# Overview

Welcome to the Optimum for Intel® Gaudi® AI Accelerator how-to guides!

These guides tackle more advanced topics and will show you how to easily get the best from HPUs.
Here's what you'll find:

- [Script adaptation](./script_adaptation): Learn how to adapt a Transformers/Diffusers script for Intel Gaudi
- [Pretraining models](./pretraining): A guide to pretraining a model using Transformers
- [Accelerating training](./accelerate_training): Discover techniques to speed up training
- [Accelerating inference](./accelerate_inference) Learn how to optimize inference for faster execution
- [Using DeepSpeed](./deepspeed): Scale your training to handle larger models
- [Multi-node training](./multi_node_training): Speed up runs with multi-node setups
- [Quantization](./quantization): Explore FP8 and UINT4 quantization for optimized inference


<EditOnGithub source="https://github.com/huggingface/optimum-habana/blob/main/docs/source/usage_guides/overview.mdx" />