import{s as hc,o as _c,n as x}from"../chunks/scheduler.85c25b89.js";import{S as bc,i as yc,g as i,s as o,r as m,A as Mc,h as p,f as a,c as r,j as w,u,x as y,k as T,y as n,a as d,v as g,d as f,t as h,w as _}from"../chunks/index.c9bcf812.js";import{T as vc}from"../chunks/Tip.d8f753fa.js";import{D as $}from"../chunks/Docstring.b39cf13b.js";import{C as I}from"../chunks/CodeBlock.c004bd26.js";import{E as F}from"../chunks/ExampleCodeBlock.5a312203.js";import{H as k}from"../chunks/getInferenceSnippets.f73e27a5.js";function Nc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckZlYXR1cmVFeHRyYWN0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjItbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyLW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkRlYXIlMjBFdmFuJTIwSGFuc2VuJTIwaXMlMjB0aGUlMjB3aW5uZXIlMjBvZiUyMHNpeCUyMFRvbnklMjBBd2FyZHMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Dear Evan Hansen is the winner of six Tony Awards.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">13</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function wc(j){let l,N="Text Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlbnRlbmNlVHJhbnNmb3JtZXJzJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJnZS1iYXNlLWVuLXYxLjUtbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VudGVuY2VUcmFuc2Zvcm1lcnMuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZ2UtYmFzZS1lbi12MS41LW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkluJTIwdGhlJTIwc21vdWxkZXJpbmclMjBwcm9taXNlJTIwb2YlMjB0aGUlMjBmYWxsJTIwb2YlMjBUcm95JTJDJTIwYSUyMG15dGhpY2FsJTIwd29ybGQlMjBvZiUyMGdvZHMlMjBhbmQlMjBtb3J0YWxzJTIwcmlzZXMlMjBmcm9tJTIwdGhlJTIwYXNoZXMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBdG9rZW5fZW1iZWRkaW5ncyUyMCUzRCUyMG91dHB1dHMudG9rZW5fZW1iZWRkaW5ncyUwQXNlbnRlbmNlX2VtYmVkZGluZyUyMCUzRCUyMCUzRCUyMG91dHB1dHMuc2VudGVuY2VfZW1iZWRkaW5n",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bge-base-en-v1.5-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSentenceTransformers.from_pretrained(<span class="hljs-string">&quot;optimum/bge-base-en-v1.5-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;In the smouldering promise of the fall of Troy, a mythical world of gods and mortals rises from the ashes.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>token_embeddings = outputs.token_embeddings
<span class="hljs-meta">&gt;&gt;&gt; </span>sentence_embedding = = outputs.sentence_embedding`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-1vtqn41"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Tc(j){let l,N="Image Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwdXRpbCUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvbk1vZGVsRm9yU2VudGVuY2VUcmFuc2Zvcm1lcnMlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGY2xpcF92aXRfZW1iX25ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlbnRlbmNlVHJhbnNmb3JtZXJzLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGY2xpcF92aXRfZW1iX25ldXJvbnglMjIpJTBBdXRpbC5odHRwX2dldCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZVS1BMYWIlMkZzZW50ZW5jZS10cmFuc2Zvcm1lcnMlMkZyYXclMkZtYXN0ZXIlMkZleGFtcGxlcyUyRnNlbnRlbmNlX3RyYW5zZm9ybWVyJTJGYXBwbGljYXRpb25zJTJGaW1hZ2Utc2VhcmNoJTJGdHdvX2RvZ3NfaW5fc25vdy5qcGclMjIlMkMlMjAlMjJ0d29fZG9nc19pbl9zbm93LmpwZyUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMlR3byUyMGRvZ3MlMjBpbiUyMHRoZSUyMHNub3clMjIlMkMlMjAnQSUyMGNhdCUyMG9uJTIwYSUyMHRhYmxlJyUyQyUyMCdBJTIwcGljdHVyZSUyMG9mJTIwTG9uZG9uJTIwYXQlMjBuaWdodCclNUQlMkMlMjBpbWFnZXMlM0RJbWFnZS5vcGVuKCUyMnR3b19kb2dzX2luX3Nub3cuanBnJTIyKSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUwQSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBY29zX3Njb3JlcyUyMCUzRCUyMHV0aWwuY29zX3NpbShvdXRwdXRzLmltYWdlX2VtYmVkcyUyQyUyMG91dHB1dHMudGV4dF9lbWJlZHMpJTIwJTIwJTIzJTIwQ29tcHV0ZSUyMGNvc2luZSUyMHNpbWlsYXJpdGllcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> util
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/clip_vit_emb_neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSentenceTransformers.from_pretrained(<span class="hljs-string">&quot;optimum/clip_vit_emb_neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>util.http_get(<span class="hljs-string">&quot;https://github.com/UKPLab/sentence-transformers/raw/master/examples/sentence_transformer/applications/image-search/two_dogs_in_snow.jpg&quot;</span>, <span class="hljs-string">&quot;two_dogs_in_snow.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">&gt;&gt;&gt; </span>    text=[<span class="hljs-string">&quot;Two dogs in the snow&quot;</span>, <span class="hljs-string">&#x27;A cat on a table&#x27;</span>, <span class="hljs-string">&#x27;A picture of London at night&#x27;</span>], images=Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;two_dogs_in_snow.jpg&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>cos_scores = util.cos_sim(outputs.image_embeds, outputs.text_embeds)  <span class="hljs-comment"># Compute cosine similarities</span>`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-l4l8dd"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function $c(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvck1hc2tlZExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmxlZ2FsLWJlcnQtYmFzZS11bmNhc2VkLW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGbGVnYWwtYmVydC1iYXNlLXVuY2FzZWQtbmV1cm9ueCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMCU1Qk1BU0slNUQlMjBBZ3JlZW1lbnQlMjBpcyUyMGJldHdlZW4lMjBHZW5lcmFsJTIwTW90b3JzJTIwYW5kJTIwSm9obiUyME11cnJheS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/legal-bert-base-uncased-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/legal-bert-base-uncased-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;This [MASK] Agreement is between General Motors and John Murray.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">13</span>, <span class="hljs-number">30522</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function jc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gtbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoLW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhhbWlsdG9uJTIwaXMlMjBjb25zaWRlcmVkJTIwdG8lMjBiZSUyMHRoZSUyMGJlc3QlMjBtdXNpY2FsJTIwb2YlMjBodW1hbiUyMGhpc3RvcnkuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hamilton is considered to be the best musical of human history.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function kc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvbk1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGcm9iZXJ0YS1iYXNlLXNxdWFkMi1uZXVyb254JTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDItbmV1cm9ueCUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJBcmUlMjB0aGVyZSUyMHdoZWVsY2hhaXIlMjBzcGFjZXMlMjBpbiUyMHRoZSUyMHRoZWF0cmVzJTNGJTIyJTJDJTIwJTIyWWVzJTJDJTIwd2UlMjBoYXZlJTIwcmVzZXJ2ZWQlMjB3aGVlbGNoYWlyJTIwc3BhY2VzJTIwd2l0aCUyMGElMjBnb29kJTIwdmlldy4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjEyJTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHN0YXJ0X3Bvc2l0aW9ucyUyQyUyMGVuZF9wb3NpdGlvbnMlM0RlbmRfcG9zaXRpb25zKSUwQXN0YXJ0X3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuc3RhcnRfbG9naXRzJTBBZW5kX3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuZW5kX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Are there wheelchair spaces in the theatres?&quot;</span>, <span class="hljs-string">&quot;Yes, we have reserved wheelchair spaces with a good view.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">12</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Cc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGYmVydC1iYXNlLU5FUi1uZXVyb254JTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGYmVydC1iYXNlLU5FUi1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJMaW4tTWFudWVsJTIwTWlyYW5kYSUyMGlzJTIwYW4lMjBBbWVyaWNhbiUyMHNvbmd3cml0ZXIlMkMlMjBhY3RvciUyQyUyMHNpbmdlciUyQyUyMGZpbG1tYWtlciUyQyUyMGFuZCUyMHBsYXl3cmlnaHQuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Lin-Manuel Miranda is an American songwriter, actor, singer, filmmaker, and playwright.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">20</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Jc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkX1NXQUctbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHLW5ldXJvbnglMjIpJTBBJTBBbnVtX2Nob2ljZXMlMjAlM0QlMjA0JTBBZmlyc3Rfc2VudGVuY2UlMjAlM0QlMjAlNUIlMjJNZW1iZXJzJTIwb2YlMjB0aGUlMjBwcm9jZXNzaW9uJTIwd2FsayUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBob2xkaW5nJTIwc21hbGwlMjBob3JuJTIwYnJhc3MlMjBpbnN0cnVtZW50cy4lMjIlNUQlMjAqJTIwbnVtX2Nob2ljZXMlMEFzZWNvbmRfc2VudGVuY2UlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBwYXNzZXMlMjBieSUyMHdhbGtpbmclMjBkb3duJTIwdGhlJTIwc3RyZWV0JTIwcGxheWluZyUyMHRoZWlyJTIwaW5zdHJ1bWVudHMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGRydW0lMjBsaW5lJTIwaGFzJTIwaGVhcmQlMjBhcHByb2FjaGluZyUyMHRoZW0uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGRydW0lMjBsaW5lJTIwYXJyaXZlcyUyMGFuZCUyMHRoZXkncmUlMjBvdXRzaWRlJTIwZGFuY2luZyUyMGFuZCUyMGFzbGVlcC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjB0dXJucyUyMHRoZSUyMGxlYWQlMjBzaW5nZXIlMjB3YXRjaGVzJTIwdGhlJTIwcGVyZm9ybWFuY2UuJTIyJTBBJTVEJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGZpcnN0X3NlbnRlbmNlJTJDJTIwc2Vjb25kX3NlbnRlbmNlJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlNUJrJTVEJTIwJTNEJTIwJTVCdiU1QmklM0ElMjBpJTIwJTJCJTIwbnVtX2Nob2ljZXMlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHYpJTJDJTIwbnVtX2Nob2ljZXMpJTVEJTBBaW5wdXRzJTIwJTNEJTIwZGljdChpbnB1dHMuY29udmVydF90b190ZW5zb3JzKHRlbnNvcl90eXBlJTNEJTIycHQlMjIpKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxvZ2l0cy5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased_SWAG-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased_SWAG-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape
[<span class="hljs-number">1</span>, <span class="hljs-number">4</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function xc(j){let l,N=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=i("p"),l.innerHTML=N},l(b){l=p(b,"P",{"data-svelte-h":!0}),y(l)!=="svelte-fincs2"&&(l.innerHTML=N)},m(b,c){d(b,l,c)},p:x,d(b){b&&a(l)}}}function Uc(j){let l,N="Example of text-to-text generation:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTSUwQSUyMyUyMGV4cG9ydCUwQW5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChnb29nbGUtdDUlMkZ0NS1zbWFsbCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjBkeW5hbWljX2JhdGNoX3NpemUlM0RGYWxzZSUyQyUyMGJhdGNoX3NpemUlM0QxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTNENjQlMkMlMjBudW1fYmVhbXMlM0Q0KSUwQW5ldXJvbl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIydDVfc21hbGxfbmV1cm9ueCUyMiklMEFkZWwlMjBuZXVyb25fbW9kZWwlMEElMEElMjMlMjBpbmZlcmVuY2UlMEFuZXVyb25fbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIydDVfc21hbGxfbmV1cm9ueCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0NV9zbWFsbF9uZXVyb254JTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJ0cmFuc2xhdGUlMjBFbmdsaXNoJTIwdG8lMjBHZXJtYW4lM0ElMjBMZXRzJTIwZWF0JTIwZ29vZCUyMGZvb2QuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBuZXVyb25fbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDElMkMlMEEpJTBBcmVzdWx0cyUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUodCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUyMGZvciUyMHQlMjBpbiUyMG91dHB1dCU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSeq2SeqLM
<span class="hljs-comment"># export</span>
neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(google-t5/t5-small, export=<span class="hljs-literal">True</span>, dynamic_batch_size=<span class="hljs-literal">False</span>, batch_size=<span class="hljs-number">1</span>, sequence_length=<span class="hljs-number">64</span>, num_beams=<span class="hljs-number">4</span>)
neuron_model.save_pretrained(<span class="hljs-string">&quot;t5_small_neuronx&quot;</span>)
<span class="hljs-keyword">del</span> neuron_model

<span class="hljs-comment"># inference</span>
neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5_small_neuronx&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5_small_neuronx&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;translate English to German: Lets eat good food.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

output = neuron_model.generate(
    **inputs,
    num_return_sequences=<span class="hljs-number">1</span>,
)
results = [tokenizer.decode(t, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> output]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-hhyk5s"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Fc(j){let l,N="Example of text-to-text generation with tensor parallelism:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTSUwQSUyMyUyMGV4cG9ydCUwQWlmJTIwX19uYW1lX18lMjAlM0QlM0QlMjAlMjJfX21haW5fXyUyMiUzQSUyMCUyMCUyMyUyMGNvbXB1bHNvcnklMjBmb3IlMjBwYXJhbGxlbCUyMHRyYWNpbmclMjBzaW5jZSUyMHRoZSUyMEFQSSUyMHdpbGwlMjBzcGF3biUyMG11bHRpcGxlJTIwcHJvY2Vzc2VzLiUwQSUyMCUyMCUyMCUyMG5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnb29nbGUlMkZmbGFuLXQ1LXhsJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEOCUyQyUyMGR5bmFtaWNfYmF0Y2hfc2l6ZSUzREZhbHNlJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBzZXF1ZW5jZV9sZW5ndGglM0QxMjglMkMlMjBudW1fYmVhbXMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMG5ldXJvbl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyZmxhbl90NV94bF9uZXVyb254X3RwOCUyMiklMEElMjAlMjAlMjAlMjBkZWwlMjBuZXVyb25fbW9kZWwlMEElMjMlMjBpbmZlcmVuY2UlMEFuZXVyb25fbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmxhbl90NV94bF9uZXVyb254X3RwOCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmbGFuX3Q1X3hsX25ldXJvbnhfdHA4JTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJ0cmFuc2xhdGUlMjBFbmdsaXNoJTIwdG8lMjBHZXJtYW4lM0ElMjBMZXRzJTIwZWF0JTIwZ29vZCUyMGZvb2QuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBuZXVyb25fbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDElMkMlMEEpJTBBcmVzdWx0cyUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUodCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUyMGZvciUyMHQlMjBpbiUyMG91dHB1dCU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSeq2SeqLM
<span class="hljs-comment"># export</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:  <span class="hljs-comment"># compulsory for parallel tracing since the API will spawn multiple processes.</span>
    neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(
        google/flan-t5-xl, export=<span class="hljs-literal">True</span>, tensor_parallel_size=<span class="hljs-number">8</span>, dynamic_batch_size=<span class="hljs-literal">False</span>, batch_size=<span class="hljs-number">1</span>, sequence_length=<span class="hljs-number">128</span>, num_beams=<span class="hljs-number">4</span>,
    )
    neuron_model.save_pretrained(<span class="hljs-string">&quot;flan_t5_xl_neuronx_tp8&quot;</span>)
    <span class="hljs-keyword">del</span> neuron_model
<span class="hljs-comment"># inference</span>
neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;flan_t5_xl_neuronx_tp8&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;flan_t5_xl_neuronx_tp8&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;translate English to German: Lets eat good food.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

output = neuron_model.generate(
    **inputs,
    num_return_sequences=<span class="hljs-number">1</span>,
)
results = [tokenizer.decode(t, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> output]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-onp91"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Ic(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ltYWdlUHJvY2Vzc29yJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByZXByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Zc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkZWVwbGFidjMtbW9iaWxldml0LXNtYWxsLW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGVlcGxhYnYzLW1vYmlsZXZpdC1zbWFsbC1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByZXByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/deeplabv3-mobilevit-small-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/deeplabv3-mobilevit-small-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Xc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnlvbG9zLXRpbnklMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBdGFyZ2V0X3NpemVzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QmltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCU1RCklMEFyZXN1bHRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19vYmplY3RfZGV0ZWN0aW9uKG91dHB1dHMlMkMlMjB0aHJlc2hvbGQlM0QwLjklMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Sc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvcihkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9jbGFzc19pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpLml0ZW0oKSUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHMlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-audio-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-audio-classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Vc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QtbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME5ldXJvbk1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZC1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sd-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  NeuronModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sd-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Rc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckNUQyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtY3RjJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtY3RjJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBcHJlZGljdGVkX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkaWN0ZWRfaWRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForCTC.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Wc(j){let l,N="Example using <code>optimum.neuron.pipeline</code>:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckNUQyUyQyUyMHBpcGVsaW5lJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGd2F2MnZlYzItbGFyZ2UtOTYwaC1sdjYwLXNlbGYtbmV1cm9ueC1jdGMlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtY3RjJTIyKSUwQWFzciUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwZmVhdHVyZV9leHRyYWN0b3IlM0Rwcm9jZXNzb3IuZmVhdHVyZV9leHRyYWN0b3IlMkMlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IudG9rZW5pemVyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCTC, pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForCTC.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>asr = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, feature_extractor=processor.feature_extractor, tokenizer=processor.tokenizer)`,wrap:!1}}),{c(){l=i("p"),l.innerHTML=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-ch7hyj"&&(l.innerHTML=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function zc(j){let l,N="Example:",b,c,M;return c=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclhWZWN0b3IlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLXN2LW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclhWZWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLXN2LW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoJTBBJTIwJTIwJTIwJTIwJTVCZCU1QiUyMmFycmF5JTIyJTVEJTIwZm9yJTIwZCUyMGluJTIwZGF0YXNldCU1QiUzQTIlNUQlNUIlMjJhdWRpbyUyMiU1RCU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlJTBBKSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sv-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForXVector.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sv-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,b=o(),m(c.$$.fragment)},l(t){l=p(t,"P",{"data-svelte-h":!0}),y(l)!=="svelte-11lpom8"&&(l.textContent=N),b=r(t),u(c.$$.fragment,t)},m(t,v){d(t,l,v),d(t,b,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(b)),_(c,t)}}}function Lc(j){let l,N,b,c,M,t,v,qr,_t,Hr,bt,Zi=`The <code>NeuronTracedModel</code> class is available for instantiating a base Neuron model without a specific head.
It is used as the base class for all tasks but text generation.`,Yr,C,yt,hs,lo,Xi="Base class running compiled and optimized models on Neuron devices.",_s,io,Si=`It implements generic methods for interacting with the Hugging Face Hub as well as compiling vanilla
transformers models to neuron-optimized TorchScript module and export it using <code>optimum.exporters.neuron</code> toolchain.`,bs,po,Vi="Class attributes:",ys,co,Ri=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;neuron_model&quot;</code>) — The name of the model type to use when
registering the NeuronTracedModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The <code>AutoModel</code> class to be represented by the
current NeuronTracedModel class.</li>`,Ms,mo,Wi="Common attributes:",vs,uo,zi=`<li>model (<code>torch.jit._script.ScriptModule</code>) — The loaded <code>ScriptModule</code> compiled for neuron devices.</li> <li>config (<a href="https://huggingface.co/docs/transformers/v4.53.0/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a>) — The configuration of the model.</li> <li>model_save_dir (<code>Path</code>) — The directory where a neuron compiled model is saved.
By default, if the loaded model is local, the directory where the original model will be used. Otherwise, the
cache directory will be used.</li>`,Ns,Pe,Mt,ws,go,Li="Returns whether this model can generate sequences with <code>.generate()</code>.",Ts,Ge,vt,$s,fo,Bi="Gets a dictionary of inputs with their valid static shapes.",js,Ee,Nt,ks,ho,Pi=`Loads a TorchScript module compiled by neuron(x)-cc compiler. It will be first loaded onto CPU and then moved to
one or multiple <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/arch/neuron-hardware/neuroncores-arch.html" rel="nofollow">NeuronCore</a>.`,Cs,De,wt,Js,_o,Gi="Removes padding from output tensors.",Qr,Tt,Ar,$t,Ei="The following Neuron model classes are available for natural language processing tasks.",Or,jt,Kr,Z,kt,xs,bo,Di="Neuron Model with a BaseModelOutput for feature-extraction tasks.",Us,yo,qi=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Fs,Mo,Hi="Feature Extraction model on Neuron devices.",Is,le,Ct,Zs,vo,Yi="The <code>NeuronModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Xs,qe,ea,Jt,ta,X,xt,Ss,No,Qi="Neuron Model for Sentence Transformers.",Vs,wo,Ai=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Rs,To,Oi="Sentence Transformers model on Neuron devices.",Ws,re,Ut,zs,$o,Ki="The <code>NeuronModelForSentenceTransformers</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Ls,He,Bs,Ye,na,Ft,oa,S,It,Ps,jo,ep="Neuron Model with a MaskedLMOutput for masked language modeling tasks.",Gs,ko,tp=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Es,Co,np="Masked language model for on Neuron devices.",Ds,ie,Zt,qs,Jo,op="The <code>NeuronModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Hs,Qe,ra,Xt,aa,V,St,Ys,xo,rp=`Neuron Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks.`,Qs,Uo,ap=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,As,Fo,sp="Sequence Classification model on Neuron devices.",Os,pe,Vt,Ks,Io,lp="The <code>NeuronModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",el,Ae,sa,Rt,la,R,Wt,tl,Zo,ip="Neuron Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD.",nl,Xo,pp=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,ol,So,cp="Question Answering model on Neuron devices.",rl,ce,zt,al,Vo,dp="The <code>NeuronModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",sl,Oe,ia,Lt,pa,W,Bt,ll,Ro,mp=`Neuron Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks.`,il,Wo,up=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,pl,zo,gp="Token Classification model on Neuron devices.",cl,de,Pt,dl,Lo,fp="The <code>NeuronModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",ml,Ke,ca,Gt,da,z,Et,ul,Bo,hp=`Neuron Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks.`,gl,Po,_p=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,fl,Go,bp="Multiple choice model on Neuron devices.",hl,me,Dt,_l,Eo,yp="The <code>NeuronModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",bl,et,ma,qt,ua,Y,Ht,yl,Do,Mp="Neuron model with a causal language modeling head for inference on Neuron devices.",Ml,qo,vp=`This model inherits from <code>~neuron.NeuronModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,vl,tt,Yt,Nl,Ho,Np="Forward pass of the model, needs to be overwritten.",ga,Qt,fa,Q,At,wl,Yo,wp="Neuron Sequence-to-sequence model with a language modeling head for text2text-generation tasks.",Tl,Qo,Tp=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,$l,U,Ot,jl,Ao,$p='The <a href="/docs/optimum.neuron/v0.2.2/en/package_reference/modeling#optimum.neuron.NeuronModelForSeq2SeqLM">NeuronModelForSeq2SeqLM</a> forward method, overrides the <code>__call__</code> special method.',kl,nt,Cl,Oo,jp="<em>(Following models are compiled with neuronx compiler and can only be run on INF2.)</em>",Jl,ot,xl,Ko,kp="<em>(For large models, in order to fit into Neuron cores, we need to apply tensor parallelism. Here below is an example ran on <code>inf2.24xlarge</code>.)</em>",Ul,rt,ha,Kt,_a,en,Cp="The following Neuron model classes are available for computer vision tasks.",ba,tn,ya,L,nn,Fl,er,Jp="Neuron Model with an image classification head on top (a linear layer on top of the final hidden state of the [CLS] token) e.g. for ImageNet.",Il,tr,xp=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Zl,nr,Up="Neuron Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, deit, levit, mobilenet_v2, mobilevit, vit, etc.",Xl,ue,on,Sl,or,Fp="The <code>NeuronModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Vl,at,Ma,rn,va,B,an,Rl,rr,Ip="Neuron Model with a semantic segmentation head on top, e.g. for Pascal VOC.",Wl,ar,Zp=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,zl,sr,Xp="Neuron Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports mobilevit, mobilenet-v2, etc.",Ll,ge,sn,Bl,lr,Sp="The <code>NeuronModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Pl,st,Na,ln,wa,P,pn,Gl,ir,Vp="Neuron Model with object detection heads on top, for tasks such as COCO detection.",El,pr,Rp=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Dl,cr,Wp="Neuron Model for object-detection, with object detection heads on top, for tasks such as COCO detection.",ql,fe,cn,Hl,dr,zp="The <code>NeuronModelForObjectDetection</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Yl,lt,Ta,dn,$a,mn,Lp="The following auto classes are available for the following audio tasks.",ja,un,ka,G,gn,Ql,mr,Bp="Neuron Model with an audio classification head.",Al,ur,Pp=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Ol,gr,Gp=`Neuron Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting.`,Kl,he,fn,ei,fr,Ep="The <code>NeuronModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",ti,it,Ca,hn,Ja,E,_n,ni,hr,Dp="Neuron Model with an audio frame classification head.",oi,_r,qp=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,ri,br,Hp="Neuron Model with a frame classification head on top for tasks like Speaker Diarization.",ai,_e,bn,si,yr,Yp="The <code>NeuronModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",li,pt,xa,yn,Ua,D,Mn,ii,Mr,Qp="Neuron Model with a connectionist temporal classification head.",pi,vr,Ap=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,ci,Nr,Op="Neuron Model with a language modeling head on top for Connectionist Temporal Classification (CTC).",di,ae,vn,mi,wr,Kp="The <code>NeuronModelForCTC</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",ui,ct,gi,dt,Fa,Nn,Ia,q,wn,fi,Tr,ec="Neuron Model with an XVector feature extraction head on top for tasks like Speaker Verification.",hi,$r,tc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,_i,jr,nc="Neuron Model with an XVector feature extraction head on top for tasks like Speaker Verification.",bi,be,Tn,yi,kr,oc="The <code>NeuronModelForXVector</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Mi,mt,Za,$n,Xa,jn,rc="The following Neuron model classes are available for stable diffusion tasks.",Sa,kn,Va,ke,Cn,vi,Cr,Jn,Ra,xn,Wa,Ce,Un,Ni,Jr,Fn,za,In,La,Je,Zn,wi,xr,Xn,Ba,Sn,Pa,xe,Vn,Ti,Ur,Rn,Ga,Wn,Ea,Ue,zn,$i,ut,Ln,ji,Fr,ac="The call function to the pipeline for generation.",Da,Bn,qa,Fe,Pn,ki,Ir,Gn,Ha,En,Ya,Ie,Dn,Ci,Zr,qn,Qa,Hn,Aa,Ze,Yn,Ji,Xr,Qn,Oa,An,Ka,Xe,On,xi,Sr,Kn,es,eo,ts,Se,to,Ui,ye,no,Fi,Vr,sc="The call function to the pipeline for generation.",Ii,Rr,lc="Examples:",ns,Dr,os;return M=new k({props:{title:"Models",local:"models",headingTag:"h1"}}),v=new k({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),_t=new k({props:{title:"NeuronTracedModel",local:"optimum.neuron.NeuronTracedModel",headingTag:"h3"}}),yt=new $({props:{name:"class optimum.neuron.NeuronTracedModel",anchor:"optimum.neuron.NeuronTracedModel",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_traced.py#L67"}}),Mt=new $({props:{name:"can_generate",anchor:"optimum.neuron.NeuronTracedModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_traced.py#L632"}}),vt=new $({props:{name:"get_input_static_shapes",anchor:"optimum.neuron.NeuronTracedModel.get_input_static_shapes",parameters:[{name:"neuron_config",val:": NeuronDefaultConfig"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_traced.py#L487"}}),Nt=new $({props:{name:"load_model",anchor:"optimum.neuron.NeuronTracedModel.load_model",parameters:[{name:"path",val:": typing.Union[str, pathlib.Path]"},{name:"to_neuron",val:": bool = False"},{name:"device_id",val:": int = 0"}],parametersDescription:[{anchor:"optimum.neuron.NeuronTracedModel.load_model.path",description:`<strong>path</strong> (<code>Union[str, Path]</code>) &#x2014;
Path of the compiled model.`,name:"path"},{anchor:"optimum.neuron.NeuronTracedModel.load_model.to_neuron",description:`<strong>to_neuron</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to move manually the traced model to NeuronCore. It&#x2019;s only needed when <code>inline_weights_to_neff=False</code>, otherwise it is loaded automatically to a Neuron device.`,name:"to_neuron"},{anchor:"optimum.neuron.NeuronTracedModel.load_model.device_id",description:`<strong>device_id</strong> (<code>int</code>, defaults to 0) &#x2014;
Index of NeuronCore to load the traced model to.`,name:"device_id"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_traced.py#L111"}}),wt=new $({props:{name:"remove_padding",anchor:"optimum.neuron.NeuronTracedModel.remove_padding",parameters:[{name:"outputs",val:": typing.List[torch.Tensor]"},{name:"dims",val:": typing.List[int]"},{name:"indices",val:": typing.List[int]"},{name:"padding_side",val:": typing.Literal['right', 'left'] = 'right'"}],parametersDescription:[{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.outputs",description:`<strong>outputs</strong> (<code>List[torch.Tensor]</code>) &#x2014;
List of torch tensors which are inference output.`,name:"outputs"},{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.dims",description:`<strong>dims</strong> (<code>List[int]</code>) &#x2014;
List of dimensions in which we slice a tensor.`,name:"dims"},{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.indices",description:`<strong>indices</strong> (<code>List[int]</code>) &#x2014;
List of indices in which we slice a tensor along an axis.`,name:"indices"},{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.padding_side",description:`<strong>padding_side</strong> (<code>Literal[&quot;right&quot;, &quot;left&quot;]</code>, defaults to &#x201C;right&#x201D;) &#x2014;
The side on which the padding has been applied.`,name:"padding_side"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_traced.py#L584"}}),Tt=new k({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),jt=new k({props:{title:"NeuronModelForFeatureExtraction",local:"optimum.neuron.NeuronModelForFeatureExtraction",headingTag:"h3"}}),kt=new $({props:{name:"class optimum.neuron.NeuronModelForFeatureExtraction",anchor:"optimum.neuron.NeuronModelForFeatureExtraction",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L86"}}),Ct=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L99"}}),qe=new F({props:{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.example",$$slots:{default:[Nc]},$$scope:{ctx:j}}}),Jt=new k({props:{title:"NeuronModelForSentenceTransformers",local:"optimum.neuron.NeuronModelForSentenceTransformers",headingTag:"h3"}}),xt=new $({props:{name:"class optimum.neuron.NeuronModelForSentenceTransformers",anchor:"optimum.neuron.NeuronModelForSentenceTransformers",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L138"}}),Ut=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L152"}}),He=new F({props:{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.example",$$slots:{default:[wc]},$$scope:{ctx:j}}}),Ye=new F({props:{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.example-2",$$slots:{default:[Tc]},$$scope:{ctx:j}}}),Ft=new k({props:{title:"NeuronModelForMaskedLM",local:"optimum.neuron.NeuronModelForMaskedLM",headingTag:"h3"}}),It=new $({props:{name:"class optimum.neuron.NeuronModelForMaskedLM",anchor:"optimum.neuron.NeuronModelForMaskedLM",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMaskedLM.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForMaskedLM.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L204"}}),Zt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L217"}}),Qe=new F({props:{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.example",$$slots:{default:[$c]},$$scope:{ctx:j}}}),Xt=new k({props:{title:"NeuronModelForSequenceClassification",local:"optimum.neuron.NeuronModelForSequenceClassification",headingTag:"h3"}}),St=new $({props:{name:"class optimum.neuron.NeuronModelForSequenceClassification",anchor:"optimum.neuron.NeuronModelForSequenceClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSequenceClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForSequenceClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L297"}}),Vt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L311"}}),Ae=new F({props:{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.example",$$slots:{default:[jc]},$$scope:{ctx:j}}}),Rt=new k({props:{title:"NeuronModelForQuestionAnswering",local:"optimum.neuron.NeuronModelForQuestionAnswering",headingTag:"h3"}}),Wt=new $({props:{name:"class optimum.neuron.NeuronModelForQuestionAnswering",anchor:"optimum.neuron.NeuronModelForQuestionAnswering",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L250"}}),zt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L263"}}),Oe=new F({props:{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.example",$$slots:{default:[kc]},$$scope:{ctx:j}}}),Lt=new k({props:{title:"NeuronModelForTokenClassification",local:"optimum.neuron.NeuronModelForTokenClassification",headingTag:"h3"}}),Bt=new $({props:{name:"class optimum.neuron.NeuronModelForTokenClassification",anchor:"optimum.neuron.NeuronModelForTokenClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForTokenClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForTokenClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L344"}}),Pt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L358"}}),Ke=new F({props:{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.example",$$slots:{default:[Cc]},$$scope:{ctx:j}}}),Gt=new k({props:{title:"NeuronModelForMultipleChoice",local:"optimum.neuron.NeuronModelForMultipleChoice",headingTag:"h3"}}),Et=new $({props:{name:"class optimum.neuron.NeuronModelForMultipleChoice",anchor:"optimum.neuron.NeuronModelForMultipleChoice",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMultipleChoice.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForMultipleChoice.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L392"}}),Dt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L406"}}),et=new F({props:{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.example",$$slots:{default:[Jc]},$$scope:{ctx:j}}}),qt=new k({props:{title:"NeuronModelForCausalLM",local:"optimum.neuron.NeuronModelForCausalLM",headingTag:"h3"}}),Ht=new $({props:{name:"class optimum.neuron.NeuronModelForCausalLM",anchor:"optimum.neuron.NeuronModelForCausalLM",parameters:[{name:"model",val:": PreTrainedModel"},{name:"config",val:": PretrainedConfig"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_decoder.py#L100"}}),Yt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForCausalLM.forward",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/modeling_base.py#L100"}}),Qt=new k({props:{title:"NeuronModelForSeq2SeqLM",local:"optimum.neuron.NeuronModelForSeq2SeqLM",headingTag:"h3"}}),At=new $({props:{name:"class optimum.neuron.NeuronModelForSeq2SeqLM",anchor:"optimum.neuron.NeuronModelForSeq2SeqLM",parameters:[{name:"encoder",val:": ScriptModule"},{name:"decoder",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"encoder_file_name",val:": typing.Optional[str] = 'model.neuron'"},{name:"decoder_file_name",val:": typing.Optional[str] = 'model.neuron'"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_configs",val:": typing.Optional[typing.Dict[str, ForwardRef('NeuronDefaultConfig')]] = None"},{name:"configs",val:": typing.Optional[typing.Dict[str, ForwardRef('PretrainedConfig')]] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.encoder",description:'<strong>encoder</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module of the encoder with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"encoder"},{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.decoder",description:'<strong>decoder</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module of the decoder with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"decoder"},{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_seq2seq.py#L435"}}),Ot=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward",parameters:[{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"beam_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"return_dict",val:": bool = False"},{name:"output_attentions",val:": bool = False"},{name:"output_hidden_states",val:": bool = False"}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_seq2seq.py#L445"}}),nt=new vc({props:{$$slots:{default:[xc]},$$scope:{ctx:j}}}),ot=new F({props:{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.example",$$slots:{default:[Uc]},$$scope:{ctx:j}}}),rt=new F({props:{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.example-2",$$slots:{default:[Fc]},$$scope:{ctx:j}}}),Kt=new k({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),tn=new k({props:{title:"NeuronModelForImageClassification",local:"optimum.neuron.NeuronModelForImageClassification",headingTag:"h3"}}),nn=new $({props:{name:"class optimum.neuron.NeuronModelForImageClassification",anchor:"optimum.neuron.NeuronModelForImageClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForImageClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForImageClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L440"}}),on=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoImageProcessor" rel="nofollow"><code>AutoImageProcessor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L460"}}),at=new F({props:{anchor:"optimum.neuron.NeuronModelForImageClassification.forward.example",$$slots:{default:[Ic]},$$scope:{ctx:j}}}),rn=new k({props:{title:"NeuronModelForSemanticSegmentation",local:"optimum.neuron.NeuronModelForSemanticSegmentation",headingTag:"h3"}}),an=new $({props:{name:"class optimum.neuron.NeuronModelForSemanticSegmentation",anchor:"optimum.neuron.NeuronModelForSemanticSegmentation",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L487"}}),sn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoImageProcessor" rel="nofollow"><code>AutoImageProcessor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L507"}}),st=new F({props:{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.forward.example",$$slots:{default:[Zc]},$$scope:{ctx:j}}}),ln=new k({props:{title:"NeuronModelForObjectDetection",local:"optimum.neuron.NeuronModelForObjectDetection",headingTag:"h3"}}),pn=new $({props:{name:"class optimum.neuron.NeuronModelForObjectDetection",anchor:"optimum.neuron.NeuronModelForObjectDetection",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForObjectDetection.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForObjectDetection.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L534"}}),cn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForObjectDetection.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoImageProcessor" rel="nofollow"><code>AutoImageProcessor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L554"}}),lt=new F({props:{anchor:"optimum.neuron.NeuronModelForObjectDetection.forward.example",$$slots:{default:[Xc]},$$scope:{ctx:j}}}),dn=new k({props:{title:"Audio",local:"audio",headingTag:"h2"}}),un=new k({props:{title:"NeuronModelForAudioClassification",local:"optimum.neuron.NeuronModelForAudioClassification",headingTag:"h3"}}),gn=new $({props:{name:"class optimum.neuron.NeuronModelForAudioClassification",anchor:"optimum.neuron.NeuronModelForAudioClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForAudioClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L583"}}),fn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForAudioClassification.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L597"}}),it=new F({props:{anchor:"optimum.neuron.NeuronModelForAudioClassification.forward.example",$$slots:{default:[Sc]},$$scope:{ctx:j}}}),hn=new k({props:{title:"NeuronModelForAudioFrameClassification",local:"optimum.neuron.NeuronModelForAudioFrameClassification",headingTag:"h3"}}),_n=new $({props:{name:"class optimum.neuron.NeuronModelForAudioFrameClassification",anchor:"optimum.neuron.NeuronModelForAudioFrameClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L624"}}),bn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L637"}}),pt=new F({props:{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.forward.example",$$slots:{default:[Vc]},$$scope:{ctx:j}}}),yn=new k({props:{title:"NeuronModelForCTC",local:"optimum.neuron.NeuronModelForCTC",headingTag:"h3"}}),Mn=new $({props:{name:"class optimum.neuron.NeuronModelForCTC",anchor:"optimum.neuron.NeuronModelForCTC",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForCTC.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForCTC.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L664"}}),vn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForCTC.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L678"}}),ct=new F({props:{anchor:"optimum.neuron.NeuronModelForCTC.forward.example",$$slots:{default:[Rc]},$$scope:{ctx:j}}}),dt=new F({props:{anchor:"optimum.neuron.NeuronModelForCTC.forward.example-2",$$slots:{default:[Wc]},$$scope:{ctx:j}}}),Nn=new k({props:{title:"NeuronModelForXVector",local:"optimum.neuron.NeuronModelForXVector",headingTag:"h3"}}),wn=new $({props:{name:"class optimum.neuron.NeuronModelForXVector",anchor:"optimum.neuron.NeuronModelForXVector",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForXVector.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForXVector.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L705"}}),Tn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForXVector.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling.py#L718"}}),mt=new F({props:{anchor:"optimum.neuron.NeuronModelForXVector.forward.example",$$slots:{default:[zc]},$$scope:{ctx:j}}}),$n=new k({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),kn=new k({props:{title:"NeuronStableDiffusionPipeline",local:"optimum.neuron.NeuronStableDiffusionPipeline",headingTag:"h3"}}),Cn=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionPipeline",anchor:"optimum.neuron.NeuronStableDiffusionPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1558"}}),Jn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1165"}}),xn=new k({props:{title:"NeuronStableDiffusionImg2ImgPipeline",local:"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline",headingTag:"h3"}}),Un=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionImg2ImgPipeline",anchor:"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1571"}}),Fn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1165"}}),In=new k({props:{title:"NeuronStableDiffusionInpaintPipeline",local:"optimum.neuron.NeuronStableDiffusionInpaintPipeline",headingTag:"h3"}}),Zn=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionInpaintPipeline",anchor:"optimum.neuron.NeuronStableDiffusionInpaintPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1576"}}),Xn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1165"}}),Sn=new k({props:{title:"NeuronLatentConsistencyModelPipeline",local:"optimum.neuron.NeuronLatentConsistencyModelPipeline",headingTag:"h3"}}),Vn=new $({props:{name:"class optimum.neuron.NeuronLatentConsistencyModelPipeline",anchor:"optimum.neuron.NeuronLatentConsistencyModelPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1589"}}),Rn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronLatentConsistencyModelPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1165"}}),Wn=new k({props:{title:"NeuronStableDiffusionControlNetPipeline",local:"optimum.neuron.NeuronStableDiffusionControlNetPipeline",headingTag:"h3"}}),zn=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionControlNetPipeline",anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1594"}}),Ln=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>Optional[&quot;PipelineImageInput&quot;]</code>, defaults to <code>None</code>) &#x2014;
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet. When <code>prompt</code> is a list, and if a list of images is passed for a single
ControlNet, each will be paired with each prompt in the <code>prompt</code> list. This also applies to multiple
ControlNets, where a list of image lists can be passed to batch for each prompt and each ControlNet.`,name:"image"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>Optional[List[int]]</code>, defaults to <code>None</code>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>Optional[List[int]]</code>, defaults to <code>None</code>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt. If it is different from the batch size used for the compiltaion,
it will be overridden by the static batch size of neuron (except for dynamic batching).`,name:"num_images_per_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <code>diffusers.schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[Union[torch.Generator, List[torch.Generator]]]</code>, defaults to <code>None</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>Optional[PipelineImageInput]</code>, defaults to <code>None</code>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>Optional[List[torch.Tensor]]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>Union[float, List[float]]</code>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>Union[float, List[float]]</code>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>Union[float, List[float]]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Optional[Union[Callable[[int, int, Dict], None], PipelineCallback, MultiPipelineCallbacks]]</code>, defaults to <code>None</code>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, defaults to <code>[&quot;latents&quot;]</code>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/pipelines/diffusers/pipeline_controlnet.py#L33",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Bn=new k({props:{title:"NeuronPixArtAlphaPipeline",local:"optimum.neuron.NeuronPixArtAlphaPipeline",headingTag:"h3"}}),Pn=new $({props:{name:"class optimum.neuron.NeuronPixArtAlphaPipeline",anchor:"optimum.neuron.NeuronPixArtAlphaPipeline",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1601"}}),Gn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronPixArtAlphaPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1165"}}),En=new k({props:{title:"NeuronStableDiffusionXLPipeline",local:"optimum.neuron.NeuronStableDiffusionXLPipeline",headingTag:"h3"}}),Dn=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1619"}}),qn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1165"}}),Hn=new k({props:{title:"NeuronStableDiffusionXLImg2ImgPipeline",local:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",headingTag:"h3"}}),Yn=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1632"}}),Qn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1165"}}),An=new k({props:{title:"NeuronStableDiffusionXLInpaintPipeline",local:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",headingTag:"h3"}}),On=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1639"}}),Kn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1165"}}),eo=new k({props:{title:"NeuronStableDiffusionXLControlNetPipeline",local:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",headingTag:"h3"}}),to=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/modeling_diffusion.py#L1646"}}),no=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders.`,name:"prompt_2"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>Optional[&quot;PipelineImageInput&quot;]</code>, defaults to <code>None</code>) &#x2014;
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"image"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>Optional[List[int]]</code>, defaults to <code>None</code>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>Optional[List[int]]</code>, defaults to <code>None</code>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>Optional[float]</code>, defaults to <code>None</code>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. This is sent to <code>tokenizer_2</code>
and <code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <code>diffusers.schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[Union[torch.Generator, List[torch.Generator]]]</code>, defaults to <code>None</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, pooled text embeddings are generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs (prompt
weighting). If not provided, pooled <code>negative_prompt_embeds</code> are generated from <code>negative_prompt</code> input
argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>Optional[PipelineImageInput]</code>, defaults to <code>None</code>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>Optional[List[torch.Tensor]]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>Optional[str]</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>Union[float, List[float]]</code>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>Union[float, List[float]]</code>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>Union[float, List[float]]</code>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Optional[Tuple[int, int]]</code>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int, int]</code>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Optional[Tuple[int, int]]</code>, defaults to <code>None</code>) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Optional[Tuple[int, int]]</code>, defaults to <code>None</code>) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int, int]</code>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Optional[Tuple[int, int]]</code>, defaults to <code>None</code>) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Optional[Union[Callable[[int, int, Dict], None], PipelineCallback, MultiPipelineCallbacks]]</code>, defaults to <code>None</code>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, defaults to <code>[&quot;latents&quot;]</code>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.2/optimum/neuron/pipelines/diffusers/pipeline_controlnet_sd_xl.py#L37",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned containing the output images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),{c(){l=i("meta"),N=o(),b=i("p"),c=o(),m(M.$$.fragment),t=o(),m(v.$$.fragment),qr=o(),m(_t.$$.fragment),Hr=o(),bt=i("p"),bt.innerHTML=Zi,Yr=o(),C=i("div"),m(yt.$$.fragment),hs=o(),lo=i("p"),lo.textContent=Xi,_s=o(),io=i("p"),io.innerHTML=Si,bs=o(),po=i("p"),po.textContent=Vi,ys=o(),co=i("ul"),co.innerHTML=Ri,Ms=o(),mo=i("p"),mo.textContent=Wi,vs=o(),uo=i("ul"),uo.innerHTML=zi,Ns=o(),Pe=i("div"),m(Mt.$$.fragment),ws=o(),go=i("p"),go.innerHTML=Li,Ts=o(),Ge=i("div"),m(vt.$$.fragment),$s=o(),fo=i("p"),fo.textContent=Bi,js=o(),Ee=i("div"),m(Nt.$$.fragment),ks=o(),ho=i("p"),ho.innerHTML=Pi,Cs=o(),De=i("div"),m(wt.$$.fragment),Js=o(),_o=i("p"),_o.textContent=Gi,Qr=o(),m(Tt.$$.fragment),Ar=o(),$t=i("p"),$t.textContent=Ei,Or=o(),m(jt.$$.fragment),Kr=o(),Z=i("div"),m(kt.$$.fragment),xs=o(),bo=i("p"),bo.textContent=Di,Us=o(),yo=i("p"),yo.innerHTML=qi,Fs=o(),Mo=i("p"),Mo.textContent=Hi,Is=o(),le=i("div"),m(Ct.$$.fragment),Zs=o(),vo=i("p"),vo.innerHTML=Yi,Xs=o(),m(qe.$$.fragment),ea=o(),m(Jt.$$.fragment),ta=o(),X=i("div"),m(xt.$$.fragment),Ss=o(),No=i("p"),No.textContent=Qi,Vs=o(),wo=i("p"),wo.innerHTML=Ai,Rs=o(),To=i("p"),To.textContent=Oi,Ws=o(),re=i("div"),m(Ut.$$.fragment),zs=o(),$o=i("p"),$o.innerHTML=Ki,Ls=o(),m(He.$$.fragment),Bs=o(),m(Ye.$$.fragment),na=o(),m(Ft.$$.fragment),oa=o(),S=i("div"),m(It.$$.fragment),Ps=o(),jo=i("p"),jo.textContent=ep,Gs=o(),ko=i("p"),ko.innerHTML=tp,Es=o(),Co=i("p"),Co.textContent=np,Ds=o(),ie=i("div"),m(Zt.$$.fragment),qs=o(),Jo=i("p"),Jo.innerHTML=op,Hs=o(),m(Qe.$$.fragment),ra=o(),m(Xt.$$.fragment),aa=o(),V=i("div"),m(St.$$.fragment),Ys=o(),xo=i("p"),xo.textContent=rp,Qs=o(),Uo=i("p"),Uo.innerHTML=ap,As=o(),Fo=i("p"),Fo.textContent=sp,Os=o(),pe=i("div"),m(Vt.$$.fragment),Ks=o(),Io=i("p"),Io.innerHTML=lp,el=o(),m(Ae.$$.fragment),sa=o(),m(Rt.$$.fragment),la=o(),R=i("div"),m(Wt.$$.fragment),tl=o(),Zo=i("p"),Zo.textContent=ip,nl=o(),Xo=i("p"),Xo.innerHTML=pp,ol=o(),So=i("p"),So.textContent=cp,rl=o(),ce=i("div"),m(zt.$$.fragment),al=o(),Vo=i("p"),Vo.innerHTML=dp,sl=o(),m(Oe.$$.fragment),ia=o(),m(Lt.$$.fragment),pa=o(),W=i("div"),m(Bt.$$.fragment),ll=o(),Ro=i("p"),Ro.textContent=mp,il=o(),Wo=i("p"),Wo.innerHTML=up,pl=o(),zo=i("p"),zo.textContent=gp,cl=o(),de=i("div"),m(Pt.$$.fragment),dl=o(),Lo=i("p"),Lo.innerHTML=fp,ml=o(),m(Ke.$$.fragment),ca=o(),m(Gt.$$.fragment),da=o(),z=i("div"),m(Et.$$.fragment),ul=o(),Bo=i("p"),Bo.textContent=hp,gl=o(),Po=i("p"),Po.innerHTML=_p,fl=o(),Go=i("p"),Go.textContent=bp,hl=o(),me=i("div"),m(Dt.$$.fragment),_l=o(),Eo=i("p"),Eo.innerHTML=yp,bl=o(),m(et.$$.fragment),ma=o(),m(qt.$$.fragment),ua=o(),Y=i("div"),m(Ht.$$.fragment),yl=o(),Do=i("p"),Do.textContent=Mp,Ml=o(),qo=i("p"),qo.innerHTML=vp,vl=o(),tt=i("div"),m(Yt.$$.fragment),Nl=o(),Ho=i("p"),Ho.textContent=Np,ga=o(),m(Qt.$$.fragment),fa=o(),Q=i("div"),m(At.$$.fragment),wl=o(),Yo=i("p"),Yo.textContent=wp,Tl=o(),Qo=i("p"),Qo.innerHTML=Tp,$l=o(),U=i("div"),m(Ot.$$.fragment),jl=o(),Ao=i("p"),Ao.innerHTML=$p,kl=o(),m(nt.$$.fragment),Cl=o(),Oo=i("p"),Oo.innerHTML=jp,Jl=o(),m(ot.$$.fragment),xl=o(),Ko=i("p"),Ko.innerHTML=kp,Ul=o(),m(rt.$$.fragment),ha=o(),m(Kt.$$.fragment),_a=o(),en=i("p"),en.textContent=Cp,ba=o(),m(tn.$$.fragment),ya=o(),L=i("div"),m(nn.$$.fragment),Fl=o(),er=i("p"),er.textContent=Jp,Il=o(),tr=i("p"),tr.innerHTML=xp,Zl=o(),nr=i("p"),nr.textContent=Up,Xl=o(),ue=i("div"),m(on.$$.fragment),Sl=o(),or=i("p"),or.innerHTML=Fp,Vl=o(),m(at.$$.fragment),Ma=o(),m(rn.$$.fragment),va=o(),B=i("div"),m(an.$$.fragment),Rl=o(),rr=i("p"),rr.textContent=Ip,Wl=o(),ar=i("p"),ar.innerHTML=Zp,zl=o(),sr=i("p"),sr.textContent=Xp,Ll=o(),ge=i("div"),m(sn.$$.fragment),Bl=o(),lr=i("p"),lr.innerHTML=Sp,Pl=o(),m(st.$$.fragment),Na=o(),m(ln.$$.fragment),wa=o(),P=i("div"),m(pn.$$.fragment),Gl=o(),ir=i("p"),ir.textContent=Vp,El=o(),pr=i("p"),pr.innerHTML=Rp,Dl=o(),cr=i("p"),cr.textContent=Wp,ql=o(),fe=i("div"),m(cn.$$.fragment),Hl=o(),dr=i("p"),dr.innerHTML=zp,Yl=o(),m(lt.$$.fragment),Ta=o(),m(dn.$$.fragment),$a=o(),mn=i("p"),mn.textContent=Lp,ja=o(),m(un.$$.fragment),ka=o(),G=i("div"),m(gn.$$.fragment),Ql=o(),mr=i("p"),mr.textContent=Bp,Al=o(),ur=i("p"),ur.innerHTML=Pp,Ol=o(),gr=i("p"),gr.textContent=Gp,Kl=o(),he=i("div"),m(fn.$$.fragment),ei=o(),fr=i("p"),fr.innerHTML=Ep,ti=o(),m(it.$$.fragment),Ca=o(),m(hn.$$.fragment),Ja=o(),E=i("div"),m(_n.$$.fragment),ni=o(),hr=i("p"),hr.textContent=Dp,oi=o(),_r=i("p"),_r.innerHTML=qp,ri=o(),br=i("p"),br.textContent=Hp,ai=o(),_e=i("div"),m(bn.$$.fragment),si=o(),yr=i("p"),yr.innerHTML=Yp,li=o(),m(pt.$$.fragment),xa=o(),m(yn.$$.fragment),Ua=o(),D=i("div"),m(Mn.$$.fragment),ii=o(),Mr=i("p"),Mr.textContent=Qp,pi=o(),vr=i("p"),vr.innerHTML=Ap,ci=o(),Nr=i("p"),Nr.textContent=Op,di=o(),ae=i("div"),m(vn.$$.fragment),mi=o(),wr=i("p"),wr.innerHTML=Kp,ui=o(),m(ct.$$.fragment),gi=o(),m(dt.$$.fragment),Fa=o(),m(Nn.$$.fragment),Ia=o(),q=i("div"),m(wn.$$.fragment),fi=o(),Tr=i("p"),Tr.textContent=ec,hi=o(),$r=i("p"),$r.innerHTML=tc,_i=o(),jr=i("p"),jr.textContent=nc,bi=o(),be=i("div"),m(Tn.$$.fragment),yi=o(),kr=i("p"),kr.innerHTML=oc,Mi=o(),m(mt.$$.fragment),Za=o(),m($n.$$.fragment),Xa=o(),jn=i("p"),jn.textContent=rc,Sa=o(),m(kn.$$.fragment),Va=o(),ke=i("div"),m(Cn.$$.fragment),vi=o(),Cr=i("div"),m(Jn.$$.fragment),Ra=o(),m(xn.$$.fragment),Wa=o(),Ce=i("div"),m(Un.$$.fragment),Ni=o(),Jr=i("div"),m(Fn.$$.fragment),za=o(),m(In.$$.fragment),La=o(),Je=i("div"),m(Zn.$$.fragment),wi=o(),xr=i("div"),m(Xn.$$.fragment),Ba=o(),m(Sn.$$.fragment),Pa=o(),xe=i("div"),m(Vn.$$.fragment),Ti=o(),Ur=i("div"),m(Rn.$$.fragment),Ga=o(),m(Wn.$$.fragment),Ea=o(),Ue=i("div"),m(zn.$$.fragment),$i=o(),ut=i("div"),m(Ln.$$.fragment),ji=o(),Fr=i("p"),Fr.textContent=ac,Da=o(),m(Bn.$$.fragment),qa=o(),Fe=i("div"),m(Pn.$$.fragment),ki=o(),Ir=i("div"),m(Gn.$$.fragment),Ha=o(),m(En.$$.fragment),Ya=o(),Ie=i("div"),m(Dn.$$.fragment),Ci=o(),Zr=i("div"),m(qn.$$.fragment),Qa=o(),m(Hn.$$.fragment),Aa=o(),Ze=i("div"),m(Yn.$$.fragment),Ji=o(),Xr=i("div"),m(Qn.$$.fragment),Oa=o(),m(An.$$.fragment),Ka=o(),Xe=i("div"),m(On.$$.fragment),xi=o(),Sr=i("div"),m(Kn.$$.fragment),es=o(),m(eo.$$.fragment),ts=o(),Se=i("div"),m(to.$$.fragment),Ui=o(),ye=i("div"),m(no.$$.fragment),Fi=o(),Vr=i("p"),Vr.textContent=sc,Ii=o(),Rr=i("p"),Rr.textContent=lc,ns=o(),Dr=i("p"),this.h()},l(e){const s=Mc("svelte-u9bgzb",document.head);l=p(s,"META",{name:!0,content:!0}),s.forEach(a),N=r(e),b=p(e,"P",{}),w(b).forEach(a),c=r(e),u(M.$$.fragment,e),t=r(e),u(v.$$.fragment,e),qr=r(e),u(_t.$$.fragment,e),Hr=r(e),bt=p(e,"P",{"data-svelte-h":!0}),y(bt)!=="svelte-1wqojdr"&&(bt.innerHTML=Zi),Yr=r(e),C=p(e,"DIV",{class:!0});var J=w(C);u(yt.$$.fragment,J),hs=r(J),lo=p(J,"P",{"data-svelte-h":!0}),y(lo)!=="svelte-14ur69o"&&(lo.textContent=Xi),_s=r(J),io=p(J,"P",{"data-svelte-h":!0}),y(io)!=="svelte-1chwlbt"&&(io.innerHTML=Si),bs=r(J),po=p(J,"P",{"data-svelte-h":!0}),y(po)!=="svelte-wz8va1"&&(po.textContent=Vi),ys=r(J),co=p(J,"UL",{"data-svelte-h":!0}),y(co)!=="svelte-7z1nij"&&(co.innerHTML=Ri),Ms=r(J),mo=p(J,"P",{"data-svelte-h":!0}),y(mo)!=="svelte-86gko0"&&(mo.textContent=Wi),vs=r(J),uo=p(J,"UL",{"data-svelte-h":!0}),y(uo)!=="svelte-3lf6vl"&&(uo.innerHTML=zi),Ns=r(J),Pe=p(J,"DIV",{class:!0});var oo=w(Pe);u(Mt.$$.fragment,oo),ws=r(oo),go=p(oo,"P",{"data-svelte-h":!0}),y(go)!=="svelte-1r2xt0l"&&(go.innerHTML=Li),oo.forEach(a),Ts=r(J),Ge=p(J,"DIV",{class:!0});var ro=w(Ge);u(vt.$$.fragment,ro),$s=r(ro),fo=p(ro,"P",{"data-svelte-h":!0}),y(fo)!=="svelte-fniwno"&&(fo.textContent=Bi),ro.forEach(a),js=r(J),Ee=p(J,"DIV",{class:!0});var ao=w(Ee);u(Nt.$$.fragment,ao),ks=r(ao),ho=p(ao,"P",{"data-svelte-h":!0}),y(ho)!=="svelte-o2sfh1"&&(ho.innerHTML=Pi),ao.forEach(a),Cs=r(J),De=p(J,"DIV",{class:!0});var so=w(De);u(wt.$$.fragment,so),Js=r(so),_o=p(so,"P",{"data-svelte-h":!0}),y(_o)!=="svelte-2mtl9d"&&(_o.textContent=Gi),so.forEach(a),J.forEach(a),Qr=r(e),u(Tt.$$.fragment,e),Ar=r(e),$t=p(e,"P",{"data-svelte-h":!0}),y($t)!=="svelte-1j76tak"&&($t.textContent=Ei),Or=r(e),u(jt.$$.fragment,e),Kr=r(e),Z=p(e,"DIV",{class:!0});var A=w(Z);u(kt.$$.fragment,A),xs=r(A),bo=p(A,"P",{"data-svelte-h":!0}),y(bo)!=="svelte-tyb6d9"&&(bo.textContent=Di),Us=r(A),yo=p(A,"P",{"data-svelte-h":!0}),y(yo)!=="svelte-t21i2g"&&(yo.innerHTML=qi),Fs=r(A),Mo=p(A,"P",{"data-svelte-h":!0}),y(Mo)!=="svelte-1nitj0t"&&(Mo.textContent=Hi),Is=r(A),le=p(A,"DIV",{class:!0});var Ve=w(le);u(Ct.$$.fragment,Ve),Zs=r(Ve),vo=p(Ve,"P",{"data-svelte-h":!0}),y(vo)!=="svelte-cgjaxs"&&(vo.innerHTML=Yi),Xs=r(Ve),u(qe.$$.fragment,Ve),Ve.forEach(a),A.forEach(a),ea=r(e),u(Jt.$$.fragment,e),ta=r(e),X=p(e,"DIV",{class:!0});var O=w(X);u(xt.$$.fragment,O),Ss=r(O),No=p(O,"P",{"data-svelte-h":!0}),y(No)!=="svelte-o9alfo"&&(No.textContent=Qi),Vs=r(O),wo=p(O,"P",{"data-svelte-h":!0}),y(wo)!=="svelte-t21i2g"&&(wo.innerHTML=Ai),Rs=r(O),To=p(O,"P",{"data-svelte-h":!0}),y(To)!=="svelte-fib3qb"&&(To.textContent=Oi),Ws=r(O),re=p(O,"DIV",{class:!0});var se=w(re);u(Ut.$$.fragment,se),zs=r(se),$o=p(se,"P",{"data-svelte-h":!0}),y($o)!=="svelte-mm1jdo"&&($o.innerHTML=Ki),Ls=r(se),u(He.$$.fragment,se),Bs=r(se),u(Ye.$$.fragment,se),se.forEach(a),O.forEach(a),na=r(e),u(Ft.$$.fragment,e),oa=r(e),S=p(e,"DIV",{class:!0});var K=w(S);u(It.$$.fragment,K),Ps=r(K),jo=p(K,"P",{"data-svelte-h":!0}),y(jo)!=="svelte-12nn25"&&(jo.textContent=ep),Gs=r(K),ko=p(K,"P",{"data-svelte-h":!0}),y(ko)!=="svelte-t21i2g"&&(ko.innerHTML=tp),Es=r(K),Co=p(K,"P",{"data-svelte-h":!0}),y(Co)!=="svelte-1y0nyf2"&&(Co.textContent=np),Ds=r(K),ie=p(K,"DIV",{class:!0});var Re=w(ie);u(Zt.$$.fragment,Re),qs=r(Re),Jo=p(Re,"P",{"data-svelte-h":!0}),y(Jo)!=="svelte-8d129p"&&(Jo.innerHTML=op),Hs=r(Re),u(Qe.$$.fragment,Re),Re.forEach(a),K.forEach(a),ra=r(e),u(Xt.$$.fragment,e),aa=r(e),V=p(e,"DIV",{class:!0});var ee=w(V);u(St.$$.fragment,ee),Ys=r(ee),xo=p(ee,"P",{"data-svelte-h":!0}),y(xo)!=="svelte-sy64kq"&&(xo.textContent=rp),Qs=r(ee),Uo=p(ee,"P",{"data-svelte-h":!0}),y(Uo)!=="svelte-t21i2g"&&(Uo.innerHTML=ap),As=r(ee),Fo=p(ee,"P",{"data-svelte-h":!0}),y(Fo)!=="svelte-1pso76n"&&(Fo.textContent=sp),Os=r(ee),pe=p(ee,"DIV",{class:!0});var We=w(pe);u(Vt.$$.fragment,We),Ks=r(We),Io=p(We,"P",{"data-svelte-h":!0}),y(Io)!=="svelte-1qtopj4"&&(Io.innerHTML=lp),el=r(We),u(Ae.$$.fragment,We),We.forEach(a),ee.forEach(a),sa=r(e),u(Rt.$$.fragment,e),la=r(e),R=p(e,"DIV",{class:!0});var te=w(R);u(Wt.$$.fragment,te),tl=r(te),Zo=p(te,"P",{"data-svelte-h":!0}),y(Zo)!=="svelte-196ytxv"&&(Zo.textContent=ip),nl=r(te),Xo=p(te,"P",{"data-svelte-h":!0}),y(Xo)!=="svelte-t21i2g"&&(Xo.innerHTML=pp),ol=r(te),So=p(te,"P",{"data-svelte-h":!0}),y(So)!=="svelte-8xyl8y"&&(So.textContent=cp),rl=r(te),ce=p(te,"DIV",{class:!0});var ze=w(ce);u(zt.$$.fragment,ze),al=r(ze),Vo=p(ze,"P",{"data-svelte-h":!0}),y(Vo)!=="svelte-1il3s71"&&(Vo.innerHTML=dp),sl=r(ze),u(Oe.$$.fragment,ze),ze.forEach(a),te.forEach(a),ia=r(e),u(Lt.$$.fragment,e),pa=r(e),W=p(e,"DIV",{class:!0});var ne=w(W);u(Bt.$$.fragment,ne),ll=r(ne),Ro=p(ne,"P",{"data-svelte-h":!0}),y(Ro)!=="svelte-16p5zms"&&(Ro.textContent=mp),il=r(ne),Wo=p(ne,"P",{"data-svelte-h":!0}),y(Wo)!=="svelte-t21i2g"&&(Wo.innerHTML=up),pl=r(ne),zo=p(ne,"P",{"data-svelte-h":!0}),y(zo)!=="svelte-1hvccyd"&&(zo.textContent=gp),cl=r(ne),de=p(ne,"DIV",{class:!0});var Le=w(de);u(Pt.$$.fragment,Le),dl=r(Le),Lo=p(Le,"P",{"data-svelte-h":!0}),y(Lo)!=="svelte-x5ht8e"&&(Lo.innerHTML=fp),ml=r(Le),u(Ke.$$.fragment,Le),Le.forEach(a),ne.forEach(a),ca=r(e),u(Gt.$$.fragment,e),da=r(e),z=p(e,"DIV",{class:!0});var oe=w(z);u(Et.$$.fragment,oe),ul=r(oe),Bo=p(oe,"P",{"data-svelte-h":!0}),y(Bo)!=="svelte-1kpvzm3"&&(Bo.textContent=hp),gl=r(oe),Po=p(oe,"P",{"data-svelte-h":!0}),y(Po)!=="svelte-t21i2g"&&(Po.innerHTML=_p),fl=r(oe),Go=p(oe,"P",{"data-svelte-h":!0}),y(Go)!=="svelte-v7xrhz"&&(Go.textContent=bp),hl=r(oe),me=p(oe,"DIV",{class:!0});var Be=w(me);u(Dt.$$.fragment,Be),_l=r(Be),Eo=p(Be,"P",{"data-svelte-h":!0}),y(Eo)!=="svelte-kejd1q"&&(Eo.innerHTML=yp),bl=r(Be),u(et.$$.fragment,Be),Be.forEach(a),oe.forEach(a),ma=r(e),u(qt.$$.fragment,e),ua=r(e),Y=p(e,"DIV",{class:!0});var gt=w(Y);u(Ht.$$.fragment,gt),yl=r(gt),Do=p(gt,"P",{"data-svelte-h":!0}),y(Do)!=="svelte-1dh7ria"&&(Do.textContent=Mp),Ml=r(gt),qo=p(gt,"P",{"data-svelte-h":!0}),y(qo)!=="svelte-m4jyla"&&(qo.innerHTML=vp),vl=r(gt),tt=p(gt,"DIV",{class:!0});var rs=w(tt);u(Yt.$$.fragment,rs),Nl=r(rs),Ho=p(rs,"P",{"data-svelte-h":!0}),y(Ho)!=="svelte-1jvspet"&&(Ho.textContent=Np),rs.forEach(a),gt.forEach(a),ga=r(e),u(Qt.$$.fragment,e),fa=r(e),Q=p(e,"DIV",{class:!0});var ft=w(Q);u(At.$$.fragment,ft),wl=r(ft),Yo=p(ft,"P",{"data-svelte-h":!0}),y(Yo)!=="svelte-12et8hl"&&(Yo.textContent=wp),Tl=r(ft),Qo=p(ft,"P",{"data-svelte-h":!0}),y(Qo)!=="svelte-t21i2g"&&(Qo.innerHTML=Tp),$l=r(ft),U=p(ft,"DIV",{class:!0});var H=w(U);u(Ot.$$.fragment,H),jl=r(H),Ao=p(H,"P",{"data-svelte-h":!0}),y(Ao)!=="svelte-1oxk9vl"&&(Ao.innerHTML=$p),kl=r(H),u(nt.$$.fragment,H),Cl=r(H),Oo=p(H,"P",{"data-svelte-h":!0}),y(Oo)!=="svelte-1osiy1t"&&(Oo.innerHTML=jp),Jl=r(H),u(ot.$$.fragment,H),xl=r(H),Ko=p(H,"P",{"data-svelte-h":!0}),y(Ko)!=="svelte-89pj2f"&&(Ko.innerHTML=kp),Ul=r(H),u(rt.$$.fragment,H),H.forEach(a),ft.forEach(a),ha=r(e),u(Kt.$$.fragment,e),_a=r(e),en=p(e,"P",{"data-svelte-h":!0}),y(en)!=="svelte-dmb9sp"&&(en.textContent=Cp),ba=r(e),u(tn.$$.fragment,e),ya=r(e),L=p(e,"DIV",{class:!0});var Me=w(L);u(nn.$$.fragment,Me),Fl=r(Me),er=p(Me,"P",{"data-svelte-h":!0}),y(er)!=="svelte-iobswt"&&(er.textContent=Jp),Il=r(Me),tr=p(Me,"P",{"data-svelte-h":!0}),y(tr)!=="svelte-t21i2g"&&(tr.innerHTML=xp),Zl=r(Me),nr=p(Me,"P",{"data-svelte-h":!0}),y(nr)!=="svelte-1g4h8eb"&&(nr.textContent=Up),Xl=r(Me),ue=p(Me,"DIV",{class:!0});var Wr=w(ue);u(on.$$.fragment,Wr),Sl=r(Wr),or=p(Wr,"P",{"data-svelte-h":!0}),y(or)!=="svelte-4a7c7i"&&(or.innerHTML=Fp),Vl=r(Wr),u(at.$$.fragment,Wr),Wr.forEach(a),Me.forEach(a),Ma=r(e),u(rn.$$.fragment,e),va=r(e),B=p(e,"DIV",{class:!0});var ve=w(B);u(an.$$.fragment,ve),Rl=r(ve),rr=p(ve,"P",{"data-svelte-h":!0}),y(rr)!=="svelte-a522e4"&&(rr.textContent=Ip),Wl=r(ve),ar=p(ve,"P",{"data-svelte-h":!0}),y(ar)!=="svelte-t21i2g"&&(ar.innerHTML=Zp),zl=r(ve),sr=p(ve,"P",{"data-svelte-h":!0}),y(sr)!=="svelte-jb8c8r"&&(sr.textContent=Xp),Ll=r(ve),ge=p(ve,"DIV",{class:!0});var zr=w(ge);u(sn.$$.fragment,zr),Bl=r(zr),lr=p(zr,"P",{"data-svelte-h":!0}),y(lr)!=="svelte-kcdbet"&&(lr.innerHTML=Sp),Pl=r(zr),u(st.$$.fragment,zr),zr.forEach(a),ve.forEach(a),Na=r(e),u(ln.$$.fragment,e),wa=r(e),P=p(e,"DIV",{class:!0});var Ne=w(P);u(pn.$$.fragment,Ne),Gl=r(Ne),ir=p(Ne,"P",{"data-svelte-h":!0}),y(ir)!=="svelte-1jokdk4"&&(ir.textContent=Vp),El=r(Ne),pr=p(Ne,"P",{"data-svelte-h":!0}),y(pr)!=="svelte-t21i2g"&&(pr.innerHTML=Rp),Dl=r(Ne),cr=p(Ne,"P",{"data-svelte-h":!0}),y(cr)!=="svelte-pqeh18"&&(cr.textContent=Wp),ql=r(Ne),fe=p(Ne,"DIV",{class:!0});var Lr=w(fe);u(cn.$$.fragment,Lr),Hl=r(Lr),dr=p(Lr,"P",{"data-svelte-h":!0}),y(dr)!=="svelte-rg1qqx"&&(dr.innerHTML=zp),Yl=r(Lr),u(lt.$$.fragment,Lr),Lr.forEach(a),Ne.forEach(a),Ta=r(e),u(dn.$$.fragment,e),$a=r(e),mn=p(e,"P",{"data-svelte-h":!0}),y(mn)!=="svelte-1htpfc5"&&(mn.textContent=Lp),ja=r(e),u(un.$$.fragment,e),ka=r(e),G=p(e,"DIV",{class:!0});var we=w(G);u(gn.$$.fragment,we),Ql=r(we),mr=p(we,"P",{"data-svelte-h":!0}),y(mr)!=="svelte-13994kt"&&(mr.textContent=Bp),Al=r(we),ur=p(we,"P",{"data-svelte-h":!0}),y(ur)!=="svelte-t21i2g"&&(ur.innerHTML=Pp),Ol=r(we),gr=p(we,"P",{"data-svelte-h":!0}),y(gr)!=="svelte-iwso1f"&&(gr.textContent=Gp),Kl=r(we),he=p(we,"DIV",{class:!0});var Br=w(he);u(fn.$$.fragment,Br),ei=r(Br),fr=p(Br,"P",{"data-svelte-h":!0}),y(fr)!=="svelte-1mrzugx"&&(fr.innerHTML=Ep),ti=r(Br),u(it.$$.fragment,Br),Br.forEach(a),we.forEach(a),Ca=r(e),u(hn.$$.fragment,e),Ja=r(e),E=p(e,"DIV",{class:!0});var Te=w(E);u(_n.$$.fragment,Te),ni=r(Te),hr=p(Te,"P",{"data-svelte-h":!0}),y(hr)!=="svelte-1wtizei"&&(hr.textContent=Dp),oi=r(Te),_r=p(Te,"P",{"data-svelte-h":!0}),y(_r)!=="svelte-t21i2g"&&(_r.innerHTML=qp),ri=r(Te),br=p(Te,"P",{"data-svelte-h":!0}),y(br)!=="svelte-484vqn"&&(br.textContent=Hp),ai=r(Te),_e=p(Te,"DIV",{class:!0});var Pr=w(_e);u(bn.$$.fragment,Pr),si=r(Pr),yr=p(Pr,"P",{"data-svelte-h":!0}),y(yr)!=="svelte-hohte"&&(yr.innerHTML=Yp),li=r(Pr),u(pt.$$.fragment,Pr),Pr.forEach(a),Te.forEach(a),xa=r(e),u(yn.$$.fragment,e),Ua=r(e),D=p(e,"DIV",{class:!0});var $e=w(D);u(Mn.$$.fragment,$e),ii=r($e),Mr=p($e,"P",{"data-svelte-h":!0}),y(Mr)!=="svelte-1minwrj"&&(Mr.textContent=Qp),pi=r($e),vr=p($e,"P",{"data-svelte-h":!0}),y(vr)!=="svelte-t21i2g"&&(vr.innerHTML=Ap),ci=r($e),Nr=p($e,"P",{"data-svelte-h":!0}),y(Nr)!=="svelte-1dft1qw"&&(Nr.textContent=Op),di=r($e),ae=p($e,"DIV",{class:!0});var ht=w(ae);u(vn.$$.fragment,ht),mi=r(ht),wr=p(ht,"P",{"data-svelte-h":!0}),y(wr)!=="svelte-33b8wf"&&(wr.innerHTML=Kp),ui=r(ht),u(ct.$$.fragment,ht),gi=r(ht),u(dt.$$.fragment,ht),ht.forEach(a),$e.forEach(a),Fa=r(e),u(Nn.$$.fragment,e),Ia=r(e),q=p(e,"DIV",{class:!0});var je=w(q);u(wn.$$.fragment,je),fi=r(je),Tr=p(je,"P",{"data-svelte-h":!0}),y(Tr)!=="svelte-ylsbuv"&&(Tr.textContent=ec),hi=r(je),$r=p(je,"P",{"data-svelte-h":!0}),y($r)!=="svelte-t21i2g"&&($r.innerHTML=tc),_i=r(je),jr=p(je,"P",{"data-svelte-h":!0}),y(jr)!=="svelte-ylsbuv"&&(jr.textContent=nc),bi=r(je),be=p(je,"DIV",{class:!0});var Gr=w(be);u(Tn.$$.fragment,Gr),yi=r(Gr),kr=p(Gr,"P",{"data-svelte-h":!0}),y(kr)!=="svelte-190wczg"&&(kr.innerHTML=oc),Mi=r(Gr),u(mt.$$.fragment,Gr),Gr.forEach(a),je.forEach(a),Za=r(e),u($n.$$.fragment,e),Xa=r(e),jn=p(e,"P",{"data-svelte-h":!0}),y(jn)!=="svelte-149jhtw"&&(jn.textContent=rc),Sa=r(e),u(kn.$$.fragment,e),Va=r(e),ke=p(e,"DIV",{class:!0});var as=w(ke);u(Cn.$$.fragment,as),vi=r(as),Cr=p(as,"DIV",{class:!0});var ic=w(Cr);u(Jn.$$.fragment,ic),ic.forEach(a),as.forEach(a),Ra=r(e),u(xn.$$.fragment,e),Wa=r(e),Ce=p(e,"DIV",{class:!0});var ss=w(Ce);u(Un.$$.fragment,ss),Ni=r(ss),Jr=p(ss,"DIV",{class:!0});var pc=w(Jr);u(Fn.$$.fragment,pc),pc.forEach(a),ss.forEach(a),za=r(e),u(In.$$.fragment,e),La=r(e),Je=p(e,"DIV",{class:!0});var ls=w(Je);u(Zn.$$.fragment,ls),wi=r(ls),xr=p(ls,"DIV",{class:!0});var cc=w(xr);u(Xn.$$.fragment,cc),cc.forEach(a),ls.forEach(a),Ba=r(e),u(Sn.$$.fragment,e),Pa=r(e),xe=p(e,"DIV",{class:!0});var is=w(xe);u(Vn.$$.fragment,is),Ti=r(is),Ur=p(is,"DIV",{class:!0});var dc=w(Ur);u(Rn.$$.fragment,dc),dc.forEach(a),is.forEach(a),Ga=r(e),u(Wn.$$.fragment,e),Ea=r(e),Ue=p(e,"DIV",{class:!0});var ps=w(Ue);u(zn.$$.fragment,ps),$i=r(ps),ut=p(ps,"DIV",{class:!0});var cs=w(ut);u(Ln.$$.fragment,cs),ji=r(cs),Fr=p(cs,"P",{"data-svelte-h":!0}),y(Fr)!=="svelte-50j04k"&&(Fr.textContent=ac),cs.forEach(a),ps.forEach(a),Da=r(e),u(Bn.$$.fragment,e),qa=r(e),Fe=p(e,"DIV",{class:!0});var ds=w(Fe);u(Pn.$$.fragment,ds),ki=r(ds),Ir=p(ds,"DIV",{class:!0});var mc=w(Ir);u(Gn.$$.fragment,mc),mc.forEach(a),ds.forEach(a),Ha=r(e),u(En.$$.fragment,e),Ya=r(e),Ie=p(e,"DIV",{class:!0});var ms=w(Ie);u(Dn.$$.fragment,ms),Ci=r(ms),Zr=p(ms,"DIV",{class:!0});var uc=w(Zr);u(qn.$$.fragment,uc),uc.forEach(a),ms.forEach(a),Qa=r(e),u(Hn.$$.fragment,e),Aa=r(e),Ze=p(e,"DIV",{class:!0});var us=w(Ze);u(Yn.$$.fragment,us),Ji=r(us),Xr=p(us,"DIV",{class:!0});var gc=w(Xr);u(Qn.$$.fragment,gc),gc.forEach(a),us.forEach(a),Oa=r(e),u(An.$$.fragment,e),Ka=r(e),Xe=p(e,"DIV",{class:!0});var gs=w(Xe);u(On.$$.fragment,gs),xi=r(gs),Sr=p(gs,"DIV",{class:!0});var fc=w(Sr);u(Kn.$$.fragment,fc),fc.forEach(a),gs.forEach(a),es=r(e),u(eo.$$.fragment,e),ts=r(e),Se=p(e,"DIV",{class:!0});var fs=w(Se);u(to.$$.fragment,fs),Ui=r(fs),ye=p(fs,"DIV",{class:!0});var Er=w(ye);u(no.$$.fragment,Er),Fi=r(Er),Vr=p(Er,"P",{"data-svelte-h":!0}),y(Vr)!=="svelte-50j04k"&&(Vr.textContent=sc),Ii=r(Er),Rr=p(Er,"P",{"data-svelte-h":!0}),y(Rr)!=="svelte-kvfsh7"&&(Rr.textContent=lc),Er.forEach(a),fs.forEach(a),ns=r(e),Dr=p(e,"P",{}),w(Dr).forEach(a),this.h()},h(){T(l,"name","hf:doc:metadata"),T(l,"content",Bc),T(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Cr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Jr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ur,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ir,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Zr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Xr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Sr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){n(document.head,l),d(e,N,s),d(e,b,s),d(e,c,s),g(M,e,s),d(e,t,s),g(v,e,s),d(e,qr,s),g(_t,e,s),d(e,Hr,s),d(e,bt,s),d(e,Yr,s),d(e,C,s),g(yt,C,null),n(C,hs),n(C,lo),n(C,_s),n(C,io),n(C,bs),n(C,po),n(C,ys),n(C,co),n(C,Ms),n(C,mo),n(C,vs),n(C,uo),n(C,Ns),n(C,Pe),g(Mt,Pe,null),n(Pe,ws),n(Pe,go),n(C,Ts),n(C,Ge),g(vt,Ge,null),n(Ge,$s),n(Ge,fo),n(C,js),n(C,Ee),g(Nt,Ee,null),n(Ee,ks),n(Ee,ho),n(C,Cs),n(C,De),g(wt,De,null),n(De,Js),n(De,_o),d(e,Qr,s),g(Tt,e,s),d(e,Ar,s),d(e,$t,s),d(e,Or,s),g(jt,e,s),d(e,Kr,s),d(e,Z,s),g(kt,Z,null),n(Z,xs),n(Z,bo),n(Z,Us),n(Z,yo),n(Z,Fs),n(Z,Mo),n(Z,Is),n(Z,le),g(Ct,le,null),n(le,Zs),n(le,vo),n(le,Xs),g(qe,le,null),d(e,ea,s),g(Jt,e,s),d(e,ta,s),d(e,X,s),g(xt,X,null),n(X,Ss),n(X,No),n(X,Vs),n(X,wo),n(X,Rs),n(X,To),n(X,Ws),n(X,re),g(Ut,re,null),n(re,zs),n(re,$o),n(re,Ls),g(He,re,null),n(re,Bs),g(Ye,re,null),d(e,na,s),g(Ft,e,s),d(e,oa,s),d(e,S,s),g(It,S,null),n(S,Ps),n(S,jo),n(S,Gs),n(S,ko),n(S,Es),n(S,Co),n(S,Ds),n(S,ie),g(Zt,ie,null),n(ie,qs),n(ie,Jo),n(ie,Hs),g(Qe,ie,null),d(e,ra,s),g(Xt,e,s),d(e,aa,s),d(e,V,s),g(St,V,null),n(V,Ys),n(V,xo),n(V,Qs),n(V,Uo),n(V,As),n(V,Fo),n(V,Os),n(V,pe),g(Vt,pe,null),n(pe,Ks),n(pe,Io),n(pe,el),g(Ae,pe,null),d(e,sa,s),g(Rt,e,s),d(e,la,s),d(e,R,s),g(Wt,R,null),n(R,tl),n(R,Zo),n(R,nl),n(R,Xo),n(R,ol),n(R,So),n(R,rl),n(R,ce),g(zt,ce,null),n(ce,al),n(ce,Vo),n(ce,sl),g(Oe,ce,null),d(e,ia,s),g(Lt,e,s),d(e,pa,s),d(e,W,s),g(Bt,W,null),n(W,ll),n(W,Ro),n(W,il),n(W,Wo),n(W,pl),n(W,zo),n(W,cl),n(W,de),g(Pt,de,null),n(de,dl),n(de,Lo),n(de,ml),g(Ke,de,null),d(e,ca,s),g(Gt,e,s),d(e,da,s),d(e,z,s),g(Et,z,null),n(z,ul),n(z,Bo),n(z,gl),n(z,Po),n(z,fl),n(z,Go),n(z,hl),n(z,me),g(Dt,me,null),n(me,_l),n(me,Eo),n(me,bl),g(et,me,null),d(e,ma,s),g(qt,e,s),d(e,ua,s),d(e,Y,s),g(Ht,Y,null),n(Y,yl),n(Y,Do),n(Y,Ml),n(Y,qo),n(Y,vl),n(Y,tt),g(Yt,tt,null),n(tt,Nl),n(tt,Ho),d(e,ga,s),g(Qt,e,s),d(e,fa,s),d(e,Q,s),g(At,Q,null),n(Q,wl),n(Q,Yo),n(Q,Tl),n(Q,Qo),n(Q,$l),n(Q,U),g(Ot,U,null),n(U,jl),n(U,Ao),n(U,kl),g(nt,U,null),n(U,Cl),n(U,Oo),n(U,Jl),g(ot,U,null),n(U,xl),n(U,Ko),n(U,Ul),g(rt,U,null),d(e,ha,s),g(Kt,e,s),d(e,_a,s),d(e,en,s),d(e,ba,s),g(tn,e,s),d(e,ya,s),d(e,L,s),g(nn,L,null),n(L,Fl),n(L,er),n(L,Il),n(L,tr),n(L,Zl),n(L,nr),n(L,Xl),n(L,ue),g(on,ue,null),n(ue,Sl),n(ue,or),n(ue,Vl),g(at,ue,null),d(e,Ma,s),g(rn,e,s),d(e,va,s),d(e,B,s),g(an,B,null),n(B,Rl),n(B,rr),n(B,Wl),n(B,ar),n(B,zl),n(B,sr),n(B,Ll),n(B,ge),g(sn,ge,null),n(ge,Bl),n(ge,lr),n(ge,Pl),g(st,ge,null),d(e,Na,s),g(ln,e,s),d(e,wa,s),d(e,P,s),g(pn,P,null),n(P,Gl),n(P,ir),n(P,El),n(P,pr),n(P,Dl),n(P,cr),n(P,ql),n(P,fe),g(cn,fe,null),n(fe,Hl),n(fe,dr),n(fe,Yl),g(lt,fe,null),d(e,Ta,s),g(dn,e,s),d(e,$a,s),d(e,mn,s),d(e,ja,s),g(un,e,s),d(e,ka,s),d(e,G,s),g(gn,G,null),n(G,Ql),n(G,mr),n(G,Al),n(G,ur),n(G,Ol),n(G,gr),n(G,Kl),n(G,he),g(fn,he,null),n(he,ei),n(he,fr),n(he,ti),g(it,he,null),d(e,Ca,s),g(hn,e,s),d(e,Ja,s),d(e,E,s),g(_n,E,null),n(E,ni),n(E,hr),n(E,oi),n(E,_r),n(E,ri),n(E,br),n(E,ai),n(E,_e),g(bn,_e,null),n(_e,si),n(_e,yr),n(_e,li),g(pt,_e,null),d(e,xa,s),g(yn,e,s),d(e,Ua,s),d(e,D,s),g(Mn,D,null),n(D,ii),n(D,Mr),n(D,pi),n(D,vr),n(D,ci),n(D,Nr),n(D,di),n(D,ae),g(vn,ae,null),n(ae,mi),n(ae,wr),n(ae,ui),g(ct,ae,null),n(ae,gi),g(dt,ae,null),d(e,Fa,s),g(Nn,e,s),d(e,Ia,s),d(e,q,s),g(wn,q,null),n(q,fi),n(q,Tr),n(q,hi),n(q,$r),n(q,_i),n(q,jr),n(q,bi),n(q,be),g(Tn,be,null),n(be,yi),n(be,kr),n(be,Mi),g(mt,be,null),d(e,Za,s),g($n,e,s),d(e,Xa,s),d(e,jn,s),d(e,Sa,s),g(kn,e,s),d(e,Va,s),d(e,ke,s),g(Cn,ke,null),n(ke,vi),n(ke,Cr),g(Jn,Cr,null),d(e,Ra,s),g(xn,e,s),d(e,Wa,s),d(e,Ce,s),g(Un,Ce,null),n(Ce,Ni),n(Ce,Jr),g(Fn,Jr,null),d(e,za,s),g(In,e,s),d(e,La,s),d(e,Je,s),g(Zn,Je,null),n(Je,wi),n(Je,xr),g(Xn,xr,null),d(e,Ba,s),g(Sn,e,s),d(e,Pa,s),d(e,xe,s),g(Vn,xe,null),n(xe,Ti),n(xe,Ur),g(Rn,Ur,null),d(e,Ga,s),g(Wn,e,s),d(e,Ea,s),d(e,Ue,s),g(zn,Ue,null),n(Ue,$i),n(Ue,ut),g(Ln,ut,null),n(ut,ji),n(ut,Fr),d(e,Da,s),g(Bn,e,s),d(e,qa,s),d(e,Fe,s),g(Pn,Fe,null),n(Fe,ki),n(Fe,Ir),g(Gn,Ir,null),d(e,Ha,s),g(En,e,s),d(e,Ya,s),d(e,Ie,s),g(Dn,Ie,null),n(Ie,Ci),n(Ie,Zr),g(qn,Zr,null),d(e,Qa,s),g(Hn,e,s),d(e,Aa,s),d(e,Ze,s),g(Yn,Ze,null),n(Ze,Ji),n(Ze,Xr),g(Qn,Xr,null),d(e,Oa,s),g(An,e,s),d(e,Ka,s),d(e,Xe,s),g(On,Xe,null),n(Xe,xi),n(Xe,Sr),g(Kn,Sr,null),d(e,es,s),g(eo,e,s),d(e,ts,s),d(e,Se,s),g(to,Se,null),n(Se,Ui),n(Se,ye),g(no,ye,null),n(ye,Fi),n(ye,Vr),n(ye,Ii),n(ye,Rr),d(e,ns,s),d(e,Dr,s),os=!0},p(e,[s]){const J={};s&2&&(J.$$scope={dirty:s,ctx:e}),qe.$set(J);const oo={};s&2&&(oo.$$scope={dirty:s,ctx:e}),He.$set(oo);const ro={};s&2&&(ro.$$scope={dirty:s,ctx:e}),Ye.$set(ro);const ao={};s&2&&(ao.$$scope={dirty:s,ctx:e}),Qe.$set(ao);const so={};s&2&&(so.$$scope={dirty:s,ctx:e}),Ae.$set(so);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),Oe.$set(A);const Ve={};s&2&&(Ve.$$scope={dirty:s,ctx:e}),Ke.$set(Ve);const O={};s&2&&(O.$$scope={dirty:s,ctx:e}),et.$set(O);const se={};s&2&&(se.$$scope={dirty:s,ctx:e}),nt.$set(se);const K={};s&2&&(K.$$scope={dirty:s,ctx:e}),ot.$set(K);const Re={};s&2&&(Re.$$scope={dirty:s,ctx:e}),rt.$set(Re);const ee={};s&2&&(ee.$$scope={dirty:s,ctx:e}),at.$set(ee);const We={};s&2&&(We.$$scope={dirty:s,ctx:e}),st.$set(We);const te={};s&2&&(te.$$scope={dirty:s,ctx:e}),lt.$set(te);const ze={};s&2&&(ze.$$scope={dirty:s,ctx:e}),it.$set(ze);const ne={};s&2&&(ne.$$scope={dirty:s,ctx:e}),pt.$set(ne);const Le={};s&2&&(Le.$$scope={dirty:s,ctx:e}),ct.$set(Le);const oe={};s&2&&(oe.$$scope={dirty:s,ctx:e}),dt.$set(oe);const Be={};s&2&&(Be.$$scope={dirty:s,ctx:e}),mt.$set(Be)},i(e){os||(f(M.$$.fragment,e),f(v.$$.fragment,e),f(_t.$$.fragment,e),f(yt.$$.fragment,e),f(Mt.$$.fragment,e),f(vt.$$.fragment,e),f(Nt.$$.fragment,e),f(wt.$$.fragment,e),f(Tt.$$.fragment,e),f(jt.$$.fragment,e),f(kt.$$.fragment,e),f(Ct.$$.fragment,e),f(qe.$$.fragment,e),f(Jt.$$.fragment,e),f(xt.$$.fragment,e),f(Ut.$$.fragment,e),f(He.$$.fragment,e),f(Ye.$$.fragment,e),f(Ft.$$.fragment,e),f(It.$$.fragment,e),f(Zt.$$.fragment,e),f(Qe.$$.fragment,e),f(Xt.$$.fragment,e),f(St.$$.fragment,e),f(Vt.$$.fragment,e),f(Ae.$$.fragment,e),f(Rt.$$.fragment,e),f(Wt.$$.fragment,e),f(zt.$$.fragment,e),f(Oe.$$.fragment,e),f(Lt.$$.fragment,e),f(Bt.$$.fragment,e),f(Pt.$$.fragment,e),f(Ke.$$.fragment,e),f(Gt.$$.fragment,e),f(Et.$$.fragment,e),f(Dt.$$.fragment,e),f(et.$$.fragment,e),f(qt.$$.fragment,e),f(Ht.$$.fragment,e),f(Yt.$$.fragment,e),f(Qt.$$.fragment,e),f(At.$$.fragment,e),f(Ot.$$.fragment,e),f(nt.$$.fragment,e),f(ot.$$.fragment,e),f(rt.$$.fragment,e),f(Kt.$$.fragment,e),f(tn.$$.fragment,e),f(nn.$$.fragment,e),f(on.$$.fragment,e),f(at.$$.fragment,e),f(rn.$$.fragment,e),f(an.$$.fragment,e),f(sn.$$.fragment,e),f(st.$$.fragment,e),f(ln.$$.fragment,e),f(pn.$$.fragment,e),f(cn.$$.fragment,e),f(lt.$$.fragment,e),f(dn.$$.fragment,e),f(un.$$.fragment,e),f(gn.$$.fragment,e),f(fn.$$.fragment,e),f(it.$$.fragment,e),f(hn.$$.fragment,e),f(_n.$$.fragment,e),f(bn.$$.fragment,e),f(pt.$$.fragment,e),f(yn.$$.fragment,e),f(Mn.$$.fragment,e),f(vn.$$.fragment,e),f(ct.$$.fragment,e),f(dt.$$.fragment,e),f(Nn.$$.fragment,e),f(wn.$$.fragment,e),f(Tn.$$.fragment,e),f(mt.$$.fragment,e),f($n.$$.fragment,e),f(kn.$$.fragment,e),f(Cn.$$.fragment,e),f(Jn.$$.fragment,e),f(xn.$$.fragment,e),f(Un.$$.fragment,e),f(Fn.$$.fragment,e),f(In.$$.fragment,e),f(Zn.$$.fragment,e),f(Xn.$$.fragment,e),f(Sn.$$.fragment,e),f(Vn.$$.fragment,e),f(Rn.$$.fragment,e),f(Wn.$$.fragment,e),f(zn.$$.fragment,e),f(Ln.$$.fragment,e),f(Bn.$$.fragment,e),f(Pn.$$.fragment,e),f(Gn.$$.fragment,e),f(En.$$.fragment,e),f(Dn.$$.fragment,e),f(qn.$$.fragment,e),f(Hn.$$.fragment,e),f(Yn.$$.fragment,e),f(Qn.$$.fragment,e),f(An.$$.fragment,e),f(On.$$.fragment,e),f(Kn.$$.fragment,e),f(eo.$$.fragment,e),f(to.$$.fragment,e),f(no.$$.fragment,e),os=!0)},o(e){h(M.$$.fragment,e),h(v.$$.fragment,e),h(_t.$$.fragment,e),h(yt.$$.fragment,e),h(Mt.$$.fragment,e),h(vt.$$.fragment,e),h(Nt.$$.fragment,e),h(wt.$$.fragment,e),h(Tt.$$.fragment,e),h(jt.$$.fragment,e),h(kt.$$.fragment,e),h(Ct.$$.fragment,e),h(qe.$$.fragment,e),h(Jt.$$.fragment,e),h(xt.$$.fragment,e),h(Ut.$$.fragment,e),h(He.$$.fragment,e),h(Ye.$$.fragment,e),h(Ft.$$.fragment,e),h(It.$$.fragment,e),h(Zt.$$.fragment,e),h(Qe.$$.fragment,e),h(Xt.$$.fragment,e),h(St.$$.fragment,e),h(Vt.$$.fragment,e),h(Ae.$$.fragment,e),h(Rt.$$.fragment,e),h(Wt.$$.fragment,e),h(zt.$$.fragment,e),h(Oe.$$.fragment,e),h(Lt.$$.fragment,e),h(Bt.$$.fragment,e),h(Pt.$$.fragment,e),h(Ke.$$.fragment,e),h(Gt.$$.fragment,e),h(Et.$$.fragment,e),h(Dt.$$.fragment,e),h(et.$$.fragment,e),h(qt.$$.fragment,e),h(Ht.$$.fragment,e),h(Yt.$$.fragment,e),h(Qt.$$.fragment,e),h(At.$$.fragment,e),h(Ot.$$.fragment,e),h(nt.$$.fragment,e),h(ot.$$.fragment,e),h(rt.$$.fragment,e),h(Kt.$$.fragment,e),h(tn.$$.fragment,e),h(nn.$$.fragment,e),h(on.$$.fragment,e),h(at.$$.fragment,e),h(rn.$$.fragment,e),h(an.$$.fragment,e),h(sn.$$.fragment,e),h(st.$$.fragment,e),h(ln.$$.fragment,e),h(pn.$$.fragment,e),h(cn.$$.fragment,e),h(lt.$$.fragment,e),h(dn.$$.fragment,e),h(un.$$.fragment,e),h(gn.$$.fragment,e),h(fn.$$.fragment,e),h(it.$$.fragment,e),h(hn.$$.fragment,e),h(_n.$$.fragment,e),h(bn.$$.fragment,e),h(pt.$$.fragment,e),h(yn.$$.fragment,e),h(Mn.$$.fragment,e),h(vn.$$.fragment,e),h(ct.$$.fragment,e),h(dt.$$.fragment,e),h(Nn.$$.fragment,e),h(wn.$$.fragment,e),h(Tn.$$.fragment,e),h(mt.$$.fragment,e),h($n.$$.fragment,e),h(kn.$$.fragment,e),h(Cn.$$.fragment,e),h(Jn.$$.fragment,e),h(xn.$$.fragment,e),h(Un.$$.fragment,e),h(Fn.$$.fragment,e),h(In.$$.fragment,e),h(Zn.$$.fragment,e),h(Xn.$$.fragment,e),h(Sn.$$.fragment,e),h(Vn.$$.fragment,e),h(Rn.$$.fragment,e),h(Wn.$$.fragment,e),h(zn.$$.fragment,e),h(Ln.$$.fragment,e),h(Bn.$$.fragment,e),h(Pn.$$.fragment,e),h(Gn.$$.fragment,e),h(En.$$.fragment,e),h(Dn.$$.fragment,e),h(qn.$$.fragment,e),h(Hn.$$.fragment,e),h(Yn.$$.fragment,e),h(Qn.$$.fragment,e),h(An.$$.fragment,e),h(On.$$.fragment,e),h(Kn.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(no.$$.fragment,e),os=!1},d(e){e&&(a(N),a(b),a(c),a(t),a(qr),a(Hr),a(bt),a(Yr),a(C),a(Qr),a(Ar),a($t),a(Or),a(Kr),a(Z),a(ea),a(ta),a(X),a(na),a(oa),a(S),a(ra),a(aa),a(V),a(sa),a(la),a(R),a(ia),a(pa),a(W),a(ca),a(da),a(z),a(ma),a(ua),a(Y),a(ga),a(fa),a(Q),a(ha),a(_a),a(en),a(ba),a(ya),a(L),a(Ma),a(va),a(B),a(Na),a(wa),a(P),a(Ta),a($a),a(mn),a(ja),a(ka),a(G),a(Ca),a(Ja),a(E),a(xa),a(Ua),a(D),a(Fa),a(Ia),a(q),a(Za),a(Xa),a(jn),a(Sa),a(Va),a(ke),a(Ra),a(Wa),a(Ce),a(za),a(La),a(Je),a(Ba),a(Pa),a(xe),a(Ga),a(Ea),a(Ue),a(Da),a(qa),a(Fe),a(Ha),a(Ya),a(Ie),a(Qa),a(Aa),a(Ze),a(Oa),a(Ka),a(Xe),a(es),a(ts),a(Se),a(ns),a(Dr)),a(l),_(M,e),_(v,e),_(_t,e),_(yt),_(Mt),_(vt),_(Nt),_(wt),_(Tt,e),_(jt,e),_(kt),_(Ct),_(qe),_(Jt,e),_(xt),_(Ut),_(He),_(Ye),_(Ft,e),_(It),_(Zt),_(Qe),_(Xt,e),_(St),_(Vt),_(Ae),_(Rt,e),_(Wt),_(zt),_(Oe),_(Lt,e),_(Bt),_(Pt),_(Ke),_(Gt,e),_(Et),_(Dt),_(et),_(qt,e),_(Ht),_(Yt),_(Qt,e),_(At),_(Ot),_(nt),_(ot),_(rt),_(Kt,e),_(tn,e),_(nn),_(on),_(at),_(rn,e),_(an),_(sn),_(st),_(ln,e),_(pn),_(cn),_(lt),_(dn,e),_(un,e),_(gn),_(fn),_(it),_(hn,e),_(_n),_(bn),_(pt),_(yn,e),_(Mn),_(vn),_(ct),_(dt),_(Nn,e),_(wn),_(Tn),_(mt),_($n,e),_(kn,e),_(Cn),_(Jn),_(xn,e),_(Un),_(Fn),_(In,e),_(Zn),_(Xn),_(Sn,e),_(Vn),_(Rn),_(Wn,e),_(zn),_(Ln),_(Bn,e),_(Pn),_(Gn),_(En,e),_(Dn),_(qn),_(Hn,e),_(Yn),_(Qn),_(An,e),_(On),_(Kn),_(eo,e),_(to),_(no)}}}const Bc='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"NeuronTracedModel","local":"optimum.neuron.NeuronTracedModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"NeuronModelForFeatureExtraction","local":"optimum.neuron.NeuronModelForFeatureExtraction","sections":[],"depth":3},{"title":"NeuronModelForSentenceTransformers","local":"optimum.neuron.NeuronModelForSentenceTransformers","sections":[],"depth":3},{"title":"NeuronModelForMaskedLM","local":"optimum.neuron.NeuronModelForMaskedLM","sections":[],"depth":3},{"title":"NeuronModelForSequenceClassification","local":"optimum.neuron.NeuronModelForSequenceClassification","sections":[],"depth":3},{"title":"NeuronModelForQuestionAnswering","local":"optimum.neuron.NeuronModelForQuestionAnswering","sections":[],"depth":3},{"title":"NeuronModelForTokenClassification","local":"optimum.neuron.NeuronModelForTokenClassification","sections":[],"depth":3},{"title":"NeuronModelForMultipleChoice","local":"optimum.neuron.NeuronModelForMultipleChoice","sections":[],"depth":3},{"title":"NeuronModelForCausalLM","local":"optimum.neuron.NeuronModelForCausalLM","sections":[],"depth":3},{"title":"NeuronModelForSeq2SeqLM","local":"optimum.neuron.NeuronModelForSeq2SeqLM","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"NeuronModelForImageClassification","local":"optimum.neuron.NeuronModelForImageClassification","sections":[],"depth":3},{"title":"NeuronModelForSemanticSegmentation","local":"optimum.neuron.NeuronModelForSemanticSegmentation","sections":[],"depth":3},{"title":"NeuronModelForObjectDetection","local":"optimum.neuron.NeuronModelForObjectDetection","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"NeuronModelForAudioClassification","local":"optimum.neuron.NeuronModelForAudioClassification","sections":[],"depth":3},{"title":"NeuronModelForAudioFrameClassification","local":"optimum.neuron.NeuronModelForAudioFrameClassification","sections":[],"depth":3},{"title":"NeuronModelForCTC","local":"optimum.neuron.NeuronModelForCTC","sections":[],"depth":3},{"title":"NeuronModelForXVector","local":"optimum.neuron.NeuronModelForXVector","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"NeuronStableDiffusionPipeline","local":"optimum.neuron.NeuronStableDiffusionPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionImg2ImgPipeline","local":"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionInpaintPipeline","local":"optimum.neuron.NeuronStableDiffusionInpaintPipeline","sections":[],"depth":3},{"title":"NeuronLatentConsistencyModelPipeline","local":"optimum.neuron.NeuronLatentConsistencyModelPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionControlNetPipeline","local":"optimum.neuron.NeuronStableDiffusionControlNetPipeline","sections":[],"depth":3},{"title":"NeuronPixArtAlphaPipeline","local":"optimum.neuron.NeuronPixArtAlphaPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLPipeline","local":"optimum.neuron.NeuronStableDiffusionXLPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLImg2ImgPipeline","local":"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLInpaintPipeline","local":"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLControlNetPipeline","local":"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline","sections":[],"depth":3}],"depth":2}],"depth":1}';function Pc(j){return _c(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ac extends bc{constructor(l){super(),yc(this,l,Pc,Lc,hc,{})}}export{Ac as component};
