import{s as la,o as ia,n as er}from"../chunks/scheduler.9991993c.js";import{S as da,i as ca,g as n,s as o,r as p,A as ma,h as l,f as t,c as a,j as $,u as f,x as d,k as b,y as s,a as i,v as u,d as h,t as g,w as _}from"../chunks/index.7fc9a5e7.js";import{T as ao}from"../chunks/Tip.9de92fc6.js";import{D as M}from"../chunks/Docstring.8180f571.js";import{C as rr}from"../chunks/CodeBlock.e11cba92.js";import{E as no}from"../chunks/ExampleCodeBlock.a03fccd6.js";import{H as pe}from"../chunks/Heading.e3de321f.js";function pa(J){let c,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/v4.39.1/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/v4.39.1/zh/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=n("p"),c.innerHTML=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1m5uk97"&&(c.innerHTML=T)},m(v,x){i(v,c,x)},p:er,d(v){v&&t(c)}}}function fa(J){let c,T="Examples:",v,x,C;return x=new rr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBQdXNoJTIwdGhlJTIwcHJvY2Vzc29yJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLWJlcnQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24lMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyLiUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=o(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,I){i(m,c,I),i(m,v,I),u(x,m,I),C=!0},p:er,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function ua(J){let c,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){c=n("p"),c.textContent=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-15rpg4"&&(c.textContent=T)},m(v,x){i(v,c,x)},p:er,d(v){v&&t(c)}}}function ha(J){let c,T=`This class method is simply calling <a href="/docs/transformers/v4.39.1/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.39.1/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=n("p"),c.innerHTML=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1shkd06"&&(c.innerHTML=T)},m(v,x){i(v,c,x)},p:er,d(v){v&&t(c)}}}function ga(J){let c,T="Examples:",v,x,C;return x=new rr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=o(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,I){i(m,c,I),i(m,v,I),u(x,m,I),C=!0},p:er,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function _a(J){let c,T="Example:",v,x,C;return x=new rr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=o(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=T),v=a(m),f(x.$$.fragment,m)},m(m,I){i(m,c,I),i(m,v,I),u(x,m,I),C=!0},p:er,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function va(J){let c,T,v,x,C,m,I,lo="在 Transformers 库中，processors可以有两种不同的含义：",sr,fe,io='<li>为多模态模型，例如<a href="../model_doc/wav2vec2">Wav2Vec2</a>（语音和文本）或<a href="../model_doc/clip">CLIP</a>（文本和视觉）预处理输入的对象</li> <li>在库的旧版本中用于预处理GLUE或SQUAD数据的已弃用对象。</li>',or,ue,ar,he,co="任何多模态模型都需要一个对象来编码或解码将多个模态（包括文本、视觉和音频）组合在一起的数据。这由称为processors的对象处理，这些processors将两个或多个处理对象组合在一起，例如tokenizers（用于文本模态），image processors（用于视觉）和feature extractors（用于音频）。",nr,ge,mo="这些processors继承自以下实现保存和加载功能的基类：",lr,y,_e,ns,yt,po="This is a mixin used to provide saving/loading functionality for all processor classes.",ls,D,ve,is,Mt,fo="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",ds,j,xe,cs,wt,uo="Instantiate a processor associated with a pretrained model.",ms,R,ps,G,$e,fs,Tt,ho=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,us,z,be,hs,Ct,go="Upload the processor files to the 🤗 Model Hub.",gs,W,_s,V,ye,vs,Pt,_o=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,xs,Q,$s,q,Me,bs,It,vo=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/v4.39.1/zh/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,ys,Y,Ms,A,we,ws,Xt,xo="Serializes this instance to a Python dictionary.",Ts,O,Te,Cs,kt,$o="Save this instance to a JSON file.",Ps,K,Ce,Is,Jt,bo="Serializes this instance to a JSON string.",ir,Pe,dr,Ie,yo='所有processor都遵循与 <a href="/docs/transformers/v4.39.1/zh/main_classes/processors#transformers.DataProcessor">DataProcessor</a> 相同的架构。processor返回一个 <a href="/docs/transformers/v4.39.1/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。这些 <a href="/docs/transformers/v4.39.1/zh/main_classes/processors#transformers.InputExample">InputExample</a> 可以转换为 <a href="/docs/transformers/v4.39.1/zh/main_classes/processors#transformers.InputFeatures">InputFeatures</a> 以供输送到模型。',cr,P,Xe,Xs,Ut,Mo="Base class for data converters for sequence classification data sets.",ks,ee,ke,Js,Zt,wo='Gets a collection of <a href="/docs/transformers/v4.39.1/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Us,te,Je,Zs,Lt,To="Gets an example from a dict with tensorflow tensors.",Ls,re,Ue,js,jt,Co="Gets the list of labels for this data set.",zs,se,Ze,Vs,zt,Po='Gets a collection of <a href="/docs/transformers/v4.39.1/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',qs,oe,Le,Es,Vt,Io='Gets a collection of <a href="/docs/transformers/v4.39.1/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Hs,ae,je,Ns,qt,Xo=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,mr,U,ze,Bs,Et,ko="A single training/test example for simple sequence classification.",Fs,ne,Ve,Ss,Ht,Jo="Serializes this instance to a JSON string.",pr,Z,qe,Ds,Nt,Uo="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",Rs,le,Ee,Gs,Bt,Zo="Serializes this instance to a JSON string.",fr,He,ur,Ne,Lo='<a href="https://gluebenchmark.com/" rel="nofollow">General Language Understanding Evaluation (GLUE)</a> 是一个基准测试，评估模型在各种现有的自然语言理解任务上的性能。它与论文 <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A multi-task benchmark and analysis platform for natural language understanding</a> 一同发布。',hr,Be,jo="该库为以下任务提供了总共10个processor：MRPC、MNLI、MNLI（mismatched）、CoLA、SST2、STSB、QQP、QNLI、RTE 和 WNLI。",gr,Fe,zo="这些processor是：",_r,Se,Vo="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",vr,De,qo='此外，还可以使用以下方法从数据文件加载值并将其转换为 <a href="/docs/transformers/v4.39.1/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。',xr,N,Re,Ws,Ft,Eo="Loads a data file into a list of <code>InputFeatures</code>",$r,Ge,br,We,Ho='<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">跨语言NLI语料库（XNLI）</a> 是一个评估跨语言文本表示质量的基准测试。XNLI是一个基于<a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a>的众包数据集：”文本对“被标记为包含15种不同语言（包括英语等高资源语言和斯瓦希里语等低资源语言）的文本蕴涵注释。',yr,Qe,No='它与论文 <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a> 一同发布。',Mr,Ye,Bo="该库提供了加载XNLI数据的processor：",wr,Ae,Fo="<li><code>~data.processors.utils.XnliProcessor</code></li>",Tr,Oe,So="请注意，由于测试集上有“gold”标签，因此评估是在测试集上进行的。",Cr,Ke,Do='使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> 脚本中提供。',Pr,et,Ir,tt,Ro='<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">斯坦福问答数据集（SQuAD）</a> 是一个评估模型在问答上性能的基准测试。有两个版本，v1.1 和 v2.0。第一个版本（v1.1）与论文 <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ Questions for Machine Comprehension of Text</a> 一同发布。第二个版本（v2.0）与论文 <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t Know: Unanswerable Questions for SQuAD</a> 一同发布。',Xr,rt,Go="该库为两个版本各自提供了一个processor：",kr,st,Jr,ot,Wo="这两个processor是：",Ur,at,Qo="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",Zr,nt,Yo="它们都继承自抽象类 <code>~data.processors.utils.SquadProcessor</code>。",Lr,k,lt,Qs,St,Ao=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,Ys,ie,it,As,Dt,Oo="Returns the evaluation example from the data directory.",Os,E,dt,Ks,Rt,Ko="Creates a list of <code>SquadExample</code> using a TFDS dataset.",eo,de,to,ce,ct,ro,Gt,ea="Returns the training examples from the data directory.",jr,mt,ta="此外，可以使用以下方法将 SQuAD 示例转换为可用作模型输入的 <code>~data.processors.utils.SquadFeatures</code>。",zr,L,pt,so,Wt,ra=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,oo,me,Vr,ft,sa="这些processor以及前面提到的方法可以与包含数据的文件以及tensorflow_datasets包一起使用。下面给出了示例。",qr,ut,Er,ht,oa="以下是使用processor以及使用数据文件的转换方法的示例：",Hr,gt,Nr,_t,aa="使用 <em>tensorflow_datasets</em> 就像使用数据文件一样简单：",Br,vt,Fr,xt,na='另一个使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> 脚本中提供。',Sr,tr,Dr;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"多模态processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/processing_utils.py#L56"}}),ve=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/processing_utils.py#L365",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),xe=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.39.1/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/v4.39.1/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/processing_utils.py#L406"}}),R=new ao({props:{$$slots:{default:[pa]},$$scope:{ctx:J}}}),$e=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/processing_utils.py#L256",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),be=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/utils/hub.py#L768"}}),W=new no({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[fa]},$$scope:{ctx:J}}}),ye=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/processing_utils.py#L470"}}),Q=new ao({props:{warning:!0,$$slots:{default:[ua]},$$scope:{ctx:J}}}),Me=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.39.1/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/processing_utils.py#L167"}}),Y=new ao({props:{$$slots:{default:[ha]},$$scope:{ctx:J}}}),we=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/processing_utils.py#L102",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Te=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/processing_utils.py#L151"}}),Ce=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/processing_utils.py#L140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Pe=new pe({props:{title:"已弃用的processors",local:"transformers.DataProcessor",headingTag:"h2"}}),Xe=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L80"}}),ke=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L97"}}),Je=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L83"}}),Ue=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L105"}}),Ze=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L101"}}),Le=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L93"}}),je=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L109"}}),ze=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L29"}}),Ve=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L49"}}),qe=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L54"}}),Ee=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/utils.py#L75"}}),He=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Re=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),Ge=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),et=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),st=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),lt=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/squad.py#L541"}}),it=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/squad.py#L629"}}),dt=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),de=new no({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[ga]},$$scope:{ctx:J}}}),ct=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/squad.py#L607"}}),pt=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/v4.39.1/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),me=new no({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[_a]},$$scope:{ctx:J}}}),ut=new pe({props:{title:"Example使用",local:"example使用",headingTag:"h3"}}),gt=new rr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),vt=new rr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=n("meta"),T=o(),v=n("p"),x=o(),p(C.$$.fragment),m=o(),I=n("p"),I.textContent=lo,sr=o(),fe=n("ul"),fe.innerHTML=io,or=o(),p(ue.$$.fragment),ar=o(),he=n("p"),he.textContent=co,nr=o(),ge=n("p"),ge.textContent=mo,lr=o(),y=n("div"),p(_e.$$.fragment),ns=o(),yt=n("p"),yt.textContent=po,ls=o(),D=n("div"),p(ve.$$.fragment),is=o(),Mt=n("p"),Mt.innerHTML=fo,ds=o(),j=n("div"),p(xe.$$.fragment),cs=o(),wt=n("p"),wt.textContent=uo,ms=o(),p(R.$$.fragment),ps=o(),G=n("div"),p($e.$$.fragment),fs=o(),Tt=n("p"),Tt.innerHTML=ho,us=o(),z=n("div"),p(be.$$.fragment),hs=o(),Ct=n("p"),Ct.textContent=go,gs=o(),p(W.$$.fragment),_s=o(),V=n("div"),p(ye.$$.fragment),vs=o(),Pt=n("p"),Pt.innerHTML=_o,xs=o(),p(Q.$$.fragment),$s=o(),q=n("div"),p(Me.$$.fragment),bs=o(),It=n("p"),It.innerHTML=vo,ys=o(),p(Y.$$.fragment),Ms=o(),A=n("div"),p(we.$$.fragment),ws=o(),Xt=n("p"),Xt.textContent=xo,Ts=o(),O=n("div"),p(Te.$$.fragment),Cs=o(),kt=n("p"),kt.textContent=$o,Ps=o(),K=n("div"),p(Ce.$$.fragment),Is=o(),Jt=n("p"),Jt.textContent=bo,ir=o(),p(Pe.$$.fragment),dr=o(),Ie=n("p"),Ie.innerHTML=yo,cr=o(),P=n("div"),p(Xe.$$.fragment),Xs=o(),Ut=n("p"),Ut.textContent=Mo,ks=o(),ee=n("div"),p(ke.$$.fragment),Js=o(),Zt=n("p"),Zt.innerHTML=wo,Us=o(),te=n("div"),p(Je.$$.fragment),Zs=o(),Lt=n("p"),Lt.textContent=To,Ls=o(),re=n("div"),p(Ue.$$.fragment),js=o(),jt=n("p"),jt.textContent=Co,zs=o(),se=n("div"),p(Ze.$$.fragment),Vs=o(),zt=n("p"),zt.innerHTML=Po,qs=o(),oe=n("div"),p(Le.$$.fragment),Es=o(),Vt=n("p"),Vt.innerHTML=Io,Hs=o(),ae=n("div"),p(je.$$.fragment),Ns=o(),qt=n("p"),qt.textContent=Xo,mr=o(),U=n("div"),p(ze.$$.fragment),Bs=o(),Et=n("p"),Et.textContent=ko,Fs=o(),ne=n("div"),p(Ve.$$.fragment),Ss=o(),Ht=n("p"),Ht.textContent=Jo,pr=o(),Z=n("div"),p(qe.$$.fragment),Ds=o(),Nt=n("p"),Nt.textContent=Uo,Rs=o(),le=n("div"),p(Ee.$$.fragment),Gs=o(),Bt=n("p"),Bt.textContent=Zo,fr=o(),p(He.$$.fragment),ur=o(),Ne=n("p"),Ne.innerHTML=Lo,hr=o(),Be=n("p"),Be.textContent=jo,gr=o(),Fe=n("p"),Fe.textContent=zo,_r=o(),Se=n("ul"),Se.innerHTML=Vo,vr=o(),De=n("p"),De.innerHTML=qo,xr=o(),N=n("div"),p(Re.$$.fragment),Ws=o(),Ft=n("p"),Ft.innerHTML=Eo,$r=o(),p(Ge.$$.fragment),br=o(),We=n("p"),We.innerHTML=Ho,yr=o(),Qe=n("p"),Qe.innerHTML=No,Mr=o(),Ye=n("p"),Ye.textContent=Bo,wr=o(),Ae=n("ul"),Ae.innerHTML=Fo,Tr=o(),Oe=n("p"),Oe.textContent=So,Cr=o(),Ke=n("p"),Ke.innerHTML=Do,Pr=o(),p(et.$$.fragment),Ir=o(),tt=n("p"),tt.innerHTML=Ro,Xr=o(),rt=n("p"),rt.textContent=Go,kr=o(),p(st.$$.fragment),Jr=o(),ot=n("p"),ot.textContent=Wo,Ur=o(),at=n("ul"),at.innerHTML=Qo,Zr=o(),nt=n("p"),nt.innerHTML=Yo,Lr=o(),k=n("div"),p(lt.$$.fragment),Qs=o(),St=n("p"),St.textContent=Ao,Ys=o(),ie=n("div"),p(it.$$.fragment),As=o(),Dt=n("p"),Dt.textContent=Oo,Os=o(),E=n("div"),p(dt.$$.fragment),Ks=o(),Rt=n("p"),Rt.innerHTML=Ko,eo=o(),p(de.$$.fragment),to=o(),ce=n("div"),p(ct.$$.fragment),ro=o(),Gt=n("p"),Gt.textContent=ea,jr=o(),mt=n("p"),mt.innerHTML=ta,zr=o(),L=n("div"),p(pt.$$.fragment),so=o(),Wt=n("p"),Wt.textContent=ra,oo=o(),p(me.$$.fragment),Vr=o(),ft=n("p"),ft.textContent=sa,qr=o(),p(ut.$$.fragment),Er=o(),ht=n("p"),ht.textContent=oa,Hr=o(),p(gt.$$.fragment),Nr=o(),_t=n("p"),_t.innerHTML=aa,Br=o(),p(vt.$$.fragment),Fr=o(),xt=n("p"),xt.innerHTML=na,Sr=o(),tr=n("p"),this.h()},l(e){const r=ma("svelte-u9bgzb",document.head);c=l(r,"META",{name:!0,content:!0}),r.forEach(t),T=a(e),v=l(e,"P",{}),$(v).forEach(t),x=a(e),f(C.$$.fragment,e),m=a(e),I=l(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1fd9lf0"&&(I.textContent=lo),sr=a(e),fe=l(e,"UL",{"data-svelte-h":!0}),d(fe)!=="svelte-rmvfpp"&&(fe.innerHTML=io),or=a(e),f(ue.$$.fragment,e),ar=a(e),he=l(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-ctzpmo"&&(he.textContent=co),nr=a(e),ge=l(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-9fh2y4"&&(ge.textContent=mo),lr=a(e),y=l(e,"DIV",{class:!0});var w=$(y);f(_e.$$.fragment,w),ns=a(w),yt=l(w,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1s4wckx"&&(yt.textContent=po),ls=a(w),D=l(w,"DIV",{class:!0});var $t=$(D);f(ve.$$.fragment,$t),is=a($t),Mt=l($t,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1i2d3vx"&&(Mt.innerHTML=fo),$t.forEach(t),ds=a(w),j=l(w,"DIV",{class:!0});var B=$(j);f(xe.$$.fragment,B),cs=a(B),wt=l(B,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1cj8dcb"&&(wt.textContent=uo),ms=a(B),f(R.$$.fragment,B),B.forEach(t),ps=a(w),G=l(w,"DIV",{class:!0});var bt=$(G);f($e.$$.fragment,bt),fs=a(bt),Tt=l(bt,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-hsvutq"&&(Tt.innerHTML=ho),bt.forEach(t),us=a(w),z=l(w,"DIV",{class:!0});var F=$(z);f(be.$$.fragment,F),hs=a(F),Ct=l(F,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-1cwsjho"&&(Ct.textContent=go),gs=a(F),f(W.$$.fragment,F),F.forEach(t),_s=a(w),V=l(w,"DIV",{class:!0});var S=$(V);f(ye.$$.fragment,S),vs=a(S),Pt=l(S,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-hhsvto"&&(Pt.innerHTML=_o),xs=a(S),f(Q.$$.fragment,S),S.forEach(t),$s=a(w),q=l(w,"DIV",{class:!0});var Qt=$(q);f(Me.$$.fragment,Qt),bs=a(Qt),It=l(Qt,"P",{"data-svelte-h":!0}),d(It)!=="svelte-12j9yee"&&(It.innerHTML=vo),ys=a(Qt),f(Y.$$.fragment,Qt),Qt.forEach(t),Ms=a(w),A=l(w,"DIV",{class:!0});var Rr=$(A);f(we.$$.fragment,Rr),ws=a(Rr),Xt=l(Rr,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1ww3wqq"&&(Xt.textContent=xo),Rr.forEach(t),Ts=a(w),O=l(w,"DIV",{class:!0});var Gr=$(O);f(Te.$$.fragment,Gr),Cs=a(Gr),kt=l(Gr,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1g70y32"&&(kt.textContent=$o),Gr.forEach(t),Ps=a(w),K=l(w,"DIV",{class:!0});var Wr=$(K);f(Ce.$$.fragment,Wr),Is=a(Wr),Jt=l(Wr,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-5ayq1f"&&(Jt.textContent=bo),Wr.forEach(t),w.forEach(t),ir=a(e),f(Pe.$$.fragment,e),dr=a(e),Ie=l(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1avbe6q"&&(Ie.innerHTML=yo),cr=a(e),P=l(e,"DIV",{class:!0});var X=$(P);f(Xe.$$.fragment,X),Xs=a(X),Ut=l(X,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1bsw04k"&&(Ut.textContent=Mo),ks=a(X),ee=l(X,"DIV",{class:!0});var Qr=$(ee);f(ke.$$.fragment,Qr),Js=a(Qr),Zt=l(Qr,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-46uevp"&&(Zt.innerHTML=wo),Qr.forEach(t),Us=a(X),te=l(X,"DIV",{class:!0});var Yr=$(te);f(Je.$$.fragment,Yr),Zs=a(Yr),Lt=l(Yr,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-pplryq"&&(Lt.textContent=To),Yr.forEach(t),Ls=a(X),re=l(X,"DIV",{class:!0});var Ar=$(re);f(Ue.$$.fragment,Ar),js=a(Ar),jt=l(Ar,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-3oqyjr"&&(jt.textContent=Co),Ar.forEach(t),zs=a(X),se=l(X,"DIV",{class:!0});var Or=$(se);f(Ze.$$.fragment,Or),Vs=a(Or),zt=l(Or,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-i10njk"&&(zt.innerHTML=Po),Or.forEach(t),qs=a(X),oe=l(X,"DIV",{class:!0});var Kr=$(oe);f(Le.$$.fragment,Kr),Es=a(Kr),Vt=l(Kr,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-1ha5z9y"&&(Vt.innerHTML=Io),Kr.forEach(t),Hs=a(X),ae=l(X,"DIV",{class:!0});var es=$(ae);f(je.$$.fragment,es),Ns=a(es),qt=l(es,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-1jevh15"&&(qt.textContent=Xo),es.forEach(t),X.forEach(t),mr=a(e),U=l(e,"DIV",{class:!0});var Yt=$(U);f(ze.$$.fragment,Yt),Bs=a(Yt),Et=l(Yt,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-vkt0pi"&&(Et.textContent=ko),Fs=a(Yt),ne=l(Yt,"DIV",{class:!0});var ts=$(ne);f(Ve.$$.fragment,ts),Ss=a(ts),Ht=l(ts,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-5ayq1f"&&(Ht.textContent=Jo),ts.forEach(t),Yt.forEach(t),pr=a(e),Z=l(e,"DIV",{class:!0});var At=$(Z);f(qe.$$.fragment,At),Ds=a(At),Nt=l(At,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-168wf64"&&(Nt.textContent=Uo),Rs=a(At),le=l(At,"DIV",{class:!0});var rs=$(le);f(Ee.$$.fragment,rs),Gs=a(rs),Bt=l(rs,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-5ayq1f"&&(Bt.textContent=Zo),rs.forEach(t),At.forEach(t),fr=a(e),f(He.$$.fragment,e),ur=a(e),Ne=l(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-pf4p60"&&(Ne.innerHTML=Lo),hr=a(e),Be=l(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-17867sm"&&(Be.textContent=jo),gr=a(e),Fe=l(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-190jb0p"&&(Fe.textContent=zo),_r=a(e),Se=l(e,"UL",{"data-svelte-h":!0}),d(Se)!=="svelte-my8qym"&&(Se.innerHTML=Vo),vr=a(e),De=l(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-aak5df"&&(De.innerHTML=qo),xr=a(e),N=l(e,"DIV",{class:!0});var ss=$(N);f(Re.$$.fragment,ss),Ws=a(ss),Ft=l(ss,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-5lvrve"&&(Ft.innerHTML=Eo),ss.forEach(t),$r=a(e),f(Ge.$$.fragment,e),br=a(e),We=l(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-143feg"&&(We.innerHTML=Ho),yr=a(e),Qe=l(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1y5f8bi"&&(Qe.innerHTML=No),Mr=a(e),Ye=l(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1n6xg4v"&&(Ye.textContent=Bo),wr=a(e),Ae=l(e,"UL",{"data-svelte-h":!0}),d(Ae)!=="svelte-1e2xq99"&&(Ae.innerHTML=Fo),Tr=a(e),Oe=l(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1514ut0"&&(Oe.textContent=So),Cr=a(e),Ke=l(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-18t4sjl"&&(Ke.innerHTML=Do),Pr=a(e),f(et.$$.fragment,e),Ir=a(e),tt=l(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1cqsmed"&&(tt.innerHTML=Ro),Xr=a(e),rt=l(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1hd0jdd"&&(rt.textContent=Go),kr=a(e),f(st.$$.fragment,e),Jr=a(e),ot=l(e,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-utkcp6"&&(ot.textContent=Wo),Ur=a(e),at=l(e,"UL",{"data-svelte-h":!0}),d(at)!=="svelte-1qiv3qf"&&(at.innerHTML=Qo),Zr=a(e),nt=l(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-165sa1k"&&(nt.innerHTML=Yo),Lr=a(e),k=l(e,"DIV",{class:!0});var H=$(k);f(lt.$$.fragment,H),Qs=a(H),St=l(H,"P",{"data-svelte-h":!0}),d(St)!=="svelte-173gxyd"&&(St.textContent=Ao),Ys=a(H),ie=l(H,"DIV",{class:!0});var os=$(ie);f(it.$$.fragment,os),As=a(os),Dt=l(os,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-wmaktk"&&(Dt.textContent=Oo),os.forEach(t),Os=a(H),E=l(H,"DIV",{class:!0});var Ot=$(E);f(dt.$$.fragment,Ot),Ks=a(Ot),Rt=l(Ot,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-11nqnea"&&(Rt.innerHTML=Ko),eo=a(Ot),f(de.$$.fragment,Ot),Ot.forEach(t),to=a(H),ce=l(H,"DIV",{class:!0});var as=$(ce);f(ct.$$.fragment,as),ro=a(as),Gt=l(as,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-d5zv1x"&&(Gt.textContent=ea),as.forEach(t),H.forEach(t),jr=a(e),mt=l(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-7uap0d"&&(mt.innerHTML=ta),zr=a(e),L=l(e,"DIV",{class:!0});var Kt=$(L);f(pt.$$.fragment,Kt),so=a(Kt),Wt=l(Kt,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-169nh0g"&&(Wt.textContent=ra),oo=a(Kt),f(me.$$.fragment,Kt),Kt.forEach(t),Vr=a(e),ft=l(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1dp3thd"&&(ft.textContent=sa),qr=a(e),f(ut.$$.fragment,e),Er=a(e),ht=l(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1tuty7g"&&(ht.textContent=oa),Hr=a(e),f(gt.$$.fragment,e),Nr=a(e),_t=l(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-1klp1tb"&&(_t.innerHTML=aa),Br=a(e),f(vt.$$.fragment,e),Fr=a(e),xt=l(e,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-1mzejoo"&&(xt.innerHTML=na),Sr=a(e),tr=l(e,"P",{}),$(tr).forEach(t),this.h()},h(){b(c,"name","hf:doc:metadata"),b(c,"content",xa),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){s(document.head,c),i(e,T,r),i(e,v,r),i(e,x,r),u(C,e,r),i(e,m,r),i(e,I,r),i(e,sr,r),i(e,fe,r),i(e,or,r),u(ue,e,r),i(e,ar,r),i(e,he,r),i(e,nr,r),i(e,ge,r),i(e,lr,r),i(e,y,r),u(_e,y,null),s(y,ns),s(y,yt),s(y,ls),s(y,D),u(ve,D,null),s(D,is),s(D,Mt),s(y,ds),s(y,j),u(xe,j,null),s(j,cs),s(j,wt),s(j,ms),u(R,j,null),s(y,ps),s(y,G),u($e,G,null),s(G,fs),s(G,Tt),s(y,us),s(y,z),u(be,z,null),s(z,hs),s(z,Ct),s(z,gs),u(W,z,null),s(y,_s),s(y,V),u(ye,V,null),s(V,vs),s(V,Pt),s(V,xs),u(Q,V,null),s(y,$s),s(y,q),u(Me,q,null),s(q,bs),s(q,It),s(q,ys),u(Y,q,null),s(y,Ms),s(y,A),u(we,A,null),s(A,ws),s(A,Xt),s(y,Ts),s(y,O),u(Te,O,null),s(O,Cs),s(O,kt),s(y,Ps),s(y,K),u(Ce,K,null),s(K,Is),s(K,Jt),i(e,ir,r),u(Pe,e,r),i(e,dr,r),i(e,Ie,r),i(e,cr,r),i(e,P,r),u(Xe,P,null),s(P,Xs),s(P,Ut),s(P,ks),s(P,ee),u(ke,ee,null),s(ee,Js),s(ee,Zt),s(P,Us),s(P,te),u(Je,te,null),s(te,Zs),s(te,Lt),s(P,Ls),s(P,re),u(Ue,re,null),s(re,js),s(re,jt),s(P,zs),s(P,se),u(Ze,se,null),s(se,Vs),s(se,zt),s(P,qs),s(P,oe),u(Le,oe,null),s(oe,Es),s(oe,Vt),s(P,Hs),s(P,ae),u(je,ae,null),s(ae,Ns),s(ae,qt),i(e,mr,r),i(e,U,r),u(ze,U,null),s(U,Bs),s(U,Et),s(U,Fs),s(U,ne),u(Ve,ne,null),s(ne,Ss),s(ne,Ht),i(e,pr,r),i(e,Z,r),u(qe,Z,null),s(Z,Ds),s(Z,Nt),s(Z,Rs),s(Z,le),u(Ee,le,null),s(le,Gs),s(le,Bt),i(e,fr,r),u(He,e,r),i(e,ur,r),i(e,Ne,r),i(e,hr,r),i(e,Be,r),i(e,gr,r),i(e,Fe,r),i(e,_r,r),i(e,Se,r),i(e,vr,r),i(e,De,r),i(e,xr,r),i(e,N,r),u(Re,N,null),s(N,Ws),s(N,Ft),i(e,$r,r),u(Ge,e,r),i(e,br,r),i(e,We,r),i(e,yr,r),i(e,Qe,r),i(e,Mr,r),i(e,Ye,r),i(e,wr,r),i(e,Ae,r),i(e,Tr,r),i(e,Oe,r),i(e,Cr,r),i(e,Ke,r),i(e,Pr,r),u(et,e,r),i(e,Ir,r),i(e,tt,r),i(e,Xr,r),i(e,rt,r),i(e,kr,r),u(st,e,r),i(e,Jr,r),i(e,ot,r),i(e,Ur,r),i(e,at,r),i(e,Zr,r),i(e,nt,r),i(e,Lr,r),i(e,k,r),u(lt,k,null),s(k,Qs),s(k,St),s(k,Ys),s(k,ie),u(it,ie,null),s(ie,As),s(ie,Dt),s(k,Os),s(k,E),u(dt,E,null),s(E,Ks),s(E,Rt),s(E,eo),u(de,E,null),s(k,to),s(k,ce),u(ct,ce,null),s(ce,ro),s(ce,Gt),i(e,jr,r),i(e,mt,r),i(e,zr,r),i(e,L,r),u(pt,L,null),s(L,so),s(L,Wt),s(L,oo),u(me,L,null),i(e,Vr,r),i(e,ft,r),i(e,qr,r),u(ut,e,r),i(e,Er,r),i(e,ht,r),i(e,Hr,r),u(gt,e,r),i(e,Nr,r),i(e,_t,r),i(e,Br,r),u(vt,e,r),i(e,Fr,r),i(e,xt,r),i(e,Sr,r),i(e,tr,r),Dr=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),R.$set(w);const $t={};r&2&&($t.$$scope={dirty:r,ctx:e}),W.$set($t);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),Q.$set(B);const bt={};r&2&&(bt.$$scope={dirty:r,ctx:e}),Y.$set(bt);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),de.$set(F);const S={};r&2&&(S.$$scope={dirty:r,ctx:e}),me.$set(S)},i(e){Dr||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(R.$$.fragment,e),h($e.$$.fragment,e),h(be.$$.fragment,e),h(W.$$.fragment,e),h(ye.$$.fragment,e),h(Q.$$.fragment,e),h(Me.$$.fragment,e),h(Y.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(Xe.$$.fragment,e),h(ke.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(Ze.$$.fragment,e),h(Le.$$.fragment,e),h(je.$$.fragment,e),h(ze.$$.fragment,e),h(Ve.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Re.$$.fragment,e),h(Ge.$$.fragment,e),h(et.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(de.$$.fragment,e),h(ct.$$.fragment,e),h(pt.$$.fragment,e),h(me.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),Dr=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(R.$$.fragment,e),g($e.$$.fragment,e),g(be.$$.fragment,e),g(W.$$.fragment,e),g(ye.$$.fragment,e),g(Q.$$.fragment,e),g(Me.$$.fragment,e),g(Y.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(Xe.$$.fragment,e),g(ke.$$.fragment,e),g(Je.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),g(Le.$$.fragment,e),g(je.$$.fragment,e),g(ze.$$.fragment,e),g(Ve.$$.fragment,e),g(qe.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Re.$$.fragment,e),g(Ge.$$.fragment,e),g(et.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(de.$$.fragment,e),g(ct.$$.fragment,e),g(pt.$$.fragment,e),g(me.$$.fragment,e),g(ut.$$.fragment,e),g(gt.$$.fragment,e),g(vt.$$.fragment,e),Dr=!1},d(e){e&&(t(T),t(v),t(x),t(m),t(I),t(sr),t(fe),t(or),t(ar),t(he),t(nr),t(ge),t(lr),t(y),t(ir),t(dr),t(Ie),t(cr),t(P),t(mr),t(U),t(pr),t(Z),t(fr),t(ur),t(Ne),t(hr),t(Be),t(gr),t(Fe),t(_r),t(Se),t(vr),t(De),t(xr),t(N),t($r),t(br),t(We),t(yr),t(Qe),t(Mr),t(Ye),t(wr),t(Ae),t(Tr),t(Oe),t(Cr),t(Ke),t(Pr),t(Ir),t(tt),t(Xr),t(rt),t(kr),t(Jr),t(ot),t(Ur),t(at),t(Zr),t(nt),t(Lr),t(k),t(jr),t(mt),t(zr),t(L),t(Vr),t(ft),t(qr),t(Er),t(ht),t(Hr),t(Nr),t(_t),t(Br),t(Fr),t(xt),t(Sr),t(tr)),t(c),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_(R),_($e),_(be),_(W),_(ye),_(Q),_(Me),_(Y),_(we),_(Te),_(Ce),_(Pe,e),_(Xe),_(ke),_(Je),_(Ue),_(Ze),_(Le),_(je),_(ze),_(Ve),_(qe),_(Ee),_(He,e),_(Re),_(Ge,e),_(et,e),_(st,e),_(lt),_(it),_(dt),_(de),_(ct),_(pt),_(me),_(ut,e),_(gt,e),_(vt,e)}}}const xa='{"title":"Processors","local":"processors","sections":[{"title":"多模态processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"已弃用的processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example使用","local":"example使用","sections":[],"depth":3}],"depth":2}],"depth":1}';function $a(J){return ia(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ia extends da{constructor(c){super(),ca(this,c,$a,va,la,{})}}export{Ia as component};
