import{s as Ma,n as ya,o as wa}from"../chunks/scheduler.9039eef2.js";import{S as Oa,i as Ja,g as r,s as o,r as m,A as ja,h as s,f as t,c as l,j as v,u as h,x as p,k as b,y as n,a as i,v as g,d as u,t as _,w as f}from"../chunks/index.ded8f90d.js";import{D as M}from"../chunks/Docstring.a2ba2b54.js";import{C as Ht}from"../chunks/CodeBlock.8580f3e8.js";import{H as ge}from"../chunks/Heading.f027f30d.js";function $a(Wt){let J,Fe,Ne,qe,A,Ee,N,Gt='<a href="https://arxiv.org/abs/2403.07691" rel="nofollow">Odds Ratio Preference Optimization</a> (ORPO) by Jiwoo Hong, Noah Lee, and James Thorne studies the crucial role of SFT within the context of preference alignment. Using preference data the method posits that a minor penalty for the disfavored generation together with a strong adaption signal to the chosen response via a simple log odds ratio term appended to the NLL loss is sufficient for preference-aligned SFT.',Be,R,St="Thus ORPO is a reference model-free preference optimization algorithm eliminating the necessity for an additional preference alignment phase thus saving compute and memory.",Le,F,Vt='The official code can be found <a href="https://github.com/xfactlab/orpo" rel="nofollow">xfactlab/orpo</a>.',ze,q,De,E,Yt="The ORPO trainer expects a format identical to the DPO trainer, which should include three entries. These entries should be named as follows:",He,B,Qt="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",We,L,Xt="for example:",Ge,z,Se,D,Zt="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. Note that a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",Ve,H,Ye,W,Kt="The ORPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Qe,G,Xe,S,ea="For a detailed example have a look at the <code>examples/scripts/orpo.py</code> script. At a high level we need to initialize the <code>ORPOTrainer</code> with a <code>model</code> we wish to train. <strong>Note that ORPOTrainer eliminates the need to use the reference model, simplifying the optimization process.</strong> The <code>beta</code> refers to the hyperparameter <code>lambda</code> in eq. (6) of the paper and refers to the weighting of the relative odd ratio loss in the standard cross-entropy loss used for SFT.",Ze,V,Ke,Y,ta="After this one can then call:",et,Q,tt,X,at,Z,aa="While training and evaluating we record the following reward metrics:",nt,K,na="<li><p><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</p></li> <li><p><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</p></li> <li><p><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</p></li> <li><p><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</p></li> <li><p><code>log_odds_chosen</code>: the mean log odds ratio of the chosen responses over the rejected responses</p></li> <li><p><code>log_odds_ratio</code>: the mean of the <code>log(sigmoid(log_odds_chosen))</code></p></li> <li><p><code>nll_loss</code>: the mean negative log likelihood loss from the SFT part of the loss over chosen responses</p></li>",ot,ee,lt,d,te,ft,ue,oa="Initialize ORPOTrainer.",vt,j,ae,bt,_e,la=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Tt,w,ne,Mt,fe,ra="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",yt,ve,sa="We do this to avoid doing two forward passes, because it’s faster for FSDP.",wt,$,oe,Ot,be,ia="Concatenate the chosen and rejected inputs into a single tensor.",Jt,O,le,jt,Te,da=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,$t,Me,pa="Works both with or without labels.",Ct,C,re,xt,ye,ca="Compute the log probabilities of the given labels under the given logits.",It,x,se,Ut,we,ma="Compute the ORPO loss and other metrics for the given batch of inputs for train or test.",Pt,I,ie,kt,Oe,ha="Generate samples from the model and reference model for the given batch of inputs.",At,U,de,Nt,Je,ga="Log <code>logs</code> on the various objects watching training, including stored metrics.",Rt,P,pe,Ft,je,ua="Compute ORPO’s odds ratio (OR) loss for a batch of policy and reference model log probabilities.",qt,T,ce,Et,$e,_a="Tokenize a single row from a ORPO specific dataset.",Bt,Ce,fa=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Lt,xe,va=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,rt,me,st,y,he,zt,Ie,ba='ORPOConfig collects all training arguments related to the <a href="/docs/trl/v0.8.5/en/orpo_trainer#trl.ORPOTrainer">ORPOTrainer</a> class.',Dt,Ue,Ta=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,it,Re,dt;return A=new ge({props:{title:"ORPO Trainer",local:"orpo-trainer",headingTag:"h1"}}),q=new ge({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),z=new Ht({props:{code:"b3Jwb19kYXRhc2V0X2RpY3QlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWxsbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhvdyUyMGFyZSUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoYXQlMjBpcyUyMHlvdXIlMjBuYW1lJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGljaCUyMGlzJTIwdGhlJTIwYmVzdCUyMHByb2dyYW1taW5nJTIwbGFuZ3VhZ2UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGljaCUyMGlzJTIwdGhlJTIwYmVzdCUyMHByb2dyYW1taW5nJTIwbGFuZ3VhZ2UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGljaCUyMGlzJTIwdGhlJTIwYmVzdCUyMHByb2dyYW1taW5nJTIwbGFuZ3VhZ2UlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTXklMjBuYW1lJTIwaXMlMjBNYXJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTXklMjBuYW1lJTIwaXMlMjBNYXJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyUHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyUHl0aG9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGVhdmUlMjBtZSUyMGFsb25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGFtJTIwbm90JTIwZmluZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoYXRzJTIwaXQlMjB0byUyMHlvdSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBkb250JTIwaGF2ZSUyMGElMjBuYW1lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YXNjcmlwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTdE",highlighted:`orpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),H=new ge({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),G=new ge({props:{title:"Using the ORPOTrainer",local:"using-the-orpotrainer",headingTag:"h2"}}),V=new Ht({props:{code:"b3Jwb19jb25maWclMjAlM0QlMjBPUlBPQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGJldGElM0QwLjElMkMlMjAlMjMlMjB0aGUlMjBsYW1iZGElMkZhbHBoYSUyMGh5cGVycGFyYW1ldGVyJTIwaW4lMjB0aGUlMjBwYXBlciUyRmNvZGUlMEEpJTBBJTBBb3Jwb190cmFpbmVyJTIwJTNEJTIwT1JQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEb3Jwb19jb25maWclMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSk=",highlighted:`orpo_config = ORPOConfig(
    beta=<span class="hljs-number">0.1</span>, <span class="hljs-comment"># the lambda/alpha hyperparameter in the paper/code</span>
)

orpo_trainer = ORPOTrainer(
    model,
    args=orpo_config,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),Q=new Ht({props:{code:"b3Jwb190cmFpbmVyLnRyYWluKCk=",highlighted:"orpo_trainer.train()",wrap:!1}}),X=new ge({props:{title:"Logging",local:"logging",headingTag:"h2"}}),ee=new ge({props:{title:"ORPOTrainer",local:"trl.ORPOTrainer",headingTag:"h2"}}),te=new M({props:{name:"class trl.ORPOTrainer",anchor:"trl.ORPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.ORPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.ORPOTrainer.args",description:`<strong>args</strong> (<code>ORPOConfig</code>) &#x2014;
The ORPO config arguments to use for training.`,name:"args"},{anchor:"trl.ORPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.ORPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.ORPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.ORPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.ORPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.ORPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.ORPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.ORPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.ORPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.ORPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L62"}}),ae=new M({props:{name:"build_tokenized_answer",anchor:"trl.ORPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L334"}}),ne=new M({props:{name:"concatenated_forward",anchor:"trl.ORPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L662"}}),oe=new M({props:{name:"concatenated_inputs",anchor:"trl.ORPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L530",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),le=new M({props:{name:"evaluation_loop",anchor:"trl.ORPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L860"}}),re=new M({props:{name:"get_batch_logps",anchor:"trl.ORPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L624",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),se=new M({props:{name:"get_batch_loss_metrics",anchor:"trl.ORPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L731"}}),ie=new M({props:{name:"get_batch_samples",anchor:"trl.ORPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L795"}}),de=new M({props:{name:"log",anchor:"trl.ORPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.ORPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L908"}}),pe=new M({props:{name:"odds_ratio_loss",anchor:"trl.ORPOTrainer.odds_ratio_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L592",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the ORPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The log odds ratio of the chosen responses over the rejected responses ratio for logging purposes.
The <code>log(sigmoid(log_odds_chosen))</code> for logging purposes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),ce=new M({props:{name:"tokenize_row",anchor:"trl.ORPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_trainer.py#L384"}}),me=new ge({props:{title:"ORPOConfig",local:"trl.ORPOConfig",headingTag:"h2"}}),he=new M({props:{name:"class trl.ORPOConfig",anchor:"trl.ORPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"disable_dropout",val:": bool = True"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.ORPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.ORPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.ORPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the completions. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.ORPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in ORPO loss (lambda/alpha in paper/code) that is the weight of the relative loss ratio in the SFT loss.`,name:"beta"},{anchor:"trl.ORPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.ORPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.ORPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.ORPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.ORPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.ORPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.ORPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.ORPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/v0.8.5/trl/trainer/orpo_config.py#L20"}}),{c(){J=r("meta"),Fe=o(),Ne=r("p"),qe=o(),m(A.$$.fragment),Ee=o(),N=r("p"),N.innerHTML=Gt,Be=o(),R=r("p"),R.textContent=St,Le=o(),F=r("p"),F.innerHTML=Vt,ze=o(),m(q.$$.fragment),De=o(),E=r("p"),E.textContent=Yt,He=o(),B=r("ul"),B.innerHTML=Qt,We=o(),L=r("p"),L.textContent=Xt,Ge=o(),m(z.$$.fragment),Se=o(),D=r("p"),D.innerHTML=Zt,Ve=o(),m(H.$$.fragment),Ye=o(),W=r("p"),W.innerHTML=Kt,Qe=o(),m(G.$$.fragment),Xe=o(),S=r("p"),S.innerHTML=ea,Ze=o(),m(V.$$.fragment),Ke=o(),Y=r("p"),Y.textContent=ta,et=o(),m(Q.$$.fragment),tt=o(),m(X.$$.fragment),at=o(),Z=r("p"),Z.textContent=aa,nt=o(),K=r("ul"),K.innerHTML=na,ot=o(),m(ee.$$.fragment),lt=o(),d=r("div"),m(te.$$.fragment),ft=o(),ue=r("p"),ue.textContent=oa,vt=o(),j=r("div"),m(ae.$$.fragment),bt=o(),_e=r("p"),_e.innerHTML=la,Tt=o(),w=r("div"),m(ne.$$.fragment),Mt=o(),fe=r("p"),fe.textContent=ra,yt=o(),ve=r("p"),ve.textContent=sa,wt=o(),$=r("div"),m(oe.$$.fragment),Ot=o(),be=r("p"),be.textContent=ia,Jt=o(),O=r("div"),m(le.$$.fragment),jt=o(),Te=r("p"),Te.innerHTML=da,$t=o(),Me=r("p"),Me.textContent=pa,Ct=o(),C=r("div"),m(re.$$.fragment),xt=o(),ye=r("p"),ye.textContent=ca,It=o(),x=r("div"),m(se.$$.fragment),Ut=o(),we=r("p"),we.textContent=ma,Pt=o(),I=r("div"),m(ie.$$.fragment),kt=o(),Oe=r("p"),Oe.textContent=ha,At=o(),U=r("div"),m(de.$$.fragment),Nt=o(),Je=r("p"),Je.innerHTML=ga,Rt=o(),P=r("div"),m(pe.$$.fragment),Ft=o(),je=r("p"),je.textContent=ua,qt=o(),T=r("div"),m(ce.$$.fragment),Et=o(),$e=r("p"),$e.textContent=_a,Bt=o(),Ce=r("p"),Ce.textContent=fa,Lt=o(),xe=r("p"),xe.textContent=va,rt=o(),m(me.$$.fragment),st=o(),y=r("div"),m(he.$$.fragment),zt=o(),Ie=r("p"),Ie.innerHTML=ba,Dt=o(),Ue=r("p"),Ue.innerHTML=Ta,it=o(),Re=r("p"),this.h()},l(e){const a=ja("svelte-u9bgzb",document.head);J=s(a,"META",{name:!0,content:!0}),a.forEach(t),Fe=l(e),Ne=s(e,"P",{}),v(Ne).forEach(t),qe=l(e),h(A.$$.fragment,e),Ee=l(e),N=s(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-yhecos"&&(N.innerHTML=Gt),Be=l(e),R=s(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-14fu8cb"&&(R.textContent=St),Le=l(e),F=s(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-awkpkf"&&(F.innerHTML=Vt),ze=l(e),h(q.$$.fragment,e),De=l(e),E=s(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1i2ldsp"&&(E.textContent=Yt),He=l(e),B=s(e,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-17vxuta"&&(B.innerHTML=Qt),We=l(e),L=s(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1gl9mvz"&&(L.textContent=Xt),Ge=l(e),h(z.$$.fragment,e),Se=l(e),D=s(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-74izzd"&&(D.innerHTML=Zt),Ve=l(e),h(H.$$.fragment,e),Ye=l(e),W=s(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-s4moud"&&(W.innerHTML=Kt),Qe=l(e),h(G.$$.fragment,e),Xe=l(e),S=s(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1ec97r1"&&(S.innerHTML=ea),Ze=l(e),h(V.$$.fragment,e),Ke=l(e),Y=s(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1lg6q1l"&&(Y.textContent=ta),et=l(e),h(Q.$$.fragment,e),tt=l(e),h(X.$$.fragment,e),at=l(e),Z=s(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-132s7j9"&&(Z.textContent=aa),nt=l(e),K=s(e,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-m19ud7"&&(K.innerHTML=na),ot=l(e),h(ee.$$.fragment,e),lt=l(e),d=s(e,"DIV",{class:!0});var c=v(d);h(te.$$.fragment,c),ft=l(c),ue=s(c,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1ggwo37"&&(ue.textContent=oa),vt=l(c),j=s(c,"DIV",{class:!0});var pt=v(j);h(ae.$$.fragment,pt),bt=l(pt),_e=s(pt,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-mcz8nm"&&(_e.innerHTML=la),pt.forEach(t),Tt=l(c),w=s(c,"DIV",{class:!0});var Pe=v(w);h(ne.$$.fragment,Pe),Mt=l(Pe),fe=s(Pe,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-16i1nac"&&(fe.textContent=ra),yt=l(Pe),ve=s(Pe,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-tgti68"&&(ve.textContent=sa),Pe.forEach(t),wt=l(c),$=s(c,"DIV",{class:!0});var ct=v($);h(oe.$$.fragment,ct),Ot=l(ct),be=s(ct,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1cvsgkk"&&(be.textContent=ia),ct.forEach(t),Jt=l(c),O=s(c,"DIV",{class:!0});var ke=v(O);h(le.$$.fragment,ke),jt=l(ke),Te=s(ke,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-8qlty5"&&(Te.innerHTML=da),$t=l(ke),Me=s(ke,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1tyo99t"&&(Me.textContent=pa),ke.forEach(t),Ct=l(c),C=s(c,"DIV",{class:!0});var mt=v(C);h(re.$$.fragment,mt),xt=l(mt),ye=s(mt,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-4nmimv"&&(ye.textContent=ca),mt.forEach(t),It=l(c),x=s(c,"DIV",{class:!0});var ht=v(x);h(se.$$.fragment,ht),Ut=l(ht),we=s(ht,"P",{"data-svelte-h":!0}),p(we)!=="svelte-ndgk7s"&&(we.textContent=ma),ht.forEach(t),Pt=l(c),I=s(c,"DIV",{class:!0});var gt=v(I);h(ie.$$.fragment,gt),kt=l(gt),Oe=s(gt,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-18uwvbi"&&(Oe.textContent=ha),gt.forEach(t),At=l(c),U=s(c,"DIV",{class:!0});var ut=v(U);h(de.$$.fragment,ut),Nt=l(ut),Je=s(ut,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-nqksfz"&&(Je.innerHTML=ga),ut.forEach(t),Rt=l(c),P=s(c,"DIV",{class:!0});var _t=v(P);h(pe.$$.fragment,_t),Ft=l(_t),je=s(_t,"P",{"data-svelte-h":!0}),p(je)!=="svelte-y2dr0o"&&(je.textContent=ua),_t.forEach(t),qt=l(c),T=s(c,"DIV",{class:!0});var k=v(T);h(ce.$$.fragment,k),Et=l(k),$e=s(k,"P",{"data-svelte-h":!0}),p($e)!=="svelte-xlsvih"&&($e.textContent=_a),Bt=l(k),Ce=s(k,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1mn1gnw"&&(Ce.textContent=fa),Lt=l(k),xe=s(k,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1xvpyih"&&(xe.textContent=va),k.forEach(t),c.forEach(t),rt=l(e),h(me.$$.fragment,e),st=l(e),y=s(e,"DIV",{class:!0});var Ae=v(y);h(he.$$.fragment,Ae),zt=l(Ae),Ie=s(Ae,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-ap0kh3"&&(Ie.innerHTML=ba),Dt=l(Ae),Ue=s(Ae,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1xl7jqc"&&(Ue.innerHTML=Ta),Ae.forEach(t),it=l(e),Re=s(e,"P",{}),v(Re).forEach(t),this.h()},h(){b(J,"name","hf:doc:metadata"),b(J,"content",Ca),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){n(document.head,J),i(e,Fe,a),i(e,Ne,a),i(e,qe,a),g(A,e,a),i(e,Ee,a),i(e,N,a),i(e,Be,a),i(e,R,a),i(e,Le,a),i(e,F,a),i(e,ze,a),g(q,e,a),i(e,De,a),i(e,E,a),i(e,He,a),i(e,B,a),i(e,We,a),i(e,L,a),i(e,Ge,a),g(z,e,a),i(e,Se,a),i(e,D,a),i(e,Ve,a),g(H,e,a),i(e,Ye,a),i(e,W,a),i(e,Qe,a),g(G,e,a),i(e,Xe,a),i(e,S,a),i(e,Ze,a),g(V,e,a),i(e,Ke,a),i(e,Y,a),i(e,et,a),g(Q,e,a),i(e,tt,a),g(X,e,a),i(e,at,a),i(e,Z,a),i(e,nt,a),i(e,K,a),i(e,ot,a),g(ee,e,a),i(e,lt,a),i(e,d,a),g(te,d,null),n(d,ft),n(d,ue),n(d,vt),n(d,j),g(ae,j,null),n(j,bt),n(j,_e),n(d,Tt),n(d,w),g(ne,w,null),n(w,Mt),n(w,fe),n(w,yt),n(w,ve),n(d,wt),n(d,$),g(oe,$,null),n($,Ot),n($,be),n(d,Jt),n(d,O),g(le,O,null),n(O,jt),n(O,Te),n(O,$t),n(O,Me),n(d,Ct),n(d,C),g(re,C,null),n(C,xt),n(C,ye),n(d,It),n(d,x),g(se,x,null),n(x,Ut),n(x,we),n(d,Pt),n(d,I),g(ie,I,null),n(I,kt),n(I,Oe),n(d,At),n(d,U),g(de,U,null),n(U,Nt),n(U,Je),n(d,Rt),n(d,P),g(pe,P,null),n(P,Ft),n(P,je),n(d,qt),n(d,T),g(ce,T,null),n(T,Et),n(T,$e),n(T,Bt),n(T,Ce),n(T,Lt),n(T,xe),i(e,rt,a),g(me,e,a),i(e,st,a),i(e,y,a),g(he,y,null),n(y,zt),n(y,Ie),n(y,Dt),n(y,Ue),i(e,it,a),i(e,Re,a),dt=!0},p:ya,i(e){dt||(u(A.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(H.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(X.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(de.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),dt=!0)},o(e){_(A.$$.fragment,e),_(q.$$.fragment,e),_(z.$$.fragment,e),_(H.$$.fragment,e),_(G.$$.fragment,e),_(V.$$.fragment,e),_(Q.$$.fragment,e),_(X.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ae.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(le.$$.fragment,e),_(re.$$.fragment,e),_(se.$$.fragment,e),_(ie.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),dt=!1},d(e){e&&(t(Fe),t(Ne),t(qe),t(Ee),t(N),t(Be),t(R),t(Le),t(F),t(ze),t(De),t(E),t(He),t(B),t(We),t(L),t(Ge),t(Se),t(D),t(Ve),t(Ye),t(W),t(Qe),t(Xe),t(S),t(Ze),t(Ke),t(Y),t(et),t(tt),t(at),t(Z),t(nt),t(K),t(ot),t(lt),t(d),t(rt),t(st),t(y),t(it),t(Re)),t(J),f(A,e),f(q,e),f(z,e),f(H,e),f(G,e),f(V,e),f(Q,e),f(X,e),f(ee,e),f(te),f(ae),f(ne),f(oe),f(le),f(re),f(se),f(ie),f(de),f(pe),f(ce),f(me,e),f(he)}}}const Ca='{"title":"ORPO Trainer","local":"orpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the ORPOTrainer","local":"using-the-orpotrainer","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"ORPOTrainer","local":"trl.ORPOTrainer","sections":[],"depth":2},{"title":"ORPOConfig","local":"trl.ORPOConfig","sections":[],"depth":2}],"depth":1}';function xa(Wt){return wa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Na extends Oa{constructor(J){super(),Ja(this,J,xa,$a,Ma,{})}}export{Na as component};
