import{s as Ps,a as $l,n as Ds,o as Os}from"../chunks/scheduler.505acc25.js";import{S as Ks,i as en,e as i,s as n,c as J,h as tn,a as M,d as l,b as a,f as Ql,g as r,j as o,k as w,l as ln,m as s,n as y,t as U,o as T,p}from"../chunks/index.fbb49fb4.js";import{C as sn}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as c}from"../chunks/CodeBlock.7f0851b7.js";import{C as nn}from"../chunks/CourseFloatingBanner.742f9db5.js";import{H as d}from"../chunks/Heading.511e0027.js";import{E as an}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function Mn(El){let h,tt,Ke,lt,f,st,b,nt,B,at,v,Rl="Code agents are the default agent type in <code>smolagents</code>. They generate Python tool calls to perform actions, achieving action representations that are efficient, expressive, and accurate.",it,k,ql="Their streamlined approach reduces the number of required actions, simplifies complex operations, and enables reuse of existing code functions. <code>smolagents</code> provides a lightweight framework for building code agents, implemented in approximately 1,000 lines of code.",Mt,A,Ll=`<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png" alt="Code vs JSON Actions"/>
Graphic from the paper <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>`,ot,m,Xl='<p>If you want to learn more about why code agents are effective, check out <a href="https://huggingface.co/docs/smolagents/en/conceptual_guides/intro_agents#code-agents" target="_blank">this guide</a> from the smolagents documentation.</p>',Jt,Z,rt,V,_l="In a multi-step agent process, the LLM writes and executes actions, typically involving external tool calls. Traditional approaches use a JSON format to specify tool names and arguments as strings, <strong>which the system must parse to determine which tool to execute</strong>.",yt,G,Yl='However, research shows that <strong>tool-calling LLMs work more effectively with code directly</strong>. This is a core principle of <code>smolagents</code>, as shown in the diagram above from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',Ut,W,zl="Writing actions in code rather than JSON offers several key advantages:",Tt,N,Pl="<li><strong>Composability</strong>: Easily combine and reuse actions</li> <li><strong>Object Management</strong>: Work directly with complex structures like images</li> <li><strong>Generality</strong>: Express any computationally possible task</li> <li><strong>Natural for LLMs</strong>: High-quality code is already present in LLM training data</li>",pt,H,wt,F,Dl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/codeagent_docs.png" alt="From https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',ct,x,Ol="The diagram above illustrates how <code>CodeAgent.run()</code> operates, following the ReAct framework we mentioned in Unit 1. The main abstraction for agents in <code>smolagents</code> is a <code>MultiStepAgent</code>, which serves as the core building block. <code>CodeAgent</code> is a special kind of <code>MultiStepAgent</code>, as we will see in an example below.",ut,S,Kl="A <code>CodeAgent</code> performs actions through a cycle of steps, with existing variables and knowledge being incorporated into the agent’s context, which is kept in an execution log:",dt,$,es='<li><p>The system prompt is stored in a <code>SystemPromptStep</code>, and the user query is logged in a <code>TaskStep</code>.</p></li> <li><p>Then, the following while loop is executed:</p> <p>2.1 Method <code>agent.write_memory_to_messages()</code> writes the agent’s logs into a list of LLM-readable <a href="https://huggingface.co/docs/transformers/main/en/chat_templating" rel="nofollow">chat messages</a>.</p> <p>2.2 These messages are sent to a <code>Model</code>, which generates a completion.</p> <p>2.3 The completion is parsed to extract the action, which, in our case, should be a code snippet since we’re working with a <code>CodeAgent</code>.</p> <p>2.4 The action is executed.</p> <p>2.5 The results are logged into memory in an <code>ActionStep</code>.</p></li>',ht,Q,ts="At the end of each step, if the agent includes any function calls (in <code>agent.step_callback</code>), they are executed.",mt,E,gt,g,ls='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/code_agents.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',jt,R,ss="Alfred is planning a party at the Wayne family mansion and needs your help to ensure everything goes smoothly. To assist him, we’ll apply what we’ve learned about how a multi-step <code>CodeAgent</code> operates.",Ct,q,ns,It,L,as="If you haven’t installed <code>smolagents</code> yet, you can do so by running the following command:",ft,X,bt,_,is="Let’s also login to the Hugging Face Hub to have access to the Serverless Inference API.",Bt,Y,vt,z,kt,P,Ms="Music is an essential part of a successful party! Alfred needs some help selecting the playlist. Luckily, <code>smolagents</code> has got us covered! We can build an agent capable of searching the web using DuckDuckGo. To give the agent access to this tool, we include it in the tool list when creating the agent.",At,D,os,Zt,O,Js='For the model, we’ll rely on <code>InferenceClientModel</code>, which provides access to Hugging Face’s <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a>. The default model is <code>&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</code>, which is performant and available for fast inference, but you can select any compatible model from the Hub.',Vt,K,rs="Running an agent is quite straightforward:",Gt,ee,Wt,te,ys="When you run this example, the output will <strong>display a trace of the workflow steps being executed</strong>. It will also print the corresponding Python code with the message:",Nt,le,Ht,se,Us="After a few steps, you’ll see the generated playlist that Alfred can use for the party! 🎵",Ft,ne,xt,ae,Ts,St,ie,ps="Now that we have selected a playlist, we need to organize the menu for the guests. Again, Alfred can take advantage of <code>smolagents</code> to do so. Here, we use the <code>@tool</code> decorator to define a custom function that acts as a tool. We’ll cover tool creation in more detail later, so for now, we can simply run the code.",$t,Me,ws="As you can see in the example below, we will create a tool using the <code>@tool</code> decorator and include it in the <code>tools</code> list.",Qt,oe,Et,Je,cs="The agent will run for a few steps until finding the answer. Precising allowed values in the docstring helps direct agent to <code>occasion</code> argument values which exist and limit hallucinations.",Rt,re,us="The menu is ready! 🥗",qt,ye,Lt,Ue,ds="We have the playlist and menu ready, but we need to check one more crucial detail: preparation time!",Xt,Te,hs="Alfred needs to calculate when everything would be ready if he started preparing now, in case they need assistance from other superheroes.",_t,pe,ms="<code>smolagents</code> specializes in agents that write and execute Python code snippets, offering sandboxed execution for security.",Yt,we,gs=`<strong>Code execution has strict security measures</strong> - imports outside a predefined safe list are blocked by default. However, you can authorize additional imports by passing them as strings in <code>additional_authorized_imports</code>.
For more details on secure code execution, see the official <a href="https://huggingface.co/docs/smolagents/tutorials/secure_code_execution" rel="nofollow">guide</a>.`,zt,ce,js="When creating the agent, we’ll use <code>additional_authorized_imports</code> to allow for importing the <code>datetime</code> module.",Pt,ue,Dt,de,Cs=`These examples are just the beginning of what you can do with code agents, and we’re already starting to see their utility for preparing the party.
You can learn more about how to build code agents in the <a href="https://huggingface.co/docs/smolagents" rel="nofollow">smolagents documentation</a>.`,Ot,he,Is="In summary, <code>smolagents</code> specializes in agents that write and execute Python code snippets, offering sandboxed execution for security. It supports both local and API-based language models, making it adaptable to various development environments.",Kt,me,el,ge,fs="Wouldn’t it be <strong>amazing to share our very own Alfred agent with the community</strong>? By doing so, anyone can easily download and use the agent directly from the Hub, bringing the ultimate party planner of Gotham to their fingertips! Let’s make it happen! 🎉",tl,je,bs="The <code>smolagents</code> library makes this possible by allowing you to share a complete agent with the community and download others for immediate use. It’s as simple as the following:",ll,Ce,sl,Ie,Bs="To download the agent again, use the code below:",nl,fe,al,be,vs='What’s also exciting is that shared agents are directly available as Hugging Face Spaces, allowing you to interact with them in real-time. You can explore other agents <a href="https://huggingface.co/spaces/davidberenstein1957/smolagents-and-tools" rel="nofollow">here</a>.',il,Be,ks='For example, the <em>AlfredAgent</em> is available <a href="https://huggingface.co/spaces/sergiopaniego/AlfredAgent" rel="nofollow">here</a>. You can try it out directly below:',Ml,u,As,ol,ve,Zs="You may be wondering—how did Alfred build such an agent using <code>smolagents</code>? By integrating several tools, he can generate an agent as follows. Don’t worry about the tools for now, as we’ll have a dedicated section later in this unit to explore that in detail:",Jl,ke,rl,Ae,Vs="As you can see, we’ve created a <code>CodeAgent</code> with several tools that enhance the agent’s functionality, turning it into the ultimate party planner ready to share with the community! 🎉",yl,Ze,Gs="Now, it’s your turn: build your very own agent and share it with the community using the knowledge we’ve just learned! 🕵️‍♂️💡",Ul,j,Ws='<p>If you would like to share your agent project, then make a space and tag the <a href="https://huggingface.co/agents-course">agents-course</a> on the Hugging Face Hub. We’d love to see what you’ve created!</p>',Tl,Ve,pl,Ge,Ns="As Alfred fine-tunes the Party Preparator Agent, he’s growing weary of debugging its runs. Agents, by nature, are unpredictable and difficult to inspect. But since he aims to build the ultimate Party Preparator Agent and deploy it in production, he needs robust traceability for future monitoring and analysis.",wl,We,Hs='Once again, <code>smolagents</code> comes to the rescue! It embraces the <a href="https://opentelemetry.io/" rel="nofollow">OpenTelemetry</a> standard for instrumenting agent runs, allowing seamless inspection and logging. With the help of <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> and the <code>SmolagentsInstrumentor</code>, Alfred can easily track and analyze his agent’s behavior.',cl,Ne,Fs="Setting it up is straightforward!",ul,He,xs="First, we need to install the necessary dependencies:",dl,Fe,hl,xe,Ss='Next, Alfred has already created an account on Langfuse and has his API keys ready. If you haven’t done so yet, you can sign up for Langfuse Cloud <a href="https://cloud.langfuse.com/" rel="nofollow">here</a> or explore <a href="https://huggingface.co/docs/smolagents/tutorials/inspect_runs" rel="nofollow">alternatives</a>.',ml,Se,$s="Once you have your API keys, they need to be properly configured as follows:",gl,$e,jl,Qe,Qs="With the environment variables set, we can now initialize the Langfuse client. get_client() initializes the Langfuse client using the credentials provided in the environment variables.",Cl,Ee,Il,Re,Es="Finally, Alfred is ready to initialize the <code>SmolagentsInstrumentor</code> and start tracking his agent’s performance.",fl,qe,bl,Le,Rs="Alfred is now connected 🔌! The runs from <code>smolagents</code> are being logged in Langfuse, giving him full visibility into the agent’s behavior. With this setup, he’s ready to revisit previous runs and refine his Party Preparator Agent even further.",Bl,C,qs='<p>To learn more about tracing your agents and using the collected data to evaluate their performance, check out <a href="https://huggingface.co/learn/agents-course/bonus-unit2/introduction">Bonus Unit 2</a>.</p>',vl,Xe,kl,_e,Ls='Alfred can now access these logs <a href="https://cloud.langfuse.com/project/cm7bq0abj025rad078ak3luwi/traces/995fc019255528e4f48cf6770b0ce27b?timestamp=2025-02-19T10%3A28%3A36.929Z" rel="nofollow">here</a> to review and analyze them.',Al,I,Xs='<p>Actually, a minor error occurred during execution. Can you spot it in the logs? Try to track how the agent handles it and still returns a valid answer. <a href="https://cloud.langfuse.com/project/cm7bq0abj025rad078ak3luwi/traces/995fc019255528e4f48cf6770b0ce27b?timestamp=2025-02-19T10%3A28%3A36.929Z&amp;observation=80ca57ace4f69b52">Here</a> is the direct link to the error if you want to verify your answer. Of course the error has been fixed in the meantime, more details can be found in this <a href="https://github.com/huggingface/smolagents/issues/838">issue</a>.</p>',Zl,Ye,_s='Meanwhile, the <a href="https://open.spotify.com/playlist/0gZMMHjuxMrrybQ7wTMTpw" rel="nofollow">suggested playlist</a> sets the perfect vibe for the party preparations. Cool, right? 🎶',Vl,Gl,Wl,ze,Ys="Now that we have created our first Code Agent, let’s <strong>learn how we can create Tool Calling Agents</strong>, the second type of agent available in <code>smolagents</code>.",Nl,Pe,Hl,De,zs='<li><a href="https://huggingface.co/blog/smolagents" rel="nofollow">smolagents Blog</a> - Introduction to smolagents and code interactions</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">smolagents: Building Good Agents</a> - Best practices for reliable agents</li> <li><a href="https://www.anthropic.com/research/building-effective-agents" rel="nofollow">Building Effective Agents - Anthropic</a> - Agent design principles</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/inspect_runs" rel="nofollow">Sharing runs with OpenTelemetry</a> - Details about how to setup OpenTelemetry for tracking your agents.</li>',Fl,Oe,xl,et,Sl;return f=new nn({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/code_agents.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),b=new sn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),B=new d({props:{title:"Building Agents That Use Code",local:"building-agents-that-use-code",headingTag:"h1"}}),Z=new d({props:{title:"Why Code Agents?",local:"why-code-agents",headingTag:"h2"}}),H=new d({props:{title:"How Does a Code Agent Work?",local:"how-does-a-code-agent-work",headingTag:"h2"}}),E=new d({props:{title:"Let’s See Some Examples",local:"lets-see-some-examples",headingTag:"h2"}}),X=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjAtVQ==",highlighted:"pip install smolagents -U",wrap:!1}}),Y=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login()`,wrap:!1}}),z=new d({props:{title:"Selecting a Playlist for the Party Using smolagents",local:"selecting-a-playlist-for-the-party-using-smolagents",headingTag:"h3"}}),ee=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQSUwQWFnZW50LnJ1biglMjJTZWFyY2glMjBmb3IlMjB0aGUlMjBiZXN0JTIwbXVzaWMlMjByZWNvbW1lbmRhdGlvbnMlMjBmb3IlMjBhJTIwcGFydHklMjBhdCUyMHRoZSUyMFdheW5lJ3MlMjBtYW5zaW9uLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, InferenceClientModel

agent = CodeAgent(tools=[DuckDuckGoSearchTool()], model=InferenceClientModel())

agent.run(<span class="hljs-string">&quot;Search for the best music recommendations for a party at the Wayne&#x27;s mansion.&quot;</span>)`,wrap:!1}}),le=new c({props:{code:"JTIwJUUyJTk0JTgwJTIwRXhlY3V0aW5nJTIwcGFyc2VkJTIwY29kZSUzQSUyMCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCUyMCUwQSUyMCUyMHJlc3VsdHMlMjAlM0QlMjB3ZWJfc2VhcmNoKHF1ZXJ5JTNEJTIyYmVzdCUyMG11c2ljJTIwZm9yJTIwYSUyMEJhdG1hbiUyMHBhcnR5JTIyKSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMHByaW50KHJlc3VsdHMpJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJTIw",highlighted:` ─ Executing parsed code: ──────────────────────────────────────────────────────────────────────────────────────── 
  results = web_search(query=<span class="hljs-string">&quot;best music for a Batman party&quot;</span>)                                                      
  <span class="hljs-built_in">print</span>(results)                                                                                                   
 ───────────────────────────────────────────────────────────────────────────────────────────────────────────────── `,wrap:!1}}),ne=new d({props:{title:"Using a Custom Tool to Prepare the Menu",local:"using-a-custom-tool-to-prepare-the-menu",headingTag:"h3"}}),oe=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, tool, InferenceClientModel

<span class="hljs-comment"># Tool to suggest a menu based on the occasion</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">suggest_menu</span>(<span class="hljs-params">occasion: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Suggests a menu based on the occasion.
    Args:
        occasion (str): The type of occasion for the party. Allowed values are:
                        - &quot;casual&quot;: Menu for casual party.
                        - &quot;formal&quot;: Menu for formal party.
                        - &quot;superhero&quot;: Menu for superhero party.
                        - &quot;custom&quot;: Custom menu.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> occasion == <span class="hljs-string">&quot;casual&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Pizza, snacks, and drinks.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;formal&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;3-course dinner with wine and dessert.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;superhero&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Buffet with high-energy and healthy food.&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Custom menu for the butler.&quot;</span>

<span class="hljs-comment"># Alfred, the butler, preparing the menu for the party</span>
agent = CodeAgent(tools=[suggest_menu], model=InferenceClientModel())

<span class="hljs-comment"># Preparing the menu for the party</span>
agent.run(<span class="hljs-string">&quot;Prepare a formal menu for the party.&quot;</span>)`,wrap:!1}}),ye=new d({props:{title:"Using Python Imports Inside the Agent",local:"using-python-imports-inside-the-agent",headingTag:"h3"}}),ue=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRpbWUlMEFpbXBvcnQlMjBkYXRldGltZSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUInZGF0ZXRpbWUnJTVEKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBbGZyZWQlMjBuZWVkcyUyMHRvJTIwcHJlcGFyZSUyMGZvciUyMHRoZSUyMHBhcnR5LiUyMEhlcmUlMjBhcmUlMjB0aGUlMjB0YXNrcyUzQSUwQSUyMCUyMCUyMCUyMDEuJTIwUHJlcGFyZSUyMHRoZSUyMGRyaW5rcyUyMC0lMjAzMCUyMG1pbnV0ZXMlMEElMjAlMjAlMjAlMjAyLiUyMERlY29yYXRlJTIwdGhlJTIwbWFuc2lvbiUyMC0lMjA2MCUyMG1pbnV0ZXMlMEElMjAlMjAlMjAlMjAzLiUyMFNldCUyMHVwJTIwdGhlJTIwbWVudSUyMC0lMjA0NSUyMG1pbnV0ZXMlMEElMjAlMjAlMjAlMjA0LiUyMFByZXBhcmUlMjB0aGUlMjBtdXNpYyUyMGFuZCUyMHBsYXlsaXN0JTIwLSUyMDQ1JTIwbWludXRlcyUwQSUwQSUyMCUyMCUyMCUyMElmJTIwd2UlMjBzdGFydCUyMHJpZ2h0JTIwbm93JTJDJTIwYXQlMjB3aGF0JTIwdGltZSUyMHdpbGwlMjB0aGUlMjBwYXJ0eSUyMGJlJTIwcmVhZHklM0YlMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> datetime

agent = CodeAgent(tools=[], model=InferenceClientModel(), additional_authorized_imports=[<span class="hljs-string">&#x27;datetime&#x27;</span>])

agent.run(
    <span class="hljs-string">&quot;&quot;&quot;
    Alfred needs to prepare for the party. Here are the tasks:
    1. Prepare the drinks - 30 minutes
    2. Decorate the mansion - 60 minutes
    3. Set up the menu - 45 minutes
    4. Prepare the music and playlist - 45 minutes

    If we start right now, at what time will the party be ready?
    &quot;&quot;&quot;</span>
)`,wrap:!1}}),me=new d({props:{title:"Sharing Our Custom Party Preparator Agent to the Hub",local:"sharing-our-custom-party-preparator-agent-to-the-hub",headingTag:"h3"}}),Ce=new c({props:{code:"JTIzJTIwQ2hhbmdlJTIwdG8lMjB5b3VyJTIwdXNlcm5hbWUlMjBhbmQlMjByZXBvJTIwbmFtZSUwQWFnZW50LnB1c2hfdG9faHViKCdzZXJnaW9wYW5pZWdvJTJGQWxmcmVkQWdlbnQnKQ==",highlighted:`<span class="hljs-comment"># Change to your username and repo name</span>
agent.push_to_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>)`,wrap:!1}}),fe=new c({props:{code:"JTIzJTIwQ2hhbmdlJTIwdG8lMjB5b3VyJTIwdXNlcm5hbWUlMjBhbmQlMjByZXBvJTIwbmFtZSUwQWFsZnJlZF9hZ2VudCUyMCUzRCUyMGFnZW50LmZyb21faHViKCdzZXJnaW9wYW5pZWdvJTJGQWxmcmVkQWdlbnQnJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQWFsZnJlZF9hZ2VudC5ydW4oJTIyR2l2ZSUyMG1lJTIwdGhlJTIwYmVzdCUyMHBsYXlsaXN0JTIwZm9yJTIwYSUyMHBhcnR5JTIwYXQlMjBXYXluZSdzJTIwbWFuc2lvbi4lMjBUaGUlMjBwYXJ0eSUyMGlkZWElMjBpcyUyMGElMjAndmlsbGFpbiUyMG1hc3F1ZXJhZGUnJTIwdGhlbWUlMjIpJTIwJTIw",highlighted:`<span class="hljs-comment"># Change to your username and repo name</span>
alfred_agent = agent.from_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

alfred_agent.run(<span class="hljs-string">&quot;Give me the best playlist for a party at Wayne&#x27;s mansion. The party idea is a &#x27;villain masquerade&#x27; theme&quot;</span>)  `,wrap:!1}}),ke=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, FinalAnswerTool, InferenceClientModel, Tool, tool, VisitWebpageTool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">suggest_menu</span>(<span class="hljs-params">occasion: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Suggests a menu based on the occasion.
    Args:
        occasion: The type of occasion for the party.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> occasion == <span class="hljs-string">&quot;casual&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Pizza, snacks, and drinks.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;formal&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;3-course dinner with wine and dessert.&quot;</span>
    <span class="hljs-keyword">elif</span> occasion == <span class="hljs-string">&quot;superhero&quot;</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Buffet with high-energy and healthy food.&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Custom menu for the butler.&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    This tool returns the highest-rated catering service in Gotham City.
    
    Args:
        query: A search term for finding catering services.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example list of catering services and their ratings</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }
    
    <span class="hljs-comment"># Find the highest rated catering service (simulating search query filtering)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)
    
    <span class="hljs-keyword">return</span> best_service

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This tool suggests creative superhero-themed party ideas based on a category.
    It returns a unique party theme idea.&quot;&quot;&quot;</span>
    
    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The type of superhero party (e.g., &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, &#x27;futuristic Gotham&#x27;).&quot;</span>,
        }
    }
    
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Justice League Gala: Guests come dressed as their favorite DC heroes with themed cocktails like &#x27;The Kryptonite Punch&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Neo-Gotham Night: A cyberpunk-style party inspired by Batman Beyond, with neon decorations and futuristic gadgets.&quot;</span>
        }
        
        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Themed party idea not found. Try &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, or &#x27;futuristic Gotham&#x27;.&quot;</span>)


<span class="hljs-comment"># Alfred, the butler, preparing the menu for the party</span>
agent = CodeAgent(
    tools=[
        DuckDuckGoSearchTool(), 
        VisitWebpageTool(),
        suggest_menu,
        catering_service_tool,
        SuperheroPartyThemeTool(),
	FinalAnswerTool()
    ], 
    model=InferenceClientModel(),
    max_steps=<span class="hljs-number">10</span>,
    verbosity_level=<span class="hljs-number">2</span>
)

agent.run(<span class="hljs-string">&quot;Give me the best playlist for a party at the Wayne&#x27;s mansion. The party idea is a &#x27;villain masquerade&#x27; theme&quot;</span>)`,wrap:!1}}),Ve=new d({props:{title:"Inspecting Our Party Preparator Agent with OpenTelemetry and Langfuse 📡",local:"inspecting-our-party-preparator-agent-with-opentelemetry-and-langfuse-",headingTag:"h3"}}),Fe=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wZW50ZWxlbWV0cnktc2RrJTIwb3BlbnRlbGVtZXRyeS1leHBvcnRlci1vdGxwJTIwb3BlbmluZmVyZW5jZS1pbnN0cnVtZW50YXRpb24tc21vbGFnZW50cyUyMGxhbmdmdXNl",highlighted:"pip install opentelemetry-sdk opentelemetry-exporter-otlp openinference-instrumentation-smolagents langfuse",wrap:!1}}),$e=new c({props:{code:"aW1wb3J0JTIwb3MlMEElMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUyMCUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbg==",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>`,wrap:!1}}),Ee=new c({props:{code:"ZnJvbSUyMGxhbmdmdXNlJTIwaW1wb3J0JTIwZ2V0X2NsaWVudCUwQSUyMCUwQWxhbmdmdXNlJTIwJTNEJTIwZ2V0X2NsaWVudCgpJTBBJTIwJTBBJTIzJTIwVmVyaWZ5JTIwY29ubmVjdGlvbiUwQWlmJTIwbGFuZ2Z1c2UuYXV0aF9jaGVjaygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyTGFuZ2Z1c2UlMjBjbGllbnQlMjBpcyUyMGF1dGhlbnRpY2F0ZWQlMjBhbmQlMjByZWFkeSElMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkF1dGhlbnRpY2F0aW9uJTIwZmFpbGVkLiUyMFBsZWFzZSUyMGNoZWNrJTIweW91ciUyMGNyZWRlbnRpYWxzJTIwYW5kJTIwaG9zdC4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langfuse <span class="hljs-keyword">import</span> get_client
 
langfuse = get_client()
 
<span class="hljs-comment"># Verify connection</span>
<span class="hljs-keyword">if</span> langfuse.auth_check():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Langfuse client is authenticated and ready!&quot;</span>)
<span class="hljs-keyword">else</span>:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Authentication failed. Please check your credentials and host.&quot;</span>)`,wrap:!1}}),qe=new c({props:{code:"ZnJvbSUyMG9wZW5pbmZlcmVuY2UuaW5zdHJ1bWVudGF0aW9uLnNtb2xhZ2VudHMlMjBpbXBvcnQlMjBTbW9sYWdlbnRzSW5zdHJ1bWVudG9yJTBBJTBBU21vbGFnZW50c0luc3RydW1lbnRvcigpLmluc3RydW1lbnQoKQ==",highlighted:`<span class="hljs-keyword">from</span> openinference.instrumentation.smolagents <span class="hljs-keyword">import</span> SmolagentsInstrumentor

SmolagentsInstrumentor().instrument()`,wrap:!1}}),Xe=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCJTVEJTJDJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpKSUwQWFsZnJlZF9hZ2VudCUyMCUzRCUyMGFnZW50LmZyb21faHViKCdzZXJnaW9wYW5pZWdvJTJGQWxmcmVkQWdlbnQnJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWFsZnJlZF9hZ2VudC5ydW4oJTIyR2l2ZSUyMG1lJTIwdGhlJTIwYmVzdCUyMHBsYXlsaXN0JTIwZm9yJTIwYSUyMHBhcnR5JTIwYXQlMjBXYXluZSdzJTIwbWFuc2lvbi4lMjBUaGUlMjBwYXJ0eSUyMGlkZWElMjBpcyUyMGElMjAndmlsbGFpbiUyMG1hc3F1ZXJhZGUnJTIwdGhlbWUlMjIpJTIwJTIw",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(tools=[], model=InferenceClientModel())
alfred_agent = agent.from_hub(<span class="hljs-string">&#x27;sergiopaniego/AlfredAgent&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
alfred_agent.run(<span class="hljs-string">&quot;Give me the best playlist for a party at Wayne&#x27;s mansion. The party idea is a &#x27;villain masquerade&#x27; theme&quot;</span>)  `,wrap:!1}}),Pe=new d({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Oe=new an({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/code_agents.mdx"}}),{c(){h=i("meta"),tt=n(),Ke=i("p"),lt=n(),J(f.$$.fragment),st=n(),J(b.$$.fragment),nt=n(),J(B.$$.fragment),at=n(),v=i("p"),v.innerHTML=Rl,it=n(),k=i("p"),k.innerHTML=ql,Mt=n(),A=i("p"),A.innerHTML=Ll,ot=n(),m=i("blockquote"),m.innerHTML=Xl,Jt=n(),J(Z.$$.fragment),rt=n(),V=i("p"),V.innerHTML=_l,yt=n(),G=i("p"),G.innerHTML=Yl,Ut=n(),W=i("p"),W.textContent=zl,Tt=n(),N=i("ul"),N.innerHTML=Pl,pt=n(),J(H.$$.fragment),wt=n(),F=i("p"),F.innerHTML=Dl,ct=n(),x=i("p"),x.innerHTML=Ol,ut=n(),S=i("p"),S.innerHTML=Kl,dt=n(),$=i("ol"),$.innerHTML=es,ht=n(),Q=i("p"),Q.innerHTML=ts,mt=n(),J(E.$$.fragment),gt=n(),g=i("blockquote"),g.innerHTML=ls,jt=n(),R=i("p"),R.innerHTML=ss,Ct=n(),q=i("img"),It=n(),L=i("p"),L.innerHTML=as,ft=n(),J(X.$$.fragment),bt=n(),_=i("p"),_.textContent=is,Bt=n(),J(Y.$$.fragment),vt=n(),J(z.$$.fragment),kt=n(),P=i("p"),P.innerHTML=Ms,At=n(),D=i("img"),Zt=n(),O=i("p"),O.innerHTML=Js,Vt=n(),K=i("p"),K.textContent=rs,Gt=n(),J(ee.$$.fragment),Wt=n(),te=i("p"),te.innerHTML=ys,Nt=n(),J(le.$$.fragment),Ht=n(),se=i("p"),se.textContent=Us,Ft=n(),J(ne.$$.fragment),xt=n(),ae=i("img"),St=n(),ie=i("p"),ie.innerHTML=ps,$t=n(),Me=i("p"),Me.innerHTML=ws,Qt=n(),J(oe.$$.fragment),Et=n(),Je=i("p"),Je.innerHTML=cs,Rt=n(),re=i("p"),re.textContent=us,qt=n(),J(ye.$$.fragment),Lt=n(),Ue=i("p"),Ue.textContent=ds,Xt=n(),Te=i("p"),Te.textContent=hs,_t=n(),pe=i("p"),pe.innerHTML=ms,Yt=n(),we=i("p"),we.innerHTML=gs,zt=n(),ce=i("p"),ce.innerHTML=js,Pt=n(),J(ue.$$.fragment),Dt=n(),de=i("p"),de.innerHTML=Cs,Ot=n(),he=i("p"),he.innerHTML=Is,Kt=n(),J(me.$$.fragment),el=n(),ge=i("p"),ge.innerHTML=fs,tl=n(),je=i("p"),je.innerHTML=bs,ll=n(),J(Ce.$$.fragment),sl=n(),Ie=i("p"),Ie.textContent=Bs,nl=n(),J(fe.$$.fragment),al=n(),be=i("p"),be.innerHTML=vs,il=n(),Be=i("p"),Be.innerHTML=ks,Ml=n(),u=i("iframe"),ol=n(),ve=i("p"),ve.innerHTML=Zs,Jl=n(),J(ke.$$.fragment),rl=n(),Ae=i("p"),Ae.innerHTML=Vs,yl=n(),Ze=i("p"),Ze.textContent=Gs,Ul=n(),j=i("blockquote"),j.innerHTML=Ws,Tl=n(),J(Ve.$$.fragment),pl=n(),Ge=i("p"),Ge.textContent=Ns,wl=n(),We=i("p"),We.innerHTML=Hs,cl=n(),Ne=i("p"),Ne.textContent=Fs,ul=n(),He=i("p"),He.textContent=xs,dl=n(),J(Fe.$$.fragment),hl=n(),xe=i("p"),xe.innerHTML=Ss,ml=n(),Se=i("p"),Se.textContent=$s,gl=n(),J($e.$$.fragment),jl=n(),Qe=i("p"),Qe.textContent=Qs,Cl=n(),J(Ee.$$.fragment),Il=n(),Re=i("p"),Re.innerHTML=Es,fl=n(),J(qe.$$.fragment),bl=n(),Le=i("p"),Le.innerHTML=Rs,Bl=n(),C=i("blockquote"),C.innerHTML=qs,vl=n(),J(Xe.$$.fragment),kl=n(),_e=i("p"),_e.innerHTML=Ls,Al=n(),I=i("blockquote"),I.innerHTML=Xs,Zl=n(),Ye=i("p"),Ye.innerHTML=_s,Vl=n(),Gl=i("hr"),Wl=n(),ze=i("p"),ze.innerHTML=Ys,Nl=n(),J(Pe.$$.fragment),Hl=n(),De=i("ul"),De.innerHTML=zs,Fl=n(),J(Oe.$$.fragment),xl=n(),et=i("p"),this.h()},l(e){const t=tn("svelte-u9bgzb",document.head);h=M(t,"META",{name:!0,content:!0}),t.forEach(l),tt=a(e),Ke=M(e,"P",{}),Ql(Ke).forEach(l),lt=a(e),r(f.$$.fragment,e),st=a(e),r(b.$$.fragment,e),nt=a(e),r(B.$$.fragment,e),at=a(e),v=M(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-17ycni3"&&(v.innerHTML=Rl),it=a(e),k=M(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1vji85d"&&(k.innerHTML=ql),Mt=a(e),A=M(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1uhgwdo"&&(A.innerHTML=Ll),ot=a(e),m=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(m)!=="svelte-1vs2p9j"&&(m.innerHTML=Xl),Jt=a(e),r(Z.$$.fragment,e),rt=a(e),V=M(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-i4pkup"&&(V.innerHTML=_l),yt=a(e),G=M(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-qsp339"&&(G.innerHTML=Yl),Ut=a(e),W=M(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1cvhdio"&&(W.textContent=zl),Tt=a(e),N=M(e,"UL",{"data-svelte-h":!0}),o(N)!=="svelte-1sdj82c"&&(N.innerHTML=Pl),pt=a(e),r(H.$$.fragment,e),wt=a(e),F=M(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-2i0rf5"&&(F.innerHTML=Dl),ct=a(e),x=M(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1w1ih9q"&&(x.innerHTML=Ol),ut=a(e),S=M(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1fyv2mb"&&(S.innerHTML=Kl),dt=a(e),$=M(e,"OL",{"data-svelte-h":!0}),o($)!=="svelte-110rju1"&&($.innerHTML=es),ht=a(e),Q=M(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1qg0cxf"&&(Q.innerHTML=ts),mt=a(e),r(E.$$.fragment,e),gt=a(e),g=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-m4phip"&&(g.innerHTML=ls),jt=a(e),R=M(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1bke2ma"&&(R.innerHTML=ss),Ct=a(e),q=M(e,"IMG",{src:!0,alt:!0}),It=a(e),L=M(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1rbs9u6"&&(L.innerHTML=as),ft=a(e),r(X.$$.fragment,e),bt=a(e),_=M(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1cqyo9g"&&(_.textContent=is),Bt=a(e),r(Y.$$.fragment,e),vt=a(e),r(z.$$.fragment,e),kt=a(e),P=M(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-x78vs2"&&(P.innerHTML=Ms),At=a(e),D=M(e,"IMG",{src:!0,alt:!0}),Zt=a(e),O=M(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-skojn1"&&(O.innerHTML=Js),Vt=a(e),K=M(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1aau6qe"&&(K.textContent=rs),Gt=a(e),r(ee.$$.fragment,e),Wt=a(e),te=M(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1idfq95"&&(te.innerHTML=ys),Nt=a(e),r(le.$$.fragment,e),Ht=a(e),se=M(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-qibxtx"&&(se.textContent=Us),Ft=a(e),r(ne.$$.fragment,e),xt=a(e),ae=M(e,"IMG",{src:!0,alt:!0}),St=a(e),ie=M(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1voj352"&&(ie.innerHTML=ps),$t=a(e),Me=M(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1iiuzsj"&&(Me.innerHTML=ws),Qt=a(e),r(oe.$$.fragment,e),Et=a(e),Je=M(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1nldwyv"&&(Je.innerHTML=cs),Rt=a(e),re=M(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1f7ze3r"&&(re.textContent=us),qt=a(e),r(ye.$$.fragment,e),Lt=a(e),Ue=M(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-8depwo"&&(Ue.textContent=ds),Xt=a(e),Te=M(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-eykpll"&&(Te.textContent=hs),_t=a(e),pe=M(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-4672lb"&&(pe.innerHTML=ms),Yt=a(e),we=M(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-fobjrc"&&(we.innerHTML=gs),zt=a(e),ce=M(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1u248np"&&(ce.innerHTML=js),Pt=a(e),r(ue.$$.fragment,e),Dt=a(e),de=M(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-vwsn9d"&&(de.innerHTML=Cs),Ot=a(e),he=M(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1u95395"&&(he.innerHTML=Is),Kt=a(e),r(me.$$.fragment,e),el=a(e),ge=M(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1hhl4b3"&&(ge.innerHTML=fs),tl=a(e),je=M(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1phne6y"&&(je.innerHTML=bs),ll=a(e),r(Ce.$$.fragment,e),sl=a(e),Ie=M(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-rbahqz"&&(Ie.textContent=Bs),nl=a(e),r(fe.$$.fragment,e),al=a(e),be=M(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-ig9tc2"&&(be.innerHTML=vs),il=a(e),Be=M(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-ivdwzg"&&(Be.innerHTML=ks),Ml=a(e),u=M(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Ql(u).forEach(l),ol=a(e),ve=M(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1dqpcjq"&&(ve.innerHTML=Zs),Jl=a(e),r(ke.$$.fragment,e),rl=a(e),Ae=M(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1096ue8"&&(Ae.innerHTML=Vs),yl=a(e),Ze=M(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-eyk6wc"&&(Ze.textContent=Gs),Ul=a(e),j=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-920krh"&&(j.innerHTML=Ws),Tl=a(e),r(Ve.$$.fragment,e),pl=a(e),Ge=M(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1cbcpl7"&&(Ge.textContent=Ns),wl=a(e),We=M(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-lvq792"&&(We.innerHTML=Hs),cl=a(e),Ne=M(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1nz0zrc"&&(Ne.textContent=Fs),ul=a(e),He=M(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-bon1th"&&(He.textContent=xs),dl=a(e),r(Fe.$$.fragment,e),hl=a(e),xe=M(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1j4k9mc"&&(xe.innerHTML=Ss),ml=a(e),Se=M(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-6s2c5k"&&(Se.textContent=$s),gl=a(e),r($e.$$.fragment,e),jl=a(e),Qe=M(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-kdnbgz"&&(Qe.textContent=Qs),Cl=a(e),r(Ee.$$.fragment,e),Il=a(e),Re=M(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-1ci9jvt"&&(Re.innerHTML=Es),fl=a(e),r(qe.$$.fragment,e),bl=a(e),Le=M(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-htkmxe"&&(Le.innerHTML=Rs),Bl=a(e),C=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-12tu00n"&&(C.innerHTML=qs),vl=a(e),r(Xe.$$.fragment,e),kl=a(e),_e=M(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-fmbkd1"&&(_e.innerHTML=Ls),Al=a(e),I=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-4pderd"&&(I.innerHTML=Xs),Zl=a(e),Ye=M(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-emnj79"&&(Ye.innerHTML=_s),Vl=a(e),Gl=M(e,"HR",{}),Wl=a(e),ze=M(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1goremc"&&(ze.innerHTML=Ys),Nl=a(e),r(Pe.$$.fragment,e),Hl=a(e),De=M(e,"UL",{"data-svelte-h":!0}),o(De)!=="svelte-695w00"&&(De.innerHTML=zs),Fl=a(e),r(Oe.$$.fragment,e),xl=a(e),et=M(e,"P",{}),Ql(et).forEach(l),this.h()},h(){w(h,"name","hf:doc:metadata"),w(h,"content",on),w(m,"class","tip"),w(g,"class","tip"),$l(q.src,ns="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-party.jpg")||w(q,"src",ns),w(q,"alt","Alfred Party"),$l(D.src,os="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-playlist.jpg")||w(D,"src",os),w(D,"alt","Alfred Playlist"),$l(ae.src,Ts="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-menu.jpg")||w(ae,"src",Ts),w(ae,"alt","Alfred Menu"),$l(u.src,As="https://sergiopaniego-alfredagent.hf.space/")||w(u,"src",As),w(u,"frameborder","0"),w(u,"width","850"),w(u,"height","450"),w(j,"class","tip"),w(C,"class","tip"),w(I,"class","tip")},m(e,t){ln(document.head,h),s(e,tt,t),s(e,Ke,t),s(e,lt,t),y(f,e,t),s(e,st,t),y(b,e,t),s(e,nt,t),y(B,e,t),s(e,at,t),s(e,v,t),s(e,it,t),s(e,k,t),s(e,Mt,t),s(e,A,t),s(e,ot,t),s(e,m,t),s(e,Jt,t),y(Z,e,t),s(e,rt,t),s(e,V,t),s(e,yt,t),s(e,G,t),s(e,Ut,t),s(e,W,t),s(e,Tt,t),s(e,N,t),s(e,pt,t),y(H,e,t),s(e,wt,t),s(e,F,t),s(e,ct,t),s(e,x,t),s(e,ut,t),s(e,S,t),s(e,dt,t),s(e,$,t),s(e,ht,t),s(e,Q,t),s(e,mt,t),y(E,e,t),s(e,gt,t),s(e,g,t),s(e,jt,t),s(e,R,t),s(e,Ct,t),s(e,q,t),s(e,It,t),s(e,L,t),s(e,ft,t),y(X,e,t),s(e,bt,t),s(e,_,t),s(e,Bt,t),y(Y,e,t),s(e,vt,t),y(z,e,t),s(e,kt,t),s(e,P,t),s(e,At,t),s(e,D,t),s(e,Zt,t),s(e,O,t),s(e,Vt,t),s(e,K,t),s(e,Gt,t),y(ee,e,t),s(e,Wt,t),s(e,te,t),s(e,Nt,t),y(le,e,t),s(e,Ht,t),s(e,se,t),s(e,Ft,t),y(ne,e,t),s(e,xt,t),s(e,ae,t),s(e,St,t),s(e,ie,t),s(e,$t,t),s(e,Me,t),s(e,Qt,t),y(oe,e,t),s(e,Et,t),s(e,Je,t),s(e,Rt,t),s(e,re,t),s(e,qt,t),y(ye,e,t),s(e,Lt,t),s(e,Ue,t),s(e,Xt,t),s(e,Te,t),s(e,_t,t),s(e,pe,t),s(e,Yt,t),s(e,we,t),s(e,zt,t),s(e,ce,t),s(e,Pt,t),y(ue,e,t),s(e,Dt,t),s(e,de,t),s(e,Ot,t),s(e,he,t),s(e,Kt,t),y(me,e,t),s(e,el,t),s(e,ge,t),s(e,tl,t),s(e,je,t),s(e,ll,t),y(Ce,e,t),s(e,sl,t),s(e,Ie,t),s(e,nl,t),y(fe,e,t),s(e,al,t),s(e,be,t),s(e,il,t),s(e,Be,t),s(e,Ml,t),s(e,u,t),s(e,ol,t),s(e,ve,t),s(e,Jl,t),y(ke,e,t),s(e,rl,t),s(e,Ae,t),s(e,yl,t),s(e,Ze,t),s(e,Ul,t),s(e,j,t),s(e,Tl,t),y(Ve,e,t),s(e,pl,t),s(e,Ge,t),s(e,wl,t),s(e,We,t),s(e,cl,t),s(e,Ne,t),s(e,ul,t),s(e,He,t),s(e,dl,t),y(Fe,e,t),s(e,hl,t),s(e,xe,t),s(e,ml,t),s(e,Se,t),s(e,gl,t),y($e,e,t),s(e,jl,t),s(e,Qe,t),s(e,Cl,t),y(Ee,e,t),s(e,Il,t),s(e,Re,t),s(e,fl,t),y(qe,e,t),s(e,bl,t),s(e,Le,t),s(e,Bl,t),s(e,C,t),s(e,vl,t),y(Xe,e,t),s(e,kl,t),s(e,_e,t),s(e,Al,t),s(e,I,t),s(e,Zl,t),s(e,Ye,t),s(e,Vl,t),s(e,Gl,t),s(e,Wl,t),s(e,ze,t),s(e,Nl,t),y(Pe,e,t),s(e,Hl,t),s(e,De,t),s(e,Fl,t),y(Oe,e,t),s(e,xl,t),s(e,et,t),Sl=!0},p:Ds,i(e){Sl||(U(f.$$.fragment,e),U(b.$$.fragment,e),U(B.$$.fragment,e),U(Z.$$.fragment,e),U(H.$$.fragment,e),U(E.$$.fragment,e),U(X.$$.fragment,e),U(Y.$$.fragment,e),U(z.$$.fragment,e),U(ee.$$.fragment,e),U(le.$$.fragment,e),U(ne.$$.fragment,e),U(oe.$$.fragment,e),U(ye.$$.fragment,e),U(ue.$$.fragment,e),U(me.$$.fragment,e),U(Ce.$$.fragment,e),U(fe.$$.fragment,e),U(ke.$$.fragment,e),U(Ve.$$.fragment,e),U(Fe.$$.fragment,e),U($e.$$.fragment,e),U(Ee.$$.fragment,e),U(qe.$$.fragment,e),U(Xe.$$.fragment,e),U(Pe.$$.fragment,e),U(Oe.$$.fragment,e),Sl=!0)},o(e){T(f.$$.fragment,e),T(b.$$.fragment,e),T(B.$$.fragment,e),T(Z.$$.fragment,e),T(H.$$.fragment,e),T(E.$$.fragment,e),T(X.$$.fragment,e),T(Y.$$.fragment,e),T(z.$$.fragment,e),T(ee.$$.fragment,e),T(le.$$.fragment,e),T(ne.$$.fragment,e),T(oe.$$.fragment,e),T(ye.$$.fragment,e),T(ue.$$.fragment,e),T(me.$$.fragment,e),T(Ce.$$.fragment,e),T(fe.$$.fragment,e),T(ke.$$.fragment,e),T(Ve.$$.fragment,e),T(Fe.$$.fragment,e),T($e.$$.fragment,e),T(Ee.$$.fragment,e),T(qe.$$.fragment,e),T(Xe.$$.fragment,e),T(Pe.$$.fragment,e),T(Oe.$$.fragment,e),Sl=!1},d(e){e&&(l(tt),l(Ke),l(lt),l(st),l(nt),l(at),l(v),l(it),l(k),l(Mt),l(A),l(ot),l(m),l(Jt),l(rt),l(V),l(yt),l(G),l(Ut),l(W),l(Tt),l(N),l(pt),l(wt),l(F),l(ct),l(x),l(ut),l(S),l(dt),l($),l(ht),l(Q),l(mt),l(gt),l(g),l(jt),l(R),l(Ct),l(q),l(It),l(L),l(ft),l(bt),l(_),l(Bt),l(vt),l(kt),l(P),l(At),l(D),l(Zt),l(O),l(Vt),l(K),l(Gt),l(Wt),l(te),l(Nt),l(Ht),l(se),l(Ft),l(xt),l(ae),l(St),l(ie),l($t),l(Me),l(Qt),l(Et),l(Je),l(Rt),l(re),l(qt),l(Lt),l(Ue),l(Xt),l(Te),l(_t),l(pe),l(Yt),l(we),l(zt),l(ce),l(Pt),l(Dt),l(de),l(Ot),l(he),l(Kt),l(el),l(ge),l(tl),l(je),l(ll),l(sl),l(Ie),l(nl),l(al),l(be),l(il),l(Be),l(Ml),l(u),l(ol),l(ve),l(Jl),l(rl),l(Ae),l(yl),l(Ze),l(Ul),l(j),l(Tl),l(pl),l(Ge),l(wl),l(We),l(cl),l(Ne),l(ul),l(He),l(dl),l(hl),l(xe),l(ml),l(Se),l(gl),l(jl),l(Qe),l(Cl),l(Il),l(Re),l(fl),l(bl),l(Le),l(Bl),l(C),l(vl),l(kl),l(_e),l(Al),l(I),l(Zl),l(Ye),l(Vl),l(Gl),l(Wl),l(ze),l(Nl),l(Hl),l(De),l(Fl),l(xl),l(et)),l(h),p(f,e),p(b,e),p(B,e),p(Z,e),p(H,e),p(E,e),p(X,e),p(Y,e),p(z,e),p(ee,e),p(le,e),p(ne,e),p(oe,e),p(ye,e),p(ue,e),p(me,e),p(Ce,e),p(fe,e),p(ke,e),p(Ve,e),p(Fe,e),p($e,e),p(Ee,e),p(qe,e),p(Xe,e),p(Pe,e),p(Oe,e)}}}const on='{"title":"Building Agents That Use Code","local":"building-agents-that-use-code","sections":[{"title":"Why Code Agents?","local":"why-code-agents","sections":[],"depth":2},{"title":"How Does a Code Agent Work?","local":"how-does-a-code-agent-work","sections":[],"depth":2},{"title":"Let’s See Some Examples","local":"lets-see-some-examples","sections":[{"title":"Selecting a Playlist for the Party Using smolagents","local":"selecting-a-playlist-for-the-party-using-smolagents","sections":[],"depth":3},{"title":"Using a Custom Tool to Prepare the Menu","local":"using-a-custom-tool-to-prepare-the-menu","sections":[],"depth":3},{"title":"Using Python Imports Inside the Agent","local":"using-python-imports-inside-the-agent","sections":[],"depth":3},{"title":"Sharing Our Custom Party Preparator Agent to the Hub","local":"sharing-our-custom-party-preparator-agent-to-the-hub","sections":[],"depth":3},{"title":"Inspecting Our Party Preparator Agent with OpenTelemetry and Langfuse 📡","local":"inspecting-our-party-preparator-agent-with-opentelemetry-and-langfuse-","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Jn(El){return Os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class un extends Ks{constructor(h){super(),en(this,h,Jn,Mn,Ps,{})}}export{un as component};
