import{s as ns,a as os,n as as,o as is}from"../chunks/scheduler.505acc25.js";import{S as rs,i as Ms,e as a,s as n,c as M,h as ps,a as i,d as l,b as o,f as Ml,g as p,j as r,k as Xe,l as _e,m as s,n as c,t as h,o as u,p as m}from"../chunks/index.fbb49fb4.js";import{C as cs}from"../chunks/CopyLLMTxtMenu.564b44fd.js";import{C as f}from"../chunks/CodeBlock.7f0851b7.js";import{C as hs}from"../chunks/CourseFloatingBanner.742f9db5.js";import{H as y}from"../chunks/Heading.511e0027.js";import{E as us}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.8c19e80e.js";function ms(pl){let g,Qe,ke,Fe,J,Ye,w,Ne,j,Se,b,cl='As we explored in <a href="https://huggingface.co/learn/agents-course/unit1/tools" rel="nofollow">unit 1</a>, agents use tools to perform various actions. In <code>smolagents</code>, tools are treated as <strong>functions that an LLM can call within an agent system</strong>.',Le,U,hl="To interact with a tool, the LLM needs an <strong>interface description</strong> with these key components:",qe,C,ul="<li><strong>Name</strong>: What the tool is called</li> <li><strong>Tool description</strong>: What the tool does</li> <li><strong>Input types and descriptions</strong>: What arguments the tool accepts</li> <li><strong>Output type</strong>: What the tool returns</li>",ze,I,ml="For instance, while preparing for a party at Wayne Manor, Alfred needs various tools to gather information - from searching for catering services to finding party theme ideas. Here’s how a simple search tool interface might look:",Pe,v,yl="<li><strong>Name:</strong> <code>web_search</code></li> <li><strong>Tool description:</strong> Searches the web for specific queries</li> <li><strong>Input:</strong> <code>query</code> (string) - The search term to look up</li> <li><strong>Output:</strong> String containing the search results</li>",De,B,dl="By using these tools, Alfred can make informed decisions and gather all the information needed for planning the perfect party.",Ke,Z,gl="Below, you can see an animation illustrating how a tool call is managed:",Oe,W,Tl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif" alt="Agentic pipeline from https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',et,G,tt,$,fl="In <code>smolagents</code>, tools can be defined in two ways:",lt,x,Jl="<li><strong>Using the <code>@tool</code> decorator</strong> for simple function-based tools</li> <li><strong>Creating a subclass of <code>Tool</code></strong> for more complex functionality</li>",st,V,nt,A,wl="The <code>@tool</code> decorator is the <strong>recommended way to define simple tools</strong>. Under the hood, smolagents will parse basic information about the function from Python. So if you name your function clearly and write a good docstring, it will be easier for the LLM to use.",ot,H,jl="Using this approach, we define a function with:",at,R,bl="<li><strong>A clear and descriptive function name</strong> that helps the LLM understand its purpose.</li> <li><strong>Type hints for both inputs and outputs</strong> to ensure proper usage.</li> <li><strong>A detailed description</strong>, including an <code>Args:</code> section where each argument is explicitly described. These descriptions provide valuable context for the LLM, so it’s important to write them carefully.</li>",it,k,rt,E,Ul,Mt,T,Cl='<p>You can follow the code in <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb" target="_blank">this notebook</a> that you can run using Google Colab.</p>',pt,X,Il="Let’s imagine that Alfred has already decided on the menu for the party, but now he needs help preparing food for such a large number of guests. To do so, he would like to hire a catering service and needs to identify the highest-rated options available. Alfred can leverage a tool to search for the best catering services in his area.",ct,_,vl="Below is an example of how Alfred can use the <code>@tool</code> decorator to make this happen:",ht,Q,ut,F,mt,Y,Bl='This approach involves creating a subclass of <a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools#smolagents.Tool" rel="nofollow"><code>Tool</code></a>.  For complex tools, we can implement a class instead of a Python function. The class wraps the function with metadata that helps the LLM understand how to use it effectively. In this class, we define:',yt,N,Zl="<li><code>name</code>: The tool’s name.</li> <li><code>description</code>: A description used to populate the agent’s system prompt.</li> <li><code>inputs</code>: A dictionary with keys <code>type</code> and <code>description</code>, providing information to help the Python interpreter process inputs.</li> <li><code>output_type</code>: Specifies the expected output type.</li> <li><code>forward</code>: The method containing the inference logic to execute.</li>",dt,S,Wl="Below, we can see an example of a tool built using <code>Tool</code> and how to integrate it within a <code>CodeAgent</code>.",gt,L,Tt,q,Gl="Alfred’s party at the mansion is a <strong>superhero-themed event</strong>, but he needs some creative ideas to make it truly special. As a fantastic host, he wants to surprise the guests with a unique theme.",ft,z,$l="To do this, he can use an agent that generates superhero-themed party ideas based on a given category. This way, Alfred can find the perfect party theme to wow his guests.",Jt,P,wt,D,xl="With this tool, Alfred will be the ultimate super host, impressing his guests with a superhero-themed party they won’t forget! 🦸‍♂️🦸‍♀️",jt,K,bt,O,Vl='<code>smolagents</code> comes with a set of pre-built tools that can be directly injected into your agent. The <a href="https://huggingface.co/docs/smolagents/guided_tour?build-a-tool=Decorate+a+function+with+%40tool#default-toolbox" rel="nofollow">default toolbox</a> includes:',Ut,ee,Al="<li><strong>PythonInterpreterTool</strong></li> <li><strong>FinalAnswerTool</strong></li> <li><strong>UserInputTool</strong></li> <li><strong>DuckDuckGoSearchTool</strong></li> <li><strong>GoogleSearchTool</strong></li> <li><strong>VisitWebpageTool</strong></li>",Ct,te,Hl="Alfred could use various tools to ensure a flawless party at Wayne Manor:",It,le,Rl="<li><p>First, he could use the <code>DuckDuckGoSearchTool</code> to find creative superhero-themed party ideas.</p></li> <li><p>For catering, he’d rely on the <code>GoogleSearchTool</code> to find the highest-rated services in Gotham.</p></li> <li><p>To manage seating arrangements, Alfred could run calculations with the <code>PythonInterpreterTool</code>.</p></li> <li><p>Once everything is gathered, he’d compile the plan using the <code>FinalAnswerTool</code>.</p></li>",vt,se,kl="With these tools, Alfred guarantees the party is both exceptional and seamless. 🦇💡",Bt,ne,Zt,oe,El="One of the most powerful features of <strong>smolagents</strong> is its ability to share custom tools on the Hub and seamlessly integrate tools created by the community. This includes connecting with <strong>HF Spaces</strong> and <strong>LangChain tools</strong>, significantly enhancing Alfred’s ability to orchestrate an unforgettable party at Wayne Manor. 🎭",Wt,ae,Xl="With these integrations, Alfred can tap into advanced event-planning tools—whether it’s adjusting the lighting for the perfect ambiance, curating the ideal playlist for the party, or coordinating with Gotham’s finest caterers.",Gt,ie,_l="Here are examples showcasing how these functionalities can elevate the party experience:",$t,re,xt,Me,Ql="Sharing your custom tool with the community is easy! Simply upload it to your Hugging Face account using the <code>push_to_hub()</code> method.",Vt,pe,Fl="For instance, Alfred can share his <code>party_theme_tool</code> to help others find the best catering services in Gotham. Here’s how to do it:",At,ce,Ht,he,Rt,ue,Yl="You can easily import tools created by other users using the <code>load_tool()</code> function. For example, Alfred might want to generate a promotional image for the party using AI. Instead of building a tool from scratch, he can leverage a predefined one from the community:",kt,me,Et,ye,Xt,de,Nl="You can also import a HF Space as a tool using <code>Tool.from_space()</code>. This opens up possibilities for integrating with thousands of spaces from the community for tasks from image generation to data analysis.",_t,ge,Sl="The tool will connect with the spaces Gradio backend using the <code>gradio_client</code>, so make sure to install it via <code>pip</code> if you don’t have it already.",Qt,Te,Ll="For the party, Alfred can use an existing HF Space for the generation of the AI-generated image to be used in the announcement (instead of the pre-built tool we mentioned before). Let’s build it!",Ft,fe,Yt,Je,Nt,we,ql="We’ll discuss the <code>LangChain</code> framework in upcoming sections. For now, we just note that we can reuse LangChain tools in your smolagents workflow!",St,je,zl="You can easily load LangChain tools using the <code>Tool.from_langchain()</code> method. Alfred, ever the perfectionist, is preparing for a spectacular superhero night at Wayne Manor while the Waynes are away. To make sure every detail exceeds expectations, he taps into LangChain tools to find top-tier entertainment ideas.",Lt,be,Pl="By using <code>Tool.from_langchain()</code>, Alfred effortlessly adds advanced search functionalities to his smolagent, enabling him to discover exclusive party ideas and services with just a few commands.",qt,Ue,Dl="Here’s how he does it:",zt,Ce,Pt,Ie,Dt,ve,Kl='<code>smolagents</code> also allows importing tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai" rel="nofollow">smithery.ai</a>. If you want to dive deeper about MCP, you can check our <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">free MCP Course</a>.',Kt,d,Ae,Ol="Install mcp client",il,He,es="We first need to install the <code>mcp</code> integration for <code>smolagents</code>.",rl,Be,Ot,Ze,ts="The MCP servers tools can be loaded in a ToolCollection object as follow:",el,We,tl,Ge,ls="With this setup, Alfred can quickly discover luxurious entertainment options, ensuring Gotham’s elite guests have an unforgettable experience. This tool helps him curate the perfect superhero-themed event for Wayne Manor! 🎉",ll,$e,sl,xe,ss='<li><a href="https://huggingface.co/docs/smolagents/tutorials/tools" rel="nofollow">Tools Tutorial</a> - Explore this tutorial to learn how to work with tools effectively.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools" rel="nofollow">Tools Documentation</a> - Comprehensive reference documentation on tools.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/guided_tour#tools" rel="nofollow">Tools Guided Tour</a> - A step-by-step guided tour to help you build and utilize tools efficiently.</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">Building Effective Agents</a> - A detailed guide on best practices for developing reliable and high-performance custom function agents.</li>',nl,Ve,ol,Ee,al;return J=new hs({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),w=new cs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new y({props:{title:"Tools",local:"tools",headingTag:"h1"}}),G=new y({props:{title:"Tool Creation Methods",local:"tool-creation-methods",headingTag:"h2"}}),V=new y({props:{title:"The @tool Decorator",local:"the-tool-decorator",headingTag:"h3"}}),k=new y({props:{title:"Generating a tool that retrieves the highest-rated catering",local:"generating-a-tool-that-retrieves-the-highest-rated-catering",headingTag:"h4"}}),Q=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, tool

<span class="hljs-comment"># Let&#x27;s pretend we have a function that fetches the highest-rated catering services.</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    This tool returns the highest-rated catering service in Gotham City.

    Args:
        query: A search term for finding catering services.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example list of catering services and their ratings</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }

    <span class="hljs-comment"># Find the highest rated catering service (simulating search query filtering)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)

    <span class="hljs-keyword">return</span> best_service


agent = CodeAgent(tools=[catering_service_tool], model=InferenceClientModel())

<span class="hljs-comment"># Run the agent to find the best catering service</span>
result = agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the highest-rated catering service in Gotham City?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)   <span class="hljs-comment"># Output: Gotham Catering Co.</span>`,wrap:!1}}),F=new y({props:{title:"Defining a Tool as a Python Class",local:"defining-a-tool-as-a-python-class",headingTag:"h3"}}),L=new y({props:{title:"Generating a tool to generate ideas about the superhero-themed party",local:"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party",headingTag:"h4"}}),P=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool, CodeAgent, InferenceClientModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This tool suggests creative superhero-themed party ideas based on a category.
    It returns a unique party theme idea.&quot;&quot;&quot;</span>

    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The type of superhero party (e.g., &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, &#x27;futuristic Gotham&#x27;).&quot;</span>,
        }
    }

    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Justice League Gala: Guests come dressed as their favorite DC heroes with themed cocktails like &#x27;The Kryptonite Punch&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Neo-Gotham Night: A cyberpunk-style party inspired by Batman Beyond, with neon decorations and futuristic gadgets.&quot;</span>
        }

        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Themed party idea not found. Try &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, or &#x27;futuristic Gotham&#x27;.&quot;</span>)

<span class="hljs-comment"># Instantiate the tool</span>
party_theme_tool = SuperheroPartyThemeTool()
agent = CodeAgent(tools=[party_theme_tool], model=InferenceClientModel())

<span class="hljs-comment"># Run the agent to generate a party theme idea</span>
result = agent.run(
    <span class="hljs-string">&quot;What would be a good superhero party idea for a &#x27;villain masquerade&#x27; theme?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)  <span class="hljs-comment"># Output: &quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>`,wrap:!1}}),K=new y({props:{title:"Default Toolbox",local:"default-toolbox",headingTag:"h2"}}),ne=new y({props:{title:"Sharing and Importing Tools",local:"sharing-and-importing-tools",headingTag:"h2"}}),re=new y({props:{title:"Sharing a Tool to the Hub",local:"sharing-a-tool-to-the-hub",headingTag:"h3"}}),ce=new f({props:{code:"cGFydHlfdGhlbWVfdG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGcGFydHlfdGhlbWVfdG9vbCUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'party_theme_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/party_theme_tool&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),he=new y({props:{title:"Importing a Tool from the Hub",local:"importing-a-tool-from-the-hub",headingTag:"h3"}}),me=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMGxvYWRfdG9vbCglMEElMjAlMjAlMjAlMjAlMjJtLXJpYyUyRnRleHQtdG8taW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCklMEEpJTBBJTBBYWdlbnQucnVuKCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwYSUyMGx1eHVyaW91cyUyMHN1cGVyaGVyby10aGVtZWQlMjBwYXJ0eSUyMGF0JTIwV2F5bmUlMjBNYW5vciUyMHdpdGglMjBtYWRlLXVwJTIwc3VwZXJoZXJvcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel

image_generation_tool = load_tool(
    <span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)

agent = CodeAgent(
    tools=[image_generation_tool],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;Generate an image of a luxurious superhero-themed party at Wayne Manor with made-up superheros.&quot;</span>)`,wrap:!1}}),ye=new y({props:{title:"Importing a Hugging Face Space as a Tool",local:"importing-a-hugging-face-space-as-a-tool",headingTag:"h3"}}),fe=new f({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fc3BhY2UoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJpbWFnZV9nZW5lcmF0b3IlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMGZyb20lMjBhJTIwcHJvbXB0JTIyJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySW1wcm92ZSUyMHRoaXMlMjBwcm9tcHQlMkMlMjB0aGVuJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwb2YlMjBpdC4lMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IndXNlcl9wcm9tcHQnJTNBJTIwJ0ElMjBncmFuZCUyMHN1cGVyaGVyby10aGVtZWQlMjBwYXJ0eSUyMGF0JTIwV2F5bmUlMjBNYW5vciUyQyUyMHdpdGglMjBBbGZyZWQlMjBvdmVyc2VlaW5nJTIwYSUyMGx1eHVyaW91cyUyMGdhbGEnJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>,
    additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A grand superhero-themed party at Wayne Manor, with Alfred overseeing a luxurious gala&#x27;</span>}
)`,wrap:!1}}),Je=new y({props:{title:"Importing a LangChain Tool",local:"importing-a-langchain-tool",headingTag:"h3"}}),Ce=new f({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMFRvb2wuZnJvbV9sYW5nY2hhaW4obG9hZF90b29scyglNUIlMjJzZXJwYXBpJTIyJTVEKSU1QjAlNUQpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUyMlNlYXJjaCUyMGZvciUyMGx1eHVyeSUyMGVudGVydGFpbm1lbnQlMjBpZGVhcyUyMGZvciUyMGElMjBzdXBlcmhlcm8tdGhlbWVkJTIwZXZlbnQlMkMlMjBzdWNoJTIwYXMlMjBsaXZlJTIwcGVyZm9ybWFuY2VzJTIwYW5kJTIwaW50ZXJhY3RpdmUlMjBleHBlcmllbmNlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;Search for luxury entertainment ideas for a superhero-themed event, such as live performances and interactive experiences.&quot;</span>)`,wrap:!1}}),Ie=new y({props:{title:"Importing a tool collection from any MCP server",local:"importing-a-tool-collection-from-any-mcp-server",headingTag:"h3"}}),Be=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJtY3AlNUQlMjI=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[mcp]&quot;</span>',wrap:!1}}),We=new f({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMFRvb2xDb2xsZWN0aW9uJTJDJTIwQ29kZUFnZW50JTBBZnJvbSUyMG1jcCUyMGltcG9ydCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMEElMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel


model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)


server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),$e=new y({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ve=new us({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/tools.mdx"}}),{c(){g=a("meta"),Qe=n(),ke=a("p"),Fe=n(),M(J.$$.fragment),Ye=n(),M(w.$$.fragment),Ne=n(),M(j.$$.fragment),Se=n(),b=a("p"),b.innerHTML=cl,Le=n(),U=a("p"),U.innerHTML=hl,qe=n(),C=a("ul"),C.innerHTML=ul,ze=n(),I=a("p"),I.textContent=ml,Pe=n(),v=a("ul"),v.innerHTML=yl,De=n(),B=a("p"),B.textContent=dl,Ke=n(),Z=a("p"),Z.textContent=gl,Oe=n(),W=a("p"),W.innerHTML=Tl,et=n(),M(G.$$.fragment),tt=n(),$=a("p"),$.innerHTML=fl,lt=n(),x=a("ol"),x.innerHTML=Jl,st=n(),M(V.$$.fragment),nt=n(),A=a("p"),A.innerHTML=wl,ot=n(),H=a("p"),H.textContent=jl,at=n(),R=a("ul"),R.innerHTML=bl,it=n(),M(k.$$.fragment),rt=n(),E=a("img"),Mt=n(),T=a("blockquote"),T.innerHTML=Cl,pt=n(),X=a("p"),X.textContent=Il,ct=n(),_=a("p"),_.innerHTML=vl,ht=n(),M(Q.$$.fragment),ut=n(),M(F.$$.fragment),mt=n(),Y=a("p"),Y.innerHTML=Bl,yt=n(),N=a("ul"),N.innerHTML=Zl,dt=n(),S=a("p"),S.innerHTML=Wl,gt=n(),M(L.$$.fragment),Tt=n(),q=a("p"),q.innerHTML=Gl,ft=n(),z=a("p"),z.textContent=$l,Jt=n(),M(P.$$.fragment),wt=n(),D=a("p"),D.textContent=xl,jt=n(),M(K.$$.fragment),bt=n(),O=a("p"),O.innerHTML=Vl,Ut=n(),ee=a("ul"),ee.innerHTML=Al,Ct=n(),te=a("p"),te.textContent=Hl,It=n(),le=a("ul"),le.innerHTML=Rl,vt=n(),se=a("p"),se.textContent=kl,Bt=n(),M(ne.$$.fragment),Zt=n(),oe=a("p"),oe.innerHTML=El,Wt=n(),ae=a("p"),ae.textContent=Xl,Gt=n(),ie=a("p"),ie.textContent=_l,$t=n(),M(re.$$.fragment),xt=n(),Me=a("p"),Me.innerHTML=Ql,Vt=n(),pe=a("p"),pe.innerHTML=Fl,At=n(),M(ce.$$.fragment),Ht=n(),M(he.$$.fragment),Rt=n(),ue=a("p"),ue.innerHTML=Yl,kt=n(),M(me.$$.fragment),Et=n(),M(ye.$$.fragment),Xt=n(),de=a("p"),de.innerHTML=Nl,_t=n(),ge=a("p"),ge.innerHTML=Sl,Qt=n(),Te=a("p"),Te.textContent=Ll,Ft=n(),M(fe.$$.fragment),Yt=n(),M(Je.$$.fragment),Nt=n(),we=a("p"),we.innerHTML=ql,St=n(),je=a("p"),je.innerHTML=zl,Lt=n(),be=a("p"),be.innerHTML=Pl,qt=n(),Ue=a("p"),Ue.textContent=Dl,zt=n(),M(Ce.$$.fragment),Pt=n(),M(Ie.$$.fragment),Dt=n(),ve=a("p"),ve.innerHTML=Kl,Kt=n(),d=a("details"),Ae=a("summary"),Ae.textContent=Ol,il=n(),He=a("p"),He.innerHTML=es,rl=n(),M(Be.$$.fragment),Ot=n(),Ze=a("p"),Ze.textContent=ts,el=n(),M(We.$$.fragment),tl=n(),Ge=a("p"),Ge.textContent=ls,ll=n(),M($e.$$.fragment),sl=n(),xe=a("ul"),xe.innerHTML=ss,nl=n(),M(Ve.$$.fragment),ol=n(),Ee=a("p"),this.h()},l(e){const t=ps("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(l),Qe=o(e),ke=i(e,"P",{}),Ml(ke).forEach(l),Fe=o(e),p(J.$$.fragment,e),Ye=o(e),p(w.$$.fragment,e),Ne=o(e),p(j.$$.fragment,e),Se=o(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-11yvg4r"&&(b.innerHTML=cl),Le=o(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1w4pglg"&&(U.innerHTML=hl),qe=o(e),C=i(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-6t5tqb"&&(C.innerHTML=ul),ze=o(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-xxdm5o"&&(I.textContent=ml),Pe=o(e),v=i(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-1y8sxu4"&&(v.innerHTML=yl),De=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1s1gqsf"&&(B.textContent=dl),Ke=o(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-gwhed0"&&(Z.textContent=gl),Oe=o(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1j9zfgm"&&(W.innerHTML=Tl),et=o(e),p(G.$$.fragment,e),tt=o(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-16o4n5p"&&($.innerHTML=fl),lt=o(e),x=i(e,"OL",{"data-svelte-h":!0}),r(x)!=="svelte-12j65du"&&(x.innerHTML=Jl),st=o(e),p(V.$$.fragment,e),nt=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1dh93c8"&&(A.innerHTML=wl),ot=o(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1hsdx6m"&&(H.textContent=jl),at=o(e),R=i(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1eycwmn"&&(R.innerHTML=bl),it=o(e),p(k.$$.fragment,e),rt=o(e),E=i(e,"IMG",{src:!0,alt:!0}),Mt=o(e),T=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1bxj2l0"&&(T.innerHTML=Cl),pt=o(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-5qyq1f"&&(X.textContent=Il),ct=o(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1f9djim"&&(_.innerHTML=vl),ht=o(e),p(Q.$$.fragment,e),ut=o(e),p(F.$$.fragment,e),mt=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-o654lj"&&(Y.innerHTML=Bl),yt=o(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-9qay4f"&&(N.innerHTML=Zl),dt=o(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1pi6ccj"&&(S.innerHTML=Wl),gt=o(e),p(L.$$.fragment,e),Tt=o(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1ugsnpu"&&(q.innerHTML=Gl),ft=o(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1t4n8j6"&&(z.textContent=$l),Jt=o(e),p(P.$$.fragment,e),wt=o(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-148a819"&&(D.textContent=xl),jt=o(e),p(K.$$.fragment,e),bt=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1se8fk8"&&(O.innerHTML=Vl),Ut=o(e),ee=i(e,"UL",{"data-svelte-h":!0}),r(ee)!=="svelte-1n5ilxc"&&(ee.innerHTML=Al),Ct=o(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-13b0t4l"&&(te.textContent=Hl),It=o(e),le=i(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-3o3ymr"&&(le.innerHTML=Rl),vt=o(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-13o2uyy"&&(se.textContent=kl),Bt=o(e),p(ne.$$.fragment,e),Zt=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-bfnw4l"&&(oe.innerHTML=El),Wt=o(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-p4tufw"&&(ae.textContent=Xl),Gt=o(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-fsw72s"&&(ie.textContent=_l),$t=o(e),p(re.$$.fragment,e),xt=o(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1cmmx6"&&(Me.innerHTML=Ql),Vt=o(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-2q1hux"&&(pe.innerHTML=Fl),At=o(e),p(ce.$$.fragment,e),Ht=o(e),p(he.$$.fragment,e),Rt=o(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1xtes2g"&&(ue.innerHTML=Yl),kt=o(e),p(me.$$.fragment,e),Et=o(e),p(ye.$$.fragment,e),Xt=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1mpb2vu"&&(de.innerHTML=Nl),_t=o(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-lat3p2"&&(ge.innerHTML=Sl),Qt=o(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1694k70"&&(Te.textContent=Ll),Ft=o(e),p(fe.$$.fragment,e),Yt=o(e),p(Je.$$.fragment,e),Nt=o(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1osr2dc"&&(we.innerHTML=ql),St=o(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-n7r7ow"&&(je.innerHTML=zl),Lt=o(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-sjrzcz"&&(be.innerHTML=Pl),qt=o(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-154co1f"&&(Ue.textContent=Dl),zt=o(e),p(Ce.$$.fragment,e),Pt=o(e),p(Ie.$$.fragment,e),Dt=o(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-eejp75"&&(ve.innerHTML=Kl),Kt=o(e),d=i(e,"DETAILS",{});var Re=Ml(d);Ae=i(Re,"SUMMARY",{"data-svelte-h":!0}),r(Ae)!=="svelte-17v5fx6"&&(Ae.textContent=Ol),il=o(Re),He=i(Re,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1yjphc7"&&(He.innerHTML=es),rl=o(Re),p(Be.$$.fragment,Re),Re.forEach(l),Ot=o(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1ki4qbm"&&(Ze.textContent=ts),el=o(e),p(We.$$.fragment,e),tl=o(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1yv1f1"&&(Ge.textContent=ls),ll=o(e),p($e.$$.fragment,e),sl=o(e),xe=i(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-1gwl39i"&&(xe.innerHTML=ss),nl=o(e),p(Ve.$$.fragment,e),ol=o(e),Ee=i(e,"P",{}),Ml(Ee).forEach(l),this.h()},h(){Xe(g,"name","hf:doc:metadata"),Xe(g,"content",ys),os(E.src,Ul="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-catering.jpg")||Xe(E,"src",Ul),Xe(E,"alt","Alfred Catering"),Xe(T,"class","tip")},m(e,t){_e(document.head,g),s(e,Qe,t),s(e,ke,t),s(e,Fe,t),c(J,e,t),s(e,Ye,t),c(w,e,t),s(e,Ne,t),c(j,e,t),s(e,Se,t),s(e,b,t),s(e,Le,t),s(e,U,t),s(e,qe,t),s(e,C,t),s(e,ze,t),s(e,I,t),s(e,Pe,t),s(e,v,t),s(e,De,t),s(e,B,t),s(e,Ke,t),s(e,Z,t),s(e,Oe,t),s(e,W,t),s(e,et,t),c(G,e,t),s(e,tt,t),s(e,$,t),s(e,lt,t),s(e,x,t),s(e,st,t),c(V,e,t),s(e,nt,t),s(e,A,t),s(e,ot,t),s(e,H,t),s(e,at,t),s(e,R,t),s(e,it,t),c(k,e,t),s(e,rt,t),s(e,E,t),s(e,Mt,t),s(e,T,t),s(e,pt,t),s(e,X,t),s(e,ct,t),s(e,_,t),s(e,ht,t),c(Q,e,t),s(e,ut,t),c(F,e,t),s(e,mt,t),s(e,Y,t),s(e,yt,t),s(e,N,t),s(e,dt,t),s(e,S,t),s(e,gt,t),c(L,e,t),s(e,Tt,t),s(e,q,t),s(e,ft,t),s(e,z,t),s(e,Jt,t),c(P,e,t),s(e,wt,t),s(e,D,t),s(e,jt,t),c(K,e,t),s(e,bt,t),s(e,O,t),s(e,Ut,t),s(e,ee,t),s(e,Ct,t),s(e,te,t),s(e,It,t),s(e,le,t),s(e,vt,t),s(e,se,t),s(e,Bt,t),c(ne,e,t),s(e,Zt,t),s(e,oe,t),s(e,Wt,t),s(e,ae,t),s(e,Gt,t),s(e,ie,t),s(e,$t,t),c(re,e,t),s(e,xt,t),s(e,Me,t),s(e,Vt,t),s(e,pe,t),s(e,At,t),c(ce,e,t),s(e,Ht,t),c(he,e,t),s(e,Rt,t),s(e,ue,t),s(e,kt,t),c(me,e,t),s(e,Et,t),c(ye,e,t),s(e,Xt,t),s(e,de,t),s(e,_t,t),s(e,ge,t),s(e,Qt,t),s(e,Te,t),s(e,Ft,t),c(fe,e,t),s(e,Yt,t),c(Je,e,t),s(e,Nt,t),s(e,we,t),s(e,St,t),s(e,je,t),s(e,Lt,t),s(e,be,t),s(e,qt,t),s(e,Ue,t),s(e,zt,t),c(Ce,e,t),s(e,Pt,t),c(Ie,e,t),s(e,Dt,t),s(e,ve,t),s(e,Kt,t),s(e,d,t),_e(d,Ae),_e(d,il),_e(d,He),_e(d,rl),c(Be,d,null),s(e,Ot,t),s(e,Ze,t),s(e,el,t),c(We,e,t),s(e,tl,t),s(e,Ge,t),s(e,ll,t),c($e,e,t),s(e,sl,t),s(e,xe,t),s(e,nl,t),c(Ve,e,t),s(e,ol,t),s(e,Ee,t),al=!0},p:as,i(e){al||(h(J.$$.fragment,e),h(w.$$.fragment,e),h(j.$$.fragment,e),h(G.$$.fragment,e),h(V.$$.fragment,e),h(k.$$.fragment,e),h(Q.$$.fragment,e),h(F.$$.fragment,e),h(L.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(me.$$.fragment,e),h(ye.$$.fragment,e),h(fe.$$.fragment,e),h(Je.$$.fragment,e),h(Ce.$$.fragment,e),h(Ie.$$.fragment,e),h(Be.$$.fragment,e),h(We.$$.fragment,e),h($e.$$.fragment,e),h(Ve.$$.fragment,e),al=!0)},o(e){u(J.$$.fragment,e),u(w.$$.fragment,e),u(j.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(k.$$.fragment,e),u(Q.$$.fragment,e),u(F.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(me.$$.fragment,e),u(ye.$$.fragment,e),u(fe.$$.fragment,e),u(Je.$$.fragment,e),u(Ce.$$.fragment,e),u(Ie.$$.fragment,e),u(Be.$$.fragment,e),u(We.$$.fragment,e),u($e.$$.fragment,e),u(Ve.$$.fragment,e),al=!1},d(e){e&&(l(Qe),l(ke),l(Fe),l(Ye),l(Ne),l(Se),l(b),l(Le),l(U),l(qe),l(C),l(ze),l(I),l(Pe),l(v),l(De),l(B),l(Ke),l(Z),l(Oe),l(W),l(et),l(tt),l($),l(lt),l(x),l(st),l(nt),l(A),l(ot),l(H),l(at),l(R),l(it),l(rt),l(E),l(Mt),l(T),l(pt),l(X),l(ct),l(_),l(ht),l(ut),l(mt),l(Y),l(yt),l(N),l(dt),l(S),l(gt),l(Tt),l(q),l(ft),l(z),l(Jt),l(wt),l(D),l(jt),l(bt),l(O),l(Ut),l(ee),l(Ct),l(te),l(It),l(le),l(vt),l(se),l(Bt),l(Zt),l(oe),l(Wt),l(ae),l(Gt),l(ie),l($t),l(xt),l(Me),l(Vt),l(pe),l(At),l(Ht),l(Rt),l(ue),l(kt),l(Et),l(Xt),l(de),l(_t),l(ge),l(Qt),l(Te),l(Ft),l(Yt),l(Nt),l(we),l(St),l(je),l(Lt),l(be),l(qt),l(Ue),l(zt),l(Pt),l(Dt),l(ve),l(Kt),l(d),l(Ot),l(Ze),l(el),l(tl),l(Ge),l(ll),l(sl),l(xe),l(nl),l(ol),l(Ee)),l(g),m(J,e),m(w,e),m(j,e),m(G,e),m(V,e),m(k,e),m(Q,e),m(F,e),m(L,e),m(P,e),m(K,e),m(ne,e),m(re,e),m(ce,e),m(he,e),m(me,e),m(ye,e),m(fe,e),m(Je,e),m(Ce,e),m(Ie,e),m(Be),m(We,e),m($e,e),m(Ve,e)}}}const ys='{"title":"Tools","local":"tools","sections":[{"title":"Tool Creation Methods","local":"tool-creation-methods","sections":[{"title":"The @tool Decorator","local":"the-tool-decorator","sections":[{"title":"Generating a tool that retrieves the highest-rated catering","local":"generating-a-tool-that-retrieves-the-highest-rated-catering","sections":[],"depth":4}],"depth":3},{"title":"Defining a Tool as a Python Class","local":"defining-a-tool-as-a-python-class","sections":[{"title":"Generating a tool to generate ideas about the superhero-themed party","local":"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Default Toolbox","local":"default-toolbox","sections":[],"depth":2},{"title":"Sharing and Importing Tools","local":"sharing-and-importing-tools","sections":[{"title":"Sharing a Tool to the Hub","local":"sharing-a-tool-to-the-hub","sections":[],"depth":3},{"title":"Importing a Tool from the Hub","local":"importing-a-tool-from-the-hub","sections":[],"depth":3},{"title":"Importing a Hugging Face Space as a Tool","local":"importing-a-hugging-face-space-as-a-tool","sections":[],"depth":3},{"title":"Importing a LangChain Tool","local":"importing-a-langchain-tool","sections":[],"depth":3},{"title":"Importing a tool collection from any MCP server","local":"importing-a-tool-collection-from-any-mcp-server","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function ds(pl){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends rs{constructor(g){super(),Ms(this,g,ds,ms,ns,{})}}export{Us as component};
