import{s as $t,a as _t,n as Lt,o as Ht}from"../chunks/scheduler.505acc25.js";import{S as Bt,i as Nt,e as i,s as l,c as m,h as zt,a as o,d as a,b as s,f as At,g as f,j as r,k as ae,l as Gt,m as n,n as M,t as y,o as g,p as T}from"../chunks/index.fbb49fb4.js";import{C as Pt}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as Et}from"../chunks/CodeBlock.2ead06c8.js";import{H as Fe}from"../chunks/Heading.511e0027.js";import{E as kt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function St(Oe){let u,se,ne,ie,v,oe,j,re,p,De="<p>En esta sección, exploramos los pasos concretos que un agente de IA toma para interactuar con su entorno.</p> <p>Cubriremos cómo se representan las acciones (usando JSON o código), la importancia del enfoque de detener y analizar, e introduciremos diferentes tipos de agentes.</p>",ue,J,Ke="Las acciones son los pasos concretos que un <strong>agente de IA toma para interactuar con su entorno</strong>.",pe,C,et="Ya sea navegando por la web en busca de información o controlando un dispositivo físico, cada acción es una operación deliberada ejecutada por el agente.",ce,w,tt="Por ejemplo, un agente que asiste con servicio al cliente podría recuperar datos del cliente, ofrecer artículos de soporte o transferir problemas a un representante humano.",de,x,me,b,at="Hay múltiples tipos de Agentes que realizan acciones de manera diferente:",fe,I,nt="<thead><tr><th>Tipo de Agente</th> <th>Descripción</th></tr></thead> <tbody><tr><td>Agente JSON</td> <td>La Acción a tomar se especifica en formato JSON.</td></tr> <tr><td>Agente de Código</td> <td>El Agente escribe un bloque de código que es interpretado externamente.</td></tr> <tr><td>Agente de llamada a funciones</td> <td>Es una subcategoría del Agente JSON que ha sido ajustado para generar un nuevo mensaje para cada acción.</td></tr></tbody>",Me,h,lt="Las acciones en sí pueden servir para muchos propósitos:",ye,U,st="<thead><tr><th>Tipo de Acción</th> <th>Descripción</th></tr></thead> <tbody><tr><td>Recopilación de Información</td> <td>Realizar búsquedas web, consultar bases de datos o recuperar documentos.</td></tr> <tr><td>Uso de Herramientas</td> <td>Hacer llamadas a API, realizar cálculos y ejecutar código.</td></tr> <tr><td>Interacción con el Entorno</td> <td>Manipular interfaces digitales o controlar dispositivos físicos.</td></tr> <tr><td>Comunicación</td> <td>Interactuar con usuarios a través de chat o colaborar con otros agentes.</td></tr></tbody>",ge,q,it="Una parte crucial de un agente es la <strong>capacidad de DETENER la generación de nuevos tokens cuando una acción está completa</strong>, y eso es cierto para todos los formatos de Agente: JSON, código o llamada a funciones. Esto previene la salida no intencionada y asegura que la respuesta del agente sea clara y precisa.",Te,A,ot="El LLM solo maneja texto y lo usa para describir la acción que quiere tomar y los parámetros a suministrar a la herramienta.",ve,E,je,$,rt="Un método clave para implementar acciones es el <strong>enfoque de detener y analizar</strong>. Este método asegura que la salida del agente sea estructurada y predecible:",Je,_,ut="<li><strong>Generación en un Formato Estructurado</strong>:</li>",Ce,L,pt="El agente produce su acción prevista en un formato claro y predeterminado (JSON o código).",we,c,ct="<li><strong>Deteniendo la Generación Adicional</strong>:</li>",xe,H,dt="Una vez que la acción está completa, <strong>el agente deja de generar tokens adicionales</strong>. Esto previene salidas adicionales o erróneas.",be,d,mt="<li><strong>Analizando la Salida</strong>:</li>",Ie,B,ft="Un analizador externo lee la acción formateada, determina qué Herramienta llamar y extrae los parámetros requeridos.",he,N,Mt="Por ejemplo, un agente que necesita verificar el clima podría producir:",Ue,z,qe,G,yt="El framework puede entonces analizar fácilmente el nombre de la función a llamar y los argumentos a aplicar.",Ae,P,gt="Este formato claro y legible por máquina minimiza errores y permite que herramientas externas procesen con precisión el comando del agente.",Ee,k,Tt=`Nota: Los agentes de llamada a funciones operan de manera similar estructurando cada acción para que una función designada sea invocada con los argumentos correctos.
Profundizaremos en esos tipos de Agentes en una Unidad futura.`,$e,S,_e,Z,vt=`Un enfoque alternativo es usar <em>Agentes de Código</em>.
La idea es: <strong>en lugar de producir un simple objeto JSON</strong>, un Agente de Código genera un <strong>bloque de código ejecutable—típicamente en un lenguaje de alto nivel como Python</strong>.`,Le,W,jt,He,R,Jt="Este enfoque ofrece varias ventajas:",Be,X,Ct="<li><strong>Expresividad:</strong> El código puede representar naturalmente lógica compleja, incluyendo bucles, condicionales y funciones anidadas, proporcionando mayor flexibilidad que JSON.</li> <li><strong>Modularidad y Reusabilidad:</strong> El código generado puede incluir funciones y módulos que son reutilizables a través de diferentes acciones o tareas.</li> <li><strong>Depuración Mejorada:</strong> Con una sintaxis de programación bien definida, los errores de código son a menudo más fáciles de detectar y corregir.</li> <li><strong>Integración Directa:</strong> Los Agentes de Código pueden integrarse directamente con bibliotecas y APIs externas, permitiendo operaciones más complejas como procesamiento de datos o toma de decisiones en tiempo real.</li>",Ne,V,wt="Por ejemplo, un Agente de Código encargado de obtener el clima podría generar el siguiente fragmento de Python:",ze,Y,Ge,Q,xt="En este ejemplo, el Agente de Código:",Pe,F,bt="<li>Recupera datos del clima <strong>a través de una llamada a API</strong>,</li> <li>Procesa la respuesta,</li> <li>Y usa la función print() para producir una respuesta final.</li>",ke,O,It="Este método <strong>también sigue el enfoque de detener y analizar</strong> delimitando claramente el bloque de código y señalando cuando la ejecución está completa (aquí, imprimiendo el final_answer).",Se,Ze,We,D,ht="Aprendimos que las Acciones conectan el razonamiento interno de un agente y sus interacciones con el mundo real ejecutando tareas claras y estructuradas—ya sea a través de JSON, código o llamadas a funciones.",Re,K,Ut="Esta ejecución deliberada asegura que cada acción sea precisa y esté lista para el procesamiento externo a través del enfoque de detener y analizar. En la siguiente sección, exploraremos las Observaciones para ver cómo los agentes capturan e integran retroalimentación de su entorno.",Xe,ee,qt="Después de esto, ¡<strong>finalmente estaremos listos para construir nuestro primer Agente</strong>!",Ve,te,Ye,le,Qe;return v=new Pt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new Fe({props:{title:"Acciones: Permitiendo al Agente Interactuar con Su Entorno",local:"acciones-permitiendo-al-agente-interactuar-con-su-entorno",headingTag:"h1"}}),x=new Fe({props:{title:"Tipos de Acciones de Agentes",local:"tipos-de-acciones-de-agentes",headingTag:"h2"}}),E=new Fe({props:{title:"El Enfoque de Detener y Analizar",local:"el-enfoque-de-detener-y-analizar",headingTag:"h2"}}),z=new Et({props:{code:"VGhvdWdodCUzQSUyME5lY2VzaXRvJTIwdmVyaWZpY2FyJTIwZWwlMjBjbGltYSUyMGFjdHVhbCUyMHBhcmElMjBOdWV2YSUyMFlvcmsuJTBBQWN0aW9uJTIwJTNBJTBBJTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb25faW5wdXQlMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMk51ZXZhJTIwWW9yayUyMiU3RCUwQSU3RA==",highlighted:`Thought<span class="hljs-punctuation">:</span> Necesito verificar el clima actual para Nueva York.
Action <span class="hljs-punctuation">:</span>
<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Nueva York&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),S=new Fe({props:{title:"Agentes de Código",local:"agentes-de-código",headingTag:"h2"}}),Y=new Et({props:{code:"JTIzJTIwRWplbXBsbyUyMGRlJTIwQWdlbnRlJTIwZGUlMjBDJUMzJUIzZGlnbyUzQSUyMFJlY3VwZXJhciUyMEluZm9ybWFjaSVDMyVCM24lMjBkZWwlMjBDbGltYSUwQWRlZiUyMGdldF93ZWF0aGVyKGNpdHkpJTNBJTBBJTIwJTIwJTIwJTIwaW1wb3J0JTIwcmVxdWVzdHMlMEElMjAlMjAlMjAlMjBhcGlfdXJsJTIwJTNEJTIwZiUyMmh0dHBzJTNBJTJGJTJGYXBpLndlYXRoZXIuY29tJTJGdjElMkZsb2NhdGlvbiUyRiU3QmNpdHklN0QlM0ZhcGlLZXklM0RZT1VSX0FQSV9LRVklMjIlMEElMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldChhcGlfdXJsKSUwQSUyMCUyMCUyMCUyMGlmJTIwcmVzcG9uc2Uuc3RhdHVzX2NvZGUlMjAlM0QlM0QlMjAyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhJTIwJTNEJTIwcmVzcG9uc2UuanNvbigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGF0YS5nZXQoJTIyd2VhdGhlciUyMiUyQyUyMCUyMk5vJTIwaGF5JTIwaW5mb3JtYWNpJUMzJUIzbiUyMGRlbCUyMGNsaW1hJTIwZGlzcG9uaWJsZSUyMiklMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyRXJyb3IlM0ElMjBObyUyMHNlJTIwcHVkbyUyMG9idGVuZXIlMjBkYXRvcyUyMGRlbCUyMGNsaW1hLiUyMiUwQSUwQSUyMyUyMEVqZWN1dGFyJTIwbGElMjBmdW5jaSVDMyVCM24lMjB5JTIwcHJlcGFyYXIlMjBsYSUyMHJlc3B1ZXN0YSUyMGZpbmFsJTBBcmVzdWx0JTIwJTNEJTIwZ2V0X3dlYXRoZXIoJTIyTnVldmElMjBZb3JrJTIyKSUwQWZpbmFsX2Fuc3dlciUyMCUzRCUyMGYlMjJFbCUyMGNsaW1hJTIwYWN0dWFsJTIwZW4lMjBOdWV2YSUyMFlvcmslMjBlcyUzQSUyMCU3QnJlc3VsdCU3RCUyMiUwQXByaW50KGZpbmFsX2Fuc3dlcik=",highlighted:`<span class="hljs-comment"># Ejemplo de Agente de Código: Recuperar Información del Clima</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;No hay información del clima disponible&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Error: No se pudo obtener datos del clima.&quot;</span>

<span class="hljs-comment"># Ejecutar la función y preparar la respuesta final</span>
result = get_weather(<span class="hljs-string">&quot;Nueva York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;El clima actual en Nueva York es: <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),te=new kt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit1/actions.mdx"}}),{c(){u=i("meta"),se=l(),ne=i("p"),ie=l(),m(v.$$.fragment),oe=l(),m(j.$$.fragment),re=l(),p=i("blockquote"),p.innerHTML=De,ue=l(),J=i("p"),J.innerHTML=Ke,pe=l(),C=i("p"),C.textContent=et,ce=l(),w=i("p"),w.textContent=tt,de=l(),m(x.$$.fragment),me=l(),b=i("p"),b.textContent=at,fe=l(),I=i("table"),I.innerHTML=nt,Me=l(),h=i("p"),h.textContent=lt,ye=l(),U=i("table"),U.innerHTML=st,ge=l(),q=i("p"),q.innerHTML=it,Te=l(),A=i("p"),A.textContent=ot,ve=l(),m(E.$$.fragment),je=l(),$=i("p"),$.innerHTML=rt,Je=l(),_=i("ol"),_.innerHTML=ut,Ce=l(),L=i("p"),L.textContent=pt,we=l(),c=i("ol"),c.innerHTML=ct,xe=l(),H=i("p"),H.innerHTML=dt,be=l(),d=i("ol"),d.innerHTML=mt,Ie=l(),B=i("p"),B.textContent=ft,he=l(),N=i("p"),N.textContent=Mt,Ue=l(),m(z.$$.fragment),qe=l(),G=i("p"),G.textContent=yt,Ae=l(),P=i("p"),P.textContent=gt,Ee=l(),k=i("p"),k.textContent=Tt,$e=l(),m(S.$$.fragment),_e=l(),Z=i("p"),Z.innerHTML=vt,Le=l(),W=i("img"),He=l(),R=i("p"),R.textContent=Jt,Be=l(),X=i("ul"),X.innerHTML=Ct,Ne=l(),V=i("p"),V.textContent=wt,ze=l(),m(Y.$$.fragment),Ge=l(),Q=i("p"),Q.textContent=xt,Pe=l(),F=i("ul"),F.innerHTML=bt,ke=l(),O=i("p"),O.innerHTML=It,Se=l(),Ze=i("hr"),We=l(),D=i("p"),D.textContent=ht,Re=l(),K=i("p"),K.textContent=Ut,Xe=l(),ee=i("p"),ee.innerHTML=qt,Ve=l(),m(te.$$.fragment),Ye=l(),le=i("p"),this.h()},l(e){const t=zt("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(a),se=s(e),ne=o(e,"P",{}),At(ne).forEach(a),ie=s(e),f(v.$$.fragment,e),oe=s(e),f(j.$$.fragment,e),re=s(e),p=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(p)!=="svelte-1u5dcys"&&(p.innerHTML=De),ue=s(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1g792u3"&&(J.innerHTML=Ke),pe=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-2bb1h1"&&(C.textContent=et),ce=s(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-gljhvq"&&(w.textContent=tt),de=s(e),f(x.$$.fragment,e),me=s(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1wivjva"&&(b.textContent=at),fe=s(e),I=o(e,"TABLE",{"data-svelte-h":!0}),r(I)!=="svelte-1vr8tjf"&&(I.innerHTML=nt),Me=s(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-134tcfx"&&(h.textContent=lt),ye=s(e),U=o(e,"TABLE",{"data-svelte-h":!0}),r(U)!=="svelte-1uwysts"&&(U.innerHTML=st),ge=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-vif9d1"&&(q.innerHTML=it),Te=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-5cern7"&&(A.textContent=ot),ve=s(e),f(E.$$.fragment,e),je=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-k29tct"&&($.innerHTML=rt),Je=s(e),_=o(e,"OL",{"data-svelte-h":!0}),r(_)!=="svelte-19p5l5m"&&(_.innerHTML=ut),Ce=s(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1axqync"&&(L.textContent=pt),we=s(e),c=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(c)!=="svelte-m7mpd0"&&(c.innerHTML=ct),xe=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-gvcxwr"&&(H.innerHTML=dt),be=s(e),d=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(d)!=="svelte-1tzrn4s"&&(d.innerHTML=mt),Ie=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-h0r7pb"&&(B.textContent=ft),he=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-m1aeyu"&&(N.textContent=Mt),Ue=s(e),f(z.$$.fragment,e),qe=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1gzno4y"&&(G.textContent=yt),Ae=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1o7cfwp"&&(P.textContent=gt),Ee=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1nvv5ro"&&(k.textContent=Tt),$e=s(e),f(S.$$.fragment,e),_e=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ttpln8"&&(Z.innerHTML=vt),Le=s(e),W=o(e,"IMG",{src:!0,alt:!0}),He=s(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-ahakaw"&&(R.textContent=Jt),Be=s(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1bukje0"&&(X.innerHTML=Ct),Ne=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-11c5kc2"&&(V.textContent=wt),ze=s(e),f(Y.$$.fragment,e),Ge=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-10jmk85"&&(Q.textContent=xt),Pe=s(e),F=o(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-1u48854"&&(F.innerHTML=bt),ke=s(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-k5ksx6"&&(O.innerHTML=It),Se=s(e),Ze=o(e,"HR",{}),We=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-u9xjsq"&&(D.textContent=ht),Re=s(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1xrixeh"&&(K.textContent=Ut),Xe=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-5z8s1y"&&(ee.innerHTML=qt),Ve=s(e),f(te.$$.fragment,e),Ye=s(e),le=o(e,"P",{}),At(le).forEach(a),this.h()},h(){ae(u,"name","hf:doc:metadata"),ae(u,"content",Zt),ae(p,"class","tip"),ae(c,"start","2"),ae(d,"start","3"),_t(W.src,jt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||ae(W,"src",jt),ae(W,"alt","Agentes de Código")},m(e,t){Gt(document.head,u),n(e,se,t),n(e,ne,t),n(e,ie,t),M(v,e,t),n(e,oe,t),M(j,e,t),n(e,re,t),n(e,p,t),n(e,ue,t),n(e,J,t),n(e,pe,t),n(e,C,t),n(e,ce,t),n(e,w,t),n(e,de,t),M(x,e,t),n(e,me,t),n(e,b,t),n(e,fe,t),n(e,I,t),n(e,Me,t),n(e,h,t),n(e,ye,t),n(e,U,t),n(e,ge,t),n(e,q,t),n(e,Te,t),n(e,A,t),n(e,ve,t),M(E,e,t),n(e,je,t),n(e,$,t),n(e,Je,t),n(e,_,t),n(e,Ce,t),n(e,L,t),n(e,we,t),n(e,c,t),n(e,xe,t),n(e,H,t),n(e,be,t),n(e,d,t),n(e,Ie,t),n(e,B,t),n(e,he,t),n(e,N,t),n(e,Ue,t),M(z,e,t),n(e,qe,t),n(e,G,t),n(e,Ae,t),n(e,P,t),n(e,Ee,t),n(e,k,t),n(e,$e,t),M(S,e,t),n(e,_e,t),n(e,Z,t),n(e,Le,t),n(e,W,t),n(e,He,t),n(e,R,t),n(e,Be,t),n(e,X,t),n(e,Ne,t),n(e,V,t),n(e,ze,t),M(Y,e,t),n(e,Ge,t),n(e,Q,t),n(e,Pe,t),n(e,F,t),n(e,ke,t),n(e,O,t),n(e,Se,t),n(e,Ze,t),n(e,We,t),n(e,D,t),n(e,Re,t),n(e,K,t),n(e,Xe,t),n(e,ee,t),n(e,Ve,t),M(te,e,t),n(e,Ye,t),n(e,le,t),Qe=!0},p:Lt,i(e){Qe||(y(v.$$.fragment,e),y(j.$$.fragment,e),y(x.$$.fragment,e),y(E.$$.fragment,e),y(z.$$.fragment,e),y(S.$$.fragment,e),y(Y.$$.fragment,e),y(te.$$.fragment,e),Qe=!0)},o(e){g(v.$$.fragment,e),g(j.$$.fragment,e),g(x.$$.fragment,e),g(E.$$.fragment,e),g(z.$$.fragment,e),g(S.$$.fragment,e),g(Y.$$.fragment,e),g(te.$$.fragment,e),Qe=!1},d(e){e&&(a(se),a(ne),a(ie),a(oe),a(re),a(p),a(ue),a(J),a(pe),a(C),a(ce),a(w),a(de),a(me),a(b),a(fe),a(I),a(Me),a(h),a(ye),a(U),a(ge),a(q),a(Te),a(A),a(ve),a(je),a($),a(Je),a(_),a(Ce),a(L),a(we),a(c),a(xe),a(H),a(be),a(d),a(Ie),a(B),a(he),a(N),a(Ue),a(qe),a(G),a(Ae),a(P),a(Ee),a(k),a($e),a(_e),a(Z),a(Le),a(W),a(He),a(R),a(Be),a(X),a(Ne),a(V),a(ze),a(Ge),a(Q),a(Pe),a(F),a(ke),a(O),a(Se),a(Ze),a(We),a(D),a(Re),a(K),a(Xe),a(ee),a(Ve),a(Ye),a(le)),a(u),T(v,e),T(j,e),T(x,e),T(E,e),T(z,e),T(S,e),T(Y,e),T(te,e)}}}const Zt='{"title":"Acciones: Permitiendo al Agente Interactuar con Su Entorno","local":"acciones-permitiendo-al-agente-interactuar-con-su-entorno","sections":[{"title":"Tipos de Acciones de Agentes","local":"tipos-de-acciones-de-agentes","sections":[],"depth":2},{"title":"El Enfoque de Detener y Analizar","local":"el-enfoque-de-detener-y-analizar","sections":[],"depth":2},{"title":"Agentes de Código","local":"agentes-de-código","sections":[],"depth":2}],"depth":1}';function Wt(Oe){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends Bt{constructor(u){super(),Nt(this,u,Wt,St,$t,{})}}export{Ot as component};
