import{s as mt,a as Ve,n as yt,o as ut}from"../chunks/scheduler.505acc25.js";import{S as ct,i as gt,e as i,s as a,c as r,h as Ut,a as p,d as s,b as n,f as dt,g as M,j as o,k as g,l as jt,m as l,n as d,t as m,o as y,p as u}from"../chunks/index.fbb49fb4.js";import{C as ft}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as O}from"../chunks/CodeBlock.2ead06c8.js";import{H as ee}from"../chunks/Heading.511e0027.js";import{E as ht}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function wt(He){let c,le,te,ae,j,ne,f,ie,h,Ne="Para crear aplicaciones con LangGraph necesitas conocer sus elementos principales. Exploremos los componentes fundamentales que conforman una aplicacion con LangGraph.",pe,U,Ae,oe,w,Fe="Una aplicación en LangGraph empieza con una  <strong>entrada</strong>, y dependiendo de la ejecución, el flujo puede ir a una función o a otra hasta que llega al FINAL.",re,T,Xe,Me,J,de,$,ze="<strong>Estado(State)</strong> es un concepto central en LangGraphh. Representa toda la información que fluye a traves de la aplicación.",me,C,ye,b,Ye="El estado es <strong>definido por el usuario</strong>, es por eso que los campos deben contruirse cuidadosamente para contener toda la información necesaria para el proceso de toma de decisiones!",ue,G,Pe="<p>💡 <strong>Tip:</strong> Piensa cuidadosamente que información necesita tu aplicación para rastrear entre pasos.</p>",ce,Z,ge,_,De="<strong>Nodos(Nodes)</strong> son funciones de python. Cada nodo:",Ue,I,Ke="<li>Toma el estado como entrada</li> <li>Realiza alguna operación</li> <li>Regresa actualizaciones al estado</li>",je,v,fe,k,Oe="Por ejemplo, los nodos pueden contener:",he,S,et="<li><strong>llamadas a LLM</strong>: Generar texto o tomar decisiones</li> <li><strong>llamadas a Tool</strong>: Interactuar con sistemas externos</li> <li><strong>Lógica Condicional</strong>: Determinar los siguientes pasos</li> <li><strong>Intervención Humana</strong>: Obtener datos del usuario</li>",we,x,tt="<p>💡 <strong>Info:</strong> Algunos nodos necesarios para el flujo completo como START y END existen directamente desde langGraph.</p>",Te,B,Je,E,st="<strong>Aristas (Edges)</strong> conectan nodos y definen los posibles caminos a través de tu grafo:",$e,R,Ce,L,lt="Las aristas(edges) pueden ser:",be,q,at="<li><strong>Directas (Direct)</strong>: Siempre van del nodo A al nodo B</li> <li><strong>Condicionales (Conditional)</strong>: Eligen el próximo nodo basándose en el estado actual</li>",Ge,W,Ze,Q,nt="El <strong>StateGraph</strong> es el contenedor que alberga todo el flujo de trabajo de tu agente:",_e,V,Ie,H,it="¡Que luego puede ser visualizado!",ve,N,ke,A,pt,Se,F,ot="Pero lo más importante, invocado::",xe,X,Be,z,rt="output :",Ee,Y,Re,P,Le,D,Mt="En la siguiente sección, pondremos estos conceptos en práctica construyendo nuestro primer grafo. Este grafo permite a Alfred recibir tus correos electrónicos, clasificarlos y elaborar una respuesta preliminar si son genuinos.",qe,K,We,se,Qe;return j=new ft({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new ee({props:{title:"Componentes de LangGraph",local:"componentes-de-langgraph",headingTag:"h1"}}),J=new ee({props:{title:"1. Estado(State)",local:"1-estadostate",headingTag:"h2"}}),C=new O({props:{code:"ZnJvbSUyMHR5cGluZ19leHRlbnNpb25zJTIwaW1wb3J0JTIwVHlwZWREaWN0JTBBJTBBY2xhc3MlMjBTdGF0ZShUeXBlZERpY3QpJTNBJTBBJTIwJTIwJTIwJTIwZ3JhcGhfc3RhdGUlM0ElMjBzdHI=",highlighted:`<span class="hljs-keyword">from</span> typing_extensions <span class="hljs-keyword">import</span> TypedDict

<span class="hljs-keyword">class</span> <span class="hljs-title class_">State</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    graph_state: <span class="hljs-built_in">str</span>`,wrap:!1}}),Z=new ee({props:{title:"2. Nodos(Nodes)",local:"2-nodosnodes",headingTag:"h2"}}),v=new O({props:{code:"ZGVmJTIwbm9kZV8xKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAxLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwWW8lMjBlc3RveSUyMiU3RCUwQSUwQWRlZiUyMG5vZGVfMihzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjItLS1Ob2RlJTIwMi0tLSUyMiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJncmFwaF9zdGF0ZSUyMiUzQSUyMHN0YXRlJTVCJ2dyYXBoX3N0YXRlJyU1RCUyMCUyQiUyMiUyMGZlbGl6ISUyMiU3RCUwQSUwQWRlZiUyMG5vZGVfMyhzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjItLS1Ob2RlJTIwMy0tLSUyMiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJncmFwaF9zdGF0ZSUyMiUzQSUyMHN0YXRlJTVCJ2dyYXBoX3N0YXRlJyU1RCUyMCUyQiUyMiUyMHRyaXN0ZSElMjIlN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_1</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 1---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; Yo estoy&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_2</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 2---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; feliz!&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_3</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 3---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; triste!&quot;</span>}`,wrap:!1}}),B=new ee({props:{title:"3. Aristas (Edges)",local:"3-aristas-edges",headingTag:"h2"}}),R=new O({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpdGVyYWwlMEElMEFkZWYlMjBkZWNpZGVfbW9vZChzdGF0ZSklMjAtJTNFJTIwTGl0ZXJhbCU1QiUyMm5vZGVfMiUyMiUyQyUyMCUyMm5vZGVfMyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEElMjBtZW51ZG8lMkMlMjB1c2FyZW1vcyUyMGVsJTIwZXN0YWRvJTIwcGFyYSUyMGRlY2lkaXIlMjBlbCUyMHByJUMzJUIzeGltbyUyMG5vZG8lMjBhJTIwdmlzaXRhciUwQSUyMCUyMCUyMCUyMHVzdWFyaW9fZW50cmFkYSUyMCUzRCUyMHN0YXRlJTVCJ2dyYXBoX3N0YXRlJyU1RCUyMCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEFxdSVDMyVBRCUyQyUyMGhhZ2Ftb3MlMjBzaW1wbGVtZW50ZSUyMHVuYSUyMGRpdmlzaSVDMyVCM24lMjA1MCUyMCUyRiUyMDUwJTIwZW50cmUlMjBsb3MlMjBub2RvcyUyMDIlMkMlMjAzJTBBJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZG9tKCklMjAlM0MlMjAwLjUlM0ElMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjA1MCUyNSUyMGRlbCUyMHRpZW1wbyUyQyUyMGRldm9sdmVtb3MlMjBlbCUyME5vZG8lMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybm9kZV8yJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwNTAlMjUlMjBkZWwlMjB0aWVtcG8lMkMlMjBkZXZvbHZlbW9zJTIwZWwlMjBOb2RvJTIwMyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCUyMm5vZGVfMyUyMlJldHJ5Q2xhdWRlJTIwY2FuJTIwbWFrZSUyMG1pc3Rha2VzLiUyMFBsZWFzZSUyMGRvdWJsZS1jaGVjayUyMHJlc3BvbnNlcy4=",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Literal</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decide_mood</span>(<span class="hljs-params">state</span>) -&gt; <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;node_2&quot;</span>, <span class="hljs-string">&quot;node_3&quot;</span>]:
    
    <span class="hljs-comment"># A menudo, usaremos el estado para decidir el próximo nodo a visitar</span>
    usuario_entrada = state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] 

    <span class="hljs-comment"># Aquí, hagamos simplemente una división 50 / 50 entre los nodos 2, 3</span>
    <span class="hljs-keyword">if</span> random.random() &lt; <span class="hljs-number">0.5</span>:
    
        <span class="hljs-comment"># 50% del tiempo, devolvemos el Nodo 2</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_2&quot;</span>

    <span class="hljs-comment"># 50% del tiempo, devolvemos el Nodo 3</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_3&quot;</span>RetryClaude can make mistakes. Please double-check responses.`,wrap:!1}}),W=new ee({props:{title:"4. StateGraph",local:"4-stategraph",headingTag:"h2"}}),V=new O({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEltYWdlJTJDJTIwZGlzcGxheSUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEElMEElMjMlMjBDb25zdHJ1aXIlMjBncmFmbyUwQWJ1aWxkZXIlMjAlM0QlMjBTdGF0ZUdyYXBoKFN0YXRlKSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIybm9kZV8xJTIyJTJDJTIwbm9kZV8xKSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIybm9kZV8yJTIyJTJDJTIwbm9kZV8yKSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIybm9kZV8zJTIyJTJDJTIwbm9kZV8zKSUwQSUwQSUyMyUyMEwlQzMlQjNnaWNhJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMm5vZGVfMSUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMjJub2RlXzElMjIlMkMlMjBkZWNpZGVfbW9vZCklMEFidWlsZGVyLmFkZF9lZGdlKCUyMm5vZGVfMiUyMiUyQyUyMEVORCklMEFidWlsZGVyLmFkZF9lZGdlKCUyMm5vZGVfMyUyMiUyQyUyMEVORCklMEElMEElMjMlMjBBJUMzJUIxYWRpciUwQWdyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END

<span class="hljs-comment"># Construir grafo</span>
builder = StateGraph(State)
builder.add_node(<span class="hljs-string">&quot;node_1&quot;</span>, node_1)
builder.add_node(<span class="hljs-string">&quot;node_2&quot;</span>, node_2)
builder.add_node(<span class="hljs-string">&quot;node_3&quot;</span>, node_3)

<span class="hljs-comment"># Lógica</span>
builder.add_edge(START, <span class="hljs-string">&quot;node_1&quot;</span>)
builder.add_conditional_edges(<span class="hljs-string">&quot;node_1&quot;</span>, decide_mood)
builder.add_edge(<span class="hljs-string">&quot;node_2&quot;</span>, END)
builder.add_edge(<span class="hljs-string">&quot;node_3&quot;</span>, END)

<span class="hljs-comment"># Añadir</span>
graph = builder.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),N=new O({props:{code:"JTIzJTIwVmVyJTBBZGlzcGxheShJbWFnZShncmFwaC5nZXRfZ3JhcGgoKS5kcmF3X21lcm1haWRfcG5nKCkpKQ==",highlighted:`<span class="hljs-comment"># Ver</span>
display(Image(graph.get_graph().draw_mermaid_png()))`,wrap:!1}}),X=new O({props:{code:"Z3JhcGguaW52b2tlKCU3QiUyMmdyYXBoX3N0YXRlJTIyJTIwJTNBJTIwJTIySG9sYSUyQyUyMHNveSUyMExhbmNlLiUyMiU3RCk=",highlighted:'graph.invoke({<span class="hljs-string">&quot;graph_state&quot;</span> : <span class="hljs-string">&quot;Hola, soy Lance.&quot;</span>})',wrap:!1}}),Y=new O({props:{code:"LS0tTm9kZSUyMDEtLS0lMEEtLS1Ob2RlJTIwMy0tLSUwQSU3QidncmFwaF9zdGF0ZSclM0ElMjAnSG9sYSUyQyUyMHNveSUyMExhbmNlLiUyMCVDMiVBMUVzdG95JTIwdHJpc3RlISclN0Q=",highlighted:`---<span class="hljs-keyword">Node</span> <span class="hljs-title">1---</span>
---<span class="hljs-keyword">Node</span> <span class="hljs-title">3---</span>
{&#x27;graph_state&#x27;: &#x27;Hola, soy Lance. ¡Estoy triste!&#x27;}`,wrap:!1}}),P=new ee({props:{title:"¿Qué sigue?",local:"qué-sigue",headingTag:"h2"}}),K=new ht({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/langgraph/building_blocks.mdx"}}),{c(){c=i("meta"),le=a(),te=i("p"),ae=a(),r(j.$$.fragment),ne=a(),r(f.$$.fragment),ie=a(),h=i("p"),h.textContent=Ne,pe=a(),U=i("img"),oe=a(),w=i("p"),w.innerHTML=Fe,re=a(),T=i("img"),Me=a(),r(J.$$.fragment),de=a(),$=i("p"),$.innerHTML=ze,me=a(),r(C.$$.fragment),ye=a(),b=i("p"),b.innerHTML=Ye,ue=a(),G=i("blockquote"),G.innerHTML=Pe,ce=a(),r(Z.$$.fragment),ge=a(),_=i("p"),_.innerHTML=De,Ue=a(),I=i("ul"),I.innerHTML=Ke,je=a(),r(v.$$.fragment),fe=a(),k=i("p"),k.textContent=Oe,he=a(),S=i("ul"),S.innerHTML=et,we=a(),x=i("blockquote"),x.innerHTML=tt,Te=a(),r(B.$$.fragment),Je=a(),E=i("p"),E.innerHTML=st,$e=a(),r(R.$$.fragment),Ce=a(),L=i("p"),L.textContent=lt,be=a(),q=i("ul"),q.innerHTML=at,Ge=a(),r(W.$$.fragment),Ze=a(),Q=i("p"),Q.innerHTML=nt,_e=a(),r(V.$$.fragment),Ie=a(),H=i("p"),H.textContent=it,ve=a(),r(N.$$.fragment),ke=a(),A=i("img"),Se=a(),F=i("p"),F.textContent=ot,xe=a(),r(X.$$.fragment),Be=a(),z=i("p"),z.textContent=rt,Ee=a(),r(Y.$$.fragment),Re=a(),r(P.$$.fragment),Le=a(),D=i("p"),D.textContent=Mt,qe=a(),r(K.$$.fragment),We=a(),se=i("p"),this.h()},l(e){const t=Ut("svelte-u9bgzb",document.head);c=p(t,"META",{name:!0,content:!0}),t.forEach(s),le=n(e),te=p(e,"P",{}),dt(te).forEach(s),ae=n(e),M(j.$$.fragment,e),ne=n(e),M(f.$$.fragment,e),ie=n(e),h=p(e,"P",{"data-svelte-h":!0}),o(h)!=="svelte-xuxj0i"&&(h.textContent=Ne),pe=n(e),U=p(e,"IMG",{src:!0,alt:!0,width:!0}),oe=n(e),w=p(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1afjpci"&&(w.innerHTML=Fe),re=n(e),T=p(e,"IMG",{src:!0,alt:!0}),Me=n(e),M(J.$$.fragment,e),de=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-q3lndj"&&($.innerHTML=ze),me=n(e),M(C.$$.fragment,e),ye=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1g66syz"&&(b.innerHTML=Ye),ue=n(e),G=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(G)!=="svelte-oxxog5"&&(G.innerHTML=Pe),ce=n(e),M(Z.$$.fragment,e),ge=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1qjv490"&&(_.innerHTML=De),Ue=n(e),I=p(e,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-16ifbd5"&&(I.innerHTML=Ke),je=n(e),M(v.$$.fragment,e),fe=n(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-11by32f"&&(k.textContent=Oe),he=n(e),S=p(e,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-6vioqc"&&(S.innerHTML=et),we=n(e),x=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(x)!=="svelte-ekx9b8"&&(x.innerHTML=tt),Te=n(e),M(B.$$.fragment,e),Je=n(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1gzev1z"&&(E.innerHTML=st),$e=n(e),M(R.$$.fragment,e),Ce=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-8q4fu3"&&(L.textContent=lt),be=n(e),q=p(e,"UL",{"data-svelte-h":!0}),o(q)!=="svelte-17pi5sb"&&(q.innerHTML=at),Ge=n(e),M(W.$$.fragment,e),Ze=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-qp6fob"&&(Q.innerHTML=nt),_e=n(e),M(V.$$.fragment,e),Ie=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-178ib0j"&&(H.textContent=it),ve=n(e),M(N.$$.fragment,e),ke=n(e),A=p(e,"IMG",{src:!0,alt:!0}),Se=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-c2jdle"&&(F.textContent=ot),xe=n(e),M(X.$$.fragment,e),Be=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1wdnc59"&&(z.textContent=rt),Ee=n(e),M(Y.$$.fragment,e),Re=n(e),M(P.$$.fragment,e),Le=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1tpo6os"&&(D.textContent=Mt),qe=n(e),M(K.$$.fragment,e),We=n(e),se=p(e,"P",{}),dt(se).forEach(s),this.h()},h(){g(c,"name","hf:doc:metadata"),g(c,"content",Tt),Ve(U.src,Ae="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Building_blocks.png")||g(U,"src",Ae),g(U,"alt","Building Blocks"),g(U,"width","70%"),Ve(T.src,Xe="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/application.png")||g(T,"src",Xe),g(T,"alt","Application"),Ve(A.src,pt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/basic_graph.jpeg")||g(A,"src",pt),g(A,"alt","Graph Visualization")},m(e,t){jt(document.head,c),l(e,le,t),l(e,te,t),l(e,ae,t),d(j,e,t),l(e,ne,t),d(f,e,t),l(e,ie,t),l(e,h,t),l(e,pe,t),l(e,U,t),l(e,oe,t),l(e,w,t),l(e,re,t),l(e,T,t),l(e,Me,t),d(J,e,t),l(e,de,t),l(e,$,t),l(e,me,t),d(C,e,t),l(e,ye,t),l(e,b,t),l(e,ue,t),l(e,G,t),l(e,ce,t),d(Z,e,t),l(e,ge,t),l(e,_,t),l(e,Ue,t),l(e,I,t),l(e,je,t),d(v,e,t),l(e,fe,t),l(e,k,t),l(e,he,t),l(e,S,t),l(e,we,t),l(e,x,t),l(e,Te,t),d(B,e,t),l(e,Je,t),l(e,E,t),l(e,$e,t),d(R,e,t),l(e,Ce,t),l(e,L,t),l(e,be,t),l(e,q,t),l(e,Ge,t),d(W,e,t),l(e,Ze,t),l(e,Q,t),l(e,_e,t),d(V,e,t),l(e,Ie,t),l(e,H,t),l(e,ve,t),d(N,e,t),l(e,ke,t),l(e,A,t),l(e,Se,t),l(e,F,t),l(e,xe,t),d(X,e,t),l(e,Be,t),l(e,z,t),l(e,Ee,t),d(Y,e,t),l(e,Re,t),d(P,e,t),l(e,Le,t),l(e,D,t),l(e,qe,t),d(K,e,t),l(e,We,t),l(e,se,t),Qe=!0},p:yt,i(e){Qe||(m(j.$$.fragment,e),m(f.$$.fragment,e),m(J.$$.fragment,e),m(C.$$.fragment,e),m(Z.$$.fragment,e),m(v.$$.fragment,e),m(B.$$.fragment,e),m(R.$$.fragment,e),m(W.$$.fragment,e),m(V.$$.fragment,e),m(N.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),Qe=!0)},o(e){y(j.$$.fragment,e),y(f.$$.fragment,e),y(J.$$.fragment,e),y(C.$$.fragment,e),y(Z.$$.fragment,e),y(v.$$.fragment,e),y(B.$$.fragment,e),y(R.$$.fragment,e),y(W.$$.fragment,e),y(V.$$.fragment,e),y(N.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),Qe=!1},d(e){e&&(s(le),s(te),s(ae),s(ne),s(ie),s(h),s(pe),s(U),s(oe),s(w),s(re),s(T),s(Me),s(de),s($),s(me),s(ye),s(b),s(ue),s(G),s(ce),s(ge),s(_),s(Ue),s(I),s(je),s(fe),s(k),s(he),s(S),s(we),s(x),s(Te),s(Je),s(E),s($e),s(Ce),s(L),s(be),s(q),s(Ge),s(Ze),s(Q),s(_e),s(Ie),s(H),s(ve),s(ke),s(A),s(Se),s(F),s(xe),s(Be),s(z),s(Ee),s(Re),s(Le),s(D),s(qe),s(We),s(se)),s(c),u(j,e),u(f,e),u(J,e),u(C,e),u(Z,e),u(v,e),u(B,e),u(R,e),u(W,e),u(V,e),u(N,e),u(X,e),u(Y,e),u(P,e),u(K,e)}}}const Tt='{"title":"Componentes de LangGraph","local":"componentes-de-langgraph","sections":[{"title":"1. Estado(State)","local":"1-estadostate","sections":[],"depth":2},{"title":"2. Nodos(Nodes)","local":"2-nodosnodes","sections":[],"depth":2},{"title":"3. Aristas (Edges)","local":"3-aristas-edges","sections":[],"depth":2},{"title":"4. StateGraph","local":"4-stategraph","sections":[],"depth":2},{"title":"¿Qué sigue?","local":"qué-sigue","sections":[],"depth":2}],"depth":1}';function Jt(He){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends ct{constructor(c){super(),gt(this,c,Jt,wt,mt,{})}}export{It as component};
