import{s as Vt,n as Xt,o as Bt}from"../chunks/scheduler.505acc25.js";import{S as St,i as Rt,e as o,s as n,c as d,q as It,h as Ht,a as i,d as t,b as s,f as Sa,g as c,j as r,r as $t,k as xe,l as y,m as l,n as m,t as u,o as p,p as b}from"../chunks/index.fbb49fb4.js";import{C as At}from"../chunks/CopyLLMTxtMenu.38c593c4.js";import{C as v}from"../chunks/CodeBlock.2ead06c8.js";import{H as Je}from"../chunks/Heading.511e0027.js";import{E as qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca82795.js";function kt(ka){let f,_e,Ge,Ee,Z,Ie,L,$e,w,Ya=`¿Recuerdas a Alfred, nuestro útil agente mayordomo de la Unidad 1?
Para ayudarnos de manera efectiva, Alfred necesita entender nuestras solicitudes y <strong>preparar, encontrar y usar información relevante para ayudar a completar tareas.</strong>
Aquí es donde entran los componentes de LlamaIndex.`,Ve,C,Na="Aunque LlamaIndex tiene muchos componentes, <strong>nos centraremos específicamente en el componente <code>QueryEngine</code></strong>. ¿Por qué? Porque se puede usar como una herramienta de Generación Aumentada por Recuperación (RAG) para un agente.",Xe,G,Qa=`Entonces, ¿qué es RAG? Los LLMs están entrenados en enormes cuerpos de datos para aprender conocimiento general. Sin embargo, pueden no estar entrenados en datos relevantes y actualizados.
RAG resuelve este problema encontrando y recuperando información relevante de tus datos y dándosela al LLM.`,Be,W,za='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/llama-index/rag.png" alt="RAG"/>',Se,_,Pa="Ahora, piensa en como funciona Alfred:",Re,E,Fa="<li>Le pides a Alfred que te ayude a planear una cena</li> <li>Alfred necesita revisar tu calendario, preferencias dietéticas y menús exitosos anteriores</li> <li>El <code>QueryEngine</code> ayuda a Alfred a encontrar esta información y usarla para planear la cena</li>",He,I,Ka=`Esto hace que el <code>QueryEngine</code> <strong>sea un componente clave para construir flujos de trabajo RAG agentic</strong> en LlamaIndex.
Así como Alfred necesita buscar en la información de tu hogar para ser útil, cualquier agente necesita una forma de encontrar y entender datos relevantes.
El <code>QueryEngine</code> proporciona exactamente esta capacidad.`,Ae,$,Da="Ahora, profundicemos un poco más en los componentes y veamos como puedes <strong>combinar componentes para crear un pipeline RAG.</strong>",qe,V,ke,g,Oa='<p>Puedes seguir el código en <a href="https://huggingface.co/agents-course/notebooks/blob/main/unit2/llama-index/components.ipynb" target="_blank">este notebook</a> que puedes ejecutar usando Google Colab.</p>',Ye,X,et="Hay cinco etapas clave dentro de RAG, que a su vez serán parte de la mayoría de las aplicaciones más grandes que construyas. Estas son:",Ne,B,at="<li><strong>Carga</strong>: esto se refiere a obtener tus datos desde donde residen — ya sean archivos de texto, PDFs, otro sitio web, una base de datos o una API — e incorporarlos a tu flujo de trabajo. LlamaHub proporciona cientos de integraciones para elegir.</li> <li><strong>Indexación</strong>: significa crear una estructura de datos que permita consultar la información. Para los LLMs, esto casi siempre significa crear embeddings vectoriales, que son representaciones numéricas del significado de los datos. La indexación también puede referirse a numerosas estrategias de metadatos para facilitar la búsqueda precisa de datos contextualmente relevantes basados en propiedades.</li> <li><strong>Almacenamiento</strong>: una vez que tus datos están indexados, querrás almacenar tu índice, así como otros metadatos, para evitar tener que volver a indexarlos.</li> <li><strong>Consulta</strong>: para cualquier estrategia de indexación hay muchas formas en que puedes utilizar LLMs y estructuras de datos de LlamaIndex para consultar, incluyendo subconsultas, consultas de múltiples pasos y estrategias híbridas.</li> <li><strong>Evaluación</strong>: un paso crítico en cualquier flujo es comprobar qué tan efectivo es en relación con otras estrategias, o cuando realizas cambios. La evaluación proporciona medidas objetivas de cuán precisas, fieles y rápidas son tus respuestas a las consultas.</li>",Qe,S,tt="A continuación, veamos cómo podemos reproducir estas etapas usando componentes.",ze,R,Pe,H,lt=`Como se mencionó anteriormente, LlamaIndex puede trabajar sobre tus propios datos, sin embargo, <strong>antes de acceder a los datos, necesitamos cargarlos.</strong>
Hay tres formas principales de cargar datos en LlamaIndex:`,Fe,A,nt="<li><code>SimpleDirectoryReader</code>: Un cargador integrado para varios tipos de archivos desde un directorio local.</li> <li><code>LlamaParse</code>: LlamaParse, la herramienta oficial de LlamaIndex para el análisis de PDFs, disponible como API gestionada.</li> <li><code>LlamaHub</code>: Un registro de cientos de bibliotecas de carga de datos para ingerir datos desde cualquier fuente.</li>",Ke,h,st='<p>Familiarízate con los cargadores de <a href="https://docs.llamaindex.ai/en/stable/module_guides/loading/connector/">LlamaHub</a> y el analizador <a href="https://github.com/run-llama/llama_cloud_services/blob/main/parse.md">LlamaParse</a> para fuentes de datos más complejas.</p>',De,q,ot=`<strong>La forma más sencilla de cargar datos es con <code>SimpleDirectoryReader</code>.</strong>
Este componente versátil puede cargar varios tipos de archivos desde una carpeta y convertirlos en objetos <code>Document</code> con los que LlamaIndex puede trabajar.
Veamos cómo podemos usar <code>SimpleDirectoryReader</code> para cargar datos desde una carpeta.`,Oe,k,ea,Y,it=`Después de cargar nuestros documentos, necesitamos dividirlos en piezas más pequeñas llamadas objetos <code>Node</code>.
Un <code>Node</code> es simplemente un fragmento de texto del documento original que es más fácil de manejar para la IA, mientras que mantiene referencias al objeto <code>Document</code> original.`,aa,N,rt="El <code>IngestionPipeline</code> nos ayuda a crear estos nodos a través de dos transformaciones clave.",ta,Q,dt="<li><code>SentenceSplitter</code> descompone los documentos en fragmentos manejables dividiéndolos en los límites naturales de las oraciones.</li> <li><code>HuggingFaceInferenceAPIEmbedding</code> convierte cada fragmento en embeddings numéricos - representaciones vectoriales que capturan el significado semántico de una manera que la IA puede procesar eficientemente.</li>",la,z,ct="Este proceso nos ayuda a organizar nuestros documentos de una manera que es más útil para la búsqueda y el análisis.",na,P,sa,F,oa,K,mt="Después de crear nuestros objetos <code>Node</code>, necesitamos indexarlos para hacerlos buscables, pero antes de poder hacerlo, necesitamos un lugar para almacenar nuestros datos.",ia,D,ut=`Como estamos usando un pipeline de ingesta, podemos adjuntar directamente un almacén vectorial al pipeline para poblarlo.
En este caso, usaremos <code>Chroma</code> para almacenar nuestros documentos.`,ra,T,Ze,pt="Instalar ChromaDB",Ra,O,da,ee,ca,j,bt='<p>Una visión general de los diferentes almacenes vectoriales se puede encontrar en la <a href="https://docs.llamaindex.ai/en/stable/module_guides/storing/vector_stores/">documentación de LlamaIndex</a>.</p>',ma,ae,Mt=`Aquí es donde entran los embeddings vectoriales - al incorporar tanto la consulta como los nodos en el mismo espacio vectorial, podemos encontrar coincidencias relevantes.
El <code>VectorStoreIndex</code> se encarga de esto por nosotros, utilizando el mismo modelo de embedding que usamos durante la ingesta para garantizar la consistencia.`,ua,te,ft="Veamos cómo crear este índice a partir de nuestro almacén vectorial y embeddings:",pa,le,ba,ne,yt="Toda la información se persiste automáticamente dentro del objeto <code>ChromaVectorStore</code> y la ruta del directorio proporcionado.",Ma,se,vt="¡Genial! Ahora que podemos guardar y cargar nuestro índice fácilmente, exploremos cómo consultarlo de diferentes maneras.",fa,oe,ya,ie,gt="Antes de poder consultar nuestro índice, necesitamos convertirlo a una interfaz de consulta. Las opciones de conversión más comunes son:",va,re,ht="<li><code>as_retriever</code>: Para recuperación básica de documentos, devolviendo una lista de objetos <code>NodeWithScore</code> con puntuaciones de similitud</li> <li><code>as_query_engine</code>: Para interacciones de pregunta-respuesta simples, devolviendo una respuesta escrita</li> <li><code>as_chat_engine</code>: Para interacciones conversacionales que mantienen la memoria a través de múltiples mensajes, devolviendo una respuesta escrita utilizando el historial de chat y el contexto indexado</li>",ga,de,Tt=`Nos centraremos en el motor de consulta ya que es más común para interacciones tipo agente.
También pasamos un LLM al motor de consulta para usarlo en la respuesta.`,ha,ce,Ta,me,ja,ue,jt=`Bajo el capó, el motor de consulta no solo usa el LLM para responder a la pregunta, sino que también utiliza un <code>ResponseSynthesizer</code> como estrategia para procesar la respuesta.
Una vez más, esto es completamente personalizable, pero hay tres estrategias principales que funcionan bien de forma predeterminada:`,Ua,pe,Ut="<li><code>refine</code>: crear y refinar una respuesta recorriendo secuencialmente cada fragmento de texto recuperado. Esto hace una llamada LLM separada por cada Node/fragmento recuperado.</li> <li><code>compact</code> (predeterminado): similar a refinar pero concatenando los fragmentos de antemano, resultando en menos llamadas LLM.</li> <li><code>tree_summarize</code>: crear una respuesta detallada recorriendo cada fragmento de texto recuperado y creando una estructura de árbol de la respuesta.</li>",xa,U,xt='<p>Toma control detallado de tus flujos de consulta con la <a href="https://docs.llamaindex.ai/en/stable/module_guides/deploying/query_engine/usage_pattern/#low-level-composition-api">API de composición de bajo nivel</a>. Esta API te permite personalizar y ajustar cada paso del proceso de consulta para que coincida con tus necesidades exactas, lo que también se combina muy bien con <a href="https://docs.llamaindex.ai/en/stable/module_guides/workflow/">Flujos de trabajo</a></p>',Ja,be,Jt="El modelo de lenguaje no siempre funcionará de manera predecible, por lo que no podemos estar seguros de que la respuesta que obtenemos sea siempre correcta. Podemos lidiar con esto <strong>evaluando la calidad de la respuesta</strong>.",Za,Me,La,fe,Zt=`LlamaIndex proporciona <strong>herramientas de evaluación integradas para evaluar la calidad de la respuesta.</strong>
Estos evaluadores aprovechan los LLMs para analizar respuestas a través de diferentes dimensiones.
Veamos los tres evaluadores principales disponibles:`,wa,ye,Lt="<li><code>FaithfulnessEvaluator</code>: Evalúa la fidelidad de la respuesta comprobando si está respaldada por el contexto.</li> <li><code>AnswerRelevancyEvaluator</code>: Evalúa la relevancia de la respuesta comprobando si es relevante para la pregunta.</li> <li><code>CorrectnessEvaluator</code>: Evalúa la corrección de la respuesta comprobando si es correcta.</li>",Ca,ve,Ga,ge,wt=`Incluso sin evaluación directa, podemos <strong>obtener información sobre cómo está funcionando nuestro sistema a través de la observabilidad.</strong>
Esto es especialmente útil cuando estamos construyendo flujos de trabajo más complejos y queremos entender cómo está funcionando cada componente.`,Wa,M,Le,Ct="Instalar LlamaTrace",Ha,he,Aa,we,Gt="Además, necesitamos establecer la variable de entorno <code>PHOENIX_API_KEY</code> con nuestra clave API de LlamaTrace. Podemos obtenerla:",qa,Ce,Wt='<li>Creando una cuenta en <a href="https://llamatrace.com/login" rel="nofollow">LlamaTrace</a></li> <li>Generando una clave API en la configuración de tu cuenta</li> <li>Usando la clave API en el código siguiente para habilitar el seguimiento</li>',_a,Te,Ea,x,_t='<p>¿Quieres aprender más sobre los componentes y cómo usarlos? Continúa tu viaje con las <a href="https://docs.llamaindex.ai/en/stable/module_guides/">Guías de Componentes</a> o la <a href="https://docs.llamaindex.ai/en/stable/understanding/rag/">Guía sobre RAG</a>.</p>',Ia,je,Et="Hemos visto cómo usar componentes para crear un <code>QueryEngine</code>. Ahora, ¡veamos cómo <strong>usar el <code>QueryEngine</code> como una herramienta para un agente!</strong>",$a,Ue,Va,We,Xa;return Z=new At({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),L=new Je({props:{title:"¿Qué son los componentes en LlamaIndex?",local:"qué-son-los-componentes-en-llamaindex",headingTag:"h1"}}),V=new Je({props:{title:"Creando un pipeline RAG usando componentes",local:"creando-un-pipeline-rag-usando-componentes",headingTag:"h2"}}),R=new Je({props:{title:"Carga y embedding de documentos",local:"carga-y-embedding-de-documentos",headingTag:"h3"}}),k=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIlMEElMEFyZWFkZXIlMjAlM0QlMjBTaW1wbGVEaXJlY3RvcnlSZWFkZXIoaW5wdXRfZGlyJTNEJTIycGF0aCUyRnRvJTJGZGlyZWN0b3J5JTIyKSUwQWRvY3VtZW50cyUyMCUzRCUyMHJlYWRlci5sb2FkX2RhdGEoKQ==",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> SimpleDirectoryReader

reader = SimpleDirectoryReader(input_dir=<span class="hljs-string">&quot;path/to/directory&quot;</span>)
documents = reader.load_data()`,wrap:!1}}),P=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBEb2N1bWVudCUwQWZyb20lMjBsbGFtYV9pbmRleC5lbWJlZGRpbmdzLmh1Z2dpbmdmYWNlX2FwaSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJRW1iZWRkaW5nJTBBZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUubm9kZV9wYXJzZXIlMjBpbXBvcnQlMjBTZW50ZW5jZVNwbGl0dGVyJTBBZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuaW5nZXN0aW9uJTIwaW1wb3J0JTIwSW5nZXN0aW9uUGlwZWxpbmUlMEElMEElMjMlMjBjcmVhciUyMGVsJTIwcGlwZWxpbmUlMjBjb24lMjB0cmFuc2Zvcm1hY2lvbmVzJTBBcGlwZWxpbmUlMjAlM0QlMjBJbmdlc3Rpb25QaXBlbGluZSglMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1hdGlvbnMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZW50ZW5jZVNwbGl0dGVyKGNodW5rX292ZXJsYXAlM0QwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQW5vZGVzJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZS5hcnVuKGRvY3VtZW50cyUzRCU1QkRvY3VtZW50LmV4YW1wbGUoKSU1RCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPIEmbedding
<span class="hljs-keyword">from</span> llama_index.core.node_parser <span class="hljs-keyword">import</span> SentenceSplitter
<span class="hljs-keyword">from</span> llama_index.core.ingestion <span class="hljs-keyword">import</span> IngestionPipeline

<span class="hljs-comment"># crear el pipeline con transformaciones</span>
pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceInferenceAPIEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ]
)

nodes = <span class="hljs-keyword">await</span> pipeline.arun(documents=[Document.example()])`,wrap:!1}}),F=new Je({props:{title:"Almacenamiento e indexación de documentos",local:"almacenamiento-e-indexación-de-documentos",headingTag:"h3"}}),O=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxsYW1hLWluZGV4LXZlY3Rvci1zdG9yZXMtY2hyb21h",highlighted:"pip install llama-index-vector-stores-chroma",wrap:!1}}),ee=new v({props:{code:"aW1wb3J0JTIwY2hyb21hZGIlMEFmcm9tJTIwbGxhbWFfaW5kZXgudmVjdG9yX3N0b3Jlcy5jaHJvbWElMjBpbXBvcnQlMjBDaHJvbWFWZWN0b3JTdG9yZSUwQSUwQWRiJTIwJTNEJTIwY2hyb21hZGIuUGVyc2lzdGVudENsaWVudChwYXRoJTNEJTIyLiUyRmFsZnJlZF9jaHJvbWFfZGIlMjIpJTBBY2hyb21hX2NvbGxlY3Rpb24lMjAlM0QlMjBkYi5nZXRfb3JfY3JlYXRlX2NvbGxlY3Rpb24oJTIyYWxmcmVkJTIyKSUwQXZlY3Rvcl9zdG9yZSUyMCUzRCUyMENocm9tYVZlY3RvclN0b3JlKGNocm9tYV9jb2xsZWN0aW9uJTNEY2hyb21hX2NvbGxlY3Rpb24pJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBJbmdlc3Rpb25QaXBlbGluZSglMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1hdGlvbnMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZW50ZW5jZVNwbGl0dGVyKGNodW5rX3NpemUlM0QyNSUyQyUyMGNodW5rX292ZXJsYXAlM0QwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwdmVjdG9yX3N0b3JlJTNEdmVjdG9yX3N0b3JlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> chromadb
<span class="hljs-keyword">from</span> llama_index.vector_stores.chroma <span class="hljs-keyword">import</span> ChromaVectorStore

db = chromadb.PersistentClient(path=<span class="hljs-string">&quot;./alfred_chroma_db&quot;</span>)
chroma_collection = db.get_or_create_collection(<span class="hljs-string">&quot;alfred&quot;</span>)
vector_store = ChromaVectorStore(chroma_collection=chroma_collection)

pipeline = IngestionPipeline(
    transformations=[
        SentenceSplitter(chunk_size=<span class="hljs-number">25</span>, chunk_overlap=<span class="hljs-number">0</span>),
        HuggingFaceInferenceAPIEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>),
    ],
    vector_store=vector_store,
)`,wrap:!1}}),le=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBWZWN0b3JTdG9yZUluZGV4JTBBZnJvbSUyMGxsYW1hX2luZGV4LmVtYmVkZGluZ3MuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUElFbWJlZGRpbmclMEElMEFlbWJlZF9tb2RlbCUyMCUzRCUyMEh1Z2dpbmdGYWNlSW5mZXJlbmNlQVBJRW1iZWRkaW5nKG1vZGVsX25hbWUlM0QlMjJCQUFJJTJGYmdlLXNtYWxsLWVuLXYxLjUlMjIpJTBBaW5kZXglMjAlM0QlMjBWZWN0b3JTdG9yZUluZGV4LmZyb21fdmVjdG9yX3N0b3JlKHZlY3Rvcl9zdG9yZSUyQyUyMGVtYmVkX21vZGVsJTNEZW1iZWRfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> VectorStoreIndex
<span class="hljs-keyword">from</span> llama_index.embeddings.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPIEmbedding

embed_model = HuggingFaceInferenceAPIEmbedding(model_name=<span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>)
index = VectorStoreIndex.from_vector_store(vector_store, embed_model=embed_model)`,wrap:!1}}),oe=new Je({props:{title:"Consultando un VectorStoreIndex con prompts y LLMs",local:"consultando-un-vectorstoreindex-con-prompts-y-llms",headingTag:"h3"}}),ce=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2VfYXBpJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEklMEElMEFsbG0lMjAlM0QlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSShtb2RlbF9uYW1lJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMGluZGV4LmFzX3F1ZXJ5X2VuZ2luZSglMEElMjAlMjAlMjAlMjBsbG0lM0RsbG0lMkMlMEElMjAlMjAlMjAlMjByZXNwb25zZV9tb2RlJTNEJTIydHJlZV9zdW1tYXJpemUlMjIlMkMlMEEpJTBBcXVlcnlfZW5naW5lLnF1ZXJ5KCUyMiVDMiVCRkN1JUMzJUExbCUyMGVzJTIwZWwlMjBzaWduaWZpY2FkbyUyMGRlJTIwbGElMjB2aWRhJTNGJTIyKSUwQSUyMyUyMEVsJTIwc2lnbmlmaWNhZG8lMjBkZSUyMGxhJTIwdmlkYSUyMGVzJTIwNDI=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface_api <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
query_engine = index.as_query_engine(
    llm=llm,
    response_mode=<span class="hljs-string">&quot;tree_summarize&quot;</span>,
)
query_engine.query(<span class="hljs-string">&quot;¿Cuál es el significado de la vida?&quot;</span>)
<span class="hljs-comment"># El significado de la vida es 42</span>`,wrap:!1}}),me=new Je({props:{title:"Procesamiento de Respuestas",local:"procesamiento-de-respuestas",headingTag:"h3"}}),Me=new Je({props:{title:"Evaluación y observabilidad",local:"evaluación-y-observabilidad",headingTag:"h3"}}),ve=new v({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUuZXZhbHVhdGlvbiUyMGltcG9ydCUyMEZhaXRoZnVsbmVzc0V2YWx1YXRvciUwQSUwQXF1ZXJ5X2VuZ2luZSUyMCUzRCUyMCUyMyUyMGRlJTIwbGElMjBzZWNjaSVDMyVCM24lMjBhbnRlcmlvciUwQWxsbSUyMCUzRCUyMCUyMyUyMGRlJTIwbGElMjBzZWNjaSVDMyVCM24lMjBhbnRlcmlvciUwQSUwQSUyMyUyMGNvbnN1bHRhciUyMCVDMyVBRG5kaWNlJTBBZXZhbHVhdG9yJTIwJTNEJTIwRmFpdGhmdWxuZXNzRXZhbHVhdG9yKGxsbSUzRGxsbSklMEFyZXNwb25zZSUyMCUzRCUyMHF1ZXJ5X2VuZ2luZS5xdWVyeSglMEElMjAlMjAlMjAlMjAlMjIlQzIlQkZRdSVDMyVBOSUyMGJhdGFsbGFzJTIwdHV2aWVyb24lMjBsdWdhciUyMGVuJTIwbGElMjBjaXVkYWQlMjBkZSUyME51ZXZhJTIwWW9yayUyMGR1cmFudGUlMjBsYSUyMFJldm9sdWNpJUMzJUIzbiUyMEFtZXJpY2FuYSUzRiUyMiUwQSklMEFldmFsX3Jlc3VsdCUyMCUzRCUyMGV2YWx1YXRvci5ldmFsdWF0ZV9yZXNwb25zZShyZXNwb25zZSUzRHJlc3BvbnNlKSUwQWV2YWxfcmVzdWx0LnBhc3Npbmc=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core.evaluation <span class="hljs-keyword">import</span> FaithfulnessEvaluator

query_engine = <span class="hljs-comment"># de la sección anterior</span>
llm = <span class="hljs-comment"># de la sección anterior</span>

<span class="hljs-comment"># consultar índice</span>
evaluator = FaithfulnessEvaluator(llm=llm)
response = query_engine.query(
    <span class="hljs-string">&quot;¿Qué batallas tuvieron lugar en la ciudad de Nueva York durante la Revolución Americana?&quot;</span>
)
eval_result = evaluator.evaluate_response(response=response)
eval_result.passing`,wrap:!1}}),he=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwbGxhbWEtaW5kZXgtY2FsbGJhY2tzLWFyaXplLXBob2VuaXg=",highlighted:"pip install -U llama-index-callbacks-arize-phoenix",wrap:!1}}),Te=new v({props:{code:"aW1wb3J0JTIwbGxhbWFfaW5kZXglMEFpbXBvcnQlMjBvcyUwQSUwQVBIT0VOSVhfQVBJX0tFWSUyMCUzRCUyMCUyMiUzQ1BIT0VOSVhfQVBJX0tFWSUzRSUyMiUwQW9zLmVudmlyb24lNUIlMjJPVEVMX0VYUE9SVEVSX09UTFBfSEVBREVSUyUyMiU1RCUyMCUzRCUyMGYlMjJhcGlfa2V5JTNEJTdCUEhPRU5JWF9BUElfS0VZJTdEJTIyJTBBbGxhbWFfaW5kZXguY29yZS5zZXRfZ2xvYmFsX2hhbmRsZXIoJTBBJTIwJTIwJTIwJTIwJTIyYXJpemVfcGhvZW5peCUyMiUyQyUwQSUyMCUyMCUyMCUyMGVuZHBvaW50JTNEJTIyaHR0cHMlM0ElMkYlMkZsbGFtYXRyYWNlLmNvbSUyRnYxJTJGdHJhY2VzJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> llama_index
<span class="hljs-keyword">import</span> os

PHOENIX_API_KEY = <span class="hljs-string">&quot;&lt;PHOENIX_API_KEY&gt;&quot;</span>
os.environ[<span class="hljs-string">&quot;OTEL_EXPORTER_OTLP_HEADERS&quot;</span>] = <span class="hljs-string">f&quot;api_key=<span class="hljs-subst">{PHOENIX_API_KEY}</span>&quot;</span>
llama_index.core.set_global_handler(
    <span class="hljs-string">&quot;arize_phoenix&quot;</span>,
    endpoint=<span class="hljs-string">&quot;https://llamatrace.com/v1/traces&quot;</span>
)`,wrap:!1}}),Ue=new qt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit2/llama-index/components.mdx"}}),{c(){f=o("meta"),_e=n(),Ge=o("p"),Ee=n(),d(Z.$$.fragment),Ie=n(),d(L.$$.fragment),$e=n(),w=o("p"),w.innerHTML=Ya,Ve=n(),C=o("p"),C.innerHTML=Na,Xe=n(),G=o("p"),G.textContent=Qa,Be=n(),W=o("p"),W.innerHTML=za,Se=n(),_=o("p"),_.textContent=Pa,Re=n(),E=o("ol"),E.innerHTML=Fa,He=n(),I=o("p"),I.innerHTML=Ka,Ae=n(),$=o("p"),$.innerHTML=Da,qe=n(),d(V.$$.fragment),ke=n(),g=o("blockquote"),g.innerHTML=Oa,Ye=n(),X=o("p"),X.textContent=et,Ne=n(),B=o("ol"),B.innerHTML=at,Qe=n(),S=o("p"),S.textContent=tt,ze=n(),d(R.$$.fragment),Pe=n(),H=o("p"),H.innerHTML=lt,Fe=n(),A=o("ol"),A.innerHTML=nt,Ke=n(),h=o("blockquote"),h.innerHTML=st,De=n(),q=o("p"),q.innerHTML=ot,Oe=n(),d(k.$$.fragment),ea=n(),Y=o("p"),Y.innerHTML=it,aa=n(),N=o("p"),N.innerHTML=rt,ta=n(),Q=o("ol"),Q.innerHTML=dt,la=n(),z=o("p"),z.textContent=ct,na=n(),d(P.$$.fragment),sa=n(),d(F.$$.fragment),oa=n(),K=o("p"),K.innerHTML=mt,ia=n(),D=o("p"),D.innerHTML=ut,ra=n(),T=o("details"),Ze=o("summary"),Ze.textContent=pt,Ra=It(`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el almacén vectorial ChromaDB con el siguiente comando:

	`),d(O.$$.fragment),da=n(),d(ee.$$.fragment),ca=n(),j=o("blockquote"),j.innerHTML=bt,ma=n(),ae=o("p"),ae.innerHTML=Mt,ua=n(),te=o("p"),te.textContent=ft,pa=n(),d(le.$$.fragment),ba=n(),ne=o("p"),ne.innerHTML=yt,Ma=n(),se=o("p"),se.textContent=vt,fa=n(),d(oe.$$.fragment),ya=n(),ie=o("p"),ie.textContent=gt,va=n(),re=o("ul"),re.innerHTML=ht,ga=n(),de=o("p"),de.textContent=Tt,ha=n(),d(ce.$$.fragment),Ta=n(),d(me.$$.fragment),ja=n(),ue=o("p"),ue.innerHTML=jt,Ua=n(),pe=o("ul"),pe.innerHTML=Ut,xa=n(),U=o("blockquote"),U.innerHTML=xt,Ja=n(),be=o("p"),be.innerHTML=Jt,Za=n(),d(Me.$$.fragment),La=n(),fe=o("p"),fe.innerHTML=Zt,wa=n(),ye=o("ul"),ye.innerHTML=Lt,Ca=n(),d(ve.$$.fragment),Ga=n(),ge=o("p"),ge.innerHTML=wt,Wa=n(),M=o("details"),Le=o("summary"),Le.textContent=Ct,Ha=It(`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el callback LlamaTrace de Arize Phoenix con el siguiente comando:

	`),d(he.$$.fragment),Aa=n(),we=o("p"),we.innerHTML=Gt,qa=n(),Ce=o("ul"),Ce.innerHTML=Wt,_a=n(),d(Te.$$.fragment),Ea=n(),x=o("blockquote"),x.innerHTML=_t,Ia=n(),je=o("p"),je.innerHTML=Et,$a=n(),d(Ue.$$.fragment),Va=n(),We=o("p"),this.h()},l(e){const a=Ht("svelte-u9bgzb",document.head);f=i(a,"META",{name:!0,content:!0}),a.forEach(t),_e=s(e),Ge=i(e,"P",{}),Sa(Ge).forEach(t),Ee=s(e),c(Z.$$.fragment,e),Ie=s(e),c(L.$$.fragment,e),$e=s(e),w=i(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-pm99e2"&&(w.innerHTML=Ya),Ve=s(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-13gpelo"&&(C.innerHTML=Na),Xe=s(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-19mpk4z"&&(G.textContent=Qa),Be=s(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-kysd50"&&(W.innerHTML=za),Se=s(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1xsxtoj"&&(_.textContent=Pa),Re=s(e),E=i(e,"OL",{"data-svelte-h":!0}),r(E)!=="svelte-1mjeq7y"&&(E.innerHTML=Fa),He=s(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-suuz1p"&&(I.innerHTML=Ka),Ae=s(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-11egg01"&&($.innerHTML=Da),qe=s(e),c(V.$$.fragment,e),ke=s(e),g=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-baqnu3"&&(g.innerHTML=Oa),Ye=s(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1jzhuw7"&&(X.textContent=et),Ne=s(e),B=i(e,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-42twja"&&(B.innerHTML=at),Qe=s(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1q05m75"&&(S.textContent=tt),ze=s(e),c(R.$$.fragment,e),Pe=s(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-ltse76"&&(H.innerHTML=lt),Fe=s(e),A=i(e,"OL",{"data-svelte-h":!0}),r(A)!=="svelte-hgvwyx"&&(A.innerHTML=nt),Ke=s(e),h=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-ohpmeu"&&(h.innerHTML=st),De=s(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-g44q18"&&(q.innerHTML=ot),Oe=s(e),c(k.$$.fragment,e),ea=s(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1dr39ef"&&(Y.innerHTML=it),aa=s(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1sz6pbb"&&(N.innerHTML=rt),ta=s(e),Q=i(e,"OL",{"data-svelte-h":!0}),r(Q)!=="svelte-s3d25b"&&(Q.innerHTML=dt),la=s(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-6evtuq"&&(z.textContent=ct),na=s(e),c(P.$$.fragment,e),sa=s(e),c(F.$$.fragment,e),oa=s(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-jayxlx"&&(K.innerHTML=mt),ia=s(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1n0ff7"&&(D.innerHTML=ut),ra=s(e),T=i(e,"DETAILS",{});var Ba=Sa(T);Ze=i(Ba,"SUMMARY",{"data-svelte-h":!0}),r(Ze)!=="svelte-1j6ze5i"&&(Ze.textContent=pt),Ra=$t(Ba,`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el almacén vectorial ChromaDB con el siguiente comando:

	`),c(O.$$.fragment,Ba),Ba.forEach(t),da=s(e),c(ee.$$.fragment,e),ca=s(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-12qoguh"&&(j.innerHTML=bt),ma=s(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1udl3w2"&&(ae.innerHTML=Mt),ua=s(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-dk0wjq"&&(te.textContent=ft),pa=s(e),c(le.$$.fragment,e),ba=s(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-k2u2nl"&&(ne.innerHTML=yt),Ma=s(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1vfh4sr"&&(se.textContent=vt),fa=s(e),c(oe.$$.fragment,e),ya=s(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-19hd66j"&&(ie.textContent=gt),va=s(e),re=i(e,"UL",{"data-svelte-h":!0}),r(re)!=="svelte-10edu3t"&&(re.innerHTML=ht),ga=s(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1f9ozoe"&&(de.textContent=Tt),ha=s(e),c(ce.$$.fragment,e),Ta=s(e),c(me.$$.fragment,e),ja=s(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1w6g8k2"&&(ue.innerHTML=jt),Ua=s(e),pe=i(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-1m28xcd"&&(pe.innerHTML=Ut),xa=s(e),U=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-s19g0w"&&(U.innerHTML=xt),Ja=s(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1bsvcjs"&&(be.innerHTML=Jt),Za=s(e),c(Me.$$.fragment,e),La=s(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-13q421x"&&(fe.innerHTML=Zt),wa=s(e),ye=i(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-1latvry"&&(ye.innerHTML=Lt),Ca=s(e),c(ve.$$.fragment,e),Ga=s(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-ktqj9w"&&(ge.innerHTML=wt),Wa=s(e),M=i(e,"DETAILS",{});var J=Sa(M);Le=i(J,"SUMMARY",{"data-svelte-h":!0}),r(Le)!=="svelte-1590nuk"&&(Le.textContent=Ct),Ha=$t(J,`
Como se introdujo en la [sección sobre LlamaHub](llama-hub), podemos instalar el callback LlamaTrace de Arize Phoenix con el siguiente comando:

	`),c(he.$$.fragment,J),Aa=s(J),we=i(J,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1of2p3f"&&(we.innerHTML=Gt),qa=s(J),Ce=i(J,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-1s72lw8"&&(Ce.innerHTML=Wt),J.forEach(t),_a=s(e),c(Te.$$.fragment,e),Ea=s(e),x=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-1vq8zru"&&(x.innerHTML=_t),Ia=s(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1ylul7b"&&(je.innerHTML=Et),$a=s(e),c(Ue.$$.fragment,e),Va=s(e),We=i(e,"P",{}),Sa(We).forEach(t),this.h()},h(){xe(f,"name","hf:doc:metadata"),xe(f,"content",Yt),xe(g,"class","tip"),xe(h,"class","tip"),xe(j,"class","tip"),xe(U,"class","tip"),xe(x,"class","tip")},m(e,a){y(document.head,f),l(e,_e,a),l(e,Ge,a),l(e,Ee,a),m(Z,e,a),l(e,Ie,a),m(L,e,a),l(e,$e,a),l(e,w,a),l(e,Ve,a),l(e,C,a),l(e,Xe,a),l(e,G,a),l(e,Be,a),l(e,W,a),l(e,Se,a),l(e,_,a),l(e,Re,a),l(e,E,a),l(e,He,a),l(e,I,a),l(e,Ae,a),l(e,$,a),l(e,qe,a),m(V,e,a),l(e,ke,a),l(e,g,a),l(e,Ye,a),l(e,X,a),l(e,Ne,a),l(e,B,a),l(e,Qe,a),l(e,S,a),l(e,ze,a),m(R,e,a),l(e,Pe,a),l(e,H,a),l(e,Fe,a),l(e,A,a),l(e,Ke,a),l(e,h,a),l(e,De,a),l(e,q,a),l(e,Oe,a),m(k,e,a),l(e,ea,a),l(e,Y,a),l(e,aa,a),l(e,N,a),l(e,ta,a),l(e,Q,a),l(e,la,a),l(e,z,a),l(e,na,a),m(P,e,a),l(e,sa,a),m(F,e,a),l(e,oa,a),l(e,K,a),l(e,ia,a),l(e,D,a),l(e,ra,a),l(e,T,a),y(T,Ze),y(T,Ra),m(O,T,null),l(e,da,a),m(ee,e,a),l(e,ca,a),l(e,j,a),l(e,ma,a),l(e,ae,a),l(e,ua,a),l(e,te,a),l(e,pa,a),m(le,e,a),l(e,ba,a),l(e,ne,a),l(e,Ma,a),l(e,se,a),l(e,fa,a),m(oe,e,a),l(e,ya,a),l(e,ie,a),l(e,va,a),l(e,re,a),l(e,ga,a),l(e,de,a),l(e,ha,a),m(ce,e,a),l(e,Ta,a),m(me,e,a),l(e,ja,a),l(e,ue,a),l(e,Ua,a),l(e,pe,a),l(e,xa,a),l(e,U,a),l(e,Ja,a),l(e,be,a),l(e,Za,a),m(Me,e,a),l(e,La,a),l(e,fe,a),l(e,wa,a),l(e,ye,a),l(e,Ca,a),m(ve,e,a),l(e,Ga,a),l(e,ge,a),l(e,Wa,a),l(e,M,a),y(M,Le),y(M,Ha),m(he,M,null),y(M,Aa),y(M,we),y(M,qa),y(M,Ce),l(e,_a,a),m(Te,e,a),l(e,Ea,a),l(e,x,a),l(e,Ia,a),l(e,je,a),l(e,$a,a),m(Ue,e,a),l(e,Va,a),l(e,We,a),Xa=!0},p:Xt,i(e){Xa||(u(Z.$$.fragment,e),u(L.$$.fragment,e),u(V.$$.fragment,e),u(R.$$.fragment,e),u(k.$$.fragment,e),u(P.$$.fragment,e),u(F.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(Me.$$.fragment,e),u(ve.$$.fragment,e),u(he.$$.fragment,e),u(Te.$$.fragment,e),u(Ue.$$.fragment,e),Xa=!0)},o(e){p(Z.$$.fragment,e),p(L.$$.fragment,e),p(V.$$.fragment,e),p(R.$$.fragment,e),p(k.$$.fragment,e),p(P.$$.fragment,e),p(F.$$.fragment,e),p(O.$$.fragment,e),p(ee.$$.fragment,e),p(le.$$.fragment,e),p(oe.$$.fragment,e),p(ce.$$.fragment,e),p(me.$$.fragment,e),p(Me.$$.fragment,e),p(ve.$$.fragment,e),p(he.$$.fragment,e),p(Te.$$.fragment,e),p(Ue.$$.fragment,e),Xa=!1},d(e){e&&(t(_e),t(Ge),t(Ee),t(Ie),t($e),t(w),t(Ve),t(C),t(Xe),t(G),t(Be),t(W),t(Se),t(_),t(Re),t(E),t(He),t(I),t(Ae),t($),t(qe),t(ke),t(g),t(Ye),t(X),t(Ne),t(B),t(Qe),t(S),t(ze),t(Pe),t(H),t(Fe),t(A),t(Ke),t(h),t(De),t(q),t(Oe),t(ea),t(Y),t(aa),t(N),t(ta),t(Q),t(la),t(z),t(na),t(sa),t(oa),t(K),t(ia),t(D),t(ra),t(T),t(da),t(ca),t(j),t(ma),t(ae),t(ua),t(te),t(pa),t(ba),t(ne),t(Ma),t(se),t(fa),t(ya),t(ie),t(va),t(re),t(ga),t(de),t(ha),t(Ta),t(ja),t(ue),t(Ua),t(pe),t(xa),t(U),t(Ja),t(be),t(Za),t(La),t(fe),t(wa),t(ye),t(Ca),t(Ga),t(ge),t(Wa),t(M),t(_a),t(Ea),t(x),t(Ia),t(je),t($a),t(Va),t(We)),t(f),b(Z,e),b(L,e),b(V,e),b(R,e),b(k,e),b(P,e),b(F,e),b(O),b(ee,e),b(le,e),b(oe,e),b(ce,e),b(me,e),b(Me,e),b(ve,e),b(he),b(Te,e),b(Ue,e)}}}const Yt='{"title":"¿Qué son los componentes en LlamaIndex?","local":"qué-son-los-componentes-en-llamaindex","sections":[{"title":"Creando un pipeline RAG usando componentes","local":"creando-un-pipeline-rag-usando-componentes","sections":[{"title":"Carga y embedding de documentos","local":"carga-y-embedding-de-documentos","sections":[],"depth":3},{"title":"Almacenamiento e indexación de documentos","local":"almacenamiento-e-indexación-de-documentos","sections":[],"depth":3},{"title":"Consultando un VectorStoreIndex con prompts y LLMs","local":"consultando-un-vectorstoreindex-con-prompts-y-llms","sections":[],"depth":3},{"title":"Procesamiento de Respuestas","local":"procesamiento-de-respuestas","sections":[],"depth":3},{"title":"Evaluación y observabilidad","local":"evaluación-y-observabilidad","sections":[],"depth":3}],"depth":2}],"depth":1}';function Nt(ka){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ot extends St{constructor(f){super(),Rt(this,f,Nt,kt,Vt,{})}}export{Ot as component};
