# LLM là gì?

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-1.jpg" alt="Unit 1 planning"/>

Ở phần trước, ta đã biết mỗi Agent cần **một mô hình AI làm lõi**, và LLM là loại mô hình AI phổ biến nhất cho mục đích này.

Giờ ta sẽ tìm hiểu LLM là gì và cách chúng vận hành Agent.

Phần này giải thích kỹ thuật ngắn gọn về LLM. Nếu muốn tìm hiểu sâu hơn, bạn có thể xem [khóa học Xử lý Ngôn ngữ Tự nhiên miễn phí](https://huggingface.co/learn/nlp-course/chapter1/1) của chúng mình.

## Mô hình ngôn ngữ lớn là gì?

Mô hình ngôn ngữ lớn (LLM) là một loại mô hình AI **giỏi hiểu và tạo ra ngôn ngữ con người**. Chúng được huấn luyện trên lượng lớn dữ liệu văn bản, cho phép học các mẫu, cấu trúc và sắc thái ngôn ngữ. Các mô hình này thường có hàng triệu tham số (parameters).

Hầu hết LLM hiện nay **dựa trên kiến trúc Transformer** - kiến trúc học sâu sử dụng thuật toán "Attention", thu hút sự quan tâm lớn từ khi BERT của Google ra mắt năm 2018.

<figure>
<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/transformer.jpg" alt="Transformer"/>
<figcaption>Kiến trúc Transformer nguyên bản gồm encoder (trái) và decoder (phải).
</figcaption>
</figure>

Có 3 loại transformers:

1. **Encoders**  
   Transformer dạng encoder nhận dữ liệu đầu vào dạng text (hoặc dữ liệu khác) và đầu ra trả về biểu diễn đặc (embedding) của text đó.

   - **Ví dụ**: BERT từ Google
   - **Ứng dụng**: Phân loại văn bản, tìm kiếm ngữ nghĩa, Nhận dạng thực thể
   - **Kích thước điển hình**: Hàng triệu tham số

2. **Decoders**  
   Transformer dạng decoder tập trung **tạo token mới để hoàn thành chuỗi, từng token một**.

   - **Ví dụ**: Llama từ Meta
   - **Ứng dụng**: Tạo văn bản, chatbot, sinh code
   - **Kích thước điển hình**: Hàng tỷ tham số (theo nghĩa Mỹ, tức 10^9)

3. **Seq2Seq (Encoder–Decoder)**  
   Transformer sequence-to-sequence _kết hợp_ encoder và decoder. Encoder xử lý đầu vào thành biểu diễn ngữ cảnh, decoder tạo ra đầu ra dạng chuỗi (sequence).

   - **Ví dụ**: T5, BART
   - **Ứng dụng**: Dịch máy, Tóm tắt, Diễn giải
   - **Kích thước điển hình**: Hàng triệu tham số

Dù LLM có nhiều dạng, chúng thường là mô hình dựa trên decoder với hàng tỷ tham số. Dưới đây là một số LLM nổi tiếng:

| **Model**                          | **Provider**                              |
|-----------------------------------|-------------------------------------------|
| **Deepseek-R1**                    | DeepSeek                                  |
| **GPT4**                           | OpenAI                                    |
| **Llama 3**                        | Meta (Facebook AI Research)               |
| **SmolLM2**                       | Hugging Face     |
| **Gemma**                          | Google                                    |
| **Mistral**                        | Mistral                                |

Nguyên lý cốt lõi của LLM đơn giản mà hiệu quả: **dự đoán token tiếp theo dựa trên chuỗi token trước đó**. "Token" là đơn vị thông tin LLM xử lý. Bạn có thể coi token như "từ", nhưng để tối ưu, LLM không dùng nguyên từ.

Ví dụ: Tiếng Anh có khoảng 600,000 từ, nhưng LLM như Llama 2 chỉ dùng ~32,000 tokens. Tokenization thường xử lý ở mức sub-word.

Ví dụ: Token "interest" + "ing" = "interesting", hoặc thêm "ed" thành "interested".

Bạn có thể thử nghiệm tokenizer trong playground tương tác dưới đây:

<iframe
	src="https://agents-course-the-tokenizer-playground.static.hf.space"
	frameborder="0"
	width="850"
	height="450"
></iframe>

Mỗi LLM có **token đặc biệt (special token)** riêng. Chúng được dùng để đánh dấu các thành phần trong quá trình tạo văn bản, ví dụ: bắt đầu/kết thúc chuỗi, tin nhắn, phản hồi. Quan trọng nhất là **token thông báo kết thúc chuỗi** (EOS).

Các token đặc biệt này rất đa dạng giữa các mô hình. Bảng dưới minh họa sự khác biệt:

<table>
  <thead>
    <tr>
      <th><strong>Mô hình</strong></th>
      <th><strong>Nhà cung cấp</strong></th>
      <th><strong>Token EOS</strong></th>
      <th><strong>Chức năng</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><strong>GPT4</strong></td>
      <td>OpenAI</td>
      <td><code>&lt;|endoftext|&gt;</code></td>
      <td>Kết thúc tin nhắn</td>
    </tr>
    <tr>
      <td><strong>Llama 3</strong></td>
      <td>Meta (Facebook AI Research)</td>
      <td><code>&lt;|eot_id|&gt;</code></td>
      <td>Kết thúc chuỗi</td>
    </tr>
    <tr>
      <td><strong>Deepseek-R1</strong></td>
      <td>DeepSeek</td>
      <td><code>&lt;|end_of_sentence|&gt;</code></td>
      <td>Kết thúc câu</td>
    </tr>
    <tr>
      <td><strong>SmolLM2</strong></td>
      <td>Hugging Face</td>
      <td><code>&lt;|im_end|&gt;</code></td>
      <td>Kết thúc hướng dẫn/tin nhắn</td>
    </tr>
    <tr>
      <td><strong>Gemma</strong></td>
      <td>Google</td>
      <td><code>&lt;end_of_turn&gt;</code></td>
      <td>Kết thúc lượt hội thoại</td>
    </tr>
  </tbody>
</table>

> [!TIP]
> Bạn không cần nhớ hết các token đặc biệt này, nhưng cần hiểu sự đa dạng và vai trò của chúng trong tạo văn bản. Muốn biết thêm, hãy xem cấu hình model trên Hugging Face Hub. Ví dụ: token đặc biệt của SmolLM2 có trong [tokenizer_config.json](https://huggingface.co/HuggingFaceTB/SmolLM2-135M-Instruct/blob/main/tokenizer_config.json).

## Hiểu về dự đoán token tiếp theo

LLM được gọi là **autoregressive (tự hồi quy)**, nghĩa là **đầu ra từ bước trước thành đầu vào cho bước sau**. Vòng lặp tiếp tục đến khi model dự đoán token EOS.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/AutoregressionSchema.gif" alt="Visual Gif of autoregressive decoding" width="60%">

Nói cách khác, LLM sẽ decode text đến khi gặp EOS. Nhưng điều gì xảy ra trong một vòng decode?

Dù quá trình đầy đủ khá kỹ thuật, đây là tổng quan ngắn:

- Sau khi **tokenize** input text, mô hình tính toán biểu diễn chuỗi, nắm bắt ý nghĩa và vị trí từng token.
- Biểu diễn này đi vào mô hình, đầu ra trả về điểm số xếp hạng khả năng mỗi token trong bộ từ vựng (vocab) là token tiếp theo.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/DecodingFinal.gif" alt="Visual Gif of decoding" width="60%">

Từ các điểm số này, ta có nhiều chiến lược chọn token:

- Chiến lược đơn giản nhất: chọn token có điểm cao nhất.

Bạn có thể tương tác với quá trình decode của SmolLM2 trong Space này (token EOS của mô hình này là **<|im_end|>**):

<iframe
	src="https://agents-course-decoding-visualizer.hf.space"
	frameborder="0"
	width="850"
	height="450"
></iframe>

- Có những chiến lược nâng cao hơn như *tìm kiếm chùm (beam search)*: khám phá nhiều chuỗi ứng viên để tìm chuỗi có tổng điểm cao nhất.

<iframe
	src="https://agents-course-beam-search-visualizer.hf.space"
	frameborder="0"
	width="850"
	height="450"
></iframe>

Muốn tìm hiểu thêm về decode, hãy xem [khóa NLP](https://huggingface.co/learn/nlp-course).

## Attention là tất cả

Yếu tố then chốt của Transformer là **Attention**. Khi dự đoán từ tiếp theo, không phải mọi từ trong câu đều quan trọng như nhau. Ví dụ: từ "France" và "capital" trong câu *"The capital of France is ..."* mang nhiều ý nghĩa nhất.

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/AttentionSceneFinal.gif" alt="Visual Gif of Attention" width="60%">
Quá trình xác định từ quan trọng nhất để dự đoán token tiếp theo đã chứng minh hiệu quả vượt trội.

Dù nguyên lý cơ bản của LLM - dự đoán token tiếp theo - không đổi từ thời GPT-2, đã có nhiều cải tiến trong việc mở rộng mạng neural và cơ chế attention cho các chuỗi dài hơn.

Nếu từng dùng LLM, hẳn bạn quen thuộc với khái niệm *độ dài ngữ cảnh (context length)* - số token tối đa mô hình xử lý được, tương đương _độ dài attention_ tối đa.

## Prompting rất quan trọng

Vì nhiệm vụ duy nhất của LLM là dự đoán token tiếp theo dựa trên các token input và chọn token "quan trọng", cách bạn diễn đạt chuỗi đầu vào (input sequence) rất quan trọng.

Chuỗi đầu vào bạn đưa vào LLM gọi là _prompt_. Thiết kế prompt cẩn thận giúp **định hướng đầu ra của LLM theo mong muốn**.

## LLM được huấn luyện thế nào?

LLM được huấn luyện trên bộ dữ liệu văn bản lớn, học cách dự đoán từ tiếp theo qua phương pháp mô hình tự giám sát (self-supervised) hoặc masked language modeling.

Từ học phi giám sát (unsupervised), mô hình học cấu trúc ngôn ngữ và **các mẫu ẩn trong văn bản**, cho phép tổng quát hóa với dữ liệu mới.

Sau giai đoạn _pre-training_, LLM có thể được tinh chỉnh trên supervised learning để thực hiện tác vụ cụ thể như hội thoại, sử dụng công cụ, phân loại, sinh code.

## Làm sao dùng LLM?

Có 2 lựa chọn chính:

1. **Chạy local** (nếu có phần cứng đủ mạnh).

2. **Dùng Cloud/API** (ví dụ qua Hugging Face Serverless Inference API).

Trong khóa học này, chúng ta chủ yếu dùng model qua API trên Hugging Face Hub. Sau đó ta sẽ khám phá cách chạy model local trên máy bạn.

## LLM được dùng thế nào trong AI agent?

LLM là thành phần then chốt của AI agent, **cung cấp nền tảng hiểu và tạo ngôn ngữ con người**.

Chúng có thể diễn giải chỉ dẫn, duy trì ngữ cảnh hội thoại, lập kế hoạch và quyết định dùng công cụ nào.

Ta sẽ tìm hiểu chi tiết các bước này trong chương, nhưng hiện tại bạn cần hiểu: LLM là **bộ não của Agent**.

---

Thật nhiều thông tin! Ta đã điểm qua kiến thức cơ bản về LLM, cách hoạt động và vai trò trong AI agent.

Nếu muốn khám phá sâu hơn về mô hình ngôn ngữ và xử lý ngôn ngữ tự nhiên, đừng ngần ngại xem [khóa học NLP miễn phí](https://huggingface.co/learn/nlp-course/chapter1/1) của chúng tôi.

Giờ đã hiểu cách LLM hoạt động, hãy xem **cách LLM cấu trúc output trong ngữ cảnh hội thoại**.

Để chạy [notebook này](https://huggingface.co/agents-course/notebooks/blob/main/unit1/dummy_agent_library.ipynb), **bạn cần Hugging Face token** lấy từ [https://hf.co/settings/tokens](https://hf.co/settings/tokens).

Xem thêm hướng dẫn chạy Jupyter Notebook tại [Jupyter Notebooks on the Hugging Face Hub](https://huggingface.co/docs/hub/notebooks).

Bạn cũng cần xin quyền truy cập [model Meta Llama](https://huggingface.co/meta-llama/Llama-3.2-3B-Instruct).

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/vi/unit1/what-are-llms.mdx" />