# 什么是 `LangGraph`？

`LangGraph` 是由 [LangChain](https://www.langchain.com/) 开发的框架，**用于管理集成 LLM 的应用程序的控制流**。

## `LangGraph` 和 `LangChain` 有何不同？

LangChain 提供了与模型和其他组件交互的标准接口，可用于检索、LLM 调用和工具调用。
LangChain 的类可能会在 LangGraph 中使用，但不是必须的。

这两个包是独立的可以单独使用，但最终你在网上找到的资源都会同时使用这两个包。

## 何时应该使用 `LangGraph`？
### 控制 vs 自由度

在设计 AI 应用时，你面临 **控制** 与 **自由度** 的基本权衡：

- **自由度** 赋予 LLM 更多创造性地解决问题的空间
- **控制** 能确保可预测的行为并维持安全护栏

像 *smolagents* 中的代码智能体（Code Agents）具有高度自由度。它们可以在单个行动步骤中调用多个工具、创建自己的工具等。然而，这种行为会使它们比使用 JSON 的常规 Agent 更难预测和控制！

`LangGraph` 则位于光谱的另一端，当你需要对智能体的执行进行 **"控制"** 时，它就会大放异彩。

当你需要 **对应用程序保持控制** 时，LangGraph 特别有价值。它为你提供了构建可预测流程应用程序的工具，同时仍能利用 LLM 的强大能力。

简而言之，如果你的应用程序包含需要以特定方式编排的多个步骤，并在每个连接点做出决策，**LangGraph 就能提供你所需的结构**。

举个例子，假设我们要构建一个能够回答文档相关问题的 LLM 助手。

由于 LLM 最擅长理解文本，在回答问题之前，你需要将其他复杂模态（图表、表格）转换为文本。但这个选择取决于你拥有的文档类型！

我选择将这种分支流程表示为：

<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/flow.png" alt="控制流程图"/>

> 💡 **提示:** 左侧部分不是智能体，因为这里不涉及工具调用。但右侧部分需要编写代码来查询 xls 文件（转换为 pandas 并操作它）。

虽然这个分支是确定性的，但你也可以设计基于 LLM 输出结果的非确定性条件分支。

LangGraph 表现出色的关键场景包括：

- 需要显式控制流程的 **多步骤推理过程**
- 需要在步骤之间 **保持状态持久化** 的应用程序
- **结合确定性逻辑与 AI 能力** 的系统
- 需要 **人工介入** 的工作流
- 多个组件协同工作的 **复杂智能体架构**

本质上，只要有可能，**作为人类** 就应该根据每个操作的输出设计行动流程，并据此决定下一步执行什么。在这种情况下，LangGraph 就是你正确的选择！

在我看来，`LangGraph` 是市场上最适合生产环境的智能体框架。

## LangGraph 如何工作？

其核心在于，`LangGraph` 使用有向图结构来定义应用程序的流程：

- **节点** 表示独立的处理步骤（如调用 LLM、使用工具或做出决策）
- **边** 定义步骤之间可能的转换
- **状态** 由用户定义和维护，并在执行期间在节点间传递。当决定下一个目标节点时，我们查看的就是当前状态

我们将在下一章更深入地探讨这些基本模块！

## 它和普通 Python 有何不同？为什么需要 LangGraph？

你可能会想："我可以用常规 Python 代码和 if-else 语句来处理所有这些流程，对吧？"

虽然技术上可行，但对于构建复杂系统，LangGraph 相比原生 Python 有 **诸多优势**。没有 LangGraph 你也能构建相同应用，但它能为你提供更便捷的工具和抽象。

它包含状态管理、可视化、日志追踪（traces）、内置的人类介入机制等功能。

<EditOnGithub source="https://github.com/huggingface/agents-course/blob/main/units/zh-CN/unit2/langgraph/when_to_use_langgraph.mdx" />