import{s as Js,o as js,n as jl}from"../chunks/scheduler.9039eef2.js";import{S as fs,i as bs,g as i,s as a,r as M,A as Cs,h as o,f as l,c as n,j as Us,u as m,x as r,k as Ul,y as Is,a as s,v as c,d as u,t as d,w as h}from"../chunks/index.cdcc3d35.js";import{T as Jl}from"../chunks/Tip.6f74db41.js";import{C as j}from"../chunks/CodeBlock.e3ac94d9.js";import{H as g}from"../chunks/Heading.96ce3702.js";function gs(I){let p,f=`While we will use <code>Llama-3 8B</code> in this tutorial, it is completely possible to use other models, simply by swtiching the <code>model_id</code>.
For instance, it is possible to fine-tune:`,y,w,b='<li>Mistral models, such as  <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.2" rel="nofollow">Mistral 7b (<code>mistralai/Mistral-7B-Instruct-v0.3</code>)</a></li> <li>Llama-2 models, such as <a href="https://huggingface.co/meta-llama/Llama-2-7b-hf" rel="nofollow">Llama-2 7b (<code>meta-llama/Llama-2-7b-hf</code>)</a></li>',T,U,Le="And many others!";return{c(){p=i("p"),p.innerHTML=f,y=a(),w=i("ul"),w.innerHTML=b,T=a(),U=i("p"),U.textContent=Le},l(J){p=o(J,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1f24nyx"&&(p.innerHTML=f),y=n(J),w=o(J,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-1fsabqd"&&(w.innerHTML=b),T=n(J),U=o(J,"P",{"data-svelte-h":!0}),r(U)!=="svelte-yii95m"&&(U.textContent=Le)},m(J,C){s(J,p,C),s(J,y,C),s(J,w,C),s(J,T,C),s(J,U,C)},p:jl,d(J){J&&(l(p),l(y),l(w),l(T),l(U))}}}function Bs(I){let p,f='If you want to know more about distributed training you can take a look at the <a href="https://huggingface.co/docs/optimum-neuron/guides/distributed_training" rel="nofollow">documentation</a>.';return{c(){p=i("p"),p.innerHTML=f},l(y){p=o(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-yp02re"&&(p.innerHTML=f)},m(y,w){s(y,p,w)},p:jl,d(y){y&&l(p)}}}function Ws(I){let p,f='This script is a minimalistic version of our official example training script to run causal language modeling fine-tuning, called <a href="https://github.com/huggingface/optimum-neuron/blob/main/examples/language-modeling/run_clm.py" rel="nofollow">run_clm.py</a>. For the sake of this tutorial, we tried to get rid of anything that is not necessary, and added the formatting step necessary for fine-tuning, but if you want to do more custom things, maybe the solution is already implemented in <code>run_clm.py</code>!',y,w,b="Also, these scripts are more designed as templates than final scripts. Feel free to take <code>finetune_llm.py</code> or <code>run_clm.py</code> and adapt them to your own needs!";return{c(){p=i("p"),p.innerHTML=f,y=a(),w=i("p"),w.innerHTML=b},l(T){p=o(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1hrw5ii"&&(p.innerHTML=f),y=n(T),w=o(T,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1k8wfq8"&&(w.innerHTML=b)},m(T,U){s(T,p,U),s(T,y,U),s(T,w,U)},p:jl,d(T){T&&(l(p),l(y),l(w))}}}function Gs(I){let p,f="Make sure to run this precompilation phase for around 10 training steps. It is usually enough to accumulate and compile all the graphs that will be needed during the actual training.";return{c(){p=i("p"),p.textContent=f},l(y){p=o(y,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1k7qt99"&&(p.textContent=f)},m(y,w){s(y,p,w)},p:jl,d(y){y&&l(p)}}}function Zs(I){let p,f,y,w,b,T,U,Le='<em>Note: The complete script for this tutorial can be downloaded <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/finetune_llm.py" rel="nofollow">here</a>.</em>',J,C,fl='This tutorial will teach you how to fine-tune open source LLMs like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B" rel="nofollow">Llama 3</a> on AWS Trainium. In our example, we are going to leverage the <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>, <a href="https://huggingface.co/docs/transformers/index" rel="nofollow">Transformers</a> and <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">Datasets</a> libraries.',Pe,v,bl="You will learn how to:",De,X,Cl='<li><a href="#1-setup-aws-environment">Setup AWS Environment</a></li> <li><a href="#2-load-and-prepare-the-dataset">Load and process the dataset</a></li> <li><a href="#3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer">Fine-tune Llama on AWS Trainium using the <code>NeuronTrainer</code></a></li> <li><a href="#4-launch-training">Launch Training</a></li> <li><a href="#5-evaluate-and-test-fine-tuned-llama-model">Evaluate and test fine-tuned Llama model</a></li>',Ke,B,Oe,$,et,x,Il="Before starting this tutorial, you will need to setup your environment:",tt,R,gl='<li>Create an AWS Trainium instance. <strong>You will need a <code>trn1.32xlarge</code>, which contains 16 Neuron Devices.</strong> You can follow this <a href="https://huggingface.co/docs/optimum-neuron/guides/setup_aws_instance" rel="nofollow">guide</a> to create one.</li> <li>Make sure you are logged in on the Hugging Face Hub:</li>',lt,V,st,W,Bl="<li>Check that you have access to the model. Some open source models are gated, meaning that users need to apply to the model owner to be able to use the model weights. Here we will be training Llama-3 8B, for which there are two possibilities:</li>",at,A,Wl='<li>The official gated repo: <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B" rel="nofollow"><code>meta-llama/Meta-Llama-3-8B</code></a></li> <li>The non-official un-gated repo: <a href="https://huggingface.co/NousResearch/Meta-Llama-3-8B" rel="nofollow"><code>NousResearch/Meta-Llama-3-8B</code></a></li>',nt,G,Gl='<li>Clone the Optimum Neuron repository, <strong>which contains the <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/finetune_llm.py" rel="nofollow">complete script</a> described in this tutorial:</strong></li>',it,H,ot,S,rt,Y,Zl='For this tutorial, we will use <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Dolly</a>, an open source dataset of instruction-following records on categories outlined in the <a href="https://arxiv.org/abs/2203.02155" rel="nofollow">InstructGPT paper</a>, including brainstorming, classification, closed QA, generation, information extraction, open QA, and summarization.',pt,z,kl="Example:",Mt,N,mt,E,_l="We can use the <code>load_dataset()</code> method from the 🤗 Datasets library to load the <code>dolly</code> dataset very easily.",ct,Q,ut,F,vl="To instruct tune our model we need to convert our structured examples into a collection of tasks described via instructions. We define a <code>format_dolly</code> that takes a raw sample and returns a string with our format instruction.",dt,L,ht,q,Xl="In addition to formatting our samples, we also want to pack multiple samples to one sequence to have a more efficient training. In other words, we are stacking multiple samples to one sequence and split them with an EOS Token. Packing/stacking samples can be done during training or before.",yt,P,$l="The following function <code>pack_dataset</code> takes a <code>dataset</code> and a <code>chunk_length</code> and returns a packed dataset:",wt,D,Tt,K,xl="To summarize to prepare our dataset we will:",Ut,O,Rl="<li>Format our samples using the template method and add an EOS token at the end of each sample</li> <li>Tokenize our dataset to convert it from text to tokens</li> <li>Pack our dataset to 2048 tokens</li>",Jt,ee,jt,te,ft,le,Vl='Normally you would use the <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a></strong> and <strong><a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a></strong> classes to fine-tune PyTorch-based transformer models.',bt,se,Al="But together with AWS, we have developed the [~<code>optimum.neuron.NeuronTrainer</code>] to improve performance, robustness, and ease-of-use when training on Trainium instances. It can be used as a 1-to-1 replacement for the <code>Trainer</code>.",Ct,ae,Hl="Since Llama-3 8B is a big model it will not fit on a single Neuron core, we need distributed training. In Optimum Neuron we support:",It,ne,Sl='<li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/frameworks/torch/torch-neuronx/tutorials/training/zero1_gpt2.html" rel="nofollow">ZeRO-1</a>: It is an optimization of data-parallelism which consists in sharding the optimizer state (which usually represents half or more of the memory needed on the device) over the data-parallel ranks.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/tensor_parallelism_overview.html" rel="nofollow">Tensor Parallelism</a>: It is a technique which consists in sharding each of your model matrix-multiplications along a given axis (row or column) on multiple devices. It also known as intra-layer model parallelism. The number of devices to shard your parameters on is called the <code>tensor_parallel_size</code>.</li> <li><a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a>: It is an optimization over Tensor Parallelism which shards the activations on the sequence axis outside of the tensor parallel regions. It is useful because it saves memory by sharding the activations.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/pipeline_parallelism_overview.html" rel="nofollow">Pipeline Parallelism</a>: It consists in sharding the model block layers on multiple devices. It is also known as inter-layer model parallelism. The number of devices to shard your layers on is called the <code>pipeline_parallel_size</code>.</li>',gt,Z,Bt,ie,Yl=`Here, since we want to fine-tune an 8B model, we will not need to use pipeline parallelism.
Our training code will look as follows:`,Wt,oe,Gt,re,zl="The key points here are:",Zt,pe,Nl="<li>We use the <code>lazy_load_for_parallelism</code> context manager to lazily load the model. This will not load the full model weights on each worker, but instead only load the required weights (sharded or full). <strong>This is much more memory efficient, and often mandatory to use.</strong></li> <li>We use the [~<code>optimum.neuron.NeuronTrainer</code>] to perform training. It will take the lazily loaded model, along with the <code>training_args</code>, which are an instance of [~<code>optimum.neuron.NeuronTrainingArguments</code>], and will handle all the parallelization and training on the Neuron cores.</li>",kt,Me,_t,me,El='We prepared a script called <a href="https://github.com/huggingface/optimum-neuron/blob/main/docs/source/training_tutorials/finetune_llm.py" rel="nofollow">finetune_llm.py</a> summing up everything mentioned in this tutorial.',vt,k,Xt,ce,Ql="PyTorch Neuron uses <code>torch_xla</code>. It evaluates operations lazily during execution of the training loops, which means it builds a symbolic graph in the background and the graph is executed on the hardware only when the tensor is printed, transfered to CPU, or <code>xm.mark_step()</code> is called. During execution, multiple graphs can be build depending on control-flow and it can take time to compile each graph sequentially. To alleviate that, the Neuron SDK provides <code>neuron_parallel_compile</code>, a tool which performs a fast trial run that builds all the graphs and compile them in parallel. This step is usually called precompilation.",$t,ue,xt,de,Fl="When training models on AWS Trainium we first need to compile our model with our training arguments.",Rt,he,Ll='To overcome this, we added a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">model cache repository</a>, which allows us to use precompiled models from the Hugging Face Hub to skip the compilation step. But be careful: every change in the model configuration might lead to a new compilation, which could result in some cache misses.',Vt,ye,ql='<em>Note: If your model configuration is not cached please open an issue on <a href="https://github.com/huggingface/optimum-neuron/issues" rel="nofollow">Github</a>, we are happy to include it.</em>',At,we,Pl="The compilation command simply consists in calling your script as an input to the <code>neuron_parallel_compile</code> utility:",Ht,Te,St,_,Yt,Ue,Dl="<em>Note: Compiling without a cache can take a while. It will also create dummy files in the <code>dolly_llama_sharded</code> during compilation you will have to remove them afterwards. We also need to add <code>MALLOC_ARENA_MAX=64</code> to limit the CPU allocation to avoid potential crashes, don’t remove it for now.</em>",zt,Je,Nt,je,Et,fe,Kl="After compilation is done we can start our actual training with a similar command, we just need to remove the use of <code>neuron_parallel_compile</code>.",Qt,be,Ol="We will use <code>torchrun</code> to launch our training script. <code>torchrun</code> is a tool that automatically distributes a PyTorch model across multiple accelerators. We can pass the number of accelerators as <code>nproc_per_node</code> arguments alongside our hyperparameters.",Ft,Ce,es="The difference to the compilation command is that we changed from <code>max_steps=10</code> to <code>num_train_epochs=3</code>.",Lt,Ie,ts="Launch the training, with the following command.",qt,ge,Pt,Be,ls="That’s it, we successfully trained Llama-3 8B on AWS Trainium!",Dt,We,ss="But before we can share and test our model we need to consolidate our model. Since we used Tensor Parallelism during training, we saved sharded versions of the checkpoints. We need to consolidate them now.",Kt,Ge,Ot,Ze,as="The Optimum CLI provides a way of doing that very easily via the <code>optimum neuron consolidate [sharded_checkpoint] [output_dir]</code> command:",el,ke,tl,_e,ll,ve,ns="As for training, to be able to run inference on AWS Trainium or AWS Inferentia2 we need to compile our model. In this case, we will use our Trainium instance for the inference test, but we recommend customer to switch to Inferentia2 for inference.",sl,Xe,is="Optimum Neuron implements similar to Transformers AutoModel classes for easy inference use. We will use the <code>NeuronModelForCausalLM</code> class to load our vanilla transformers checkpoint and convert it to neuron.",al,$e,nl,xe,os="<em>Note: Inference compilation can take ~25minutes. Luckily, you need to only run this onces. Since you can save the model afterwards. If you are going to run on Inferentia2 you need to recompile again. The compilation is parameter and hardware specific.</em>",il,Re,ol,Ve,rs="We can now test inference, but have to make sure we format our input to our prompt format we used for fine-tuning. Therefore we created a helper method, which accepts a <code>dict</code> with our <code>instruction</code> and optionally a <code>context</code>.",rl,Ae,pl,He,ps="Let’s test inference. First we test without a context.",Ml,Se,Ms="<em>Note: Inference is not expected to be super fast on AWS Trainium using 2 cores. For Inference we recommend using Inferentia2.</em>",ml,Ye,cl,ze,ms="<p>AWS stands for Amazon Web Services. AWS is a suite of remote computing services offered by Amazon. The most widely used of these include Amazon Elastic Compute Cloud (Amazon EC2), which provides resizable compute capacity in the cloud; Amazon Simple Storage Service (Amazon S3), which is an object storage service; and Amazon Elastic Block Store (Amazon EBS), which is designed to provide high performance, durable block storage volumes for use with AWS instances. AWS also provides other services, such as AWS Identity and Access Management (IAM), a service that enables organizations to control access to their AWS resources, and AWS Key Management Service (AWS KMS), which helps customers create and control the use of encryption keys.</p>",ul,Ne,cs="That looks correct. Now, lets add some context, e.g. as you would do for RAG applications:",dl,Ee,hl,Qe,us="<p>You can use the Optimum Neuron interface to train models on AWS Trainium.</p>",yl,Fe,ds="Awesome, our model also correctly uses the provided context. We are done. Congrats on fine-tuning Llama on AWS Trainium.",wl,qe,Tl;return b=new g({props:{title:"Fine-tune and Test Llama-3 8B on AWS Trainium",local:"fine-tune-and-test-llama-3-8b-on-aws-trainium",headingTag:"h1"}}),B=new Jl({props:{$$slots:{default:[gs]},$$scope:{ctx:I}}}),$=new g({props:{title:"1. Setup AWS Environment",local:"1-setup-aws-environment",headingTag:"h2"}}),V=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4lMjAtLXRva2VuJTIwWU9VUl9UT0tFTg==",highlighted:"huggingface-cli login --token YOUR_TOKEN",wrap:!1}}),H=new j({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRm9wdGltdW0tbmV1cm9uLmdpdA==",highlighted:'git <span class="hljs-built_in">clone</span> https://github.com/huggingface/optimum-neuron.git',wrap:!1}}),S=new g({props:{title:"2. Load and prepare the dataset",local:"2-load-and-prepare-the-dataset",headingTag:"h2"}}),N=new j({props:{code:"JTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB3b3JsZCUyMG9mJTIwd2FyY3JhZnQlMjIlMkMlMEElMjAlMjAlMjJjb250ZXh0JTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV29ybGQlMjBvZiUyMHdhcmNyYWZ0JTIwaXMlMjBhJTIwbWFzc2l2ZSUyMG9ubGluZSUyMG11bHRpJTIwcGxheWVyJTIwcm9sZSUyMHBsYXlpbmclMjBnYW1lLiUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkl0JTIwd2FzJTIwcmVsZWFzZWQlMjBpbiUyMDIwMDQlMjBieSUyMGJsaXphcnJlJTIwZW50ZXJ0YWlubWVudCUyMiUwQSUyMCUyMCUyMCUyMCklMEElN0Q=",highlighted:`{
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;What is world of warcraft&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;&quot;</span>,
  <span class="hljs-string">&quot;response&quot;</span>: (
        <span class="hljs-string">&quot;World of warcraft is a massive online multi player role playing game. &quot;</span>
        <span class="hljs-string">&quot;It was released in 2004 by blizarre entertainment&quot;</span>
    )
}`,wrap:!1}}),Q=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHJhbmRvbSUyMGltcG9ydCUyMHJhbmRyYW5nZSUwQSUwQSUyMyUyMExvYWQlMjBkYXRhc2V0JTIwZnJvbSUyMHRoZSUyMGh1YiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZGF0YWJyaWNrcyUyRmRhdGFicmlja3MtZG9sbHktMTVrJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEElMEFwcmludChmJTIyZGF0YXNldCUyMHNpemUlM0ElMjAlN0JsZW4oZGF0YXNldCklN0QlMjIpJTBBcHJpbnQoZGF0YXNldCU1QnJhbmRyYW5nZShsZW4oZGF0YXNldCkpJTVEKSUwQSUyMyUyMGRhdGFzZXQlMjBzaXplJTNBJTIwMTUwMTE=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randrange

<span class="hljs-comment"># Load dataset from the hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;dataset size: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(dataset)}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(dataset[randrange(<span class="hljs-built_in">len</span>(dataset))])
<span class="hljs-comment"># dataset size: 15011</span>`,wrap:!1}}),L=new j({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5KHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBpbnN0cnVjdGlvbiUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiU1Q24lN0JzYW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwY29udGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBDb250ZXh0JTVDbiU3QnNhbXBsZSU1Qidjb250ZXh0JyU1RCU3RCUyMiUyMGlmJTIwbGVuKHNhbXBsZSU1QiUyMmNvbnRleHQlMjIlNUQpJTIwJTNFJTIwMCUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiU3QnNhbXBsZSU1QidyZXNwb25zZSclNUQlN0QlMjIlMEElMjAlMjAlMjAlMjAlMjMlMjBqb2luJTIwYWxsJTIwdGhlJTIwcGFydHMlMjB0b2dldGhlciUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;context&quot;</span>]) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;response&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-comment"># join all the parts together</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt`,wrap:!1}}),D=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-keyword">from</span> itertools <span class="hljs-keyword">import</span> chain

<span class="hljs-comment"># empty list to save remainder from batches to use in next batch</span>
remainder = {<span class="hljs-string">&quot;input_ids&quot;</span>: [], <span class="hljs-string">&quot;attention_mask&quot;</span>: [], <span class="hljs-string">&quot;token_type_ids&quot;</span>: []}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">pack_dataset</span>(<span class="hljs-params">dataset, chunk_length=<span class="hljs-number">2048</span></span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Chunking dataset into chunks of <span class="hljs-subst">{chunk_length}</span> tokens.&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">chunk</span>(<span class="hljs-params">sample, chunk_length=chunk_length</span>):
        <span class="hljs-comment"># define global remainder variable to save remainder from batches to use in next batch</span>
        <span class="hljs-keyword">global</span> remainder
        <span class="hljs-comment"># Concatenate all texts and add remainder from previous batch</span>
        concatenated_examples = {k: <span class="hljs-built_in">list</span>(chain(*sample[k])) <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> sample.keys()}
        concatenated_examples = {k: remainder[k] + concatenated_examples[k] <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> concatenated_examples.keys()}
        <span class="hljs-comment"># get total number of tokens for batch</span>
        batch_total_length = <span class="hljs-built_in">len</span>(concatenated_examples[<span class="hljs-built_in">list</span>(sample.keys())[<span class="hljs-number">0</span>]])

        <span class="hljs-comment"># get max number of chunks for batch</span>
        <span class="hljs-keyword">if</span> batch_total_length &gt;= chunk_length:
            batch_chunk_length = (batch_total_length // chunk_length) * chunk_length

        <span class="hljs-comment"># Split by chunks of max_len.</span>
        result = {
            k: [t[i : i + chunk_length] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, batch_chunk_length, chunk_length)]
            <span class="hljs-keyword">for</span> k, t <span class="hljs-keyword">in</span> concatenated_examples.items()
        }
        <span class="hljs-comment"># add remainder to global variable for next batch</span>
        remainder = {k: concatenated_examples[k][batch_chunk_length:] <span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> concatenated_examples.keys()}
        <span class="hljs-comment"># prepare labels</span>
        result[<span class="hljs-string">&quot;labels&quot;</span>] = result[<span class="hljs-string">&quot;input_ids&quot;</span>].copy()
        <span class="hljs-keyword">return</span> result

    <span class="hljs-comment"># tokenize and chunk dataset</span>
    lm_dataset = dataset.<span class="hljs-built_in">map</span>(
        partial(chunk, chunk_length=chunk_length),
        batched=<span class="hljs-literal">True</span>,
    )
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total number of samples: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(lm_dataset)}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> lm_dataset`,wrap:!1}}),ee=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwcmFuZG9tJTIwaW1wb3J0JTIwcmFuZGludCUwQSUwQSUyMyUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwbW9kZWwlMjBpZCUyMCUwQSUyMyUyMG1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04QiUyMiUyMCUyMyUyMGdhdGVkJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJOb3VzUmVzZWFyY2glMkZNZXRhLUxsYW1hLTMtOEIlMjIlMjAlMjMlMjB1bmdhdGVkJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTIzJTIwdGVtcGxhdGUlMjBkYXRhc2V0JTIwdG8lMjBhZGQlMjBwcm9tcHQlMjB0byUyMGVhY2glMjBzYW1wbGUlMEFkZWYlMjB0ZW1wbGF0ZV9kYXRhc2V0KHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGUlNUIlMjJ0ZXh0JTIyJTVEJTIwJTNEJTIwZiUyMiU3QmZvcm1hdF9kb2xseShzYW1wbGUpJTdEJTdCdG9rZW5pemVyLmVvc190b2tlbiU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNhbXBsZSUwQSUwQSUyMyUyMGFwcGx5JTIwcHJvbXB0JTIwdGVtcGxhdGUlMjBwZXIlMjBzYW1wbGUlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAodGVtcGxhdGVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEbGlzdChkYXRhc2V0LmZlYXR1cmVzKSklMEElMEElMjMlMjBwcmludCUyMHJhbmRvbSUyMHNhbXBsZSUwQXByaW50KGRhdGFzZXQlNUJyYW5kaW50KDAlMkMlMjBsZW4oZGF0YXNldCkpJTVEJTVCJTIydGV4dCUyMiU1RCklMEElMEElMjMlMjB0b2tlbml6ZSUyMGRhdGFzZXQlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwbGFtYmRhJTIwc2FtcGxlJTNBJTIwdG9rZW5pemVyKHNhbXBsZSU1QiUyMnRleHQlMjIlNUQpJTJDJTIwYmF0Y2hlZCUzRFRydWUlMkMlMjByZW1vdmVfY29sdW1ucyUzRGxpc3QoZGF0YXNldC5mZWF0dXJlcyklMEEpJTBBJTBBJTIzJTIwY2h1bmslMjBkYXRhc2V0JTBBbG1fZGF0YXNldCUyMCUzRCUyMHBhY2tfZGF0YXNldChkYXRhc2V0JTJDJTIwY2h1bmtfbGVuZ3RoJTNEMjA0OCklMjAlMjMlMjBXZSUyMHVzZSUyMDIwNDglMjBhcyUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMjBmb3IlMjBwYWNraW5n",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> random <span class="hljs-keyword">import</span> randint

<span class="hljs-comment"># Hugging Face Hub model id </span>
<span class="hljs-comment"># model_id = &quot;meta-llama/Meta-Llama-3-8B&quot; # gated</span>
model_id = <span class="hljs-string">&quot;NousResearch/Meta-Llama-3-8B&quot;</span> <span class="hljs-comment"># ungated</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)

<span class="hljs-comment"># template dataset to add prompt to each sample</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">template_dataset</span>(<span class="hljs-params">sample</span>):
    sample[<span class="hljs-string">&quot;text&quot;</span>] = <span class="hljs-string">f&quot;<span class="hljs-subst">{format_dolly(sample)}</span><span class="hljs-subst">{tokenizer.eos_token}</span>&quot;</span>
    <span class="hljs-keyword">return</span> sample

<span class="hljs-comment"># apply prompt template per sample</span>
dataset = dataset.<span class="hljs-built_in">map</span>(template_dataset, remove_columns=<span class="hljs-built_in">list</span>(dataset.features))

<span class="hljs-comment"># print random sample</span>
<span class="hljs-built_in">print</span>(dataset[randint(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset))][<span class="hljs-string">&quot;text&quot;</span>])

<span class="hljs-comment"># tokenize dataset</span>
dataset = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> sample: tokenizer(sample[<span class="hljs-string">&quot;text&quot;</span>]), batched=<span class="hljs-literal">True</span>, remove_columns=<span class="hljs-built_in">list</span>(dataset.features)
)

<span class="hljs-comment"># chunk dataset</span>
lm_dataset = pack_dataset(dataset, chunk_length=<span class="hljs-number">2048</span>) <span class="hljs-comment"># We use 2048 as the maximum length for packing</span>`,wrap:!1}}),te=new g({props:{title:"3. Fine-tune Llama on AWS Trainium using the NeuronTrainer",local:"3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer",headingTag:"h2"}}),Z=new Jl({props:{$$slots:{default:[Bs]},$$scope:{ctx:I}}}),oe=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5lciUyMGFzJTIwVHJhaW5lciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5kaXN0cmlidXRlZCUyMGltcG9ydCUyMGxhenlfbG9hZF9mb3JfcGFyYWxsZWxpc20lMEElMEElMjMlMjBEZWZpbmUlMjB0aGUlMjB0ZW5zb3JfcGFyYWxsZWxfc2l6ZSUwQXRlbnNvcl9wYXJhbGxlbF9zaXplJTIwJTNEJTIwOCUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWdnaW5nJTIwZmFjZSUyMEh1YiUyMCUwQXdpdGglMjBsYXp5X2xvYWRfZm9yX3BhcmFsbGVsaXNtKHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEdGVuc29yX3BhcmFsbGVsX3NpemUpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGVmYXVsdF9kYXRhX2NvbGxhdG9yJTJDJTIwJTIwJTIzJTIwbm8lMjBzcGVjaWFsJTIwY29sbGF0b3IlMjBuZWVkZWQlMjBzaW5jZSUyMHdlJTIwc3RhY2tlZCUyMHRoZSUyMGRhdGFzZXQlMEEpJTBBJTBBJTIzJTIwU3RhcnQlMjB0cmFpbmluZyUwQXRyYWluZXIudHJhaW4oKSUwQSUwQXRyYWluZXIuc2F2ZV9tb2RlbCgpJTIwJTIwJTIzJTIwc2F2ZXMlMjB0aGUlMjB0b2tlbml6ZXIlMjB0b28lMjBmb3IlMjBlYXN5JTIwdXBsb2Fk",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainer <span class="hljs-keyword">as</span> Trainer
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> lazy_load_for_parallelism

<span class="hljs-comment"># Define the tensor_parallel_size</span>
tensor_parallel_size = <span class="hljs-number">8</span>

<span class="hljs-comment"># Load model from the Hugging face Hub </span>
<span class="hljs-keyword">with</span> lazy_load_for_parallelism(tensor_parallel_size=tensor_parallel_size):
    model = AutoModelForCausalLM.from_pretrained(model_id)

trainer = Trainer(
    model=model,
    tokenizer=tokenizer,
    args=training_args,
    train_dataset=dataset,
    data_collator=default_data_collator,  <span class="hljs-comment"># no special collator needed since we stacked the dataset</span>
)

<span class="hljs-comment"># Start training</span>
trainer.train()

trainer.save_model()  <span class="hljs-comment"># saves the tokenizer too for easy upload</span>`,wrap:!1}}),Me=new g({props:{title:"4. Launch Training",local:"4-launch-training",headingTag:"h2"}}),k=new Jl({props:{$$slots:{default:[Ws]},$$scope:{ctx:I}}}),ue=new g({props:{title:"Precompilation",local:"precompilation",headingTag:"h3"}}),Te=new j({props:{code:"TUFMTE9DX0FSRU5BX01BWCUzRDY0JTIwWExBX1VTRV9CRjE2JTNEMSUyMG5ldXJvbl9wYXJhbGxlbF9jb21waWxlJTIwdG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMzIlMjBmaW5ldHVuZV9sbG0ucHklMjAlNUMlMEElMjAtLW1vZGVsX2lkJTIwbWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04QiUyMCU1QyUwQSUyMC0tYmYxNiUyMFRydWUlMjAlNUMlMEElMjAtLWxlYXJuaW5nX3JhdGUlMjA1ZS01JTIwJTVDJTBBJTIwLS1vdXRwdXRfZGlyJTIwZG9sbHlfbGxhbWElMjAlNUMlMEElMjAtLW92ZXJ3cml0ZV9vdXRwdXRfZGlyJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMSUyMCU1QyUwQSUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwMTYlMjAlNUMlMEElMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBUcnVlJTIwJTVDJTBBJTIwLS10ZW5zb3JfcGFyYWxsZWxfc2l6ZSUyMDglMjAlNUMlMEElMjAtLW1heF9zdGVwcyUyMDEwJTIwJTVDJTBBJTIwLS1sb2dnaW5nX3N0ZXBzJTIwMTA=",highlighted:`MALLOC_ARENA_MAX=64 XLA_USE_BF16=1 neuron_parallel_compile torchrun --nproc_per_node=32 finetune_llm.py \\
 --model_id meta-llama/Meta-Llama-3-8B \\
 --bf16 True \\
 --learning_rate 5e-5 \\
 --output_dir dolly_llama \\
 --overwrite_output_dir True \\
 --per_device_train_batch_size 1 \\
 --gradient_accumulation_steps 16 \\
 --gradient_checkpointing True \\
 --tensor_parallel_size 8 \\
 --max_steps 10 \\
 --logging_steps 10`,wrap:!1}}),_=new Jl({props:{$$slots:{default:[Gs]},$$scope:{ctx:I}}}),Je=new j({props:{code:"JTIzJTIwcmVtb3ZlJTIwZHVtbXklMjBhcnRpZmFjdHMlMjB3aGljaCUyMGFyZSUyMGNyZWF0ZWQlMjBieSUyMHRoZSUyMHByZWNvbXBpbGF0aW9uJTIwY29tbWFuZCUwQXJtJTIwLXJmJTIwZG9sbHlfbGxhbWE=",highlighted:`<span class="hljs-comment"># remove dummy artifacts which are created by the precompilation command</span>
<span class="hljs-built_in">rm</span> -rf dolly_llama`,wrap:!1}}),je=new g({props:{title:"Actual Training",local:"actual-training",headingTag:"h3"}}),ge=new j({props:{code:"TUFMTE9DX0FSRU5BX01BWCUzRDY0JTIwWExBX1VTRV9CRjE2JTNEMSUyMHRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUzRDMyJTIwZmluZXR1bmVfbGxtLnB5JTIwJTVDJTBBJTIwLS1tb2RlbF9pZCUyMG1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEIlMjAlNUMlMEElMjAtLWJmMTYlMjBUcnVlJTIwJTVDJTBBJTIwLS1sZWFybmluZ19yYXRlJTIwNWUtNSUyMCU1QyUwQSUyMC0tb3V0cHV0X2RpciUyMGRvbGx5X2xsYW1hJTIwJTVDJTBBJTIwLS1vdmVyd3JpdGVfb3V0cHV0X2RpciUyMFRydWUlMjAlNUMlMEElMjAtLXNraXBfY2FjaGVfcHVzaCUyMFRydWUlMjAlNUMlMEElMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDElMjAlNUMlMEElMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDE2JTIwJTVDJTBBJTIwLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIwVHJ1ZSUyMCU1QyUwQSUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjA4JTIwJTVDJTBBJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMyUyMCU1QyUwQSUyMC0tbG9nZ2luZ19zdGVwcyUyMDEw",highlighted:`MALLOC_ARENA_MAX=64 XLA_USE_BF16=1 torchrun --nproc_per_node=32 finetune_llm.py \\
 --model_id meta-llama/Meta-Llama-3-8B \\
 --bf16 True \\
 --learning_rate 5e-5 \\
 --output_dir dolly_llama \\
 --overwrite_output_dir True \\
 --skip_cache_push True \\
 --per_device_train_batch_size 1 \\
 --gradient_accumulation_steps 16 \\
 --gradient_checkpointing True \\
 --tensor_parallel_size 8 \\
 --num_train_epochs 3 \\
 --logging_steps 10`,wrap:!1}}),Ge=new g({props:{title:"Consolidate the Checkpoint",local:"consolidate-the-checkpoint",headingTag:"h3"}}),ke=new j({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMGRvbGx5X2xsYW1hJTIwZG9sbHlfbGxhbWE=",highlighted:"optimum-cli neuron consolidate dolly_llama dolly_llama",wrap:!1}}),_e=new g({props:{title:"5. Evaluate and test fine-tuned Llama model",local:"5-evaluate-and-test-fine-tuned-llama-model",headingTag:"h2"}}),$e=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBY29tcGlsZXJfYXJncyUyMCUzRCUyMCU3QiUyMm51bV9jb3JlcyUyMiUzQSUyMDIlMkMlMjAlMjJhdXRvX2Nhc3RfdHlwZSUyMiUzQSUyMCdmcDE2JyU3RCUwQWlucHV0X3NoYXBlcyUyMCUzRCUyMCU3QiUyMmJhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTIwJTIyc2VxdWVuY2VfbGVuZ3RoJTIyJTNBJTIwMjA0OCU3RCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRvbGx5X2xsYW1hJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZG9sbHlfbGxhbWElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleHBvcnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipjb21waWxlcl9hcmdzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dF9zaGFwZXMp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

compiler_args = {<span class="hljs-string">&quot;num_cores&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&#x27;fp16&#x27;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;dolly_llama&quot;</span>)
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;dolly_llama&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)`,wrap:!1}}),Re=new j({props:{code:"JTIzJTIwQ09NTUVOVCUyMElOJTIwaWYlMjB5b3UlMjB3YW50JTIwdG8lMjBzYXZlJTIwdGhlJTIwY29tcGlsZWQlMjBtb2RlbCUwQSUyMyUyMG1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJjb21waWxlZF9kb2xseV9sbGFtYSUyMik=",highlighted:`<span class="hljs-comment"># COMMENT IN if you want to save the compiled model</span>
<span class="hljs-comment"># model.save_pretrained(&quot;compiled_dolly_llama&quot;)</span>`,wrap:!1}}),Ae=new j({props:{code:"ZGVmJTIwZm9ybWF0X2RvbGx5X2luZmVyZW5jZShzYW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW5zdHJ1Y3Rpb24lMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwSW5zdHJ1Y3Rpb24lNUNuJTdCc2FtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMGNvbnRleHQlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQ29udGV4dCU1Q24lN0JzYW1wbGUlNUInY29udGV4dCclNUQlN0QlMjIlMjBpZiUyMCUyMmNvbnRleHQlMjIlMjBpbiUyMHNhbXBsZSUyMGVsc2UlMjBOb25lJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBmJTIyJTIzJTIzJTIzJTIwQW5zd2VyJTVDbiUyMiUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMiU1Q24lNUNuJTIyLmpvaW4oJTVCaSUyMGZvciUyMGklMjBpbiUyMCU1Qmluc3RydWN0aW9uJTJDJTIwY29udGV4dCUyQyUyMHJlc3BvbnNlJTVEJTIwaWYlMjBpJTIwaXMlMjBub3QlMjBOb25lJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByb21wdCUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlKHNhbXBsZSklM0ElMEElMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjBmb3JtYXRfZG9sbHlfaW5mZXJlbmNlKHNhbXBsZSklMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3BfcCUzRDAuOSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIuZGVjb2RlKG91dHB1dHMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSU1Qmxlbihwcm9tcHQpJTNBJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly_inference</span>(<span class="hljs-params">sample</span>):
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{sample[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;context&quot;</span> <span class="hljs-keyword">in</span> sample <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n&quot;</span>
    prompt = <span class="hljs-string">&quot;\\n\\n&quot;</span>.join([i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> [instruction, context, response] <span class="hljs-keyword">if</span> i <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>])
    <span class="hljs-keyword">return</span> prompt


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">sample</span>):
    prompt = format_dolly_inference(sample)
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(
        **inputs,
        max_new_tokens=<span class="hljs-number">512</span>,
        do_sample=<span class="hljs-literal">True</span>,
        temperature=<span class="hljs-number">0.9</span>,
        top_k=<span class="hljs-number">50</span>,
        top_p=<span class="hljs-number">0.9</span>
    )
    <span class="hljs-keyword">return</span> tokenizer.decode(outputs[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-built_in">len</span>(prompt):]`,wrap:!1}}),Ye=new j({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJDYW4lMjB5b3UlMjB0ZWxsJTIwbWUlMjBzb21ldGhpbmclMjBhYm91dCUyMEFXUyUzRiUyMiUwQSU3RCUwQXJlcyUyMCUzRCUyMGdlbmVyYXRlKHByb21wdCklMEElMEFwcmludChyZXMp",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;Can you tell me something about AWS?&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),Ee=new j({props:{code:"cHJvbXB0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIyaW5zdHJ1Y3Rpb24lMjIlM0ElMjAlMjJIb3clMjBjYW4lMjBJJTIwdHJhaW4lMjBtb2RlbHMlMjBvbiUyMEFXUyUyMFRyYWluaXVtJTNGJTIyJTJDJTBBJTIwJTIwJTIyY29udGV4dCUyMiUzQSUyMCUyMiVGMCU5RiVBNCU5NyUyME9wdGltdW0lMjBOZXVyb24lMjBpcyUyMHRoZSUyMGludGVyZmFjZSUyMGJldHdlZW4lMjB0aGUlMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjBsaWJyYXJ5JTIwYW5kJTIwQVdTJTIwQWNjZWxlcmF0b3JzJTIwaW5jbHVkaW5nJTIwJTVCQVdTJTIwVHJhaW5pdW0lNUQoaHR0cHMlM0ElMkYlMkZhd3MuYW1hem9uLmNvbSUyRm1hY2hpbmUtbGVhcm5pbmclMkZ0cmFpbml1bSUyRiUzRm5jMSUzRGhfbHMpJTIwYW5kJTIwJTVCQVdTJTIwSW5mZXJlbnRpYSU1RChodHRwcyUzQSUyRiUyRmF3cy5hbWF6b24uY29tJTJGbWFjaGluZS1sZWFybmluZyUyRmluZmVyZW50aWElMkYlM0ZuYzElM0RoX2xzKS4lMjBJdCUyMHByb3ZpZGVzJTIwYSUyMHNldCUyMG9mJTIwdG9vbHMlMjBlbmFibGluZyUyMGVhc3klMjBtb2RlbCUyMGxvYWRpbmclMkMlMjB0cmFpbmluZyUyMGFuZCUyMGluZmVyZW5jZSUyMG9uJTIwc2luZ2xlLSUyMGFuZCUyMG11bHRpLUFjY2VsZXJhdG9yJTIwc2V0dGluZ3MlMjBmb3IlMjBkaWZmZXJlbnQlMjBkb3duc3RyZWFtJTIwdGFza3MuJTIyJTBBJTdEJTBBcmVzJTIwJTNEJTIwZ2VuZXJhdGUocHJvbXB0KSUwQSUwQXByaW50KHJlcyk=",highlighted:`prompt = {
  <span class="hljs-string">&quot;instruction&quot;</span>: <span class="hljs-string">&quot;How can I train models on AWS Trainium?&quot;</span>,
  <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;🤗 Optimum Neuron is the interface between the 🤗 Transformers library and AWS Accelerators including [AWS Trainium](https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls) and [AWS Inferentia](https://aws.amazon.com/machine-learning/inferentia/?nc1=h_ls). It provides a set of tools enabling easy model loading, training and inference on single- and multi-Accelerator settings for different downstream tasks.&quot;</span>
}
res = generate(prompt)

<span class="hljs-built_in">print</span>(res)`,wrap:!1}}),{c(){p=i("meta"),f=a(),y=i("p"),w=a(),M(b.$$.fragment),T=a(),U=i("p"),U.innerHTML=Le,J=a(),C=i("p"),C.innerHTML=fl,Pe=a(),v=i("p"),v.textContent=bl,De=a(),X=i("ol"),X.innerHTML=Cl,Ke=a(),M(B.$$.fragment),Oe=a(),M($.$$.fragment),et=a(),x=i("p"),x.textContent=Il,tt=a(),R=i("ol"),R.innerHTML=gl,lt=a(),M(V.$$.fragment),st=a(),W=i("ol"),W.innerHTML=Bl,at=a(),A=i("ul"),A.innerHTML=Wl,nt=a(),G=i("ol"),G.innerHTML=Gl,it=a(),M(H.$$.fragment),ot=a(),M(S.$$.fragment),rt=a(),Y=i("p"),Y.innerHTML=Zl,pt=a(),z=i("p"),z.textContent=kl,Mt=a(),M(N.$$.fragment),mt=a(),E=i("p"),E.innerHTML=_l,ct=a(),M(Q.$$.fragment),ut=a(),F=i("p"),F.innerHTML=vl,dt=a(),M(L.$$.fragment),ht=a(),q=i("p"),q.textContent=Xl,yt=a(),P=i("p"),P.innerHTML=$l,wt=a(),M(D.$$.fragment),Tt=a(),K=i("p"),K.textContent=xl,Ut=a(),O=i("ol"),O.innerHTML=Rl,Jt=a(),M(ee.$$.fragment),jt=a(),M(te.$$.fragment),ft=a(),le=i("p"),le.innerHTML=Vl,bt=a(),se=i("p"),se.innerHTML=Al,Ct=a(),ae=i("p"),ae.textContent=Hl,It=a(),ne=i("ol"),ne.innerHTML=Sl,gt=a(),M(Z.$$.fragment),Bt=a(),ie=i("p"),ie.textContent=Yl,Wt=a(),M(oe.$$.fragment),Gt=a(),re=i("p"),re.textContent=zl,Zt=a(),pe=i("ul"),pe.innerHTML=Nl,kt=a(),M(Me.$$.fragment),_t=a(),me=i("p"),me.innerHTML=El,vt=a(),M(k.$$.fragment),Xt=a(),ce=i("p"),ce.innerHTML=Ql,$t=a(),M(ue.$$.fragment),xt=a(),de=i("p"),de.textContent=Fl,Rt=a(),he=i("p"),he.innerHTML=Ll,Vt=a(),ye=i("p"),ye.innerHTML=ql,At=a(),we=i("p"),we.innerHTML=Pl,Ht=a(),M(Te.$$.fragment),St=a(),M(_.$$.fragment),Yt=a(),Ue=i("p"),Ue.innerHTML=Dl,zt=a(),M(Je.$$.fragment),Nt=a(),M(je.$$.fragment),Et=a(),fe=i("p"),fe.innerHTML=Kl,Qt=a(),be=i("p"),be.innerHTML=Ol,Ft=a(),Ce=i("p"),Ce.innerHTML=es,Lt=a(),Ie=i("p"),Ie.textContent=ts,qt=a(),M(ge.$$.fragment),Pt=a(),Be=i("p"),Be.textContent=ls,Dt=a(),We=i("p"),We.textContent=ss,Kt=a(),M(Ge.$$.fragment),Ot=a(),Ze=i("p"),Ze.innerHTML=as,el=a(),M(ke.$$.fragment),tl=a(),M(_e.$$.fragment),ll=a(),ve=i("p"),ve.textContent=ns,sl=a(),Xe=i("p"),Xe.innerHTML=is,al=a(),M($e.$$.fragment),nl=a(),xe=i("p"),xe.innerHTML=os,il=a(),M(Re.$$.fragment),ol=a(),Ve=i("p"),Ve.innerHTML=rs,rl=a(),M(Ae.$$.fragment),pl=a(),He=i("p"),He.textContent=ps,Ml=a(),Se=i("p"),Se.innerHTML=Ms,ml=a(),M(Ye.$$.fragment),cl=a(),ze=i("blockquote"),ze.innerHTML=ms,ul=a(),Ne=i("p"),Ne.textContent=cs,dl=a(),M(Ee.$$.fragment),hl=a(),Qe=i("blockquote"),Qe.innerHTML=us,yl=a(),Fe=i("p"),Fe.textContent=ds,wl=a(),qe=i("p"),this.h()},l(e){const t=Cs("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),f=n(e),y=o(e,"P",{}),Us(y).forEach(l),w=n(e),m(b.$$.fragment,e),T=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1dtzs79"&&(U.innerHTML=Le),J=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1w2bqvx"&&(C.innerHTML=fl),Pe=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1hahfn0"&&(v.textContent=bl),De=n(e),X=o(e,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-1yf8yg7"&&(X.innerHTML=Cl),Ke=n(e),m(B.$$.fragment,e),Oe=n(e),m($.$$.fragment,e),et=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-w52dpm"&&(x.textContent=Il),tt=n(e),R=o(e,"OL",{"data-svelte-h":!0}),r(R)!=="svelte-15ega2l"&&(R.innerHTML=gl),lt=n(e),m(V.$$.fragment,e),st=n(e),W=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(W)!=="svelte-ksb30n"&&(W.innerHTML=Bl),at=n(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-1qiwkz0"&&(A.innerHTML=Wl),nt=n(e),G=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(G)!=="svelte-ch5yfe"&&(G.innerHTML=Gl),it=n(e),m(H.$$.fragment,e),ot=n(e),m(S.$$.fragment,e),rt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-s6kf7j"&&(Y.innerHTML=Zl),pt=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-11lpom8"&&(z.textContent=kl),Mt=n(e),m(N.$$.fragment,e),mt=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1snwaj0"&&(E.innerHTML=_l),ct=n(e),m(Q.$$.fragment,e),ut=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-voh434"&&(F.innerHTML=vl),dt=n(e),m(L.$$.fragment,e),ht=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1qw7fs2"&&(q.textContent=Xl),yt=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1tlab3t"&&(P.innerHTML=$l),wt=n(e),m(D.$$.fragment,e),Tt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-vnokz2"&&(K.textContent=xl),Ut=n(e),O=o(e,"OL",{"data-svelte-h":!0}),r(O)!=="svelte-v6jbub"&&(O.innerHTML=Rl),Jt=n(e),m(ee.$$.fragment,e),jt=n(e),m(te.$$.fragment,e),ft=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-14g3or9"&&(le.innerHTML=Vl),bt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-b4fdk9"&&(se.innerHTML=Al),Ct=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-lw48ct"&&(ae.textContent=Hl),It=n(e),ne=o(e,"OL",{"data-svelte-h":!0}),r(ne)!=="svelte-xm927i"&&(ne.innerHTML=Sl),gt=n(e),m(Z.$$.fragment,e),Bt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1lnowtd"&&(ie.textContent=Yl),Wt=n(e),m(oe.$$.fragment,e),Gt=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-t16ze3"&&(re.textContent=zl),Zt=n(e),pe=o(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-1ou6zrr"&&(pe.innerHTML=Nl),kt=n(e),m(Me.$$.fragment,e),_t=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-618yad"&&(me.innerHTML=El),vt=n(e),m(k.$$.fragment,e),Xt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-bne5rp"&&(ce.innerHTML=Ql),$t=n(e),m(ue.$$.fragment,e),xt=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1u0hmu2"&&(de.textContent=Fl),Rt=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1gsk3gh"&&(he.innerHTML=Ll),Vt=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-jypm7b"&&(ye.innerHTML=ql),At=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-t9z3bd"&&(we.innerHTML=Pl),Ht=n(e),m(Te.$$.fragment,e),St=n(e),m(_.$$.fragment,e),Yt=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-136s4kc"&&(Ue.innerHTML=Dl),zt=n(e),m(Je.$$.fragment,e),Nt=n(e),m(je.$$.fragment,e),Et=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1yiqpri"&&(fe.innerHTML=Kl),Qt=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1anw499"&&(be.innerHTML=Ol),Ft=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-ctfnvw"&&(Ce.innerHTML=es),Lt=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-17lv8z9"&&(Ie.textContent=ts),qt=n(e),m(ge.$$.fragment,e),Pt=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1v2czzn"&&(Be.textContent=ls),Dt=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-12iaeqv"&&(We.textContent=ss),Kt=n(e),m(Ge.$$.fragment,e),Ot=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-66io75"&&(Ze.innerHTML=as),el=n(e),m(ke.$$.fragment,e),tl=n(e),m(_e.$$.fragment,e),ll=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-emhotm"&&(ve.textContent=ns),sl=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1pgrxrm"&&(Xe.innerHTML=is),al=n(e),m($e.$$.fragment,e),nl=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1sinvz7"&&(xe.innerHTML=os),il=n(e),m(Re.$$.fragment,e),ol=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-jx2yqv"&&(Ve.innerHTML=rs),rl=n(e),m(Ae.$$.fragment,e),pl=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1ytr5g6"&&(He.textContent=ps),Ml=n(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1j8w2o0"&&(Se.innerHTML=Ms),ml=n(e),m(Ye.$$.fragment,e),cl=n(e),ze=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(ze)!=="svelte-6l4k0q"&&(ze.innerHTML=ms),ul=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-ovzcvi"&&(Ne.textContent=cs),dl=n(e),m(Ee.$$.fragment,e),hl=n(e),Qe=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Qe)!=="svelte-15xrtpx"&&(Qe.innerHTML=us),yl=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-q9f4rf"&&(Fe.textContent=ds),wl=n(e),qe=o(e,"P",{}),Us(qe).forEach(l),this.h()},h(){Ul(p,"name","hf:doc:metadata"),Ul(p,"content",ks),Ul(W,"start","3"),Ul(G,"start","4")},m(e,t){Is(document.head,p),s(e,f,t),s(e,y,t),s(e,w,t),c(b,e,t),s(e,T,t),s(e,U,t),s(e,J,t),s(e,C,t),s(e,Pe,t),s(e,v,t),s(e,De,t),s(e,X,t),s(e,Ke,t),c(B,e,t),s(e,Oe,t),c($,e,t),s(e,et,t),s(e,x,t),s(e,tt,t),s(e,R,t),s(e,lt,t),c(V,e,t),s(e,st,t),s(e,W,t),s(e,at,t),s(e,A,t),s(e,nt,t),s(e,G,t),s(e,it,t),c(H,e,t),s(e,ot,t),c(S,e,t),s(e,rt,t),s(e,Y,t),s(e,pt,t),s(e,z,t),s(e,Mt,t),c(N,e,t),s(e,mt,t),s(e,E,t),s(e,ct,t),c(Q,e,t),s(e,ut,t),s(e,F,t),s(e,dt,t),c(L,e,t),s(e,ht,t),s(e,q,t),s(e,yt,t),s(e,P,t),s(e,wt,t),c(D,e,t),s(e,Tt,t),s(e,K,t),s(e,Ut,t),s(e,O,t),s(e,Jt,t),c(ee,e,t),s(e,jt,t),c(te,e,t),s(e,ft,t),s(e,le,t),s(e,bt,t),s(e,se,t),s(e,Ct,t),s(e,ae,t),s(e,It,t),s(e,ne,t),s(e,gt,t),c(Z,e,t),s(e,Bt,t),s(e,ie,t),s(e,Wt,t),c(oe,e,t),s(e,Gt,t),s(e,re,t),s(e,Zt,t),s(e,pe,t),s(e,kt,t),c(Me,e,t),s(e,_t,t),s(e,me,t),s(e,vt,t),c(k,e,t),s(e,Xt,t),s(e,ce,t),s(e,$t,t),c(ue,e,t),s(e,xt,t),s(e,de,t),s(e,Rt,t),s(e,he,t),s(e,Vt,t),s(e,ye,t),s(e,At,t),s(e,we,t),s(e,Ht,t),c(Te,e,t),s(e,St,t),c(_,e,t),s(e,Yt,t),s(e,Ue,t),s(e,zt,t),c(Je,e,t),s(e,Nt,t),c(je,e,t),s(e,Et,t),s(e,fe,t),s(e,Qt,t),s(e,be,t),s(e,Ft,t),s(e,Ce,t),s(e,Lt,t),s(e,Ie,t),s(e,qt,t),c(ge,e,t),s(e,Pt,t),s(e,Be,t),s(e,Dt,t),s(e,We,t),s(e,Kt,t),c(Ge,e,t),s(e,Ot,t),s(e,Ze,t),s(e,el,t),c(ke,e,t),s(e,tl,t),c(_e,e,t),s(e,ll,t),s(e,ve,t),s(e,sl,t),s(e,Xe,t),s(e,al,t),c($e,e,t),s(e,nl,t),s(e,xe,t),s(e,il,t),c(Re,e,t),s(e,ol,t),s(e,Ve,t),s(e,rl,t),c(Ae,e,t),s(e,pl,t),s(e,He,t),s(e,Ml,t),s(e,Se,t),s(e,ml,t),c(Ye,e,t),s(e,cl,t),s(e,ze,t),s(e,ul,t),s(e,Ne,t),s(e,dl,t),c(Ee,e,t),s(e,hl,t),s(e,Qe,t),s(e,yl,t),s(e,Fe,t),s(e,wl,t),s(e,qe,t),Tl=!0},p(e,[t]){const hs={};t&2&&(hs.$$scope={dirty:t,ctx:e}),B.$set(hs);const ys={};t&2&&(ys.$$scope={dirty:t,ctx:e}),Z.$set(ys);const ws={};t&2&&(ws.$$scope={dirty:t,ctx:e}),k.$set(ws);const Ts={};t&2&&(Ts.$$scope={dirty:t,ctx:e}),_.$set(Ts)},i(e){Tl||(u(b.$$.fragment,e),u(B.$$.fragment,e),u($.$$.fragment,e),u(V.$$.fragment,e),u(H.$$.fragment,e),u(S.$$.fragment,e),u(N.$$.fragment,e),u(Q.$$.fragment,e),u(L.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(Z.$$.fragment,e),u(oe.$$.fragment,e),u(Me.$$.fragment,e),u(k.$$.fragment,e),u(ue.$$.fragment,e),u(Te.$$.fragment,e),u(_.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(ge.$$.fragment,e),u(Ge.$$.fragment,e),u(ke.$$.fragment,e),u(_e.$$.fragment,e),u($e.$$.fragment,e),u(Re.$$.fragment,e),u(Ae.$$.fragment,e),u(Ye.$$.fragment,e),u(Ee.$$.fragment,e),Tl=!0)},o(e){d(b.$$.fragment,e),d(B.$$.fragment,e),d($.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(S.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(Z.$$.fragment,e),d(oe.$$.fragment,e),d(Me.$$.fragment,e),d(k.$$.fragment,e),d(ue.$$.fragment,e),d(Te.$$.fragment,e),d(_.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d(ge.$$.fragment,e),d(Ge.$$.fragment,e),d(ke.$$.fragment,e),d(_e.$$.fragment,e),d($e.$$.fragment,e),d(Re.$$.fragment,e),d(Ae.$$.fragment,e),d(Ye.$$.fragment,e),d(Ee.$$.fragment,e),Tl=!1},d(e){e&&(l(f),l(y),l(w),l(T),l(U),l(J),l(C),l(Pe),l(v),l(De),l(X),l(Ke),l(Oe),l(et),l(x),l(tt),l(R),l(lt),l(st),l(W),l(at),l(A),l(nt),l(G),l(it),l(ot),l(rt),l(Y),l(pt),l(z),l(Mt),l(mt),l(E),l(ct),l(ut),l(F),l(dt),l(ht),l(q),l(yt),l(P),l(wt),l(Tt),l(K),l(Ut),l(O),l(Jt),l(jt),l(ft),l(le),l(bt),l(se),l(Ct),l(ae),l(It),l(ne),l(gt),l(Bt),l(ie),l(Wt),l(Gt),l(re),l(Zt),l(pe),l(kt),l(_t),l(me),l(vt),l(Xt),l(ce),l($t),l(xt),l(de),l(Rt),l(he),l(Vt),l(ye),l(At),l(we),l(Ht),l(St),l(Yt),l(Ue),l(zt),l(Nt),l(Et),l(fe),l(Qt),l(be),l(Ft),l(Ce),l(Lt),l(Ie),l(qt),l(Pt),l(Be),l(Dt),l(We),l(Kt),l(Ot),l(Ze),l(el),l(tl),l(ll),l(ve),l(sl),l(Xe),l(al),l(nl),l(xe),l(il),l(ol),l(Ve),l(rl),l(pl),l(He),l(Ml),l(Se),l(ml),l(cl),l(ze),l(ul),l(Ne),l(dl),l(hl),l(Qe),l(yl),l(Fe),l(wl),l(qe)),l(p),h(b,e),h(B,e),h($,e),h(V,e),h(H,e),h(S,e),h(N,e),h(Q,e),h(L,e),h(D,e),h(ee,e),h(te,e),h(Z,e),h(oe,e),h(Me,e),h(k,e),h(ue,e),h(Te,e),h(_,e),h(Je,e),h(je,e),h(ge,e),h(Ge,e),h(ke,e),h(_e,e),h($e,e),h(Re,e),h(Ae,e),h(Ye,e),h(Ee,e)}}}const ks='{"title":"Fine-tune and Test Llama-3 8B on AWS Trainium","local":"fine-tune-and-test-llama-3-8b-on-aws-trainium","sections":[{"title":"1. Setup AWS Environment","local":"1-setup-aws-environment","sections":[],"depth":2},{"title":"2. Load and prepare the dataset","local":"2-load-and-prepare-the-dataset","sections":[],"depth":2},{"title":"3. Fine-tune Llama on AWS Trainium using the NeuronTrainer","local":"3-fine-tune-llama-on-aws-trainium-using-the-neurontrainer","sections":[],"depth":2},{"title":"4. Launch Training","local":"4-launch-training","sections":[{"title":"Precompilation","local":"precompilation","sections":[],"depth":3},{"title":"Actual Training","local":"actual-training","sections":[],"depth":3},{"title":"Consolidate the Checkpoint","local":"consolidate-the-checkpoint","sections":[],"depth":3}],"depth":2},{"title":"5. Evaluate and test fine-tuned Llama model","local":"5-evaluate-and-test-fine-tuned-llama-model","sections":[],"depth":2}],"depth":1}';function _s(I){return js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends fs{constructor(p){super(),bs(this,p,_s,Zs,Js,{})}}export{Vs as component};
