# Optimization

## Transformation[[optimum.fx.optimization.Transformation]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.fx.optimization.Transformation</name><anchor>optimum.fx.optimization.Transformation</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L105</source><parameters>[]</parameters><paramsdesc>- **preserves_computation** (`bool`, defaults to `False`) --
  Whether the transformation preserves the graph computation or not. If `True`, the original and the
  transformed graph should produce the same outputs.</paramsdesc><paramgroups>0</paramgroups></docstring>

A torch.fx graph transformation.

It  must implement the [transform()](/docs/optimum/main/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation.transform) method, and be used as a
callable.






<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__call__</name><anchor>optimum.fx.optimization.Transformation.__call__</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L128</source><parameters>[{"name": "graph_module", "val": ": GraphModule"}, {"name": "lint_and_recompile", "val": ": bool = True"}]</parameters><paramsdesc>- **graph_module** (`torch.fx.GraphModule`) --
  The module to transform.
- **lint_and_recompile** (`bool`, defaults to `True`) --
  Whether the transformed module should be linted and recompiled.
  This can be set to `False` when chaining transformations together to perform this operation only once.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.fx.GraphModule`</rettype><retdesc>The transformed module.</retdesc></docstring>








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>get_transformed_nodes</name><anchor>optimum.fx.optimization.Transformation.get_transformed_nodes</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L181</source><parameters>[{"name": "graph_module", "val": ": GraphModule"}]</parameters><paramsdesc>- **graph_module** (`torch.fx.GraphModule`) --
  The graph_module to get the nodes from.</paramsdesc><paramgroups>0</paramgroups><rettype>`List[torch.fx.Node]`</rettype><retdesc>Gives the list of nodes that were transformed by the transformation.</retdesc></docstring>








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>mark_as_transformed</name><anchor>optimum.fx.optimization.Transformation.mark_as_transformed</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L157</source><parameters>[{"name": "node", "val": ": Node"}]</parameters><paramsdesc>- **node** (`torch.fx.Node`) --
  The node to mark as transformed.</paramsdesc><paramgroups>0</paramgroups></docstring>

Marks a node as transformed by this transformation.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>transform</name><anchor>optimum.fx.optimization.Transformation.transform</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L115</source><parameters>[{"name": "graph_module", "val": ": GraphModule"}]</parameters><paramsdesc>- **graph_module** (`torch.fx.GraphModule`) --
  The module to transform.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.fx.GraphModule`</rettype><retdesc>The transformed module.</retdesc></docstring>








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>transformed</name><anchor>optimum.fx.optimization.Transformation.transformed</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L169</source><parameters>[{"name": "node", "val": ": Node"}]</parameters><paramsdesc>- **node** (`torch.fx.Node`) --
  The node to check.</paramsdesc><paramgroups>0</paramgroups><rettype>`bool`</rettype><retdesc>Specifies whether the node was transformed by this transformation or not.</retdesc></docstring>








</div></div>

## Reversible transformation[[optimum.fx.optimization.ReversibleTransformation]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.fx.optimization.ReversibleTransformation</name><anchor>optimum.fx.optimization.ReversibleTransformation</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L196</source><parameters>[]</parameters><paramsdesc>- **preserves_computation** (`bool`, defaults to `False`) --
  Whether the transformation preserves the graph computation or not. If `True`, the original and the
  transformed graph should produce the same outputs.</paramsdesc><paramgroups>0</paramgroups></docstring>

A torch.fx graph transformation that is reversible.

It must implement the [transform()](/docs/optimum/main/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation.transform) and
[reverse()](/docs/optimum/main/en/torch_fx/package_reference/optimization#optimum.fx.optimization.ReversibleTransformation.reverse) methods, and be used as a callable.






<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>__call__</name><anchor>optimum.fx.optimization.ReversibleTransformation.__call__</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L217</source><parameters>[{"name": "graph_module", "val": ": GraphModule"}, {"name": "lint_and_recompile", "val": ": bool = True"}, {"name": "reverse", "val": ": bool = False"}]</parameters><paramsdesc>- **graph_module** (`torch.fx.GraphModule`) --
  The module to transform.
- **lint_and_recompile** (`bool`, defaults to `True`) --
  Whether the transformed module should be linted and recompiled.
  This can be set to `False` when chaining transformations together to perform this operation only once.
- **reverse** (`bool`, defaults to `False`) --
  If `True`, the reverse transformation is performed.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.fx.GraphModule`</rettype><retdesc>The transformed module.</retdesc></docstring>








</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>mark_as_restored</name><anchor>optimum.fx.optimization.ReversibleTransformation.mark_as_restored</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L242</source><parameters>[{"name": "node", "val": ": Node"}]</parameters><paramsdesc>- **node** (`torch.fx.Node`) --
  The node to mark as restored.</paramsdesc><paramgroups>0</paramgroups></docstring>

Marks a node as restored back to its original state.




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>reverse</name><anchor>optimum.fx.optimization.ReversibleTransformation.reverse</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L204</source><parameters>[{"name": "graph_module", "val": ": GraphModule"}]</parameters><paramsdesc>- **graph_module** (`torch.fx.GraphModule`) --
  The module to transform.</paramsdesc><paramgroups>0</paramgroups><rettype>`torch.fx.GraphModule`</rettype><retdesc>The reverse transformed module.</retdesc></docstring>








</div></div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>optimum.fx.optimization.compose</name><anchor>optimum.fx.optimization.compose</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L741</source><parameters>[{"name": "*args", "val": ": Transformation"}, {"name": "inplace", "val": ": bool = True"}]</parameters><paramsdesc>- **args** ([Transformation](/docs/optimum/main/en/torch_fx/package_reference/optimization#optimum.fx.optimization.Transformation)) --
  The transformations to compose together.
- **inplace** (`bool`, defaults to `True`) --
  Whether the resulting transformation should be inplace, or create a new graph module.</paramsdesc><paramgroups>0</paramgroups><retdesc>The composition transformation object.</retdesc></docstring>

Composes a list of transformations together.





<ExampleCodeBlock anchor="optimum.fx.optimization.compose.example">

Example:

```python
>>> from transformers import BertModel
>>> from transformers.utils.fx import symbolic_trace
>>> from optimum.fx.optimization import ChangeTrueDivToMulByInverse, MergeLinears, compose

>>> model = BertModel.from_pretrained("bert-base-uncased")
>>> traced = symbolic_trace(
...     model,
...     input_names=["input_ids", "attention_mask", "token_type_ids"],
... )
>>> composition = compose(ChangeTrueDivToMulByInverse(), MergeLinears())
>>> transformed_model = composition(traced)
```

</ExampleCodeBlock>


</div>

### Transformations[[optimum.fx.optimization.MergeLinears]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.fx.optimization.MergeLinears</name><anchor>optimum.fx.optimization.MergeLinears</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L257</source><parameters>[]</parameters><paramsdesc>- **preserves_computation** (`bool`, defaults to `False`) --
  Whether the transformation preserves the graph computation or not. If `True`, the original and the
  transformed graph should produce the same outputs.</paramsdesc><paramgroups>0</paramgroups></docstring>

Transformation that merges linear layers that take the same input into one big linear layer.




<ExampleCodeBlock anchor="optimum.fx.optimization.MergeLinears.example">

Example:

```python
>>> from transformers import BertModel
>>> from transformers.utils.fx import symbolic_trace
>>> from optimum.fx.optimization import MergeLinears

>>> model = BertModel.from_pretrained("bert-base-uncased")
>>> traced = symbolic_trace(
...     model,
...     input_names=["input_ids", "attention_mask", "token_type_ids"],
... )
>>> transformation = MergeLinears()
>>> transformed_model = transformation(traced)
>>> restored_model = transformation(transformed_model, reverse=True)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.fx.optimization.FuseBiasInLinear</name><anchor>optimum.fx.optimization.FuseBiasInLinear</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L413</source><parameters>[]</parameters><paramsdesc>- **preserves_computation** (`bool`, defaults to `False`) --
  Whether the transformation preserves the graph computation or not. If `True`, the original and the
  transformed graph should produce the same outputs.</paramsdesc><paramgroups>0</paramgroups></docstring>

Transformation that fuses the bias to the weight in torch.nn.Linear.




<ExampleCodeBlock anchor="optimum.fx.optimization.FuseBiasInLinear.example">

Example:

```python
>>> from transformers import BertModel
>>> from transformers.utils.fx import symbolic_trace
>>> from optimum.fx.optimization import FuseBiasInLinear

>>> model = BertModel.from_pretrained("bert-base-uncased")
>>> traced = symbolic_trace(
...     model,
...     input_names=["input_ids", "attention_mask", "token_type_ids"],
... )
>>> transformation = FuseBiasInLinear()
>>> transformed_model = transformation(traced)
>>> restored_model = transformation(transformed_model, reverse=True)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.fx.optimization.ChangeTrueDivToMulByInverse</name><anchor>optimum.fx.optimization.ChangeTrueDivToMulByInverse</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L467</source><parameters>[]</parameters><paramsdesc>- **preserves_computation** (`bool`, defaults to `False`) --
  Whether the transformation preserves the graph computation or not. If `True`, the original and the
  transformed graph should produce the same outputs.</paramsdesc><paramgroups>0</paramgroups></docstring>

Transformation that changes truediv nodes to multiplication by the inverse nodes when the denominator is static.
For example, that is sometimes the case for the scaling factor in attention layers.




<ExampleCodeBlock anchor="optimum.fx.optimization.ChangeTrueDivToMulByInverse.example">

Example:

```python
>>> from transformers import BertModel
>>> from transformers.utils.fx import symbolic_trace
>>> from optimum.fx.optimization import ChangeTrueDivToMulByInverse

>>> model = BertModel.from_pretrained("bert-base-uncased")
>>> traced = symbolic_trace(
...     model,
...     input_names=["input_ids", "attention_mask", "token_type_ids"],
... )
>>> transformation = ChangeTrueDivToMulByInverse()
>>> transformed_model = transformation(traced)
>>> restored_model = transformation(transformed_model, reverse=True)
```

</ExampleCodeBlock>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.fx.optimization.FuseBatchNorm2dInConv2d</name><anchor>optimum.fx.optimization.FuseBatchNorm2dInConv2d</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L498</source><parameters>[]</parameters><paramsdesc>- **preserves_computation** (`bool`, defaults to `False`) --
  Whether the transformation preserves the graph computation or not. If `True`, the original and the
  transformed graph should produce the same outputs.</paramsdesc><paramgroups>0</paramgroups></docstring>

Transformation that fuses `nn.BatchNorm2d` following `nn.Conv2d` into a single `nn.Conv2d`.
The fusion will be done only if the convolution has the batch normalization as sole following node.

For example, fusion will not be done in the case
<ExampleCodeBlock anchor="optimum.fx.optimization.FuseBatchNorm2dInConv2d.example">

```
     Conv2d
     /   \
    /     \
ReLU   BatchNorm2d
```

</ExampleCodeBlock>

<ExampleCodeBlock anchor="optimum.fx.optimization.FuseBatchNorm2dInConv2d.example-2">

Example:
```python
>>> from transformers.utils.fx import symbolic_trace
>>> from transformers import AutoModelForImageClassification

>>> from optimum.fx.optimization import FuseBatchNorm2dInConv2d

>>> model = AutoModelForImageClassification.from_pretrained("microsoft/resnet-50")
>>> model.eval()
>>> traced_model = symbolic_trace(
...     model,
...     input_names=["pixel_values"],
...     disable_check=True
... )

>>> transformation = FuseBatchNorm2dInConv2d()
>>> transformed_model = transformation(traced_model)
```

</ExampleCodeBlock>




</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.fx.optimization.FuseBatchNorm1dInLinear</name><anchor>optimum.fx.optimization.FuseBatchNorm1dInLinear</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/fx/optimization/transformations.py#L581</source><parameters>[]</parameters><paramsdesc>- **preserves_computation** (`bool`, defaults to `False`) --
  Whether the transformation preserves the graph computation or not. If `True`, the original and the
  transformed graph should produce the same outputs.</paramsdesc><paramgroups>0</paramgroups></docstring>

Transformation that fuses `nn.BatchNorm1d` following or preceding `nn.Linear` into a single `nn.Linear`.
The fusion will be done only if the linear layer has the batch normalization as sole following node, or the batch normalization
has the linear layer as sole following node.

For example, fusion will not be done in the case
<ExampleCodeBlock anchor="optimum.fx.optimization.FuseBatchNorm1dInLinear.example">

```
     Linear
     /   \
    /     \
ReLU   BatchNorm1d
```

</ExampleCodeBlock>

<ExampleCodeBlock anchor="optimum.fx.optimization.FuseBatchNorm1dInLinear.example-2">

Example:
```python
>>> from transformers.utils.fx import symbolic_trace
>>> from transformers import AutoModel

>>> from optimum.fx.optimization import FuseBatchNorm1dInLinear

>>> model = AutoModel.from_pretrained("nvidia/groupvit-gcc-yfcc")
>>> model.eval()
>>> traced_model = symbolic_trace(
...     model,
...     input_names=["input_ids", "attention_mask", "pixel_values"],
...     disable_check=True
... )

>>> transformation = FuseBatchNorm1dInLinear()
>>> transformed_model = transformation(traced_model)
```

</ExampleCodeBlock>




</div>