import{s as ii,f as ri,n as pi,o as di}from"../chunks/scheduler.85c25b89.js";import{S as ci,i as mi,g as o,s as l,r as p,A as ui,h as i,f as a,c as s,j as ua,u as d,x as r,k as J,l as oi,y,a as n,v as c,d as m,t as u,w as M}from"../chunks/index.c142fe32.js";import{D as gs}from"../chunks/Docstring.d3e0bcd1.js";import{C as h}from"../chunks/CodeBlock.a5e95a57.js";import{H as f,E as Mi}from"../chunks/EditOnGithub.a592e7aa.js";function hi(vs){let j,_a,ja,ba,I,va,k,Cs="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",Ca,F,Is=`Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.
Experimental support for Vision Language Models is also included in the example <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/vsft_llava.py" rel="nofollow"><code>examples/scripts/vsft_llava.py</code></a>.`,Ia,x,ka,$,ks=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,Fa,Z,xa,G,Fs="Make sure to pass the correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",$a,B,xs="You can also construct a model outside of the trainer and pass it as follows:",Za,N,Ga,q,$s='The above snippets will use the default training arguments from the <a href="/docs/trl/main/en/sft_trainer#trl.SFTConfig">SFTConfig</a> class. If you want to modify the defaults pass in your modification to the <code>SFTConfig</code> constructor and pass them to the trainer via the <code>args</code> argument.',Ba,A,Na,R,qa,E,Zs=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,Aa,X,Ra,Q,Gs="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",Ea,W,Xa,S,Bs="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",Qa,z,Wa,V,Ns="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending on whether they have context or not. For example:",Sa,H,za,L,qs="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",Va,Y,As="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",Ha,D,Rs="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",La,O,Ya,P,Es="To solve this, you can tokenize the <code>response_template</code> with the same context as in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",Da,K,Oa,tt,Pa,et,Xs=`Adding special tokens to a language model is crucial for training chat models. These tokens are added between the different roles in a conversation, such as the user, assistant, and system and help the model recognize the structure and flow of a conversation. This setup is essential for enabling the model to generate coherent and contextually appropriate responses in a chat environment.
The <code>setup_chat_format()</code> function in <code>trl</code> easily sets up a model and tokenizer for conversational AI tasks. This function:`,Ka,at,Qs='<li>Adds special tokens to the tokenizer, e.g. <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>, to indicate the start and end of a conversation.</li> <li>Resizes the model’s embedding layer to accommodate the new tokens.</li> <li>Sets the <code>chat_template</code> of the tokenizer, which is used to format the input data into a chat-like format. The default is <code>chatml</code> from OpenAI.</li> <li><em>optionally</em> you can pass <code>resize_to_multiple_of</code> to resize the embedding layer to a multiple of the <code>resize_to_multiple_of</code> argument, e.g. 64. If you want to see more formats being supported in the future, please open a GitHub issue on <a href="https://github.com/huggingface/trl" rel="nofollow">trl</a></li>',tn,nt,en,lt,Ws="With our model and tokenizer set up, we can now fine-tune our model on a conversational dataset. Below is an example of how a dataset can be formatted for fine-tuning.",an,st,nn,ot,Ss='The <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports popular dataset formats. This allows you to pass the dataset to the trainer without any pre-processing directly. The following formats are supported:',ln,it,zs="<li>conversational format</li>",sn,rt,on,pt,Vs="<li>instruction format</li>",rn,dt,pn,ct,Hs='If your dataset uses one of the above formats, you can directly pass it to the trainer without pre-processing. The <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> will then format the dataset for you using the defined format from the model’s tokenizer with the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#templates-for-chat-models" rel="nofollow">apply_chat_template</a> method.',dn,mt,cn,ut,Ls="If the dataset is not in one of those format you can either preprocess the dataset to match the formatting or pass a formatting function to the SFTTrainer to do it for you. Let’s have a look.",mn,Mt,un,ht,Ys=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,Mn,ft,hn,yt,Ds="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",fn,Tt,yn,gt,Os='To properly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example of how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',Tn,Jt,gn,wt,Ps='<a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/main/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor.',Jn,jt,wn,Ut,Ks=`Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.
If you don’t want to pack your <code>eval_dataset</code>, you can pass <code>eval_packing=False</code> to the <code>SFTConfig</code> init method.`,jn,_t,Un,bt,to="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",_n,vt,bn,Ct,eo='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/main/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor. Please refer to that class’ signature for more information.',vn,It,Cn,kt,ao='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/main/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. For example, if you want to load a model in a different precision, analogous to',In,Ft,kn,xt,no="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",Fn,$t,xn,Zt,lo="We also support tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",$n,Gt,Zn,Bt,so="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",Gn,Nt,Bn,qt,oo="For that, you need to first load your 8 bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",Nn,At,qn,Rt,An,Et,io=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,Rn,Xt,En,Qt,ro=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Xn,Wt,Qn,St,po="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",Wn,zt,Sn,Vt,co="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",zn,Ht,Vn,Lt,mo="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",Hn,Yt,uo="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",Ln,Dt,Mo="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",Yn,Ot,Dn,Pt,ho="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",On,Kt,Pn,te,fo="And add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when calling <code>from_pretrained</code>:",Kn,ee,tl,ae,yo=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,el,ne,To="In contrast to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",al,le,nl,se,go="We included a utility function to create your model.",ll,T,oe,Js,Ma,Jo="Configuration class for the models.",ws,ha,wo=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,sl,ie,ol,re,il,pe,jo='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://huggingface.co/papers/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',rl,de,Uo="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",pl,b,_o='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',dl,ce,bo="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTConfig</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",cl,me,ml,ue,vo='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',ul,v,Co='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',Ml,Me,Io='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',hl,he,fl,fe,ko='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',yl,ye,Fo="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",Tl,Te,xo='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',gl,ge,Jl,Je,$o='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',wl,we,jl,je,Zo='<a href="https://github.com/linkedin/Liger-Kernel" rel="nofollow">Liger Kernel</a> is a collection of Triton kernels designed specifically for LLM training. It can effectively increase multi-GPU training throughput by 20% and reduces memory usage by 60%. That way, we can <strong>4x</strong> our context length, as described in the benchmark below. They have implemented Hugging Face Compatible <code>RMSNorm</code>, <code>RoPE</code>, <code>SwiGLU</code>, <code>CrossEntropy</code>, <code>FusedLinearCrossEntropy</code>, and more to come. The kernel works out of the box with <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Flash Attention</a>, <a href="https://pytorch.org/tutorials/intermediate/FSDP_tutorial.html" rel="nofollow">PyTorch FSDP</a>, and <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">Microsoft DeepSpeed</a>.',Ul,Ue,Go="With great memory reduction, you can potentially turn off cpu_offloading or gradient checkpointing to further boost the performance.",_l,_e,Bo='<thead><tr><th>Speed Up</th> <th>Memory Reduction</th></tr></thead> <tbody><tr><td><img src="https://raw.githubusercontent.com/linkedin/Liger-Kernel/main/docs/images/e2e-tps.png" alt="Speed up"/></td> <td><img src="https://raw.githubusercontent.com/linkedin/Liger-Kernel/main/docs/images/e2e-memory.png" alt="Memory"/></td></tr></tbody>',bl,be,No="<li>To use Liger-Kernel in <code>SFTTrainer</code>, first install by</li>",vl,ve,Cl,C,qo='<li>Once installed, set <code>use_liger</code> in <a href="https://github.com/huggingface/trl/blob/850ddcf598984013007d384c6b3e311def2a616e/trl/trainer/sft_config.py#L69" rel="nofollow">SFTConfig</a>. No other changes are needed!</li>',Il,Ce,kl,Ie,Ao='To learn more about Liger-Kernel, visit their <a href="https://github.com/linkedin/Liger-Kernel/" rel="nofollow">official repository</a>.',Fl,ke,xl,Fe,Ro="Pay attention to the following best practices when training a model with that trainer:",$l,xe,Eo='<li><a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide a default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',Zl,$e,Gl,Ze,Xo='Trainer (and thus SFTTrainer) supports multi-GPU training. If you run your script with <code>python script.py</code> it will default to using DP as the strategy, which may be <a href="https://github.com/huggingface/trl/issues/1303" rel="nofollow">slower than expected</a>. To use DDP (which is generally recommended, see <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_many?select-gpu=Accelerate#data-parallelism" rel="nofollow">here</a> for more info) you must launch the script with <code>python -m torch.distributed.launch script.py</code> or <code>accelerate launch script.py</code>. For DDP to work you must also check the following:',Bl,Ge,Qo='<li>If you’re using gradient_checkpointing, add the following to the TrainingArguments: <code>gradient_checkpointing_kwargs={&#39;use_reentrant&#39;:False}</code> (more info <a href="https://github.com/huggingface/transformers/issues/26969" rel="nofollow">here</a></li> <li>Ensure that the model is placed on the correct device:</li>',Nl,Be,ql,Ne,Al,qe,Wo="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",Rl,Ae,El,Re,So='<code>SFTTrainer</code> does not inherently support vision-language data. However, we provide a guide on how to tweak the trainer to support vision-language data. Specifically, you need to use a custom data collator that is compatible with vision-language data. This guide outlines the steps to make these adjustments. For a concrete example, refer to the script <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/vsft_llava.py" rel="nofollow"><code>examples/scripts/vsft_llava.py</code></a> which demonstrates how to fine-tune the LLaVA 1.5 model on the <a href="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft" rel="nofollow">HuggingFaceH4/llava-instruct-mix-vsft</a> dataset.',Xl,Ee,Ql,Xe,zo="The data format is flexible, provided it is compatible with the custom collator that we will define later. A common approach is to use conversational data. Given that the data includes both text and images, the format needs to be adjusted accordingly. Below is an example of a conversational data format involving both text and images:",Wl,Qe,Sl,We,Vo="To illustrate how this data format will be processed using the LLaVA model, you can use the following code:",zl,Se,Vl,ze,Ho="The output will be formatted as follows:",Hl,Ve,Ll,w,Lo,Yl,He,Dl,Le,Yo="Unlike the default behavior of <code>SFTTrainer</code>, processing multi-modal data is done on the fly during the data collation process. To do this, you need to define a custom collator that processes both the text and images. This collator must take a list of examples as input (see the previous section for an example of the data format) and return a batch of processed data. Below is an example of such a collator:",Ol,Ye,Pl,De,Do="We can verify that the collator works as expected by running the following code:",Kl,Oe,ts,Pe,es,Ke,Oo="Now that we have prepared the data and defined the collator, we can proceed with training the model. To ensure that the data is not processed as text-only, we need to set a couple of arguments in the <code>SFTConfig</code>, specifically <code>dataset_text_field</code> and <code>remove_unused_columns</code>. We also need to set <code>skip_prepare_dataset</code> to <code>True</code> to avoid the default processing of the dataset. Below is an example of how to set up the <code>SFTTrainer</code>.",as,ta,ns,ea,Po='A full example of training LLaVa 1.5 on the <a href="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft" rel="nofollow">HuggingFaceH4/llava-instruct-mix-vsft</a> dataset can be found in the script <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/vsft_llava.py" rel="nofollow"><code>examples/scripts/vsft_llava.py</code></a>.',ls,aa,Ko='<li><a href="https://wandb.ai/huggingface/trl/runs/2b2c5l7s" rel="nofollow">Experiment tracking</a></li> <li><a href="https://huggingface.co/HuggingFaceH4/sft-llava-1.5-7b-hf" rel="nofollow">Trained model</a></li>',ss,na,os,U,la,js,fa,ti=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,is,sa,rs,g,oa,Us,ya,ei='Configuration class for the <a href="/docs/trl/main/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>.',_s,Ta,ai=`Using <a href="https://huggingface.co/docs/transformers/main/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,ps,ia,ds,ra,ni="In the SFTTrainer we smartly support <code>datasets.IterableDataset</code> in addition to other style datasets. This is useful if you are using large corpora that you do not want to save all to disk. The data will be tokenized and processed on the fly, even when packing is enabled.",cs,pa,li="Additionally, in the SFTTrainer, we support pre-tokenized datasets if they are <code>datasets.Dataset</code> or <code>datasets.IterableDataset</code>. In other words, if such a dataset has a column of <code>input_ids</code>, no further processing (tokenization or packing) will be done, and the dataset will be used as-is. This can be useful if you have pretokenized your dataset outside of this script and want to re-use it directly.",ms,da,us,_,ca,bs,ga,si=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,Ms,ma,hs,Ua,fs;return I=new f({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),x=new f({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),Z=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBc2Z0X2NvbmZpZyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBkYXRhc2V0X3RleHRfZmllbGQlM0QlMjJ0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3NlcV9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEJTIyJTJGdG1wJTIyJTJDJTBBKSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RzZnRfY29uZmlnJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

sft_config = SFTConfig(
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
)
trainer.train()`,wrap:!1}}),N=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFzZnRfY29uZmlnJTIwJTNEJTIwU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RzZnRfY29uZmlnJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

sft_config = SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=sft_config,
)

trainer.train()`,wrap:!1}}),A=new f({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),R=new f({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),X=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19wcm9tcHRzX2Z1bmMlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0b3IlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),W=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRDb25maWclMkMlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RTRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMiUyRnRtcCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUyMCUzRCUyMCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0b3IlMkMlMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    args=SFTConfig(
        output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
        dataset_text_field = <span class="hljs-string">&quot;text&quot;</span>,
    ),
    train_dataset=dataset,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),z=new f({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),H=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),O=new h({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCk=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)',wrap:!1}}),K=new h({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),tt=new f({props:{title:"Add Special Tokens for Chat Format",local:"add-special-tokens-for-chat-format",headingTag:"h3"}}),nt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBzZXR1cF9jaGF0X2Zvcm1hdCUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMGNoYXQlMjBmb3JtYXQlMjB3aXRoJTIwZGVmYXVsdCUyMCdjaGF0bWwnJTIwZm9ybWF0JTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBzZXR1cF9jaGF0X2Zvcm1hdChtb2RlbCUyQyUyMHRva2VuaXplciklMEE=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> setup_chat_format

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-comment"># Set up the chat format with default &#x27;chatml&#x27; format</span>
model, tokenizer = setup_chat_format(model, tokenizer)
`,wrap:!1}}),st=new f({props:{title:"Dataset format support",local:"dataset-format-support",headingTag:"h3"}}),rt=new h({props:{code:"JTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGhlbHBmdWwlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMi4uLiUyMiU3RCU1RCU3RCUwQSU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBoZWxwZnVsJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwd3JvdGUlMjAnUm9tZW8lMjBhbmQlMjBKdWxpZXQnJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIuLi4lMjIlN0QlNUQlN0QlMEElN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwaGVscGZ1bCUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGZhciUyMGlzJTIwdGhlJTIwTW9vbiUyMGZyb20lMjBFYXJ0aCUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyLi4uJTIyJTdEJTVEJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Who wrote &#x27;Romeo and Juliet&#x27;?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How far is the Moon from Earth?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),dt=new h({props:{code:"JTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyJTNDcHJvbXB0JTIwdGV4dCUzRSUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlM0NpZGVhbCUyMGdlbmVyYXRlZCUyMHRleHQlM0UlMjIlN0QlMEElN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjIlM0Nwcm9tcHQlMjB0ZXh0JTNFJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUzQ2lkZWFsJTIwZ2VuZXJhdGVkJTIwdGV4dCUzRSUyMiU3RCUwQSU3QiUyMnByb21wdCUyMiUzQSUyMCUyMiUzQ3Byb21wdCUyMHRleHQlM0UlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTNDaWRlYWwlMjBnZW5lcmF0ZWQlMjB0ZXh0JTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),mt=new h({props:{code:"JTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

...

<span class="hljs-comment"># load jsonl dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;path/to/dataset.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># load dataset from the HuggingFace Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/dolly-15k-oai-style&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

...

sft_config = SFTConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=sft_config,
    train_dataset=dataset,
)`,wrap:!1}}),Mt=new f({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),ft=new h({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),Tt=new h({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    args=sft_config,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),Jt=new f({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),jt=new h({props:{code:"JTBB",highlighted:`...
sft_config = SFTConfig(packing=<span class="hljs-literal">True</span>, dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config
)

trainer.train()`,wrap:!1}}),_t=new f({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),vt=new h({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEFzZnRfY29uZmlnJTIwJTNEJTIwU0ZUQ29uZmlnKHBhY2tpbmclM0RUcnVlKSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RzZnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19mdW5jJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

sft_config = SFTConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),It=new f({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),Ft=new h({props:{code:"JTBBJTBB",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)

...

sft_config = SFTConfig(
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: <span class="hljs-string">&quot;bfloat16&quot;</span>,
    },
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
)

trainer.train()`,wrap:!1}}),$t=new f({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),Gt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJFbGV1dGhlckFJJTJGZ3B0LW5lby0xMjVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0RwZWZ0X2NvbmZpZyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>),
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),Nt=new f({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),At=new h({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=SFTConfig(),
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Rt=new f({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),Xt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),Wt=new f({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),zt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),Ht=new h({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),Ot=new f({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Kt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),ee=new h({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
)`,wrap:!1}}),le=new f({props:{title:"Using model creation utility",local:"trl.ModelConfig",headingTag:"h3"}}),oe=new gs({props:{name:"class trl.ModelConfig",anchor:"trl.ModelConfig",parameters:[{name:"model_name_or_path",val:": Optional = None"},{name:"model_revision",val:": str = 'main'"},{name:"torch_dtype",val:": Optional = None"},{name:"trust_remote_code",val:": bool = False"},{name:"attn_implementation",val:": Optional = None"},{name:"use_peft",val:": bool = False"},{name:"lora_r",val:": int = 16"},{name:"lora_alpha",val:": int = 32"},{name:"lora_dropout",val:": float = 0.05"},{name:"lora_target_modules",val:": Optional = None"},{name:"lora_modules_to_save",val:": Optional = None"},{name:"lora_task_type",val:": str = 'CAUSAL_LM'"},{name:"use_rslora",val:": bool = False"},{name:"load_in_8bit",val:": bool = False"},{name:"load_in_4bit",val:": bool = False"},{name:"bnb_4bit_quant_type",val:": Literal = 'nf4'"},{name:"use_bnb_nested_quant",val:": bool = False"}],parametersDescription:[{anchor:"trl.ModelConfig.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Model checkpoint for weights initialization.`,name:"model_name_or_path"},{anchor:"trl.ModelConfig.model_revision",description:`<strong>model_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
Specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"model_revision"},{anchor:"trl.ModelConfig.torch_dtype",description:`<strong>torch_dtype</strong> (<code>Optional[Literal[&quot;auto&quot;, &quot;bfloat16&quot;, &quot;float16&quot;, &quot;float32&quot;]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Override the default <code>torch.dtype</code> and load the model under this dtype. Possible values are</p>
<ul>
<li><code>&quot;bfloat16&quot;</code>: <code>torch.bfloat16</code></li>
<li><code>&quot;float16&quot;</code>: <code>torch.float16</code></li>
<li><code>&quot;float32&quot;</code>: <code>torch.float32</code></li>
<li><code>&quot;auto&quot;</code>: Automatically derive the dtype from the model&#x2019;s weights.</li>
</ul>`,name:"torch_dtype"},{anchor:"trl.ModelConfig.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to allow for custom models defined on the Hub in their own modeling files. This option should only
be set to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code
present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"trl.ModelConfig.attn_implementation",description:`<strong>attn_implementation</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Which attention implementation to use. You can run <code>--attn_implementation=flash_attention_2</code>, in which case
you must install this manually by running <code>pip install flash-attn --no-build-isolation</code>.`,name:"attn_implementation"},{anchor:"trl.ModelConfig.use_peft",description:`<strong>use_peft</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use PEFT for training.`,name:"use_peft"},{anchor:"trl.ModelConfig.lora_r",description:`<strong>lora_r</strong> (<code>int</code>, <em>optional</em>, defaults to <code>16</code>) &#x2014;
LoRA R value.`,name:"lora_r"},{anchor:"trl.ModelConfig.lora_alpha",description:`<strong>lora_alpha</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014;
LoRA alpha.`,name:"lora_alpha"},{anchor:"trl.ModelConfig.lora_dropout",description:`<strong>lora_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.05</code>) &#x2014;
LoRA dropout.`,name:"lora_dropout"},{anchor:"trl.ModelConfig.lora_target_modules",description:`<strong>lora_target_modules</strong> (<code>Optional[Union[str, List[str]]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
LoRA target modules.`,name:"lora_target_modules"},{anchor:"trl.ModelConfig.lora_modules_to_save",description:`<strong>lora_modules_to_save</strong> (<code>Optional[List[str]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Model layers to unfreeze &amp; train.`,name:"lora_modules_to_save"},{anchor:"trl.ModelConfig.lora_task_type",description:`<strong>lora_task_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;CAUSAL_LM&quot;</code>) &#x2014;
Task type to pass for LoRA (use <code>&quot;SEQ_CLS&quot;</code> for reward modeling).`,name:"lora_task_type"},{anchor:"trl.ModelConfig.use_rslora",description:`<strong>use_rslora</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Rank-Stabilized LoRA, which sets the adapter scaling factor to <code>lora_alpha/&#x221A;r</code>, instead of
the original default value of <code>lora_alpha/r</code>.`,name:"use_rslora"},{anchor:"trl.ModelConfig.load_in_8bit",description:`<strong>load_in_8bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use 8 bit precision for the base model. Works only with LoRA.`,name:"load_in_8bit"},{anchor:"trl.ModelConfig.load_in_4bit",description:`<strong>load_in_4bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use 4 bit precision for the base model. Works only with LoRA.`,name:"load_in_4bit"},{anchor:"trl.ModelConfig.bnb_4bit_quant_type",description:`<strong>bnb_4bit_quant_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;nf4&quot;</code>) &#x2014;
Quantization type (<code>&quot;fp4&quot;</code> or <code>&quot;nf4&quot;</code>).`,name:"bnb_4bit_quant_type"},{anchor:"trl.ModelConfig.use_bnb_nested_quant",description:`<strong>use_bnb_nested_quant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use nested quantization.`,name:"use_bnb_nested_quant"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/model_config.py#L5"}}),ie=new h({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyME1vZGVsQ29uZmlnJTJDJTIwU0ZUVHJhaW5lciUyQyUyMGdldF9rYml0X2RldmljZV9tYXAlMkMlMjBnZXRfcGVmdF9jb25maWclMkMlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyME1vZGVsQ29uZmlnKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWVfb3JfcGF0aCUzRCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMEElMjAlMjAlMjAlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNETm9uZSUyQyUyMCUyMyUyMG9yJTIwJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIlMEEpJTBBdG9yY2hfZHR5cGUlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbW9kZWxfY29uZmlnLnRvcmNoX2R0eXBlJTBBJTIwJTIwJTIwJTIwaWYlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUlMjBpbiUyMCU1QiUyMmF1dG8lMjIlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwZWxzZSUyMGdldGF0dHIodG9yY2glMkMlMjBtb2RlbF9jb25maWcudG9yY2hfZHR5cGUpJTBBKSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyhtb2RlbF9jb25maWcpJTBBbW9kZWxfa3dhcmdzJTIwJTNEJTIwZGljdCglMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzRG1vZGVsX2NvbmZpZy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEbW9kZWxfY29uZmlnLnRydXN0X3JlbW90ZV9jb2RlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRG1vZGVsX2NvbmZpZy5hdHRuX2ltcGxlbWVudGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaF9kdHlwZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jYWNoZSUzREZhbHNlJTIwaWYlMjB0cmFpbmluZ19hcmdzLmdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjBlbHNlJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RnZXRfa2JpdF9kZXZpY2VfbWFwKCklMjBpZiUyMHF1YW50aXphdGlvbl9jb25maWclMjBpcyUyMG5vdCUyME5vbmUlMjBlbHNlJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMjAqKm1vZGVsX2t3YXJncyklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2NvbmZpZy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRGdldF9wZWZ0X2NvbmZpZyhtb2RlbF9jb25maWcpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> ModelConfig, SFTTrainer, get_kbit_device_map, get_peft_config, get_quantization_config
model_config = ModelConfig(
    model_name_or_path=<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
    attn_implementation=<span class="hljs-literal">None</span>, <span class="hljs-comment"># or &quot;flash_attention_2&quot;</span>
)
torch_dtype = (
    model_config.torch_dtype
    <span class="hljs-keyword">if</span> model_config.torch_dtype <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;auto&quot;</span>, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">else</span> <span class="hljs-built_in">getattr</span>(torch, model_config.torch_dtype)
)
quantization_config = get_quantization_config(model_config)
model_kwargs = <span class="hljs-built_in">dict</span>(
    revision=model_config.model_revision,
    trust_remote_code=model_config.trust_remote_code,
    attn_implementation=model_config.attn_implementation,
    torch_dtype=torch_dtype,
    use_cache=<span class="hljs-literal">False</span> <span class="hljs-keyword">if</span> training_args.gradient_checkpointing <span class="hljs-keyword">else</span> <span class="hljs-literal">True</span>,
    device_map=get_kbit_device_map() <span class="hljs-keyword">if</span> quantization_config <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
    quantization_config=quantization_config,
)
model = AutoModelForCausalLM.from_pretrained(model_config.model_name_or_path, **model_kwargs)
trainer = SFTTrainer(
    ...,
    model=model_config.model_name_or_path,
    peft_config=get_peft_config(model_config),
)`,wrap:!1}}),re=new f({props:{title:"Enhance the model’s performances using NEFTune",local:"enhance-the-models-performances-using-neftune",headingTag:"h3"}}),me=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBc2Z0X2NvbmZpZyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBuZWZ0dW5lX25vaXNlX2FscGhhJTNENSUyQyUwQSklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEc2Z0X2NvbmZpZyUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

sft_config = SFTConfig(
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=sft_config,
)
trainer.train()`,wrap:!1}}),he=new f({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),ge=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name=<span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length=max_seq_length,
    dtype=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r=<span class="hljs-number">16</span>,
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
    ],
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing=<span class="hljs-literal">True</span>,
    random_state=<span class="hljs-number">3407</span>,
)

args = SFTConfig(
    output_dir=<span class="hljs-string">&quot;./output&quot;</span>,
    max_seq_length=max_seq_length,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
)

trainer = SFTTrainer(
    model=model,
    args=args,
    train_dataset=dataset,
)
trainer.train()`,wrap:!1}}),we=new f({props:{title:"Liger-Kernel: Increase 20% throughput and reduces 60% memory for multi-GPU training",local:"liger-kernel-increase-20-throughput-and-reduces-60-memory-for-multi-gpu-training",headingTag:"h2"}}),ve=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxpZ2VyLWtlcm5lbA==",highlighted:"pip install liger-kernel",wrap:!1}}),Ce=new h({props:{code:"Y29uZmlnJTIwJTNEJTIwU0ZUQ29uZmlnKCUwQSUyMCUyMHVzZV9saWdlciUzRFRydWUlMEEp",highlighted:`config = SFTConfig(
  use_liger=<span class="hljs-literal">True</span>
)`,wrap:!1}}),ke=new f({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),$e=new f({props:{title:"Multi-GPU Training",local:"multi-gpu-training",headingTag:"h2"}}),Be=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEFkZXZpY2Vfc3RyaW5nJTIwJTNEJTIwUGFydGlhbFN0YXRlKCkucHJvY2Vzc19pbmRleCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlN0InJyUzQWRldmljZV9zdHJpbmclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
device_string = PartialState().process_index
model = AutoModelForCausalLM.from_pretrained(
     ...
    device_map={<span class="hljs-string">&#x27;&#x27;</span>:device_string}
)`,wrap:!1}}),Ne=new f({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),Ae=new f({props:{title:"Extending SFTTrainer for Vision Language Models",local:"extending-sfttrainer-for-vision-language-models",headingTag:"h2"}}),Ee=new f({props:{title:"Preparing the Data",local:"preparing-the-data",headingTag:"h3"}}),Qe=new h({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCJTIyb2JhbWEucG5nJTIyJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaG8lMjBpcyUyMHRoaXMlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkJhcmFjayUyME9iYW1hJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwaGUlMjBmYW1vdXMlMjBmb3IlM0YlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhlJTIwaXMlMjB0aGUlMjA0NHRoJTIwUHJlc2lkZW50JTIwb2YlMjB0aGUlMjBVbml0ZWQlMjBTdGF0ZXMuJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTVE",highlighted:`images = [<span class="hljs-string">&quot;obama.png&quot;</span>]
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Who is this?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Barack Obama&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is he famous for?&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;He is the 44th President of the United States.&quot;</span>}
        ]
    }
]`,wrap:!1}}),Se=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLTEuNS03Yi1oZiUyMiklMEFwcmludChwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2UpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)
<span class="hljs-built_in">print</span>(processor.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>))`,wrap:!1}}),Ve=new h({props:{code:"V2hvJTIwaXMlMjB0aGlzJTNGJTIwQVNTSVNUQU5UJTNBJTIwQmFyYWNrJTIwT2JhbWElMjBVU0VSJTNBJTIwV2hhdCUyMGlzJTIwaGUlMjBmYW1vdXMlMjBmb3IlM0YlMjBBU1NJU1RBTlQlM0ElMjBIZSUyMGlzJTIwdGhlJTIwNDR0aCUyMFByZXNpZGVudCUyMG9mJTIwdGhlJTIwVW5pdGVkJTIwU3RhdGVzLiUyMA==",highlighted:"Who is this? ASSISTANT: Barack Obama USER: What is he famous for? ASSISTANT: He is the 44th President of the United States. ",wrap:!1}}),He=new f({props:{title:"A custom collator for processing multi-modal data",local:"a-custom-collator-for-processing-multi-modal-data",headingTag:"h3"}}),Ye=new h({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjB0aGUlMjB0ZXh0cyUyMGFuZCUyMGltYWdlcyUyQyUyMGFuZCUyMGFwcGx5JTIwdGhlJTIwY2hhdCUyMHRlbXBsYXRlJTBBJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShleGFtcGxlJTVCJTIybWVzc2FnZXMlMjIlNUQlMkMlMjB0b2tlbml6ZSUzREZhbHNlKSUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMGV4YW1wbGVzJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwJTVCZXhhbXBsZSU1QiUyMmltYWdlcyUyMiU1RCU1QjAlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRva2VuaXplJTIwdGhlJTIwdGV4dHMlMjBhbmQlMjBwcm9jZXNzJTIwdGhlJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjBwcm9jZXNzb3IodGV4dHMlMkMlMjBpbWFnZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlJTIwbGFiZWxzJTIwYXJlJTIwdGhlJTIwaW5wdXRfaWRzJTJDJTIwYW5kJTIwd2UlMjBtYXNrJTIwdGhlJTIwcGFkZGluZyUyMHRva2VucyUyMGluJTIwdGhlJTIwbG9zcyUyMGNvbXB1dGF0aW9uJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQuY2xvbmUoKSUwQSUyMCUyMCUyMCUyMGxhYmVscyU1QmxhYmVscyUyMCUzRCUzRCUyMHByb2Nlc3Nvci50b2tlbml6ZXIucGFkX3Rva2VuX2lkJTVEJTIwJTNEJTIwLTEwMCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwbGFiZWxzJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-comment"># Get the texts and images, and apply the chat template</span>
    texts = [processor.apply_chat_template(example[<span class="hljs-string">&quot;messages&quot;</span>], tokenize=<span class="hljs-literal">False</span>) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]
    images = [example[<span class="hljs-string">&quot;images&quot;</span>][<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]

    <span class="hljs-comment"># Tokenize the texts and process the images</span>
    batch = processor(texts, images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># The labels are the input_ids, and we mask the padding tokens in the loss computation</span>
    labels = batch[<span class="hljs-string">&quot;input_ids&quot;</span>].clone()
    labels[labels == processor.tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),Oe=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGbGxhdmEtaW5zdHJ1Y3QtbWl4LXZzZnQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWV4YW1wbGVzJTIwJTNEJTIwJTVCZGF0YXNldCU1QjAlNUQlMkMlMjBkYXRhc2V0JTVCMSU1RCU1RCUyMCUyMCUyMyUyMEp1c3QlMjB0d28lMjBleGFtcGxlcyUyMGZvciUyMHRoZSUyMHNha2UlMjBvZiUyMHRoZSUyMGV4YW1wbGUlMEFjb2xsYXRlZF9kYXRhJTIwJTNEJTIwY29sbGF0ZV9mbihleGFtcGxlcyklMEFwcmludChjb2xsYXRlZF9kYXRhLmtleXMoKSklMjAlMjAlMjMlMjBkaWN0X2tleXMoJTVCJ2lucHV0X2lkcyclMkMlMjAnYXR0ZW50aW9uX21hc2snJTJDJTIwJ3BpeGVsX3ZhbHVlcyclMkMlMjAnbGFiZWxzJyU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/llava-instruct-mix-vsft&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
examples = [dataset[<span class="hljs-number">0</span>], dataset[<span class="hljs-number">1</span>]]  <span class="hljs-comment"># Just two examples for the sake of the example</span>
collated_data = collate_fn(examples)
<span class="hljs-built_in">print</span>(collated_data.keys())  <span class="hljs-comment"># dict_keys([&#x27;input_ids&#x27;, &#x27;attention_mask&#x27;, &#x27;pixel_values&#x27;, &#x27;labels&#x27;])</span>`,wrap:!1}}),Pe=new f({props:{title:"Training the vision-language model",local:"training-the-vision-language-model",headingTag:"h3"}}),ta=new h({props:{code:"YXJncy5kYXRhc2V0X3RleHRfZmllbGQlMjAlM0QlMjAlMjIlMjIlMjAlMjAlMjMlMjBuZWVkcyUyMGElMjBkdW1teSUyMGZpZWxkJTBBYXJncy5yZW1vdmVfdW51c2VkX2NvbHVtbnMlMjAlM0QlMjBGYWxzZSUwQWFyZ3MuZGF0YXNldF9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJza2lwX3ByZXBhcmVfZGF0YXNldCUyMiUzQSUyMFRydWUlN0QlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yLnRva2VuaXplciUyQyUwQSk=",highlighted:`args.dataset_text_field = <span class="hljs-string">&quot;&quot;</span>  <span class="hljs-comment"># needs a dummy field</span>
args.remove_unused_columns = <span class="hljs-literal">False</span>
args.dataset_kwargs = {<span class="hljs-string">&quot;skip_prepare_dataset&quot;</span>: <span class="hljs-literal">True</span>}

trainer = SFTTrainer(
    model=model,
    args=args,
    data_collator=collate_fn,
    train_dataset=train_dataset,
    tokenizer=processor.tokenizer,
)`,wrap:!1}}),na=new f({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),la=new gs({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = None"},{name:"chars_per_token",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": Optional = None"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (<code>Optional[SFTConfig]</code>) &#x2014;
The arguments to tweak for training. Will default to a basic instance of <a href="/docs/trl/main/en/sft_trainer#trl.SFTConfig">SFTConfig</a> with the <code>output_dir</code>
set to a directory named <em>tmp_trainer</em> in the current directory if not provided.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (<code>Optional[transformers.DataCollator]</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>Optional[datasets.Dataset]</code>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>Optional[transformers.PreTrainedTokenizer]</code>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L60"}}),sa=new f({props:{title:"SFTConfig",local:"trl.SFTConfig",headingTag:"h2"}}),oa=new gs({props:{name:"class trl.SFTConfig",anchor:"trl.SFTConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": bool = False"},{name:"max_seq_length",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"},{name:"eval_packing",val:": Optional = None"},{name:"num_of_sequences",val:": int = 1024"},{name:"chars_per_token",val:": float = 3.6"},{name:"use_liger",val:": bool = False"}],parametersDescription:[{anchor:"trl.SFTConfig.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the text field of the dataset. If provided, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on <code>dataset_text_field</code>.`,name:"dataset_text_field"},{anchor:"trl.SFTConfig.packing",description:`<strong>packing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls whether the <code>ConstantLengthDataset</code> packs the sequences of the dataset.`,name:"packing"},{anchor:"trl.SFTConfig.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum sequence length for the <code>ConstantLengthDataset</code> and for automatically creating the dataset. If
<code>None</code>, it uses the smaller value between <code>tokenizer.model_max_length</code> and <code>1024</code>.`,name:"max_seq_length"},{anchor:"trl.SFTConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset. Only used when <code>packing=False</code>.`,name:"dataset_num_proc"},{anchor:"trl.SFTConfig.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>Union[int, None]</code>, <em>optional</em>, defaults to <code>1000</code>) &#x2014;
Number of examples to tokenize per batch. If <code>dataset_batch_size &lt;= 0</code> or <code>dataset_batch_size is None</code>,
tokenizes the full dataset as a single batch.`,name:"dataset_batch_size"},{anchor:"trl.SFTConfig.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Scale of the noise for NEFTune embeddings. The <a href="https://huggingface.co/papers/2310.05914" rel="nofollow">NEFTune paper</a>
suggests using values between <code>5</code> and <code>15</code>. If set to <code>None</code>, NEFTune is not activated. Activating NEFTune
can significantly improve model performance for instruction fine-tuning.`,name:"neftune_noise_alpha"},{anchor:"trl.SFTConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.SFTConfig.dataset_kwargs",description:`<strong>dataset_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Dictionary of optional keyword arguments to pass when creating packed or non-packed datasets.`,name:"dataset_kwargs"},{anchor:"trl.SFTConfig.eval_packing",description:`<strong>eval_packing</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to pack the eval dataset. If <code>None</code>, uses the same value as <code>packing</code>.`,name:"eval_packing"},{anchor:"trl.SFTConfig.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of sequences to use for the <code>ConstantLengthDataset</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTConfig.chars_per_token",description:`<strong>chars_per_token</strong> (<code>float</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token to use for the <code>ConstantLengthDataset</code>. See
<a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">chars_token_ratio</a> for more details.`,name:"chars_per_token"},{anchor:"trl.SFTConfig.use_liger",description:`<strong>use_liger</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Monkey patch the model with Liger kernels to increase throughput and reduce memory usage.`,name:"use_liger"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_config.py#L20"}}),ia=new f({props:{title:"Datasets",local:"datasets",headingTag:"h2"}}),da=new f({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h3"}}),ca=new gs({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"tokenizer",val:""},{name:"dataset",val:""},{name:"dataset_text_field",val:" = None"},{name:"formatting_func",val:" = None"},{name:"infinite",val:" = False"},{name:"seq_length",val:" = 1024"},{name:"num_of_sequences",val:" = 1024"},{name:"chars_per_token",val:" = 3.6"},{name:"eos_token_id",val:" = 0"},{name:"shuffle",val:" = True"},{name:"append_concat_token",val:" = True"},{name:"add_special_tokens",val:" = True"}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as <code>&quot;### Question: {question} ### Answer: {answer}&quot;</code>`,name:"formatting_func"},{anchor:"trl.trainer.ConstantLengthDataset.infinite",description:`<strong>infinite</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True the iterator is reset after dataset reaches end else stops.`,name:"infinite"},{anchor:"trl.trainer.ConstantLengthDataset.seq_length",description:`<strong>seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Length of token sequences to return.`,name:"seq_length"},{anchor:"trl.trainer.ConstantLengthDataset.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of token sequences to keep in buffer.`,name:"num_of_sequences"},{anchor:"trl.trainer.ConstantLengthDataset.chars_per_token",description:`<strong>chars_per_token</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token used to estimate number of tokens in text buffer.`,name:"chars_per_token"},{anchor:"trl.trainer.ConstantLengthDataset.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Id of the end of sequence token if the passed tokenizer does not have an EOS token.`,name:"eos_token_id"},{anchor:"trl.trainer.ConstantLengthDataset.shuffle",description:`<strong>shuffle</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Shuffle the examples before they are returned`,name:"shuffle"},{anchor:"trl.trainer.ConstantLengthDataset.append_concat_token",description:`<strong>append_concat_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If true, appends <code>eos_token_id</code> at the end of each sample being packed.`,name:"append_concat_token"},{anchor:"trl.trainer.ConstantLengthDataset.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If true, tokenizers adds special tokens to each sample being packed.`,name:"add_special_tokens"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/utils.py#L539"}}),ma=new Mi({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/sft_trainer.mdx"}}),{c(){j=o("meta"),_a=l(),ja=o("p"),ba=l(),p(I.$$.fragment),va=l(),k=o("p"),k.textContent=Cs,Ca=l(),F=o("p"),F.innerHTML=Is,Ia=l(),p(x.$$.fragment),ka=l(),$=o("p"),$.innerHTML=ks,Fa=l(),p(Z.$$.fragment),xa=l(),G=o("p"),G.innerHTML=Fs,$a=l(),B=o("p"),B.textContent=xs,Za=l(),p(N.$$.fragment),Ga=l(),q=o("p"),q.innerHTML=$s,Ba=l(),p(A.$$.fragment),Na=l(),p(R.$$.fragment),qa=l(),E=o("p"),E.innerHTML=Zs,Aa=l(),p(X.$$.fragment),Ra=l(),Q=o("p"),Q.innerHTML=Gs,Ea=l(),p(W.$$.fragment),Xa=l(),S=o("p"),S.innerHTML=Bs,Qa=l(),p(z.$$.fragment),Wa=l(),V=o("p"),V.innerHTML=Ns,Sa=l(),p(H.$$.fragment),za=l(),L=o("p"),L.innerHTML=qs,Va=l(),Y=o("ul"),Y.innerHTML=As,Ha=l(),D=o("p"),D.innerHTML=Rs,La=l(),p(O.$$.fragment),Ya=l(),P=o("p"),P.innerHTML=Es,Da=l(),p(K.$$.fragment),Oa=l(),p(tt.$$.fragment),Pa=l(),et=o("p"),et.innerHTML=Xs,Ka=l(),at=o("ul"),at.innerHTML=Qs,tn=l(),p(nt.$$.fragment),en=l(),lt=o("p"),lt.textContent=Ws,an=l(),p(st.$$.fragment),nn=l(),ot=o("p"),ot.innerHTML=Ss,ln=l(),it=o("ul"),it.innerHTML=zs,sn=l(),p(rt.$$.fragment),on=l(),pt=o("ul"),pt.innerHTML=Vs,rn=l(),p(dt.$$.fragment),pn=l(),ct=o("p"),ct.innerHTML=Hs,dn=l(),p(mt.$$.fragment),cn=l(),ut=o("p"),ut.textContent=Ls,mn=l(),p(Mt.$$.fragment),un=l(),ht=o("p"),ht.innerHTML=Ys,Mn=l(),p(ft.$$.fragment),hn=l(),yt=o("p"),yt.innerHTML=Ds,fn=l(),p(Tt.$$.fragment),yn=l(),gt=o("p"),gt.innerHTML=Os,Tn=l(),p(Jt.$$.fragment),gn=l(),wt=o("p"),wt.innerHTML=Ps,Jn=l(),p(jt.$$.fragment),wn=l(),Ut=o("p"),Ut.innerHTML=Ks,jn=l(),p(_t.$$.fragment),Un=l(),bt=o("p"),bt.innerHTML=to,_n=l(),p(vt.$$.fragment),bn=l(),Ct=o("p"),Ct.innerHTML=eo,vn=l(),p(It.$$.fragment),Cn=l(),kt=o("p"),kt.innerHTML=ao,In=l(),p(Ft.$$.fragment),kn=l(),xt=o("p"),xt.innerHTML=no,Fn=l(),p($t.$$.fragment),xn=l(),Zt=o("p"),Zt.textContent=lo,$n=l(),p(Gt.$$.fragment),Zn=l(),Bt=o("p"),Bt.innerHTML=so,Gn=l(),p(Nt.$$.fragment),Bn=l(),qt=o("p"),qt.innerHTML=oo,Nn=l(),p(At.$$.fragment),qn=l(),p(Rt.$$.fragment),An=l(),Et=o("p"),Et.textContent=io,Rn=l(),p(Xt.$$.fragment),En=l(),Qt=o("p"),Qt.textContent=ro,Xn=l(),p(Wt.$$.fragment),Qn=l(),St=o("p"),St.innerHTML=po,Wn=l(),p(zt.$$.fragment),Sn=l(),Vt=o("p"),Vt.innerHTML=co,zn=l(),p(Ht.$$.fragment),Vn=l(),Lt=o("p"),Lt.innerHTML=mo,Hn=l(),Yt=o("p"),Yt.textContent=uo,Ln=l(),Dt=o("table"),Dt.innerHTML=Mo,Yn=l(),p(Ot.$$.fragment),Dn=l(),Pt=o("p"),Pt.innerHTML=ho,On=l(),p(Kt.$$.fragment),Pn=l(),te=o("p"),te.innerHTML=fo,Kn=l(),p(ee.$$.fragment),tl=l(),ae=o("p"),ae.textContent=yo,el=l(),ne=o("p"),ne.textContent=To,al=l(),p(le.$$.fragment),nl=l(),se=o("p"),se.textContent=go,ll=l(),T=o("div"),p(oe.$$.fragment),Js=l(),Ma=o("p"),Ma.textContent=Jo,ws=l(),ha=o("p"),ha.innerHTML=wo,sl=l(),p(ie.$$.fragment),ol=l(),p(re.$$.fragment),il=l(),pe=o("p"),pe.innerHTML=jo,rl=l(),de=o("blockquote"),de.innerHTML=Uo,pl=l(),b=o("div"),b.innerHTML=_o,dl=l(),ce=o("p"),ce.innerHTML=bo,cl=l(),p(me.$$.fragment),ml=l(),ue=o("p"),ue.innerHTML=vo,ul=l(),v=o("div"),v.innerHTML=Co,Ml=l(),Me=o("p"),Me.innerHTML=Io,hl=l(),p(he.$$.fragment),fl=l(),fe=o("p"),fe.innerHTML=ko,yl=l(),ye=o("table"),ye.innerHTML=Fo,Tl=l(),Te=o("p"),Te.innerHTML=xo,gl=l(),p(ge.$$.fragment),Jl=l(),Je=o("p"),Je.innerHTML=$o,wl=l(),p(we.$$.fragment),jl=l(),je=o("p"),je.innerHTML=Zo,Ul=l(),Ue=o("p"),Ue.textContent=Go,_l=l(),_e=o("table"),_e.innerHTML=Bo,bl=l(),be=o("ol"),be.innerHTML=No,vl=l(),p(ve.$$.fragment),Cl=l(),C=o("ol"),C.innerHTML=qo,Il=l(),p(Ce.$$.fragment),kl=l(),Ie=o("p"),Ie.innerHTML=Ao,Fl=l(),p(ke.$$.fragment),xl=l(),Fe=o("p"),Fe.textContent=Ro,$l=l(),xe=o("ul"),xe.innerHTML=Eo,Zl=l(),p($e.$$.fragment),Gl=l(),Ze=o("p"),Ze.innerHTML=Xo,Bl=l(),Ge=o("ul"),Ge.innerHTML=Qo,Nl=l(),p(Be.$$.fragment),ql=l(),p(Ne.$$.fragment),Al=l(),qe=o("p"),qe.innerHTML=Wo,Rl=l(),p(Ae.$$.fragment),El=l(),Re=o("p"),Re.innerHTML=So,Xl=l(),p(Ee.$$.fragment),Ql=l(),Xe=o("p"),Xe.textContent=zo,Wl=l(),p(Qe.$$.fragment),Sl=l(),We=o("p"),We.textContent=Vo,zl=l(),p(Se.$$.fragment),Vl=l(),ze=o("p"),ze.textContent=Ho,Hl=l(),p(Ve.$$.fragment),Ll=l(),w=o("iframe"),Yl=l(),p(He.$$.fragment),Dl=l(),Le=o("p"),Le.innerHTML=Yo,Ol=l(),p(Ye.$$.fragment),Pl=l(),De=o("p"),De.textContent=Do,Kl=l(),p(Oe.$$.fragment),ts=l(),p(Pe.$$.fragment),es=l(),Ke=o("p"),Ke.innerHTML=Oo,as=l(),p(ta.$$.fragment),ns=l(),ea=o("p"),ea.innerHTML=Po,ls=l(),aa=o("ul"),aa.innerHTML=Ko,ss=l(),p(na.$$.fragment),os=l(),U=o("div"),p(la.$$.fragment),js=l(),fa=o("p"),fa.innerHTML=ti,is=l(),p(sa.$$.fragment),rs=l(),g=o("div"),p(oa.$$.fragment),Us=l(),ya=o("p"),ya.innerHTML=ei,_s=l(),Ta=o("p"),Ta.innerHTML=ai,ps=l(),p(ia.$$.fragment),ds=l(),ra=o("p"),ra.innerHTML=ni,cs=l(),pa=o("p"),pa.innerHTML=li,ms=l(),p(da.$$.fragment),us=l(),_=o("div"),p(ca.$$.fragment),bs=l(),ga=o("p"),ga.textContent=si,Ms=l(),p(ma.$$.fragment),hs=l(),Ua=o("p"),this.h()},l(t){const e=ui("svelte-u9bgzb",document.head);j=i(e,"META",{name:!0,content:!0}),e.forEach(a),_a=s(t),ja=i(t,"P",{}),ua(ja).forEach(a),ba=s(t),d(I.$$.fragment,t),va=s(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-o839x3"&&(k.textContent=Cs),Ca=s(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1apqcwz"&&(F.innerHTML=Is),Ia=s(t),d(x.$$.fragment,t),ka=s(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-anzvl4"&&($.innerHTML=ks),Fa=s(t),d(Z.$$.fragment,t),xa=s(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-4l7u4"&&(G.innerHTML=Fs),$a=s(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-ulikv8"&&(B.textContent=xs),Za=s(t),d(N.$$.fragment,t),Ga=s(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1atlkjh"&&(q.innerHTML=$s),Ba=s(t),d(A.$$.fragment,t),Na=s(t),d(R.$$.fragment,t),qa=s(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-13sbeoj"&&(E.innerHTML=Zs),Aa=s(t),d(X.$$.fragment,t),Ra=s(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1a743rp"&&(Q.innerHTML=Gs),Ea=s(t),d(W.$$.fragment,t),Xa=s(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-rjhq4r"&&(S.innerHTML=Bs),Qa=s(t),d(z.$$.fragment,t),Wa=s(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-12zdtxn"&&(V.innerHTML=Ns),Sa=s(t),d(H.$$.fragment,t),za=s(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-xlwe87"&&(L.innerHTML=qs),Va=s(t),Y=i(t,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-1enki0k"&&(Y.innerHTML=As),Ha=s(t),D=i(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-14yxh0m"&&(D.innerHTML=Rs),La=s(t),d(O.$$.fragment,t),Ya=s(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-hvnyie"&&(P.innerHTML=Es),Da=s(t),d(K.$$.fragment,t),Oa=s(t),d(tt.$$.fragment,t),Pa=s(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1ccg0zx"&&(et.innerHTML=Xs),Ka=s(t),at=i(t,"UL",{"data-svelte-h":!0}),r(at)!=="svelte-ebt5re"&&(at.innerHTML=Qs),tn=s(t),d(nt.$$.fragment,t),en=s(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-1hmfl2q"&&(lt.textContent=Ws),an=s(t),d(st.$$.fragment,t),nn=s(t),ot=i(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1d09r79"&&(ot.innerHTML=Ss),ln=s(t),it=i(t,"UL",{"data-svelte-h":!0}),r(it)!=="svelte-5iwuvk"&&(it.innerHTML=zs),sn=s(t),d(rt.$$.fragment,t),on=s(t),pt=i(t,"UL",{"data-svelte-h":!0}),r(pt)!=="svelte-23l1e6"&&(pt.innerHTML=Vs),rn=s(t),d(dt.$$.fragment,t),pn=s(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1qd8v57"&&(ct.innerHTML=Hs),dn=s(t),d(mt.$$.fragment,t),cn=s(t),ut=i(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-145h0zs"&&(ut.textContent=Ls),mn=s(t),d(Mt.$$.fragment,t),un=s(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-cqsf2h"&&(ht.innerHTML=Ys),Mn=s(t),d(ft.$$.fragment,t),hn=s(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-l25vq0"&&(yt.innerHTML=Ds),fn=s(t),d(Tt.$$.fragment,t),yn=s(t),gt=i(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-j2xlt3"&&(gt.innerHTML=Os),Tn=s(t),d(Jt.$$.fragment,t),gn=s(t),wt=i(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1g6bcy6"&&(wt.innerHTML=Ps),Jn=s(t),d(jt.$$.fragment,t),wn=s(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-t5o0mn"&&(Ut.innerHTML=Ks),jn=s(t),d(_t.$$.fragment,t),Un=s(t),bt=i(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-iejqw3"&&(bt.innerHTML=to),_n=s(t),d(vt.$$.fragment,t),bn=s(t),Ct=i(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1ngywwy"&&(Ct.innerHTML=eo),vn=s(t),d(It.$$.fragment,t),Cn=s(t),kt=i(t,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-17sfmxe"&&(kt.innerHTML=ao),In=s(t),d(Ft.$$.fragment,t),kn=s(t),xt=i(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1su7aih"&&(xt.innerHTML=no),Fn=s(t),d($t.$$.fragment,t),xn=s(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-9vpjkk"&&(Zt.textContent=lo),$n=s(t),d(Gt.$$.fragment,t),Zn=s(t),Bt=i(t,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-pwdaav"&&(Bt.innerHTML=so),Gn=s(t),d(Nt.$$.fragment,t),Bn=s(t),qt=i(t,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-11pydf"&&(qt.innerHTML=oo),Nn=s(t),d(At.$$.fragment,t),qn=s(t),d(Rt.$$.fragment,t),An=s(t),Et=i(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-fyvvsj"&&(Et.textContent=io),Rn=s(t),d(Xt.$$.fragment,t),En=s(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-yypgof"&&(Qt.textContent=ro),Xn=s(t),d(Wt.$$.fragment,t),Qn=s(t),St=i(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-yugu96"&&(St.innerHTML=po),Wn=s(t),d(zt.$$.fragment,t),Sn=s(t),Vt=i(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-1qms4cl"&&(Vt.innerHTML=co),zn=s(t),d(Ht.$$.fragment,t),Vn=s(t),Lt=i(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-qe5zfz"&&(Lt.innerHTML=mo),Hn=s(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-69u1rz"&&(Yt.textContent=uo),Ln=s(t),Dt=i(t,"TABLE",{"data-svelte-h":!0}),r(Dt)!=="svelte-8fq96j"&&(Dt.innerHTML=Mo),Yn=s(t),d(Ot.$$.fragment,t),Dn=s(t),Pt=i(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1rqlm78"&&(Pt.innerHTML=ho),On=s(t),d(Kt.$$.fragment,t),Pn=s(t),te=i(t,"P",{"data-svelte-h":!0}),r(te)!=="svelte-14s96xo"&&(te.innerHTML=fo),Kn=s(t),d(ee.$$.fragment,t),tl=s(t),ae=i(t,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-vfpk19"&&(ae.textContent=yo),el=s(t),ne=i(t,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-162zeem"&&(ne.textContent=To),al=s(t),d(le.$$.fragment,t),nl=s(t),se=i(t,"P",{"data-svelte-h":!0}),r(se)!=="svelte-u9yx96"&&(se.textContent=go),ll=s(t),T=i(t,"DIV",{class:!0});var Ja=ua(T);d(oe.$$.fragment,Ja),Js=s(Ja),Ma=i(Ja,"P",{"data-svelte-h":!0}),r(Ma)!=="svelte-21rjm6"&&(Ma.textContent=Jo),ws=s(Ja),ha=i(Ja,"P",{"data-svelte-h":!0}),r(ha)!=="svelte-ekuf1t"&&(ha.innerHTML=wo),Ja.forEach(a),sl=s(t),d(ie.$$.fragment,t),ol=s(t),d(re.$$.fragment,t),il=s(t),pe=i(t,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-8q8jbt"&&(pe.innerHTML=jo),rl=s(t),de=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(de)!=="svelte-1ejl1pl"&&(de.innerHTML=Uo),pl=s(t),b=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(b)!=="svelte-1wkjgyb"&&(b.innerHTML=_o),dl=s(t),ce=i(t,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-15c39pv"&&(ce.innerHTML=bo),cl=s(t),d(me.$$.fragment,t),ml=s(t),ue=i(t,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-sqj12"&&(ue.innerHTML=vo),ul=s(t),v=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(v)!=="svelte-a1m5gi"&&(v.innerHTML=Co),Ml=s(t),Me=i(t,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-rwofnh"&&(Me.innerHTML=Io),hl=s(t),d(he.$$.fragment,t),fl=s(t),fe=i(t,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1q1m1nw"&&(fe.innerHTML=ko),yl=s(t),ye=i(t,"TABLE",{"data-svelte-h":!0}),r(ye)!=="svelte-lj2wpp"&&(ye.innerHTML=Fo),Tl=s(t),Te=i(t,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1p74c9x"&&(Te.innerHTML=xo),gl=s(t),d(ge.$$.fragment,t),Jl=s(t),Je=i(t,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1o18rwj"&&(Je.innerHTML=$o),wl=s(t),d(we.$$.fragment,t),jl=s(t),je=i(t,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1tpy3c1"&&(je.innerHTML=Zo),Ul=s(t),Ue=i(t,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-wsouej"&&(Ue.textContent=Go),_l=s(t),_e=i(t,"TABLE",{"data-svelte-h":!0}),r(_e)!=="svelte-1jpb79"&&(_e.innerHTML=Bo),bl=s(t),be=i(t,"OL",{"data-svelte-h":!0}),r(be)!=="svelte-10hwsos"&&(be.innerHTML=No),vl=s(t),d(ve.$$.fragment,t),Cl=s(t),C=i(t,"OL",{start:!0,"data-svelte-h":!0}),r(C)!=="svelte-rmnlwi"&&(C.innerHTML=qo),Il=s(t),d(Ce.$$.fragment,t),kl=s(t),Ie=i(t,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1h5mxii"&&(Ie.innerHTML=Ao),Fl=s(t),d(ke.$$.fragment,t),xl=s(t),Fe=i(t,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-g801h1"&&(Fe.textContent=Ro),$l=s(t),xe=i(t,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-pefjj9"&&(xe.innerHTML=Eo),Zl=s(t),d($e.$$.fragment,t),Gl=s(t),Ze=i(t,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-s3xf41"&&(Ze.innerHTML=Xo),Bl=s(t),Ge=i(t,"UL",{"data-svelte-h":!0}),r(Ge)!=="svelte-19jsxq"&&(Ge.innerHTML=Qo),Nl=s(t),d(Be.$$.fragment,t),ql=s(t),d(Ne.$$.fragment,t),Al=s(t),qe=i(t,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-xofzi2"&&(qe.innerHTML=Wo),Rl=s(t),d(Ae.$$.fragment,t),El=s(t),Re=i(t,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-3c9rqx"&&(Re.innerHTML=So),Xl=s(t),d(Ee.$$.fragment,t),Ql=s(t),Xe=i(t,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-58v4pe"&&(Xe.textContent=zo),Wl=s(t),d(Qe.$$.fragment,t),Sl=s(t),We=i(t,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1i9g14v"&&(We.textContent=Vo),zl=s(t),d(Se.$$.fragment,t),Vl=s(t),ze=i(t,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-aegjvb"&&(ze.textContent=Ho),Hl=s(t),d(Ve.$$.fragment,t),Ll=s(t),w=i(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),ua(w).forEach(a),Yl=s(t),d(He.$$.fragment,t),Dl=s(t),Le=i(t,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1y2dzof"&&(Le.innerHTML=Yo),Ol=s(t),d(Ye.$$.fragment,t),Pl=s(t),De=i(t,"P",{"data-svelte-h":!0}),r(De)!=="svelte-ezw63w"&&(De.textContent=Do),Kl=s(t),d(Oe.$$.fragment,t),ts=s(t),d(Pe.$$.fragment,t),es=s(t),Ke=i(t,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-qqrn0r"&&(Ke.innerHTML=Oo),as=s(t),d(ta.$$.fragment,t),ns=s(t),ea=i(t,"P",{"data-svelte-h":!0}),r(ea)!=="svelte-1kavtxk"&&(ea.innerHTML=Po),ls=s(t),aa=i(t,"UL",{"data-svelte-h":!0}),r(aa)!=="svelte-ata0nu"&&(aa.innerHTML=Ko),ss=s(t),d(na.$$.fragment,t),os=s(t),U=i(t,"DIV",{class:!0});var ys=ua(U);d(la.$$.fragment,ys),js=s(ys),fa=i(ys,"P",{"data-svelte-h":!0}),r(fa)!=="svelte-14oyph8"&&(fa.innerHTML=ti),ys.forEach(a),is=s(t),d(sa.$$.fragment,t),rs=s(t),g=i(t,"DIV",{class:!0});var wa=ua(g);d(oa.$$.fragment,wa),Us=s(wa),ya=i(wa,"P",{"data-svelte-h":!0}),r(ya)!=="svelte-1vqepzx"&&(ya.innerHTML=ei),_s=s(wa),Ta=i(wa,"P",{"data-svelte-h":!0}),r(Ta)!=="svelte-ekuf1t"&&(Ta.innerHTML=ai),wa.forEach(a),ps=s(t),d(ia.$$.fragment,t),ds=s(t),ra=i(t,"P",{"data-svelte-h":!0}),r(ra)!=="svelte-16l6c3u"&&(ra.innerHTML=ni),cs=s(t),pa=i(t,"P",{"data-svelte-h":!0}),r(pa)!=="svelte-k5kqyl"&&(pa.innerHTML=li),ms=s(t),d(da.$$.fragment,t),us=s(t),_=i(t,"DIV",{class:!0});var Ts=ua(_);d(ca.$$.fragment,Ts),bs=s(Ts),ga=i(Ts,"P",{"data-svelte-h":!0}),r(ga)!=="svelte-1dlriq1"&&(ga.textContent=si),Ts.forEach(a),Ms=s(t),d(ma.$$.fragment,t),hs=s(t),Ua=i(t,"P",{}),ua(Ua).forEach(a),this.h()},h(){J(j,"name","hf:doc:metadata"),J(j,"content",fi),J(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),oi(b,"text-align","center"),oi(v,"text-align","center"),J(C,"start","2"),ri(w.src,Lo="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft/embed/viewer/default/train")||J(w,"src",Lo),J(w,"frameborder","0"),J(w,"width","100%"),J(w,"height","560px"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){y(document.head,j),n(t,_a,e),n(t,ja,e),n(t,ba,e),c(I,t,e),n(t,va,e),n(t,k,e),n(t,Ca,e),n(t,F,e),n(t,Ia,e),c(x,t,e),n(t,ka,e),n(t,$,e),n(t,Fa,e),c(Z,t,e),n(t,xa,e),n(t,G,e),n(t,$a,e),n(t,B,e),n(t,Za,e),c(N,t,e),n(t,Ga,e),n(t,q,e),n(t,Ba,e),c(A,t,e),n(t,Na,e),c(R,t,e),n(t,qa,e),n(t,E,e),n(t,Aa,e),c(X,t,e),n(t,Ra,e),n(t,Q,e),n(t,Ea,e),c(W,t,e),n(t,Xa,e),n(t,S,e),n(t,Qa,e),c(z,t,e),n(t,Wa,e),n(t,V,e),n(t,Sa,e),c(H,t,e),n(t,za,e),n(t,L,e),n(t,Va,e),n(t,Y,e),n(t,Ha,e),n(t,D,e),n(t,La,e),c(O,t,e),n(t,Ya,e),n(t,P,e),n(t,Da,e),c(K,t,e),n(t,Oa,e),c(tt,t,e),n(t,Pa,e),n(t,et,e),n(t,Ka,e),n(t,at,e),n(t,tn,e),c(nt,t,e),n(t,en,e),n(t,lt,e),n(t,an,e),c(st,t,e),n(t,nn,e),n(t,ot,e),n(t,ln,e),n(t,it,e),n(t,sn,e),c(rt,t,e),n(t,on,e),n(t,pt,e),n(t,rn,e),c(dt,t,e),n(t,pn,e),n(t,ct,e),n(t,dn,e),c(mt,t,e),n(t,cn,e),n(t,ut,e),n(t,mn,e),c(Mt,t,e),n(t,un,e),n(t,ht,e),n(t,Mn,e),c(ft,t,e),n(t,hn,e),n(t,yt,e),n(t,fn,e),c(Tt,t,e),n(t,yn,e),n(t,gt,e),n(t,Tn,e),c(Jt,t,e),n(t,gn,e),n(t,wt,e),n(t,Jn,e),c(jt,t,e),n(t,wn,e),n(t,Ut,e),n(t,jn,e),c(_t,t,e),n(t,Un,e),n(t,bt,e),n(t,_n,e),c(vt,t,e),n(t,bn,e),n(t,Ct,e),n(t,vn,e),c(It,t,e),n(t,Cn,e),n(t,kt,e),n(t,In,e),c(Ft,t,e),n(t,kn,e),n(t,xt,e),n(t,Fn,e),c($t,t,e),n(t,xn,e),n(t,Zt,e),n(t,$n,e),c(Gt,t,e),n(t,Zn,e),n(t,Bt,e),n(t,Gn,e),c(Nt,t,e),n(t,Bn,e),n(t,qt,e),n(t,Nn,e),c(At,t,e),n(t,qn,e),c(Rt,t,e),n(t,An,e),n(t,Et,e),n(t,Rn,e),c(Xt,t,e),n(t,En,e),n(t,Qt,e),n(t,Xn,e),c(Wt,t,e),n(t,Qn,e),n(t,St,e),n(t,Wn,e),c(zt,t,e),n(t,Sn,e),n(t,Vt,e),n(t,zn,e),c(Ht,t,e),n(t,Vn,e),n(t,Lt,e),n(t,Hn,e),n(t,Yt,e),n(t,Ln,e),n(t,Dt,e),n(t,Yn,e),c(Ot,t,e),n(t,Dn,e),n(t,Pt,e),n(t,On,e),c(Kt,t,e),n(t,Pn,e),n(t,te,e),n(t,Kn,e),c(ee,t,e),n(t,tl,e),n(t,ae,e),n(t,el,e),n(t,ne,e),n(t,al,e),c(le,t,e),n(t,nl,e),n(t,se,e),n(t,ll,e),n(t,T,e),c(oe,T,null),y(T,Js),y(T,Ma),y(T,ws),y(T,ha),n(t,sl,e),c(ie,t,e),n(t,ol,e),c(re,t,e),n(t,il,e),n(t,pe,e),n(t,rl,e),n(t,de,e),n(t,pl,e),n(t,b,e),n(t,dl,e),n(t,ce,e),n(t,cl,e),c(me,t,e),n(t,ml,e),n(t,ue,e),n(t,ul,e),n(t,v,e),n(t,Ml,e),n(t,Me,e),n(t,hl,e),c(he,t,e),n(t,fl,e),n(t,fe,e),n(t,yl,e),n(t,ye,e),n(t,Tl,e),n(t,Te,e),n(t,gl,e),c(ge,t,e),n(t,Jl,e),n(t,Je,e),n(t,wl,e),c(we,t,e),n(t,jl,e),n(t,je,e),n(t,Ul,e),n(t,Ue,e),n(t,_l,e),n(t,_e,e),n(t,bl,e),n(t,be,e),n(t,vl,e),c(ve,t,e),n(t,Cl,e),n(t,C,e),n(t,Il,e),c(Ce,t,e),n(t,kl,e),n(t,Ie,e),n(t,Fl,e),c(ke,t,e),n(t,xl,e),n(t,Fe,e),n(t,$l,e),n(t,xe,e),n(t,Zl,e),c($e,t,e),n(t,Gl,e),n(t,Ze,e),n(t,Bl,e),n(t,Ge,e),n(t,Nl,e),c(Be,t,e),n(t,ql,e),c(Ne,t,e),n(t,Al,e),n(t,qe,e),n(t,Rl,e),c(Ae,t,e),n(t,El,e),n(t,Re,e),n(t,Xl,e),c(Ee,t,e),n(t,Ql,e),n(t,Xe,e),n(t,Wl,e),c(Qe,t,e),n(t,Sl,e),n(t,We,e),n(t,zl,e),c(Se,t,e),n(t,Vl,e),n(t,ze,e),n(t,Hl,e),c(Ve,t,e),n(t,Ll,e),n(t,w,e),n(t,Yl,e),c(He,t,e),n(t,Dl,e),n(t,Le,e),n(t,Ol,e),c(Ye,t,e),n(t,Pl,e),n(t,De,e),n(t,Kl,e),c(Oe,t,e),n(t,ts,e),c(Pe,t,e),n(t,es,e),n(t,Ke,e),n(t,as,e),c(ta,t,e),n(t,ns,e),n(t,ea,e),n(t,ls,e),n(t,aa,e),n(t,ss,e),c(na,t,e),n(t,os,e),n(t,U,e),c(la,U,null),y(U,js),y(U,fa),n(t,is,e),c(sa,t,e),n(t,rs,e),n(t,g,e),c(oa,g,null),y(g,Us),y(g,ya),y(g,_s),y(g,Ta),n(t,ps,e),c(ia,t,e),n(t,ds,e),n(t,ra,e),n(t,cs,e),n(t,pa,e),n(t,ms,e),c(da,t,e),n(t,us,e),n(t,_,e),c(ca,_,null),y(_,bs),y(_,ga),n(t,Ms,e),c(ma,t,e),n(t,hs,e),n(t,Ua,e),fs=!0},p:pi,i(t){fs||(m(I.$$.fragment,t),m(x.$$.fragment,t),m(Z.$$.fragment,t),m(N.$$.fragment,t),m(A.$$.fragment,t),m(R.$$.fragment,t),m(X.$$.fragment,t),m(W.$$.fragment,t),m(z.$$.fragment,t),m(H.$$.fragment,t),m(O.$$.fragment,t),m(K.$$.fragment,t),m(tt.$$.fragment,t),m(nt.$$.fragment,t),m(st.$$.fragment,t),m(rt.$$.fragment,t),m(dt.$$.fragment,t),m(mt.$$.fragment,t),m(Mt.$$.fragment,t),m(ft.$$.fragment,t),m(Tt.$$.fragment,t),m(Jt.$$.fragment,t),m(jt.$$.fragment,t),m(_t.$$.fragment,t),m(vt.$$.fragment,t),m(It.$$.fragment,t),m(Ft.$$.fragment,t),m($t.$$.fragment,t),m(Gt.$$.fragment,t),m(Nt.$$.fragment,t),m(At.$$.fragment,t),m(Rt.$$.fragment,t),m(Xt.$$.fragment,t),m(Wt.$$.fragment,t),m(zt.$$.fragment,t),m(Ht.$$.fragment,t),m(Ot.$$.fragment,t),m(Kt.$$.fragment,t),m(ee.$$.fragment,t),m(le.$$.fragment,t),m(oe.$$.fragment,t),m(ie.$$.fragment,t),m(re.$$.fragment,t),m(me.$$.fragment,t),m(he.$$.fragment,t),m(ge.$$.fragment,t),m(we.$$.fragment,t),m(ve.$$.fragment,t),m(Ce.$$.fragment,t),m(ke.$$.fragment,t),m($e.$$.fragment,t),m(Be.$$.fragment,t),m(Ne.$$.fragment,t),m(Ae.$$.fragment,t),m(Ee.$$.fragment,t),m(Qe.$$.fragment,t),m(Se.$$.fragment,t),m(Ve.$$.fragment,t),m(He.$$.fragment,t),m(Ye.$$.fragment,t),m(Oe.$$.fragment,t),m(Pe.$$.fragment,t),m(ta.$$.fragment,t),m(na.$$.fragment,t),m(la.$$.fragment,t),m(sa.$$.fragment,t),m(oa.$$.fragment,t),m(ia.$$.fragment,t),m(da.$$.fragment,t),m(ca.$$.fragment,t),m(ma.$$.fragment,t),fs=!0)},o(t){u(I.$$.fragment,t),u(x.$$.fragment,t),u(Z.$$.fragment,t),u(N.$$.fragment,t),u(A.$$.fragment,t),u(R.$$.fragment,t),u(X.$$.fragment,t),u(W.$$.fragment,t),u(z.$$.fragment,t),u(H.$$.fragment,t),u(O.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(nt.$$.fragment,t),u(st.$$.fragment,t),u(rt.$$.fragment,t),u(dt.$$.fragment,t),u(mt.$$.fragment,t),u(Mt.$$.fragment,t),u(ft.$$.fragment,t),u(Tt.$$.fragment,t),u(Jt.$$.fragment,t),u(jt.$$.fragment,t),u(_t.$$.fragment,t),u(vt.$$.fragment,t),u(It.$$.fragment,t),u(Ft.$$.fragment,t),u($t.$$.fragment,t),u(Gt.$$.fragment,t),u(Nt.$$.fragment,t),u(At.$$.fragment,t),u(Rt.$$.fragment,t),u(Xt.$$.fragment,t),u(Wt.$$.fragment,t),u(zt.$$.fragment,t),u(Ht.$$.fragment,t),u(Ot.$$.fragment,t),u(Kt.$$.fragment,t),u(ee.$$.fragment,t),u(le.$$.fragment,t),u(oe.$$.fragment,t),u(ie.$$.fragment,t),u(re.$$.fragment,t),u(me.$$.fragment,t),u(he.$$.fragment,t),u(ge.$$.fragment,t),u(we.$$.fragment,t),u(ve.$$.fragment,t),u(Ce.$$.fragment,t),u(ke.$$.fragment,t),u($e.$$.fragment,t),u(Be.$$.fragment,t),u(Ne.$$.fragment,t),u(Ae.$$.fragment,t),u(Ee.$$.fragment,t),u(Qe.$$.fragment,t),u(Se.$$.fragment,t),u(Ve.$$.fragment,t),u(He.$$.fragment,t),u(Ye.$$.fragment,t),u(Oe.$$.fragment,t),u(Pe.$$.fragment,t),u(ta.$$.fragment,t),u(na.$$.fragment,t),u(la.$$.fragment,t),u(sa.$$.fragment,t),u(oa.$$.fragment,t),u(ia.$$.fragment,t),u(da.$$.fragment,t),u(ca.$$.fragment,t),u(ma.$$.fragment,t),fs=!1},d(t){t&&(a(_a),a(ja),a(ba),a(va),a(k),a(Ca),a(F),a(Ia),a(ka),a($),a(Fa),a(xa),a(G),a($a),a(B),a(Za),a(Ga),a(q),a(Ba),a(Na),a(qa),a(E),a(Aa),a(Ra),a(Q),a(Ea),a(Xa),a(S),a(Qa),a(Wa),a(V),a(Sa),a(za),a(L),a(Va),a(Y),a(Ha),a(D),a(La),a(Ya),a(P),a(Da),a(Oa),a(Pa),a(et),a(Ka),a(at),a(tn),a(en),a(lt),a(an),a(nn),a(ot),a(ln),a(it),a(sn),a(on),a(pt),a(rn),a(pn),a(ct),a(dn),a(cn),a(ut),a(mn),a(un),a(ht),a(Mn),a(hn),a(yt),a(fn),a(yn),a(gt),a(Tn),a(gn),a(wt),a(Jn),a(wn),a(Ut),a(jn),a(Un),a(bt),a(_n),a(bn),a(Ct),a(vn),a(Cn),a(kt),a(In),a(kn),a(xt),a(Fn),a(xn),a(Zt),a($n),a(Zn),a(Bt),a(Gn),a(Bn),a(qt),a(Nn),a(qn),a(An),a(Et),a(Rn),a(En),a(Qt),a(Xn),a(Qn),a(St),a(Wn),a(Sn),a(Vt),a(zn),a(Vn),a(Lt),a(Hn),a(Yt),a(Ln),a(Dt),a(Yn),a(Dn),a(Pt),a(On),a(Pn),a(te),a(Kn),a(tl),a(ae),a(el),a(ne),a(al),a(nl),a(se),a(ll),a(T),a(sl),a(ol),a(il),a(pe),a(rl),a(de),a(pl),a(b),a(dl),a(ce),a(cl),a(ml),a(ue),a(ul),a(v),a(Ml),a(Me),a(hl),a(fl),a(fe),a(yl),a(ye),a(Tl),a(Te),a(gl),a(Jl),a(Je),a(wl),a(jl),a(je),a(Ul),a(Ue),a(_l),a(_e),a(bl),a(be),a(vl),a(Cl),a(C),a(Il),a(kl),a(Ie),a(Fl),a(xl),a(Fe),a($l),a(xe),a(Zl),a(Gl),a(Ze),a(Bl),a(Ge),a(Nl),a(ql),a(Al),a(qe),a(Rl),a(El),a(Re),a(Xl),a(Ql),a(Xe),a(Wl),a(Sl),a(We),a(zl),a(Vl),a(ze),a(Hl),a(Ll),a(w),a(Yl),a(Dl),a(Le),a(Ol),a(Pl),a(De),a(Kl),a(ts),a(es),a(Ke),a(as),a(ns),a(ea),a(ls),a(aa),a(ss),a(os),a(U),a(is),a(rs),a(g),a(ps),a(ds),a(ra),a(cs),a(pa),a(ms),a(us),a(_),a(Ms),a(hs),a(Ua)),a(j),M(I,t),M(x,t),M(Z,t),M(N,t),M(A,t),M(R,t),M(X,t),M(W,t),M(z,t),M(H,t),M(O,t),M(K,t),M(tt,t),M(nt,t),M(st,t),M(rt,t),M(dt,t),M(mt,t),M(Mt,t),M(ft,t),M(Tt,t),M(Jt,t),M(jt,t),M(_t,t),M(vt,t),M(It,t),M(Ft,t),M($t,t),M(Gt,t),M(Nt,t),M(At,t),M(Rt,t),M(Xt,t),M(Wt,t),M(zt,t),M(Ht,t),M(Ot,t),M(Kt,t),M(ee,t),M(le,t),M(oe),M(ie,t),M(re,t),M(me,t),M(he,t),M(ge,t),M(we,t),M(ve,t),M(Ce,t),M(ke,t),M($e,t),M(Be,t),M(Ne,t),M(Ae,t),M(Ee,t),M(Qe,t),M(Se,t),M(Ve,t),M(He,t),M(Ye,t),M(Oe,t),M(Pe,t),M(ta,t),M(na,t),M(la),M(sa,t),M(oa),M(ia,t),M(da,t),M(ca),M(ma,t)}}}const fi='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Add Special Tokens for Chat Format","local":"add-special-tokens-for-chat-format","sections":[],"depth":3},{"title":"Dataset format support","local":"dataset-format-support","sections":[],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Using model creation utility","local":"trl.ModelConfig","sections":[],"depth":3},{"title":"Enhance the model’s performances using NEFTune","local":"enhance-the-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Liger-Kernel: Increase 20% throughput and reduces 60% memory for multi-GPU training","local":"liger-kernel-increase-20-throughput-and-reduces-60-memory-for-multi-gpu-training","sections":[],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"Multi-GPU Training","local":"multi-gpu-training","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"Extending SFTTrainer for Vision Language Models","local":"extending-sfttrainer-for-vision-language-models","sections":[{"title":"Preparing the Data","local":"preparing-the-data","sections":[],"depth":3},{"title":"A custom collator for processing multi-modal data","local":"a-custom-collator-for-processing-multi-modal-data","sections":[],"depth":3},{"title":"Training the vision-language model","local":"training-the-vision-language-model","sections":[],"depth":3}],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"SFTConfig","local":"trl.SFTConfig","sections":[],"depth":2},{"title":"Datasets","local":"datasets","sections":[{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[],"depth":3}],"depth":2}],"depth":1}';function yi(vs){return di(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ui extends ci{constructor(j){super(),mi(this,j,yi,hi,ii,{})}}export{Ui as component};
