import{s as Ke,o as Oe}from"../chunks/scheduler.6062bdaf.js";import{S as et,i as tt,g as i,s as n,r as m,A as lt,h as s,f as l,c as o,j as Se,u as p,x as d,k as De,y as at,a,v as u,d as h,t as f,w as c,m as nt,n as ot}from"../chunks/index.4bca734e.js";import{T as it}from"../chunks/Tip.b9ac1f03.js";import{C as D}from"../chunks/CodeBlock.fa01571c.js";import{H as M}from"../chunks/Heading.723dceba.js";function st(K){let r;return{c(){r=nt("GPTQ quantization only works for text model for now. Futhermore, the quantization process can take a lot of time depending on one's hardware (175B model = 4 gpu hours using NVIDIA A100). Please check on the Hugging Face Hub if there is not already a GPTQ quantized version of the model you would like to quantize.")},l(b){r=ot(b,"GPTQ quantization only works for text model for now. Futhermore, the quantization process can take a lot of time depending on one's hardware (175B model = 4 gpu hours using NVIDIA A100). Please check on the Hugging Face Hub if there is not already a GPTQ quantized version of the model you would like to quantize.")},m(b,w){a(b,r,w)},d(b){b&&l(r)}}}function dt(K){let r,b,w,O,_,ee,$,te,g,Re='🤗 Optimum collaborated with <a href="https://github.com/PanQiWei/AutoGPTQ" rel="nofollow">AutoGPTQ library</a> to provide a simple API that apply GPTQ quantization on language models. With GPTQ quantization, you can quantize your favorite language model to 8, 4, 3 or even 2 bits. This comes without a big drop of performance and with faster inference speed. This is supported by most GPU hardwares.',le,v,Xe='If you want to quantize 🤗 Transformers models with GPTQ, follow this <a href="https://huggingface.co/docs/transformers/main_classes/quantization" rel="nofollow">documentation</a>.',ae,T,Ce="To learn more about the quantization technique used in GPTQ, please refer to:",ne,k,We='<li>the <a href="https://arxiv.org/pdf/2210.17323.pdf" rel="nofollow">GPTQ</a> paper</li> <li>the <a href="https://github.com/PanQiWei/AutoGPTQ" rel="nofollow">AutoGPTQ</a> library used as the backend</li>',oe,Z,Ue="Note that the AutoGPTQ library provides more advanced usage (triton backend, fused attention, fused MLP) that are not integrated with Optimum. For now, we leverage only the CUDA kernel for GPTQ.",ie,q,se,z,xe="You need to have the following requirements installed to run the code below:",de,j,Je=`<li><p>AutoGPTQ library:
<code>pip install auto-gptq</code></p></li> <li><p>Optimum library:
<code>pip install --upgrade optimum</code></p></li> <li><p>Install latest <code>transformers</code> library from source:
<code>pip install --upgrade git+https://github.com/huggingface/transformers.git</code></p></li> <li><p>Install latest <code>accelerate</code> library:
<code>pip install --upgrade accelerate</code></p></li>`,re,G,me,F,Qe="The <code>GPTQQuantizer</code> class is used to quantize your model. In order to quantize your model, you need to provide a few arguemnts:",pe,R,He="<li>the number of bits: <code>bits</code></li> <li>the dataset used to calibrate the quantization: <code>dataset</code></li> <li>the model sequence length used to process the dataset: <code>model_seqlen</code></li> <li>the block name to quantize: <code>block_name_to_quantize</code></li>",ue,X,Ve="With 🤗 Transformers integration, you don’t need to pass the <code>block_name_to_quantize</code> and <code>model_seqlen</code> as we can retrieve them. However, for custom model, you need to specify them. Also, make sure that your model is converted to <code>torch.float16</code> before quantization.",he,C,fe,y,ce,W,be,U,Ee="To save your model, use the save method from <code>GPTQQuantizer</code> class. It will create a folder with your model state dict along with the quantization config.",ye,x,Me,J,we,Q,Be=`You can load your quantized weights by using the <code>load_quantized_model()</code> function.
Through the Accelerate library, it is possible to load a model faster with a lower memory usage. The model needs to be initialized using empty weights, with weights loaded as a next step.`,_e,H,$e,V,ge,E,Pe="With the release of the exllamav2 kernel, you can get faster inference speed compared to the exllama kernels for 4-bit model. It is activated by default: <code>disable_exllamav2=False</code> in <code>load_quantized_model()</code>. In order to use these kernels, you need to have the entire model on gpus.",ve,B,Te,P,Ie="If you wish to use exllama kernels, you will have to disable the exllamav2 kernel and activate the exllama kernel:",ke,I,Ze,L,Le="Note that only 4-bit models are supported with exllama/exllamav2 kernels for now. Furthermore, it is recommended to disable the exllama/exllamav2 kernel when you are finetuning your model with peft.",qe,Y,Ye='You can find the benchmark of these kernels <a href="https://github.com/huggingface/optimum/tree/main/tests/benchmark#gptq-benchmark" rel="nofollow">here</a>',ze,A,je,N,Ae=`With the official support of adapters in the Hugging Face ecosystem, you can fine-tune models that have been quantized with GPTQ.
Please have a look at <a href="https://github.com/huggingface/peft" rel="nofollow"><code>peft</code></a> library for more details.`,Ge,S,Fe;return _=new M({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),$=new M({props:{title:"AutoGPTQ Integration",local:"autogptq-integration",headingTag:"h2"}}),q=new M({props:{title:"Requirements",local:"requirements",headingTag:"h3"}}),G=new M({props:{title:"Load and quantize a model",local:"load-and-quantize-a-model",headingTag:"h3"}}),C=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLmdwdHElMjBpbXBvcnQlMjBHUFRRUXVhbnRpemVyJTJDJTIwbG9hZF9xdWFudGl6ZWRfbW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXF1YW50aXplciUyMCUzRCUyMEdQVFFRdWFudGl6ZXIoYml0cyUzRDQlMkMlMjBkYXRhc2V0JTNEJTIyYzQlMjIlMkMlMjBibG9ja19uYW1lX3RvX3F1YW50aXplJTIwJTNEJTIwJTIybW9kZWwuZGVjb2Rlci5sYXllcnMlMjIlMkMlMjBtb2RlbF9zZXFsZW4lMjAlM0QlMjAyMDQ4KSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMHF1YW50aXplci5xdWFudGl6ZV9tb2RlbChtb2RlbCUyQyUyMHRva2VuaXplcik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> optimum.gptq <span class="hljs-keyword">import</span> GPTQQuantizer, load_quantized_model
<span class="hljs-keyword">import</span> torch
model_name = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_name)
model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=torch.float16)

quantizer = GPTQQuantizer(bits=<span class="hljs-number">4</span>, dataset=<span class="hljs-string">&quot;c4&quot;</span>, block_name_to_quantize = <span class="hljs-string">&quot;model.decoder.layers&quot;</span>, model_seqlen = <span class="hljs-number">2048</span>)
quantized_model = quantizer.quantize_model(model, tokenizer)`,wrap:!1}}),y=new it({props:{warning:!0,$$slots:{default:[st]},$$scope:{ctx:K}}}),W=new M({props:{title:"Save the model",local:"save-the-model",headingTag:"h3"}}),x=new D({props:{code:"c2F2ZV9mb2xkZXIlMjAlM0QlMjAlMjIlMkZwYXRoJTJGdG8lMkZzYXZlX2ZvbGRlciUyRiUyMiUwQXF1YW50aXplci5zYXZlKG1vZGVsJTJDc2F2ZV9mb2xkZXIp",highlighted:`save_folder = <span class="hljs-string">&quot;/path/to/save_folder/&quot;</span>
quantizer.save(model,save_folder)`,wrap:!1}}),J=new M({props:{title:"Load quantized weights",local:"load-quantized-weights",headingTag:"h3"}}),H=new D({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEF3aXRoJTIwaW5pdF9lbXB0eV93ZWlnaHRzKCklM0ElMEElMjAlMjAlMjAlMjBlbXB0eV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWVtcHR5X21vZGVsLnRpZV93ZWlnaHRzKCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBsb2FkX3F1YW50aXplZF9tb2RlbChlbXB0eV9tb2RlbCUyQyUyMHNhdmVfZm9sZGVyJTNEc2F2ZV9mb2xkZXIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=torch.float16)
empty_model.tie_weights()
quantized_model = load_quantized_model(empty_model, save_folder=save_folder, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),V=new M({props:{title:"Exllama kernels for faster inference",local:"exllama-kernels-for-faster-inference",headingTag:"h3"}}),B=new D({props:{code:"ZnJvbSUyMG9wdGltdW0uZ3B0cSUyMGltcG9ydCUyMEdQVFFRdWFudGl6ZXIlMkMlMjBsb2FkX3F1YW50aXplZF9tb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEF3aXRoJTIwaW5pdF9lbXB0eV93ZWlnaHRzKCklM0ElMEElMjAlMjAlMjAlMjBlbXB0eV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWVtcHR5X21vZGVsLnRpZV93ZWlnaHRzKCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBsb2FkX3F1YW50aXplZF9tb2RlbChlbXB0eV9tb2RlbCUyQyUyMHNhdmVfZm9sZGVyJTNEc2F2ZV9mb2xkZXIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.gptq <span class="hljs-keyword">import</span> GPTQQuantizer, load_quantized_model
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=torch.float16)
empty_model.tie_weights()
quantized_model = load_quantized_model(empty_model, save_folder=save_folder, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),I=new D({props:{code:"ZnJvbSUyMG9wdGltdW0uZ3B0cSUyMGltcG9ydCUyMEdQVFFRdWFudGl6ZXIlMkMlMjBsb2FkX3F1YW50aXplZF9tb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEF3aXRoJTIwaW5pdF9lbXB0eV93ZWlnaHRzKCklM0ElMEElMjAlMjAlMjAlMjBlbXB0eV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWVtcHR5X21vZGVsLnRpZV93ZWlnaHRzKCklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBsb2FkX3F1YW50aXplZF9tb2RlbChlbXB0eV9tb2RlbCUyQyUyMHNhdmVfZm9sZGVyJTNEc2F2ZV9mb2xkZXIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGRpc2FibGVfZXhsbGFtYSUzREZhbHNlJTJDJTIwZGlzYWJsZV9leGxsYW1hdjIlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.gptq <span class="hljs-keyword">import</span> GPTQQuantizer, load_quantized_model
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = AutoModelForCausalLM.from_pretrained(model_name, torch_dtype=torch.float16)
empty_model.tie_weights()
quantized_model = load_quantized_model(empty_model, save_folder=save_folder, device_map=<span class="hljs-string">&quot;auto&quot;</span>, disable_exllama=<span class="hljs-literal">False</span>, disable_exllamav2=<span class="hljs-literal">True</span>)`,wrap:!1}}),A=new M({props:{title:"Fine-tune a quantized model",local:"fine-tune-a-quantized-model",headingTag:"h4"}}),{c(){r=i("meta"),b=n(),w=i("p"),O=n(),m(_.$$.fragment),ee=n(),m($.$$.fragment),te=n(),g=i("p"),g.innerHTML=Re,le=n(),v=i("p"),v.innerHTML=Xe,ae=n(),T=i("p"),T.textContent=Ce,ne=n(),k=i("ul"),k.innerHTML=We,oe=n(),Z=i("p"),Z.textContent=Ue,ie=n(),m(q.$$.fragment),se=n(),z=i("p"),z.textContent=xe,de=n(),j=i("ul"),j.innerHTML=Je,re=n(),m(G.$$.fragment),me=n(),F=i("p"),F.innerHTML=Qe,pe=n(),R=i("ul"),R.innerHTML=He,ue=n(),X=i("p"),X.innerHTML=Ve,he=n(),m(C.$$.fragment),fe=n(),m(y.$$.fragment),ce=n(),m(W.$$.fragment),be=n(),U=i("p"),U.innerHTML=Ee,ye=n(),m(x.$$.fragment),Me=n(),m(J.$$.fragment),we=n(),Q=i("p"),Q.innerHTML=Be,_e=n(),m(H.$$.fragment),$e=n(),m(V.$$.fragment),ge=n(),E=i("p"),E.innerHTML=Pe,ve=n(),m(B.$$.fragment),Te=n(),P=i("p"),P.textContent=Ie,ke=n(),m(I.$$.fragment),Ze=n(),L=i("p"),L.textContent=Le,qe=n(),Y=i("p"),Y.innerHTML=Ye,ze=n(),m(A.$$.fragment),je=n(),N=i("p"),N.innerHTML=Ae,Ge=n(),S=i("p"),this.h()},l(e){const t=lt("svelte-u9bgzb",document.head);r=s(t,"META",{name:!0,content:!0}),t.forEach(l),b=o(e),w=s(e,"P",{}),Se(w).forEach(l),O=o(e),p(_.$$.fragment,e),ee=o(e),p($.$$.fragment,e),te=o(e),g=s(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-ugzxpc"&&(g.innerHTML=Re),le=o(e),v=s(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-1uwtkai"&&(v.innerHTML=Xe),ae=o(e),T=s(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1ruo6q2"&&(T.textContent=Ce),ne=o(e),k=s(e,"UL",{"data-svelte-h":!0}),d(k)!=="svelte-kq5zxq"&&(k.innerHTML=We),oe=o(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1p4dqk2"&&(Z.textContent=Ue),ie=o(e),p(q.$$.fragment,e),se=o(e),z=s(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-3chw6d"&&(z.textContent=xe),de=o(e),j=s(e,"UL",{"data-svelte-h":!0}),d(j)!=="svelte-bd9wx0"&&(j.innerHTML=Je),re=o(e),p(G.$$.fragment,e),me=o(e),F=s(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-1mwd8qr"&&(F.innerHTML=Qe),pe=o(e),R=s(e,"UL",{"data-svelte-h":!0}),d(R)!=="svelte-1gnh4h2"&&(R.innerHTML=He),ue=o(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1palewv"&&(X.innerHTML=Ve),he=o(e),p(C.$$.fragment,e),fe=o(e),p(y.$$.fragment,e),ce=o(e),p(W.$$.fragment,e),be=o(e),U=s(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-o4ss2s"&&(U.innerHTML=Ee),ye=o(e),p(x.$$.fragment,e),Me=o(e),p(J.$$.fragment,e),we=o(e),Q=s(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1x9uzwt"&&(Q.innerHTML=Be),_e=o(e),p(H.$$.fragment,e),$e=o(e),p(V.$$.fragment,e),ge=o(e),E=s(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-hn1iyi"&&(E.innerHTML=Pe),ve=o(e),p(B.$$.fragment,e),Te=o(e),P=s(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-1thk57v"&&(P.textContent=Ie),ke=o(e),p(I.$$.fragment,e),Ze=o(e),L=s(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-14wl4xl"&&(L.textContent=Le),qe=o(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-fpw9ll"&&(Y.innerHTML=Ye),ze=o(e),p(A.$$.fragment,e),je=o(e),N=s(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1rghhrt"&&(N.innerHTML=Ae),Ge=o(e),S=s(e,"P",{}),Se(S).forEach(l),this.h()},h(){De(r,"name","hf:doc:metadata"),De(r,"content",rt)},m(e,t){at(document.head,r),a(e,b,t),a(e,w,t),a(e,O,t),u(_,e,t),a(e,ee,t),u($,e,t),a(e,te,t),a(e,g,t),a(e,le,t),a(e,v,t),a(e,ae,t),a(e,T,t),a(e,ne,t),a(e,k,t),a(e,oe,t),a(e,Z,t),a(e,ie,t),u(q,e,t),a(e,se,t),a(e,z,t),a(e,de,t),a(e,j,t),a(e,re,t),u(G,e,t),a(e,me,t),a(e,F,t),a(e,pe,t),a(e,R,t),a(e,ue,t),a(e,X,t),a(e,he,t),u(C,e,t),a(e,fe,t),u(y,e,t),a(e,ce,t),u(W,e,t),a(e,be,t),a(e,U,t),a(e,ye,t),u(x,e,t),a(e,Me,t),u(J,e,t),a(e,we,t),a(e,Q,t),a(e,_e,t),u(H,e,t),a(e,$e,t),u(V,e,t),a(e,ge,t),a(e,E,t),a(e,ve,t),u(B,e,t),a(e,Te,t),a(e,P,t),a(e,ke,t),u(I,e,t),a(e,Ze,t),a(e,L,t),a(e,qe,t),a(e,Y,t),a(e,ze,t),u(A,e,t),a(e,je,t),a(e,N,t),a(e,Ge,t),a(e,S,t),Fe=!0},p(e,[t]){const Ne={};t&2&&(Ne.$$scope={dirty:t,ctx:e}),y.$set(Ne)},i(e){Fe||(h(_.$$.fragment,e),h($.$$.fragment,e),h(q.$$.fragment,e),h(G.$$.fragment,e),h(C.$$.fragment,e),h(y.$$.fragment,e),h(W.$$.fragment,e),h(x.$$.fragment,e),h(J.$$.fragment,e),h(H.$$.fragment,e),h(V.$$.fragment,e),h(B.$$.fragment,e),h(I.$$.fragment,e),h(A.$$.fragment,e),Fe=!0)},o(e){f(_.$$.fragment,e),f($.$$.fragment,e),f(q.$$.fragment,e),f(G.$$.fragment,e),f(C.$$.fragment,e),f(y.$$.fragment,e),f(W.$$.fragment,e),f(x.$$.fragment,e),f(J.$$.fragment,e),f(H.$$.fragment,e),f(V.$$.fragment,e),f(B.$$.fragment,e),f(I.$$.fragment,e),f(A.$$.fragment,e),Fe=!1},d(e){e&&(l(b),l(w),l(O),l(ee),l(te),l(g),l(le),l(v),l(ae),l(T),l(ne),l(k),l(oe),l(Z),l(ie),l(se),l(z),l(de),l(j),l(re),l(me),l(F),l(pe),l(R),l(ue),l(X),l(he),l(fe),l(ce),l(be),l(U),l(ye),l(Me),l(we),l(Q),l(_e),l($e),l(ge),l(E),l(ve),l(Te),l(P),l(ke),l(Ze),l(L),l(qe),l(Y),l(ze),l(je),l(N),l(Ge),l(S)),l(r),c(_,e),c($,e),c(q,e),c(G,e),c(C,e),c(y,e),c(W,e),c(x,e),c(J,e),c(H,e),c(V,e),c(B,e),c(I,e),c(A,e)}}}const rt='{"title":"Quantization","local":"quantization","sections":[{"title":"AutoGPTQ Integration","local":"autogptq-integration","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":3},{"title":"Load and quantize a model","local":"load-and-quantize-a-model","sections":[],"depth":3},{"title":"Save the model","local":"save-the-model","sections":[],"depth":3},{"title":"Load quantized weights","local":"load-quantized-weights","sections":[],"depth":3},{"title":"Exllama kernels for faster inference","local":"exllama-kernels-for-faster-inference","sections":[{"title":"Fine-tune a quantized model","local":"fine-tune-a-quantized-model","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function mt(K){return Oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bt extends et{constructor(r){super(),tt(this,r,mt,dt,Ke,{})}}export{bt as component};
