import{s as Uc,o as Ic,n as j}from"../chunks/scheduler.6062bdaf.js";import{S as Zc,i as Cc,g as m,s as a,r as g,A as Wc,h as d,f as i,c as l,j as x,u as f,x as T,k as $,y as o,a as c,v as h,d as _,t as b,w as y}from"../chunks/index.4bca734e.js";import{T as C}from"../chunks/Tip.b9ac1f03.js";import{D as k}from"../chunks/Docstring.ed07512f.js";import{C as U}from"../chunks/CodeBlock.fa01571c.js";import{E as J}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as R}from"../chunks/Heading.723dceba.js";function Nc(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Sc(v){let n,M="Example of text generation:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwQXJ0aHVyJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBZ2VuX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDZG9fc2FtcGxlJTNEVHJ1ZSUyQ3RlbXBlcmF0dXJlJTNEMC45JTJDJTIwbWluX2xlbmd0aCUzRDIwJTJDbWF4X2xlbmd0aCUzRDIwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs,do_sample=<span class="hljs-literal">True</span>,temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>,max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Fc(v){let n,M="Example using <code>transformers.pipelines</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBb25ueF9nZW4lMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEFydGh1ciUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjIlMEFnZW4lMjAlM0QlMjBvbm54X2dlbih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_gen = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = onnx_gen(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Gc(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Xc(v){let n,M="Example of feature extraction:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">28996</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12vwt80"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Oc(v){let n,M="Example using <code>transformers.pipeline</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JNYXNrZWRMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZSglMjJmaWxsLW1hc2slMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMCU1Qk1BU0slNUQuJTIyJTBBcHJlZCUyMCUzRCUyMGZpbGxfbWFza2VyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = fill_masker(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Vc(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function zc(v){let n,M="Example of text generation:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ0NS1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTXklMjBuYW1lJTIwaXMlMjBFdXN0YWNoZSUyMGFuZCUyMEklMjBsaWtlJTIwdG8lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Eustache and I like to&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function qc(v){let n,M="Example using <code>transformers.pipeline</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19kZSUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwRXVzdGFjaGUuJTIyJTBBcHJlZCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_de&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Eustache.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_translation(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Bc(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Lc(v){let n,M="Example of single-label classification:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-ykxpe4"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Hc(v){let n,M="Example using <code>transformers.pipelines</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBb25ueF9jbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9jbGFzc2lmaWVyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_classifier(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Ec(v){let n,M="Example using zero-shot-classification <code>transformers.pipelines</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLW1ubGklMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQW9ubnhfejAlMjAlM0QlMjBwaXBlbGluZSglMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXNlcXVlbmNlX3RvX2NsYXNzaWZ5JTIwJTNEJTIwJTIyV2hvJTIwYXJlJTIweW91JTIwdm90aW5nJTIwZm9yJTIwaW4lMjAyMDIwJTNGJTIyJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMkV1cm9wZSUyMiUyQyUyMCUyMnB1YmxpYyUyMGhlYWx0aCUyMiUyQyUyMCUyMnBvbGl0aWNzJTIyJTJDJTIwJTIyZWxlY3Rpb25zJTIyJTVEJTBBcHJlZCUyMCUzRCUyMG9ubnhfejAoc2VxdWVuY2VfdG9fY2xhc3NpZnklMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_z0 = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_to_classify = <span class="hljs-string">&quot;Who are you voting for in 2020?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;Europe&quot;</span>, <span class="hljs-string">&quot;public health&quot;</span>, <span class="hljs-string">&quot;politics&quot;</span>, <span class="hljs-string">&quot;elections&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_z0(sequence_to_classify, candidate_labels, multi_label=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1vtj8d2"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Pc(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Qc(v){let n,M="Example of token classification:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-rtgw80"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Dc(v){let n,M="Example using <code>transformers.pipelines</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQW9ubnhfbmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9uZXIodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ner = pipeline(<span class="hljs-string">&quot;token-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ner(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1da1qsq"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Yc(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Ac(v){let n,M="Example of mutliple choice:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlaGR3bnMxNTE2JTJGYmVydC1iYXNlLXVuY2FzZWRfU1dBRyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmVoZHduczE1MTYlMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFudW1fY2hvaWNlcyUyMCUzRCUyMDQlMEFmaXJzdF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUyMk1lbWJlcnMlMjBvZiUyMHRoZSUyMHByb2Nlc3Npb24lMjB3YWxrJTIwZG93biUyMHRoZSUyMHN0cmVldCUyMGhvbGRpbmclMjBzbWFsbCUyMGhvcm4lMjBicmFzcyUyMGluc3RydW1lbnRzLiUyMiU1RCUyMColMjBudW1fY2hvaWNlcyUwQXNlY29uZF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHBhc3NlcyUyMGJ5JTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBwbGF5aW5nJTIwdGhlaXIlMjBpbnN0cnVtZW50cy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBoYXMlMjBoZWFyZCUyMGFwcHJvYWNoaW5nJTIwdGhlbS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBhcnJpdmVzJTIwYW5kJTIwdGhleSdyZSUyMG91dHNpZGUlMjBkYW5jaW5nJTIwYW5kJTIwYXNsZWVwLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHR1cm5zJTIwdGhlJTIwbGVhZCUyMHNpbmdlciUyMHdhdGNoZXMlMjB0aGUlMjBwZXJmb3JtYW5jZS4lMjIlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZmlyc3Rfc2VudGVuY2UlMkMlMjBzZWNvbmRfc2VudGVuY2UlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QmslNUQlMjAlM0QlMjAlNUJ2JTVCaSUzQSUyMGklMjAlMkIlMjBudW1fY2hvaWNlcyU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4odiklMkMlMjBudW1fY2hvaWNlcyklNUQlMEFpbnB1dHMlMjAlM0QlMjBkaWN0KGlucHV0cy5jb252ZXJ0X3RvX3RlbnNvcnModGVuc29yX3R5cGUlM0QlMjJwdCUyMikpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-lfckvi"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Kc(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function eu(v){let n,M="Example of question answering:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEc3RhcnRfcG9zaXRpb25zJTJDJTIwZW5kX3Bvc2l0aW9ucyUzRGVuZF9wb3NpdGlvbnMpJTBBc3RhcnRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMlMEFlbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">3</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1ml1brl"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function tu(v){let n,M="Example using <code>transformers.pipeline</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question, text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function nu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function ou(v){let n,M="Example of image classification:",r,s,u;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1nh3zco"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function su(v){let n,M="Example using <code>transformers.pipeline</code>:",r,s,u;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW9ubnhfaW1hZ2VfY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9jbGFzc2lmaWVyKHVybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_classifier = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_classifier(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function au(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function lu(v){let n,M="Example of semantic segmentation:",r,s,u;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1wzzaup"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function ru(v){let n,M="Example using <code>transformers.pipeline</code>:",r,s,u;return s=new U({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW9ubnhfaW1hZ2Vfc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9zZWdtZW50ZXIodXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_segmenter(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function iu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function pu(v){let n,M="Example of audio classification:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1mp8f15"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function mu(v){let n,M="Example using <code>transformers.pipeline</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZodWJlcnQtYmFzZS1zdXBlcmIta3MlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW9ubnhfYWMlMjAlM0QlMjBwaXBlbGluZSglMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yKSUwQSUwQXByZWQlMjAlM0QlMjBvbm54X2FjKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ac = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model, feature_extractor=feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ac(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function du(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function cu(v){let n,M="Example of audio frame classification:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME9SVE1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  ORTModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12boqdm"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function uu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function gu(v){let n,M="Example of CTC:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCTC.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-mdyxnj"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function fu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function hu(v){let n,M="Example of text generation:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTNEaW5wdXRzLmlucHV0X2ZlYXR1cmVzKSUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(inputs=inputs.input_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function _u(v){let n,M="Example using <code>transformers.pipeline</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFzcGVlY2hfcmVjb2duaXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciklMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBcHJlZCUyMCUzRCUyMHNwZWVjaF9yZWNvZ25pdGlvbihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>speech_recognition = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, tokenizer=processor.tokenizer, feature_extractor=processor.feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = speech_recognition(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function bu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function yu(v){let n,M="Example of Audio XVector:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvWFZlY3RvciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zdiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1kzdm5c"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Tu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Mu(v){let n,M="Example of text generation:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIybmxwY29ubmVjdCUyRnZpdC1ncHQyLWltYWdlLWNhcHRpb25pbmclMjIlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1bvu0cy"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function wu(v){let n,M="Example using <code>transformers.pipeline</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3RvX3RleHQlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS10by10ZXh0JTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJvY2Vzc29yJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTNEcHJvY2Vzc29yKSUwQXByZWQlMjAlM0QlMjBpbWFnZV90b190ZXh0KGltYWdlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=model, tokenizer=tokenizer, feature_extractor=processor, image_processor=processor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = image_to_text(image)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function vu(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function xu(v){let n,M="Example of pix2struct:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUGl4MlN0cnVjdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcGl4MnN0cnVjdC1haTJkLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclBpeDJTdHJ1Y3QuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBpeDJzdHJ1Y3QtYWkyZC1iYXNlJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHVzZV9pb19iaW5kaW5nJTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmFpMmQtZGVtby5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwbGFiZWwlMjAxNSUyMHJlcHJlc2VudCUzRiUyMCgxKSUyMGxhdmElMjAoMiklMjBjb3JlJTIwKDMpJTIwdHVubmVsJTIwKDQpJTIwYXNoJTIwY2xvdWQlMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForPix2Struct
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForPix2Struct.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/ai2d-demo.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What does the label 15 represent? (1) lava (2) core (3) tunnel (4) ash cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-11ikyn3"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function $u(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function ku(v){let n,M="Example of custom tasks(e.g. a sentence transformers taking <code>pooler_output</code> as output):",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2JlcnQtYWxsLU1pbmlMTS1MNi13aXRoLXBvb2xlciUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlcl9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I love burritos!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooler_output = outputs.pooler_output`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-6kynse"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function ju(v){let n,M="Example using <code>transformers.pipelines</code>(only if the task is supported):",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNiZXJ0LWFsbC1NaW5pTE0tTDYtd2l0aC1wb29sZXIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUwQXByZWQlMjAlM0QlMjBvbm54X2V4dHJhY3Rvcih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I love burritos!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-xxeb0k"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Ju(v){let n,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=M},l(r){n=d(r,"P",{"data-svelte-h":!0}),T(n)!=="svelte-fincs2"&&(n.innerHTML=M)},m(r,s){c(r,n,s)},p:j,d(r){r&&i(n)}}}function Ru(v){let n,M="Example of feature extraction:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBHZXJtYW55LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGUuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-12vwt80"&&(n.textContent=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Uu(v){let n,M="Example using <code>transformers.pipeline</code>:",r,s,u;return s=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9leHRyYWN0b3IodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=M,r=a(),g(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),T(n)!=="svelte-1u1xsxh"&&(n.innerHTML=M),r=l(t),f(s.$$.fragment,t)},m(t,w){c(t,n,w),c(t,r,w),h(s,t,w),u=!0},p:j,i(t){u||(_(s.$$.fragment,t),u=!0)},o(t){b(s.$$.fragment,t),u=!1},d(t){t&&(i(n),i(r)),y(s,t)}}}function Iu(v){let n,M,r,s,u,t,w,tl,fn,Rm="The following ORT classes are available for instantiating a base model class without a specific head.",nl,hn,ol,I,_n,mr,as,Um="Base class for implementing models using ONNX Runtime.",dr,ls,Im=`The ORTModel implements generic methods for interacting with the Hugging Face Hub as well as exporting vanilla
transformers models to ONNX using <code>optimum.exporters.onnx</code> toolchain.`,cr,rs,Zm="Class attributes:",ur,is,Cm=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;onnx_model&quot;</code>) — The name of the model type to use when
registering the ORTModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The “AutoModel” class to represented by the
current ORTModel class.</li>`,gr,ps,Wm="Common attributes:",fr,ms,Nm=`<li>model (<code>ort.InferenceSession</code>) — The ONNX Runtime InferenceSession that is running the model.</li> <li>config (<a href="https://huggingface.co/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> — The configuration of the model.</li> <li>use_io_binding (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) — Whether to use I/O bindings with <strong>ONNX Runtime
with the CUDAExecutionProvider</strong>, this can significantly speedup inference depending on the task.</li> <li>model_save_dir (<code>Path</code>) — The directory where the model exported to ONNX is saved.
By defaults, if the loaded model is local, the directory where the original model will be used. Otherwise, the
cache directory is used.</li> <li>providers (\`List[str]) — The list of execution providers available to ONNX Runtime.</li>`,hr,it,bn,_r,ds,Sm="Instantiate a pretrained model from a pre-trained model configuration.",br,pt,yn,yr,cs,Fm=`Loads an ONNX Inference session with a given provider. Default provider is <code>CPUExecutionProvider</code> to match the
default behaviour in PyTorch/TensorFlow/JAX.`,Tr,mt,Tn,Mr,us,Gm="Raises an error if IO Binding is requested although the tensor used are numpy arrays.",wr,dt,Mn,vr,gs,Xm="Initializes attributes that may be shared among several ONNX Runtime inference sesssions.",xr,ct,wn,$r,fs,Om="Changes the ONNX Runtime provider according to the device.",sl,vn,al,xn,Vm="The following ORT classes are available for the following natural language processing tasks.",ll,$n,rl,N,kn,kr,hs,zm="ONNX model with a causal language modeling head for ONNX Runtime inference. This class officially supports bloom, codegen, falcon, gpt2, gpt_bigcode, gpt_neo, gpt_neox, gptj, llama.",jr,_s,qm=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Jr,bs,Bm='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Rr,ae,jn,Ur,ys,Lm="The <code>ORTModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method.",Ir,ut,Zr,gt,Cr,ft,il,Jn,pl,S,Rn,Wr,Ts,Hm="ONNX Model with a MaskedLMOutput for masked language modeling tasks. This class officially supports albert, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.",Nr,Ms,Em=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Sr,ws,Pm='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Fr,le,Un,Gr,vs,Qm="The <code>ORTModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method.",Xr,ht,Or,_t,Vr,bt,ml,In,dl,F,Zn,zr,xs,Dm="Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports bart, blenderbot, blenderbot_small, longt5, m2m_100, marian, mbart, mt5, pegasus, t5.",qr,$s,Ym=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Br,ks,Am='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Lr,re,Cn,Hr,js,Km="The <code>ORTModelForSeq2SeqLM</code> forward method, overrides the <code>__call__</code> special method.",Er,yt,Pr,Tt,Qr,Mt,cl,Wn,ul,G,Nn,Dr,Js,ed=`ONNX Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks. This class officially supports albert, bart, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Yr,Rs,td=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ar,Us,nd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Kr,W,Sn,ei,Is,od="The <code>ORTModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method.",ti,wt,ni,vt,oi,xt,si,$t,gl,Fn,fl,X,Gn,ai,Zs,sd=`ONNX Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks. This class officially supports albert, bert, bloom, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, gpt2, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.`,li,Cs,ad=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ri,Ws,ld='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ii,ie,Xn,pi,Ns,rd="The <code>ORTModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method.",mi,kt,di,jt,ci,Jt,hl,On,_l,O,Vn,ui,Ss,id=`ONNX Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks. This class officially supports albert, bert, camembert, convbert, data2vec_text, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,gi,Fs,pd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,fi,Gs,md='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',hi,Ye,zn,_i,Xs,dd="The <code>ORTModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method.",bi,Rt,yi,Ut,bl,qn,yl,V,Bn,Ti,Os,cd="ONNX Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD. This class officially supports albert, bart, bert, camembert, convbert, data2vec_text, deberta, deberta_v2, distilbert, electra, flaubert, gptj, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.",Mi,Vs,ud=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,wi,zs,gd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',vi,pe,Ln,xi,qs,fd="The <code>ORTModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method.",$i,It,ki,Zt,ji,Ct,Tl,Hn,Ml,En,hd="The following ORT classes are available for the following computer vision tasks.",wl,Pn,vl,z,Qn,Ji,Bs,_d="ONNX Model for image-classification tasks. This class officially supports beit, convnext, data2vec_vision, deit, levit, mobilenet_v1, mobilenet_v2, mobilevit, poolformer, resnet, segformer, swin, vit.",Ri,Ls,bd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ui,Hs,yd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ii,me,Dn,Zi,Es,Td="The <code>ORTModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method.",Ci,Wt,Wi,Nt,Ni,St,xl,Yn,$l,q,An,Si,Ps,Md="ONNX Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports segformer.",Fi,Qs,wd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Gi,Ds,vd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Xi,de,Kn,Oi,Ys,xd="The <code>ORTModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method.",Vi,Ft,zi,Gt,qi,Xt,kl,eo,jl,to,$d="The following ORT classes are available for the following audio tasks.",Jl,no,Rl,B,oo,Bi,As,kd=`ONNX Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting. This class officially supports audio_spectrogram_transformer, data2vec_audio, hubert, sew, sew_d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.`,Li,Ks,jd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Hi,ea,Jd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Ei,ce,so,Pi,ta,Rd="The <code>ORTModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method.",Qi,Ot,Di,Vt,Yi,zt,Ul,ao,Il,L,lo,Ai,na,Ud="ONNX Model with a frame classification head on top for tasks like Speaker Diarization. This class officially supports data2vec_audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",Ki,oa,Id=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ep,sa,Zd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',tp,Ae,ro,np,aa,Cd="The <code>ORTModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method.",op,qt,sp,Bt,Zl,io,Cl,H,po,ap,la,Wd="ONNX Model with a language modeling head on top for Connectionist Temporal Classification (CTC). This class officially supports data2vec_audio, hubert, sew, sew_d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",lp,ra,Nd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,rp,ia,Sd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ip,Ke,mo,pp,pa,Fd="The <code>ORTModelForCTC</code> forward method, overrides the <code>__call__</code> special method.",mp,Lt,dp,Ht,Wl,co,Nl,E,uo,cp,ma,Gd="Speech Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports whisper, speech_to_text.",up,da,Xd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,gp,ca,Od='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',fp,ue,go,hp,ua,Vd="The <code>ORTModelForSpeechSeq2Seq</code> forward method, overrides the <code>__call__</code> special method.",_p,Et,bp,Pt,yp,Qt,Sl,fo,Fl,P,ho,Tp,ga,zd="ONNX Model with an XVector feature extraction head on top for tasks like Speaker Verification. This class officially supports data2vec_audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",Mp,fa,qd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,wp,ha,Bd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',vp,et,_o,xp,_a,Ld="The <code>ORTModelForAudioXVector</code> forward method, overrides the <code>__call__</code> special method.",$p,Dt,kp,Yt,Gl,bo,Xl,yo,Hd="The following ORT classes are available for the following multimodal tasks.",Ol,To,Vl,Q,Mo,jp,ba,Ed="VisionEncoderDecoder Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports trocr and vision-encoder-decoder.",Jp,ya,Pd=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Rp,Ta,Qd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Up,ge,wo,Ip,Ma,Dd="The <code>ORTModelForVision2Seq</code> forward method, overrides the <code>__call__</code> special method.",Zp,At,Cp,Kt,Wp,en,zl,vo,ql,D,xo,Np,wa,Yd="Pix2struct model with a language modeling head for ONNX Runtime inference. This class officially supports pix2struct.",Sp,va,Ad=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Fp,xa,Kd='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Gp,tt,$o,Xp,$a,ec="The <code>ORTModelForPix2Struct</code> forward method, overrides the <code>__call__</code> special method.",Op,tn,Vp,nn,Bl,ko,Ll,jo,tc="The following ORT classes are available for the following custom tasks.",Hl,Jo,El,Y,Ro,zp,ka,nc="ONNX Model for any custom tasks. It can be used to leverage the inference acceleration for any single-file ONNX model, that may use custom inputs and outputs.",qp,ja,oc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Bp,Ja,sc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Lp,fe,Uo,Hp,Ra,ac="The <code>ORTModelForCustomTasks</code> forward method, overrides the <code>__call__</code> special method.",Ep,on,Pp,sn,Qp,an,Pl,Io,Ql,A,Zo,Dp,Ua,lc="ONNX Model for feature-extraction task.",Yp,Ia,rc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ap,Za,ic='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Kp,he,Co,em,Ca,pc="The <code>ORTModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method.",tm,ln,nm,rn,om,pn,Dl,Wo,Yl,No,Al,K,So,sm,Wa,mc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline" rel="nofollow">diffusers.StableDiffusionPipeline</a>.',am,Na,dc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,lm,Sa,cc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',rm,mn,Fo,im,Fa,uc="Function invoked when calling the pipeline for generation.",Kl,Go,er,ee,Xo,pm,Ga,gc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionImg2ImgPipeline</a>.',mm,Xa,fc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,dm,Oa,hc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',cm,dn,Oo,um,Va,_c="Function invoked when calling the pipeline for generation.",tr,Vo,nr,te,zo,gm,za,bc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline" rel="nofollow">diffusers.StableDiffusionInpaintPipeline</a>.',fm,qa,yc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,hm,Ba,Tc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',_m,cn,qo,bm,La,Mc="Function invoked when calling the pipeline for generation.",or,Bo,sr,ne,Lo,ym,Ha,wc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline" rel="nofollow">diffusers.StableDiffusionXLPipeline</a>.',Tm,Ea,vc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Mm,Pa,xc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',wm,un,Ho,vm,Qa,$c="Function invoked when calling the pipeline for generation.",ar,Eo,lr,oe,Po,xm,Da,kc='ONNX Runtime-powered stable diffusion pipeline corresponding to <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLImg2ImgPipeline" rel="nofollow">diffusers.StableDiffusionXLImg2ImgPipeline</a>.',$m,Ya,jc=`This model inherits from <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,km,Aa,Jc='This class should be initialized using the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',jm,gn,Qo,Jm,Ka,Rc="Function invoked when calling the pipeline for generation.",rr,el,ir;return u=new R({props:{title:"Models",local:"models",headingTag:"h1"}}),w=new R({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),hn=new R({props:{title:"ORTModel",local:"optimum.onnxruntime.ORTModel",headingTag:"h3"}}),_n=new k({props:{name:"class optimum.onnxruntime.ORTModel",anchor:"optimum.onnxruntime.ORTModel",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L138"}}),bn=new k({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTModel.from_pretrained",parameters:[{name:"model_id",val:": typing.Union[str, pathlib.Path]"},{name:"export",val:": bool = False"},{name:"force_download",val:": bool = False"},{name:"use_auth_token",val:": typing.Optional[str] = None"},{name:"cache_dir",val:": typing.Optional[str] = None"},{name:"subfolder",val:": str = ''"},{name:"config",val:": typing.Optional[ForwardRef('PretrainedConfig')] = None"},{name:"local_files_only",val:": bool = False"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"provider_options",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.model_id",description:`<strong>model_id</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a model saved using <code>~OptimizedModel.save_pretrained</code>,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"model_id"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.from_transformers",description:`<strong>from_transformers</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Defines whether the provided <code>model_id</code> contains a vanilla Transformers checkpoint.`,name:"from_transformers"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>transformers-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"use_auth_token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo either locally or on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.config",description:`<strong>config</strong> (<code>Optional[transformers.PretrainedConfig]</code>, defaults to <code>None</code>) &#x2014;
The model configuration.`,name:"config"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>Optional[bool]</code>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling. This option should only be set
to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code present on
the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model. See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a> for
possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>), &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionaries corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_io_binding",description:`<strong>use_io_binding</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
Whether to use IOBinding during inference to avoid memory copy between the host and device, or between numpy/torch tensors and ONNX Runtime ORTValue. Defaults to
<code>True</code> if the execution provider is CUDAExecutionProvider. For [~onnxruntime.ORTModelForCausalLM], defaults to <code>True</code> on CPUExecutionProvider,
in all other cases defaults to <code>False</code>.`,name:"use_io_binding"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Will be passed to the underlying model loading methods.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L573",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded ORTModel model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`,parameterGroups:[{title:"Parameters for decoder models (ORTModelForCausalLM, ORTModelForSeq2SeqLM, ORTModelForSeq2SeqLM, ORTModelForSpeechSeq2Seq, ORTModelForVision2Seq)",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_cache",description:`<strong>use_cache</strong> (<code>Optional[bool]</code>, defaults to <code>True</code>) &#x2014;
Whether or not past key/values cache should be used. Defaults to <code>True</code>.`,name:"use_cache"}]},{title:"Parameters for ORTModelForCausalLM",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_merged",description:`<strong>use_merged</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
whether or not to use a single ONNX that handles both the decoding without and with past key values reuse. This option defaults
to <code>True</code> if loading from a local repository and a merged decoder is found. When exporting with <code>export=True</code>,
defaults to <code>False</code>. This option should be set to <code>True</code> to minimize memory usage.`,name:"use_merged"}]}]}}),yn=new k({props:{name:"load_model",anchor:"optimum.onnxruntime.ORTModel.load_model",parameters:[{name:"path",val:": typing.Union[str, pathlib.Path]"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"provider_options",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.load_model.path",description:`<strong>path</strong> (<code>Union[str, Path]</code>) &#x2014;
Path of the ONNX model.`,name:"path"},{anchor:"optimum.onnxruntime.ORTModel.load_model.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model. See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a>
for possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.load_model.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>) &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.load_model.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionary corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L330"}}),Tn=new k({props:{name:"raise_on_numpy_input_io_binding",anchor:"optimum.onnxruntime.ORTModel.raise_on_numpy_input_io_binding",parameters:[{name:"use_torch",val:": bool"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.raise_on_numpy_input_io_binding.use_torch",description:`<strong>use_torch</strong> (<code>bool</code>) &#x2014;
Whether the tensor used during inference are of type torch.Tensor or not.`,name:"use_torch"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L792"}}),Mn=new k({props:{name:"shared_attributes_init",anchor:"optimum.onnxruntime.ORTModel.shared_attributes_init",parameters:[{name:"model",val:": InferenceSession"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L181"}}),wn=new k({props:{name:"to",anchor:"optimum.onnxruntime.ORTModel.to",parameters:[{name:"device",val:": typing.Union[torch.device, str, int]"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.to.device",description:`<strong>device</strong> (<code>torch.device</code> or <code>str</code> or <code>int</code>) &#x2014;
Device ordinal for CPU/GPU supports. Setting this to -1 will leverage CPU, a positive will run
the model on the associated CUDA device id. You can pass native <code>torch.device</code> or a <code>str</code> too.`,name:"device"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L294",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the model placed on the requested device.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`}}),vn=new R({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),$n=new R({props:{title:"ORTModelForCausalLM",local:"optimum.onnxruntime.ORTModelForCausalLM",headingTag:"h3"}}),kn=new k({props:{name:"class optimum.onnxruntime.ORTModelForCausalLM",anchor:"optimum.onnxruntime.ORTModelForCausalLM",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_decoder.py#L115"}}),jn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache_branch",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_decoder.py#L179"}}),ut=new C({props:{$$slots:{default:[Nc]},$$scope:{ctx:v}}}),gt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example",$$slots:{default:[Sc]},$$scope:{ctx:v}}}),ft=new J({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example-2",$$slots:{default:[Fc]},$$scope:{ctx:v}}}),Jn=new R({props:{title:"ORTModelForMaskedLM",local:"optimum.onnxruntime.ORTModelForMaskedLM",headingTag:"h3"}}),Rn=new k({props:{name:"class optimum.onnxruntime.ORTModelForMaskedLM",anchor:"optimum.onnxruntime.ORTModelForMaskedLM",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1000"}}),Un=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1007"}}),ht=new C({props:{$$slots:{default:[Gc]},$$scope:{ctx:v}}}),_t=new J({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example",$$slots:{default:[Xc]},$$scope:{ctx:v}}}),bt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example-2",$$slots:{default:[Oc]},$$scope:{ctx:v}}}),In=new R({props:{title:"ORTModelForSeq2SeqLM",local:"optimum.onnxruntime.ORTModelForSeq2SeqLM",headingTag:"h3"}}),Zn=new k({props:{name:"class optimum.onnxruntime.ORTModelForSeq2SeqLM",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1119"}}),Cn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of input sequence tokens in the vocabulary of shape <code>(batch_size, encoder_sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, encoder_sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1173"}}),yt=new C({props:{$$slots:{default:[Vc]},$$scope:{ctx:v}}}),Tt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example",$$slots:{default:[zc]},$$scope:{ctx:v}}}),Mt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example-2",$$slots:{default:[qc]},$$scope:{ctx:v}}}),Wn=new R({props:{title:"ORTModelForSequenceClassification",local:"optimum.onnxruntime.ORTModelForSequenceClassification",headingTag:"h3"}}),Nn=new k({props:{name:"class optimum.onnxruntime.ORTModelForSequenceClassification",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1225"}}),Sn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1233"}}),wt=new C({props:{$$slots:{default:[Bc]},$$scope:{ctx:v}}}),vt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example",$$slots:{default:[Lc]},$$scope:{ctx:v}}}),xt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-2",$$slots:{default:[Hc]},$$scope:{ctx:v}}}),$t=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-3",$$slots:{default:[Ec]},$$scope:{ctx:v}}}),Fn=new R({props:{title:"ORTModelForTokenClassification",local:"optimum.onnxruntime.ORTModelForTokenClassification",headingTag:"h3"}}),Gn=new k({props:{name:"class optimum.onnxruntime.ORTModelForTokenClassification",anchor:"optimum.onnxruntime.ORTModelForTokenClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1326"}}),Xn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1335"}}),kt=new C({props:{$$slots:{default:[Pc]},$$scope:{ctx:v}}}),jt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example",$$slots:{default:[Qc]},$$scope:{ctx:v}}}),Jt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example-2",$$slots:{default:[Dc]},$$scope:{ctx:v}}}),On=new R({props:{title:"ORTModelForMultipleChoice",local:"optimum.onnxruntime.ORTModelForMultipleChoice",headingTag:"h3"}}),Vn=new k({props:{name:"class optimum.onnxruntime.ORTModelForMultipleChoice",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1425"}}),zn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1433"}}),Rt=new C({props:{$$slots:{default:[Yc]},$$scope:{ctx:v}}}),Ut=new J({props:{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.example",$$slots:{default:[Ac]},$$scope:{ctx:v}}}),qn=new R({props:{title:"ORTModelForQuestionAnswering",local:"optimum.onnxruntime.ORTModelForQuestionAnswering",headingTag:"h3"}}),Bn=new k({props:{name:"class optimum.onnxruntime.ORTModelForQuestionAnswering",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1103"}}),Ln=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1110"}}),It=new C({props:{$$slots:{default:[Kc]},$$scope:{ctx:v}}}),Zt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example",$$slots:{default:[eu]},$$scope:{ctx:v}}}),Ct=new J({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example-2",$$slots:{default:[tu]},$$scope:{ctx:v}}}),Hn=new R({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),Pn=new R({props:{title:"ORTModelForImageClassification",local:"optimum.onnxruntime.ORTModelForImageClassification",headingTag:"h3"}}),Qn=new k({props:{name:"class optimum.onnxruntime.ORTModelForImageClassification",anchor:"optimum.onnxruntime.ORTModelForImageClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1531"}}),Dn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1538"}}),Wt=new C({props:{$$slots:{default:[nu]},$$scope:{ctx:v}}}),Nt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example",$$slots:{default:[ou]},$$scope:{ctx:v}}}),St=new J({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example-2",$$slots:{default:[su]},$$scope:{ctx:v}}}),Yn=new R({props:{title:"ORTModelForSemanticSegmentation",local:"optimum.onnxruntime.ORTModelForSemanticSegmentation",headingTag:"h3"}}),An=new k({props:{name:"class optimum.onnxruntime.ORTModelForSemanticSegmentation",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1625"}}),Kn=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1632"}}),Ft=new C({props:{$$slots:{default:[au]},$$scope:{ctx:v}}}),Gt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example",$$slots:{default:[lu]},$$scope:{ctx:v}}}),Xt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example-2",$$slots:{default:[ru]},$$scope:{ctx:v}}}),eo=new R({props:{title:"Audio",local:"audio",headingTag:"h2"}}),no=new R({props:{title:"ORTModelForAudioClassification",local:"optimum.onnxruntime.ORTModelForAudioClassification",headingTag:"h3"}}),oo=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioClassification",anchor:"optimum.onnxruntime.ORTModelForAudioClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1731"}}),so=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"attenton_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1739"}}),Ot=new C({props:{$$slots:{default:[iu]},$$scope:{ctx:v}}}),Vt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example",$$slots:{default:[pu]},$$scope:{ctx:v}}}),zt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example-2",$$slots:{default:[mu]},$$scope:{ctx:v}}}),ao=new R({props:{title:"ORTModelForAudioFrameClassification",local:"optimum.onnxruntime.ORTModelForAudioFrameClassification",headingTag:"h3"}}),lo=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioFrameClassification",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1989"}}),ro=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1996"}}),qt=new C({props:{$$slots:{default:[du]},$$scope:{ctx:v}}}),Bt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.example",$$slots:{default:[cu]},$$scope:{ctx:v}}}),io=new R({props:{title:"ORTModelForCTC",local:"optimum.onnxruntime.ORTModelForCTC",headingTag:"h3"}}),po=new k({props:{name:"class optimum.onnxruntime.ORTModelForCTC",anchor:"optimum.onnxruntime.ORTModelForCTC",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1817"}}),mo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCTC.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1824"}}),Lt=new C({props:{$$slots:{default:[uu]},$$scope:{ctx:v}}}),Ht=new J({props:{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.example",$$slots:{default:[gu]},$$scope:{ctx:v}}}),co=new R({props:{title:"ORTModelForSpeechSeq2Seq",local:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",headingTag:"h3"}}),uo=new k({props:{name:"class optimum.onnxruntime.ORTModelForSpeechSeq2Seq",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1270"}}),go=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward",parameters:[{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Mel features extracted from the raw speech waveform.
<code>(batch_size, feature_size, encoder_sequence_length)</code>.`,name:"input_features"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1312"}}),Et=new C({props:{$$slots:{default:[fu]},$$scope:{ctx:v}}}),Pt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example",$$slots:{default:[hu]},$$scope:{ctx:v}}}),Qt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example-2",$$slots:{default:[_u]},$$scope:{ctx:v}}}),fo=new R({props:{title:"ORTModelForAudioXVector",local:"optimum.onnxruntime.ORTModelForAudioXVector",headingTag:"h3"}}),ho=new k({props:{name:"class optimum.onnxruntime.ORTModelForAudioXVector",anchor:"optimum.onnxruntime.ORTModelForAudioXVector",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1900"}}),_o=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward",parameters:[{name:"input_values",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L1907"}}),Dt=new C({props:{$$slots:{default:[bu]},$$scope:{ctx:v}}}),Yt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.example",$$slots:{default:[yu]},$$scope:{ctx:v}}}),bo=new R({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),To=new R({props:{title:"ORTModelForVision2Seq",local:"optimum.onnxruntime.ORTModelForVision2Seq",headingTag:"h3"}}),Mo=new k({props:{name:"class optimum.onnxruntime.ORTModelForVision2Seq",anchor:"optimum.onnxruntime.ORTModelForVision2Seq",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1449"}}),wo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Features extracted from an Image. This tensor should be of shape
<code>(batch_size, num_channels, height, width)</code>.`,name:"pixel_values"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1507"}}),At=new C({props:{$$slots:{default:[Tu]},$$scope:{ctx:v}}}),Kt=new J({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example",$$slots:{default:[Mu]},$$scope:{ctx:v}}}),en=new J({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example-2",$$slots:{default:[wu]},$$scope:{ctx:v}}}),vo=new R({props:{title:"ORTModelForPix2Struct",local:"optimum.onnxruntime.ORTModelForPix2Struct",headingTag:"h3"}}),xo=new k({props:{name:"class optimum.onnxruntime.ORTModelForPix2Struct",anchor:"optimum.onnxruntime.ORTModelForPix2Struct",parameters:[{name:"encoder_session",val:": InferenceSession"},{name:"decoder_session",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"onnx_paths",val:": typing.List[str]"},{name:"decoder_with_past_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"use_cache",val:": bool = True"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1598"}}),$o=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward",parameters:[{name:"flattened_patches",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.flattened_patches",description:`<strong>flattened_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length, hidden_size)</code>) &#x2014;
Flattened pixel patches. the <code>hidden_size</code> is obtained by the following formula: <code>hidden_size</code> =
<code>num_channels</code> <em> <code>patch_size</code> </em> <code>patch_size</code>
The process of flattening the pixel patches is done by <code>Pix2StructProcessor</code>.`,name:"flattened_patches"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.
Pix2StructText uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_seq2seq.py#L1610"}}),tn=new C({props:{$$slots:{default:[vu]},$$scope:{ctx:v}}}),nn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.example",$$slots:{default:[xu]},$$scope:{ctx:v}}}),ko=new R({props:{title:"Custom Tasks",local:"custom-tasks",headingTag:"h2"}}),Jo=new R({props:{title:"ORTModelForCustomTasks",local:"optimum.onnxruntime.ORTModelForCustomTasks",headingTag:"h4"}}),Ro=new k({props:{name:"class optimum.onnxruntime.ORTModelForCustomTasks",anchor:"optimum.onnxruntime.ORTModelForCustomTasks",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2069"}}),Uo=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L2074"}}),on=new C({props:{$$slots:{default:[$u]},$$scope:{ctx:v}}}),sn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example",$$slots:{default:[ku]},$$scope:{ctx:v}}}),an=new J({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example-2",$$slots:{default:[ju]},$$scope:{ctx:v}}}),Io=new R({props:{title:"ORTModelForFeatureExtraction",local:"optimum.onnxruntime.ORTModelForFeatureExtraction",headingTag:"h4"}}),Zo=new k({props:{name:"class optimum.onnxruntime.ORTModelForFeatureExtraction",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction",parameters:[{name:"model",val:": InferenceSession"},{name:"config",val:": PretrainedConfig"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L892"}}),Co=new k({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_ort.py#L899"}}),ln=new C({props:{$$slots:{default:[Ju]},$$scope:{ctx:v}}}),rn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example",$$slots:{default:[Ru]},$$scope:{ctx:v}}}),pn=new J({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example-2",$$slots:{default:[Uu]},$$scope:{ctx:v}}}),Wo=new R({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),No=new R({props:{title:"ORTStableDiffusionPipeline",local:"optimum.onnxruntime.ORTStableDiffusionPipeline",headingTag:"h4"}}),So=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L539"}}),Fo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"guidance_rescale",val:": float = 0.0"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_stable_diffusion.py#L202",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Go=new R({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",headingTag:"h4"}}),Xo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L548"}}),Oo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[numpy.ndarray, PIL.Image.Image] = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>Union[np.ndarray, PIL.Image.Image]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_stable_diffusion_img2img.py#L76",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Vo=new R({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",headingTag:"h4"}}),zo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L557"}}),qo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"image",val:": Image"},{name:"mask_image",val:": Image"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing a masked image batch which will be upscaled.`,name:"mask_image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_stable_diffusion_inpaint.py#L98",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Bo=new R({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",headingTag:"h4"}}),Lo=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L615"}}),Ho=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.height",description:`<strong>height</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.width",description:`<strong>width</strong> (<code>Optional[int]</code>, defaults to None) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_stable_diffusion_xl.py#L263",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),Eo=new R({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),Po=new k({props:{name:"class optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"vae_decoder_session",val:": InferenceSession"},{name:"text_encoder_session",val:": InferenceSession"},{name:"unet_session",val:": InferenceSession"},{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler]"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"vae_encoder_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"text_encoder_2_session",val:": typing.Optional[onnxruntime.capi.onnxruntime_inference_collection.InferenceSession] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"add_watermarker",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/onnxruntime/modeling_diffusion.py#L624"}}),Qo=new k({props:{name:"__call__",anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[numpy.ndarray, PIL.Image.Image] = None"},{name:"strength",val:": float = 0.3"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Optional[numpy.random.mtrand.RandomState] = None"},{name:"latents",val:": typing.Optional[numpy.ndarray] = None"},{name:"prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[numpy.ndarray] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, numpy.ndarray], NoneType], NoneType] = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Union[typing.Tuple[int, int], NoneType] = None"},{name:"aesthetic_score",val:": float = 6.0"},{name:"negative_aesthetic_score",val:": float = 2.5"}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to None) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>Union[np.ndarray, PIL.Image.Image]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be upscaled.`,name:"image"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, list]]</code>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code>. instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code>
is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<code>schedulers.DDIMScheduler</code>, will be ignored for others.`,name:"eta"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[np.random.RandomState]</code>, defaults to <code>None</code>) &#x2014;:
A np.random.RandomState to make generation deterministic.`,name:"generator"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[np.ndarray]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (Optional[Callable], defaults to <code>None</code>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, defaults to 0.7) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"}],source:"https://github.com/huggingface/optimum/blob/main/optimum/pipelines/diffusers/pipeline_stable_diffusion_xl_img2img.py#L267",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple. When returning a tuple, the first element is a list with the generated images, and the second element is a list of </code>bool<code>s denoting whether the corresponding generated image likely represents "not-safe-for-work" (nsfw) content, according to the </code>safety_checker\`.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),{c(){n=m("meta"),M=a(),r=m("p"),s=a(),g(u.$$.fragment),t=a(),g(w.$$.fragment),tl=a(),fn=m("p"),fn.textContent=Rm,nl=a(),g(hn.$$.fragment),ol=a(),I=m("div"),g(_n.$$.fragment),mr=a(),as=m("p"),as.textContent=Um,dr=a(),ls=m("p"),ls.innerHTML=Im,cr=a(),rs=m("p"),rs.textContent=Zm,ur=a(),is=m("ul"),is.innerHTML=Cm,gr=a(),ps=m("p"),ps.textContent=Wm,fr=a(),ms=m("ul"),ms.innerHTML=Nm,hr=a(),it=m("div"),g(bn.$$.fragment),_r=a(),ds=m("p"),ds.textContent=Sm,br=a(),pt=m("div"),g(yn.$$.fragment),yr=a(),cs=m("p"),cs.innerHTML=Fm,Tr=a(),mt=m("div"),g(Tn.$$.fragment),Mr=a(),us=m("p"),us.textContent=Gm,wr=a(),dt=m("div"),g(Mn.$$.fragment),vr=a(),gs=m("p"),gs.textContent=Xm,xr=a(),ct=m("div"),g(wn.$$.fragment),$r=a(),fs=m("p"),fs.textContent=Om,sl=a(),g(vn.$$.fragment),al=a(),xn=m("p"),xn.textContent=Vm,ll=a(),g($n.$$.fragment),rl=a(),N=m("div"),g(kn.$$.fragment),kr=a(),hs=m("p"),hs.textContent=zm,jr=a(),_s=m("p"),_s.innerHTML=qm,Jr=a(),bs=m("p"),bs.innerHTML=Bm,Rr=a(),ae=m("div"),g(jn.$$.fragment),Ur=a(),ys=m("p"),ys.innerHTML=Lm,Ir=a(),g(ut.$$.fragment),Zr=a(),g(gt.$$.fragment),Cr=a(),g(ft.$$.fragment),il=a(),g(Jn.$$.fragment),pl=a(),S=m("div"),g(Rn.$$.fragment),Wr=a(),Ts=m("p"),Ts.textContent=Hm,Nr=a(),Ms=m("p"),Ms.innerHTML=Em,Sr=a(),ws=m("p"),ws.innerHTML=Pm,Fr=a(),le=m("div"),g(Un.$$.fragment),Gr=a(),vs=m("p"),vs.innerHTML=Qm,Xr=a(),g(ht.$$.fragment),Or=a(),g(_t.$$.fragment),Vr=a(),g(bt.$$.fragment),ml=a(),g(In.$$.fragment),dl=a(),F=m("div"),g(Zn.$$.fragment),zr=a(),xs=m("p"),xs.textContent=Dm,qr=a(),$s=m("p"),$s.innerHTML=Ym,Br=a(),ks=m("p"),ks.innerHTML=Am,Lr=a(),re=m("div"),g(Cn.$$.fragment),Hr=a(),js=m("p"),js.innerHTML=Km,Er=a(),g(yt.$$.fragment),Pr=a(),g(Tt.$$.fragment),Qr=a(),g(Mt.$$.fragment),cl=a(),g(Wn.$$.fragment),ul=a(),G=m("div"),g(Nn.$$.fragment),Dr=a(),Js=m("p"),Js.textContent=ed,Yr=a(),Rs=m("p"),Rs.innerHTML=td,Ar=a(),Us=m("p"),Us.innerHTML=nd,Kr=a(),W=m("div"),g(Sn.$$.fragment),ei=a(),Is=m("p"),Is.innerHTML=od,ti=a(),g(wt.$$.fragment),ni=a(),g(vt.$$.fragment),oi=a(),g(xt.$$.fragment),si=a(),g($t.$$.fragment),gl=a(),g(Fn.$$.fragment),fl=a(),X=m("div"),g(Gn.$$.fragment),ai=a(),Zs=m("p"),Zs.textContent=sd,li=a(),Cs=m("p"),Cs.innerHTML=ad,ri=a(),Ws=m("p"),Ws.innerHTML=ld,ii=a(),ie=m("div"),g(Xn.$$.fragment),pi=a(),Ns=m("p"),Ns.innerHTML=rd,mi=a(),g(kt.$$.fragment),di=a(),g(jt.$$.fragment),ci=a(),g(Jt.$$.fragment),hl=a(),g(On.$$.fragment),_l=a(),O=m("div"),g(Vn.$$.fragment),ui=a(),Ss=m("p"),Ss.textContent=id,gi=a(),Fs=m("p"),Fs.innerHTML=pd,fi=a(),Gs=m("p"),Gs.innerHTML=md,hi=a(),Ye=m("div"),g(zn.$$.fragment),_i=a(),Xs=m("p"),Xs.innerHTML=dd,bi=a(),g(Rt.$$.fragment),yi=a(),g(Ut.$$.fragment),bl=a(),g(qn.$$.fragment),yl=a(),V=m("div"),g(Bn.$$.fragment),Ti=a(),Os=m("p"),Os.textContent=cd,Mi=a(),Vs=m("p"),Vs.innerHTML=ud,wi=a(),zs=m("p"),zs.innerHTML=gd,vi=a(),pe=m("div"),g(Ln.$$.fragment),xi=a(),qs=m("p"),qs.innerHTML=fd,$i=a(),g(It.$$.fragment),ki=a(),g(Zt.$$.fragment),ji=a(),g(Ct.$$.fragment),Tl=a(),g(Hn.$$.fragment),Ml=a(),En=m("p"),En.textContent=hd,wl=a(),g(Pn.$$.fragment),vl=a(),z=m("div"),g(Qn.$$.fragment),Ji=a(),Bs=m("p"),Bs.textContent=_d,Ri=a(),Ls=m("p"),Ls.innerHTML=bd,Ui=a(),Hs=m("p"),Hs.innerHTML=yd,Ii=a(),me=m("div"),g(Dn.$$.fragment),Zi=a(),Es=m("p"),Es.innerHTML=Td,Ci=a(),g(Wt.$$.fragment),Wi=a(),g(Nt.$$.fragment),Ni=a(),g(St.$$.fragment),xl=a(),g(Yn.$$.fragment),$l=a(),q=m("div"),g(An.$$.fragment),Si=a(),Ps=m("p"),Ps.textContent=Md,Fi=a(),Qs=m("p"),Qs.innerHTML=wd,Gi=a(),Ds=m("p"),Ds.innerHTML=vd,Xi=a(),de=m("div"),g(Kn.$$.fragment),Oi=a(),Ys=m("p"),Ys.innerHTML=xd,Vi=a(),g(Ft.$$.fragment),zi=a(),g(Gt.$$.fragment),qi=a(),g(Xt.$$.fragment),kl=a(),g(eo.$$.fragment),jl=a(),to=m("p"),to.textContent=$d,Jl=a(),g(no.$$.fragment),Rl=a(),B=m("div"),g(oo.$$.fragment),Bi=a(),As=m("p"),As.textContent=kd,Li=a(),Ks=m("p"),Ks.innerHTML=jd,Hi=a(),ea=m("p"),ea.innerHTML=Jd,Ei=a(),ce=m("div"),g(so.$$.fragment),Pi=a(),ta=m("p"),ta.innerHTML=Rd,Qi=a(),g(Ot.$$.fragment),Di=a(),g(Vt.$$.fragment),Yi=a(),g(zt.$$.fragment),Ul=a(),g(ao.$$.fragment),Il=a(),L=m("div"),g(lo.$$.fragment),Ai=a(),na=m("p"),na.textContent=Ud,Ki=a(),oa=m("p"),oa.innerHTML=Id,ep=a(),sa=m("p"),sa.innerHTML=Zd,tp=a(),Ae=m("div"),g(ro.$$.fragment),np=a(),aa=m("p"),aa.innerHTML=Cd,op=a(),g(qt.$$.fragment),sp=a(),g(Bt.$$.fragment),Zl=a(),g(io.$$.fragment),Cl=a(),H=m("div"),g(po.$$.fragment),ap=a(),la=m("p"),la.textContent=Wd,lp=a(),ra=m("p"),ra.innerHTML=Nd,rp=a(),ia=m("p"),ia.innerHTML=Sd,ip=a(),Ke=m("div"),g(mo.$$.fragment),pp=a(),pa=m("p"),pa.innerHTML=Fd,mp=a(),g(Lt.$$.fragment),dp=a(),g(Ht.$$.fragment),Wl=a(),g(co.$$.fragment),Nl=a(),E=m("div"),g(uo.$$.fragment),cp=a(),ma=m("p"),ma.textContent=Gd,up=a(),da=m("p"),da.innerHTML=Xd,gp=a(),ca=m("p"),ca.innerHTML=Od,fp=a(),ue=m("div"),g(go.$$.fragment),hp=a(),ua=m("p"),ua.innerHTML=Vd,_p=a(),g(Et.$$.fragment),bp=a(),g(Pt.$$.fragment),yp=a(),g(Qt.$$.fragment),Sl=a(),g(fo.$$.fragment),Fl=a(),P=m("div"),g(ho.$$.fragment),Tp=a(),ga=m("p"),ga.textContent=zd,Mp=a(),fa=m("p"),fa.innerHTML=qd,wp=a(),ha=m("p"),ha.innerHTML=Bd,vp=a(),et=m("div"),g(_o.$$.fragment),xp=a(),_a=m("p"),_a.innerHTML=Ld,$p=a(),g(Dt.$$.fragment),kp=a(),g(Yt.$$.fragment),Gl=a(),g(bo.$$.fragment),Xl=a(),yo=m("p"),yo.textContent=Hd,Ol=a(),g(To.$$.fragment),Vl=a(),Q=m("div"),g(Mo.$$.fragment),jp=a(),ba=m("p"),ba.textContent=Ed,Jp=a(),ya=m("p"),ya.innerHTML=Pd,Rp=a(),Ta=m("p"),Ta.innerHTML=Qd,Up=a(),ge=m("div"),g(wo.$$.fragment),Ip=a(),Ma=m("p"),Ma.innerHTML=Dd,Zp=a(),g(At.$$.fragment),Cp=a(),g(Kt.$$.fragment),Wp=a(),g(en.$$.fragment),zl=a(),g(vo.$$.fragment),ql=a(),D=m("div"),g(xo.$$.fragment),Np=a(),wa=m("p"),wa.textContent=Yd,Sp=a(),va=m("p"),va.innerHTML=Ad,Fp=a(),xa=m("p"),xa.innerHTML=Kd,Gp=a(),tt=m("div"),g($o.$$.fragment),Xp=a(),$a=m("p"),$a.innerHTML=ec,Op=a(),g(tn.$$.fragment),Vp=a(),g(nn.$$.fragment),Bl=a(),g(ko.$$.fragment),Ll=a(),jo=m("p"),jo.textContent=tc,Hl=a(),g(Jo.$$.fragment),El=a(),Y=m("div"),g(Ro.$$.fragment),zp=a(),ka=m("p"),ka.textContent=nc,qp=a(),ja=m("p"),ja.innerHTML=oc,Bp=a(),Ja=m("p"),Ja.innerHTML=sc,Lp=a(),fe=m("div"),g(Uo.$$.fragment),Hp=a(),Ra=m("p"),Ra.innerHTML=ac,Ep=a(),g(on.$$.fragment),Pp=a(),g(sn.$$.fragment),Qp=a(),g(an.$$.fragment),Pl=a(),g(Io.$$.fragment),Ql=a(),A=m("div"),g(Zo.$$.fragment),Dp=a(),Ua=m("p"),Ua.textContent=lc,Yp=a(),Ia=m("p"),Ia.innerHTML=rc,Ap=a(),Za=m("p"),Za.innerHTML=ic,Kp=a(),he=m("div"),g(Co.$$.fragment),em=a(),Ca=m("p"),Ca.innerHTML=pc,tm=a(),g(ln.$$.fragment),nm=a(),g(rn.$$.fragment),om=a(),g(pn.$$.fragment),Dl=a(),g(Wo.$$.fragment),Yl=a(),g(No.$$.fragment),Al=a(),K=m("div"),g(So.$$.fragment),sm=a(),Wa=m("p"),Wa.innerHTML=mc,am=a(),Na=m("p"),Na.innerHTML=dc,lm=a(),Sa=m("p"),Sa.innerHTML=cc,rm=a(),mn=m("div"),g(Fo.$$.fragment),im=a(),Fa=m("p"),Fa.textContent=uc,Kl=a(),g(Go.$$.fragment),er=a(),ee=m("div"),g(Xo.$$.fragment),pm=a(),Ga=m("p"),Ga.innerHTML=gc,mm=a(),Xa=m("p"),Xa.innerHTML=fc,dm=a(),Oa=m("p"),Oa.innerHTML=hc,cm=a(),dn=m("div"),g(Oo.$$.fragment),um=a(),Va=m("p"),Va.textContent=_c,tr=a(),g(Vo.$$.fragment),nr=a(),te=m("div"),g(zo.$$.fragment),gm=a(),za=m("p"),za.innerHTML=bc,fm=a(),qa=m("p"),qa.innerHTML=yc,hm=a(),Ba=m("p"),Ba.innerHTML=Tc,_m=a(),cn=m("div"),g(qo.$$.fragment),bm=a(),La=m("p"),La.textContent=Mc,or=a(),g(Bo.$$.fragment),sr=a(),ne=m("div"),g(Lo.$$.fragment),ym=a(),Ha=m("p"),Ha.innerHTML=wc,Tm=a(),Ea=m("p"),Ea.innerHTML=vc,Mm=a(),Pa=m("p"),Pa.innerHTML=xc,wm=a(),un=m("div"),g(Ho.$$.fragment),vm=a(),Qa=m("p"),Qa.textContent=$c,ar=a(),g(Eo.$$.fragment),lr=a(),oe=m("div"),g(Po.$$.fragment),xm=a(),Da=m("p"),Da.innerHTML=kc,$m=a(),Ya=m("p"),Ya.innerHTML=jc,km=a(),Aa=m("p"),Aa.innerHTML=Jc,jm=a(),gn=m("div"),g(Qo.$$.fragment),Jm=a(),Ka=m("p"),Ka.textContent=Rc,rr=a(),el=m("p"),this.h()},l(e){const p=Wc("svelte-u9bgzb",document.head);n=d(p,"META",{name:!0,content:!0}),p.forEach(i),M=l(e),r=d(e,"P",{}),x(r).forEach(i),s=l(e),f(u.$$.fragment,e),t=l(e),f(w.$$.fragment,e),tl=l(e),fn=d(e,"P",{"data-svelte-h":!0}),T(fn)!=="svelte-uyecg"&&(fn.textContent=Rm),nl=l(e),f(hn.$$.fragment,e),ol=l(e),I=d(e,"DIV",{class:!0});var Z=x(I);f(_n.$$.fragment,Z),mr=l(Z),as=d(Z,"P",{"data-svelte-h":!0}),T(as)!=="svelte-12yueui"&&(as.textContent=Um),dr=l(Z),ls=d(Z,"P",{"data-svelte-h":!0}),T(ls)!=="svelte-zarm0s"&&(ls.innerHTML=Im),cr=l(Z),rs=d(Z,"P",{"data-svelte-h":!0}),T(rs)!=="svelte-wz8va1"&&(rs.textContent=Zm),ur=l(Z),is=d(Z,"UL",{"data-svelte-h":!0}),T(is)!=="svelte-qpxha0"&&(is.innerHTML=Cm),gr=l(Z),ps=d(Z,"P",{"data-svelte-h":!0}),T(ps)!=="svelte-86gko0"&&(ps.textContent=Wm),fr=l(Z),ms=d(Z,"UL",{"data-svelte-h":!0}),T(ms)!=="svelte-1hugf7m"&&(ms.innerHTML=Nm),hr=l(Z),it=d(Z,"DIV",{class:!0});var Do=x(it);f(bn.$$.fragment,Do),_r=l(Do),ds=d(Do,"P",{"data-svelte-h":!0}),T(ds)!=="svelte-18vxhwp"&&(ds.textContent=Sm),Do.forEach(i),br=l(Z),pt=d(Z,"DIV",{class:!0});var Yo=x(pt);f(yn.$$.fragment,Yo),yr=l(Yo),cs=d(Yo,"P",{"data-svelte-h":!0}),T(cs)!=="svelte-1sb2z5w"&&(cs.innerHTML=Fm),Yo.forEach(i),Tr=l(Z),mt=d(Z,"DIV",{class:!0});var Ao=x(mt);f(Tn.$$.fragment,Ao),Mr=l(Ao),us=d(Ao,"P",{"data-svelte-h":!0}),T(us)!=="svelte-h8ck7o"&&(us.textContent=Gm),Ao.forEach(i),wr=l(Z),dt=d(Z,"DIV",{class:!0});var Ko=x(dt);f(Mn.$$.fragment,Ko),vr=l(Ko),gs=d(Ko,"P",{"data-svelte-h":!0}),T(gs)!=="svelte-1b4tey4"&&(gs.textContent=Xm),Ko.forEach(i),xr=l(Z),ct=d(Z,"DIV",{class:!0});var es=x(ct);f(wn.$$.fragment,es),$r=l(es),fs=d(es,"P",{"data-svelte-h":!0}),T(fs)!=="svelte-1tdm1u4"&&(fs.textContent=Om),es.forEach(i),Z.forEach(i),sl=l(e),f(vn.$$.fragment,e),al=l(e),xn=d(e,"P",{"data-svelte-h":!0}),T(xn)!=="svelte-1tlroh"&&(xn.textContent=Vm),ll=l(e),f($n.$$.fragment,e),rl=l(e),N=d(e,"DIV",{class:!0});var _e=x(N);f(kn.$$.fragment,_e),kr=l(_e),hs=d(_e,"P",{"data-svelte-h":!0}),T(hs)!=="svelte-pig4vj"&&(hs.textContent=zm),jr=l(_e),_s=d(_e,"P",{"data-svelte-h":!0}),T(_s)!=="svelte-1pmzjgn"&&(_s.innerHTML=qm),Jr=l(_e),bs=d(_e,"P",{"data-svelte-h":!0}),T(bs)!=="svelte-7jrnx4"&&(bs.innerHTML=Bm),Rr=l(_e),ae=d(_e,"DIV",{class:!0});var be=x(ae);f(jn.$$.fragment,be),Ur=l(be),ys=d(be,"P",{"data-svelte-h":!0}),T(ys)!=="svelte-1ox9av6"&&(ys.innerHTML=Lm),Ir=l(be),f(ut.$$.fragment,be),Zr=l(be),f(gt.$$.fragment,be),Cr=l(be),f(ft.$$.fragment,be),be.forEach(i),_e.forEach(i),il=l(e),f(Jn.$$.fragment,e),pl=l(e),S=d(e,"DIV",{class:!0});var ye=x(S);f(Rn.$$.fragment,ye),Wr=l(ye),Ts=d(ye,"P",{"data-svelte-h":!0}),T(Ts)!=="svelte-lnzl0e"&&(Ts.textContent=Hm),Nr=l(ye),Ms=d(ye,"P",{"data-svelte-h":!0}),T(Ms)!=="svelte-1pmzjgn"&&(Ms.innerHTML=Em),Sr=l(ye),ws=d(ye,"P",{"data-svelte-h":!0}),T(ws)!=="svelte-7jrnx4"&&(ws.innerHTML=Pm),Fr=l(ye),le=d(ye,"DIV",{class:!0});var Te=x(le);f(Un.$$.fragment,Te),Gr=l(Te),vs=d(Te,"P",{"data-svelte-h":!0}),T(vs)!=="svelte-1xqof9m"&&(vs.innerHTML=Qm),Xr=l(Te),f(ht.$$.fragment,Te),Or=l(Te),f(_t.$$.fragment,Te),Vr=l(Te),f(bt.$$.fragment,Te),Te.forEach(i),ye.forEach(i),ml=l(e),f(In.$$.fragment,e),dl=l(e),F=d(e,"DIV",{class:!0});var Me=x(F);f(Zn.$$.fragment,Me),zr=l(Me),xs=d(Me,"P",{"data-svelte-h":!0}),T(xs)!=="svelte-t6z30i"&&(xs.textContent=Dm),qr=l(Me),$s=d(Me,"P",{"data-svelte-h":!0}),T($s)!=="svelte-1pmzjgn"&&($s.innerHTML=Ym),Br=l(Me),ks=d(Me,"P",{"data-svelte-h":!0}),T(ks)!=="svelte-7jrnx4"&&(ks.innerHTML=Am),Lr=l(Me),re=d(Me,"DIV",{class:!0});var we=x(re);f(Cn.$$.fragment,we),Hr=l(we),js=d(we,"P",{"data-svelte-h":!0}),T(js)!=="svelte-n65k7h"&&(js.innerHTML=Km),Er=l(we),f(yt.$$.fragment,we),Pr=l(we),f(Tt.$$.fragment,we),Qr=l(we),f(Mt.$$.fragment,we),we.forEach(i),Me.forEach(i),cl=l(e),f(Wn.$$.fragment,e),ul=l(e),G=d(e,"DIV",{class:!0});var ve=x(G);f(Nn.$$.fragment,ve),Dr=l(ve),Js=d(ve,"P",{"data-svelte-h":!0}),T(Js)!=="svelte-ixbo5n"&&(Js.textContent=ed),Yr=l(ve),Rs=d(ve,"P",{"data-svelte-h":!0}),T(Rs)!=="svelte-1pmzjgn"&&(Rs.innerHTML=td),Ar=l(ve),Us=d(ve,"P",{"data-svelte-h":!0}),T(Us)!=="svelte-7jrnx4"&&(Us.innerHTML=nd),Kr=l(ve),W=d(ve,"DIV",{class:!0});var se=x(W);f(Sn.$$.fragment,se),ei=l(se),Is=d(se,"P",{"data-svelte-h":!0}),T(Is)!=="svelte-1plx9t"&&(Is.innerHTML=od),ti=l(se),f(wt.$$.fragment,se),ni=l(se),f(vt.$$.fragment,se),oi=l(se),f(xt.$$.fragment,se),si=l(se),f($t.$$.fragment,se),se.forEach(i),ve.forEach(i),gl=l(e),f(Fn.$$.fragment,e),fl=l(e),X=d(e,"DIV",{class:!0});var xe=x(X);f(Gn.$$.fragment,xe),ai=l(xe),Zs=d(xe,"P",{"data-svelte-h":!0}),T(Zs)!=="svelte-1l2d2mz"&&(Zs.textContent=sd),li=l(xe),Cs=d(xe,"P",{"data-svelte-h":!0}),T(Cs)!=="svelte-1pmzjgn"&&(Cs.innerHTML=ad),ri=l(xe),Ws=d(xe,"P",{"data-svelte-h":!0}),T(Ws)!=="svelte-7jrnx4"&&(Ws.innerHTML=ld),ii=l(xe),ie=d(xe,"DIV",{class:!0});var $e=x(ie);f(Xn.$$.fragment,$e),pi=l($e),Ns=d($e,"P",{"data-svelte-h":!0}),T(Ns)!=="svelte-xk2xch"&&(Ns.innerHTML=rd),mi=l($e),f(kt.$$.fragment,$e),di=l($e),f(jt.$$.fragment,$e),ci=l($e),f(Jt.$$.fragment,$e),$e.forEach(i),xe.forEach(i),hl=l(e),f(On.$$.fragment,e),_l=l(e),O=d(e,"DIV",{class:!0});var ke=x(O);f(Vn.$$.fragment,ke),ui=l(ke),Ss=d(ke,"P",{"data-svelte-h":!0}),T(Ss)!=="svelte-1oobrgk"&&(Ss.textContent=id),gi=l(ke),Fs=d(ke,"P",{"data-svelte-h":!0}),T(Fs)!=="svelte-1pmzjgn"&&(Fs.innerHTML=pd),fi=l(ke),Gs=d(ke,"P",{"data-svelte-h":!0}),T(Gs)!=="svelte-7jrnx4"&&(Gs.innerHTML=md),hi=l(ke),Ye=d(ke,"DIV",{class:!0});var nt=x(Ye);f(zn.$$.fragment,nt),_i=l(nt),Xs=d(nt,"P",{"data-svelte-h":!0}),T(Xs)!=="svelte-qesv8n"&&(Xs.innerHTML=dd),bi=l(nt),f(Rt.$$.fragment,nt),yi=l(nt),f(Ut.$$.fragment,nt),nt.forEach(i),ke.forEach(i),bl=l(e),f(qn.$$.fragment,e),yl=l(e),V=d(e,"DIV",{class:!0});var je=x(V);f(Bn.$$.fragment,je),Ti=l(je),Os=d(je,"P",{"data-svelte-h":!0}),T(Os)!=="svelte-1hsozsl"&&(Os.textContent=cd),Mi=l(je),Vs=d(je,"P",{"data-svelte-h":!0}),T(Vs)!=="svelte-1pmzjgn"&&(Vs.innerHTML=ud),wi=l(je),zs=d(je,"P",{"data-svelte-h":!0}),T(zs)!=="svelte-7jrnx4"&&(zs.innerHTML=gd),vi=l(je),pe=d(je,"DIV",{class:!0});var Je=x(pe);f(Ln.$$.fragment,Je),xi=l(Je),qs=d(Je,"P",{"data-svelte-h":!0}),T(qs)!=="svelte-1dng7rw"&&(qs.innerHTML=fd),$i=l(Je),f(It.$$.fragment,Je),ki=l(Je),f(Zt.$$.fragment,Je),ji=l(Je),f(Ct.$$.fragment,Je),Je.forEach(i),je.forEach(i),Tl=l(e),f(Hn.$$.fragment,e),Ml=l(e),En=d(e,"P",{"data-svelte-h":!0}),T(En)!=="svelte-1h2y3wu"&&(En.textContent=hd),wl=l(e),f(Pn.$$.fragment,e),vl=l(e),z=d(e,"DIV",{class:!0});var Re=x(z);f(Qn.$$.fragment,Re),Ji=l(Re),Bs=d(Re,"P",{"data-svelte-h":!0}),T(Bs)!=="svelte-myyf2v"&&(Bs.textContent=_d),Ri=l(Re),Ls=d(Re,"P",{"data-svelte-h":!0}),T(Ls)!=="svelte-1pmzjgn"&&(Ls.innerHTML=bd),Ui=l(Re),Hs=d(Re,"P",{"data-svelte-h":!0}),T(Hs)!=="svelte-7jrnx4"&&(Hs.innerHTML=yd),Ii=l(Re),me=d(Re,"DIV",{class:!0});var Ue=x(me);f(Dn.$$.fragment,Ue),Zi=l(Ue),Es=d(Ue,"P",{"data-svelte-h":!0}),T(Es)!=="svelte-1azuqx"&&(Es.innerHTML=Td),Ci=l(Ue),f(Wt.$$.fragment,Ue),Wi=l(Ue),f(Nt.$$.fragment,Ue),Ni=l(Ue),f(St.$$.fragment,Ue),Ue.forEach(i),Re.forEach(i),xl=l(e),f(Yn.$$.fragment,e),$l=l(e),q=d(e,"DIV",{class:!0});var Ie=x(q);f(An.$$.fragment,Ie),Si=l(Ie),Ps=d(Ie,"P",{"data-svelte-h":!0}),T(Ps)!=="svelte-mw2y5y"&&(Ps.textContent=Md),Fi=l(Ie),Qs=d(Ie,"P",{"data-svelte-h":!0}),T(Qs)!=="svelte-1pmzjgn"&&(Qs.innerHTML=wd),Gi=l(Ie),Ds=d(Ie,"P",{"data-svelte-h":!0}),T(Ds)!=="svelte-7jrnx4"&&(Ds.innerHTML=vd),Xi=l(Ie),de=d(Ie,"DIV",{class:!0});var Ze=x(de);f(Kn.$$.fragment,Ze),Oi=l(Ze),Ys=d(Ze,"P",{"data-svelte-h":!0}),T(Ys)!=="svelte-1s27jle"&&(Ys.innerHTML=xd),Vi=l(Ze),f(Ft.$$.fragment,Ze),zi=l(Ze),f(Gt.$$.fragment,Ze),qi=l(Ze),f(Xt.$$.fragment,Ze),Ze.forEach(i),Ie.forEach(i),kl=l(e),f(eo.$$.fragment,e),jl=l(e),to=d(e,"P",{"data-svelte-h":!0}),T(to)!=="svelte-liyjdz"&&(to.textContent=$d),Jl=l(e),f(no.$$.fragment,e),Rl=l(e),B=d(e,"DIV",{class:!0});var Ce=x(B);f(oo.$$.fragment,Ce),Bi=l(Ce),As=d(Ce,"P",{"data-svelte-h":!0}),T(As)!=="svelte-yleggj"&&(As.textContent=kd),Li=l(Ce),Ks=d(Ce,"P",{"data-svelte-h":!0}),T(Ks)!=="svelte-1pmzjgn"&&(Ks.innerHTML=jd),Hi=l(Ce),ea=d(Ce,"P",{"data-svelte-h":!0}),T(ea)!=="svelte-7jrnx4"&&(ea.innerHTML=Jd),Ei=l(Ce),ce=d(Ce,"DIV",{class:!0});var We=x(ce);f(so.$$.fragment,We),Pi=l(We),ta=d(We,"P",{"data-svelte-h":!0}),T(ta)!=="svelte-p67kxo"&&(ta.innerHTML=Rd),Qi=l(We),f(Ot.$$.fragment,We),Di=l(We),f(Vt.$$.fragment,We),Yi=l(We),f(zt.$$.fragment,We),We.forEach(i),Ce.forEach(i),Ul=l(e),f(ao.$$.fragment,e),Il=l(e),L=d(e,"DIV",{class:!0});var Ne=x(L);f(lo.$$.fragment,Ne),Ai=l(Ne),na=d(Ne,"P",{"data-svelte-h":!0}),T(na)!=="svelte-lyybxc"&&(na.textContent=Ud),Ki=l(Ne),oa=d(Ne,"P",{"data-svelte-h":!0}),T(oa)!=="svelte-1pmzjgn"&&(oa.innerHTML=Id),ep=l(Ne),sa=d(Ne,"P",{"data-svelte-h":!0}),T(sa)!=="svelte-7jrnx4"&&(sa.innerHTML=Zd),tp=l(Ne),Ae=d(Ne,"DIV",{class:!0});var ot=x(Ae);f(ro.$$.fragment,ot),np=l(ot),aa=d(ot,"P",{"data-svelte-h":!0}),T(aa)!=="svelte-18aced7"&&(aa.innerHTML=Cd),op=l(ot),f(qt.$$.fragment,ot),sp=l(ot),f(Bt.$$.fragment,ot),ot.forEach(i),Ne.forEach(i),Zl=l(e),f(io.$$.fragment,e),Cl=l(e),H=d(e,"DIV",{class:!0});var Se=x(H);f(po.$$.fragment,Se),ap=l(Se),la=d(Se,"P",{"data-svelte-h":!0}),T(la)!=="svelte-xbkga4"&&(la.textContent=Wd),lp=l(Se),ra=d(Se,"P",{"data-svelte-h":!0}),T(ra)!=="svelte-1pmzjgn"&&(ra.innerHTML=Nd),rp=l(Se),ia=d(Se,"P",{"data-svelte-h":!0}),T(ia)!=="svelte-7jrnx4"&&(ia.innerHTML=Sd),ip=l(Se),Ke=d(Se,"DIV",{class:!0});var st=x(Ke);f(mo.$$.fragment,st),pp=l(st),pa=d(st,"P",{"data-svelte-h":!0}),T(pa)!=="svelte-1szjv6u"&&(pa.innerHTML=Fd),mp=l(st),f(Lt.$$.fragment,st),dp=l(st),f(Ht.$$.fragment,st),st.forEach(i),Se.forEach(i),Wl=l(e),f(co.$$.fragment,e),Nl=l(e),E=d(e,"DIV",{class:!0});var Fe=x(E);f(uo.$$.fragment,Fe),cp=l(Fe),ma=d(Fe,"P",{"data-svelte-h":!0}),T(ma)!=="svelte-135bhh9"&&(ma.textContent=Gd),up=l(Fe),da=d(Fe,"P",{"data-svelte-h":!0}),T(da)!=="svelte-1pmzjgn"&&(da.innerHTML=Xd),gp=l(Fe),ca=d(Fe,"P",{"data-svelte-h":!0}),T(ca)!=="svelte-7jrnx4"&&(ca.innerHTML=Od),fp=l(Fe),ue=d(Fe,"DIV",{class:!0});var Ge=x(ue);f(go.$$.fragment,Ge),hp=l(Ge),ua=d(Ge,"P",{"data-svelte-h":!0}),T(ua)!=="svelte-1e3zkhy"&&(ua.innerHTML=Vd),_p=l(Ge),f(Et.$$.fragment,Ge),bp=l(Ge),f(Pt.$$.fragment,Ge),yp=l(Ge),f(Qt.$$.fragment,Ge),Ge.forEach(i),Fe.forEach(i),Sl=l(e),f(fo.$$.fragment,e),Fl=l(e),P=d(e,"DIV",{class:!0});var Xe=x(P);f(ho.$$.fragment,Xe),Tp=l(Xe),ga=d(Xe,"P",{"data-svelte-h":!0}),T(ga)!=="svelte-1bhc8y0"&&(ga.textContent=zd),Mp=l(Xe),fa=d(Xe,"P",{"data-svelte-h":!0}),T(fa)!=="svelte-1pmzjgn"&&(fa.innerHTML=qd),wp=l(Xe),ha=d(Xe,"P",{"data-svelte-h":!0}),T(ha)!=="svelte-7jrnx4"&&(ha.innerHTML=Bd),vp=l(Xe),et=d(Xe,"DIV",{class:!0});var at=x(et);f(_o.$$.fragment,at),xp=l(at),_a=d(at,"P",{"data-svelte-h":!0}),T(_a)!=="svelte-1fuxgrl"&&(_a.innerHTML=Ld),$p=l(at),f(Dt.$$.fragment,at),kp=l(at),f(Yt.$$.fragment,at),at.forEach(i),Xe.forEach(i),Gl=l(e),f(bo.$$.fragment,e),Xl=l(e),yo=d(e,"P",{"data-svelte-h":!0}),T(yo)!=="svelte-1gk58z"&&(yo.textContent=Hd),Ol=l(e),f(To.$$.fragment,e),Vl=l(e),Q=d(e,"DIV",{class:!0});var Oe=x(Q);f(Mo.$$.fragment,Oe),jp=l(Oe),ba=d(Oe,"P",{"data-svelte-h":!0}),T(ba)!=="svelte-1yhfevg"&&(ba.textContent=Ed),Jp=l(Oe),ya=d(Oe,"P",{"data-svelte-h":!0}),T(ya)!=="svelte-1pmzjgn"&&(ya.innerHTML=Pd),Rp=l(Oe),Ta=d(Oe,"P",{"data-svelte-h":!0}),T(Ta)!=="svelte-7jrnx4"&&(Ta.innerHTML=Qd),Up=l(Oe),ge=d(Oe,"DIV",{class:!0});var Ve=x(ge);f(wo.$$.fragment,Ve),Ip=l(Ve),Ma=d(Ve,"P",{"data-svelte-h":!0}),T(Ma)!=="svelte-11xalzp"&&(Ma.innerHTML=Dd),Zp=l(Ve),f(At.$$.fragment,Ve),Cp=l(Ve),f(Kt.$$.fragment,Ve),Wp=l(Ve),f(en.$$.fragment,Ve),Ve.forEach(i),Oe.forEach(i),zl=l(e),f(vo.$$.fragment,e),ql=l(e),D=d(e,"DIV",{class:!0});var ze=x(D);f(xo.$$.fragment,ze),Np=l(ze),wa=d(ze,"P",{"data-svelte-h":!0}),T(wa)!=="svelte-80a148"&&(wa.textContent=Yd),Sp=l(ze),va=d(ze,"P",{"data-svelte-h":!0}),T(va)!=="svelte-1pmzjgn"&&(va.innerHTML=Ad),Fp=l(ze),xa=d(ze,"P",{"data-svelte-h":!0}),T(xa)!=="svelte-7jrnx4"&&(xa.innerHTML=Kd),Gp=l(ze),tt=d(ze,"DIV",{class:!0});var lt=x(tt);f($o.$$.fragment,lt),Xp=l(lt),$a=d(lt,"P",{"data-svelte-h":!0}),T($a)!=="svelte-eywb10"&&($a.innerHTML=ec),Op=l(lt),f(tn.$$.fragment,lt),Vp=l(lt),f(nn.$$.fragment,lt),lt.forEach(i),ze.forEach(i),Bl=l(e),f(ko.$$.fragment,e),Ll=l(e),jo=d(e,"P",{"data-svelte-h":!0}),T(jo)!=="svelte-1n8n3ms"&&(jo.textContent=tc),Hl=l(e),f(Jo.$$.fragment,e),El=l(e),Y=d(e,"DIV",{class:!0});var qe=x(Y);f(Ro.$$.fragment,qe),zp=l(qe),ka=d(qe,"P",{"data-svelte-h":!0}),T(ka)!=="svelte-5pmyjn"&&(ka.textContent=nc),qp=l(qe),ja=d(qe,"P",{"data-svelte-h":!0}),T(ja)!=="svelte-1pmzjgn"&&(ja.innerHTML=oc),Bp=l(qe),Ja=d(qe,"P",{"data-svelte-h":!0}),T(Ja)!=="svelte-7jrnx4"&&(Ja.innerHTML=sc),Lp=l(qe),fe=d(qe,"DIV",{class:!0});var Be=x(fe);f(Uo.$$.fragment,Be),Hp=l(Be),Ra=d(Be,"P",{"data-svelte-h":!0}),T(Ra)!=="svelte-1usnw5b"&&(Ra.innerHTML=ac),Ep=l(Be),f(on.$$.fragment,Be),Pp=l(Be),f(sn.$$.fragment,Be),Qp=l(Be),f(an.$$.fragment,Be),Be.forEach(i),qe.forEach(i),Pl=l(e),f(Io.$$.fragment,e),Ql=l(e),A=d(e,"DIV",{class:!0});var Le=x(A);f(Zo.$$.fragment,Le),Dp=l(Le),Ua=d(Le,"P",{"data-svelte-h":!0}),T(Ua)!=="svelte-1rhquq6"&&(Ua.textContent=lc),Yp=l(Le),Ia=d(Le,"P",{"data-svelte-h":!0}),T(Ia)!=="svelte-1pmzjgn"&&(Ia.innerHTML=rc),Ap=l(Le),Za=d(Le,"P",{"data-svelte-h":!0}),T(Za)!=="svelte-7jrnx4"&&(Za.innerHTML=ic),Kp=l(Le),he=d(Le,"DIV",{class:!0});var He=x(he);f(Co.$$.fragment,He),em=l(He),Ca=d(He,"P",{"data-svelte-h":!0}),T(Ca)!=="svelte-iqwqsz"&&(Ca.innerHTML=pc),tm=l(He),f(ln.$$.fragment,He),nm=l(He),f(rn.$$.fragment,He),om=l(He),f(pn.$$.fragment,He),He.forEach(i),Le.forEach(i),Dl=l(e),f(Wo.$$.fragment,e),Yl=l(e),f(No.$$.fragment,e),Al=l(e),K=d(e,"DIV",{class:!0});var Ee=x(K);f(So.$$.fragment,Ee),sm=l(Ee),Wa=d(Ee,"P",{"data-svelte-h":!0}),T(Wa)!=="svelte-o3cjct"&&(Wa.innerHTML=mc),am=l(Ee),Na=d(Ee,"P",{"data-svelte-h":!0}),T(Na)!=="svelte-1pmzjgn"&&(Na.innerHTML=dc),lm=l(Ee),Sa=d(Ee,"P",{"data-svelte-h":!0}),T(Sa)!=="svelte-7jrnx4"&&(Sa.innerHTML=cc),rm=l(Ee),mn=d(Ee,"DIV",{class:!0});var ts=x(mn);f(Fo.$$.fragment,ts),im=l(ts),Fa=d(ts,"P",{"data-svelte-h":!0}),T(Fa)!=="svelte-v78lg8"&&(Fa.textContent=uc),ts.forEach(i),Ee.forEach(i),Kl=l(e),f(Go.$$.fragment,e),er=l(e),ee=d(e,"DIV",{class:!0});var Pe=x(ee);f(Xo.$$.fragment,Pe),pm=l(Pe),Ga=d(Pe,"P",{"data-svelte-h":!0}),T(Ga)!=="svelte-1ds9yih"&&(Ga.innerHTML=gc),mm=l(Pe),Xa=d(Pe,"P",{"data-svelte-h":!0}),T(Xa)!=="svelte-1pmzjgn"&&(Xa.innerHTML=fc),dm=l(Pe),Oa=d(Pe,"P",{"data-svelte-h":!0}),T(Oa)!=="svelte-7jrnx4"&&(Oa.innerHTML=hc),cm=l(Pe),dn=d(Pe,"DIV",{class:!0});var ns=x(dn);f(Oo.$$.fragment,ns),um=l(ns),Va=d(ns,"P",{"data-svelte-h":!0}),T(Va)!=="svelte-v78lg8"&&(Va.textContent=_c),ns.forEach(i),Pe.forEach(i),tr=l(e),f(Vo.$$.fragment,e),nr=l(e),te=d(e,"DIV",{class:!0});var Qe=x(te);f(zo.$$.fragment,Qe),gm=l(Qe),za=d(Qe,"P",{"data-svelte-h":!0}),T(za)!=="svelte-1jlenwy"&&(za.innerHTML=bc),fm=l(Qe),qa=d(Qe,"P",{"data-svelte-h":!0}),T(qa)!=="svelte-1pmzjgn"&&(qa.innerHTML=yc),hm=l(Qe),Ba=d(Qe,"P",{"data-svelte-h":!0}),T(Ba)!=="svelte-7jrnx4"&&(Ba.innerHTML=Tc),_m=l(Qe),cn=d(Qe,"DIV",{class:!0});var os=x(cn);f(qo.$$.fragment,os),bm=l(os),La=d(os,"P",{"data-svelte-h":!0}),T(La)!=="svelte-v78lg8"&&(La.textContent=Mc),os.forEach(i),Qe.forEach(i),or=l(e),f(Bo.$$.fragment,e),sr=l(e),ne=d(e,"DIV",{class:!0});var De=x(ne);f(Lo.$$.fragment,De),ym=l(De),Ha=d(De,"P",{"data-svelte-h":!0}),T(Ha)!=="svelte-tg08kp"&&(Ha.innerHTML=wc),Tm=l(De),Ea=d(De,"P",{"data-svelte-h":!0}),T(Ea)!=="svelte-1pmzjgn"&&(Ea.innerHTML=vc),Mm=l(De),Pa=d(De,"P",{"data-svelte-h":!0}),T(Pa)!=="svelte-7jrnx4"&&(Pa.innerHTML=xc),wm=l(De),un=d(De,"DIV",{class:!0});var ss=x(un);f(Ho.$$.fragment,ss),vm=l(ss),Qa=d(ss,"P",{"data-svelte-h":!0}),T(Qa)!=="svelte-v78lg8"&&(Qa.textContent=$c),ss.forEach(i),De.forEach(i),ar=l(e),f(Eo.$$.fragment,e),lr=l(e),oe=d(e,"DIV",{class:!0});var rt=x(oe);f(Po.$$.fragment,rt),xm=l(rt),Da=d(rt,"P",{"data-svelte-h":!0}),T(Da)!=="svelte-zcp8nz"&&(Da.innerHTML=kc),$m=l(rt),Ya=d(rt,"P",{"data-svelte-h":!0}),T(Ya)!=="svelte-1pmzjgn"&&(Ya.innerHTML=jc),km=l(rt),Aa=d(rt,"P",{"data-svelte-h":!0}),T(Aa)!=="svelte-7jrnx4"&&(Aa.innerHTML=Jc),jm=l(rt),gn=d(rt,"DIV",{class:!0});var pr=x(gn);f(Qo.$$.fragment,pr),Jm=l(pr),Ka=d(pr,"P",{"data-svelte-h":!0}),T(Ka)!=="svelte-v78lg8"&&(Ka.textContent=Rc),pr.forEach(i),rt.forEach(i),rr=l(e),el=d(e,"P",{}),x(el).forEach(i),this.h()},h(){$(n,"name","hf:doc:metadata"),$(n,"content",Zu),$(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(dt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){o(document.head,n),c(e,M,p),c(e,r,p),c(e,s,p),h(u,e,p),c(e,t,p),h(w,e,p),c(e,tl,p),c(e,fn,p),c(e,nl,p),h(hn,e,p),c(e,ol,p),c(e,I,p),h(_n,I,null),o(I,mr),o(I,as),o(I,dr),o(I,ls),o(I,cr),o(I,rs),o(I,ur),o(I,is),o(I,gr),o(I,ps),o(I,fr),o(I,ms),o(I,hr),o(I,it),h(bn,it,null),o(it,_r),o(it,ds),o(I,br),o(I,pt),h(yn,pt,null),o(pt,yr),o(pt,cs),o(I,Tr),o(I,mt),h(Tn,mt,null),o(mt,Mr),o(mt,us),o(I,wr),o(I,dt),h(Mn,dt,null),o(dt,vr),o(dt,gs),o(I,xr),o(I,ct),h(wn,ct,null),o(ct,$r),o(ct,fs),c(e,sl,p),h(vn,e,p),c(e,al,p),c(e,xn,p),c(e,ll,p),h($n,e,p),c(e,rl,p),c(e,N,p),h(kn,N,null),o(N,kr),o(N,hs),o(N,jr),o(N,_s),o(N,Jr),o(N,bs),o(N,Rr),o(N,ae),h(jn,ae,null),o(ae,Ur),o(ae,ys),o(ae,Ir),h(ut,ae,null),o(ae,Zr),h(gt,ae,null),o(ae,Cr),h(ft,ae,null),c(e,il,p),h(Jn,e,p),c(e,pl,p),c(e,S,p),h(Rn,S,null),o(S,Wr),o(S,Ts),o(S,Nr),o(S,Ms),o(S,Sr),o(S,ws),o(S,Fr),o(S,le),h(Un,le,null),o(le,Gr),o(le,vs),o(le,Xr),h(ht,le,null),o(le,Or),h(_t,le,null),o(le,Vr),h(bt,le,null),c(e,ml,p),h(In,e,p),c(e,dl,p),c(e,F,p),h(Zn,F,null),o(F,zr),o(F,xs),o(F,qr),o(F,$s),o(F,Br),o(F,ks),o(F,Lr),o(F,re),h(Cn,re,null),o(re,Hr),o(re,js),o(re,Er),h(yt,re,null),o(re,Pr),h(Tt,re,null),o(re,Qr),h(Mt,re,null),c(e,cl,p),h(Wn,e,p),c(e,ul,p),c(e,G,p),h(Nn,G,null),o(G,Dr),o(G,Js),o(G,Yr),o(G,Rs),o(G,Ar),o(G,Us),o(G,Kr),o(G,W),h(Sn,W,null),o(W,ei),o(W,Is),o(W,ti),h(wt,W,null),o(W,ni),h(vt,W,null),o(W,oi),h(xt,W,null),o(W,si),h($t,W,null),c(e,gl,p),h(Fn,e,p),c(e,fl,p),c(e,X,p),h(Gn,X,null),o(X,ai),o(X,Zs),o(X,li),o(X,Cs),o(X,ri),o(X,Ws),o(X,ii),o(X,ie),h(Xn,ie,null),o(ie,pi),o(ie,Ns),o(ie,mi),h(kt,ie,null),o(ie,di),h(jt,ie,null),o(ie,ci),h(Jt,ie,null),c(e,hl,p),h(On,e,p),c(e,_l,p),c(e,O,p),h(Vn,O,null),o(O,ui),o(O,Ss),o(O,gi),o(O,Fs),o(O,fi),o(O,Gs),o(O,hi),o(O,Ye),h(zn,Ye,null),o(Ye,_i),o(Ye,Xs),o(Ye,bi),h(Rt,Ye,null),o(Ye,yi),h(Ut,Ye,null),c(e,bl,p),h(qn,e,p),c(e,yl,p),c(e,V,p),h(Bn,V,null),o(V,Ti),o(V,Os),o(V,Mi),o(V,Vs),o(V,wi),o(V,zs),o(V,vi),o(V,pe),h(Ln,pe,null),o(pe,xi),o(pe,qs),o(pe,$i),h(It,pe,null),o(pe,ki),h(Zt,pe,null),o(pe,ji),h(Ct,pe,null),c(e,Tl,p),h(Hn,e,p),c(e,Ml,p),c(e,En,p),c(e,wl,p),h(Pn,e,p),c(e,vl,p),c(e,z,p),h(Qn,z,null),o(z,Ji),o(z,Bs),o(z,Ri),o(z,Ls),o(z,Ui),o(z,Hs),o(z,Ii),o(z,me),h(Dn,me,null),o(me,Zi),o(me,Es),o(me,Ci),h(Wt,me,null),o(me,Wi),h(Nt,me,null),o(me,Ni),h(St,me,null),c(e,xl,p),h(Yn,e,p),c(e,$l,p),c(e,q,p),h(An,q,null),o(q,Si),o(q,Ps),o(q,Fi),o(q,Qs),o(q,Gi),o(q,Ds),o(q,Xi),o(q,de),h(Kn,de,null),o(de,Oi),o(de,Ys),o(de,Vi),h(Ft,de,null),o(de,zi),h(Gt,de,null),o(de,qi),h(Xt,de,null),c(e,kl,p),h(eo,e,p),c(e,jl,p),c(e,to,p),c(e,Jl,p),h(no,e,p),c(e,Rl,p),c(e,B,p),h(oo,B,null),o(B,Bi),o(B,As),o(B,Li),o(B,Ks),o(B,Hi),o(B,ea),o(B,Ei),o(B,ce),h(so,ce,null),o(ce,Pi),o(ce,ta),o(ce,Qi),h(Ot,ce,null),o(ce,Di),h(Vt,ce,null),o(ce,Yi),h(zt,ce,null),c(e,Ul,p),h(ao,e,p),c(e,Il,p),c(e,L,p),h(lo,L,null),o(L,Ai),o(L,na),o(L,Ki),o(L,oa),o(L,ep),o(L,sa),o(L,tp),o(L,Ae),h(ro,Ae,null),o(Ae,np),o(Ae,aa),o(Ae,op),h(qt,Ae,null),o(Ae,sp),h(Bt,Ae,null),c(e,Zl,p),h(io,e,p),c(e,Cl,p),c(e,H,p),h(po,H,null),o(H,ap),o(H,la),o(H,lp),o(H,ra),o(H,rp),o(H,ia),o(H,ip),o(H,Ke),h(mo,Ke,null),o(Ke,pp),o(Ke,pa),o(Ke,mp),h(Lt,Ke,null),o(Ke,dp),h(Ht,Ke,null),c(e,Wl,p),h(co,e,p),c(e,Nl,p),c(e,E,p),h(uo,E,null),o(E,cp),o(E,ma),o(E,up),o(E,da),o(E,gp),o(E,ca),o(E,fp),o(E,ue),h(go,ue,null),o(ue,hp),o(ue,ua),o(ue,_p),h(Et,ue,null),o(ue,bp),h(Pt,ue,null),o(ue,yp),h(Qt,ue,null),c(e,Sl,p),h(fo,e,p),c(e,Fl,p),c(e,P,p),h(ho,P,null),o(P,Tp),o(P,ga),o(P,Mp),o(P,fa),o(P,wp),o(P,ha),o(P,vp),o(P,et),h(_o,et,null),o(et,xp),o(et,_a),o(et,$p),h(Dt,et,null),o(et,kp),h(Yt,et,null),c(e,Gl,p),h(bo,e,p),c(e,Xl,p),c(e,yo,p),c(e,Ol,p),h(To,e,p),c(e,Vl,p),c(e,Q,p),h(Mo,Q,null),o(Q,jp),o(Q,ba),o(Q,Jp),o(Q,ya),o(Q,Rp),o(Q,Ta),o(Q,Up),o(Q,ge),h(wo,ge,null),o(ge,Ip),o(ge,Ma),o(ge,Zp),h(At,ge,null),o(ge,Cp),h(Kt,ge,null),o(ge,Wp),h(en,ge,null),c(e,zl,p),h(vo,e,p),c(e,ql,p),c(e,D,p),h(xo,D,null),o(D,Np),o(D,wa),o(D,Sp),o(D,va),o(D,Fp),o(D,xa),o(D,Gp),o(D,tt),h($o,tt,null),o(tt,Xp),o(tt,$a),o(tt,Op),h(tn,tt,null),o(tt,Vp),h(nn,tt,null),c(e,Bl,p),h(ko,e,p),c(e,Ll,p),c(e,jo,p),c(e,Hl,p),h(Jo,e,p),c(e,El,p),c(e,Y,p),h(Ro,Y,null),o(Y,zp),o(Y,ka),o(Y,qp),o(Y,ja),o(Y,Bp),o(Y,Ja),o(Y,Lp),o(Y,fe),h(Uo,fe,null),o(fe,Hp),o(fe,Ra),o(fe,Ep),h(on,fe,null),o(fe,Pp),h(sn,fe,null),o(fe,Qp),h(an,fe,null),c(e,Pl,p),h(Io,e,p),c(e,Ql,p),c(e,A,p),h(Zo,A,null),o(A,Dp),o(A,Ua),o(A,Yp),o(A,Ia),o(A,Ap),o(A,Za),o(A,Kp),o(A,he),h(Co,he,null),o(he,em),o(he,Ca),o(he,tm),h(ln,he,null),o(he,nm),h(rn,he,null),o(he,om),h(pn,he,null),c(e,Dl,p),h(Wo,e,p),c(e,Yl,p),h(No,e,p),c(e,Al,p),c(e,K,p),h(So,K,null),o(K,sm),o(K,Wa),o(K,am),o(K,Na),o(K,lm),o(K,Sa),o(K,rm),o(K,mn),h(Fo,mn,null),o(mn,im),o(mn,Fa),c(e,Kl,p),h(Go,e,p),c(e,er,p),c(e,ee,p),h(Xo,ee,null),o(ee,pm),o(ee,Ga),o(ee,mm),o(ee,Xa),o(ee,dm),o(ee,Oa),o(ee,cm),o(ee,dn),h(Oo,dn,null),o(dn,um),o(dn,Va),c(e,tr,p),h(Vo,e,p),c(e,nr,p),c(e,te,p),h(zo,te,null),o(te,gm),o(te,za),o(te,fm),o(te,qa),o(te,hm),o(te,Ba),o(te,_m),o(te,cn),h(qo,cn,null),o(cn,bm),o(cn,La),c(e,or,p),h(Bo,e,p),c(e,sr,p),c(e,ne,p),h(Lo,ne,null),o(ne,ym),o(ne,Ha),o(ne,Tm),o(ne,Ea),o(ne,Mm),o(ne,Pa),o(ne,wm),o(ne,un),h(Ho,un,null),o(un,vm),o(un,Qa),c(e,ar,p),h(Eo,e,p),c(e,lr,p),c(e,oe,p),h(Po,oe,null),o(oe,xm),o(oe,Da),o(oe,$m),o(oe,Ya),o(oe,km),o(oe,Aa),o(oe,jm),o(oe,gn),h(Qo,gn,null),o(gn,Jm),o(gn,Ka),c(e,rr,p),c(e,el,p),ir=!0},p(e,[p]){const Z={};p&2&&(Z.$$scope={dirty:p,ctx:e}),ut.$set(Z);const Do={};p&2&&(Do.$$scope={dirty:p,ctx:e}),gt.$set(Do);const Yo={};p&2&&(Yo.$$scope={dirty:p,ctx:e}),ft.$set(Yo);const Ao={};p&2&&(Ao.$$scope={dirty:p,ctx:e}),ht.$set(Ao);const Ko={};p&2&&(Ko.$$scope={dirty:p,ctx:e}),_t.$set(Ko);const es={};p&2&&(es.$$scope={dirty:p,ctx:e}),bt.$set(es);const _e={};p&2&&(_e.$$scope={dirty:p,ctx:e}),yt.$set(_e);const be={};p&2&&(be.$$scope={dirty:p,ctx:e}),Tt.$set(be);const ye={};p&2&&(ye.$$scope={dirty:p,ctx:e}),Mt.$set(ye);const Te={};p&2&&(Te.$$scope={dirty:p,ctx:e}),wt.$set(Te);const Me={};p&2&&(Me.$$scope={dirty:p,ctx:e}),vt.$set(Me);const we={};p&2&&(we.$$scope={dirty:p,ctx:e}),xt.$set(we);const ve={};p&2&&(ve.$$scope={dirty:p,ctx:e}),$t.$set(ve);const se={};p&2&&(se.$$scope={dirty:p,ctx:e}),kt.$set(se);const xe={};p&2&&(xe.$$scope={dirty:p,ctx:e}),jt.$set(xe);const $e={};p&2&&($e.$$scope={dirty:p,ctx:e}),Jt.$set($e);const ke={};p&2&&(ke.$$scope={dirty:p,ctx:e}),Rt.$set(ke);const nt={};p&2&&(nt.$$scope={dirty:p,ctx:e}),Ut.$set(nt);const je={};p&2&&(je.$$scope={dirty:p,ctx:e}),It.$set(je);const Je={};p&2&&(Je.$$scope={dirty:p,ctx:e}),Zt.$set(Je);const Re={};p&2&&(Re.$$scope={dirty:p,ctx:e}),Ct.$set(Re);const Ue={};p&2&&(Ue.$$scope={dirty:p,ctx:e}),Wt.$set(Ue);const Ie={};p&2&&(Ie.$$scope={dirty:p,ctx:e}),Nt.$set(Ie);const Ze={};p&2&&(Ze.$$scope={dirty:p,ctx:e}),St.$set(Ze);const Ce={};p&2&&(Ce.$$scope={dirty:p,ctx:e}),Ft.$set(Ce);const We={};p&2&&(We.$$scope={dirty:p,ctx:e}),Gt.$set(We);const Ne={};p&2&&(Ne.$$scope={dirty:p,ctx:e}),Xt.$set(Ne);const ot={};p&2&&(ot.$$scope={dirty:p,ctx:e}),Ot.$set(ot);const Se={};p&2&&(Se.$$scope={dirty:p,ctx:e}),Vt.$set(Se);const st={};p&2&&(st.$$scope={dirty:p,ctx:e}),zt.$set(st);const Fe={};p&2&&(Fe.$$scope={dirty:p,ctx:e}),qt.$set(Fe);const Ge={};p&2&&(Ge.$$scope={dirty:p,ctx:e}),Bt.$set(Ge);const Xe={};p&2&&(Xe.$$scope={dirty:p,ctx:e}),Lt.$set(Xe);const at={};p&2&&(at.$$scope={dirty:p,ctx:e}),Ht.$set(at);const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:e}),Et.$set(Oe);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:e}),Pt.$set(Ve);const ze={};p&2&&(ze.$$scope={dirty:p,ctx:e}),Qt.$set(ze);const lt={};p&2&&(lt.$$scope={dirty:p,ctx:e}),Dt.$set(lt);const qe={};p&2&&(qe.$$scope={dirty:p,ctx:e}),Yt.$set(qe);const Be={};p&2&&(Be.$$scope={dirty:p,ctx:e}),At.$set(Be);const Le={};p&2&&(Le.$$scope={dirty:p,ctx:e}),Kt.$set(Le);const He={};p&2&&(He.$$scope={dirty:p,ctx:e}),en.$set(He);const Ee={};p&2&&(Ee.$$scope={dirty:p,ctx:e}),tn.$set(Ee);const ts={};p&2&&(ts.$$scope={dirty:p,ctx:e}),nn.$set(ts);const Pe={};p&2&&(Pe.$$scope={dirty:p,ctx:e}),on.$set(Pe);const ns={};p&2&&(ns.$$scope={dirty:p,ctx:e}),sn.$set(ns);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:e}),an.$set(Qe);const os={};p&2&&(os.$$scope={dirty:p,ctx:e}),ln.$set(os);const De={};p&2&&(De.$$scope={dirty:p,ctx:e}),rn.$set(De);const ss={};p&2&&(ss.$$scope={dirty:p,ctx:e}),pn.$set(ss)},i(e){ir||(_(u.$$.fragment,e),_(w.$$.fragment,e),_(hn.$$.fragment,e),_(_n.$$.fragment,e),_(bn.$$.fragment,e),_(yn.$$.fragment,e),_(Tn.$$.fragment,e),_(Mn.$$.fragment,e),_(wn.$$.fragment,e),_(vn.$$.fragment,e),_($n.$$.fragment,e),_(kn.$$.fragment,e),_(jn.$$.fragment,e),_(ut.$$.fragment,e),_(gt.$$.fragment,e),_(ft.$$.fragment,e),_(Jn.$$.fragment,e),_(Rn.$$.fragment,e),_(Un.$$.fragment,e),_(ht.$$.fragment,e),_(_t.$$.fragment,e),_(bt.$$.fragment,e),_(In.$$.fragment,e),_(Zn.$$.fragment,e),_(Cn.$$.fragment,e),_(yt.$$.fragment,e),_(Tt.$$.fragment,e),_(Mt.$$.fragment,e),_(Wn.$$.fragment,e),_(Nn.$$.fragment,e),_(Sn.$$.fragment,e),_(wt.$$.fragment,e),_(vt.$$.fragment,e),_(xt.$$.fragment,e),_($t.$$.fragment,e),_(Fn.$$.fragment,e),_(Gn.$$.fragment,e),_(Xn.$$.fragment,e),_(kt.$$.fragment,e),_(jt.$$.fragment,e),_(Jt.$$.fragment,e),_(On.$$.fragment,e),_(Vn.$$.fragment,e),_(zn.$$.fragment,e),_(Rt.$$.fragment,e),_(Ut.$$.fragment,e),_(qn.$$.fragment,e),_(Bn.$$.fragment,e),_(Ln.$$.fragment,e),_(It.$$.fragment,e),_(Zt.$$.fragment,e),_(Ct.$$.fragment,e),_(Hn.$$.fragment,e),_(Pn.$$.fragment,e),_(Qn.$$.fragment,e),_(Dn.$$.fragment,e),_(Wt.$$.fragment,e),_(Nt.$$.fragment,e),_(St.$$.fragment,e),_(Yn.$$.fragment,e),_(An.$$.fragment,e),_(Kn.$$.fragment,e),_(Ft.$$.fragment,e),_(Gt.$$.fragment,e),_(Xt.$$.fragment,e),_(eo.$$.fragment,e),_(no.$$.fragment,e),_(oo.$$.fragment,e),_(so.$$.fragment,e),_(Ot.$$.fragment,e),_(Vt.$$.fragment,e),_(zt.$$.fragment,e),_(ao.$$.fragment,e),_(lo.$$.fragment,e),_(ro.$$.fragment,e),_(qt.$$.fragment,e),_(Bt.$$.fragment,e),_(io.$$.fragment,e),_(po.$$.fragment,e),_(mo.$$.fragment,e),_(Lt.$$.fragment,e),_(Ht.$$.fragment,e),_(co.$$.fragment,e),_(uo.$$.fragment,e),_(go.$$.fragment,e),_(Et.$$.fragment,e),_(Pt.$$.fragment,e),_(Qt.$$.fragment,e),_(fo.$$.fragment,e),_(ho.$$.fragment,e),_(_o.$$.fragment,e),_(Dt.$$.fragment,e),_(Yt.$$.fragment,e),_(bo.$$.fragment,e),_(To.$$.fragment,e),_(Mo.$$.fragment,e),_(wo.$$.fragment,e),_(At.$$.fragment,e),_(Kt.$$.fragment,e),_(en.$$.fragment,e),_(vo.$$.fragment,e),_(xo.$$.fragment,e),_($o.$$.fragment,e),_(tn.$$.fragment,e),_(nn.$$.fragment,e),_(ko.$$.fragment,e),_(Jo.$$.fragment,e),_(Ro.$$.fragment,e),_(Uo.$$.fragment,e),_(on.$$.fragment,e),_(sn.$$.fragment,e),_(an.$$.fragment,e),_(Io.$$.fragment,e),_(Zo.$$.fragment,e),_(Co.$$.fragment,e),_(ln.$$.fragment,e),_(rn.$$.fragment,e),_(pn.$$.fragment,e),_(Wo.$$.fragment,e),_(No.$$.fragment,e),_(So.$$.fragment,e),_(Fo.$$.fragment,e),_(Go.$$.fragment,e),_(Xo.$$.fragment,e),_(Oo.$$.fragment,e),_(Vo.$$.fragment,e),_(zo.$$.fragment,e),_(qo.$$.fragment,e),_(Bo.$$.fragment,e),_(Lo.$$.fragment,e),_(Ho.$$.fragment,e),_(Eo.$$.fragment,e),_(Po.$$.fragment,e),_(Qo.$$.fragment,e),ir=!0)},o(e){b(u.$$.fragment,e),b(w.$$.fragment,e),b(hn.$$.fragment,e),b(_n.$$.fragment,e),b(bn.$$.fragment,e),b(yn.$$.fragment,e),b(Tn.$$.fragment,e),b(Mn.$$.fragment,e),b(wn.$$.fragment,e),b(vn.$$.fragment,e),b($n.$$.fragment,e),b(kn.$$.fragment,e),b(jn.$$.fragment,e),b(ut.$$.fragment,e),b(gt.$$.fragment,e),b(ft.$$.fragment,e),b(Jn.$$.fragment,e),b(Rn.$$.fragment,e),b(Un.$$.fragment,e),b(ht.$$.fragment,e),b(_t.$$.fragment,e),b(bt.$$.fragment,e),b(In.$$.fragment,e),b(Zn.$$.fragment,e),b(Cn.$$.fragment,e),b(yt.$$.fragment,e),b(Tt.$$.fragment,e),b(Mt.$$.fragment,e),b(Wn.$$.fragment,e),b(Nn.$$.fragment,e),b(Sn.$$.fragment,e),b(wt.$$.fragment,e),b(vt.$$.fragment,e),b(xt.$$.fragment,e),b($t.$$.fragment,e),b(Fn.$$.fragment,e),b(Gn.$$.fragment,e),b(Xn.$$.fragment,e),b(kt.$$.fragment,e),b(jt.$$.fragment,e),b(Jt.$$.fragment,e),b(On.$$.fragment,e),b(Vn.$$.fragment,e),b(zn.$$.fragment,e),b(Rt.$$.fragment,e),b(Ut.$$.fragment,e),b(qn.$$.fragment,e),b(Bn.$$.fragment,e),b(Ln.$$.fragment,e),b(It.$$.fragment,e),b(Zt.$$.fragment,e),b(Ct.$$.fragment,e),b(Hn.$$.fragment,e),b(Pn.$$.fragment,e),b(Qn.$$.fragment,e),b(Dn.$$.fragment,e),b(Wt.$$.fragment,e),b(Nt.$$.fragment,e),b(St.$$.fragment,e),b(Yn.$$.fragment,e),b(An.$$.fragment,e),b(Kn.$$.fragment,e),b(Ft.$$.fragment,e),b(Gt.$$.fragment,e),b(Xt.$$.fragment,e),b(eo.$$.fragment,e),b(no.$$.fragment,e),b(oo.$$.fragment,e),b(so.$$.fragment,e),b(Ot.$$.fragment,e),b(Vt.$$.fragment,e),b(zt.$$.fragment,e),b(ao.$$.fragment,e),b(lo.$$.fragment,e),b(ro.$$.fragment,e),b(qt.$$.fragment,e),b(Bt.$$.fragment,e),b(io.$$.fragment,e),b(po.$$.fragment,e),b(mo.$$.fragment,e),b(Lt.$$.fragment,e),b(Ht.$$.fragment,e),b(co.$$.fragment,e),b(uo.$$.fragment,e),b(go.$$.fragment,e),b(Et.$$.fragment,e),b(Pt.$$.fragment,e),b(Qt.$$.fragment,e),b(fo.$$.fragment,e),b(ho.$$.fragment,e),b(_o.$$.fragment,e),b(Dt.$$.fragment,e),b(Yt.$$.fragment,e),b(bo.$$.fragment,e),b(To.$$.fragment,e),b(Mo.$$.fragment,e),b(wo.$$.fragment,e),b(At.$$.fragment,e),b(Kt.$$.fragment,e),b(en.$$.fragment,e),b(vo.$$.fragment,e),b(xo.$$.fragment,e),b($o.$$.fragment,e),b(tn.$$.fragment,e),b(nn.$$.fragment,e),b(ko.$$.fragment,e),b(Jo.$$.fragment,e),b(Ro.$$.fragment,e),b(Uo.$$.fragment,e),b(on.$$.fragment,e),b(sn.$$.fragment,e),b(an.$$.fragment,e),b(Io.$$.fragment,e),b(Zo.$$.fragment,e),b(Co.$$.fragment,e),b(ln.$$.fragment,e),b(rn.$$.fragment,e),b(pn.$$.fragment,e),b(Wo.$$.fragment,e),b(No.$$.fragment,e),b(So.$$.fragment,e),b(Fo.$$.fragment,e),b(Go.$$.fragment,e),b(Xo.$$.fragment,e),b(Oo.$$.fragment,e),b(Vo.$$.fragment,e),b(zo.$$.fragment,e),b(qo.$$.fragment,e),b(Bo.$$.fragment,e),b(Lo.$$.fragment,e),b(Ho.$$.fragment,e),b(Eo.$$.fragment,e),b(Po.$$.fragment,e),b(Qo.$$.fragment,e),ir=!1},d(e){e&&(i(M),i(r),i(s),i(t),i(tl),i(fn),i(nl),i(ol),i(I),i(sl),i(al),i(xn),i(ll),i(rl),i(N),i(il),i(pl),i(S),i(ml),i(dl),i(F),i(cl),i(ul),i(G),i(gl),i(fl),i(X),i(hl),i(_l),i(O),i(bl),i(yl),i(V),i(Tl),i(Ml),i(En),i(wl),i(vl),i(z),i(xl),i($l),i(q),i(kl),i(jl),i(to),i(Jl),i(Rl),i(B),i(Ul),i(Il),i(L),i(Zl),i(Cl),i(H),i(Wl),i(Nl),i(E),i(Sl),i(Fl),i(P),i(Gl),i(Xl),i(yo),i(Ol),i(Vl),i(Q),i(zl),i(ql),i(D),i(Bl),i(Ll),i(jo),i(Hl),i(El),i(Y),i(Pl),i(Ql),i(A),i(Dl),i(Yl),i(Al),i(K),i(Kl),i(er),i(ee),i(tr),i(nr),i(te),i(or),i(sr),i(ne),i(ar),i(lr),i(oe),i(rr),i(el)),i(n),y(u,e),y(w,e),y(hn,e),y(_n),y(bn),y(yn),y(Tn),y(Mn),y(wn),y(vn,e),y($n,e),y(kn),y(jn),y(ut),y(gt),y(ft),y(Jn,e),y(Rn),y(Un),y(ht),y(_t),y(bt),y(In,e),y(Zn),y(Cn),y(yt),y(Tt),y(Mt),y(Wn,e),y(Nn),y(Sn),y(wt),y(vt),y(xt),y($t),y(Fn,e),y(Gn),y(Xn),y(kt),y(jt),y(Jt),y(On,e),y(Vn),y(zn),y(Rt),y(Ut),y(qn,e),y(Bn),y(Ln),y(It),y(Zt),y(Ct),y(Hn,e),y(Pn,e),y(Qn),y(Dn),y(Wt),y(Nt),y(St),y(Yn,e),y(An),y(Kn),y(Ft),y(Gt),y(Xt),y(eo,e),y(no,e),y(oo),y(so),y(Ot),y(Vt),y(zt),y(ao,e),y(lo),y(ro),y(qt),y(Bt),y(io,e),y(po),y(mo),y(Lt),y(Ht),y(co,e),y(uo),y(go),y(Et),y(Pt),y(Qt),y(fo,e),y(ho),y(_o),y(Dt),y(Yt),y(bo,e),y(To,e),y(Mo),y(wo),y(At),y(Kt),y(en),y(vo,e),y(xo),y($o),y(tn),y(nn),y(ko,e),y(Jo,e),y(Ro),y(Uo),y(on),y(sn),y(an),y(Io,e),y(Zo),y(Co),y(ln),y(rn),y(pn),y(Wo,e),y(No,e),y(So),y(Fo),y(Go,e),y(Xo),y(Oo),y(Vo,e),y(zo),y(qo),y(Bo,e),y(Lo),y(Ho),y(Eo,e),y(Po),y(Qo)}}}const Zu='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"ORTModel","local":"optimum.onnxruntime.ORTModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"ORTModelForCausalLM","local":"optimum.onnxruntime.ORTModelForCausalLM","sections":[],"depth":3},{"title":"ORTModelForMaskedLM","local":"optimum.onnxruntime.ORTModelForMaskedLM","sections":[],"depth":3},{"title":"ORTModelForSeq2SeqLM","local":"optimum.onnxruntime.ORTModelForSeq2SeqLM","sections":[],"depth":3},{"title":"ORTModelForSequenceClassification","local":"optimum.onnxruntime.ORTModelForSequenceClassification","sections":[],"depth":3},{"title":"ORTModelForTokenClassification","local":"optimum.onnxruntime.ORTModelForTokenClassification","sections":[],"depth":3},{"title":"ORTModelForMultipleChoice","local":"optimum.onnxruntime.ORTModelForMultipleChoice","sections":[],"depth":3},{"title":"ORTModelForQuestionAnswering","local":"optimum.onnxruntime.ORTModelForQuestionAnswering","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"ORTModelForImageClassification","local":"optimum.onnxruntime.ORTModelForImageClassification","sections":[],"depth":3},{"title":"ORTModelForSemanticSegmentation","local":"optimum.onnxruntime.ORTModelForSemanticSegmentation","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"ORTModelForAudioClassification","local":"optimum.onnxruntime.ORTModelForAudioClassification","sections":[],"depth":3},{"title":"ORTModelForAudioFrameClassification","local":"optimum.onnxruntime.ORTModelForAudioFrameClassification","sections":[],"depth":3},{"title":"ORTModelForCTC","local":"optimum.onnxruntime.ORTModelForCTC","sections":[],"depth":3},{"title":"ORTModelForSpeechSeq2Seq","local":"optimum.onnxruntime.ORTModelForSpeechSeq2Seq","sections":[],"depth":3},{"title":"ORTModelForAudioXVector","local":"optimum.onnxruntime.ORTModelForAudioXVector","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"ORTModelForVision2Seq","local":"optimum.onnxruntime.ORTModelForVision2Seq","sections":[],"depth":3},{"title":"ORTModelForPix2Struct","local":"optimum.onnxruntime.ORTModelForPix2Struct","sections":[],"depth":3}],"depth":2},{"title":"Custom Tasks","local":"custom-tasks","sections":[{"title":"ORTModelForCustomTasks","local":"optimum.onnxruntime.ORTModelForCustomTasks","sections":[],"depth":4},{"title":"ORTModelForFeatureExtraction","local":"optimum.onnxruntime.ORTModelForFeatureExtraction","sections":[],"depth":4}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"ORTStableDiffusionPipeline","local":"optimum.onnxruntime.ORTStableDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.onnxruntime.ORTStableDiffusionInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.onnxruntime.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function Cu(v){return Ic(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vu extends Zc{constructor(n){super(),Cc(this,n,Cu,Iu,Uc,{})}}export{Vu as component};
