import{s as Xl,n as Bl,o as Gl}from"../chunks/scheduler.6062bdaf.js";import{S as Il,i as Rl,g as d,s as n,r as i,A as $l,h as c,f as t,c as a,j as Wl,u as m,x as b,k as al,y as vl,a as s,v as p,d as o,t as r,w as u}from"../chunks/index.4bca734e.js";import{C as M}from"../chunks/CodeBlock.fa01571c.js";import{H as y}from"../chunks/Heading.723dceba.js";function Nl(il){let f,ue,oe,de,J,ce,g,ml=`Optimum is a utility package for building and running inference with accelerated runtime like ONNX Runtime.
Optimum can be used to load optimized models from the <a href="hf.co/models">Hugging Face Hub</a> and create pipelines
to run accelerated inference without rewriting your APIs.`,be,T,Me,w,pl=`The <code>optimum.onnxruntime.ORTModelForXXX</code> model classes are API compatible with Hugging Face Transformers models. This
means you can just replace your <code>AutoModelForXXX</code> class with the corresponding <code>ORTModelForXXX</code> class in <code>optimum.onnxruntime</code>.`,ye,Z,ol="You do not need to adapt your code to get it to work with <code>ORTModelForXXX</code> classes:",fe,U,he,j,Je,W,rl=`Because the model you want to work with might not be already converted to ONNX,  <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>
includes a method to convert vanilla Transformers models to ONNX ones. Simply pass <code>export=True</code> to the
<a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">from_pretrained()</a> method, and your model will be loaded and converted to ONNX on-the-fly:`,ge,X,Te,B,we,G,ul=`It is also possible, just as with regular <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel" rel="nofollow">PreTrainedModel</a>s, to push your <code>ORTModelForXXX</code> to the
<a href="https://hf.co/models" rel="nofollow">Hugging Face Model Hub</a>:`,Ze,I,Ue,R,je,$,dl=`Sequence-to-sequence (Seq2Seq) models can also be used when running inference with ONNX Runtime. When Seq2Seq models
are exported to the ONNX format, they are decomposed into three parts that are later combined during inference:`,We,v,cl=`<li>The encoder part of the model</li> <li>The decoder part of the model + the language modeling head</li> <li>The same decoder part of the model + language modeling head but taking and using pre-computed key / values as inputs and
outputs. This makes inference faster.</li>`,Xe,N,bl="Here is an example of how you can load a T5 model to the ONNX format and run inference for a translation task:",Be,k,Ge,x,Ie,S,Ml=`Stable Diffusion models can also be used when running inference with ONNX Runtime. When Stable Diffusion models
are exported to the ONNX format, they are split into four components that are later combined during inference:`,Re,V,yl="<li>The text encoder</li> <li>The U-NET</li> <li>The VAE encoder</li> <li>The VAE decoder</li>",$e,C,fl="Make sure you have 🤗 Diffusers installed.",ve,F,hl="To install <code>diffusers</code>:",Ne,E,ke,Q,xe,_,Jl="Here is an example of how you can load an ONNX Stable Diffusion model and run inference using ONNX Runtime:",Se,Y,Ve,H,gl="To load your PyTorch model and convert it to ONNX on-the-fly, you can set <code>export=True</code>.",Ce,q,Fe,h,Tl='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/onnxruntime/stable_diffusion_v1_5_ort_sail_boat.png"/>',Ee,z,Qe,L,_e,O,Ye,P,He,A,qe,D,wl="Before using <code>ORTStableDiffusionXLPipeline</code> make sure to have <code>diffusers</code> and <code>invisible_watermark</code> installed. You can install the libraries as follows:",ze,K,Le,ee,Oe,le,Zl='Here is an example of how you can load a SDXL ONNX model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> and run inference using ONNX Runtime :',Pe,te,Ae,se,De,ne,Ul="Here is an example of how you can load a PyTorch SDXL model, convert it to ONNX on-the-fly and run inference using ONNX Runtime for <em>image-to-image</em> :",Ke,ae,el,ie,ll,me,jl='The image can be refined by making use of a model like <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-refiner-1.0</a>. In this case, you only have to output the latents from the base model.',tl,pe,sl,re,nl;return J=new y({props:{title:"Optimum Inference with ONNX Runtime",local:"optimum-inference-with-onnx-runtime",headingTag:"h1"}}),T=new y({props:{title:"Switching from Transformers to Optimum",local:"switching-from-transformers-to-optimum",headingTag:"h2"}}),U=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQS1mcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMkJmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEEtbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcHNldCUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTIwJTIzJTIwUHlUb3JjaCUyMGNoZWNrcG9pbnQlMEElMkJtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUyMCUyMyUyME9OTlglMjBjaGVja3BvaW50JTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcHNldCUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQ21vZGVsJTNEbW9kZWwlMkN0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMjAlM0QlMjAlMjJXaGF0J3MlMjBteSUyMG5hbWUlM0YlMjIlMEFjb250ZXh0JTIwJTNEJTIwJTIyTXklMjBuYW1lJTIwaXMlMjBQaGlsaXBwJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyME51cmVtYmVyZy4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMGNvbnRleHQp",highlighted:`from transformers import AutoTokenizer, pipeline
<span class="hljs-deletion">-from transformers import AutoModelForQuestionAnswering</span>
<span class="hljs-addition">+from optimum.onnxruntime import ORTModelForQuestionAnswering</span>

<span class="hljs-deletion">-model = AutoModelForQuestionAnswering.from_pretrained(&quot;deepset/roberta-base-squad2&quot;) # PyTorch checkpoint</span>
<span class="hljs-addition">+model = ORTModelForQuestionAnswering.from_pretrained(&quot;optimum/roberta-base-squad2&quot;) # ONNX checkpoint</span>
tokenizer = AutoTokenizer.from_pretrained(&quot;deepset/roberta-base-squad2&quot;)

onnx_qa = pipeline(&quot;question-answering&quot;,model=model,tokenizer=tokenizer)

question = &quot;What&#x27;s my name?&quot;
context = &quot;My name is Philipp and I live in Nuremberg.&quot;
pred = onnx_qa(question, context)`,wrap:!1}}),j=new y({props:{title:"Loading a vanilla Transformers model",local:"loading-a-vanilla-transformers-model",headingTag:"h3"}}),X=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwaHViJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMkMlMjBleHBvcnQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>, export=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),B=new y({props:{title:"Pushing ONNX models to the Hugging Face Hub",local:"pushing-onnx-models-to-the-hugging-face-hub",headingTag:"h3"}}),I=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwaHViJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMkMlMjBleHBvcnQlM0RUcnVlJTBBKSUwQSUwQSUyMyUyMFNhdmUlMjB0aGUlMjBjb252ZXJ0ZWQlMjBtb2RlbCUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJhX2xvY2FsX3BhdGhfZm9yX2NvbnZlcnRfb25ueF9tb2RlbCUyMiklMEElMEFtb2RlbC5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjJhX2xvY2FsX3BhdGhfZm9yX2NvbnZlcnRfb25ueF9tb2RlbCUyMiUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1vbm54LXJlcG8lMjIlMkMlMjB1c2VfYXV0aF90b2tlbiUzRFRydWUlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>, export=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the converted model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;a_local_path_for_convert_onnx_model&quot;</span>)

<span class="hljs-comment"># Push the onnx model to HF Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;a_local_path_for_convert_onnx_model&quot;</span>, repository_id=<span class="hljs-string">&quot;my-onnx-repo&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),R=new y({props:{title:"Sequence-to-sequence models",local:"sequence-to-sequence-models",headingTag:"h2"}}),k=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbF9uYW1lJTIwJTNEJTIwJTIydDUtc21hbGwlMjIlMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9uYW1lKSUwQSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19mciUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBdGV4dCUyMCUzRCUyMCUyMkhlJTIwbmV2ZXIlMjB3ZW50JTIwb3V0JTIwd2l0aG91dCUyMGElMjBib29rJTIwdW5kZXIlMjBoaXMlMjBhcm0lMkMlMjBhbmQlMjBoZSUyMG9mdGVuJTIwY2FtZSUyMGJhY2slMjB3aXRoJTIwdHdvLiUyMiUwQXJlc3VsdCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCklMEElMjMlMjAlNUIlN0IndHJhbnNsYXRpb25fdGV4dCclM0ElMjAlMjJJbCUyMG4nZXN0JTIwamFtYWlzJTIwc29ydGklMjBzYW5zJTIwdW4lMjBsaXZyZSUyMHNvdXMlMjBzb24lMjBicmFzJTJDJTIwZXQlMjBpbCUyMGVzdCUyMHNvdXZlbnQlMjByZXZlbnUlMjBhdmVjJTIwZGV1eC4lMjIlN0QlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = <span class="hljs-string">&quot;t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(model_name, export=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_name)

<span class="hljs-comment"># Create a pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_fr&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;He never went out without a book under his arm, and he often came back with two.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = onnx_translation(text)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [{&#x27;translation_text&#x27;: &quot;Il n&#x27;est jamais sorti sans un livre sous son bras, et il est souvent revenu avec deux.&quot;}]</span>`,wrap:!1}}),x=new y({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),E=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2Vycw==",highlighted:"pip install diffusers",wrap:!1}}),Q=new y({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),Y=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25QaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHJldmlzaW9uJTNEJTIyb25ueCUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJzYWlsaW5nJTIwc2hpcCUyMGluJTIwc3Rvcm0lMjBieSUyMExlb25hcmRvJTIwZGElMjBWaW5jaSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = ORTStableDiffusionPipeline.from_pretrained(model_id, revision=<span class="hljs-string">&quot;onnx&quot;</span>)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
image = pipeline(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),q=new M({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBPUlRTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQSUyMyUyMERvbid0JTIwZm9yZ2V0JTIwdG8lMjBzYXZlJTIwdGhlJTIwT05OWCUyMG1vZGVsJTBBc2F2ZV9kaXJlY3RvcnklMjAlM0QlMjAlMjJhX2xvY2FsX3BhdGglMjIlMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3Rvcnkp",highlighted:`pipeline = ORTStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Don&#x27;t forget to save the ONNX model</span>
save_directory = <span class="hljs-string">&quot;a_local_path&quot;</span>
pipeline.save_pretrained(save_directory)`,wrap:!1}}),z=new y({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),L=new M({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMm9ubnglMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhyZXNwb25zZS5jb250ZW50KSkuY29udmVydCglMjJSR0IlMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg3NjglMkMlMjA1MTIpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwdHJlbmRpbmclMjBvbiUyMGFydHN0YXRpb24lMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC43NSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy41KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmYW50YXN5X2xhbmRzY2FwZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = ORTStableDiffusionImg2ImgPipeline.from_pretrained(model_id, revision=<span class="hljs-string">&quot;onnx&quot;</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),O=new y({props:{title:"Inpaint",local:"inpaint",headingTag:"h3"}}),P=new M({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLWlucGFpbnRpbmclMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjByZXZpc2lvbiUzRCUyMm9ubnglMjIpJTBBJTBBZGVmJTIwZG93bmxvYWRfaW1hZ2UodXJsKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBQSUwuSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWdfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW8ucG5nJTIyJTBBbWFza191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGbGF0ZW50LWRpZmZ1c2lvbiUyRm1haW4lMkZkYXRhJTJGaW5wYWludGluZ19leGFtcGxlcyUyRm92ZXJ0dXJlLWNyZWF0aW9ucy01c0k2ZlFnWUl1b19tYXNrLnBuZyUyMiUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBkb3dubG9hZF9pbWFnZShpbWdfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBbWFza19pbWFnZSUyMCUzRCUyMGRvd25sb2FkX2ltYWdlKG1hc2tfdXJsKS5yZXNpemUoKDUxMiUyQyUyMDUxMikpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyRmFjZSUyMG9mJTIwYSUyMHllbGxvdyUyMGNhdCUyQyUyMGhpZ2glMjByZXNvbHV0aW9uJTJDJTIwc2l0dGluZyUyMG9uJTIwYSUyMHBhcmslMjBiZW5jaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionInpaintPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>
pipeline = ORTStableDiffusionInpaintPipeline.from_pretrained(model_id, revision=<span class="hljs-string">&quot;onnx&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
    response = requests.get(url)
    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)

img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>

init_image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
mask_image = download_image(mask_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
image = pipeline(prompt=prompt, image=init_image, mask_image=mask_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new y({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),K=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRpZmZ1c2VycyUwQXBpcCUyMGluc3RhbGwlMjBpbnZpc2libGUtd2F0ZXJtYXJrJTNFJTNEMC4yLjA=",highlighted:`pip install diffusers
pip install invisible-watermark&gt;=0.2.0`,wrap:!1}}),ee=new y({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),te=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMEFiYXNlJTIwJTNEJTIwT1JUU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBcHJvbXB0JTIwJTNEJTIwJTIyc2FpbGluZyUyMHNoaXAlMjBpbiUyMHN0b3JtJTIwYnklMjBMZW9uYXJkbyUyMGRhJTIwVmluY2klMjIlMEFpbWFnZSUyMCUzRCUyMGJhc2UocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTBBJTIzJTIwRG9uJ3QlMjBmb3JnZXQlMjB0byUyMHNhdmUlMjB0aGUlMjBPTk5YJTIwbW9kZWwlMEFzYXZlX2RpcmVjdG9yeSUyMCUzRCUyMCUyMnNkX3hsX2Jhc2UlMjIlMEFiYXNlLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSk=",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
base = ORTStableDiffusionXLPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
image = base(prompt).images[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Don&#x27;t forget to save the ONNX model</span>
save_directory = <span class="hljs-string">&quot;sd_xl_base&quot;</span>
base.save_pretrained(save_directory)`,wrap:!1}}),se=new y({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),ae=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMEFwaXBlbGluZSUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGb3B0aW11bSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZpbnRlbCUyRm9wZW52aW5vJTJGc2RfeGwlMkZjYXN0bGVfZnJpZWRyaWNoLnBuZyUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMm1lZGlldmFsJTIwY2FzdGxlJTIwYnklMjBDYXNwYXIlMjBEYXZpZCUyMEZyaWVkcmljaCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaW1hZ2UlM0RpbWFnZSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIybWVkaWV2YWxfY2FzdGxlLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
pipeline = ORTStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;medieval castle by Caspar David Friedrich&quot;</span>
image = pipeline(prompt, image=image).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;medieval_castle.png&quot;</span>)`,wrap:!1}}),ie=new y({props:{title:"Refining the image output",local:"refining-the-image-output",headingTag:"h3"}}),pe=new M({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLXJlZmluZXItMS4wJTIyJTBBcmVmaW5lciUyMCUzRCUyME9SVFN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBaW1hZ2UlMjAlM0QlMjBiYXNlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjByZWZpbmVyKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UlNUJOb25lJTJDJTIwJTNBJTVEKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzYWlsaW5nX3NoaXAucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTStableDiffusionXLImg2ImgPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
refiner = ORTStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;sailing_ship.png&quot;</span>)`,wrap:!1}}),{c(){f=d("meta"),ue=n(),oe=d("p"),de=n(),i(J.$$.fragment),ce=n(),g=d("p"),g.innerHTML=ml,be=n(),i(T.$$.fragment),Me=n(),w=d("p"),w.innerHTML=pl,ye=n(),Z=d("p"),Z.innerHTML=ol,fe=n(),i(U.$$.fragment),he=n(),i(j.$$.fragment),Je=n(),W=d("p"),W.innerHTML=rl,ge=n(),i(X.$$.fragment),Te=n(),i(B.$$.fragment),we=n(),G=d("p"),G.innerHTML=ul,Ze=n(),i(I.$$.fragment),Ue=n(),i(R.$$.fragment),je=n(),$=d("p"),$.textContent=dl,We=n(),v=d("ul"),v.innerHTML=cl,Xe=n(),N=d("p"),N.textContent=bl,Be=n(),i(k.$$.fragment),Ge=n(),i(x.$$.fragment),Ie=n(),S=d("p"),S.textContent=Ml,Re=n(),V=d("ul"),V.innerHTML=yl,$e=n(),C=d("p"),C.textContent=fl,ve=n(),F=d("p"),F.innerHTML=hl,Ne=n(),i(E.$$.fragment),ke=n(),i(Q.$$.fragment),xe=n(),_=d("p"),_.textContent=Jl,Se=n(),i(Y.$$.fragment),Ve=n(),H=d("p"),H.innerHTML=gl,Ce=n(),i(q.$$.fragment),Fe=n(),h=d("div"),h.innerHTML=Tl,Ee=n(),i(z.$$.fragment),Qe=n(),i(L.$$.fragment),_e=n(),i(O.$$.fragment),Ye=n(),i(P.$$.fragment),He=n(),i(A.$$.fragment),qe=n(),D=d("p"),D.innerHTML=wl,ze=n(),i(K.$$.fragment),Le=n(),i(ee.$$.fragment),Oe=n(),le=d("p"),le.innerHTML=Zl,Pe=n(),i(te.$$.fragment),Ae=n(),i(se.$$.fragment),De=n(),ne=d("p"),ne.innerHTML=Ul,Ke=n(),i(ae.$$.fragment),el=n(),i(ie.$$.fragment),ll=n(),me=d("p"),me.innerHTML=jl,tl=n(),i(pe.$$.fragment),sl=n(),re=d("p"),this.h()},l(e){const l=$l("svelte-u9bgzb",document.head);f=c(l,"META",{name:!0,content:!0}),l.forEach(t),ue=a(e),oe=c(e,"P",{}),Wl(oe).forEach(t),de=a(e),m(J.$$.fragment,e),ce=a(e),g=c(e,"P",{"data-svelte-h":!0}),b(g)!=="svelte-4xrbw1"&&(g.innerHTML=ml),be=a(e),m(T.$$.fragment,e),Me=a(e),w=c(e,"P",{"data-svelte-h":!0}),b(w)!=="svelte-rq0os"&&(w.innerHTML=pl),ye=a(e),Z=c(e,"P",{"data-svelte-h":!0}),b(Z)!=="svelte-182to9s"&&(Z.innerHTML=ol),fe=a(e),m(U.$$.fragment,e),he=a(e),m(j.$$.fragment,e),Je=a(e),W=c(e,"P",{"data-svelte-h":!0}),b(W)!=="svelte-1j4ucjr"&&(W.innerHTML=rl),ge=a(e),m(X.$$.fragment,e),Te=a(e),m(B.$$.fragment,e),we=a(e),G=c(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-fs10ay"&&(G.innerHTML=ul),Ze=a(e),m(I.$$.fragment,e),Ue=a(e),m(R.$$.fragment,e),je=a(e),$=c(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-g9kxqu"&&($.textContent=dl),We=a(e),v=c(e,"UL",{"data-svelte-h":!0}),b(v)!=="svelte-ugiogr"&&(v.innerHTML=cl),Xe=a(e),N=c(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-jyc43"&&(N.textContent=bl),Be=a(e),m(k.$$.fragment,e),Ge=a(e),m(x.$$.fragment,e),Ie=a(e),S=c(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-h8xsd7"&&(S.textContent=Ml),Re=a(e),V=c(e,"UL",{"data-svelte-h":!0}),b(V)!=="svelte-bu3ryq"&&(V.innerHTML=yl),$e=a(e),C=c(e,"P",{"data-svelte-h":!0}),b(C)!=="svelte-1itwfg8"&&(C.textContent=fl),ve=a(e),F=c(e,"P",{"data-svelte-h":!0}),b(F)!=="svelte-1nlmsjk"&&(F.innerHTML=hl),Ne=a(e),m(E.$$.fragment,e),ke=a(e),m(Q.$$.fragment,e),xe=a(e),_=c(e,"P",{"data-svelte-h":!0}),b(_)!=="svelte-s2wxrw"&&(_.textContent=Jl),Se=a(e),m(Y.$$.fragment,e),Ve=a(e),H=c(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-vf0f3x"&&(H.innerHTML=gl),Ce=a(e),m(q.$$.fragment,e),Fe=a(e),h=c(e,"DIV",{class:!0,"data-svelte-h":!0}),b(h)!=="svelte-1pusq1s"&&(h.innerHTML=Tl),Ee=a(e),m(z.$$.fragment,e),Qe=a(e),m(L.$$.fragment,e),_e=a(e),m(O.$$.fragment,e),Ye=a(e),m(P.$$.fragment,e),He=a(e),m(A.$$.fragment,e),qe=a(e),D=c(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-rwvcml"&&(D.innerHTML=wl),ze=a(e),m(K.$$.fragment,e),Le=a(e),m(ee.$$.fragment,e),Oe=a(e),le=c(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-tg9ftm"&&(le.innerHTML=Zl),Pe=a(e),m(te.$$.fragment,e),Ae=a(e),m(se.$$.fragment,e),De=a(e),ne=c(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-gtkw23"&&(ne.innerHTML=Ul),Ke=a(e),m(ae.$$.fragment,e),el=a(e),m(ie.$$.fragment,e),ll=a(e),me=c(e,"P",{"data-svelte-h":!0}),b(me)!=="svelte-1lzmdpv"&&(me.innerHTML=jl),tl=a(e),m(pe.$$.fragment,e),sl=a(e),re=c(e,"P",{}),Wl(re).forEach(t),this.h()},h(){al(f,"name","hf:doc:metadata"),al(f,"content",kl),al(h,"class","flex justify-center")},m(e,l){vl(document.head,f),s(e,ue,l),s(e,oe,l),s(e,de,l),p(J,e,l),s(e,ce,l),s(e,g,l),s(e,be,l),p(T,e,l),s(e,Me,l),s(e,w,l),s(e,ye,l),s(e,Z,l),s(e,fe,l),p(U,e,l),s(e,he,l),p(j,e,l),s(e,Je,l),s(e,W,l),s(e,ge,l),p(X,e,l),s(e,Te,l),p(B,e,l),s(e,we,l),s(e,G,l),s(e,Ze,l),p(I,e,l),s(e,Ue,l),p(R,e,l),s(e,je,l),s(e,$,l),s(e,We,l),s(e,v,l),s(e,Xe,l),s(e,N,l),s(e,Be,l),p(k,e,l),s(e,Ge,l),p(x,e,l),s(e,Ie,l),s(e,S,l),s(e,Re,l),s(e,V,l),s(e,$e,l),s(e,C,l),s(e,ve,l),s(e,F,l),s(e,Ne,l),p(E,e,l),s(e,ke,l),p(Q,e,l),s(e,xe,l),s(e,_,l),s(e,Se,l),p(Y,e,l),s(e,Ve,l),s(e,H,l),s(e,Ce,l),p(q,e,l),s(e,Fe,l),s(e,h,l),s(e,Ee,l),p(z,e,l),s(e,Qe,l),p(L,e,l),s(e,_e,l),p(O,e,l),s(e,Ye,l),p(P,e,l),s(e,He,l),p(A,e,l),s(e,qe,l),s(e,D,l),s(e,ze,l),p(K,e,l),s(e,Le,l),p(ee,e,l),s(e,Oe,l),s(e,le,l),s(e,Pe,l),p(te,e,l),s(e,Ae,l),p(se,e,l),s(e,De,l),s(e,ne,l),s(e,Ke,l),p(ae,e,l),s(e,el,l),p(ie,e,l),s(e,ll,l),s(e,me,l),s(e,tl,l),p(pe,e,l),s(e,sl,l),s(e,re,l),nl=!0},p:Bl,i(e){nl||(o(J.$$.fragment,e),o(T.$$.fragment,e),o(U.$$.fragment,e),o(j.$$.fragment,e),o(X.$$.fragment,e),o(B.$$.fragment,e),o(I.$$.fragment,e),o(R.$$.fragment,e),o(k.$$.fragment,e),o(x.$$.fragment,e),o(E.$$.fragment,e),o(Q.$$.fragment,e),o(Y.$$.fragment,e),o(q.$$.fragment,e),o(z.$$.fragment,e),o(L.$$.fragment,e),o(O.$$.fragment,e),o(P.$$.fragment,e),o(A.$$.fragment,e),o(K.$$.fragment,e),o(ee.$$.fragment,e),o(te.$$.fragment,e),o(se.$$.fragment,e),o(ae.$$.fragment,e),o(ie.$$.fragment,e),o(pe.$$.fragment,e),nl=!0)},o(e){r(J.$$.fragment,e),r(T.$$.fragment,e),r(U.$$.fragment,e),r(j.$$.fragment,e),r(X.$$.fragment,e),r(B.$$.fragment,e),r(I.$$.fragment,e),r(R.$$.fragment,e),r(k.$$.fragment,e),r(x.$$.fragment,e),r(E.$$.fragment,e),r(Q.$$.fragment,e),r(Y.$$.fragment,e),r(q.$$.fragment,e),r(z.$$.fragment,e),r(L.$$.fragment,e),r(O.$$.fragment,e),r(P.$$.fragment,e),r(A.$$.fragment,e),r(K.$$.fragment,e),r(ee.$$.fragment,e),r(te.$$.fragment,e),r(se.$$.fragment,e),r(ae.$$.fragment,e),r(ie.$$.fragment,e),r(pe.$$.fragment,e),nl=!1},d(e){e&&(t(ue),t(oe),t(de),t(ce),t(g),t(be),t(Me),t(w),t(ye),t(Z),t(fe),t(he),t(Je),t(W),t(ge),t(Te),t(we),t(G),t(Ze),t(Ue),t(je),t($),t(We),t(v),t(Xe),t(N),t(Be),t(Ge),t(Ie),t(S),t(Re),t(V),t($e),t(C),t(ve),t(F),t(Ne),t(ke),t(xe),t(_),t(Se),t(Ve),t(H),t(Ce),t(Fe),t(h),t(Ee),t(Qe),t(_e),t(Ye),t(He),t(qe),t(D),t(ze),t(Le),t(Oe),t(le),t(Pe),t(Ae),t(De),t(ne),t(Ke),t(el),t(ll),t(me),t(tl),t(sl),t(re)),t(f),u(J,e),u(T,e),u(U,e),u(j,e),u(X,e),u(B,e),u(I,e),u(R,e),u(k,e),u(x,e),u(E,e),u(Q,e),u(Y,e),u(q,e),u(z,e),u(L,e),u(O,e),u(P,e),u(A,e),u(K,e),u(ee,e),u(te,e),u(se,e),u(ae,e),u(ie,e),u(pe,e)}}}const kl='{"title":"Optimum Inference with ONNX Runtime","local":"optimum-inference-with-onnx-runtime","sections":[{"title":"Switching from Transformers to Optimum","local":"switching-from-transformers-to-optimum","sections":[{"title":"Loading a vanilla Transformers model","local":"loading-a-vanilla-transformers-model","sections":[],"depth":3},{"title":"Pushing ONNX models to the Hugging Face Hub","local":"pushing-onnx-models-to-the-hugging-face-hub","sections":[],"depth":3}],"depth":2},{"title":"Sequence-to-sequence models","local":"sequence-to-sequence-models","sections":[],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Inpaint","local":"inpaint","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Refining the image output","local":"refining-the-image-output","sections":[],"depth":3}],"depth":2}],"depth":1}';function xl(il){return Gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class El extends Il{constructor(f){super(),Rl(this,f,xl,Nl,Xl,{})}}export{El as component};
