import{s as Cn,n as In,o as wn}from"../chunks/scheduler.56730f09.js";import{S as jn,i as Jn,g as l,s as r,r as g,A as kn,h as d,f as n,c as a,j as vn,u as o,x as c,k as De,y as Rn,a as i,v as s,d as m,t as h,w as p}from"../chunks/index.61415d3e.js";import{C as Ne}from"../chunks/CodeBlock.e6fa6bff.js";import{H as f}from"../chunks/Heading.9036b585.js";function Un(He){let b,jt,It,Jt,u,kt,y,Be='このガイドは、<a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow"><code>torch.compile()</code></a> を使用した推論速度の向上に関するベンチマークを提供することを目的としています。これは、<a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;library=transformers&amp;sort=trending" rel="nofollow">🤗 Transformers のコンピュータビジョンモデル</a>向けのものです。',Rt,$,Ut,v,ze=`<code>torch.compile()</code>の利点
モデルとGPUによっては、torch.compile()は推論時に最大30%の高速化を実現します。  <code>torch.compile()</code>を使用するには、バージョン2.0以上のtorchをインストールするだけです。`,Et,C,We=`モデルのコンパイルには時間がかかるため、毎回推論するのではなく、モデルを1度だけコンパイルする場合に役立ちます。
任意のコンピュータビジョンモデルをコンパイルするには、以下のようにモデルに<code>torch.compile()</code>を呼び出します：`,_t,I,Zt,w,Ve='<code>compile()</code> は、コンパイルに関する異なるモードを備えており、基本的にはコンパイル時間と推論のオーバーヘッドが異なります。<code>max-autotune</code> は <code>reduce-overhead</code> よりも時間がかかりますが、推論速度が速くなります。デフォルトモードはコンパイルにおいては最速ですが、推論時間においては <code>reduce-overhead</code> に比べて効率が良くありません。このガイドでは、デフォルトモードを使用しました。詳細については、<a href="https://pytorch.org/get-started/pytorch-2.0/#user-experience" rel="nofollow">こちら</a> を参照してください。',St,j,Oe="<code>torch</code> バージョン 2.0.1 で異なるコンピュータビジョンモデル、タスク、ハードウェアの種類、およびバッチサイズを使用して <code>torch.compile</code> をベンチマークしました。",Lt,J,Dt,k,xe="以下に、各タスクのベンチマークコードを示します。推論前にGPUをウォームアップし、毎回同じ画像を使用して300回の推論の平均時間を取得します。",Nt,R,Ht,U,Bt,E,zt,_,Wt,Z,Vt,S,Ot,L,Xe="以下は、私たちがベンチマークを行ったモデルのリストです。",xt,D,Ge="<strong>Image Classification</strong>",Xt,N,Ae='<li><a href="https://huggingface.co/google/vit-base-patch16-224" rel="nofollow">google/vit-base-patch16-224</a></li> <li><a href="https://huggingface.co/microsoft/beit-base-patch16-224-pt22k-ft22k" rel="nofollow">microsoft/beit-base-patch16-224-pt22k-ft22k</a></li> <li><a href="https://huggingface.co/facebook/convnext-large-224" rel="nofollow">facebook/convnext-large-224</a></li> <li><a href="https://huggingface.co/" rel="nofollow">microsoft/resnet-50</a></li>',Gt,H,Fe="<strong>Image Segmentation</strong>",At,B,qe='<li><a href="https://huggingface.co/nvidia/segformer-b0-finetuned-ade-512-512" rel="nofollow">nvidia/segformer-b0-finetuned-ade-512-512</a></li> <li><a href="https://huggingface.co/facebook/mask2former-swin-tiny-coco-panoptic" rel="nofollow">facebook/mask2former-swin-tiny-coco-panoptic</a></li> <li><a href="https://huggingface.co/facebook/maskformer-swin-base-ade" rel="nofollow">facebook/maskformer-swin-base-ade</a></li> <li><a href="https://huggingface.co/google/deeplabv3_mobilenet_v2_1.0_513" rel="nofollow">google/deeplabv3_mobilenet_v2_1.0_513</a></li>',Ft,z,Ye="<strong>Object Detection</strong>",qt,W,Qe='<li><a href="https://huggingface.co/google/owlvit-base-patch32" rel="nofollow">google/owlvit-base-patch32</a></li> <li><a href="https://huggingface.co/facebook/detr-resnet-101" rel="nofollow">facebook/detr-resnet-101</a></li> <li><a href="https://huggingface.co/microsoft/conditional-detr-resnet-50" rel="nofollow">microsoft/conditional-detr-resnet-50</a></li>',Yt,V,Pe="以下は、<code>torch.compile()</code>を使用した場合と使用しない場合の推論時間の可視化と、異なるハードウェアとバッチサイズの各モデルに対するパフォーマンス向上の割合です。",Qt,T,Ke='<div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/a100_batch_comp.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/v100_batch_comp.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/t4_batch_comp.png"/></div>',Pt,M,tn='<div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/A100_1_duration.png"/></div> <div><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/A100_1_percentage.png"/></div>',Kt,O,en='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/v100_1_duration.png" alt="Duration Comparison on V100 with Batch Size of 1"/>',te,x,nn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/torch_compile/T4_4_percentage.png" alt="Percentage Improvement on T4 with Batch Size of 4"/>',ee,X,rn="下記は、各モデルについて<code>compile()</code>を使用した場合と使用しなかった場合の推論時間（ミリ秒単位）です。なお、OwlViTは大きなバッチサイズでの使用時にメモリ不足（OOM）が発生することに注意してください。",ne,G,ie,A,an='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">9.325</td> <td align="center">7.584</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">11.759</td> <td align="center">10.500</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">24.978</td> <td align="center">18.420</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">11.282</td> <td align="center">8.448</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">34.619</td> <td align="center">19.040</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">10.410</td> <td align="center">10.208</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.531</td> <td align="center">4.124</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">60.188</td> <td align="center">49.117</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">75.764</td> <td align="center">59.487</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">8.583</td> <td align="center">3.974</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">36.276</td> <td align="center">18.197</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">31.219</td> <td align="center">17.993</td></tr></tbody>',re,F,ae,q,ln='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">14.832</td> <td align="center">14.499</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">18.838</td> <td align="center">16.476</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">13.205</td> <td align="center">13.048</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">48.657</td> <td align="center">32.418</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">22.940</td> <td align="center">21.631</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.657</td> <td align="center">4.268</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">74.277</td> <td align="center">61.781</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">180.700</td> <td align="center">159.116</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">14.174</td> <td align="center">8.515</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">68.101</td> <td align="center">44.998</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">56.470</td> <td align="center">35.552</td></tr></tbody>',le,Y,de,Q,dn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">40.944</td> <td align="center">40.010</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">37.005</td> <td align="center">31.144</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">41.854</td> <td align="center">41.048</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">164.382</td> <td align="center">161.902</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">82.258</td> <td align="center">75.561</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">7.018</td> <td align="center">5.024</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">178.945</td> <td align="center">154.814</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">638.570</td> <td align="center">579.826</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">51.693</td> <td align="center">30.310</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">232.887</td> <td align="center">155.021</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">180.491</td> <td align="center">124.032</td></tr></tbody>',ce,P,ge,K,cn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">10.495</td> <td align="center">6.00</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">13.321</td> <td align="center">5.862</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">25.769</td> <td align="center">22.395</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">11.347</td> <td align="center">7.234</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">33.951</td> <td align="center">19.388</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">11.623</td> <td align="center">10.412</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.484</td> <td align="center">3.820</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">64.640</td> <td align="center">49.873</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">95.532</td> <td align="center">72.207</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">9.217</td> <td align="center">4.753</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">52.818</td> <td align="center">28.367</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">39.512</td> <td align="center">20.816</td></tr></tbody>',oe,tt,se,et,gn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">15.181</td> <td align="center">14.501</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">16.787</td> <td align="center">16.188</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">15.171</td> <td align="center">14.753</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">88.529</td> <td align="center">64.195</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">29.574</td> <td align="center">27.085</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.109</td> <td align="center">4.731</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">90.402</td> <td align="center">76.926</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">234.261</td> <td align="center">205.456</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">24.623</td> <td align="center">14.816</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">134.672</td> <td align="center">101.304</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">97.464</td> <td align="center">69.739</td></tr></tbody>',me,nt,he,it,on='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">52.209</td> <td align="center">51.633</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">61.013</td> <td align="center">55.499</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">53.938</td> <td align="center">53.581</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">OOM</td> <td align="center">OOM</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">109.682</td> <td align="center">100.771</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">14.857</td> <td align="center">12.089</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">249.605</td> <td align="center">222.801</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">831.142</td> <td align="center">743.645</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">93.129</td> <td align="center">55.365</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">482.425</td> <td align="center">361.843</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">344.661</td> <td align="center">255.298</td></tr></tbody>',pe,rt,fe,at,sn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">16.520</td> <td align="center">15.786</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">16.116</td> <td align="center">14.205</td></tr> <tr><td align="center">Object Detection/OwlViT</td> <td align="center">53.634</td> <td align="center">51.105</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16.464</td> <td align="center">15.710</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">73.100</td> <td align="center">53.99</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">32.932</td> <td align="center">30.845</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">6.031</td> <td align="center">4.321</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">79.192</td> <td align="center">66.815</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">200.026</td> <td align="center">188.268</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">18.908</td> <td align="center">11.997</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">106.622</td> <td align="center">82.566</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">77.594</td> <td align="center">56.984</td></tr></tbody>',be,lt,Te,dt,mn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">43.653</td> <td align="center">43.626</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">45.327</td> <td align="center">42.445</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">52.007</td> <td align="center">51.354</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">277.850</td> <td align="center">268.003</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">119.259</td> <td align="center">105.580</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">13.039</td> <td align="center">11.388</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">201.540</td> <td align="center">184.670</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">764.052</td> <td align="center">711.280</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">74.289</td> <td align="center">48.677</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">421.859</td> <td align="center">357.614</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">289.002</td> <td align="center">226.945</td></tr></tbody>',Me,ct,ue,gt,hn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ViT</td> <td align="center">163.914</td> <td align="center">160.907</td></tr> <tr><td align="center">Image Segmentation/Segformer</td> <td align="center">192.412</td> <td align="center">163.620</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">188.978</td> <td align="center">187.976</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">OOM</td> <td align="center">OOM</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">422.886</td> <td align="center">388.078</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">44.114</td> <td align="center">37.604</td></tr> <tr><td align="center">Image Segmentation/Mask2former</td> <td align="center">756.337</td> <td align="center">695.291</td></tr> <tr><td align="center">Image Segmentation/Maskformer</td> <td align="center">2842.940</td> <td align="center">2656.88</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">299.003</td> <td align="center">201.942</td></tr> <tr><td align="center">Object Detection/Resnet-101</td> <td align="center">1619.505</td> <td align="center">1262.758</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">1137.513</td> <td align="center">897.390</td></tr></tbody>',ye,ot,$e,st,pn='また、PyTorchのナイトリーバージョン（2.1.0dev）でのベンチマークを行い、コンパイルされていないモデルとコンパイル済みモデルの両方でレイテンシーの向上を観察しました。ホイールは<a href="https://download.pytorch.org/whl/nightly/cu118" rel="nofollow">こちら</a>から入手できます。',ve,mt,Ce,ht,fn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - no compile</strong></th> <th align="center"><strong>torch 2.0 -<br/> compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">12.462</td> <td align="center">6.954</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">14.109</td> <td align="center">12.851</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">42.179</td> <td align="center">42.147</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">30.484</td> <td align="center">15.221</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">46.816</td> <td align="center">30.942</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">163.749</td> <td align="center">163.706</td></tr></tbody>',Ie,pt,we,ft,bn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">14.408</td> <td align="center">14.052</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">47.381</td> <td align="center">46.604</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">42.179</td> <td align="center">42.147</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">68.382</td> <td align="center">53.481</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">269.615</td> <td align="center">204.785</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">OOM</td> <td align="center">OOM</td></tr></tbody>',je,bt,Tn="### V100",Je,Tt,Mn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/BeiT</td> <td align="center">Unbatched</td> <td align="center">13.477</td> <td align="center">7.926</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">4</td> <td align="center">15.103</td> <td align="center">14.378</td></tr> <tr><td align="center">Image Classification/BeiT</td> <td align="center">16</td> <td align="center">52.517</td> <td align="center">51.691</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">Unbatched</td> <td align="center">28.706</td> <td align="center">19.077</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">4</td> <td align="center">88.402</td> <td align="center">62.949</td></tr> <tr><td align="center">Object Detection/DETR</td> <td align="center">16</td> <td align="center">OOM</td> <td align="center">OOM</td></tr></tbody>',ke,Mt,Re,ut,un="NightlyビルドでA100およびT4向けの <code>reduce-overhead</code> コンパイルモードをベンチマークしました。",Ue,yt,Ee,$t,yn='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">Unbatched</td> <td align="center">11.758</td> <td align="center">7.335</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">4</td> <td align="center">23.171</td> <td align="center">21.490</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">Unbatched</td> <td align="center">7.435</td> <td align="center">3.801</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">4</td> <td align="center">7.261</td> <td align="center">2.187</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">Unbatched</td> <td align="center">32.823</td> <td align="center">11.627</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">4</td> <td align="center">50.622</td> <td align="center">33.831</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">Unbatched</td> <td align="center">9.869</td> <td align="center">4.244</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">4</td> <td align="center">14.385</td> <td align="center">7.946</td></tr></tbody>',_e,vt,Ze,Ct,$n='<thead><tr><th align="center"><strong>Task/Model</strong></th> <th align="center"><strong>Batch Size</strong></th> <th align="center"><strong>torch 2.0 - <br/>no compile</strong></th> <th align="center"><strong>torch 2.0 - <br/>compile</strong></th></tr></thead> <tbody><tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">Unbatched</td> <td align="center">32.137</td> <td align="center">31.84</td></tr> <tr><td align="center">Image Classification/ConvNeXT</td> <td align="center">4</td> <td align="center">120.944</td> <td align="center">110.209</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">Unbatched</td> <td align="center">9.761</td> <td align="center">7.698</td></tr> <tr><td align="center">Image Classification/ResNet</td> <td align="center">4</td> <td align="center">15.215</td> <td align="center">13.871</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">Unbatched</td> <td align="center">72.150</td> <td align="center">57.660</td></tr> <tr><td align="center">Object Detection/Conditional-DETR</td> <td align="center">4</td> <td align="center">301.494</td> <td align="center">247.543</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">Unbatched</td> <td align="center">22.266</td> <td align="center">19.339</td></tr> <tr><td align="center">Image Segmentation/MobileNet</td> <td align="center">4</td> <td align="center">78.311</td> <td align="center">50.983</td></tr></tbody>',Se,wt,Le;return u=new f({props:{title:"Optimize inference using torch.compile()",local:"optimize-inference-using-torchcompile",headingTag:"h1"}}),$=new f({props:{title:"Benefits of torch.compile",local:"benefits-of-torchcompile",headingTag:"h2"}}),I=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKE1PREVMX0lEKS50byglMjJjdWRhJTIyKSUwQSUyQiUyMG1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCk=",highlighted:`from transformers import AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(MODEL_ID).to(&quot;cuda&quot;)
<span class="hljs-addition">+ model = torch.compile(model)</span>`,wrap:!1}}),J=new f({props:{title:"Benchmarking code",local:"benchmarking-code",headingTag:"h2"}}),R=new f({props:{title:"Image Classification with ViT",local:"image-classification-with-vit",headingTag:"h3"}}),U=new Ne({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ltYWdlUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQSUwQXVybCUyMCUzRCUyMCdodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJyUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMikudG8oJTIyY3VkYSUyMiklMEFtb2RlbCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUobW9kZWwpJTBBJTBBcHJvY2Vzc2VkX2lucHV0JTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QncHQnKS50byhkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwbW9kZWwoKipwcm9jZXNzZWRfaW5wdXQp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForImageClassification

url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-keyword">open</span>(requests.<span class="hljs-keyword">get</span>(url, stream=<span class="hljs-keyword">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(&quot;google/vit-base-patch16-224&quot;)
model = AutoModelForImageClassification.from_pretrained(&quot;google/vit-base-patch16-224&quot;).<span class="hljs-keyword">to</span>(&quot;cuda&quot;)
model = torch.compile(model)

processed_input = processor(image, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>).<span class="hljs-keyword">to</span>(device=&quot;cuda&quot;)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**processed_input)`,wrap:!1}}),E=new f({props:{title:"Object Detection with DETR",local:"object-detection-with-detr",headingTag:"h4"}}),_=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZkZXRyLXJlc25ldC01MCUyMikudG8oJTIyY3VkYSUyMiklMEFtb2RlbCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUobW9kZWwpJTBBJTBBdGV4dHMlMjAlM0QlMjAlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHRleHRzJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBfJTIwJTNEJTIwbW9kZWwoKippbnB1dHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>)
model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)

texts = [<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]
inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**inputs)`,wrap:!1}}),Z=new f({props:{title:"Image Segmentation with Segformer",local:"image-segmentation-with-segformer",headingTag:"h4"}}),S=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlZ2Zvcm1lckltYWdlUHJvY2Vzc29yJTJDJTIwU2VnZm9ybWVyRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTZWdmb3JtZXJJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybnZpZGlhJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyMFNlZ2Zvcm1lckZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJudmlkaWElMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKS50byglMjJjdWRhJTIyKSUwQW1vZGVsJTIwJTNEJTIwdG9yY2guY29tcGlsZShtb2RlbCklMEFzZWdfaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwXyUyMCUzRCUyMG1vZGVsKCoqc2VnX2lucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SegformerImageProcessor, SegformerForSemanticSegmentation

processor = SegformerImageProcessor.from_pretrained(<span class="hljs-string">&quot;nvidia/segformer-b0-finetuned-ade-512-512&quot;</span>)
model = SegformerForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;nvidia/segformer-b0-finetuned-ade-512-512&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
model = torch.<span class="hljs-built_in">compile</span>(model)
seg_inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
    _ = model(**seg_inputs)`,wrap:!1}}),G=new f({props:{title:"A100 (batch size: 1)",local:"a100-batch-size-1",headingTag:"h3"}}),F=new f({props:{title:"A100 (batch size: 4)",local:"a100-batch-size-4",headingTag:"h3"}}),Y=new f({props:{title:"A100 (batch size: 16)",local:"a100-batch-size-16",headingTag:"h3"}}),P=new f({props:{title:"V100 (batch size: 1)",local:"v100-batch-size-1",headingTag:"h3"}}),tt=new f({props:{title:"V100 (batch size: 4)",local:"v100-batch-size-4",headingTag:"h3"}}),nt=new f({props:{title:"V100 (batch size: 16)",local:"v100-batch-size-16",headingTag:"h3"}}),rt=new f({props:{title:"T4 (batch size: 1)",local:"t4-batch-size-1",headingTag:"h3"}}),lt=new f({props:{title:"T4 (batch size: 4)",local:"t4-batch-size-4",headingTag:"h3"}}),ct=new f({props:{title:"T4 (batch size: 16)",local:"t4-batch-size-16",headingTag:"h3"}}),ot=new f({props:{title:"PyTorch Nightly",local:"pytorch-nightly",headingTag:"h2"}}),mt=new f({props:{title:"A100",local:"a100",headingTag:"h3"}}),pt=new f({props:{title:"T4",local:"t4",headingTag:"h3"}}),Mt=new f({props:{title:"Reduce Overhead",local:"reduce-overhead",headingTag:"h2"}}),yt=new f({props:{title:"A100",local:"a100",headingTag:"h3"}}),vt=new f({props:{title:"T4",local:"t4",headingTag:"h3"}}),{c(){b=l("meta"),jt=r(),It=l("p"),Jt=r(),g(u.$$.fragment),kt=r(),y=l("p"),y.innerHTML=Be,Rt=r(),g($.$$.fragment),Ut=r(),v=l("p"),v.innerHTML=ze,Et=r(),C=l("p"),C.innerHTML=We,_t=r(),g(I.$$.fragment),Zt=r(),w=l("p"),w.innerHTML=Ve,St=r(),j=l("p"),j.innerHTML=Oe,Lt=r(),g(J.$$.fragment),Dt=r(),k=l("p"),k.textContent=xe,Nt=r(),g(R.$$.fragment),Ht=r(),g(U.$$.fragment),Bt=r(),g(E.$$.fragment),zt=r(),g(_.$$.fragment),Wt=r(),g(Z.$$.fragment),Vt=r(),g(S.$$.fragment),Ot=r(),L=l("p"),L.textContent=Xe,xt=r(),D=l("p"),D.innerHTML=Ge,Xt=r(),N=l("ul"),N.innerHTML=Ae,Gt=r(),H=l("p"),H.innerHTML=Fe,At=r(),B=l("ul"),B.innerHTML=qe,Ft=r(),z=l("p"),z.innerHTML=Ye,qt=r(),W=l("ul"),W.innerHTML=Qe,Yt=r(),V=l("p"),V.innerHTML=Pe,Qt=r(),T=l("div"),T.innerHTML=Ke,Pt=r(),M=l("div"),M.innerHTML=tn,Kt=r(),O=l("p"),O.innerHTML=en,te=r(),x=l("p"),x.innerHTML=nn,ee=r(),X=l("p"),X.innerHTML=rn,ne=r(),g(G.$$.fragment),ie=r(),A=l("table"),A.innerHTML=an,re=r(),g(F.$$.fragment),ae=r(),q=l("table"),q.innerHTML=ln,le=r(),g(Y.$$.fragment),de=r(),Q=l("table"),Q.innerHTML=dn,ce=r(),g(P.$$.fragment),ge=r(),K=l("table"),K.innerHTML=cn,oe=r(),g(tt.$$.fragment),se=r(),et=l("table"),et.innerHTML=gn,me=r(),g(nt.$$.fragment),he=r(),it=l("table"),it.innerHTML=on,pe=r(),g(rt.$$.fragment),fe=r(),at=l("table"),at.innerHTML=sn,be=r(),g(lt.$$.fragment),Te=r(),dt=l("table"),dt.innerHTML=mn,Me=r(),g(ct.$$.fragment),ue=r(),gt=l("table"),gt.innerHTML=hn,ye=r(),g(ot.$$.fragment),$e=r(),st=l("p"),st.innerHTML=pn,ve=r(),g(mt.$$.fragment),Ce=r(),ht=l("table"),ht.innerHTML=fn,Ie=r(),g(pt.$$.fragment),we=r(),ft=l("table"),ft.innerHTML=bn,je=r(),bt=l("p"),bt.textContent=Tn,Je=r(),Tt=l("table"),Tt.innerHTML=Mn,ke=r(),g(Mt.$$.fragment),Re=r(),ut=l("p"),ut.innerHTML=un,Ue=r(),g(yt.$$.fragment),Ee=r(),$t=l("table"),$t.innerHTML=yn,_e=r(),g(vt.$$.fragment),Ze=r(),Ct=l("table"),Ct.innerHTML=$n,Se=r(),wt=l("p"),this.h()},l(t){const e=kn("svelte-u9bgzb",document.head);b=d(e,"META",{name:!0,content:!0}),e.forEach(n),jt=a(t),It=d(t,"P",{}),vn(It).forEach(n),Jt=a(t),o(u.$$.fragment,t),kt=a(t),y=d(t,"P",{"data-svelte-h":!0}),c(y)!=="svelte-irbci"&&(y.innerHTML=Be),Rt=a(t),o($.$$.fragment,t),Ut=a(t),v=d(t,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1fbn4ig"&&(v.innerHTML=ze),Et=a(t),C=d(t,"P",{"data-svelte-h":!0}),c(C)!=="svelte-1qahe0"&&(C.innerHTML=We),_t=a(t),o(I.$$.fragment,t),Zt=a(t),w=d(t,"P",{"data-svelte-h":!0}),c(w)!=="svelte-1f6elgo"&&(w.innerHTML=Ve),St=a(t),j=d(t,"P",{"data-svelte-h":!0}),c(j)!=="svelte-zipvn5"&&(j.innerHTML=Oe),Lt=a(t),o(J.$$.fragment,t),Dt=a(t),k=d(t,"P",{"data-svelte-h":!0}),c(k)!=="svelte-6affft"&&(k.textContent=xe),Nt=a(t),o(R.$$.fragment,t),Ht=a(t),o(U.$$.fragment,t),Bt=a(t),o(E.$$.fragment,t),zt=a(t),o(_.$$.fragment,t),Wt=a(t),o(Z.$$.fragment,t),Vt=a(t),o(S.$$.fragment,t),Ot=a(t),L=d(t,"P",{"data-svelte-h":!0}),c(L)!=="svelte-15jicxa"&&(L.textContent=Xe),xt=a(t),D=d(t,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1pzh5ag"&&(D.innerHTML=Ge),Xt=a(t),N=d(t,"UL",{"data-svelte-h":!0}),c(N)!=="svelte-i1xpay"&&(N.innerHTML=Ae),Gt=a(t),H=d(t,"P",{"data-svelte-h":!0}),c(H)!=="svelte-vq25eq"&&(H.innerHTML=Fe),At=a(t),B=d(t,"UL",{"data-svelte-h":!0}),c(B)!=="svelte-1vcuz7e"&&(B.innerHTML=qe),Ft=a(t),z=d(t,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1e8jpwt"&&(z.innerHTML=Ye),qt=a(t),W=d(t,"UL",{"data-svelte-h":!0}),c(W)!=="svelte-yhf9tm"&&(W.innerHTML=Qe),Yt=a(t),V=d(t,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1x7u157"&&(V.innerHTML=Pe),Qt=a(t),T=d(t,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-1jw9wmi"&&(T.innerHTML=Ke),Pt=a(t),M=d(t,"DIV",{class:!0,"data-svelte-h":!0}),c(M)!=="svelte-nlzsqo"&&(M.innerHTML=tn),Kt=a(t),O=d(t,"P",{"data-svelte-h":!0}),c(O)!=="svelte-gdeipd"&&(O.innerHTML=en),te=a(t),x=d(t,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1cusdpa"&&(x.innerHTML=nn),ee=a(t),X=d(t,"P",{"data-svelte-h":!0}),c(X)!=="svelte-4j9ezu"&&(X.innerHTML=rn),ne=a(t),o(G.$$.fragment,t),ie=a(t),A=d(t,"TABLE",{"data-svelte-h":!0}),c(A)!=="svelte-6uvhqg"&&(A.innerHTML=an),re=a(t),o(F.$$.fragment,t),ae=a(t),q=d(t,"TABLE",{"data-svelte-h":!0}),c(q)!=="svelte-f4zjoc"&&(q.innerHTML=ln),le=a(t),o(Y.$$.fragment,t),de=a(t),Q=d(t,"TABLE",{"data-svelte-h":!0}),c(Q)!=="svelte-9ju0ii"&&(Q.innerHTML=dn),ce=a(t),o(P.$$.fragment,t),ge=a(t),K=d(t,"TABLE",{"data-svelte-h":!0}),c(K)!=="svelte-18ncoxq"&&(K.innerHTML=cn),oe=a(t),o(tt.$$.fragment,t),se=a(t),et=d(t,"TABLE",{"data-svelte-h":!0}),c(et)!=="svelte-15udyd3"&&(et.innerHTML=gn),me=a(t),o(nt.$$.fragment,t),he=a(t),it=d(t,"TABLE",{"data-svelte-h":!0}),c(it)!=="svelte-rw07j7"&&(it.innerHTML=on),pe=a(t),o(rt.$$.fragment,t),fe=a(t),at=d(t,"TABLE",{"data-svelte-h":!0}),c(at)!=="svelte-37x5jw"&&(at.innerHTML=sn),be=a(t),o(lt.$$.fragment,t),Te=a(t),dt=d(t,"TABLE",{"data-svelte-h":!0}),c(dt)!=="svelte-1mc5027"&&(dt.innerHTML=mn),Me=a(t),o(ct.$$.fragment,t),ue=a(t),gt=d(t,"TABLE",{"data-svelte-h":!0}),c(gt)!=="svelte-10eiin7"&&(gt.innerHTML=hn),ye=a(t),o(ot.$$.fragment,t),$e=a(t),st=d(t,"P",{"data-svelte-h":!0}),c(st)!=="svelte-1wc2mx4"&&(st.innerHTML=pn),ve=a(t),o(mt.$$.fragment,t),Ce=a(t),ht=d(t,"TABLE",{"data-svelte-h":!0}),c(ht)!=="svelte-1cg5nyy"&&(ht.innerHTML=fn),Ie=a(t),o(pt.$$.fragment,t),we=a(t),ft=d(t,"TABLE",{"data-svelte-h":!0}),c(ft)!=="svelte-1nlzppe"&&(ft.innerHTML=bn),je=a(t),bt=d(t,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-l1xtas"&&(bt.textContent=Tn),Je=a(t),Tt=d(t,"TABLE",{"data-svelte-h":!0}),c(Tt)!=="svelte-ok1p6e"&&(Tt.innerHTML=Mn),ke=a(t),o(Mt.$$.fragment,t),Re=a(t),ut=d(t,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-1qqs4aq"&&(ut.innerHTML=un),Ue=a(t),o(yt.$$.fragment,t),Ee=a(t),$t=d(t,"TABLE",{"data-svelte-h":!0}),c($t)!=="svelte-13rnx0"&&($t.innerHTML=yn),_e=a(t),o(vt.$$.fragment,t),Ze=a(t),Ct=d(t,"TABLE",{"data-svelte-h":!0}),c(Ct)!=="svelte-oh2zql"&&(Ct.innerHTML=$n),Se=a(t),wt=d(t,"P",{}),vn(wt).forEach(n),this.h()},h(){De(b,"name","hf:doc:metadata"),De(b,"content",En),De(T,"class","flex"),De(M,"class","flex")},m(t,e){Rn(document.head,b),i(t,jt,e),i(t,It,e),i(t,Jt,e),s(u,t,e),i(t,kt,e),i(t,y,e),i(t,Rt,e),s($,t,e),i(t,Ut,e),i(t,v,e),i(t,Et,e),i(t,C,e),i(t,_t,e),s(I,t,e),i(t,Zt,e),i(t,w,e),i(t,St,e),i(t,j,e),i(t,Lt,e),s(J,t,e),i(t,Dt,e),i(t,k,e),i(t,Nt,e),s(R,t,e),i(t,Ht,e),s(U,t,e),i(t,Bt,e),s(E,t,e),i(t,zt,e),s(_,t,e),i(t,Wt,e),s(Z,t,e),i(t,Vt,e),s(S,t,e),i(t,Ot,e),i(t,L,e),i(t,xt,e),i(t,D,e),i(t,Xt,e),i(t,N,e),i(t,Gt,e),i(t,H,e),i(t,At,e),i(t,B,e),i(t,Ft,e),i(t,z,e),i(t,qt,e),i(t,W,e),i(t,Yt,e),i(t,V,e),i(t,Qt,e),i(t,T,e),i(t,Pt,e),i(t,M,e),i(t,Kt,e),i(t,O,e),i(t,te,e),i(t,x,e),i(t,ee,e),i(t,X,e),i(t,ne,e),s(G,t,e),i(t,ie,e),i(t,A,e),i(t,re,e),s(F,t,e),i(t,ae,e),i(t,q,e),i(t,le,e),s(Y,t,e),i(t,de,e),i(t,Q,e),i(t,ce,e),s(P,t,e),i(t,ge,e),i(t,K,e),i(t,oe,e),s(tt,t,e),i(t,se,e),i(t,et,e),i(t,me,e),s(nt,t,e),i(t,he,e),i(t,it,e),i(t,pe,e),s(rt,t,e),i(t,fe,e),i(t,at,e),i(t,be,e),s(lt,t,e),i(t,Te,e),i(t,dt,e),i(t,Me,e),s(ct,t,e),i(t,ue,e),i(t,gt,e),i(t,ye,e),s(ot,t,e),i(t,$e,e),i(t,st,e),i(t,ve,e),s(mt,t,e),i(t,Ce,e),i(t,ht,e),i(t,Ie,e),s(pt,t,e),i(t,we,e),i(t,ft,e),i(t,je,e),i(t,bt,e),i(t,Je,e),i(t,Tt,e),i(t,ke,e),s(Mt,t,e),i(t,Re,e),i(t,ut,e),i(t,Ue,e),s(yt,t,e),i(t,Ee,e),i(t,$t,e),i(t,_e,e),s(vt,t,e),i(t,Ze,e),i(t,Ct,e),i(t,Se,e),i(t,wt,e),Le=!0},p:In,i(t){Le||(m(u.$$.fragment,t),m($.$$.fragment,t),m(I.$$.fragment,t),m(J.$$.fragment,t),m(R.$$.fragment,t),m(U.$$.fragment,t),m(E.$$.fragment,t),m(_.$$.fragment,t),m(Z.$$.fragment,t),m(S.$$.fragment,t),m(G.$$.fragment,t),m(F.$$.fragment,t),m(Y.$$.fragment,t),m(P.$$.fragment,t),m(tt.$$.fragment,t),m(nt.$$.fragment,t),m(rt.$$.fragment,t),m(lt.$$.fragment,t),m(ct.$$.fragment,t),m(ot.$$.fragment,t),m(mt.$$.fragment,t),m(pt.$$.fragment,t),m(Mt.$$.fragment,t),m(yt.$$.fragment,t),m(vt.$$.fragment,t),Le=!0)},o(t){h(u.$$.fragment,t),h($.$$.fragment,t),h(I.$$.fragment,t),h(J.$$.fragment,t),h(R.$$.fragment,t),h(U.$$.fragment,t),h(E.$$.fragment,t),h(_.$$.fragment,t),h(Z.$$.fragment,t),h(S.$$.fragment,t),h(G.$$.fragment,t),h(F.$$.fragment,t),h(Y.$$.fragment,t),h(P.$$.fragment,t),h(tt.$$.fragment,t),h(nt.$$.fragment,t),h(rt.$$.fragment,t),h(lt.$$.fragment,t),h(ct.$$.fragment,t),h(ot.$$.fragment,t),h(mt.$$.fragment,t),h(pt.$$.fragment,t),h(Mt.$$.fragment,t),h(yt.$$.fragment,t),h(vt.$$.fragment,t),Le=!1},d(t){t&&(n(jt),n(It),n(Jt),n(kt),n(y),n(Rt),n(Ut),n(v),n(Et),n(C),n(_t),n(Zt),n(w),n(St),n(j),n(Lt),n(Dt),n(k),n(Nt),n(Ht),n(Bt),n(zt),n(Wt),n(Vt),n(Ot),n(L),n(xt),n(D),n(Xt),n(N),n(Gt),n(H),n(At),n(B),n(Ft),n(z),n(qt),n(W),n(Yt),n(V),n(Qt),n(T),n(Pt),n(M),n(Kt),n(O),n(te),n(x),n(ee),n(X),n(ne),n(ie),n(A),n(re),n(ae),n(q),n(le),n(de),n(Q),n(ce),n(ge),n(K),n(oe),n(se),n(et),n(me),n(he),n(it),n(pe),n(fe),n(at),n(be),n(Te),n(dt),n(Me),n(ue),n(gt),n(ye),n($e),n(st),n(ve),n(Ce),n(ht),n(Ie),n(we),n(ft),n(je),n(bt),n(Je),n(Tt),n(ke),n(Re),n(ut),n(Ue),n(Ee),n($t),n(_e),n(Ze),n(Ct),n(Se),n(wt)),n(b),p(u,t),p($,t),p(I,t),p(J,t),p(R,t),p(U,t),p(E,t),p(_,t),p(Z,t),p(S,t),p(G,t),p(F,t),p(Y,t),p(P,t),p(tt,t),p(nt,t),p(rt,t),p(lt,t),p(ct,t),p(ot,t),p(mt,t),p(pt,t),p(Mt,t),p(yt,t),p(vt,t)}}}const En='{"title":"Optimize inference using torch.compile()","local":"optimize-inference-using-torchcompile","sections":[{"title":"Benefits of torch.compile","local":"benefits-of-torchcompile","sections":[],"depth":2},{"title":"Benchmarking code","local":"benchmarking-code","sections":[{"title":"Image Classification with ViT","local":"image-classification-with-vit","sections":[{"title":"Object Detection with DETR","local":"object-detection-with-detr","sections":[],"depth":4},{"title":"Image Segmentation with Segformer","local":"image-segmentation-with-segformer","sections":[],"depth":4}],"depth":3},{"title":"A100 (batch size: 1)","local":"a100-batch-size-1","sections":[],"depth":3},{"title":"A100 (batch size: 4)","local":"a100-batch-size-4","sections":[],"depth":3},{"title":"A100 (batch size: 16)","local":"a100-batch-size-16","sections":[],"depth":3},{"title":"V100 (batch size: 1)","local":"v100-batch-size-1","sections":[],"depth":3},{"title":"V100 (batch size: 4)","local":"v100-batch-size-4","sections":[],"depth":3},{"title":"V100 (batch size: 16)","local":"v100-batch-size-16","sections":[],"depth":3},{"title":"T4 (batch size: 1)","local":"t4-batch-size-1","sections":[],"depth":3},{"title":"T4 (batch size: 4)","local":"t4-batch-size-4","sections":[],"depth":3},{"title":"T4 (batch size: 16)","local":"t4-batch-size-16","sections":[],"depth":3}],"depth":2},{"title":"PyTorch Nightly","local":"pytorch-nightly","sections":[{"title":"A100","local":"a100","sections":[],"depth":3},{"title":"T4","local":"t4","sections":[],"depth":3}],"depth":2},{"title":"Reduce Overhead","local":"reduce-overhead","sections":[{"title":"A100","local":"a100","sections":[],"depth":3},{"title":"T4","local":"t4","sections":[],"depth":3}],"depth":2}],"depth":1}';function _n(He){return wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nn extends jn{constructor(b){super(),Jn(this,b,_n,Un,Cn,{})}}export{Nn as component};
