import{s as rn,o as dn,n as sn}from"../chunks/scheduler.8c3d61f6.js";import{S as cn,i as pn,g as l,s as o,r as f,A as un,h as r,f as t,c as a,j as J,u as h,x as v,k as H,y as s,a as i,v as g,d as _,t as y,w as b}from"../chunks/index.da70eac4.js";import{T as mn}from"../chunks/Tip.1d9b8c37.js";import{D as K}from"../chunks/Docstring.6b390b9a.js";import{C as ln}from"../chunks/CodeBlock.00a903b3.js";import{E as fn}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as je,E as hn}from"../chunks/EditOnGithub.1e64e623.js";function gn(ee){let d,V='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){d=l("p"),d.innerHTML=V},l(m){d=r(m,"P",{"data-svelte-h":!0}),v(d)!=="svelte-1qn15hi"&&(d.innerHTML=V)},m(m,w){i(m,d,w)},p:sn,d(m){m&&t(d)}}}function _n(ee){let d,V="Examples:",m,w,M;return w=new ln({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwSHVueXVhblZpZGVvUGlwZWxpbmUlMkMlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJodW55dWFudmlkZW8tY29tbXVuaXR5JTJGSHVueXVhblZpZGVvJTIyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBIdW55dWFuVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUudmFlLmVuYWJsZV90aWxpbmcoKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBjYXQlMjB3YWxrcyUyMG9uJTIwdGhlJTIwZ3Jhc3MlMkMlMjByZWFsaXN0aWMlMjIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QzMjAlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9mcmFtZXMlM0Q2MSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUwQSkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyhvdXRwdXQlMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEMTUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline, HunyuanVideoTransformer3DModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;hunyuanvideo-community/HunyuanVideo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transformer = HunyuanVideoTransformer3DModel.from_pretrained(
<span class="hljs-meta">... </span>    model_id, subfolder=<span class="hljs-string">&quot;transformer&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = HunyuanVideoPipeline.from_pretrained(model_id, transformer=transformer, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_tiling()
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;A cat walks on the grass, realistic&quot;</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">320</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">61</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),{c(){d=l("p"),d.textContent=V,m=o(),f(w.$$.fragment)},l(p){d=r(p,"P",{"data-svelte-h":!0}),v(d)!=="svelte-kvfsh7"&&(d.textContent=V),m=a(p),h(w.$$.fragment,p)},m(p,T){i(p,d,T),i(p,m,T),g(w,p,T),M=!0},p:sn,i(p){M||(_(w.$$.fragment,p),M=!0)},o(p){y(w.$$.fragment,p),M=!1},d(p){p&&(t(d),t(m)),b(w,p)}}}function yn(ee){let d,V,m,w,M,p,T,De='<a href="https://www.arxiv.org/abs/2412.03603" rel="nofollow">HunyuanVideo</a> by Tencent.',ce,U,qe='<em>Recent advancements in video generation have significantly impacted daily life for both individuals and industries. However, the leading video generation models remain closed-source, resulting in a notable performance gap between industry capabilities and those available to the public. In this report, we introduce HunyuanVideo, an innovative open-source video foundation model that demonstrates performance in video generation comparable to, or even surpassing, that of leading closed-source models. HunyuanVideo encompasses a comprehensive framework that integrates several key elements, including data curation, advanced architectural design, progressive model scaling and training, and an efficient infrastructure tailored for large-scale model training and inference. As a result, we successfully trained a video generative model with over 13 billion parameters, making it the largest among all open-source models. We conducted extensive experiments and implemented a series of targeted designs to ensure high visual quality, motion dynamics, text-video alignment, and advanced filming techniques. According to evaluations by professionals, HunyuanVideo outperforms previous state-of-the-art models, including Runway Gen-3, Luma 1.6, and three top-performing Chinese video generative models. By releasing the code for the foundation model and its applications, we aim to bridge the gap between closed-source and open-source communities. This initiative will empower individuals within the community to experiment with their ideas, fostering a more dynamic and vibrant video generation ecosystem. The code is publicly available at <a href="https://github.com/tencent/HunyuanVideo" rel="nofollow">this https URL</a>.</em>',pe,j,ue,E,Re="Recommendations for inference:",me,B,Fe='<li>Both text encoders should be in <code>torch.float16</code>.</li> <li>Transformer should be in <code>torch.bfloat16</code>.</li> <li>VAE should be in <code>torch.float16</code>.</li> <li><code>num_frames</code> should be of the form <code>4 * k + 1</code>, for example <code>49</code> or <code>129</code>.</li> <li>For smaller resolution videos, try lower values of <code>shift</code> (between <code>2.0</code> to <code>5.0</code>) in the <a href="https://huggingface.co/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler.shift" rel="nofollow">Scheduler</a>. For larger resolution images, try higher values (between <code>7.0</code> and <code>12.0</code>). The default value is <code>7.0</code> for HunyuanVideo.</li> <li>For more information about supported resolutions and other details, please refer to the original repository <a href="https://github.com/Tencent/HunyuanVideo/" rel="nofollow">here</a>.</li>',fe,L,he,G,Ne="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",ge,z,Se='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/hunyuan_video#diffusers.HunyuanVideoPipeline">HunyuanVideoPipeline</a> for inference with bitsandbytes.',_e,X,ye,A,be,c,Q,Ce,ne,Ye="Pipeline for text-to-video generation using HunyuanVideo.",Pe,te,Oe=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ie,$,D,Ze,oe,Ke="The call function to the pipeline for generation.",We,C,Ue,P,q,Ee,ae,en=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Be,I,R,Le,ie,nn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ge,Z,F,ze,se,tn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Xe,W,N,Ae,le,on=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,ve,S,we,k,Y,Qe,re,an="Output class for HunyuanVideo pipelines.",Me,O,Te,de,Ve;return M=new je({props:{title:"HunyuanVideo",local:"hunyuanvideo",headingTag:"h1"}}),j=new mn({props:{$$slots:{default:[gn]},$$scope:{ctx:ee}}}),L=new je({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),X=new ln({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBIdW55dWFuVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwlMkMlMjBIdW55dWFuVmlkZW9QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fdmlkZW8lMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSklMEF0cmFuc2Zvcm1lcl84Yml0JTIwJTNEJTIwSHVueXVhblZpZGVvVHJhbnNmb3JtZXIzRE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJodW55dWFudmlkZW8tY29tbXVuaXR5JTJGSHVueXVhblZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMEh1bnl1YW5WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJodW55dWFudmlkZW8tY29tbXVuaXR5JTJGSHVueXVhblZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lcl84Yml0JTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmJhbGFuY2VkJTIyJTJDJTBBKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjB3YWxrcyUyMG9uJTIwdGhlJTIwZ3Jhc3MlMkMlMjByZWFsaXN0aWMlMjBzdHlsZS4lMjIlMEF2aWRlbyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUzRHByb21wdCUyQyUyMG51bV9mcmFtZXMlM0Q2MSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCkuZnJhbWVzJTVCMCU1RCUwQWV4cG9ydF90b192aWRlbyh2aWRlbyUyQyUyMCUyMmNhdC5tcDQlMjIlMkMlMjBmcHMlM0QxNSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, HunyuanVideoTransformer3DModel, HunyuanVideoPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = HunyuanVideoTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;hunyuanvideo-community/HunyuanVideo&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.bfloat16,
)

pipeline = HunyuanVideoPipeline.from_pretrained(
    <span class="hljs-string">&quot;hunyuanvideo-community/HunyuanVideo&quot;</span>,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;A cat walks on the grass, realistic style.&quot;</span>
video = pipeline(prompt=prompt, num_frames=<span class="hljs-number">61</span>, num_inference_steps=<span class="hljs-number">30</span>).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;cat.mp4&quot;</span>, fps=<span class="hljs-number">15</span>)`,wrap:!1}}),A=new je({props:{title:"HunyuanVideoPipeline",local:"diffusers.HunyuanVideoPipeline",headingTag:"h2"}}),Q=new K({props:{name:"class diffusers.HunyuanVideoPipeline",anchor:"diffusers.HunyuanVideoPipeline",parameters:[{name:"text_encoder",val:": LlamaModel"},{name:"tokenizer",val:": LlamaTokenizerFast"},{name:"transformer",val:": HunyuanVideoTransformer3DModel"},{name:"vae",val:": AutoencoderKLHunyuanVideo"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"text_encoder_2",val:": CLIPTextModel"},{name:"tokenizer_2",val:": CLIPTokenizer"}],parametersDescription:[{anchor:"diffusers.HunyuanVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>LlamaModel</code>) &#x2014;
<a href="https://huggingface.co/xtuner/llava-llama-3-8b-v1_1-transformers" rel="nofollow">Llava Llama3-8B</a>.`,name:"text_encoder"},{anchor:"diffusers.HunyuanVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>LlamaTokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/xtuner/llava-llama-3-8b-v1_1-transformers" rel="nofollow">Llava Llama3-8B</a>.`,name:"tokenizer"},{anchor:"diffusers.HunyuanVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/hunyuan_video_transformer_3d#diffusers.HunyuanVideoTransformer3DModel">HunyuanVideoTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.HunyuanVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.HunyuanVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_hunyuan_video#diffusers.AutoencoderKLHunyuanVideo">AutoencoderKLHunyuanVideo</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"},{anchor:"diffusers.HunyuanVideoPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.HunyuanVideoPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L144"}}),D=new K({props:{name:"__call__",anchor:"diffusers.HunyuanVideoPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 720"},{name:"width",val:": int = 1280"},{name:"num_frames",val:": int = 129"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 6.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"prompt_template",val:": typing.Dict[str, typing.Any] = {'template': '<|start_header_id|>system<|end_header_id|>\\n\\nDescribe the video by detailing the following aspects: 1. The main content and theme of the video.2. The color, shape, size, texture, quantity, text, and spatial relationships of the objects.3. Actions, events, behaviors temporal relationships, physical movement changes of the objects.4. background environment, light, style and atmosphere.5. camera angles, movements, and transitions used in the video:<|eot_id|><|start_header_id|>user<|end_header_id|>\\n\\n{}<|eot_id|>', 'crop_start': 95}"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.HunyuanVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead.`,name:"prompt_2"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>720</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>1280</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>129</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>6.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality. Note that the only available HunyuanVideo model is
CFG-distilled, which means that traditional guidance between unconditional and conditional latent is
not applied.`,name:"guidance_scale"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>HunyuanVideoPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.HunyuanVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L463",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>HunyuanVideoPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned
where the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~HunyuanVideoPipelineOutput</code> or <code>tuple</code></p>
`}}),C=new fn({props:{anchor:"diffusers.HunyuanVideoPipeline.__call__.example",$$slots:{default:[_n]},$$scope:{ctx:ee}}}),q=new K({props:{name:"disable_vae_slicing",anchor:"diffusers.HunyuanVideoPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L425"}}),R=new K({props:{name:"disable_vae_tiling",anchor:"diffusers.HunyuanVideoPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L440"}}),F=new K({props:{name:"enable_vae_slicing",anchor:"diffusers.HunyuanVideoPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L418"}}),N=new K({props:{name:"enable_vae_tiling",anchor:"diffusers.HunyuanVideoPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_hunyuan_video.py#L432"}}),S=new je({props:{title:"HunyuanVideoPipelineOutput",local:"diffusers.pipelines.hunyuan_video.pipeline_output.HunyuanVideoPipelineOutput",headingTag:"h2"}}),Y=new K({props:{name:"class diffusers.pipelines.hunyuan_video.pipeline_output.HunyuanVideoPipelineOutput",anchor:"diffusers.pipelines.hunyuan_video.pipeline_output.HunyuanVideoPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.hunyuan_video.pipeline_output.HunyuanVideoPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/hunyuan_video/pipeline_output.py#L8"}}),O=new hn({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/hunyuan_video.md"}}),{c(){d=l("meta"),V=o(),m=l("p"),w=o(),f(M.$$.fragment),p=o(),T=l("p"),T.innerHTML=De,ce=o(),U=l("p"),U.innerHTML=qe,pe=o(),f(j.$$.fragment),ue=o(),E=l("p"),E.textContent=Re,me=o(),B=l("ul"),B.innerHTML=Fe,fe=o(),f(L.$$.fragment),he=o(),G=l("p"),G.textContent=Ne,ge=o(),z=l("p"),z.innerHTML=Se,_e=o(),f(X.$$.fragment),ye=o(),f(A.$$.fragment),be=o(),c=l("div"),f(Q.$$.fragment),Ce=o(),ne=l("p"),ne.textContent=Ye,Pe=o(),te=l("p"),te.innerHTML=Oe,Ie=o(),$=l("div"),f(D.$$.fragment),Ze=o(),oe=l("p"),oe.textContent=Ke,We=o(),f(C.$$.fragment),Ue=o(),P=l("div"),f(q.$$.fragment),Ee=o(),ae=l("p"),ae.innerHTML=en,Be=o(),I=l("div"),f(R.$$.fragment),Le=o(),ie=l("p"),ie.innerHTML=nn,Ge=o(),Z=l("div"),f(F.$$.fragment),ze=o(),se=l("p"),se.textContent=tn,Xe=o(),W=l("div"),f(N.$$.fragment),Ae=o(),le=l("p"),le.textContent=on,ve=o(),f(S.$$.fragment),we=o(),k=l("div"),f(Y.$$.fragment),Qe=o(),re=l("p"),re.textContent=an,Me=o(),f(O.$$.fragment),Te=o(),de=l("p"),this.h()},l(e){const n=un("svelte-u9bgzb",document.head);d=r(n,"META",{name:!0,content:!0}),n.forEach(t),V=a(e),m=r(e,"P",{}),J(m).forEach(t),w=a(e),h(M.$$.fragment,e),p=a(e),T=r(e,"P",{"data-svelte-h":!0}),v(T)!=="svelte-r39nnx"&&(T.innerHTML=De),ce=a(e),U=r(e,"P",{"data-svelte-h":!0}),v(U)!=="svelte-nu132f"&&(U.innerHTML=qe),pe=a(e),h(j.$$.fragment,e),ue=a(e),E=r(e,"P",{"data-svelte-h":!0}),v(E)!=="svelte-1bbhycm"&&(E.textContent=Re),me=a(e),B=r(e,"UL",{"data-svelte-h":!0}),v(B)!=="svelte-jc657q"&&(B.innerHTML=Fe),fe=a(e),h(L.$$.fragment,e),he=a(e),G=r(e,"P",{"data-svelte-h":!0}),v(G)!=="svelte-1ou2pxc"&&(G.textContent=Ne),ge=a(e),z=r(e,"P",{"data-svelte-h":!0}),v(z)!=="svelte-4th7qw"&&(z.innerHTML=Se),_e=a(e),h(X.$$.fragment,e),ye=a(e),h(A.$$.fragment,e),be=a(e),c=r(e,"DIV",{class:!0});var u=J(c);h(Q.$$.fragment,u),Ce=a(u),ne=r(u,"P",{"data-svelte-h":!0}),v(ne)!=="svelte-1a4x0ff"&&(ne.textContent=Ye),Pe=a(u),te=r(u,"P",{"data-svelte-h":!0}),v(te)!=="svelte-496sm0"&&(te.innerHTML=Oe),Ie=a(u),$=r(u,"DIV",{class:!0});var x=J($);h(D.$$.fragment,x),Ze=a(x),oe=r(x,"P",{"data-svelte-h":!0}),v(oe)!=="svelte-50j04k"&&(oe.textContent=Ke),We=a(x),h(C.$$.fragment,x),x.forEach(t),Ue=a(u),P=r(u,"DIV",{class:!0});var $e=J(P);h(q.$$.fragment,$e),Ee=a($e),ae=r($e,"P",{"data-svelte-h":!0}),v(ae)!=="svelte-1s3c06i"&&(ae.innerHTML=en),$e.forEach(t),Be=a(u),I=r(u,"DIV",{class:!0});var ke=J(I);h(R.$$.fragment,ke),Le=a(ke),ie=r(ke,"P",{"data-svelte-h":!0}),v(ie)!=="svelte-pkn4ui"&&(ie.innerHTML=nn),ke.forEach(t),Ge=a(u),Z=r(u,"DIV",{class:!0});var xe=J(Z);h(F.$$.fragment,xe),ze=a(xe),se=r(xe,"P",{"data-svelte-h":!0}),v(se)!=="svelte-14bnrb6"&&(se.textContent=tn),xe.forEach(t),Xe=a(u),W=r(u,"DIV",{class:!0});var Je=J(W);h(N.$$.fragment,Je),Ae=a(Je),le=r(Je,"P",{"data-svelte-h":!0}),v(le)!=="svelte-1xwrf7t"&&(le.textContent=on),Je.forEach(t),u.forEach(t),ve=a(e),h(S.$$.fragment,e),we=a(e),k=r(e,"DIV",{class:!0});var He=J(k);h(Y.$$.fragment,He),Qe=a(He),re=r(He,"P",{"data-svelte-h":!0}),v(re)!=="svelte-i6xdzu"&&(re.textContent=an),He.forEach(t),Me=a(e),h(O.$$.fragment,e),Te=a(e),de=r(e,"P",{}),J(de).forEach(t),this.h()},h(){H(d,"name","hf:doc:metadata"),H(d,"content",bn),H($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){s(document.head,d),i(e,V,n),i(e,m,n),i(e,w,n),g(M,e,n),i(e,p,n),i(e,T,n),i(e,ce,n),i(e,U,n),i(e,pe,n),g(j,e,n),i(e,ue,n),i(e,E,n),i(e,me,n),i(e,B,n),i(e,fe,n),g(L,e,n),i(e,he,n),i(e,G,n),i(e,ge,n),i(e,z,n),i(e,_e,n),g(X,e,n),i(e,ye,n),g(A,e,n),i(e,be,n),i(e,c,n),g(Q,c,null),s(c,Ce),s(c,ne),s(c,Pe),s(c,te),s(c,Ie),s(c,$),g(D,$,null),s($,Ze),s($,oe),s($,We),g(C,$,null),s(c,Ue),s(c,P),g(q,P,null),s(P,Ee),s(P,ae),s(c,Be),s(c,I),g(R,I,null),s(I,Le),s(I,ie),s(c,Ge),s(c,Z),g(F,Z,null),s(Z,ze),s(Z,se),s(c,Xe),s(c,W),g(N,W,null),s(W,Ae),s(W,le),i(e,ve,n),g(S,e,n),i(e,we,n),i(e,k,n),g(Y,k,null),s(k,Qe),s(k,re),i(e,Me,n),g(O,e,n),i(e,Te,n),i(e,de,n),Ve=!0},p(e,[n]){const u={};n&2&&(u.$$scope={dirty:n,ctx:e}),j.$set(u);const x={};n&2&&(x.$$scope={dirty:n,ctx:e}),C.$set(x)},i(e){Ve||(_(M.$$.fragment,e),_(j.$$.fragment,e),_(L.$$.fragment,e),_(X.$$.fragment,e),_(A.$$.fragment,e),_(Q.$$.fragment,e),_(D.$$.fragment,e),_(C.$$.fragment,e),_(q.$$.fragment,e),_(R.$$.fragment,e),_(F.$$.fragment,e),_(N.$$.fragment,e),_(S.$$.fragment,e),_(Y.$$.fragment,e),_(O.$$.fragment,e),Ve=!0)},o(e){y(M.$$.fragment,e),y(j.$$.fragment,e),y(L.$$.fragment,e),y(X.$$.fragment,e),y(A.$$.fragment,e),y(Q.$$.fragment,e),y(D.$$.fragment,e),y(C.$$.fragment,e),y(q.$$.fragment,e),y(R.$$.fragment,e),y(F.$$.fragment,e),y(N.$$.fragment,e),y(S.$$.fragment,e),y(Y.$$.fragment,e),y(O.$$.fragment,e),Ve=!1},d(e){e&&(t(V),t(m),t(w),t(p),t(T),t(ce),t(U),t(pe),t(ue),t(E),t(me),t(B),t(fe),t(he),t(G),t(ge),t(z),t(_e),t(ye),t(be),t(c),t(ve),t(we),t(k),t(Me),t(Te),t(de)),t(d),b(M,e),b(j,e),b(L,e),b(X,e),b(A,e),b(Q),b(D),b(C),b(q),b(R),b(F),b(N),b(S,e),b(Y),b(O,e)}}}const bn='{"title":"HunyuanVideo","local":"hunyuanvideo","sections":[{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"HunyuanVideoPipeline","local":"diffusers.HunyuanVideoPipeline","sections":[],"depth":2},{"title":"HunyuanVideoPipelineOutput","local":"diffusers.pipelines.hunyuan_video.pipeline_output.HunyuanVideoPipelineOutput","sections":[],"depth":2}],"depth":1}';function vn(ee){return dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jn extends cn{constructor(d){super(),pn(this,d,vn,yn,rn,{})}}export{Jn as component};
