import{s as Ws,o as Ds,n as Et}from"../chunks/scheduler.d627b047.js";import{S as Ys,i as Fs,g as a,s as n,r as p,A as Ks,h as i,f as s,c as l,j as v,u as c,x as $,k as x,y as r,a as o,v as u,d as m,t as g,w as f}from"../chunks/index.73c51727.js";import{T as Ss}from"../chunks/Tip.a82942ec.js";import{D as _}from"../chunks/Docstring.488b7ad2.js";import{C as nt}from"../chunks/CodeBlock.b1cdc5f6.js";import{E as Xs}from"../chunks/ExampleCodeBlock.2e3fd904.js";import{H as B,E as Os}from"../chunks/EditOnGithub.859b9ebc.js";function en(q){let d,w="TRL Judges is an experimental API which is subject to change at any time.";return{c(){d=a("p"),d.textContent=w},l(M){d=i(M,"P",{"data-svelte-h":!0}),$(d)!=="svelte-1xzbokz"&&(d.textContent=w)},m(M,J){o(M,d,J)},p:Et,d(M){M&&s(d)}}}function tn(q){let d,w="<strong>Example</strong>:",M,J,b;return J=new nt({props:{code:"cGFpcnJtX2p1ZGdlJTIwJTNEJTIwUGFpclJNSnVkZ2UoKSUwQXByb21wdHMlMjAlM0QlMjAlNUIlMjJUcmFuc2xhdGUlMjAnaGVsbG8nJTIwdG8lMjBGcmVuY2glMjIlMkMlMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBKYXBhbiUzRiUyMiU1RCUwQWNvbXBsZXRpb25zJTIwJTNEJTIwJTVCJTVCJTIyQm9uam91ciUyMiUyQyUyMCUyMlNhbHV0JTIyJTVEJTJDJTIwJTVCJTIyS3lvdG8lMjIlMkMlMjAlMjJUb2t5byUyMiU1RCU1RCUwQXJlc3VsdHMlMjAlM0QlMjBwYWlycm1fanVkZ2UuanVkZ2UocHJvbXB0cyUyQyUyMGNvbXBsZXRpb25zKSUwQXByaW50KHJlc3VsdHMpJTIwJTIwJTIzJTIwJTVCMCUyQyUyMDElNUQlMjAoaW5kaWNhdGluZyUyMHRoZSUyMGZpcnN0JTIwY29tcGxldGlvbiUyMGlzJTIwcHJlZmVycmVkJTIwZm9yJTIwdGhlJTIwZmlyc3QlMjBwcm9tcHQlMjBhbmQlMjB0aGUlMjBzZWNvbmQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pairrm_judge = PairRMJudge()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = [<span class="hljs-string">&quot;Translate &#x27;hello&#x27; to French&quot;</span>, <span class="hljs-string">&quot;What&#x27;s the capital of Japan?&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>completions = [[<span class="hljs-string">&quot;Bonjour&quot;</span>, <span class="hljs-string">&quot;Salut&quot;</span>], [<span class="hljs-string">&quot;Kyoto&quot;</span>, <span class="hljs-string">&quot;Tokyo&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>results = pairrm_judge.judge(prompts, completions)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(results)  <span class="hljs-comment"># [0, 1] (indicating the first completion is preferred for the first prompt and the second)</span>`,wrap:!1}}),{c(){d=a("p"),d.innerHTML=w,M=n(),p(J.$$.fragment)},l(h){d=i(h,"P",{"data-svelte-h":!0}),$(d)!=="svelte-uthfgh"&&(d.innerHTML=w),M=l(h),c(J.$$.fragment,h)},m(h,T){o(h,d,T),o(h,M,T),u(J,h,T),b=!0},p:Et,i(h){b||(m(J.$$.fragment,h),b=!0)},o(h){g(J.$$.fragment,h),b=!1},d(h){h&&(s(d),s(M)),f(J,h)}}}function sn(q){let d,w="This class requires the llm-blender library to be installed. Install it with: <code>pip install llm-blender</code>.";return{c(){d=a("p"),d.innerHTML=w},l(M){d=i(M,"P",{"data-svelte-h":!0}),$(d)!=="svelte-mbqgq5"&&(d.innerHTML=w)},m(M,J){o(M,d,J)},p:Et,d(M){M&&s(d)}}}function nn(q){let d,w="<strong>Example</strong>:",M,J,b;return J=new nt({props:{code:"Y2xhc3MlMjBNeVJhbmtKdWRnZShCYXNlUmFua0p1ZGdlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGp1ZGdlKHNlbGYlMkMlMjBwcm9tcHRzJTJDJTIwY29tcGxldGlvbnMlMkMlMjBzaHVmZmxlX29yZGVyJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAuLi4lMjAlMjAlMjMlMjBZb3VyJTIwcmFua2luZyUyMGxvZ2ljJTIwaGVyZSUwQSUwQWp1ZGdlJTIwJTNEJTIwTXlSYW5rSnVkZ2UoKSUwQWp1ZGdlLmp1ZGdlKCUwQSUyMCUyMCUyMCUyMHByb21wdHMlM0QlNUIlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMiUyQyUyMCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEdlcm1hbnklMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGNvbXBsZXRpb25zJTNEJTVCJTVCJTIyJTIwUGFyaXMlMjIlMkMlMjAlMjIlMjBNYXJzZWlsbGUlMjIlMkMlMjAlMjJMeW9uJTIyJTVEJTJDJTIwJTVCJTIyJTIwTXVuaWNoJTIyJTJDJTIwJTIyJTIwQmVybGluJTIyJTVEJTVEJTBBKSUyMCUyMCUyMyUyMCU1QiU1QjAlMkMlMjAxJTJDJTIwMiU1RCUyQyUyMCU1QjElMkMlMjAwJTVEJTVE",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyRankJudge</span>(<span class="hljs-title class_ inherited__">BaseRankJudge</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">judge</span>(<span class="hljs-params">self, prompts, completions, shuffle_order=<span class="hljs-literal">True</span></span>):
        <span class="hljs-keyword">return</span> ...  <span class="hljs-comment"># Your ranking logic here</span>

judge = MyRankJudge()
judge.judge(
    prompts=[<span class="hljs-string">&quot;The capital of France is&quot;</span>, <span class="hljs-string">&quot;The capital of Germany is&quot;</span>],
    completions=[[<span class="hljs-string">&quot; Paris&quot;</span>, <span class="hljs-string">&quot; Marseille&quot;</span>, <span class="hljs-string">&quot;Lyon&quot;</span>], [<span class="hljs-string">&quot; Munich&quot;</span>, <span class="hljs-string">&quot; Berlin&quot;</span>]]
)  <span class="hljs-comment"># [[0, 1, 2], [1, 0]]</span>`,wrap:!1}}),{c(){d=a("p"),d.innerHTML=w,M=n(),p(J.$$.fragment)},l(h){d=i(h,"P",{"data-svelte-h":!0}),$(d)!=="svelte-uthfgh"&&(d.innerHTML=w),M=l(h),c(J.$$.fragment,h)},m(h,T){o(h,d,T),o(h,M,T),u(J,h,T),b=!0},p:Et,i(h){b||(m(J.$$.fragment,h),b=!0)},o(h){g(J.$$.fragment,h),b=!1},d(h){h&&(s(d),s(M)),f(J,h)}}}function ln(q){let d,w,M,J,b,h,T,rt,Y,$s="TRL provides judges to easily compare two completions.",ot,F,Ms="Make sure to have installed the required dependencies by running:",at,K,it,O,dt,ee,Js="TRL provides several judges out of the box. For example, you can use the <code>HfPairwiseJudge</code> to compare two completions using a pre-trained model from the Hugging Face model hub:",pt,te,ct,se,ut,ne,ys='To define your own judge, we provide several base classes that you can subclass. For rank-based judges, you need to subclass <a href="/docs/trl/main/en/judges#trl.BaseRankJudge">BaseRankJudge</a> and implement the <a href="/docs/trl/main/en/judges#trl.BaseRankJudge.judge">BaseRankJudge.judge()</a> method. For pairwise judges, you need to subclass <code>BasePairJudge</code> and implement the <code>BasePairJudge.judge</code> method. If you want to define a judge that doesn’t fit into these categories, you need to subclass <a href="/docs/trl/main/en/judges#trl.BaseJudge">BaseJudge</a> and implement the <code>BaseJudge.judge()</code> method.',mt,le,js="As an example, let’s define a pairwise judge that prefers shorter completions:",gt,re,ft,oe,bs="You can then use this judge as follows:",ht,ae,$t,ie,Mt,de,Jt,y,pe,Zt,_e,ws="LLM judge based on the PairRM model from AllenAI.",Lt,ke,Ts=`This judge uses the PairRM model to rank pairs of completions for given prompts. It’s designed for pairwise
comparison of language model outputs. The PairRM model is loaded using the llm-blender library and runs on the
default Accelerator device.`,Nt,Pe,vs="<strong>Attributes</strong>:",Qt,Ge,xs=`blender (<code>llm_blender.Blender</code>):
An instance of the Blender class from llm-blender.`,zt,N,St,Q,Xt,V,ce,Wt,Re,Us="Judge the completion pairs for the given prompts using the PairRM model.",Dt,qe,Is=`Note:
Unlike llm-blender, ranks are 0-indexed (<code>0</code> means the first completion is preferred).`,yt,ue,jt,k,me,Yt,Ve,Bs="Pairwise judge based on the Hugging Face API with chat completion.",Ft,Ae,Cs="This judge is relevant for assessing the quality chat models, where the completion is a response to a given prompt.",bt,ge,wt,P,fe,Kt,He,_s="Judge based on the OpenAI API.",Ot,Ee,ks="This judge is relevant for assessing the quality chat models, where the completion is a response to a given prompt.",Tt,he,vt,U,$e,es,Ze,Ps='Unify the decision of multiple <a href="/docs/trl/main/en/judges#trl.BaseBinaryJudge">BaseBinaryJudge</a> instances.',ts,Le,Gs=`Returns <code>1</code> only if all inner binary judges return <code>1</code>. If any judge returns <code>0</code>, it returns <code>0</code>.
If any judge returns <code>-1</code>, indicating a failure in its process, this judge will also return <code>-1</code>.`,ss,Ne,Rs='Implements the Mixture of Judges as described in the <a href="https://huggingface.co/papers/2409.20370" rel="nofollow">CGPO paper</a>.',xt,Me,Ut,Je,It,H,ye,ns,Qe,qs="Base class for judges. The subclasses of this class should implement the <code>judge</code> method.",Bt,je,Ct,G,be,ls,ze,Vs="Base class for binary judges.",rs,C,we,os,Se,As="Judge the completion for a given prompt. Used to assess if a completion satisfies a constraint.",as,Xe,Hs=`This base class should be used to implement binary evaluations as done in section 4.1.4 of the
<a href="https://huggingface.co/papers/2409.20370" rel="nofollow">CGPO paper</a>.
It is relevant for assessing whether a prompt completion pair satisfies a specific contraint.`,is,We,Es=`Note:
If the judge returns -1 for any prompt, it indicates that the inner process used to compute the preference has failed.
For instance, this could occur if the underlying language model or rule based contraint returned an invalid answer.
In such cases, the caller should handle these invalid indices appropriately, possibly by implementing fallback logic or error handling.`,_t,Te,kt,I,ve,ds,De,Zs="Base class for LLM ranking judges.",ps,z,cs,S,xe,us,Ye,Ls="Judge the completion for the given prompts and return the ranks of each completion.",Pt,Ue,Gt,R,Ie,ms,Fe,Ns="Base class for pairwise judges.",gs,A,Be,fs,Ke,Qs="Judge the completion pairs for the given prompts.",hs,Oe,zs=`Note:
If the judge returns <code>-1</code> for any prompt, it indicates that the inner process used to compute the
preference has failed. For instance, this could occur if the underlying language model returned an invalid
answer. In such cases, the caller should handle these invalid indices appropriately, possibly by
implementing fallback logic or error handling.`,Rt,Ce,qt,lt,Vt;return b=new B({props:{title:"Judges",local:"judges",headingTag:"h1"}}),T=new Ss({props:{warning:!0,$$slots:{default:[en]},$$scope:{ctx:q}}}),K=new nt({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRybCU1Qmp1ZGdlcyU1RA==",highlighted:"pip install trl[judges]",wrap:!1}}),O=new B({props:{title:"Using the provided judges",local:"using-the-provided-judges",headingTag:"h2"}}),te=new nt({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMEhmUGFpcndpc2VKdWRnZSUwQSUwQWp1ZGdlJTIwJTNEJTIwSGZQYWlyd2lzZUp1ZGdlKCklMEFqdWRnZS5qdWRnZSglMEElMjAlMjAlMjAlMjBwcm9tcHRzJTNEJTVCJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTJDJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwYmlnZ2VzdCUyMHBsYW5ldCUyMGluJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0lM0YlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBjb21wbGV0aW9ucyUzRCU1QiU1QiUyMlBhcmlzJTIyJTJDJTIwJTIyTHlvbiUyMiU1RCUyQyUyMCU1QiUyMlNhdHVybiUyMiUyQyUyMCUyMkp1cGl0ZXIlMjIlNUQlNUQlMkMlMEEpJTIwJTIwJTIzJTIwT3V0cHV0cyUzQSUyMCU1QjAlMkMlMjAxJTVE",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> HfPairwiseJudge

judge = HfPairwiseJudge()
judge.judge(
    prompts=[<span class="hljs-string">&quot;What is the capital of France?&quot;</span>, <span class="hljs-string">&quot;What is the biggest planet in the solar system?&quot;</span>],
    completions=[[<span class="hljs-string">&quot;Paris&quot;</span>, <span class="hljs-string">&quot;Lyon&quot;</span>], [<span class="hljs-string">&quot;Saturn&quot;</span>, <span class="hljs-string">&quot;Jupiter&quot;</span>]],
)  <span class="hljs-comment"># Outputs: [0, 1]</span>`,wrap:!1}}),se=new B({props:{title:"Define your own judge",local:"define-your-own-judge",headingTag:"h2"}}),re=new nt({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMEJhc2VQYWlyd2lzZUp1ZGdlJTBBJTBBY2xhc3MlMjBQcmVmZXJzU2hvcnRlckp1ZGdlKEJhc2VQYWlyd2lzZUp1ZGdlKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGp1ZGdlKHNlbGYlMkMlMjBwcm9tcHRzJTJDJTIwY29tcGxldGlvbnMlMkMlMjBzaHVmZmxlX29yZGVyJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCMCUyMGlmJTIwbGVuKGNvbXBsZXRpb24lNUIwJTVEKSUyMCUzRSUyMGxlbihjb21wbGV0aW9uJTVCMSU1RCklMjBlbHNlJTIwMSUyMGZvciUyMGNvbXBsZXRpb24lMjBpbiUyMGNvbXBsZXRpb25zJTVE",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> BasePairwiseJudge

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PrefersShorterJudge</span>(<span class="hljs-title class_ inherited__">BasePairwiseJudge</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">judge</span>(<span class="hljs-params">self, prompts, completions, shuffle_order=<span class="hljs-literal">False</span></span>):
        <span class="hljs-keyword">return</span> [<span class="hljs-number">0</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(completion[<span class="hljs-number">0</span>]) &gt; <span class="hljs-built_in">len</span>(completion[<span class="hljs-number">1</span>]) <span class="hljs-keyword">else</span> <span class="hljs-number">1</span> <span class="hljs-keyword">for</span> completion <span class="hljs-keyword">in</span> completions]`,wrap:!1}}),ae=new nt({props:{code:"anVkZ2UlMjAlM0QlMjBQcmVmZXJzU2hvcnRlckp1ZGdlKCklMEFqdWRnZS5qdWRnZSglMEElMjAlMjAlMjAlMjBwcm9tcHRzJTNEJTVCJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTJDJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwYmlnZ2VzdCUyMHBsYW5ldCUyMGluJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0lM0YlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBjb21wbGV0aW9ucyUzRCU1QiU1QiUyMlBhcmlzJTIyJTJDJTIwJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjIlNUQlMkMlMjAlNUIlMjJKdXBpdGVyJTIwaXMlMjB0aGUlMjBiaWdnZXN0JTIwcGxhbmV0JTIwaW4lMjB0aGUlMjBzb2xhciUyMHN5c3RlbS4lMjIlMkMlMjAlMjJKdXBpdGVyJTIyJTVEJTVEJTJDJTBBKSUyMCUyMCUyMyUyME91dHB1dHMlM0ElMjAlNUIwJTJDJTIwMSU1RA==",highlighted:`judge = PrefersShorterJudge()
judge.judge(
    prompts=[<span class="hljs-string">&quot;What is the capital of France?&quot;</span>, <span class="hljs-string">&quot;What is the biggest planet in the solar system?&quot;</span>],
    completions=[[<span class="hljs-string">&quot;Paris&quot;</span>, <span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>], [<span class="hljs-string">&quot;Jupiter is the biggest planet in the solar system.&quot;</span>, <span class="hljs-string">&quot;Jupiter&quot;</span>]],
)  <span class="hljs-comment"># Outputs: [0, 1]</span>`,wrap:!1}}),ie=new B({props:{title:"Provided judges",local:"provided-judges",headingTag:"h2"}}),de=new B({props:{title:"PairRMJudge",local:"trl.PairRMJudge",headingTag:"h3"}}),pe=new _({props:{name:"class trl.PairRMJudge",anchor:"trl.PairRMJudge",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L185"}}),N=new Xs({props:{anchor:"trl.PairRMJudge.example",$$slots:{default:[tn]},$$scope:{ctx:q}}}),Q=new Ss({props:{$$slots:{default:[sn]},$$scope:{ctx:q}}}),ce=new _({props:{name:"judge",anchor:"trl.PairRMJudge.judge",parameters:[{name:"prompts",val:": list"},{name:"completions",val:": list"},{name:"shuffle_order",val:": bool = True"},{name:"return_scores",val:": bool = False"},{name:"temperature",val:": float = 1.0"}],parametersDescription:[{anchor:"trl.PairRMJudge.judge.prompts",description:`<strong>prompts</strong> (<code>list[str]</code>) &#x2014;
List of prompts to judge.`,name:"prompts"},{anchor:"trl.PairRMJudge.judge.completions",description:`<strong>completions</strong> (<code>list[list[str]]</code>) &#x2014;
List of completion pairs for each prompt.`,name:"completions"},{anchor:"trl.PairRMJudge.judge.shuffle_order",description:`<strong>shuffle_order</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to shuffle the order of the completions to avoid positional bias.`,name:"shuffle_order"},{anchor:"trl.PairRMJudge.judge.return_scores",description:`<strong>return_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, return probability scores of the first completion instead of ranks (i.e. a <em>soft-judge</em>).`,name:"return_scores"},{anchor:"trl.PairRMJudge.judge.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Temperature for scaling logits if <code>return_scores</code> is True.`,name:"temperature"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L220",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_scores</code> is <code>False</code>, returns a list of ranks (<code>0</code> or <code>1</code>) for each prompt, indicating which
completion is preferred.
If <code>return_scores</code> is <code>True</code>, returns softmax probabilities for the first completion.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[list[int, float]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If the number of completions per prompt is not exactly 2.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),ue=new B({props:{title:"HfPairwiseJudge",local:"trl.HfPairwiseJudge",headingTag:"h3"}}),me=new _({props:{name:"class trl.HfPairwiseJudge",anchor:"trl.HfPairwiseJudge",parameters:[{name:"model",val:" = 'meta-llama/Meta-Llama-3-70B-Instruct'"},{name:"token",val:": typing.Optional[str] = None"},{name:"system_prompt",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"trl.HfPairwiseJudge.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</code>) &#x2014;
Model to use for the judge.`,name:"model"},{anchor:"trl.HfPairwiseJudge.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Hugging Face API token to use for the <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient" rel="nofollow">huggingface_hub.InferenceClient</a>.`,name:"token"},{anchor:"trl.HfPairwiseJudge.system_prompt",description:`<strong>system_prompt</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The system prompt to be used for the judge. If not provided, a default prompt is used. Note that the system
prompt should contain the following placeholders: <code>{prompt}</code>, <code>{response0}</code>, and <code>{response1}</code>. Also, the
inference is called with <code>max_tokens=1</code>, consequently the system prompt should ask for a single token
response.`,name:"system_prompt"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L287"}}),ge=new B({props:{title:"OpenAIPairwiseJudge",local:"trl.OpenAIPairwiseJudge",headingTag:"h3"}}),fe=new _({props:{name:"class trl.OpenAIPairwiseJudge",anchor:"trl.OpenAIPairwiseJudge",parameters:[{name:"model",val:" = 'gpt-4-turbo-preview'"},{name:"system_prompt",val:": typing.Optional[str] = None"},{name:"max_requests",val:": typing.Optional[int] = 1000"}],parametersDescription:[{anchor:"trl.OpenAIPairwiseJudge.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gpt-4-turbo-preview&quot;</code>) &#x2014;
Model to use for the judge.`,name:"model"},{anchor:"trl.OpenAIPairwiseJudge.system_prompt",description:`<strong>system_prompt</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
System prompt to be used for the judge. If not provided, a default prompt is used. Note that the system
prompt should contain the following placeholders: <code>{prompt}</code>, <code>{response0}</code>, and <code>{response1}</code>. Also, the
inference is called with <code>max_tokens=1</code>, consequently the system prompt should ask for a single token
response.`,name:"system_prompt"},{anchor:"trl.OpenAIPairwiseJudge.max_requests",description:`<strong>max_requests</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>1000</code>) &#x2014;
Maximum number of requests to make to the OpenAI API. If set to <code>None</code>, there is no limit.`,name:"max_requests"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L343"}}),he=new B({props:{title:"AllTrueJudge",local:"trl.AllTrueJudge",headingTag:"h3"}}),$e=new _({props:{name:"class trl.AllTrueJudge",anchor:"trl.AllTrueJudge",parameters:[{name:"judges",val:": list"}],parametersDescription:[{anchor:"trl.AllTrueJudge.judges",description:'<strong>judges</strong> (<code>list[BaseBinaryJudge]</code>) &#x2014; A list of <a href="/docs/trl/main/en/judges#trl.BaseBinaryJudge">BaseBinaryJudge</a> instances whose decisions will be unified.',name:"judges"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L416"}}),Me=new B({props:{title:"Base classes",local:"base-classes",headingTag:"h2"}}),Je=new B({props:{title:"BaseJudge",local:"trl.BaseJudge",headingTag:"h3"}}),ye=new _({props:{name:"class trl.BaseJudge",anchor:"trl.BaseJudge",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L64"}}),je=new B({props:{title:"BaseBinaryJudge",local:"trl.BaseBinaryJudge",headingTag:"h3"}}),be=new _({props:{name:"class trl.BaseBinaryJudge",anchor:"trl.BaseBinaryJudge",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L146"}}),we=new _({props:{name:"judge",anchor:"trl.BaseBinaryJudge.judge",parameters:[{name:"prompts",val:": list"},{name:"completions",val:": list"},{name:"gold_completions",val:": typing.Optional[list[str]] = None"},{name:"shuffle_order",val:": bool = True"}],parametersDescription:[{anchor:"trl.BaseBinaryJudge.judge.prompts",description:"<strong>prompts</strong> (<code>list[str]</code>) &#x2014; List of prompts.",name:"prompts"},{anchor:"trl.BaseBinaryJudge.judge.completions",description:"<strong>completions</strong> (<code>list[str]</code>) &#x2014; List of completions.",name:"completions"},{anchor:"trl.BaseBinaryJudge.judge.gold_completions",description:"<strong>gold_completions</strong> (<code>list[str]</code>, <code>optional</code>) &#x2014; List of gold completions if it exists.",name:"gold_completions"},{anchor:"trl.BaseBinaryJudge.judge.shuffle_order",description:"<strong>shuffle_order</strong> (<code>bool</code>) &#x2014; Whether to shuffle the order of the completions to avoid positional bias.",name:"shuffle_order"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L151",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of binary labels:</p>
<ul>
<li>1 indicates that the completion satisfies the evaluated constraint.</li>
<li>0 indicates that the completion does not satisfy the evaluated constraint.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list[int]</p>
`}}),Te=new B({props:{title:"BaseRankJudge",local:"trl.BaseRankJudge",headingTag:"h3"}}),ve=new _({props:{name:"class trl.BaseRankJudge",anchor:"trl.BaseRankJudge",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L74"}}),z=new Xs({props:{anchor:"trl.BaseRankJudge.example",$$slots:{default:[nn]},$$scope:{ctx:q}}}),xe=new _({props:{name:"judge",anchor:"trl.BaseRankJudge.judge",parameters:[{name:"prompts",val:": list"},{name:"completions",val:": list"},{name:"shuffle_order",val:": bool = True"}],parametersDescription:[{anchor:"trl.BaseRankJudge.judge.prompts",description:`<strong>prompts</strong> (<code>list[str]</code>) &#x2014;
List of prompts.`,name:"prompts"},{anchor:"trl.BaseRankJudge.judge.completions",description:`<strong>completions</strong> (<code>list[list[str]]</code>) &#x2014;
List of completions list, where each element is a list of completions for the corresponding prompt.`,name:"completions"},{anchor:"trl.BaseRankJudge.judge.shuffle_order",description:`<strong>shuffle_order</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to shuffle the order of the completions to avoid positional bias.`,name:"shuffle_order"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L92",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of lists of idxs, where each list contains the ranks of the completions for the corresponding
prompt. E.g., <code>[1, 2, 0]</code> means that the second completion (<code>idx=1</code>) is the best, followed by the
third, and then the first.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>list[list[int]]</code></p>
`}}),Ue=new B({props:{title:"BasePairwiseJudge",local:"trl.BasePairwiseJudge",headingTag:"h3"}}),Ie=new _({props:{name:"class trl.BasePairwiseJudge",anchor:"trl.BasePairwiseJudge",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L114"}}),Be=new _({props:{name:"judge",anchor:"trl.BasePairwiseJudge.judge",parameters:[{name:"prompts",val:": list"},{name:"completions",val:": list"},{name:"shuffle_order",val:": bool = True"}],parametersDescription:[{anchor:"trl.BasePairwiseJudge.judge.prompts",description:`<strong>prompts</strong> (<code>list[str]</code>) &#x2014;
List of prompts.`,name:"prompts"},{anchor:"trl.BasePairwiseJudge.judge.completions",description:`<strong>completions</strong> (<code>list[list[str]]</code>) &#x2014;
List of completions pairs, where each element is a pair of completions for the corresponding prompt.`,name:"completions"},{anchor:"trl.BasePairwiseJudge.judge.shuffle_order",description:`<strong>shuffle_order</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to shuffle the order of the completions to avoid positional bias.`,name:"shuffle_order"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/judges.py#L119",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of idxs, where each idx is the rank of the best completion for the corresponding prompt.
E.g., <code>1</code> means that the second completion (<code>idx=1</code>) is the best.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>list[int]</code></p>
`}}),Ce=new Os({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/judges.mdx"}}),{c(){d=a("meta"),w=n(),M=a("p"),J=n(),p(b.$$.fragment),h=n(),p(T.$$.fragment),rt=n(),Y=a("p"),Y.textContent=$s,ot=n(),F=a("p"),F.textContent=Ms,at=n(),p(K.$$.fragment),it=n(),p(O.$$.fragment),dt=n(),ee=a("p"),ee.innerHTML=Js,pt=n(),p(te.$$.fragment),ct=n(),p(se.$$.fragment),ut=n(),ne=a("p"),ne.innerHTML=ys,mt=n(),le=a("p"),le.textContent=js,gt=n(),p(re.$$.fragment),ft=n(),oe=a("p"),oe.textContent=bs,ht=n(),p(ae.$$.fragment),$t=n(),p(ie.$$.fragment),Mt=n(),p(de.$$.fragment),Jt=n(),y=a("div"),p(pe.$$.fragment),Zt=n(),_e=a("p"),_e.textContent=ws,Lt=n(),ke=a("p"),ke.textContent=Ts,Nt=n(),Pe=a("p"),Pe.innerHTML=vs,Qt=n(),Ge=a("p"),Ge.innerHTML=xs,zt=n(),p(N.$$.fragment),St=n(),p(Q.$$.fragment),Xt=n(),V=a("div"),p(ce.$$.fragment),Wt=n(),Re=a("p"),Re.textContent=Us,Dt=n(),qe=a("p"),qe.innerHTML=Is,yt=n(),p(ue.$$.fragment),jt=n(),k=a("div"),p(me.$$.fragment),Yt=n(),Ve=a("p"),Ve.textContent=Bs,Ft=n(),Ae=a("p"),Ae.textContent=Cs,bt=n(),p(ge.$$.fragment),wt=n(),P=a("div"),p(fe.$$.fragment),Kt=n(),He=a("p"),He.textContent=_s,Ot=n(),Ee=a("p"),Ee.textContent=ks,Tt=n(),p(he.$$.fragment),vt=n(),U=a("div"),p($e.$$.fragment),es=n(),Ze=a("p"),Ze.innerHTML=Ps,ts=n(),Le=a("p"),Le.innerHTML=Gs,ss=n(),Ne=a("p"),Ne.innerHTML=Rs,xt=n(),p(Me.$$.fragment),Ut=n(),p(Je.$$.fragment),It=n(),H=a("div"),p(ye.$$.fragment),ns=n(),Qe=a("p"),Qe.innerHTML=qs,Bt=n(),p(je.$$.fragment),Ct=n(),G=a("div"),p(be.$$.fragment),ls=n(),ze=a("p"),ze.textContent=Vs,rs=n(),C=a("div"),p(we.$$.fragment),os=n(),Se=a("p"),Se.textContent=As,as=n(),Xe=a("p"),Xe.innerHTML=Hs,is=n(),We=a("p"),We.textContent=Es,_t=n(),p(Te.$$.fragment),kt=n(),I=a("div"),p(ve.$$.fragment),ds=n(),De=a("p"),De.textContent=Zs,ps=n(),p(z.$$.fragment),cs=n(),S=a("div"),p(xe.$$.fragment),us=n(),Ye=a("p"),Ye.textContent=Ls,Pt=n(),p(Ue.$$.fragment),Gt=n(),R=a("div"),p(Ie.$$.fragment),ms=n(),Fe=a("p"),Fe.textContent=Ns,gs=n(),A=a("div"),p(Be.$$.fragment),fs=n(),Ke=a("p"),Ke.textContent=Qs,hs=n(),Oe=a("p"),Oe.innerHTML=zs,Rt=n(),p(Ce.$$.fragment),qt=n(),lt=a("p"),this.h()},l(e){const t=Ks("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(s),w=l(e),M=i(e,"P",{}),v(M).forEach(s),J=l(e),c(b.$$.fragment,e),h=l(e),c(T.$$.fragment,e),rt=l(e),Y=i(e,"P",{"data-svelte-h":!0}),$(Y)!=="svelte-xz70xq"&&(Y.textContent=$s),ot=l(e),F=i(e,"P",{"data-svelte-h":!0}),$(F)!=="svelte-1kcs23p"&&(F.textContent=Ms),at=l(e),c(K.$$.fragment,e),it=l(e),c(O.$$.fragment,e),dt=l(e),ee=i(e,"P",{"data-svelte-h":!0}),$(ee)!=="svelte-1aryxdw"&&(ee.innerHTML=Js),pt=l(e),c(te.$$.fragment,e),ct=l(e),c(se.$$.fragment,e),ut=l(e),ne=i(e,"P",{"data-svelte-h":!0}),$(ne)!=="svelte-19nqkta"&&(ne.innerHTML=ys),mt=l(e),le=i(e,"P",{"data-svelte-h":!0}),$(le)!=="svelte-rwweup"&&(le.textContent=js),gt=l(e),c(re.$$.fragment,e),ft=l(e),oe=i(e,"P",{"data-svelte-h":!0}),$(oe)!=="svelte-1qb11fq"&&(oe.textContent=bs),ht=l(e),c(ae.$$.fragment,e),$t=l(e),c(ie.$$.fragment,e),Mt=l(e),c(de.$$.fragment,e),Jt=l(e),y=i(e,"DIV",{class:!0});var j=v(y);c(pe.$$.fragment,j),Zt=l(j),_e=i(j,"P",{"data-svelte-h":!0}),$(_e)!=="svelte-154ezq1"&&(_e.textContent=ws),Lt=l(j),ke=i(j,"P",{"data-svelte-h":!0}),$(ke)!=="svelte-1f5qqxa"&&(ke.textContent=Ts),Nt=l(j),Pe=i(j,"P",{"data-svelte-h":!0}),$(Pe)!=="svelte-1xx6nm4"&&(Pe.innerHTML=vs),Qt=l(j),Ge=i(j,"P",{"data-svelte-h":!0}),$(Ge)!=="svelte-1jojwf4"&&(Ge.innerHTML=xs),zt=l(j),c(N.$$.fragment,j),St=l(j),c(Q.$$.fragment,j),Xt=l(j),V=i(j,"DIV",{class:!0});var E=v(V);c(ce.$$.fragment,E),Wt=l(E),Re=i(E,"P",{"data-svelte-h":!0}),$(Re)!=="svelte-16em2g0"&&(Re.textContent=Us),Dt=l(E),qe=i(E,"P",{"data-svelte-h":!0}),$(qe)!=="svelte-18fkoy7"&&(qe.innerHTML=Is),E.forEach(s),j.forEach(s),yt=l(e),c(ue.$$.fragment,e),jt=l(e),k=i(e,"DIV",{class:!0});var Z=v(k);c(me.$$.fragment,Z),Yt=l(Z),Ve=i(Z,"P",{"data-svelte-h":!0}),$(Ve)!=="svelte-wncm6c"&&(Ve.textContent=Bs),Ft=l(Z),Ae=i(Z,"P",{"data-svelte-h":!0}),$(Ae)!=="svelte-1toa14k"&&(Ae.textContent=Cs),Z.forEach(s),bt=l(e),c(ge.$$.fragment,e),wt=l(e),P=i(e,"DIV",{class:!0});var L=v(P);c(fe.$$.fragment,L),Kt=l(L),He=i(L,"P",{"data-svelte-h":!0}),$(He)!=="svelte-1a3twli"&&(He.textContent=_s),Ot=l(L),Ee=i(L,"P",{"data-svelte-h":!0}),$(Ee)!=="svelte-1toa14k"&&(Ee.textContent=ks),L.forEach(s),Tt=l(e),c(he.$$.fragment,e),vt=l(e),U=i(e,"DIV",{class:!0});var X=v(U);c($e.$$.fragment,X),es=l(X),Ze=i(X,"P",{"data-svelte-h":!0}),$(Ze)!=="svelte-xw2gy5"&&(Ze.innerHTML=Ps),ts=l(X),Le=i(X,"P",{"data-svelte-h":!0}),$(Le)!=="svelte-15oq5pb"&&(Le.innerHTML=Gs),ss=l(X),Ne=i(X,"P",{"data-svelte-h":!0}),$(Ne)!=="svelte-qxn9du"&&(Ne.innerHTML=Rs),X.forEach(s),xt=l(e),c(Me.$$.fragment,e),Ut=l(e),c(Je.$$.fragment,e),It=l(e),H=i(e,"DIV",{class:!0});var At=v(H);c(ye.$$.fragment,At),ns=l(At),Qe=i(At,"P",{"data-svelte-h":!0}),$(Qe)!=="svelte-1gejamc"&&(Qe.innerHTML=qs),At.forEach(s),Bt=l(e),c(je.$$.fragment,e),Ct=l(e),G=i(e,"DIV",{class:!0});var et=v(G);c(be.$$.fragment,et),ls=l(et),ze=i(et,"P",{"data-svelte-h":!0}),$(ze)!=="svelte-153ati9"&&(ze.textContent=Vs),rs=l(et),C=i(et,"DIV",{class:!0});var W=v(C);c(we.$$.fragment,W),os=l(W),Se=i(W,"P",{"data-svelte-h":!0}),$(Se)!=="svelte-xz8n8e"&&(Se.textContent=As),as=l(W),Xe=i(W,"P",{"data-svelte-h":!0}),$(Xe)!=="svelte-4aoel"&&(Xe.innerHTML=Hs),is=l(W),We=i(W,"P",{"data-svelte-h":!0}),$(We)!=="svelte-xo7f61"&&(We.textContent=Es),W.forEach(s),et.forEach(s),_t=l(e),c(Te.$$.fragment,e),kt=l(e),I=i(e,"DIV",{class:!0});var D=v(I);c(ve.$$.fragment,D),ds=l(D),De=i(D,"P",{"data-svelte-h":!0}),$(De)!=="svelte-1q0zcc3"&&(De.textContent=Zs),ps=l(D),c(z.$$.fragment,D),cs=l(D),S=i(D,"DIV",{class:!0});var Ht=v(S);c(xe.$$.fragment,Ht),us=l(Ht),Ye=i(Ht,"P",{"data-svelte-h":!0}),$(Ye)!=="svelte-1lgx3sj"&&(Ye.textContent=Ls),Ht.forEach(s),D.forEach(s),Pt=l(e),c(Ue.$$.fragment,e),Gt=l(e),R=i(e,"DIV",{class:!0});var tt=v(R);c(Ie.$$.fragment,tt),ms=l(tt),Fe=i(tt,"P",{"data-svelte-h":!0}),$(Fe)!=="svelte-syi0zc"&&(Fe.textContent=Ns),gs=l(tt),A=i(tt,"DIV",{class:!0});var st=v(A);c(Be.$$.fragment,st),fs=l(st),Ke=i(st,"P",{"data-svelte-h":!0}),$(Ke)!=="svelte-1ko5z1p"&&(Ke.textContent=Qs),hs=l(st),Oe=i(st,"P",{"data-svelte-h":!0}),$(Oe)!=="svelte-3t8r62"&&(Oe.innerHTML=zs),st.forEach(s),tt.forEach(s),Rt=l(e),c(Ce.$$.fragment,e),qt=l(e),lt=i(e,"P",{}),v(lt).forEach(s),this.h()},h(){x(d,"name","hf:doc:metadata"),x(d,"content",rn),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,d),o(e,w,t),o(e,M,t),o(e,J,t),u(b,e,t),o(e,h,t),u(T,e,t),o(e,rt,t),o(e,Y,t),o(e,ot,t),o(e,F,t),o(e,at,t),u(K,e,t),o(e,it,t),u(O,e,t),o(e,dt,t),o(e,ee,t),o(e,pt,t),u(te,e,t),o(e,ct,t),u(se,e,t),o(e,ut,t),o(e,ne,t),o(e,mt,t),o(e,le,t),o(e,gt,t),u(re,e,t),o(e,ft,t),o(e,oe,t),o(e,ht,t),u(ae,e,t),o(e,$t,t),u(ie,e,t),o(e,Mt,t),u(de,e,t),o(e,Jt,t),o(e,y,t),u(pe,y,null),r(y,Zt),r(y,_e),r(y,Lt),r(y,ke),r(y,Nt),r(y,Pe),r(y,Qt),r(y,Ge),r(y,zt),u(N,y,null),r(y,St),u(Q,y,null),r(y,Xt),r(y,V),u(ce,V,null),r(V,Wt),r(V,Re),r(V,Dt),r(V,qe),o(e,yt,t),u(ue,e,t),o(e,jt,t),o(e,k,t),u(me,k,null),r(k,Yt),r(k,Ve),r(k,Ft),r(k,Ae),o(e,bt,t),u(ge,e,t),o(e,wt,t),o(e,P,t),u(fe,P,null),r(P,Kt),r(P,He),r(P,Ot),r(P,Ee),o(e,Tt,t),u(he,e,t),o(e,vt,t),o(e,U,t),u($e,U,null),r(U,es),r(U,Ze),r(U,ts),r(U,Le),r(U,ss),r(U,Ne),o(e,xt,t),u(Me,e,t),o(e,Ut,t),u(Je,e,t),o(e,It,t),o(e,H,t),u(ye,H,null),r(H,ns),r(H,Qe),o(e,Bt,t),u(je,e,t),o(e,Ct,t),o(e,G,t),u(be,G,null),r(G,ls),r(G,ze),r(G,rs),r(G,C),u(we,C,null),r(C,os),r(C,Se),r(C,as),r(C,Xe),r(C,is),r(C,We),o(e,_t,t),u(Te,e,t),o(e,kt,t),o(e,I,t),u(ve,I,null),r(I,ds),r(I,De),r(I,ps),u(z,I,null),r(I,cs),r(I,S),u(xe,S,null),r(S,us),r(S,Ye),o(e,Pt,t),u(Ue,e,t),o(e,Gt,t),o(e,R,t),u(Ie,R,null),r(R,ms),r(R,Fe),r(R,gs),r(R,A),u(Be,A,null),r(A,fs),r(A,Ke),r(A,hs),r(A,Oe),o(e,Rt,t),u(Ce,e,t),o(e,qt,t),o(e,lt,t),Vt=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),T.$set(j);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),N.$set(E);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),Q.$set(Z);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),z.$set(L)},i(e){Vt||(m(b.$$.fragment,e),m(T.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(re.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(de.$$.fragment,e),m(pe.$$.fragment,e),m(N.$$.fragment,e),m(Q.$$.fragment,e),m(ce.$$.fragment,e),m(ue.$$.fragment,e),m(me.$$.fragment,e),m(ge.$$.fragment,e),m(fe.$$.fragment,e),m(he.$$.fragment,e),m($e.$$.fragment,e),m(Me.$$.fragment,e),m(Je.$$.fragment,e),m(ye.$$.fragment,e),m(je.$$.fragment,e),m(be.$$.fragment,e),m(we.$$.fragment,e),m(Te.$$.fragment,e),m(ve.$$.fragment,e),m(z.$$.fragment,e),m(xe.$$.fragment,e),m(Ue.$$.fragment,e),m(Ie.$$.fragment,e),m(Be.$$.fragment,e),m(Ce.$$.fragment,e),Vt=!0)},o(e){g(b.$$.fragment,e),g(T.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(te.$$.fragment,e),g(se.$$.fragment,e),g(re.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(N.$$.fragment,e),g(Q.$$.fragment,e),g(ce.$$.fragment,e),g(ue.$$.fragment,e),g(me.$$.fragment,e),g(ge.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g($e.$$.fragment,e),g(Me.$$.fragment,e),g(Je.$$.fragment,e),g(ye.$$.fragment,e),g(je.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(ve.$$.fragment,e),g(z.$$.fragment,e),g(xe.$$.fragment,e),g(Ue.$$.fragment,e),g(Ie.$$.fragment,e),g(Be.$$.fragment,e),g(Ce.$$.fragment,e),Vt=!1},d(e){e&&(s(w),s(M),s(J),s(h),s(rt),s(Y),s(ot),s(F),s(at),s(it),s(dt),s(ee),s(pt),s(ct),s(ut),s(ne),s(mt),s(le),s(gt),s(ft),s(oe),s(ht),s($t),s(Mt),s(Jt),s(y),s(yt),s(jt),s(k),s(bt),s(wt),s(P),s(Tt),s(vt),s(U),s(xt),s(Ut),s(It),s(H),s(Bt),s(Ct),s(G),s(_t),s(kt),s(I),s(Pt),s(Gt),s(R),s(Rt),s(qt),s(lt)),s(d),f(b,e),f(T,e),f(K,e),f(O,e),f(te,e),f(se,e),f(re,e),f(ae,e),f(ie,e),f(de,e),f(pe),f(N),f(Q),f(ce),f(ue,e),f(me),f(ge,e),f(fe),f(he,e),f($e),f(Me,e),f(Je,e),f(ye),f(je,e),f(be),f(we),f(Te,e),f(ve),f(z),f(xe),f(Ue,e),f(Ie),f(Be),f(Ce,e)}}}const rn='{"title":"Judges","local":"judges","sections":[{"title":"Using the provided judges","local":"using-the-provided-judges","sections":[],"depth":2},{"title":"Define your own judge","local":"define-your-own-judge","sections":[],"depth":2},{"title":"Provided judges","local":"provided-judges","sections":[{"title":"PairRMJudge","local":"trl.PairRMJudge","sections":[],"depth":3},{"title":"HfPairwiseJudge","local":"trl.HfPairwiseJudge","sections":[],"depth":3},{"title":"OpenAIPairwiseJudge","local":"trl.OpenAIPairwiseJudge","sections":[],"depth":3},{"title":"AllTrueJudge","local":"trl.AllTrueJudge","sections":[],"depth":3}],"depth":2},{"title":"Base classes","local":"base-classes","sections":[{"title":"BaseJudge","local":"trl.BaseJudge","sections":[],"depth":3},{"title":"BaseBinaryJudge","local":"trl.BaseBinaryJudge","sections":[],"depth":3},{"title":"BaseRankJudge","local":"trl.BaseRankJudge","sections":[],"depth":3},{"title":"BasePairwiseJudge","local":"trl.BasePairwiseJudge","sections":[],"depth":3}],"depth":2}],"depth":1}';function on(q){return Ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fn extends Ys{constructor(d){super(),Fs(this,d,on,ln,Ws,{})}}export{fn as component};
