import{s as fl,f as Ul,n as Bl,o as gl}from"../chunks/scheduler.37c15a92.js";import{S as Il,i as Gl,g as i,s as n,r as u,A as Cl,h as o,f as l,c as a,j as bl,u as h,x as p,k as Ye,y as _l,a as s,v as M,d as r,t as c,w}from"../chunks/index.2bf4358c.js";import{C as y}from"../chunks/CodeBlock.4e987730.js";import{H as Ze}from"../chunks/Heading.8ada512a.js";import{E as $l}from"../chunks/index.2145fe70.js";function vl(We){let m,gt,Ut,It,d,Gt,j,Ne,Ct,T,Re="This course is framework-agnostic because we want to <strong>focus on the concepts of AI agents and avoid getting bogged down in the specifics of a particular framework</strong>.",_t,J,Ee="Also, we want students to be able to use the concepts they learn in this course in their own projects, using any framework they like.",$t,b,Qe="Therefore, for this Unit 1, we will use a dummy agent library and a simple serverless API to access our LLM engine.",vt,f,Ve="You probably wouldn’t use these in production, but they will serve as a good <strong>starting point for understanding how agents work</strong>.",xt,U,Fe="After this section, you’ll be ready to <strong>create a simple Agent</strong> using <code>smolagents</code>",kt,B,Ae="And in the following Units we will also use other AI Agent libraries like <code>LangGraph</code>, <code>LangChain</code>, and <code>LlamaIndex</code>.",Xt,g,ze="To keep things simple we will use a simple Python function as a Tool and Agent.",qt,I,He="We will use built-in Python packages like <code>datetime</code> and <code>os</code> so that you can try it out in any environment.",Yt,G,Se='You can follow the process <a href="https://huggingface.co/agents-course/notebooks/blob/main/dummy_agent_library.ipynb" rel="nofollow">in this notebook</a> and <strong>run the code yourself</strong>.',Zt,C,Wt,_,Le="In the Hugging Face ecosystem, there is a convenient feature called Serverless API that allows you to easily run inference on many models. There’s no installation or deployment required.",Nt,$,Rt,v,Et,x,Pe="output:",Qt,k,Vt,X,Oe="As seen in the LLM section, if we just do decoding, <strong>the model will only stop when it predicts an EOS token</strong>, and this does not happen here because this is a conversational (chat) model and <strong>we didn’t apply the chat template it expects</strong>.",Ft,q,De='If we now add the special tokens related to the <a href="https://huggingface.co/meta-llama/Llama-3.2-3B-Instruct">Llama-3.2-3B-Instruct model</a> that we’re using, the behavior changes and it now produces the expected EOS.',At,Y,zt,Z,Ke="output:",Ht,W,St,N,tl="Using the “chat” method is a much more convenient and reliable way to apply chat templates:",Lt,R,Pt,E,el="output:",Ot,Q,Dt,V,ll="The chat method is the RECOMMENDED method to use in order to ensure a smooth transition between models, but since this notebook is only educational, we will keep using the “text_generation” method to understand the details.",Kt,F,te,A,sl="In the previous sections, we saw that the core of an agent library is to append information in the system prompt.",ee,z,nl="This system prompt is a bit more complex than the one we saw earlier, but it already contains:",le,H,al="<li><strong>Information about the tools</strong></li> <li><strong>Cycle instructions</strong> (Thought → Action → Observation)</li>",se,S,ne,L,il="Since we are running the “text_generation” method, we need to apply the prompt manually:",ae,P,ie,O,ol="We can also do it like this, which is what happens inside the <code>chat</code> method :",oe,D,pe,K,pl="The prompt now is :",ue,tt,he,et,ul="Let’s decode!",Me,lt,re,st,hl="output:",ce,nt,we,at,Ml="Do you see the issue?",ye,it,rl=`<p>The answer was hallucinated by the model. We need to stop to actually execute the function!
Let’s now stop on “Observation” so that we don’t hallucinate the actual function response.</p>`,me,ot,de,pt,cl="output:",je,ut,Te,ht,wl=`Much Better!
Let’s now create a dummy get weather function.  In a real situation, you would likely call an API.`,Je,Mt,be,rt,yl="output:",fe,ct,Ue,wt,ml="Let’s concatenate the base prompt, the completion until function execution and the result of the function as an Observation and resume generation.",Be,yt,ge,mt,dl="Here is the new prompt:",Ie,dt,Ge,jt,jl="Output:",Ce,Tt,_e,$e,ve,Jt,Tl="We learned how we can create Agents from scratch using Python code, and we <strong>saw just how tedious that process can be</strong>. Fortunately, many Agent libraries simplify this work by handling much of the heavy lifting for you.",xe,bt,Jl="Now, we’re ready <strong>to create our first real Agent</strong> using the <code>smolagents</code> library.",ke,ft,Xe,Bt,qe;return d=new Ze({props:{title:"Dummy Agent Library",local:"dummy-agent-library",headingTag:"h1"}}),C=new Ze({props:{title:"Serverless API",local:"serverless-api",headingTag:"h2"}}),$=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIzJTIwWW91JTIwbmVlZCUyMGElMjB0b2tlbiUyMGZyb20lMjBodHRwcyUzQSUyRiUyRmhmLmNvJTJGc2V0dGluZ3MlMkZ0b2tlbnMlMkMlMjBlbnN1cmUlMjB0aGF0JTIweW91JTIwc2VsZWN0JTIwJ3JlYWQnJTIwYXMlMjB0aGUlMjB0b2tlbiUyMHR5cGUuJTIwSWYlMjB5b3UlMjBydW4lMjB0aGlzJTIwb24lMjBHb29nbGUlMjBDb2xhYiUyQyUyMHlvdSUyMGNhbiUyMHNldCUyMGl0JTIwdXAlMjBpbiUyMHRoZSUyMCUyMnNldHRpbmdzJTIyJTIwdGFiJTIwdW5kZXIlMjAlMjJzZWNyZXRzJTIyLiUyME1ha2UlMjBzdXJlJTIwdG8lMjBjYWxsJTIwaXQlMjAlMjJIRl9UT0tFTiUyMiUwQW9zLmVudmlyb24lNUIlMjJIRl9UT0tFTiUyMiU1RCUzRCUyMmhmX3h4eHh4eHh4eHh4eHh4JTIyJTBBJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTIzJTIwaWYlMjB0aGUlMjBvdXRwdXRzJTIwZm9yJTIwbmV4dCUyMGNlbGxzJTIwYXJlJTIwd3JvbmclMkMlMjB0aGUlMjBmcmVlJTIwbW9kZWwlMjBtYXklMjBiZSUyMG92ZXJsb2FkZWQuJTIwWW91JTIwY2FuJTIwYWxzbyUyMHVzZSUyMHRoaXMlMjBwdWJsaWMlMjBlbmRwb2ludCUyMHRoYXQlMjBjb250YWlucyUyMExsYW1hLTMuMi0zQi1JbnN0cnVjdCUwQSUyMyUyMGNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmpjMjZtd2cyMjhta2o4ZHcudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment">## You need a token from https://hf.co/settings/tokens, ensure that you select &#x27;read&#x27; as the token type. If you run this on Google Colab, you can set it up in the &quot;settings&quot; tab under &quot;secrets&quot;. Make sure to call it &quot;HF_TOKEN&quot;</span>
os.environ[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>]=<span class="hljs-string">&quot;hf_xxxxxxxxxxxxxx&quot;</span>

client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)
<span class="hljs-comment"># if the outputs for next cells are wrong, the free model may be overloaded. You can also use this public endpoint that contains Llama-3.2-3B-Instruct</span>
<span class="hljs-comment"># client = InferenceClient(&quot;https://jc26mwg228mkj8dw.us-east-1.aws.endpoints.huggingface.cloud&quot;)</span>`,wrap:!1}}),v=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBKSUwQSUwQXByaW50KG91dHB1dCk=",highlighted:`output = client.text_generation(
    <span class="hljs-string">&quot;The capital of France is&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),k=new y({props:{code:"UGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiUyMFRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwUGFyaXMuJTIwVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4lMjBUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLg==",highlighted:'Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris. The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),Y=new y({props:{code:"cHJvbXB0JTNEJTIyJTIyJTIyJTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTIyJTIyJTIyJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`prompt=<span class="hljs-string">&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
The capital of France is&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;&quot;&quot;&quot;</span>
output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),W=new y({props:{code:"VGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjBQYXJpcy4=",highlighted:'The capital of France <span class="hljs-keyword">is</span> Paris.',wrap:!1}}),R=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTIwaXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQXByaW50KG91dHB1dC5jaG9pY2VzJTVCMCU1RC5tZXNzYWdlLmNvbnRlbnQp",highlighted:`output = client.chat.completions.create(
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The capital of France is&quot;</span>},
    ],
    stream=<span class="hljs-literal">False</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)
<span class="hljs-built_in">print</span>(output.choices[<span class="hljs-number">0</span>].message.content)`,wrap:!1}}),Q=new y({props:{code:"UGFyaXMu",highlighted:"Paris.",wrap:!1}}),F=new Ze({props:{title:"Dummy Agent",local:"dummy-agent",headingTag:"h2"}}),S=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`# <span class="hljs-type">This</span> system prompt is a bit more complex and actually contains the function description already appended.
# <span class="hljs-type">Here</span> we suppose that the textual description of the tools has already been appended.

<span class="hljs-type">SYSTEM_PROMPT</span> = <span class="hljs-comment">&quot;&quot;</span><span class="hljs-comment">&quot;Answer the following questions as best you can. You have access to the following tools:

get_weather: Get the current weather in a given location

The way you use the tools is by specifying a json blob.
Specifically, this json should have an \`action\` key (with the name of the tool to use) and an \`action_input\` key (with the input to the tool going here).

The only values that should be in the &quot;</span>action<span class="hljs-comment">&quot; field are:
get_weather: Get the current weather in a given location, args: {&quot;</span>location<span class="hljs-comment">&quot;: {&quot;</span>type<span class="hljs-comment">&quot;: &quot;</span>string<span class="hljs-comment">&quot;}}
example use :

{{
  &quot;</span>action<span class="hljs-comment">&quot;: &quot;</span>get_weather<span class="hljs-comment">&quot;,
  &quot;</span>action_input<span class="hljs-comment">&quot;: {&quot;</span>location<span class="hljs-comment">&quot;: &quot;</span><span class="hljs-type">New</span> <span class="hljs-type">York</span><span class="hljs-comment">&quot;}
}}


ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action at a time in this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can repeat N times, you should take several steps when needed. The $JSON_BLOB must be formatted as markdown and only use a SINGLE action at a time.)

You must always end your output with the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the exact characters \`Final Answer:\` when you provide a definitive answer. &quot;</span><span class="hljs-comment">&quot;&quot;</span>`,wrap:!1}}),P=new y({props:{code:"cHJvbXB0JTNEZiUyMiUyMiUyMiUzQyU3Q2JlZ2luX29mX3RleHQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0VzeXN0ZW0lM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBJTdCU1lTVEVNX1BST01QVCU3RCUwQSUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTBBV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGluJTIwTG9uZG9uJTIwJTNGJTBBJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`prompt=<span class="hljs-string">f&quot;&quot;&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;
<span class="hljs-subst">{SYSTEM_PROMPT}</span>
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
What&#x27;s the weather in London ?
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),D=new y({props:{code:"bWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMFNZU1RFTV9QUk9NUFQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjAlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItM0ItSW5zdHJ1Y3QlMjIpJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSk=",highlighted:`messages=[
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: SYSTEM_PROMPT},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather in London ?&quot;</span>},
    ]
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.2-3B-Instruct&quot;</span>)

tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>,add_generation_prompt=<span class="hljs-literal">True</span>)`,wrap:!1}}),tt=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEE=",highlighted:`&lt;|<span class="hljs-type">begin_of_text</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;system</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
Answer</span> the following questions <span class="hljs-built_in">as</span> best you can. You have access to the following tools:

get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location

The way you use the tools is <span class="hljs-built_in">by</span> specifying a json blob.
Specifically, this json should have an \`action\` key (<span class="hljs-built_in">with</span> the name of the tool to use) and a \`action_input\` key (<span class="hljs-built_in">with</span> the input to the tool going here).

The only values that should be <span class="hljs-built_in">in</span> the <span class="hljs-string">&quot;action&quot;</span> <span class="hljs-built_in">field</span> are:
get_weather: Get the current weather <span class="hljs-built_in">in</span> a given location, args: {<span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}}
example use : 

{{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;New York&quot;</span>}
}}

ALWAYS use the following format:

Question: the input question you must answer
Thought: you should always think about one action to take. Only one action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span> <span class="hljs-built_in">in</span> this format:
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.
... (this Thought/Action/Observation can <span class="hljs-built_in">repeat</span> N times, you should take several steps when needed. The $JSON_BLOB must be formatted <span class="hljs-built_in">as</span> markdown and only use a SINGLE action <span class="hljs-built_in">at</span> a <span class="hljs-built_in">time</span>.)

You must always <span class="hljs-keyword">end</span> your output <span class="hljs-built_in">with</span> the following format:

Thought: I now know the final answer
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the <span class="hljs-built_in">exact</span> characters \`Final Answer:\` when you provide a definitive answer. 
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;user</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;
What</span>&#x27;s the weather <span class="hljs-built_in">in</span> London ?
&lt;|<span class="hljs-type">eot_id</span>|<span class="hljs-type">&gt;&lt;|start_header_id</span>|<span class="hljs-type">&gt;assistant</span>&lt;|<span class="hljs-type">end_header_id</span>|<span class="hljs-type">&gt;</span>`,wrap:!1}}),lt=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSklMEElMEFwcmludChvdXRwdXQp",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),nt=new y({props:{code:"VGhvdWdodCUzQSUyMEklMjB3aWxsJTIwY2hlY2slMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24uJTBBQWN0aW9uJTNBJTBBJTYwJTYwJTYwJTBBJTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb25faW5wdXQlMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RCUwQSU2MCU2MCU2MCUwQU9ic2VydmF0aW9uJTNBJTIwVGhlJTIwY3VycmVudCUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwbW9zdGx5JTIwY2xvdWR5JTIwd2l0aCUyMGElMjBoaWdoJTIwb2YlMjAxMiVDMiVCMEMlMjBhbmQlMjBhJTIwbG93JTIwb2YlMjA4JUMyJUIwQy4=",highlighted:`Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Action:
\`\`\`
{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
\`\`\`
Observation: The current weather in London is mostly cloudy with a high of 12°C<span class="hljs-built_in"> and </span>a low of 8°C.`,wrap:!1}}),ot=new y({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwMCUyQyUwQSUyMCUyMCUyMCUyMHN0b3AlM0QlNUIlMjJPYnNlcnZhdGlvbiUzQSUyMiU1RCUyMCUyMyUyMExldCdzJTIwc3RvcCUyMGJlZm9yZSUyMGFueSUyMGFjdHVhbCUyMGZ1bmN0aW9uJTIwaXMlMjBjYWxsZWQlMEEpJTBBJTBBcHJpbnQob3V0cHV0KQ==",highlighted:`output = client.text_generation(
    prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
    stop=[<span class="hljs-string">&quot;Observation:&quot;</span>] <span class="hljs-comment"># Let&#x27;s stop before any actual function is called</span>
)

<span class="hljs-built_in">print</span>(output)`,wrap:!1}}),ut=new y({props:{code:"VGhvdWdodCUzQSUyMEklMjB3aWxsJTIwY2hlY2slMjB0aGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24uJTBBQWN0aW9uJTNBJTBBJTYwJTYwJTYwJTBBJTdCJTBBJTIwJTIwJTIyYWN0aW9uJTIyJTNBJTIwJTIyZ2V0X3dlYXRoZXIlMjIlMkMlMEElMjAlMjAlMjJhY3Rpb25faW5wdXQlMjIlM0ElMjAlN0IlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMkxvbmRvbiUyMiU3RCUwQSU3RCUwQSU2MCU2MCU2MCUwQU9ic2VydmF0aW9uJTNB",highlighted:`Thought: I will<span class="hljs-built_in"> check </span>the weather in London.
Action:
\`\`\`
{
  <span class="hljs-string">&quot;action&quot;</span>: <span class="hljs-string">&quot;get_weather&quot;</span>,
  <span class="hljs-string">&quot;action_input&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;London&quot;</span>}
}
\`\`\`
Observation:`,wrap:!1}}),Mt=new y({props:{code:"JTIzJTIwRHVtbXklMjBmdW5jdGlvbiUwQWRlZiUyMGdldF93ZWF0aGVyKGxvY2F0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGYlMjJ0aGUlMjB3ZWF0aGVyJTIwaW4lMjAlN0Jsb2NhdGlvbiU3RCUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24lMjIlMEElMEFnZXRfd2VhdGhlcignTG9uZG9uJyk=",highlighted:`<span class="hljs-comment"># Dummy function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">location</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;the weather in <span class="hljs-subst">{location}</span> is sunny with low temperatures. \\n&quot;</span>

get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)`,wrap:!1}}),ct=new y({props:{code:"J3RoZSUyMHdlYXRoZXIlMjBpbiUyMExvbmRvbiUyMGlzJTIwc3VubnklMjB3aXRoJTIwbG93JTIwdGVtcGVyYXR1cmVzLiUyMCU1Q24n",highlighted:'<span class="hljs-symbol">&#x27;the</span> weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures. \\n&#x27;',wrap:!1}}),yt=new y({props:{code:"bmV3X3Byb21wdCUyMCUzRCUyMHByb21wdCUyMCUyQiUyMG91dHB1dCUyMCUyQiUyMGdldF93ZWF0aGVyKCdMb25kb24nKSUwQWZpbmFsX291dHB1dCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwbmV3X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTBBKSUwQSUwQXByaW50KGZpbmFsX291dHB1dCk=",highlighted:`new_prompt = prompt + output + get_weather(<span class="hljs-string">&#x27;London&#x27;</span>)
final_output = client.text_generation(
    new_prompt,
    max_new_tokens=<span class="hljs-number">200</span>,
)

<span class="hljs-built_in">print</span>(final_output)`,wrap:!1}}),dt=new y({props:{code:"JTBBJTBBJTBBJTBBJTBBJTBBJTBBJTBBKHRoaXMlMjBUaG91Z2h0JTJGQWN0aW9uJTJGT2JzZXJ2YXRpb24lMjBjYW4lMjByZXBlYXQlMjBOJTIwdGltZXMlMkMlMjB5b3UlMjBzaG91bGQlMjB0YWtlJTIwc2V2ZXJhbCUyMHN0ZXBzJTIwd2hlbiUyMG5lZWRlZC4lMjBUaGUlMjAlMjRKU09OX0JMT0IlMjBtdXN0JTIwYmUlMjBmb3JtYXR0ZWQlMjBhcyUyMG1hcmtkb3duJTIwYW5kJTIwb25seSUyMHVzZSUyMGElMjBTSU5HTEUlMjBhY3Rpb24lMjBhdCUyMGElMjB0aW1lLiklMEElMEElMEElMEElMEElMEE=",highlighted:`&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;
Answer the following questions as best you can. You have access to the following tools:

get_weather: Get the current weather in a given location

The way you use the tools is by specifying a json blob.
Specifically, this json should have a \`action\` key (with the name of the tool to use) and a \`action_input\` key (with the input to the tool going here).

The only values that should be in the &quot;action&quot; field are:
get_weather: Get the current weather in a given location, args: {&quot;location&quot;: {&quot;type&quot;: &quot;string&quot;}}
example use : 

{
  &quot;action&quot;: &quot;get_weather&quot;,
  &quot;action_input&quot;: {&quot;location&quot;: &quot;New York&quot;}
}

ALWAYS use the following format:

Question: the input question you must answer  
Thought: you should always think about one action to take. Only one action at a time in this format:  
Action:

$JSON_BLOB (inside markdown cell)

Observation: the result of the action. This Observation is unique, complete, and the source of truth.  
... (this Thought/Action/Observation can repeat N times, you should take several steps when needed. The $JSON_BLOB must be formatted as markdown and only use a SINGLE action at a time.)

You must always end your output with the following format:

Thought: I now know the final answer  
Final Answer: the final answer to the original input question

Now begin! Reminder to ALWAYS use the exact characters \`Final Answer:\` when you provide a definitive answer.
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
What&#x27;s the weather in London?
&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
Thought: I will check the weather in London.  
Action:

    \`\`\`json
    {
      &quot;action&quot;: &quot;get_weather&quot;,
      &quot;action_input&quot;: {&quot;location&quot;: {&quot;type&quot;: &quot;string&quot;, &quot;value&quot;: &quot;London&quot;}}
    }
    \`\`\`

Observation: The weather in London is sunny with low temperatures.
`,wrap:!1}}),Tt=new y({props:{code:"RmluYWwlMjBBbnN3ZXIlM0ElMjBUaGUlMjB3ZWF0aGVyJTIwaW4lMjBMb25kb24lMjBpcyUyMHN1bm55JTIwd2l0aCUyMGxvdyUyMHRlbXBlcmF0dXJlcy4=",highlighted:'<span class="hljs-keyword">Final</span> Answer: The weather <span class="hljs-keyword">in</span> London <span class="hljs-keyword">is</span> sunny <span class="hljs-keyword">with</span> low temperatures.',wrap:!1}}),ft=new $l({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/dummy-agent-library.mdx"}}),{c(){m=i("meta"),gt=n(),Ut=i("p"),It=n(),u(d.$$.fragment),Gt=n(),j=i("img"),Ct=n(),T=i("p"),T.innerHTML=Re,_t=n(),J=i("p"),J.textContent=Ee,$t=n(),b=i("p"),b.textContent=Qe,vt=n(),f=i("p"),f.innerHTML=Ve,xt=n(),U=i("p"),U.innerHTML=Fe,kt=n(),B=i("p"),B.innerHTML=Ae,Xt=n(),g=i("p"),g.textContent=ze,qt=n(),I=i("p"),I.innerHTML=He,Yt=n(),G=i("p"),G.innerHTML=Se,Zt=n(),u(C.$$.fragment),Wt=n(),_=i("p"),_.textContent=Le,Nt=n(),u($.$$.fragment),Rt=n(),u(v.$$.fragment),Et=n(),x=i("p"),x.textContent=Pe,Qt=n(),u(k.$$.fragment),Vt=n(),X=i("p"),X.innerHTML=Oe,Ft=n(),q=i("p"),q.innerHTML=De,At=n(),u(Y.$$.fragment),zt=n(),Z=i("p"),Z.textContent=Ke,Ht=n(),u(W.$$.fragment),St=n(),N=i("p"),N.textContent=tl,Lt=n(),u(R.$$.fragment),Pt=n(),E=i("p"),E.textContent=el,Ot=n(),u(Q.$$.fragment),Dt=n(),V=i("p"),V.textContent=ll,Kt=n(),u(F.$$.fragment),te=n(),A=i("p"),A.textContent=sl,ee=n(),z=i("p"),z.textContent=nl,le=n(),H=i("ol"),H.innerHTML=al,se=n(),u(S.$$.fragment),ne=n(),L=i("p"),L.textContent=il,ae=n(),u(P.$$.fragment),ie=n(),O=i("p"),O.innerHTML=ol,oe=n(),u(D.$$.fragment),pe=n(),K=i("p"),K.textContent=pl,ue=n(),u(tt.$$.fragment),he=n(),et=i("p"),et.textContent=ul,Me=n(),u(lt.$$.fragment),re=n(),st=i("p"),st.textContent=hl,ce=n(),u(nt.$$.fragment),we=n(),at=i("p"),at.textContent=Ml,ye=n(),it=i("blockquote"),it.innerHTML=rl,me=n(),u(ot.$$.fragment),de=n(),pt=i("p"),pt.textContent=cl,je=n(),u(ut.$$.fragment),Te=n(),ht=i("p"),ht.textContent=wl,Je=n(),u(Mt.$$.fragment),be=n(),rt=i("p"),rt.textContent=yl,fe=n(),u(ct.$$.fragment),Ue=n(),wt=i("p"),wt.textContent=ml,Be=n(),u(yt.$$.fragment),ge=n(),mt=i("p"),mt.textContent=dl,Ie=n(),u(dt.$$.fragment),Ge=n(),jt=i("p"),jt.textContent=jl,Ce=n(),u(Tt.$$.fragment),_e=n(),$e=i("hr"),ve=n(),Jt=i("p"),Jt.innerHTML=Tl,xe=n(),bt=i("p"),bt.innerHTML=Jl,ke=n(),u(ft.$$.fragment),Xe=n(),Bt=i("p"),this.h()},l(t){const e=Cl("svelte-u9bgzb",document.head);m=o(e,"META",{name:!0,content:!0}),e.forEach(l),gt=a(t),Ut=o(t,"P",{}),bl(Ut).forEach(l),It=a(t),h(d.$$.fragment,t),Gt=a(t),j=o(t,"IMG",{src:!0,alt:!0}),Ct=a(t),T=o(t,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1rwfam6"&&(T.innerHTML=Re),_t=a(t),J=o(t,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1pvln0h"&&(J.textContent=Ee),$t=a(t),b=o(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-17n0axy"&&(b.textContent=Qe),vt=a(t),f=o(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1ssvh5p"&&(f.innerHTML=Ve),xt=a(t),U=o(t,"P",{"data-svelte-h":!0}),p(U)!=="svelte-r0w337"&&(U.innerHTML=Fe),kt=a(t),B=o(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-9snja6"&&(B.innerHTML=Ae),Xt=a(t),g=o(t,"P",{"data-svelte-h":!0}),p(g)!=="svelte-scmak8"&&(g.textContent=ze),qt=a(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-10qtj1b"&&(I.innerHTML=He),Yt=a(t),G=o(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1fa85bb"&&(G.innerHTML=Se),Zt=a(t),h(C.$$.fragment,t),Wt=a(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1y7mhy7"&&(_.textContent=Le),Nt=a(t),h($.$$.fragment,t),Rt=a(t),h(v.$$.fragment,t),Et=a(t),x=o(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1wueeet"&&(x.textContent=Pe),Qt=a(t),h(k.$$.fragment,t),Vt=a(t),X=o(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-14l0pz9"&&(X.innerHTML=Oe),Ft=a(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1891xc3"&&(q.innerHTML=De),At=a(t),h(Y.$$.fragment,t),zt=a(t),Z=o(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1wueeet"&&(Z.textContent=Ke),Ht=a(t),h(W.$$.fragment,t),St=a(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-10i9u01"&&(N.textContent=tl),Lt=a(t),h(R.$$.fragment,t),Pt=a(t),E=o(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1wueeet"&&(E.textContent=el),Ot=a(t),h(Q.$$.fragment,t),Dt=a(t),V=o(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-o9oayq"&&(V.textContent=ll),Kt=a(t),h(F.$$.fragment,t),te=a(t),A=o(t,"P",{"data-svelte-h":!0}),p(A)!=="svelte-xr84ar"&&(A.textContent=sl),ee=a(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1m7y210"&&(z.textContent=nl),le=a(t),H=o(t,"OL",{"data-svelte-h":!0}),p(H)!=="svelte-27sevg"&&(H.innerHTML=al),se=a(t),h(S.$$.fragment,t),ne=a(t),L=o(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1jc27vd"&&(L.textContent=il),ae=a(t),h(P.$$.fragment,t),ie=a(t),O=o(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1letw4p"&&(O.innerHTML=ol),oe=a(t),h(D.$$.fragment,t),pe=a(t),K=o(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-u9o4sn"&&(K.textContent=pl),ue=a(t),h(tt.$$.fragment,t),he=a(t),et=o(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-18yryy0"&&(et.textContent=ul),Me=a(t),h(lt.$$.fragment,t),re=a(t),st=o(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1wueeet"&&(st.textContent=hl),ce=a(t),h(nt.$$.fragment,t),we=a(t),at=o(t,"P",{"data-svelte-h":!0}),p(at)!=="svelte-azbr52"&&(at.textContent=Ml),ye=a(t),it=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),p(it)!=="svelte-12w90z8"&&(it.innerHTML=rl),me=a(t),h(ot.$$.fragment,t),de=a(t),pt=o(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1wueeet"&&(pt.textContent=cl),je=a(t),h(ut.$$.fragment,t),Te=a(t),ht=o(t,"P",{"data-svelte-h":!0}),p(ht)!=="svelte-1ndvzyl"&&(ht.textContent=wl),Je=a(t),h(Mt.$$.fragment,t),be=a(t),rt=o(t,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-1wueeet"&&(rt.textContent=yl),fe=a(t),h(ct.$$.fragment,t),Ue=a(t),wt=o(t,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-18w5bdv"&&(wt.textContent=ml),Be=a(t),h(yt.$$.fragment,t),ge=a(t),mt=o(t,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-smcbfz"&&(mt.textContent=dl),Ie=a(t),h(dt.$$.fragment,t),Ge=a(t),jt=o(t,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-1wuxk0l"&&(jt.textContent=jl),Ce=a(t),h(Tt.$$.fragment,t),_e=a(t),$e=o(t,"HR",{}),ve=a(t),Jt=o(t,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-1qq5buo"&&(Jt.innerHTML=Tl),xe=a(t),bt=o(t,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-1ef9lfw"&&(bt.innerHTML=Jl),ke=a(t),h(ft.$$.fragment,t),Xe=a(t),Bt=o(t,"P",{}),bl(Bt).forEach(l),this.h()},h(){Ye(m,"name","hf:doc:metadata"),Ye(m,"content",xl),Ul(j.src,Ne="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-unit1sub3DONE.jpg")||Ye(j,"src",Ne),Ye(j,"alt","Unit 1 planning")},m(t,e){_l(document.head,m),s(t,gt,e),s(t,Ut,e),s(t,It,e),M(d,t,e),s(t,Gt,e),s(t,j,e),s(t,Ct,e),s(t,T,e),s(t,_t,e),s(t,J,e),s(t,$t,e),s(t,b,e),s(t,vt,e),s(t,f,e),s(t,xt,e),s(t,U,e),s(t,kt,e),s(t,B,e),s(t,Xt,e),s(t,g,e),s(t,qt,e),s(t,I,e),s(t,Yt,e),s(t,G,e),s(t,Zt,e),M(C,t,e),s(t,Wt,e),s(t,_,e),s(t,Nt,e),M($,t,e),s(t,Rt,e),M(v,t,e),s(t,Et,e),s(t,x,e),s(t,Qt,e),M(k,t,e),s(t,Vt,e),s(t,X,e),s(t,Ft,e),s(t,q,e),s(t,At,e),M(Y,t,e),s(t,zt,e),s(t,Z,e),s(t,Ht,e),M(W,t,e),s(t,St,e),s(t,N,e),s(t,Lt,e),M(R,t,e),s(t,Pt,e),s(t,E,e),s(t,Ot,e),M(Q,t,e),s(t,Dt,e),s(t,V,e),s(t,Kt,e),M(F,t,e),s(t,te,e),s(t,A,e),s(t,ee,e),s(t,z,e),s(t,le,e),s(t,H,e),s(t,se,e),M(S,t,e),s(t,ne,e),s(t,L,e),s(t,ae,e),M(P,t,e),s(t,ie,e),s(t,O,e),s(t,oe,e),M(D,t,e),s(t,pe,e),s(t,K,e),s(t,ue,e),M(tt,t,e),s(t,he,e),s(t,et,e),s(t,Me,e),M(lt,t,e),s(t,re,e),s(t,st,e),s(t,ce,e),M(nt,t,e),s(t,we,e),s(t,at,e),s(t,ye,e),s(t,it,e),s(t,me,e),M(ot,t,e),s(t,de,e),s(t,pt,e),s(t,je,e),M(ut,t,e),s(t,Te,e),s(t,ht,e),s(t,Je,e),M(Mt,t,e),s(t,be,e),s(t,rt,e),s(t,fe,e),M(ct,t,e),s(t,Ue,e),s(t,wt,e),s(t,Be,e),M(yt,t,e),s(t,ge,e),s(t,mt,e),s(t,Ie,e),M(dt,t,e),s(t,Ge,e),s(t,jt,e),s(t,Ce,e),M(Tt,t,e),s(t,_e,e),s(t,$e,e),s(t,ve,e),s(t,Jt,e),s(t,xe,e),s(t,bt,e),s(t,ke,e),M(ft,t,e),s(t,Xe,e),s(t,Bt,e),qe=!0},p:Bl,i(t){qe||(r(d.$$.fragment,t),r(C.$$.fragment,t),r($.$$.fragment,t),r(v.$$.fragment,t),r(k.$$.fragment,t),r(Y.$$.fragment,t),r(W.$$.fragment,t),r(R.$$.fragment,t),r(Q.$$.fragment,t),r(F.$$.fragment,t),r(S.$$.fragment,t),r(P.$$.fragment,t),r(D.$$.fragment,t),r(tt.$$.fragment,t),r(lt.$$.fragment,t),r(nt.$$.fragment,t),r(ot.$$.fragment,t),r(ut.$$.fragment,t),r(Mt.$$.fragment,t),r(ct.$$.fragment,t),r(yt.$$.fragment,t),r(dt.$$.fragment,t),r(Tt.$$.fragment,t),r(ft.$$.fragment,t),qe=!0)},o(t){c(d.$$.fragment,t),c(C.$$.fragment,t),c($.$$.fragment,t),c(v.$$.fragment,t),c(k.$$.fragment,t),c(Y.$$.fragment,t),c(W.$$.fragment,t),c(R.$$.fragment,t),c(Q.$$.fragment,t),c(F.$$.fragment,t),c(S.$$.fragment,t),c(P.$$.fragment,t),c(D.$$.fragment,t),c(tt.$$.fragment,t),c(lt.$$.fragment,t),c(nt.$$.fragment,t),c(ot.$$.fragment,t),c(ut.$$.fragment,t),c(Mt.$$.fragment,t),c(ct.$$.fragment,t),c(yt.$$.fragment,t),c(dt.$$.fragment,t),c(Tt.$$.fragment,t),c(ft.$$.fragment,t),qe=!1},d(t){t&&(l(gt),l(Ut),l(It),l(Gt),l(j),l(Ct),l(T),l(_t),l(J),l($t),l(b),l(vt),l(f),l(xt),l(U),l(kt),l(B),l(Xt),l(g),l(qt),l(I),l(Yt),l(G),l(Zt),l(Wt),l(_),l(Nt),l(Rt),l(Et),l(x),l(Qt),l(Vt),l(X),l(Ft),l(q),l(At),l(zt),l(Z),l(Ht),l(St),l(N),l(Lt),l(Pt),l(E),l(Ot),l(Dt),l(V),l(Kt),l(te),l(A),l(ee),l(z),l(le),l(H),l(se),l(ne),l(L),l(ae),l(ie),l(O),l(oe),l(pe),l(K),l(ue),l(he),l(et),l(Me),l(re),l(st),l(ce),l(we),l(at),l(ye),l(it),l(me),l(de),l(pt),l(je),l(Te),l(ht),l(Je),l(be),l(rt),l(fe),l(Ue),l(wt),l(Be),l(ge),l(mt),l(Ie),l(Ge),l(jt),l(Ce),l(_e),l($e),l(ve),l(Jt),l(xe),l(bt),l(ke),l(Xe),l(Bt)),l(m),w(d,t),w(C,t),w($,t),w(v,t),w(k,t),w(Y,t),w(W,t),w(R,t),w(Q,t),w(F,t),w(S,t),w(P,t),w(D,t),w(tt,t),w(lt,t),w(nt,t),w(ot,t),w(ut,t),w(Mt,t),w(ct,t),w(yt,t),w(dt,t),w(Tt,t),w(ft,t)}}}const xl='{"title":"Dummy Agent Library","local":"dummy-agent-library","sections":[{"title":"Serverless API","local":"serverless-api","sections":[],"depth":2},{"title":"Dummy Agent","local":"dummy-agent","sections":[],"depth":2}],"depth":1}';function kl(We){return gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nl extends Il{constructor(m){super(),Gl(this,m,kl,vl,fl,{})}}export{Nl as component};
