import{s as Xs,f as Bl,n as Vs,o as qs}from"../chunks/scheduler.37c15a92.js";import{S as Ns,i as Ps,g as a,s as n,r as p,A as Fs,h as o,f as l,c as i,j as _l,u as r,x as M,k as y,y as Hl,a as s,v as w,d as u,t as T,w as c}from"../chunks/index.2bf4358c.js";import{C as m}from"../chunks/CodeBlock.4e987730.js";import{H as Vt}from"../chunks/Heading.8ada512a.js";import{E as Ds}from"../chunks/index.2145fe70.js";function Ks(Gl){let J,Ft,Nt,Dt,h,Kt,d,Ll,Ot,I,Wl="One crucial aspect of AI Agents is their ability to take <strong>actions</strong>. As we saw, this happens through the use of <strong>Tools</strong>.",te,U,$l="In this section, we’ll learn what Tools are, how to design them effectively, and how to integrate them into your Agent via the System Message.",ee,f,kl="By giving your Agent the right Tools—and clearly describing how those Tools work—you can dramatically increase what your AI can accomplish. Let’s dive in!",le,C,se,b,El="A <strong>Tool is a function given to the LLM</strong>. This function should fulfill a <strong>clear objective</strong>.",ne,A,Zl="Here are some commonly used tools in AI agents:",ie,v,Rl="<thead><tr><th>Tool</th> <th>Description</th></tr></thead> <tbody><tr><td>Web Search</td> <td>Allows the agent to fetch up-to-date information from the internet.</td></tr> <tr><td>Image Generation</td> <td>Creates images based on text descriptions.</td></tr> <tr><td>Retrieval</td> <td>Retrieves information from an external source.</td></tr> <tr><td>API Interface</td> <td>Interacts with an external API (GitHub, YouTube, Spotify, etc.).</td></tr></tbody>",ae,g,Sl="Those are only examples, as you can in fact create a tool for any use case!",oe,B,Yl="A good tool should be something that <strong>complements the power of an LLM</strong>.",Me,x,zl="For instance, if you need to perform arithmetic, giving a <strong>calculator tool</strong> to your LLM will provide better results than relying on the native capabilities of the model.",pe,_,Ql="Furthermore, <strong>LLMs predict the completion of a prompt based on their training data</strong>, which means that their internal knowledge only includes events prior to their training. Therefore, if your agent needs up-to-date data you must provide it through some tool.",re,H,Xl="For instance, if you ask an LLM directly (without a search tool) for today’s weather, the LLM will potentially hallucinate random weather.",we,G,Vl,ue,L,ql="<li><p>A Tool should contain:</p> <ul><li>A <strong>textual description of what the function does</strong>.</li> <li>A <em>Callable</em> (something to perform an action).</li> <li><em>Arguments</em> with typings.</li> <li>(Optional) Outputs with typings.</li></ul></li>",Te,W,ce,$,Nl="LLMs, as we saw, can only receive text inputs and generate text outputs. They have no way to call tools on their own. When we talk about providing tools to an Agent, we mean teaching the LLM about the existence of these tools and instructing it to generate text-based invocations when needed.",ye,k,Pl="For example, if we provide a tool to check the weather at a location from the internet and then ask the LLM about the weather in Paris, the LLM will recognize that this is an opportunity to use the “weather” tool. Instead of retrieving the weather data itself, the LLM will generate text that represents a tool call, such as call weather_tool(‘Paris’).",Je,E,Fl="The <strong>Agent</strong> then reads this response, identifies that a tool call is required, executes the tool on the LLM’s behalf, and retrieves the actual weather data.",me,Z,Dl="The Tool-calling steps are typically not shown to the user: the Agent appends them as a new message before passing the updated conversation to the LLM again. The LLM then processes this additional context and generates a natural-sounding response for the user. From the user’s perspective, it appears as if the LLM directly interacted with the tool, but in reality, it was the Agent that handled the entire execution process in the background.",je,R,Kl="We’ll talk a lot more about this process in future sessions.",he,S,de,Y,Ol="The complete answer may seem overwhelming, but we essentially use the system prompt to provide textual descriptions of available tools to the model:",Ie,z,ts,Ue,Q,es="For this to work, we have to be very precise and accurate about:",fe,X,ls="<li><strong>What the tool does</strong></li> <li><strong>What exact inputs it expects</strong></li>",Ce,V,ss="This is the reason why tool descriptions are usually provided using expressive but precise structures, such as computer languages or JSON. It’s not <em>necessary</em> to do it like that, any precise and coherent format would work.",be,q,ns="If this seems too theoretical, let’s understand it through a concrete example.",Ae,N,is="We will implement a simplified <strong>calculator</strong> tool that will just multiply two integers. This could be our Python implementation:",ve,P,ge,F,as="So our tool is called <code>calculator</code>, it <strong>multiplies two integers</strong>, and it requires the following inputs:",Be,D,os="<li><strong><code>a</code></strong> (<em>int</em>): An integer.</li> <li><strong><code>b</code></strong> (<em>int</em>): An integer.</li>",xe,K,Ms="The output of the tool is another integer number that we can describe like this:",_e,O,ps="<li>(<em>int</em>): The product of <code>a</code> and <code>b</code>.</li>",He,tt,rs="All of these details are important. Let’s put them together in a text string that describes our tool for the LLM to understand.",Ge,et,Le,lt,ws="<p><strong>Reminder:</strong> This textual description is <em>what we want the LLM to know about the tool</em>.</p>",We,st,us="When we pass the previous string as part of the input to the LLM, the model will recognize it as a tool, and will know what it needs to pass as inputs and what to expect from the output.",$e,nt,Ts="If we want to provide additional tools, we must be consistent and always use the same format. This process can be fragile, and we might accidentally overlook some details.",ke,it,cs="Is there a better way?",Ee,at,Ze,ot,ys="Our tool was written in Python, and the implementation already provides everything we need:",Re,Mt,Js="<li>A descriptive name of what it does: <code>calculator</code></li> <li>A longer description, provided by the function’s docstring comment: <code>Multiply two integers.</code></li> <li>The inputs and their type: the function clearly expects two <code>int</code>s.</li> <li>The type of the output.</li>",Se,pt,ms="There’s a reason people use programming languages: they are expressive, concise, and precise.",Ye,rt,js="We could provide the Python source code as the <em>specification</em> of the tool for the LLM, but the way the tool is implemented does not matter. All that matters is its name, what it does, the inputs it expects and the output it provides.",ze,wt,hs="We will leverage Python’s introspection features to leverage the source code and build a tool description automatically for us. All we need is that the tool implementation uses type hints, docstrings, and sensible function names. We will write some code to extract the relevant portions from the source code.",Qe,ut,ds="After we are done, we’ll only need to use a Python decorator to indicate that the <code>calculator</code> function is a tool:",Xe,Tt,Ve,ct,Is="Note the <code>@tool</code> decorator before the function definition.",qe,yt,Us="With the implementation we’ll see next, we will be able to retrieve the following text automatically from the source code via the <code>to_string()</code> function provided by the decorator:",Ne,Jt,Pe,mt,fs="As you can see, it’s the same thing we wrote manually before!",Fe,jt,De,ht,Cs="We create a generic <code>Tool</code> class that we can reuse whenever we need to use a tool.",Ke,dt,bs="<p><strong>Disclaimer:</strong> This example implementation is fictional but closely resembles real implementations in most libraries.</p>",Oe,It,tl,Ut,As="It may seem complicated, but if we go slowly through it we can see what it does. We define a <strong><code>Tool</code></strong> class that includes:",el,ft,vs="<li><strong><code>name</code></strong> (<em>str</em>): The name of the tool.</li> <li><strong><code>description</code></strong> (<em>str</em>): A brief description of what the tool does.</li> <li><strong><code>function</code></strong> (<em>callable</em>): The function the tool executes.</li> <li><strong><code>arguments</code></strong> (<em>list</em>): The expected input parameters.</li> <li><strong><code>outputs</code></strong> (<em>str</em> or <em>list</em>): The expected outputs of the tool.</li> <li><strong><code>__call__()</code></strong>: Calls the function when the tool instance is invoked.</li> <li><strong><code>to_string()</code></strong>: Converts the tool’s attributes into a textual representation.</li>",ll,Ct,gs="We could create a Tool with this class using code like the following:",sl,bt,nl,At,Bs="But we can also use Python’s <code>inspect</code> module to retrieve all the information for us! This is what the <code>@tool</code> decorator does.",il,vt,xs="<p>If you are interested, you can disclose the following section to look at the decorator implementation.</p>",al,j,qt,_s="decorator code",xl,gt,ol,Bt,Hs="Just to reiterate, with this decorator in place we can implement our tool like this:",Ml,xt,pl,_t,Gs="And we can use the <code>Tool</code>’s <code>to_string</code> method to automatically retrieve a text suitable to be used as a tool description for an LLM:",rl,Ht,wl,Gt,Ls="The description is <strong>injected</strong> in the system prompt. Taking the example with which we started this section, here is how it would look like after replacing the <code>tools_description</code>:",ul,Lt,Ws,Tl,Wt,$s='In the <a href="actions">Actions</a> section, we will learn more about how an Agent can <strong>Call</strong> this tool we just created.',cl,$t,yl,kt,ks=`Model Context Protocol (MCP) is an <strong>open protocol</strong> that standardizes how applications <strong>provide tools to LLMs</strong>.
MCP provides:`,Jl,Et,Es="<li>A growing list of pre-built integrations that your LLM can directly plug into</li> <li>The flexibility to switch between LLM providers and vendors</li> <li>Best practices for securing your data within your infrastructure</li>",ml,Zt,Zs="This means that <strong>any framework implementing MCP can leverage tools defined within the protocol</strong>, eliminating the need to reimplement the same tool interface for each framework.",jl,hl,dl,Rt,Rs="Tools play a crucial role in enhancing the capabilities of AI agents.",Il,St,Ss="To summarize, we learned:",Ul,Yt,Ys="<li><p><em>What Tools Are</em>: Functions that give LLMs extra capabilities, such as performing calculations or accessing external data.</p></li> <li><p><em>How to Define a Tool</em>: By providing a clear textual description, inputs, outputs, and a callable function.</p></li> <li><p><em>Why Tools Are Essential</em>: They enable Agents to overcome the limitations of static model training, handle real-time tasks, and perform specialized actions.</p></li>",fl,zt,zs='Now, we can move on to the <a href="agent-steps-and-structure">Agent Workflow</a> where you’ll see how an Agent observes, thinks, and acts. This <strong>brings together everything we’ve covered so far</strong> and sets the stage for creating your own fully functional AI Agent.',Cl,Qt,Qs="But first, it’s time for another short quiz!",bl,Xt,Al,Pt,vl;return h=new Vt({props:{title:"What are Tools?",local:"what-are-tools",headingTag:"h1"}}),C=new Vt({props:{title:"What are AI Tools?",local:"what-are-ai-tools",headingTag:"h2"}}),W=new Vt({props:{title:"How do tools work?",local:"how-do-tools-work",headingTag:"h2"}}),S=new Vt({props:{title:"How do we give tools to an LLM?",local:"how-do-we-give-tools-to-an-llm",headingTag:"h2"}}),P=new m({props:{code:"ZGVmJTIwY2FsY3VsYXRvcihhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyTXVsdGlwbHklMjB0d28lMjBpbnRlZ2Vycy4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBhJTIwKiUyMGI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b`,wrap:!1}}),et=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),at=new Vt({props:{title:"Auto-formatting Tool sections",local:"auto-formatting-tool-sections",headingTag:"h3"}}),Tt=new m({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Jt=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),jt=new Vt({props:{title:"Generic Tool implementation",local:"generic-tool-implementation",headingTag:"h3"}}),It=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">Tool</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    A class representing a reusable piece of code (Tool).

    Attributes:
        name (str): Name of the tool.
        description (str): A textual description of what the tool does.
        func (callable): The function this tool wraps.
        arguments (list): A list of argument.
        outputs (str or list): The return type(s) of the wrapped function.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self,
                 name: <span class="hljs-built_in">str</span>,
                 description: <span class="hljs-built_in">str</span>,
                 func: <span class="hljs-built_in">callable</span>,
                 arguments: <span class="hljs-built_in">list</span>,
                 outputs: <span class="hljs-built_in">str</span></span>):
        self.name = name
        self.description = description
        self.func = func
        self.arguments = arguments
        self.outputs = outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">to_string</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return a string representation of the tool,
        including its name, description, arguments, and outputs.
        &quot;&quot;&quot;</span>
        args_str = <span class="hljs-string">&quot;, &quot;</span>.join([
            <span class="hljs-string">f&quot;<span class="hljs-subst">{arg_name}</span>: <span class="hljs-subst">{arg_type}</span>&quot;</span> <span class="hljs-keyword">for</span> arg_name, arg_type <span class="hljs-keyword">in</span> self.arguments
        ])

        <span class="hljs-keyword">return</span> (
            <span class="hljs-string">f&quot;Tool Name: <span class="hljs-subst">{self.name}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Description: <span class="hljs-subst">{self.description}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Arguments: <span class="hljs-subst">{args_str}</span>,&quot;</span>
            <span class="hljs-string">f&quot; Outputs: <span class="hljs-subst">{self.outputs}</span>&quot;</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, *args, **kwargs</span>):
        <span class="hljs-string">&quot;&quot;&quot;
        Invoke the underlying function (callable) with provided arguments.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> self.func(*args, **kwargs)`,wrap:!1}}),bt=new m({props:{code:"Y2FsY3VsYXRvcl90b29sJTIwJTNEJTIwVG9vbCglMEElMjAlMjAlMjAlMjAlMjJjYWxjdWxhdG9yJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbmFtZSUwQSUyMCUyMCUyMCUyMCUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZGVzY3JpcHRpb24lMEElMjAlMjAlMjAlMjBjYWxjdWxhdG9yJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZnVuY3Rpb24lMjB0byUyMGNhbGwlMEElMjAlMjAlMjAlMjAlNUIoJTIyYSUyMiUyQyUyMCUyMmludCUyMiklMkMlMjAoJTIyYiUyMiUyQyUyMCUyMmludCUyMiklNUQlMkMlMjAlMjAlMjAlMjMlMjBpbnB1dHMlMjAobmFtZXMlMjBhbmQlMjB0eXBlcyklMEElMjAlMjAlMjAlMjAlMjJpbnQlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBvdXRwdXQlMEEp",highlighted:`calculator_tool = Tool(
    <span class="hljs-string">&quot;calculator&quot;</span>,                   <span class="hljs-comment"># name</span>
    <span class="hljs-string">&quot;Multiply two integers.&quot;</span>,       <span class="hljs-comment"># description</span>
    calculator,                     <span class="hljs-comment"># function to call</span>
    [(<span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>), (<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;int&quot;</span>)],   <span class="hljs-comment"># inputs (names and types)</span>
    <span class="hljs-string">&quot;int&quot;</span>,                          <span class="hljs-comment"># output</span>
)`,wrap:!1}}),gt=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tool</span>(<span class="hljs-params">func</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A decorator that creates a Tool instance from the given function.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Get the function signature</span>
    signature = inspect.signature(func)

    <span class="hljs-comment"># Extract (param_name, param_annotation) pairs for inputs</span>
    arguments = []
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> signature.parameters.values():
        annotation_name = (
            param.annotation.__name__
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(param.annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>)
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(param.annotation)
        )
        arguments.append((param.name, annotation_name))

    <span class="hljs-comment"># Determine the return annotation</span>
    return_annotation = signature.return_annotation
    <span class="hljs-keyword">if</span> return_annotation <span class="hljs-keyword">is</span> inspect._empty:
        outputs = <span class="hljs-string">&quot;No return annotation&quot;</span>
    <span class="hljs-keyword">else</span>:
        outputs = (
            return_annotation.__name__
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(return_annotation, <span class="hljs-string">&#x27;__name__&#x27;</span>)
            <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(return_annotation)
        )

    <span class="hljs-comment"># Use the function&#x27;s docstring as the description (default if None)</span>
    description = func.__doc__ <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;No description provided.&quot;</span>

    <span class="hljs-comment"># The function name becomes the Tool name</span>
    name = func.__name__

    <span class="hljs-comment"># Return a new Tool instance</span>
    <span class="hljs-keyword">return</span> Tool(
        name=name,
        description=description,
        func=func,
        arguments=arguments,
        outputs=outputs
    )`,wrap:!1}}),xt=new m({props:{code:"JTQwdG9vbCUwQWRlZiUyMGNhbGN1bGF0b3IoYSUzQSUyMGludCUyQyUyMGIlM0ElMjBpbnQpJTIwLSUzRSUyMGludCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMk11bHRpcGx5JTIwdHdvJTIwaW50ZWdlcnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBcHJpbnQoY2FsY3VsYXRvci50b19zdHJpbmcoKSk=",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">calculator</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-string">&quot;&quot;&quot;Multiply two integers.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

<span class="hljs-built_in">print</span>(calculator.to_string())`,wrap:!1}}),Ht=new m({props:{code:"VG9vbCUyME5hbWUlM0ElMjBjYWxjdWxhdG9yJTJDJTIwRGVzY3JpcHRpb24lM0ElMjBNdWx0aXBseSUyMHR3byUyMGludGVnZXJzLiUyQyUyMEFyZ3VtZW50cyUzQSUyMGElM0ElMjBpbnQlMkMlMjBiJTNBJTIwaW50JTJDJTIwT3V0cHV0cyUzQSUyMGludA==",highlighted:"Tool Name: calculator, Description: Multiply two integers., Arguments: a: int, b: int, Outputs: int",wrap:!1}}),$t=new Vt({props:{title:"Model Context Protocol (MCP): a unified tool interface",local:"model-context-protocol-mcp-a-unified-tool-interface",headingTag:"h3"}}),Xt=new Ds({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/tools.mdx"}}),{c(){J=a("meta"),Ft=n(),Nt=a("p"),Dt=n(),p(h.$$.fragment),Kt=n(),d=a("img"),Ot=n(),I=a("p"),I.innerHTML=Wl,te=n(),U=a("p"),U.textContent=$l,ee=n(),f=a("p"),f.textContent=kl,le=n(),p(C.$$.fragment),se=n(),b=a("p"),b.innerHTML=El,ne=n(),A=a("p"),A.textContent=Zl,ie=n(),v=a("table"),v.innerHTML=Rl,ae=n(),g=a("p"),g.textContent=Sl,oe=n(),B=a("p"),B.innerHTML=Yl,Me=n(),x=a("p"),x.innerHTML=zl,pe=n(),_=a("p"),_.innerHTML=Ql,re=n(),H=a("p"),H.textContent=Xl,we=n(),G=a("img"),ue=n(),L=a("ul"),L.innerHTML=ql,Te=n(),p(W.$$.fragment),ce=n(),$=a("p"),$.textContent=Nl,ye=n(),k=a("p"),k.textContent=Pl,Je=n(),E=a("p"),E.innerHTML=Fl,me=n(),Z=a("p"),Z.textContent=Dl,je=n(),R=a("p"),R.textContent=Kl,he=n(),p(S.$$.fragment),de=n(),Y=a("p"),Y.textContent=Ol,Ie=n(),z=a("img"),Ue=n(),Q=a("p"),Q.textContent=es,fe=n(),X=a("ol"),X.innerHTML=ls,Ce=n(),V=a("p"),V.innerHTML=ss,be=n(),q=a("p"),q.textContent=ns,Ae=n(),N=a("p"),N.innerHTML=is,ve=n(),p(P.$$.fragment),ge=n(),F=a("p"),F.innerHTML=as,Be=n(),D=a("ul"),D.innerHTML=os,xe=n(),K=a("p"),K.textContent=Ms,_e=n(),O=a("ul"),O.innerHTML=ps,He=n(),tt=a("p"),tt.textContent=rs,Ge=n(),p(et.$$.fragment),Le=n(),lt=a("blockquote"),lt.innerHTML=ws,We=n(),st=a("p"),st.textContent=us,$e=n(),nt=a("p"),nt.textContent=Ts,ke=n(),it=a("p"),it.textContent=cs,Ee=n(),p(at.$$.fragment),Ze=n(),ot=a("p"),ot.textContent=ys,Re=n(),Mt=a("ul"),Mt.innerHTML=Js,Se=n(),pt=a("p"),pt.textContent=ms,Ye=n(),rt=a("p"),rt.innerHTML=js,ze=n(),wt=a("p"),wt.textContent=hs,Qe=n(),ut=a("p"),ut.innerHTML=ds,Xe=n(),p(Tt.$$.fragment),Ve=n(),ct=a("p"),ct.innerHTML=Is,qe=n(),yt=a("p"),yt.innerHTML=Us,Ne=n(),p(Jt.$$.fragment),Pe=n(),mt=a("p"),mt.textContent=fs,Fe=n(),p(jt.$$.fragment),De=n(),ht=a("p"),ht.innerHTML=Cs,Ke=n(),dt=a("blockquote"),dt.innerHTML=bs,Oe=n(),p(It.$$.fragment),tl=n(),Ut=a("p"),Ut.innerHTML=As,el=n(),ft=a("ul"),ft.innerHTML=vs,ll=n(),Ct=a("p"),Ct.textContent=gs,sl=n(),p(bt.$$.fragment),nl=n(),At=a("p"),At.innerHTML=Bs,il=n(),vt=a("blockquote"),vt.innerHTML=xs,al=n(),j=a("details"),qt=a("summary"),qt.textContent=_s,xl=n(),p(gt.$$.fragment),ol=n(),Bt=a("p"),Bt.textContent=Hs,Ml=n(),p(xt.$$.fragment),pl=n(),_t=a("p"),_t.innerHTML=Gs,rl=n(),p(Ht.$$.fragment),wl=n(),Gt=a("p"),Gt.innerHTML=Ls,ul=n(),Lt=a("img"),Tl=n(),Wt=a("p"),Wt.innerHTML=$s,cl=n(),p($t.$$.fragment),yl=n(),kt=a("p"),kt.innerHTML=ks,Jl=n(),Et=a("ul"),Et.innerHTML=Es,ml=n(),Zt=a("p"),Zt.innerHTML=Zs,jl=n(),hl=a("hr"),dl=n(),Rt=a("p"),Rt.textContent=Rs,Il=n(),St=a("p"),St.textContent=Ss,Ul=n(),Yt=a("ul"),Yt.innerHTML=Ys,fl=n(),zt=a("p"),zt.innerHTML=zs,Cl=n(),Qt=a("p"),Qt.textContent=Qs,bl=n(),p(Xt.$$.fragment),Al=n(),Pt=a("p"),this.h()},l(t){const e=Fs("svelte-u9bgzb",document.head);J=o(e,"META",{name:!0,content:!0}),e.forEach(l),Ft=i(t),Nt=o(t,"P",{}),_l(Nt).forEach(l),Dt=i(t),r(h.$$.fragment,t),Kt=i(t),d=o(t,"IMG",{src:!0,alt:!0}),Ot=i(t),I=o(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-12q0l6c"&&(I.innerHTML=Wl),te=i(t),U=o(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-vccz0n"&&(U.textContent=$l),ee=i(t),f=o(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-g748wk"&&(f.textContent=kl),le=i(t),r(C.$$.fragment,t),se=i(t),b=o(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-d0memu"&&(b.innerHTML=El),ne=i(t),A=o(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-1bnicmb"&&(A.textContent=Zl),ie=i(t),v=o(t,"TABLE",{"data-svelte-h":!0}),M(v)!=="svelte-1r7ovsn"&&(v.innerHTML=Rl),ae=i(t),g=o(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1fuccdy"&&(g.textContent=Sl),oe=i(t),B=o(t,"P",{"data-svelte-h":!0}),M(B)!=="svelte-178hc7g"&&(B.innerHTML=Yl),Me=i(t),x=o(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1redoxr"&&(x.innerHTML=zl),pe=i(t),_=o(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1v1ck09"&&(_.innerHTML=Ql),re=i(t),H=o(t,"P",{"data-svelte-h":!0}),M(H)!=="svelte-mz2far"&&(H.textContent=Xl),we=i(t),G=o(t,"IMG",{src:!0,alt:!0}),ue=i(t),L=o(t,"UL",{"data-svelte-h":!0}),M(L)!=="svelte-gj3em1"&&(L.innerHTML=ql),Te=i(t),r(W.$$.fragment,t),ce=i(t),$=o(t,"P",{"data-svelte-h":!0}),M($)!=="svelte-12sfw6d"&&($.textContent=Nl),ye=i(t),k=o(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-17ojdf7"&&(k.textContent=Pl),Je=i(t),E=o(t,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1ym7xfc"&&(E.innerHTML=Fl),me=i(t),Z=o(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-16cdakx"&&(Z.textContent=Dl),je=i(t),R=o(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1gym7on"&&(R.textContent=Kl),he=i(t),r(S.$$.fragment,t),de=i(t),Y=o(t,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1m76tol"&&(Y.textContent=Ol),Ie=i(t),z=o(t,"IMG",{src:!0,alt:!0}),Ue=i(t),Q=o(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-e466s4"&&(Q.textContent=es),fe=i(t),X=o(t,"OL",{"data-svelte-h":!0}),M(X)!=="svelte-12vrnnv"&&(X.innerHTML=ls),Ce=i(t),V=o(t,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1lxlzbg"&&(V.innerHTML=ss),be=i(t),q=o(t,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1p033lp"&&(q.textContent=ns),Ae=i(t),N=o(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1if40sb"&&(N.innerHTML=is),ve=i(t),r(P.$$.fragment,t),ge=i(t),F=o(t,"P",{"data-svelte-h":!0}),M(F)!=="svelte-somofk"&&(F.innerHTML=as),Be=i(t),D=o(t,"UL",{"data-svelte-h":!0}),M(D)!=="svelte-1qi2vj"&&(D.innerHTML=os),xe=i(t),K=o(t,"P",{"data-svelte-h":!0}),M(K)!=="svelte-z90coj"&&(K.textContent=Ms),_e=i(t),O=o(t,"UL",{"data-svelte-h":!0}),M(O)!=="svelte-1rd1o27"&&(O.innerHTML=ps),He=i(t),tt=o(t,"P",{"data-svelte-h":!0}),M(tt)!=="svelte-1gl47rm"&&(tt.textContent=rs),Ge=i(t),r(et.$$.fragment,t),Le=i(t),lt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(lt)!=="svelte-jn5onw"&&(lt.innerHTML=ws),We=i(t),st=o(t,"P",{"data-svelte-h":!0}),M(st)!=="svelte-dd2uu2"&&(st.textContent=us),$e=i(t),nt=o(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-1ec16zo"&&(nt.textContent=Ts),ke=i(t),it=o(t,"P",{"data-svelte-h":!0}),M(it)!=="svelte-xhigt1"&&(it.textContent=cs),Ee=i(t),r(at.$$.fragment,t),Ze=i(t),ot=o(t,"P",{"data-svelte-h":!0}),M(ot)!=="svelte-xwh6nk"&&(ot.textContent=ys),Re=i(t),Mt=o(t,"UL",{"data-svelte-h":!0}),M(Mt)!=="svelte-1mufwba"&&(Mt.innerHTML=Js),Se=i(t),pt=o(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-6ogn9l"&&(pt.textContent=ms),Ye=i(t),rt=o(t,"P",{"data-svelte-h":!0}),M(rt)!=="svelte-2908e6"&&(rt.innerHTML=js),ze=i(t),wt=o(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-1nshzlk"&&(wt.textContent=hs),Qe=i(t),ut=o(t,"P",{"data-svelte-h":!0}),M(ut)!=="svelte-1iag2er"&&(ut.innerHTML=ds),Xe=i(t),r(Tt.$$.fragment,t),Ve=i(t),ct=o(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-1xfdhk0"&&(ct.innerHTML=Is),qe=i(t),yt=o(t,"P",{"data-svelte-h":!0}),M(yt)!=="svelte-hj3bkt"&&(yt.innerHTML=Us),Ne=i(t),r(Jt.$$.fragment,t),Pe=i(t),mt=o(t,"P",{"data-svelte-h":!0}),M(mt)!=="svelte-ah55dy"&&(mt.textContent=fs),Fe=i(t),r(jt.$$.fragment,t),De=i(t),ht=o(t,"P",{"data-svelte-h":!0}),M(ht)!=="svelte-1g4lbet"&&(ht.innerHTML=Cs),Ke=i(t),dt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(dt)!=="svelte-17jlnyo"&&(dt.innerHTML=bs),Oe=i(t),r(It.$$.fragment,t),tl=i(t),Ut=o(t,"P",{"data-svelte-h":!0}),M(Ut)!=="svelte-1m24zfs"&&(Ut.innerHTML=As),el=i(t),ft=o(t,"UL",{"data-svelte-h":!0}),M(ft)!=="svelte-1aoag7f"&&(ft.innerHTML=vs),ll=i(t),Ct=o(t,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-9jg0w0"&&(Ct.textContent=gs),sl=i(t),r(bt.$$.fragment,t),nl=i(t),At=o(t,"P",{"data-svelte-h":!0}),M(At)!=="svelte-imjo5d"&&(At.innerHTML=Bs),il=i(t),vt=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),M(vt)!=="svelte-5gslq7"&&(vt.innerHTML=xs),al=i(t),j=o(t,"DETAILS",{});var gl=_l(j);qt=o(gl,"SUMMARY",{"data-svelte-h":!0}),M(qt)!=="svelte-14wmf42"&&(qt.textContent=_s),xl=i(gl),r(gt.$$.fragment,gl),gl.forEach(l),ol=i(t),Bt=o(t,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-1pxgdsn"&&(Bt.textContent=Hs),Ml=i(t),r(xt.$$.fragment,t),pl=i(t),_t=o(t,"P",{"data-svelte-h":!0}),M(_t)!=="svelte-oh725x"&&(_t.innerHTML=Gs),rl=i(t),r(Ht.$$.fragment,t),wl=i(t),Gt=o(t,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-1gsasw4"&&(Gt.innerHTML=Ls),ul=i(t),Lt=o(t,"IMG",{src:!0,alt:!0}),Tl=i(t),Wt=o(t,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-14h2jbz"&&(Wt.innerHTML=$s),cl=i(t),r($t.$$.fragment,t),yl=i(t),kt=o(t,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-123mz07"&&(kt.innerHTML=ks),Jl=i(t),Et=o(t,"UL",{"data-svelte-h":!0}),M(Et)!=="svelte-jdb0o1"&&(Et.innerHTML=Es),ml=i(t),Zt=o(t,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-v0j64b"&&(Zt.innerHTML=Zs),jl=i(t),hl=o(t,"HR",{}),dl=i(t),Rt=o(t,"P",{"data-svelte-h":!0}),M(Rt)!=="svelte-yaz9vn"&&(Rt.textContent=Rs),Il=i(t),St=o(t,"P",{"data-svelte-h":!0}),M(St)!=="svelte-1mncb1b"&&(St.textContent=Ss),Ul=i(t),Yt=o(t,"UL",{"data-svelte-h":!0}),M(Yt)!=="svelte-1lbaznq"&&(Yt.innerHTML=Ys),fl=i(t),zt=o(t,"P",{"data-svelte-h":!0}),M(zt)!=="svelte-16mxhlc"&&(zt.innerHTML=zs),Cl=i(t),Qt=o(t,"P",{"data-svelte-h":!0}),M(Qt)!=="svelte-1w2njod"&&(Qt.textContent=Qs),bl=i(t),r(Xt.$$.fragment,t),Al=i(t),Pt=o(t,"P",{}),_l(Pt).forEach(l),this.h()},h(){y(J,"name","hf:doc:metadata"),y(J,"content",Os),Bl(d.src,Ll="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/whiteboard-check-2.jpg")||y(d,"src",Ll),y(d,"alt","Unit 1 planning"),Bl(G.src,Vl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/weather.jpg")||y(G,"src",Vl),y(G,"alt","Weather"),Bl(z.src,ts="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt.png")||y(z,"src",ts),y(z,"alt","System prompt for tools"),Bl(Lt.src,Ws="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/Agent_system_prompt_tools.png")||y(Lt,"src",Ws),y(Lt,"alt","System prompt for tools")},m(t,e){Hl(document.head,J),s(t,Ft,e),s(t,Nt,e),s(t,Dt,e),w(h,t,e),s(t,Kt,e),s(t,d,e),s(t,Ot,e),s(t,I,e),s(t,te,e),s(t,U,e),s(t,ee,e),s(t,f,e),s(t,le,e),w(C,t,e),s(t,se,e),s(t,b,e),s(t,ne,e),s(t,A,e),s(t,ie,e),s(t,v,e),s(t,ae,e),s(t,g,e),s(t,oe,e),s(t,B,e),s(t,Me,e),s(t,x,e),s(t,pe,e),s(t,_,e),s(t,re,e),s(t,H,e),s(t,we,e),s(t,G,e),s(t,ue,e),s(t,L,e),s(t,Te,e),w(W,t,e),s(t,ce,e),s(t,$,e),s(t,ye,e),s(t,k,e),s(t,Je,e),s(t,E,e),s(t,me,e),s(t,Z,e),s(t,je,e),s(t,R,e),s(t,he,e),w(S,t,e),s(t,de,e),s(t,Y,e),s(t,Ie,e),s(t,z,e),s(t,Ue,e),s(t,Q,e),s(t,fe,e),s(t,X,e),s(t,Ce,e),s(t,V,e),s(t,be,e),s(t,q,e),s(t,Ae,e),s(t,N,e),s(t,ve,e),w(P,t,e),s(t,ge,e),s(t,F,e),s(t,Be,e),s(t,D,e),s(t,xe,e),s(t,K,e),s(t,_e,e),s(t,O,e),s(t,He,e),s(t,tt,e),s(t,Ge,e),w(et,t,e),s(t,Le,e),s(t,lt,e),s(t,We,e),s(t,st,e),s(t,$e,e),s(t,nt,e),s(t,ke,e),s(t,it,e),s(t,Ee,e),w(at,t,e),s(t,Ze,e),s(t,ot,e),s(t,Re,e),s(t,Mt,e),s(t,Se,e),s(t,pt,e),s(t,Ye,e),s(t,rt,e),s(t,ze,e),s(t,wt,e),s(t,Qe,e),s(t,ut,e),s(t,Xe,e),w(Tt,t,e),s(t,Ve,e),s(t,ct,e),s(t,qe,e),s(t,yt,e),s(t,Ne,e),w(Jt,t,e),s(t,Pe,e),s(t,mt,e),s(t,Fe,e),w(jt,t,e),s(t,De,e),s(t,ht,e),s(t,Ke,e),s(t,dt,e),s(t,Oe,e),w(It,t,e),s(t,tl,e),s(t,Ut,e),s(t,el,e),s(t,ft,e),s(t,ll,e),s(t,Ct,e),s(t,sl,e),w(bt,t,e),s(t,nl,e),s(t,At,e),s(t,il,e),s(t,vt,e),s(t,al,e),s(t,j,e),Hl(j,qt),Hl(j,xl),w(gt,j,null),s(t,ol,e),s(t,Bt,e),s(t,Ml,e),w(xt,t,e),s(t,pl,e),s(t,_t,e),s(t,rl,e),w(Ht,t,e),s(t,wl,e),s(t,Gt,e),s(t,ul,e),s(t,Lt,e),s(t,Tl,e),s(t,Wt,e),s(t,cl,e),w($t,t,e),s(t,yl,e),s(t,kt,e),s(t,Jl,e),s(t,Et,e),s(t,ml,e),s(t,Zt,e),s(t,jl,e),s(t,hl,e),s(t,dl,e),s(t,Rt,e),s(t,Il,e),s(t,St,e),s(t,Ul,e),s(t,Yt,e),s(t,fl,e),s(t,zt,e),s(t,Cl,e),s(t,Qt,e),s(t,bl,e),w(Xt,t,e),s(t,Al,e),s(t,Pt,e),vl=!0},p:Vs,i(t){vl||(u(h.$$.fragment,t),u(C.$$.fragment,t),u(W.$$.fragment,t),u(S.$$.fragment,t),u(P.$$.fragment,t),u(et.$$.fragment,t),u(at.$$.fragment,t),u(Tt.$$.fragment,t),u(Jt.$$.fragment,t),u(jt.$$.fragment,t),u(It.$$.fragment,t),u(bt.$$.fragment,t),u(gt.$$.fragment,t),u(xt.$$.fragment,t),u(Ht.$$.fragment,t),u($t.$$.fragment,t),u(Xt.$$.fragment,t),vl=!0)},o(t){T(h.$$.fragment,t),T(C.$$.fragment,t),T(W.$$.fragment,t),T(S.$$.fragment,t),T(P.$$.fragment,t),T(et.$$.fragment,t),T(at.$$.fragment,t),T(Tt.$$.fragment,t),T(Jt.$$.fragment,t),T(jt.$$.fragment,t),T(It.$$.fragment,t),T(bt.$$.fragment,t),T(gt.$$.fragment,t),T(xt.$$.fragment,t),T(Ht.$$.fragment,t),T($t.$$.fragment,t),T(Xt.$$.fragment,t),vl=!1},d(t){t&&(l(Ft),l(Nt),l(Dt),l(Kt),l(d),l(Ot),l(I),l(te),l(U),l(ee),l(f),l(le),l(se),l(b),l(ne),l(A),l(ie),l(v),l(ae),l(g),l(oe),l(B),l(Me),l(x),l(pe),l(_),l(re),l(H),l(we),l(G),l(ue),l(L),l(Te),l(ce),l($),l(ye),l(k),l(Je),l(E),l(me),l(Z),l(je),l(R),l(he),l(de),l(Y),l(Ie),l(z),l(Ue),l(Q),l(fe),l(X),l(Ce),l(V),l(be),l(q),l(Ae),l(N),l(ve),l(ge),l(F),l(Be),l(D),l(xe),l(K),l(_e),l(O),l(He),l(tt),l(Ge),l(Le),l(lt),l(We),l(st),l($e),l(nt),l(ke),l(it),l(Ee),l(Ze),l(ot),l(Re),l(Mt),l(Se),l(pt),l(Ye),l(rt),l(ze),l(wt),l(Qe),l(ut),l(Xe),l(Ve),l(ct),l(qe),l(yt),l(Ne),l(Pe),l(mt),l(Fe),l(De),l(ht),l(Ke),l(dt),l(Oe),l(tl),l(Ut),l(el),l(ft),l(ll),l(Ct),l(sl),l(nl),l(At),l(il),l(vt),l(al),l(j),l(ol),l(Bt),l(Ml),l(pl),l(_t),l(rl),l(wl),l(Gt),l(ul),l(Lt),l(Tl),l(Wt),l(cl),l(yl),l(kt),l(Jl),l(Et),l(ml),l(Zt),l(jl),l(hl),l(dl),l(Rt),l(Il),l(St),l(Ul),l(Yt),l(fl),l(zt),l(Cl),l(Qt),l(bl),l(Al),l(Pt)),l(J),c(h,t),c(C,t),c(W,t),c(S,t),c(P,t),c(et,t),c(at,t),c(Tt,t),c(Jt,t),c(jt,t),c(It,t),c(bt,t),c(gt),c(xt,t),c(Ht,t),c($t,t),c(Xt,t)}}}const Os='{"title":"What are Tools?","local":"what-are-tools","sections":[{"title":"What are AI Tools?","local":"what-are-ai-tools","sections":[],"depth":2},{"title":"How do tools work?","local":"how-do-tools-work","sections":[],"depth":2},{"title":"How do we give tools to an LLM?","local":"how-do-we-give-tools-to-an-llm","sections":[{"title":"Auto-formatting Tool sections","local":"auto-formatting-tool-sections","sections":[],"depth":3},{"title":"Generic Tool implementation","local":"generic-tool-implementation","sections":[],"depth":3},{"title":"Model Context Protocol (MCP): a unified tool interface","local":"model-context-protocol-mcp-a-unified-tool-interface","sections":[],"depth":3}],"depth":2}],"depth":1}';function tn(Gl){return qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class on extends Ns{constructor(J){super(),Ps(this,J,tn,Ks,Xs,{})}}export{on as component};
