import{s as Qs,o as Hs,n as zs}from"../chunks/scheduler.37c15a92.js";import{S as qs,i as Ls,g as M,s as a,r as y,A as Ps,h as i,f as t,c as n,j as Fs,u as o,x as p,k as js,y as Ds,a as e,v as w,d as U,t as T,w as j,m as _s,n as Vs}from"../chunks/index.2bf4358c.js";import{T as Ks}from"../chunks/Tip.363c041f.js";import{C as h}from"../chunks/CodeBlock.4e987730.js";import{H as r}from"../chunks/Heading.8ada512a.js";import{E as Os}from"../chunks/index.2145fe70.js";function lt(rl){let m,c,u="this notebook",d;return{c(){m=_s("You can follow the code in "),c=M("a"),c.textContent=u,d=_s(" that you can run using Google Colab."),this.h()},l(J){m=Vs(J,"You can follow the code in "),c=i(J,"A",{href:!0,target:!0,"data-svelte-h":!0}),p(c)!=="svelte-12bw6nz"&&(c.textContent=u),d=Vs(J," that you can run using Google Colab."),this.h()},h(){js(c,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/agent.ipynb"),js(c,"target","_blank")},m(J,I){e(J,m,I),e(J,c,I),e(J,d,I)},p:zs,d(J){J&&(t(m),t(c),t(d))}}}function st(rl){let m,c,u,d,J,I,b,Js="Alfred at your service. As Mr. Wayne’s trusted butler, I’ve taken the liberty of documenting how I assist Mr Wayne with his various documentary needs. While he’s out attending to his… nighttime activities, I ensure all his paperwork, training schedules, and nutritional plans are properly analyzed and organized.",hl,g,ms="Before leaving, he left a note with his week training program. I then took the responsability to come up with a <strong>menu</strong> for tomorrow’s meals.",dl,f,cs="For future such event, let’s create a document analysis system using LangGraph to serve Mister Wayne’s needs. This system can:",ul,B,rs="<li>Process images document</li> <li>Extract text using vision models (Vision Language Model)</li> <li>Perform calculations when needed (to demonstrate normal tools)</li> <li>Analyze content and provide concise summaries</li> <li>Execute specific instructions related to documents</li>",Il,A,Cl,G,hs="The workflow we’ll build, follows a structured this schema:",bl,Z,ds='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',gl,C,fl,W,Bl,$,Al,v,us="and imports :",Gl,k,Zl,x,Wl,E,Is=`This state is a little more complex than the previous ones we have seen.
AnyMessage is a class from langchain that define messages and the add_messages is an operator that add the latest message rather than overwritting it with the latest state.`,$l,S,Cs="This is a new concept in LangGraph, where you can add operators in your state to define the way they should interact together.",vl,Y,kl,R,xl,N,El,X,Sl,F,Yl,_,Rl,V,bs="Allow me to explain the approach in this agent. The agent follows what’s known as the ReAct pattern (Reason-Act-Observe)",Nl,Q,gs="<li><strong>Reason</strong> about his documents and requests</li> <li><strong>Act</strong> by using appropriate tools</li> <li><strong>Observe</strong> the results</li> <li><strong>Repeat</strong> as necessary until I’ve fully addressed his needs</li>",Xl,H,fs="This is a simple implementation of an agent using langGraph.",Fl,z,_l,q,Bs=`We define a <code>tools</code> node with our list of tools. The <code>assistant</code> node is just our model with bound tools.
We create a graph with <code>assistant</code> and <code>tools</code> nodes.`,Vl,L,As="We add <code>tools_condition</code> edge, which routes to <code>End</code> or to <code>tools</code> based on whether the <code>assistant</code> calls a tool.",Ql,P,Gs="Now, we add one new step:",Hl,D,Zs="We connect the <code>tools</code> node back to the <code>assistant</code>, forming a loop.",zl,K,Ws="<li>After the <code>assistant</code> node executes, <code>tools_condition</code> checks if the model’s output is a tool call.</li> <li>If it is a tool call, the flow is directed to the <code>tools</code> node.</li> <li>The <code>tools</code> node connects back to <code>assistant</code>.</li> <li>This loop continues as long as the model decides to call tools.</li> <li>If the model response is not a tool call, the flow is directed to END, terminating the process.</li>",ql,O,$s='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',Ll,ll,Pl,sl,Dl,tl,vs="Here is an example to show a simple use case of an agent using a tool in LangGraph.",Kl,el,Ol,al,ks="The conversation would proceed:",ls,nl,ss,Ml,ts,il,xs="When Master Wayne leaves his training and meal notes:",es,pl,as,yl,Es="The interaction would proceed:",ns,ol,Ms,wl,is,Ul,Ss="Should you wish to create your own document analysis butler, here are key considerations:",ps,Tl,Ys="<li><strong>Define clear tools</strong> for specific document-related tasks</li> <li><strong>Create a robust state tracker</strong> to maintain context between tool calls</li> <li><strong>Consider error handling</strong> for tools fails</li> <li><strong>Maintain contextual awareness</strong> of previous interactions (ensured by the operator add_messages)</li>",ys,jl,Rs="With these principles, you too can provide exemplary document analysis service worthy of Wayne Manor.",os,Jl,Ns="<em>I trust this explanation has been satisfactory. Now, if you’ll excuse me, Master Wayne’s cape requires pressing before tonight’s activities.</em>",ws,ml,Us,cl,Ts;return J=new r({props:{title:"Document Analysis Graph",local:"document-analysis-graph",headingTag:"h1"}}),A=new r({props:{title:"The Butler’s Workflow",local:"the-butlers-workflow",headingTag:"h2"}}),C=new Ks({props:{$$slots:{default:[lt]},$$scope:{ctx:rl}}}),W=new r({props:{title:"Setting Up the environment",local:"setting-up-the-environment",headingTag:"h2"}}),$=new h({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai langchain_core",wrap:!1}}),k=new h({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQWZyb20lMjBsYW5nY2hhaW5fY29yZS5tZXNzYWdlcyUyMGltcG9ydCUyMEFueU1lc3NhZ2UlMkMlMjBTeXN0ZW1NZXNzYWdlJTJDJTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaC5tZXNzYWdlJTIwaW1wb3J0JTIwYWRkX21lc3NhZ2VzJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaCUyMGltcG9ydCUyMFNUQVJUJTJDJTIwU3RhdGVHcmFwaCUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUyQyUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage, HumanMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode, tools_condition
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),x=new r({props:{title:"Defining Agent’s State",local:"defining-agents-state",headingTag:"h2"}}),Y=new h({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBkb2N1bWVudCUyMHByb3ZpZGVkJTBBJTIwJTIwJTIwJTIwaW5wdXRfZmlsZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTIwJTIwJTIzJTIwQ29udGFpbnMlMjBmaWxlJTIwcGF0aCUyMChQREYlMkZQTkcpJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBBbm5vdGF0ZWQlNUJsaXN0JTVCQW55TWVzc2FnZSU1RCUyQyUyMGFkZF9tZXNzYWdlcyU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># The document provided</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]  <span class="hljs-comment"># Contains file path (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),R=new r({props:{title:"Preparing Tools",local:"preparing-tools",headingTag:"h2"}}),N=new h({props:{code:"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",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extract text from an image file using a multimodal model.
    
    Master Wayne often leaves notes with his training regimen or meal plans.
    This allows me to properly analyze the contents.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Read image and encode as base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># Prepare the prompt including the base64 image data</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extract all the text from this image. &quot;</span>
                            <span class="hljs-string">&quot;Return only the extracted text, no explanations.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># Call the vision-capable model</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># Append extracted text</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># A butler should handle errors gracefully</span>
        error_msg = <span class="hljs-string">f&quot;Error extracting text: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Divide a and b - for Master Wayne&#x27;s occasional calculations.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># Equip the butler with tools</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),X=new r({props:{title:"The nodes",local:"the-nodes",headingTag:"h2"}}),F=new h({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTeXN0ZW0lMjBtZXNzYWdlJTBBJTIwJTIwJTIwJTIwdGV4dHVhbF9kZXNjcmlwdGlvbl9vZl90b29sJTNEJTIyJTIyJTIyJTBBZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjBFeHRyYWN0JTIwdGV4dCUyMGZyb20lMjBhbiUyMGltYWdlJTIwZmlsZSUyMHVzaW5nJTIwYSUyMG11bHRpbW9kYWwlMjBtb2RlbC4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1nX3BhdGglM0ElMjBBJTIwbG9jYWwlMjBpbWFnZSUyMGZpbGUlMjBwYXRoJTIwKHN0cmluZ3MpLiUwQSUwQSUyMCUyMCUyMCUyMFJldHVybnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBJTIwc2luZ2xlJTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHRoZSUyMGNvbmNhdGVuYXRlZCUyMHRleHQlMjBleHRyYWN0ZWQlMjBmcm9tJTIwZWFjaCUyMGltYWdlLiUwQWRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjBEaXZpZGUlMjBhJTIwYW5kJTIwYiUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGltYWdlJTNEc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwc3lzX21zZyUyMCUzRCUyMFN5c3RlbU1lc3NhZ2UoY29udGVudCUzRGYlMjJZb3UlMjBhcmUlMjBhbiUyMGhlbHBmdWwlMjBidXRsZXIlMjBuYW1lZCUyMEFsZnJlZCUyMHRoYXQlMjBzZXJ2ZXMlMjBNci4lMjBXYXluZSUyMGFuZCUyMEJhdG1hbi4lMjBZb3UlMjBjYW4lMjBhbmFseXNlJTIwZG9jdW1lbnRzJTIwYW5kJTIwcnVuJTIwY29tcHV0YXRpb25zJTIwd2l0aCUyMHByb3ZpZGVkJTIwdG9vbHMlM0ElNUNuJTdCdGV4dHVhbF9kZXNjcmlwdGlvbl9vZl90b29sJTdEJTIwJTVDbiUyMFlvdSUyMGhhdmUlMjBhY2Nlc3MlMjB0byUyMHNvbWUlMjBvcHRpb25hbCUyMGltYWdlcy4lMjBDdXJyZW50bHklMjB0aGUlMjBsb2FkZWQlMjBpbWFnZSUyMGlzJTNBJTIwJTdCaW1hZ2UlN0QlMjIpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUJsbG1fd2l0aF90b29scy5pbnZva2UoJTVCc3lzX21zZyU1RCUyMCUyQiUyMHN0YXRlJTVCJTIybWVzc2FnZXMlMjIlNUQpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyMHN0YXRlJTVCJTIyaW5wdXRfZmlsZSUyMiU1RCUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment"># System message</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extract text from an image file using a multimodal model.

    Args:
        img_path: A local image file path (strings).

    Returns:
        A single string containing the concatenated text extracted from each image.
divide(a: int, b: int) -&gt; float:
    Divide a and b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;You are an helpful butler named Alfred that serves Mr. Wayne and Batman. You can analyse documents and run computations with provided tools:\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n You have access to some optional images. Currently the loaded image is: <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),_=new r({props:{title:"The ReAct Pattern: How I Assist Mr. Wayne",local:"the-react-pattern-how-i-assist-mr-wayne",headingTag:"h2"}}),z=new h({props:{code:"JTIzJTIwVGhlJTIwZ3JhcGglMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChBZ2VudFN0YXRlKSUwQSUwQSUyMyUyMERlZmluZSUyMG5vZGVzJTNBJTIwdGhlc2UlMjBkbyUyMHRoZSUyMHdvcmslMEFidWlsZGVyLmFkZF9ub2RlKCUyMmFzc2lzdGFudCUyMiUyQyUyMGFzc2lzdGFudCklMEFidWlsZGVyLmFkZF9ub2RlKCUyMnRvb2xzJTIyJTJDJTIwVG9vbE5vZGUodG9vbHMpKSUwQSUwQSUyMyUyMERlZmluZSUyMGVkZ2VzJTNBJTIwdGhlc2UlMjBkZXRlcm1pbmUlMjBob3clMjB0aGUlMjBjb250cm9sJTIwZmxvdyUyMG1vdmVzJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMmFzc2lzdGFudCUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMEElMjAlMjAlMjAlMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBJZiUyMHRoZSUyMGxhdGVzdCUyMG1lc3NhZ2UlMjByZXF1aXJlcyUyMGElMjB0b29sJTJDJTIwcm91dGUlMjB0byUyMHRvb2xzJTBBJTIwJTIwJTIwJTIwJTIzJTIwT3RoZXJ3aXNlJTJDJTIwcHJvdmlkZSUyMGElMjBkaXJlY3QlMjByZXNwb25zZSUwQSUyMCUyMCUyMCUyMHRvb2xzX2NvbmRpdGlvbiUyQyUwQSklMEFidWlsZGVyLmFkZF9lZGdlKCUyMnRvb2xzJTIyJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQXJlYWN0X2dyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCklMEElMEElMjMlMjBTaG93JTIwdGhlJTIwYnV0bGVyJ3MlMjB0aG91Z2h0JTIwcHJvY2VzcyUwQWRpc3BsYXkoSW1hZ2UocmVhY3RfZ3JhcGguZ2V0X2dyYXBoKHhyYXklM0RUcnVlKS5kcmF3X21lcm1haWRfcG5nKCkpKQ==",highlighted:`<span class="hljs-comment"># The graph</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Define nodes: these do the work</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Define edges: these determine how the control flow moves</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># If the latest message requires a tool, route to tools</span>
    <span class="hljs-comment"># Otherwise, provide a direct response</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Show the butler&#x27;s thought process</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),ll=new r({props:{title:"The Butler in Action",local:"the-butler-in-action",headingTag:"h2"}}),sl=new r({props:{title:"Example 1: Simple Calculations",local:"example-1-simple-calculations",headingTag:"h3"}}),el=new h({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlkZSUyMDY3OTAlMjBieSUyMDUlMjIpJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjByZWFjdF9ncmFwaC5pbnZva2UoJTdCJTIybWVzc2FnZXMlMjIlM0ElMjBtZXNzYWdlcyUyQyUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjBOb25lJTdEKSUwQSUwQSUyMyUyMFNob3clMjB0aGUlMjBtZXNzYWdlcyUwQWZvciUyMG0lMjBpbiUyMG1lc3NhZ2VzJTVCJ21lc3NhZ2VzJyU1RCUzQSUwQSUyMCUyMCUyMCUyMG0ucHJldHR5X3ByaW50KCk=",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divide 6790 by 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})

<span class="hljs-comment"># Show the messages</span>
<span class="hljs-keyword">for</span> m <span class="hljs-keyword">in</span> messages[<span class="hljs-string">&#x27;messages&#x27;</span>]:
    m.pretty_print()`,wrap:!1}}),nl=new h({props:{code:"SHVtYW4lM0ElMjBEaXZpZGUlMjA2NzkwJTIwYnklMjA1JTBBJTBBQUklMjBUb29sJTIwQ2FsbCUzQSUyMGRpdmlkZShhJTNENjc5MCUyQyUyMGIlM0Q1KSUwQSUwQVRvb2wlMjBSZXNwb25zZSUzQSUyMDEzNTguMCUwQSUwQUFsZnJlZCUzQSUyMFRoZSUyMHJlc3VsdCUyMG9mJTIwZGl2aWRpbmclMjA2NzkwJTIwYnklMjA1JTIwaXMlMjAxMzU4LjAu",highlighted:`<span class="hljs-attribute">Human</span>: Divide <span class="hljs-number">6790</span> by <span class="hljs-number">5</span>

<span class="hljs-attribute">AI</span> Tool Call: divide(a=<span class="hljs-number">6790</span>, b=<span class="hljs-number">5</span>)

<span class="hljs-attribute">Tool</span> Response: <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>

<span class="hljs-attribute">Alfred</span>: The result of dividing <span class="hljs-number">6790</span> by <span class="hljs-number">5</span> is <span class="hljs-number">1358</span>.<span class="hljs-number">0</span>.`,wrap:!1}}),Ml=new r({props:{title:"Example 2: Analyzing Master Wayne’s Training Documents",local:"example-2-analyzing-master-waynes-training-documents",headingTag:"h3"}}),pl=new h({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkFjY29yZGluZyUyMHRvJTIwdGhlJTIwbm90ZSUyMHByb3ZpZGVkJTIwYnklMjBNci4lMjBXYXluZSUyMGluJTIwdGhlJTIwcHJvdmlkZWQlMjBpbWFnZXMuJTIwV2hhdCdzJTIwdGhlJTIwbGlzdCUyMG9mJTIwaXRlbXMlMjBJJTIwc2hvdWxkJTIwYnV5JTIwZm9yJTIwdGhlJTIwZGlubmVyJTIwbWVudSUzRiUyMiklNUQlMEFtZXNzYWdlcyUyMCUzRCUyMHJlYWN0X2dyYXBoLmludm9rZSglN0IlMjJtZXNzYWdlcyUyMiUzQSUyMG1lc3NhZ2VzJTJDJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyMCUyMkJhdG1hbl90cmFpbmluZ19hbmRfbWVhbHMucG5nJTIyJTdEKQ==",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;According to the note provided by Mr. Wayne in the provided images. What&#x27;s the list of items I should buy for the dinner menu?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),ol=new h({props:{code:"SHVtYW4lM0ElMjBBY2NvcmRpbmclMjB0byUyMHRoZSUyMG5vdGUlMjBwcm92aWRlZCUyMGJ5JTIwTXIuJTIwV2F5bmUlMjBpbiUyMHRoZSUyMHByb3ZpZGVkJTIwaW1hZ2VzLiUyMFdoYXQncyUyMHRoZSUyMGxpc3QlMjBvZiUyMGl0ZW1zJTIwSSUyMHNob3VsZCUyMGJ1eSUyMGZvciUyMHRoZSUyMGRpbm5lciUyMG1lbnUlM0YlMEElMEFBSSUyMFRvb2wlMjBDYWxsJTNBJTIwZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNEJTIyQmF0bWFuX3RyYWluaW5nX2FuZF9tZWFscy5wbmclMjIpJTBBJTBBVG9vbCUyMFJlc3BvbnNlJTNBJTIwJTVCRXh0cmFjdGVkJTIwdGV4dCUyMHdpdGglMjB0cmFpbmluZyUyMHNjaGVkdWxlJTIwYW5kJTIwbWVudSUyMGRldGFpbHMlNUQlMEElMEFBbGZyZWQlM0ElMjBGb3IlMjB0aGUlMjBkaW5uZXIlMjBtZW51JTJDJTIweW91JTIwc2hvdWxkJTIwYnV5JTIwdGhlJTIwZm9sbG93aW5nJTIwaXRlbXMlM0ElMEElMEExLiUyMEdyYXNzLWZlZCUyMGxvY2FsJTIwc2lybG9pbiUyMHN0ZWFrJTBBMi4lMjBPcmdhbmljJTIwc3BpbmFjaCUwQTMuJTIwUGlxdWlsbG8lMjBwZXBwZXJzJTBBNC4lMjBQb3RhdG9lcyUyMChmb3IlMjBvdmVuLWJha2VkJTIwZ29sZGVuJTIwaGVyYiUyMHBvdGF0byklMEE1LiUyMEZpc2glMjBvaWwlMjAoMiUyMGdyYW1zKSUwQSUwQUVuc3VyZSUyMHRoZSUyMHN0ZWFrJTIwaXMlMjBncmFzcy1mZWQlMjBhbmQlMjB0aGUlMjBzcGluYWNoJTIwYW5kJTIwcGVwcGVycyUyMGFyZSUyMG9yZ2FuaWMlMjBmb3IlMjB0aGUlMjBiZXN0JTIwcXVhbGl0eSUyMG1lYWwu",highlighted:`<span class="hljs-symbol">Human:</span> According <span class="hljs-keyword">to</span> the note provided <span class="hljs-keyword">by</span> Mr. Wayne <span class="hljs-keyword">in</span> the provided images. What<span class="hljs-comment">&#x27;s the list of items I should buy for the dinner menu?</span>

AI Tool <span class="hljs-keyword">Call</span>: extract_text(img_path=<span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>)

Tool Response: [Extracted <span class="hljs-keyword">text</span> <span class="hljs-keyword">with</span> training schedule <span class="hljs-built_in">and</span> menu details]

<span class="hljs-symbol">Alfred:</span> <span class="hljs-keyword">For</span> the dinner menu, you should buy the following items:

<span class="hljs-number">1</span>. Grass-fed local sirloin steak
<span class="hljs-number">2</span>. Organic spinach
<span class="hljs-number">3</span>. Piquillo peppers
<span class="hljs-number">4</span>. Potatoes (<span class="hljs-keyword">for</span> oven-baked golden herb potato)
<span class="hljs-number">5</span>. Fish oil (<span class="hljs-number">2</span> grams)

Ensure the steak <span class="hljs-built_in">is</span> grass-fed <span class="hljs-built_in">and</span> the spinach <span class="hljs-built_in">and</span> peppers are organic <span class="hljs-keyword">for</span> the best quality meal.`,wrap:!1}}),wl=new r({props:{title:"Key Takeaways",local:"key-takeaways",headingTag:"h2"}}),ml=new Os({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){m=M("meta"),c=a(),u=M("p"),d=a(),y(J.$$.fragment),I=a(),b=M("p"),b.textContent=Js,hl=a(),g=M("p"),g.innerHTML=ms,dl=a(),f=M("p"),f.textContent=cs,ul=a(),B=M("ol"),B.innerHTML=rs,Il=a(),y(A.$$.fragment),Cl=a(),G=M("p"),G.textContent=hs,bl=a(),Z=M("p"),Z.innerHTML=ds,gl=a(),y(C.$$.fragment),fl=a(),y(W.$$.fragment),Bl=a(),y($.$$.fragment),Al=a(),v=M("p"),v.textContent=us,Gl=a(),y(k.$$.fragment),Zl=a(),y(x.$$.fragment),Wl=a(),E=M("p"),E.textContent=Is,$l=a(),S=M("p"),S.textContent=Cs,vl=a(),y(Y.$$.fragment),kl=a(),y(R.$$.fragment),xl=a(),y(N.$$.fragment),El=a(),y(X.$$.fragment),Sl=a(),y(F.$$.fragment),Yl=a(),y(_.$$.fragment),Rl=a(),V=M("p"),V.textContent=bs,Nl=a(),Q=M("ol"),Q.innerHTML=gs,Xl=a(),H=M("p"),H.textContent=fs,Fl=a(),y(z.$$.fragment),_l=a(),q=M("p"),q.innerHTML=Bs,Vl=a(),L=M("p"),L.innerHTML=As,Ql=a(),P=M("p"),P.textContent=Gs,Hl=a(),D=M("p"),D.innerHTML=Zs,zl=a(),K=M("ul"),K.innerHTML=Ws,ql=a(),O=M("p"),O.innerHTML=$s,Ll=a(),y(ll.$$.fragment),Pl=a(),y(sl.$$.fragment),Dl=a(),tl=M("p"),tl.textContent=vs,Kl=a(),y(el.$$.fragment),Ol=a(),al=M("p"),al.textContent=ks,ls=a(),y(nl.$$.fragment),ss=a(),y(Ml.$$.fragment),ts=a(),il=M("p"),il.textContent=xs,es=a(),y(pl.$$.fragment),as=a(),yl=M("p"),yl.textContent=Es,ns=a(),y(ol.$$.fragment),Ms=a(),y(wl.$$.fragment),is=a(),Ul=M("p"),Ul.textContent=Ss,ps=a(),Tl=M("ol"),Tl.innerHTML=Ys,ys=a(),jl=M("p"),jl.textContent=Rs,os=a(),Jl=M("p"),Jl.innerHTML=Ns,ws=a(),y(ml.$$.fragment),Us=a(),cl=M("p"),this.h()},l(l){const s=Ps("svelte-u9bgzb",document.head);m=i(s,"META",{name:!0,content:!0}),s.forEach(t),c=n(l),u=i(l,"P",{}),Fs(u).forEach(t),d=n(l),o(J.$$.fragment,l),I=n(l),b=i(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-11xka8s"&&(b.textContent=Js),hl=n(l),g=i(l,"P",{"data-svelte-h":!0}),p(g)!=="svelte-t4bjwl"&&(g.innerHTML=ms),dl=n(l),f=i(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-17vvsed"&&(f.textContent=cs),ul=n(l),B=i(l,"OL",{"data-svelte-h":!0}),p(B)!=="svelte-gyca7w"&&(B.innerHTML=rs),Il=n(l),o(A.$$.fragment,l),Cl=n(l),G=i(l,"P",{"data-svelte-h":!0}),p(G)!=="svelte-p4eu2y"&&(G.textContent=hs),bl=n(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-g7cpwr"&&(Z.innerHTML=ds),gl=n(l),o(C.$$.fragment,l),fl=n(l),o(W.$$.fragment,l),Bl=n(l),o($.$$.fragment,l),Al=n(l),v=i(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1ey17wx"&&(v.textContent=us),Gl=n(l),o(k.$$.fragment,l),Zl=n(l),o(x.$$.fragment,l),Wl=n(l),E=i(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1d1vtsq"&&(E.textContent=Is),$l=n(l),S=i(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-s7exkc"&&(S.textContent=Cs),vl=n(l),o(Y.$$.fragment,l),kl=n(l),o(R.$$.fragment,l),xl=n(l),o(N.$$.fragment,l),El=n(l),o(X.$$.fragment,l),Sl=n(l),o(F.$$.fragment,l),Yl=n(l),o(_.$$.fragment,l),Rl=n(l),V=i(l,"P",{"data-svelte-h":!0}),p(V)!=="svelte-18vru10"&&(V.textContent=bs),Nl=n(l),Q=i(l,"OL",{"data-svelte-h":!0}),p(Q)!=="svelte-1lieze1"&&(Q.innerHTML=gs),Xl=n(l),H=i(l,"P",{"data-svelte-h":!0}),p(H)!=="svelte-7iqp0"&&(H.textContent=fs),Fl=n(l),o(z.$$.fragment,l),_l=n(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1d0auck"&&(q.innerHTML=Bs),Vl=n(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-8pgf7n"&&(L.innerHTML=As),Ql=n(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1f0m6x1"&&(P.textContent=Gs),Hl=n(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-echfi8"&&(D.innerHTML=Zs),zl=n(l),K=i(l,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-bdsar0"&&(K.innerHTML=Ws),ql=n(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1nhlurw"&&(O.innerHTML=$s),Ll=n(l),o(ll.$$.fragment,l),Pl=n(l),o(sl.$$.fragment,l),Dl=n(l),tl=i(l,"P",{"data-svelte-h":!0}),p(tl)!=="svelte-1rxi6tg"&&(tl.textContent=vs),Kl=n(l),o(el.$$.fragment,l),Ol=n(l),al=i(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-eegy09"&&(al.textContent=ks),ls=n(l),o(nl.$$.fragment,l),ss=n(l),o(Ml.$$.fragment,l),ts=n(l),il=i(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-k6gec7"&&(il.textContent=xs),es=n(l),o(pl.$$.fragment,l),as=n(l),yl=i(l,"P",{"data-svelte-h":!0}),p(yl)!=="svelte-gpwkjm"&&(yl.textContent=Es),ns=n(l),o(ol.$$.fragment,l),Ms=n(l),o(wl.$$.fragment,l),is=n(l),Ul=i(l,"P",{"data-svelte-h":!0}),p(Ul)!=="svelte-17u0oai"&&(Ul.textContent=Ss),ps=n(l),Tl=i(l,"OL",{"data-svelte-h":!0}),p(Tl)!=="svelte-1qddtr0"&&(Tl.innerHTML=Ys),ys=n(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-1tc3qgy"&&(jl.textContent=Rs),os=n(l),Jl=i(l,"P",{"data-svelte-h":!0}),p(Jl)!=="svelte-1ik86s0"&&(Jl.innerHTML=Ns),ws=n(l),o(ml.$$.fragment,l),Us=n(l),cl=i(l,"P",{}),Fs(cl).forEach(t),this.h()},h(){js(m,"name","hf:doc:metadata"),js(m,"content",tt)},m(l,s){Ds(document.head,m),e(l,c,s),e(l,u,s),e(l,d,s),w(J,l,s),e(l,I,s),e(l,b,s),e(l,hl,s),e(l,g,s),e(l,dl,s),e(l,f,s),e(l,ul,s),e(l,B,s),e(l,Il,s),w(A,l,s),e(l,Cl,s),e(l,G,s),e(l,bl,s),e(l,Z,s),e(l,gl,s),w(C,l,s),e(l,fl,s),w(W,l,s),e(l,Bl,s),w($,l,s),e(l,Al,s),e(l,v,s),e(l,Gl,s),w(k,l,s),e(l,Zl,s),w(x,l,s),e(l,Wl,s),e(l,E,s),e(l,$l,s),e(l,S,s),e(l,vl,s),w(Y,l,s),e(l,kl,s),w(R,l,s),e(l,xl,s),w(N,l,s),e(l,El,s),w(X,l,s),e(l,Sl,s),w(F,l,s),e(l,Yl,s),w(_,l,s),e(l,Rl,s),e(l,V,s),e(l,Nl,s),e(l,Q,s),e(l,Xl,s),e(l,H,s),e(l,Fl,s),w(z,l,s),e(l,_l,s),e(l,q,s),e(l,Vl,s),e(l,L,s),e(l,Ql,s),e(l,P,s),e(l,Hl,s),e(l,D,s),e(l,zl,s),e(l,K,s),e(l,ql,s),e(l,O,s),e(l,Ll,s),w(ll,l,s),e(l,Pl,s),w(sl,l,s),e(l,Dl,s),e(l,tl,s),e(l,Kl,s),w(el,l,s),e(l,Ol,s),e(l,al,s),e(l,ls,s),w(nl,l,s),e(l,ss,s),w(Ml,l,s),e(l,ts,s),e(l,il,s),e(l,es,s),w(pl,l,s),e(l,as,s),e(l,yl,s),e(l,ns,s),w(ol,l,s),e(l,Ms,s),w(wl,l,s),e(l,is,s),e(l,Ul,s),e(l,ps,s),e(l,Tl,s),e(l,ys,s),e(l,jl,s),e(l,os,s),e(l,Jl,s),e(l,ws,s),w(ml,l,s),e(l,Us,s),e(l,cl,s),Ts=!0},p(l,[s]){const Xs={};s&2&&(Xs.$$scope={dirty:s,ctx:l}),C.$set(Xs)},i(l){Ts||(U(J.$$.fragment,l),U(A.$$.fragment,l),U(C.$$.fragment,l),U(W.$$.fragment,l),U($.$$.fragment,l),U(k.$$.fragment,l),U(x.$$.fragment,l),U(Y.$$.fragment,l),U(R.$$.fragment,l),U(N.$$.fragment,l),U(X.$$.fragment,l),U(F.$$.fragment,l),U(_.$$.fragment,l),U(z.$$.fragment,l),U(ll.$$.fragment,l),U(sl.$$.fragment,l),U(el.$$.fragment,l),U(nl.$$.fragment,l),U(Ml.$$.fragment,l),U(pl.$$.fragment,l),U(ol.$$.fragment,l),U(wl.$$.fragment,l),U(ml.$$.fragment,l),Ts=!0)},o(l){T(J.$$.fragment,l),T(A.$$.fragment,l),T(C.$$.fragment,l),T(W.$$.fragment,l),T($.$$.fragment,l),T(k.$$.fragment,l),T(x.$$.fragment,l),T(Y.$$.fragment,l),T(R.$$.fragment,l),T(N.$$.fragment,l),T(X.$$.fragment,l),T(F.$$.fragment,l),T(_.$$.fragment,l),T(z.$$.fragment,l),T(ll.$$.fragment,l),T(sl.$$.fragment,l),T(el.$$.fragment,l),T(nl.$$.fragment,l),T(Ml.$$.fragment,l),T(pl.$$.fragment,l),T(ol.$$.fragment,l),T(wl.$$.fragment,l),T(ml.$$.fragment,l),Ts=!1},d(l){l&&(t(c),t(u),t(d),t(I),t(b),t(hl),t(g),t(dl),t(f),t(ul),t(B),t(Il),t(Cl),t(G),t(bl),t(Z),t(gl),t(fl),t(Bl),t(Al),t(v),t(Gl),t(Zl),t(Wl),t(E),t($l),t(S),t(vl),t(kl),t(xl),t(El),t(Sl),t(Yl),t(Rl),t(V),t(Nl),t(Q),t(Xl),t(H),t(Fl),t(_l),t(q),t(Vl),t(L),t(Ql),t(P),t(Hl),t(D),t(zl),t(K),t(ql),t(O),t(Ll),t(Pl),t(Dl),t(tl),t(Kl),t(Ol),t(al),t(ls),t(ss),t(ts),t(il),t(es),t(as),t(yl),t(ns),t(Ms),t(is),t(Ul),t(ps),t(Tl),t(ys),t(jl),t(os),t(Jl),t(ws),t(Us),t(cl)),t(m),j(J,l),j(A,l),j(C,l),j(W,l),j($,l),j(k,l),j(x,l),j(Y,l),j(R,l),j(N,l),j(X,l),j(F,l),j(_,l),j(z,l),j(ll,l),j(sl,l),j(el,l),j(nl,l),j(Ml,l),j(pl,l),j(ol,l),j(wl,l),j(ml,l)}}}const tt='{"title":"Document Analysis Graph","local":"document-analysis-graph","sections":[{"title":"The Butler’s Workflow","local":"the-butlers-workflow","sections":[],"depth":2},{"title":"Setting Up the environment","local":"setting-up-the-environment","sections":[],"depth":2},{"title":"Defining Agent’s State","local":"defining-agents-state","sections":[],"depth":2},{"title":"Preparing Tools","local":"preparing-tools","sections":[],"depth":2},{"title":"The nodes","local":"the-nodes","sections":[],"depth":2},{"title":"The ReAct Pattern: How I Assist Mr. Wayne","local":"the-react-pattern-how-i-assist-mr-wayne","sections":[],"depth":2},{"title":"The Butler in Action","local":"the-butler-in-action","sections":[{"title":"Example 1: Simple Calculations","local":"example-1-simple-calculations","sections":[],"depth":3},{"title":"Example 2: Analyzing Master Wayne’s Training Documents","local":"example-2-analyzing-master-waynes-training-documents","sections":[],"depth":3}],"depth":2},{"title":"Key Takeaways","local":"key-takeaways","sections":[],"depth":2}],"depth":1}';function et(rl){return Hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ot extends qs{constructor(m){super(),Ls(this,m,et,st,Qs,{})}}export{ot as component};
