import{s as ss,f as ns,o as os,n as as}from"../chunks/scheduler.37c15a92.js";import{S as is,i as rs,g as a,s as n,r as p,A as ps,h as i,f as l,c as o,j as rl,u as M,x as r,k as ke,y as Ee,a as s,v as c,d as h,t as y,w as u,m as ts,n as ls}from"../chunks/index.2bf4358c.js";import{T as Ms}from"../chunks/Tip.363c041f.js";import{C}from"../chunks/CodeBlock.4e987730.js";import{C as cs}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as T}from"../chunks/Heading.8ada512a.js";import{E as hs}from"../chunks/index.2145fe70.js";function ys(Ne){let m,g,U="this notebook",f;return{c(){m=ts("You can follow the code in "),g=a("a"),g.textContent=U,f=ts(" that you can run using Google Colab."),this.h()},l(d){m=ls(d,"You can follow the code in "),g=i(d,"A",{href:!0,target:!0,"data-svelte-h":!0}),r(g)!=="svelte-z2gf46"&&(g.textContent=U),f=ls(d," that you can run using Google Colab."),this.h()},h(){ke(g,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb"),ke(g,"target","_blank")},m(d,j){s(d,m,j),s(d,g,j),s(d,f,j)},p:as,d(d){d&&(l(m),l(g),l(f))}}}function us(Ne){let m,g,U,f,d,j,I,Fe,v,pl='As we explored in <a href="https://huggingface.co/learn/agents-course/unit1/tools" rel="nofollow">unit 1</a>, agents use tools to perform various actions. In <code>smolagents</code>, tools are treated as <strong>functions that an LLM can call within an agent system</strong>.',qe,G,Ml="To interact with a tool, the LLM needs an <strong>interface description</strong> with these key components:",Ye,Z,cl="<li><strong>Name</strong>: What the tool is called</li> <li><strong>Tool description</strong>: What the tool does</li> <li><strong>Input types and descriptions</strong>: What arguments the tool accepts</li> <li><strong>Output type</strong>: What the tool returns</li>",Le,B,hl="For instance, while preparing for a party at Wayne Manor, Alfred needs various tools to gather information - from searching for catering services to finding party theme ideas. Here’s how a simple search tool interface might look:",ze,$,yl="<li><strong>Name:</strong> <code>web_search</code></li> <li><strong>Tool description:</strong> Searches the web for specific queries</li> <li><strong>Input:</strong> <code>query</code> (string) - The search term to look up</li> <li><strong>Output:</strong> String containing the search results</li>",Pe,V,ul="By using these tools, Alfred can make informed decisions and gather all the information needed for planning the perfect party.",De,x,dl="Below, you can see an animation illustrating how a tool call is managed:",Ke,W,ml='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif" alt="Agentic pipeline from https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',Oe,H,et,X,gl="In <code>smolagents</code>, tools can be defined in two ways:",tt,A,Tl="<li><strong>Using the <code>@tool</code> decorator</strong> for simple function-based tools</li> <li><strong>Creating a subclass of <code>Tool</code></strong> for more complex functionality</li>",lt,R,st,Q,wl="The <code>@tool</code> decorator is the <strong>recommended way to define simple tools</strong>. Under the hood, smolagents will parse basic information about the function from Python. So if you name your function clearly and write a good docstring, it will be easier for the LLM to use.",nt,_,fl="Using this approach, we define a function with:",ot,k,Jl="<li><strong>A clear and descriptive function name</strong> that helps the LLM understand its purpose.</li> <li><strong>Type hints for both inputs and outputs</strong> to ensure proper usage.</li> <li><strong>A detailed description</strong>, including an <code>Args:</code> section where each argument is explicitly described. These descriptions provide valuable context for the LLM, so it’s important to write them carefully.</li>",at,S,it,E,Ul,rt,b,pt,N,jl="Let’s imagine that Alfred has already decided on the menu for the party, but now he needs help preparing food for such a large number of guests. To do so, he would like to hire a catering service and needs to identify the highest-rated options available. Alfred can leverage a tool to search for the best catering services in his area.",Mt,F,bl="Below is an example of how Alfred can use the <code>@tool</code> decorator to make this happen:",ct,q,ht,Y,yt,L,Cl='This approach involves creating a subclass of <a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools#smolagents.Tool" rel="nofollow"><code>Tool</code></a>.  For complex tools, we can implement a class instead of a Python function. The class wraps the function with metadata that helps the LLM understand how to use it effectively. In this class, we define:',ut,z,Il="<li><code>name</code>: The tool’s name.</li> <li><code>description</code>: A description used to populate the agent’s system prompt.</li> <li><code>inputs</code>: A dictionary with keys <code>type</code> and <code>description</code>, providing information to help the Python interpreter process inputs.</li> <li><code>output_type</code>: Specifies the expected output type.</li> <li><code>forward</code>: The method containing the inference logic to execute.</li>",dt,P,vl="Below, we can see an example of a tool built using <code>Tool</code> and how to integrate it within a <code>CodeAgent</code>.",mt,D,gt,K,Gl="Alfred’s party at the mansion is a <strong>superhero-themed event</strong>, but he needs some creative ideas to make it truly special. As a fantastic host, he wants to surprise the guests with a unique theme.",Tt,O,Zl="To do this, he can use an agent that generates superhero-themed party ideas based on a given category. This way, Alfred can find the perfect party theme to wow his guests.",wt,ee,ft,te,Bl="With this tool, Alfred will be the ultimate super host, impressing his guests with a superhero-themed party they won’t forget! 🦸‍♂️🦸‍♀️",Jt,le,Ut,se,$l='<code>smolagents</code> comes with a set of pre-built tools that can be directly injected into your agent. The <a href="https://huggingface.co/docs/smolagents/guided_tour?build-a-tool=Decorate+a+function+with+%40tool#default-toolbox" rel="nofollow">default toolbox</a> includes:',jt,ne,Vl="<li><strong>PythonInterpreterTool</strong></li> <li><strong>FinalAnswerTool</strong></li> <li><strong>UserInputTool</strong></li> <li><strong>DuckDuckGoSearchTool</strong></li> <li><strong>GoogleSearchTool</strong></li> <li><strong>VisitWebpageTool</strong></li>",bt,oe,xl="Alfred could use various tools to ensure a flawless party at Wayne Manor:",Ct,ae,Wl="<li><p>First, he could use the <code>DuckDuckGoSearchTool</code> to find creative superhero-themed party ideas.</p></li> <li><p>For catering, he’d rely on the <code>GoogleSearchTool</code> to find the highest-rated services in Gotham.</p></li> <li><p>To manage seating arrangements, Alfred could run calculations with the <code>PythonInterpreterTool</code>.</p></li> <li><p>Once everything is gathered, he’d compile the plan using the <code>FinalAnswerTool</code>.</p></li>",It,ie,Hl="With these tools, Alfred guarantees the party is both exceptional and seamless. 🦇💡",vt,re,Gt,pe,Xl="One of the most powerful features of <strong>smolagents</strong> is its ability to share custom tools on the Hub and seamlessly integrate tools created by the community. This includes connecting with <strong>HF Spaces</strong> and <strong>LangChain tools</strong>, significantly enhancing Alfred’s ability to orchestrate an unforgettable party at Wayne Manor. 🎭",Zt,Me,Al="With these integrations, Alfred can tap into advanced event-planning tools—whether it’s adjusting the lighting for the perfect ambiance, curating the ideal playlist for the party, or coordinating with Gotham’s finest caterers.",Bt,ce,Rl="Here are examples showcasing how these functionalities can elevate the party experience:",$t,he,Vt,ye,Ql="Sharing your custom tool with the community is easy! Simply upload it to your Hugging Face account using the <code>push_to_hub()</code> method.",xt,ue,_l="For instance, Alfred can share his <code>party_theme_tool</code> to help others find the best catering services in Gotham. Here’s how to do it:",Wt,de,Ht,me,Xt,ge,kl="You can easily import tools created by other users using the <code>load_tool()</code> function. For example, Alfred might want to generate a promotional image for the party using AI. Instead of building a tool from scratch, he can leverage a predefined one from the community:",At,Te,Rt,we,Qt,fe,Sl="You can also import a HF Space as a tool using <code>Tool.from_space()</code>. This opens up possibilities for integrating with thousands of spaces from the community for tasks from image generation to data analysis.",_t,Je,El="The tool will connect with the spaces Gradio backend using the <code>gradio_client</code>, so make sure to install it via <code>pip</code> if you don’t have it already.",kt,Ue,Nl="For the party, Alfred can use an existing HF Space for the generation of the AI-generated image to be used in the announcement (instead of the pre-built tool we mentioned before). Let’s build it!",St,je,Et,be,Nt,Ce,Fl="We’ll discuss the <code>LangChain</code> framework in upcoming sections. For now, we just note that we can reuse LangChain tools in your smolagents workflow!",Ft,Ie,ql="You can easily load LangChain tools using the <code>Tool.from_langchain()</code> method. Alfred, ever the perfectionist, is preparing for a spectacular superhero night at Wayne Manor while the Waynes are away. To make sure every detail exceeds expectations, he taps into LangChain tools to find top-tier entertainment ideas.",qt,ve,Yl="By using <code>Tool.from_langchain()</code>, Alfred effortlessly adds advanced search functionalities to his smolagent, enabling him to discover exclusive party ideas and services with just a few commands.",Yt,Ge,Ll="Here’s how he does it:",Lt,Ze,zt,Be,Pt,$e,zl='<code>smolagents</code> also allows importing tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai" rel="nofollow">smithery.ai</a>.',Dt,w,Qe,Pl="Install mcp client",al,_e,Dl="We first need to install the <code>mcp</code> integration for <code>smolagents</code>.",il,Ve,Kt,xe,Kl="The MCP servers tools can be loaded in a ToolCollection object as follow:",Ot,We,el,He,Ol="With this setup, Alfred can quickly discover luxurious entertainment options, ensuring Gotham’s elite guests have an unforgettable experience. This tool helps him curate the perfect superhero-themed event for Wayne Manor! 🎉",tl,Xe,ll,Ae,es='<li><a href="https://huggingface.co/docs/smolagents/tutorials/tools" rel="nofollow">Tools Tutorial</a> - Explore this tutorial to learn how to work with tools effectively.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools" rel="nofollow">Tools Documentation</a> - Comprehensive reference documentation on tools.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/guided_tour#tools" rel="nofollow">Tools Guided Tour</a> - A step-by-step guided tour to help you build and utilize tools efficiently.</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">Building Effective Agents</a> - A detailed guide on best practices for developing reliable and high-performance custom function agents.</li>',sl,Re,nl,Se,ol;return d=new cs({props:{chapter:2,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/agents-course/blob/main/notebooks/unit2/smolagents/tools.ipynb"}]}}),I=new T({props:{title:"Tools",local:"tools",headingTag:"h1"}}),H=new T({props:{title:"Tool Creation Methods",local:"tool-creation-methods",headingTag:"h2"}}),R=new T({props:{title:"The @tool Decorator",local:"the-tool-decorator",headingTag:"h3"}}),S=new T({props:{title:"Generating a tool that retrieves the highest-rated catering",local:"generating-a-tool-that-retrieves-the-highest-rated-catering",headingTag:"h4"}}),b=new Ms({props:{$$slots:{default:[ys]},$$scope:{ctx:Ne}}}),q=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTJDJTIwdG9vbCUwQSUwQSUyMyUyMExldCdzJTIwcHJldGVuZCUyMHdlJTIwaGF2ZSUyMGElMjBmdW5jdGlvbiUyMHRoYXQlMjBmZXRjaGVzJTIwdGhlJTIwaGlnaGVzdC1yYXRlZCUyMGNhdGVyaW5nJTIwc2VydmljZXMuJTBBJTQwdG9vbCUwQWRlZiUyMGNhdGVyaW5nX3NlcnZpY2VfdG9vbChxdWVyeSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwVGhpcyUyMHRvb2wlMjByZXR1cm5zJTIwdGhlJTIwaGlnaGVzdC1yYXRlZCUyMGNhdGVyaW5nJTIwc2VydmljZSUyMGluJTIwR290aGFtJTIwQ2l0eS4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnklM0ElMjBBJTIwc2VhcmNoJTIwdGVybSUyMGZvciUyMGZpbmRpbmclMjBjYXRlcmluZyUyMHNlcnZpY2VzLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMyUyMEV4YW1wbGUlMjBsaXN0JTIwb2YlMjBjYXRlcmluZyUyMHNlcnZpY2VzJTIwYW5kJTIwdGhlaXIlMjByYXRpbmdzJTBBJTIwJTIwJTIwJTIwc2VydmljZXMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJHb3RoYW0lMjBDYXRlcmluZyUyMENvLiUyMiUzQSUyMDQuOSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldheW5lJTIwTWFub3IlMjBDYXRlcmluZyUyMiUzQSUyMDQuOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkdvdGhhbSUyMENpdHklMjBFdmVudHMlMjIlM0ElMjA0LjclMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBGaW5kJTIwdGhlJTIwaGlnaGVzdCUyMHJhdGVkJTIwY2F0ZXJpbmclMjBzZXJ2aWNlJTIwKHNpbXVsYXRpbmclMjBzZWFyY2glMjBxdWVyeSUyMGZpbHRlcmluZyklMEElMjAlMjAlMjAlMjBiZXN0X3NlcnZpY2UlMjAlM0QlMjBtYXgoc2VydmljZXMlMkMlMjBrZXklM0RzZXJ2aWNlcy5nZXQpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmVzdF9zZXJ2aWNlJTBBJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJjYXRlcmluZ19zZXJ2aWNlX3Rvb2wlNUQlMkMlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSklMEElMEElMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUyMHRvJTIwZmluZCUyMHRoZSUyMGJlc3QlMjBjYXRlcmluZyUyMHNlcnZpY2UlMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwaGlnaGVzdC1yYXRlZCUyMGNhdGVyaW5nJTIwc2VydmljZSUyMGluJTIwR290aGFtJTIwQ2l0eSUzRiUyMiUwQSklMEElMEFwcmludChyZXN1bHQpJTIwJTIwJTIwJTIzJTIwT3V0cHV0JTNBJTIwR290aGFtJTIwQ2F0ZXJpbmclMjBDby4=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel, tool

<span class="hljs-comment"># Let&#x27;s pretend we have a function that fetches the highest-rated catering services.</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    This tool returns the highest-rated catering service in Gotham City.

    Args:
        query: A search term for finding catering services.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example list of catering services and their ratings</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }

    <span class="hljs-comment"># Find the highest rated catering service (simulating search query filtering)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)

    <span class="hljs-keyword">return</span> best_service


agent = CodeAgent(tools=[catering_service_tool], model=HfApiModel())

<span class="hljs-comment"># Run the agent to find the best catering service</span>
result = agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the highest-rated catering service in Gotham City?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)   <span class="hljs-comment"># Output: Gotham Catering Co.</span>`,wrap:!1}}),Y=new T({props:{title:"Defining a Tool as a Python Class",local:"defining-a-tool-as-a-python-class",headingTag:"h3"}}),D=new T({props:{title:"Generating a tool to generate ideas about the superhero-themed party",local:"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party",headingTag:"h4"}}),ee=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool, CodeAgent, HfApiModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This tool suggests creative superhero-themed party ideas based on a category.
    It returns a unique party theme idea.&quot;&quot;&quot;</span>

    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The type of superhero party (e.g., &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, &#x27;futuristic Gotham&#x27;).&quot;</span>,
        }
    }

    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Justice League Gala: Guests come dressed as their favorite DC heroes with themed cocktails like &#x27;The Kryptonite Punch&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Neo-Gotham Night: A cyberpunk-style party inspired by Batman Beyond, with neon decorations and futuristic gadgets.&quot;</span>
        }

        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Themed party idea not found. Try &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, or &#x27;futuristic Gotham&#x27;.&quot;</span>)

<span class="hljs-comment"># Instantiate the tool</span>
party_theme_tool = SuperheroPartyThemeTool()
agent = CodeAgent(tools=[party_theme_tool], model=HfApiModel())

<span class="hljs-comment"># Run the agent to generate a party theme idea</span>
result = agent.run(
    <span class="hljs-string">&quot;What would be a good superhero party idea for a &#x27;villain masquerade&#x27; theme?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)  <span class="hljs-comment"># Output: &quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>`,wrap:!1}}),le=new T({props:{title:"Default Toolbox",local:"default-toolbox",headingTag:"h2"}}),re=new T({props:{title:"Sharing and Importing Tools",local:"sharing-and-importing-tools",headingTag:"h2"}}),he=new T({props:{title:"Sharing a Tool to the Hub",local:"sharing-a-tool-to-the-hub",headingTag:"h3"}}),de=new C({props:{code:"cGFydHlfdGhlbWVfdG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGcGFydHlfdGhlbWVfdG9vbCUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'party_theme_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/party_theme_tool&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),me=new T({props:{title:"Importing a Tool from the Hub",local:"importing-a-tool-from-the-hub",headingTag:"h3"}}),Te=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTBBJTBBaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMm0tcmljJTJGdGV4dC10by1pbWFnZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUwQSklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESGZBcGlNb2RlbCgpJTBBKSUwQSUwQWFnZW50LnJ1biglMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGElMjBsdXh1cmlvdXMlMjBzdXBlcmhlcm8tdGhlbWVkJTIwcGFydHklMjBhdCUyMFdheW5lJTIwTWFub3IlMjB3aXRoJTIwbWFkZS11cCUyMHN1cGVyaGVyb3MuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, HfApiModel

image_generation_tool = load_tool(
    <span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)

agent = CodeAgent(
    tools=[image_generation_tool],
    model=HfApiModel()
)

agent.run(<span class="hljs-string">&quot;Generate an image of a luxurious superhero-themed party at Wayne Manor with made-up superheros.&quot;</span>)`,wrap:!1}}),we=new T({props:{title:"Importing a Hugging Face Space as a Tool",local:"importing-a-hugging-face-space-as-a-tool",headingTag:"h3"}}),je=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTJDJTIwVG9vbCUwQSUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMFRvb2wuZnJvbV9zcGFjZSglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMmltYWdlX2dlbmVyYXRvciUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyR2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwZnJvbSUyMGElMjBwcm9tcHQlMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkltcHJvdmUlMjB0aGlzJTIwcHJvbXB0JTJDJTIwdGhlbiUyMGdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwaXQuJTIyJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hcmdzJTNEJTdCJ3VzZXJfcHJvbXB0JyUzQSUyMCdBJTIwZ3JhbmQlMjBzdXBlcmhlcm8tdGhlbWVkJTIwcGFydHklMjBhdCUyMFdheW5lJTIwTWFub3IlMkMlMjB3aXRoJTIwQWxmcmVkJTIwb3ZlcnNlZWluZyUyMGElMjBsdXh1cmlvdXMlMjBnYWxhJyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel, Tool

image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>,
    additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A grand superhero-themed party at Wayne Manor, with Alfred overseeing a luxurious gala&#x27;</span>}
)`,wrap:!1}}),be=new T({props:{title:"Importing a LangChain Tool",local:"importing-a-langchain-tool",headingTag:"h3"}}),Ze=new C({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBIZkFwaU1vZGVsJTJDJTIwVG9vbCUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwVG9vbC5mcm9tX2xhbmdjaGFpbihsb2FkX3Rvb2xzKCU1QiUyMnNlcnBhcGklMjIlNUQpJTVCMCU1RCklMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QnNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTIyU2VhcmNoJTIwZm9yJTIwbHV4dXJ5JTIwZW50ZXJ0YWlubWVudCUyMGlkZWFzJTIwZm9yJTIwYSUyMHN1cGVyaGVyby10aGVtZWQlMjBldmVudCUyQyUyMHN1Y2glMjBhcyUyMGxpdmUlMjBwZXJmb3JtYW5jZXMlMjBhbmQlMjBpbnRlcmFjdGl2ZSUyMGV4cGVyaWVuY2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, HfApiModel, Tool

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;Search for luxury entertainment ideas for a superhero-themed event, such as live performances and interactive experiences.&quot;</span>)`,wrap:!1}}),Be=new T({props:{title:"Importing a tool collection from any MCP server",local:"importing-a-tool-collection-from-any-mcp-server",headingTag:"h3"}}),Ve=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJtY3AlNUQlMjI=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[mcp]&quot;</span>',wrap:!1}}),We=new C({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMFRvb2xDb2xsZWN0aW9uJTJDJTIwQ29kZUFnZW50JTBBZnJvbSUyMG1jcCUyMGltcG9ydCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwSGZBcGlNb2RlbCUwQSUwQSUwQW1vZGVsJTIwJTNEJTIwSGZBcGlNb2RlbCglMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBJTBBc2VydmVyX3BhcmFtZXRlcnMlMjAlM0QlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMoJTBBJTIwJTIwJTIwJTIwY29tbWFuZCUzRCUyMnV2eCUyMiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0QlNUIlMjItLXF1aWV0JTIyJTJDJTIwJTIycHVibWVkbWNwJTQwMC4xLjMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBlbnYlM0QlN0IlMjJVVl9QWVRIT04lMjIlM0ElMjAlMjIzLjEyJTIyJTJDJTIwKipvcy5lbnZpcm9uJTdEJTJDJTBBKSUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcChzZXJ2ZXJfcGFyYW1ldGVycyUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjBhJTIwcmVtZWR5JTIwZm9yJTIwaGFuZ292ZXIuJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel


model = HfApiModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)


server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),Xe=new T({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Re=new hs({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/tools.mdx"}}),{c(){m=a("meta"),g=n(),U=a("p"),f=n(),p(d.$$.fragment),j=n(),p(I.$$.fragment),Fe=n(),v=a("p"),v.innerHTML=pl,qe=n(),G=a("p"),G.innerHTML=Ml,Ye=n(),Z=a("ul"),Z.innerHTML=cl,Le=n(),B=a("p"),B.textContent=hl,ze=n(),$=a("ul"),$.innerHTML=yl,Pe=n(),V=a("p"),V.textContent=ul,De=n(),x=a("p"),x.textContent=dl,Ke=n(),W=a("p"),W.innerHTML=ml,Oe=n(),p(H.$$.fragment),et=n(),X=a("p"),X.innerHTML=gl,tt=n(),A=a("ol"),A.innerHTML=Tl,lt=n(),p(R.$$.fragment),st=n(),Q=a("p"),Q.innerHTML=wl,nt=n(),_=a("p"),_.textContent=fl,ot=n(),k=a("ul"),k.innerHTML=Jl,at=n(),p(S.$$.fragment),it=n(),E=a("img"),rt=n(),p(b.$$.fragment),pt=n(),N=a("p"),N.textContent=jl,Mt=n(),F=a("p"),F.innerHTML=bl,ct=n(),p(q.$$.fragment),ht=n(),p(Y.$$.fragment),yt=n(),L=a("p"),L.innerHTML=Cl,ut=n(),z=a("ul"),z.innerHTML=Il,dt=n(),P=a("p"),P.innerHTML=vl,mt=n(),p(D.$$.fragment),gt=n(),K=a("p"),K.innerHTML=Gl,Tt=n(),O=a("p"),O.textContent=Zl,wt=n(),p(ee.$$.fragment),ft=n(),te=a("p"),te.textContent=Bl,Jt=n(),p(le.$$.fragment),Ut=n(),se=a("p"),se.innerHTML=$l,jt=n(),ne=a("ul"),ne.innerHTML=Vl,bt=n(),oe=a("p"),oe.textContent=xl,Ct=n(),ae=a("ul"),ae.innerHTML=Wl,It=n(),ie=a("p"),ie.textContent=Hl,vt=n(),p(re.$$.fragment),Gt=n(),pe=a("p"),pe.innerHTML=Xl,Zt=n(),Me=a("p"),Me.textContent=Al,Bt=n(),ce=a("p"),ce.textContent=Rl,$t=n(),p(he.$$.fragment),Vt=n(),ye=a("p"),ye.innerHTML=Ql,xt=n(),ue=a("p"),ue.innerHTML=_l,Wt=n(),p(de.$$.fragment),Ht=n(),p(me.$$.fragment),Xt=n(),ge=a("p"),ge.innerHTML=kl,At=n(),p(Te.$$.fragment),Rt=n(),p(we.$$.fragment),Qt=n(),fe=a("p"),fe.innerHTML=Sl,_t=n(),Je=a("p"),Je.innerHTML=El,kt=n(),Ue=a("p"),Ue.textContent=Nl,St=n(),p(je.$$.fragment),Et=n(),p(be.$$.fragment),Nt=n(),Ce=a("p"),Ce.innerHTML=Fl,Ft=n(),Ie=a("p"),Ie.innerHTML=ql,qt=n(),ve=a("p"),ve.innerHTML=Yl,Yt=n(),Ge=a("p"),Ge.textContent=Ll,Lt=n(),p(Ze.$$.fragment),zt=n(),p(Be.$$.fragment),Pt=n(),$e=a("p"),$e.innerHTML=zl,Dt=n(),w=a("details"),Qe=a("summary"),Qe.textContent=Pl,al=n(),_e=a("p"),_e.innerHTML=Dl,il=n(),p(Ve.$$.fragment),Kt=n(),xe=a("p"),xe.textContent=Kl,Ot=n(),p(We.$$.fragment),el=n(),He=a("p"),He.textContent=Ol,tl=n(),p(Xe.$$.fragment),ll=n(),Ae=a("ul"),Ae.innerHTML=es,sl=n(),p(Re.$$.fragment),nl=n(),Se=a("p"),this.h()},l(e){const t=ps("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(l),g=o(e),U=i(e,"P",{}),rl(U).forEach(l),f=o(e),M(d.$$.fragment,e),j=o(e),M(I.$$.fragment,e),Fe=o(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-11yvg4r"&&(v.innerHTML=pl),qe=o(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1w4pglg"&&(G.innerHTML=Ml),Ye=o(e),Z=i(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-6t5tqb"&&(Z.innerHTML=cl),Le=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-xxdm5o"&&(B.textContent=hl),ze=o(e),$=i(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-1y8sxu4"&&($.innerHTML=yl),Pe=o(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1s1gqsf"&&(V.textContent=ul),De=o(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-gwhed0"&&(x.textContent=dl),Ke=o(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1j9zfgm"&&(W.innerHTML=ml),Oe=o(e),M(H.$$.fragment,e),et=o(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-16o4n5p"&&(X.innerHTML=gl),tt=o(e),A=i(e,"OL",{"data-svelte-h":!0}),r(A)!=="svelte-12j65du"&&(A.innerHTML=Tl),lt=o(e),M(R.$$.fragment,e),st=o(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1dh93c8"&&(Q.innerHTML=wl),nt=o(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1hsdx6m"&&(_.textContent=fl),ot=o(e),k=i(e,"UL",{"data-svelte-h":!0}),r(k)!=="svelte-1eycwmn"&&(k.innerHTML=Jl),at=o(e),M(S.$$.fragment,e),it=o(e),E=i(e,"IMG",{src:!0,alt:!0}),rt=o(e),M(b.$$.fragment,e),pt=o(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-5qyq1f"&&(N.textContent=jl),Mt=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1f9djim"&&(F.innerHTML=bl),ct=o(e),M(q.$$.fragment,e),ht=o(e),M(Y.$$.fragment,e),yt=o(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-o654lj"&&(L.innerHTML=Cl),ut=o(e),z=i(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-9qay4f"&&(z.innerHTML=Il),dt=o(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1pi6ccj"&&(P.innerHTML=vl),mt=o(e),M(D.$$.fragment,e),gt=o(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1ugsnpu"&&(K.innerHTML=Gl),Tt=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1t4n8j6"&&(O.textContent=Zl),wt=o(e),M(ee.$$.fragment,e),ft=o(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-148a819"&&(te.textContent=Bl),Jt=o(e),M(le.$$.fragment,e),Ut=o(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1se8fk8"&&(se.innerHTML=$l),jt=o(e),ne=i(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-1n5ilxc"&&(ne.innerHTML=Vl),bt=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-13b0t4l"&&(oe.textContent=xl),Ct=o(e),ae=i(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-3o3ymr"&&(ae.innerHTML=Wl),It=o(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-13o2uyy"&&(ie.textContent=Hl),vt=o(e),M(re.$$.fragment,e),Gt=o(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-bfnw4l"&&(pe.innerHTML=Xl),Zt=o(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-p4tufw"&&(Me.textContent=Al),Bt=o(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-fsw72s"&&(ce.textContent=Rl),$t=o(e),M(he.$$.fragment,e),Vt=o(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1cmmx6"&&(ye.innerHTML=Ql),xt=o(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-2q1hux"&&(ue.innerHTML=_l),Wt=o(e),M(de.$$.fragment,e),Ht=o(e),M(me.$$.fragment,e),Xt=o(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1xtes2g"&&(ge.innerHTML=kl),At=o(e),M(Te.$$.fragment,e),Rt=o(e),M(we.$$.fragment,e),Qt=o(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1mpb2vu"&&(fe.innerHTML=Sl),_t=o(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-lat3p2"&&(Je.innerHTML=El),kt=o(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1694k70"&&(Ue.textContent=Nl),St=o(e),M(je.$$.fragment,e),Et=o(e),M(be.$$.fragment,e),Nt=o(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1osr2dc"&&(Ce.innerHTML=Fl),Ft=o(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-n7r7ow"&&(Ie.innerHTML=ql),qt=o(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-sjrzcz"&&(ve.innerHTML=Yl),Yt=o(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-154co1f"&&(Ge.textContent=Ll),Lt=o(e),M(Ze.$$.fragment,e),zt=o(e),M(Be.$$.fragment,e),Pt=o(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1jvu17l"&&($e.innerHTML=zl),Dt=o(e),w=i(e,"DETAILS",{});var J=rl(w);Qe=i(J,"SUMMARY",{"data-svelte-h":!0}),r(Qe)!=="svelte-17v5fx6"&&(Qe.textContent=Pl),al=o(J),_e=i(J,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1yjphc7"&&(_e.innerHTML=Dl),il=o(J),M(Ve.$$.fragment,J),J.forEach(l),Kt=o(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1ki4qbm"&&(xe.textContent=Kl),Ot=o(e),M(We.$$.fragment,e),el=o(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1yv1f1"&&(He.textContent=Ol),tl=o(e),M(Xe.$$.fragment,e),ll=o(e),Ae=i(e,"UL",{"data-svelte-h":!0}),r(Ae)!=="svelte-1gwl39i"&&(Ae.innerHTML=es),sl=o(e),M(Re.$$.fragment,e),nl=o(e),Se=i(e,"P",{}),rl(Se).forEach(l),this.h()},h(){ke(m,"name","hf:doc:metadata"),ke(m,"content",ds),ns(E.src,Ul="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-catering.jpg")||ke(E,"src",Ul),ke(E,"alt","Alfred Catering")},m(e,t){Ee(document.head,m),s(e,g,t),s(e,U,t),s(e,f,t),c(d,e,t),s(e,j,t),c(I,e,t),s(e,Fe,t),s(e,v,t),s(e,qe,t),s(e,G,t),s(e,Ye,t),s(e,Z,t),s(e,Le,t),s(e,B,t),s(e,ze,t),s(e,$,t),s(e,Pe,t),s(e,V,t),s(e,De,t),s(e,x,t),s(e,Ke,t),s(e,W,t),s(e,Oe,t),c(H,e,t),s(e,et,t),s(e,X,t),s(e,tt,t),s(e,A,t),s(e,lt,t),c(R,e,t),s(e,st,t),s(e,Q,t),s(e,nt,t),s(e,_,t),s(e,ot,t),s(e,k,t),s(e,at,t),c(S,e,t),s(e,it,t),s(e,E,t),s(e,rt,t),c(b,e,t),s(e,pt,t),s(e,N,t),s(e,Mt,t),s(e,F,t),s(e,ct,t),c(q,e,t),s(e,ht,t),c(Y,e,t),s(e,yt,t),s(e,L,t),s(e,ut,t),s(e,z,t),s(e,dt,t),s(e,P,t),s(e,mt,t),c(D,e,t),s(e,gt,t),s(e,K,t),s(e,Tt,t),s(e,O,t),s(e,wt,t),c(ee,e,t),s(e,ft,t),s(e,te,t),s(e,Jt,t),c(le,e,t),s(e,Ut,t),s(e,se,t),s(e,jt,t),s(e,ne,t),s(e,bt,t),s(e,oe,t),s(e,Ct,t),s(e,ae,t),s(e,It,t),s(e,ie,t),s(e,vt,t),c(re,e,t),s(e,Gt,t),s(e,pe,t),s(e,Zt,t),s(e,Me,t),s(e,Bt,t),s(e,ce,t),s(e,$t,t),c(he,e,t),s(e,Vt,t),s(e,ye,t),s(e,xt,t),s(e,ue,t),s(e,Wt,t),c(de,e,t),s(e,Ht,t),c(me,e,t),s(e,Xt,t),s(e,ge,t),s(e,At,t),c(Te,e,t),s(e,Rt,t),c(we,e,t),s(e,Qt,t),s(e,fe,t),s(e,_t,t),s(e,Je,t),s(e,kt,t),s(e,Ue,t),s(e,St,t),c(je,e,t),s(e,Et,t),c(be,e,t),s(e,Nt,t),s(e,Ce,t),s(e,Ft,t),s(e,Ie,t),s(e,qt,t),s(e,ve,t),s(e,Yt,t),s(e,Ge,t),s(e,Lt,t),c(Ze,e,t),s(e,zt,t),c(Be,e,t),s(e,Pt,t),s(e,$e,t),s(e,Dt,t),s(e,w,t),Ee(w,Qe),Ee(w,al),Ee(w,_e),Ee(w,il),c(Ve,w,null),s(e,Kt,t),s(e,xe,t),s(e,Ot,t),c(We,e,t),s(e,el,t),s(e,He,t),s(e,tl,t),c(Xe,e,t),s(e,ll,t),s(e,Ae,t),s(e,sl,t),c(Re,e,t),s(e,nl,t),s(e,Se,t),ol=!0},p(e,[t]){const J={};t&2&&(J.$$scope={dirty:t,ctx:e}),b.$set(J)},i(e){ol||(h(d.$$.fragment,e),h(I.$$.fragment,e),h(H.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(b.$$.fragment,e),h(q.$$.fragment,e),h(Y.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(je.$$.fragment,e),h(be.$$.fragment,e),h(Ze.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Re.$$.fragment,e),ol=!0)},o(e){y(d.$$.fragment,e),y(I.$$.fragment,e),y(H.$$.fragment,e),y(R.$$.fragment,e),y(S.$$.fragment,e),y(b.$$.fragment,e),y(q.$$.fragment,e),y(Y.$$.fragment,e),y(D.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(re.$$.fragment,e),y(he.$$.fragment,e),y(de.$$.fragment,e),y(me.$$.fragment,e),y(Te.$$.fragment,e),y(we.$$.fragment,e),y(je.$$.fragment,e),y(be.$$.fragment,e),y(Ze.$$.fragment,e),y(Be.$$.fragment,e),y(Ve.$$.fragment,e),y(We.$$.fragment,e),y(Xe.$$.fragment,e),y(Re.$$.fragment,e),ol=!1},d(e){e&&(l(g),l(U),l(f),l(j),l(Fe),l(v),l(qe),l(G),l(Ye),l(Z),l(Le),l(B),l(ze),l($),l(Pe),l(V),l(De),l(x),l(Ke),l(W),l(Oe),l(et),l(X),l(tt),l(A),l(lt),l(st),l(Q),l(nt),l(_),l(ot),l(k),l(at),l(it),l(E),l(rt),l(pt),l(N),l(Mt),l(F),l(ct),l(ht),l(yt),l(L),l(ut),l(z),l(dt),l(P),l(mt),l(gt),l(K),l(Tt),l(O),l(wt),l(ft),l(te),l(Jt),l(Ut),l(se),l(jt),l(ne),l(bt),l(oe),l(Ct),l(ae),l(It),l(ie),l(vt),l(Gt),l(pe),l(Zt),l(Me),l(Bt),l(ce),l($t),l(Vt),l(ye),l(xt),l(ue),l(Wt),l(Ht),l(Xt),l(ge),l(At),l(Rt),l(Qt),l(fe),l(_t),l(Je),l(kt),l(Ue),l(St),l(Et),l(Nt),l(Ce),l(Ft),l(Ie),l(qt),l(ve),l(Yt),l(Ge),l(Lt),l(zt),l(Pt),l($e),l(Dt),l(w),l(Kt),l(xe),l(Ot),l(el),l(He),l(tl),l(ll),l(Ae),l(sl),l(nl),l(Se)),l(m),u(d,e),u(I,e),u(H,e),u(R,e),u(S,e),u(b,e),u(q,e),u(Y,e),u(D,e),u(ee,e),u(le,e),u(re,e),u(he,e),u(de,e),u(me,e),u(Te,e),u(we,e),u(je,e),u(be,e),u(Ze,e),u(Be,e),u(Ve),u(We,e),u(Xe,e),u(Re,e)}}}const ds='{"title":"Tools","local":"tools","sections":[{"title":"Tool Creation Methods","local":"tool-creation-methods","sections":[{"title":"The @tool Decorator","local":"the-tool-decorator","sections":[{"title":"Generating a tool that retrieves the highest-rated catering","local":"generating-a-tool-that-retrieves-the-highest-rated-catering","sections":[],"depth":4}],"depth":3},{"title":"Defining a Tool as a Python Class","local":"defining-a-tool-as-a-python-class","sections":[{"title":"Generating a tool to generate ideas about the superhero-themed party","local":"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Default Toolbox","local":"default-toolbox","sections":[],"depth":2},{"title":"Sharing and Importing Tools","local":"sharing-and-importing-tools","sections":[{"title":"Sharing a Tool to the Hub","local":"sharing-a-tool-to-the-hub","sections":[],"depth":3},{"title":"Importing a Tool from the Hub","local":"importing-a-tool-from-the-hub","sections":[],"depth":3},{"title":"Importing a Hugging Face Space as a Tool","local":"importing-a-hugging-face-space-as-a-tool","sections":[],"depth":3},{"title":"Importing a LangChain Tool","local":"importing-a-langchain-tool","sections":[],"depth":3},{"title":"Importing a tool collection from any MCP server","local":"importing-a-tool-collection-from-any-mcp-server","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function ms(Ne){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends is{constructor(m){super(),rs(this,m,ms,us,ss,{})}}export{bs as component};
