import{s as $t,n as It,o as Ct}from"../chunks/scheduler.85c25b89.js";import{S as Wt,i as Bt,g as p,s as a,r as i,A as Nt,h as m,f as e,c as n,j as Zt,u as o,x as r,k as kt,y as vt,a as l,v as c,d as h,t as M,w as j}from"../chunks/index.c9bcf812.js";import{C as Q}from"../chunks/CodeBlock.94efc595.js";import{H as A}from"../chunks/Heading.3c6e5b17.js";function Et(Mt){let g,R,_,Y,d,H,w,jt='<strong>VoVNet</strong> is a convolutional neural network that seeks to make <a href="https://paperswithcode.com/method/densenet" rel="nofollow">DenseNet</a> more efficient by concatenating all features only once in the last feature map, which makes input size constant and enables enlarging new output channel.',S,J,gt='Read about <a href="https://paperswithcode.com/method/one-shot-aggregation" rel="nofollow">one-shot aggregation here</a>.',z,y,F,u,dt="To load a pretrained model:",L,T,D,b,wt="To load and preprocess the image:",P,f,q,U,Jt="To get the model predictions:",K,Z,O,k,yt="To get the top-5 predictions class names:",tt,$,st,I,ut="Replace the model name with the variant you want to use, e.g. <code>ese_vovnet19b_dw</code>. You can find the IDs in the model summaries at the top of this page.",et,C,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',lt,W,at,B,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",nt,N,pt,v,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,E,it,G,Ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ot,x,rt,V,ct,X,ht;return d=new A({props:{title:"ESE-VoVNet",local:"ese-vovnet",headingTag:"h1"}}),y=new A({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2VzZV92b3ZuZXQxOWJfZHcnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),Z=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new A({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZXNlX3Zvdm5ldDE5Yl9kdyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new A({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),x=new A({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new Q({props:{code:"JTQwbWlzYyU3QmxlZTIwMTllbmVyZ3klMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkFuJTIwRW5lcmd5JTIwYW5kJTIwR1BVLUNvbXB1dGF0aW9uJTIwRWZmaWNpZW50JTIwQmFja2JvbmUlMjBOZXR3b3JrJTIwZm9yJTIwUmVhbC1UaW1lJTIwT2JqZWN0JTIwRGV0ZWN0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCWW91bmd3YW4lMjBMZWUlMjBhbmQlMjBKb29uZy13b24lMjBId2FuZyUyMGFuZCUyMFNhbmdyb2slMjBMZWUlMjBhbmQlMjBZdXNlb2slMjBCYWUlMjBhbmQlMjBKb25neW91bCUyMFBhcmslN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE5MDQuMDk3MzAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{lee2019energy,
      title={An Energy <span class="hljs-keyword">and </span>GPU-Computation Efficient <span class="hljs-keyword">Backbone </span>Network for Real-Time Object Detection}, 
      author={Youngwan Lee <span class="hljs-keyword">and </span><span class="hljs-keyword">Joong-won </span>Hwang <span class="hljs-keyword">and </span>Sangrok Lee <span class="hljs-keyword">and </span>Yuseok <span class="hljs-keyword">Bae </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Jongyoul </span>Park},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">09730</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){g=p("meta"),R=a(),_=p("p"),Y=a(),i(d.$$.fragment),H=a(),w=p("p"),w.innerHTML=jt,S=a(),J=p("p"),J.innerHTML=gt,z=a(),i(y.$$.fragment),F=a(),u=p("p"),u.textContent=dt,L=a(),i(T.$$.fragment),D=a(),b=p("p"),b.textContent=wt,P=a(),i(f.$$.fragment),q=a(),U=p("p"),U.textContent=Jt,K=a(),i(Z.$$.fragment),O=a(),k=p("p"),k.textContent=yt,tt=a(),i($.$$.fragment),st=a(),I=p("p"),I.innerHTML=ut,et=a(),C=p("p"),C.innerHTML=Tt,lt=a(),i(W.$$.fragment),at=a(),B=p("p"),B.textContent=bt,nt=a(),i(N.$$.fragment),pt=a(),v=p("p"),v.innerHTML=ft,mt=a(),i(E.$$.fragment),it=a(),G=p("p"),G.innerHTML=Ut,ot=a(),i(x.$$.fragment),rt=a(),i(V.$$.fragment),ct=a(),X=p("p"),this.h()},l(t){const s=Nt("svelte-u9bgzb",document.head);g=m(s,"META",{name:!0,content:!0}),s.forEach(e),R=n(t),_=m(t,"P",{}),Zt(_).forEach(e),Y=n(t),o(d.$$.fragment,t),H=n(t),w=m(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-13oc2jm"&&(w.innerHTML=jt),S=n(t),J=m(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1ajn3h8"&&(J.innerHTML=gt),z=n(t),o(y.$$.fragment,t),F=n(t),u=m(t,"P",{"data-svelte-h":!0}),r(u)!=="svelte-18ywhxh"&&(u.textContent=dt),L=n(t),o(T.$$.fragment,t),D=n(t),b=m(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1c2ipa8"&&(b.textContent=wt),P=n(t),o(f.$$.fragment,t),q=n(t),U=m(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1n9qsq1"&&(U.textContent=Jt),K=n(t),o(Z.$$.fragment,t),O=n(t),k=m(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-19cnvx1"&&(k.textContent=yt),tt=n(t),o($.$$.fragment,t),st=n(t),I=m(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-yryjra"&&(I.innerHTML=ut),et=n(t),C=m(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1wmi3ea"&&(C.innerHTML=Tt),lt=n(t),o(W.$$.fragment,t),at=n(t),B=m(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9sr7nh"&&(B.textContent=bt),nt=n(t),o(N.$$.fragment,t),pt=n(t),v=m(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1kguc51"&&(v.innerHTML=ft),mt=n(t),o(E.$$.fragment,t),it=n(t),G=m(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1n0coha"&&(G.innerHTML=Ut),ot=n(t),o(x.$$.fragment,t),rt=n(t),o(V.$$.fragment,t),ct=n(t),X=m(t,"P",{}),Zt(X).forEach(e),this.h()},h(){kt(g,"name","hf:doc:metadata"),kt(g,"content",Gt)},m(t,s){vt(document.head,g),l(t,R,s),l(t,_,s),l(t,Y,s),c(d,t,s),l(t,H,s),l(t,w,s),l(t,S,s),l(t,J,s),l(t,z,s),c(y,t,s),l(t,F,s),l(t,u,s),l(t,L,s),c(T,t,s),l(t,D,s),l(t,b,s),l(t,P,s),c(f,t,s),l(t,q,s),l(t,U,s),l(t,K,s),c(Z,t,s),l(t,O,s),l(t,k,s),l(t,tt,s),c($,t,s),l(t,st,s),l(t,I,s),l(t,et,s),l(t,C,s),l(t,lt,s),c(W,t,s),l(t,at,s),l(t,B,s),l(t,nt,s),c(N,t,s),l(t,pt,s),l(t,v,s),l(t,mt,s),c(E,t,s),l(t,it,s),l(t,G,s),l(t,ot,s),c(x,t,s),l(t,rt,s),c(V,t,s),l(t,ct,s),l(t,X,s),ht=!0},p:It,i(t){ht||(h(d.$$.fragment,t),h(y.$$.fragment,t),h(T.$$.fragment,t),h(f.$$.fragment,t),h(Z.$$.fragment,t),h($.$$.fragment,t),h(W.$$.fragment,t),h(N.$$.fragment,t),h(E.$$.fragment,t),h(x.$$.fragment,t),h(V.$$.fragment,t),ht=!0)},o(t){M(d.$$.fragment,t),M(y.$$.fragment,t),M(T.$$.fragment,t),M(f.$$.fragment,t),M(Z.$$.fragment,t),M($.$$.fragment,t),M(W.$$.fragment,t),M(N.$$.fragment,t),M(E.$$.fragment,t),M(x.$$.fragment,t),M(V.$$.fragment,t),ht=!1},d(t){t&&(e(R),e(_),e(Y),e(H),e(w),e(S),e(J),e(z),e(F),e(u),e(L),e(D),e(b),e(P),e(q),e(U),e(K),e(O),e(k),e(tt),e(st),e(I),e(et),e(C),e(lt),e(at),e(B),e(nt),e(pt),e(v),e(mt),e(it),e(G),e(ot),e(rt),e(ct),e(X)),e(g),j(d,t),j(y,t),j(T,t),j(f,t),j(Z,t),j($,t),j(W,t),j(N,t),j(E,t),j(x,t),j(V,t)}}}const Gt='{"title":"ESE-VoVNet","local":"ese-vovnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xt(Mt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Wt{constructor(g){super(),Bt(this,g,xt,Et,$t,{})}}export{At as component};
