# কোর্সের উপাদান সম্পর্কে আপনার উপলব্ধি পরীক্ষা করুন

### ১. Sampling Rate কোন এককে পরিমাপ করা হয়?

<Question
	choices={[
		{
			text: "dB",
			explain: "না, amplitude ডেসিবেলে (dB) পরিমাপ করা হয়।"
		},
		{
			text: "Hz",
			explain: "Sampling Rate হল এক সেকেন্ডে নেওয়া নমুনার সংখ্যা এবং হার্টজ (Hz) এ পরিমাপ করা হয়।",
			correct: true
		},
		{
			text: "bit",
			explain: "bit, bit depth বর্ণনা করতে ব্যবহৃত হয়, যা একটি অডিও সংকেতের প্রতিটি নমুনাকে উপস্থাপন করতে ব্যবহৃত তথ্যের বিটের সংখ্যা বোঝায়।",
		}
	]}
/>

### ২. একটি বড় অডিও ডেটাসেট স্ট্রিম করার সময়, আপনি কত তাড়াতাড়ি এটি ব্যবহার করা শুরু করতে পারেন?

<Question
	choices={[
		{
			text: "সম্পূর্ণ ডেটাসেট ডাউনলোড হওয়ার সাথে সাথে।",
			explain: "ডেটা স্ট্রিমিংয়ের লক্ষ্য হল একটি ডেটাসেট সম্পূর্ণরূপে ডাউনলোড না করেই এটির সাথে কাজ করতে সক্ষম হওয়া।"
		},
		{
			text: "যত তাড়াতাড়ি প্রথম ১৬টি  উদাহরণ ডাউনলোড করা হয়।",
			explain: "আবার চেষ্টা করুন!"
		},
		{
			text: "যত তাড়াতাড়ি প্রথম উদাহরণ ডাউনলোড করা হয়।",
			explain: "",
			correct: true
		}
	]}
/>

### ৩. spectrogram কি ?

<Question
	choices={[
		{
			text: "অডিও ডিজিটাইজ করতে ব্যবহৃত একটি ডিভাইস যা প্রথমে একটি মাইক্রোফোন দ্বারা ক্যাপচার করা হয়, যা শব্দ তরঙ্গকে বৈদ্যুতিক সংকেতে রূপান্তরিত করে।",
			explain: "এই ধরনের বৈদ্যুতিক সংকেত ডিজিটাইজ করার জন্য ব্যবহৃত একটি ডিভাইসকে বলা হয় অ্যানালগ-টু-ডিজিটাল কনভার্টার। আবার চেষ্টা কর!"
		},
		{
			text: "একটি প্লট যা দেখায় কিভাবে একটি অডিও সংকেতের amplitude সময়ের সাথে পরিবর্তিত হয়। এটি শব্দের *time domain* উপস্থাপনা হিসাবেও পরিচিত।",
			explain: "উপরের বর্ণনাটি waveform বোঝায়, spectrogram নয়।"
		},
		{
			text: "একটি সিগন্যালের ফ্রিকোয়েন্সি বর্ণালীর একটি ভিজ্যুয়াল উপস্থাপনা কারণ এটি সময়ের সাথে পরিবর্তিত হয়।",
			explain: "",
			correct: true
		}
	]}
/>

### ৪. Whisper দ্বারা প্রত্যাশিত লগ-মেল স্পেকট্রোগ্রামে, কাঁচা অডিও ডেটা রূপান্তর করার সবচেয়ে সহজ উপায় কী?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

<Question
	choices={[
		{
			text: "A",
			explain: "`librosa.feature.melspectrogram()` পাওয়ার স্পেক্ট্রোগ্রাম তৈরী করে।"
		},
		{
			text: "B",
			explain: "",
			correct: true
		},
		{
			text: "C",
			explain: "ডেটাসেট ট্রান্সফরমার মডেলের জন্য ফিচারস প্রস্তুত করে না, এটি মডেলের প্রিপ্রসেসর দ্বারা করা হয়।"
		}
	]}
/>

### ৫. আপনি কিভাবে 🤗 হাব থেকে একটি ডেটাসেট লোড করবেন?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

<Question
	choices={[
		{
			text: "A",
			explain: "সবচেয়ে ভালো উপায় হল 🤗 ডেটাসেট লাইব্রেরি ব্যবহার করা।",
			correct: true
		},
		{
			text: "B",
			explain: "Librosa.load স্যাম্পলিং রেট সহ একটি পাথ থেকে একটি পৃথক অডিও ফাইল লোড করতে উপযোগী, কিন্তু অনেক উদাহরণ এবং একাধিক বৈশিষ্ট্য সহ একটি সম্পূর্ণ ডেটাসেট নয়।"
		},
		{
			text: "C",
			explain: "load_dataset পদ্ধতি 🤗 ডেটাসেট লাইব্রেরিতে আসে, 🤗 ট্রান্সফরমারে নয়।"
		}
	]}
/>

### ৬. আপনার কাস্টম ডেটাসেটে ৩২ kHz sampling rate সহ উচ্চ-মানের অডিও রয়েছে৷ আপনি একটি speech recognition মডেলকে train করতে চান যা আশা করে যে অডিও উদাহরণগুলির একটি ১৬ খজ sampling rate থাকবে। তোমার কি করা উচিত?

<Question
	choices={[
		{
			text: "উদাহরণগুলি যেমন ব্যবহার করুন, মডেলটি সহজেই উচ্চ মানের অডিও উদাহরণে সাধারণীকরণ করবে।",
			explain: "attention mechanism এর উপর নির্ভরতার কারণে, মডেলগুলির জন্য নমুনা হারের মধ্যে সাধারণীকরণ করা চ্যালেঞ্জিং।"
		},
		{
			text: "কাস্টম ডেটাসেটের উদাহরণগুলি ডাউন নমুনা করতে 🤗 ডেটাসেট লাইব্রেরি থেকে Audio মডিউল ব্যবহার করুন।  ",
			explain: "",
			correct: true
		},
		{
			text: "প্রতি দ্বিতীয় নমুনা ফেলে দিয়ে একটি গুণনীয়ক ২x দ্বারা ডাউন নমুনা।",
			explain: "এটি সিগন্যালে বিকৃতি তৈরি করবে। সঠিকভাবে পুনরায় নমুনা তৈরি করা কঠিন এবং ভাল-পরীক্ষিত লাইব্রেরি যেমন librosa বা 🤗 datasets গুলোর উপরে ছেড়ে দেওয়া ভালো।"
		}
	]}
/>

### ৭. আপনি কিভাবে একটি মেশিন লার্নিং মডেল দ্বারা উত্পন্ন একটি spectrogram কে একটি waveform এ রূপান্তর করতে পারেন?

<Question
	choices={[
		{
			text: "আমরা স্পেকট্রোগ্রাম থেকে একটি waveform পুনর্গঠন করতে vocoder নামে একটি নিউরাল নেটওয়ার্ক ব্যবহার করতে পারি।",
			explain: "যেহেতু এই ক্ষেত্রে ফেজের তথ্য অনুপস্থিত, তাই তরঙ্গরূপ পুনর্গঠনের জন্য আমাদের একটি vocodder বা ক্লাসিক Griffin-Lim অ্যালগরিদম ব্যবহার করতে হবে।",
			correct: true
		},
		{
			text: "উৎপন্ন স্পেকট্রোগ্রামকে তরঙ্গরূপে রূপান্তর করতে আমরা inverse STFT ব্যবহার করতে পারি। ",
			explain: "একটি জেনারেট করা spectrogram এ ফেজ তথ্য অনুপস্থিত রয়েছে যা inverse STFT ব্যবহার করার জন্য প্রয়োজন।"
		},
		{
			text: "আপনি একটি মেশিন লার্নিং মডেল দ্বারা উত্পন্ন একটি spectrogram কে waveform এ রূপান্তর করতে পারবেন না।",
			explain: "আবার চেষ্টা করুন!"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/bn/chapter1/quiz.mdx" />