import{s as O,a as D,n as ee,o as te}from"../chunks/scheduler.cd324960.js";import{S as ae,i as le,e as p,s as n,c as b,h as se,a as m,d as a,b as i,f as Y,g as $,j as S,k as r,l as ne,m as l,n as T,t as J,o as U,p as G}from"../chunks/index.d5c3adcc.js";import{C as ie,H as oe,E as re}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.5025912f.js";import{C as X}from"../chunks/CodeBlock.12aa859f.js";function pe(q){let o,B,_,x,c,C,d,I,u,z=`In this final section on audio classification, we’ll build a <a href="https://gradio.app" rel="nofollow">Gradio</a> demo to showcase the music
classification model that we just trained on the <a href="https://huggingface.co/datasets/marsyas/gtzan" rel="nofollow">GTZAN</a> dataset. The first
thing to do is load up the fine-tuned checkpoint using the <code>pipeline()</code> class - this is very familiar now from the section
on <a href="classification_models">pre-trained models</a>. You can change the <code>model_id</code> to the namespace of your fine-tuned model
on the Hugging Face Hub:`,R,f,W,h,F=`Secondly, we’ll define a function that takes the filepath for an audio input and passes it through the pipeline. Here,
the pipeline automatically takes care of loading the audio file, resampling it to the correct sampling rate, and running
inference with the model. We take the models predictions of <code>preds</code> and format them as a dictionary object to be displayed on the
output:`,v,w,Z,M,L="Finally, we launch the Gradio demo using the function we’ve just defined:",H,y,Q,g,P="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",V,s,K,A,j,E,k,N;return c=new ie({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new oe({props:{title:"Build a demo with Gradio",local:"build-a-demo-with-gradio",headingTag:"h1"}}),f=new X({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzYW5jaGl0LWdhbmRoaSUyRmRpc3RpbGh1YmVydC1maW5ldHVuZWQtZ3R6YW4lMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model_id = <span class="hljs-string">&quot;sanchit-gandhi/distilhubert-finetuned-gtzan&quot;</span>
pipe = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model_id)`,wrap:!1}}),w=new X({props:{code:"ZGVmJTIwY2xhc3NpZnlfYXVkaW8oZmlsZXBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZHMlMjAlM0QlMjBwaXBlKGZpbGVwYXRoKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjAlN0IlN0QlMEElMjAlMjAlMjAlMjBmb3IlMjBwJTIwaW4lMjBwcmVkcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlNUJwJTVCJTIybGFiZWwlMjIlNUQlNUQlMjAlM0QlMjBwJTVCJTIyc2NvcmUlMjIlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_audio</span>(<span class="hljs-params">filepath</span>):
    preds = pipe(filepath)
    outputs = {}
    <span class="hljs-keyword">for</span> p <span class="hljs-keyword">in</span> preds:
        outputs[p[<span class="hljs-string">&quot;label&quot;</span>]] = p[<span class="hljs-string">&quot;score&quot;</span>]
    <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),y=new X({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RjbGFzc2lmeV9hdWRpbyUyQyUyMGlucHV0cyUzRGdyLkF1ZGlvKHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMjBvdXRwdXRzJTNEZ3Iub3V0cHV0cy5MYWJlbCgpJTBBKSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Interface(
    fn=classify_audio, inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>), outputs=gr.outputs.Label()
)
demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),j=new re({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter4/demo.mdx"}}),{c(){o=p("meta"),B=n(),_=p("p"),x=n(),b(c.$$.fragment),C=n(),b(d.$$.fragment),I=n(),u=p("p"),u.innerHTML=z,R=n(),b(f.$$.fragment),W=n(),h=p("p"),h.innerHTML=F,v=n(),b(w.$$.fragment),Z=n(),M=p("p"),M.textContent=L,H=n(),b(y.$$.fragment),Q=n(),g=p("p"),g.textContent=P,V=n(),s=p("iframe"),A=n(),b(j.$$.fragment),E=n(),k=p("p"),this.h()},l(e){const t=se("svelte-u9bgzb",document.head);o=m(t,"META",{name:!0,content:!0}),t.forEach(a),B=i(e),_=m(e,"P",{}),Y(_).forEach(a),x=i(e),$(c.$$.fragment,e),C=i(e),$(d.$$.fragment,e),I=i(e),u=m(e,"P",{"data-svelte-h":!0}),S(u)!=="svelte-1r0764x"&&(u.innerHTML=z),R=i(e),$(f.$$.fragment,e),W=i(e),h=m(e,"P",{"data-svelte-h":!0}),S(h)!=="svelte-1o13rj8"&&(h.innerHTML=F),v=i(e),$(w.$$.fragment,e),Z=i(e),M=m(e,"P",{"data-svelte-h":!0}),S(M)!=="svelte-rqn9c6"&&(M.textContent=L),H=i(e),$(y.$$.fragment,e),Q=i(e),g=m(e,"P",{"data-svelte-h":!0}),S(g)!=="svelte-10sf4ix"&&(g.textContent=P),V=i(e),s=m(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),Y(s).forEach(a),A=i(e),$(j.$$.fragment,e),E=i(e),k=m(e,"P",{}),Y(k).forEach(a),this.h()},h(){r(o,"name","hf:doc:metadata"),r(o,"content",me),D(s.src,K="https://course-demos-song-classifier.hf.space")||r(s,"src",K),r(s,"frameborder","0"),r(s,"height","450"),r(s,"title","Gradio app"),r(s,"class","container p-0 flex-grow space-iframe"),r(s,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),r(s,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){ne(document.head,o),l(e,B,t),l(e,_,t),l(e,x,t),T(c,e,t),l(e,C,t),T(d,e,t),l(e,I,t),l(e,u,t),l(e,R,t),T(f,e,t),l(e,W,t),l(e,h,t),l(e,v,t),T(w,e,t),l(e,Z,t),l(e,M,t),l(e,H,t),T(y,e,t),l(e,Q,t),l(e,g,t),l(e,V,t),l(e,s,t),l(e,A,t),T(j,e,t),l(e,E,t),l(e,k,t),N=!0},p:ee,i(e){N||(J(c.$$.fragment,e),J(d.$$.fragment,e),J(f.$$.fragment,e),J(w.$$.fragment,e),J(y.$$.fragment,e),J(j.$$.fragment,e),N=!0)},o(e){U(c.$$.fragment,e),U(d.$$.fragment,e),U(f.$$.fragment,e),U(w.$$.fragment,e),U(y.$$.fragment,e),U(j.$$.fragment,e),N=!1},d(e){e&&(a(B),a(_),a(x),a(C),a(I),a(u),a(R),a(W),a(h),a(v),a(Z),a(M),a(H),a(Q),a(g),a(V),a(s),a(A),a(E),a(k)),a(o),G(c,e),G(d,e),G(f,e),G(w,e),G(y,e),G(j,e)}}}const me='{"title":"Build a demo with Gradio","local":"build-a-demo-with-gradio","sections":[],"depth":1}';function ce(q){return te(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class we extends ae{constructor(o){super(),le(this,o,ce,pe,O,{})}}export{we as component};
