import{s as be,a as Ce,n as Ie,o as Ae}from"../chunks/scheduler.cd324960.js";import{S as We,i as $e,e as i,s,c as x,h as ve,a as o,d as l,b as n,f as re,g as Z,j as r,k as c,l as xe,m as a,n as G,t as _,o as k,p as B}from"../chunks/index.d5c3adcc.js";import{C as Ze,H as Ge,E as _e}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.5025912f.js";import{C as pe}from"../chunks/CodeBlock.12aa859f.js";function ke(ue){let u,H,E,Y,m,Q,M,V,d,ce=`Now that we’ve fine-tuned a Whisper model for Dhivehi speech recognition, let’s go ahead and build a <a href="https://gradio.app" rel="nofollow">Gradio</a>
demo to showcase it to the community!`,R,h,me=`The first thing to do is load up the fine-tuned checkpoint using the <code>pipeline()</code> class - this is very familiar now from
the section on <a href="asr_models">pre-trained models</a>. You can change the <code>model_id</code> to the namespace of your fine-tuned
model on the Hugging Face Hub, or one of the pre-trained <a href="https://huggingface.co/models?sort=downloads&amp;search=openai%2Fwhisper-" rel="nofollow">Whisper models</a>
to perform zero-shot speech recognition:`,N,y,z,w,Me=`Secondly, we’ll define a function that takes the filepath for an audio input and passes it through the pipeline. Here,
the pipeline automatically takes care of loading the audio file, resampling it to the correct sampling rate, and running
inference with the model. We can then simply return the transcribed text as the output of the function. To ensure our
model can handle audio inputs of arbitrary length, we’ll enable <em>chunking</em> as described in the section
on <a href="asr_models">pre-trained models</a>:`,q,f,X,j,de=`We’ll use the Gradio <a href="https://gradio.app/docs/#blocks" rel="nofollow">blocks</a> feature to launch two tabs on our demo: one for microphone
transcription, and the other for file upload.`,F,U,P,T,he="Finally, we launch the Gradio demo using the two blocks that we’ve just defined:",L,J,K,g,ye="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",D,p,we,O,b,fe="Should you wish to host your demo on the Hugging Face Hub, you can use this Space as a template for your fine-tuned model.",ee,C,je='Click the link to duplicate the template demo to your account: <a href="https://huggingface.co/spaces/course-demos/whisper-small?duplicate=true" rel="nofollow">https://huggingface.co/spaces/course-demos/whisper-small?duplicate=true</a>',te,I,Ue="We recommend giving your space a similar name to your fine-tuned model (e.g. whisper-small-dv-demo) and setting the visibility to “Public”.",le,A,Te=`Once you’ve duplicated the Space to your account, click “Files and versions” -> “app.py” -> “edit”. Then change the
model identifier to your fine-tuned model (line 6). Scroll to the bottom of the page and click “Commit changes to main”.
The demo will reboot, this time using your fine-tuned model. You can share this demo with your friends and family so that
they can use the model that you’ve trained!`,ae,W,Je='Checkout our video tutorial to get a better understanding of how to duplicate the Space 👉️ <a href="https://www.youtube.com/watch?v=VQYuvl6-9VE" rel="nofollow">YouTube Video</a>',se,$,ge="We look forward to seeing your demos on the Hub!",ne,v,ie,S,oe;return m=new Ze({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),M=new Ge({props:{title:"Build a demo with Gradio",local:"build-a-demo-with-gradio",headingTag:"h1"}}),y=new pe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzYW5jaGl0LWdhbmRoaSUyRndoaXNwZXItc21hbGwtZHYlMjIlMjAlMjAlMjMlMjB1cGRhdGUlMjB3aXRoJTIweW91ciUyMG1vZGVsJTIwaWQlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model_id = <span class="hljs-string">&quot;sanchit-gandhi/whisper-small-dv&quot;</span>  <span class="hljs-comment"># update with your model id</span>
pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model_id)`,wrap:!1}}),f=new pe({props:{code:"ZGVmJTIwdHJhbnNjcmliZV9zcGVlY2goZmlsZXBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmaWxlcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zY3JpYmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5ndWFnZSUyMiUzQSUyMCUyMnNpbmhhbGVzZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUyMCUyMyUyMHVwZGF0ZSUyMHdpdGglMjB0aGUlMjBsYW5ndWFnZSUyMHlvdSd2ZSUyMGZpbmUtdHVuZWQlMjBvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNodW5rX2xlbmd0aF9zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXQlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_speech</span>(<span class="hljs-params">filepath</span>):
    output = pipe(
        filepath,
        max_new_tokens=<span class="hljs-number">256</span>,
        generate_kwargs={
            <span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>,
            <span class="hljs-string">&quot;language&quot;</span>: <span class="hljs-string">&quot;sinhalese&quot;</span>,
        },  <span class="hljs-comment"># update with the language you&#x27;ve fine-tuned on</span>
        chunk_length_s=<span class="hljs-number">30</span>,
        batch_size=<span class="hljs-number">8</span>,
    )
    <span class="hljs-keyword">return</span> output[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),U=new pe({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQW1pY190cmFuc2NyaWJlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEdHJhbnNjcmliZV9zcGVlY2glMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyhzb3VyY2VzJTNEJTIybWljcm9waG9uZSUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuY29tcG9uZW50cy5UZXh0Ym94KCklMkMlMEEpJTBBJTBBZmlsZV90cmFuc2NyaWJlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEdHJhbnNjcmliZV9zcGVlY2glMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyhzb3VyY2VzJTNEJTIydXBsb2FkJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyKSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0Rnci5jb21wb25lbnRzLlRleHRib3goKSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Blocks()

mic_transcribe = gr.Interface(
    fn=transcribe_speech,
    inputs=gr.Audio(sources=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.components.Textbox(),
)

file_transcribe = gr.Interface(
    fn=transcribe_speech,
    inputs=gr.Audio(sources=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.components.Textbox(),
)`,wrap:!1}}),J=new pe({props:{code:"d2l0aCUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjBnci5UYWJiZWRJbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCbWljX3RyYW5zY3JpYmUlMkMlMjBmaWxlX3RyYW5zY3JpYmUlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMjJUcmFuc2NyaWJlJTIwTWljcm9waG9uZSUyMiUyQyUyMCUyMlRyYW5zY3JpYmUlMjBBdWRpbyUyMEZpbGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBZGVtby5sYXVuY2goZGVidWclM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">with</span> demo:
    gr.TabbedInterface(
        [mic_transcribe, file_transcribe],
        [<span class="hljs-string">&quot;Transcribe Microphone&quot;</span>, <span class="hljs-string">&quot;Transcribe Audio File&quot;</span>],
    )

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new _e({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter5/demo.mdx"}}),{c(){u=i("meta"),H=s(),E=i("p"),Y=s(),x(m.$$.fragment),Q=s(),x(M.$$.fragment),V=s(),d=i("p"),d.innerHTML=ce,R=s(),h=i("p"),h.innerHTML=me,N=s(),x(y.$$.fragment),z=s(),w=i("p"),w.innerHTML=Me,q=s(),x(f.$$.fragment),X=s(),j=i("p"),j.innerHTML=de,F=s(),x(U.$$.fragment),P=s(),T=i("p"),T.textContent=he,L=s(),x(J.$$.fragment),K=s(),g=i("p"),g.textContent=ye,D=s(),p=i("iframe"),O=s(),b=i("p"),b.textContent=fe,ee=s(),C=i("p"),C.innerHTML=je,te=s(),I=i("p"),I.textContent=Ue,le=s(),A=i("p"),A.textContent=Te,ae=s(),W=i("p"),W.innerHTML=Je,se=s(),$=i("p"),$.textContent=ge,ne=s(),x(v.$$.fragment),ie=s(),S=i("p"),this.h()},l(e){const t=ve("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),H=n(e),E=o(e,"P",{}),re(E).forEach(l),Y=n(e),Z(m.$$.fragment,e),Q=n(e),Z(M.$$.fragment,e),V=n(e),d=o(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1q95dto"&&(d.innerHTML=ce),R=n(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-ldnoqw"&&(h.innerHTML=me),N=n(e),Z(y.$$.fragment,e),z=n(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-g873e4"&&(w.innerHTML=Me),q=n(e),Z(f.$$.fragment,e),X=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-wlltyj"&&(j.innerHTML=de),F=n(e),Z(U.$$.fragment,e),P=n(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1s2jh73"&&(T.textContent=he),L=n(e),Z(J.$$.fragment,e),K=n(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-10sf4ix"&&(g.textContent=ye),D=n(e),p=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),re(p).forEach(l),O=n(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-ojipak"&&(b.textContent=fe),ee=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1uiun01"&&(C.innerHTML=je),te=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1oyez0p"&&(I.textContent=Ue),le=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-7essz6"&&(A.textContent=Te),ae=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-9wesld"&&(W.innerHTML=Je),se=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1v4hd0t"&&($.textContent=ge),ne=n(e),Z(v.$$.fragment,e),ie=n(e),S=o(e,"P",{}),re(S).forEach(l),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",Be),Ce(p.src,we="https://course-demos-whisper-small.hf.space")||c(p,"src",we),c(p,"frameborder","0"),c(p,"height","450"),c(p,"title","Gradio app"),c(p,"class","container p-0 flex-grow space-iframe"),c(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),c(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){xe(document.head,u),a(e,H,t),a(e,E,t),a(e,Y,t),G(m,e,t),a(e,Q,t),G(M,e,t),a(e,V,t),a(e,d,t),a(e,R,t),a(e,h,t),a(e,N,t),G(y,e,t),a(e,z,t),a(e,w,t),a(e,q,t),G(f,e,t),a(e,X,t),a(e,j,t),a(e,F,t),G(U,e,t),a(e,P,t),a(e,T,t),a(e,L,t),G(J,e,t),a(e,K,t),a(e,g,t),a(e,D,t),a(e,p,t),a(e,O,t),a(e,b,t),a(e,ee,t),a(e,C,t),a(e,te,t),a(e,I,t),a(e,le,t),a(e,A,t),a(e,ae,t),a(e,W,t),a(e,se,t),a(e,$,t),a(e,ne,t),G(v,e,t),a(e,ie,t),a(e,S,t),oe=!0},p:Ie,i(e){oe||(_(m.$$.fragment,e),_(M.$$.fragment,e),_(y.$$.fragment,e),_(f.$$.fragment,e),_(U.$$.fragment,e),_(J.$$.fragment,e),_(v.$$.fragment,e),oe=!0)},o(e){k(m.$$.fragment,e),k(M.$$.fragment,e),k(y.$$.fragment,e),k(f.$$.fragment,e),k(U.$$.fragment,e),k(J.$$.fragment,e),k(v.$$.fragment,e),oe=!1},d(e){e&&(l(H),l(E),l(Y),l(Q),l(V),l(d),l(R),l(h),l(N),l(z),l(w),l(q),l(X),l(j),l(F),l(P),l(T),l(L),l(K),l(g),l(D),l(p),l(O),l(b),l(ee),l(C),l(te),l(I),l(le),l(A),l(ae),l(W),l(se),l($),l(ne),l(ie),l(S)),l(u),B(m,e),B(M,e),B(y,e),B(f,e),B(U,e),B(J,e),B(v,e)}}}const Be='{"title":"Build a demo with Gradio","local":"build-a-demo-with-gradio","sections":[],"depth":1}';function Ee(ue){return Ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ve extends We{constructor(u){super(),$e(this,u,Ee,ke,be,{})}}export{Ve as component};
