import{s as la,o as sa}from"../chunks/scheduler.cd324960.js";import{S as na,i as aa,e as i,s as n,c as p,h as ia,a as o,d as l,b as a,f as Pn,g as c,j as r,k as Kn,l as oa,m as s,n as h,t as d,o as M,p as u,q as ea,r as ta}from"../chunks/index.d5c3adcc.js";import{T as On}from"../chunks/Tip.889bec11.js";import{C as ra,H as T,E as pa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.5025912f.js";import{C as m}from"../chunks/CodeBlock.12aa859f.js";function ca(Ct){let y;return{c(){y=ea('You can change the language identifier from `"dv"` to a language identifier of your choice. To see all possible languages\n    in Common Voice 13, check out the dataset card on the Hugging Face Hub: https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},l(w){y=ta(w,'You can change the language identifier from `"dv"` to a language identifier of your choice. To see all possible languages\n    in Common Voice 13, check out the dataset card on the Hugging Face Hub: https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},m(w,J){s(w,y,J)},d(w){w&&l(y)}}}function ha(Ct){let y;return{c(){y=ea("If you do not want to upload the model checkpoints to the Hub, set `push_to_hub=False`.")},l(w){y=ta(w,"If you do not want to upload the model checkpoints to the Hub, set `push_to_hub=False`.")},m(w,J){s(w,y,J)},d(w){w&&l(y)}}}function da(Ct){let y,w,J,vt,j,Wt,U,_t,b,Zs=`In this section, we’ll cover a step-by-step guide on fine-tuning Whisper for speech recognition on the Common Voice 13
dataset. We’ll use the ‘small’ version of the model and a relatively lightweight dataset, enabling you to run fine-tuning
fairly quickly on any 16GB+ GPU with low disk space requirements, such as the 16GB T4 GPU provided in the Google Colab free
tier.`,$t,C,Bs=`Should you have a smaller GPU or encounter memory issues during training, you can follow the suggestions provided for
reducing memory usage. Conversely, should you have access to a larger GPU, you can amend the training arguments to maximise
your throughput. Thus, this guide is accessible regardless of your GPU specifications!`,kt,I,Xs=`Likewise, this guide outlines how to fine-tune the Whisper model for the Dhivehi language. However, the steps covered here
generalise to any language in the Common Voice dataset, and more generally to any ASR dataset on the Hugging Face Hub.
You can tweak the code to quickly switch to a language of your choice and fine-tune a Whisper model in your native tongue 🌍`,xt,v,Vs="Right! Now that’s out the way, let’s get started and kick-off our fine-tuning pipeline!",Gt,W,Zt,_,Rs=`We strongly advise you to upload model checkpoints directly the <a href="https://huggingface.co/" rel="nofollow">Hugging Face Hub</a> while training.
The Hub provides:`,Bt,$,Hs="<li>Integrated version control: you can be sure that no model checkpoint is lost during training.</li> <li>Tensorboard logs: track important metrics over the course of training.</li> <li>Model cards: document what a model does and its intended use cases.</li> <li>Community: an easy way to share and collaborate with the community! 🤗</li>",Xt,k,Ns=`Linking the notebook to the Hub is straightforward - it simply requires entering your Hub authentication token when prompted.
Find your Hub authentication token <a href="https://huggingface.co/settings/tokens" rel="nofollow">here</a> and enter it when prompted:`,Vt,x,Rt,G,As="<strong>Output:</strong>",Ht,Z,Nt,B,At,X,Es=`<a href="https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0" rel="nofollow">Common Voice 13</a> contains approximately ten
hours of labelled Dhivehi data, three of which is held-out test data. This is extremely little data for fine-tuning, so
we’ll be relying on leveraging the extensive multilingual ASR knowledge acquired by Whisper during pre-training for the
low-resource Dhivehi language.`,Et,V,Ys=`Using 🤗 Datasets, downloading and preparing data is extremely simple. We can download and prepare the Common Voice 13
splits in just one line of code. Since Dhivehi is very low-resource, we’ll combine the <code>train</code> and <code>validation</code> splits
to give approximately seven hours of training data. We’ll use the three hours of <code>test</code> data as our held-out test set:`,Yt,R,zt,H,zs="<strong>Output:</strong>",Ft,N,Qt,f,qt,A,Fs=`Most ASR datasets only provide input audio samples (<code>audio</code>) and the corresponding transcribed text (<code>sentence</code>).
Common Voice contains additional metadata information, such as <code>accent</code> and <code>locale</code>, which we can disregard for ASR.
Keeping the notebook as general as possible, we only consider the input audio and transcribed text for fine-tuning,
discarding the additional metadata information:`,St,E,Lt,Y,Dt,z,Qs="The ASR pipeline can be de-composed into three stages:",Pt,F,qs="<li>The feature extractor which pre-processes the raw audio-inputs to log-mel spectrograms</li> <li>The model which performs the sequence-to-sequence mapping</li> <li>The tokenizer which post-processes the predicted tokens to text</li>",Kt,Q,Ss=`In 🤗 Transformers, the Whisper model has an associated feature extractor and tokenizer, called <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperFeatureExtractor" rel="nofollow">WhisperFeatureExtractor</a> and <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperTokenizer" rel="nofollow">WhisperTokenizer</a>
respectively. To make our lives simple, these two objects are wrapped under a single class, called the <a href="https://huggingface.co/docs/transformers/model_doc/whisper#transformers.WhisperProcessor" rel="nofollow">WhisperProcessor</a>.
We can call the WhisperProcessor to perform both the audio pre-processing and the text token post-processing. In doing
so, we only need to keep track of two objects during training: the processor and the model.`,Ot,q,Ls=`When performing multilingual fine-tuning, we need to set the <code>&quot;language&quot;</code> and <code>&quot;task&quot;</code> when instantiating the processor.
The <code>&quot;language&quot;</code> should be set to the source audio language, and the task to <code>&quot;transcribe&quot;</code> for speech recognition or
<code>&quot;translate&quot;</code> for speech translation. These arguments modify the behaviour of the tokenizer, and should be set correctly
to ensure the target labels are encoded properly.`,el,S,Ds="We can see all possible languages supported by Whisper by importing the list of languages:",tl,L,ll,D,Ps=`If you scroll through this list, you’ll notice that many languages are present, but Dhivehi is one of few that is not!
This means that Whisper was not pre-trained on Dhivehi. However, this doesn’t mean that we can’t fine tune Whisper on it.
In doing so, we’ll be teaching Whisper a new language, one that the pre-trained checkpoint does not support. That’s pretty
cool, right!`,sl,P,Ks=`When you fine-tune it on a new language, Whisper does a good job at leveraging its knowledge of the other 96 languages
it’s pre-trained on. Largely speaking, all modern languages will be linguistically similar to at least one of the
96 languages Whisper already knows, so we’ll fall under this paradigm of cross-lingual knowledge representation.`,nl,K,Os=`What we need to do to fine-tune Whisper on a new language is find the language <strong>most similar</strong> that Whisper was
pre-trained on. The Wikipedia article for Dhivehi states that Dhivehi is closely related to the Sinhalese language of Sri Lanka.
If we check the language codes again, we can see that Sinhalese is present in the Whisper language set,
so we can safely set our language argument to <code>&quot;sinhalese&quot;</code>.`,al,O,en=`Right! We’ll load our processor from the pre-trained checkpoint, setting the language to <code>&quot;sinhalese&quot;</code> and task to <code>&quot;transcribe&quot;</code>
as explained above:`,il,ee,ol,te,tn=`It’s worth reiterating that in most circumstances, you’ll find that the language you want to fine-tune on is in the set of
pre-training languages, in which case you can simply set the language directly as your source audio language! Note that
both of these arguments should be omitted for English-only fine-tuning, where there is only one option for the language
(<code>&quot;English&quot;</code>) and task (<code>&quot;transcribe&quot;</code>).`,rl,le,pl,se,ln=`Let’s have a look at the dataset features. Pay particular attention to the <code>&quot;audio&quot;</code> column - this details the sampling
rate of our audio inputs:`,cl,ne,hl,ae,sn="<strong>Output:</strong>",dl,ie,Ml,oe,nn=`Since our input audio is sampled at 48kHz, we need to <em>downsample</em> it to 16kHz prior to passing it to the Whisper feature
extractor, 16kHz being the sampling rate expected by the Whisper model.`,ul,re,an=`We’ll set the audio inputs to the correct sampling rate using dataset’s <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.cast_column" rel="nofollow"><code>cast_column</code></a>
method. This operation does not change the audio in-place, but rather signals to datasets to resample audio samples
on-the-fly when they are loaded:`,ml,pe,yl,ce,on="Now we can write a function to prepare our data ready for the model:",wl,he,rn="<li>We load and resample the audio data on a sample-by-sample basis by calling <code>sample[&quot;audio&quot;]</code>. As explained above, 🤗 Datasets performs any necessary resampling operations on the fly.</li> <li>We use the feature extractor to compute the log-mel spectrogram input features from our 1-dimensional audio array.</li> <li>We encode the transcriptions to label ids through the use of the tokenizer.</li>",Tl,de,Jl,Me,pn=`We can apply the data preparation function to all of our training examples using 🤗 Datasets’ <code>.map</code> method. We’ll
remove the columns from the raw training data (the audio and text), leaving just the columns returned by the
<code>prepare_dataset</code> function:`,fl,ue,gl,me,cn=`Finally, we filter any training data with audio samples longer than 30s. These samples would otherwise be truncated by
the Whisper feature-extractor which could affect the stability of training. We define a function that returns <code>True</code> for
samples that are less than 30s, and <code>False</code> for those that are longer:`,jl,ye,Ul,we,hn="We apply our filter function to all samples of our training dataset through 🤗 Datasets’ <code>.filter</code> method:",bl,Te,Cl,Je,dn="Let’s check how much training data we removed through this filtering step:",Il,fe,vl,ge,Mn="<strong>Output</strong>",Wl,je,_l,Ue,un=`Alright! In this case we actually have the same number of samples as before, so there were no samples longer than 30s.
This might not be the case if you switch languages, so it’s best to keep this filter step in-place for robustness. With
that, we have our data fully prepared for training! Let’s continue and take a look at how we can use this data to fine-tune
Whisper.`,$l,be,kl,Ce,mn=`Now that we’ve prepared our data, we’re ready to dive into the training pipeline.
The <a href="https://huggingface.co/transformers/master/main_classes/trainer.html?highlight=trainer" rel="nofollow">🤗 Trainer</a>
will do much of the heavy lifting for us. All we have to do is:`,xl,Ie,yn="<li><p>Define a data collator: the data collator takes our pre-processed data and prepares PyTorch tensors ready for the model.</p></li> <li><p>Evaluation metrics: during evaluation, we want to evaluate the model using the word error rate (WER) metric. We need to define a <code>compute_metrics</code> function that handles this computation.</p></li> <li><p>Load a pre-trained checkpoint: we need to load a pre-trained checkpoint and configure it correctly for training.</p></li> <li><p>Define the training arguments: these will be used by the 🤗 Trainer in constructing the training schedule.</p></li>",Gl,ve,wn=`Once we’ve fine-tuned the model, we will evaluate it on the test data to verify that we have correctly trained it
to transcribe speech in Dhivehi.`,Zl,We,Bl,_e,Tn=`The data collator for a sequence-to-sequence speech model is unique in the sense that it treats the <code>input_features</code>
and <code>labels</code> independently: the  <code>input_features</code> must be handled by the feature extractor and the <code>labels</code> by the tokenizer.`,Xl,$e,Jn=`The <code>input_features</code> are already padded to 30s and converted to a log-Mel spectrogram of fixed dimension, so all we
have to do is convert them to batched PyTorch tensors. We do this using the feature extractor’s <code>.pad</code> method with
<code>return_tensors=pt</code>. Note that no additional padding is applied here since the inputs are of fixed dimension, the
<code>input_features</code> are simply converted to PyTorch tensors.`,Vl,ke,fn=`On the other hand, the <code>labels</code> are un-padded. We first pad the sequences to the maximum length in the batch using
the tokenizer’s <code>.pad</code> method. The padding tokens are then replaced by <code>-100</code> so that these tokens are <strong>not</strong> taken
into account when computing the loss. We then cut the start of transcript token from the beginning of the label sequence
as we append it later during training.`,Rl,xe,gn="We can leverage the <code>WhisperProcessor</code> we defined earlier to perform both the feature extractor and the tokenizer operations:",Hl,Ge,Nl,Ze,jn="We can now initialise the data collator we’ve just defined:",Al,Be,El,Xe,Un="Onwards!",Yl,Ve,zl,Re,bn=`Next, we define the evaluation metric we’ll use on our evaluation set. We’ll use the Word Error Rate (WER) metric introduced
in the section on <a href="evaluation">Evaluation</a>, the ‘de-facto’ metric for assessing ASR systems.`,Fl,He,Cn="We’ll load the WER metric from 🤗 Evaluate:",Ql,Ne,ql,Ae,In=`We then simply have to define a function that takes our model predictions and returns the WER metric. This function, called
<code>compute_metrics</code>, first replaces <code>-100</code> with the <code>pad_token_id</code> in the <code>label_ids</code> (undoing the step we applied in the
data collator to ignore padded tokens correctly in the loss). It then decodes the predicted and label ids to strings. Finally,
it computes the WER between the predictions and reference labels. Here, we have the option of evaluating with the ‘normalised’
transcriptions and predictions, which have punctuation and casing removed. We recommend you follow this to benefit
from the WER improvement obtained by normalising the transcriptions.`,Sl,Ee,Ll,Ye,Dl,ze,vn="Now let’s load the pre-trained Whisper small checkpoint. Again, this is trivial through use of 🤗 Transformers!",Pl,Fe,Kl,Qe,Wn=`We’ll set <code>use_cache</code> to <code>False</code> for training since we’re using <a href="https://huggingface.co/docs/transformers/v4.18.0/en/performance#gradient-checkpointing" rel="nofollow">gradient checkpointing</a>
and the two are incompatible. We’ll also override two generation arguments to control the behaviour of the model during inference:
we’ll force the language and task tokens during generation by setting the <code>language</code> and <code>task</code> arguments, and also re-enable
cache for generation to speed-up inference time:`,Ol,qe,es,Se,ts,Le,_n=`In the final step, we define all the parameters related to training. Here, we set the number of training steps to 500.
This is enough steps to see a big WER improvement compared to the pre-trained Whisper model, while ensuring that fine-tuning can
be run in approximately 45 minutes on a Google Colab free tier. For more detail on the training arguments, refer to the
Seq2SeqTrainingArguments <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments" rel="nofollow">docs</a>.`,ls,De,ss,g,ns,Pe,$n="We can forward the training arguments to the 🤗 Trainer along with our model, dataset, data collator and <code>compute_metrics</code> function:",as,Ke,is,Oe,kn="And with that, we’re ready to start training!",os,et,rs,tt,xn="To launch training, simply execute:",ps,lt,cs,st,Gn=`Training will take approximately 45 minutes depending on your GPU or the one allocated to the Google Colab. Depending on
your GPU, it is possible that you will encounter a CUDA <code>&quot;out-of-memory&quot;</code> error when you start training. In this case,
you can reduce the <code>per_device_train_batch_size</code> incrementally by factors of 2 and employ <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments.gradient_accumulation_steps" rel="nofollow"><code>gradient_accumulation_steps</code></a>
to compensate.`,hs,nt,Zn="<strong>Output:</strong>",ds,at,Bn='<thead><tr><th align="center">Training Loss</th> <th align="center">Epoch</th> <th align="center">Step</th> <th align="center">Validation Loss</th> <th align="center">Wer Ortho</th> <th align="center">Wer</th></tr></thead> <tbody><tr><td align="center">0.136</td> <td align="center">1.63</td> <td align="center">500</td> <td align="center">0.1727</td> <td align="center">63.8972</td> <td align="center">14.0661</td></tr></tbody>',Ms,it,Xn=`Our final WER is 14.1% - not bad for seven hours of training data and just 500 training steps! That amounts to a 112%
improvement versus the pre-trained model! That means we’ve taken a model that previously had no knowledge about Dhivehi,
and fine-tuned it to recognise Dhivehi speech with adequate accuracy in under one hour 🤯`,us,ot,Vn=`The big question is how this compares to other ASR systems. For that, we can view the autoevaluate <a href="https://huggingface.co/spaces/autoevaluate/leaderboards?dataset=mozilla-foundation%2Fcommon_voice_13_0&amp;only_verified=0&amp;task=automatic-speech-recognition&amp;config=dv&amp;split=test&amp;metric=wer" rel="nofollow">leaderboard</a>,
a leaderboard that categorises models by language and dataset, and subsequently ranks them according to their WER.`,ms,rt,Rn=`Looking at the leaderboard, we see that our model trained for 500 steps convincingly beats the pre-trained <a href="https://huggingface.co/openai/whisper-small" rel="nofollow">Whisper Small</a>
checkpoint that we evaluated in the previous section. Nice job 👏`,ys,pt,Hn=`We see that there are a few checkpoints that do better than the one we trained. The beauty of the Hugging Face Hub is that
it’s a <em>collaborative</em> platform - if we don’t have the time or resources to perform a longer training run ourselves, we
can load a checkpoint that someone else in the community has trained and been kind enough to share (making sure to thank them for it!).
You’ll be able to load these checkpoints in exactly the same way as the pre-trained ones using the <code>pipeline</code> class as we
did previously! So there’s nothing stopping you cherry-picking the best model on the leaderboard to use for your task!`,ws,ct,Nn=`We can automatically submit our checkpoint to the leaderboard when we push the training results to the Hub - we simply
have to set the appropriate key-word arguments (kwargs). You can change these values to match your dataset, language and
model name accordingly:`,Ts,ht,Js,dt,An="The training results can now be uploaded to the Hub. To do so, execute the <code>push_to_hub</code> command:",fs,Mt,gs,ut,En=`This will save the training logs and model weights under <code>&quot;your-username/the-name-you-picked&quot;</code>. For this example, check
out the upload at <code>sanchit-gandhi/whisper-small-dv</code>.`,js,mt,Yn=`While the fine-tuned model yields satisfactory results on the Common Voice 13 Dhivehi test data, it is by no means optimal.
The purpose of this guide is to demonstrate how to fine-tune an ASR model using the 🤗 Trainer for multilingual speech
recognition.`,Us,yt,zn=`If you have access to your own GPU or are subscribed to a Google Colab paid plan, you can increase <code>max_steps</code> to 4000 steps
to improve the WER further by training for more steps. Training for 4000 steps will take approximately 3-5 hours depending
on your GPU and yield WER results approximately 3% lower than training for 500 steps. If you decide to train for 4000 steps,
we also recommend changing the learning rate scheduler to a <em>linear</em> schedule (set <code>lr_scheduler_type=&quot;linear&quot;</code>), as this will
yield an additional performance boost over long training runs.`,bs,wt,Fn=`The results could likely be improved further by optimising the training hyperparameters, such as <em>learning rate</em> and
<em>dropout</em>, and using a larger pre-trained checkpoint (<code>medium</code> or <code>large</code>). We leave this as an exercise to the reader.`,Cs,Tt,Is,Jt,Qn=`You can now share this model with anyone using the link on the Hub. They can load it with the identifier <code>&quot;your-username/the-name-you-picked&quot;</code>
directly into the <code>pipeline()</code> object. For instance, to load the fine-tuned checkpoint <a href="https://huggingface.co/sanchit-gandhi/whisper-small-dv" rel="nofollow">“sanchit-gandhi/whisper-small-dv”</a>:`,vs,ft,Ws,gt,_s,jt,qn=`In this section, we covered a step-by-step guide on fine-tuning the Whisper model for speech recognition 🤗 Datasets,
Transformers and the Hugging Face Hub. We first loaded the Dhivehi subset of the Common Voice 13 dataset and pre-processed
it by computing log-mel spectrograms and tokenising the text. We then defined a data collator, evaluation metric and
training arguments, before using the 🤗 Trainer to train and evaluate our model. We finished by uploading the fine-tuned
model to the Hugging Face Hub, and showcased how to share and use it with the <code>pipeline()</code> class.`,$s,Ut,Sn=`If you followed through to this point, you should now have a fine-tuned checkpoint for speech recognition, well done! 🥳
Even more importantly, you’re equipped with all the tools you need to fine-tune the Whisper model on any speech recognition
dataset or domain. So what are you waiting for! Pick one of the datasets covered in the section <a href="choosing_dataset">Choosing a Dataset</a>
or select a dataset of your own, and see whether you can get state-of-the-art performance! The leaderboard is waiting for you…`,ks,bt,xs,It,Gs;return j=new ra({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new T({props:{title:"Fine-tuning the ASR model",local:"fine-tuning-the-asr-model",headingTag:"h1"}}),W=new T({props:{title:"Prepare Environment",local:"prepare-environment",headingTag:"h2"}}),x=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Z=new m({props:{code:"TG9naW4lMjBzdWNjZXNzZnVsJTBBWW91ciUyMHRva2VuJTIwaGFzJTIwYmVlbiUyMHNhdmVkJTIwdG8lMjAlMkZyb290JTJGLmh1Z2dpbmdmYWNlJTJGdG9rZW4=",highlighted:`Login successful
Your token has been saved to /root/.huggingface/token`,wrap:!1}}),B=new T({props:{title:"Load Dataset",local:"load-dataset",headingTag:"h2"}}),R=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwRGF0YXNldERpY3QlMEElMEFjb21tb25fdm9pY2UlMjAlM0QlMjBEYXRhc2V0RGljdCgpJTBBJTBBY29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ2YWxpZGF0aW9uJTIyJTBBKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMiUwQSklMEElMEFwcmludChjb21tb25fdm9pY2Up",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, DatasetDict

common_voice = DatasetDict()

common_voice[<span class="hljs-string">&quot;train&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;train+validation&quot;</span>
)
common_voice[<span class="hljs-string">&quot;test&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>
)

<span class="hljs-built_in">print</span>(common_voice)`,wrap:!1}}),N=new m({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2NsaWVudF9pZCclMkMlMjAncGF0aCclMkMlMjAnYXVkaW8nJTJDJTIwJ3NlbnRlbmNlJyUyQyUyMCd1cF92b3RlcyclMkMlMjAnZG93bl92b3RlcyclMkMlMjAnYWdlJyUyQyUyMCdnZW5kZXInJTJDJTIwJ2FjY2VudCclMkMlMjAnbG9jYWxlJyUyQyUyMCdzZWdtZW50JyUyQyUyMCd2YXJpYW50JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNDkwNCUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidjbGllbnRfaWQnJTJDJTIwJ3BhdGgnJTJDJTIwJ2F1ZGlvJyUyQyUyMCdzZW50ZW5jZSclMkMlMjAndXBfdm90ZXMnJTJDJTIwJ2Rvd25fdm90ZXMnJTJDJTIwJ2FnZSclMkMlMjAnZ2VuZGVyJyUyQyUyMCdhY2NlbnQnJTJDJTIwJ2xvY2FsZSclMkMlMjAnc2VnbWVudCclMkMlMjAndmFyaWFudCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDIyMTIlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTdEKQ==",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">4904</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">2212</span>
    })
})`,wrap:!1}}),f=new On({props:{$$slots:{default:[ca]},$$scope:{ctx:Ct}}}),E=new m({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLnNlbGVjdF9jb2x1bW5zKCU1QiUyMmF1ZGlvJTIyJTJDJTIwJTIyc2VudGVuY2UlMjIlNUQp",highlighted:'common_voice = common_voice.select_columns([<span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;sentence&quot;</span>])',wrap:!1}}),Y=new T({props:{title:"Feature Extractor, Tokenizer and Processor",local:"feature-extractor-tokenizer-and-processor",headingTag:"h2"}}),L=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMud2hpc3Blci50b2tlbml6YXRpb25fd2hpc3BlciUyMGltcG9ydCUyMFRPX0xBTkdVQUdFX0NPREUlMEElMEFUT19MQU5HVUFHRV9DT0RF",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.tokenization_whisper <span class="hljs-keyword">import</span> TO_LANGUAGE_CODE

TO_LANGUAGE_CODE`,wrap:!1}}),ee=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBXaGlzcGVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTIwbGFuZ3VhZ2UlM0QlMjJzaW5oYWxlc2UlMjIlMkMlMjB0YXNrJTNEJTIydHJhbnNjcmliZSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperProcessor

processor = WhisperProcessor.from_pretrained(
    <span class="hljs-string">&quot;openai/whisper-small&quot;</span>, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>
)`,wrap:!1}}),le=new T({props:{title:"Pre-Process the Data",local:"pre-process-the-data",headingTag:"h2"}}),ne=new m({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQuZmVhdHVyZXM=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>].features',wrap:!1}}),ie=new m({props:{code:"JTdCJ2F1ZGlvJyUzQSUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0Q0ODAwMCUyQyUyMG1vbm8lM0RUcnVlJTJDJTIwZGVjb2RlJTNEVHJ1ZSUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnc2VudGVuY2UnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklN0Q=",highlighted:`{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(<span class="hljs-attribute">sampling_rate</span>=48000, <span class="hljs-attribute">mono</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">decode</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">id</span>=None),
 <span class="hljs-string">&#x27;sentence&#x27;</span>: Value(<span class="hljs-attribute">dtype</span>=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-attribute">id</span>=None)}`,wrap:!1}}),pe=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMEFjb21tb25fdm9pY2UlMjAlM0QlMjBjb21tb25fdm9pY2UuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

sampling_rate = processor.feature_extractor.sampling_rate
common_voice = common_voice.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=sampling_rate))`,wrap:!1}}),de=new m({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTNEZXhhbXBsZSU1QiUyMnNlbnRlbmNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBpbnB1dCUyMGxlbmd0aCUyMG9mJTIwYXVkaW8lMjBzYW1wbGUlMjBpbiUyMHNlY29uZHMlMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW5wdXRfbGVuZ3RoJTIyJTVEJTIwJTNEJTIwbGVuKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTIwYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        audio=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        text=example[<span class="hljs-string">&quot;sentence&quot;</span>],
    )

    <span class="hljs-comment"># compute input length of audio sample in seconds</span>
    example[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(audio[<span class="hljs-string">&quot;array&quot;</span>]) / audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>]

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),ue=new m({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLm1hcCglMEElMjAlMjAlMjAlMjBwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRGNvbW1vbl92b2ljZS5jb2x1bW5fbmFtZXMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMG51bV9wcm9jJTNEMSUwQSk=",highlighted:`common_voice = common_voice.<span class="hljs-built_in">map</span>(
    prepare_dataset, remove_columns=common_voice.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">1</span>
)`,wrap:!1}}),ye=new m({props:{code:"bWF4X2lucHV0X2xlbmd0aCUyMCUzRCUyMDMwLjAlMEElMEElMEFkZWYlMjBpc19hdWRpb19pbl9sZW5ndGhfcmFuZ2UobGVuZ3RoKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxlbmd0aCUyMCUzQyUyMG1heF9pbnB1dF9sZW5ndGg=",highlighted:`max_input_length = <span class="hljs-number">30.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_in_length_range</span>(<span class="hljs-params">length</span>):
    <span class="hljs-keyword">return</span> length &lt; max_input_length`,wrap:!1}}),Te=new m({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RC5maWx0ZXIoJTBBJTIwJTIwJTIwJTIwaXNfYXVkaW9faW5fbGVuZ3RoX3JhbmdlJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmlucHV0X2xlbmd0aCUyMiU1RCUyQyUwQSk=",highlighted:`common_voice[<span class="hljs-string">&quot;train&quot;</span>] = common_voice[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">filter</span>(
    is_audio_in_length_range,
    input_columns=[<span class="hljs-string">&quot;input_length&quot;</span>],
)`,wrap:!1}}),fe=new m({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),je=new m({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidpbnB1dF9mZWF0dXJlcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdpbnB1dF9sZW5ndGgnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA0OTA0JTBBJTdEKQ==",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;input_features&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;input_length&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">4904</span>
})`,wrap:!1}}),be=new T({props:{title:"Training and Evaluation",local:"training-and-evaluation",headingTag:"h2"}}),We=new T({props:{title:"Define a Data Collator",local:"define-a-data-collator",headingTag:"h3"}}),Ge=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorSpeechSeq2SeqWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-comment"># split inputs and labels since they have to be of different lengths and need different padding methods</span>
        <span class="hljs-comment"># first treat the audio inputs by simply returning torch tensors</span>
        input_features = [
            {<span class="hljs-string">&quot;input_features&quot;</span>: feature[<span class="hljs-string">&quot;input_features&quot;</span>][<span class="hljs-number">0</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features
        ]
        batch = self.processor.feature_extractor.pad(input_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># get the tokenized label sequences</span>
        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        <span class="hljs-comment"># pad the labels to max length</span>
        labels_batch = self.processor.tokenizer.pad(label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(
            labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># if bos token is appended in previous tokenization step,</span>
        <span class="hljs-comment"># cut bos token here as it&#x27;s append later anyways</span>
        <span class="hljs-keyword">if</span> (labels[:, <span class="hljs-number">0</span>] == self.processor.tokenizer.bos_token_id).<span class="hljs-built_in">all</span>().cpu().item():
            labels = labels[:, <span class="hljs-number">1</span>:]

        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),Be=new m({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvclNwZWVjaFNlcTJTZXFXaXRoUGFkZGluZyhwcm9jZXNzb3IlM0Rwcm9jZXNzb3Ip",highlighted:"data_collator = DataCollatorSpeechSeq2SeqWithPadding(processor=processor)",wrap:!1}}),Ve=new T({props:{title:"Evaluation Metrics",local:"evaluation-metrics",headingTag:"h3"}}),Ne=new m({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`,wrap:!1}}),Ee=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.english_normalizer <span class="hljs-keyword">import</span> BasicTextNormalizer

normalizer = BasicTextNormalizer()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">pred</span>):
    pred_ids = pred.predictions
    label_ids = pred.label_ids

    <span class="hljs-comment"># replace -100 with the pad_token_id</span>
    label_ids[label_ids == -<span class="hljs-number">100</span>] = processor.tokenizer.pad_token_id

    <span class="hljs-comment"># we do not want to group tokens when computing the metrics</span>
    pred_str = processor.batch_decode(pred_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
    label_str = processor.batch_decode(label_ids, skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># compute orthographic wer</span>
    wer_ortho = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str, references=label_str)

    <span class="hljs-comment"># compute normalised WER</span>
    pred_str_norm = [normalizer(pred) <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> pred_str]
    label_str_norm = [normalizer(label) <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> label_str]
    <span class="hljs-comment"># filtering step to only evaluate the samples that correspond to non-zero references:</span>
    pred_str_norm = [
        pred_str_norm[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(pred_str_norm)) <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]
    label_str_norm = [
        label_str_norm[i]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(label_str_norm))
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]

    wer = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str_norm, references=label_str_norm)

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer_ortho&quot;</span>: wer_ortho, <span class="hljs-string">&quot;wer&quot;</span>: wer}`,wrap:!1}}),Ye=new T({props:{title:"Load a Pre-Trained Checkpoint",local:"load-a-pre-trained-checkpoint",headingTag:"h3"}}),Fe=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperForConditionalGeneration

model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),qe=new m({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkaXNhYmxlJTIwY2FjaGUlMjBkdXJpbmclMjB0cmFpbmluZyUyMHNpbmNlJTIwaXQncyUyMGluY29tcGF0aWJsZSUyMHdpdGglMjBncmFkaWVudCUyMGNoZWNrcG9pbnRpbmclMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBzZXQlMjBsYW5ndWFnZSUyMGFuZCUyMHRhc2slMjBmb3IlMjBnZW5lcmF0aW9uJTIwYW5kJTIwcmUtZW5hYmxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwoJTBBJTIwJTIwJTIwJTIwbW9kZWwuZ2VuZXJhdGUlMkMlMjBsYW5ndWFnZSUzRCUyMnNpbmhhbGVzZSUyMiUyQyUyMHRhc2slM0QlMjJ0cmFuc2NyaWJlJTIyJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># disable cache during training since it&#x27;s incompatible with gradient checkpointing</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># set language and task for generation and re-enable cache</span>
model.generate = partial(
    model.generate, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>, use_cache=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Se=new T({props:{title:"Define the Training Configuration",local:"define-the-training-configuration",headingTag:"h2"}}),De=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMi4lMkZ3aGlzcGVyLXNtYWxsLWR2JTIyJTJDJTIwJTIwJTIzJTIwbmFtZSUyMG9uJTIwdGhlJTIwSEYlMjBIdWIlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDElMkMlMjAlMjAlMjMlMjBpbmNyZWFzZSUyMGJ5JTIwMnglMjBmb3IlMjBldmVyeSUyMDJ4JTIwZGVjcmVhc2UlMjBpbiUyMGJhdGNoJTIwc2l6ZSUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyX3R5cGUlM0QlMjJjb25zdGFudF93aXRoX3dhcm11cCUyMiUyQyUwQSUyMCUyMCUyMCUyMHdhcm11cF9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENTAwJTJDJTIwJTIwJTIzJTIwaW5jcmVhc2UlMjB0byUyMDQwMDAlMjBpZiUyMHlvdSUyMGhhdmUlMjB5b3VyJTIwb3duJTIwR1BVJTIwb3IlMjBhJTIwQ29sYWIlMjBwYWlkJTIwcGxhbiUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2X2Z1bGxfZXZhbCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwcHJlZGljdF93aXRoX2dlbmVyYXRlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRpb25fbWF4X2xlbmd0aCUzRDIyNSUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0ZXBzJTNENTAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTVCJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpY19mb3JfYmVzdF9tb2RlbCUzRCUyMndlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;./whisper-small-dv&quot;</span>,  <span class="hljs-comment"># name on the HF Hub</span>
    per_device_train_batch_size=<span class="hljs-number">16</span>,
    gradient_accumulation_steps=<span class="hljs-number">1</span>,  <span class="hljs-comment"># increase by 2x for every 2x decrease in batch size</span>
    learning_rate=<span class="hljs-number">1e-5</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;constant_with_warmup&quot;</span>,
    warmup_steps=<span class="hljs-number">50</span>,
    max_steps=<span class="hljs-number">500</span>,  <span class="hljs-comment"># increase to 4000 if you have your own GPU or a Colab paid plan</span>
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    fp16_full_eval=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">16</span>,
    predict_with_generate=<span class="hljs-literal">True</span>,
    generation_max_length=<span class="hljs-number">225</span>,
    save_steps=<span class="hljs-number">500</span>,
    eval_steps=<span class="hljs-number">500</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;wer&quot;</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),g=new On({props:{$$slots:{default:[ha]},$$scope:{ctx:Ct}}}),Ke=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=common_voice[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=common_voice[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    compute_metrics=compute_metrics,
    tokenizer=processor,
)`,wrap:!1}}),et=new T({props:{title:"Training",local:"training",headingTag:"h3"}}),lt=new m({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),ht=new m({props:{code:"a3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZGF0YXNldF90YWdzJTIyJTNBJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkYXRhc2V0JTIyJTNBJTIwJTIyQ29tbW9uJTIwVm9pY2UlMjAxMyUyMiUyQyUyMCUyMCUyMyUyMGElMjAncHJldHR5JyUyMG5hbWUlMjBmb3IlMjB0aGUlMjB0cmFpbmluZyUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjAlMjJsYW5ndWFnZSUyMiUzQSUyMCUyMmR2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMldoaXNwZXIlMjBTbWFsbCUyMER2JTIwLSUyMFNhbmNoaXQlMjBHYW5kaGklMjIlMkMlMjAlMjAlMjMlMjBhJTIwJ3ByZXR0eSclMjBuYW1lJTIwZm9yJTIweW91ciUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwJTIyZmluZXR1bmVkX2Zyb20lMjIlM0ElMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFza3MlMjIlM0ElMjAlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTBBJTdE",highlighted:`kwargs = {
    <span class="hljs-string">&quot;dataset_tags&quot;</span>: <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>,
    <span class="hljs-string">&quot;dataset&quot;</span>: <span class="hljs-string">&quot;Common Voice 13&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for the training dataset</span>
    <span class="hljs-string">&quot;language&quot;</span>: <span class="hljs-string">&quot;dv&quot;</span>,
    <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;Whisper Small Dv - Sanchit Gandhi&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for your model</span>
    <span class="hljs-string">&quot;finetuned_from&quot;</span>: <span class="hljs-string">&quot;openai/whisper-small&quot;</span>,
    <span class="hljs-string">&quot;tasks&quot;</span>: <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
}`,wrap:!1}}),Mt=new m({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1YigqKmt3YXJncyk=",highlighted:"trainer.push_to_hub(**kwargs)",wrap:!1}}),Tt=new T({props:{title:"Sharing Your Model",local:"sharing-your-model",headingTag:"h2"}}),ft=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNhbmNoaXQtZ2FuZGhpJTJGd2hpc3Blci1zbWFsbC1kdiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-small-dv&quot;</span>)`,wrap:!1}}),gt=new T({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),bt=new pa({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter5/fine-tuning.mdx"}}),{c(){y=i("meta"),w=n(),J=i("p"),vt=n(),p(j.$$.fragment),Wt=n(),p(U.$$.fragment),_t=n(),b=i("p"),b.textContent=Zs,$t=n(),C=i("p"),C.textContent=Bs,kt=n(),I=i("p"),I.textContent=Xs,xt=n(),v=i("p"),v.textContent=Vs,Gt=n(),p(W.$$.fragment),Zt=n(),_=i("p"),_.innerHTML=Rs,Bt=n(),$=i("ul"),$.innerHTML=Hs,Xt=n(),k=i("p"),k.innerHTML=Ns,Vt=n(),p(x.$$.fragment),Rt=n(),G=i("p"),G.innerHTML=As,Ht=n(),p(Z.$$.fragment),Nt=n(),p(B.$$.fragment),At=n(),X=i("p"),X.innerHTML=Es,Et=n(),V=i("p"),V.innerHTML=Ys,Yt=n(),p(R.$$.fragment),zt=n(),H=i("p"),H.innerHTML=zs,Ft=n(),p(N.$$.fragment),Qt=n(),p(f.$$.fragment),qt=n(),A=i("p"),A.innerHTML=Fs,St=n(),p(E.$$.fragment),Lt=n(),p(Y.$$.fragment),Dt=n(),z=i("p"),z.textContent=Qs,Pt=n(),F=i("ol"),F.innerHTML=qs,Kt=n(),Q=i("p"),Q.innerHTML=Ss,Ot=n(),q=i("p"),q.innerHTML=Ls,el=n(),S=i("p"),S.textContent=Ds,tl=n(),p(L.$$.fragment),ll=n(),D=i("p"),D.textContent=Ps,sl=n(),P=i("p"),P.textContent=Ks,nl=n(),K=i("p"),K.innerHTML=Os,al=n(),O=i("p"),O.innerHTML=en,il=n(),p(ee.$$.fragment),ol=n(),te=i("p"),te.innerHTML=tn,rl=n(),p(le.$$.fragment),pl=n(),se=i("p"),se.innerHTML=ln,cl=n(),p(ne.$$.fragment),hl=n(),ae=i("p"),ae.innerHTML=sn,dl=n(),p(ie.$$.fragment),Ml=n(),oe=i("p"),oe.innerHTML=nn,ul=n(),re=i("p"),re.innerHTML=an,ml=n(),p(pe.$$.fragment),yl=n(),ce=i("p"),ce.textContent=on,wl=n(),he=i("ol"),he.innerHTML=rn,Tl=n(),p(de.$$.fragment),Jl=n(),Me=i("p"),Me.innerHTML=pn,fl=n(),p(ue.$$.fragment),gl=n(),me=i("p"),me.innerHTML=cn,jl=n(),p(ye.$$.fragment),Ul=n(),we=i("p"),we.innerHTML=hn,bl=n(),p(Te.$$.fragment),Cl=n(),Je=i("p"),Je.textContent=dn,Il=n(),p(fe.$$.fragment),vl=n(),ge=i("p"),ge.innerHTML=Mn,Wl=n(),p(je.$$.fragment),_l=n(),Ue=i("p"),Ue.textContent=un,$l=n(),p(be.$$.fragment),kl=n(),Ce=i("p"),Ce.innerHTML=mn,xl=n(),Ie=i("ul"),Ie.innerHTML=yn,Gl=n(),ve=i("p"),ve.textContent=wn,Zl=n(),p(We.$$.fragment),Bl=n(),_e=i("p"),_e.innerHTML=Tn,Xl=n(),$e=i("p"),$e.innerHTML=Jn,Vl=n(),ke=i("p"),ke.innerHTML=fn,Rl=n(),xe=i("p"),xe.innerHTML=gn,Hl=n(),p(Ge.$$.fragment),Nl=n(),Ze=i("p"),Ze.textContent=jn,Al=n(),p(Be.$$.fragment),El=n(),Xe=i("p"),Xe.textContent=Un,Yl=n(),p(Ve.$$.fragment),zl=n(),Re=i("p"),Re.innerHTML=bn,Fl=n(),He=i("p"),He.textContent=Cn,Ql=n(),p(Ne.$$.fragment),ql=n(),Ae=i("p"),Ae.innerHTML=In,Sl=n(),p(Ee.$$.fragment),Ll=n(),p(Ye.$$.fragment),Dl=n(),ze=i("p"),ze.textContent=vn,Pl=n(),p(Fe.$$.fragment),Kl=n(),Qe=i("p"),Qe.innerHTML=Wn,Ol=n(),p(qe.$$.fragment),es=n(),p(Se.$$.fragment),ts=n(),Le=i("p"),Le.innerHTML=_n,ls=n(),p(De.$$.fragment),ss=n(),p(g.$$.fragment),ns=n(),Pe=i("p"),Pe.innerHTML=$n,as=n(),p(Ke.$$.fragment),is=n(),Oe=i("p"),Oe.textContent=kn,os=n(),p(et.$$.fragment),rs=n(),tt=i("p"),tt.textContent=xn,ps=n(),p(lt.$$.fragment),cs=n(),st=i("p"),st.innerHTML=Gn,hs=n(),nt=i("p"),nt.innerHTML=Zn,ds=n(),at=i("table"),at.innerHTML=Bn,Ms=n(),it=i("p"),it.textContent=Xn,us=n(),ot=i("p"),ot.innerHTML=Vn,ms=n(),rt=i("p"),rt.innerHTML=Rn,ys=n(),pt=i("p"),pt.innerHTML=Hn,ws=n(),ct=i("p"),ct.textContent=Nn,Ts=n(),p(ht.$$.fragment),Js=n(),dt=i("p"),dt.innerHTML=An,fs=n(),p(Mt.$$.fragment),gs=n(),ut=i("p"),ut.innerHTML=En,js=n(),mt=i("p"),mt.textContent=Yn,Us=n(),yt=i("p"),yt.innerHTML=zn,bs=n(),wt=i("p"),wt.innerHTML=Fn,Cs=n(),p(Tt.$$.fragment),Is=n(),Jt=i("p"),Jt.innerHTML=Qn,vs=n(),p(ft.$$.fragment),Ws=n(),p(gt.$$.fragment),_s=n(),jt=i("p"),jt.innerHTML=qn,$s=n(),Ut=i("p"),Ut.innerHTML=Sn,ks=n(),p(bt.$$.fragment),xs=n(),It=i("p"),this.h()},l(e){const t=ia("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),w=a(e),J=o(e,"P",{}),Pn(J).forEach(l),vt=a(e),c(j.$$.fragment,e),Wt=a(e),c(U.$$.fragment,e),_t=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-y7r5mv"&&(b.textContent=Zs),$t=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-15djjoq"&&(C.textContent=Bs),kt=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1qs2xtc"&&(I.textContent=Xs),xt=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-vn1gx2"&&(v.textContent=Vs),Gt=a(e),c(W.$$.fragment,e),Zt=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-lavash"&&(_.innerHTML=Rs),Bt=a(e),$=o(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-1vhmuwk"&&($.innerHTML=Hs),Xt=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-dngs6s"&&(k.innerHTML=Ns),Vt=a(e),c(x.$$.fragment,e),Rt=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1mvdyro"&&(G.innerHTML=As),Ht=a(e),c(Z.$$.fragment,e),Nt=a(e),c(B.$$.fragment,e),At=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-9bh3m8"&&(X.innerHTML=Es),Et=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1d296ko"&&(V.innerHTML=Ys),Yt=a(e),c(R.$$.fragment,e),zt=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1mvdyro"&&(H.innerHTML=zs),Ft=a(e),c(N.$$.fragment,e),Qt=a(e),c(f.$$.fragment,e),qt=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-amnv42"&&(A.innerHTML=Fs),St=a(e),c(E.$$.fragment,e),Lt=a(e),c(Y.$$.fragment,e),Dt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1iebir5"&&(z.textContent=Qs),Pt=a(e),F=o(e,"OL",{"data-svelte-h":!0}),r(F)!=="svelte-peruey"&&(F.innerHTML=qs),Kt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1al0blu"&&(Q.innerHTML=Ss),Ot=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-zcpfiu"&&(q.innerHTML=Ls),el=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1o6e7as"&&(S.textContent=Ds),tl=a(e),c(L.$$.fragment,e),ll=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-bbew1u"&&(D.textContent=Ps),sl=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1c5pwr8"&&(P.textContent=Ks),nl=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-nq5sit"&&(K.innerHTML=Os),al=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-14p5mnr"&&(O.innerHTML=en),il=a(e),c(ee.$$.fragment,e),ol=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-kof0c9"&&(te.innerHTML=tn),rl=a(e),c(le.$$.fragment,e),pl=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1h5ivu3"&&(se.innerHTML=ln),cl=a(e),c(ne.$$.fragment,e),hl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1mvdyro"&&(ae.innerHTML=sn),dl=a(e),c(ie.$$.fragment,e),Ml=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1k18r6h"&&(oe.innerHTML=nn),ul=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-17pt1y2"&&(re.innerHTML=an),ml=a(e),c(pe.$$.fragment,e),yl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-93po82"&&(ce.textContent=on),wl=a(e),he=o(e,"OL",{"data-svelte-h":!0}),r(he)!=="svelte-51y4cn"&&(he.innerHTML=rn),Tl=a(e),c(de.$$.fragment,e),Jl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-c2eyft"&&(Me.innerHTML=pn),fl=a(e),c(ue.$$.fragment,e),gl=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1a11l7s"&&(me.innerHTML=cn),jl=a(e),c(ye.$$.fragment,e),Ul=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1mmculc"&&(we.innerHTML=hn),bl=a(e),c(Te.$$.fragment,e),Cl=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-184pc3h"&&(Je.textContent=dn),Il=a(e),c(fe.$$.fragment,e),vl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1ga3zr2"&&(ge.innerHTML=Mn),Wl=a(e),c(je.$$.fragment,e),_l=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-6oin7m"&&(Ue.textContent=un),$l=a(e),c(be.$$.fragment,e),kl=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1ei1tif"&&(Ce.innerHTML=mn),xl=a(e),Ie=o(e,"UL",{"data-svelte-h":!0}),r(Ie)!=="svelte-1osxt83"&&(Ie.innerHTML=yn),Gl=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-pvjt36"&&(ve.textContent=wn),Zl=a(e),c(We.$$.fragment,e),Bl=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-3d3hl2"&&(_e.innerHTML=Tn),Xl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1r84vh4"&&($e.innerHTML=Jn),Vl=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-e9pzmh"&&(ke.innerHTML=fn),Rl=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-ah9f4t"&&(xe.innerHTML=gn),Hl=a(e),c(Ge.$$.fragment,e),Nl=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-14k5ead"&&(Ze.textContent=jn),Al=a(e),c(Be.$$.fragment,e),El=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-hg8uw5"&&(Xe.textContent=Un),Yl=a(e),c(Ve.$$.fragment,e),zl=a(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1dqtuem"&&(Re.innerHTML=bn),Fl=a(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-16pkeis"&&(He.textContent=Cn),Ql=a(e),c(Ne.$$.fragment,e),ql=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-wtclzb"&&(Ae.innerHTML=In),Sl=a(e),c(Ee.$$.fragment,e),Ll=a(e),c(Ye.$$.fragment,e),Dl=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1xesvxe"&&(ze.textContent=vn),Pl=a(e),c(Fe.$$.fragment,e),Kl=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1fuw0bw"&&(Qe.innerHTML=Wn),Ol=a(e),c(qe.$$.fragment,e),es=a(e),c(Se.$$.fragment,e),ts=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1h5nxlm"&&(Le.innerHTML=_n),ls=a(e),c(De.$$.fragment,e),ss=a(e),c(g.$$.fragment,e),ns=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1i53tjj"&&(Pe.innerHTML=$n),as=a(e),c(Ke.$$.fragment,e),is=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-rljiwv"&&(Oe.textContent=kn),os=a(e),c(et.$$.fragment,e),rs=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1ary2hj"&&(tt.textContent=xn),ps=a(e),c(lt.$$.fragment,e),cs=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-k1eeda"&&(st.innerHTML=Gn),hs=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1mvdyro"&&(nt.innerHTML=Zn),ds=a(e),at=o(e,"TABLE",{"data-svelte-h":!0}),r(at)!=="svelte-10vryw9"&&(at.innerHTML=Bn),Ms=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1w06i7z"&&(it.textContent=Xn),us=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1ryvxjm"&&(ot.innerHTML=Vn),ms=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-yo8880"&&(rt.innerHTML=Rn),ys=a(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-nt4ns1"&&(pt.innerHTML=Hn),ws=a(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1jhde3j"&&(ct.textContent=Nn),Ts=a(e),c(ht.$$.fragment,e),Js=a(e),dt=o(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-14z2x03"&&(dt.innerHTML=An),fs=a(e),c(Mt.$$.fragment,e),gs=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1m7wkzz"&&(ut.innerHTML=En),js=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-ywnn18"&&(mt.textContent=Yn),Us=a(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-7mks79"&&(yt.innerHTML=zn),bs=a(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1i1ixy0"&&(wt.innerHTML=Fn),Cs=a(e),c(Tt.$$.fragment,e),Is=a(e),Jt=o(e,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-5ekp45"&&(Jt.innerHTML=Qn),vs=a(e),c(ft.$$.fragment,e),Ws=a(e),c(gt.$$.fragment,e),_s=a(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-z4yljy"&&(jt.innerHTML=qn),$s=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1kap55g"&&(Ut.innerHTML=Sn),ks=a(e),c(bt.$$.fragment,e),xs=a(e),It=o(e,"P",{}),Pn(It).forEach(l),this.h()},h(){Kn(y,"name","hf:doc:metadata"),Kn(y,"content",Ma)},m(e,t){oa(document.head,y),s(e,w,t),s(e,J,t),s(e,vt,t),h(j,e,t),s(e,Wt,t),h(U,e,t),s(e,_t,t),s(e,b,t),s(e,$t,t),s(e,C,t),s(e,kt,t),s(e,I,t),s(e,xt,t),s(e,v,t),s(e,Gt,t),h(W,e,t),s(e,Zt,t),s(e,_,t),s(e,Bt,t),s(e,$,t),s(e,Xt,t),s(e,k,t),s(e,Vt,t),h(x,e,t),s(e,Rt,t),s(e,G,t),s(e,Ht,t),h(Z,e,t),s(e,Nt,t),h(B,e,t),s(e,At,t),s(e,X,t),s(e,Et,t),s(e,V,t),s(e,Yt,t),h(R,e,t),s(e,zt,t),s(e,H,t),s(e,Ft,t),h(N,e,t),s(e,Qt,t),h(f,e,t),s(e,qt,t),s(e,A,t),s(e,St,t),h(E,e,t),s(e,Lt,t),h(Y,e,t),s(e,Dt,t),s(e,z,t),s(e,Pt,t),s(e,F,t),s(e,Kt,t),s(e,Q,t),s(e,Ot,t),s(e,q,t),s(e,el,t),s(e,S,t),s(e,tl,t),h(L,e,t),s(e,ll,t),s(e,D,t),s(e,sl,t),s(e,P,t),s(e,nl,t),s(e,K,t),s(e,al,t),s(e,O,t),s(e,il,t),h(ee,e,t),s(e,ol,t),s(e,te,t),s(e,rl,t),h(le,e,t),s(e,pl,t),s(e,se,t),s(e,cl,t),h(ne,e,t),s(e,hl,t),s(e,ae,t),s(e,dl,t),h(ie,e,t),s(e,Ml,t),s(e,oe,t),s(e,ul,t),s(e,re,t),s(e,ml,t),h(pe,e,t),s(e,yl,t),s(e,ce,t),s(e,wl,t),s(e,he,t),s(e,Tl,t),h(de,e,t),s(e,Jl,t),s(e,Me,t),s(e,fl,t),h(ue,e,t),s(e,gl,t),s(e,me,t),s(e,jl,t),h(ye,e,t),s(e,Ul,t),s(e,we,t),s(e,bl,t),h(Te,e,t),s(e,Cl,t),s(e,Je,t),s(e,Il,t),h(fe,e,t),s(e,vl,t),s(e,ge,t),s(e,Wl,t),h(je,e,t),s(e,_l,t),s(e,Ue,t),s(e,$l,t),h(be,e,t),s(e,kl,t),s(e,Ce,t),s(e,xl,t),s(e,Ie,t),s(e,Gl,t),s(e,ve,t),s(e,Zl,t),h(We,e,t),s(e,Bl,t),s(e,_e,t),s(e,Xl,t),s(e,$e,t),s(e,Vl,t),s(e,ke,t),s(e,Rl,t),s(e,xe,t),s(e,Hl,t),h(Ge,e,t),s(e,Nl,t),s(e,Ze,t),s(e,Al,t),h(Be,e,t),s(e,El,t),s(e,Xe,t),s(e,Yl,t),h(Ve,e,t),s(e,zl,t),s(e,Re,t),s(e,Fl,t),s(e,He,t),s(e,Ql,t),h(Ne,e,t),s(e,ql,t),s(e,Ae,t),s(e,Sl,t),h(Ee,e,t),s(e,Ll,t),h(Ye,e,t),s(e,Dl,t),s(e,ze,t),s(e,Pl,t),h(Fe,e,t),s(e,Kl,t),s(e,Qe,t),s(e,Ol,t),h(qe,e,t),s(e,es,t),h(Se,e,t),s(e,ts,t),s(e,Le,t),s(e,ls,t),h(De,e,t),s(e,ss,t),h(g,e,t),s(e,ns,t),s(e,Pe,t),s(e,as,t),h(Ke,e,t),s(e,is,t),s(e,Oe,t),s(e,os,t),h(et,e,t),s(e,rs,t),s(e,tt,t),s(e,ps,t),h(lt,e,t),s(e,cs,t),s(e,st,t),s(e,hs,t),s(e,nt,t),s(e,ds,t),s(e,at,t),s(e,Ms,t),s(e,it,t),s(e,us,t),s(e,ot,t),s(e,ms,t),s(e,rt,t),s(e,ys,t),s(e,pt,t),s(e,ws,t),s(e,ct,t),s(e,Ts,t),h(ht,e,t),s(e,Js,t),s(e,dt,t),s(e,fs,t),h(Mt,e,t),s(e,gs,t),s(e,ut,t),s(e,js,t),s(e,mt,t),s(e,Us,t),s(e,yt,t),s(e,bs,t),s(e,wt,t),s(e,Cs,t),h(Tt,e,t),s(e,Is,t),s(e,Jt,t),s(e,vs,t),h(ft,e,t),s(e,Ws,t),h(gt,e,t),s(e,_s,t),s(e,jt,t),s(e,$s,t),s(e,Ut,t),s(e,ks,t),h(bt,e,t),s(e,xs,t),s(e,It,t),Gs=!0},p(e,[t]){const Ln={};t&2&&(Ln.$$scope={dirty:t,ctx:e}),f.$set(Ln);const Dn={};t&2&&(Dn.$$scope={dirty:t,ctx:e}),g.$set(Dn)},i(e){Gs||(d(j.$$.fragment,e),d(U.$$.fragment,e),d(W.$$.fragment,e),d(x.$$.fragment,e),d(Z.$$.fragment,e),d(B.$$.fragment,e),d(R.$$.fragment,e),d(N.$$.fragment,e),d(f.$$.fragment,e),d(E.$$.fragment,e),d(Y.$$.fragment,e),d(L.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(ye.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),d(je.$$.fragment,e),d(be.$$.fragment,e),d(We.$$.fragment,e),d(Ge.$$.fragment,e),d(Be.$$.fragment,e),d(Ve.$$.fragment,e),d(Ne.$$.fragment,e),d(Ee.$$.fragment,e),d(Ye.$$.fragment,e),d(Fe.$$.fragment,e),d(qe.$$.fragment,e),d(Se.$$.fragment,e),d(De.$$.fragment,e),d(g.$$.fragment,e),d(Ke.$$.fragment,e),d(et.$$.fragment,e),d(lt.$$.fragment,e),d(ht.$$.fragment,e),d(Mt.$$.fragment,e),d(Tt.$$.fragment,e),d(ft.$$.fragment,e),d(gt.$$.fragment,e),d(bt.$$.fragment,e),Gs=!0)},o(e){M(j.$$.fragment,e),M(U.$$.fragment,e),M(W.$$.fragment,e),M(x.$$.fragment,e),M(Z.$$.fragment,e),M(B.$$.fragment,e),M(R.$$.fragment,e),M(N.$$.fragment,e),M(f.$$.fragment,e),M(E.$$.fragment,e),M(Y.$$.fragment,e),M(L.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(pe.$$.fragment,e),M(de.$$.fragment,e),M(ue.$$.fragment,e),M(ye.$$.fragment,e),M(Te.$$.fragment,e),M(fe.$$.fragment,e),M(je.$$.fragment,e),M(be.$$.fragment,e),M(We.$$.fragment,e),M(Ge.$$.fragment,e),M(Be.$$.fragment,e),M(Ve.$$.fragment,e),M(Ne.$$.fragment,e),M(Ee.$$.fragment,e),M(Ye.$$.fragment,e),M(Fe.$$.fragment,e),M(qe.$$.fragment,e),M(Se.$$.fragment,e),M(De.$$.fragment,e),M(g.$$.fragment,e),M(Ke.$$.fragment,e),M(et.$$.fragment,e),M(lt.$$.fragment,e),M(ht.$$.fragment,e),M(Mt.$$.fragment,e),M(Tt.$$.fragment,e),M(ft.$$.fragment,e),M(gt.$$.fragment,e),M(bt.$$.fragment,e),Gs=!1},d(e){e&&(l(w),l(J),l(vt),l(Wt),l(_t),l(b),l($t),l(C),l(kt),l(I),l(xt),l(v),l(Gt),l(Zt),l(_),l(Bt),l($),l(Xt),l(k),l(Vt),l(Rt),l(G),l(Ht),l(Nt),l(At),l(X),l(Et),l(V),l(Yt),l(zt),l(H),l(Ft),l(Qt),l(qt),l(A),l(St),l(Lt),l(Dt),l(z),l(Pt),l(F),l(Kt),l(Q),l(Ot),l(q),l(el),l(S),l(tl),l(ll),l(D),l(sl),l(P),l(nl),l(K),l(al),l(O),l(il),l(ol),l(te),l(rl),l(pl),l(se),l(cl),l(hl),l(ae),l(dl),l(Ml),l(oe),l(ul),l(re),l(ml),l(yl),l(ce),l(wl),l(he),l(Tl),l(Jl),l(Me),l(fl),l(gl),l(me),l(jl),l(Ul),l(we),l(bl),l(Cl),l(Je),l(Il),l(vl),l(ge),l(Wl),l(_l),l(Ue),l($l),l(kl),l(Ce),l(xl),l(Ie),l(Gl),l(ve),l(Zl),l(Bl),l(_e),l(Xl),l($e),l(Vl),l(ke),l(Rl),l(xe),l(Hl),l(Nl),l(Ze),l(Al),l(El),l(Xe),l(Yl),l(zl),l(Re),l(Fl),l(He),l(Ql),l(ql),l(Ae),l(Sl),l(Ll),l(Dl),l(ze),l(Pl),l(Kl),l(Qe),l(Ol),l(es),l(ts),l(Le),l(ls),l(ss),l(ns),l(Pe),l(as),l(is),l(Oe),l(os),l(rs),l(tt),l(ps),l(cs),l(st),l(hs),l(nt),l(ds),l(at),l(Ms),l(it),l(us),l(ot),l(ms),l(rt),l(ys),l(pt),l(ws),l(ct),l(Ts),l(Js),l(dt),l(fs),l(gs),l(ut),l(js),l(mt),l(Us),l(yt),l(bs),l(wt),l(Cs),l(Is),l(Jt),l(vs),l(Ws),l(_s),l(jt),l($s),l(Ut),l(ks),l(xs),l(It)),l(y),u(j,e),u(U,e),u(W,e),u(x,e),u(Z,e),u(B,e),u(R,e),u(N,e),u(f,e),u(E,e),u(Y,e),u(L,e),u(ee,e),u(le,e),u(ne,e),u(ie,e),u(pe,e),u(de,e),u(ue,e),u(ye,e),u(Te,e),u(fe,e),u(je,e),u(be,e),u(We,e),u(Ge,e),u(Be,e),u(Ve,e),u(Ne,e),u(Ee,e),u(Ye,e),u(Fe,e),u(qe,e),u(Se,e),u(De,e),u(g,e),u(Ke,e),u(et,e),u(lt,e),u(ht,e),u(Mt,e),u(Tt,e),u(ft,e),u(gt,e),u(bt,e)}}}const Ma='{"title":"Fine-tuning the ASR model","local":"fine-tuning-the-asr-model","sections":[{"title":"Prepare Environment","local":"prepare-environment","sections":[],"depth":2},{"title":"Load Dataset","local":"load-dataset","sections":[],"depth":2},{"title":"Feature Extractor, Tokenizer and Processor","local":"feature-extractor-tokenizer-and-processor","sections":[],"depth":2},{"title":"Pre-Process the Data","local":"pre-process-the-data","sections":[],"depth":2},{"title":"Training and Evaluation","local":"training-and-evaluation","sections":[{"title":"Define a Data Collator","local":"define-a-data-collator","sections":[],"depth":3},{"title":"Evaluation Metrics","local":"evaluation-metrics","sections":[],"depth":3},{"title":"Load a Pre-Trained Checkpoint","local":"load-a-pre-trained-checkpoint","sections":[],"depth":3}],"depth":2},{"title":"Define the Training Configuration","local":"define-the-training-configuration","sections":[{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Sharing Your Model","local":"sharing-your-model","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function ua(Ct){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fa extends na{constructor(y){super(),aa(this,y,ua,da,la,{})}}export{fa as component};
