import{s as as,o as ss}from"../chunks/scheduler.cd324960.js";import{S as is,i as ns,e as l,s as i,c as m,h as ls,a as o,d as a,b as n,f as Ka,g as u,j as r,k as ze,l as os,m as s,n as h,t as c,o as d,p as f,q as es,r as ts}from"../chunks/index.d5c3adcc.js";import{T as Oa}from"../chunks/Tip.889bec11.js";import{C as rs,H as Ge,E as ps}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.5025912f.js";import{C as Ie}from"../chunks/CodeBlock.12aa859f.js";function ms(Be){let p;return{c(){p=es(`💡 In practice, people use the term FFT interchangeably with DFT, as the FFT or Fast Fourier Transform is the only efficient
way to calculate the DFT on a computer.`)},l(g){p=ts(g,`💡 In practice, people use the term FFT interchangeably with DFT, as the FFT or Fast Fourier Transform is the only efficient
way to calculate the DFT on a computer.`)},m(g,w){s(g,p,w)},d(g){g&&a(p)}}}function us(Be){let p;return{c(){p=es(`💡 Not all mel spectrograms are the same! There are two different mel scales in common use ("htk" and "slaney"),
and instead of the power spectrogram the amplitude spectrogram may be used. The conversion to a log-mel spectrogram doesn't
always compute true decibels but may simply take the \`log\`. Therefore, if a machine learning model expects a mel spectrogram
as input, double check to make sure you're computing it the same way.`)},l(g){p=ts(g,`💡 Not all mel spectrograms are the same! There are two different mel scales in common use ("htk" and "slaney"),
and instead of the power spectrogram the amplitude spectrogram may be used. The conversion to a log-mel spectrogram doesn't
always compute true decibels but may simply take the \`log\`. Therefore, if a machine learning model expects a mel spectrogram
as input, double check to make sure you're computing it the same way.`)},m(g,w){s(g,p,w)},d(g){g&&a(p)}}}function hs(Be){let p,g,w,Le,$,Ze,k,Se,_,Ot=`By nature, a sound wave is a continuous signal, meaning it contains an infinite number of signal values in a given time.
This poses problems for digital devices which expect finite arrays. To be processed, stored, and transmitted by digital
devices, the continuous sound wave needs to be converted into a series of discrete values, known as a digital representation.`,Ue,J,ea=`If you look at any audio dataset, you’ll find digital files with sound excerpts, such as text narration or music.
You may encounter different file formats such as <code>.wav</code> (Waveform Audio File), <code>.flac</code> (Free Lossless Audio Codec)
and <code>.mp3</code> (MPEG-1 Audio Layer 3). These formats mainly differ in how they compress the digital representation of the audio signal.`,Pe,H,ta=`Let’s take a look at how we arrive from a continuous signal to this representation. The analog signal is first captured by
a microphone, which converts the sound waves into an electrical signal. The electrical signal is then digitized by an
Analog-to-Digital Converter to get the digital representation through sampling.`,Xe,q,Ee,j,aa=`Sampling is the process of measuring the value of a continuous signal at fixed time steps. The sampled waveform is <em>discrete</em>,
since it contains a finite number of signal values at uniform intervals.`,We,v,sa='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/Signal_Sampling.png" alt="Signal sampling illustration"/>',Ye,z,ia='<em>Illustration from Wikipedia article: <a href="https://en.wikipedia.org/wiki/Sampling_(signal_processing)" rel="nofollow">Sampling (signal processing)</a></em>',Re,G,na=`The <strong>sampling rate</strong> (also called sampling frequency) is the number of samples taken in one second and is measured in
hertz (Hz). To give you a point of reference, CD-quality audio has a sampling rate of 44,100 Hz, meaning samples are taken
44,100 times per second. For comparison, high-resolution audio has a sampling rate of 192,000 Hz or 192 kHz. A common
sampling rate used in training speech models is 16,000 Hz or 16 kHz.`,Ve,B,la=`The choice of sampling rate primarily determines the highest frequency that can be captured from the signal. This is also
known as the Nyquist limit and is exactly half the sampling rate. The audible frequencies in human speech are below 8 kHz
and therefore sampling speech at 16 kHz is sufficient. Using a higher sampling rate will not capture more information and
merely leads to an increase in the computational cost of processing such files. On the other hand, sampling audio at too
low a sampling rate will result in information loss. Speech sampled at 8 kHz will sound muffled, as the higher frequencies
cannot be captured at this rate.`,Ne,I,oa=`It’s important to ensure that all audio examples in your dataset have the same sampling rate when working on any audio task.
If you plan to use custom audio data to fine-tune a pre-trained model, the sampling rate of your data should match the
sampling rate of the data the model was pre-trained on. The sampling rate determines the time interval between successive
audio samples, which impacts the temporal resolution of the audio data. Consider an example: a 5-second sound at a sampling
rate of 16,000 Hz will be represented as a series of 80,000 values, while the same 5-second sound at a sampling rate of
8,000 Hz will be represented as a series of 40,000 values. Transformer models that solve audio tasks treat examples as
sequences and rely on attention mechanisms to learn audio or multimodal representation. Since sequences are different for
audio examples at different sampling rates, it will be challenging for models to generalize between sampling rates.
<strong>Resampling</strong> is the process of making the sampling rates match, and is part of <a href="preprocessing#resampling-the-audio-data">preprocessing</a> the audio data.`,De,F,Qe,L,ra="While the sampling rate tells you how often the samples are taken, what exactly are the values in each sample?",Ae,Z,pa=`Sound is made by changes in air pressure at frequencies that are audible to humans. The <strong>amplitude</strong> of a sound describes
the sound pressure level at any given instant and is measured in decibels (dB). We perceive the amplitude as loudness.
To give you an example, a normal speaking voice is under 60 dB, and a rock concert can be at around 125 dB, pushing the
limits of human hearing.`,Ke,S,ma=`In digital audio, each audio sample records the amplitude of the audio wave at a point in time. The <strong>bit depth</strong> of the
sample determines with how much precision this amplitude value can be described. The higher the bit depth, the more
faithfully the digital representation approximates the original continuous sound wave.`,Oe,U,ua=`The most common audio bit depths are 16-bit and 24-bit. Each is a binary term, representing the number of possible steps
to which the amplitude value can be quantized when it’s converted from continuous to discrete: 65,536 steps for 16-bit audio,
a whopping 16,777,216 steps for 24-bit audio. Because quantizing involves rounding off the continuous value to a discrete
value, the sampling process introduces noise. The higher the bit depth, the smaller this quantization noise. In practice,
the quantization noise of 16-bit audio is already small enough to be inaudible, and using higher bit depths is generally
not necessary.`,et,P,ha=`You may also come across 32-bit audio. This stores the samples as floating-point values, whereas 16-bit and 24-bit audio
use integer samples. The precision of a 32-bit floating-point value is 24 bits, giving it the same bit depth as 24-bit audio.
Floating-point audio samples are expected to lie within the [-1.0, 1.0] range. Since machine learning models naturally
work on floating-point data, the audio must first be converted into floating-point format before it can be used to train
the model. We’ll see how to do this in the next section on <a href="preprocessing">Preprocessing</a>.`,tt,X,ca=`Just as with continuous audio signals, the amplitude of digital audio is typically expressed in decibels (dB). Since
human hearing is logarithmic in nature — our ears are more sensitive to small fluctuations in quiet sounds than in loud
sounds — the loudness of a sound is easier to interpret if the amplitudes are in decibels, which are also logarithmic.
The decibel scale for real-world audio starts at 0 dB, which represents the quietest possible sound humans can hear, and
louder sounds have larger values. However, for digital audio signals, 0 dB is the loudest possible amplitude, while all
other amplitudes are negative. As a quick rule of thumb: every -6 dB is a halving of the amplitude, and anything below -60 dB
is generally inaudible unless you really crank up the volume.`,at,E,st,W,da=`You may have seen sounds visualized as a <strong>waveform</strong>, which plots the sample values over time and illustrates the changes
in the sound’s amplitude. This is also known as the <em>time domain</em> representation of sound.`,it,Y,fa=`This type of visualization is useful for identifying specific features of the audio signal such as the timing of individual
sound events, the overall loudness of the signal, and any irregularities or noise present in the audio.`,nt,R,ga="To plot the waveform for an audio signal, we can use a Python library called <code>librosa</code>:",lt,V,ot,N,wa="Let’s take an example sound called “trumpet” that comes with the library:",rt,D,pt,Q,va=`The example is loaded as a tuple of audio time series (here we call it <code>array</code>), and sampling rate (<code>sampling_rate</code>).
Let’s take a look at this sound’s waveform by using librosa’s <code>waveshow()</code> function:`,mt,A,ut,b,ba='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_plot.png" alt="Waveform plot"/>',ht,K,ya=`This plots the amplitude of the signal on the y-axis and time along the x-axis. In other words, each point corresponds
to a single sample value that was taken when this sound was sampled. Also note that librosa returns the audio as
floating-point values already, and that the amplitude values are indeed within the [-1.0, 1.0] range.`,ct,O,Ta=`Visualizing the audio along with listening to it can be a useful tool for understanding the data you are working with.
You can see the shape of the signal, observe patterns, learn to spot noise or distortion. If you preprocess data in some
ways, such as normalization, resampling, or filtering, you can visually confirm that preprocessing steps have been applied as expected.
After training a model, you can also visualize samples where errors occur (e.g. in audio classification task) to debug
the issue.`,dt,ee,ft,te,xa=`Another way to visualize audio data is to plot the <strong>frequency spectrum</strong> of an audio signal, also known as the <em>frequency domain</em>
representation. The spectrum is computed using the discrete Fourier transform or DFT. It describes the individual frequencies
that make up the signal and how strong they are.`,gt,ae,Ma=`Let’s plot the frequency spectrum for the same trumpet sound by taking the DFT using numpy’s <code>rfft()</code> function. While it
is possible to plot the spectrum of the entire sound, it’s more useful to look at a small region instead. Here we’ll take
the DFT over the first 4096 samples, which is roughly the length of the first note being played:`,wt,se,vt,y,Ca='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/spectrum_plot.png" alt="Spectrum plot"/>',bt,ie,$a=`This plots the strength of the various frequency components that are present in this audio segment. The frequency values are on
the x-axis, usually plotted on a logarithmic scale, while their amplitudes are on the y-axis.`,yt,ne,ka=`The frequency spectrum that we plotted shows several peaks. These peaks correspond to the harmonics of the note that’s
being played, with the higher harmonics being quieter. Since the first peak is at around 620 Hz, this is the frequency spectrum of an E♭ note.`,Tt,le,_a=`The output of the DFT is an array of complex numbers, made up of real and imaginary components. Taking
the magnitude with <code>np.abs(dft)</code> extracts the amplitude information from the spectrogram. The angle between the real and
imaginary components provides the so-called phase spectrum, but this is often discarded in machine learning applications.`,xt,oe,Ja=`You used <code>librosa.amplitude_to_db()</code> to convert the amplitude values to the decibel scale, making it easier to see
the finer details in the spectrum. Sometimes people use the <strong>power spectrum</strong>, which measures energy rather than amplitude;
this is simply a spectrum with the amplitude values squared.`,Mt,T,Ct,re,Ha=`The frequency spectrum of an audio signal contains the exact same information as its waveform — they are simply two different
ways of looking at the same data (here, the first 4096 samples from the trumpet sound). Where the waveform plots the amplitude
of the audio signal over time, the spectrum visualizes the amplitudes of the individual frequencies at a fixed point in time.`,$t,pe,kt,me,qa=`What if we want to see how the frequencies in an audio signal change? The trumpet plays several notes and they all have
different frequencies. The problem is that the spectrum only shows a frozen snapshot of the frequencies at a given instant.
The solution is to take multiple DFTs, each covering only a small slice of time, and stack the resulting spectra together
into a <strong>spectrogram</strong>.`,_t,ue,ja=`A spectrogram plots the frequency content of an audio signal as it changes over time. It allows you to see time, frequency,
and amplitude all on one graph. The algorithm that performs this computation is the STFT or Short Time Fourier Transform.`,Jt,he,za=`The spectrogram is one of the most informative audio tools available to you. For example, when working with a music recording,
you can see the various instruments and vocal tracks and how they contribute to the overall sound. In speech, you can
identify different vowel sounds as each vowel is characterized by particular frequencies.`,Ht,ce,Ga="Let’s plot a spectrogram for the same trumpet sound, using librosa’s <code>stft()</code> and <code>specshow()</code> functions:",qt,de,jt,x,Ba='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/spectrogram_plot.png" alt="Spectrogram plot"/>',zt,fe,Ia=`In this plot, the x-axis represents time as in the waveform visualization but now the y-axis represents frequency in Hz.
The intensity of the color gives the amplitude or power of the frequency component at each point in time, measured in decibels (dB).`,Gt,ge,Fa=`The spectrogram is created by taking short segments of the audio signal, typically lasting a few milliseconds, and calculating
the discrete Fourier transform of each segment to obtain its frequency spectrum. The resulting spectra are then stacked
together on the time axis to create the spectrogram. Each vertical slice in this image corresponds to a single frequency
spectrum, seen from the top. By default, <code>librosa.stft()</code> splits the audio signal into segments of 2048 samples, which
gives a good trade-off between frequency resolution and time resolution.`,Bt,we,La=`Since the spectrogram and the waveform are different views of the same data, it’s possible to turn the spectrogram back
into the original waveform using the inverse STFT. However, this requires the phase information in addition to the amplitude
information. If the spectrogram was generated by a machine learning model, it typically only outputs the amplitudes. In
that case, we can use a phase reconstruction algorithm such as the classic Griffin-Lim algorithm, or using a neural network
called a vocoder, to reconstruct a waveform from the spectrogram.`,It,ve,Za=`Spectrograms aren’t just used for visualization. Many machine learning models will take spectrograms as input — as opposed
to waveforms — and produce spectrograms as output.`,Ft,be,Sa="Now that we know what a spectrogram is and how it’s made, let’s take a look at a variant of it widely used for speech processing: the mel spectrogram.",Lt,ye,Zt,Te,Ua=`A mel spectrogram is a variation of the spectrogram that is commonly used in speech processing and machine learning tasks.
It is similar to a spectrogram in that it shows the frequency content of an audio signal over time, but on a different frequency axis.`,St,xe,Pa=`In a standard spectrogram, the frequency axis is linear and is measured in hertz (Hz). However, the human auditory system
is more sensitive to changes in lower frequencies than higher frequencies, and this sensitivity decreases logarithmically
as frequency increases. The mel scale is a perceptual scale that approximates the non-linear frequency response of the human ear.`,Ut,Me,Xa=`To create a mel spectrogram, the STFT is used just like before, splitting the audio into short segments to obtain a sequence
of frequency spectra. Additionally, each spectrum is sent through a set of filters, the so-called mel filterbank, to
transform the frequencies to the mel scale.`,Pt,Ce,Ea="Let’s see how we can plot a mel spectrogram using librosa’s <code>melspectrogram()</code> function, which performs all of those steps for us:",Xt,$e,Et,M,Wa='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/mel-spectrogram.png" alt="Mel spectrogram plot"/>',Wt,ke,Ya=`In the example above, <code>n_mels</code> stands for the number of mel bands to generate. The mel bands define a set of frequency
ranges that divide the spectrum into perceptually meaningful components, using a set of filters whose shape and spacing
are chosen to mimic the way the human ear responds to different frequencies. Common values for <code>n_mels</code> are 40 or 80. <code>fmax</code>
indicates the highest frequency (in Hz) we care about.`,Yt,_e,Ra=`Just as with a regular spectrogram, it’s common practice to express the strength of the mel frequency components in
decibels. This is commonly referred to as a <strong>log-mel spectrogram</strong>, because the conversion to decibels involves a
logarithmic operation. The above example used <code>librosa.power_to_db()</code> as <code>librosa.feature.melspectrogram()</code> creates a power spectrogram.`,Rt,C,Vt,Je,Va=`Creating a mel spectrogram is a lossy operation as it involves filtering the signal. Converting a mel spectrogram back
into a waveform is more difficult than doing this for a regular spectrogram, as it requires estimating the frequencies
that were thrown away. This is why machine learning models such as HiFiGAN vocoder are needed to produce a waveform from a mel
spectrogram.`,Nt,He,Na=`Compared to a standard spectrogram, a mel spectrogram can capture more meaningful features of the audio signal for
human perception, making it a popular choice in tasks such as speech recognition, speaker identification, and music genre classification.`,Dt,qe,Da="Now that you know how to visualize audio data examples, go ahead and try to see what your favorite sounds look like. :)",Qt,je,At,Fe,Kt;return $=new rs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),k=new Ge({props:{title:"Introduction to audio data",local:"introduction-to-audio-data",headingTag:"h1"}}),q=new Ge({props:{title:"Sampling and sampling rate",local:"sampling-and-sampling-rate",headingTag:"h2"}}),F=new Ge({props:{title:"Amplitude and bit depth",local:"amplitude-and-bit-depth",headingTag:"h2"}}),E=new Ge({props:{title:"Audio as a waveform",local:"audio-as-a-waveform",headingTag:"h2"}}),V=new Ie({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxpYnJvc2E=",highlighted:"pip install librosa",wrap:!1}}),D=new Ie({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQSUwQWFycmF5JTJDJTIwc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGxpYnJvc2EubG9hZChsaWJyb3NhLmV4KCUyMnRydW1wZXQlMjIpKQ==",highlighted:`<span class="hljs-keyword">import</span> librosa

array, sampling_rate = librosa.load(librosa.ex(<span class="hljs-string">&quot;trumpet&quot;</span>))`,wrap:!1}}),A=new Ie({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMGxpYnJvc2EuZGlzcGxheSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LndhdmVzaG93KGFycmF5JTJDJTIwc3IlM0RzYW1wbGluZ19yYXRlKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),ee=new Ge({props:{title:"The frequency spectrum",local:"the-frequency-spectrum",headingTag:"h2"}}),se=new Ie({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZGZ0X2lucHV0JTIwJTNEJTIwYXJyYXklNUIlM0E0MDk2JTVEJTBBJTBBJTIzJTIwY2FsY3VsYXRlJTIwdGhlJTIwREZUJTBBd2luZG93JTIwJTNEJTIwbnAuaGFubmluZyhsZW4oZGZ0X2lucHV0KSklMEF3aW5kb3dlZF9pbnB1dCUyMCUzRCUyMGRmdF9pbnB1dCUyMColMjB3aW5kb3clMEFkZnQlMjAlM0QlMjBucC5mZnQucmZmdCh3aW5kb3dlZF9pbnB1dCklMEElMEElMjMlMjBnZXQlMjB0aGUlMjBhbXBsaXR1ZGUlMjBzcGVjdHJ1bSUyMGluJTIwZGVjaWJlbHMlMEFhbXBsaXR1ZGUlMjAlM0QlMjBucC5hYnMoZGZ0KSUwQWFtcGxpdHVkZV9kYiUyMCUzRCUyMGxpYnJvc2EuYW1wbGl0dWRlX3RvX2RiKGFtcGxpdHVkZSUyQyUyMHJlZiUzRG5wLm1heCklMEElMEElMjMlMjBnZXQlMjB0aGUlMjBmcmVxdWVuY3klMjBiaW5zJTBBZnJlcXVlbmN5JTIwJTNEJTIwbGlicm9zYS5mZnRfZnJlcXVlbmNpZXMoc3IlM0RzYW1wbGluZ19yYXRlJTJDJTIwbl9mZnQlM0RsZW4oZGZ0X2lucHV0KSklMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQXBsdC5wbG90KGZyZXF1ZW5jeSUyQyUyMGFtcGxpdHVkZV9kYiklMEFwbHQueGxhYmVsKCUyMkZyZXF1ZW5jeSUyMChIeiklMjIpJTBBcGx0LnlsYWJlbCglMjJBbXBsaXR1ZGUlMjAoZEIpJTIyKSUwQXBsdC54c2NhbGUoJTIybG9nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

dft_input = array[:<span class="hljs-number">4096</span>]

<span class="hljs-comment"># calculate the DFT</span>
window = np.hanning(<span class="hljs-built_in">len</span>(dft_input))
windowed_input = dft_input * window
dft = np.fft.rfft(windowed_input)

<span class="hljs-comment"># get the amplitude spectrum in decibels</span>
amplitude = np.<span class="hljs-built_in">abs</span>(dft)
amplitude_db = librosa.amplitude_to_db(amplitude, ref=np.<span class="hljs-built_in">max</span>)

<span class="hljs-comment"># get the frequency bins</span>
frequency = librosa.fft_frequencies(sr=sampling_rate, n_fft=<span class="hljs-built_in">len</span>(dft_input))

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
plt.plot(frequency, amplitude_db)
plt.xlabel(<span class="hljs-string">&quot;Frequency (Hz)&quot;</span>)
plt.ylabel(<span class="hljs-string">&quot;Amplitude (dB)&quot;</span>)
plt.xscale(<span class="hljs-string">&quot;log&quot;</span>)`,wrap:!1}}),T=new Oa({props:{$$slots:{default:[ms]},$$scope:{ctx:Be}}}),pe=new Ge({props:{title:"Spectrogram",local:"spectrogram",headingTag:"h2"}}),de=new Ie({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBRCUyMCUzRCUyMGxpYnJvc2Euc3RmdChhcnJheSklMEFTX2RiJTIwJTNEJTIwbGlicm9zYS5hbXBsaXR1ZGVfdG9fZGIobnAuYWJzKEQpJTJDJTIwcmVmJTNEbnAubWF4KSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LnNwZWNzaG93KFNfZGIlMkMlMjB4X2F4aXMlM0QlMjJ0aW1lJTIyJTJDJTIweV9heGlzJTNEJTIyaHolMjIpJTBBcGx0LmNvbG9yYmFyKCk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

D = librosa.stft(array)
S_db = librosa.amplitude_to_db(np.<span class="hljs-built_in">abs</span>(D), ref=np.<span class="hljs-built_in">max</span>)

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(S_db, x_axis=<span class="hljs-string">&quot;time&quot;</span>, y_axis=<span class="hljs-string">&quot;hz&quot;</span>)
plt.colorbar()`,wrap:!1}}),ye=new Ge({props:{title:"Mel spectrogram",local:"mel-spectrogram",headingTag:"h2"}}),$e=new Ie({props:{code:"UyUyMCUzRCUyMGxpYnJvc2EuZmVhdHVyZS5tZWxzcGVjdHJvZ3JhbSh5JTNEYXJyYXklMkMlMjBzciUzRHNhbXBsaW5nX3JhdGUlMkMlMjBuX21lbHMlM0QxMjglMkMlMjBmbWF4JTNEODAwMCklMEFTX2RCJTIwJTNEJTIwbGlicm9zYS5wb3dlcl90b19kYihTJTJDJTIwcmVmJTNEbnAubWF4KSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LnNwZWNzaG93KFNfZEIlMkMlMjB4X2F4aXMlM0QlMjJ0aW1lJTIyJTJDJTIweV9heGlzJTNEJTIybWVsJTIyJTJDJTIwc3IlM0RzYW1wbGluZ19yYXRlJTJDJTIwZm1heCUzRDgwMDApJTBBcGx0LmNvbG9yYmFyKCk=",highlighted:`S = librosa.feature.melspectrogram(y=array, sr=sampling_rate, n_mels=<span class="hljs-number">128</span>, fmax=<span class="hljs-number">8000</span>)
S_dB = librosa.power_to_db(S, ref=np.<span class="hljs-built_in">max</span>)

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(S_dB, x_axis=<span class="hljs-string">&quot;time&quot;</span>, y_axis=<span class="hljs-string">&quot;mel&quot;</span>, sr=sampling_rate, fmax=<span class="hljs-number">8000</span>)
plt.colorbar()`,wrap:!1}}),C=new Oa({props:{$$slots:{default:[us]},$$scope:{ctx:Be}}}),je=new ps({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter1/audio_data.mdx"}}),{c(){p=l("meta"),g=i(),w=l("p"),Le=i(),m($.$$.fragment),Ze=i(),m(k.$$.fragment),Se=i(),_=l("p"),_.textContent=Ot,Ue=i(),J=l("p"),J.innerHTML=ea,Pe=i(),H=l("p"),H.textContent=ta,Xe=i(),m(q.$$.fragment),Ee=i(),j=l("p"),j.innerHTML=aa,We=i(),v=l("div"),v.innerHTML=sa,Ye=i(),z=l("p"),z.innerHTML=ia,Re=i(),G=l("p"),G.innerHTML=na,Ve=i(),B=l("p"),B.textContent=la,Ne=i(),I=l("p"),I.innerHTML=oa,De=i(),m(F.$$.fragment),Qe=i(),L=l("p"),L.textContent=ra,Ae=i(),Z=l("p"),Z.innerHTML=pa,Ke=i(),S=l("p"),S.innerHTML=ma,Oe=i(),U=l("p"),U.textContent=ua,et=i(),P=l("p"),P.innerHTML=ha,tt=i(),X=l("p"),X.textContent=ca,at=i(),m(E.$$.fragment),st=i(),W=l("p"),W.innerHTML=da,it=i(),Y=l("p"),Y.textContent=fa,nt=i(),R=l("p"),R.innerHTML=ga,lt=i(),m(V.$$.fragment),ot=i(),N=l("p"),N.textContent=wa,rt=i(),m(D.$$.fragment),pt=i(),Q=l("p"),Q.innerHTML=va,mt=i(),m(A.$$.fragment),ut=i(),b=l("div"),b.innerHTML=ba,ht=i(),K=l("p"),K.textContent=ya,ct=i(),O=l("p"),O.textContent=Ta,dt=i(),m(ee.$$.fragment),ft=i(),te=l("p"),te.innerHTML=xa,gt=i(),ae=l("p"),ae.innerHTML=Ma,wt=i(),m(se.$$.fragment),vt=i(),y=l("div"),y.innerHTML=Ca,bt=i(),ie=l("p"),ie.textContent=$a,yt=i(),ne=l("p"),ne.textContent=ka,Tt=i(),le=l("p"),le.innerHTML=_a,xt=i(),oe=l("p"),oe.innerHTML=Ja,Mt=i(),m(T.$$.fragment),Ct=i(),re=l("p"),re.textContent=Ha,$t=i(),m(pe.$$.fragment),kt=i(),me=l("p"),me.innerHTML=qa,_t=i(),ue=l("p"),ue.textContent=ja,Jt=i(),he=l("p"),he.textContent=za,Ht=i(),ce=l("p"),ce.innerHTML=Ga,qt=i(),m(de.$$.fragment),jt=i(),x=l("div"),x.innerHTML=Ba,zt=i(),fe=l("p"),fe.textContent=Ia,Gt=i(),ge=l("p"),ge.innerHTML=Fa,Bt=i(),we=l("p"),we.textContent=La,It=i(),ve=l("p"),ve.textContent=Za,Ft=i(),be=l("p"),be.textContent=Sa,Lt=i(),m(ye.$$.fragment),Zt=i(),Te=l("p"),Te.textContent=Ua,St=i(),xe=l("p"),xe.textContent=Pa,Ut=i(),Me=l("p"),Me.textContent=Xa,Pt=i(),Ce=l("p"),Ce.innerHTML=Ea,Xt=i(),m($e.$$.fragment),Et=i(),M=l("div"),M.innerHTML=Wa,Wt=i(),ke=l("p"),ke.innerHTML=Ya,Yt=i(),_e=l("p"),_e.innerHTML=Ra,Rt=i(),m(C.$$.fragment),Vt=i(),Je=l("p"),Je.textContent=Va,Nt=i(),He=l("p"),He.textContent=Na,Dt=i(),qe=l("p"),qe.textContent=Da,Qt=i(),m(je.$$.fragment),At=i(),Fe=l("p"),this.h()},l(e){const t=ls("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(a),g=n(e),w=o(e,"P",{}),Ka(w).forEach(a),Le=n(e),u($.$$.fragment,e),Ze=n(e),u(k.$$.fragment,e),Se=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1pmkh95"&&(_.textContent=Ot),Ue=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-bb9jdf"&&(J.innerHTML=ea),Pe=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1nxlqp8"&&(H.textContent=ta),Xe=n(e),u(q.$$.fragment,e),Ee=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ou5bn8"&&(j.innerHTML=aa),We=n(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1g809yq"&&(v.innerHTML=sa),Ye=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-42toji"&&(z.innerHTML=ia),Re=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1bavgg"&&(G.innerHTML=na),Ve=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-erenf"&&(B.textContent=la),Ne=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-vwfzx1"&&(I.innerHTML=oa),De=n(e),u(F.$$.fragment,e),Qe=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-aeraln"&&(L.textContent=ra),Ae=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-c1topq"&&(Z.innerHTML=pa),Ke=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-17m5t67"&&(S.innerHTML=ma),Oe=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-r3waof"&&(U.textContent=ua),et=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1mkb3me"&&(P.innerHTML=ha),tt=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1vo81sc"&&(X.textContent=ca),at=n(e),u(E.$$.fragment,e),st=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1cl8jes"&&(W.innerHTML=da),it=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ef6fws"&&(Y.textContent=fa),nt=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-7fbxqn"&&(R.innerHTML=ga),lt=n(e),u(V.$$.fragment,e),ot=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-4c289b"&&(N.textContent=wa),rt=n(e),u(D.$$.fragment,e),pt=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1uo32p8"&&(Q.innerHTML=va),mt=n(e),u(A.$$.fragment,e),ut=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1cse5se"&&(b.innerHTML=ba),ht=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-4i4t88"&&(K.textContent=ya),ct=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-15w4tcn"&&(O.textContent=Ta),dt=n(e),u(ee.$$.fragment,e),ft=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-zbggm7"&&(te.innerHTML=xa),gt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-pcmpy3"&&(ae.innerHTML=Ma),wt=n(e),u(se.$$.fragment,e),vt=n(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1eg4i6m"&&(y.innerHTML=Ca),bt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-2gktww"&&(ie.textContent=$a),yt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1iiz53k"&&(ne.textContent=ka),Tt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1djmz7i"&&(le.innerHTML=_a),xt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1bt1xj3"&&(oe.innerHTML=Ja),Mt=n(e),u(T.$$.fragment,e),Ct=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-59fha7"&&(re.textContent=Ha),$t=n(e),u(pe.$$.fragment,e),kt=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-196s45l"&&(me.innerHTML=qa),_t=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1l55l7k"&&(ue.textContent=ja),Jt=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-u0c2pj"&&(he.textContent=za),Ht=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-rcbtf3"&&(ce.innerHTML=Ga),qt=n(e),u(de.$$.fragment,e),jt=n(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-b6kbs6"&&(x.innerHTML=Ba),zt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1fap1oe"&&(fe.textContent=Ia),Gt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1v7yz7v"&&(ge.innerHTML=Fa),Bt=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-13z5f9l"&&(we.textContent=La),It=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-fc7u1p"&&(ve.textContent=Za),Ft=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-tu7x1"&&(be.textContent=Sa),Lt=n(e),u(ye.$$.fragment,e),Zt=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-naa7dr"&&(Te.textContent=Ua),St=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1x7yj9g"&&(xe.textContent=Pa),Ut=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-9z7nz9"&&(Me.textContent=Xa),Pt=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1bkzq64"&&(Ce.innerHTML=Ea),Xt=n(e),u($e.$$.fragment,e),Et=n(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1soplef"&&(M.innerHTML=Wa),Wt=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-otxgpj"&&(ke.innerHTML=Ya),Yt=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-fposmi"&&(_e.innerHTML=Ra),Rt=n(e),u(C.$$.fragment,e),Vt=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-ph55g"&&(Je.textContent=Va),Nt=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-lsf6hk"&&(He.textContent=Na),Dt=n(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1xaydvu"&&(qe.textContent=Da),Qt=n(e),u(je.$$.fragment,e),At=n(e),Fe=o(e,"P",{}),Ka(Fe).forEach(a),this.h()},h(){ze(p,"name","hf:doc:metadata"),ze(p,"content",cs),ze(v,"class","flex justify-center"),ze(b,"class","flex justify-center"),ze(y,"class","flex justify-center"),ze(x,"class","flex justify-center"),ze(M,"class","flex justify-center")},m(e,t){os(document.head,p),s(e,g,t),s(e,w,t),s(e,Le,t),h($,e,t),s(e,Ze,t),h(k,e,t),s(e,Se,t),s(e,_,t),s(e,Ue,t),s(e,J,t),s(e,Pe,t),s(e,H,t),s(e,Xe,t),h(q,e,t),s(e,Ee,t),s(e,j,t),s(e,We,t),s(e,v,t),s(e,Ye,t),s(e,z,t),s(e,Re,t),s(e,G,t),s(e,Ve,t),s(e,B,t),s(e,Ne,t),s(e,I,t),s(e,De,t),h(F,e,t),s(e,Qe,t),s(e,L,t),s(e,Ae,t),s(e,Z,t),s(e,Ke,t),s(e,S,t),s(e,Oe,t),s(e,U,t),s(e,et,t),s(e,P,t),s(e,tt,t),s(e,X,t),s(e,at,t),h(E,e,t),s(e,st,t),s(e,W,t),s(e,it,t),s(e,Y,t),s(e,nt,t),s(e,R,t),s(e,lt,t),h(V,e,t),s(e,ot,t),s(e,N,t),s(e,rt,t),h(D,e,t),s(e,pt,t),s(e,Q,t),s(e,mt,t),h(A,e,t),s(e,ut,t),s(e,b,t),s(e,ht,t),s(e,K,t),s(e,ct,t),s(e,O,t),s(e,dt,t),h(ee,e,t),s(e,ft,t),s(e,te,t),s(e,gt,t),s(e,ae,t),s(e,wt,t),h(se,e,t),s(e,vt,t),s(e,y,t),s(e,bt,t),s(e,ie,t),s(e,yt,t),s(e,ne,t),s(e,Tt,t),s(e,le,t),s(e,xt,t),s(e,oe,t),s(e,Mt,t),h(T,e,t),s(e,Ct,t),s(e,re,t),s(e,$t,t),h(pe,e,t),s(e,kt,t),s(e,me,t),s(e,_t,t),s(e,ue,t),s(e,Jt,t),s(e,he,t),s(e,Ht,t),s(e,ce,t),s(e,qt,t),h(de,e,t),s(e,jt,t),s(e,x,t),s(e,zt,t),s(e,fe,t),s(e,Gt,t),s(e,ge,t),s(e,Bt,t),s(e,we,t),s(e,It,t),s(e,ve,t),s(e,Ft,t),s(e,be,t),s(e,Lt,t),h(ye,e,t),s(e,Zt,t),s(e,Te,t),s(e,St,t),s(e,xe,t),s(e,Ut,t),s(e,Me,t),s(e,Pt,t),s(e,Ce,t),s(e,Xt,t),h($e,e,t),s(e,Et,t),s(e,M,t),s(e,Wt,t),s(e,ke,t),s(e,Yt,t),s(e,_e,t),s(e,Rt,t),h(C,e,t),s(e,Vt,t),s(e,Je,t),s(e,Nt,t),s(e,He,t),s(e,Dt,t),s(e,qe,t),s(e,Qt,t),h(je,e,t),s(e,At,t),s(e,Fe,t),Kt=!0},p(e,[t]){const Qa={};t&2&&(Qa.$$scope={dirty:t,ctx:e}),T.$set(Qa);const Aa={};t&2&&(Aa.$$scope={dirty:t,ctx:e}),C.$set(Aa)},i(e){Kt||(c($.$$.fragment,e),c(k.$$.fragment,e),c(q.$$.fragment,e),c(F.$$.fragment,e),c(E.$$.fragment,e),c(V.$$.fragment,e),c(D.$$.fragment,e),c(A.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(T.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(ye.$$.fragment,e),c($e.$$.fragment,e),c(C.$$.fragment,e),c(je.$$.fragment,e),Kt=!0)},o(e){d($.$$.fragment,e),d(k.$$.fragment,e),d(q.$$.fragment,e),d(F.$$.fragment,e),d(E.$$.fragment,e),d(V.$$.fragment,e),d(D.$$.fragment,e),d(A.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(T.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),d(ye.$$.fragment,e),d($e.$$.fragment,e),d(C.$$.fragment,e),d(je.$$.fragment,e),Kt=!1},d(e){e&&(a(g),a(w),a(Le),a(Ze),a(Se),a(_),a(Ue),a(J),a(Pe),a(H),a(Xe),a(Ee),a(j),a(We),a(v),a(Ye),a(z),a(Re),a(G),a(Ve),a(B),a(Ne),a(I),a(De),a(Qe),a(L),a(Ae),a(Z),a(Ke),a(S),a(Oe),a(U),a(et),a(P),a(tt),a(X),a(at),a(st),a(W),a(it),a(Y),a(nt),a(R),a(lt),a(ot),a(N),a(rt),a(pt),a(Q),a(mt),a(ut),a(b),a(ht),a(K),a(ct),a(O),a(dt),a(ft),a(te),a(gt),a(ae),a(wt),a(vt),a(y),a(bt),a(ie),a(yt),a(ne),a(Tt),a(le),a(xt),a(oe),a(Mt),a(Ct),a(re),a($t),a(kt),a(me),a(_t),a(ue),a(Jt),a(he),a(Ht),a(ce),a(qt),a(jt),a(x),a(zt),a(fe),a(Gt),a(ge),a(Bt),a(we),a(It),a(ve),a(Ft),a(be),a(Lt),a(Zt),a(Te),a(St),a(xe),a(Ut),a(Me),a(Pt),a(Ce),a(Xt),a(Et),a(M),a(Wt),a(ke),a(Yt),a(_e),a(Rt),a(Vt),a(Je),a(Nt),a(He),a(Dt),a(qe),a(Qt),a(At),a(Fe)),a(p),f($,e),f(k,e),f(q,e),f(F,e),f(E,e),f(V,e),f(D,e),f(A,e),f(ee,e),f(se,e),f(T,e),f(pe,e),f(de,e),f(ye,e),f($e,e),f(C,e),f(je,e)}}}const cs='{"title":"Introduction to audio data","local":"introduction-to-audio-data","sections":[{"title":"Sampling and sampling rate","local":"sampling-and-sampling-rate","sections":[],"depth":2},{"title":"Amplitude and bit depth","local":"amplitude-and-bit-depth","sections":[],"depth":2},{"title":"Audio as a waveform","local":"audio-as-a-waveform","sections":[],"depth":2},{"title":"The frequency spectrum","local":"the-frequency-spectrum","sections":[],"depth":2},{"title":"Spectrogram","local":"spectrogram","sections":[],"depth":2},{"title":"Mel spectrogram","local":"mel-spectrogram","sections":[],"depth":2}],"depth":1}';function ds(Be){return ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends is{constructor(p){super(),ns(this,p,ds,hs,as,{})}}export{ys as component};
