import{s as Xt,o as Vt}from"../chunks/scheduler.cd324960.js";import{S as zt,i as Et,e as i,s as l,c as p,h as Qt,a as o,d as a,b as n,f as qt,g as M,j as r,k as Mt,l as Yt,m as s,n as m,t as u,o as h,p as d,q as St,r as Ft}from"../chunks/index.d5c3adcc.js";import{T as Lt}from"../chunks/Tip.889bec11.js";import{C as Dt,H as pt,E as Pt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.5025912f.js";import{C as y}from"../chunks/CodeBlock.12aa859f.js";function Ot(he){let c;return{c(){c=St(`💡 Some background on resampling: If an audio signal has been sampled at 8 kHz, so that it has 8000 sample readings per
second, we know that the audio does not contain any frequencies over 4 kHz. This is guaranteed by the Nyquist sampling
theorem. Because of this, we can be certain that in between the sampling points the original continuous signal always
makes a smooth curve. Upsampling to a higher sampling rate is then a matter of calculating additional sample values that go in between
the existing ones, by approximating this curve. Downsampling, however, requires that we first filter out any frequencies
that would be higher than the new Nyquist limit, before estimating the new sample points. In other words, you can't
downsample by a factor 2x by simply throwing away every other sample — this will create distortions in the signal called
aliases. Doing resampling correctly is tricky and best left to well-tested libraries such as librosa or 🤗 Datasets.`)},l(f){c=Ft(f,`💡 Some background on resampling: If an audio signal has been sampled at 8 kHz, so that it has 8000 sample readings per
second, we know that the audio does not contain any frequencies over 4 kHz. This is guaranteed by the Nyquist sampling
theorem. Because of this, we can be certain that in between the sampling points the original continuous signal always
makes a smooth curve. Upsampling to a higher sampling rate is then a matter of calculating additional sample values that go in between
the existing ones, by approximating this curve. Downsampling, however, requires that we first filter out any frequencies
that would be higher than the new Nyquist limit, before estimating the new sample points. In other words, you can't
downsample by a factor 2x by simply throwing away every other sample — this will create distortions in the signal called
aliases. Doing resampling correctly is tricky and best left to well-tested libraries such as librosa or 🤗 Datasets.`)},m(f,T){s(f,c,T)},d(f){f&&a(c)}}}function Kt(he){let c,f,T,de,J,ce,U,ye,g,mt=`Loading a dataset with 🤗 Datasets is just half of the fun. If you plan to use it either for training a model, or for running
inference, you will need to pre-process the data first. In general, this will involve the following steps:`,fe,b,ut="<li>Resampling the audio data</li> <li>Filtering the dataset</li> <li>Converting audio data to model’s expected input</li>",we,I,je,C,ht=`The <code>load_dataset</code> function downloads audio examples with the sampling rate that they were published with. This is not
always the sampling rate expected by a model you plan to train, or use for inference. If there’s a discrepancy between
the sampling rates, you can resample the audio to the model’s expected sampling rate.`,Te,A,dt=`Most of the available pretrained models have been pretrained on audio datasets at a sampling rate of 16 kHz.
When we explored MINDS-14 dataset, you may have noticed that it is sampled at 8 kHz, which means we will likely need
to upsample it.`,Je,x,ct=`To do so, use 🤗 Datasets’ <code>cast_column</code> method. This operation does not change the audio in-place, but rather signals
to datasets to resample the audio examples on the fly when they are loaded. The following code will set the sampling
rate to 16kHz:`,Ue,$,ge,v,yt="Re-load the first audio example in the MINDS-14 dataset, and check that it has been resampled to the desired <code>sampling rate</code>:",be,k,Ie,B,ft="<strong>Output:</strong>",Ce,_,Ae,R,wt=`You may notice that the array values are now also different. This is because we’ve now got twice the number of amplitude values for
every one that we had before.`,xe,w,$e,Z,ve,G,jt=`You may need to filter the data based on some criteria. One of the common cases involves limiting the audio examples to a
certain duration. For instance, we might want to filter out any examples longer than 20s to prevent out-of-memory errors
when training a model.`,ke,W,Tt=`We can do this by using the  🤗 Datasets’ <code>filter</code> method and passing a function with filtering logic to it. Let’s start by writing a
function that indicates which examples to keep and which to discard. This function, <code>is_audio_length_in_range</code>,
returns <code>True</code> if a sample is shorter than 20s, and <code>False</code> if it is longer than 20s.`,Be,H,_e,N,Jt=`The filtering function can be applied to a dataset’s column but we do not have a column with audio track duration in this
dataset. However, we can create one, filter based on the values in that column, and then remove it.`,Re,q,Ze,X,Ut="<strong>Output:</strong>",Ge,V,We,z,gt="We can verify that dataset has been filtered down from 654 examples to 624.",He,E,Ne,Q,bt=`One of the most challenging aspects of working with audio datasets is preparing the data in the right format for model
training. As you saw, the raw audio data comes as an array of sample values. However, pre-trained models, whether you use them
for inference, or want to fine-tune them for your task, expect the raw data to be converted into input features. The
requirements for the input features may vary from one model to another — they depend on the model’s architecture, and the data it was
pre-trained with. The good news is, for every supported audio model, 🤗 Transformers offer a feature extractor class
that can convert raw audio data into the input features the model expects.`,qe,Y,It=`So what does a feature extractor do with the raw audio data? Let’s take a look at <a href="https://huggingface.co/papers/2212.04356" rel="nofollow">Whisper</a>’s
feature extractor to understand some common feature extraction transformations. Whisper is a pre-trained model for
automatic speech recognition (ASR) published in September 2022 by Alec Radford et al. from OpenAI.`,Xe,S,Ct=`First, the Whisper feature extractor pads/truncates a batch of audio examples such that all
examples have an input length of 30s. Examples shorter than this are padded to 30s by appending zeros to the end of the
sequence (zeros in an audio signal correspond to no signal or silence). Examples longer than 30s are truncated to 30s.
Since all elements in the batch are padded/truncated to a maximum length in the input space, there is no need for an attention
mask. Whisper is unique in this regard, most other audio models require an attention mask that details
where sequences have been padded, and thus where they should be ignored in the self-attention mechanism. Whisper is
trained to operate without an attention mask and infer directly from the speech signals where to ignore the inputs.`,Ve,F,At=`The second operation that the Whisper feature extractor performs is converting the padded audio arrays to log-mel spectrograms.
As you recall, these spectrograms describe how the frequencies of a signal change over time, expressed on the mel scale
and measured in decibels (the log part) to make the frequencies and amplitudes more representative of human hearing.`,ze,L,xt=`All these transformations can be applied to your raw audio data with a couple of lines of code. Let’s go ahead and load
the feature extractor from the pre-trained Whisper checkpoint to have ready for our audio data:`,Ee,D,Qe,P,$t="Next, you can write a function to pre-process a single audio example by passing it through the <code>feature_extractor</code>.",Ye,O,Se,K,vt="We can apply the data preparation function to all of our training examples using 🤗 Datasets’ map method:",Fe,ee,Le,te,kt="<strong>Output:</strong>",De,ae,Pe,se,Bt="As easy as that, we now have log-mel spectrograms as <code>input_features</code> in the dataset.",Oe,le,_t="Let’s visualize it for one of the examples in the <code>minds</code> dataset:",Ke,ne,et,j,Rt='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',tt,ie,Zt="Now you can see what the audio input to the Whisper model looks like after preprocessing.",at,oe,Gt=`The model’s feature extractor class takes care of transforming raw audio data to the format that the model expects. However,
many tasks involving audio are multimodal, e.g. speech recognition. In such cases 🤗 Transformers also offer model-specific
tokenizers to process the text inputs. For a deep dive into tokenizers, please refer to our <a href="https://huggingface.co/course/chapter2/4" rel="nofollow">NLP course</a>.`,st,re,Wt=`You can load the feature extractor and tokenizer for Whisper and other multimodal models separately, or you can load both via
a so-called processor. To make things even simpler, use <code>AutoProcessor</code> to load a model’s feature extractor and processor from a
checkpoint, like this:`,lt,pe,nt,Me,Ht=`Here we have illustrated the fundamental data preparation steps. Of course, custom data may require more complex preprocessing.
In this case, you can extend the function <code>prepare_dataset</code> to perform any sort of custom data transformations. With 🤗 Datasets,
if you can write it as a Python function, you can <a href="https://huggingface.co/docs/datasets/audio_process" rel="nofollow">apply it</a> to your dataset!`,it,me,ot,ue,rt;return J=new Dt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new pt({props:{title:"Preprocessing an audio dataset",local:"preprocessing-an-audio-dataset",headingTag:"h1"}}),I=new pt({props:{title:"Resampling the audio data",local:"resampling-the-audio-data",headingTag:"h2"}}),$=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),k=new y({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),_=new y({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`,wrap:!1}}),w=new Lt({props:{$$slots:{default:[Ot]},$$scope:{ctx:he}}}),Z=new pt({props:{title:"Filtering the dataset",local:"filtering-the-dataset",headingTag:"h2"}}),H=new y({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),q=new y({props:{code:"JTIzJTIwdXNlJTIwbGlicm9zYSUyMHRvJTIwZ2V0JTIwZXhhbXBsZSdzJTIwZHVyYXRpb24lMjBmcm9tJTIwdGhlJTIwYXVkaW8lMjBmaWxlJTBBbmV3X2NvbHVtbiUyMCUzRCUyMCU1QmxpYnJvc2EuZ2V0X2R1cmF0aW9uKHBhdGglM0R4KSUyMGZvciUyMHglMjBpbiUyMG1pbmRzJTVCJTIycGF0aCUyMiU1RCU1RCUwQW1pbmRzJTIwJTNEJTIwbWluZHMuYWRkX2NvbHVtbiglMjJkdXJhdGlvbiUyMiUyQyUyMG5ld19jb2x1bW4pJTBBJTBBJTIzJTIwdXNlJTIwJUYwJTlGJUE0JTk3JTIwRGF0YXNldHMnJTIwJTYwZmlsdGVyJTYwJTIwbWV0aG9kJTIwdG8lMjBhcHBseSUyMHRoZSUyMGZpbHRlcmluZyUyMGZ1bmN0aW9uJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5maWx0ZXIoaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlJTJDJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmR1cmF0aW9uJTIyJTVEKSUwQSUwQSUyMyUyMHJlbW92ZSUyMHRoZSUyMHRlbXBvcmFyeSUyMGhlbHBlciUyMGNvbHVtbiUwQW1pbmRzJTIwJTNEJTIwbWluZHMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyZHVyYXRpb24lMjIlNUQpJTBBbWluZHM=",highlighted:`<span class="hljs-comment"># use librosa to get example&#x27;s duration from the audio file</span>
new_column = [librosa.get_duration(path=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># use 🤗 Datasets&#x27; \`filter\` method to apply the filtering function</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># remove the temporary helper column</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),V=new y({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),E=new pt({props:{title:"Pre-processing audio data",local:"pre-processing-audio-data",headingTag:"h2"}}),D=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),O=new y({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBpZiUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyMCElM0QlMjAxNjAwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvX2FycmF5JTIwJTNEJTIwbGlicm9zYS5yZXNhbXBsZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyU1QiUyMmFycmF5JTIyJTVEJTJDJTIwb3JpZ19zciUzRGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUyMHRhcmdldF9zciUzRDE2MDAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwJTdCJTIyYXJyYXklMjIlM0ElMjBhdWRpb19hcnJheSUyQyUyMCUyMnNhbXBsaW5nX3JhdGUlMjIlM0ElMjAxNjAwMCU3RCUwQSUwQSUyMCUyMCUyMCUyMGZlYXR1cmVzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmZWF0dXJlcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    <span class="hljs-keyword">if</span> audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>] != <span class="hljs-number">16000</span>:
        audio_array = librosa.resample(
            audio[<span class="hljs-string">&quot;array&quot;</span>], orig_sr=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], target_sr=<span class="hljs-number">16000</span>
        )
        audio = {<span class="hljs-string">&quot;array&quot;</span>: audio_array, <span class="hljs-string">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>}

    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),ee=new y({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),ae=new y({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),ne=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),pe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),me=new Pt({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter1/preprocessing.mdx"}}),{c(){c=i("meta"),f=l(),T=i("p"),de=l(),p(J.$$.fragment),ce=l(),p(U.$$.fragment),ye=l(),g=i("p"),g.textContent=mt,fe=l(),b=i("ul"),b.innerHTML=ut,we=l(),p(I.$$.fragment),je=l(),C=i("p"),C.innerHTML=ht,Te=l(),A=i("p"),A.textContent=dt,Je=l(),x=i("p"),x.innerHTML=ct,Ue=l(),p($.$$.fragment),ge=l(),v=i("p"),v.innerHTML=yt,be=l(),p(k.$$.fragment),Ie=l(),B=i("p"),B.innerHTML=ft,Ce=l(),p(_.$$.fragment),Ae=l(),R=i("p"),R.textContent=wt,xe=l(),p(w.$$.fragment),$e=l(),p(Z.$$.fragment),ve=l(),G=i("p"),G.textContent=jt,ke=l(),W=i("p"),W.innerHTML=Tt,Be=l(),p(H.$$.fragment),_e=l(),N=i("p"),N.textContent=Jt,Re=l(),p(q.$$.fragment),Ze=l(),X=i("p"),X.innerHTML=Ut,Ge=l(),p(V.$$.fragment),We=l(),z=i("p"),z.textContent=gt,He=l(),p(E.$$.fragment),Ne=l(),Q=i("p"),Q.textContent=bt,qe=l(),Y=i("p"),Y.innerHTML=It,Xe=l(),S=i("p"),S.textContent=Ct,Ve=l(),F=i("p"),F.textContent=At,ze=l(),L=i("p"),L.textContent=xt,Ee=l(),p(D.$$.fragment),Qe=l(),P=i("p"),P.innerHTML=$t,Ye=l(),p(O.$$.fragment),Se=l(),K=i("p"),K.textContent=vt,Fe=l(),p(ee.$$.fragment),Le=l(),te=i("p"),te.innerHTML=kt,De=l(),p(ae.$$.fragment),Pe=l(),se=i("p"),se.innerHTML=Bt,Oe=l(),le=i("p"),le.innerHTML=_t,Ke=l(),p(ne.$$.fragment),et=l(),j=i("div"),j.innerHTML=Rt,tt=l(),ie=i("p"),ie.textContent=Zt,at=l(),oe=i("p"),oe.innerHTML=Gt,st=l(),re=i("p"),re.innerHTML=Wt,lt=l(),p(pe.$$.fragment),nt=l(),Me=i("p"),Me.innerHTML=Ht,it=l(),p(me.$$.fragment),ot=l(),ue=i("p"),this.h()},l(e){const t=Qt("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),f=n(e),T=o(e,"P",{}),qt(T).forEach(a),de=n(e),M(J.$$.fragment,e),ce=n(e),M(U.$$.fragment,e),ye=n(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1b3xnqq"&&(g.textContent=mt),fe=n(e),b=o(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-1anvx2"&&(b.innerHTML=ut),we=n(e),M(I.$$.fragment,e),je=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-47dy14"&&(C.innerHTML=ht),Te=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1c2c4da"&&(A.textContent=dt),Je=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-x7frc7"&&(x.innerHTML=ct),Ue=n(e),M($.$$.fragment,e),ge=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-96ugis"&&(v.innerHTML=yt),be=n(e),M(k.$$.fragment,e),Ie=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1mvdyro"&&(B.innerHTML=ft),Ce=n(e),M(_.$$.fragment,e),Ae=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-hnb1k"&&(R.textContent=wt),xe=n(e),M(w.$$.fragment,e),$e=n(e),M(Z.$$.fragment,e),ve=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-s6y06a"&&(G.textContent=jt),ke=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1szy3nk"&&(W.innerHTML=Tt),Be=n(e),M(H.$$.fragment,e),_e=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1btp9dp"&&(N.textContent=Jt),Re=n(e),M(q.$$.fragment,e),Ze=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1mvdyro"&&(X.innerHTML=Ut),Ge=n(e),M(V.$$.fragment,e),We=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-ipsrxo"&&(z.textContent=gt),He=n(e),M(E.$$.fragment,e),Ne=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-jbw2e0"&&(Q.textContent=bt),qe=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1jndbwe"&&(Y.innerHTML=It),Xe=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1y8nv8f"&&(S.textContent=Ct),Ve=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1ys9rww"&&(F.textContent=At),ze=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-n9ngno"&&(L.textContent=xt),Ee=n(e),M(D.$$.fragment,e),Qe=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-kd1gw8"&&(P.innerHTML=$t),Ye=n(e),M(O.$$.fragment,e),Se=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-6ixft2"&&(K.textContent=vt),Fe=n(e),M(ee.$$.fragment,e),Le=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1mvdyro"&&(te.innerHTML=kt),De=n(e),M(ae.$$.fragment,e),Pe=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-14djzfz"&&(se.innerHTML=Bt),Oe=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1478ups"&&(le.innerHTML=_t),Ke=n(e),M(ne.$$.fragment,e),et=n(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-csckl"&&(j.innerHTML=Rt),tt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-pj9vlt"&&(ie.textContent=Zt),at=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1x1eerf"&&(oe.innerHTML=Gt),st=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-ngi3x1"&&(re.innerHTML=Wt),lt=n(e),M(pe.$$.fragment,e),nt=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-gvmmsi"&&(Me.innerHTML=Ht),it=n(e),M(me.$$.fragment,e),ot=n(e),ue=o(e,"P",{}),qt(ue).forEach(a),this.h()},h(){Mt(c,"name","hf:doc:metadata"),Mt(c,"content",ea),Mt(j,"class","flex justify-center")},m(e,t){Yt(document.head,c),s(e,f,t),s(e,T,t),s(e,de,t),m(J,e,t),s(e,ce,t),m(U,e,t),s(e,ye,t),s(e,g,t),s(e,fe,t),s(e,b,t),s(e,we,t),m(I,e,t),s(e,je,t),s(e,C,t),s(e,Te,t),s(e,A,t),s(e,Je,t),s(e,x,t),s(e,Ue,t),m($,e,t),s(e,ge,t),s(e,v,t),s(e,be,t),m(k,e,t),s(e,Ie,t),s(e,B,t),s(e,Ce,t),m(_,e,t),s(e,Ae,t),s(e,R,t),s(e,xe,t),m(w,e,t),s(e,$e,t),m(Z,e,t),s(e,ve,t),s(e,G,t),s(e,ke,t),s(e,W,t),s(e,Be,t),m(H,e,t),s(e,_e,t),s(e,N,t),s(e,Re,t),m(q,e,t),s(e,Ze,t),s(e,X,t),s(e,Ge,t),m(V,e,t),s(e,We,t),s(e,z,t),s(e,He,t),m(E,e,t),s(e,Ne,t),s(e,Q,t),s(e,qe,t),s(e,Y,t),s(e,Xe,t),s(e,S,t),s(e,Ve,t),s(e,F,t),s(e,ze,t),s(e,L,t),s(e,Ee,t),m(D,e,t),s(e,Qe,t),s(e,P,t),s(e,Ye,t),m(O,e,t),s(e,Se,t),s(e,K,t),s(e,Fe,t),m(ee,e,t),s(e,Le,t),s(e,te,t),s(e,De,t),m(ae,e,t),s(e,Pe,t),s(e,se,t),s(e,Oe,t),s(e,le,t),s(e,Ke,t),m(ne,e,t),s(e,et,t),s(e,j,t),s(e,tt,t),s(e,ie,t),s(e,at,t),s(e,oe,t),s(e,st,t),s(e,re,t),s(e,lt,t),m(pe,e,t),s(e,nt,t),s(e,Me,t),s(e,it,t),m(me,e,t),s(e,ot,t),s(e,ue,t),rt=!0},p(e,[t]){const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),w.$set(Nt)},i(e){rt||(u(J.$$.fragment,e),u(U.$$.fragment,e),u(I.$$.fragment,e),u($.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u(w.$$.fragment,e),u(Z.$$.fragment,e),u(H.$$.fragment,e),u(q.$$.fragment,e),u(V.$$.fragment,e),u(E.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),rt=!0)},o(e){h(J.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h($.$$.fragment,e),h(k.$$.fragment,e),h(_.$$.fragment,e),h(w.$$.fragment,e),h(Z.$$.fragment,e),h(H.$$.fragment,e),h(q.$$.fragment,e),h(V.$$.fragment,e),h(E.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),rt=!1},d(e){e&&(a(f),a(T),a(de),a(ce),a(ye),a(g),a(fe),a(b),a(we),a(je),a(C),a(Te),a(A),a(Je),a(x),a(Ue),a(ge),a(v),a(be),a(Ie),a(B),a(Ce),a(Ae),a(R),a(xe),a($e),a(ve),a(G),a(ke),a(W),a(Be),a(_e),a(N),a(Re),a(Ze),a(X),a(Ge),a(We),a(z),a(He),a(Ne),a(Q),a(qe),a(Y),a(Xe),a(S),a(Ve),a(F),a(ze),a(L),a(Ee),a(Qe),a(P),a(Ye),a(Se),a(K),a(Fe),a(Le),a(te),a(De),a(Pe),a(se),a(Oe),a(le),a(Ke),a(et),a(j),a(tt),a(ie),a(at),a(oe),a(st),a(re),a(lt),a(nt),a(Me),a(it),a(ot),a(ue)),a(c),d(J,e),d(U,e),d(I,e),d($,e),d(k,e),d(_,e),d(w,e),d(Z,e),d(H,e),d(q,e),d(V,e),d(E,e),d(D,e),d(O,e),d(ee,e),d(ae,e),d(ne,e),d(pe,e),d(me,e)}}}const ea='{"title":"Preprocessing an audio dataset","local":"preprocessing-an-audio-dataset","sections":[{"title":"Resampling the audio data","local":"resampling-the-audio-data","sections":[],"depth":2},{"title":"Filtering the dataset","local":"filtering-the-dataset","sections":[],"depth":2},{"title":"Pre-processing audio data","local":"pre-processing-audio-data","sections":[],"depth":2}],"depth":1}';function ta(he){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends zt{constructor(c){super(),Et(this,c,ta,Kt,Xt,{})}}export{oa as component};
