import{s as ta,o as la}from"../chunks/scheduler.a045fce0.js";import{S as na,i as aa,e as i,s as n,c as u,h as ia,a as r,d as t,b as a,f as Dn,g as p,j as o,k as Kn,l as ra,m as l,n as c,t as m,o as d,p as M,q as ea,r as sa}from"../chunks/index.5135b896.js";import{T as On}from"../chunks/Tip.872c1b89.js";import{C as oa,H as j,E as ua}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.18f40ad6.js";import{C as y}from"../chunks/CodeBlock.655c066f.js";function pa(gs){let J;return{c(){J=ea('Vous pouvez changer l\'identifiant de langue de `"dv"` pour un identifiant de langue de votre choix. Pour voir toutes les langues possibles dans Common Voice 13, consultez la carte du jeu de données sur le *Hub* : https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},l(T){J=sa(T,'Vous pouvez changer l\'identifiant de langue de `"dv"` pour un identifiant de langue de votre choix. Pour voir toutes les langues possibles dans Common Voice 13, consultez la carte du jeu de données sur le *Hub* : https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},m(T,f){l(T,J,f)},d(T){T&&t(J)}}}function ca(gs){let J;return{c(){J=ea("Si vous ne voulez pas télécharger les *checkpoints* du modèle vers le *Hub*, mettez `push_to_hub=False`.")},l(T){J=sa(T,"Si vous ne voulez pas télécharger les *checkpoints* du modèle vers le *Hub*, mettez `push_to_hub=False`.")},m(T,f){l(T,J,f)},d(T){T&&t(J)}}}function ma(gs){let J,T,f,Cs,w,Zs,b,_s,v,xl="Dans cette section, nous allons couvrir un guide étape par étape pour <em>finetuner</em> Whisper pour la reconnaissance automatique de la parole sur le jeu de données Common Voice 13. Nous utiliserons la version ”<em>small</em>” du modèle et un jeu de données relativement léger, vous permettant d’exécuter le <em>finetuning</em> assez rapidement sur n’importe quel GPU de plus de 16 Go avec de faibles besoins en espace disque, comme le GPU T4 de 16 Go fourni dans le volet gratuit de Google Colab.",$s,g,Bl="Si vous disposez d’un GPU plus petit ou si vous rencontrez des problèmes de mémoire pendant l’entraînement, vous pouvez suivre les suggestions fournies pour réduire l’utilisation de la mémoire. À l’inverse, si vous avez accès à un GPU plus puissant, vous pouvez modifier les arguments d’entraînement pour maximiser votre capacité de traitement. Ce guide est donc accessible quelles que soient les spécifications de votre GPU !",Ws,I,kl=`De même, ce guide porte plus précisément sur le <em>finetuning</em> sur la langue Dhivehi mais les étapes couvertes ici se généralisent à n’importe quelle langue du jeu de données Common Voice, et plus généralement à n’importe quel jeu de données d’ASR disponible sur le <em>Hub</em>.
Vous pouvez modifier le code pour passer rapidement à la langue de votre choix et <em>finetuner</em> un modèle Whisper dans votre langue maternelle 🌍.`,qs,C,Xl="Commençons et donnons le coup d’envoi de notre pipeline de <em>finetuning</em> !",Gs,Z,xs,_,zl=`Nous vous conseillons vivement de télécharger les <em>checkpoints</em> du modèle directement sur le <a href="https://huggingface.co/" rel="nofollow"><em>Hub</em></a>.
Le <em>Hub</em> offre les avantages suivants :`,Bs,$,Vl="<li>Un contrôle de version intégré : vous pouvez être sûr qu’aucun <em>checkpoint</em> n’est perdu pendant l’entraînement.</li> <li>Tensorboard : suivi des mesures importantes au cours de l’entraînement.</li> <li>Cartes de modèle : documenter ce que fait un modèle et ses cas d’utilisation prévus.</li> <li>Communauté : un moyen facile de partager et de collaborer avec la communauté ! 🤗</li>",ks,W,Nl=`Lier le <em>notebook</em> au <em>Hub</em> est très simple, il suffit d’entrer votre <em>token</em> d’authentification au <em>Hub</em> lorsque l’on vous y invite.
Votre <em>token</em> d’authentification est trouvable <a href="https://huggingface.co/settings/tokens" rel="nofollow">ici</a>.`,Xs,q,zs,G,Hl="<strong>Sortie :</strong>",Vs,x,Ns,B,Hs,k,Al='<a href="https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0" rel="nofollow">Common Voice 13</a> contient environ dix heures de données Dhivehi étiquetées, dont trois sont des données de test. Il s’agit de très peu de données pour un <em>finetuning</em>, nous nous appuierons donc sur la connaissance multilingue acquise par Whisper pendant le pré-entraînement.',As,X,El="En utilisant les 🤗 <em>Datasets</em>, le téléchargement et la préparation des données sont extrêmement simples. Nous pouvons télécharger et préparer les ensembles de Common Voice 13 en une seule ligne de code. Puisque le Dhivehi est très pauvre en ressources, nous combinerons les splits <code>train</code> et <code>validation</code> pour obtenir environ sept heures de données d’entraînement. Nous utiliserons les trois heures de données <code>test</code> comme notre ensemble de test :",Es,z,Rs,V,Rl="<strong>Sortie :</strong>",Qs,N,Ys,U,Fs,H,Ql=`La plupart des jeux de données d’ASR ne fournissent que des échantillons audio en entrée (<code>audio</code>) et le texte transcrit correspondant (<code>sentence</code>).
Common Voice contient des métadonnées supplémentaires, telles que <code>accent</code> et <code>locale</code>, que nous pouvons ignorer pour l’ASR.
En gardant le <em>notebook</em> aussi général que possible, nous ne considérons que l’audio d’entrée et le texte transcrit en écartant les informations de métadonnées supplémentaires :`,Ss,A,Ls,E,Ps,R,Yl="Le pipeline d’ASR peut être décomposé en trois étapes :",Ds,Q,Fl="<li>L’extracteur de caractéristiques qui pré-traite les entrées audio brutes en spectrogrammes log-mél.</li> <li>Le modèle qui effectue l’association séquence-séquence</li> <li>Le tokenizer qui post-traite les <em>tokens</em> prédits en texte.</li>",Ks,Y,Sl=`Dans 🤗 <em>Transformers</em>, le modèle Whisper est associé à un extracteur de caractéristiques et à un tokenizer, appelés respectivement <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperFeatureExtractor" rel="nofollow">WhisperFeatureExtractor</a> et <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperTokenizer" rel="nofollow">WhisperTokenizer</a>.
Pour nous simplifier la vie, ces deux objets sont regroupés dans une seule classe, appelée <a href="https://huggingface.co/docs/transformers/model_doc/whisper#transformers.WhisperProcessor" rel="nofollow">WhisperProcessor</a>.
Nous pouvons appeler le WhisperProcessor pour effectuer à la fois le prétraitement audio et le post-traitement des <em>tokens</em> de texte. Ce faisant, nous n’avons besoin de suivre que deux objets pendant l’entraîningment : le processeur et le modèle.`,Os,F,Ll=`Lors d’un <em>finetuné</em> multilingue, nous devons définir la <code>&quot;language&quot;</code> et la <code>&quot;task&quot;</code> lors de l’instanciation du processeur.
La <code>&quot;language&quot;</code> doit être fixée à la langue audio source, et la tâche à <code>&quot;translate&quot;</code> pour la reconnaissance vocale ou à <code>&quot;translate&quot;</code> pour la traduction vocale. Ces arguments modifient le comportement du <em>tokens</em>, et doivent être définis correctement pour s’assurer que les étiquettes cibles sont encodées correctement.`,et,S,Pl="Nous pouvons voir toutes les langues possibles supportées par Whisper en important la liste des langues :",st,L,tt,P,Dl=`Si vous parcourez cette liste, vous remarquerez que de nombreuses langues sont présentes, mais que le dhivehi est l’une des rares à ne pas l’être !
Cela signifie que Whisper n’a pas été pré-entraîné sur le dhivehi. Cependant, cela ne signifie pas que nous ne pouvons pas <em>finetuner</em> Whisper sur cette langue.
En faisant cela, nous allons entraîner Whisper dans une nouvelle langue, une langue non supportée par le <em>checkpoint</em> pré-entraîné. C’est plutôt cool, non ?`,lt,D,Kl="Lorsque vous le <em>finetunez</em> sur une nouvelle langue, Whisper fait un bon travail en tirant parti de sa connaissance des 96 autres langues sur lesquelles il a été pré-entraîné. En général, toutes les langues modernes seront linguistiquement similaires à au moins l’une des 96 langues que Whisper connaît déjà, nous nous inscrivons donc dans ce paradigme de représentation des connaissances interlinguistiques.",nt,K,Ol=`Ce que nous devons faire pour cette nouvelle langue, est de trouver la langue <strong>la plus similaire</strong> sur laquelle Whisper a été pré-entraîné. L’article de Wikipédia sur le dhivehi indique que cette langue est étroitement liée à la langue cinghalaise du Sri Lanka.
Si nous vérifions à nouveau les codes de langue, nous pouvons voir que le cinghalais est présent dans le jeu de langues de Whisper, nous pouvons donc en toute sécurité mettre notre argument de langue à <code>&quot;sinhalese&quot;</code>.`,at,O,en="Nous allons charger notre processeur à partir du <em>checkpoint</em> pré-entraîné, en fixant la langue à <code>&quot;sinhalese&quot;</code> et la tâche à <code>&quot;transcribe&quot;</code> comme expliqué ci-dessus :",it,ee,rt,se,sn="Il est utile de rappeler que dans la plupart des cas, vous constaterez que la langue sur laquelle vous souhaitez effectuer un <em>finetuning</em> se trouve dans l’ensemble des langues de pré-entraînement, auquel cas vous pouvez simplement définir cette langue directement comme langue audio source ! Notez que ces deux arguments doivent être omis pour le <em>finetuning</em> en anglais où il n’y a qu’une seule option pour la langue (<code>&quot;English&quot;</code>) et la tâche (<code>&quot;transcribe&quot;</code>).",ot,te,ut,le,tn="Jetons un coup d’oeil aux caractéristiques du jeu de données. Portez une attention particulière à la colonne <code>&quot;audio&quot;</code>, elle détaille le taux d’échantillonnage de nos entrées audio :",pt,ne,ct,ae,ln="<strong>Sortie :</strong>",mt,ie,dt,re,nn="Puisque notre audio d’entrée est échantillonné à 48kHz, nous devons le sous-échantillonner à 16kHz avant de le passer à l’extracteur de caractéristiques de Whisper qui est la fréquence d’échantillonnage attendue par le modèle.",Mt,oe,an='Nous allons régler les entrées audio à la bonne fréquence d’échantillonnage en utilisant la méthode <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.cast_column" rel="nofollow"><code>cast_column</code></a> du jeu de données. Cette opération ne modifie pas l’audio sur place, mais signale aux jeux de données de rééchantillonner les échantillons audio à la volée lorsqu’ils sont chargés :',yt,ue,Jt,pe,rn="Nous pouvons maintenant écrire une fonction pour préparer nos données pour le modèle :",Tt,ce,on="<li>Nous chargeons et rééchantillonnons les données audio échantillon par échantillon en appelant <code>sample[&quot;audio&quot;]</code>. Comme expliqué ci-dessus, 🤗 <em>Datasets</em> effectue toutes les opérations de rééchantillonnage nécessaires à la volée.</li> <li>Nous utilisons l’extracteur de caractéristiques pour calculer les caractéristiques d’entrée du spectrogramme log-mel à partir de notre tableau audio unidimensionnel.</li> <li>Nous encodons les transcriptions en identifiants d’étiquettes à l’aide d’un <em>tokenizer</em>.</li>",jt,me,ft,de,un="Nous pouvons appliquer la fonction de préparation des données à tous nos exemples d’entraînement en utilisant la méthode <code>.map</code> de 🤗 <em>Datasets</em>. Nous allons supprimer les colonnes des données d’entraînement brutes (l’audio et le texte), en ne laissant que les colonnes renvoyées par la fonction <code>prepare_dataset</code> :",Ut,Me,ht,ye,pn="Enfin, nous filtrons toutes les données d’entraînement contenant des échantillons audio de plus de 30 secondes. Ces échantillons seraient sinon tronqués par l’extracteur de caractéristiques de Whisper, ce qui pourrait affecter la stabilité de l’entraînement. Nous définissons une fonction qui renvoie <code>True</code> pour les échantillons de moins de 30 secondes, et <code>False</code> pour ceux qui sont plus longs :",wt,Je,bt,Te,cn="Nous appliquons notre fonction de filtrage à tous les échantillons de notre jeu de données d’entraînement par le biais de la méthode <code>.filter</code> de 🤗 <em>Datasets</em> :",vt,je,gt,fe,mn="Vérifions la quantité de données d’entraînement que nous avons supprimée grâce à cette étape de filtrage :",It,Ue,Ct,he,dn="<strong>Sortie :</strong>",Zt,we,_t,be,Mn=`Dans ce cas, nous avons en fait le même nombre d’échantillons que précédemment, donc il n’y a pas d’échantillons de plus de 30s.
Cela pourrait ne pas être le cas si vous changez de langue, il est donc préférable de garder cette étape de filtrage en place pour plus de robustesse. Nos données sont maintenant prêtes à être entraînées ! Continuons et regardons comment nous pouvons utiliser ces données pour le <em>finetuning</em>.`,$t,ve,Wt,ge,yn=`Maintenant que nous avons préparé nos données, nous sommes prêts à plonger dans le pipeline d’entraînement.
<a href="https://huggingface.co/transformers/master/main_classes/trainer.html?highlight=trainer" rel="nofollow">Trainer</a>
va faire le gros du travail à notre place. Tout ce que nous avons à faire est de :`,qt,Ie,Jn="<li><p>Définir un assembleur de données qui prend nos données prétraitées et prépare des tenseurs PyTorch adaptés au modèle.</p></li> <li><p>Métriques d’évaluation : lors de l’évaluation, nous voulons évaluer le modèle en utilisant la métrique du taux d’erreur au niveau du mot (WER). Nous devons définir une fonction <code>compute_metrics</code> qui gère ce calcul.</p></li> <li><p>Charger un <em>checkpoint</em> pré-entraîné et le configurer correctement pour l’entraînement.</p></li> <li><p>Définir les arguments d’entraînement : ils seront utilisés par le Trainer pour construire le plannificateur d’entraînement.</p></li>",Gt,Ce,Tn="Une fois le modèle <em>finetuné</em>, nous l’évaluerons sur les données de test pour vérifier que nous l’avons correctement entraîné à transcrire la parole en Dhivehi.",xt,Ze,Bt,_e,jn="L’assembleur de données pour un modèle audio séquence-à-séquence est unique dans le sens où il traite les <code>input_features</code> et les <code>labels</code> indépendamment : les <code>input_features</code> doivent être traitées par l’extracteur de caractéristiques et les <code>labels</code> par le tokenizer.",kt,$e,fn="Les <code>input_features</code> sont déjà rembourrées à 30s et converties en un spectrogramme log-Mel de dimension fixe, donc tout ce que nous avons à faire est de les convertir en tenseurs PyTorch batchés. Nous le faisons en utilisant la méthode <code>.pad</code> de l’extracteur de caractéristiques avec <code>return_tensors=pt</code>. Notez qu’aucun rembourrage supplémentaire n’est appliqué ici puisque les entrées sont de dimension fixe, les <code>input_features</code> sont simplement converties en tenseurs PyTorch.",Xt,We,Un="D’un autre côté, les <code>labels</code> ne sont pas rembourrés. Les séquences sont d’abord remplacées par la longueur maximale du batch à l’aide de la méthode <code>.pad</code> du <em>tokenizer</em>. Les <em>tokens</em> de remplissage sont ensuite remplacés par <code>-100</code> de sorte que ces tokens ne sont <strong>pas</strong> pris en compte lors du calcul de la perte. Nous coupons ensuite le début du <em>token</em> de transcription du début de la séquence d’étiquettes comme nous l’ajouterons plus tard pendant l’entraînement.",zt,qe,hn="Nous pouvons utiliser le <code>WhisperProcessor</code> que nous avons défini plus tôt pour effectuer à la fois les opérations de l’extracteur de caractéristiques et du <em>tokenizer</em> :",Vt,Ge,Nt,xe,wn="Nous pouvons maintenant initialiser l’assembleur de données que nous venons de définir :",Ht,Be,At,ke,bn="En avant !",Et,Xe,Rt,ze,vn='Ensuite, nous définissons la métrique d’évaluation que nous utiliserons sur notre ensemble d’évaluation. Nous utiliserons le taux d’erreur au niveaud du mot (WER) introduit dans la section <a href="%C3%A9valuation">évaluation</a>, la métrique “de-facto” pour évaluer les systèmes d’ASR.',Qt,Ve,gn="Nous chargerons la métrique WER à partir d’ 🤗 <em>Evaluate</em> :",Yt,Ne,Ft,He,In="Il suffit ensuite de définir une fonction qui prend les prédictions de notre modèle et renvoie la métrique WER. Cette fonction, appelée <code>compute_metrics</code>, remplace d’abord <code>-100</code> par le <code>pad_token_id</code> dans <code>label_ids</code> (annulant l’étape que nous avons appliquée dans l’assembleur de données pour ignorer correctement les <em>tokens</em> rembourrés dans la perte). Il décode ensuite les identifiants prédits et les identifiants d’étiquettes en chaînes de caractères. Enfin, il calcule le WER entre les prédictions et les étiquettes de référence. Ici, nous avons la possibilité d’évaluer les transcriptions et les prédictions “normalisées”, dont la ponctuation et la casse ont été supprimées. Nous vous recommandons de procéder ainsi pour bénéficier de l’amélioration du WER obtenue par la normalisation des transcriptions.",St,Ae,Lt,Ee,Pt,Re,Cn="Chargeons maintenant le <em>checkpoint</em> pré-entraîné de Whisper small. Encore une fois, ceci est trivial grâce à l’utilisation de 🤗 <em>Transformers</em> !",Dt,Qe,Kt,Ye,Zn='Nous allons mettre <code>use_cache</code> à <code>False</code> pour l’entraînement puisque nous utilisons [<em>gradient checkpointing</em>] (<a href="https://huggingface.co/docs/transformers/v4.18.0/en/performance#gradient-checkpointing" rel="nofollow">https://huggingface.co/docs/transformers/v4.18.0/en/performance#gradient-checkpointing</a>) et que les deux sont incompatibles. Nous allons aussi surcharger deux arguments de génération pour contrôler le comportement du modèle pendant l’inférence : nous allons forcer la langue et les <em>tokens</em> de tâche pendant la génération en définissant les arguments <code>language</code> et <code>task</code>, et aussi réactiver le cache pour la génération afin d’accélérer le temps d’inférence :',Ot,Fe,el,Se,sl,Le,_n=`Dans la dernière étape, nous définissons tous les paramètres liés à l’entraînement. Ici, nous fixons le nombre d’étapes d’entraînement à 500.
Cela représente suffisamment d’étapes pour voir une grande amélioration du WER par rapport au modèle pré-entraîné, tout en s’assurant que le <em>finetuning</em> peut être exécuté en environ 45 minutes sur un niveau gratuit de Google Colab. Pour plus de détails sur les arguments d’entraînement, reportez-vous à la documentation de [Seq2SeqTrainingArguments] (<a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments" rel="nofollow">https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments</a>).`,tl,Pe,ll,h,nl,De,$n="Nous pouvons transmettre les arguments d’entraînement au <em>Trainer</em> avec notre modèle, notre jeu de données, notre assembleur de données et la fonction <code>compute_metrics</code> :",al,Ke,il,Oe,Wn="Et voilà, nous sommes prêts à entraîner !",rl,es,ol,ss,qn="Pour lancer l’entraînement, il suffit d’exécuter :",ul,ts,pl,ls,Gn='L’entraînement prendra environ 45 minutes en fonction de votre GPU ou de celui alloué par Google Colab. En fonction de votre GPU, il est possible que vous rencontriez une erreur CUDA <code>&quot;out-of-memory&quot;</code> lorsque vous commencez à entraîner. Dans ce cas, vous pouvez réduire le <code>per_device_train_batch_size</code> par incréments d’un facteur 2 et utiliser <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments.gradient_accumulation_steps" rel="nofollow"><code>gradient_accumulation_steps</code></a> pour compenser.',cl,ns,xn="<strong>Sortie :</strong>",ml,as,Bn='<thead><tr><th align="center">Training Loss</th> <th align="center">Epoch</th> <th align="center">Step</th> <th align="center">Validation Loss</th> <th align="center">Wer Ortho</th> <th align="center">Wer</th></tr></thead> <tbody><tr><td align="center">0.136</td> <td align="center">1.63</td> <td align="center">500</td> <td align="center">0.1727</td> <td align="center">63.8972</td> <td align="center">14.0661</td></tr></tbody>',dl,is,kn="Notre WER final est de 14,1 % ce qui n’est pas mal pour sept heures de données d’entraînement et seulement 500 étapes d’entraînement ! Cela représente une amélioration de 112 % par rapport au modèle pré-entraîné ! Cela signifie que nous avons pris un modèle qui n’avait aucune connaissance du dhivehi et que nous l’avons <em>finetuné</em> pour reconnaître l’dhivehi avec une précision adéquate en moins d’une heure 🤯.",Ml,rs,Xn='La grande question est de savoir comment cela se compare à d’autres systèmes ASR. Pour cela, nous pouvons consulter le [classement autoevaluate] (<a href="https://huggingface.co/spaces/autoevaluate/leaderboards?dataset=mozilla-foundation%2Fcommon_voice_13_0&amp;only_verified=0&amp;task=automatic-speech-recognition&amp;config=dv&amp;split=test&amp;metric=wer" rel="nofollow">https://huggingface.co/spaces/autoevaluate/leaderboards?dataset=mozilla-foundation%2Fcommon_voice_13_0&amp;only_verified=0&amp;task=automatic-speech-recognition&amp;config=dv&amp;split=test&amp;metric=wer</a>) qui catégorise les modèles par langue et par jeu de données, et les classe ensuite en fonction de leur WER.',yl,os,zn='En regardant le classement, nous voyons que notre modèle entraîné pour 500 étapes bat de manière convaincante le <em>checkpoint</em> <a href="https://huggingface.co/openai/whisper-small" rel="nofollow">Whisper Small</a> pré-entraîné que nous avons évalué dans la section précédente. Bon travail 👏',Jl,us,Vn=`Nous voyons qu’il y a quelques <em>checkpoints</em> qui font mieux que celui que nous avons entraîné. La beauté du <em>Hub</em> est qu’il s’agit d’une plateforme <em>collaborative</em>. Si nous n’avons pas le temps ou les ressources pour effectuer un entraînement plus long nous-mêmes, nous pouvons charger un <em>checkpoint</em> que quelqu’un d’autre dans la communauté a entraîné et a eu la gentillesse de partager (en s’assurant de le remercier pour cela !).
Vous pourrez charger ces <em>checkpoints</em> exactement de la même manière que les pré-entraînés en utilisant la classe <code>pipeline</code> comme nous l’avons fait précédemment ! Ainsi, rien ne vous empêche de sélectionner le meilleur modèle du leaderboard pour l’utiliser dans le cadre de votre tâche !`,Tl,ps,Nn="Nous pouvons automatiquement soumettre notre <em>checkpoint</em> au classement lorsque nous envoyons les résultats de l’entraînement au <em>Hub</em>. Nous devons simplement définir les arguments de mot-clé appropriés (kwargs). Vous pouvez modifier ces valeurs pour qu’elles correspondent à votre jeu de données, à votre langue et au nom de votre modèle en conséquence :",jl,cs,fl,ms,Hn="Les résultats de l’entraînement peuvent maintenant être téléchargés vers le <em>Hub</em>. Pour ce faire, exécutez la commande <code>push_to_hub</code> :",Ul,ds,hl,Ms,An="Ceci sauvegardera les logs d’entraînement et les poids des modèles sous <code>&quot;votre-nom-d&#39;utilisateur/le-nom-que-vous-avez-choisi&quot;</code>. Pour cet exemple, regardez le téléchargement à <code>sanchit-gandhi/whisper-small-dv</code>.",wl,ys,En=`Bien que le modèle <em>finetuné</em> donne des résultats satisfaisants sur les données de test de Common Voice 13, il n’est en aucun cas optimal.
Le but de ce guide est de démontrer comment <em>finetuner</em> un modèle ASR en utilisant le <em>Trainer</em> pour la reconnaissance automatique de la parole multilingue.`,bl,Js,Rn="Si vous avez accès à votre propre GPU ou si vous êtes abonné à un plan payant de Google Colab, vous pouvez augmenter <code>max_pas</code> à 4000 pas pour améliorer davantage le WER en entraînant plus de pas. Entraîner 4000 pas prendra environ 3 à 5 heures en fonction de votre GPU et donnera des résultats WER inférieurs d’environ 3 % à l’entraînement de 500 pas. Si vous décidez d’entraîner sur 4000 pas, nous vous recommandons également de changer le planificateur de taux d’apprentissage pour un plan <em>linéaire</em> (set <code>lr_scheduler_type=&quot;linear&quot;</code>), car cela permettra d’augmenter les performances sur de longues périodes d’entraînement.",vl,Ts,Qn="Les résultats pourraient probablement être améliorés en optimisant les hyperparamètres d’entraînement, tels que <em>learning rate</em> et <em>dropout</em>, et en utilisant un <em>checkpoint</em> pré-entraîné plus grand (<code>medium</code> ou <code>large</code>). Nous laissons cet exercice au lecteur.",gl,js,Il,fs,Yn='Vous pouvez maintenant partager ce modèle avec n’importe qui en utilisant le lien sur le <em>Hub</em>. Ils peuvent le charger avec l’identifiant <code>&quot;votre-nom-d&#39;utilisateur/le-nom-que-vous-avez-choisi&quot;</code> directement dans l’objet <code>pipeline()</code>. Par exemple, pour charger le <em>checkpoint</em> <em>finetuné</em> <a href="https://huggingface.co/sanchit-gandhi/whisper-small-dv" rel="nofollow">“sanchit-gandhi/whisper-small-dv”</a> :',Cl,Us,Zl,hs,_l,ws,Fn="Dans cette section, nous avons couvert un guide étape par étape sur le <em>finetuning</em> du modèle Whisper pour la reconnaissance vocale en utilisants 🤗 <em>Jeux de données</em>, 🤗 <em>Transformers</em> et le <em>Hub</em>. Nous avons d’abord chargé le sous-ensemble Dhivehi du jeu de données Common Voice 13 et l’avons prétraité en calculant des spectrogrammes log-mel et en tokenisant le texte. Nous avons ensuite défini un assembleur de données, une métrique d’évaluation et des arguments d’entraînement, avant d’utiliser le <em>Trainer</em> pour entraîner et évaluer notre modèle. Nous avons terminé en téléchargeant le modèle <em>finetuné</em> sur le <em>Hub</em>, et nous avons montré comment le partager et l’utiliser avec la classe <code>pipeline()</code>.",$l,bs,Sn=`Si vous avez suivi jusqu’à ce point, vous devriez maintenant avoir un <em>checkpoint</em> <em>finetuné</em> pour la reconnaissance automatique de la parole, bien joué ! 🥳
Plus important encore, vous êtes équipé de tous les outils nécessaires pour <em>finetuner</em> le modèle Whisper sur n’importe quel jeu de données ou domaine de reconnaissance vocale. Alors, qu’attendez-vous ? Choisissez l’un des jeux de données couverts dans la section <a href="choosing_dataset">Choisir un jeu de données</a> ou sélectionnez un jeu de données de votre choix, et voyez si vous pouvez obtenir des performances de pointe ! Le classement vous attend…`,Wl,vs,ql,Is,Gl;return w=new oa({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new j({props:{title:"Comment finetuner un système de reconnaissance automatique de la parole avec l’API Trainer",local:"comment-finetuner-un-système-de-reconnaissance-automatique-de-la-parole-avec-lapi-trainer",headingTag:"h1"}}),Z=new j({props:{title:"Préparer l’environnement",local:"préparer-lenvironnement",headingTag:"h2"}}),q=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),x=new y({props:{code:"TG9naW4lMjBzdWNjZXNzZnVsJTBBWW91ciUyMHRva2VuJTIwaGFzJTIwYmVlbiUyMHNhdmVkJTIwdG8lMjAlMkZyb290JTJGLmh1Z2dpbmdmYWNlJTJGdG9rZW4=",highlighted:`Login successful
Your token has been saved to /root/.huggingface/token`,wrap:!1}}),B=new j({props:{title:"Charger le jeu de données",local:"charger-le-jeu-de-données",headingTag:"h2"}}),z=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwRGF0YXNldERpY3QlMEElMEFjb21tb25fdm9pY2UlMjAlM0QlMjBEYXRhc2V0RGljdCgpJTBBJTBBY29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ2YWxpZGF0aW9uJTIyJTBBKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMiUwQSklMEElMEFwcmludChjb21tb25fdm9pY2Up",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, DatasetDict

common_voice = DatasetDict()

common_voice[<span class="hljs-string">&quot;train&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;train+validation&quot;</span>
)
common_voice[<span class="hljs-string">&quot;test&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>
)

<span class="hljs-built_in">print</span>(common_voice)`,wrap:!1}}),N=new y({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2NsaWVudF9pZCclMkMlMjAncGF0aCclMkMlMjAnYXVkaW8nJTJDJTIwJ3NlbnRlbmNlJyUyQyUyMCd1cF92b3RlcyclMkMlMjAnZG93bl92b3RlcyclMkMlMjAnYWdlJyUyQyUyMCdnZW5kZXInJTJDJTIwJ2FjY2VudCclMkMlMjAnbG9jYWxlJyUyQyUyMCdzZWdtZW50JyUyQyUyMCd2YXJpYW50JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNDkwNCUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidjbGllbnRfaWQnJTJDJTIwJ3BhdGgnJTJDJTIwJ2F1ZGlvJyUyQyUyMCdzZW50ZW5jZSclMkMlMjAndXBfdm90ZXMnJTJDJTIwJ2Rvd25fdm90ZXMnJTJDJTIwJ2FnZSclMkMlMjAnZ2VuZGVyJyUyQyUyMCdhY2NlbnQnJTJDJTIwJ2xvY2FsZSclMkMlMjAnc2VnbWVudCclMkMlMjAndmFyaWFudCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDIyMTIlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTdEKQ==",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">4904</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">2212</span>
    })
})`,wrap:!1}}),U=new On({props:{$$slots:{default:[pa]},$$scope:{ctx:gs}}}),A=new y({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLnNlbGVjdF9jb2x1bW5zKCU1QiUyMmF1ZGlvJTIyJTJDJTIwJTIyc2VudGVuY2UlMjIlNUQp",highlighted:'common_voice = common_voice.select_columns([<span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;sentence&quot;</span>])',wrap:!1}}),E=new j({props:{title:"Extracteur de caractéristiques, tokeniser et processeur",local:"extracteur-de-caractéristiques-tokeniser-et-processeur",headingTag:"h2"}}),L=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMud2hpc3Blci50b2tlbml6YXRpb25fd2hpc3BlciUyMGltcG9ydCUyMFRPX0xBTkdVQUdFX0NPREUlMEElMEFUT19MQU5HVUFHRV9DT0RF",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.tokenization_whisper <span class="hljs-keyword">import</span> TO_LANGUAGE_CODE

TO_LANGUAGE_CODE`,wrap:!1}}),ee=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBXaGlzcGVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTIwbGFuZ3VhZ2UlM0QlMjJzaW5oYWxlc2UlMjIlMkMlMjB0YXNrJTNEJTIydHJhbnNjcmliZSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperProcessor

processor = WhisperProcessor.from_pretrained(
    <span class="hljs-string">&quot;openai/whisper-small&quot;</span>, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>
)`,wrap:!1}}),te=new j({props:{title:"Prétraitement des données",local:"prétraitement-des-données",headingTag:"h2"}}),ne=new y({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQuZmVhdHVyZXM=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>].features',wrap:!1}}),ie=new y({props:{code:"JTdCJ2F1ZGlvJyUzQSUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0Q0ODAwMCUyQyUyMG1vbm8lM0RUcnVlJTJDJTIwZGVjb2RlJTNEVHJ1ZSUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnc2VudGVuY2UnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklN0Q=",highlighted:`{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(<span class="hljs-attribute">sampling_rate</span>=48000, <span class="hljs-attribute">mono</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">decode</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">id</span>=None),
 <span class="hljs-string">&#x27;sentence&#x27;</span>: Value(<span class="hljs-attribute">dtype</span>=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-attribute">id</span>=None)}`,wrap:!1}}),ue=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMEFjb21tb25fdm9pY2UlMjAlM0QlMjBjb21tb25fdm9pY2UuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

sampling_rate = processor.feature_extractor.sampling_rate
common_voice = common_voice.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=sampling_rate))`,wrap:!1}}),me=new y({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTNEZXhhbXBsZSU1QiUyMnNlbnRlbmNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBpbnB1dCUyMGxlbmd0aCUyMG9mJTIwYXVkaW8lMjBzYW1wbGUlMjBpbiUyMHNlY29uZHMlMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW5wdXRfbGVuZ3RoJTIyJTVEJTIwJTNEJTIwbGVuKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTIwYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        audio=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        text=example[<span class="hljs-string">&quot;sentence&quot;</span>],
    )

    <span class="hljs-comment"># compute input length of audio sample in seconds</span>
    example[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(audio[<span class="hljs-string">&quot;array&quot;</span>]) / audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>]

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Me=new y({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLm1hcCglMEElMjAlMjAlMjAlMjBwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRGNvbW1vbl92b2ljZS5jb2x1bW5fbmFtZXMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMG51bV9wcm9jJTNEMSUwQSk=",highlighted:`common_voice = common_voice.<span class="hljs-built_in">map</span>(
    prepare_dataset, remove_columns=common_voice.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">1</span>
)`,wrap:!1}}),Je=new y({props:{code:"bWF4X2lucHV0X2xlbmd0aCUyMCUzRCUyMDMwLjAlMEElMEElMEFkZWYlMjBpc19hdWRpb19pbl9sZW5ndGhfcmFuZ2UobGVuZ3RoKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxlbmd0aCUyMCUzQyUyMG1heF9pbnB1dF9sZW5ndGg=",highlighted:`max_input_length = <span class="hljs-number">30.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_in_length_range</span>(<span class="hljs-params">length</span>):
    <span class="hljs-keyword">return</span> length &lt; max_input_length`,wrap:!1}}),je=new y({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RC5maWx0ZXIoJTBBJTIwJTIwJTIwJTIwaXNfYXVkaW9faW5fbGVuZ3RoX3JhbmdlJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmlucHV0X2xlbmd0aCUyMiU1RCUyQyUwQSk=",highlighted:`common_voice[<span class="hljs-string">&quot;train&quot;</span>] = common_voice[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">filter</span>(
    is_audio_in_length_range,
    input_columns=[<span class="hljs-string">&quot;input_length&quot;</span>],
)`,wrap:!1}}),Ue=new y({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),we=new y({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidpbnB1dF9mZWF0dXJlcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdpbnB1dF9sZW5ndGgnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA0OTA0JTBBJTdEKQ==",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;input_features&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;input_length&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">4904</span>
})`,wrap:!1}}),ve=new j({props:{title:"Entraînement et évaluation",local:"entraînement-et-évaluation",headingTag:"h2"}}),Ze=new j({props:{title:"Définir un assembleur de données",local:"définir-un-assembleur-de-données",headingTag:"h3"}}),Ge=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorSpeechSeq2SeqWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-comment"># diviser les entrées et les étiquettes car elles doivent être de longueurs différentes et nécessitent des méthodes de remplissage différentes</span>
        <span class="hljs-comment"># traiter d&#x27;abord les entrées audio en renvoyant simplement des tenseurs Torch</span>
        input_features = [
            {<span class="hljs-string">&quot;input_features&quot;</span>: feature[<span class="hljs-string">&quot;input_features&quot;</span>][<span class="hljs-number">0</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features
        ]
        batch = self.processor.feature_extractor.pad(input_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># obtenir les séquences d&#x27;étiquettes tokenisées</span>
        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        <span class="hljs-comment"># rembourrer les étiquettes à la longueur maximale</span>
        labels_batch = self.processor.tokenizer.pad(label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># remplacer le remplissage par -100 pour ignorer correctement les pertes</span>
        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(
            labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># si le token bos est ajouté lors de l&#x27;étape de tokenisation précédente, couper le token bos ici puisqu&#x27;il sera de toute façon ajouté plus tard</span>
        <span class="hljs-keyword">if</span> (labels[:, <span class="hljs-number">0</span>] == self.processor.tokenizer.bos_token_id).<span class="hljs-built_in">all</span>().cpu().item():
            labels = labels[:, <span class="hljs-number">1</span>:]

        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),Be=new y({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvclNwZWVjaFNlcTJTZXFXaXRoUGFkZGluZyhwcm9jZXNzb3IlM0Rwcm9jZXNzb3Ip",highlighted:"data_collator = DataCollatorSpeechSeq2SeqWithPadding(processor=processor)",wrap:!1}}),Xe=new j({props:{title:"Métriques d’évaluation",local:"métriques-dévaluation",headingTag:"h3"}}),Ne=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`,wrap:!1}}),Ae=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMud2hpc3Blci5lbmdsaXNoX25vcm1hbGl6ZXIlMjBpbXBvcnQlMjBCYXNpY1RleHROb3JtYWxpemVyJTBBJTBBbm9ybWFsaXplciUyMCUzRCUyMEJhc2ljVGV4dE5vcm1hbGl6ZXIoKSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhwcmVkKSUzQSUwQSUyMCUyMCUyMCUyMHByZWRfaWRzJTIwJTNEJTIwcHJlZC5wcmVkaWN0aW9ucyUwQSUyMCUyMCUyMCUyMGxhYmVsX2lkcyUyMCUzRCUyMHByZWQubGFiZWxfaWRzJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwcmVtcGxhY2VyJTIwLTEwMCUyMHBhciUyMHBhZF90b2tlbl9pZCUwQSUyMCUyMCUyMCUyMGxhYmVsX2lkcyU1QmxhYmVsX2lkcyUyMCUzRCUzRCUyMC0xMDAlNUQlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLnBhZF90b2tlbl9pZCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMG5vdXMlMjBuZSUyMHZvdWxvbnMlMjBwYXMlMjBncm91cGVyJTIwbGVzJTIwKnRva2VucyolMjBsb3JzJTIwZHUlMjBjYWxjdWwlMjBkZXMlMjBtJUMzJUE5dHJpcXVlcyUwQSUyMCUyMCUyMCUyMHByZWRfc3RyJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMGxhYmVsX3N0ciUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUobGFiZWxfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwY2FsY3VsZXIlMjBsZSUyMFdlciUyMG9ydGhvZ3JhcGhpcXVlJTBBJTIwJTIwJTIwJTIwd2VyX29ydGhvJTIwJTNEJTIwMTAwJTIwKiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZF9zdHIlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxfc3RyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNhbGN1bGVyJTIwbGUlMjBXRVIlMjBub3JtYWxpcyVDMyVBOSUwQSUyMCUyMCUyMCUyMHByZWRfc3RyX25vcm0lMjAlM0QlMjAlNUJub3JtYWxpemVyKHByZWQpJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZF9zdHIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbF9zdHJfbm9ybSUyMCUzRCUyMCU1Qm5vcm1hbGl6ZXIobGFiZWwpJTIwZm9yJTIwbGFiZWwlMjBpbiUyMGxhYmVsX3N0ciU1RCUwQSUyMCUyMCUyMCUyMCUyMyUyMGFmaW4lMjBkZSUyMG4nJUMzJUE5dmFsdWVyJTIwcXVlJTIwbGVzJTIwJUMzJUE5Y2hhbnRpbGxvbnMlMjBjb3JyZXNwb25kYW50JTIwJUMzJUEwJTIwZGVzJTIwciVDMyVBOWYlQzMlQTlyZW5jZXMlMjBub24lMjBudWxsZXMlMEElMjAlMjAlMjAlMjBwcmVkX3N0cl9ub3JtJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZF9zdHJfbm9ybSU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4ocHJlZF9zdHJfbm9ybSkpJTIwaWYlMjBsZW4obGFiZWxfc3RyX25vcm0lNUJpJTVEKSUyMCUzRSUyMDAlMEElMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjBsYWJlbF9zdHJfbm9ybSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsX3N0cl9ub3JtJTVCaSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihsYWJlbF9zdHJfbm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4obGFiZWxfc3RyX25vcm0lNUJpJTVEKSUyMCUzRSUyMDAlMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjB3ZXIlMjAlM0QlMjAxMDAlMjAqJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkX3N0cl9ub3JtJTJDJTIwcmVmZXJlbmNlcyUzRGxhYmVsX3N0cl9ub3JtKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMndlcl9vcnRobyUyMiUzQSUyMHdlcl9vcnRobyUyQyUyMCUyMndlciUyMiUzQSUyMHdlciU3RA==",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.english_normalizer <span class="hljs-keyword">import</span> BasicTextNormalizer

normalizer = BasicTextNormalizer()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">pred</span>):
    pred_ids = pred.predictions
    label_ids = pred.label_ids

    <span class="hljs-comment"># remplacer -100 par pad_token_id</span>
    label_ids[label_ids == -<span class="hljs-number">100</span>] = processor.tokenizer.pad_token_id

    <span class="hljs-comment"># nous ne voulons pas grouper les *tokens* lors du calcul des métriques</span>
    pred_str = processor.batch_decode(pred_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
    label_str = processor.batch_decode(label_ids, skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># calculer le Wer orthographique</span>
    wer_ortho = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str, references=label_str)

    <span class="hljs-comment"># calculer le WER normalisé</span>
    pred_str_norm = [normalizer(pred) <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> pred_str]
    label_str_norm = [normalizer(label) <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> label_str]
    <span class="hljs-comment"># afin de n&#x27;évaluer que les échantillons correspondant à des références non nulles</span>
    pred_str_norm = [
        pred_str_norm[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(pred_str_norm)) <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]
    label_str_norm = [
        label_str_norm[i]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(label_str_norm))
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]

    wer = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str_norm, references=label_str_norm)

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer_ortho&quot;</span>: wer_ortho, <span class="hljs-string">&quot;wer&quot;</span>: wer}`,wrap:!1}}),Ee=new j({props:{title:"Charger un checkpoint pré-entraîné",local:"charger-un-checkpoint-pré-entraîné",headingTag:"h3"}}),Qe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperForConditionalGeneration

model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),Fe=new y({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkJUMzJUE5c2FjdGl2ZXIlMjBsZSUyMGNhY2hlJTIwcGVuZGFudCUyMGwnZW50cmElQzMlQUVuZW1lbnQlMjBjYXIlMjBpbCUyMGVzdCUyMGluY29tcGF0aWJsZSUyMGF2ZWMlMjBsZSUyMGNoZWNrcG9pbnRpbmclMjBkdSUyMGdyYWRpZW50JTBBbW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNlJTBBJTBBJTIzJTIwZCVDMyVBOWZpbmlyJTIwbGElMjBsYW5ndWUlMjBldCUyMGxhJTIwdCVDMyVBMmNoZSUyMHBvdXIlMjBsYSUyMGclQzMlQTluJUMzJUE5cmF0aW9uJTIwZXQlMjByJUMzJUE5YWN0aXZlciUyMGxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwoJTBBJTIwJTIwJTIwJTIwbW9kZWwuZ2VuZXJhdGUlMkMlMjBsYW5ndWFnZSUzRCUyMnNpbmhhbGVzZSUyMiUyQyUyMHRhc2slM0QlMjJ0cmFuc2NyaWJlJTIyJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># désactiver le cache pendant l&#x27;entraînement car il est incompatible avec le checkpointing du gradient</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># définir la langue et la tâche pour la génération et réactiver le cache</span>
model.generate = partial(
    model.generate, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>, use_cache=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Se=new j({props:{title:"Définir la configuration de l’entraînement",local:"définir-la-configuration-de-lentraînement",headingTag:"h2"}}),Pe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMi4lMkZ3aGlzcGVyLXNtYWxsLWR2JTIyJTJDJTIwJTIwJTIzJTIwbm9tJTIwc3VyJTIwbGUlMjBIdWIlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDElMkMlMjAlMjAlMjMlMjAlQzMlQTAlMjB4MiUyMCUyMHBvdXIlMjBjaGFxdWUlMjBkaW1pbnV0aW9uJTIwZGUlMjAyeCUyMGRlJTIwbGElMjB0YWlsbGUlMjBkdSUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXJfdHlwZSUzRCUyMmNvbnN0YW50X3dpdGhfd2FybXVwJTIyJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q1MDAlMkMlMjAlMjAlMjMlMjBhdWdtZW50ZXIlMjBqdXNxdSclQzMlQTAlMjA0MDAwJTIwc2klMjB2b3VzJTIwZGlzcG9zZXolMjBkZSUyMHZvdHJlJTIwcHJvcHJlJTIwR1BVJTIwb3UlMjBkJ3VuJTIwcGxhbiUyMENvbGFiJTIwcGF5YW50JTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZwMTZfZnVsbF9ldmFsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBwcmVkaWN0X3dpdGhfZ2VuZXJhdGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGlvbl9tYXhfbGVuZ3RoJTNEMjI1JTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdGVwcyUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljX2Zvcl9iZXN0X21vZGVsJTNEJTIyd2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;./whisper-small-dv&quot;</span>,  <span class="hljs-comment"># nom sur le Hub</span>
    per_device_train_batch_size=<span class="hljs-number">16</span>,
    gradient_accumulation_steps=<span class="hljs-number">1</span>,  <span class="hljs-comment"># à x2  pour chaque diminution de 2x de la taille du batch</span>
    learning_rate=<span class="hljs-number">1e-5</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;constant_with_warmup&quot;</span>,
    warmup_steps=<span class="hljs-number">50</span>,
    max_steps=<span class="hljs-number">500</span>,  <span class="hljs-comment"># augmenter jusqu&#x27;à 4000 si vous disposez de votre propre GPU ou d&#x27;un plan Colab payant</span>
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    fp16_full_eval=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">16</span>,
    predict_with_generate=<span class="hljs-literal">True</span>,
    generation_max_length=<span class="hljs-number">225</span>,
    save_steps=<span class="hljs-number">500</span>,
    eval_steps=<span class="hljs-number">500</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;wer&quot;</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),h=new On({props:{$$slots:{default:[ca]},$$scope:{ctx:gs}}}),Ke=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=common_voice[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=common_voice[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    compute_metrics=compute_metrics,
    tokenizer=processor,
)`,wrap:!1}}),es=new j({props:{title:"Entraînement",local:"entraînement",headingTag:"h4"}}),ts=new y({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),cs=new y({props:{code:"a3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZGF0YXNldF90YWdzJTIyJTNBJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkYXRhc2V0JTIyJTNBJTIwJTIyQ29tbW9uJTIwVm9pY2UlMjAxMyUyMiUyQyUyMCUyMCUyMyUyMGElMjAncHJldHR5JyUyMG5hbWUlMjBmb3IlMjB0aGUlMjB0cmFpbmluZyUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjAlMjJsYW5ndWFnZSUyMiUzQSUyMCUyMmR2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMldoaXNwZXIlMjBTbWFsbCUyMER2JTIwLSUyMFNhbmNoaXQlMjBHYW5kaGklMjIlMkMlMjAlMjAlMjMlMjBhJTIwJ3ByZXR0eSclMjBuYW1lJTIwZm9yJTIweW91ciUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwJTIyZmluZXR1bmVkX2Zyb20lMjIlM0ElMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFza3MlMjIlM0ElMjAlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTBBJTdE",highlighted:`kwargs = {
    <span class="hljs-string">&quot;dataset_tags&quot;</span>: <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>,
    <span class="hljs-string">&quot;dataset&quot;</span>: <span class="hljs-string">&quot;Common Voice 13&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for the training dataset</span>
    <span class="hljs-string">&quot;language&quot;</span>: <span class="hljs-string">&quot;dv&quot;</span>,
    <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;Whisper Small Dv - Sanchit Gandhi&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for your model</span>
    <span class="hljs-string">&quot;finetuned_from&quot;</span>: <span class="hljs-string">&quot;openai/whisper-small&quot;</span>,
    <span class="hljs-string">&quot;tasks&quot;</span>: <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
}`,wrap:!1}}),ds=new y({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1YigqKmt3YXJncyk=",highlighted:"trainer.push_to_hub(**kwargs)",wrap:!1}}),js=new j({props:{title:"Partager votre modèle",local:"partager-votre-modèle",headingTag:"h2"}}),Us=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNhbmNoaXQtZ2FuZGhpJTJGd2hpc3Blci1zbWFsbC1kdiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-small-dv&quot;</span>)`,wrap:!1}}),hs=new j({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),vs=new ua({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter5/fine-tuning.mdx"}}),{c(){J=i("meta"),T=n(),f=i("p"),Cs=n(),u(w.$$.fragment),Zs=n(),u(b.$$.fragment),_s=n(),v=i("p"),v.innerHTML=xl,$s=n(),g=i("p"),g.textContent=Bl,Ws=n(),I=i("p"),I.innerHTML=kl,qs=n(),C=i("p"),C.innerHTML=Xl,Gs=n(),u(Z.$$.fragment),xs=n(),_=i("p"),_.innerHTML=zl,Bs=n(),$=i("ul"),$.innerHTML=Vl,ks=n(),W=i("p"),W.innerHTML=Nl,Xs=n(),u(q.$$.fragment),zs=n(),G=i("p"),G.innerHTML=Hl,Vs=n(),u(x.$$.fragment),Ns=n(),u(B.$$.fragment),Hs=n(),k=i("p"),k.innerHTML=Al,As=n(),X=i("p"),X.innerHTML=El,Es=n(),u(z.$$.fragment),Rs=n(),V=i("p"),V.innerHTML=Rl,Qs=n(),u(N.$$.fragment),Ys=n(),u(U.$$.fragment),Fs=n(),H=i("p"),H.innerHTML=Ql,Ss=n(),u(A.$$.fragment),Ls=n(),u(E.$$.fragment),Ps=n(),R=i("p"),R.textContent=Yl,Ds=n(),Q=i("ol"),Q.innerHTML=Fl,Ks=n(),Y=i("p"),Y.innerHTML=Sl,Os=n(),F=i("p"),F.innerHTML=Ll,et=n(),S=i("p"),S.textContent=Pl,st=n(),u(L.$$.fragment),tt=n(),P=i("p"),P.innerHTML=Dl,lt=n(),D=i("p"),D.innerHTML=Kl,nt=n(),K=i("p"),K.innerHTML=Ol,at=n(),O=i("p"),O.innerHTML=en,it=n(),u(ee.$$.fragment),rt=n(),se=i("p"),se.innerHTML=sn,ot=n(),u(te.$$.fragment),ut=n(),le=i("p"),le.innerHTML=tn,pt=n(),u(ne.$$.fragment),ct=n(),ae=i("p"),ae.innerHTML=ln,mt=n(),u(ie.$$.fragment),dt=n(),re=i("p"),re.textContent=nn,Mt=n(),oe=i("p"),oe.innerHTML=an,yt=n(),u(ue.$$.fragment),Jt=n(),pe=i("p"),pe.textContent=rn,Tt=n(),ce=i("ol"),ce.innerHTML=on,jt=n(),u(me.$$.fragment),ft=n(),de=i("p"),de.innerHTML=un,Ut=n(),u(Me.$$.fragment),ht=n(),ye=i("p"),ye.innerHTML=pn,wt=n(),u(Je.$$.fragment),bt=n(),Te=i("p"),Te.innerHTML=cn,vt=n(),u(je.$$.fragment),gt=n(),fe=i("p"),fe.textContent=mn,It=n(),u(Ue.$$.fragment),Ct=n(),he=i("p"),he.innerHTML=dn,Zt=n(),u(we.$$.fragment),_t=n(),be=i("p"),be.innerHTML=Mn,$t=n(),u(ve.$$.fragment),Wt=n(),ge=i("p"),ge.innerHTML=yn,qt=n(),Ie=i("ul"),Ie.innerHTML=Jn,Gt=n(),Ce=i("p"),Ce.innerHTML=Tn,xt=n(),u(Ze.$$.fragment),Bt=n(),_e=i("p"),_e.innerHTML=jn,kt=n(),$e=i("p"),$e.innerHTML=fn,Xt=n(),We=i("p"),We.innerHTML=Un,zt=n(),qe=i("p"),qe.innerHTML=hn,Vt=n(),u(Ge.$$.fragment),Nt=n(),xe=i("p"),xe.textContent=wn,Ht=n(),u(Be.$$.fragment),At=n(),ke=i("p"),ke.textContent=bn,Et=n(),u(Xe.$$.fragment),Rt=n(),ze=i("p"),ze.innerHTML=vn,Qt=n(),Ve=i("p"),Ve.innerHTML=gn,Yt=n(),u(Ne.$$.fragment),Ft=n(),He=i("p"),He.innerHTML=In,St=n(),u(Ae.$$.fragment),Lt=n(),u(Ee.$$.fragment),Pt=n(),Re=i("p"),Re.innerHTML=Cn,Dt=n(),u(Qe.$$.fragment),Kt=n(),Ye=i("p"),Ye.innerHTML=Zn,Ot=n(),u(Fe.$$.fragment),el=n(),u(Se.$$.fragment),sl=n(),Le=i("p"),Le.innerHTML=_n,tl=n(),u(Pe.$$.fragment),ll=n(),u(h.$$.fragment),nl=n(),De=i("p"),De.innerHTML=$n,al=n(),u(Ke.$$.fragment),il=n(),Oe=i("p"),Oe.textContent=Wn,rl=n(),u(es.$$.fragment),ol=n(),ss=i("p"),ss.textContent=qn,ul=n(),u(ts.$$.fragment),pl=n(),ls=i("p"),ls.innerHTML=Gn,cl=n(),ns=i("p"),ns.innerHTML=xn,ml=n(),as=i("table"),as.innerHTML=Bn,dl=n(),is=i("p"),is.innerHTML=kn,Ml=n(),rs=i("p"),rs.innerHTML=Xn,yl=n(),os=i("p"),os.innerHTML=zn,Jl=n(),us=i("p"),us.innerHTML=Vn,Tl=n(),ps=i("p"),ps.innerHTML=Nn,jl=n(),u(cs.$$.fragment),fl=n(),ms=i("p"),ms.innerHTML=Hn,Ul=n(),u(ds.$$.fragment),hl=n(),Ms=i("p"),Ms.innerHTML=An,wl=n(),ys=i("p"),ys.innerHTML=En,bl=n(),Js=i("p"),Js.innerHTML=Rn,vl=n(),Ts=i("p"),Ts.innerHTML=Qn,gl=n(),u(js.$$.fragment),Il=n(),fs=i("p"),fs.innerHTML=Yn,Cl=n(),u(Us.$$.fragment),Zl=n(),u(hs.$$.fragment),_l=n(),ws=i("p"),ws.innerHTML=Fn,$l=n(),bs=i("p"),bs.innerHTML=Sn,Wl=n(),u(vs.$$.fragment),ql=n(),Is=i("p"),this.h()},l(e){const s=ia("svelte-u9bgzb",document.head);J=r(s,"META",{name:!0,content:!0}),s.forEach(t),T=a(e),f=r(e,"P",{}),Dn(f).forEach(t),Cs=a(e),p(w.$$.fragment,e),Zs=a(e),p(b.$$.fragment,e),_s=a(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-7xhodp"&&(v.innerHTML=xl),$s=a(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-4imhws"&&(g.textContent=Bl),Ws=a(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-311mw7"&&(I.innerHTML=kl),qs=a(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-2difxl"&&(C.innerHTML=Xl),Gs=a(e),p(Z.$$.fragment,e),xs=a(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1utckd2"&&(_.innerHTML=zl),Bs=a(e),$=r(e,"UL",{"data-svelte-h":!0}),o($)!=="svelte-1j0por"&&($.innerHTML=Vl),ks=a(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-x9ppr7"&&(W.innerHTML=Nl),Xs=a(e),p(q.$$.fragment,e),zs=a(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-dbzevp"&&(G.innerHTML=Hl),Vs=a(e),p(x.$$.fragment,e),Ns=a(e),p(B.$$.fragment,e),Hs=a(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-71vyw5"&&(k.innerHTML=Al),As=a(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-12unh11"&&(X.innerHTML=El),Es=a(e),p(z.$$.fragment,e),Rs=a(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-dbzevp"&&(V.innerHTML=Rl),Qs=a(e),p(N.$$.fragment,e),Ys=a(e),p(U.$$.fragment,e),Fs=a(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-ybamg3"&&(H.innerHTML=Ql),Ss=a(e),p(A.$$.fragment,e),Ls=a(e),p(E.$$.fragment,e),Ps=a(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-qk6exq"&&(R.textContent=Yl),Ds=a(e),Q=r(e,"OL",{"data-svelte-h":!0}),o(Q)!=="svelte-1yr2wae"&&(Q.innerHTML=Fl),Ks=a(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-coa99w"&&(Y.innerHTML=Sl),Os=a(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-p9miuc"&&(F.innerHTML=Ll),et=a(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-101xqap"&&(S.textContent=Pl),st=a(e),p(L.$$.fragment,e),tt=a(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-mv87b3"&&(P.innerHTML=Dl),lt=a(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-ftdzgz"&&(D.innerHTML=Kl),nt=a(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-32kddc"&&(K.innerHTML=Ol),at=a(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1bhj23r"&&(O.innerHTML=en),it=a(e),p(ee.$$.fragment,e),rt=a(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1vetgq4"&&(se.innerHTML=sn),ot=a(e),p(te.$$.fragment,e),ut=a(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1s88cms"&&(le.innerHTML=tn),pt=a(e),p(ne.$$.fragment,e),ct=a(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-dbzevp"&&(ae.innerHTML=ln),mt=a(e),p(ie.$$.fragment,e),dt=a(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-bhbzlh"&&(re.textContent=nn),Mt=a(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1c9l05"&&(oe.innerHTML=an),yt=a(e),p(ue.$$.fragment,e),Jt=a(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-kma8yf"&&(pe.textContent=rn),Tt=a(e),ce=r(e,"OL",{"data-svelte-h":!0}),o(ce)!=="svelte-l386lk"&&(ce.innerHTML=on),jt=a(e),p(me.$$.fragment,e),ft=a(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-p7ipd6"&&(de.innerHTML=un),Ut=a(e),p(Me.$$.fragment,e),ht=a(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1qc8iml"&&(ye.innerHTML=pn),wt=a(e),p(Je.$$.fragment,e),bt=a(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-gzokzm"&&(Te.innerHTML=cn),vt=a(e),p(je.$$.fragment,e),gt=a(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1astr79"&&(fe.textContent=mn),It=a(e),p(Ue.$$.fragment,e),Ct=a(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-dbzevp"&&(he.innerHTML=dn),Zt=a(e),p(we.$$.fragment,e),_t=a(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-p7jukp"&&(be.innerHTML=Mn),$t=a(e),p(ve.$$.fragment,e),Wt=a(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1mq6oan"&&(ge.innerHTML=yn),qt=a(e),Ie=r(e,"UL",{"data-svelte-h":!0}),o(Ie)!=="svelte-sqta85"&&(Ie.innerHTML=Jn),Gt=a(e),Ce=r(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-2uwoqk"&&(Ce.innerHTML=Tn),xt=a(e),p(Ze.$$.fragment,e),Bt=a(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1k53otr"&&(_e.innerHTML=jn),kt=a(e),$e=r(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-enj5n1"&&($e.innerHTML=fn),Xt=a(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1g4czpk"&&(We.innerHTML=Un),zt=a(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-i0n36t"&&(qe.innerHTML=hn),Vt=a(e),p(Ge.$$.fragment,e),Nt=a(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-cc0sp7"&&(xe.textContent=wn),Ht=a(e),p(Be.$$.fragment,e),At=a(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-nyz60k"&&(ke.textContent=bn),Et=a(e),p(Xe.$$.fragment,e),Rt=a(e),ze=r(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-3hsyij"&&(ze.innerHTML=vn),Qt=a(e),Ve=r(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-c52gbi"&&(Ve.innerHTML=gn),Yt=a(e),p(Ne.$$.fragment,e),Ft=a(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1j3exdi"&&(He.innerHTML=In),St=a(e),p(Ae.$$.fragment,e),Lt=a(e),p(Ee.$$.fragment,e),Pt=a(e),Re=r(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-db0asr"&&(Re.innerHTML=Cn),Dt=a(e),p(Qe.$$.fragment,e),Kt=a(e),Ye=r(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-17vn05i"&&(Ye.innerHTML=Zn),Ot=a(e),p(Fe.$$.fragment,e),el=a(e),p(Se.$$.fragment,e),sl=a(e),Le=r(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1gc8mk7"&&(Le.innerHTML=_n),tl=a(e),p(Pe.$$.fragment,e),ll=a(e),p(h.$$.fragment,e),nl=a(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-1hcg6it"&&(De.innerHTML=$n),al=a(e),p(Ke.$$.fragment,e),il=a(e),Oe=r(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-iy6ynd"&&(Oe.textContent=Wn),rl=a(e),p(es.$$.fragment,e),ol=a(e),ss=r(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-v8wedd"&&(ss.textContent=qn),ul=a(e),p(ts.$$.fragment,e),pl=a(e),ls=r(e,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-igzv0v"&&(ls.innerHTML=Gn),cl=a(e),ns=r(e,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-dbzevp"&&(ns.innerHTML=xn),ml=a(e),as=r(e,"TABLE",{"data-svelte-h":!0}),o(as)!=="svelte-10vryw9"&&(as.innerHTML=Bn),dl=a(e),is=r(e,"P",{"data-svelte-h":!0}),o(is)!=="svelte-189evyt"&&(is.innerHTML=kn),Ml=a(e),rs=r(e,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-c68dny"&&(rs.innerHTML=Xn),yl=a(e),os=r(e,"P",{"data-svelte-h":!0}),o(os)!=="svelte-1i7i3ab"&&(os.innerHTML=zn),Jl=a(e),us=r(e,"P",{"data-svelte-h":!0}),o(us)!=="svelte-e0goyt"&&(us.innerHTML=Vn),Tl=a(e),ps=r(e,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-10v9yjn"&&(ps.innerHTML=Nn),jl=a(e),p(cs.$$.fragment,e),fl=a(e),ms=r(e,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-8qq12z"&&(ms.innerHTML=Hn),Ul=a(e),p(ds.$$.fragment,e),hl=a(e),Ms=r(e,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-1n05g3i"&&(Ms.innerHTML=An),wl=a(e),ys=r(e,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-jftxq6"&&(ys.innerHTML=En),bl=a(e),Js=r(e,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-muxy92"&&(Js.innerHTML=Rn),vl=a(e),Ts=r(e,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-15dfq0u"&&(Ts.innerHTML=Qn),gl=a(e),p(js.$$.fragment,e),Il=a(e),fs=r(e,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-1ecvei2"&&(fs.innerHTML=Yn),Cl=a(e),p(Us.$$.fragment,e),Zl=a(e),p(hs.$$.fragment,e),_l=a(e),ws=r(e,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-7weori"&&(ws.innerHTML=Fn),$l=a(e),bs=r(e,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-1a2cjs"&&(bs.innerHTML=Sn),Wl=a(e),p(vs.$$.fragment,e),ql=a(e),Is=r(e,"P",{}),Dn(Is).forEach(t),this.h()},h(){Kn(J,"name","hf:doc:metadata"),Kn(J,"content",da)},m(e,s){ra(document.head,J),l(e,T,s),l(e,f,s),l(e,Cs,s),c(w,e,s),l(e,Zs,s),c(b,e,s),l(e,_s,s),l(e,v,s),l(e,$s,s),l(e,g,s),l(e,Ws,s),l(e,I,s),l(e,qs,s),l(e,C,s),l(e,Gs,s),c(Z,e,s),l(e,xs,s),l(e,_,s),l(e,Bs,s),l(e,$,s),l(e,ks,s),l(e,W,s),l(e,Xs,s),c(q,e,s),l(e,zs,s),l(e,G,s),l(e,Vs,s),c(x,e,s),l(e,Ns,s),c(B,e,s),l(e,Hs,s),l(e,k,s),l(e,As,s),l(e,X,s),l(e,Es,s),c(z,e,s),l(e,Rs,s),l(e,V,s),l(e,Qs,s),c(N,e,s),l(e,Ys,s),c(U,e,s),l(e,Fs,s),l(e,H,s),l(e,Ss,s),c(A,e,s),l(e,Ls,s),c(E,e,s),l(e,Ps,s),l(e,R,s),l(e,Ds,s),l(e,Q,s),l(e,Ks,s),l(e,Y,s),l(e,Os,s),l(e,F,s),l(e,et,s),l(e,S,s),l(e,st,s),c(L,e,s),l(e,tt,s),l(e,P,s),l(e,lt,s),l(e,D,s),l(e,nt,s),l(e,K,s),l(e,at,s),l(e,O,s),l(e,it,s),c(ee,e,s),l(e,rt,s),l(e,se,s),l(e,ot,s),c(te,e,s),l(e,ut,s),l(e,le,s),l(e,pt,s),c(ne,e,s),l(e,ct,s),l(e,ae,s),l(e,mt,s),c(ie,e,s),l(e,dt,s),l(e,re,s),l(e,Mt,s),l(e,oe,s),l(e,yt,s),c(ue,e,s),l(e,Jt,s),l(e,pe,s),l(e,Tt,s),l(e,ce,s),l(e,jt,s),c(me,e,s),l(e,ft,s),l(e,de,s),l(e,Ut,s),c(Me,e,s),l(e,ht,s),l(e,ye,s),l(e,wt,s),c(Je,e,s),l(e,bt,s),l(e,Te,s),l(e,vt,s),c(je,e,s),l(e,gt,s),l(e,fe,s),l(e,It,s),c(Ue,e,s),l(e,Ct,s),l(e,he,s),l(e,Zt,s),c(we,e,s),l(e,_t,s),l(e,be,s),l(e,$t,s),c(ve,e,s),l(e,Wt,s),l(e,ge,s),l(e,qt,s),l(e,Ie,s),l(e,Gt,s),l(e,Ce,s),l(e,xt,s),c(Ze,e,s),l(e,Bt,s),l(e,_e,s),l(e,kt,s),l(e,$e,s),l(e,Xt,s),l(e,We,s),l(e,zt,s),l(e,qe,s),l(e,Vt,s),c(Ge,e,s),l(e,Nt,s),l(e,xe,s),l(e,Ht,s),c(Be,e,s),l(e,At,s),l(e,ke,s),l(e,Et,s),c(Xe,e,s),l(e,Rt,s),l(e,ze,s),l(e,Qt,s),l(e,Ve,s),l(e,Yt,s),c(Ne,e,s),l(e,Ft,s),l(e,He,s),l(e,St,s),c(Ae,e,s),l(e,Lt,s),c(Ee,e,s),l(e,Pt,s),l(e,Re,s),l(e,Dt,s),c(Qe,e,s),l(e,Kt,s),l(e,Ye,s),l(e,Ot,s),c(Fe,e,s),l(e,el,s),c(Se,e,s),l(e,sl,s),l(e,Le,s),l(e,tl,s),c(Pe,e,s),l(e,ll,s),c(h,e,s),l(e,nl,s),l(e,De,s),l(e,al,s),c(Ke,e,s),l(e,il,s),l(e,Oe,s),l(e,rl,s),c(es,e,s),l(e,ol,s),l(e,ss,s),l(e,ul,s),c(ts,e,s),l(e,pl,s),l(e,ls,s),l(e,cl,s),l(e,ns,s),l(e,ml,s),l(e,as,s),l(e,dl,s),l(e,is,s),l(e,Ml,s),l(e,rs,s),l(e,yl,s),l(e,os,s),l(e,Jl,s),l(e,us,s),l(e,Tl,s),l(e,ps,s),l(e,jl,s),c(cs,e,s),l(e,fl,s),l(e,ms,s),l(e,Ul,s),c(ds,e,s),l(e,hl,s),l(e,Ms,s),l(e,wl,s),l(e,ys,s),l(e,bl,s),l(e,Js,s),l(e,vl,s),l(e,Ts,s),l(e,gl,s),c(js,e,s),l(e,Il,s),l(e,fs,s),l(e,Cl,s),c(Us,e,s),l(e,Zl,s),c(hs,e,s),l(e,_l,s),l(e,ws,s),l(e,$l,s),l(e,bs,s),l(e,Wl,s),c(vs,e,s),l(e,ql,s),l(e,Is,s),Gl=!0},p(e,[s]){const Ln={};s&2&&(Ln.$$scope={dirty:s,ctx:e}),U.$set(Ln);const Pn={};s&2&&(Pn.$$scope={dirty:s,ctx:e}),h.$set(Pn)},i(e){Gl||(m(w.$$.fragment,e),m(b.$$.fragment,e),m(Z.$$.fragment,e),m(q.$$.fragment,e),m(x.$$.fragment,e),m(B.$$.fragment,e),m(z.$$.fragment,e),m(N.$$.fragment,e),m(U.$$.fragment,e),m(A.$$.fragment,e),m(E.$$.fragment,e),m(L.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(ue.$$.fragment,e),m(me.$$.fragment,e),m(Me.$$.fragment,e),m(Je.$$.fragment,e),m(je.$$.fragment,e),m(Ue.$$.fragment,e),m(we.$$.fragment,e),m(ve.$$.fragment,e),m(Ze.$$.fragment,e),m(Ge.$$.fragment,e),m(Be.$$.fragment,e),m(Xe.$$.fragment,e),m(Ne.$$.fragment,e),m(Ae.$$.fragment,e),m(Ee.$$.fragment,e),m(Qe.$$.fragment,e),m(Fe.$$.fragment,e),m(Se.$$.fragment,e),m(Pe.$$.fragment,e),m(h.$$.fragment,e),m(Ke.$$.fragment,e),m(es.$$.fragment,e),m(ts.$$.fragment,e),m(cs.$$.fragment,e),m(ds.$$.fragment,e),m(js.$$.fragment,e),m(Us.$$.fragment,e),m(hs.$$.fragment,e),m(vs.$$.fragment,e),Gl=!0)},o(e){d(w.$$.fragment,e),d(b.$$.fragment,e),d(Z.$$.fragment,e),d(q.$$.fragment,e),d(x.$$.fragment,e),d(B.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(U.$$.fragment,e),d(A.$$.fragment,e),d(E.$$.fragment,e),d(L.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(Me.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d(Ue.$$.fragment,e),d(we.$$.fragment,e),d(ve.$$.fragment,e),d(Ze.$$.fragment,e),d(Ge.$$.fragment,e),d(Be.$$.fragment,e),d(Xe.$$.fragment,e),d(Ne.$$.fragment,e),d(Ae.$$.fragment,e),d(Ee.$$.fragment,e),d(Qe.$$.fragment,e),d(Fe.$$.fragment,e),d(Se.$$.fragment,e),d(Pe.$$.fragment,e),d(h.$$.fragment,e),d(Ke.$$.fragment,e),d(es.$$.fragment,e),d(ts.$$.fragment,e),d(cs.$$.fragment,e),d(ds.$$.fragment,e),d(js.$$.fragment,e),d(Us.$$.fragment,e),d(hs.$$.fragment,e),d(vs.$$.fragment,e),Gl=!1},d(e){e&&(t(T),t(f),t(Cs),t(Zs),t(_s),t(v),t($s),t(g),t(Ws),t(I),t(qs),t(C),t(Gs),t(xs),t(_),t(Bs),t($),t(ks),t(W),t(Xs),t(zs),t(G),t(Vs),t(Ns),t(Hs),t(k),t(As),t(X),t(Es),t(Rs),t(V),t(Qs),t(Ys),t(Fs),t(H),t(Ss),t(Ls),t(Ps),t(R),t(Ds),t(Q),t(Ks),t(Y),t(Os),t(F),t(et),t(S),t(st),t(tt),t(P),t(lt),t(D),t(nt),t(K),t(at),t(O),t(it),t(rt),t(se),t(ot),t(ut),t(le),t(pt),t(ct),t(ae),t(mt),t(dt),t(re),t(Mt),t(oe),t(yt),t(Jt),t(pe),t(Tt),t(ce),t(jt),t(ft),t(de),t(Ut),t(ht),t(ye),t(wt),t(bt),t(Te),t(vt),t(gt),t(fe),t(It),t(Ct),t(he),t(Zt),t(_t),t(be),t($t),t(Wt),t(ge),t(qt),t(Ie),t(Gt),t(Ce),t(xt),t(Bt),t(_e),t(kt),t($e),t(Xt),t(We),t(zt),t(qe),t(Vt),t(Nt),t(xe),t(Ht),t(At),t(ke),t(Et),t(Rt),t(ze),t(Qt),t(Ve),t(Yt),t(Ft),t(He),t(St),t(Lt),t(Pt),t(Re),t(Dt),t(Kt),t(Ye),t(Ot),t(el),t(sl),t(Le),t(tl),t(ll),t(nl),t(De),t(al),t(il),t(Oe),t(rl),t(ol),t(ss),t(ul),t(pl),t(ls),t(cl),t(ns),t(ml),t(as),t(dl),t(is),t(Ml),t(rs),t(yl),t(os),t(Jl),t(us),t(Tl),t(ps),t(jl),t(fl),t(ms),t(Ul),t(hl),t(Ms),t(wl),t(ys),t(bl),t(Js),t(vl),t(Ts),t(gl),t(Il),t(fs),t(Cl),t(Zl),t(_l),t(ws),t($l),t(bs),t(Wl),t(ql),t(Is)),t(J),M(w,e),M(b,e),M(Z,e),M(q,e),M(x,e),M(B,e),M(z,e),M(N,e),M(U,e),M(A,e),M(E,e),M(L,e),M(ee,e),M(te,e),M(ne,e),M(ie,e),M(ue,e),M(me,e),M(Me,e),M(Je,e),M(je,e),M(Ue,e),M(we,e),M(ve,e),M(Ze,e),M(Ge,e),M(Be,e),M(Xe,e),M(Ne,e),M(Ae,e),M(Ee,e),M(Qe,e),M(Fe,e),M(Se,e),M(Pe,e),M(h,e),M(Ke,e),M(es,e),M(ts,e),M(cs,e),M(ds,e),M(js,e),M(Us,e),M(hs,e),M(vs,e)}}}const da='{"title":"Comment finetuner un système de reconnaissance automatique de la parole avec l’API Trainer","local":"comment-finetuner-un-système-de-reconnaissance-automatique-de-la-parole-avec-lapi-trainer","sections":[{"title":"Préparer l’environnement","local":"préparer-lenvironnement","sections":[],"depth":2},{"title":"Charger le jeu de données","local":"charger-le-jeu-de-données","sections":[],"depth":2},{"title":"Extracteur de caractéristiques, tokeniser et processeur","local":"extracteur-de-caractéristiques-tokeniser-et-processeur","sections":[],"depth":2},{"title":"Prétraitement des données","local":"prétraitement-des-données","sections":[],"depth":2},{"title":"Entraînement et évaluation","local":"entraînement-et-évaluation","sections":[{"title":"Définir un assembleur de données","local":"définir-un-assembleur-de-données","sections":[],"depth":3},{"title":"Métriques d’évaluation","local":"métriques-dévaluation","sections":[],"depth":3},{"title":"Charger un checkpoint pré-entraîné","local":"charger-un-checkpoint-pré-entraîné","sections":[],"depth":3}],"depth":2},{"title":"Définir la configuration de l’entraînement","local":"définir-la-configuration-de-lentraînement","sections":[{"title":"Entraînement","local":"entraînement","sections":[],"depth":4}],"depth":2},{"title":"Partager votre modèle","local":"partager-votre-modèle","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Ma(gs){return la(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ua extends na{constructor(J){super(),aa(this,J,Ma,ma,ta,{})}}export{Ua as component};
