# Unité 2 : Une introduction en douceur aux applications audio

Bienvenue dans la deuxième unité du cours audio Hugging Face ! Précédemment, nous avons exploré les principes fondamentaux des données audio et appris à travailler avec des jeux de données audio en utilisant les bibliothèques 🤗 *Datasets* et 🤗 *Transformers*.
Nous avons abordé divers concepts tels que la fréquence d'échantillonnage, l'amplitude, la profondeur de bits, la forme d'onde et les spectrogrammes, et nous avons vu comment prétraiter les données pour les préparer à un modèle pré-entraîné.

À ce stade, vous êtes peut-être impatient de découvrir les tâches audio que 🤗 *Transformers* peut gérer, et vous avez toutes les connaissances de base nécessaires pour vous y plonger ! Jetons un coup d'œil à quelques exemples de tâches audio époustouflantes :

**Classification audio** : classez facilement les clips audio dans différentes catégories. Vous pouvez déterminer si un enregistrement est celui d'un chien qui aboie ou d'un chat qui miaule, ou à quel genre musical appartient une chanson.
**Reconnaissance automatique de la parole** : transformez les clips audio en texte en les transcrivant automatiquement. Vous pouvez obtenir une représentation textuelle d'un enregistrement de quelqu'un qui parle, comme "Comment allez-vous aujourd'hui ?". Plutôt utile pour la prise de notes !
**Diagnostic du locuteur** : Vous vous êtes déjà demandé qui parlait dans un enregistrement ? Avec 🤗 *Transformers*, vous pouvez identifier le locuteur qui parle à un moment donné dans un clip audio. Imaginez que vous puissiez faire la différence entre "Alice" et "Bob" dans un enregistrement de leur conversation.
**Text to speech** : créer une version narrée d'un texte qui peut être utilisée pour produire un livre audio, aider à l'accessibilité ou donner une voix à un PNJ dans un jeu. Avec 🤗 *Transformers*, vous pouvez facilement le faire !

Dans cette unité, vous apprendrez à utiliser des modèles pré-entraînés pour certaines de ces tâches en utilisant la fonction `pipeline()` de 🤗 *Transformers*.
Plus précisément, nous verrons comment les modèles pré-entraînés peuvent être utilisés pour la classification audio et la reconnaissance automatique de la parole.
C'est parti !


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/fr/chapter2/introduction.mdx" />