# Проверьте свое понимание материала курса

### 1. В каких единицах измеряется частота дискретизации?

<Question
	choices={[
		{
			text: "дБ",
			explain: "Нет, амплитуда измеряется в децибелах (дБ)."
		},
		{
			text: "Гц",
			explain: "Частота дискретизации - это количество выборок, сделанных за одну секунду, она измеряется в герцах (Гц).",
			correct: true
		},
		{
			text: "бит",
			explain: "Биты используются для описания битовой глубины, под которой понимается количество битов информации, используемых для представления каждого образца аудиосигнала.",
		}
	]}
/>

### 2. При потоковой передаче большого набора аудиоданных как скоро можно начать его использовать?

<Question
	choices={[
		{
			text: "Как только набор данных будет загружен полностью.",
			explain: "Цель потоковой передачи данных состоит в том, чтобы иметь возможность работать с ними без необходимости полной загрузки набора данных."
		},
		{
			text: "Как только первые 16 образцов будут загружены.",
			explain: "Попробуйте еще раз!"
		},
		{
			text: "Как только первый образец будет загружен.",
			explain: "",
			correct: true
		}
	]}
/>

### 3. Что такое спектрограмма?

<Question
	choices={[
		{
			text: "Устройство, используемое для оцифровки звука, который сначала улавливается микрофоном, преобразующим звуковые волны в электрический сигнал.",
			explain: "Устройство, используемое для оцифровки такого электрического сигнала, называется аналого-цифровым преобразователем. Попробуйте еще раз!"
		},
		{
			text: "График, показывающий изменение амплитуды звукового сигнала с течением времени. Он также известен как *временная область* представления звука.",
			explain: "В приведенном описании речь идет о форме волны, а не о спектрограмме."
		},
		{
			text: "Визуальное представление частотного спектра сигнала при его изменении во времени.",
			explain: "",
			correct: true
		}
	]}
/>

### 4. Как проще всего преобразовать сырые аудиоданные в лог-мел спектрограмму, ожидаемую Whisper?

A.
```python
librosa.feature.melspectrogram(audio["array"])
```

B.
```python
feature_extractor = WhisperFeatureExtractor.from_pretrained("openai/whisper-small")
feature_extractor(audio["array"])
```

C.
```python
dataset.feature(audio["array"], model="whisper")
```

<Question
	choices={[
		{
			text: "A",
			explain: "`librosa.feature.melspectrogram()` создает спектрограмму мощности."
		},
		{
			text: "B",
			explain: "",
			correct: true
		},
		{
			text: "C",
			explain: "Dataset не подготавливает признаки для моделей Transformer, это делает препроцессор модели."
		}
	]}
/>

### 5. Как загрузить набор данных из 🤗 Hub?

A.
```python
from datasets import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

B.
```python
import librosa

dataset = librosa.load(PATH_TO_DATASET)
```

C.
```python
from transformers import load_dataset

dataset = load_dataset(DATASET_NAME_ON_HUB)
```

<Question
	choices={[
		{
			text: "A",
			explain: "Лучше всего использовать библиотеку 🤗 Datasets.",
			correct: true
		},
		{
			text: "B",
			explain: "Librosa.load удобен для загрузки отдельного аудиофайла расположенного по пути в кортеж с временным рядом и частотой дискретизации, но не целого набора данных с большим количеством образцов и множеством признаков. "
		},
		{
			text: "C",
			explain: "Метод load_dataset находится в библиотеке 🤗 Datasets, а не в 🤗 Transformers."
		}
	]}
/>

### 6. Ваш пользовательский набор данных содержит высококачественные аудиозаписи с частотой дискретизации 32 кГц. Вы хотите обучить модель распознавания речи, которая ожидает, что аудиопримеры будут иметь частоту дискретизации 16 кГц. Что нужно сделать?

<Question
	choices={[
		{
			text: "Используйте примеры как есть, модель легко обобщится на более качественные аудиопримеры.",
			explain: "Из-за зависимости от механизма внимания моделям сложно обобщать данные с разной частотой дискретизации."
		},
		{
			text: "Используйте модуль Audio из библиотеки 🤗 Datasets для понижения частоты дискретизации примеров в пользовательском наборе данных",
			explain: "",
			correct: true
		},
		{
			text: "Уменьшите выборку в 2 раза, отбросив все остальные образцы.",
			explain: "При этом в сигнале возникают искажения, называемые наложениями (aliases). Корректная передискретизация - сложная задача, и ее лучше доверить проверенным библиотекам, таким как librosa или 🤗 Datasets."
		}
	]}
/>

### 7. Как преобразовать спектрограмму, сгенерированную моделью машинного обучения, в форму волны?

<Question
	choices={[
		{
			text: "Для восстановления формы волны из спектрограммы мы можем использовать нейронную сеть, называемую вокодером.",
			explain: "Поскольку фазовая информация в этом случае отсутствует, для восстановления формы сигнала необходимо использовать вокодер или классический алгоритм Гриффина-Лима.",
			correct: true
		},
		{
			text: "Мы можем использовать обратное ОПФ для преобразования сгенерированной спектрограммы в форму волны",
			explain: "В сгенерированной спектрограмме отсутствует фазовая информация, необходимая для использования инверсного ОПФ."
		},
		{
			text: "Вы не можете преобразовать спектрограмму, сгенерированную моделью машинного обучения, в форму волны.",
			explain: "Попробуйте еще раз!"
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter1/quiz.mdx" />