# Раздел 6. От текста к речи 

В предыдущем разделе вы узнали, как использовать трансформеры для преобразования устной речи в текст. Теперь давайте перевернем сценарий
и посмотрим, как можно преобразовать заданный входной текст в аудио вывод, звучащий как человеческая речь.

Задача, которую мы будем изучать в этом блоке, называется "Преобразование текста в речь " (Text-to-speech, TTS). Модели, способные преобразовывать текст в слышимую
человеческую речь, имеют широкий спектр потенциальных применений: 

* Вспомогательные приложения: подумайте об инструментах, которые могут использовать эти модели для обеспечения доступа людей с ослабленным зрением к цифровому контенту с помощью звука.
* Озвучивание аудиокниг: перевод письменных книг в аудиоформат делает литературу более доступной для тех, кто предпочитает слушать или испытывает трудности с чтением.
* Виртуальные помощники: TTS-модели являются фундаментальным компонентом виртуальных помощников, таких как Siri, Google Assistant или Amazon Alexa. После того как они с помощью классификационной модели поймали слово "пробуждение" и использовали ASR-модель для обработки запроса, они могут использовать TTS-модель для ответа на ваш запрос.
* Развлечения, игры и изучение языков: озвучивайте персонажей NPC, рассказывайте об игровых событиях или помогайте изучающим язык примерами правильного произношения и интонации слов и фраз.

Это лишь некоторые примеры, и я уверен, что вы можете придумать множество других! Однако с такой мощью приходит и ответственность
,важно подчеркнуть, что модели TTS потенциально могут быть использованы в злонамеренных целях. 
Например, имея достаточное количество образцов голоса, злоумышленники могут создавать убедительные поддельные аудиозаписи, что приводит к
несанкционированному использованию голоса человека в мошеннических целях или для манипуляций. Если вы планируете собирать данные для дообучения
собственных систем, тщательно продумайте вопросы конфиденциальности и информационного согласия. Получение голосовых данных должно осуществляться с явного согласия
людей, при этом они должны понимать цель, объем и потенциальные риски, связанные с использованием их голоса
в системе TTS. Пожалуйста, используйте преобразование текста в речь ответственно. 

## Чему вы научитесь и что создадите

В этом разделе мы поговорим о:

* [Наборах данных, пригодных для обучения Text-to-speech](tts_datasets)
* [Предварительно обученных моделях для преобразования текста в речь](pre-trained_models)
* [Дообучение SpeechT5 на новом языке](fine-tuning)
* [Оценке моделей TTS](evaluation)


<EditOnGithub source="https://github.com/huggingface/audio-transformers-course/blob/main/chapters/ru/chapter6/introduction.mdx" />