import{s as ga,o as _a,n as re}from"../chunks/scheduler.9bc65507.js";import{S as ba,i as va,g as i,s as o,r as p,A as ka,h as l,f as n,c as a,j as M,u,x as m,k as x,y as s,a as r,v as h,d as f,t as g,w as _}from"../chunks/index.707bf1b6.js";import{T as Cn}from"../chunks/Tip.c2ecdbf4.js";import{D as F}from"../chunks/Docstring.17db21ae.js";import{C as At}from"../chunks/CodeBlock.54a9f38d.js";import{E as Fn}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as fa}from"../chunks/PipelineTag.44585822.js";import{H as V}from"../chunks/Heading.342b1fa6.js";function ya(C){let d,k="The <code>Llama2</code> models were trained using <code>bfloat16</code>, but the original inference uses <code>float16. The checkpoints uploaded on the hub use </code>torch_dtype = ‘float16’<code>which will be used by the</code>AutoModel<code>API to cast the checkpoints from</code>torch.float32<code>to</code>torch.float16`.",c,v,w="The <code>dtype</code> of the online weights is mostly irrelevant, unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>. The reason is that the model will first be downloaded ( using the <code>dtype</code> of the checkpoints online) then it will be casted to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>) and finally, if there is a <code>torch_dtype</code> provided in the config, it will be used.",b,L,ie="Training the model in <code>float16</code> is not recommended and known to produce <code>nan</code>, as such the model should be trained in <code>bfloat16</code>.";return{c(){d=i("p"),d.innerHTML=k,c=o(),v=i("p"),v.innerHTML=w,b=o(),L=i("p"),L.innerHTML=ie},l($){d=l($,"P",{"data-svelte-h":!0}),m(d)!=="svelte-g9c9om"&&(d.innerHTML=k),c=a($),v=l($,"P",{"data-svelte-h":!0}),m(v)!=="svelte-ug0twd"&&(v.innerHTML=w),b=a($),L=l($,"P",{"data-svelte-h":!0}),m(L)!=="svelte-gosvm7"&&(L.innerHTML=ie)},m($,B){r($,d,B),r($,c,B),r($,v,B),r($,b,B),r($,L,B)},p:re,d($){$&&(n(d),n(c),n(v),n(b),n(L))}}}function Ta(C){let d,k;return d=new At({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hTW9kZWwlMkMlMjBMbGFtYUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMTGFNQSUyMGxsYW1hLTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYW1hQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwbGxhbWEtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMExsYW1hTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaModel, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a LLaMA llama-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llama-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){p(d.$$.fragment)},l(c){u(d.$$.fragment,c)},m(c,v){h(d,c,v),k=!0},p:re,i(c){k||(f(d.$$.fragment,c),k=!0)},o(c){g(d.$$.fragment,c),k=!1},d(c){_(d,c)}}}function La(C){let d,k="sequence pair mask has the following format:",c,v,w;return v=new At({props:{code:"MCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAwJTIwMCUyMDAlMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMjAxJTIwMSUyMDElMEElN0MlMjBmaXJzdCUyMHNlcXVlbmNlJTIwJTIwJTIwJTIwJTdDJTIwc2Vjb25kJTIwc2VxdWVuY2UlMjAlN0M=",highlighted:`0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 0 </span>0<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1<span class="hljs-number"> 1 </span>1 1
| first sequence    | second sequence |`,wrap:!1}}),{c(){d=i("p"),d.textContent=k,c=o(),p(v.$$.fragment)},l(b){d=l(b,"P",{"data-svelte-h":!0}),m(d)!=="svelte-16klr56"&&(d.textContent=k),c=a(b),u(v.$$.fragment,b)},m(b,L){r(b,d,L),r(b,c,L),h(v,b,L),w=!0},p:re,i(b){w||(f(v.$$.fragment,b),w=!0)},o(b){g(v.$$.fragment,b),w=!1},d(b){b&&(n(d),n(c)),_(v,b)}}}function $a(C){let d,k;return d=new At({props:{code:"JTBBJTVCMSUyQyUyMDE1MDQzJTJDJTIwNDQ1JTJDJTIwMzM4JTJDJTIwMjYzJTJDJTIwMTI0MyU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaTokenizerFast

tokenizer = LlamaTokenizerFast.from_pretrained(&quot;hf-internal-testing/llama-tokenizer&quot;)
tokenizer.encode(&quot;Hello this is a test&quot;)
&gt;&gt;&gt; [<span class="hljs-number">1</span>, <span class="hljs-number">15043</span>, <span class="hljs-number">445</span>, <span class="hljs-number">338</span>, <span class="hljs-number">263</span>, <span class="hljs-number">1243</span>]`,wrap:!1}}),{c(){p(d.$$.fragment)},l(c){u(d.$$.fragment,c)},m(c,v){h(d,c,v),k=!0},p:re,i(c){k||(f(d.$$.fragment,c),k=!0)},o(c){g(d.$$.fragment,c),k=!1},d(c){_(d,c)}}}function wa(C){let d,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=k},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=k)},m(c,v){r(c,d,v)},p:re,d(c){c&&n(d)}}}function Ma(C){let d,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=k},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=k)},m(c,v){r(c,d,v)},p:re,d(c){c&&n(d)}}}function xa(C){let d,k="Example:",c,v,w;return v=new At({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYUZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChQQVRIX1RPX0NPTlZFUlRFRF9XRUlHSFRTKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKFBBVEhfVE9fQ09OVkVSVEVEX1RPS0VOSVpFUiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, LlamaForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlamaForCausalLM.from_pretrained(PATH_TO_CONVERTED_WEIGHTS)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(PATH_TO_CONVERTED_TOKENIZER)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){d=i("p"),d.textContent=k,c=o(),p(v.$$.fragment)},l(b){d=l(b,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=k),c=a(b),u(v.$$.fragment,b)},m(b,L){r(b,d,L),r(b,c,L),h(v,b,L),w=!0},p:re,i(b){w||(f(v.$$.fragment,b),w=!0)},o(b){g(v.$$.fragment,b),w=!1},d(b){b&&(n(d),n(c)),_(v,b)}}}function za(C){let d,k=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=k},l(c){d=l(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=k)},m(c,v){r(c,d,v)},p:re,d(c){c&&n(d)}}}function Ca(C){let d,k,c,v,w,b,L,ie,$,B='The Llama2 model was proposed in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">LLaMA: Open Foundation and Fine-Tuned Chat Models</a> by Hugo Touvron, Louis Martin, Kevin Stone, Peter Albert, Amjad Almahairi, Yasmine Babaei, Nikolay Bashlykov, Soumya Batra, Prajjwal Bhargava, Shruti Bhosale, Dan Bikel, Lukas Blecher, Cristian Canton Ferrer, Moya Chen, Guillem Cucurull, David Esiobu, Jude Fernandes, Jeremy Fu, Wenyin Fu, Brian Fuller, Cynthia Gao, Vedanuj Goswami, Naman Goyal, Anthony Hartshorn, Saghar Hosseini, Rui Hou, Hakan Inan, Marcin Kardas, Viktor Kerkez Madian Khabsa, Isabel Kloumann, Artem Korenev, Punit Singh Koura, Marie-Anne Lachaux, Thibaut Lavril, Jenya Lee, Diana Liskovich, Yinghai Lu, Yuning Mao, Xavier Martinet, Todor Mihaylov, Pushka rMishra, Igor Molybog, Yixin Nie, Andrew Poulton, Jeremy Reizenstein, Rashi Rungta, Kalyan Saladi, Alan Schelten, Ruan Silva, Eric Michael Smith, Ranjan Subramanian, Xiaoqing EllenTan, Binh Tang, Ross Taylor, Adina Williams, Jian Xiang Kuan, Puxin Xu, Zheng Yan, Iliyan Zarov, Yuchen Zhang, Angela Fan, Melanie Kambadur, Sharan Narang, Aurelien Rodriguez, Robert Stojnic, Sergey Edunov, Thomas Scialom. It is a collection of foundation language models ranging from 7B to 70B parameters, with checkpoints finetuned for chat application!',Wt,le,Lo="The abstract from the paper is the following:",Nt,de,$o="<em>In this work, we develop and release Llama 2, a collection of pretrained and fine-tuned large language models (LLMs) ranging in scale from 7 billion to 70 billion parameters. Our fine-tuned LLMs, called Llama 2-Chat, are optimized for dialogue use cases. Our models outperform open-source chat models on most benchmarks we tested, and based on our human evaluations for helpfulness and safety, may be a suitable substitute for closed-source models. We provide a detailed description of our approach to fine-tuning and safety improvements of Llama 2-Chat in order to enable the community to build on our work and contribute to the responsible development of LLMs.</em>",Dt,ce,wo='Checkout all Llama2 models <a href="https://huggingface.co/models?search=llama2" rel="nofollow">here</a>',Jt,G,Rt,me,Mo="Tips:",Vt,pe,xo='<li>Weights for the Llama2 models can be obtained by filling out <a href="https://ai.meta.com/resources/models-and-libraries/llama-downloads/" rel="nofollow">this form</a></li> <li>The architecture is very similar to the first Llama, with the addition of Grouped Query Attention (GQA) following this <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">paper</a></li> <li>Setting <code>config.pretraining_tp</code> to a value different than 1 will activate the more accurate but slower computation of the linear layers, which should better match the original logits.</li> <li>The original model uses <code>pad_id = -1</code> which means that there is no padding token. We can’t have the same logic, make sure to add a padding token using <code>tokenizer.add_special_tokens({&quot;pad_token&quot;:&quot;&lt;pad&gt;&quot;})</code> and resize the token embedding accordingly. You should also set the <code>model.config.pad_token_id</code>. The <code>embed_tokens</code> layer of the model is initialized with <code>self.embed_tokens = nn.Embedding(config.vocab_size, config.hidden_size, self.config.padding_idx)</code>, which makes sure that encoding the padding token will output zeros, so passing it when initializing is recommended.</li> <li>After filling out the form and gaining access to the model checkpoints, you should be able to use the already converted checkpoints. Otherwise, if you are converting your own model, feel free to use the <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/convert_llama_weights_to_hf.py" rel="nofollow">conversion script</a>. The script can be called with the following (example) command:</li>',Bt,ue,Gt,he,zo="<li>After conversion, the model and tokenizer can be loaded via:</li>",Zt,fe,Ot,ge,Co=`Note that executing the script requires enough CPU RAM to host the whole model in float16 precision (even if the biggest versions
come in several checkpoints they each contain a part of each weight of the model, so we need to load them all in RAM). For the 75B model, it’s thus 145GB of RAM needed.`,Xt,_e,Fo='<li>The LLaMA tokenizer is a BPE model based on <a href="https://github.com/google/sentencepiece" rel="nofollow">sentencepiece</a>. One quirk of sentencepiece is that when decoding a sequence, if the first token is the start of the word (e.g. “Banana”), the tokenizer does not prepend the prefix space to the string.</li>',Qt,be,qo='This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">Arthur Zucker</a> with contributions from <a href="https://huggingface.co/lysandre" rel="nofollow">Lysandre Debut</a>. The code of the implementation in Hugging Face is based on GPT-NeoX <a href="https://github.com/EleutherAI/gpt-neox" rel="nofollow">here</a>. The original code of the authors can be found <a href="https://github.com/facebookresearch/llama" rel="nofollow">here</a>.',Yt,ve,Kt,ke,Po="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with LLaMA2. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",en,ye,Io='<li><a href="https://huggingface.co/blog/llama2" rel="nofollow">Llama 2 is here - get it on Hugging Face</a>, a blog post about Llama 2 and how to use it with 🤗 Transformers and 🤗 PEFT.</li> <li><a href="https://www.philschmid.de/llama-2" rel="nofollow">LLaMA 2 - Every Resource you need</a>, a compilation of relevant resources to learn about LLaMA 2 and how to get started quickly.</li>',tn,Te,nn,Le,jo='<li>A <a href="https://colab.research.google.com/drive/1PEQyJO1-f6j0S_XJ8DV50NkpzasXkrzd?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune Llama 2 in Google Colab using QLoRA and 4-bit precision. 🌎</li> <li>A <a href="https://colab.research.google.com/drive/134o_cXcMe_lsvl15ZE_4Y75Kstepsntu?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune the “Llama-v2-7b-guanaco” model with 4-bit QLoRA and generate Q&amp;A datasets from PDFs. 🌎</li>',on,$e,an,we,Ho='<li>A <a href="https://colab.research.google.com/drive/1ggaa2oRFphdBmqIjSEbnb_HGkcIRC2ZB?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune the Llama 2 model with QLoRa, TRL, and Korean text classification dataset. 🌎🇰🇷</li>',sn,Me,Ao="⚗️ Optimization",rn,xe,Uo='<li><a href="https://huggingface.co/blog/dpo-trl" rel="nofollow">Fine-tune Llama 2 with DPO</a>, a guide to using the TRL library’s DPO method to fine tune Llama 2 on a specific dataset.</li> <li><a href="https://www.philschmid.de/instruction-tune-llama-2" rel="nofollow">Extended Guide: Instruction-tune Llama 2</a>, a guide to training Llama 2 to generate instructions from inputs, transforming the model from instruction-following to instruction-giving.</li> <li>A <a href="https://colab.research.google.com/drive/1SYpgFpcmtIUzdE7pxqknrM4ArCASfkFQ?usp=sharing" rel="nofollow">notebook</a> on how to fine-tune the Llama 2 model on a personal computer using QLoRa and TRL. 🌎</li>',ln,ze,Eo="⚡️ Inference",dn,Ce,So='<li>A <a href="https://colab.research.google.com/drive/1TC56ArKerXUpbgRy5vM3woRsbTEVNq7h?usp=sharing" rel="nofollow">notebook</a> on how to quantize the Llama 2 model using GPTQ from the AutoGPTQ library. 🌎</li> <li>A <a href="https://colab.research.google.com/drive/1X1z9Q6domMKl2CnEM0QGHNwidLfR4dW2?usp=sharing" rel="nofollow">notebook</a> on how to run the Llama 2 Chat Model with 4-bit quantization on a local computer or Google Colab. 🌎</li>',cn,Fe,Wo="🚀 Deploy",mn,qe,No='<li><a href="https://www.philschmid.de/sagemaker-llama2-qlora" rel="nofollow">Fine-tune LLaMA 2 (7-70B) on Amazon SageMaker</a>, a complete guide from setup to QLoRA fine-tuning and deployment on Amazon SageMaker.</li> <li><a href="https://www.philschmid.de/sagemaker-llama-llm" rel="nofollow">Deploy Llama 2 7B/13B/70B on Amazon SageMaker</a>, a guide on using Hugging Face’s LLM DLC container for secure and scalable deployment.</li>',pn,Pe,un,H,Ie,qn,at,Do=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.1/en/model_doc/llama2#transformers.LlamaModel">LlamaModel</a>. It is used to instantiate an LLaMA
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the LLaMA-7B.`,Pn,st,Jo=`Configuration objects inherit from <a href="/docs/transformers/v4.34.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,In,Z,hn,je,fn,q,He,jn,rt,Ro=`Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding. The default padding token is unset as there is
no padding token in the original model.`,Hn,it,Ae,An,O,Ue,Un,lt,Vo=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,En,A,Ee,Sn,dt,Bo="Creates a mask from the two sequences passed to be used in a sequence-pair classification task. An ALBERT",Wn,X,Nn,ct,Go="if token_ids_1 is None, only returns the first portion of the mask (0s).",Dn,Q,Se,Jn,mt,Zo="Save the vocabulary and special tokens file to a directory.",gn,We,_n,y,Ne,Rn,pt,Oo="Construct a Llama tokenizer. Based on byte-level Byte-Pair-Encoding.",Vn,ut,Xo="This uses notably ByteFallback and no normalization.",Bn,Y,Gn,ht,Qo=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Zn,ft,Yo=`This tokenizer inherits from <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,On,gt,De,Xn,K,Je,Qn,_t,Ko=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,Yn,W,Re,Kn,bt,ea=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,eo,vt,ta="Should be overridden in a subclass if the model has a special way of building those.",to,ee,Ve,no,kt,na="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",oo,yt,Be,bn,Ge,vn,P,Ze,ao,Tt,oa=`The bare LLaMA Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,so,Lt,aa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ro,$t,sa="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>LlamaDecoderLayer</code>",io,N,Oe,lo,wt,ra='The <a href="/docs/transformers/v4.34.1/en/model_doc/llama2#transformers.LlamaModel">LlamaModel</a> forward method, overrides the <code>__call__</code> special method.',co,te,kn,Xe,yn,R,Qe,mo,U,Ye,po,Mt,ia='The <a href="/docs/transformers/v4.34.1/en/model_doc/llama2#transformers.LlamaForCausalLM">LlamaForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',uo,ne,ho,oe,Tn,Ke,Ln,z,et,fo,xt,la="The LLaMa Model transformer with a sequence classification head on top (linear layer).",go,zt,da=`<a href="/docs/transformers/v4.34.1/en/model_doc/llama2#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,_o,Ct,ca=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,bo,Ft,ma=`This model inherits from <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vo,qt,pa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ko,D,tt,yo,Pt,ua='The <a href="/docs/transformers/v4.34.1/en/model_doc/llama2#transformers.LlamaForSequenceClassification">LlamaForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',To,ae,$n,Ut,wn;return w=new V({props:{title:"Llama2",local:"llama2",headingTag:"h1"}}),L=new V({props:{title:"Overview",local:"overview",headingTag:"h2"}}),G=new Cn({props:{warning:!0,$$slots:{default:[ya]},$$scope:{ctx:C}}}),ue=new At({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbGxhbWElMkZjb252ZXJ0X2xsYW1hX3dlaWdodHNfdG9faGYucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZsbGFtYSUyRndlaWdodHMlMjAtLW1vZGVsX3NpemUlMjA3QiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGg=",highlighted:`python src/transformers/models/llama/convert_llama_weights_to_hf.py \\
    --input_dir /path/to/downloaded/llama/weights --model_size 7B --output_dir /output/path`,wrap:!1}}),fe=new At({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hRm9yQ2F1c2FsTE0lMkMlMjBMbGFtYVRva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMExsYW1hVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZvdXRwdXQlMkZwYXRoJTIyKSUwQW1vZGVsJTIwJTNEJTIwTGxhbWFGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTJGb3V0cHV0JTJGcGF0aCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlamaForCausalLM, LlamaTokenizer

tokenizer = LlamaTokenizer.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)
model = LlamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;/output/path&quot;</span>)`,wrap:!1}}),ve=new V({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Te=new fa({props:{pipeline:"text-generation"}}),$e=new fa({props:{pipeline:"text-classification"}}),Pe=new V({props:{title:"LlamaConfig",local:"transformers.LlamaConfig",headingTag:"h2"}}),Ie=new F({props:{name:"class transformers.LlamaConfig",anchor:"transformers.LlamaConfig",parameters:[{name:"vocab_size",val:" = 32000"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = None"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 2048"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-06"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"pretraining_tp",val:" = 1"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"attention_bias",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
Vocabulary size of the LLaMA model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.34.1/en/model_doc/llama2#transformers.LlamaModel">LlamaModel</a>`,name:"vocab_size"},{anchor:"transformers.LlamaConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.LlamaConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.LlamaConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.LlamaConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.LlamaConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.LlamaConfig.pretraining_tp",description:`<strong>pretraining_tp</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1</code>) &#x2014;
Experimental feature. Tensor parallelism rank used during pretraining. Please refer to <a href="https://huggingface.co/docs/transformers/parallelism" rel="nofollow">this
document</a> to understand more about it. This value is
necessary to ensure exact reproducibility of the pretraining results. Please refer to <a href="https://github.com/pytorch/pytorch/issues/76232" rel="nofollow">this
issue</a>.`,name:"pretraining_tp"},{anchor:"transformers.LlamaConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.LlamaConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Llama 1 supports up to 2048 tokens,
Llama 2 up to 4096, CodeLlama up to 16384.`,name:"max_position_embeddings"},{anchor:"transformers.LlamaConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.LlamaConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.LlamaConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.LlamaConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.LlamaConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.LlamaConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be an float greater than 1. The expected format
is <code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/LocalLLaMA/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/LocalLLaMA/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This is an
experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.LlamaConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.</p>
<p>Example &#x2014;`,name:"attention_bias"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/configuration_llama.py#L31"}}),Z=new Fn({props:{anchor:"transformers.LlamaConfig.example",$$slots:{default:[Ta]},$$scope:{ctx:C}}}),je=new V({props:{title:"LlamaTokenizer",local:"transformers.LlamaTokenizer",headingTag:"h2"}}),He=new F({props:{name:"class transformers.LlamaTokenizer",anchor:"transformers.LlamaTokenizer",parameters:[{name:"vocab_file",val:""},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"pad_token",val:" = None"},{name:"sp_model_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"use_default_system_prompt",val:" = True"},{name:"spaces_between_special_tokens",val:" = False"},{name:"legacy",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.LlamaTokenizer.legacy",description:`<strong>legacy</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the <code>legacy</code> behavior of the tokenizer should be used. Legacy is before the merge of #24622
and #25224 which includes fixes to properly handle tokens that appear after special tokens. A simple
example:</p>
<ul>
<li><code>legacy=True</code>:</li>
</ul>`,name:"legacy"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/tokenization_llama.py#L66"}}),Ae=new F({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.LlamaTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/tokenization_llama.py#L296"}}),Ue=new F({props:{name:"get_special_tokens_mask",anchor:"transformers.LlamaTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.LlamaTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/tokenization_llama.py#L307",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ee=new F({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/tokenization_llama.py#L344",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#token-type-ids">token type IDs</a> according to the given sequence(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),X=new Fn({props:{anchor:"transformers.LlamaTokenizer.create_token_type_ids_from_sequences.example",$$slots:{default:[La]},$$scope:{ctx:C}}}),Se=new F({props:{name:"save_vocabulary",anchor:"transformers.LlamaTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:""},{name:"filename_prefix",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizer.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/tokenization_llama.py#L269",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),We=new V({props:{title:"LlamaTokenizerFast",local:"transformers.LlamaTokenizerFast",headingTag:"h2"}}),Ne=new F({props:{name:"class transformers.LlamaTokenizerFast",anchor:"transformers.LlamaTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<unk>'"},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a> file (generally has a .model extension) that
contains the vocabulary necessary to instantiate a tokenizer.`,name:"vocab_file"},{anchor:"transformers.LlamaTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.LlamaTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Wether to cleanup spaces after decoding, cleanup consists in removing potential artifacts like extra
spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.LlamaTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.LlamaTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.LlamaTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/tokenization_llama_fast.py#L57"}}),Y=new Fn({props:{anchor:"transformers.LlamaTokenizerFast.example",$$slots:{default:[$a]},$$scope:{ctx:C}}}),De=new F({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.LlamaTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/tokenization_llama_fast.py#L255"}}),Je=new F({props:{name:"get_special_tokens_mask",anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.LlamaTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/tokenization_utils_base.py#L3754",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),Re=new F({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.LlamaTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/tokenization_utils_base.py#L3289",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ve=new F({props:{name:"update_post_processor",anchor:"transformers.LlamaTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/tokenization_llama_fast.py#L142"}}),Be=new F({props:{name:"save_vocabulary",anchor:"transformers.LlamaTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/tokenization_llama_fast.py#L182"}}),Ge=new V({props:{title:"LlamaModel",local:"transformers.LlamaModel",headingTag:"h2"}}),Ze=new F({props:{name:"class transformers.LlamaModel",anchor:"transformers.LlamaModel",parameters:[{name:"config",val:": LlamaConfig"}],parametersDescription:[{anchor:"transformers.LlamaModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.1/en/model_doc/llama2#transformers.LlamaConfig">LlamaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; LlamaConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/modeling_llama.py#L776"}}),Oe=new F({props:{name:"forward",anchor:"transformers.LlamaModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.LlamaModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlamaModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/modeling_llama.py#L827"}}),te=new Cn({props:{$$slots:{default:[wa]},$$scope:{ctx:C}}}),Xe=new V({props:{title:"LlamaForCausalLM",local:"transformers.LlamaForCausalLM",headingTag:"h2"}}),Qe=new F({props:{name:"class transformers.LlamaForCausalLM",anchor:"transformers.LlamaForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/modeling_llama.py#L960"}}),Ye=new F({props:{name:"forward",anchor:"transformers.LlamaForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.LlamaForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlamaForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/modeling_llama.py#L990",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.1/en/model_doc/llama2#transformers.LlamaConfig"
>LlamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ne=new Cn({props:{$$slots:{default:[Ma]},$$scope:{ctx:C}}}),oe=new Fn({props:{anchor:"transformers.LlamaForCausalLM.forward.example",$$slots:{default:[xa]},$$scope:{ctx:C}}}),Ke=new V({props:{title:"LlamaForSequenceClassification",local:"transformers.LlamaForSequenceClassification",headingTag:"h2"}}),et=new F({props:{name:"class transformers.LlamaForSequenceClassification",anchor:"transformers.LlamaForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.LlamaForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.1/en/model_doc/llama2#transformers.LlamaConfig">LlamaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/modeling_llama.py#L1139"}}),tt=new F({props:{name:"forward",anchor:"transformers.LlamaForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.LlamaForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlamaForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.34.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.34.1/en/model_doc/vits#transformers.VitsTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlamaForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlamaForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlamaForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlamaForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlamaForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlamaForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlamaForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlamaForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/llama/modeling_llama.py#L1155"}}),ae=new Cn({props:{$$slots:{default:[za]},$$scope:{ctx:C}}}),{c(){d=i("meta"),k=o(),c=i("p"),v=o(),p(w.$$.fragment),b=o(),p(L.$$.fragment),ie=o(),$=i("p"),$.innerHTML=B,Wt=o(),le=i("p"),le.textContent=Lo,Nt=o(),de=i("p"),de.innerHTML=$o,Dt=o(),ce=i("p"),ce.innerHTML=wo,Jt=o(),p(G.$$.fragment),Rt=o(),me=i("p"),me.textContent=Mo,Vt=o(),pe=i("ul"),pe.innerHTML=xo,Bt=o(),p(ue.$$.fragment),Gt=o(),he=i("ul"),he.innerHTML=zo,Zt=o(),p(fe.$$.fragment),Ot=o(),ge=i("p"),ge.textContent=Co,Xt=o(),_e=i("ul"),_e.innerHTML=Fo,Qt=o(),be=i("p"),be.innerHTML=qo,Yt=o(),p(ve.$$.fragment),Kt=o(),ke=i("p"),ke.textContent=Po,en=o(),ye=i("ul"),ye.innerHTML=Io,tn=o(),p(Te.$$.fragment),nn=o(),Le=i("ul"),Le.innerHTML=jo,on=o(),p($e.$$.fragment),an=o(),we=i("ul"),we.innerHTML=Ho,sn=o(),Me=i("p"),Me.textContent=Ao,rn=o(),xe=i("ul"),xe.innerHTML=Uo,ln=o(),ze=i("p"),ze.textContent=Eo,dn=o(),Ce=i("ul"),Ce.innerHTML=So,cn=o(),Fe=i("p"),Fe.textContent=Wo,mn=o(),qe=i("ul"),qe.innerHTML=No,pn=o(),p(Pe.$$.fragment),un=o(),H=i("div"),p(Ie.$$.fragment),qn=o(),at=i("p"),at.innerHTML=Do,Pn=o(),st=i("p"),st.innerHTML=Jo,In=o(),p(Z.$$.fragment),hn=o(),p(je.$$.fragment),fn=o(),q=i("div"),p(He.$$.fragment),jn=o(),rt=i("p"),rt.textContent=Ro,Hn=o(),it=i("div"),p(Ae.$$.fragment),An=o(),O=i("div"),p(Ue.$$.fragment),Un=o(),lt=i("p"),lt.innerHTML=Vo,En=o(),A=i("div"),p(Ee.$$.fragment),Sn=o(),dt=i("p"),dt.textContent=Bo,Wn=o(),p(X.$$.fragment),Nn=o(),ct=i("p"),ct.textContent=Go,Dn=o(),Q=i("div"),p(Se.$$.fragment),Jn=o(),mt=i("p"),mt.textContent=Zo,gn=o(),p(We.$$.fragment),_n=o(),y=i("div"),p(Ne.$$.fragment),Rn=o(),pt=i("p"),pt.textContent=Oo,Vn=o(),ut=i("p"),ut.textContent=Xo,Bn=o(),p(Y.$$.fragment),Gn=o(),ht=i("p"),ht.innerHTML=Qo,Zn=o(),ft=i("p"),ft.innerHTML=Yo,On=o(),gt=i("div"),p(De.$$.fragment),Xn=o(),K=i("div"),p(Je.$$.fragment),Qn=o(),_t=i("p"),_t.innerHTML=Ko,Yn=o(),W=i("div"),p(Re.$$.fragment),Kn=o(),bt=i("p"),bt.innerHTML=ea,eo=o(),vt=i("p"),vt.textContent=ta,to=o(),ee=i("div"),p(Ve.$$.fragment),no=o(),kt=i("p"),kt.innerHTML=na,oo=o(),yt=i("div"),p(Be.$$.fragment),bn=o(),p(Ge.$$.fragment),vn=o(),P=i("div"),p(Ze.$$.fragment),ao=o(),Tt=i("p"),Tt.innerHTML=oa,so=o(),Lt=i("p"),Lt.innerHTML=aa,ro=o(),$t=i("p"),$t.innerHTML=sa,io=o(),N=i("div"),p(Oe.$$.fragment),lo=o(),wt=i("p"),wt.innerHTML=ra,co=o(),p(te.$$.fragment),kn=o(),p(Xe.$$.fragment),yn=o(),R=i("div"),p(Qe.$$.fragment),mo=o(),U=i("div"),p(Ye.$$.fragment),po=o(),Mt=i("p"),Mt.innerHTML=ia,uo=o(),p(ne.$$.fragment),ho=o(),p(oe.$$.fragment),Tn=o(),p(Ke.$$.fragment),Ln=o(),z=i("div"),p(et.$$.fragment),fo=o(),xt=i("p"),xt.textContent=la,go=o(),zt=i("p"),zt.innerHTML=da,_o=o(),Ct=i("p"),Ct.innerHTML=ca,bo=o(),Ft=i("p"),Ft.innerHTML=ma,vo=o(),qt=i("p"),qt.innerHTML=pa,ko=o(),D=i("div"),p(tt.$$.fragment),yo=o(),Pt=i("p"),Pt.innerHTML=ua,To=o(),p(ae.$$.fragment),$n=o(),Ut=i("p"),this.h()},l(e){const t=ka("svelte-u9bgzb",document.head);d=l(t,"META",{name:!0,content:!0}),t.forEach(n),k=a(e),c=l(e,"P",{}),M(c).forEach(n),v=a(e),u(w.$$.fragment,e),b=a(e),u(L.$$.fragment,e),ie=a(e),$=l(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-xm2zag"&&($.innerHTML=B),Wt=a(e),le=l(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-vfdo9a"&&(le.textContent=Lo),Nt=a(e),de=l(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-1wo3ztj"&&(de.innerHTML=$o),Dt=a(e),ce=l(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-forh14"&&(ce.innerHTML=wo),Jt=a(e),u(G.$$.fragment,e),Rt=a(e),me=l(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-axv494"&&(me.textContent=Mo),Vt=a(e),pe=l(e,"UL",{"data-svelte-h":!0}),m(pe)!=="svelte-tepalw"&&(pe.innerHTML=xo),Bt=a(e),u(ue.$$.fragment,e),Gt=a(e),he=l(e,"UL",{"data-svelte-h":!0}),m(he)!=="svelte-yjbkch"&&(he.innerHTML=zo),Zt=a(e),u(fe.$$.fragment,e),Ot=a(e),ge=l(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-199e5ee"&&(ge.textContent=Co),Xt=a(e),_e=l(e,"UL",{"data-svelte-h":!0}),m(_e)!=="svelte-1xmggxn"&&(_e.innerHTML=Fo),Qt=a(e),be=l(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-x3p6lc"&&(be.innerHTML=qo),Yt=a(e),u(ve.$$.fragment,e),Kt=a(e),ke=l(e,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-1l10g8k"&&(ke.textContent=Po),en=a(e),ye=l(e,"UL",{"data-svelte-h":!0}),m(ye)!=="svelte-189jef5"&&(ye.innerHTML=Io),tn=a(e),u(Te.$$.fragment,e),nn=a(e),Le=l(e,"UL",{"data-svelte-h":!0}),m(Le)!=="svelte-1txpvb1"&&(Le.innerHTML=jo),on=a(e),u($e.$$.fragment,e),an=a(e),we=l(e,"UL",{"data-svelte-h":!0}),m(we)!=="svelte-13c8j1g"&&(we.innerHTML=Ho),sn=a(e),Me=l(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-liq2q7"&&(Me.textContent=Ao),rn=a(e),xe=l(e,"UL",{"data-svelte-h":!0}),m(xe)!=="svelte-1xuj4g0"&&(xe.innerHTML=Uo),ln=a(e),ze=l(e,"P",{"data-svelte-h":!0}),m(ze)!=="svelte-1wntqpp"&&(ze.textContent=Eo),dn=a(e),Ce=l(e,"UL",{"data-svelte-h":!0}),m(Ce)!=="svelte-gxsehz"&&(Ce.innerHTML=So),cn=a(e),Fe=l(e,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-lk14e4"&&(Fe.textContent=Wo),mn=a(e),qe=l(e,"UL",{"data-svelte-h":!0}),m(qe)!=="svelte-1f88qgk"&&(qe.innerHTML=No),pn=a(e),u(Pe.$$.fragment,e),un=a(e),H=l(e,"DIV",{class:!0});var E=M(H);u(Ie.$$.fragment,E),qn=a(E),at=l(E,"P",{"data-svelte-h":!0}),m(at)!=="svelte-1kvpar5"&&(at.innerHTML=Do),Pn=a(E),st=l(E,"P",{"data-svelte-h":!0}),m(st)!=="svelte-1onjy9f"&&(st.innerHTML=Jo),In=a(E),u(Z.$$.fragment,E),E.forEach(n),hn=a(e),u(je.$$.fragment,e),fn=a(e),q=l(e,"DIV",{class:!0});var I=M(q);u(He.$$.fragment,I),jn=a(I),rt=l(I,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-qfiu5a"&&(rt.textContent=Ro),Hn=a(I),it=l(I,"DIV",{class:!0});var Et=M(it);u(Ae.$$.fragment,Et),Et.forEach(n),An=a(I),O=l(I,"DIV",{class:!0});var nt=M(O);u(Ue.$$.fragment,nt),Un=a(nt),lt=l(nt,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-1f4f5kp"&&(lt.innerHTML=Vo),nt.forEach(n),En=a(I),A=l(I,"DIV",{class:!0});var S=M(A);u(Ee.$$.fragment,S),Sn=a(S),dt=l(S,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-13bfd60"&&(dt.textContent=Bo),Wn=a(S),u(X.$$.fragment,S),Nn=a(S),ct=l(S,"P",{"data-svelte-h":!0}),m(ct)!=="svelte-wtrslu"&&(ct.textContent=Go),S.forEach(n),Dn=a(I),Q=l(I,"DIV",{class:!0});var ot=M(Q);u(Se.$$.fragment,ot),Jn=a(ot),mt=l(ot,"P",{"data-svelte-h":!0}),m(mt)!=="svelte-1slb66l"&&(mt.textContent=Zo),ot.forEach(n),I.forEach(n),gn=a(e),u(We.$$.fragment,e),_n=a(e),y=l(e,"DIV",{class:!0});var T=M(y);u(Ne.$$.fragment,T),Rn=a(T),pt=l(T,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-15tdcz8"&&(pt.textContent=Oo),Vn=a(T),ut=l(T,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-llhmpa"&&(ut.textContent=Xo),Bn=a(T),u(Y.$$.fragment,T),Gn=a(T),ht=l(T,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-cnb6q1"&&(ht.innerHTML=Qo),Zn=a(T),ft=l(T,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-1x2gtl7"&&(ft.innerHTML=Yo),On=a(T),gt=l(T,"DIV",{class:!0});var St=M(gt);u(De.$$.fragment,St),St.forEach(n),Xn=a(T),K=l(T,"DIV",{class:!0});var Mn=M(K);u(Je.$$.fragment,Mn),Qn=a(Mn),_t=l(Mn,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-1wmjg8a"&&(_t.innerHTML=Ko),Mn.forEach(n),Yn=a(T),W=l(T,"DIV",{class:!0});var It=M(W);u(Re.$$.fragment,It),Kn=a(It),bt=l(It,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-zj1vf1"&&(bt.innerHTML=ea),eo=a(It),vt=l(It,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-9vptpw"&&(vt.textContent=ta),It.forEach(n),to=a(T),ee=l(T,"DIV",{class:!0});var xn=M(ee);u(Ve.$$.fragment,xn),no=a(xn),kt=l(xn,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-nfci2w"&&(kt.innerHTML=na),xn.forEach(n),oo=a(T),yt=l(T,"DIV",{class:!0});var ha=M(yt);u(Be.$$.fragment,ha),ha.forEach(n),T.forEach(n),bn=a(e),u(Ge.$$.fragment,e),vn=a(e),P=l(e,"DIV",{class:!0});var J=M(P);u(Ze.$$.fragment,J),ao=a(J),Tt=l(J,"P",{"data-svelte-h":!0}),m(Tt)!=="svelte-1us8u5y"&&(Tt.innerHTML=oa),so=a(J),Lt=l(J,"P",{"data-svelte-h":!0}),m(Lt)!=="svelte-hswkmf"&&(Lt.innerHTML=aa),ro=a(J),$t=l(J,"P",{"data-svelte-h":!0}),m($t)!=="svelte-eom0yk"&&($t.innerHTML=sa),io=a(J),N=l(J,"DIV",{class:!0});var jt=M(N);u(Oe.$$.fragment,jt),lo=a(jt),wt=l(jt,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-15lqhib"&&(wt.innerHTML=ra),co=a(jt),u(te.$$.fragment,jt),jt.forEach(n),J.forEach(n),kn=a(e),u(Xe.$$.fragment,e),yn=a(e),R=l(e,"DIV",{class:!0});var zn=M(R);u(Qe.$$.fragment,zn),mo=a(zn),U=l(zn,"DIV",{class:!0});var se=M(U);u(Ye.$$.fragment,se),po=a(se),Mt=l(se,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-7s14g3"&&(Mt.innerHTML=ia),uo=a(se),u(ne.$$.fragment,se),ho=a(se),u(oe.$$.fragment,se),se.forEach(n),zn.forEach(n),Tn=a(e),u(Ke.$$.fragment,e),Ln=a(e),z=l(e,"DIV",{class:!0});var j=M(z);u(et.$$.fragment,j),fo=a(j),xt=l(j,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-62must"&&(xt.textContent=la),go=a(j),zt=l(j,"P",{"data-svelte-h":!0}),m(zt)!=="svelte-1qrxkd4"&&(zt.innerHTML=da),_o=a(j),Ct=l(j,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-10ugs3m"&&(Ct.innerHTML=ca),bo=a(j),Ft=l(j,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-l15rv1"&&(Ft.innerHTML=ma),vo=a(j),qt=l(j,"P",{"data-svelte-h":!0}),m(qt)!=="svelte-hswkmf"&&(qt.innerHTML=pa),ko=a(j),D=l(j,"DIV",{class:!0});var Ht=M(D);u(tt.$$.fragment,Ht),yo=a(Ht),Pt=l(Ht,"P",{"data-svelte-h":!0}),m(Pt)!=="svelte-13g60vl"&&(Pt.innerHTML=ua),To=a(Ht),u(ae.$$.fragment,Ht),Ht.forEach(n),j.forEach(n),$n=a(e),Ut=l(e,"P",{}),M(Ut).forEach(n),this.h()},h(){x(d,"name","hf:doc:metadata"),x(d,"content",Fa),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(it,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(gt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,d),r(e,k,t),r(e,c,t),r(e,v,t),h(w,e,t),r(e,b,t),h(L,e,t),r(e,ie,t),r(e,$,t),r(e,Wt,t),r(e,le,t),r(e,Nt,t),r(e,de,t),r(e,Dt,t),r(e,ce,t),r(e,Jt,t),h(G,e,t),r(e,Rt,t),r(e,me,t),r(e,Vt,t),r(e,pe,t),r(e,Bt,t),h(ue,e,t),r(e,Gt,t),r(e,he,t),r(e,Zt,t),h(fe,e,t),r(e,Ot,t),r(e,ge,t),r(e,Xt,t),r(e,_e,t),r(e,Qt,t),r(e,be,t),r(e,Yt,t),h(ve,e,t),r(e,Kt,t),r(e,ke,t),r(e,en,t),r(e,ye,t),r(e,tn,t),h(Te,e,t),r(e,nn,t),r(e,Le,t),r(e,on,t),h($e,e,t),r(e,an,t),r(e,we,t),r(e,sn,t),r(e,Me,t),r(e,rn,t),r(e,xe,t),r(e,ln,t),r(e,ze,t),r(e,dn,t),r(e,Ce,t),r(e,cn,t),r(e,Fe,t),r(e,mn,t),r(e,qe,t),r(e,pn,t),h(Pe,e,t),r(e,un,t),r(e,H,t),h(Ie,H,null),s(H,qn),s(H,at),s(H,Pn),s(H,st),s(H,In),h(Z,H,null),r(e,hn,t),h(je,e,t),r(e,fn,t),r(e,q,t),h(He,q,null),s(q,jn),s(q,rt),s(q,Hn),s(q,it),h(Ae,it,null),s(q,An),s(q,O),h(Ue,O,null),s(O,Un),s(O,lt),s(q,En),s(q,A),h(Ee,A,null),s(A,Sn),s(A,dt),s(A,Wn),h(X,A,null),s(A,Nn),s(A,ct),s(q,Dn),s(q,Q),h(Se,Q,null),s(Q,Jn),s(Q,mt),r(e,gn,t),h(We,e,t),r(e,_n,t),r(e,y,t),h(Ne,y,null),s(y,Rn),s(y,pt),s(y,Vn),s(y,ut),s(y,Bn),h(Y,y,null),s(y,Gn),s(y,ht),s(y,Zn),s(y,ft),s(y,On),s(y,gt),h(De,gt,null),s(y,Xn),s(y,K),h(Je,K,null),s(K,Qn),s(K,_t),s(y,Yn),s(y,W),h(Re,W,null),s(W,Kn),s(W,bt),s(W,eo),s(W,vt),s(y,to),s(y,ee),h(Ve,ee,null),s(ee,no),s(ee,kt),s(y,oo),s(y,yt),h(Be,yt,null),r(e,bn,t),h(Ge,e,t),r(e,vn,t),r(e,P,t),h(Ze,P,null),s(P,ao),s(P,Tt),s(P,so),s(P,Lt),s(P,ro),s(P,$t),s(P,io),s(P,N),h(Oe,N,null),s(N,lo),s(N,wt),s(N,co),h(te,N,null),r(e,kn,t),h(Xe,e,t),r(e,yn,t),r(e,R,t),h(Qe,R,null),s(R,mo),s(R,U),h(Ye,U,null),s(U,po),s(U,Mt),s(U,uo),h(ne,U,null),s(U,ho),h(oe,U,null),r(e,Tn,t),h(Ke,e,t),r(e,Ln,t),r(e,z,t),h(et,z,null),s(z,fo),s(z,xt),s(z,go),s(z,zt),s(z,_o),s(z,Ct),s(z,bo),s(z,Ft),s(z,vo),s(z,qt),s(z,ko),s(z,D),h(tt,D,null),s(D,yo),s(D,Pt),s(D,To),h(ae,D,null),r(e,$n,t),r(e,Ut,t),wn=!0},p(e,[t]){const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),G.$set(E);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),Z.$set(I);const Et={};t&2&&(Et.$$scope={dirty:t,ctx:e}),X.$set(Et);const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),Y.$set(nt);const S={};t&2&&(S.$$scope={dirty:t,ctx:e}),te.$set(S);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),ne.$set(ot);const T={};t&2&&(T.$$scope={dirty:t,ctx:e}),oe.$set(T);const St={};t&2&&(St.$$scope={dirty:t,ctx:e}),ae.$set(St)},i(e){wn||(f(w.$$.fragment,e),f(L.$$.fragment,e),f(G.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(ve.$$.fragment,e),f(Te.$$.fragment,e),f($e.$$.fragment,e),f(Pe.$$.fragment,e),f(Ie.$$.fragment,e),f(Z.$$.fragment,e),f(je.$$.fragment,e),f(He.$$.fragment,e),f(Ae.$$.fragment,e),f(Ue.$$.fragment,e),f(Ee.$$.fragment,e),f(X.$$.fragment,e),f(Se.$$.fragment,e),f(We.$$.fragment,e),f(Ne.$$.fragment,e),f(Y.$$.fragment,e),f(De.$$.fragment,e),f(Je.$$.fragment,e),f(Re.$$.fragment,e),f(Ve.$$.fragment,e),f(Be.$$.fragment,e),f(Ge.$$.fragment,e),f(Ze.$$.fragment,e),f(Oe.$$.fragment,e),f(te.$$.fragment,e),f(Xe.$$.fragment,e),f(Qe.$$.fragment,e),f(Ye.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(ae.$$.fragment,e),wn=!0)},o(e){g(w.$$.fragment,e),g(L.$$.fragment,e),g(G.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(ve.$$.fragment,e),g(Te.$$.fragment,e),g($e.$$.fragment,e),g(Pe.$$.fragment,e),g(Ie.$$.fragment,e),g(Z.$$.fragment,e),g(je.$$.fragment,e),g(He.$$.fragment,e),g(Ae.$$.fragment,e),g(Ue.$$.fragment,e),g(Ee.$$.fragment,e),g(X.$$.fragment,e),g(Se.$$.fragment,e),g(We.$$.fragment,e),g(Ne.$$.fragment,e),g(Y.$$.fragment,e),g(De.$$.fragment,e),g(Je.$$.fragment,e),g(Re.$$.fragment,e),g(Ve.$$.fragment,e),g(Be.$$.fragment,e),g(Ge.$$.fragment,e),g(Ze.$$.fragment,e),g(Oe.$$.fragment,e),g(te.$$.fragment,e),g(Xe.$$.fragment,e),g(Qe.$$.fragment,e),g(Ye.$$.fragment,e),g(ne.$$.fragment,e),g(oe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(ae.$$.fragment,e),wn=!1},d(e){e&&(n(k),n(c),n(v),n(b),n(ie),n($),n(Wt),n(le),n(Nt),n(de),n(Dt),n(ce),n(Jt),n(Rt),n(me),n(Vt),n(pe),n(Bt),n(Gt),n(he),n(Zt),n(Ot),n(ge),n(Xt),n(_e),n(Qt),n(be),n(Yt),n(Kt),n(ke),n(en),n(ye),n(tn),n(nn),n(Le),n(on),n(an),n(we),n(sn),n(Me),n(rn),n(xe),n(ln),n(ze),n(dn),n(Ce),n(cn),n(Fe),n(mn),n(qe),n(pn),n(un),n(H),n(hn),n(fn),n(q),n(gn),n(_n),n(y),n(bn),n(vn),n(P),n(kn),n(yn),n(R),n(Tn),n(Ln),n(z),n($n),n(Ut)),n(d),_(w,e),_(L,e),_(G,e),_(ue,e),_(fe,e),_(ve,e),_(Te,e),_($e,e),_(Pe,e),_(Ie),_(Z),_(je,e),_(He),_(Ae),_(Ue),_(Ee),_(X),_(Se),_(We,e),_(Ne),_(Y),_(De),_(Je),_(Re),_(Ve),_(Be),_(Ge,e),_(Ze),_(Oe),_(te),_(Xe,e),_(Qe),_(Ye),_(ne),_(oe),_(Ke,e),_(et),_(tt),_(ae)}}}const Fa='{"title":"Llama2","local":"llama2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"LlamaConfig","local":"transformers.LlamaConfig","sections":[],"depth":2},{"title":"LlamaTokenizer","local":"transformers.LlamaTokenizer","sections":[],"depth":2},{"title":"LlamaTokenizerFast","local":"transformers.LlamaTokenizerFast","sections":[],"depth":2},{"title":"LlamaModel","local":"transformers.LlamaModel","sections":[],"depth":2},{"title":"LlamaForCausalLM","local":"transformers.LlamaForCausalLM","sections":[],"depth":2},{"title":"LlamaForSequenceClassification","local":"transformers.LlamaForSequenceClassification","sections":[],"depth":2}],"depth":1}';function qa(C){return _a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wa extends ba{constructor(d){super(),va(this,d,qa,Ca,ga,{})}}export{Wa as component};
