import{s as Gt,n as _t,o as Rt}from"../chunks/scheduler.85c25b89.js";import{S as Qt,i as Vt,g as i,s as a,r as o,A as Xt,h as p,f as s,c as n,j as Wt,u as c,x as m,k as Et,y as At,a as l,v as r,d as h,t as M,w as f}from"../chunks/index.c9bcf812.js";import{C as X}from"../chunks/CodeBlock.94efc595.js";import{H as Y}from"../chunks/Heading.3c6e5b17.js";function Ht(ut){let d,z,A,F,g,S,w,Jt="<strong>EfficientNet</strong> is a convolutional neural network architecture and scaling method that uniformly scales all dimensions of depth/width/resolution using a <em>compound coefficient</em>. Unlike conventional practice that arbitrary scales  these factors, the EfficientNet scaling method uniformly scales network width, depth, and resolution with a set of fixed scaling coefficients. For example, if we want to use $2^N$ times more computational resources, then we can simply increase the network depth by $\\alpha ^ N$,  width by $\\beta ^ N$, and image size by $\\gamma ^ N$, where $\\alpha, \\beta, \\gamma$ are constant coefficients determined by a small grid search on the original small model. EfficientNet uses a compound coefficient $\\phi$ to uniformly scales network width, depth, and resolution in a  principled way.",L,j,Tt="The compound scaling method is justified by the intuition that if the input image is bigger, then the network needs more layers to increase the receptive field and more channels to capture more fine-grained patterns on the bigger image.",P,u,yt='The base EfficientNet-B0 network is based on the inverted bottleneck residual blocks of <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>.',q,J,bt='EfficientNet-Lite makes EfficientNet more suitable for mobile devices by introducing <a href="https://paperswithcode.com/method/relu6" rel="nofollow">ReLU6</a> activation functions and removing <a href="https://paperswithcode.com/method/squeeze-and-excitation" rel="nofollow">squeeze-and-excitation blocks</a>.',D,T,$t='The weights from this model were ported from <a href="https://github.com/tensorflow/tpu" rel="nofollow">Tensorflow/TPU</a>.',K,y,O,b,Ut="To load a pretrained model:",tt,$,et,U,It="To load and preprocess the image:",st,I,lt,Z,Zt="To get the model predictions:",at,k,nt,x,kt="To get the top-5 predictions class names:",it,N,pt,C,xt="Replace the model name with the variant you want to use, e.g. <code>tf_efficientnet_lite0</code>. You can find the IDs in the model summaries at the top of this page.",mt,v,Nt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ot,B,ct,W,Ct="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",rt,E,ht,G,vt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Mt,_,ft,R,Bt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',dt,Q,gt,V,wt,H,jt;return g=new Y({props:{title:"(Tensorflow) EfficientNet Lite",local:"tensorflow-efficientnet-lite",headingTag:"h1"}}),y=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),$=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RmX2VmZmljaWVudG5ldF9saXRlMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_lite0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),I=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),k=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),N=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),B=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),E=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndGZfZWZmaWNpZW50bmV0X2xpdGUwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tf_efficientnet_lite0&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),_=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new X({props:{code:"JTQwbWlzYyU3QnRhbjIwMjBlZmZpY2llbnRuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkVmZmljaWVudE5ldCUzQSUyMFJldGhpbmtpbmclMjBNb2RlbCUyMFNjYWxpbmclMjBmb3IlMjBDb252b2x1dGlvbmFsJTIwTmV1cmFsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA1LjExOTQ2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuTEclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{tan2020efficientnet,
      title={EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Mingxing Tan and Quoc V. Le}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1905.11946}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.LG}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){d=i("meta"),z=a(),A=i("p"),F=a(),o(g.$$.fragment),S=a(),w=i("p"),w.innerHTML=Jt,L=a(),j=i("p"),j.textContent=Tt,P=a(),u=i("p"),u.innerHTML=yt,q=a(),J=i("p"),J.innerHTML=bt,D=a(),T=i("p"),T.innerHTML=$t,K=a(),o(y.$$.fragment),O=a(),b=i("p"),b.textContent=Ut,tt=a(),o($.$$.fragment),et=a(),U=i("p"),U.textContent=It,st=a(),o(I.$$.fragment),lt=a(),Z=i("p"),Z.textContent=Zt,at=a(),o(k.$$.fragment),nt=a(),x=i("p"),x.textContent=kt,it=a(),o(N.$$.fragment),pt=a(),C=i("p"),C.innerHTML=xt,mt=a(),v=i("p"),v.innerHTML=Nt,ot=a(),o(B.$$.fragment),ct=a(),W=i("p"),W.textContent=Ct,rt=a(),o(E.$$.fragment),ht=a(),G=i("p"),G.innerHTML=vt,Mt=a(),o(_.$$.fragment),ft=a(),R=i("p"),R.innerHTML=Bt,dt=a(),o(Q.$$.fragment),gt=a(),o(V.$$.fragment),wt=a(),H=i("p"),this.h()},l(t){const e=Xt("svelte-u9bgzb",document.head);d=p(e,"META",{name:!0,content:!0}),e.forEach(s),z=n(t),A=p(t,"P",{}),Wt(A).forEach(s),F=n(t),c(g.$$.fragment,t),S=n(t),w=p(t,"P",{"data-svelte-h":!0}),m(w)!=="svelte-1bwkfja"&&(w.innerHTML=Jt),L=n(t),j=p(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-5z334a"&&(j.textContent=Tt),P=n(t),u=p(t,"P",{"data-svelte-h":!0}),m(u)!=="svelte-1ctfbzq"&&(u.innerHTML=yt),q=n(t),J=p(t,"P",{"data-svelte-h":!0}),m(J)!=="svelte-1iy4wlm"&&(J.innerHTML=bt),D=n(t),T=p(t,"P",{"data-svelte-h":!0}),m(T)!=="svelte-k8hpf1"&&(T.innerHTML=$t),K=n(t),c(y.$$.fragment,t),O=n(t),b=p(t,"P",{"data-svelte-h":!0}),m(b)!=="svelte-18ywhxh"&&(b.textContent=Ut),tt=n(t),c($.$$.fragment,t),et=n(t),U=p(t,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1c2ipa8"&&(U.textContent=It),st=n(t),c(I.$$.fragment,t),lt=n(t),Z=p(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1n9qsq1"&&(Z.textContent=Zt),at=n(t),c(k.$$.fragment,t),nt=n(t),x=p(t,"P",{"data-svelte-h":!0}),m(x)!=="svelte-19cnvx1"&&(x.textContent=kt),it=n(t),c(N.$$.fragment,t),pt=n(t),C=p(t,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1w44yho"&&(C.innerHTML=xt),mt=n(t),v=p(t,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1wmi3ea"&&(v.innerHTML=Nt),ot=n(t),c(B.$$.fragment,t),ct=n(t),W=p(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-9sr7nh"&&(W.textContent=Ct),rt=n(t),c(E.$$.fragment,t),ht=n(t),G=p(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1kguc51"&&(G.innerHTML=vt),Mt=n(t),c(_.$$.fragment,t),ft=n(t),R=p(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1n0coha"&&(R.innerHTML=Bt),dt=n(t),c(Q.$$.fragment,t),gt=n(t),c(V.$$.fragment,t),wt=n(t),H=p(t,"P",{}),Wt(H).forEach(s),this.h()},h(){Et(d,"name","hf:doc:metadata"),Et(d,"content",Yt)},m(t,e){At(document.head,d),l(t,z,e),l(t,A,e),l(t,F,e),r(g,t,e),l(t,S,e),l(t,w,e),l(t,L,e),l(t,j,e),l(t,P,e),l(t,u,e),l(t,q,e),l(t,J,e),l(t,D,e),l(t,T,e),l(t,K,e),r(y,t,e),l(t,O,e),l(t,b,e),l(t,tt,e),r($,t,e),l(t,et,e),l(t,U,e),l(t,st,e),r(I,t,e),l(t,lt,e),l(t,Z,e),l(t,at,e),r(k,t,e),l(t,nt,e),l(t,x,e),l(t,it,e),r(N,t,e),l(t,pt,e),l(t,C,e),l(t,mt,e),l(t,v,e),l(t,ot,e),r(B,t,e),l(t,ct,e),l(t,W,e),l(t,rt,e),r(E,t,e),l(t,ht,e),l(t,G,e),l(t,Mt,e),r(_,t,e),l(t,ft,e),l(t,R,e),l(t,dt,e),r(Q,t,e),l(t,gt,e),r(V,t,e),l(t,wt,e),l(t,H,e),jt=!0},p:_t,i(t){jt||(h(g.$$.fragment,t),h(y.$$.fragment,t),h($.$$.fragment,t),h(I.$$.fragment,t),h(k.$$.fragment,t),h(N.$$.fragment,t),h(B.$$.fragment,t),h(E.$$.fragment,t),h(_.$$.fragment,t),h(Q.$$.fragment,t),h(V.$$.fragment,t),jt=!0)},o(t){M(g.$$.fragment,t),M(y.$$.fragment,t),M($.$$.fragment,t),M(I.$$.fragment,t),M(k.$$.fragment,t),M(N.$$.fragment,t),M(B.$$.fragment,t),M(E.$$.fragment,t),M(_.$$.fragment,t),M(Q.$$.fragment,t),M(V.$$.fragment,t),jt=!1},d(t){t&&(s(z),s(A),s(F),s(S),s(w),s(L),s(j),s(P),s(u),s(q),s(J),s(D),s(T),s(K),s(O),s(b),s(tt),s(et),s(U),s(st),s(lt),s(Z),s(at),s(nt),s(x),s(it),s(pt),s(C),s(mt),s(v),s(ot),s(ct),s(W),s(rt),s(ht),s(G),s(Mt),s(ft),s(R),s(dt),s(gt),s(wt),s(H)),s(d),f(g,t),f(y,t),f($,t),f(I,t),f(k,t),f(N,t),f(B,t),f(E,t),f(_,t),f(Q,t),f(V,t)}}}const Yt='{"title":"(Tensorflow) EfficientNet Lite","local":"tensorflow-efficientnet-lite","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function zt(ut){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends Qt{constructor(d){super(),Vt(this,d,zt,Ht,Gt,{})}}export{qt as component};
