import{s as Ut,n as It,o as $t}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as xt,g as p,s as a,r as m,A as Wt,h as i,f as e,c as n,j as ft,u as o,x as g,k as bt,y as kt,a as l,v as r,d as c,t as h,w as M}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as R}from"../chunks/Heading.3097d2ed.js";function Ct(ct){let J,_,V,Y,d,S,j,ht='<strong>SK ResNeXt</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a> that employs a <a href="https://paperswithcode.com/method/selective-kernel" rel="nofollow">Selective Kernel</a> unit. In general, all the large kernel convolutions in the original bottleneck blocks in ResNext are replaced by the proposed <a href="https://paperswithcode.com/method/selective-kernel-convolution" rel="nofollow">SK convolutions</a>, enabling the network to choose appropriate receptive field sizes in an adaptive manner.',A,w,z,y,Mt="To load a pretrained model:",H,T,F,u,gt="To load and preprocess the image:",L,f,D,b,Jt="To get the model predictions:",K,U,q,I,dt="To get the top-5 predictions class names:",P,$,O,Z,jt="Replace the model name with the variant you want to use, e.g. <code>skresnext50_32x4d</code>. You can find the IDs in the model summaries at the top of this page.",tt,x,wt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,W,et,k,yt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,C,at,N,Tt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,v,pt,B,ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',it,G,mt,E,ot,X,rt;return d=new R({props:{title:"SK-ResNeXt",local:"sk-resnext",headingTag:"h1"}}),w=new R({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NrcmVzbmV4dDUwXzMyeDRkJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnext50_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new R({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),C=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2tyZXNuZXh0NTBfMzJ4NGQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnext50_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),v=new R({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),G=new R({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new Q({props:{code:"JTQwbWlzYyU3QmxpMjAxOXNlbGVjdGl2ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCU2VsZWN0aXZlJTIwS2VybmVsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JYaWFuZyUyMExpJTIwYW5kJTIwV2VuaGFpJTIwV2FuZyUyMGFuZCUyMFhpYW9saW4lMjBIdSUyMGFuZCUyMEppYW4lMjBZYW5nJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTAzLjA2NTg2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{li2019selective,
      title={Selective Kernel Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Xiang Li and Wenhai Wang and Xiaolin Hu and Jian Yang}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1903.06586}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){J=p("meta"),_=a(),V=p("p"),Y=a(),m(d.$$.fragment),S=a(),j=p("p"),j.innerHTML=ht,A=a(),m(w.$$.fragment),z=a(),y=p("p"),y.textContent=Mt,H=a(),m(T.$$.fragment),F=a(),u=p("p"),u.textContent=gt,L=a(),m(f.$$.fragment),D=a(),b=p("p"),b.textContent=Jt,K=a(),m(U.$$.fragment),q=a(),I=p("p"),I.textContent=dt,P=a(),m($.$$.fragment),O=a(),Z=p("p"),Z.innerHTML=jt,tt=a(),x=p("p"),x.innerHTML=wt,st=a(),m(W.$$.fragment),et=a(),k=p("p"),k.textContent=yt,lt=a(),m(C.$$.fragment),at=a(),N=p("p"),N.innerHTML=Tt,nt=a(),m(v.$$.fragment),pt=a(),B=p("p"),B.innerHTML=ut,it=a(),m(G.$$.fragment),mt=a(),m(E.$$.fragment),ot=a(),X=p("p"),this.h()},l(t){const s=Wt("svelte-u9bgzb",document.head);J=i(s,"META",{name:!0,content:!0}),s.forEach(e),_=n(t),V=i(t,"P",{}),ft(V).forEach(e),Y=n(t),o(d.$$.fragment,t),S=n(t),j=i(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-1kqotlt"&&(j.innerHTML=ht),A=n(t),o(w.$$.fragment,t),z=n(t),y=i(t,"P",{"data-svelte-h":!0}),g(y)!=="svelte-18ywhxh"&&(y.textContent=Mt),H=n(t),o(T.$$.fragment,t),F=n(t),u=i(t,"P",{"data-svelte-h":!0}),g(u)!=="svelte-1c2ipa8"&&(u.textContent=gt),L=n(t),o(f.$$.fragment,t),D=n(t),b=i(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=Jt),K=n(t),o(U.$$.fragment,t),q=n(t),I=i(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-19cnvx1"&&(I.textContent=dt),P=n(t),o($.$$.fragment,t),O=n(t),Z=i(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-44hawi"&&(Z.innerHTML=jt),tt=n(t),x=i(t,"P",{"data-svelte-h":!0}),g(x)!=="svelte-1wmi3ea"&&(x.innerHTML=wt),st=n(t),o(W.$$.fragment,t),et=n(t),k=i(t,"P",{"data-svelte-h":!0}),g(k)!=="svelte-9sr7nh"&&(k.textContent=yt),lt=n(t),o(C.$$.fragment,t),at=n(t),N=i(t,"P",{"data-svelte-h":!0}),g(N)!=="svelte-1kguc51"&&(N.innerHTML=Tt),nt=n(t),o(v.$$.fragment,t),pt=n(t),B=i(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1n0coha"&&(B.innerHTML=ut),it=n(t),o(G.$$.fragment,t),mt=n(t),o(E.$$.fragment,t),ot=n(t),X=i(t,"P",{}),ft(X).forEach(e),this.h()},h(){bt(J,"name","hf:doc:metadata"),bt(J,"content",Nt)},m(t,s){kt(document.head,J),l(t,_,s),l(t,V,s),l(t,Y,s),r(d,t,s),l(t,S,s),l(t,j,s),l(t,A,s),r(w,t,s),l(t,z,s),l(t,y,s),l(t,H,s),r(T,t,s),l(t,F,s),l(t,u,s),l(t,L,s),r(f,t,s),l(t,D,s),l(t,b,s),l(t,K,s),r(U,t,s),l(t,q,s),l(t,I,s),l(t,P,s),r($,t,s),l(t,O,s),l(t,Z,s),l(t,tt,s),l(t,x,s),l(t,st,s),r(W,t,s),l(t,et,s),l(t,k,s),l(t,lt,s),r(C,t,s),l(t,at,s),l(t,N,s),l(t,nt,s),r(v,t,s),l(t,pt,s),l(t,B,s),l(t,it,s),r(G,t,s),l(t,mt,s),r(E,t,s),l(t,ot,s),l(t,X,s),rt=!0},p:It,i(t){rt||(c(d.$$.fragment,t),c(w.$$.fragment,t),c(T.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c($.$$.fragment,t),c(W.$$.fragment,t),c(C.$$.fragment,t),c(v.$$.fragment,t),c(G.$$.fragment,t),c(E.$$.fragment,t),rt=!0)},o(t){h(d.$$.fragment,t),h(w.$$.fragment,t),h(T.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(W.$$.fragment,t),h(C.$$.fragment,t),h(v.$$.fragment,t),h(G.$$.fragment,t),h(E.$$.fragment,t),rt=!1},d(t){t&&(e(_),e(V),e(Y),e(S),e(j),e(A),e(z),e(y),e(H),e(F),e(u),e(L),e(D),e(b),e(K),e(q),e(I),e(P),e(O),e(Z),e(tt),e(x),e(st),e(et),e(k),e(lt),e(at),e(N),e(nt),e(pt),e(B),e(it),e(mt),e(ot),e(X)),e(J),M(d,t),M(w,t),M(T,t),M(f,t),M(U,t),M($,t),M(W,t),M(C,t),M(v,t),M(G,t),M(E,t)}}}const Nt='{"title":"SK-ResNeXt","local":"sk-resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function vt(ct){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Zt{constructor(J){super(),xt(this,J,vt,Ct,Ut,{})}}export{Vt as component};
