import{s as Yn,n as Dn,o as Pn}from"../chunks/scheduler.9039eef2.js";import{S as On,i as Kn,g as o,s,r as p,A as ts,h as i,f as a,c as l,j as Aa,u as d,x as r,k as La,l as Wn,y as _,a as n,v as c,d as m,t as u,w as h}from"../chunks/index.ded8f90d.js";import{D as qn}from"../chunks/Docstring.a2ba2b54.js";import{C as f}from"../chunks/CodeBlock.8580f3e8.js";import{H as M}from"../chunks/Heading.f027f30d.js";function es(Da){let T,ie,le,re,k,pe,J,Pa="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",de,j,Oa='Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.',ce,C,me,x,Ka=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,ue,$,he,v,tn="Make sure to pass a correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",fe,F,en="You can also construct a model outside of the trainer and pass it as follows:",Me,I,ye,G,an='The above snippets will use the default training arguments from the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow"><code>transformers.TrainingArguments</code></a> class. If you want to modify that, make sure to create your own <code>TrainingArguments</code> object and pass it to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor as it is done on the <a href="https://github.com/huggingface/trl/blob/main/examples/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>supervised_finetuning.py</code> script</a> on the stack-llama example.',Te,R,ge,Z,we,z,nn=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,be,B,Ue,S,sn="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",_e,E,ke,X,ln="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",Je,N,je,V,on="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending whether they have context or not. For example:",Ce,Q,xe,A,rn="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",$e,L,pn="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",ve,H,dn="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",Fe,W,Ie,q,cn="To solve this, you can tokenize the <code>response_template</code> with the same context than in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",Ge,Y,Re,D,Ze,P,mn=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,ze,O,Be,K,un="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",Se,tt,Ee,et,hn='To preperly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example on how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',Xe,at,Ne,nt,fn='<a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor.',Ve,st,Qe,lt,Mn="Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.",Ae,ot,Le,it,yn="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",He,rt,We,pt,Tn='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor. Please refer to that class’ signature for more information.',qe,dt,Ye,ct,gn='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. For example, if you want to load a model in a different precision, analogous to',De,mt,Pe,ut,Oe,ht,wn="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",Ke,ft,ta,Mt,bn="We also support a tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",ea,yt,aa,Tt,Un="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",na,gt,sa,wt,_n="For that you need to first load your 8bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",la,bt,oa,Ut,ia,_t,kn=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,ra,kt,pa,Jt,Jn=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,da,jt,ca,Ct,jn="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",ma,xt,ua,$t,Cn="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",ha,vt,fa,Ft,xn="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",Ma,It,$n="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",ya,Gt,vn="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",Ta,Rt,ga,Zt,Fn="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",wa,zt,ba,Bt,In="And add <code>use_flash_attention_2=True</code> when calling <code>from_pretrained</code>:",Ua,St,_a,Et,Gn=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,ka,Xt,Rn="In contrary to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",Ja,Nt,ja,Vt,Zn='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',Ca,Qt,zn="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",xa,w,Bn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',$a,At,Sn="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTTrainer</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",va,Lt,Fa,Ht,En='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',Ia,b,Xn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',Ga,Wt,Nn='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',Ra,qt,Za,Yt,Vn="Pay attention to the following best practices when training a model with that trainer:",za,Dt,Qn='<li><a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',Ba,Pt,Sa,g,Ot,Ha,ae,An=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Ea,Kt,Xa,y,te,Wa,ne,Ln=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,qa,ee,Ya,se,Hn=`”<code>infinite (</code>bool<code>, *optional*, defaults to </code>False<code>): If True the iterator is reset after dataset reaches end else stops. seq_length (</code>int<code>, *optional*, defaults to </code>1024<code>): Length of token sequences to return. num_of_sequences (</code>int<code>, *optional*, defaults to </code>1024<code>): Number of token sequences to keep in buffer. chars_per_token (</code>int<code>, *optional*, defaults to </code>3.6<code>): Number of characters per token used to estimate number of tokens in text buffer. eos_token_id (</code>int<code>, *optional*, defaults to </code>0<code>): Id of the end of sequence token if the passed tokenizer does not have an EOS token. shuffle (&#39;bool&#39;, *optional*, defaults to True) Shuffle the examples before they are returned append_concat_token (&#39;bool&#39;, *optional*, defaults to True) If true, appends </code>eos_token_id\` at the end of each sample being packed.
add_special_tokens (‘bool’, <em>optional</em>, defaults to True)
If true, tokenizers adds special tokens to each sample being packed.`,Na,oe,Va;return k=new M({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),C=new M({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),$=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)
trainer.train()`,wrap:!1}}),I=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)

trainer.train()`,wrap:!1}}),R=new M({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),Z=new M({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),B=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX2Z1bmMlM0Rmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCklMjA=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train() `,wrap:!1}}),E=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCklMjA=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    data_collator=collator,
)

trainer.train() `,wrap:!1}}),N=new M({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),Q=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),W=new f({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCklMjAlMjAlMjA=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)   ',wrap:!1}}),Y=new f({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),D=new M({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),O=new f({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),tt=new f({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),at=new M({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),st=new f({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    packing=<span class="hljs-literal">True</span>
)

trainer.train()`,wrap:!1}}),ot=new M({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),rt=new f({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwYWNraW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),dt=new M({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),mt=new f({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYp",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)',wrap:!1}}),ut=new f({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16,
    },
)

trainer.train()`,wrap:!1}}),ft=new M({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),yt=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),gt=new M({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),bt=new f({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Ut=new M({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),kt=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),jt=new M({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),xt=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),vt=new f({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),Rt=new M({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),zt=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),St=new f({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUwQSk=",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Nt=new M({props:{title:"Enhance model’s performances using NEFTune",local:"enhance-models-performances-using-neftune",headingTag:"h3"}}),Lt=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG5lZnR1bmVfbm9pc2VfYWxwaGElM0Q1JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer.train()`,wrap:!1}}),qt=new M({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),Pt=new M({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),Ot=new qn({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"peft_config",val:": typing.Optional[ForwardRef('PeftConfig')] = None"},{name:"dataset_text_field",val:": typing.Optional[str] = None"},{name:"packing",val:": typing.Optional[bool] = False"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"infinite",val:": typing.Optional[bool] = None"},{name:"num_of_sequences",val:": typing.Optional[int] = 1024"},{name:"chars_per_token",val:": typing.Optional[float] = 3.6"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"dataset_kwargs",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automaticallty creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instrcution
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L52"}}),Kt=new M({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h2"}}),te=new qn({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"*args",val:""},{name:"**kwds",val:""}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as \`&#x201D;### Question: {question}`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/utils.py#L334"}}),ee=new M({props:{title:"Answer: {answer}",local:"answer-answer",headingTag:"h3"}}),{c(){T=o("meta"),ie=s(),le=o("p"),re=s(),p(k.$$.fragment),pe=s(),J=o("p"),J.textContent=Pa,de=s(),j=o("p"),j.innerHTML=Oa,ce=s(),p(C.$$.fragment),me=s(),x=o("p"),x.innerHTML=Ka,ue=s(),p($.$$.fragment),he=s(),v=o("p"),v.innerHTML=tn,fe=s(),F=o("p"),F.textContent=en,Me=s(),p(I.$$.fragment),ye=s(),G=o("p"),G.innerHTML=an,Te=s(),p(R.$$.fragment),ge=s(),p(Z.$$.fragment),we=s(),z=o("p"),z.innerHTML=nn,be=s(),p(B.$$.fragment),Ue=s(),S=o("p"),S.innerHTML=sn,_e=s(),p(E.$$.fragment),ke=s(),X=o("p"),X.innerHTML=ln,Je=s(),p(N.$$.fragment),je=s(),V=o("p"),V.innerHTML=on,Ce=s(),p(Q.$$.fragment),xe=s(),A=o("p"),A.innerHTML=rn,$e=s(),L=o("ul"),L.innerHTML=pn,ve=s(),H=o("p"),H.innerHTML=dn,Fe=s(),p(W.$$.fragment),Ie=s(),q=o("p"),q.innerHTML=cn,Ge=s(),p(Y.$$.fragment),Re=s(),p(D.$$.fragment),Ze=s(),P=o("p"),P.innerHTML=mn,ze=s(),p(O.$$.fragment),Be=s(),K=o("p"),K.innerHTML=un,Se=s(),p(tt.$$.fragment),Ee=s(),et=o("p"),et.innerHTML=hn,Xe=s(),p(at.$$.fragment),Ne=s(),nt=o("p"),nt.innerHTML=fn,Ve=s(),p(st.$$.fragment),Qe=s(),lt=o("p"),lt.innerHTML=Mn,Ae=s(),p(ot.$$.fragment),Le=s(),it=o("p"),it.innerHTML=yn,He=s(),p(rt.$$.fragment),We=s(),pt=o("p"),pt.innerHTML=Tn,qe=s(),p(dt.$$.fragment),Ye=s(),ct=o("p"),ct.innerHTML=gn,De=s(),p(mt.$$.fragment),Pe=s(),p(ut.$$.fragment),Oe=s(),ht=o("p"),ht.innerHTML=wn,Ke=s(),p(ft.$$.fragment),ta=s(),Mt=o("p"),Mt.textContent=bn,ea=s(),p(yt.$$.fragment),aa=s(),Tt=o("p"),Tt.innerHTML=Un,na=s(),p(gt.$$.fragment),sa=s(),wt=o("p"),wt.innerHTML=_n,la=s(),p(bt.$$.fragment),oa=s(),p(Ut.$$.fragment),ia=s(),_t=o("p"),_t.textContent=kn,ra=s(),p(kt.$$.fragment),pa=s(),Jt=o("p"),Jt.textContent=Jn,da=s(),p(jt.$$.fragment),ca=s(),Ct=o("p"),Ct.innerHTML=jn,ma=s(),p(xt.$$.fragment),ua=s(),$t=o("p"),$t.innerHTML=Cn,ha=s(),p(vt.$$.fragment),fa=s(),Ft=o("p"),Ft.innerHTML=xn,Ma=s(),It=o("p"),It.textContent=$n,ya=s(),Gt=o("table"),Gt.innerHTML=vn,Ta=s(),p(Rt.$$.fragment),ga=s(),Zt=o("p"),Zt.innerHTML=Fn,wa=s(),p(zt.$$.fragment),ba=s(),Bt=o("p"),Bt.innerHTML=In,Ua=s(),p(St.$$.fragment),_a=s(),Et=o("p"),Et.textContent=Gn,ka=s(),Xt=o("p"),Xt.textContent=Rn,Ja=s(),p(Nt.$$.fragment),ja=s(),Vt=o("p"),Vt.innerHTML=Zn,Ca=s(),Qt=o("blockquote"),Qt.innerHTML=zn,xa=s(),w=o("div"),w.innerHTML=Bn,$a=s(),At=o("p"),At.innerHTML=Sn,va=s(),p(Lt.$$.fragment),Fa=s(),Ht=o("p"),Ht.innerHTML=En,Ia=s(),b=o("div"),b.innerHTML=Xn,Ga=s(),Wt=o("p"),Wt.innerHTML=Nn,Ra=s(),p(qt.$$.fragment),Za=s(),Yt=o("p"),Yt.textContent=Vn,za=s(),Dt=o("ul"),Dt.innerHTML=Qn,Ba=s(),p(Pt.$$.fragment),Sa=s(),g=o("div"),p(Ot.$$.fragment),Ha=s(),ae=o("p"),ae.innerHTML=An,Ea=s(),p(Kt.$$.fragment),Xa=s(),y=o("div"),p(te.$$.fragment),Wa=s(),ne=o("p"),ne.textContent=Ln,qa=s(),p(ee.$$.fragment),Ya=s(),se=o("p"),se.innerHTML=Hn,Na=s(),oe=o("p"),this.h()},l(t){const e=ts("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(a),ie=l(t),le=i(t,"P",{}),Aa(le).forEach(a),re=l(t),d(k.$$.fragment,t),pe=l(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-o839x3"&&(J.textContent=Pa),de=l(t),j=i(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-exgkch"&&(j.innerHTML=Oa),ce=l(t),d(C.$$.fragment,t),me=l(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-8asaew"&&(x.innerHTML=Ka),ue=l(t),d($.$$.fragment,t),he=l(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1gbidw"&&(v.innerHTML=tn),fe=l(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-ulikv8"&&(F.textContent=en),Me=l(t),d(I.$$.fragment,t),ye=l(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ryagwl"&&(G.innerHTML=an),Te=l(t),d(R.$$.fragment,t),ge=l(t),d(Z.$$.fragment,t),we=l(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-13sbeoj"&&(z.innerHTML=nn),be=l(t),d(B.$$.fragment,t),Ue=l(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1a743rp"&&(S.innerHTML=sn),_e=l(t),d(E.$$.fragment,t),ke=l(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-17fkgzr"&&(X.innerHTML=ln),Je=l(t),d(N.$$.fragment,t),je=l(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-dfggk8"&&(V.innerHTML=on),Ce=l(t),d(Q.$$.fragment,t),xe=l(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-xlwe87"&&(A.innerHTML=rn),$e=l(t),L=i(t,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-1enki0k"&&(L.innerHTML=pn),ve=l(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-14yxh0m"&&(H.innerHTML=dn),Fe=l(t),d(W.$$.fragment,t),Ie=l(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-13h81gp"&&(q.innerHTML=cn),Ge=l(t),d(Y.$$.fragment,t),Re=l(t),d(D.$$.fragment,t),Ze=l(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-cqsf2h"&&(P.innerHTML=mn),ze=l(t),d(O.$$.fragment,t),Be=l(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-l25vq0"&&(K.innerHTML=un),Se=l(t),d(tt.$$.fragment,t),Ee=l(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1iqmdsd"&&(et.innerHTML=hn),Xe=l(t),d(at.$$.fragment,t),Ne=l(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1a4epj8"&&(nt.innerHTML=fn),Ve=l(t),d(st.$$.fragment,t),Qe=l(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-wtbvzy"&&(lt.innerHTML=Mn),Ae=l(t),d(ot.$$.fragment,t),Le=l(t),it=i(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-iejqw3"&&(it.innerHTML=yn),He=l(t),d(rt.$$.fragment,t),We=l(t),pt=i(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-qqgn8q"&&(pt.innerHTML=Tn),qe=l(t),d(dt.$$.fragment,t),Ye=l(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-oxgwyg"&&(ct.innerHTML=gn),De=l(t),d(mt.$$.fragment,t),Pe=l(t),d(ut.$$.fragment,t),Oe=l(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1rnsxc5"&&(ht.innerHTML=wn),Ke=l(t),d(ft.$$.fragment,t),ta=l(t),Mt=i(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-11jfbzz"&&(Mt.textContent=bn),ea=l(t),d(yt.$$.fragment,t),aa=l(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-pwdaav"&&(Tt.innerHTML=Un),na=l(t),d(gt.$$.fragment,t),sa=l(t),wt=i(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-zbh7v5"&&(wt.innerHTML=_n),la=l(t),d(bt.$$.fragment,t),oa=l(t),d(Ut.$$.fragment,t),ia=l(t),_t=i(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-fyvvsj"&&(_t.textContent=kn),ra=l(t),d(kt.$$.fragment,t),pa=l(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-yypgof"&&(Jt.textContent=Jn),da=l(t),d(jt.$$.fragment,t),ca=l(t),Ct=i(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-yugu96"&&(Ct.innerHTML=jn),ma=l(t),d(xt.$$.fragment,t),ua=l(t),$t=i(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1qms4cl"&&($t.innerHTML=Cn),ha=l(t),d(vt.$$.fragment,t),fa=l(t),Ft=i(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-qe5zfz"&&(Ft.innerHTML=xn),Ma=l(t),It=i(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-69u1rz"&&(It.textContent=$n),ya=l(t),Gt=i(t,"TABLE",{"data-svelte-h":!0}),r(Gt)!=="svelte-8fq96j"&&(Gt.innerHTML=vn),Ta=l(t),d(Rt.$$.fragment,t),ga=l(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1rqlm78"&&(Zt.innerHTML=Fn),wa=l(t),d(zt.$$.fragment,t),ba=l(t),Bt=i(t,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-sqoxna"&&(Bt.innerHTML=In),Ua=l(t),d(St.$$.fragment,t),_a=l(t),Et=i(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-vfpk19"&&(Et.textContent=Gn),ka=l(t),Xt=i(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-zatc00"&&(Xt.textContent=Rn),Ja=l(t),d(Nt.$$.fragment,t),ja=l(t),Vt=i(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-6trhkk"&&(Vt.innerHTML=Zn),Ca=l(t),Qt=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Qt)!=="svelte-1ejl1pl"&&(Qt.innerHTML=zn),xa=l(t),w=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(w)!=="svelte-1wkjgyb"&&(w.innerHTML=Bn),$a=l(t),At=i(t,"P",{"data-svelte-h":!0}),r(At)!=="svelte-7jwpzy"&&(At.innerHTML=Sn),va=l(t),d(Lt.$$.fragment,t),Fa=l(t),Ht=i(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-sqj12"&&(Ht.innerHTML=En),Ia=l(t),b=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(b)!=="svelte-a1m5gi"&&(b.innerHTML=Xn),Ga=l(t),Wt=i(t,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-rwofnh"&&(Wt.innerHTML=Nn),Ra=l(t),d(qt.$$.fragment,t),Za=l(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-g801h1"&&(Yt.textContent=Vn),za=l(t),Dt=i(t,"UL",{"data-svelte-h":!0}),r(Dt)!=="svelte-1mmsr46"&&(Dt.innerHTML=Qn),Ba=l(t),d(Pt.$$.fragment,t),Sa=l(t),g=i(t,"DIV",{class:!0});var Qa=Aa(g);d(Ot.$$.fragment,Qa),Ha=l(Qa),ae=i(Qa,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-14oyph8"&&(ae.innerHTML=An),Qa.forEach(a),Ea=l(t),d(Kt.$$.fragment,t),Xa=l(t),y=i(t,"DIV",{class:!0});var U=Aa(y);d(te.$$.fragment,U),Wa=l(U),ne=i(U,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1dlriq1"&&(ne.textContent=Ln),qa=l(U),d(ee.$$.fragment,U),Ya=l(U),se=i(U,"P",{"data-svelte-h":!0}),r(se)!=="svelte-gymob5"&&(se.innerHTML=Hn),U.forEach(a),Na=l(t),oe=i(t,"P",{}),Aa(oe).forEach(a),this.h()},h(){La(T,"name","hf:doc:metadata"),La(T,"content",as),Wn(w,"text-align","center"),Wn(b,"text-align","center"),La(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),La(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){_(document.head,T),n(t,ie,e),n(t,le,e),n(t,re,e),c(k,t,e),n(t,pe,e),n(t,J,e),n(t,de,e),n(t,j,e),n(t,ce,e),c(C,t,e),n(t,me,e),n(t,x,e),n(t,ue,e),c($,t,e),n(t,he,e),n(t,v,e),n(t,fe,e),n(t,F,e),n(t,Me,e),c(I,t,e),n(t,ye,e),n(t,G,e),n(t,Te,e),c(R,t,e),n(t,ge,e),c(Z,t,e),n(t,we,e),n(t,z,e),n(t,be,e),c(B,t,e),n(t,Ue,e),n(t,S,e),n(t,_e,e),c(E,t,e),n(t,ke,e),n(t,X,e),n(t,Je,e),c(N,t,e),n(t,je,e),n(t,V,e),n(t,Ce,e),c(Q,t,e),n(t,xe,e),n(t,A,e),n(t,$e,e),n(t,L,e),n(t,ve,e),n(t,H,e),n(t,Fe,e),c(W,t,e),n(t,Ie,e),n(t,q,e),n(t,Ge,e),c(Y,t,e),n(t,Re,e),c(D,t,e),n(t,Ze,e),n(t,P,e),n(t,ze,e),c(O,t,e),n(t,Be,e),n(t,K,e),n(t,Se,e),c(tt,t,e),n(t,Ee,e),n(t,et,e),n(t,Xe,e),c(at,t,e),n(t,Ne,e),n(t,nt,e),n(t,Ve,e),c(st,t,e),n(t,Qe,e),n(t,lt,e),n(t,Ae,e),c(ot,t,e),n(t,Le,e),n(t,it,e),n(t,He,e),c(rt,t,e),n(t,We,e),n(t,pt,e),n(t,qe,e),c(dt,t,e),n(t,Ye,e),n(t,ct,e),n(t,De,e),c(mt,t,e),n(t,Pe,e),c(ut,t,e),n(t,Oe,e),n(t,ht,e),n(t,Ke,e),c(ft,t,e),n(t,ta,e),n(t,Mt,e),n(t,ea,e),c(yt,t,e),n(t,aa,e),n(t,Tt,e),n(t,na,e),c(gt,t,e),n(t,sa,e),n(t,wt,e),n(t,la,e),c(bt,t,e),n(t,oa,e),c(Ut,t,e),n(t,ia,e),n(t,_t,e),n(t,ra,e),c(kt,t,e),n(t,pa,e),n(t,Jt,e),n(t,da,e),c(jt,t,e),n(t,ca,e),n(t,Ct,e),n(t,ma,e),c(xt,t,e),n(t,ua,e),n(t,$t,e),n(t,ha,e),c(vt,t,e),n(t,fa,e),n(t,Ft,e),n(t,Ma,e),n(t,It,e),n(t,ya,e),n(t,Gt,e),n(t,Ta,e),c(Rt,t,e),n(t,ga,e),n(t,Zt,e),n(t,wa,e),c(zt,t,e),n(t,ba,e),n(t,Bt,e),n(t,Ua,e),c(St,t,e),n(t,_a,e),n(t,Et,e),n(t,ka,e),n(t,Xt,e),n(t,Ja,e),c(Nt,t,e),n(t,ja,e),n(t,Vt,e),n(t,Ca,e),n(t,Qt,e),n(t,xa,e),n(t,w,e),n(t,$a,e),n(t,At,e),n(t,va,e),c(Lt,t,e),n(t,Fa,e),n(t,Ht,e),n(t,Ia,e),n(t,b,e),n(t,Ga,e),n(t,Wt,e),n(t,Ra,e),c(qt,t,e),n(t,Za,e),n(t,Yt,e),n(t,za,e),n(t,Dt,e),n(t,Ba,e),c(Pt,t,e),n(t,Sa,e),n(t,g,e),c(Ot,g,null),_(g,Ha),_(g,ae),n(t,Ea,e),c(Kt,t,e),n(t,Xa,e),n(t,y,e),c(te,y,null),_(y,Wa),_(y,ne),_(y,qa),c(ee,y,null),_(y,Ya),_(y,se),n(t,Na,e),n(t,oe,e),Va=!0},p:Dn,i(t){Va||(m(k.$$.fragment,t),m(C.$$.fragment,t),m($.$$.fragment,t),m(I.$$.fragment,t),m(R.$$.fragment,t),m(Z.$$.fragment,t),m(B.$$.fragment,t),m(E.$$.fragment,t),m(N.$$.fragment,t),m(Q.$$.fragment,t),m(W.$$.fragment,t),m(Y.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(at.$$.fragment,t),m(st.$$.fragment,t),m(ot.$$.fragment,t),m(rt.$$.fragment,t),m(dt.$$.fragment,t),m(mt.$$.fragment,t),m(ut.$$.fragment,t),m(ft.$$.fragment,t),m(yt.$$.fragment,t),m(gt.$$.fragment,t),m(bt.$$.fragment,t),m(Ut.$$.fragment,t),m(kt.$$.fragment,t),m(jt.$$.fragment,t),m(xt.$$.fragment,t),m(vt.$$.fragment,t),m(Rt.$$.fragment,t),m(zt.$$.fragment,t),m(St.$$.fragment,t),m(Nt.$$.fragment,t),m(Lt.$$.fragment,t),m(qt.$$.fragment,t),m(Pt.$$.fragment,t),m(Ot.$$.fragment,t),m(Kt.$$.fragment,t),m(te.$$.fragment,t),m(ee.$$.fragment,t),Va=!0)},o(t){u(k.$$.fragment,t),u(C.$$.fragment,t),u($.$$.fragment,t),u(I.$$.fragment,t),u(R.$$.fragment,t),u(Z.$$.fragment,t),u(B.$$.fragment,t),u(E.$$.fragment,t),u(N.$$.fragment,t),u(Q.$$.fragment,t),u(W.$$.fragment,t),u(Y.$$.fragment,t),u(D.$$.fragment,t),u(O.$$.fragment,t),u(tt.$$.fragment,t),u(at.$$.fragment,t),u(st.$$.fragment,t),u(ot.$$.fragment,t),u(rt.$$.fragment,t),u(dt.$$.fragment,t),u(mt.$$.fragment,t),u(ut.$$.fragment,t),u(ft.$$.fragment,t),u(yt.$$.fragment,t),u(gt.$$.fragment,t),u(bt.$$.fragment,t),u(Ut.$$.fragment,t),u(kt.$$.fragment,t),u(jt.$$.fragment,t),u(xt.$$.fragment,t),u(vt.$$.fragment,t),u(Rt.$$.fragment,t),u(zt.$$.fragment,t),u(St.$$.fragment,t),u(Nt.$$.fragment,t),u(Lt.$$.fragment,t),u(qt.$$.fragment,t),u(Pt.$$.fragment,t),u(Ot.$$.fragment,t),u(Kt.$$.fragment,t),u(te.$$.fragment,t),u(ee.$$.fragment,t),Va=!1},d(t){t&&(a(ie),a(le),a(re),a(pe),a(J),a(de),a(j),a(ce),a(me),a(x),a(ue),a(he),a(v),a(fe),a(F),a(Me),a(ye),a(G),a(Te),a(ge),a(we),a(z),a(be),a(Ue),a(S),a(_e),a(ke),a(X),a(Je),a(je),a(V),a(Ce),a(xe),a(A),a($e),a(L),a(ve),a(H),a(Fe),a(Ie),a(q),a(Ge),a(Re),a(Ze),a(P),a(ze),a(Be),a(K),a(Se),a(Ee),a(et),a(Xe),a(Ne),a(nt),a(Ve),a(Qe),a(lt),a(Ae),a(Le),a(it),a(He),a(We),a(pt),a(qe),a(Ye),a(ct),a(De),a(Pe),a(Oe),a(ht),a(Ke),a(ta),a(Mt),a(ea),a(aa),a(Tt),a(na),a(sa),a(wt),a(la),a(oa),a(ia),a(_t),a(ra),a(pa),a(Jt),a(da),a(ca),a(Ct),a(ma),a(ua),a($t),a(ha),a(fa),a(Ft),a(Ma),a(It),a(ya),a(Gt),a(Ta),a(ga),a(Zt),a(wa),a(ba),a(Bt),a(Ua),a(_a),a(Et),a(ka),a(Xt),a(Ja),a(ja),a(Vt),a(Ca),a(Qt),a(xa),a(w),a($a),a(At),a(va),a(Fa),a(Ht),a(Ia),a(b),a(Ga),a(Wt),a(Ra),a(Za),a(Yt),a(za),a(Dt),a(Ba),a(Sa),a(g),a(Ea),a(Xa),a(y),a(Na),a(oe)),a(T),h(k,t),h(C,t),h($,t),h(I,t),h(R,t),h(Z,t),h(B,t),h(E,t),h(N,t),h(Q,t),h(W,t),h(Y,t),h(D,t),h(O,t),h(tt,t),h(at,t),h(st,t),h(ot,t),h(rt,t),h(dt,t),h(mt,t),h(ut,t),h(ft,t),h(yt,t),h(gt,t),h(bt,t),h(Ut,t),h(kt,t),h(jt,t),h(xt,t),h(vt,t),h(Rt,t),h(zt,t),h(St,t),h(Nt,t),h(Lt,t),h(qt,t),h(Pt,t),h(Ot),h(Kt,t),h(te),h(ee)}}}const as='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Enhance model’s performances using NEFTune","local":"enhance-models-performances-using-neftune","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[{"title":"Answer: {answer}","local":"answer-answer","sections":[],"depth":3}],"depth":2}],"depth":1}';function ns(Da){return Pn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ps extends On{constructor(T){super(),Kn(this,T,ns,es,Yn,{})}}export{ps as component};
