import{s as Et,f as lt,n as zt,o as Lt}from"../chunks/scheduler.37c15a92.js";import{S as Qt,i as St,g as n,s as i,r as d,A as Wt,h as o,f as l,c as s,j as pe,u as M,x as r,k as p,y as Rt,a,v as y,d as f,t as w,w as T}from"../chunks/index.2bf4358c.js";import{C as at}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Vt}from"../chunks/CourseFloatingBanner.06521e8b.js";import{H as ne}from"../chunks/Heading.8ada512a.js";function Nt(it){let j,ce,oe,ue,J,me,h,de,b,st=`In questa sezione, daremo un’occhiata più da vicino alla classe <code>Interface</code> e scopriremo i
parametri principali che si usano per crearne una.`,Me,U,ye,v,nt="Si può notare che la classe <code>Interface</code> (<em>interfaccia</em>) ha 3 parametri necessari:",fe,I,ot="<code>Interface(fn, inputs, outputs, ...)</code>",we,C,rt="Questi parametri sono:",Te,g,pt="<li><code>fn</code>: la funzione per le predizione chi viene utilizzata dall’interfaccia di Gradio. Questa funzione può accettare uno o più parametri e restituire uno o più valori</li> <li><code>inputs</code>: il/i tipo/i dei componenti in input. Gradio fornisce molti componenti predefiniti, come <code>&quot;image&quot;</code>(<em>immagine</em>) o <code>&quot;mic&quot;</code>(<em>microfono</em>).</li> <li><code>outputs</code>: il/i tipo/i dei componenti in output. Anche in questo caso, Gradio fornisce molti componenti predefiniti, come <code>&quot;image&quot;</code> o <code>&quot;label&quot;</code>.</li>",je,q,ct='Per un elenco completo dei componenti, <a href="https://gradio.app/docs" rel="nofollow">consultare la documentazione di Gradio</a>. Ogni componente predefinito può essere personalizzato istanziando la classe corrispondente al componente.',Je,k,ut=`Ad esempio, come abbiamo visto nella <a href="/course/chapter9/2">sezione precedente</a>,
invece di passare <code>&quot;textbox&quot;</code> al parametro <code>inputs</code>, si può passare un componente <code>Textbox(lines=7, label=&quot;Prompt&quot;)</code> per creare una casella di testo con 7 righe e un’etichetta.`,he,A,mt="Diamo un’occhiata a un altro esempio, questa volta con un componente <code>Audio</code>.",be,x,Ue,G,dt=`Come detto in precedenza, Gradio fornisce molti input e output differenti.
Costruiamo perciò una <code>Interface</code> che funziona con l’audio.`,ve,B,Mt=`In questo esempio, svilupperemo una funzione da audio ad audio che prende un
file audio e semplicemente lo inverte.`,Ie,_,yt=`Per l’input utilizzeremo il componente <code>Audio</code>. Quando si usa il componente <code>Audio</code>,
si può specificare se si vuole che la <code>source</code> (<em>sorgente</em>) dell’audio sia un file
caricato dall’utente o un microfono con cui l’utente può registrare la propria voce. In questo caso,
impostiamo <code>&quot;microphone&quot;</code>. Per divertimento, aggiungeremo un’etichetta al nostro <code>Audio</code> che dice
“Speak here…” (<em>“Parla qui…”</em>).`,Ce,$,ft=`Inoltre, vorremmo ricevere l’audio come un numpy array, in modo da poterlo facilmente
“invertire”. Impostiamo quindi il <code>&quot;type&quot;</code> come <code>&quot;numpy&quot;</code>, che passa i dati in input
come una tupla di (<code>sample_rate</code>, <code>data</code>) alla nostra funzione.`,ge,Z,wt=`Utilizzeremo anche il componente di output <code>Audio</code>, il quale può convertire automaticamente
una tupla formata da una frequenza di campionamento e un numpy array di dati in un file audio riproducibile.
In questo caso, non abbiamo bisogno di fare alcuna personalizzazione, quindi useremo la stringa
<code>&quot;audio&quot;</code>.`,qe,H,ke,E,Tt=`Il codice precedente produrrà un’interfaccia come quella qui sotto (se il tuo browser non
chiede il premesso per usare il microfono, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">apri il demo in una tab diversa</a>.)`,Ae,c,jt,xe,z,Jt="A questo punto potresti registrare la tua voce e di sentirti parlare al contrario - spaventoso 👻!",Ge,L,Be,Q,ht=`Supponiamo di avere una funzione più complicata, con più input e output.
Nell’esempio seguente, abbiamo una funzione che richiede un elenco a tendina, il valore di uno slider e un numero,
e restituisce il campione audio di una nota musicale.`,_e,S,bt=`Osserva come si passa un elenco di componenti di input e di output,
e vedi se riesci a seguire quello che succede.`,$e,W,Ut="La questione fondamentale è che quando si passa:",Ze,R,vt="<li>un elenco di componenti di input, ogni componente corrisponde in ordine a un parametro.</li> <li>un elenco di componenti di output, ogni componente corrisponde a un valore restituito.</li>",He,V,It="Lo snippet di codice qui sotto mostra come tre componenti di input si abbinano ai tre argomenti della funzione <code>generate_tone()</code>:",Ee,N,ze,u,Ct,Le,X,Qe,Y,gt=`Per ora, abbiamo utilizzato il metodo <code>launch()</code> per avviare l’interfaccia, ma
non abbiamo discusso realmente cosa fa.`,Se,P,qt=`Di default, il metodo <code>launch()</code> avvia la demo in un web server che
che viene eseguito in locale. Se si esegue il codice in un Jupyter o Colab notebook,
Gradio incorporerà l’interfaccia grafica della demo nel notebook, così da poterla usare facilmente.`,We,F,kt="È possibile modificare il comportamento di <code>launch()</code> attraverso diversi parametri:",Re,D,At="<li><code>inline</code> - per visualizzare l’interfaccia <em>inline</em> sui notebook di Python.</li> <li><code>inbrowser</code> - per avviare automaticamente l’interfaccia in una nuova scheda del browser di default.</li> <li><code>share</code> - per create un link pubblico per l’interfaccia da condividere dal proprio computer. Un po’ come un link di Google Drive!</li>",Ve,K,xt="Il parametro <code>share</code> sarà trattato in modo molto più dettagliato nella prossima sezione!",Ne,O,Xe,ee,Gt=`Costruiamo un’interfaccia che permetta di provare un modello di <strong>riconoscimento vocale</strong>.
Per renderlo interessante, accetteremo un input <em>qualisiasi</em> tra un microfono o un file caricato.`,Ye,te,Bt=`Come al solito, caricheremo il nostro modello di riconoscimento vocale usando la funzione <code>pipeline()</code> da 🤗 Transformers.
Se si ha bisogno di un ripasso veloce, si può tornare a <a href="/course/chapter1/3">quella sezione nel Capitolo 1</a>.     Quindi, implementeremo una funzione <code>transcribe_audio()</code> che elabora l’audio e restituisce la sua trascrizione. Infine, avvolgeremo questa funzione in una <code>Interface</code> con i componenti <code>Audio</code> per gli input e solo testo per l’output. Il codice completo per questa applicazione è il seguente:`,Pe,le,Fe,ae,_t='Se il tuo browser non ti chiede i permessi per il microfono, <a href="https://huggingface.co/spaces/course-demos/audio-reverse" target="_blank">apri la demo in una scheda separata</a>.',De,m,$t,Ke,ie,Zt=`Ecco fatto! Ora è possibile utilizzare questa interfaccia per trascrivere l’audio. Si osservi che
passando il parametro <code>optional</code> come <code>True</code>, si permette all’utente di
fornire o un microfono o un file audio (o nessuno dei due, ma questo restituirà un messaggio di errore).`,Oe,se,Ht="Continua a leggere per scoprire come condividere la tua interfaccia con gli altri!",et,re,tt;return J=new ne({props:{title:"Capire la classe Interface",local:"capire-la-classe-interface",headingTag:"h1"}}),h=new Vt({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section3.ipynb"}]}}),U=new ne({props:{title:"Come creare una Interface",local:"come-creare-una-interface",headingTag:"h2"}}),x=new ne({props:{title:"Un semplice esempio con l’audio",local:"un-semplice-esempio-con-laudio",headingTag:"h2"}}),H=new at({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMHJldmVyc2VfYXVkaW8oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMkMlMjBkYXRhJTIwJTNEJTIwYXVkaW8lMEElMjAlMjAlMjAlMjByZXZlcnNlZF9hdWRpbyUyMCUzRCUyMChzciUyQyUyMG5wLmZsaXB1ZChkYXRhKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXZlcnNlZF9hdWRpbyUwQSUwQSUwQW1pYyUyMCUzRCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMm1pY3JvcGhvbmUlMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIlMkMlMjBsYWJlbCUzRCUyMlNwZWFrJTIwaGVyZS4uLiUyMiklMEFnci5JbnRlcmZhY2UocmV2ZXJzZV9hdWRpbyUyQyUyMG1pYyUyQyUyMCUyMmF1ZGlvJTIyKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">reverse_audio</span>(<span class="hljs-params">audio</span>):
    sr, data = audio
    reversed_audio = (sr, np.flipud(data))
    <span class="hljs-keyword">return</span> reversed_audio


mic = gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>, label=<span class="hljs-string">&quot;Speak here...&quot;</span>)
gr.Interface(reverse_audio, mic, <span class="hljs-string">&quot;audio&quot;</span>).launch()`,wrap:!1}}),L=new ne({props:{title:"Lavorare con più input e output",local:"lavorare-con-più-input-e-output",headingTag:"h2"}}),N=new at({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW5vdGVzJTIwJTNEJTIwJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjMlMjIlMkMlMjAlMjJEJTIyJTJDJTIwJTIyRCUyMyUyMiUyQyUyMCUyMkUlMjIlMkMlMjAlMjJGJTIyJTJDJTIwJTIyRiUyMyUyMiUyQyUyMCUyMkclMjIlMkMlMjAlMjJHJTIzJTIyJTJDJTIwJTIyQSUyMiUyQyUyMCUyMkElMjMlMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTBBJTBBZGVmJTIwZ2VuZXJhdGVfdG9uZShub3RlJTJDJTIwb2N0YXZlJTJDJTIwZHVyYXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwc3IlMjAlM0QlMjA0ODAwMCUwQSUyMCUyMCUyMCUyMGE0X2ZyZXElMkMlMjB0b25lc19mcm9tX2E0JTIwJTNEJTIwNDQwJTJDJTIwMTIlMjAqJTIwKG9jdGF2ZSUyMC0lMjA0KSUyMCUyQiUyMChub3RlJTIwLSUyMDkpJTBBJTIwJTIwJTIwJTIwZnJlcXVlbmN5JTIwJTNEJTIwYTRfZnJlcSUyMColMjAyJTIwKiolMjAodG9uZXNfZnJvbV9hNCUyMCUyRiUyMDEyKSUwQSUyMCUyMCUyMCUyMGR1cmF0aW9uJTIwJTNEJTIwaW50KGR1cmF0aW9uKSUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbnAubGluc3BhY2UoMCUyQyUyMGR1cmF0aW9uJTJDJTIwZHVyYXRpb24lMjAqJTIwc3IpJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjAoMjAwMDAlMjAqJTIwbnAuc2luKGF1ZGlvJTIwKiUyMCgyJTIwKiUyMG5wLnBpJTIwKiUyMGZyZXF1ZW5jeSkpKS5hc3R5cGUobnAuaW50MTYpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKHNyJTJDJTIwYXVkaW8pJTBBJTBBJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlX3RvbmUlMkMlMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5Ecm9wZG93bihub3RlcyUyQyUyMHR5cGUlM0QlMjJpbmRleCUyMiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5TbGlkZXIobWluaW11bSUzRDQlMkMlMjBtYXhpbXVtJTNENiUyQyUyMHN0ZXAlM0QxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLlRleHRib3godHlwZSUzRCUyMm51bWJlciUyMiUyQyUyMHZhbHVlJTNEMSUyQyUyMGxhYmVsJTNEJTIyRHVyYXRpb24lMjBpbiUyMHNlY29uZHMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8lMjIlMkMlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

notes = [<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C#&quot;</span>, <span class="hljs-string">&quot;D&quot;</span>, <span class="hljs-string">&quot;D#&quot;</span>, <span class="hljs-string">&quot;E&quot;</span>, <span class="hljs-string">&quot;F&quot;</span>, <span class="hljs-string">&quot;F#&quot;</span>, <span class="hljs-string">&quot;G&quot;</span>, <span class="hljs-string">&quot;G#&quot;</span>, <span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;A#&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_tone</span>(<span class="hljs-params">note, octave, duration</span>):
    sr = <span class="hljs-number">48000</span>
    a4_freq, tones_from_a4 = <span class="hljs-number">440</span>, <span class="hljs-number">12</span> * (octave - <span class="hljs-number">4</span>) + (note - <span class="hljs-number">9</span>)
    frequency = a4_freq * <span class="hljs-number">2</span> ** (tones_from_a4 / <span class="hljs-number">12</span>)
    duration = <span class="hljs-built_in">int</span>(duration)
    audio = np.linspace(<span class="hljs-number">0</span>, duration, duration * sr)
    audio = (<span class="hljs-number">20000</span> * np.sin(audio * (<span class="hljs-number">2</span> * np.pi * frequency))).astype(np.int16)
    <span class="hljs-keyword">return</span> (sr, audio)


gr.Interface(
    generate_tone,
    [
        gr.Dropdown(notes, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;index&quot;</span>),
        gr.Slider(minimum=<span class="hljs-number">4</span>, maximum=<span class="hljs-number">6</span>, step=<span class="hljs-number">1</span>),
        gr.Textbox(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;number&quot;</span>, value=<span class="hljs-number">1</span>, label=<span class="hljs-string">&quot;Duration in seconds&quot;</span>),
    ],
    <span class="hljs-string">&quot;audio&quot;</span>,
).launch()`,wrap:!1}}),X=new ne({props:{title:"Il metodo launch()",local:"il-metodo-launch",headingTag:"h3"}}),O=new ne({props:{title:"✏️ Mettiamolo in pratica!",local:"-mettiamolo-in-pratica",headingTag:"h2"}}),le=new at({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQW1vZGVsJTIwJTNEJTIwcGlwZWxpbmUoJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiklMEElMEElMEFkZWYlMjB0cmFuc2NyaWJlX2F1ZGlvKG1pYyUzRE5vbmUlMkMlMjBmaWxlJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjBpZiUyMG1pYyUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwbWljJTBBJTIwJTIwJTIwJTIwZWxpZiUyMGZpbGUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpbyUyMCUzRCUyMGZpbGUlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyWW91JTIwbXVzdCUyMGVpdGhlciUyMHByb3ZpZGUlMjBhJTIwbWljJTIwcmVjb3JkaW5nJTIwb3IlMjBhJTIwZmlsZSUyMiUwQSUyMCUyMCUyMCUyMHRyYW5zY3JpcHRpb24lMjAlM0QlMjBtb2RlbChhdWRpbyklNUIlMjJ0ZXh0JTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNjcmlwdGlvbiUwQSUwQSUwQWdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHRyYW5zY3JpYmVfYXVkaW8lMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnci5BdWRpbyhzb3VyY2UlM0QlMjJtaWNyb3Bob25lJTIyJTJDJTIwdHlwZSUzRCUyMmZpbGVwYXRoJTIyJTJDJTIwb3B0aW9uYWwlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiUyQyUyMG9wdGlvbmFsJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEJTIydGV4dCUyMiUyQyUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

model = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe_audio</span>(<span class="hljs-params">mic=<span class="hljs-literal">None</span>, file=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">if</span> mic <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = mic
    <span class="hljs-keyword">elif</span> file <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        audio = file
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;You must either provide a mic recording or a file&quot;</span>
    transcription = model(audio)[<span class="hljs-string">&quot;text&quot;</span>]
    <span class="hljs-keyword">return</span> transcription


gr.Interface(
    fn=transcribe_audio,
    inputs=[
        gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
        gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>, optional=<span class="hljs-literal">True</span>),
    ],
    outputs=<span class="hljs-string">&quot;text&quot;</span>,
).launch()`,wrap:!1}}),{c(){j=n("meta"),ce=i(),oe=n("p"),ue=i(),d(J.$$.fragment),me=i(),d(h.$$.fragment),de=i(),b=n("p"),b.innerHTML=st,Me=i(),d(U.$$.fragment),ye=i(),v=n("p"),v.innerHTML=nt,fe=i(),I=n("p"),I.innerHTML=ot,we=i(),C=n("p"),C.textContent=rt,Te=i(),g=n("ul"),g.innerHTML=pt,je=i(),q=n("p"),q.innerHTML=ct,Je=i(),k=n("p"),k.innerHTML=ut,he=i(),A=n("p"),A.innerHTML=mt,be=i(),d(x.$$.fragment),Ue=i(),G=n("p"),G.innerHTML=dt,ve=i(),B=n("p"),B.textContent=Mt,Ie=i(),_=n("p"),_.innerHTML=yt,Ce=i(),$=n("p"),$.innerHTML=ft,ge=i(),Z=n("p"),Z.innerHTML=wt,qe=i(),d(H.$$.fragment),ke=i(),E=n("p"),E.innerHTML=Tt,Ae=i(),c=n("iframe"),xe=i(),z=n("p"),z.textContent=Jt,Ge=i(),d(L.$$.fragment),Be=i(),Q=n("p"),Q.textContent=ht,_e=i(),S=n("p"),S.textContent=bt,$e=i(),W=n("p"),W.textContent=Ut,Ze=i(),R=n("ul"),R.innerHTML=vt,He=i(),V=n("p"),V.innerHTML=It,Ee=i(),d(N.$$.fragment),ze=i(),u=n("iframe"),Le=i(),d(X.$$.fragment),Qe=i(),Y=n("p"),Y.innerHTML=gt,Se=i(),P=n("p"),P.innerHTML=qt,We=i(),F=n("p"),F.innerHTML=kt,Re=i(),D=n("ul"),D.innerHTML=At,Ve=i(),K=n("p"),K.innerHTML=xt,Ne=i(),d(O.$$.fragment),Xe=i(),ee=n("p"),ee.innerHTML=Gt,Ye=i(),te=n("p"),te.innerHTML=Bt,Pe=i(),d(le.$$.fragment),Fe=i(),ae=n("p"),ae.innerHTML=_t,De=i(),m=n("iframe"),Ke=i(),ie=n("p"),ie.innerHTML=Zt,Oe=i(),se=n("p"),se.textContent=Ht,et=i(),re=n("p"),this.h()},l(e){const t=Wt("svelte-u9bgzb",document.head);j=o(t,"META",{name:!0,content:!0}),t.forEach(l),ce=s(e),oe=o(e,"P",{}),pe(oe).forEach(l),ue=s(e),M(J.$$.fragment,e),me=s(e),M(h.$$.fragment,e),de=s(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-14ztba5"&&(b.innerHTML=st),Me=s(e),M(U.$$.fragment,e),ye=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-mdq459"&&(v.innerHTML=nt),fe=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-5xxju6"&&(I.innerHTML=ot),we=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-6irjuj"&&(C.textContent=rt),Te=s(e),g=o(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-1j8hlms"&&(g.innerHTML=pt),je=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1jw46aq"&&(q.innerHTML=ct),Je=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-19f2t2g"&&(k.innerHTML=ut),he=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-typm67"&&(A.innerHTML=mt),be=s(e),M(x.$$.fragment,e),Ue=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-rpkqe"&&(G.innerHTML=dt),ve=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-a1nhl0"&&(B.textContent=Mt),Ie=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-bhgks4"&&(_.innerHTML=yt),Ce=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-y2m3ta"&&($.innerHTML=ft),ge=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ixtdpr"&&(Z.innerHTML=wt),qe=s(e),M(H.$$.fragment,e),ke=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-awt8h6"&&(E.innerHTML=Tt),Ae=s(e),c=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),pe(c).forEach(l),xe=s(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-tpp1gz"&&(z.textContent=Jt),Ge=s(e),M(L.$$.fragment,e),Be=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1vk6lhf"&&(Q.textContent=ht),_e=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-dck3w8"&&(S.textContent=bt),$e=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1nrtmto"&&(W.textContent=Ut),Ze=s(e),R=o(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1p8dh6b"&&(R.innerHTML=vt),He=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-lpxldx"&&(V.innerHTML=It),Ee=s(e),M(N.$$.fragment,e),ze=s(e),u=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),pe(u).forEach(l),Le=s(e),M(X.$$.fragment,e),Qe=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1m4lcun"&&(Y.innerHTML=gt),Se=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1khz6t"&&(P.innerHTML=qt),We=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1m47pf2"&&(F.innerHTML=kt),Re=s(e),D=o(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-1x8aicu"&&(D.innerHTML=At),Ve=s(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-ozzr76"&&(K.innerHTML=xt),Ne=s(e),M(O.$$.fragment,e),Xe=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-24bysq"&&(ee.innerHTML=Gt),Ye=s(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1o4vjjv"&&(te.innerHTML=Bt),Pe=s(e),M(le.$$.fragment,e),Fe=s(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-55fg8a"&&(ae.innerHTML=_t),De=s(e),m=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),pe(m).forEach(l),Ke=s(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1c0ove0"&&(ie.innerHTML=Zt),Oe=s(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1rwz6wq"&&(se.textContent=Ht),et=s(e),re=o(e,"P",{}),pe(re).forEach(l),this.h()},h(){p(j,"name","hf:doc:metadata"),p(j,"content",Xt),lt(c.src,jt="https://course-demos-audio-reverse.hf.space")||p(c,"src",jt),p(c,"frameborder","0"),p(c,"height","250"),p(c,"title","Gradio app"),p(c,"class","container p-0 flex-grow space-iframe"),p(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),lt(u.src,Ct="https://course-demos-generate-tone.hf.space")||p(u,"src",Ct),p(u,"frameborder","0"),p(u,"height","450"),p(u,"title","Gradio app"),p(u,"class","container p-0 flex-grow space-iframe"),p(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),lt(m.src,$t="https://course-demos-asr.hf.space")||p(m,"src",$t),p(m,"frameborder","0"),p(m,"height","550"),p(m,"title","Gradio app"),p(m,"class","container p-0 flex-grow space-iframe"),p(m,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),p(m,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){Rt(document.head,j),a(e,ce,t),a(e,oe,t),a(e,ue,t),y(J,e,t),a(e,me,t),y(h,e,t),a(e,de,t),a(e,b,t),a(e,Me,t),y(U,e,t),a(e,ye,t),a(e,v,t),a(e,fe,t),a(e,I,t),a(e,we,t),a(e,C,t),a(e,Te,t),a(e,g,t),a(e,je,t),a(e,q,t),a(e,Je,t),a(e,k,t),a(e,he,t),a(e,A,t),a(e,be,t),y(x,e,t),a(e,Ue,t),a(e,G,t),a(e,ve,t),a(e,B,t),a(e,Ie,t),a(e,_,t),a(e,Ce,t),a(e,$,t),a(e,ge,t),a(e,Z,t),a(e,qe,t),y(H,e,t),a(e,ke,t),a(e,E,t),a(e,Ae,t),a(e,c,t),a(e,xe,t),a(e,z,t),a(e,Ge,t),y(L,e,t),a(e,Be,t),a(e,Q,t),a(e,_e,t),a(e,S,t),a(e,$e,t),a(e,W,t),a(e,Ze,t),a(e,R,t),a(e,He,t),a(e,V,t),a(e,Ee,t),y(N,e,t),a(e,ze,t),a(e,u,t),a(e,Le,t),y(X,e,t),a(e,Qe,t),a(e,Y,t),a(e,Se,t),a(e,P,t),a(e,We,t),a(e,F,t),a(e,Re,t),a(e,D,t),a(e,Ve,t),a(e,K,t),a(e,Ne,t),y(O,e,t),a(e,Xe,t),a(e,ee,t),a(e,Ye,t),a(e,te,t),a(e,Pe,t),y(le,e,t),a(e,Fe,t),a(e,ae,t),a(e,De,t),a(e,m,t),a(e,Ke,t),a(e,ie,t),a(e,Oe,t),a(e,se,t),a(e,et,t),a(e,re,t),tt=!0},p:zt,i(e){tt||(f(J.$$.fragment,e),f(h.$$.fragment,e),f(U.$$.fragment,e),f(x.$$.fragment,e),f(H.$$.fragment,e),f(L.$$.fragment,e),f(N.$$.fragment,e),f(X.$$.fragment,e),f(O.$$.fragment,e),f(le.$$.fragment,e),tt=!0)},o(e){w(J.$$.fragment,e),w(h.$$.fragment,e),w(U.$$.fragment,e),w(x.$$.fragment,e),w(H.$$.fragment,e),w(L.$$.fragment,e),w(N.$$.fragment,e),w(X.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),tt=!1},d(e){e&&(l(ce),l(oe),l(ue),l(me),l(de),l(b),l(Me),l(ye),l(v),l(fe),l(I),l(we),l(C),l(Te),l(g),l(je),l(q),l(Je),l(k),l(he),l(A),l(be),l(Ue),l(G),l(ve),l(B),l(Ie),l(_),l(Ce),l($),l(ge),l(Z),l(qe),l(ke),l(E),l(Ae),l(c),l(xe),l(z),l(Ge),l(Be),l(Q),l(_e),l(S),l($e),l(W),l(Ze),l(R),l(He),l(V),l(Ee),l(ze),l(u),l(Le),l(Qe),l(Y),l(Se),l(P),l(We),l(F),l(Re),l(D),l(Ve),l(K),l(Ne),l(Xe),l(ee),l(Ye),l(te),l(Pe),l(Fe),l(ae),l(De),l(m),l(Ke),l(ie),l(Oe),l(se),l(et),l(re)),l(j),T(J,e),T(h,e),T(U,e),T(x,e),T(H,e),T(L,e),T(N,e),T(X,e),T(O,e),T(le,e)}}}const Xt='{"title":"Capire la classe Interface","local":"capire-la-classe-interface","sections":[{"title":"Come creare una Interface","local":"come-creare-una-interface","sections":[],"depth":2},{"title":"Un semplice esempio con l’audio","local":"un-semplice-esempio-con-laudio","sections":[],"depth":2},{"title":"Lavorare con più input e output","local":"lavorare-con-più-input-e-output","sections":[{"title":"Il metodo launch()","local":"il-metodo-launch","sections":[],"depth":3}],"depth":2},{"title":"✏️ Mettiamolo in pratica!","local":"-mettiamolo-in-pratica","sections":[],"depth":2}],"depth":1}';function Yt(it){return Lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Qt{constructor(j){super(),St(this,j,Yt,Nt,Et,{})}}export{el as component};
