import{s as he,n as ce,o as fe}from"../chunks/scheduler.c59d9fbb.js";import{S as ue,i as ye,g as i,s,r as p,A as Te,h as o,f as l,c as n,j as Me,u as d,x as r,k as me,y as we,a,v as M,d as m,t as h,w as c}from"../chunks/index.a47918e3.js";import{C as K}from"../chunks/CodeBlock.936db8cd.js";import{H as tt}from"../chunks/Heading.604bc707.js";function je(Ht){let f,et,V,lt,u,at,y,Wt="SetFit comes with extensive automatically generated model cards/READMEs. In this how-to guide, we will explore how to make the most of this automatic generation.",st,T,qt='As an example, the <a href="https://huggingface.co/tomaarsen/setfit-all-MiniLM-L6-v2-sst2-32-shot" rel="nofollow">tomaarsen/setfit-all-MiniLM-L6-v2-sst2-32-shot</a> model has followed all steps from this guide to produce the most extensive automatically generated model card.',nt,w,it,j,Rt="Although SetFit can infer a lot of information about your model through its training and configuration, some metadata can often not be (trivially) inferred. For example:",ot,g,Nt="<li><strong>language</strong>: The model language, e.g. “en” for English.</li> <li><strong>license</strong>: The model license, e.g. “mit” or “apache-2.0”.</li> <li><strong>dataset_name</strong>: The pretty name of a dataset, e.g. “Amazon Counterfactual”.</li> <li><strong>dataset_id</strong>: The dataset ID of the dataset, e.g. “dair-ai/emotion”.</li>",rt,J,Qt='It is recommended to specify this information to the <a href="/docs/setfit/v1.0.0/en/reference/main#setfit.SetFitModel">SetFitModel</a> upon calling <code>SetFitModel.from_pretrained()</code>, to allow this information to be included in the model card and its metadata. This can be done using an <a href="/docs/setfit/v1.0.0/en/reference/main#setfit.SetFitModelCardData">SetFitModelCardData</a> instance and the <code>model_card_data</code> key-word argument, e.g. like so:',pt,C,dt,b,zt='See the <a href="/docs/setfit/v1.0.0/en/reference/main#setfit.SetFitModelCardData">SetFitModelCardData</a> documentation for more information that you can specify to be used in the README.',Mt,U,mt,I,Gt='If the labels from your training dataset are all integers, then you are recommended to provide your <a href="/docs/setfit/v1.0.0/en/reference/main#setfit.SetFitModel">SetFitModel</a> with labels. These labels can then 1) be used in inference and 2) be used in your model card. For example, if your training labels are <code>0</code> and <code>1</code> for negative and positive, respectively, then you can load your model like so:',ht,v,ct,x,Yt='When calling <a href="/docs/setfit/v1.0.0/en/reference/main#setfit.PolarityModel.predict">SetFitModel.predict()</a>, the trained model will now output strings or lists of strings, rather than your integer labels:',ft,A,ut,$,Dt="Additionally, the model card will include the labels, e.g. it will use the following table:",yt,_,Pt='<thead><tr><th align="left">Label</th> <th align="left">Examples</th></tr></thead> <tbody><tr><td align="left">negative</td> <td align="left"><ul><li>‘a tough pill to swallow and ’</li><li>‘indignation ’</li><li>‘that the typical hollywood disregard for historical truth and realism is at work here ’</li></ul></td></tr> <tr><td align="left">positive</td> <td align="left"><ul><li>“a moving experience for people who have n’t read the book ”</li><li>‘in the best possible senses of both those words ’</li><li>‘to serve the work especially well ’</li></ul></td></tr></tbody>',Tt,B,Xt="Rather than this one:",wt,S,Vt='<thead><tr><th align="left">Label</th> <th align="left">Examples</th></tr></thead> <tbody><tr><td align="left">0</td> <td align="left"><ul><li>‘a tough pill to swallow and ’</li><li>‘indignation ’</li><li>‘that the typical hollywood disregard for historical truth and realism is at work here ’</li></ul></td></tr> <tr><td align="left">1</td> <td align="left"><ul><li>“a moving experience for people who have n’t read the book ”</li><li>‘in the best possible senses of both those words ’</li><li>‘to serve the work especially well ’</li></ul></td></tr></tbody>',jt,k,Ot="And the following table:",gt,E,Kt='<thead><tr><th align="left">Label</th> <th align="left">Training Sample Count</th></tr></thead> <tbody><tr><td align="left">negative</td> <td align="left">32</td></tr> <tr><td align="left">positive</td> <td align="left">32</td></tr></tbody>',Jt,L,te="Rather than this one:",Ct,Z,ee='<thead><tr><th align="left">Label</th> <th align="left">Training Sample Count</th></tr></thead> <tbody><tr><td align="left">0</td> <td align="left">32</td></tr> <tr><td align="left">1</td> <td align="left">32</td></tr></tbody>',bt,F,Ut,H,le='The <a href="https://github.com/mlco2/codecarbon" rel="nofollow"><code>codecarbon</code></a> Python package can be installed to automatically track carbon emissions during training. This information will be included in the model card, e.g. in a list <a href="https://huggingface.co/tomaarsen/setfit-all-MiniLM-L6-v2-sst2-32-shot#environmental-impact" rel="nofollow">like so</a>:',It,W,ae="Environmental Impact",vt,q,se='Carbon emissions were measured using <a href="https://github.com/mlco2/codecarbon" rel="nofollow">CodeCarbon</a>.',xt,R,ne="<li><strong>Carbon Emitted</strong>: 0.003 kg of CO2</li> <li><strong>Hours Used</strong>: 0.072 hours</li>",At,N,$t,Q,ie="If you use custom metrics, then these will be included in your model card as well! For example, if you use the following <code>metric</code> function:",_t,z,Bt,G,oe="Then the final model card will contain your special metrics! For example, the metadata will include e.g.:",St,Y,kt,D,re="Additionally, the Evaluation section will display your metrics:",Et,P,pe="Metrics",Lt,X,de='<thead><tr><th align="left">Label</th> <th align="left">Accuracy</th> <th align="left">Precision</th> <th align="left">Recall</th> <th align="left">F1</th></tr></thead> <tbody><tr><td align="left"><strong>all</strong></td> <td align="left">0.8062</td> <td align="left">0.7294</td> <td align="left">0.9725</td> <td align="left">0.8336</td></tr></tbody>',Zt,O,Ft;return u=new tt({props:{title:"Model Cards",local:"model-cards",headingTag:"h1"}}),w=new tt({props:{title:"Specifying Metadata",local:"specifying-metadata",headingTag:"h2"}}),C=new K({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFNldEZpdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfY2FyZF9kYXRhJTNEU2V0Rml0TW9kZWxDYXJkRGF0YSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYW5ndWFnZSUzRCUyMmVuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGljZW5zZSUzRCUyMmFwYWNoZS0yLjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X2lkJTNEJTIyc3N0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRfbmFtZSUzRCUyMlNTVDIlMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel

model = SetFitModel.from_pretrained(
    <span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>,
    model_card_data=SetFitModelCardData(
        language=<span class="hljs-string">&quot;en&quot;</span>,
        license=<span class="hljs-string">&quot;apache-2.0&quot;</span>,
        dataset_id=<span class="hljs-string">&quot;sst2&quot;</span>,
        dataset_name=<span class="hljs-string">&quot;SST2&quot;</span>,
    )
)`,wrap:!1}}),U=new tt({props:{title:"Labels",local:"labels",headingTag:"h2"}}),v=new K({props:{code:"bW9kZWwlMjAlM0QlMjBTZXRGaXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyQkFBSSUyRmJnZS1zbWFsbC1lbi12MS41JTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2NhcmRfZGF0YSUzRFNldEZpdE1vZGVsQ2FyZERhdGEoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFuZ3VhZ2UlM0QlMjJlbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpY2Vuc2UlM0QlMjJhcGFjaGUtMi4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldF9pZCUzRCUyMnNzdDIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhc2V0X25hbWUlM0QlMjJTU1QyJTIyJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSk=",highlighted:`model = SetFitModel.from_pretrained(
    <span class="hljs-string">&quot;BAAI/bge-small-en-v1.5&quot;</span>,
    labels=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>],
    model_card_data=SetFitModelCardData(
        language=<span class="hljs-string">&quot;en&quot;</span>,
        license=<span class="hljs-string">&quot;apache-2.0&quot;</span>,
        dataset_id=<span class="hljs-string">&quot;sst2&quot;</span>,
        dataset_name=<span class="hljs-string">&quot;SST2&quot;</span>,
    )
)`,wrap:!1}}),A=new K({props:{code:"bW9kZWwucHJlZGljdCglNUIlMEElMjAlMjAlMjAlMjAlMjJJdCdzJTIwYSUyMGNoYXJtaW5nJTIwYW5kJTIwb2Z0ZW4lMjBhZmZlY3RpbmclMjBqb3VybmV5LiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkl0J3MlMjBzbG93JTIwLS0lMjB2ZXJ5JTJDJTIwdmVyeSUyMHNsb3cuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMHNvbWV0aW1lcyUyMHRlZGlvdXMlMjBmaWxtLiUyMiUyQyUwQSU1RCklMEElMjMlMjAlM0QlM0UlMjAlNUIncG9zaXRpdmUnJTJDJTIwJ25lZ2F0aXZlJyUyQyUyMCduZWdhdGl2ZSclNUQ=",highlighted:`model.predict([
    <span class="hljs-string">&quot;It&#x27;s a charming and often affecting journey.&quot;</span>,
    <span class="hljs-string">&quot;It&#x27;s slow -- very, very slow.&quot;</span>,
    <span class="hljs-string">&quot;A sometimes tedious film.&quot;</span>,
])
<span class="hljs-comment"># =&gt; [&#x27;positive&#x27;, &#x27;negative&#x27;, &#x27;negative&#x27;]</span>`,wrap:!1}}),F=new tt({props:{title:"Emissions Tracking",local:"emissions-tracking",headingTag:"h2"}}),N=new tt({props:{title:"Custom Metrics",local:"custom-metrics",headingTag:"h2"}}),z=new K({props:{code:"JTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> SetFitModel, Trainer, TrainingArguments

...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">y_pred, y_test</span>):
    accuracy = accuracy_score(y_test, y_pred)
    precision = precision_score(y_test, y_pred)
    recall = recall_score(y_test, y_pred)
    f1 = f1_score(y_test, y_pred)
    <span class="hljs-keyword">return</span> { <span class="hljs-string">&#x27;accuracy&#x27;</span>: accuracy, <span class="hljs-string">&#x27;precision&#x27;</span>: precision, <span class="hljs-string">&#x27;recall&#x27;</span>: recall, <span class="hljs-string">&#x27;f1&#x27;</span>: f1}

...

trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    metric=compute_metrics,
)
trainer.train()

model.save_pretrained(<span class="hljs-string">&quot;setfit-bge-small-v1.5-sst2-8-shot&quot;</span>)`,wrap:!1}}),Y=new K({props:{code:"JTIwJTIwJTIwJTIwbWV0cmljcyUzQSUwQSUyMCUyMCUyMCUyMC0lMjB0eXBlJTNBJTIwYWNjdXJhY3klMEElMjAlMjAlMjAlMjAlMjAlMjB2YWx1ZSUzQSUyMDAuODA2MTUwNDY2Nzc2NDk2NCUwQSUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlM0ElMjBBY2N1cmFjeSUwQSUyMCUyMCUyMCUyMC0lMjB0eXBlJTNBJTIwcHJlY2lzaW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwdmFsdWUlM0ElMjAwLjcyOTM3MjkzNzI5MzcyOTMlMEElMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwUHJlY2lzaW9uJTBBJTIwJTIwJTIwJTIwLSUyMHR5cGUlM0ElMjByZWNhbGwlMEElMjAlMjAlMjAlMjAlMjAlMjB2YWx1ZSUzQSUyMDAuOTcyNDk3MjQ5NzI0OTcyNSUwQSUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlM0ElMjBSZWNhbGwlMEElMjAlMjAlMjAlMjAtJTIwdHlwZSUzQSUyMGYxJTBBJTIwJTIwJTIwJTIwJTIwJTIwdmFsdWUlM0ElMjAwLjgzMzU2OTA3MTE5MjgzMzUlMEElMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwRjE=",highlighted:`    <span class="hljs-attr">metrics:</span>
    <span class="hljs-bullet">-</span> <span class="hljs-attr">type:</span> <span class="hljs-string">accuracy</span>
      <span class="hljs-attr">value:</span> <span class="hljs-number">0.8061504667764964</span>
      <span class="hljs-attr">name:</span> <span class="hljs-string">Accuracy</span>
    <span class="hljs-bullet">-</span> <span class="hljs-attr">type:</span> <span class="hljs-string">precision</span>
      <span class="hljs-attr">value:</span> <span class="hljs-number">0.7293729372937293</span>
      <span class="hljs-attr">name:</span> <span class="hljs-string">Precision</span>
    <span class="hljs-bullet">-</span> <span class="hljs-attr">type:</span> <span class="hljs-string">recall</span>
      <span class="hljs-attr">value:</span> <span class="hljs-number">0.9724972497249725</span>
      <span class="hljs-attr">name:</span> <span class="hljs-string">Recall</span>
    <span class="hljs-bullet">-</span> <span class="hljs-attr">type:</span> <span class="hljs-string">f1</span>
      <span class="hljs-attr">value:</span> <span class="hljs-number">0.8335690711928335</span>
      <span class="hljs-attr">name:</span> <span class="hljs-string">F1</span>`,wrap:!1}}),{c(){f=i("meta"),et=s(),V=i("p"),lt=s(),p(u.$$.fragment),at=s(),y=i("p"),y.textContent=Wt,st=s(),T=i("p"),T.innerHTML=qt,nt=s(),p(w.$$.fragment),it=s(),j=i("p"),j.textContent=Rt,ot=s(),g=i("ul"),g.innerHTML=Nt,rt=s(),J=i("p"),J.innerHTML=Qt,pt=s(),p(C.$$.fragment),dt=s(),b=i("p"),b.innerHTML=zt,Mt=s(),p(U.$$.fragment),mt=s(),I=i("p"),I.innerHTML=Gt,ht=s(),p(v.$$.fragment),ct=s(),x=i("p"),x.innerHTML=Yt,ft=s(),p(A.$$.fragment),ut=s(),$=i("p"),$.textContent=Dt,yt=s(),_=i("table"),_.innerHTML=Pt,Tt=s(),B=i("p"),B.textContent=Xt,wt=s(),S=i("table"),S.innerHTML=Vt,jt=s(),k=i("p"),k.textContent=Ot,gt=s(),E=i("table"),E.innerHTML=Kt,Jt=s(),L=i("p"),L.textContent=te,Ct=s(),Z=i("table"),Z.innerHTML=ee,bt=s(),p(F.$$.fragment),Ut=s(),H=i("p"),H.innerHTML=le,It=s(),W=i("h4"),W.textContent=ae,vt=s(),q=i("p"),q.innerHTML=se,xt=s(),R=i("ul"),R.innerHTML=ne,At=s(),p(N.$$.fragment),$t=s(),Q=i("p"),Q.innerHTML=ie,_t=s(),p(z.$$.fragment),Bt=s(),G=i("p"),G.textContent=oe,St=s(),p(Y.$$.fragment),kt=s(),D=i("p"),D.textContent=re,Et=s(),P=i("h4"),P.textContent=pe,Lt=s(),X=i("table"),X.innerHTML=de,Zt=s(),O=i("p"),this.h()},l(t){const e=Te("svelte-u9bgzb",document.head);f=o(e,"META",{name:!0,content:!0}),e.forEach(l),et=n(t),V=o(t,"P",{}),Me(V).forEach(l),lt=n(t),d(u.$$.fragment,t),at=n(t),y=o(t,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1owc2hy"&&(y.textContent=Wt),st=n(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-l4cdo1"&&(T.innerHTML=qt),nt=n(t),d(w.$$.fragment,t),it=n(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-nkz1ip"&&(j.textContent=Rt),ot=n(t),g=o(t,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-1ir5hx2"&&(g.innerHTML=Nt),rt=n(t),J=o(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-pwl20h"&&(J.innerHTML=Qt),pt=n(t),d(C.$$.fragment,t),dt=n(t),b=o(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1xq7j8v"&&(b.innerHTML=zt),Mt=n(t),d(U.$$.fragment,t),mt=n(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-h4t7vs"&&(I.innerHTML=Gt),ht=n(t),d(v.$$.fragment,t),ct=n(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1ixjll1"&&(x.innerHTML=Yt),ft=n(t),d(A.$$.fragment,t),ut=n(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1uzaiyk"&&($.textContent=Dt),yt=n(t),_=o(t,"TABLE",{"data-svelte-h":!0}),r(_)!=="svelte-1tq13gv"&&(_.innerHTML=Pt),Tt=n(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-ljd7a7"&&(B.textContent=Xt),wt=n(t),S=o(t,"TABLE",{"data-svelte-h":!0}),r(S)!=="svelte-74k2ga"&&(S.innerHTML=Vt),jt=n(t),k=o(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1qiqua3"&&(k.textContent=Ot),gt=n(t),E=o(t,"TABLE",{"data-svelte-h":!0}),r(E)!=="svelte-hbvayy"&&(E.innerHTML=Kt),Jt=n(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-ljd7a7"&&(L.textContent=te),Ct=n(t),Z=o(t,"TABLE",{"data-svelte-h":!0}),r(Z)!=="svelte-f17nsh"&&(Z.innerHTML=ee),bt=n(t),d(F.$$.fragment,t),Ut=n(t),H=o(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-m1sba2"&&(H.innerHTML=le),It=n(t),W=o(t,"H4",{"data-svelte-h":!0}),r(W)!=="svelte-1bng7y0"&&(W.textContent=ae),vt=n(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-yytei1"&&(q.innerHTML=se),xt=n(t),R=o(t,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1isp3jj"&&(R.innerHTML=ne),At=n(t),d(N.$$.fragment,t),$t=n(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-zqp51z"&&(Q.innerHTML=ie),_t=n(t),d(z.$$.fragment,t),Bt=n(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1skh2a2"&&(G.textContent=oe),St=n(t),d(Y.$$.fragment,t),kt=n(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1iwn7bw"&&(D.textContent=re),Et=n(t),P=o(t,"H4",{"data-svelte-h":!0}),r(P)!=="svelte-rqmqwl"&&(P.textContent=pe),Lt=n(t),X=o(t,"TABLE",{"data-svelte-h":!0}),r(X)!=="svelte-tt8ras"&&(X.innerHTML=de),Zt=n(t),O=o(t,"P",{}),Me(O).forEach(l),this.h()},h(){me(f,"name","hf:doc:metadata"),me(f,"content",ge)},m(t,e){we(document.head,f),a(t,et,e),a(t,V,e),a(t,lt,e),M(u,t,e),a(t,at,e),a(t,y,e),a(t,st,e),a(t,T,e),a(t,nt,e),M(w,t,e),a(t,it,e),a(t,j,e),a(t,ot,e),a(t,g,e),a(t,rt,e),a(t,J,e),a(t,pt,e),M(C,t,e),a(t,dt,e),a(t,b,e),a(t,Mt,e),M(U,t,e),a(t,mt,e),a(t,I,e),a(t,ht,e),M(v,t,e),a(t,ct,e),a(t,x,e),a(t,ft,e),M(A,t,e),a(t,ut,e),a(t,$,e),a(t,yt,e),a(t,_,e),a(t,Tt,e),a(t,B,e),a(t,wt,e),a(t,S,e),a(t,jt,e),a(t,k,e),a(t,gt,e),a(t,E,e),a(t,Jt,e),a(t,L,e),a(t,Ct,e),a(t,Z,e),a(t,bt,e),M(F,t,e),a(t,Ut,e),a(t,H,e),a(t,It,e),a(t,W,e),a(t,vt,e),a(t,q,e),a(t,xt,e),a(t,R,e),a(t,At,e),M(N,t,e),a(t,$t,e),a(t,Q,e),a(t,_t,e),M(z,t,e),a(t,Bt,e),a(t,G,e),a(t,St,e),M(Y,t,e),a(t,kt,e),a(t,D,e),a(t,Et,e),a(t,P,e),a(t,Lt,e),a(t,X,e),a(t,Zt,e),a(t,O,e),Ft=!0},p:ce,i(t){Ft||(m(u.$$.fragment,t),m(w.$$.fragment,t),m(C.$$.fragment,t),m(U.$$.fragment,t),m(v.$$.fragment,t),m(A.$$.fragment,t),m(F.$$.fragment,t),m(N.$$.fragment,t),m(z.$$.fragment,t),m(Y.$$.fragment,t),Ft=!0)},o(t){h(u.$$.fragment,t),h(w.$$.fragment,t),h(C.$$.fragment,t),h(U.$$.fragment,t),h(v.$$.fragment,t),h(A.$$.fragment,t),h(F.$$.fragment,t),h(N.$$.fragment,t),h(z.$$.fragment,t),h(Y.$$.fragment,t),Ft=!1},d(t){t&&(l(et),l(V),l(lt),l(at),l(y),l(st),l(T),l(nt),l(it),l(j),l(ot),l(g),l(rt),l(J),l(pt),l(dt),l(b),l(Mt),l(mt),l(I),l(ht),l(ct),l(x),l(ft),l(ut),l($),l(yt),l(_),l(Tt),l(B),l(wt),l(S),l(jt),l(k),l(gt),l(E),l(Jt),l(L),l(Ct),l(Z),l(bt),l(Ut),l(H),l(It),l(W),l(vt),l(q),l(xt),l(R),l(At),l($t),l(Q),l(_t),l(Bt),l(G),l(St),l(kt),l(D),l(Et),l(P),l(Lt),l(X),l(Zt),l(O)),l(f),c(u,t),c(w,t),c(C,t),c(U,t),c(v,t),c(A,t),c(F,t),c(N,t),c(z,t),c(Y,t)}}}const ge='{"title":"Model Cards","local":"model-cards","sections":[{"title":"Specifying Metadata","local":"specifying-metadata","sections":[],"depth":2},{"title":"Labels","local":"labels","sections":[],"depth":2},{"title":"Emissions Tracking","local":"emissions-tracking","sections":[],"depth":2},{"title":"Custom Metrics","local":"custom-metrics","sections":[],"depth":2}],"depth":1}';function Je(Ht){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ve extends ue{constructor(f){super(),ye(this,f,Je,je,he,{})}}export{ve as component};
