import{s as is,f as ns,o as rs,n as cl}from"../chunks/scheduler.f6319a2a.js";import{S as Ms,i as ps,g as a,s as o,r as p,A as us,h as i,f as l,c as n,j as as,u,x as r,k as pl,y as cs,a as s,v as c,d as m,t as d,w as y}from"../chunks/index.85aa684c.js";import{T as ul}from"../chunks/Tip.3d397a88.js";import{C as T}from"../chunks/CodeBlock.3400fc53.js";import{D as ms}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as g,E as ds}from"../chunks/getInferenceSnippets.743412b2.js";function ys(j){let M,U='If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.';return{c(){M=a("p"),M.innerHTML=U},l(h){M=i(h,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1p1d9vw"&&(M.innerHTML=U)},m(h,b){s(h,M,b)},p:cl,d(h){h&&l(M)}}}function hs(j){let M,U=`<strong>Security Warning:</strong> Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.
Using MCP servers comes with security risks:`,h,b,f="<li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers:</strong> While remote MCP servers will not execute code on your machine, still proceed with caution.</li>";return{c(){M=a("p"),M.innerHTML=U,h=o(),b=a("ul"),b.innerHTML=f},l(w){M=i(w,"P",{"data-svelte-h":!0}),r(M)!=="svelte-t3a0vm"&&(M.innerHTML=U),h=n(w),b=i(w,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-gohv2x"&&(b.innerHTML=f)},m(w,J){s(w,M,J),s(w,h,J),s(w,b,J)},p:cl,d(w){w&&(l(M),l(h),l(b))}}}function bs(j){let M,U="Beware of not adding too many tools to an agent: this can overwhelm weaker LLM engines.";return{c(){M=a("p"),M.textContent=U},l(h){M=i(h,"P",{"data-svelte-h":!0}),r(M)!=="svelte-h9mzfm"&&(M.textContent=U)},m(h,b){s(h,M,b)},p:cl,d(h){h&&l(M)}}}function ws(j){let M,U=`<strong>Security Warning:</strong> Always verify the source and integrity of any MCP server before connecting to it, especially for production environments.
Using MCP servers comes with security risks:`,h,b,f="<li><strong>Trust is essential:</strong> Only use MCP servers from trusted sources. Malicious servers can execute harmful code on your machine.</li> <li><strong>Stdio-based MCP servers</strong> will always execute code on your machine (that’s their intended functionality).</li> <li><strong>Streamable HTTP-based MCP servers:</strong> While remote MCP servers will not execute code on your machine, still proceed with caution.</li>";return{c(){M=a("p"),M.innerHTML=U,h=o(),b=a("ul"),b.innerHTML=f},l(w){M=i(w,"P",{"data-svelte-h":!0}),r(M)!=="svelte-t3a0vm"&&(M.innerHTML=U),h=n(w),b=i(w,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-gohv2x"&&(b.innerHTML=f)},m(w,J){s(w,M,J),s(w,h,J),s(w,b,J)},p:cl,d(w){w&&(l(M),l(h),l(b))}}}function Us(j){let M,U,h,b,f,w,J,Ae,$,ml="Here, we’re going to see advanced tool usage.",Xe,C,Ye,B,ze,W,dl="A tool is mostly a function that an LLM can use in an agentic system.",Fe,G,yl="But to use it, the LLM will need to be given an API: name, tool description, input types and descriptions, output type.",Pe,_,hl="So it cannot be only a function. It should be a class.",Le,Q,bl="So at core, the tool is a class that wraps a function with metadata that helps the LLM understand how to use it.",De,k,wl="Here’s how it looks:",Ke,H,Oe,x,Ul='The custom tool subclasses <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.Tool">Tool</a> to inherit useful methods. The child class also defines:',et,V,Tl='<li>An attribute <code>name</code>, which corresponds to the name of the tool itself. The name usually describes what the tool does. Since the code returns the model with the most downloads for a task, let’s name it <code>model_download_counter</code>.</li> <li>An attribute <code>description</code> is used to populate the agent’s system prompt.</li> <li>An <code>inputs</code> attribute, which is a dictionary with keys <code>&quot;type&quot;</code> and <code>&quot;description&quot;</code>. It contains information that helps the Python interpreter make educated choices about the input.</li> <li>An <code>output_type</code> attribute, which specifies the output type. The types for both <code>inputs</code> and <code>output_type</code> should be <a href="https://docs.pydantic.dev/latest/concepts/json_schema/#generating-json-schema" rel="nofollow">Pydantic formats</a>, they can be either of these: <code>~AUTHORIZED_TYPES()</code>.</li> <li>A <code>forward</code> method which contains the inference code to be executed.</li>',tt,R,Jl="And that’s all it needs to be used in an agent!",lt,N,fl='There’s another way to build a tool. In the <a href="../guided_tour">guided_tour</a>, we implemented a tool using the <code>@tool</code> decorator. The <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.tool">tool()</a> decorator is the recommended way to define simple tools, but sometimes you need more than this: using several methods in a class for more clarity, or using additional class attributes.',st,E,jl='In this case, you can build your tool by subclassing <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.Tool">Tool</a> as described above.',ot,S,nt,q,gl='You can share your custom tool to the Hub as a Space repository by calling <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> on the tool. Make sure you’ve created a repository for it on the Hub and are using a token with read access.',at,A,it,X,Cl="For the push to Hub to work, your tool will need to respect some rules:",rt,Y,vl='<li>All methods are self-contained, e.g. use variables that come either from their args.</li> <li>As per the above point, <strong>all imports should be defined directly within the tool’s functions</strong>, else you will get an error when trying to call <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.Tool.save">save()</a> or <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.Tool.push_to_hub">push_to_hub()</a> with your custom tool.</li> <li>If you subclass the <code>__init__</code> method, you can give it no other argument than <code>self</code>. This is because arguments set during a specific tool instance’s initialization are hard to track, which prevents from sharing them properly to the hub. And anyway, the idea of making a specific class is that you can already set class attributes for anything you need to hard-code (just set <code>your_variable=(...)</code> directly under the <code>class YourTool(Tool):</code> line). And of course you can still create a class attribute anywhere in your code by assigning stuff to <code>self.your_variable</code>.</li>',Mt,z,Il='Once your tool is pushed to Hub, you can visualize it. <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads" rel="nofollow">Here</a> is the <code>model_downloads_tool</code> that I’ve pushed. It has a nice gradio interface.',pt,F,Zl='When diving into the tool files, you can find that all the tool’s logic is under <a href="https://huggingface.co/spaces/m-ric/hf-model-downloads/blob/main/tool.py" rel="nofollow">tool.py</a>. That is where you can inspect a tool shared by someone else.',ut,P,$l=`Then you can load the tool with <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.load_tool">load_tool()</a> or create it with <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.Tool.from_hub">from_hub()</a> and pass it to the <code>tools</code> parameter in your agent.
Since running tools means running custom code, you need to make sure you trust the repository, thus we require to pass <code>trust_remote_code=True</code> to load a tool from the Hub.`,ct,L,mt,D,dt,K,Bl="Our <code>MCPClient</code> allows you to load tools from an MCP server, and gives you full control over the connection and tool management:",yt,O,Wl="For stdio-based MCP servers:",ht,ee,bt,te,Gl="For Streamable HTTP-based MCP servers:",wt,le,Ut,se,_l="You can also manually manage the connection lifecycle with the try…finally pattern:",Tt,oe,Jt,ne,Ql="You can also connect to multiple MCP servers at once by passing a list of server parameters:",ft,ae,jt,v,gt,ie,Ct,re,kl='You can directly import a Gradio Space from the Hub as a tool using the <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.Tool.from_space">Tool.from_space()</a> method!',vt,Me,Hl='You only need to provide the id of the Space on the Hub, its name, and a description that will help your agent understand what the tool does. Under the hood, this will use <a href="https://pypi.org/project/gradio-client/" rel="nofollow"><code>gradio-client</code></a> library to call the Space.',It,pe,xl='For instance, let’s import the <a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow">FLUX.1-dev</a> Space from the Hub and use it to generate an image.',Zt,ue,$t,ce,Vl="And voilà, here’s your image! 🏖️",Bt,Ee,Rl,Wt,me,Nl="Then you can use this tool just like any other tool.  For example, let’s improve the prompt <code>a rabbit wearing a space suit</code> and generate an image of it. This example also shows how you can pass additional arguments to the agent.",Gt,de,_t,ye,Qt,Se,El,kt,he,Sl="How cool is this? 🤩",Ht,be,xt,we,ql=`We love Langchain and think it has a very compelling suite of tools.
To import a tool from LangChain, use the <code>from_langchain()</code> method.`,Vt,Ue,Al=`Here is how you can use it to recreate the intro’s search result using a LangChain web search tool.
This tool will need <code>pip install langchain google-search-results -q</code> to work properly.`,Rt,Te,Nt,Je,Et,fe,Xl="You can manage an agent’s toolbox by adding or replacing a tool in attribute <code>agent.tools</code>, since it is a standard dictionary.",St,je,Yl="Let’s add the <code>model_download_tool</code> to an existing agent initialized with only the default toolbox.",qt,ge,At,Ce,zl="Now we can leverage the new tool:",Xt,ve,Yt,I,zt,Ie,Ft,Ze,Fl='You can leverage tool collections by using <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.ToolCollection">ToolCollection</a>. It supports loading either a collection from the Hub or an MCP server tools.',Pt,$e,Lt,Be,Pl='Leverage tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai/" rel="nofollow">smithery.ai</a>.',Dt,We,Ll='The MCP servers tools can be loaded with <a href="/docs/smolagents/v1.21.2/en/reference/tools#smolagents.ToolCollection.from_mcp">ToolCollection.from_mcp()</a>.',Kt,Z,Ot,Ge,Dl="For stdio-based MCP servers, pass the server parameters as an instance of <code>mcp.StdioServerParameters</code>:",el,_e,tl,Qe,Kl="For Streamable HTTP-based MCP servers, simply pass a dict with parameters to <code>mcp.client.streamable_http.streamablehttp_client</code> and add the key <code>transport</code> with the value <code>&quot;streamable-http&quot;</code>:",ll,ke,sl,He,ol,xe,Ol=`You can leverage it with the slug of the collection you want to use.
Then pass them as a list to initialize your agent, and start using them!`,nl,Ve,al,Re,es="To speed up the start, tools are loaded only if called by the agent.",il,Ne,rl,qe,Ml;return f=new g({props:{title:"Tools",local:"tools",headingTag:"h1"}}),J=new ms({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tools.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/tools.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/tools.ipynb"}]}}),C=new ul({props:{warning:!1,$$slots:{default:[ys]},$$scope:{ctx:j}}}),B=new g({props:{title:"What is a tool, and how to build one?",local:"what-is-a-tool-and-how-to-build-one",headingTag:"h3"}}),H=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBY2xhc3MlMjBIRk1vZGVsRG93bmxvYWRzVG9vbChUb29sKSUzQSUwQSUyMCUyMCUyMCUyMG5hbWUlMjAlM0QlMjAlMjJtb2RlbF9kb3dubG9hZF9jb3VudGVyJTIyJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lMjAlM0QlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBUaGlzJTIwaXMlMjBhJTIwdG9vbCUyMHRoYXQlMjByZXR1cm5zJTIwdGhlJTIwbW9zdCUyMGRvd25sb2FkZWQlMjBtb2RlbCUyMG9mJTIwYSUyMGdpdmVuJTIwdGFzayUyMG9uJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIuJTBBJTIwJTIwJTIwJTIwSXQlMjByZXR1cm5zJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2hlY2twb2ludC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0YXNrJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIydGhlJTIwdGFzayUyMGNhdGVnb3J5JTIwKHN1Y2glMjBhcyUyMHRleHQtY2xhc3NpZmljYXRpb24lMkMlMjBkZXB0aC1lc3RpbWF0aW9uJTJDJTIwZXRjKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTIwJTNEJTIwJTIyc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGFzayUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG5leHQoaXRlcihsaXN0X21vZGVscyhmaWx0ZXIlM0R0YXNrJTJDJTIwc29ydCUzRCUyMmRvd25sb2FkcyUyMiUyQyUyMGRpcmVjdGlvbiUzRC0xKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbW9kZWwuaWQlMEElMEFtb2RlbF9kb3dubG9hZHNfdG9vbCUyMCUzRCUyMEhGTW9kZWxEb3dubG9hZHNUb29sKCk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">HFModelDownloadsTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;model_download_counter&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This is a tool that returns the most downloaded model of a given task on the Hugging Face Hub.
    It returns the name of the checkpoint.&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;task&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the task category (such as text-classification, depth-estimation, etc)&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, task: <span class="hljs-built_in">str</span></span>):
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_models

        model = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(list_models(<span class="hljs-built_in">filter</span>=task, sort=<span class="hljs-string">&quot;downloads&quot;</span>, direction=-<span class="hljs-number">1</span>)))
        <span class="hljs-keyword">return</span> model.<span class="hljs-built_in">id</span>

model_downloads_tool = HFModelDownloadsTool()`,wrap:!1}}),S=new g({props:{title:"Share your tool to the Hub",local:"share-your-tool-to-the-hub",headingTag:"h3"}}),A=new T({props:{code:"bW9kZWxfZG93bmxvYWRzX3Rvb2wucHVzaF90b19odWIoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRmhmLW1vZGVsLWRvd25sb2FkcyUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'model_downloads_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),L=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMEElMEFtb2RlbF9kb3dubG9hZF90b29sJTIwJTNEJTIwbG9hZF90b29sKCUwQSUyMCUyMCUyMCUyMCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZoZi1tb2RlbC1kb3dubG9hZHMlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent

model_download_tool = load_tool(
    <span class="hljs-string">&quot;{your_username}/hf-model-downloads&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)`,wrap:!1}}),D=new g({props:{title:"Use tools from an MCP server",local:"use-tools-from-an-mcp-server",headingTag:"h3"}}),ee=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTIwJTIwJTIzJTIwVXNpbmclMjB1dnglMjBlbnN1cmVzJTIwZGVwZW5kZW5jaWVzJTIwYXJlJTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyME1DUENsaWVudChzZXJ2ZXJfcGFyYW1ldGVycyklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGZpbmQlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMG9uJTIwQ09WSUQtMTklMjB0cmVhdG1lbnQuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,  <span class="hljs-comment"># Using uvx ensures dependencies are available</span>
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> MCPClient(server_parameters) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find the latest research on COVID-19 treatment.&quot;</span>)`,wrap:!1}}),le=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEElMEF3aXRoJTIwTUNQQ2xpZW50KCU3QiUyMnVybCUyMiUzQSUyMCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDAwJTJGbWNwJTIyJTJDJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTIyc3RyZWFtYWJsZS1odHRwJTIyJTdEKSUyMGFzJTIwdG9vbHMlM0ElMEElMjAlMjAlMjAlMjBhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRHRvb2xzJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent

<span class="hljs-keyword">with</span> MCPClient({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),oe=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEElMjMlMjBJbml0aWFsaXplJTIwc2VydmVyJTIwcGFyYW1ldGVycyUwQXNlcnZlcl9wYXJhbWV0ZXJzJTIwJTNEJTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzKCUwQSUyMCUyMCUyMCUyMGNvbW1hbmQlM0QlMjJ1dnglMjIlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEJTVCJTIyLS1xdWlldCUyMiUyQyUyMCUyMnB1Ym1lZG1jcCU0MDAuMS4zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZW52JTNEJTdCJTIyVVZfUFlUSE9OJTIyJTNBJTIwJTIyMy4xMiUyMiUyQyUyMCoqb3MuZW52aXJvbiU3RCUyQyUwQSklMEElMEElMjMlMjBNYW51YWxseSUyMG1hbmFnZSUyMHRoZSUyMGNvbm5lY3Rpb24lMEF0cnklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50JTIwJTNEJTIwTUNQQ2xpZW50KHNlcnZlcl9wYXJhbWV0ZXJzKSUwQSUyMCUyMCUyMCUyMHRvb2xzJTIwJTNEJTIwbWNwX2NsaWVudC5nZXRfdG9vbHMoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMHRoZSUyMHRvb2xzJTIwd2l0aCUyMHlvdXIlMjBhZ2VudCUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEdG9vbHMlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMGFnZW50LnJ1biglMjJXaGF0JTIwYXJlJTIwdGhlJTIwcmVjZW50JTIwdGhlcmFwZXV0aWMlMjBhcHByb2FjaGVzJTIwZm9yJTIwQWx6aGVpbWVyJ3MlMjBkaXNlYXNlJTNGJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFByb2Nlc3MlMjB0aGUlMjByZXN1bHQlMjBhcyUyMG5lZWRlZCUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJBZ2VudCUyMHJlc3BvbnNlJTNBJTIwJTdCcmVzdWx0JTdEJTIyKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBbHdheXMlMjBlbnN1cmUlMjB0aGUlMjBjb25uZWN0aW9uJTIwaXMlMjBwcm9wZXJseSUyMGNsb3NlZCUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQuZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Initialize server parameters</span>
server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-comment"># Manually manage the connection</span>
<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(server_parameters)
    tools = mcp_client.get_tools()

    <span class="hljs-comment"># Use the tools with your agent</span>
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    result = agent.run(<span class="hljs-string">&quot;What are the recent therapeutic approaches for Alzheimer&#x27;s disease?&quot;</span>)

    <span class="hljs-comment"># Process the result as needed</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Agent response: <span class="hljs-subst">{result}</span>&quot;</span>)
<span class="hljs-keyword">finally</span>:
    <span class="hljs-comment"># Always ensure the connection is properly closed</span>
    mcp_client.disconnect()`,wrap:!1}}),ae=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBNQ1BDbGllbnQlMkMlMjBDb2RlQWdlbnQlMEFmcm9tJTIwbWNwJTIwaW1wb3J0JTIwU3RkaW9TZXJ2ZXJQYXJhbWV0ZXJzJTBBaW1wb3J0JTIwb3MlMEElMEFzZXJ2ZXJfcGFyYW1zMSUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBc2VydmVyX3BhcmFtczIlMjAlM0QlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRnNzZSUyMiU3RCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTVCc2VydmVyX3BhcmFtczElMkMlMjBzZXJ2ZXJfcGFyYW1zMiU1RCklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0R0b29scyUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMGFuYWx5emUlMjB0aGUlMjBsYXRlc3QlMjByZXNlYXJjaCUyMGFuZCUyMHN1Z2dlc3QlMjByZW1lZGllcyUyMGZvciUyMGhlYWRhY2hlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> MCPClient, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">import</span> os

server_params1 = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

server_params2 = {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/sse&quot;</span>}

<span class="hljs-keyword">with</span> MCPClient([server_params1, server_params2]) <span class="hljs-keyword">as</span> tools:
    agent = CodeAgent(tools=tools, model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please analyze the latest research and suggest remedies for headaches.&quot;</span>)`,wrap:!1}}),v=new ul({props:{warning:!0,$$slots:{default:[hs]},$$scope:{ctx:j}}}),ie=new g({props:{title:"Import a Space as a tool",local:"import-a-space-as-a-tool",headingTag:"h3"}}),ue=new T({props:{code:"aW1hZ2VfZ2VuZXJhdGlvbl90b29sJTIwJTNEJTIwVG9vbC5mcm9tX3NwYWNlKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyaW1hZ2VfZ2VuZXJhdG9yJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJHZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBmcm9tJTIwYSUyMHByb21wdCUyMiUwQSklMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2woJTIyQSUyMHN1bm55JTIwYmVhY2glMjIp",highlighted:`image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

image_generation_tool(<span class="hljs-string">&quot;A sunny beach&quot;</span>)`,wrap:!1}}),de=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMEElMjAlMjAlMjAlMjAlMjJJbXByb3ZlJTIwdGhpcyUyMHByb21wdCUyQyUyMHRoZW4lMjBnZW5lcmF0ZSUyMGFuJTIwaW1hZ2UlMjBvZiUyMGl0LiUyMiUyQyUyMGFkZGl0aW9uYWxfYXJncyUzRCU3Qid1c2VyX3Byb21wdCclM0ElMjAnQSUyMHJhYmJpdCUyMHdlYXJpbmclMjBhJTIwc3BhY2UlMjBzdWl0JyU3RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)
agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>, additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A rabbit wearing a space suit&#x27;</span>}
)`,wrap:!1}}),ye=new T({props:{code:"JTBBQWdlbnQlMjBpcyUyMGV4ZWN1dGluZyUyMHRoZSUyMGNvZGUlMjBiZWxvdyUzQQ==",highlighted:`=== Agent thoughts:
improved_prompt could be &quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;

Now that I have improved the prompt, I can use the image generator tool to generate an image based on this prompt.
&gt;&gt;&gt; Agent is executing the code below:
image = image_generator(prompt=&quot;A bright blue space suit wearing rabbit, on the surface of the moon, under a bright orange sunset, with the Earth visible in the background&quot;)
final_answer(image)`,wrap:!1}}),be=new g({props:{title:"Use LangChain tools",local:"use-langchain-tools",headingTag:"h3"}}),Te=new T({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCc2VhcmNoX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKSUwQSUwQWFnZW50LnJ1biglMjJIb3clMjBtYW55JTIwbW9yZSUyMGJsb2NrcyUyMChhbHNvJTIwZGVub3RlZCUyMGFzJTIwbGF5ZXJzKSUyMGFyZSUyMGluJTIwQkVSVCUyMGJhc2UlMjBlbmNvZGVyJTIwY29tcGFyZWQlMjB0byUyMHRoZSUyMGVuY29kZXIlMjBmcm9tJTIwdGhlJTIwYXJjaGl0ZWN0dXJlJTIwcHJvcG9zZWQlMjBpbiUyMEF0dGVudGlvbiUyMGlzJTIwQWxsJTIwWW91JTIwTmVlZCUzRiUyMik=",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;How many more blocks (also denoted as layers) are in BERT base encoder compared to the encoder from the architecture proposed in Attention is All You Need?&quot;</span>)`,wrap:!1}}),Je=new g({props:{title:"Manage your agent’s toolbox",local:"manage-your-agents-toolbox",headingTag:"h3"}}),ge=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS1Db2Rlci0zMkItSW5zdHJ1Y3QlMjIpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkX2Jhc2VfdG9vbHMlM0RUcnVlKSUwQWFnZW50LnRvb2xzJTVCbW9kZWxfZG93bmxvYWRfdG9vbC5uYW1lJTVEJTIwJTNEJTIwbW9kZWxfZG93bmxvYWRfdG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel

model = InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[], model=model, add_base_tools=<span class="hljs-literal">True</span>)
agent.tools[model_download_tool.name] = model_download_tool`,wrap:!1}}),ve=new T({props:{code:"YWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwdGhhdCUyMGhhcyUyMHRoZSUyMG1vc3QlMjBkb3dubG9hZHMlMjBpbiUyMHRoZSUyMCd0ZXh0LXRvLXZpZGVvJyUyMHRhc2slMjBvbiUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwYnV0JTIwcmV2ZXJzZSUyMHRoZSUyMGxldHRlcnMlM0YlMjIlMEEp",highlighted:`agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the model that has the most downloads in the &#x27;text-to-video&#x27; task on the Hugging Face Hub but reverse the letters?&quot;</span>
)`,wrap:!1}}),I=new ul({props:{warning:!1,$$slots:{default:[bs]},$$scope:{ctx:j}}}),Ie=new g({props:{title:"Use a collection of tools",local:"use-a-collection-of-tools",headingTag:"h3"}}),$e=new g({props:{title:"Tool Collection from any MCP server",local:"tool-collection-from-any-mcp-server",headingTag:"h4"}}),Z=new ul({props:{warning:!0,$$slots:{default:[ws]},$$scope:{ctx:j}}}),_e=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQWZyb20lMjBtY3AlMjBpbXBvcnQlMjBTdGRpb1NlcnZlclBhcmFtZXRlcnMlMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters

server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),ke=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBUb29sQ29sbGVjdGlvbi5mcm9tX21jcCglN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODAwMCUyRm1jcCUyMiUyQyUyMCUyMnRyYW5zcG9ydCUyMiUzQSUyMCUyMnN0cmVhbWFibGUtaHR0cCUyMiU3RCUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMjBhcyUyMHRvb2xfY29sbGVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMGFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCKnRvb2xfY29sbGVjdGlvbi50b29scyU1RCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

<span class="hljs-keyword">with</span> ToolCollection.from_mcp({<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://127.0.0.1:8000/mcp&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;streamable-http&quot;</span>}, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),He=new g({props:{title:"Tool Collection from a collection in the Hub",local:"tool-collection-from-a-collection-in-the-hub",headingTag:"h4"}}),Ve=new T({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBUb29sQ29sbGVjdGlvbiUyQyUyMENvZGVBZ2VudCUwQSUwQWltYWdlX3Rvb2xfY29sbGVjdGlvbiUyMCUzRCUyMFRvb2xDb2xsZWN0aW9uLmZyb21faHViKCUwQSUyMCUyMCUyMCUyMGNvbGxlY3Rpb25fc2x1ZyUzRCUyMmh1Z2dpbmdmYWNlLXRvb2xzJTJGZGlmZnVzaW9uLXRvb2xzLTY2MzBiYjE5YTk0MmMyMzA2YTJjZGI2ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIlMEEpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqaW1hZ2VfdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMEFhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent

image_tool_collection = ToolCollection.from_hub(
    collection_slug=<span class="hljs-string">&quot;huggingface-tools/diffusion-tools-6630bb19a942c2306a2cdb6f&quot;</span>,
    token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>
)
agent = CodeAgent(tools=[*image_tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)

agent.run(<span class="hljs-string">&quot;Please draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),Ne=new ds({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/tools.md"}}),{c(){M=a("meta"),U=o(),h=a("p"),b=o(),p(f.$$.fragment),w=o(),p(J.$$.fragment),Ae=o(),$=a("p"),$.textContent=ml,Xe=o(),p(C.$$.fragment),Ye=o(),p(B.$$.fragment),ze=o(),W=a("p"),W.textContent=dl,Fe=o(),G=a("p"),G.textContent=yl,Pe=o(),_=a("p"),_.textContent=hl,Le=o(),Q=a("p"),Q.textContent=bl,De=o(),k=a("p"),k.textContent=wl,Ke=o(),p(H.$$.fragment),Oe=o(),x=a("p"),x.innerHTML=Ul,et=o(),V=a("ul"),V.innerHTML=Tl,tt=o(),R=a("p"),R.textContent=Jl,lt=o(),N=a("p"),N.innerHTML=fl,st=o(),E=a("p"),E.innerHTML=jl,ot=o(),p(S.$$.fragment),nt=o(),q=a("p"),q.innerHTML=gl,at=o(),p(A.$$.fragment),it=o(),X=a("p"),X.textContent=Cl,rt=o(),Y=a("ul"),Y.innerHTML=vl,Mt=o(),z=a("p"),z.innerHTML=Il,pt=o(),F=a("p"),F.innerHTML=Zl,ut=o(),P=a("p"),P.innerHTML=$l,ct=o(),p(L.$$.fragment),mt=o(),p(D.$$.fragment),dt=o(),K=a("p"),K.innerHTML=Bl,yt=o(),O=a("p"),O.textContent=Wl,ht=o(),p(ee.$$.fragment),bt=o(),te=a("p"),te.textContent=Gl,wt=o(),p(le.$$.fragment),Ut=o(),se=a("p"),se.textContent=_l,Tt=o(),p(oe.$$.fragment),Jt=o(),ne=a("p"),ne.textContent=Ql,ft=o(),p(ae.$$.fragment),jt=o(),p(v.$$.fragment),gt=o(),p(ie.$$.fragment),Ct=o(),re=a("p"),re.innerHTML=kl,vt=o(),Me=a("p"),Me.innerHTML=Hl,It=o(),pe=a("p"),pe.innerHTML=xl,Zt=o(),p(ue.$$.fragment),$t=o(),ce=a("p"),ce.textContent=Vl,Bt=o(),Ee=a("img"),Wt=o(),me=a("p"),me.innerHTML=Nl,Gt=o(),p(de.$$.fragment),_t=o(),p(ye.$$.fragment),Qt=o(),Se=a("img"),kt=o(),he=a("p"),he.textContent=Sl,Ht=o(),p(be.$$.fragment),xt=o(),we=a("p"),we.innerHTML=ql,Vt=o(),Ue=a("p"),Ue.innerHTML=Al,Rt=o(),p(Te.$$.fragment),Nt=o(),p(Je.$$.fragment),Et=o(),fe=a("p"),fe.innerHTML=Xl,St=o(),je=a("p"),je.innerHTML=Yl,qt=o(),p(ge.$$.fragment),At=o(),Ce=a("p"),Ce.textContent=zl,Xt=o(),p(ve.$$.fragment),Yt=o(),p(I.$$.fragment),zt=o(),p(Ie.$$.fragment),Ft=o(),Ze=a("p"),Ze.innerHTML=Fl,Pt=o(),p($e.$$.fragment),Lt=o(),Be=a("p"),Be.innerHTML=Pl,Dt=o(),We=a("p"),We.innerHTML=Ll,Kt=o(),p(Z.$$.fragment),Ot=o(),Ge=a("p"),Ge.innerHTML=Dl,el=o(),p(_e.$$.fragment),tl=o(),Qe=a("p"),Qe.innerHTML=Kl,ll=o(),p(ke.$$.fragment),sl=o(),p(He.$$.fragment),ol=o(),xe=a("p"),xe.textContent=Ol,nl=o(),p(Ve.$$.fragment),al=o(),Re=a("p"),Re.textContent=es,il=o(),p(Ne.$$.fragment),rl=o(),qe=a("p"),this.h()},l(e){const t=us("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(l),U=n(e),h=i(e,"P",{}),as(h).forEach(l),b=n(e),u(f.$$.fragment,e),w=n(e),u(J.$$.fragment,e),Ae=n(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-8951oz"&&($.textContent=ml),Xe=n(e),u(C.$$.fragment,e),Ye=n(e),u(B.$$.fragment,e),ze=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-50z9h0"&&(W.textContent=dl),Fe=n(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1llqfcr"&&(G.textContent=yl),Pe=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-eilpgu"&&(_.textContent=hl),Le=n(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-suz7fy"&&(Q.textContent=bl),De=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-x18ywb"&&(k.textContent=wl),Ke=n(e),u(H.$$.fragment,e),Oe=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-19wvtm2"&&(x.innerHTML=Ul),et=n(e),V=i(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-xqgwuf"&&(V.innerHTML=Tl),tt=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-220ayw"&&(R.textContent=Jl),lt=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1yyxkym"&&(N.innerHTML=fl),st=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-144wzsk"&&(E.innerHTML=jl),ot=n(e),u(S.$$.fragment,e),nt=n(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1wp96dx"&&(q.innerHTML=gl),at=n(e),u(A.$$.fragment,e),it=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-hoocvd"&&(X.textContent=Cl),rt=n(e),Y=i(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-14ee4ml"&&(Y.innerHTML=vl),Mt=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-4n5s3c"&&(z.innerHTML=Il),pt=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1knl8v8"&&(F.innerHTML=Zl),ut=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-ebqbts"&&(P.innerHTML=$l),ct=n(e),u(L.$$.fragment,e),mt=n(e),u(D.$$.fragment,e),dt=n(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-eofyyc"&&(K.innerHTML=Bl),yt=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1en3ihe"&&(O.textContent=Wl),ht=n(e),u(ee.$$.fragment,e),bt=n(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1ro6hjz"&&(te.textContent=Gl),wt=n(e),u(le.$$.fragment,e),Ut=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1and4a8"&&(se.textContent=_l),Tt=n(e),u(oe.$$.fragment,e),Jt=n(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-7q6kbi"&&(ne.textContent=Ql),ft=n(e),u(ae.$$.fragment,e),jt=n(e),u(v.$$.fragment,e),gt=n(e),u(ie.$$.fragment,e),Ct=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-hq155q"&&(re.innerHTML=kl),vt=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-17wa58l"&&(Me.innerHTML=Hl),It=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1gucs20"&&(pe.innerHTML=xl),Zt=n(e),u(ue.$$.fragment,e),$t=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-sgspwr"&&(ce.textContent=Vl),Bt=n(e),Ee=i(e,"IMG",{src:!0}),Wt=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1y8rl57"&&(me.innerHTML=Nl),Gt=n(e),u(de.$$.fragment,e),_t=n(e),u(ye.$$.fragment,e),Qt=n(e),Se=i(e,"IMG",{src:!0}),kt=n(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-i5dtbz"&&(he.textContent=Sl),Ht=n(e),u(be.$$.fragment,e),xt=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1rq40pf"&&(we.innerHTML=ql),Vt=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1g7jkvd"&&(Ue.innerHTML=Al),Rt=n(e),u(Te.$$.fragment,e),Nt=n(e),u(Je.$$.fragment,e),Et=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-69p3x"&&(fe.innerHTML=Xl),St=n(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-ocb8u2"&&(je.innerHTML=Yl),qt=n(e),u(ge.$$.fragment,e),At=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-o3ledg"&&(Ce.textContent=zl),Xt=n(e),u(ve.$$.fragment,e),Yt=n(e),u(I.$$.fragment,e),zt=n(e),u(Ie.$$.fragment,e),Ft=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-12d8mln"&&(Ze.innerHTML=Fl),Pt=n(e),u($e.$$.fragment,e),Lt=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1q39vf"&&(Be.innerHTML=Pl),Dt=n(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-meervh"&&(We.innerHTML=Ll),Kt=n(e),u(Z.$$.fragment,e),Ot=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-s0gh2b"&&(Ge.innerHTML=Dl),el=n(e),u(_e.$$.fragment,e),tl=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-j0i0xh"&&(Qe.innerHTML=Kl),ll=n(e),u(ke.$$.fragment,e),sl=n(e),u(He.$$.fragment,e),ol=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-qubpc6"&&(xe.textContent=Ol),nl=n(e),u(Ve.$$.fragment,e),al=n(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-6r1jgt"&&(Re.textContent=es),il=n(e),u(Ne.$$.fragment,e),rl=n(e),qe=i(e,"P",{}),as(qe).forEach(l),this.h()},h(){pl(M,"name","hf:doc:metadata"),pl(M,"content",Ts),ns(Ee.src,Rl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/sunny_beach.webp")||pl(Ee,"src",Rl),ns(Se.src,El="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit_spacesuit_flux.webp")||pl(Se,"src",El)},m(e,t){cs(document.head,M),s(e,U,t),s(e,h,t),s(e,b,t),c(f,e,t),s(e,w,t),c(J,e,t),s(e,Ae,t),s(e,$,t),s(e,Xe,t),c(C,e,t),s(e,Ye,t),c(B,e,t),s(e,ze,t),s(e,W,t),s(e,Fe,t),s(e,G,t),s(e,Pe,t),s(e,_,t),s(e,Le,t),s(e,Q,t),s(e,De,t),s(e,k,t),s(e,Ke,t),c(H,e,t),s(e,Oe,t),s(e,x,t),s(e,et,t),s(e,V,t),s(e,tt,t),s(e,R,t),s(e,lt,t),s(e,N,t),s(e,st,t),s(e,E,t),s(e,ot,t),c(S,e,t),s(e,nt,t),s(e,q,t),s(e,at,t),c(A,e,t),s(e,it,t),s(e,X,t),s(e,rt,t),s(e,Y,t),s(e,Mt,t),s(e,z,t),s(e,pt,t),s(e,F,t),s(e,ut,t),s(e,P,t),s(e,ct,t),c(L,e,t),s(e,mt,t),c(D,e,t),s(e,dt,t),s(e,K,t),s(e,yt,t),s(e,O,t),s(e,ht,t),c(ee,e,t),s(e,bt,t),s(e,te,t),s(e,wt,t),c(le,e,t),s(e,Ut,t),s(e,se,t),s(e,Tt,t),c(oe,e,t),s(e,Jt,t),s(e,ne,t),s(e,ft,t),c(ae,e,t),s(e,jt,t),c(v,e,t),s(e,gt,t),c(ie,e,t),s(e,Ct,t),s(e,re,t),s(e,vt,t),s(e,Me,t),s(e,It,t),s(e,pe,t),s(e,Zt,t),c(ue,e,t),s(e,$t,t),s(e,ce,t),s(e,Bt,t),s(e,Ee,t),s(e,Wt,t),s(e,me,t),s(e,Gt,t),c(de,e,t),s(e,_t,t),c(ye,e,t),s(e,Qt,t),s(e,Se,t),s(e,kt,t),s(e,he,t),s(e,Ht,t),c(be,e,t),s(e,xt,t),s(e,we,t),s(e,Vt,t),s(e,Ue,t),s(e,Rt,t),c(Te,e,t),s(e,Nt,t),c(Je,e,t),s(e,Et,t),s(e,fe,t),s(e,St,t),s(e,je,t),s(e,qt,t),c(ge,e,t),s(e,At,t),s(e,Ce,t),s(e,Xt,t),c(ve,e,t),s(e,Yt,t),c(I,e,t),s(e,zt,t),c(Ie,e,t),s(e,Ft,t),s(e,Ze,t),s(e,Pt,t),c($e,e,t),s(e,Lt,t),s(e,Be,t),s(e,Dt,t),s(e,We,t),s(e,Kt,t),c(Z,e,t),s(e,Ot,t),s(e,Ge,t),s(e,el,t),c(_e,e,t),s(e,tl,t),s(e,Qe,t),s(e,ll,t),c(ke,e,t),s(e,sl,t),c(He,e,t),s(e,ol,t),s(e,xe,t),s(e,nl,t),c(Ve,e,t),s(e,al,t),s(e,Re,t),s(e,il,t),c(Ne,e,t),s(e,rl,t),s(e,qe,t),Ml=!0},p(e,[t]){const ts={};t&2&&(ts.$$scope={dirty:t,ctx:e}),C.$set(ts);const ls={};t&2&&(ls.$$scope={dirty:t,ctx:e}),v.$set(ls);const ss={};t&2&&(ss.$$scope={dirty:t,ctx:e}),I.$set(ss);const os={};t&2&&(os.$$scope={dirty:t,ctx:e}),Z.$set(os)},i(e){Ml||(m(f.$$.fragment,e),m(J.$$.fragment,e),m(C.$$.fragment,e),m(B.$$.fragment,e),m(H.$$.fragment,e),m(S.$$.fragment,e),m(A.$$.fragment,e),m(L.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(ae.$$.fragment,e),m(v.$$.fragment,e),m(ie.$$.fragment,e),m(ue.$$.fragment,e),m(de.$$.fragment,e),m(ye.$$.fragment,e),m(be.$$.fragment,e),m(Te.$$.fragment,e),m(Je.$$.fragment,e),m(ge.$$.fragment,e),m(ve.$$.fragment,e),m(I.$$.fragment,e),m(Ie.$$.fragment,e),m($e.$$.fragment,e),m(Z.$$.fragment,e),m(_e.$$.fragment,e),m(ke.$$.fragment,e),m(He.$$.fragment,e),m(Ve.$$.fragment,e),m(Ne.$$.fragment,e),Ml=!0)},o(e){d(f.$$.fragment,e),d(J.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(H.$$.fragment,e),d(S.$$.fragment,e),d(A.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(oe.$$.fragment,e),d(ae.$$.fragment,e),d(v.$$.fragment,e),d(ie.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(ye.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),d(Je.$$.fragment,e),d(ge.$$.fragment,e),d(ve.$$.fragment,e),d(I.$$.fragment,e),d(Ie.$$.fragment,e),d($e.$$.fragment,e),d(Z.$$.fragment,e),d(_e.$$.fragment,e),d(ke.$$.fragment,e),d(He.$$.fragment,e),d(Ve.$$.fragment,e),d(Ne.$$.fragment,e),Ml=!1},d(e){e&&(l(U),l(h),l(b),l(w),l(Ae),l($),l(Xe),l(Ye),l(ze),l(W),l(Fe),l(G),l(Pe),l(_),l(Le),l(Q),l(De),l(k),l(Ke),l(Oe),l(x),l(et),l(V),l(tt),l(R),l(lt),l(N),l(st),l(E),l(ot),l(nt),l(q),l(at),l(it),l(X),l(rt),l(Y),l(Mt),l(z),l(pt),l(F),l(ut),l(P),l(ct),l(mt),l(dt),l(K),l(yt),l(O),l(ht),l(bt),l(te),l(wt),l(Ut),l(se),l(Tt),l(Jt),l(ne),l(ft),l(jt),l(gt),l(Ct),l(re),l(vt),l(Me),l(It),l(pe),l(Zt),l($t),l(ce),l(Bt),l(Ee),l(Wt),l(me),l(Gt),l(_t),l(Qt),l(Se),l(kt),l(he),l(Ht),l(xt),l(we),l(Vt),l(Ue),l(Rt),l(Nt),l(Et),l(fe),l(St),l(je),l(qt),l(At),l(Ce),l(Xt),l(Yt),l(zt),l(Ft),l(Ze),l(Pt),l(Lt),l(Be),l(Dt),l(We),l(Kt),l(Ot),l(Ge),l(el),l(tl),l(Qe),l(ll),l(sl),l(ol),l(xe),l(nl),l(al),l(Re),l(il),l(rl),l(qe)),l(M),y(f,e),y(J,e),y(C,e),y(B,e),y(H,e),y(S,e),y(A,e),y(L,e),y(D,e),y(ee,e),y(le,e),y(oe,e),y(ae,e),y(v,e),y(ie,e),y(ue,e),y(de,e),y(ye,e),y(be,e),y(Te,e),y(Je,e),y(ge,e),y(ve,e),y(I,e),y(Ie,e),y($e,e),y(Z,e),y(_e,e),y(ke,e),y(He,e),y(Ve,e),y(Ne,e)}}}const Ts='{"title":"Tools","local":"tools","sections":[{"title":"What is a tool, and how to build one?","local":"what-is-a-tool-and-how-to-build-one","sections":[],"depth":3},{"title":"Share your tool to the Hub","local":"share-your-tool-to-the-hub","sections":[],"depth":3},{"title":"Use tools from an MCP server","local":"use-tools-from-an-mcp-server","sections":[],"depth":3},{"title":"Import a Space as a tool","local":"import-a-space-as-a-tool","sections":[],"depth":3},{"title":"Use LangChain tools","local":"use-langchain-tools","sections":[],"depth":3},{"title":"Manage your agent’s toolbox","local":"manage-your-agents-toolbox","sections":[],"depth":3},{"title":"Use a collection of tools","local":"use-a-collection-of-tools","sections":[{"title":"Tool Collection from any MCP server","local":"tool-collection-from-any-mcp-server","sections":[],"depth":4},{"title":"Tool Collection from a collection in the Hub","local":"tool-collection-from-a-collection-in-the-hub","sections":[],"depth":4}],"depth":3}],"depth":1}';function Js(j){return rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zs extends Ms{constructor(M){super(),ps(this,M,Js,Us,is,{})}}export{Zs as component};
