import{s as Dt,o as Kt,n as Pt}from"../chunks/scheduler.7da89386.js";import{S as te,i as ee,g as p,s as n,r as u,A as le,h as o,f as l,c as s,j as Ot,u as c,x as y,k as tt,y as ae,a,v as M,d as r,t as d,w as h}from"../chunks/index.20910acc.js";import{T as Lt}from"../chunks/Tip.53e22153.js";import{C as j}from"../chunks/CodeBlock.143bd81e.js";import{H as D}from"../chunks/getInferenceSnippets.3bc14635.js";function ne(P){let i,T=`You can read the <a href="../../concept_guides/quantization">conceptual guide on quantization</a> to learn about quantization. It
explains the main concepts that you will be using when performing quantization with the
<a href="/docs/optimum/main/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a>.`;return{c(){i=p("p"),i.innerHTML=T},l(m){i=o(m,"P",{"data-svelte-h":!0}),y(i)!=="svelte-mncod"&&(i.innerHTML=T)},m(m,b){a(m,i,b)},p:Pt,d(m){m&&l(i)}}}function se(P){let i,T="Currently, only dynamic quantization is supported for Seq2Seq models.";return{c(){i=p("p"),i.textContent=T},l(m){i=o(m,"P",{"data-svelte-h":!0}),y(i)!=="svelte-1s2u00l"&&(i.textContent=T)},m(m,b){a(m,i,b)},p:Pt,d(m){m&&l(i)}}}function ie(P){let i,T,m,b,R,et,C,Gt=`🤗 Optimum provides an <code>optimum.onnxruntime</code> package that enables you to apply quantization on many models hosted on
the Hugging Face Hub using the <a href="https://github.com/microsoft/onnxruntime/blob/master/onnxruntime/python/tools/quantization/README.md" rel="nofollow">ONNX Runtime</a>
quantization tool.`,lt,Z,Ft=`The quantization process is abstracted via the <a href="/docs/optimum/main/en/onnxruntime/package_reference/configuration#optimum.onnxruntime.ORTConfig">ORTConfig</a> and
the <a href="/docs/optimum/main/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> classes. The former allows you to specify how quantization should be done,
while the latter effectively handles quantization.`,at,U,nt,W,st,X,Qt="The Optimum ONNX Runtime quantization tool can be used through Optimum command-line interface:",it,z,pt,I,_t="Quantizing an ONNX model can be done as follows:",ot,v,mt,G,Bt="This quantize all the ONNX files in <code>onnx_model_location</code> with the AVX-512 instructions.",ut,F,ct,Q,qt=`The <a href="/docs/optimum/main/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> class is used to quantize your ONNX model. The class can be initialized using
the <code>from_pretrained()</code> method, which supports different checkpoint formats.`,Mt,_,$t="<li>Using an already initialized <code>ORTModelForXXX</code> class.</li>",rt,B,dt,w,Vt="<li>Using a local ONNX model from a directory.</li>",ht,q,yt,$,Tt,V,kt=`The <a href="/docs/optimum/main/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> class can be used to quantize dynamically your ONNX model. Below you will
find an easy end-to-end example on how to quantize dynamically
<a href="https://huggingface.co/distilbert-base-uncased-finetuned-sst-2-english" rel="nofollow">distilbert-base-uncased-finetuned-sst-2-english</a>.`,jt,k,bt,x,Ut,N,xt=`The <a href="/docs/optimum/main/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> class can be used to quantize statically your ONNX model. Below you will find
an easy end-to-end example on how to quantize statically
<a href="https://huggingface.co/distilbert-base-uncased-finetuned-sst-2-english" rel="nofollow">distilbert-base-uncased-finetuned-sst-2-english</a>.`,wt,A,Jt,S,ft,E,Nt=`The <a href="/docs/optimum/main/en/onnxruntime/package_reference/quantization#optimum.onnxruntime.ORTQuantizer">ORTQuantizer</a> class currently doesn’t support multi-file models, like
<a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModelForSeq2SeqLM">ORTModelForSeq2SeqLM</a>. If you want to quantize a Seq2Seq model, you have to quantize each
model’s component individually.`,gt,J,Rt,Y,At="<li>Load seq2seq model as <code>ORTModelForSeq2SeqLM</code>.</li>",Ct,H,Zt,f,St="<li>Define Quantizer for encoder, decoder and decoder with past keys</li>",Wt,O,Xt,g,Et="<li>Quantize all models</li>",zt,L,It,K,vt;return R=new D({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),U=new Lt({props:{$$slots:{default:[ne]},$$scope:{ctx:P}}}),W=new D({props:{title:"Quantizing a model to be used with Optimum’s CLI",local:"quantizing-a-model-to-be-used-with-optimums-cli",headingTag:"h2"}}),z=new j({props:{code:"b3B0aW11bS1jbGklMjBvbm54cnVudGltZSUyMHF1YW50aXplJTIwLS1oZWxwJTBBdXNhZ2UlM0ElMjBvcHRpbXVtLWNsaSUyMCUzQ2NvbW1hbmQlM0UlMjAlNUIlM0NhcmdzJTNFJTVEJTIwb25ueHJ1bnRpbWUlMjBxdWFudGl6ZSUyMCU1Qi1oJTVEJTIwLS1vbm54X21vZGVsJTIwT05OWF9NT0RFTCUyMC1vJTIwT1VUUFVUJTIwJTVCLS1wZXJfY2hhbm5lbCU1RCUyMCgtLWFybTY0JTIwJTdDJTIwLS1hdngyJTIwJTdDJTIwLS1hdng1MTIlMjAlN0MlMjAtLWF2eDUxMl92bm5pJTIwJTdDJTIwLS10ZW5zb3JydCUyMCU3QyUyMC1jJTIwQ09ORklHKSUwQSUwQW9wdGlvbnMlM0ElMEElMjAlMjAtaCUyQyUyMC0taGVscCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNob3clMjB0aGlzJTIwaGVscCUyMG1lc3NhZ2UlMjBhbmQlMjBleGl0JTBBJTIwJTIwLS1hcm02NCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFF1YW50aXphdGlvbiUyMGZvciUyMHRoZSUyMEFSTTY0JTIwYXJjaGl0ZWN0dXJlLiUwQSUyMCUyMC0tYXZ4MiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFF1YW50aXphdGlvbiUyMHdpdGglMjBBVlgtMiUyMGluc3RydWN0aW9ucy4lMEElMjAlMjAtLWF2eDUxMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFF1YW50aXphdGlvbiUyMHdpdGglMjBBVlgtNTEyJTIwaW5zdHJ1Y3Rpb25zLiUwQSUyMCUyMC0tYXZ4NTEyX3ZubmklMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBRdWFudGl6YXRpb24lMjB3aXRoJTIwQVZYLTUxMiUyMGFuZCUyMFZOTkklMjBpbnN0cnVjdGlvbnMuJTBBJTIwJTIwLS10ZW5zb3JydCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFF1YW50aXphdGlvbiUyMGZvciUyME5WSURJQSUyMFRlbnNvclJUJTIwb3B0aW1pemVyLiUwQSUyMCUyMC1jJTIwQ09ORklHJTJDJTIwLS1jb25maWclMjBDT05GSUclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNjBPUlRDb25maWclNjAlMjBmaWxlJTIwdG8lMjB1c2UlMjB0byUyMG9wdGltaXplJTIwdGhlJTIwbW9kZWwuJTBBJTBBUmVxdWlyZWQlMjBhcmd1bWVudHMlM0ElMEElMjAlMjAtLW9ubnhfbW9kZWwlMjBPTk5YX01PREVMJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUGF0aCUyMHRvJTIwdGhlJTIwcmVwb3NpdG9yeSUyMHdoZXJlJTIwdGhlJTIwT05OWCUyMG1vZGVscyUyMHRvJTIwcXVhbnRpemUlMjBhcmUlMjBsb2NhdGVkLiUwQSUyMCUyMC1vJTIwT1VUUFVUJTJDJTIwLS1vdXRwdXQlMjBPVVRQVVQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBQYXRoJTIwdG8lMjB0aGUlMjBkaXJlY3RvcnklMjB3aGVyZSUyMHRvJTIwc3RvcmUlMjBnZW5lcmF0ZWQlMjBPTk5YJTIwbW9kZWwuJTBBJTBBT3B0aW9uYWwlMjBhcmd1bWVudHMlM0ElMEElMjAlMjAtLXBlcl9jaGFubmVsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQ29tcHV0ZSUyMHRoZSUyMHF1YW50aXphdGlvbiUyMHBhcmFtZXRlcnMlMjBvbiUyMGElMjBwZXItY2hhbm5lbCUyMGJhc2lzLiUwQQ==",highlighted:`optimum-cli onnxruntime quantize --<span class="hljs-built_in">help</span>
usage: optimum-cli &lt;<span class="hljs-built_in">command</span>&gt; [&lt;args&gt;] onnxruntime quantize [-h] --onnx_model ONNX_MODEL -o OUTPUT [--per_channel] (--arm64 | --avx2 | --avx512 | --avx512_vnni | --tensorrt | -c CONFIG)

options:
  -h, --<span class="hljs-built_in">help</span>            show this <span class="hljs-built_in">help</span> message and <span class="hljs-built_in">exit</span>
  --arm64               Quantization <span class="hljs-keyword">for</span> the ARM64 architecture.
  --avx2                Quantization with AVX-2 instructions.
  --avx512              Quantization with AVX-512 instructions.
  --avx512_vnni         Quantization with AVX-512 and VNNI instructions.
  --tensorrt            Quantization <span class="hljs-keyword">for</span> NVIDIA TensorRT optimizer.
  -c CONFIG, --config CONFIG
                        \`ORTConfig\` file to use to optimize the model.

Required arguments:
  --onnx_model ONNX_MODEL
                        Path to the repository <span class="hljs-built_in">where</span> the ONNX models to quantize are located.
  -o OUTPUT, --output OUTPUT
                        Path to the directory <span class="hljs-built_in">where</span> to store generated ONNX model.

Optional arguments:
  --per_channel         Compute the quantization parameters on a per-channel basis.
`,wrap:!1}}),v=new j({props:{code:"JTIwb3B0aW11bS1jbGklMjBvbm54cnVudGltZSUyMHF1YW50aXplJTIwLS1vbm54X21vZGVsJTIwb25ueF9tb2RlbF9sb2NhdGlvbiUyRiUyMC0tYXZ4NTEyJTIwLW8lMjBxdWFudGl6ZWRfbW9kZWwlMkY=",highlighted:" optimum-cli onnxruntime quantize --onnx_model onnx_model_location/ --avx512 -o quantized_model/",wrap:!1}}),F=new D({props:{title:"Creating an ORTQuantizer",local:"creating-an-ortquantizer",headingTag:"h2"}}),B=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRRdWFudGl6ZXIlMkMlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQSklMEElMEFxdWFudGl6ZXIlMjAlM0QlMjBPUlRRdWFudGl6ZXIuZnJvbV9wcmV0cmFpbmVkKG9ydF9tb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer, ORTModelForSequenceClassification

<span class="hljs-comment"># Loading ONNX Model from the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Create a quantizer from a ORTModelForXXX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(ort_model)`,wrap:!1}}),q=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRRdWFudGl6ZXIlMEElMEFxdWFudGl6ZXIlMjAlM0QlMjBPUlRRdWFudGl6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnBhdGglMkZ0byUyRm1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer

<span class="hljs-comment"># This assumes a model.onnx exists in path/to/model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(<span class="hljs-string">&quot;path/to/model&quot;</span>)`,wrap:!1}}),$=new D({props:{title:"Apply Dynamic Quantization",local:"apply-dynamic-quantization",headingTag:"h2"}}),k=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRRdWFudGl6ZXIlMkMlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZS5jb25maWd1cmF0aW9uJTIwaW1wb3J0JTIwQXV0b1F1YW50aXphdGlvbkNvbmZpZyUwQSUwQW9ubnhfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFxdWFudGl6ZXIlMjAlM0QlMjBPUlRRdWFudGl6ZXIuZnJvbV9wcmV0cmFpbmVkKG9ubnhfbW9kZWwpJTBBJTBBZHFjb25maWclMjAlM0QlMjBBdXRvUXVhbnRpemF0aW9uQ29uZmlnLmF2eDUxMl92bm5pKGlzX3N0YXRpYyUzREZhbHNlJTJDJTIwcGVyX2NoYW5uZWwlM0RGYWxzZSklMEElMEFtb2RlbF9xdWFudGl6ZWRfcGF0aCUyMCUzRCUyMHF1YW50aXplci5xdWFudGl6ZSglMEElMjAlMjAlMjAlMjBzYXZlX2RpciUzRCUyMnBhdGglMkZ0byUyRm91dHB1dCUyRm1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGRxY29uZmlnJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer, ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig

<span class="hljs-comment"># Load PyTorch model and convert to ONNX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Create quantizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(onnx_model)

<span class="hljs-comment"># Define the quantization strategy by creating the appropriate configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dqconfig = AutoQuantizationConfig.avx512_vnni(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Quantize the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_quantized_path = quantizer.quantize(
<span class="hljs-meta">... </span>    save_dir=<span class="hljs-string">&quot;path/to/output/model&quot;</span>,
<span class="hljs-meta">... </span>    quantization_config=dqconfig,
<span class="hljs-meta">... </span>)`,wrap:!1}}),x=new D({props:{title:"Static Quantization example",local:"static-quantization-example",headingTag:"h2"}}),A=new j({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUUXVhbnRpemVyJTJDJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyMEF1dG9RdWFudGl6YXRpb25Db25maWclMkMlMjBBdXRvQ2FsaWJyYXRpb25Db25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTBBJTBBb25ueF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXF1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQob25ueF9tb2RlbCklMEFxY29uZmlnJTIwJTNEJTIwQXV0b1F1YW50aXphdGlvbkNvbmZpZy5hcm02NChpc19zdGF0aWMlM0RUcnVlJTJDJTIwcGVyX2NoYW5uZWwlM0RGYWxzZSklMEElMEFkZWYlMjBwcmVwcm9jZXNzX2ZuKGV4JTJDJTIwdG9rZW5pemVyKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplcihleCU1QiUyMnNlbnRlbmNlJTIyJTVEKSUwQSUwQWNhbGlicmF0aW9uX2RhdGFzZXQlMjAlM0QlMjBxdWFudGl6ZXIuZ2V0X2NhbGlicmF0aW9uX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIyZ2x1ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfY29uZmlnX25hbWUlM0QlMjJzc3QyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcHJlcHJvY2Vzc19mdW5jdGlvbiUzRHBhcnRpYWwocHJlcHJvY2Vzc19mbiUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMkMlMEElMjAlMjAlMjAlMjBudW1fc2FtcGxlcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF9zcGxpdCUzRCUyMnRyYWluJTIyJTJDJTBBKSUwQSUwQWNhbGlicmF0aW9uX2NvbmZpZyUyMCUzRCUyMEF1dG9DYWxpYnJhdGlvbkNvbmZpZy5taW5tYXgoY2FsaWJyYXRpb25fZGF0YXNldCklMEElMEFyYW5nZXMlMjAlM0QlMjBxdWFudGl6ZXIuZml0KCUwQSUyMCUyMCUyMCUyMGRhdGFzZXQlM0RjYWxpYnJhdGlvbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwY2FsaWJyYXRpb25fY29uZmlnJTNEY2FsaWJyYXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwb3BlcmF0b3JzX3RvX3F1YW50aXplJTNEcWNvbmZpZy5vcGVyYXRvcnNfdG9fcXVhbnRpemUlMkMlMEEpJTBBJTBBbW9kZWxfcXVhbnRpemVkX3BhdGglMjAlM0QlMjBxdWFudGl6ZXIucXVhbnRpemUoJTBBJTIwJTIwJTIwJTIwc2F2ZV9kaXIlM0QlMjJwYXRoJTJGdG8lMkZvdXRwdXQlMkZtb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMGNhbGlicmF0aW9uX3RlbnNvcnNfcmFuZ2UlM0RyYW5nZXMlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcWNvbmZpZyUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer, ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig, AutoCalibrationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>

<span class="hljs-comment"># Load PyTorch model and convert to ONNX and create Quantizer and setup config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_model = ORTModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(onnx_model)
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">True</span>, per_channel=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Create the calibration dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_fn</span>(<span class="hljs-params">ex, tokenizer</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(ex[<span class="hljs-string">&quot;sentence&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>calibration_dataset = quantizer.get_calibration_dataset(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;glue&quot;</span>,
<span class="hljs-meta">... </span>    dataset_config_name=<span class="hljs-string">&quot;sst2&quot;</span>,
<span class="hljs-meta">... </span>    preprocess_function=partial(preprocess_fn, tokenizer=tokenizer),
<span class="hljs-meta">... </span>    num_samples=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    dataset_split=<span class="hljs-string">&quot;train&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Create the calibration configuration containing the parameters related to calibration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>calibration_config = AutoCalibrationConfig.minmax(calibration_dataset)

<span class="hljs-comment"># Perform the calibration step: computes the activations quantization ranges</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ranges = quantizer.fit(
<span class="hljs-meta">... </span>    dataset=calibration_dataset,
<span class="hljs-meta">... </span>    calibration_config=calibration_config,
<span class="hljs-meta">... </span>    operators_to_quantize=qconfig.operators_to_quantize,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Apply static quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_quantized_path = quantizer.quantize(
<span class="hljs-meta">... </span>    save_dir=<span class="hljs-string">&quot;path/to/output/model&quot;</span>,
<span class="hljs-meta">... </span>    calibration_tensors_range=ranges,
<span class="hljs-meta">... </span>    quantization_config=qconfig,
<span class="hljs-meta">... </span>)`,wrap:!1}}),S=new D({props:{title:"Quantize Seq2Seq models",local:"quantize-seq2seq-models",headingTag:"h2"}}),J=new Lt({props:{warning:!0,$$slots:{default:[se]},$$scope:{ctx:P}}}),H=new j({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRRdWFudGl6ZXIlMkMlMjBPUlRNb2RlbEZvclNlcTJTZXFMTSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lLmNvbmZpZ3VyYXRpb24lMjBpbXBvcnQlMjBBdXRvUXVhbnRpemF0aW9uQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIlMEFvbm54X21vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQW1vZGVsX2RpciUyMCUzRCUyMG9ubnhfbW9kZWwubW9kZWxfc2F2ZV9kaXI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer, ORTModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig

<span class="hljs-comment"># load Seq2Seq model and set model file directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;optimum/t5-small&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_model = ORTModelForSeq2SeqLM.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_dir = onnx_model.model_save_dir`,wrap:!1}}),O=new j({props:{code:"ZW5jb2Rlcl9xdWFudGl6ZXIlMjAlM0QlMjBPUlRRdWFudGl6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2RpciUyQyUyMGZpbGVfbmFtZSUzRCUyMmVuY29kZXJfbW9kZWwub25ueCUyMiklMEElMEFkZWNvZGVyX3F1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfZGlyJTJDJTIwZmlsZV9uYW1lJTNEJTIyZGVjb2Rlcl9tb2RlbC5vbm54JTIyKSUwQSUwQWRlY29kZXJfd3BfcXVhbnRpemVyJTIwJTNEJTIwT1JUUXVhbnRpemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9kaXIlMkMlMjBmaWxlX25hbWUlM0QlMjJkZWNvZGVyX3dpdGhfcGFzdF9tb2RlbC5vbm54JTIyKSUwQSUwQXF1YW50aXplciUyMCUzRCUyMCU1QmVuY29kZXJfcXVhbnRpemVyJTJDJTIwZGVjb2Rlcl9xdWFudGl6ZXIlMkMlMjBkZWNvZGVyX3dwX3F1YW50aXplciU1RA==",highlighted:`<span class="hljs-comment"># Create encoder quantizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_quantizer = ORTQuantizer.from_pretrained(model_dir, file_name=<span class="hljs-string">&quot;encoder_model.onnx&quot;</span>)

<span class="hljs-comment"># Create decoder quantizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_quantizer = ORTQuantizer.from_pretrained(model_dir, file_name=<span class="hljs-string">&quot;decoder_model.onnx&quot;</span>)

<span class="hljs-comment"># Create decoder with past key values quantizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_wp_quantizer = ORTQuantizer.from_pretrained(model_dir, file_name=<span class="hljs-string">&quot;decoder_with_past_model.onnx&quot;</span>)

<span class="hljs-comment"># Create Quantizer list</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = [encoder_quantizer, decoder_quantizer, decoder_wp_quantizer]`,wrap:!1}}),L=new j({props:{code:"ZHFjb25maWclMjAlM0QlMjBBdXRvUXVhbnRpemF0aW9uQ29uZmlnLmF2eDUxMl92bm5pKGlzX3N0YXRpYyUzREZhbHNlJTJDJTIwcGVyX2NoYW5uZWwlM0RGYWxzZSklMEElMEFmb3IlMjBxJTIwaW4lMjBxdWFudGl6ZXIlM0ElMEElMjAlMjAlMjAlMjBxLnF1YW50aXplKHNhdmVfZGlyJTNEJTIyLiUyMiUyQ3F1YW50aXphdGlvbl9jb25maWclM0RkcWNvbmZpZyklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCSUdOT1JFX1JFU1VMVA==",highlighted:`<span class="hljs-comment"># Define the quantization strategy by creating the appropriate configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dqconfig = AutoQuantizationConfig.avx512_vnni(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)

<span class="hljs-comment"># Quantize the models individually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> q <span class="hljs-keyword">in</span> quantizer:
<span class="hljs-meta">... </span>    q.quantize(save_dir=<span class="hljs-string">&quot;.&quot;</span>,quantization_config=dqconfig)  <span class="hljs-comment"># doctest: +IGNORE_RESULT</span>`,wrap:!1}}),{c(){i=p("meta"),T=n(),m=p("p"),b=n(),u(R.$$.fragment),et=n(),C=p("p"),C.innerHTML=Gt,lt=n(),Z=p("p"),Z.innerHTML=Ft,at=n(),u(U.$$.fragment),nt=n(),u(W.$$.fragment),st=n(),X=p("p"),X.textContent=Qt,it=n(),u(z.$$.fragment),pt=n(),I=p("p"),I.textContent=_t,ot=n(),u(v.$$.fragment),mt=n(),G=p("p"),G.innerHTML=Bt,ut=n(),u(F.$$.fragment),ct=n(),Q=p("p"),Q.innerHTML=qt,Mt=n(),_=p("ol"),_.innerHTML=$t,rt=n(),u(B.$$.fragment),dt=n(),w=p("ol"),w.innerHTML=Vt,ht=n(),u(q.$$.fragment),yt=n(),u($.$$.fragment),Tt=n(),V=p("p"),V.innerHTML=kt,jt=n(),u(k.$$.fragment),bt=n(),u(x.$$.fragment),Ut=n(),N=p("p"),N.innerHTML=xt,wt=n(),u(A.$$.fragment),Jt=n(),u(S.$$.fragment),ft=n(),E=p("p"),E.innerHTML=Nt,gt=n(),u(J.$$.fragment),Rt=n(),Y=p("ol"),Y.innerHTML=At,Ct=n(),u(H.$$.fragment),Zt=n(),f=p("ol"),f.innerHTML=St,Wt=n(),u(O.$$.fragment),Xt=n(),g=p("ol"),g.innerHTML=Et,zt=n(),u(L.$$.fragment),It=n(),K=p("p"),this.h()},l(t){const e=le("svelte-u9bgzb",document.head);i=o(e,"META",{name:!0,content:!0}),e.forEach(l),T=s(t),m=o(t,"P",{}),Ot(m).forEach(l),b=s(t),c(R.$$.fragment,t),et=s(t),C=o(t,"P",{"data-svelte-h":!0}),y(C)!=="svelte-wazzwm"&&(C.innerHTML=Gt),lt=s(t),Z=o(t,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-nds7k4"&&(Z.innerHTML=Ft),at=s(t),c(U.$$.fragment,t),nt=s(t),c(W.$$.fragment,t),st=s(t),X=o(t,"P",{"data-svelte-h":!0}),y(X)!=="svelte-rew7gv"&&(X.textContent=Qt),it=s(t),c(z.$$.fragment,t),pt=s(t),I=o(t,"P",{"data-svelte-h":!0}),y(I)!=="svelte-7tptkq"&&(I.textContent=_t),ot=s(t),c(v.$$.fragment,t),mt=s(t),G=o(t,"P",{"data-svelte-h":!0}),y(G)!=="svelte-q209i"&&(G.innerHTML=Bt),ut=s(t),c(F.$$.fragment,t),ct=s(t),Q=o(t,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-1pwylaj"&&(Q.innerHTML=qt),Mt=s(t),_=o(t,"OL",{"data-svelte-h":!0}),y(_)!=="svelte-prnl7i"&&(_.innerHTML=$t),rt=s(t),c(B.$$.fragment,t),dt=s(t),w=o(t,"OL",{start:!0,"data-svelte-h":!0}),y(w)!=="svelte-s0fljy"&&(w.innerHTML=Vt),ht=s(t),c(q.$$.fragment,t),yt=s(t),c($.$$.fragment,t),Tt=s(t),V=o(t,"P",{"data-svelte-h":!0}),y(V)!=="svelte-pvjuls"&&(V.innerHTML=kt),jt=s(t),c(k.$$.fragment,t),bt=s(t),c(x.$$.fragment,t),Ut=s(t),N=o(t,"P",{"data-svelte-h":!0}),y(N)!=="svelte-17z7rcc"&&(N.innerHTML=xt),wt=s(t),c(A.$$.fragment,t),Jt=s(t),c(S.$$.fragment,t),ft=s(t),E=o(t,"P",{"data-svelte-h":!0}),y(E)!=="svelte-uddd5z"&&(E.innerHTML=Nt),gt=s(t),c(J.$$.fragment,t),Rt=s(t),Y=o(t,"OL",{"data-svelte-h":!0}),y(Y)!=="svelte-o17da9"&&(Y.innerHTML=At),Ct=s(t),c(H.$$.fragment,t),Zt=s(t),f=o(t,"OL",{start:!0,"data-svelte-h":!0}),y(f)!=="svelte-vmrglm"&&(f.innerHTML=St),Wt=s(t),c(O.$$.fragment,t),Xt=s(t),g=o(t,"OL",{start:!0,"data-svelte-h":!0}),y(g)!=="svelte-1lobl21"&&(g.innerHTML=Et),zt=s(t),c(L.$$.fragment,t),It=s(t),K=o(t,"P",{}),Ot(K).forEach(l),this.h()},h(){tt(i,"name","hf:doc:metadata"),tt(i,"content",pe),tt(w,"start","2"),tt(f,"start","2"),tt(g,"start","3")},m(t,e){ae(document.head,i),a(t,T,e),a(t,m,e),a(t,b,e),M(R,t,e),a(t,et,e),a(t,C,e),a(t,lt,e),a(t,Z,e),a(t,at,e),M(U,t,e),a(t,nt,e),M(W,t,e),a(t,st,e),a(t,X,e),a(t,it,e),M(z,t,e),a(t,pt,e),a(t,I,e),a(t,ot,e),M(v,t,e),a(t,mt,e),a(t,G,e),a(t,ut,e),M(F,t,e),a(t,ct,e),a(t,Q,e),a(t,Mt,e),a(t,_,e),a(t,rt,e),M(B,t,e),a(t,dt,e),a(t,w,e),a(t,ht,e),M(q,t,e),a(t,yt,e),M($,t,e),a(t,Tt,e),a(t,V,e),a(t,jt,e),M(k,t,e),a(t,bt,e),M(x,t,e),a(t,Ut,e),a(t,N,e),a(t,wt,e),M(A,t,e),a(t,Jt,e),M(S,t,e),a(t,ft,e),a(t,E,e),a(t,gt,e),M(J,t,e),a(t,Rt,e),a(t,Y,e),a(t,Ct,e),M(H,t,e),a(t,Zt,e),a(t,f,e),a(t,Wt,e),M(O,t,e),a(t,Xt,e),a(t,g,e),a(t,zt,e),M(L,t,e),a(t,It,e),a(t,K,e),vt=!0},p(t,[e]){const Yt={};e&2&&(Yt.$$scope={dirty:e,ctx:t}),U.$set(Yt);const Ht={};e&2&&(Ht.$$scope={dirty:e,ctx:t}),J.$set(Ht)},i(t){vt||(r(R.$$.fragment,t),r(U.$$.fragment,t),r(W.$$.fragment,t),r(z.$$.fragment,t),r(v.$$.fragment,t),r(F.$$.fragment,t),r(B.$$.fragment,t),r(q.$$.fragment,t),r($.$$.fragment,t),r(k.$$.fragment,t),r(x.$$.fragment,t),r(A.$$.fragment,t),r(S.$$.fragment,t),r(J.$$.fragment,t),r(H.$$.fragment,t),r(O.$$.fragment,t),r(L.$$.fragment,t),vt=!0)},o(t){d(R.$$.fragment,t),d(U.$$.fragment,t),d(W.$$.fragment,t),d(z.$$.fragment,t),d(v.$$.fragment,t),d(F.$$.fragment,t),d(B.$$.fragment,t),d(q.$$.fragment,t),d($.$$.fragment,t),d(k.$$.fragment,t),d(x.$$.fragment,t),d(A.$$.fragment,t),d(S.$$.fragment,t),d(J.$$.fragment,t),d(H.$$.fragment,t),d(O.$$.fragment,t),d(L.$$.fragment,t),vt=!1},d(t){t&&(l(T),l(m),l(b),l(et),l(C),l(lt),l(Z),l(at),l(nt),l(st),l(X),l(it),l(pt),l(I),l(ot),l(mt),l(G),l(ut),l(ct),l(Q),l(Mt),l(_),l(rt),l(dt),l(w),l(ht),l(yt),l(Tt),l(V),l(jt),l(bt),l(Ut),l(N),l(wt),l(Jt),l(ft),l(E),l(gt),l(Rt),l(Y),l(Ct),l(Zt),l(f),l(Wt),l(Xt),l(g),l(zt),l(It),l(K)),l(i),h(R,t),h(U,t),h(W,t),h(z,t),h(v,t),h(F,t),h(B,t),h(q,t),h($,t),h(k,t),h(x,t),h(A,t),h(S,t),h(J,t),h(H,t),h(O,t),h(L,t)}}}const pe='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantizing a model to be used with Optimum’s CLI","local":"quantizing-a-model-to-be-used-with-optimums-cli","sections":[],"depth":2},{"title":"Creating an ORTQuantizer","local":"creating-an-ortquantizer","sections":[],"depth":2},{"title":"Apply Dynamic Quantization","local":"apply-dynamic-quantization","sections":[],"depth":2},{"title":"Static Quantization example","local":"static-quantization-example","sections":[],"depth":2},{"title":"Quantize Seq2Seq models","local":"quantize-seq2seq-models","sections":[],"depth":2}],"depth":1}';function oe(P){return Kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class de extends te{constructor(i){super(),ee(this,i,oe,ie,Dt,{})}}export{de as component};
