import{s as Ps,n as Ks,o as sl}from"../chunks/scheduler.de5597d1.js";import{S as ll,i as tl,e as p,s as a,c as m,h as el,a as i,d as t,b as n,f as B,g as o,j as c,k as Ns,l as h,m as e,n as r,t as y,o as d,p as M}from"../chunks/index.bf1177c2.js";import{C as al,H as Qs,E as nl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.cd8e640f.js";import{C as A}from"../chunks/CodeBlock.257e0f66.js";function pl(Gs){let U,K,D,ss,f,ls,j,ts,J,Ys='除了 <code>HfApi</code>，<code>huggingface_hub</code> 库还提供了 <code>HfFileSystem</code>，这是一个符合 <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec</a> 规范的 Python 文件接口，用于与 Hugging Face Hub 交互。<code>HfFileSystem</code> 基于 <code>HfApi</code> 构建，提供了典型的文件系统操作，如 <code>cp</code>、<code>mv</code>、<code>ls</code>、<code>du</code>、<code>glob</code>、<code>get_file</code> 和 <code>put_file</code>。',es,g,vs="<p><code>HfFileSystem</code> 提供了 fsspec 兼容性，这对于需要它的库（例如，直接使用 <code>pandas</code> 读取 Hugging Face 数据集）非常有用。然而，由于这种兼容性层，会引入额外的开销。为了更好的性能和可靠性，建议尽可能使用 <code>HfApi</code> 方法。</p>",as,w,ns,k,ps,C,Xs="可以传递可选的 <code>revision</code> 参数，以从特定提交（如分支、标签名或提交哈希）运行操作。",is,R,Es="与 Python 内置的 <code>open</code> 不同，<code>fsspec</code> 的 <code>open</code> 默认是二进制模式 <code>&quot;rb&quot;</code>。这意味着您必须明确设置模式为 <code>&quot;r&quot;</code> 以读取文本模式，或 <code>&quot;w&quot;</code> 以写入文本模式。目前不支持追加到文件（模式 <code>&quot;a&quot;</code> 和 <code>&quot;ab&quot;</code>）",cs,V,ms,b,Is="<code>HfFileSystem</code> 可以与任何集成了 <code>fsspec</code> 的库一起使用，前提是 URL 遵循以下格式：",os,N,rs,u,_s='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/hf_urls.png"/>',ys,Q,Hs="对于数据集，<code>repo_type_prefix</code> 为 <code>datasets/</code>，对于Space，<code>repo_type_prefix</code>为 <code>spaces/</code>，模型不需要在 URL 中使用这样的前缀。",ds,F,Os="以下是一些 <code>HfFileSystem</code> 简化与 Hub 交互的有趣集成：",Ms,x,Z,L,qs='从 Hub 仓库读取/写入 <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame ：',Fs,$,hs,S,Bs='同样的工作流程也适用于 <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> 和 <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> DataFrames.',Us,T,G,z,xs='使用 <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a> 查询(远程)Hub文件：',Zs,Y,$s,v,W,Ls='使用 <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a> 将 Hub 作为数组存储：',Ss,X,gs,E,us,I,zs='在许多情况下，您必须登录 Hugging Face 账户才能与 Hub 交互。请参阅文档的<a href="../quick-start#authentication">认证</a> 部分，了解有关 Hub 上认证方法的更多信息。',Ts,_,Ws="也可以通过将您的 token 作为参数传递给 <code>HfFileSystem</code> 以编程方式登录：",fs,H,js,O,As="如果您以这种方式登录，请注意在共享源代码时不要意外泄露令牌！",Js,q,ws,P,ks;return f=new al({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),j=new Qs({props:{title:"通过文件系统 API 与 Hub 交互",local:"通过文件系统-api-与-hub-交互",headingTag:"h1"}}),w=new Qs({props:{title:"使用方法",local:"使用方法",headingTag:"h2"}}),k=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjAlRTUlODglOTclRTUlODclQkElRTclOUIlQUUlRTUlQkQlOTUlRTQlQjglQUQlRTclOUElODQlRTYlODklODAlRTYlOUMlODklRTYlOTYlODclRTQlQkIlQjYlMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMCVFNSU4OCU5NyVFNSU4NyVCQSVFNCVCQiU5MyVFNSVCQSU5MyVFNCVCOCVBRCVFNyU5QSU4NCVFNiU4OSU4MCVFNiU5QyU4OSUyMCUyMi5jc3YlMjIlMjAlRTYlOTYlODclRTQlQkIlQjYlMEFmcy5nbG9iKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkYqKiUyRiouY3N2JTIyKSUwQSUwQSUyMyUyMCVFOCVBRiVCQiVFNSU4RiU5NiVFOCVCRiU5QyVFNyVBOCU4QiVFNiU5NiU4NyVFNCVCQiVCNiUwQXdpdGglMjBmcy5vcGVuKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdHJhaW4uY3N2JTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhJTIwJTNEJTIwZi5yZWFkbGluZXMoKSUwQSUwQSUyMyUyMCVFOCVCRiU5QyVFNyVBOCU4QiVFNiU5NiU4NyVFNCVCQiVCNiVFNSU4NiU4NSVFNSVBRSVCOSVFOCVBRiVCQiVFNSU4RiU5NiVFNCVCOCVCQSVFNSVBRCU5NyVFNyVBQyVBNiVFNCVCOCVCMiUwQXRyYWluX2RhdGElMjAlM0QlMjBmcy5yZWFkX3RleHQoJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjByZXZpc2lvbiUzRCUyMmRldiUyMiklMEElMEElMjMlMjAlRTUlODYlOTklRTUlODUlQTUlRTglQkYlOUMlRTclQTglOEIlRTYlOTYlODclRTQlQkIlQjYlMEF3aXRoJTIwZnMub3BlbiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyRnZhbGlkYXRpb24uY3N2JTIyJTJDJTIwJTIydyUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMnRleHQlMkNsYWJlbCUyMiklMEElMjAlMjAlMjAlMjBmLndyaXRlKCUyMkZhbnRhc3RpYyUyMG1vdmllISUyQ2dvb2QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 列出目录中的所有文件</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 列出仓库中的所有 &quot;.csv&quot; 文件</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**/*.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 读取远程文件</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 远程文件内容读取为字符串</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 写入远程文件</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),V=new Qs({props:{title:"集成",local:"集成",headingTag:"h2"}}),N=new A({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGF0aCUyRmluJTJGcmVwbyUzRQ==",highlighted:'hf:<span class="hljs-regexp">//</span>[&lt;repo_type_prefix&gt;]&lt;repo_id&gt;[@&lt;revision&gt;]<span class="hljs-regexp">/&lt;path/i</span>n/repo&gt;',wrap:!1}}),$=new A({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMCVFNSVCMCU4NiVFOCVCRiU5QyVFNyVBOCU4QiUyMENTViUyMCVFNiU5NiU4NyVFNCVCQiVCNiVFOCVBRiVCQiVFNSU4RiU5NiVFNSU4OCVCMCUyMERhdGFGcmFtZSUwQWRmJTIwJTNEJTIwcGQucmVhZF9jc3YoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGdHJhaW4uY3N2JTIyKSUwQSUwQSUyMyUyMCVFNSVCMCU4NiUyMERhdGFGcmFtZSUyMCVFNSU4NiU5OSVFNSU4NSVBNSVFOCVCRiU5QyVFNyVBOCU4QiUyMENTViUyMCVFNiU5NiU4NyVFNCVCQiVCNiUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 将远程 CSV 文件读取到 DataFrame</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 将 DataFrame 写入远程 CSV 文件</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),Y=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjAlRTYlOUYlQTUlRTglQUYlQTIlRTglQkYlOUMlRTclQTglOEIlRTYlOTYlODclRTQlQkIlQjYlRTUlQjklQjYlRTUlQjAlODYlRTclQkIlOTMlRTYlOUUlOUMlRTglQkYlOTQlRTUlOUIlOUUlRTQlQjglQkElMjBEYXRhRnJhbWUlMEFmc19xdWVyeV9maWxlJTIwJTNEJTIwJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YV9kaXIlMkZkYXRhLnBhcnF1ZXQlMjIlMEFkZiUyMCUzRCUyMGR1Y2tkYi5xdWVyeShmJTIyU0VMRUNUJTIwKiUyMEZST00lMjAnJTdCZnNfcXVlcnlfZmlsZSU3RCclMjBMSU1JVCUyMDEwJTIyKS5kZigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 查询远程文件并将结果返回为 DataFrame</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),X=new A({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjAlRTUlQjAlODYlRTYlOTUlQjAlRTclQkIlODQlRTUlODYlOTklRTUlODUlQTUlRTQlQkIlOTMlRTUlQkElOTMlMEF3aXRoJTIwemFyci5vcGVuX2dyb3VwKCUyMmhmJTNBJTJGJTJGbXktdXNlcm5hbWUlMkZteS1tb2RlbC1yZXBvJTJGYXJyYXktc3RvcmUlMjIlMkMlMjBtb2RlJTNEJTIydyUyMiklMjBhcyUyMHJvb3QlM0ElMEElMjAlMjAlMjBmb28lMjAlM0QlMjByb290LmNyZWF0ZV9ncm91cCglMjJlbWJlZGRpbmdzJTIyKSUwQSUyMCUyMCUyMGZvb2JhciUyMCUzRCUyMGZvby56ZXJvcygnZXhwZXJpbWVudF8wJyUyQyUyMHNoYXBlJTNEKDUwMDAwJTJDJTIwMTAwMCklMkMlMjBjaHVua3MlM0QoMTAwMDAlMkMlMjAxMDAwKSUyQyUyMGR0eXBlJTNEJ2Y0JyklMEElMjAlMjAlMjBmb29iYXIlNUIlM0ElNUQlMjAlM0QlMjBlbWJlZGRpbmdzJTBBJTBBJTIzJTIwJUU0JUJCJThFJUU0JUJCJTkzJUU1JUJBJTkzJUU4JUFGJUJCJUU1JThGJTk2JUU2JTk1JUIwJUU3JUJCJTg0JTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 将数组写入仓库</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 从仓库读取数组</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),E=new Qs({props:{title:"认证",local:"认证",headingTag:"h2"}}),H=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),q=new nl({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/cn/guides/hf_file_system.md"}}),{c(){U=p("meta"),K=a(),D=p("p"),ss=a(),m(f.$$.fragment),ls=a(),m(j.$$.fragment),ts=a(),J=p("p"),J.innerHTML=Ys,es=a(),g=p("blockquote"),g.innerHTML=vs,as=a(),m(w.$$.fragment),ns=a(),m(k.$$.fragment),ps=a(),C=p("p"),C.innerHTML=Xs,is=a(),R=p("p"),R.innerHTML=Es,cs=a(),m(V.$$.fragment),ms=a(),b=p("p"),b.innerHTML=Is,os=a(),m(N.$$.fragment),rs=a(),u=p("div"),u.innerHTML=_s,ys=a(),Q=p("p"),Q.innerHTML=Hs,ds=a(),F=p("p"),F.innerHTML=Os,Ms=a(),x=p("ul"),Z=p("li"),L=p("p"),L.innerHTML=qs,Fs=a(),m($.$$.fragment),hs=a(),S=p("p"),S.innerHTML=Bs,Us=a(),T=p("ul"),G=p("li"),z=p("p"),z.innerHTML=xs,Zs=a(),m(Y.$$.fragment),$s=a(),v=p("li"),W=p("p"),W.innerHTML=Ls,Ss=a(),m(X.$$.fragment),gs=a(),m(E.$$.fragment),us=a(),I=p("p"),I.innerHTML=zs,Ts=a(),_=p("p"),_.innerHTML=Ws,fs=a(),m(H.$$.fragment),js=a(),O=p("p"),O.textContent=As,Js=a(),m(q.$$.fragment),ws=a(),P=p("p"),this.h()},l(s){const l=el("svelte-u9bgzb",document.head);U=i(l,"META",{name:!0,content:!0}),l.forEach(t),K=n(s),D=i(s,"P",{}),B(D).forEach(t),ss=n(s),o(f.$$.fragment,s),ls=n(s),o(j.$$.fragment,s),ts=n(s),J=i(s,"P",{"data-svelte-h":!0}),c(J)!=="svelte-8k89ij"&&(J.innerHTML=Ys),es=n(s),g=i(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(g)!=="svelte-xq34u8"&&(g.innerHTML=vs),as=n(s),o(w.$$.fragment,s),ns=n(s),o(k.$$.fragment,s),ps=n(s),C=i(s,"P",{"data-svelte-h":!0}),c(C)!=="svelte-1wzfat4"&&(C.innerHTML=Xs),is=n(s),R=i(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1iolibw"&&(R.innerHTML=Es),cs=n(s),o(V.$$.fragment,s),ms=n(s),b=i(s,"P",{"data-svelte-h":!0}),c(b)!=="svelte-1evtbpn"&&(b.innerHTML=Is),os=n(s),o(N.$$.fragment,s),rs=n(s),u=i(s,"DIV",{class:!0,"data-svelte-h":!0}),c(u)!=="svelte-167v4fl"&&(u.innerHTML=_s),ys=n(s),Q=i(s,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-iwgss8"&&(Q.innerHTML=Hs),ds=n(s),F=i(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-12r7993"&&(F.innerHTML=Os),Ms=n(s),x=i(s,"UL",{});var Ds=B(x);Z=i(Ds,"LI",{});var Cs=B(Z);L=i(Cs,"P",{"data-svelte-h":!0}),c(L)!=="svelte-lwztdr"&&(L.innerHTML=qs),Fs=n(Cs),o($.$$.fragment,Cs),Cs.forEach(t),Ds.forEach(t),hs=n(s),S=i(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1d71x4n"&&(S.innerHTML=Bs),Us=n(s),T=i(s,"UL",{});var Rs=B(T);G=i(Rs,"LI",{});var Vs=B(G);z=i(Vs,"P",{"data-svelte-h":!0}),c(z)!=="svelte-1pmewq4"&&(z.innerHTML=xs),Zs=n(Vs),o(Y.$$.fragment,Vs),Vs.forEach(t),$s=n(Rs),v=i(Rs,"LI",{});var bs=B(v);W=i(bs,"P",{"data-svelte-h":!0}),c(W)!=="svelte-17onvf5"&&(W.innerHTML=Ls),Ss=n(bs),o(X.$$.fragment,bs),bs.forEach(t),Rs.forEach(t),gs=n(s),o(E.$$.fragment,s),us=n(s),I=i(s,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1ehmkss"&&(I.innerHTML=zs),Ts=n(s),_=i(s,"P",{"data-svelte-h":!0}),c(_)!=="svelte-uh366k"&&(_.innerHTML=Ws),fs=n(s),o(H.$$.fragment,s),js=n(s),O=i(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1cvm5tr"&&(O.textContent=As),Js=n(s),o(q.$$.fragment,s),ws=n(s),P=i(s,"P",{}),B(P).forEach(t),this.h()},h(){Ns(U,"name","hf:doc:metadata"),Ns(U,"content",il),Ns(g,"class","warning"),Ns(u,"class","flex justify-center")},m(s,l){h(document.head,U),e(s,K,l),e(s,D,l),e(s,ss,l),r(f,s,l),e(s,ls,l),r(j,s,l),e(s,ts,l),e(s,J,l),e(s,es,l),e(s,g,l),e(s,as,l),r(w,s,l),e(s,ns,l),r(k,s,l),e(s,ps,l),e(s,C,l),e(s,is,l),e(s,R,l),e(s,cs,l),r(V,s,l),e(s,ms,l),e(s,b,l),e(s,os,l),r(N,s,l),e(s,rs,l),e(s,u,l),e(s,ys,l),e(s,Q,l),e(s,ds,l),e(s,F,l),e(s,Ms,l),e(s,x,l),h(x,Z),h(Z,L),h(Z,Fs),r($,Z,null),e(s,hs,l),e(s,S,l),e(s,Us,l),e(s,T,l),h(T,G),h(G,z),h(G,Zs),r(Y,G,null),h(T,$s),h(T,v),h(v,W),h(v,Ss),r(X,v,null),e(s,gs,l),r(E,s,l),e(s,us,l),e(s,I,l),e(s,Ts,l),e(s,_,l),e(s,fs,l),r(H,s,l),e(s,js,l),e(s,O,l),e(s,Js,l),r(q,s,l),e(s,ws,l),e(s,P,l),ks=!0},p:Ks,i(s){ks||(y(f.$$.fragment,s),y(j.$$.fragment,s),y(w.$$.fragment,s),y(k.$$.fragment,s),y(V.$$.fragment,s),y(N.$$.fragment,s),y($.$$.fragment,s),y(Y.$$.fragment,s),y(X.$$.fragment,s),y(E.$$.fragment,s),y(H.$$.fragment,s),y(q.$$.fragment,s),ks=!0)},o(s){d(f.$$.fragment,s),d(j.$$.fragment,s),d(w.$$.fragment,s),d(k.$$.fragment,s),d(V.$$.fragment,s),d(N.$$.fragment,s),d($.$$.fragment,s),d(Y.$$.fragment,s),d(X.$$.fragment,s),d(E.$$.fragment,s),d(H.$$.fragment,s),d(q.$$.fragment,s),ks=!1},d(s){s&&(t(K),t(D),t(ss),t(ls),t(ts),t(J),t(es),t(g),t(as),t(ns),t(ps),t(C),t(is),t(R),t(cs),t(ms),t(b),t(os),t(rs),t(u),t(ys),t(Q),t(ds),t(F),t(Ms),t(x),t(hs),t(S),t(Us),t(T),t(gs),t(us),t(I),t(Ts),t(_),t(fs),t(js),t(O),t(Js),t(ws),t(P)),t(U),M(f,s),M(j,s),M(w,s),M(k,s),M(V,s),M(N,s),M($),M(Y),M(X),M(E,s),M(H,s),M(q,s)}}}const il='{"title":"通过文件系统 API 与 Hub 交互","local":"通过文件系统-api-与-hub-交互","sections":[{"title":"使用方法","local":"使用方法","sections":[],"depth":2},{"title":"集成","local":"集成","sections":[],"depth":2},{"title":"认证","local":"认证","sections":[],"depth":2}],"depth":1}';function cl(Gs){return sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends ll{constructor(U){super(),tl(this,U,cl,pl,Ps,{})}}export{dl as component};
