import{s as Kl,n as ei,o as ni}from"../chunks/scheduler.de5597d1.js";import{S as ti,i as si,e as a,s as l,c as p,h as li,a as r,d as t,b as i,f as Cn,g as o,j as d,k as Jn,l as w,m as s,n as h,t as m,o as u,p as c}from"../chunks/index.bf1177c2.js";import{C as ii,H as M,E as ai}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d16525ff.js";import{C as g}from"../chunks/CodeBlock.0114a234.js";function ri(Rs){let b,_n,vn,Sn,v,Gn,z,Bn,C,Ds="Das Teilen Ihrer Dateien und Arbeiten ist ein wichtiger Aspekt des Hubs. Das <code>huggingface_hub</code> bietet mehrere Optionen, um Ihre Dateien auf den Hub hochzuladen. Sie können diese Funktionen unabhängig verwenden oder sie in Ihre Bibliothek integrieren, um es Ihren Benutzern zu erleichtern, mit dem Hub zu interagieren. In dieser Anleitung erfahren Sie, wie Sie Dateien hochladen:",Zn,_,Ws='<li>ohne Git zu verwenden.</li> <li>mit <a href="https://git-lfs.github.com/" rel="nofollow">Git LFS</a> wenn die Dateien sehr groß sind.</li> <li>mit dem <code>commit</code>-Context-Manager.</li> <li>mit der Funktion <code>~Repository.push_to_hub</code>.</li>',$n,S,Xs="Wenn Sie Dateien auf den Hub hochladen möchten, müssen Sie sich bei Ihrem Hugging Face-Konto anmelden:",Hn,T,G,jn,As="Melden Sie sich bei Ihrem Hugging Face-Konto mit dem folgenden Befehl an:",Gs,B,Bs,f,Un,Ls="Alternativ können Sie sich in einem Notebook oder einem Skript programmatisch mit <code>login()</code> anmelden:",Zs,Z,$s,kn,Es="Wenn es in einem Jupyter- oder Colaboratory-Notebook ausgeführt wird, startet <code>login()</code> ein Widget, über das Sie Ihren Hugging Face-Zugriffstoken eingeben können. Andernfalls wird eine Meldung im Terminal angezeigt.",Hs,In,Vs="Es ist auch möglich, sich programmatisch ohne das Widget anzumelden, indem Sie den Token direkt an <code>login()</code> übergeben. Seien Sie jedoch vorsichtig, wenn Sie Ihr Notebook teilen. Es ist am Besten, den Token aus einem sicheren Passwortspeicher zu laden, anstatt ihn in Ihrem Colaboratory-Notebook zu speichern.",Rn,$,Dn,H,Fs="Sobald Sie ein Repository mit <code>create_repo()</code> erstellt haben, können Sie mit <code>upload_file()</code> eine Datei in Ihr Repository hochladen.",Wn,R,xs="Geben Sie den Pfad der hochzuladenden Datei, den Ort, an den Sie die Datei im Repository hochladen möchten, und den Namen des Repositories an, zu dem Sie die Datei hinzufügen möchten. Abhängig von Ihrem Repository-Typ können Sie optional den Repository-Typ als <code>dataset</code>, <code>model</code>, oder <code>space</code> festlegen.",Xn,D,An,W,Ln,X,Ns="Verwenden Sie die Funktion <code>upload_folder()</code>, um einen lokalen Ordner in ein vorhandenes Repository hochzuladen. Geben Sie den Pfad des lokalen Ordners an, den Sie hochladen möchten, an welchem Ort Sie den Ordner im Repository hochladen möchten, und den Namen des Repositories, zu dem Sie den Ordner hinzufügen möchten. Abhängig von Ihrem Repository-Typ können Sie optional den Repository-Typ als <code>dataset</code>, <code>model</code>, oder <code>space</code> festlegen.",En,A,Vn,L,qs='Verwenden Sie die Argumente <code>allow_patterns</code> und <code>ignore_patterns</code>, um anzugeben, welche Dateien hochgeladen werden sollen. Diese Parameter akzeptieren entweder ein einzelnes Muster oder eine Liste von Mustern. Muster sind Standard-Wildcards (globbing patterns) wie <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">hier</a> dokumentiert. Wenn sowohl <code>allow_patterns</code> als auch <code>ignore_patterns</code> angegeben werden, gelten beide Einschränkungen. Standardmäßig werden alle Dateien aus dem Ordner hochgeladen.',Fn,E,Qs="Jeder <code>.git/</code>-Ordner in einem Unterverzeichnis wird ignoriert. Bitte beachten Sie jedoch, dass die <code>.gitignore</code>-Datei nicht berücksichtigt wird. Dies bedeutet, dass Sie <code>allow_patterns</code> und <code>ignore_patterns</code> verwenden müssen, um anzugeben, welche Dateien stattdessen hochgeladen werden sollen.",xn,V,Nn,F,Ys="Sie können auch das Argument <code>delete_patterns</code> verwenden, um Dateien anzugeben, die Sie im selben Commit aus dem Repo löschen möchten. Dies kann nützlich sein, wenn Sie einen entfernten Ordner reinigen möchten, bevor Sie Dateien darin ablegen und nicht wissen, welche Dateien bereits vorhanden sind.",qn,x,Ps="Im folgenden Beispiel wird der lokale Ordner <code>./logs</code> in den entfernten Ordner <code>/experiment/logs/</code> hochgeladen. Es werden nur txt-Dateien hochgeladen, aber davor werden alle vorherigen Protokolle im Repo gelöscht. All dies in einem einzigen Commit.",Qn,N,Yn,q,Pn,Q,Os="In den meisten Fällen benötigen Sie nicht mehr als <code>upload_file()</code> und <code>upload_folder()</code>, um Ihre Dateien auf den Hub hochzuladen. Das <code>huggingface_hub</code> bietet jedoch fortschrittlichere Funktionen, um die Dinge einfacher zu machen. Schauen wir sie uns an!",On,Y,Kn,P,Ks='In einigen Fällen möchten Sie Daten hochladen, ohne Ihren Hauptthread zu blockieren. Dies ist besonders nützlich, um Protokolle und Artefakte hochzuladen, während Sie weiter trainieren. Um dies zu tun, können Sie das Argument <code>run_as_future</code> in beiden <code>upload_file()</code> und <code>upload_folder()</code> verwenden. Dies gibt ein <a href="https://docs.python.org/3/library/concurrent.futures.html#future-objects" rel="nofollow"><code>concurrent.futures.Future</code></a>-Objekt zurück, mit dem Sie den Status des Uploads überprüfen können.',et,O,nt,y,el="<p>Hintergrund-Aufgaben werden in die Warteschlange gestellt, wenn <code>run_as_future=True</code> verwendet wird. Das bedeutet, dass garantiert wird, dass die Aufgaben in der richtigen Reihenfolge ausgeführt werden.</p>",tt,K,nl="Auch wenn Hintergrundaufgaben hauptsächlich dazu dienen, Daten hochzuladen/Commits zu erstellen, können Sie jede gewünschte Methode in die Warteschlange stellen, indem Sie <code>run_as_future()</code> verwenden. Sie können es beispielsweise verwenden, um ein Repo zu erstellen und dann Daten im Hintergrund dorthin hochzuladen. Das integrierte Argument <code>run_as_future</code> in Upload-Methoden ist lediglich ein Alias dafür.",st,ee,lt,ne,it,te,tl="Mit <code>upload_folder()</code> können Sie ganz einfach einen gesamten Ordner ins Hub hochladen. Bei großen Ordnern (Tausende von Dateien oder Hunderte von GB) kann dies jedoch immer noch herausfordernd sein. Wenn Sie einen Ordner mit vielen Dateien haben, möchten Sie ihn möglicherweise in mehreren Commits hochladen. Wenn während des Uploads ein Fehler oder ein Verbindungsproblem auftritt, müssen Sie den Vorgang nicht von Anfang an wiederholen.",at,se,sl="Um einen Ordner in mehreren Commits hochzuladen, übergeben Sie einfach <code>multi_commits=True</code> als Argument. Intern wird <code>huggingface_hub</code> die hochzuladenden/zu löschenden Dateien auflisten und sie in mehrere Commits aufteilen. Die “Strategie” (d.h. wie die Commits aufgeteilt werden) basiert auf der Anzahl und Größe der hochzuladenden Dateien. Ein PR wird im Hub geöffnet, um alle Commits zu pushen. Sobald der PR bereit ist, werden die Commits zu einem einzigen Commit zusammengefasst. Wenn der Prozess unterbrochen wird, bevor er abgeschlossen ist, können Sie Ihr Skript erneut ausführen, um den Upload fortzusetzen. Der erstellte PR wird automatisch erkannt und der Upload setzt dort fort, wo er gestoppt wurde. Es wird empfohlen, <code>multi_commits_verbose=True</code> zu übergeben, um ein besseres Verständnis für den Upload und dessen Fortschritt zu erhalten.",rt,le,ll="Das untenstehende Beispiel lädt den Ordner “checkpoints” in ein Dataset in mehreren Commits hoch. Ein PR wird im Hub erstellt und automatisch zusammengeführt, sobald der Upload abgeschlossen ist. Wenn Sie möchten, dass der PR offen bleibt und Sie ihn manuell überprüfen können, übergeben Sie <code>create_pr=True</code>.",dt,ie,pt,ae,il="Wenn Sie die Upload-Strategie besser steuern möchten (d.h. die erstellten Commits), können Sie sich die Low-Level-Methoden <code>plan_multi_commits</code> und <code>create_commits_on_pr</code> ansehen.",ot,J,al="<p><code>multi_commits</code> ist noch ein experimentelles Feature. Seine API und sein Verhalten können in Zukunft ohne vorherige Ankündigung geändert werden.</p>",ht,re,mt,de,rl="Das Hugging Face Hub erleichtert das Speichern und Versionieren von Daten. Es gibt jedoch einige Einschränkungen, wenn Sie dieselbe Datei Tausende von Malen aktualisieren möchten. Sie möchten beispielsweise Protokolle eines Trainingsprozesses oder Benutzerfeedback in einem bereitgestellten Space speichern. In diesen Fällen macht es Sinn, die Daten als Dataset im Hub hochzuladen, aber es kann schwierig sein, dies richtig zu machen. Der Hauptgrund ist, dass Sie nicht jede Aktualisierung Ihrer Daten versionieren möchten, da dies das git-Repository unbrauchbar machen würde. Die Klasse <code>CommitScheduler</code> bietet eine Lösung für dieses Problem.",ut,pe,dl="Die Idee besteht darin, einen Hintergrundjob auszuführen, der regelmäßig einen lokalen Ordner ins Hub schiebt. Nehmen Sie an, Sie haben einen Gradio Space, der als Eingabe einen Text nimmt und zwei Übersetzungen davon generiert. Der Benutzer kann dann seine bevorzugte Übersetzung auswählen. Für jeden Durchlauf möchten Sie die Eingabe, Ausgabe und Benutzerpräferenz speichern, um die Ergebnisse zu analysieren. Dies ist ein perfekter Anwendungsfall für <code>CommitScheduler</code>; Sie möchten Daten ins Hub speichern (potenziell Millionen von Benutzerfeedbacks), aber Sie müssen nicht in Echtzeit jede Benutzereingabe speichern. Stattdessen können Sie die Daten lokal in einer JSON-Datei speichern und sie alle 10 Minuten hochladen. Zum Beispiel:",ct,oe,gt,he,pl="Und das war’s! Benutzereingabe/-ausgaben und Feedback sind als Dataset auf dem Hub verfügbar. Durch die Verwendung eines eindeutigen JSON-Dateinamens können Sie sicher sein, dass Sie keine Daten von einem vorherigen Lauf oder Daten von anderen Spaces/Replikas überschreiben, die gleichzeitig in dasselbe Repository pushen.",Mt,me,ol="Für weitere Details über den <code>CommitScheduler</code>, hier das Wichtigste:",wt,ue,hl=`<li><strong>append-only / Nur hinzufügen:</strong>
Es wird davon ausgegangen, dass Sie nur Inhalte zum Ordner hinzufügen. Sie dürfen nur Daten zu bestehenden Dateien hinzufügen oder neue Dateien erstellen. Das Löschen oder Überschreiben einer Datei könnte Ihr Repository beschädigen.</li> <li><strong>git history / git Historie</strong>:
Der Scheduler wird den Ordner alle every Minuten committen. Um das Git-Repository nicht zu überladen, wird empfohlen, einen minimalen Wert von 5 Minuten festzulegen. Außerdem ist der Scheduler darauf ausgelegt, leere Commits zu vermeiden. Wenn im Ordner kein neuer Inhalt erkannt wird, wird der geplante Commit verworfen.</li> <li><strong>errors / Fehler</strong>:
Der Scheduler läuft als Hintergrund-Thread. Er wird gestartet, wenn Sie die Klasse instanziieren, und stoppt nie. Insbesondere, wenn während des Uploads ein Fehler auftritt (z. B. Verbindungsproblem), wird der Scheduler ihn stillschweigend ignorieren und beim nächsten geplanten Commit erneut versuchen.</li> <li><strong>thread-safety / Thread-Sicherheit</strong>:
In den meisten Fällen können Sie davon ausgehen, dass Sie eine Datei schreiben können, ohne sich um eine Lock-Datei kümmern zu müssen. Der Scheduler wird nicht abstürzen oder beschädigt werden, wenn Sie Inhalte in den Ordner schreiben, während er hochlädt. In der Praxis ist es möglich, dass bei stark ausgelasteten Apps Probleme mit der Parallelität auftreten. In diesem Fall empfehlen wir, das <code>scheduler.lock</code> Lock zu verwenden, um die Thread-Sicherheit zu gewährleisten. Das Lock wird nur gesperrt, wenn der Scheduler den Ordner auf Änderungen überprüft, nicht beim Hochladen von Daten. Sie können sicher davon ausgehen, dass dies das Benutzererlebnis in Ihrem Space nicht beeinflusst.</li>`,ft,ce,bt,ge,ml='Das Speichern von Daten aus einem Space in einem Dataset auf dem Hub ist der Hauptanwendungsfall für den <code>CommitScheduler</code>. Je nach Anwendungsfall möchten Sie Ihre Daten möglicherweise anders strukturieren. Die Struktur muss robust gegenüber gleichzeitigen Benutzern und Neustarts sein, was oft das Generieren von UUIDs impliziert. Neben der Robustheit sollten Sie Daten in einem Format hochladen, das von der 🤗 Datasets-Bibliothek für die spätere Wiederverwendung gelesen werden kann. Wir haben einen <a href="https://huggingface.co/spaces/Wauplin/space_to_dataset_saver" rel="nofollow">Space</a> erstellt, der zeigt, wie man verschiedene Datenformate speichert (dies muss möglicherweise für Ihre speziellen Bedürfnisse angepasst werden).',Tt,Me,yt,we,ul="<code>CommitScheduler</code> geht davon aus, dass Ihre Daten nur hinzugefügt werden und “wie sie sind” hochgeladen werden sollten. Sie möchten jedoch möglicherweise anpassen, wie Daten hochgeladen werden. Dies können Sie tun, indem Sie eine Klasse erstellen, die vom <code>CommitScheduler</code> erbt und die Methode <code>push_to_hub</code> überschreibt (fühlen Sie sich frei, sie nach Belieben zu überschreiben). Es ist garantiert, dass sie alle <code>every</code> Minuten in einem Hintergrund-Thread aufgerufen wird. Sie müssen sich keine Gedanken über Parallelität und Fehler machen, aber Sie müssen vorsichtig sein bei anderen Aspekten, wie z. B. dem Pushen von leeren Commits oder doppelten Daten.",Jt,fe,cl="Im folgenden (vereinfachten) Beispiel überschreiben wir <code>push_to_hub</code>, um alle PNG-Dateien in einem einzigen Archiv zu zippen, um das Repo auf dem Hub nicht zu überladen:",jt,be,Ut,Te,gl="Wenn Sie <code>push_to_hub</code> überschreiben, haben Sie Zugriff auf die Attribute vom <code>CommitScheduler</code> und insbesondere:",kt,ye,Ml="<li><code>HfApi</code> Client: <code>api</code></li> <li>Ordnerparameter: <code>folder_path</code> und <code>path_in_repo</code></li> <li>Repo-Parameter: <code>repo_id</code>, <code>repo_type</code>, <code>revision</code></li> <li>Das Thread-Lock: <code>lock</code></li>",It,j,wl='<p>Für weitere Beispiele von benutzerdefinierten Schedulern, schauen Sie sich unseren <a href="https://huggingface.co/spaces/Wauplin/space_to_dataset_saver" rel="nofollow">Demo Space</a> an, der verschiedene Implementierungen je nach Ihren Anforderungen enthält.</p>',vt,Je,zt,je,fl="Die Funktionen <code>upload_file()</code> und <code>upload_folder()</code> sind High-Level-APIs, die im Allgemeinen bequem zu verwenden sind. Wir empfehlen, diese Funktionen zuerst auszuprobieren, wenn Sie nicht auf einer niedrigeren Ebene arbeiten müssen. Wenn Sie jedoch auf Commit-Ebene arbeiten möchten, können Sie die Funktion <code>create_commit()</code> direkt verwenden.",Ct,Ue,bl="Es gibt drei von <code>create_commit()</code> unterstützte Operationstypen:",_t,ke,Tl="<li><p><code>CommitOperationAdd</code> lädt eine Datei in den Hub hoch. Wenn die Datei bereits existiert, werden die Dateiinhalte überschrieben. Diese Operation akzeptiert zwei Argumente:</p> <ul><li><code>path_in_repo</code>: der Repository-Pfad, um eine Datei hochzuladen.</li> <li><code>path_or_fileobj</code>: entweder ein Pfad zu einer Datei auf Ihrem Dateisystem oder ein Datei-ähnliches Objekt. Dies ist der Inhalt der Datei, die auf den Hub hochgeladen werden soll.</li></ul></li> <li><p><code>CommitOperationDelete</code> entfernt eine Datei oder einen Ordner aus einem Repository. Diese Operation akzeptiert path_in_repo als Argument.</p></li> <li><p><code>CommitOperationCopy</code> kopiert eine Datei innerhalb eines Repositorys. Diese Operation akzeptiert drei Argumente:</p> <ul><li><code>src_path_in_repo</code>: der Repository-Pfad der zu kopierenden Datei.</li> <li><code>path_in_repo</code>: der Repository-Pfad, wohin die Datei kopiert werden soll.</li> <li><code>src_revision</code>: optional - die Revision der zu kopierenden Datei, wenn Sie eine Datei von einem anderen Branch/Revision kopieren möchten.</li></ul></li>",St,Ie,yl="Zum Beispiel, wenn Sie zwei Dateien hochladen und eine Datei in einem Hub-Repository löschen möchten:",Gt,ve,Jl="<li>Verwenden Sie die entsprechende <code>CommitOperation</code>, um eine Datei hinzuzufügen oder zu löschen und einen Ordner zu löschen:</li>",Bt,ze,Zt,U,jl="<li>Übergeben Sie Ihre Operationen an <code>create_commit()</code>:</li>",$t,Ce,Ht,_e,Ul="Zusätzlich zu <code>upload_file()</code> und <code>upload_folder()</code> verwenden auch die folgenden Funktionen <code>create_commit()</code> im Hintergrund:",Rt,Se,kl="<li><code>delete_file()</code> löscht eine einzelne Datei aus einem Repository auf dem Hub.</li> <li><code>delete_folder()</code> löscht einen gesamten Ordner aus einem Repository auf dem Hub.</li> <li><code>metadata_update()</code> aktualisiert die Metadaten eines Repositorys.</li>",Dt,Ge,Il="Für detailliertere Informationen werfen Sie einen Blick auf die <code>HfApi</code> Referenz.",Wt,Be,Xt,Ze,vl="Bei der Verwaltung einer großen Datenmenge in Ihrem Repo gibt es einige Einschränkungen zu beachten. Angesichts der Zeit, die es dauert, die Daten zu streamen, kann es sehr ärgerlich sein, am Ende des Prozesses einen Upload/Push zu verlieren oder eine degradierte Erfahrung zu machen, sei es auf hf.co oder bei lokalem Arbeiten. Wir haben eine Liste von Tipps und Empfehlungen zusammengestellt, um Ihr Repo zu strukturieren.",At,$e,zl="<thead><tr><th>Eigenschaft</th> <th>Empfohlen</th> <th>Tipps</th></tr></thead> <tbody><tr><td>Repo-Größe</td> <td>-</td> <td>Kontaktieren Sie uns für große Repos (TBs Daten)</td></tr> <tr><td>Dateien pro Repo</td> <td>&lt;100k</td> <td>Daten in weniger Dateien zusammenführen</td></tr> <tr><td>Einträge pro Ordner</td> <td>&lt;10k</td> <td>Unterverzeichnisse im Repo verwenden</td></tr> <tr><td>Dateigröße</td> <td>&lt;5GB</td> <td>Daten in geteilte Dateien aufteilen</td></tr> <tr><td>Commit-Größe</td> <td>&lt;100 files*</td> <td>Dateien in mehreren Commits hochladen</td></tr> <tr><td>Commits pro Repo</td> <td>-</td> <td>Mehrere Dateien pro Commit hochladen und/oder Historie zusammenführen</td></tr></tbody>",Lt,He,Cl="<em>* Nicht relevant bei direkter Verwendung des <code>git</code> CLI</em>",Et,Re,_l="Bitte lesen Sie den nächsten Abschnitt, um diese Beschränkungen besser zu verstehen und zu erfahren, wie Sie damit umgehen können.",Vt,De,Ft,We,Sl="Was meinen wir, wenn wir von “großen Uploads” sprechen, und welche Einschränkungen sind damit verbunden? Große Uploads können sehr unterschiedlich sein, von Repositories mit einigen riesigen Dateien (z. B. Modellgewichten) bis hin zu Repositories mit Tausenden von kleinen Dateien (z. B. einem Bilddatensatz).",xt,Xe,Gl=`Hinter den Kulissen verwendet der Hub Git zur Versionierung der Daten, was strukturelle Auswirkungen darauf hat, was Sie in Ihrem Repo tun können.
Wenn Ihr Repo einige der im vorherigen Abschnitt erwähnten Zahlen überschreitet, <strong>empfehlen wir Ihnen dringend, <a href="https://github.com/github/git-sizer" rel="nofollow"><code>git-sizer</code></a> zu verwenden</strong>, das eine sehr detaillierte Dokumentation über die verschiedenen Faktoren bietet, die Ihr Erlebnis beeinflussen werden. Hier ist ein TL;DR der zu berücksichtigenden Faktoren:`,Nt,Ae,Bl=`<li><strong>Repository-Größe</strong>: Die Gesamtgröße der Daten, die Sie hochladen möchten. Es gibt keine feste Obergrenze für die Größe eines Hub-Repositories. Wenn Sie jedoch vorhaben, Hunderte von GBs oder sogar TBs an Daten hochzuladen, würden wir es begrüßen, wenn Sie uns dies im Voraus mitteilen könnten, damit wir Ihnen besser helfen können, falls Sie während des Prozesses Fragen haben. Sie können uns unter <a href="mailto:datasets@huggingface.co">datasets@huggingface.co</a> oder auf <a href="http://hf.co/join/discord" rel="nofollow">unserem Discord</a> kontaktieren.</li> <li><strong>Anzahl der Dateien</strong>:
<ul><li>Für ein optimales Erlebnis empfehlen wir, die Gesamtzahl der Dateien unter 100k zu halten. Versuchen Sie, die Daten zu weniger Dateien zusammenzuführen, wenn Sie mehr haben.
Zum Beispiel können json-Dateien zu einer einzigen jsonl-Datei zusammengeführt oder große Datensätze als Parquet-Dateien exportiert werden.</li> <li>Die maximale Anzahl von Dateien pro Ordner darf 10k Dateien pro Ordner nicht überschreiten. Eine einfache Lösung besteht darin, eine Repository-Struktur zu erstellen, die Unterverzeichnisse verwendet. Ein Repo mit 1k Ordnern von <code>000/</code> bis <code>999/</code>, in dem jeweils maximal 1000 Dateien enthalten sind, reicht bereits aus.</li></ul></li> <li><strong>Dateigröße</strong>: Bei hochzuladenden großen Dateien (z. B. Modellgewichte) empfehlen wir dringend, sie <strong>in Blöcke von etwa 5GB aufzuteilen</strong>.
Es gibt mehrere Gründe dafür:
<ul><li>Das Hoch- und Herunterladen kleinerer Dateien ist sowohl für Sie als auch für andere Benutzer viel einfacher. Bei der Datenübertragung können immer Verbindungsprobleme auftreten, und kleinere Dateien vermeiden das erneute Starten von Anfang an im Falle von Fehlern.</li> <li>Dateien werden den Benutzern über CloudFront bereitgestellt. Aus unserer Erfahrung werden riesige Dateien von diesem Dienst nicht zwischengespeichert, was zu einer langsameren Downloadgeschwindigkeit führt.
In jedem Fall wird keine einzelne LFS-Datei &gt;50GB sein können. D. h. 50GB ist das absolute Limit für die Einzeldateigröße.</li></ul></li> <li><strong>Anzahl der Commits</strong>: Es gibt kein festes Limit für die Gesamtzahl der Commits in Ihrer Repo-Historie. Aus unserer Erfahrung heraus beginnt das Benutzererlebnis im Hub jedoch nach einigen Tausend Commits abzunehmen. Wir arbeiten ständig daran, den Service zu verbessern, aber man sollte immer daran denken, dass ein Git-Repository nicht als Datenbank mit vielen Schreibzugriffen gedacht ist. Wenn die Historie Ihres Repos sehr groß wird, können Sie immer alle Commits mit <code>super_squash_history()</code> zusammenfassen, um einen Neuanfang zu erhalten. Dies ist eine nicht rückgängig zu machende Operation.</li> <li><strong>Anzahl der Operationen pro Commit</strong>: Auch hier gibt es keine feste Obergrenze. Wenn ein Commit im Hub hochgeladen wird, wird jede Git-Operation (Hinzufügen oder Löschen) vom Server überprüft. Wenn hundert LFS-Dateien auf einmal committed werden, wird jede Datei einzeln überprüft, um sicherzustellen, dass sie korrekt hochgeladen wurde. Beim Pushen von Daten über HTTP mit <code>huggingface_hub</code> wird ein Timeout von 60s für die Anforderung festgelegt, was bedeutet, dass, wenn der Prozess mehr Zeit in Anspruch nimmt, clientseitig ein Fehler ausgelöst wird. Es kann jedoch (in seltenen Fällen) vorkommen, dass selbst wenn das Timeout clientseitig ausgelöst wird, der Prozess serverseitig dennoch abgeschlossen wird. Dies kann manuell überprüft werden, indem man das Repo im Hub durchsucht. Um dieses Timeout zu vermeiden, empfehlen wir, pro Commit etwa 50-100 Dateien hinzuzufügen.</li>`,qt,Le,Qt,Ee,Zl="Nachdem wir die technischen Aspekte gesehen haben, die Sie bei der Strukturierung Ihres Repositories berücksichtigen müssen, schauen wir uns einige praktische Tipps an, um Ihren Upload-Prozess so reibungslos wie möglich zu gestalten.",Yt,Ve,$l=`<li><strong>Fangen Sie klein an</strong>: Wir empfehlen, mit einer kleinen Datenmenge zu beginnen, um Ihr Upload-Skript zu testen. Es ist einfacher, an einem Skript zu arbeiten, wenn ein Fehler nur wenig Zeit kostet.</li> <li><strong>Rechnen Sie mit Ausfällen</strong>: Das Streamen großer Datenmengen ist eine Herausforderung. Sie wissen nicht, was passieren kann, aber es ist immer am besten anzunehmen, dass etwas mindestens einmal schiefgehen wird - unabhängig davon, ob es an Ihrem Gerät, Ihrer Verbindung oder unseren Servern liegt. Wenn Sie zum Beispiel vorhaben, eine große Anzahl von Dateien hochzuladen, ist es am besten, lokal zu verfolgen, welche Dateien Sie bereits hochgeladen haben, bevor Sie die nächste Batch hochladen. Sie können sicher sein, dass eine LFS-Datei, die bereits committed wurde, niemals zweimal hochgeladen wird, aber es kann clientseitig trotzdem Zeit sparen, dies zu überprüfen.</li> <li><strong>Verwenden Sie <code>hf_transfer</code></strong>: Dabei handelt es sich um eine auf Rust basierende <a href="https://github.com/huggingface/hf_transfer" rel="nofollow">Bibliothek</a>, die dazu dient, Uploads auf Maschinen mit sehr hoher Bandbreite zu beschleunigen. Um sie zu verwenden, müssen Sie sie installieren (<code>pip install hf_transfer</code>) und sie durch Einstellen von <code>HF_HUB_ENABLE_HF_TRANSFER=1</code> als Umgebungsvariable aktivieren. Anschließend können Sie <code>huggingface_hub</code> wie gewohnt verwenden.
Hinweis: Dies ist ein Tool für Power-User. Es ist getestet und einsatzbereit, verfügt jedoch nicht über benutzerfreundliche Funktionen wie Fortschrittsanzeigen oder erweiterte Fehlerbehandlung.</li>`,Pt,Fe,Ot,xe,Hl=`Alle oben beschriebenen Methoden verwenden die Hub-API, um Dateien hochzuladen. Dies ist der empfohlene Weg, Dateien in den Hub hochzuladen.
Wir bieten jedoch auch <code>Repository</code> an, einen Wrapper um das git-Tool, um ein lokales Repository zu verwalten.`,Kt,k,Rl=`<p>Obwohl <code>Repository</code> formell nicht als veraltet gekennzeichnet ist, empfehlen wir stattdessen die Nutzung der HTTP-basierten Methoden, die oben beschrieben sind.
Für weitere Details zu dieser Empfehlung werfen Sie bitte einen Blick auf diesen <a href="../concepts/git_vs_http">Leitfaden</a>, der die Kernunterschiede zwischen HTTP- und Git-basierten Ansätzen erklärt.</p>`,es,Ne,Dl="Git LFS verarbeitet automatisch Dateien, die größer als 10MB sind. Für sehr große Dateien (>5GB) müssen Sie jedoch einen benutzerdefinierten Transferagenten für Git LFS installieren:",ns,qe,ts,Qe,Wl="Sie sollten dies für jedes Repository installieren, das eine sehr große Datei enthält. Einmal installiert, können Sie Dateien hochladen, die größer als 5GB sind.",ss,Ye,ls,Pe,Xl="Der <code>commit</code> Kontextmanager handhabt vier der gängigsten Git-Befehle: pull, add, commit und push. <code>git-lfs</code> beobactet automatisch jede Datei, die größer als 10MB ist. Im folgenden Beispiel handhabt der <code>commit</code> Kontextmanager die folgenden Aufgaben:",is,Oe,Al="<li>Holt Daten aus dem <code>text-files</code> Repository.</li> <li>Fügt eine Änderung an <code>file.txt</code> hinzu.</li> <li>Committet die Änderung.</li> <li>Schickt die Änderung an das <code>text-files</code> Repository.</li>",as,Ke,rs,en,Ll="Hier ist ein weiteres Beispiel, wie man den <code>commit</code> Kontextmanager verwendet, um eine Datei in einem Repository zu speichern und hochzuladen:",ds,nn,ps,tn,El="Setzen Sie <code>blocking=False</code>, wenn Sie Ihre Commits asynchron pushen möchten. Das nicht-blockierende Verhalten ist nützlich, wenn Sie Ihr Skript weiterhin ausführen möchten, während Ihre Commits gesendet werden.",os,sn,hs,ln,Vl="Sie können den Status Ihres Pushs mit der Methode <code>command_queue</code> überprüfen:",ms,an,us,rn,Fl="Beachten Sie die Tabelle mit möglichen Statuscodes:",cs,dn,xl="<thead><tr><th>Status</th> <th>Beschreibung</th></tr></thead> <tbody><tr><td>-1</td> <td>Der Push wird ausgeführt.</td></tr> <tr><td>0</td> <td>Der Push wurde erfolgreich beendet.</td></tr> <tr><td>Non-zero</td> <td>Ein Fehler ist aufgetreten.</td></tr></tbody>",gs,pn,Nl="Wenn <code>blocking=False</code> gesetzt ist, werden Befehle beobachtet und Ihr Skript wird erst beendet, wenn alle Pushs abgeschlossen sind, auch wenn andere Fehler in Ihrem Skript auftreten. Einige zusätzliche nützliche Befehle, um den Status eines Pushs zu überprüfen, sind:",Ms,on,ws,hn,fs,mn,ql="Die Klasse <code>Repository</code> hat eine Funktion <code>~Repository.push_to_hub</code>, um Dateien hinzuzufügen, einen Commit zu machen und diese zu einem Repository zu pushen. Im Gegensatz zum <code>commit</code> Kontextmanager müssen Sie zuerst von einem Repository pullen, bevor Sie <code>~Repository.push_to_hub</code> aufrufen.",bs,un,Ql="Zum Beispiel, wenn Sie bereits ein Repository vom Hub geklont haben, können Sie das <code>repo</code> vom lokalen Verzeichnis initialisieren:",Ts,cn,ys,gn,Yl="Aktualisieren Sie Ihren lokalen Klon mit <code>~Repository.git_pull</code> und dann pushen Sie Ihre Datei zum Hub:",Js,Mn,js,wn,Pl="Wenn Sie jedoch noch nicht bereit sind, eine Datei zu pushen, können Sie <code>~Repository.git_add</code> und <code>~Repository.git_commit</code> verwenden, um nur Ihre Datei hinzuzufügen und zu committen:",Us,fn,ks,bn,Ol="Wenn Sie bereit sind, pushen Sie die Datei zu Ihrem Repository mit <code>~Repository.git_push</code>:",Is,Tn,vs,yn,zs,zn,Cs;return v=new ii({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),z=new M({props:{title:"Dateien auf den Hub hochladen",local:"dateien-auf-den-hub-hochladen",headingTag:"h1"}}),B=new g({props:{code:"aGYlMjBhdXRoJTIwbG9naW4lMEElMjMlMjBvZGVyJTIwbWl0JTIwZWluZXIlMjBVbWdlYnVuZ3N2YXJpYWJsZSUwQWhmJTIwYXV0aCUyMGxvZ2luJTIwLS10b2tlbiUyMCUyNEhVR0dJTkdGQUNFX1RPS0VO",highlighted:`hf auth login
<span class="hljs-comment"># oder mit einer Umgebungsvariable</span>
hf auth login --token <span class="hljs-variable">$HUGGINGFACE_TOKEN</span>`,wrap:!1}}),Z=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
<span class="hljs-meta">&gt;&gt;&gt; </span>login()`,wrap:!1}}),$=new M({props:{title:"Datei hochladen",local:"datei-hochladen",headingTag:"h2"}}),D=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS51cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjBwYXRoX29yX2ZpbGVvYmolM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyRlJFQURNRS5tZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMlJFQURNRS5tZCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRnRlc3QtZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">&quot;/path/to/local/folder/README.md&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;README.md&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/test-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new M({props:{title:"Ordner hochladen",local:"ordner-hochladen",headingTag:"h2"}}),A=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEJTIyJTJGcGF0aCUyRnRvJTJGbG9jYWwlMkZzcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LWNvb2wtc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX3R5cGUlM0QlMjJzcGFjZSUyMiUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()

<span class="hljs-comment"># Den gesamten Inhalt aus dem lokalen Ordner in den entfernten Space hoch laden.</span>
<span class="hljs-comment"># Standardmäßig werden Dateien im Hauptverzeichnis des Repos hochgeladen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/space&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-cool-space&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;space&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),V=new g({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIoJTBBJTIwJTIwJTIwJTIwZm9sZGVyX3BhdGglM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMm15LWRhdGFzZXQlMkZ0cmFpbiUyMiUyQyUyMCUyMyUyMEhvY2hsYWRlbiUyMGluJTIwZWluZW4lMjBiZXN0aW1tdGVuJTIwT3JkbmVyJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGdGVzdC1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlnbm9yZV9wYXR0ZXJucyUzRCUyMioqJTJGbG9ncyUyRioudHh0JTIyJTJDJTIwJTIzJTIwQWxsZSUyMFRleHRwcm90b2tvbGxlJTIwaWdub3JpZXJlbiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/folder&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;my-dataset/train&quot;</span>, <span class="hljs-comment"># Hochladen in einen bestimmten Ordner</span>
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/test-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    ignore_patterns=<span class="hljs-string">&quot;**/logs/*.txt&quot;</span>, <span class="hljs-comment"># Alle Textprotokolle ignorieren</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),N=new g({props:{code:"YXBpLnVwbG9hZF9mb2xkZXIoJTBBJTIwJTIwJTIwJTIwZm9sZGVyX3BhdGglM0QlMjIlMkZwYXRoJTJGdG8lMkZsb2NhbCUyRmZvbGRlciUyRmxvZ3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZ0cmFpbmVkLW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIyZXhwZXJpbWVudCUyRmxvZ3MlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19wYXR0ZXJucyUzRCUyMioudHh0JTIyJTJDJTIwJTIzJTIwQWxsZSUyMGxva2FsZW4lMjBUZXh0ZGF0ZWllbiUyMGhvY2hsYWRlbiUwQSUyMCUyMCUyMCUyMGRlbGV0ZV9wYXR0ZXJucyUzRCUyMioudHh0JTIyJTJDJTIwJTIzJTIwVm9yaGVyJTIwYWxsZSUyMGVuZmVybnRlbiUyMFRleHRkYXRlaWVuJTIwbCVDMyVCNnNjaGVuJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/path/to/local/folder/logs&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/trained-model&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;experiment/logs/&quot;</span>,
<span class="hljs-meta">... </span>    allow_patterns=<span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-comment"># Alle lokalen Textdateien hochladen</span>
<span class="hljs-meta">... </span>    delete_patterns=<span class="hljs-string">&quot;*.txt&quot;</span>, <span class="hljs-comment"># Vorher alle enfernten Textdateien löschen</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new M({props:{title:"Erweiterte Funktionen",local:"erweiterte-funktionen",headingTag:"h2"}}),Y=new M({props:{title:"Nicht blockierende Uploads",local:"nicht-blockierende-uploads",headingTag:"h3"}}),O=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWZ1dHVyZSUyMCUzRCUyMGFwaS51cGxvYWRfZm9sZGVyKCUyMCUyMyUyMEhvY2hsYWRlbiUyMGltJTIwSGludGVyZ3J1bmQlMjAobmljaHQlMjBibG9ja2llcmVuZGUlMjBBa3Rpb24pJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmNoZWNrcG9pbnRzLTAwMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJ1bl9hc19mdXR1cmUlM0RUcnVlJTJDJTBBKSUwQWZ1dHVyZSUwQWZ1dHVyZS5kb25lKCklMEFmdXR1cmUucmVzdWx0KCklMjAlMjMlMjBXYXJ0ZW4lMjBiaXMlMjBkZXIlMjBVcGxvYWQlMjBhYmdlc2NobG9zc2VuJTIwaXN0JTIwKGJsb2NraWVyZW5kZSUyMEFrdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>future = api.upload_folder( <span class="hljs-comment"># Hochladen im Hintergrund (nicht blockierende Aktion)</span>
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;checkpoints-001&quot;</span>,
<span class="hljs-meta">... </span>    run_as_future=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>future
Future(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>future.done()
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>future.result() <span class="hljs-comment"># Warten bis der Upload abgeschlossen ist (blockierende Aktion)</span>
...`,wrap:!1}}),ee=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5ydW5fYXNfZnV0dXJlKGFwaS5jcmVhdGVfcmVwbyUyQyUyMCUyMnVzZXJuYW1lJTJGbXktbW9kZWwlMjIlMkMlMjBleGlzdHNfb2slM0RUcnVlKSUwQWFwaS51cGxvYWRfZmlsZSglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMmZpbGUudHh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEYiUyMmZpbGUlMjBjb250ZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwcnVuX2FzX2Z1dHVyZSUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>api.run_as_future(api.create_repo, <span class="hljs-string">&quot;username/my-model&quot;</span>, exists_ok=<span class="hljs-literal">True</span>)
Future(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>api.upload_file(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-model&quot;</span>,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;file.txt&quot;</span>,
<span class="hljs-meta">... </span>    path_or_fileobj=<span class="hljs-string">b&quot;file content&quot;</span>,
<span class="hljs-meta">... </span>    run_as_future=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
Future(...)`,wrap:!1}}),ne=new M({props:{title:"Ordner in Teilen hochladen",local:"ordner-in-teilen-hochladen",headingTag:"h3"}}),ie=new g({props:{code:"dXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMmxvY2FsJTJGY2hlY2twb2ludHMlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMG11bHRpX2NvbW1pdHMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbXVsdGlfY29tbWl0c192ZXJib3NlJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;local/checkpoints&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    multi_commits=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    multi_commits_verbose=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),re=new M({props:{title:"Geplante Uploads",local:"geplante-uploads",headingTag:"h3"}}),oe=new g({props:{code:"aW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMHV1aWQlMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjBncmFkaW8lMjBhcyUyMGdyJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMENvbW1pdFNjaGVkdWxlciUwQSUwQWZlZWRiYWNrX2ZpbGUlMjAlM0QlMjBQYXRoKCUyMnVzZXJfZmVlZGJhY2slMkYlMjIpJTIwJTJGJTIwZiUyMmRhdGFfJTdCdXVpZC51dWlkNCgpJTdELmpzb24lMjIlMEFmZWVkYmFja19mb2xkZXIlMjAlM0QlMjBmZWVkYmFja19maWxlLnBhcmVudCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMENvbW1pdFNjaGVkdWxlciglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIycmVwb3J0LXRyYW5zbGF0aW9uLWZlZWRiYWNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEZmVlZGJhY2tfZm9sZGVyJTJDJTBBJTIwJTIwJTIwJTIwcGF0aF9pbl9yZXBvJTNEJTIyZGF0YSUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2ZXJ5JTNEMTAlMkMlMEEpJTBBJTBBZGVmJTIwc2F2ZV9mZWVkYmFjayhpbnB1dF90ZXh0JTNBc3RyJTJDJTIwb3V0cHV0XzElM0ElMjBzdHIlMkMlMjBvdXRwdXRfMiUzQXN0ciUyQyUyMHVzZXJfY2hvaWNlJTNBJTIwaW50KSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwRiVDMyVCQ2dlJTIwRWluZ2FiZSUyRkF1c2dhYmUlMjB1bmQlMjBCZW51dHplcmZlZWRiYWNrJTIwenUlMjBlaW5lciUyMEpTT04tTGluZXMtRGF0ZWklMjBoaW56dSUyMHVuZCUyMHZlcndlbmRlJTIwZWluJTIwVGhyZWFkLUxvY2slMkMlMjB1bSUyMGdsZWljaHplaXRpZ2VzJTIwU2NocmVpYmVuJTIwdm9uJTIwdmVyc2NoaWVkZW5lbiUyMEJlbnV0emVybiUyMHp1JTIwdmVybWVpZGVuLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHdpdGglMjBzY2hlZHVsZXIubG9jayUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBmZWVkYmFja19maWxlLm9wZW4oJTIyYSUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmLndyaXRlKGpzb24uZHVtcHMoJTdCJTIyaW5wdXQlMjIlM0ElMjBpbnB1dF90ZXh0JTJDJTIwJTIyb3V0cHV0XzElMjIlM0ElMjBvdXRwdXRfMSUyQyUyMCUyMm91dHB1dF8yJTIyJTNBJTIwb3V0cHV0XzIlMkMlMjAlMjJ1c2VyX2Nob2ljZSUyMiUzQSUyMHVzZXJfY2hvaWNlJTdEKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmLndyaXRlKCUyMiU1Q24lMjIpJTBBJTBBd2l0aCUyMGdyLkJsb2NrcygpJTIwYXMlMjBkZW1vJTNBJTBBJTIwJTIwJTIwJTIwLi4uJTIwJTIzJTIwRGVmaW5pZXJlJTIwR3JhZGlvJTIwRGVtbyUyMCUyQiUyMHZlcndlbmRlJTIwJTYwc2F2ZV9mZWVkYmFjayU2MCUwQWRlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> uuid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitScheduler

<span class="hljs-comment"># Definieren Sie die Datei, in der die Daten gespeichert werden sollen. Verwenden Sie UUID, um sicherzustellen, dass vorhandene Daten aus einem früheren Lauf nicht überschrieben werden.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feedback_file = Path(<span class="hljs-string">&quot;user_feedback/&quot;</span>) / <span class="hljs-string">f&quot;data_<span class="hljs-subst">{uuid.uuid4()}</span>.json&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>feedback_folder = feedback_file.parent

<span class="hljs-comment"># Geplante regelmäßige Uploads. Das Remote-Repo und der lokale Ordner werden erstellt, wenn sie noch nicht existieren.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = CommitScheduler(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;report-translation-feedback&quot;</span>,
<span class="hljs-meta">... </span>    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>    folder_path=feedback_folder,
<span class="hljs-meta">... </span>    path_in_repo=<span class="hljs-string">&quot;data&quot;</span>,
<span class="hljs-meta">... </span>    every=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Eine einfache Gradio-Anwendung, die einen Text als Eingabe nimmt und zwei Übersetzungen generiert. Der Benutzer wählt seine bevorzugte Übersetzung aus.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_feedback</span>(<span class="hljs-params">input_text:<span class="hljs-built_in">str</span>, output_1: <span class="hljs-built_in">str</span>, output_2:<span class="hljs-built_in">str</span>, user_choice: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Füge Eingabe/Ausgabe und Benutzerfeedback zu einer JSON-Lines-Datei hinzu und verwende ein Thread-Lock, um gleichzeitiges Schreiben von verschiedenen Benutzern zu vermeiden.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> scheduler.lock:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">with</span> feedback_file.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;a&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>            f.write(json.dumps({<span class="hljs-string">&quot;input&quot;</span>: input_text, <span class="hljs-string">&quot;output_1&quot;</span>: output_1, <span class="hljs-string">&quot;output_2&quot;</span>: output_2, <span class="hljs-string">&quot;user_choice&quot;</span>: user_choice}))
<span class="hljs-meta">... </span>            f.write(<span class="hljs-string">&quot;\\n&quot;</span>)

<span class="hljs-comment"># Starte Gradio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
<span class="hljs-meta">&gt;&gt;&gt; </span>    ... <span class="hljs-comment"># Definiere Gradio Demo + verwende \`save_feedback\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>demo.launch()`,wrap:!1}}),ce=new M({props:{title:"Space Persistenz-Demo",local:"space-persistenz-demo",headingTag:"h4"}}),Me=new M({props:{title:"Benutzerdefinierte Uploads",local:"benutzerdefinierte-uploads",headingTag:"h4"}}),be=new g({props:{code:"Y2xhc3MlMjBaaXBTY2hlZHVsZXIoQ29tbWl0U2NoZWR1bGVyKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHB1c2hfdG9faHViKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwMS4lMjBMaXN0ZSUyMFBORy1EYXRlaWVuJTIwYXVmJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG5nX2ZpbGVzJTIwJTNEJTIwbGlzdChzZWxmLmZvbGRlcl9wYXRoLmdsb2IoJTIyKi5wbmclMjIpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKHBuZ19maWxlcyklMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTm9uZSUyMCUyMCUyMyUyMGtlaHJlJTIwZnIlQzMlQkNoJTIwenVyJUMzJUJDY2slMkMlMjB3ZW5uJTIwbmljaHRzJTIwenUlMjBjb21taXR0ZW4lMjBpc3QlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAyLiUyMFppcHBlJTIwUE5HLURhdGVpZW4lMjBpbiUyMGVpbiUyMGVpbnplbG5lcyUyMEFyY2hpdiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjB0ZW1wZmlsZS5UZW1wb3JhcnlEaXJlY3RvcnkoKSUyMGFzJTIwdG1wZGlyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZV9wYXRoJTIwJTNEJTIwUGF0aCh0bXBkaXIpJTIwJTJGJTIwJTIydHJhaW4uemlwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHppcGZpbGUuWmlwRmlsZShhcmNoaXZlX3BhdGglMkMlMjAlMjJ3JTIyJTJDJTIwemlwZmlsZS5aSVBfREVGTEFURUQpJTIwYXMlMjB6aXAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBwbmdfZmlsZSUyMGluJTIwcG5nX2ZpbGVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwemlwLndyaXRlKGZpbGVuYW1lJTNEcG5nX2ZpbGUlMkMlMjBhcmNuYW1lJTNEcG5nX2ZpbGUubmFtZSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAzLiUyMExhZGUlMjBkYXMlMjBBcmNoaXYlMjBob2NoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5hcGkudXBsb2FkX2ZpbGUoLi4uJTJDJTIwcGF0aF9vcl9maWxlb2JqJTNEYXJjaGl2ZV9wYXRoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMDQuJTIwTCVDMyVCNnNjaGUlMjBsb2thbGUlMjBQTkctRGF0ZWllbiUyQyUyMHVtJTIwc3AlQzMlQTR0ZXJlcyUyMGVybmV1dGVzJTIwSG9jaGxhZGVuJTIwenUlMjB2ZXJtZWlkZW4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBwbmdfZmlsZSUyMGluJTIwcG5nX2ZpbGVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG5nX2ZpbGUudW5saW5rKCk=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ZipScheduler</span>(<span class="hljs-title class_ inherited__">CommitScheduler</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># 1. Liste PNG-Dateien auf</span>
          png_files = <span class="hljs-built_in">list</span>(self.folder_path.glob(<span class="hljs-string">&quot;*.png&quot;</span>))
          <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(png_files) == <span class="hljs-number">0</span>:
              <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>  <span class="hljs-comment"># kehre früh zurück, wenn nichts zu committen ist</span>

        <span class="hljs-comment"># 2. Zippe PNG-Dateien in ein einzelnes Archiv</span>
        <span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
            archive_path = Path(tmpdir) / <span class="hljs-string">&quot;train.zip&quot;</span>
            <span class="hljs-keyword">with</span> zipfile.ZipFile(archive_path, <span class="hljs-string">&quot;w&quot;</span>, zipfile.ZIP_DEFLATED) <span class="hljs-keyword">as</span> <span class="hljs-built_in">zip</span>:
                <span class="hljs-keyword">for</span> png_file <span class="hljs-keyword">in</span> png_files:
                    <span class="hljs-built_in">zip</span>.write(filename=png_file, arcname=png_file.name)

            <span class="hljs-comment"># 3. Lade das Archiv hoch</span>
            self.api.upload_file(..., path_or_fileobj=archive_path)

        <span class="hljs-comment"># 4. Lösche lokale PNG-Dateien, um späteres erneutes Hochladen zu vermeiden</span>
        <span class="hljs-keyword">for</span> png_file <span class="hljs-keyword">in</span> png_files:
            png_file.unlink()`,wrap:!1}}),Je=new M({props:{title:"create_commit",local:"createcommit",headingTag:"h3"}}),ze=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwQ29tbWl0T3BlcmF0aW9uQWRkJTJDJTIwQ29tbWl0T3BlcmF0aW9uRGVsZXRlJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQW9wZXJhdGlvbnMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25BZGQocGF0aF9pbl9yZXBvJTNEJTIyTElDRU5TRS5tZCUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRCUyMn4lMkZyZXBvJTJGTElDRU5TRS5tZCUyMiklMkMlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25BZGQocGF0aF9pbl9yZXBvJTNEJTIyd2VpZ2h0cy5oNSUyMiUyQyUyMHBhdGhfb3JfZmlsZW9iaiUzRCUyMn4lMkZyZXBvJTJGd2VpZ2h0cy1maW5hbC5oNSUyMiklMkMlMEElMjAlMjAlMjAlMjBDb21taXRPcGVyYXRpb25EZWxldGUocGF0aF9pbl9yZXBvJTNEJTIyb2xkLXdlaWdodHMuaDUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwQ29tbWl0T3BlcmF0aW9uRGVsZXRlKHBhdGhfaW5fcmVwbyUzRCUyMmxvZ3MlMkYlMjIpJTJDJTBBJTIwJTIwJTIwJTIwQ29tbWl0T3BlcmF0aW9uQ29weShzcmNfcGF0aF9pbl9yZXBvJTNEJTIyaW1hZ2UucG5nJTIyJTJDJTIwcGF0aF9pbl9yZXBvJTNEJTIyZHVwbGljYXRlX2ltYWdlLnBuZyUyMiklMkMlMEElNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, CommitOperationAdd, CommitOperationDelete
<span class="hljs-meta">&gt;&gt;&gt; </span>api = HfApi()
<span class="hljs-meta">&gt;&gt;&gt; </span>operations = [
<span class="hljs-meta">... </span>    CommitOperationAdd(path_in_repo=<span class="hljs-string">&quot;LICENSE.md&quot;</span>, path_or_fileobj=<span class="hljs-string">&quot;~/repo/LICENSE.md&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationAdd(path_in_repo=<span class="hljs-string">&quot;weights.h5&quot;</span>, path_or_fileobj=<span class="hljs-string">&quot;~/repo/weights-final.h5&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationDelete(path_in_repo=<span class="hljs-string">&quot;old-weights.h5&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationDelete(path_in_repo=<span class="hljs-string">&quot;logs/&quot;</span>),
<span class="hljs-meta">... </span>    CommitOperationCopy(src_path_in_repo=<span class="hljs-string">&quot;image.png&quot;</span>, path_in_repo=<span class="hljs-string">&quot;duplicate_image.png&quot;</span>),
<span class="hljs-meta">... </span>]`,wrap:!1}}),Ce=new g({props:{code:"YXBpLmNyZWF0ZV9jb21taXQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGdGVzdC1tb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wZXJhdGlvbnMlM0RvcGVyYXRpb25zJTJDJTBBJTIwJTIwJTIwJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJIb2NobGFkZW4lMjBtZWluZXIlMjBNb2RlbGwtR2V3aWNodGUlMjB1bmQlMjAtTGl6ZW56JTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>api.create_commit(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;lysandre/test-model&quot;</span>,
<span class="hljs-meta">... </span>    operations=operations,
<span class="hljs-meta">... </span>    commit_message=<span class="hljs-string">&quot;Hochladen meiner Modell-Gewichte und -Lizenz&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Be=new M({props:{title:"Tipps und Tricks für große Uploads",local:"tipps-und-tricks-für-große-uploads",headingTag:"h2"}}),De=new M({props:{title:"Hub-Repository Größenbeschränkungen",local:"hub-repository-größenbeschränkungen",headingTag:"h3"}}),Le=new M({props:{title:"Praktische Tipps",local:"praktische-tipps",headingTag:"h3"}}),Fe=new M({props:{title:"(veraltet) Dateien mit Git LFS hochladen",local:"veraltet-dateien-mit-git-lfs-hochladen",headingTag:"h2"}}),qe=new g({props:{code:"aGYlMjBsZnMtZW5hYmxlLWxhcmdlZmlsZXMlMjAu",highlighted:"hf lfs-enable-largefiles .",wrap:!1}}),Ye=new M({props:{title:"commit Kontextmanager",local:"commit-kontextmanager",headingTag:"h3"}}),Ke=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEF3aXRoJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJ0ZXh0LWZpbGVzJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMiUzQ3VzZXIlM0UlMkZ0ZXh0LWZpbGVzJTIyKS5jb21taXQoY29tbWl0X21lc3NhZ2UlM0QlMjJNZWluJTIwZXJzdGUlMjBEYXRlaSUyMCUzQSklMjIpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oJTIyZmlsZS50eHQlMjIlMkMlMjAlMjJ3JTJCJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYud3JpdGUoanNvbi5kdW1wcyglN0IlMjJoZXklMjIlM0ElMjA4JTdEKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(local_dir=<span class="hljs-string">&quot;text-files&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/text-files&quot;</span>).commit(commit_message=<span class="hljs-string">&quot;Mein erste Datei :)&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;file.txt&quot;</span>, <span class="hljs-string">&quot;w+&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(json.dumps({<span class="hljs-string">&quot;hey&quot;</span>: <span class="hljs-number">8</span>}))`,wrap:!1}}),nn=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFtb2RlbCUyMCUzRCUyMHRvcmNoLm5uLlRyYW5zZm9ybWVyKCklMEF3aXRoJTIwUmVwb3NpdG9yeSglMjJ0b3JjaC1tb2RlbCUyMiUyQyUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGdG9yY2gtbW9kZWwlMjIlMkMlMjB0b2tlbiUzRFRydWUpLmNvbW1pdChjb21taXRfbWVzc2FnZSUzRCUyMk1laW4lMjBjb29sZXMlMjBNb2RlbCUyMCUzQSklMjIpJTNBJTBBJTIwJTIwJTIwJTIwdG9yY2guc2F2ZShtb2RlbC5zdGF0ZV9kaWN0KCklMkMlMjAlMjJtb2RlbC5wdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.nn.Transformer()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(<span class="hljs-string">&quot;torch-model&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/torch-model&quot;</span>, token=<span class="hljs-literal">True</span>).commit(commit_message=<span class="hljs-string">&quot;Mein cooles Model :)&quot;</span>):
<span class="hljs-meta">... </span>    torch.save(model.state_dict(), <span class="hljs-string">&quot;model.pt&quot;</span>)`,wrap:!1}}),sn=new g({props:{code:"d2l0aCUyMHJlcG8uY29tbWl0KGNvbW1pdF9tZXNzYWdlJTNEJTIyTWVpbiUyMGNvb2xlcyUyME1vZGVsJTIwJTNBKSUyMiUyQyUyMGJsb2NraW5nJTNERmFsc2Up",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> repo.commit(commit_message=<span class="hljs-string">&quot;Mein cooles Model :)&quot;</span>, blocking=<span class="hljs-literal">False</span>)',wrap:!1}}),an=new g({props:{code:"bGFzdF9jb21tYW5kJTIwJTNEJTIwcmVwby5jb21tYW5kX3F1ZXVlJTVCLTElNUQlMEFsYXN0X2NvbW1hbmQuc3RhdHVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>last_command = repo.command_queue[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.status`,wrap:!1}}),on=new g({props:{code:"bGFzdF9jb21tYW5kLnN0ZGVyciUwQSUwQWxhc3RfY29tbWFuZC5pc19kb25lJTBBJTBBbGFzdF9jb21tYW5kLmZhaWxlZA==",highlighted:`<span class="hljs-comment"># Einen Fehler inspizieren.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.stderr

<span class="hljs-comment"># Überprüfen, ob ein Push abgeschlossen ist oder noch läuft.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.is_done

<span class="hljs-comment"># Überprüfen, ob bei einem Push-Befehl ein Fehler aufgetreten ist.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>last_command.failed`,wrap:!1}}),hn=new M({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),cn=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJwZmFkJTJGenVyJTJGbG9rYWxlbiUyRnJlcG8lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;pfad/zur/lokalen/repo&quot;</span>)`,wrap:!1}}),Mn=new g({props:{code:"cmVwby5naXRfcHVsbCgpJTBBcmVwby5wdXNoX3RvX2h1Yihjb21taXRfbWVzc2FnZSUzRCUyMkNvbW1pdHRlJTIwbWVpbmUlMjBnZW5pYWxlJTIwRGF0ZWklMjB6dW0lMjBIdWIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull()
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.push_to_hub(commit_message=<span class="hljs-string">&quot;Committe meine geniale Datei zum Hub&quot;</span>)`,wrap:!1}}),fn=new g({props:{code:"cmVwby5naXRfYWRkKCUyMnBhdGglMkZ0byUyRmZpbGUlMjIpJTBBcmVwby5naXRfY29tbWl0KGNvbW1pdF9tZXNzYWdlJTNEJTIyZiVDMyVCQ2dlJTIwbWVpbmUlMjBlcnN0ZSUyME1vZGVsbC1Lb25maWd1cmF0aW9uc2RhdGVpJTIwaGluenUlMjAlM0EpJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_add(<span class="hljs-string">&quot;path/to/file&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_commit(commit_message=<span class="hljs-string">&quot;füge meine erste Modell-Konfigurationsdatei hinzu :)&quot;</span>)`,wrap:!1}}),Tn=new g({props:{code:"cmVwby5naXRfcHVzaCgp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_push()',wrap:!1}}),yn=new ai({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/upload.md"}}),{c(){b=a("meta"),_n=l(),vn=a("p"),Sn=l(),p(v.$$.fragment),Gn=l(),p(z.$$.fragment),Bn=l(),C=a("p"),C.innerHTML=Ds,Zn=l(),_=a("ul"),_.innerHTML=Ws,$n=l(),S=a("p"),S.textContent=Xs,Hn=l(),T=a("ul"),G=a("li"),jn=a("p"),jn.textContent=As,Gs=l(),p(B.$$.fragment),Bs=l(),f=a("li"),Un=a("p"),Un.innerHTML=Ls,Zs=l(),p(Z.$$.fragment),$s=l(),kn=a("p"),kn.innerHTML=Es,Hs=l(),In=a("p"),In.innerHTML=Vs,Rn=l(),p($.$$.fragment),Dn=l(),H=a("p"),H.innerHTML=Fs,Wn=l(),R=a("p"),R.innerHTML=xs,Xn=l(),p(D.$$.fragment),An=l(),p(W.$$.fragment),Ln=l(),X=a("p"),X.innerHTML=Ns,En=l(),p(A.$$.fragment),Vn=l(),L=a("p"),L.innerHTML=qs,Fn=l(),E=a("p"),E.innerHTML=Qs,xn=l(),p(V.$$.fragment),Nn=l(),F=a("p"),F.innerHTML=Ys,qn=l(),x=a("p"),x.innerHTML=Ps,Qn=l(),p(N.$$.fragment),Yn=l(),p(q.$$.fragment),Pn=l(),Q=a("p"),Q.innerHTML=Os,On=l(),p(Y.$$.fragment),Kn=l(),P=a("p"),P.innerHTML=Ks,et=l(),p(O.$$.fragment),nt=l(),y=a("blockquote"),y.innerHTML=el,tt=l(),K=a("p"),K.innerHTML=nl,st=l(),p(ee.$$.fragment),lt=l(),p(ne.$$.fragment),it=l(),te=a("p"),te.innerHTML=tl,at=l(),se=a("p"),se.innerHTML=sl,rt=l(),le=a("p"),le.innerHTML=ll,dt=l(),p(ie.$$.fragment),pt=l(),ae=a("p"),ae.innerHTML=il,ot=l(),J=a("blockquote"),J.innerHTML=al,ht=l(),p(re.$$.fragment),mt=l(),de=a("p"),de.innerHTML=rl,ut=l(),pe=a("p"),pe.innerHTML=dl,ct=l(),p(oe.$$.fragment),gt=l(),he=a("p"),he.textContent=pl,Mt=l(),me=a("p"),me.innerHTML=ol,wt=l(),ue=a("ul"),ue.innerHTML=hl,ft=l(),p(ce.$$.fragment),bt=l(),ge=a("p"),ge.innerHTML=ml,Tt=l(),p(Me.$$.fragment),yt=l(),we=a("p"),we.innerHTML=ul,Jt=l(),fe=a("p"),fe.innerHTML=cl,jt=l(),p(be.$$.fragment),Ut=l(),Te=a("p"),Te.innerHTML=gl,kt=l(),ye=a("ul"),ye.innerHTML=Ml,It=l(),j=a("blockquote"),j.innerHTML=wl,vt=l(),p(Je.$$.fragment),zt=l(),je=a("p"),je.innerHTML=fl,Ct=l(),Ue=a("p"),Ue.innerHTML=bl,_t=l(),ke=a("ul"),ke.innerHTML=Tl,St=l(),Ie=a("p"),Ie.textContent=yl,Gt=l(),ve=a("ol"),ve.innerHTML=Jl,Bt=l(),p(ze.$$.fragment),Zt=l(),U=a("ol"),U.innerHTML=jl,$t=l(),p(Ce.$$.fragment),Ht=l(),_e=a("p"),_e.innerHTML=Ul,Rt=l(),Se=a("ul"),Se.innerHTML=kl,Dt=l(),Ge=a("p"),Ge.innerHTML=Il,Wt=l(),p(Be.$$.fragment),Xt=l(),Ze=a("p"),Ze.textContent=vl,At=l(),$e=a("table"),$e.innerHTML=zl,Lt=l(),He=a("p"),He.innerHTML=Cl,Et=l(),Re=a("p"),Re.textContent=_l,Vt=l(),p(De.$$.fragment),Ft=l(),We=a("p"),We.textContent=Sl,xt=l(),Xe=a("p"),Xe.innerHTML=Gl,Nt=l(),Ae=a("ul"),Ae.innerHTML=Bl,qt=l(),p(Le.$$.fragment),Qt=l(),Ee=a("p"),Ee.textContent=Zl,Yt=l(),Ve=a("ul"),Ve.innerHTML=$l,Pt=l(),p(Fe.$$.fragment),Ot=l(),xe=a("p"),xe.innerHTML=Hl,Kt=l(),k=a("blockquote"),k.innerHTML=Rl,es=l(),Ne=a("p"),Ne.textContent=Dl,ns=l(),p(qe.$$.fragment),ts=l(),Qe=a("p"),Qe.textContent=Wl,ss=l(),p(Ye.$$.fragment),ls=l(),Pe=a("p"),Pe.innerHTML=Xl,is=l(),Oe=a("ol"),Oe.innerHTML=Al,as=l(),p(Ke.$$.fragment),rs=l(),en=a("p"),en.innerHTML=Ll,ds=l(),p(nn.$$.fragment),ps=l(),tn=a("p"),tn.innerHTML=El,os=l(),p(sn.$$.fragment),hs=l(),ln=a("p"),ln.innerHTML=Vl,ms=l(),p(an.$$.fragment),us=l(),rn=a("p"),rn.textContent=Fl,cs=l(),dn=a("table"),dn.innerHTML=xl,gs=l(),pn=a("p"),pn.innerHTML=Nl,Ms=l(),p(on.$$.fragment),ws=l(),p(hn.$$.fragment),fs=l(),mn=a("p"),mn.innerHTML=ql,bs=l(),un=a("p"),un.innerHTML=Ql,Ts=l(),p(cn.$$.fragment),ys=l(),gn=a("p"),gn.innerHTML=Yl,Js=l(),p(Mn.$$.fragment),js=l(),wn=a("p"),wn.innerHTML=Pl,Us=l(),p(fn.$$.fragment),ks=l(),bn=a("p"),bn.innerHTML=Ol,Is=l(),p(Tn.$$.fragment),vs=l(),p(yn.$$.fragment),zs=l(),zn=a("p"),this.h()},l(e){const n=li("svelte-u9bgzb",document.head);b=r(n,"META",{name:!0,content:!0}),n.forEach(t),_n=i(e),vn=r(e,"P",{}),Cn(vn).forEach(t),Sn=i(e),o(v.$$.fragment,e),Gn=i(e),o(z.$$.fragment,e),Bn=i(e),C=r(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-114xw3z"&&(C.innerHTML=Ds),Zn=i(e),_=r(e,"UL",{"data-svelte-h":!0}),d(_)!=="svelte-8usn7a"&&(_.innerHTML=Ws),$n=i(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-cdvrkx"&&(S.textContent=Xs),Hn=i(e),T=r(e,"UL",{});var _s=Cn(T);G=r(_s,"LI",{});var Ss=Cn(G);jn=r(Ss,"P",{"data-svelte-h":!0}),d(jn)!=="svelte-umgrcx"&&(jn.textContent=As),Gs=i(Ss),o(B.$$.fragment,Ss),Ss.forEach(t),Bs=i(_s),f=r(_s,"LI",{});var I=Cn(f);Un=r(I,"P",{"data-svelte-h":!0}),d(Un)!=="svelte-6b2bd5"&&(Un.innerHTML=Ls),Zs=i(I),o(Z.$$.fragment,I),$s=i(I),kn=r(I,"P",{"data-svelte-h":!0}),d(kn)!=="svelte-1ctmzvx"&&(kn.innerHTML=Es),Hs=i(I),In=r(I,"P",{"data-svelte-h":!0}),d(In)!=="svelte-133nfh4"&&(In.innerHTML=Vs),I.forEach(t),_s.forEach(t),Rn=i(e),o($.$$.fragment,e),Dn=i(e),H=r(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-1dfvtbd"&&(H.innerHTML=Fs),Wn=i(e),R=r(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1n36ycg"&&(R.innerHTML=xs),Xn=i(e),o(D.$$.fragment,e),An=i(e),o(W.$$.fragment,e),Ln=i(e),X=r(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-j7pi6k"&&(X.innerHTML=Ns),En=i(e),o(A.$$.fragment,e),Vn=i(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1pbvdnu"&&(L.innerHTML=qs),Fn=i(e),E=r(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-5vdggv"&&(E.innerHTML=Qs),xn=i(e),o(V.$$.fragment,e),Nn=i(e),F=r(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-7uym69"&&(F.innerHTML=Ys),qn=i(e),x=r(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-8qbbfh"&&(x.innerHTML=Ps),Qn=i(e),o(N.$$.fragment,e),Yn=i(e),o(q.$$.fragment,e),Pn=i(e),Q=r(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1er2klo"&&(Q.innerHTML=Os),On=i(e),o(Y.$$.fragment,e),Kn=i(e),P=r(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-kvfjdh"&&(P.innerHTML=Ks),et=i(e),o(O.$$.fragment,e),nt=i(e),y=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(y)!=="svelte-b12d5k"&&(y.innerHTML=el),tt=i(e),K=r(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1r1y404"&&(K.innerHTML=nl),st=i(e),o(ee.$$.fragment,e),lt=i(e),o(ne.$$.fragment,e),it=i(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1vaz587"&&(te.innerHTML=tl),at=i(e),se=r(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-rby1he"&&(se.innerHTML=sl),rt=i(e),le=r(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-vty75k"&&(le.innerHTML=ll),dt=i(e),o(ie.$$.fragment,e),pt=i(e),ae=r(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-17r1syw"&&(ae.innerHTML=il),ot=i(e),J=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(J)!=="svelte-1etd3hp"&&(J.innerHTML=al),ht=i(e),o(re.$$.fragment,e),mt=i(e),de=r(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-dt9p60"&&(de.innerHTML=rl),ut=i(e),pe=r(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-yl5dbd"&&(pe.innerHTML=dl),ct=i(e),o(oe.$$.fragment,e),gt=i(e),he=r(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-9dm96i"&&(he.textContent=pl),Mt=i(e),me=r(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-2ujvhl"&&(me.innerHTML=ol),wt=i(e),ue=r(e,"UL",{"data-svelte-h":!0}),d(ue)!=="svelte-1n0uoup"&&(ue.innerHTML=hl),ft=i(e),o(ce.$$.fragment,e),bt=i(e),ge=r(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-15t2mz9"&&(ge.innerHTML=ml),Tt=i(e),o(Me.$$.fragment,e),yt=i(e),we=r(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-qxkcp7"&&(we.innerHTML=ul),Jt=i(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-r02ie6"&&(fe.innerHTML=cl),jt=i(e),o(be.$$.fragment,e),Ut=i(e),Te=r(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1kgsx3b"&&(Te.innerHTML=gl),kt=i(e),ye=r(e,"UL",{"data-svelte-h":!0}),d(ye)!=="svelte-g5kpve"&&(ye.innerHTML=Ml),It=i(e),j=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(j)!=="svelte-1slhgg6"&&(j.innerHTML=wl),vt=i(e),o(Je.$$.fragment,e),zt=i(e),je=r(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-295c4n"&&(je.innerHTML=fl),Ct=i(e),Ue=r(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1egtusl"&&(Ue.innerHTML=bl),_t=i(e),ke=r(e,"UL",{"data-svelte-h":!0}),d(ke)!=="svelte-1msl7bh"&&(ke.innerHTML=Tl),St=i(e),Ie=r(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-t8ao7l"&&(Ie.textContent=yl),Gt=i(e),ve=r(e,"OL",{"data-svelte-h":!0}),d(ve)!=="svelte-1jt2hpm"&&(ve.innerHTML=Jl),Bt=i(e),o(ze.$$.fragment,e),Zt=i(e),U=r(e,"OL",{start:!0,"data-svelte-h":!0}),d(U)!=="svelte-1xllltg"&&(U.innerHTML=jl),$t=i(e),o(Ce.$$.fragment,e),Ht=i(e),_e=r(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-15h4434"&&(_e.innerHTML=Ul),Rt=i(e),Se=r(e,"UL",{"data-svelte-h":!0}),d(Se)!=="svelte-1yofes3"&&(Se.innerHTML=kl),Dt=i(e),Ge=r(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-dk98c8"&&(Ge.innerHTML=Il),Wt=i(e),o(Be.$$.fragment,e),Xt=i(e),Ze=r(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-14ue8hi"&&(Ze.textContent=vl),At=i(e),$e=r(e,"TABLE",{"data-svelte-h":!0}),d($e)!=="svelte-bnqzez"&&($e.innerHTML=zl),Lt=i(e),He=r(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-yadqf2"&&(He.innerHTML=Cl),Et=i(e),Re=r(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-q6n0zj"&&(Re.textContent=_l),Vt=i(e),o(De.$$.fragment,e),Ft=i(e),We=r(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-15fsi6q"&&(We.textContent=Sl),xt=i(e),Xe=r(e,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-t5ulc8"&&(Xe.innerHTML=Gl),Nt=i(e),Ae=r(e,"UL",{"data-svelte-h":!0}),d(Ae)!=="svelte-q804pl"&&(Ae.innerHTML=Bl),qt=i(e),o(Le.$$.fragment,e),Qt=i(e),Ee=r(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1ls8orn"&&(Ee.textContent=Zl),Yt=i(e),Ve=r(e,"UL",{"data-svelte-h":!0}),d(Ve)!=="svelte-hebfqp"&&(Ve.innerHTML=$l),Pt=i(e),o(Fe.$$.fragment,e),Ot=i(e),xe=r(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-91yc6i"&&(xe.innerHTML=Hl),Kt=i(e),k=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),d(k)!=="svelte-1rjqx3m"&&(k.innerHTML=Rl),es=i(e),Ne=r(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-10wsoxt"&&(Ne.textContent=Dl),ns=i(e),o(qe.$$.fragment,e),ts=i(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-10ywdme"&&(Qe.textContent=Wl),ss=i(e),o(Ye.$$.fragment,e),ls=i(e),Pe=r(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-uvk78l"&&(Pe.innerHTML=Xl),is=i(e),Oe=r(e,"OL",{"data-svelte-h":!0}),d(Oe)!=="svelte-10cv9c7"&&(Oe.innerHTML=Al),as=i(e),o(Ke.$$.fragment,e),rs=i(e),en=r(e,"P",{"data-svelte-h":!0}),d(en)!=="svelte-1pkfaao"&&(en.innerHTML=Ll),ds=i(e),o(nn.$$.fragment,e),ps=i(e),tn=r(e,"P",{"data-svelte-h":!0}),d(tn)!=="svelte-1xa4cog"&&(tn.innerHTML=El),os=i(e),o(sn.$$.fragment,e),hs=i(e),ln=r(e,"P",{"data-svelte-h":!0}),d(ln)!=="svelte-8fnwhj"&&(ln.innerHTML=Vl),ms=i(e),o(an.$$.fragment,e),us=i(e),rn=r(e,"P",{"data-svelte-h":!0}),d(rn)!=="svelte-1ou7b1z"&&(rn.textContent=Fl),cs=i(e),dn=r(e,"TABLE",{"data-svelte-h":!0}),d(dn)!=="svelte-1hf9nu8"&&(dn.innerHTML=xl),gs=i(e),pn=r(e,"P",{"data-svelte-h":!0}),d(pn)!=="svelte-2zhs7n"&&(pn.innerHTML=Nl),Ms=i(e),o(on.$$.fragment,e),ws=i(e),o(hn.$$.fragment,e),fs=i(e),mn=r(e,"P",{"data-svelte-h":!0}),d(mn)!=="svelte-1h643lo"&&(mn.innerHTML=ql),bs=i(e),un=r(e,"P",{"data-svelte-h":!0}),d(un)!=="svelte-o21xq"&&(un.innerHTML=Ql),Ts=i(e),o(cn.$$.fragment,e),ys=i(e),gn=r(e,"P",{"data-svelte-h":!0}),d(gn)!=="svelte-yyhw2f"&&(gn.innerHTML=Yl),Js=i(e),o(Mn.$$.fragment,e),js=i(e),wn=r(e,"P",{"data-svelte-h":!0}),d(wn)!=="svelte-8wkql8"&&(wn.innerHTML=Pl),Us=i(e),o(fn.$$.fragment,e),ks=i(e),bn=r(e,"P",{"data-svelte-h":!0}),d(bn)!=="svelte-16acqbp"&&(bn.innerHTML=Ol),Is=i(e),o(Tn.$$.fragment,e),vs=i(e),o(yn.$$.fragment,e),zs=i(e),zn=r(e,"P",{}),Cn(zn).forEach(t),this.h()},h(){Jn(b,"name","hf:doc:metadata"),Jn(b,"content",di),Jn(y,"class","tip"),Jn(J,"class","warning"),Jn(j,"class","tip"),Jn(U,"start","2"),Jn(k,"class","warning")},m(e,n){w(document.head,b),s(e,_n,n),s(e,vn,n),s(e,Sn,n),h(v,e,n),s(e,Gn,n),h(z,e,n),s(e,Bn,n),s(e,C,n),s(e,Zn,n),s(e,_,n),s(e,$n,n),s(e,S,n),s(e,Hn,n),s(e,T,n),w(T,G),w(G,jn),w(G,Gs),h(B,G,null),w(T,Bs),w(T,f),w(f,Un),w(f,Zs),h(Z,f,null),w(f,$s),w(f,kn),w(f,Hs),w(f,In),s(e,Rn,n),h($,e,n),s(e,Dn,n),s(e,H,n),s(e,Wn,n),s(e,R,n),s(e,Xn,n),h(D,e,n),s(e,An,n),h(W,e,n),s(e,Ln,n),s(e,X,n),s(e,En,n),h(A,e,n),s(e,Vn,n),s(e,L,n),s(e,Fn,n),s(e,E,n),s(e,xn,n),h(V,e,n),s(e,Nn,n),s(e,F,n),s(e,qn,n),s(e,x,n),s(e,Qn,n),h(N,e,n),s(e,Yn,n),h(q,e,n),s(e,Pn,n),s(e,Q,n),s(e,On,n),h(Y,e,n),s(e,Kn,n),s(e,P,n),s(e,et,n),h(O,e,n),s(e,nt,n),s(e,y,n),s(e,tt,n),s(e,K,n),s(e,st,n),h(ee,e,n),s(e,lt,n),h(ne,e,n),s(e,it,n),s(e,te,n),s(e,at,n),s(e,se,n),s(e,rt,n),s(e,le,n),s(e,dt,n),h(ie,e,n),s(e,pt,n),s(e,ae,n),s(e,ot,n),s(e,J,n),s(e,ht,n),h(re,e,n),s(e,mt,n),s(e,de,n),s(e,ut,n),s(e,pe,n),s(e,ct,n),h(oe,e,n),s(e,gt,n),s(e,he,n),s(e,Mt,n),s(e,me,n),s(e,wt,n),s(e,ue,n),s(e,ft,n),h(ce,e,n),s(e,bt,n),s(e,ge,n),s(e,Tt,n),h(Me,e,n),s(e,yt,n),s(e,we,n),s(e,Jt,n),s(e,fe,n),s(e,jt,n),h(be,e,n),s(e,Ut,n),s(e,Te,n),s(e,kt,n),s(e,ye,n),s(e,It,n),s(e,j,n),s(e,vt,n),h(Je,e,n),s(e,zt,n),s(e,je,n),s(e,Ct,n),s(e,Ue,n),s(e,_t,n),s(e,ke,n),s(e,St,n),s(e,Ie,n),s(e,Gt,n),s(e,ve,n),s(e,Bt,n),h(ze,e,n),s(e,Zt,n),s(e,U,n),s(e,$t,n),h(Ce,e,n),s(e,Ht,n),s(e,_e,n),s(e,Rt,n),s(e,Se,n),s(e,Dt,n),s(e,Ge,n),s(e,Wt,n),h(Be,e,n),s(e,Xt,n),s(e,Ze,n),s(e,At,n),s(e,$e,n),s(e,Lt,n),s(e,He,n),s(e,Et,n),s(e,Re,n),s(e,Vt,n),h(De,e,n),s(e,Ft,n),s(e,We,n),s(e,xt,n),s(e,Xe,n),s(e,Nt,n),s(e,Ae,n),s(e,qt,n),h(Le,e,n),s(e,Qt,n),s(e,Ee,n),s(e,Yt,n),s(e,Ve,n),s(e,Pt,n),h(Fe,e,n),s(e,Ot,n),s(e,xe,n),s(e,Kt,n),s(e,k,n),s(e,es,n),s(e,Ne,n),s(e,ns,n),h(qe,e,n),s(e,ts,n),s(e,Qe,n),s(e,ss,n),h(Ye,e,n),s(e,ls,n),s(e,Pe,n),s(e,is,n),s(e,Oe,n),s(e,as,n),h(Ke,e,n),s(e,rs,n),s(e,en,n),s(e,ds,n),h(nn,e,n),s(e,ps,n),s(e,tn,n),s(e,os,n),h(sn,e,n),s(e,hs,n),s(e,ln,n),s(e,ms,n),h(an,e,n),s(e,us,n),s(e,rn,n),s(e,cs,n),s(e,dn,n),s(e,gs,n),s(e,pn,n),s(e,Ms,n),h(on,e,n),s(e,ws,n),h(hn,e,n),s(e,fs,n),s(e,mn,n),s(e,bs,n),s(e,un,n),s(e,Ts,n),h(cn,e,n),s(e,ys,n),s(e,gn,n),s(e,Js,n),h(Mn,e,n),s(e,js,n),s(e,wn,n),s(e,Us,n),h(fn,e,n),s(e,ks,n),s(e,bn,n),s(e,Is,n),h(Tn,e,n),s(e,vs,n),h(yn,e,n),s(e,zs,n),s(e,zn,n),Cs=!0},p:ei,i(e){Cs||(m(v.$$.fragment,e),m(z.$$.fragment,e),m(B.$$.fragment,e),m(Z.$$.fragment,e),m($.$$.fragment,e),m(D.$$.fragment,e),m(W.$$.fragment,e),m(A.$$.fragment,e),m(V.$$.fragment,e),m(N.$$.fragment,e),m(q.$$.fragment,e),m(Y.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(Me.$$.fragment,e),m(be.$$.fragment,e),m(Je.$$.fragment,e),m(ze.$$.fragment,e),m(Ce.$$.fragment,e),m(Be.$$.fragment,e),m(De.$$.fragment,e),m(Le.$$.fragment,e),m(Fe.$$.fragment,e),m(qe.$$.fragment,e),m(Ye.$$.fragment,e),m(Ke.$$.fragment,e),m(nn.$$.fragment,e),m(sn.$$.fragment,e),m(an.$$.fragment,e),m(on.$$.fragment,e),m(hn.$$.fragment,e),m(cn.$$.fragment,e),m(Mn.$$.fragment,e),m(fn.$$.fragment,e),m(Tn.$$.fragment,e),m(yn.$$.fragment,e),Cs=!0)},o(e){u(v.$$.fragment,e),u(z.$$.fragment,e),u(B.$$.fragment,e),u(Z.$$.fragment,e),u($.$$.fragment,e),u(D.$$.fragment,e),u(W.$$.fragment,e),u(A.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(q.$$.fragment,e),u(Y.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(Me.$$.fragment,e),u(be.$$.fragment,e),u(Je.$$.fragment,e),u(ze.$$.fragment,e),u(Ce.$$.fragment,e),u(Be.$$.fragment,e),u(De.$$.fragment,e),u(Le.$$.fragment,e),u(Fe.$$.fragment,e),u(qe.$$.fragment,e),u(Ye.$$.fragment,e),u(Ke.$$.fragment,e),u(nn.$$.fragment,e),u(sn.$$.fragment,e),u(an.$$.fragment,e),u(on.$$.fragment,e),u(hn.$$.fragment,e),u(cn.$$.fragment,e),u(Mn.$$.fragment,e),u(fn.$$.fragment,e),u(Tn.$$.fragment,e),u(yn.$$.fragment,e),Cs=!1},d(e){e&&(t(_n),t(vn),t(Sn),t(Gn),t(Bn),t(C),t(Zn),t(_),t($n),t(S),t(Hn),t(T),t(Rn),t(Dn),t(H),t(Wn),t(R),t(Xn),t(An),t(Ln),t(X),t(En),t(Vn),t(L),t(Fn),t(E),t(xn),t(Nn),t(F),t(qn),t(x),t(Qn),t(Yn),t(Pn),t(Q),t(On),t(Kn),t(P),t(et),t(nt),t(y),t(tt),t(K),t(st),t(lt),t(it),t(te),t(at),t(se),t(rt),t(le),t(dt),t(pt),t(ae),t(ot),t(J),t(ht),t(mt),t(de),t(ut),t(pe),t(ct),t(gt),t(he),t(Mt),t(me),t(wt),t(ue),t(ft),t(bt),t(ge),t(Tt),t(yt),t(we),t(Jt),t(fe),t(jt),t(Ut),t(Te),t(kt),t(ye),t(It),t(j),t(vt),t(zt),t(je),t(Ct),t(Ue),t(_t),t(ke),t(St),t(Ie),t(Gt),t(ve),t(Bt),t(Zt),t(U),t($t),t(Ht),t(_e),t(Rt),t(Se),t(Dt),t(Ge),t(Wt),t(Xt),t(Ze),t(At),t($e),t(Lt),t(He),t(Et),t(Re),t(Vt),t(Ft),t(We),t(xt),t(Xe),t(Nt),t(Ae),t(qt),t(Qt),t(Ee),t(Yt),t(Ve),t(Pt),t(Ot),t(xe),t(Kt),t(k),t(es),t(Ne),t(ns),t(ts),t(Qe),t(ss),t(ls),t(Pe),t(is),t(Oe),t(as),t(rs),t(en),t(ds),t(ps),t(tn),t(os),t(hs),t(ln),t(ms),t(us),t(rn),t(cs),t(dn),t(gs),t(pn),t(Ms),t(ws),t(fs),t(mn),t(bs),t(un),t(Ts),t(ys),t(gn),t(Js),t(js),t(wn),t(Us),t(ks),t(bn),t(Is),t(vs),t(zs),t(zn)),t(b),c(v,e),c(z,e),c(B),c(Z),c($,e),c(D,e),c(W,e),c(A,e),c(V,e),c(N,e),c(q,e),c(Y,e),c(O,e),c(ee,e),c(ne,e),c(ie,e),c(re,e),c(oe,e),c(ce,e),c(Me,e),c(be,e),c(Je,e),c(ze,e),c(Ce,e),c(Be,e),c(De,e),c(Le,e),c(Fe,e),c(qe,e),c(Ye,e),c(Ke,e),c(nn,e),c(sn,e),c(an,e),c(on,e),c(hn,e),c(cn,e),c(Mn,e),c(fn,e),c(Tn,e),c(yn,e)}}}const di='{"title":"Dateien auf den Hub hochladen","local":"dateien-auf-den-hub-hochladen","sections":[{"title":"Datei hochladen","local":"datei-hochladen","sections":[],"depth":2},{"title":"Ordner hochladen","local":"ordner-hochladen","sections":[],"depth":2},{"title":"Erweiterte Funktionen","local":"erweiterte-funktionen","sections":[{"title":"Nicht blockierende Uploads","local":"nicht-blockierende-uploads","sections":[],"depth":3},{"title":"Ordner in Teilen hochladen","local":"ordner-in-teilen-hochladen","sections":[],"depth":3},{"title":"Geplante Uploads","local":"geplante-uploads","sections":[{"title":"Space Persistenz-Demo","local":"space-persistenz-demo","sections":[],"depth":4},{"title":"Benutzerdefinierte Uploads","local":"benutzerdefinierte-uploads","sections":[],"depth":4}],"depth":3},{"title":"create_commit","local":"createcommit","sections":[],"depth":3}],"depth":2},{"title":"Tipps und Tricks für große Uploads","local":"tipps-und-tricks-für-große-uploads","sections":[{"title":"Hub-Repository Größenbeschränkungen","local":"hub-repository-größenbeschränkungen","sections":[],"depth":3},{"title":"Praktische Tipps","local":"praktische-tipps","sections":[],"depth":3}],"depth":2},{"title":"(veraltet) Dateien mit Git LFS hochladen","local":"veraltet-dateien-mit-git-lfs-hochladen","sections":[{"title":"commit Kontextmanager","local":"commit-kontextmanager","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3}],"depth":2}],"depth":1}';function pi(Rs){return ni(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ci extends ti{constructor(b){super(),si(this,b,pi,ri,Kl,{})}}export{ci as component};
