import{s as dt,n as rt,o as ot}from"../chunks/scheduler.de5597d1.js";import{S as ut,i as ht,e as a,s,c as o,h as pt,a as d,d as t,b as l,f as at,g as u,j as r,k as Hn,l as mt,m as i,n as h,t as p,o as m,p as c}from"../chunks/index.bf1177c2.js";import{C as ct,H as b,E as gt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d16525ff.js";import{C as g}from"../chunks/CodeBlock.0114a234.js";function ft(Jn){let f,ye,$e,ke,M,je,$,_e,v,Cn="Die <code>huggingface_hub</code>-Bibliothek bietet Funktionen zum Herunterladen von Dateien aus den auf dem Hub gespeicherten Repositories. Sie können diese Funktionen unabhängig verwenden oder in Ihre eigene Bibliothek integrieren, um es Ihren Benutzern zu erleichtern, mit dem Hub zu interagieren. In diesem Leitfaden erfahren Sie, wie Sie:",Te,y,Gn="<li>Einzelne Dateien herunterladen und zwischenspeichern.</li> <li>Ein gesamtes Repository herunterladen und zwischenspeichern.</li> <li>Dateien in einen lokalen Ordner herunterladen.</li>",ze,k,He,j,Un="Die <code>hf_hub_download()</code>-Funktion ist die Hauptfunktion zum Herunterladen von Dateien aus dem Hub. Sie lädt die Remote-Datei herunter, speichert sie auf der Festplatte (auf eine versionsbewusste Art und Weise) und gibt ihren lokalen Dateipfad zurück.",Je,w,Zn='<p>Der zurückgegebene Dateipfad verweist auf den lokalen Cache von HF. Es ist daher wichtig, die Datei nicht zu ändern, um einen beschädigten Cache zu vermeiden. Wenn Sie mehr darüber erfahren möchten, wie Dateien zwischengespeichert werden, lesen Sie bitte unseren <a href="./manage-cache">Caching-Leitfaden</a>.</p>',Ce,_,Ge,T,qn="Wählen Sie die Datei zum Herunterladen anhand der Parameter <code>repo_id</code>, <code>repo_type</code> und <code>filename</code> aus. Standardmäßig wird davon ausgegangen, dass die Datei Teil einer <code>model</code>-Repository ist.",Ue,z,Ze,H,qe,J,Dn="Standardmäßig wird die neueste Version vom Hauptzweig <code>main</code> heruntergeladen. In einigen Fällen möchten Sie jedoch eine Datei in einer bestimmten Version herunterladen (z. B. aus einem bestimmten Zweig, einem PR, einem Tag oder einem Commit-Hash). Verwenden Sie dazu den Parameter <code>revision</code>:",De,C,Se,G,Sn="<strong>Hinweis:</strong> Bei Verwendung des Commit-Hashs muss der vollständige Hash anstelle eines 7-Zeichen-Commit-Hashs verwendet werden.",xe,U,Le,Z,xn="Falls Sie die URL erstellen möchten, die zum Herunterladen einer Datei aus einem Repo verwendet wird, können Sie <code>hf_hub_url()</code> verwenden, das eine URL zurückgibt. Beachten Sie, dass es intern von <code>hf_hub_download()</code> verwendet wird.",Be,q,Ie,D,Ln="<code>snapshot_download()</code> lädt ein gesamtes Repository zu einer bestimmten Revision herunter. Es verwendet intern <code>hf_hub_download()</code>, was bedeutet, dass alle heruntergeladenen Dateien auch auf Ihrer lokalen Festplatte zwischengespeichert werden. Die Downloads werden gleichzeitig durchgeführt, um den Prozess zu beschleunigen.",Re,S,Bn="Um ein ganzes Repository herunterzuladen, geben Sie einfach die <code>repo_id</code> und <code>repo_type</code> an:",Ye,x,We,L,In="<code>snapshot_download()</code> lädt standardmäßig die neueste Revision herunter. Wenn Sie eine spezifische Repository-Revision wünschen, verwenden Sie den Parameter <code>revision</code>:",Xe,B,Ne,I,Pe,R,Rn="<code>snapshot_download()</code> bietet eine einfache Möglichkeit, ein Repository herunterzuladen. Sie möchten jedoch nicht immer den gesamten Inhalt eines Repositories herunterladen. Beispielsweise möchten Sie möglicherweise verhindern, dass alle <code>.bin</code>-Dateien heruntergeladen werden, wenn Sie wissen, dass Sie nur die <code>.safetensors</code>-Gewichtungen verwenden werden. Dies können Sie mit den Parametern <code>allow_patterns</code> und <code>ignore_patterns</code> tun.",Ve,Y,Yn='Diese Parameter akzeptieren entweder ein einzelnes Muster oder eine Liste von Mustern. Muster sind Standard-Wildcards (globbing patterns) wie <a href="https://tldp.org/LDP/GNU-Linux-Tools-Summary/html/x11655.htm" rel="nofollow">hier</a> dokumentiert. Die Mustervergleichung basiert auf <a href="https://docs.python.org/3/library/fnmatch.html" rel="nofollow"><code>fnmatch</code></a>.',Qe,W,Wn="Beispielsweise können Sie <code>allow_patterns</code> verwenden, um nur JSON-Konfigurationsdateien herunterzuladen:",Fe,X,Oe,N,Xn="Andererseits können Sie mit <code>ignore_patterns</code> bestimmte Dateien vom Herunterladen ausschließen. Im folgenden Beispiel werden die Dateierweiterungen <code>.msgpack</code> und <code>.h5</code> ignoriert:",Ee,P,Ae,V,Nn="Schließlich können Sie beide kombinieren, um Ihren Download genau zu filtern. Hier ist ein Beispiel, wie man alle json- und markdown-Dateien herunterlädt, außer <code>vocab.json</code>.",Ke,Q,en,F,nn,O,Pn='Die empfohlene (und standardmäßige) Methode zum Herunterladen von Dateien aus dem Hub besteht darin, das <a href="./manage-cache">Cache-System</a> zu verwenden. Sie können Ihren Cache-Ort festlegen, indem Sie den <code>cache_dir</code>-Parameter setzen (sowohl in <code>hf_hub_download()</code> als auch in <code>snapshot_download()</code>).',tn,E,Vn="In einigen Fällen möchten Sie jedoch Dateien herunterladen und in einen bestimmten Ordner verschieben. Dies ist nützlich, um einen Workflow zu erhalten, der den <code>git</code>-Befehlen ähnelt. Sie können dies mit den Parametern <code>local_dir</code> und <code>local_dir_use_symlinks</code> tun:",sn,A,Qn=`<li>local_dir muss ein Pfad zu einem Ordner auf Ihrem System sein. Die heruntergeladenen Dateien behalten dieselbe Dateistruktur wie im Repository. Wenn zum Beispiel <code>filename=&quot;data/train.csv&quot;</code> und <code>local_dir=&quot;pfad/zum/ordner&quot;</code> ist, wird der zurückgegebene Dateipfad <code>&quot;pfad/zum/ordner/data/train.csv&quot;</code> sein.</li> <li><code>local_dir_use_symlinks</code> definiert, wie die Datei in Ihrem lokalen Ordner gespeichert werden muss.
<ul><li>Das Standardverhalten (<code>&quot;auto&quot;</code>) besteht darin, kleine Dateien (&lt;5MB) zu duplizieren und für größere Dateien Symlinks zu verwenden. Symlinks ermöglichen
die Optimierung von Bandbreite und Speicherplatz. Das manuelle Bearbeiten einer verlinkten Datei könnte jedoch den Cache beschädigen, daher die Duplizierung für kleine Dateien. Die 5-MB-Schwelle kann mit der <code>HF_HUB_LOCAL_DIR_AUTO_SYMLINK_THRESHOLD</code>-Umgebungsvariable konfiguriert werden.</li> <li>Wenn <code>local_dir_use_symlinks=True</code> gesetzt ist, werden alle Dateien verlinkt, um den Speicherplatz optimal zu nutzen. Dies ist zum Beispiel nützlich, wenn ein riesiges Dataset mit Tausenden von kleinen Dateien heruntergeladen wird.</li> <li>Wenn Sie überhaupt keine Symlinks möchten, können Sie sie deaktivieren (<code>local_dir_use_symlinks=False</code>). Das Cache-Verzeichnis wird weiterhin verwendet, um zu überprüfen, ob die Datei bereits im Cache ist oder nicht. Wenn sie bereits im Cache ist, wird die Datei aus dem Cache <strong>dupliziert</strong> (d.h. Bandbreite wird gespart, aber der Speicherplatzverbrauch steigt). Wenn die Datei noch nicht im Cache ist, wird sie heruntergeladen und direkt in das lokale Verzeichnis verschoben. Das bedeutet, dass wenn Sie sie später woanders wiederverwenden müssen, sie <strong>erneut heruntergeladen</strong> wird.</li></ul></li>`,ln,K,Fn="Hier ist eine Tabelle, die die verschiedenen Optionen zusammenfasst, um Ihnen zu helfen, die Parameter zu wählen, die am besten zu Ihrem Anwendungsfall passen.",an,ee,On='<thead><tr><th>Parameter</th> <th align="center">Datei schon im Cache</th> <th align="center">Zurückgegebener Pfad</th> <th align="center">Pfad lesbar?</th> <th align="center">Kann im Pfad speichern?</th> <th align="center">Optimierter Datendurchsatz</th> <th align="center">Optimierter Speicherplatz</th></tr></thead> <tbody><tr><td><code>local_dir=None</code></td> <td align="center"></td> <td align="center">Symlink im Cache</td> <td align="center">✅</td> <td align="center">❌<br/><em>(Speichern würde den Cache beschädigen)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=&quot;auto&quot;</code></td> <td align="center"></td> <td align="center">Datei oder Symlink im Ordner</td> <td align="center">✅</td> <td align="center">✅ <em>(für kleine Dateien)</em> <br/> ⚠️ <em>(für große Dateien den Pfad nicht auflösen vor dem Speichern)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=True</code></td> <td align="center"></td> <td align="center">Symlink im Ordner</td> <td align="center">✅</td> <td align="center">⚠️<br/><em>(den Pfad nicht auflösen vor dem Speichern)</em></td> <td align="center">✅</td> <td align="center">✅</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=False</code></td> <td align="center">Nein</td> <td align="center">Datei im Ordner</td> <td align="center">✅</td> <td align="center">✅</td> <td align="center">❌<br/><em>(bei erneutem Ausführen wird die Datei erneut heruntergeladen)</em></td> <td align="center">⚠️<br/>(mehrere Kopien, wenn in mehreren Ordnern ausgeführt)</td></tr> <tr><td><code>local_dir=&quot;path/to/folder&quot;</code><br/><code>local_dir_use_symlinks=False</code></td> <td align="center">Ja</td> <td align="center">Datei im Ordner</td> <td align="center">✅</td> <td align="center">✅</td> <td align="center">⚠️<br/><em>(Datei muss zuerst im Cache gespeichert werden)</em></td> <td align="center">❌<br/><em>(Datei wird dupliziert)</em></td></tr></tbody>',dn,ne,En='<strong>Hinweis</strong>: Wenn Sie einen Windows-Computer verwenden, müssen Sie den Entwicklermodus aktivieren oder <code>huggingface_hub</code> als Administrator ausführen, um Symlinks zu aktivieren. Weitere Details finden Sie im Abschnitt über <a href="../guides/manage-cache#limitations">Cache-Beschränkungen</a>.',rn,te,on,ie,An="Sie können den <code>hf download</code>-Befehl im Terminal verwenden, um Dateien direkt aus dem Hub herunterzuladen. Intern verwendet es die gleichen <code>hf_hub_download()</code> und <code>snapshot_download()</code> Helfer, die oben beschrieben wurden, und gibt den zurückgegebenen Pfad im Terminal aus:",un,se,hn,le,Kn="Standardmäßig wird das lokal gespeicherte Token (mit <code>hf auth login</code>) verwendet. Wenn Sie sich ausdrücklich authentifizieren möchten, verwenden Sie die <code>--token</code> Option:",pn,ae,mn,de,et="Sie können mehrere Dateien gleichzeitig herunterladen, wobei eine Fortschrittsleiste angezeigt wird und der Snapshot-Pfad zurückgegeben wird, in dem sich die Dateien befinden:",cn,re,gn,oe,nt="Wenn Sie die Fortschrittsleisten und mögliche Warnungen stummschalten möchten, verwenden Sie die Option <code>--quiet</code>. Dies kann nützlich sein, wenn Sie die Ausgabe an einen anderen Befehl in einem Skript weitergeben möchten.",fn,ue,bn,he,tt="Standardmäßig werden Dateien im Cache-Verzeichnis heruntergeladen, das durch die Umgebungsvariable <code>HF_HOME</code> definiert ist (oder <code>~/.cache/huggingface/hub</code>, wenn nicht angegeben). Sie können dies mit der Option <code>--cache-dir</code> überschreiben:",wn,pe,Mn,me,it='Wenn Sie Dateien in einen lokalen Ordner herunterladen möchten, ohne die Cache-Verzeichnisstruktur, können Sie <code>--local-dir</code> verwenden. Das Herunterladen in einen lokalen Ordner hat seine Einschränkungen, die in dieser <a href="https://huggingface.co/docs/huggingface_hub/guides/download#download-files-to-local-folder" rel="nofollow">Tabelle</a> aufgeführt sind.',$n,ce,vn,ge,st="Es gibt weitere Argumente, die Sie angeben können, um aus verschiedenen Repo-Typen oder Revisionen herunterzuladen und Dateien zum Herunterladen mit Glob-Mustern ein- oder auszuschließen:",yn,fe,kn,be,lt="Für eine vollständige Liste der Argumente führen Sie bitte den folgenden Befehl aus:",jn,we,_n,Me,Tn,ve,zn;return M=new ct({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),$=new b({props:{title:"Dateien aus dem Hub herunterladen",local:"dateien-aus-dem-hub-herunterladen",headingTag:"h1"}}),k=new b({props:{title:"Einzelne Dateien herunterladen",local:"einzelne-dateien-herunterladen",headingTag:"h2"}}),_=new b({props:{title:"Von der neuesten Version",local:"von-der-neuesten-version",headingTag:"h3"}}),z=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIyZ29vZ2xlJTJGZmxldXJzJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJmbGV1cnMucHklMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade/config.json&#x27;</span>

<span class="hljs-comment"># Herunterladen von einem Dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, filename=<span class="hljs-string">&quot;fleurs.py&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/root/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34/fleurs.py&#x27;</span>`,wrap:!1}}),H=new b({props:{title:"Von einer spezifischen Version",local:"von-einer-spezifischen-version",headingTag:"h3"}}),C=new g({props:{code:"aGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnYxLjAlMjIpJTBBJTBBaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIlMkMlMjByZXZpc2lvbiUzRCUyMnRlc3QtYnJhbmNoJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYzJTIyKSUwQSUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI4NzdiODRhOGY5M2YyZDYxOWZhYTJhNmU1MTRhMzJiZWVmODhhYjBhJTIyKQ==",highlighted:`<span class="hljs-comment"># Herunterladen vom Tag \`v1.0\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;v1.0&quot;</span>)

<span class="hljs-comment"># Herunterladen vom Zweig \`test-branch\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;test-branch&quot;</span>)

<span class="hljs-comment"># Herunterladen von Pull Request #3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/3&quot;</span>)

<span class="hljs-comment"># Herunterladen von einem spezifischen Commit-Hash</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;877b84a8f93f2d619faa2a6e514a32beef88ab0a&quot;</span>)`,wrap:!1}}),U=new b({props:{title:"URL zum Herunterladen erstellen",local:"url-zum-herunterladen-erstellen",headingTag:"h3"}}),q=new b({props:{title:"Gesamte Repository herunterladen",local:"gesamte-repository-herunterladen",headingTag:"h2"}}),x=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyKSUwQSUwQXNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJnb29nbGUlMkZmbGV1cnMlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade&#x27;</span>

<span class="hljs-comment"># Oder von einem Dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;google/fleurs&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/datasets--google--fleurs/snapshots/199e4ae37915137c555b1765c01477c216287d34&#x27;</span>`,wrap:!1}}),B=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwcmV2aXNpb24lM0QlMjJyZWZzJTJGcHIlMkYxJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, revision=<span class="hljs-string">&quot;refs/pr/1&quot;</span>)`,wrap:!1}}),I=new b({props:{title:"Dateien filtern zum Herunterladen",local:"dateien-filtern-zum-herunterladen",headingTag:"h3"}}),X=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwYWxsb3dfcGF0dGVybnMlM0QlMjIqLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, allow_patterns=<span class="hljs-string">&quot;*.json&quot;</span>)`,wrap:!1}}),P=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyJTJDJTIwaWdub3JlX3BhdHRlcm5zJTNEJTVCJTIyKi5tc2dwYWNrJTIyJTJDJTIwJTIyKi5oNSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, ignore_patterns=[<span class="hljs-string">&quot;*.msgpack&quot;</span>, <span class="hljs-string">&quot;*.h5&quot;</span>])`,wrap:!1}}),Q=new g({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmdwdDIlMjIlMkMlMjBhbGxvd19wYXR0ZXJucyUzRCU1QiUyMioubWQlMjIlMkMlMjAlMjIqLmpzb24lMjIlNUQlMkMlMjBpZ25vcmVfcGF0dGVybnMlM0QlMjJ2b2NhYi5qc29uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;gpt2&quot;</span>, allow_patterns=[<span class="hljs-string">&quot;*.md&quot;</span>, <span class="hljs-string">&quot;*.json&quot;</span>], ignore_patterns=<span class="hljs-string">&quot;vocab.json&quot;</span>)`,wrap:!1}}),F=new b({props:{title:"Datei(en) in lokalen Ordner herunterladen",local:"dateien-in-lokalen-ordner-herunterladen",headingTag:"h2"}}),te=new b({props:{title:"Herunterladen mit dem CLI",local:"herunterladen-mit-dem-cli",headingTag:"h2"}}),se=new g({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbg==",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),ae=new g({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbiUyMC0tdG9rZW4lM0RoZl8qKioq",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json --token=hf_****
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),re=new g({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbiUyMG1vZGVsLnNhZmV0ZW5zb3Jz",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json model.safetensors
Fetching 2 files: 100%|████████████████████████████████████████████| 2/2 [00:00&lt;00:00, 23831.27it/s]
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),ue=new g({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbiUyMG1vZGVsLnNhZmV0ZW5zb3Jz",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json model.safetensors
/home/wauplin/.cache/huggingface/hub/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10`,wrap:!1}}),pe=new g({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbiUyMC0tY2FjaGUtZGlyJTNELiUyRmNhY2hl",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json --cache-dir=./cache
./cache/models--gpt2/snapshots/11c5a3d5811f50298f278a704980280950aedb10/config.json`,wrap:!1}}),ce=new g({props:{code:"aGYlMjBkb3dubG9hZCUyMGdwdDIlMjBjb25maWcuanNvbiUyMC0tbG9jYWwtZGlyJTNELiUyRm1vZGVscyUyRmdwdDI=",highlighted:`&gt;&gt;&gt; hf download gpt2 config.json --local-dir=./models/gpt2
./models/gpt2/config.json`,wrap:!1}}),fe=new g({props:{code:"aGYlMjBkb3dubG9hZCUyMGJpZ2NvZGUlMkZ0aGUtc3RhY2slMjAtLXJlcG8tdHlwZSUzRGRhdGFzZXQlMjAtLXJldmlzaW9uJTNEdjEuMiUyMC0taW5jbHVkZSUzRCUyMmRhdGElMkZweXRob24lMkYqJTIyJTIwLS1leGNsdQ==",highlighted:`&gt;&gt;&gt; hf download bigcode/the-stack --repo-type=dataset --revision=v1.2 --include=<span class="hljs-string">&quot;data/python/*&quot;</span> --exclu
de=<span class="hljs-string">&quot;*.json&quot;</span> --exclude=<span class="hljs-string">&quot;*.zip&quot;</span>
Fetching 206 files:   100%|████████████████████████████████████████████| 206/206 [02:31&lt;2:31, ?it/s]
/home/wauplin/.cache/huggingface/hub/datasets--bigcode--the-stack/snapshots/9ca8fa6acdbc8ce920a0cb58adcdafc495818ae7`,wrap:!1}}),we=new g({props:{code:"aGYlMjBkb3dubG9hZCUyMC0taGVscA==",highlighted:'hf download --<span class="hljs-built_in">help</span>',wrap:!1}}),Me=new gt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/download.md"}}),{c(){f=a("meta"),ye=s(),$e=a("p"),ke=s(),o(M.$$.fragment),je=s(),o($.$$.fragment),_e=s(),v=a("p"),v.innerHTML=Cn,Te=s(),y=a("ul"),y.innerHTML=Gn,ze=s(),o(k.$$.fragment),He=s(),j=a("p"),j.innerHTML=Un,Je=s(),w=a("blockquote"),w.innerHTML=Zn,Ce=s(),o(_.$$.fragment),Ge=s(),T=a("p"),T.innerHTML=qn,Ue=s(),o(z.$$.fragment),Ze=s(),o(H.$$.fragment),qe=s(),J=a("p"),J.innerHTML=Dn,De=s(),o(C.$$.fragment),Se=s(),G=a("p"),G.innerHTML=Sn,xe=s(),o(U.$$.fragment),Le=s(),Z=a("p"),Z.innerHTML=xn,Be=s(),o(q.$$.fragment),Ie=s(),D=a("p"),D.innerHTML=Ln,Re=s(),S=a("p"),S.innerHTML=Bn,Ye=s(),o(x.$$.fragment),We=s(),L=a("p"),L.innerHTML=In,Xe=s(),o(B.$$.fragment),Ne=s(),o(I.$$.fragment),Pe=s(),R=a("p"),R.innerHTML=Rn,Ve=s(),Y=a("p"),Y.innerHTML=Yn,Qe=s(),W=a("p"),W.innerHTML=Wn,Fe=s(),o(X.$$.fragment),Oe=s(),N=a("p"),N.innerHTML=Xn,Ee=s(),o(P.$$.fragment),Ae=s(),V=a("p"),V.innerHTML=Nn,Ke=s(),o(Q.$$.fragment),en=s(),o(F.$$.fragment),nn=s(),O=a("p"),O.innerHTML=Pn,tn=s(),E=a("p"),E.innerHTML=Vn,sn=s(),A=a("ul"),A.innerHTML=Qn,ln=s(),K=a("p"),K.textContent=Fn,an=s(),ee=a("table"),ee.innerHTML=On,dn=s(),ne=a("p"),ne.innerHTML=En,rn=s(),o(te.$$.fragment),on=s(),ie=a("p"),ie.innerHTML=An,un=s(),o(se.$$.fragment),hn=s(),le=a("p"),le.innerHTML=Kn,pn=s(),o(ae.$$.fragment),mn=s(),de=a("p"),de.textContent=et,cn=s(),o(re.$$.fragment),gn=s(),oe=a("p"),oe.innerHTML=nt,fn=s(),o(ue.$$.fragment),bn=s(),he=a("p"),he.innerHTML=tt,wn=s(),o(pe.$$.fragment),Mn=s(),me=a("p"),me.innerHTML=it,$n=s(),o(ce.$$.fragment),vn=s(),ge=a("p"),ge.textContent=st,yn=s(),o(fe.$$.fragment),kn=s(),be=a("p"),be.textContent=lt,jn=s(),o(we.$$.fragment),_n=s(),o(Me.$$.fragment),Tn=s(),ve=a("p"),this.h()},l(e){const n=pt("svelte-u9bgzb",document.head);f=d(n,"META",{name:!0,content:!0}),n.forEach(t),ye=l(e),$e=d(e,"P",{}),at($e).forEach(t),ke=l(e),u(M.$$.fragment,e),je=l(e),u($.$$.fragment,e),_e=l(e),v=d(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ubrpt0"&&(v.innerHTML=Cn),Te=l(e),y=d(e,"UL",{"data-svelte-h":!0}),r(y)!=="svelte-11ytfdd"&&(y.innerHTML=Gn),ze=l(e),u(k.$$.fragment,e),He=l(e),j=d(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-xak2q1"&&(j.innerHTML=Un),Je=l(e),w=d(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-146ecry"&&(w.innerHTML=Zn),Ce=l(e),u(_.$$.fragment,e),Ge=l(e),T=d(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-ab5nty"&&(T.innerHTML=qn),Ue=l(e),u(z.$$.fragment,e),Ze=l(e),u(H.$$.fragment,e),qe=l(e),J=d(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-tiniw9"&&(J.innerHTML=Dn),De=l(e),u(C.$$.fragment,e),Se=l(e),G=d(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-58pyfb"&&(G.innerHTML=Sn),xe=l(e),u(U.$$.fragment,e),Le=l(e),Z=d(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1sta8et"&&(Z.innerHTML=xn),Be=l(e),u(q.$$.fragment,e),Ie=l(e),D=d(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1xxjhn3"&&(D.innerHTML=Ln),Re=l(e),S=d(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1gwjjh9"&&(S.innerHTML=Bn),Ye=l(e),u(x.$$.fragment,e),We=l(e),L=d(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-17cn3wl"&&(L.innerHTML=In),Xe=l(e),u(B.$$.fragment,e),Ne=l(e),u(I.$$.fragment,e),Pe=l(e),R=d(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1deq760"&&(R.innerHTML=Rn),Ve=l(e),Y=d(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1i4aei1"&&(Y.innerHTML=Yn),Qe=l(e),W=d(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-d2qgld"&&(W.innerHTML=Wn),Fe=l(e),u(X.$$.fragment,e),Oe=l(e),N=d(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-oj4gj3"&&(N.innerHTML=Xn),Ee=l(e),u(P.$$.fragment,e),Ae=l(e),V=d(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-5giyaa"&&(V.innerHTML=Nn),Ke=l(e),u(Q.$$.fragment,e),en=l(e),u(F.$$.fragment,e),nn=l(e),O=d(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-9pwg96"&&(O.innerHTML=Pn),tn=l(e),E=d(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-zq57f8"&&(E.innerHTML=Vn),sn=l(e),A=d(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-193cf09"&&(A.innerHTML=Qn),ln=l(e),K=d(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-5xwtoz"&&(K.textContent=Fn),an=l(e),ee=d(e,"TABLE",{"data-svelte-h":!0}),r(ee)!=="svelte-pit09k"&&(ee.innerHTML=On),dn=l(e),ne=d(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-m5n1en"&&(ne.innerHTML=En),rn=l(e),u(te.$$.fragment,e),on=l(e),ie=d(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-zfmarb"&&(ie.innerHTML=An),un=l(e),u(se.$$.fragment,e),hn=l(e),le=d(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-ubbt6u"&&(le.innerHTML=Kn),pn=l(e),u(ae.$$.fragment,e),mn=l(e),de=d(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1ny036d"&&(de.textContent=et),cn=l(e),u(re.$$.fragment,e),gn=l(e),oe=d(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-ehpfc5"&&(oe.innerHTML=nt),fn=l(e),u(ue.$$.fragment,e),bn=l(e),he=d(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1uph7px"&&(he.innerHTML=tt),wn=l(e),u(pe.$$.fragment,e),Mn=l(e),me=d(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-13f2xbh"&&(me.innerHTML=it),$n=l(e),u(ce.$$.fragment,e),vn=l(e),ge=d(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1v2ae8z"&&(ge.textContent=st),yn=l(e),u(fe.$$.fragment,e),kn=l(e),be=d(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1jb9e92"&&(be.textContent=lt),jn=l(e),u(we.$$.fragment,e),_n=l(e),u(Me.$$.fragment,e),Tn=l(e),ve=d(e,"P",{}),at(ve).forEach(t),this.h()},h(){Hn(f,"name","hf:doc:metadata"),Hn(f,"content",bt),Hn(w,"class","tip")},m(e,n){mt(document.head,f),i(e,ye,n),i(e,$e,n),i(e,ke,n),h(M,e,n),i(e,je,n),h($,e,n),i(e,_e,n),i(e,v,n),i(e,Te,n),i(e,y,n),i(e,ze,n),h(k,e,n),i(e,He,n),i(e,j,n),i(e,Je,n),i(e,w,n),i(e,Ce,n),h(_,e,n),i(e,Ge,n),i(e,T,n),i(e,Ue,n),h(z,e,n),i(e,Ze,n),h(H,e,n),i(e,qe,n),i(e,J,n),i(e,De,n),h(C,e,n),i(e,Se,n),i(e,G,n),i(e,xe,n),h(U,e,n),i(e,Le,n),i(e,Z,n),i(e,Be,n),h(q,e,n),i(e,Ie,n),i(e,D,n),i(e,Re,n),i(e,S,n),i(e,Ye,n),h(x,e,n),i(e,We,n),i(e,L,n),i(e,Xe,n),h(B,e,n),i(e,Ne,n),h(I,e,n),i(e,Pe,n),i(e,R,n),i(e,Ve,n),i(e,Y,n),i(e,Qe,n),i(e,W,n),i(e,Fe,n),h(X,e,n),i(e,Oe,n),i(e,N,n),i(e,Ee,n),h(P,e,n),i(e,Ae,n),i(e,V,n),i(e,Ke,n),h(Q,e,n),i(e,en,n),h(F,e,n),i(e,nn,n),i(e,O,n),i(e,tn,n),i(e,E,n),i(e,sn,n),i(e,A,n),i(e,ln,n),i(e,K,n),i(e,an,n),i(e,ee,n),i(e,dn,n),i(e,ne,n),i(e,rn,n),h(te,e,n),i(e,on,n),i(e,ie,n),i(e,un,n),h(se,e,n),i(e,hn,n),i(e,le,n),i(e,pn,n),h(ae,e,n),i(e,mn,n),i(e,de,n),i(e,cn,n),h(re,e,n),i(e,gn,n),i(e,oe,n),i(e,fn,n),h(ue,e,n),i(e,bn,n),i(e,he,n),i(e,wn,n),h(pe,e,n),i(e,Mn,n),i(e,me,n),i(e,$n,n),h(ce,e,n),i(e,vn,n),i(e,ge,n),i(e,yn,n),h(fe,e,n),i(e,kn,n),i(e,be,n),i(e,jn,n),h(we,e,n),i(e,_n,n),h(Me,e,n),i(e,Tn,n),i(e,ve,n),zn=!0},p:rt,i(e){zn||(p(M.$$.fragment,e),p($.$$.fragment,e),p(k.$$.fragment,e),p(_.$$.fragment,e),p(z.$$.fragment,e),p(H.$$.fragment,e),p(C.$$.fragment,e),p(U.$$.fragment,e),p(q.$$.fragment,e),p(x.$$.fragment,e),p(B.$$.fragment,e),p(I.$$.fragment,e),p(X.$$.fragment,e),p(P.$$.fragment,e),p(Q.$$.fragment,e),p(F.$$.fragment,e),p(te.$$.fragment,e),p(se.$$.fragment,e),p(ae.$$.fragment,e),p(re.$$.fragment,e),p(ue.$$.fragment,e),p(pe.$$.fragment,e),p(ce.$$.fragment,e),p(fe.$$.fragment,e),p(we.$$.fragment,e),p(Me.$$.fragment,e),zn=!0)},o(e){m(M.$$.fragment,e),m($.$$.fragment,e),m(k.$$.fragment,e),m(_.$$.fragment,e),m(z.$$.fragment,e),m(H.$$.fragment,e),m(C.$$.fragment,e),m(U.$$.fragment,e),m(q.$$.fragment,e),m(x.$$.fragment,e),m(B.$$.fragment,e),m(I.$$.fragment,e),m(X.$$.fragment,e),m(P.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(re.$$.fragment,e),m(ue.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(fe.$$.fragment,e),m(we.$$.fragment,e),m(Me.$$.fragment,e),zn=!1},d(e){e&&(t(ye),t($e),t(ke),t(je),t(_e),t(v),t(Te),t(y),t(ze),t(He),t(j),t(Je),t(w),t(Ce),t(Ge),t(T),t(Ue),t(Ze),t(qe),t(J),t(De),t(Se),t(G),t(xe),t(Le),t(Z),t(Be),t(Ie),t(D),t(Re),t(S),t(Ye),t(We),t(L),t(Xe),t(Ne),t(Pe),t(R),t(Ve),t(Y),t(Qe),t(W),t(Fe),t(Oe),t(N),t(Ee),t(Ae),t(V),t(Ke),t(en),t(nn),t(O),t(tn),t(E),t(sn),t(A),t(ln),t(K),t(an),t(ee),t(dn),t(ne),t(rn),t(on),t(ie),t(un),t(hn),t(le),t(pn),t(mn),t(de),t(cn),t(gn),t(oe),t(fn),t(bn),t(he),t(wn),t(Mn),t(me),t($n),t(vn),t(ge),t(yn),t(kn),t(be),t(jn),t(_n),t(Tn),t(ve)),t(f),c(M,e),c($,e),c(k,e),c(_,e),c(z,e),c(H,e),c(C,e),c(U,e),c(q,e),c(x,e),c(B,e),c(I,e),c(X,e),c(P,e),c(Q,e),c(F,e),c(te,e),c(se,e),c(ae,e),c(re,e),c(ue,e),c(pe,e),c(ce,e),c(fe,e),c(we,e),c(Me,e)}}}const bt='{"title":"Dateien aus dem Hub herunterladen","local":"dateien-aus-dem-hub-herunterladen","sections":[{"title":"Einzelne Dateien herunterladen","local":"einzelne-dateien-herunterladen","sections":[{"title":"Von der neuesten Version","local":"von-der-neuesten-version","sections":[],"depth":3},{"title":"Von einer spezifischen Version","local":"von-einer-spezifischen-version","sections":[],"depth":3},{"title":"URL zum Herunterladen erstellen","local":"url-zum-herunterladen-erstellen","sections":[],"depth":3}],"depth":2},{"title":"Gesamte Repository herunterladen","local":"gesamte-repository-herunterladen","sections":[{"title":"Dateien filtern zum Herunterladen","local":"dateien-filtern-zum-herunterladen","sections":[],"depth":3}],"depth":2},{"title":"Datei(en) in lokalen Ordner herunterladen","local":"dateien-in-lokalen-ordner-herunterladen","sections":[],"depth":2},{"title":"Herunterladen mit dem CLI","local":"herunterladen-mit-dem-cli","sections":[],"depth":2}],"depth":1}';function wt(Jn){return ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends ut{constructor(f){super(),ht(this,f,wt,ft,dt,{})}}export{kt as component};
