import{s as xl,n as Xl,o as Rl}from"../chunks/scheduler.de5597d1.js";import{S as Ll,i as Nl,e as a,s,c as d,h as Ql,a as r,d as n,b as i,f as Sl,g as o,j as M,k as dl,l as Yl,m as t,n as p,t as m,o as h,p as c}from"../chunks/index.bf1177c2.js";import{C as Fl,H as u,E as Dl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d16525ff.js";import{C as oe}from"../chunks/CodeBlock.0114a234.js";function Kl(ol){let y,he,pe,ce,b,ue,J,ye,T,pl='Der Hugging Face Hub erleichtert das Hosten und Teilen von Modellen mit der Community. Er unterstützt <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">Dutzende von Bibliotheken</a> im Open Source-Ökosystem. Wir arbeiten ständig daran, diese Unterstützung zu erweitern, um kollaboratives Machine Learning voranzutreiben. Die <code>huggingface_hub</code>-Bibliothek spielt eine Schlüsselrolle in diesem Prozess und ermöglicht es jedem Python-Skript, Dateien einfach hochzuladen und zu laden.',we,U,ml="Es gibt vier Hauptwege, eine Bibliothek mit dem Hub zu integrieren:",je,f,hl=`<li><strong>Push to Hub</strong>: Implementieren Sie eine Methode, um ein Modell auf den Hub hochzuladen.
Dies beinhaltet das Modellgewicht sowie <a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">die Modellkarte</a> und alle anderen relevanten Informationen oder Daten, die für den Betrieb des Modells erforderlich sind (zum Beispiel Trainingsprotokolle). Diese Methode wird oft <code>push_to_hub()</code> genannt.</li> <li><strong>Download from Hub</strong>: Implementieren Sie eine Methode, um ein Modell vom Hub zu laden.
Die Methode sollte die Modellkonfiguration/-gewichte herunterladen und das Modell laden. Diese Methode wird oft <code>from_pretrained</code> oder <code>load_from_hub()</code> genannt.</li> <li><strong>Widgets</strong>: Zeigen Sie ein Widget auf der Landing Page Ihrer Modelle auf dem Hub an.
Dies ermöglicht es Benutzern, ein Modell schnell aus dem Browser heraus auszuprobieren.</li>`,be,I,cl="In diesem Leitfaden konzentrieren wir uns auf die ersten beiden Themen. Wir werden die beiden Hauptansätze vorstellen, die Sie zur Integration einer Bibliothek verwenden können, mit ihren Vor- und Nachteilen. Am Ende des Leitfadens ist alles zusammengefasst, um Ihnen bei der Auswahl zwischen den beiden zu helfen. Bitte beachten Sie, dass dies nur Richtlinien sind, die Sie an Ihre Anforderungen anpassen können.",Je,g,ul='Wenn Sie sich für Inferenz und Widgets interessieren, können Sie <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">diesem Leitfaden</a> folgen. In beiden Fällen können Sie sich an uns wenden, wenn Sie eine Bibliothek mit dem Hub integrieren und <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">in unserer Dokumentation</a> aufgeführt haben möchten.',Te,C,Ue,k,yl=`Der erste Ansatz zur Integration einer Bibliothek in den Hub besteht tatsächlich darin, die <code>push_to_hub</code> und <code>from_pretrained</code> Methoden selbst zu implementieren. Dies gibt Ihnen volle Flexibilität hinsichtlich der Dateien, die Sie hoch-/herunterladen möchten, und wie Sie Eingaben, die speziell für Ihr Framework sind, behandeln. Sie können sich die beiden Leitfäden <a href="./upload">Dateien hochladen</a> und <a href="./download">Dateien herunterladen</a> ansehen, um mehr darüber zu erfahren, wie dies funktioniert. Dies ist zum Beispiel die Art und Weise, wie die FastAI-Integration implementiert ist (siehe <code>push_to_hub_fastai()</code>
und <code>from_pretrained_fastai()</code>).`,fe,_,wl="Die Implementierung kann zwischen den Bibliotheken variieren, aber der Workflow ist oft ähnlich.",Ie,v,ge,B,jl="So sieht eine <code>from_pretrained</code> Methode normalerweise aus:",Ce,A,ke,Z,_e,W,bl="Die <code>push_to_hub</code> Methode erfordert oft etwas mehr Komplexität, um die Repo-Erstellung, die Generierung der Modellkarte und das Speichern von Gewichten zu behandeln. Ein üblicher Ansatz besteht darin, all diese Dateien in einem temporären Ordner zu speichern, ihn hochzuladen und dann zu löschen.",ve,G,Be,z,Jl='Dies ist natürlich nur ein Beispiel. Wenn Sie an komplexeren Manipulationen interessiert sind (entfernen von entfernten Dateien, hochladen von Gewichten on-the-fly, lokales Speichern von Gewichten, usw.), beachten Sie bitte den <a href="./upload">Dateien hochladen</a> Leitfaden.',Ae,E,Ze,H,Tl="Obwohl dieser Ansatz flexibel ist, hat er einige Nachteile, insbesondere in Bezug auf die Wartung. Hugging Face-Benutzer sind oft an zusätzliche Funktionen gewöhnt, wenn sie mit <code>huggingface_hub</code> arbeiten. Zum Beispiel ist es beim Laden von Dateien aus dem Hub üblich, Parameter wie folgt anzubieten:",We,V,Ul="<li><code>token</code>: zum Herunterladen aus einem privaten Repository</li> <li><code>revision</code>: zum Herunterladen von einem spezifischen Branch</li> <li><code>cache_dir</code>: um Dateien in einem spezifischen Verzeichnis zu cachen</li> <li><code>force_download</code>/<code>local_files_only</code>: um den Cache wieder zu verwenden oder nicht</li> <li><code>api_endpoint</code>/<code>proxies</code>: HTTP-Session konfigurieren</li>",Ge,$,fl="Beim Pushen von Modellen werden ähnliche Parameter unterstützt:",ze,S,Il="<li><code>commit_message</code>: benutzerdefinierte Commit-Nachricht</li> <li><code>private</code>: ein privates Repository erstellen, falls nicht vorhanden</li> <li><code>create_pr</code>: erstellen Sie einen PR anstatt auf <code>main</code> zu pushen</li> <li><code>branch</code>: auf einen Branch pushen anstatt auf den <code>main</code> Branch</li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filtern, welche Dateien hochgeladen werden sollen</li> <li><code>token</code></li> <li><code>api_endpoint</code></li> <li>…</li>",Ee,x,gl=`Alle diese Parameter können den zuvor gesehenen Implementierungen hinzugefügt und an die <code>huggingface_hub</code>-Methoden übergeben werden.
Wenn sich jedoch ein Parameter ändert oder eine neue Funktion hinzugefügt wird, müssen Sie Ihr Paket aktualisieren.
Die Unterstützung dieser Parameter bedeutet auch mehr Dokumentation, die Sie auf Ihrer Seite pflegen müssen.
Um zu sehen, wie man diese Einschränkungen mildert, springen wir zu unserem nächsten Abschnitt <strong>Klassenvererbung</strong>.`,He,X,Ve,R,Cl="Wie wir oben gesehen haben, gibt es zwei Hauptmethoden, um Ihre Bibliothek mit dem Hub zu integrieren: Dateien hochladen (<code>push_to_hub</code>) und Dateien herunterladen (<code>from_pretrained</code>). Sie können diese Methoden selbst implementieren, aber das hat seine Tücken. Um dies zu bewältigen, bietet <code>huggingface_hub</code> ein Werkzeug an, das Klassenvererbung verwendet. Schauen wir uns an, wie es funktioniert!",$e,L,kl='In vielen Fällen implementiert eine Bibliothek ihr Modell bereits mit einer Python-Klasse. Die Klasse enthält die Eigenschaften des Modells und Methoden zum Laden, Ausführen, Trainieren und Evaluieren. Unser Ansatz besteht darin, diese Klasse zu erweitern, um Upload- und Download-Funktionen mit Mixins hinzuzufügen. Ein <a href="https://stackoverflow.com/a/547714" rel="nofollow">Mixin</a> ist eine Klasse, die dazu bestimmt ist, eine vorhandene Klasse mit einem Satz spezifischer Funktionen durch Mehrfachvererbung zu erweitern. <code>huggingface_hub</code> bietet sein eigenes Mixin, das <code>ModelHubMixin</code>. Der Schlüssel hier ist zu verstehen, wie es funktioniert und wie man es anpassen kann.',Se,N,_l="Die Klasse [ModelHubMixin] implementiert 3 <em>öffentliche</em> Methoden (<code>push_to_hub</code>, <code>save_pretrained</code> und <code>from_pretrained</code>). Dies sind die Methoden, die Ihre Benutzer aufrufen werden, um Modelle mit Ihrer Bibliothek zu laden/speichern. <code>ModelHubMixin</code> definiert auch 2 private Methoden (<code>_save_pretrained</code> und <code>_from_pretrained</code>). Diese müssen Sie implementieren. Um Ihre Bibliothek zu integrieren, sollten Sie:",xe,Q,vl=`<li>Lassen Sie Ihre Modell-Klasse von <code>ModelHubMixin</code> erben.</li> <li>Implementieren Sie die privaten Methoden:
<ul><li><code>_save_pretrained()</code>: Methode, die als Eingabe einen Pfad zu einem Verzeichnis nimmt und das Modell dort speichert. Sie müssen die gesamte Logik zum Speichern Ihres Modells in dieser Methode schreiben: Modellkarte, Modellgewichte, Konfigurationsdateien, Trainingsprotokolle und Diagramme. Alle relevanten Informationen für dieses Modell müssen von dieser Methode behandelt werden.
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards</a> sind besonders wichtig, um Ihr Modell zu beschreiben. Weitere Details finden Sie in <a href="./model-cards">unserem Implementierungsleitfaden</a>.</li> <li>[~ModelHubMixin._from_pretrained]: <strong>Klassenmethode</strong>, die als Eingabe eine <code>model_id</code> nimmt und ein instanziiertes Modell zurückgibt. Die Methode muss die relevanten Dateien herunterladen und laden.</li></ul></li> <li>Sie sind fertig!</li>`,Xe,Y,Bl="Der Vorteil der Verwendung von <code>ModelHubMixin</code> besteht darin, dass Sie, sobald Sie sich um die Serialisierung/das Laden der Dateien gekümmert haben, bereit sind los zu legen. Sie müssen sich keine Gedanken über Dinge wie Repository-Erstellung, Commits, PRs oder Revisionen machen. All dies wird von dem Mixin gehandhabt und steht Ihren Benutzern zur Verfügung. Das Mixin stellt auch sicher, dass öffentliche Methoden gut dokumentiert und typisiert sind.",Re,F,Le,D,Al="Ein gutes Beispiel für das, was wir oben gesehen haben, ist <code>PyTorchModelHubMixin</code>, unsere Integration für das PyTorch-Framework. Dies ist eine einsatzbereite Integration.",Ne,K,Qe,P,Zl="Hier ist, wie jeder Benutzer ein PyTorch-Modell vom/auf den Hub laden/speichern kann:",Ye,q,Fe,O,De,ee,Wl='Die Implementierung ist tatsächlich sehr einfach, und die vollständige Implementierung finden Sie <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">hier</a>.',Ke,le,Gl="<li>Zuerst, erben Ihrer Klasse von <code>ModelHubMixin</code>:</li>",Pe,ne,qe,w,zl="<li>Implementieren der <code>_save_pretrained</code> Methode:</li>",Oe,te,el,j,El="<li>Implementieren der <code>_from_pretrained</code> Methode:</li>",ll,se,nl,ie,Hl="Und das war’s! Ihre Bibliothek ermöglicht es Benutzern nun, Dateien vom und zum Hub hoch- und herunterzuladen.",tl,ae,sl,re,Vl="Lassen Sie uns die beiden Ansätze, die wir gesehen haben, schnell mit ihren Vor- und Nachteilen zusammenfassen. Die untenstehende Tabelle ist nur indikativ. Ihr Framework könnte einige Besonderheiten haben, die Sie berücksichtigen müssen. Dieser Leitfaden soll nur Richtlinien und Ideen geben, wie Sie die Integration handhaben können. Kontaktieren Sie uns in jedem Fall, wenn Sie Fragen haben!",il,Me,$l='<thead><tr><th align="center">Integration</th> <th align="center">Mit Helfern</th> <th align="center">Mit <code>ModelHubMixin</code></th></tr></thead> <tbody><tr><td align="center">Benutzererfahrung</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexibilität</td> <td align="center">Sehr flexibel.<br/>Sie haben die volle Kontrolle über die Implementierung.</td> <td align="center">Weniger flexibel.<br/>Ihr Framework muss eine Modellklasse haben.</td></tr> <tr><td align="center">Wartung</td> <td align="center">Mehr Wartung, um Unterstützung für Konfiguration und neue Funktionen hinzuzufügen. Könnte auch das Beheben von Benutzerproblemen erfordern.</td> <td align="center">Weniger Wartung, da die meisten Interaktionen mit dem Hub in <code>huggingface_hub</code> implementiert sind.</td></tr> <tr><td align="center">Dokumentation/Typ-Annotation</td> <td align="center">Manuell zu schreiben.</td> <td align="center">Teilweise durch <code>huggingface_hub</code> behandelt.</td></tr></tbody>',al,de,rl,me,Ml;return b=new Fl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new u({props:{title:"Integrieren Sie jedes ML-Framework mit dem Hub",local:"integrieren-sie-jedes-ml-framework-mit-dem-hub",headingTag:"h1"}}),C=new u({props:{title:"Ein flexibler Ansatz: Helfer",local:"ein-flexibler-ansatz-helfer",headingTag:"h2"}}),v=new u({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),A=new oe({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBNb2RlbGwlMjB2b20lMjBIdWIlMjBoZXJ1bnRlcmxhZGVuJTBBJTIwJTIwJTIwY2FjaGVkX21vZGVsJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJtb2RlbC5wa2wlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBsaWJyYXJ5X25hbWUlM0QlMjJmYXN0YWklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBsaWJyYXJ5X3ZlcnNpb24lM0RnZXRfZmFzdGFpX3ZlcnNpb24oKSUyQyUwQSUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjMlMjBNb2RlbGwlMjBsYWRlbiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxvYWRfbW9kZWwoY2FjaGVkX21vZGVsKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Modell vom Hub herunterladen</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Modell laden</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),Z=new u({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),G=new oe({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwUmVwbyUyMGVyc3RlbGxlbiUyQyUyMHdlbm4lMjBub2NoJTIwbmljaHQlMjB2b3JoYW5kZW4lMjB1bmQlMjBkaWUlMjB6dWdlaCVDMyVCNnJpZ2UlMjByZXBvX2lkJTIwZXJoYWx0ZW4lMEElMjAlMjAlMjByZXBvX2lkJTIwJTNEJTIwYXBpLmNyZWF0ZV9yZXBvKHJlcG9fbmFtZSUyQyUyMGV4aXN0X29rJTNEVHJ1ZSklMEElMEElMjAlMjAlMjAlMjMlMjBNb2RlbGwlMjBpbiUyMHRlbXBvciVDMyVBNHJlbSUyME9yZG5lciUyMHNwZWljaGVybiUyMHVuZCUyMGluJTIwZWluZW0lMjBlbnppZ2VuJTIwQ29tbWl0JTIwcHVzaGVuJTBBJTIwJTIwJTIwd2l0aCUyMFRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjB0bXBkaXIlMjAlM0QlMjBQYXRoKHRtcGRpciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZXdpY2h0ZSUyMHNwZWljaGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWwobW9kZWwlMkMlMjB0bXBkaXIlMjAlMkYlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBNb2RlbGxrYXJ0ZSUyMGdlbmVyaWVyZW4lMEElMjAlMjAlMjAlMjAlMjAlMjBjYXJkJTIwJTNEJTIwZ2VuZXJhdGVfbW9kZWxfY2FyZChtb2RlbCklMEElMjAlMjAlMjAlMjAlMjAlMjAodG1wZGlyJTIwJTJGJTIwJTIyUkVBRE1FLm1kJTIyKS53cml0ZV90ZXh0KGNhcmQpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTG9ncyUyMHNwZWljaGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMERpYWdyYW1tZSUyMHNwZWljaGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEV2YWx1YXRpb25zbWV0cmlrZW4lMjBzcGVpY2hlcm4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAuLi4lMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBdWYlMjBkZW4lMjBIdWIlMjBwdXNoZW4lMEElMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhcGkudXBsb2FkX2ZvbGRlcihyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGZvbGRlcl9wYXRoJTNEdG1wZGlyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Repo erstellen, wenn noch nicht vorhanden und die zugehörige repo_id erhalten</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># Modell in temporärem Ordner speichern und in einem enzigen Commit pushen</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Gewichte speichern</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Modellkarte generieren</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Logs speichern</span>
      <span class="hljs-comment"># Diagramme speichern</span>
      <span class="hljs-comment"># Evaluationsmetriken speichern</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Auf den Hub pushen</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),E=new u({props:{title:"Einschränkungen",local:"einschränkungen",headingTag:"h3"}}),X=new u({props:{title:"Ein komplexerer Ansatz: Klassenvererbung",local:"ein-komplexerer-ansatz-klassenvererbung",headingTag:"h2"}}),F=new u({props:{title:"Ein konkretes Beispiel: PyTorch",local:"ein-konkretes-beispiel-pytorch",headingTag:"h3"}}),K=new u({props:{title:"Wie verwendet man es?",local:"wie-verwendet-man-es",headingTag:"h4"}}),q=new oe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15TW9kZWwobm4uTW9kdWxlJTJDJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4pJTNBJTIwJTIzJTIwTWVocmZhY2h2ZXJlcmJ1bmclMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucGFyYW0lMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2gucmFuZCgzJTJDJTIwNCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5saW5lYXIlMjAlM0QlMjBubi5MaW5lYXIoNCUyQyUyMDUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmxpbmVhcih4JTIwJTJCJTIwc2VsZi5wYXJhbSklMEFtb2RlbCUyMCUzRCUyME15TW9kZWwoKSUwQSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ1c2VybmFtZSUyRm15LWF3ZXNvbWUtbW9kZWwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-comment"># 1. Definieren Sie Ihr Pytorch-Modell genau so, wie Sie es gewohnt sind</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin): <span class="hljs-comment"># Mehrfachvererbung</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(<span class="hljs-number">3</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()

<span class="hljs-comment"># 2. (optional) Modell in lokales Verzeichnis speichern</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Modellgewichte an den Hub übertragen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Modell vom Hub initialisieren</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)`,wrap:!1}}),O=new u({props:{title:"Implementierung",local:"implementierung",headingTag:"h4"}}),ne=new oe({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),te=new oe({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2VuZXJpZXJlJTIwTW9kZWxsa2FydGUlMjB1bmQlMjBzcGVpY2hlcmUlMjBHZXdpY2h0ZSUyMHZvbiUyMGVpbmVtJTIwUHl0b3JjaC1Nb2RlbGwlMjBpbiUyMGVpbmVtJTIwbG9rYWxlbiUyMFZlcnplaWNobmlzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2NhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYXJkX2RhdGElM0RNb2RlbENhcmREYXRhKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpY2Vuc2UlM0QnbWl0JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpYnJhcnlfbmFtZSUzRCUyMnB5dG9yY2glMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfc3VtbWFyeSUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX3R5cGUlM0QuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwKHNhdmVfZGlyZWN0b3J5JTIwJTJGJTIwJTIyUkVBRE1FLm1kJTIyKS53cml0ZV90ZXh0KHN0cihtb2RlbCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guc2F2ZShvYmolM0RzZWxmLm1vZHVsZS5zdGF0ZV9kaWN0KCklMkMlMjBmJTNEc2F2ZV9kaXJlY3RvcnklMjAlMkYlMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>):
      <span class="hljs-string">&quot;&quot;&quot;Generiere Modellkarte und speichere Gewichte von einem Pytorch-Modell in einem lokalen Verzeichnis.&quot;&quot;&quot;</span>
      model_card = ModelCard.from_template(
         card_data=ModelCardData(
            license=<span class="hljs-string">&#x27;mit&#x27;</span>,
            library_name=<span class="hljs-string">&quot;pytorch&quot;</span>,
            ...
         ),
         model_summary=...,
         model_type=...,
         ...
      )
      (save_directory / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(<span class="hljs-built_in">str</span>(model))
      torch.save(obj=self.module.state_dict(), f=save_directory / <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`,wrap:!1}}),se=new oe({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Muss eine Klassenmethode sein!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">dict</span>],
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># zusätzliches Argument</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># zusätzliches Argument</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Load Pytorch pretrained weights and return the loaded model.&quot;&quot;&quot;</span>
      <span class="hljs-keyword">if</span> os.path.isdir(model_id): <span class="hljs-comment"># Kann entweder ein lokales Verzeichnis sein</span>
         <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
         model_file = os.path.join(model_id, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
      <span class="hljs-keyword">else</span>: <span class="hljs-comment"># Oder ein Modell am Hub</span>
         model_file = hf_hub_download( <span class="hljs-comment"># Herunterladen vom Hub, gleiche Eingabeargumente</span>
            repo_id=model_id,
            filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            token=token,
            local_files_only=local_files_only,
         )

      <span class="hljs-comment"># Modell laden und zurückgeben - benutzerdefinierte Logik je nach Ihrem Framework</span>
      model = cls(**model_kwargs)
      state_dict = torch.load(model_file, map_location=torch.device(map_location))
      model.load_state_dict(state_dict, strict=strict)
      model.<span class="hljs-built_in">eval</span>()
      <span class="hljs-keyword">return</span> model`,wrap:!1}}),ae=new u({props:{title:"Kurzer Vergleich",local:"kurzer-vergleich",headingTag:"h2"}}),de=new Dl({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/integrations.md"}}),{c(){y=a("meta"),he=s(),pe=a("p"),ce=s(),d(b.$$.fragment),ue=s(),d(J.$$.fragment),ye=s(),T=a("p"),T.innerHTML=pl,we=s(),U=a("p"),U.textContent=ml,je=s(),f=a("ol"),f.innerHTML=hl,be=s(),I=a("p"),I.textContent=cl,Je=s(),g=a("p"),g.innerHTML=ul,Te=s(),d(C.$$.fragment),Ue=s(),k=a("p"),k.innerHTML=yl,fe=s(),_=a("p"),_.textContent=wl,Ie=s(),d(v.$$.fragment),ge=s(),B=a("p"),B.innerHTML=jl,Ce=s(),d(A.$$.fragment),ke=s(),d(Z.$$.fragment),_e=s(),W=a("p"),W.innerHTML=bl,ve=s(),d(G.$$.fragment),Be=s(),z=a("p"),z.innerHTML=Jl,Ae=s(),d(E.$$.fragment),Ze=s(),H=a("p"),H.innerHTML=Tl,We=s(),V=a("ul"),V.innerHTML=Ul,Ge=s(),$=a("p"),$.textContent=fl,ze=s(),S=a("ul"),S.innerHTML=Il,Ee=s(),x=a("p"),x.innerHTML=gl,He=s(),d(X.$$.fragment),Ve=s(),R=a("p"),R.innerHTML=Cl,$e=s(),L=a("p"),L.innerHTML=kl,Se=s(),N=a("p"),N.innerHTML=_l,xe=s(),Q=a("ol"),Q.innerHTML=vl,Xe=s(),Y=a("p"),Y.innerHTML=Bl,Re=s(),d(F.$$.fragment),Le=s(),D=a("p"),D.innerHTML=Al,Ne=s(),d(K.$$.fragment),Qe=s(),P=a("p"),P.textContent=Zl,Ye=s(),d(q.$$.fragment),Fe=s(),d(O.$$.fragment),De=s(),ee=a("p"),ee.innerHTML=Wl,Ke=s(),le=a("ol"),le.innerHTML=Gl,Pe=s(),d(ne.$$.fragment),qe=s(),w=a("ol"),w.innerHTML=zl,Oe=s(),d(te.$$.fragment),el=s(),j=a("ol"),j.innerHTML=El,ll=s(),d(se.$$.fragment),nl=s(),ie=a("p"),ie.textContent=Hl,tl=s(),d(ae.$$.fragment),sl=s(),re=a("p"),re.textContent=Vl,il=s(),Me=a("table"),Me.innerHTML=$l,al=s(),d(de.$$.fragment),rl=s(),me=a("p"),this.h()},l(e){const l=Ql("svelte-u9bgzb",document.head);y=r(l,"META",{name:!0,content:!0}),l.forEach(n),he=i(e),pe=r(e,"P",{}),Sl(pe).forEach(n),ce=i(e),o(b.$$.fragment,e),ue=i(e),o(J.$$.fragment,e),ye=i(e),T=r(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1uv5xno"&&(T.innerHTML=pl),we=i(e),U=r(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1wuvm32"&&(U.textContent=ml),je=i(e),f=r(e,"OL",{"data-svelte-h":!0}),M(f)!=="svelte-18hrhsl"&&(f.innerHTML=hl),be=i(e),I=r(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-18fkufj"&&(I.textContent=cl),Je=i(e),g=r(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1iwhhmw"&&(g.innerHTML=ul),Te=i(e),o(C.$$.fragment,e),Ue=i(e),k=r(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-d1foe8"&&(k.innerHTML=yl),fe=i(e),_=r(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1v7bx6l"&&(_.textContent=wl),Ie=i(e),o(v.$$.fragment,e),ge=i(e),B=r(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1m7ctz2"&&(B.innerHTML=jl),Ce=i(e),o(A.$$.fragment,e),ke=i(e),o(Z.$$.fragment,e),_e=i(e),W=r(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-12y5xmc"&&(W.innerHTML=bl),ve=i(e),o(G.$$.fragment,e),Be=i(e),z=r(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-calp58"&&(z.innerHTML=Jl),Ae=i(e),o(E.$$.fragment,e),Ze=i(e),H=r(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-bl4t77"&&(H.innerHTML=Tl),We=i(e),V=r(e,"UL",{"data-svelte-h":!0}),M(V)!=="svelte-16nbf7a"&&(V.innerHTML=Ul),Ge=i(e),$=r(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1lnppi9"&&($.textContent=fl),ze=i(e),S=r(e,"UL",{"data-svelte-h":!0}),M(S)!=="svelte-q0zixo"&&(S.innerHTML=Il),Ee=i(e),x=r(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-w69vgv"&&(x.innerHTML=gl),He=i(e),o(X.$$.fragment,e),Ve=i(e),R=r(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1kz5ea2"&&(R.innerHTML=Cl),$e=i(e),L=r(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-d3dywx"&&(L.innerHTML=kl),Se=i(e),N=r(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-18mc3qm"&&(N.innerHTML=_l),xe=i(e),Q=r(e,"OL",{"data-svelte-h":!0}),M(Q)!=="svelte-alyawy"&&(Q.innerHTML=vl),Xe=i(e),Y=r(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-116c8ma"&&(Y.innerHTML=Bl),Re=i(e),o(F.$$.fragment,e),Le=i(e),D=r(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1macysc"&&(D.innerHTML=Al),Ne=i(e),o(K.$$.fragment,e),Qe=i(e),P=r(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1el4w9u"&&(P.textContent=Zl),Ye=i(e),o(q.$$.fragment,e),Fe=i(e),o(O.$$.fragment,e),De=i(e),ee=r(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-oavmpb"&&(ee.innerHTML=Wl),Ke=i(e),le=r(e,"OL",{"data-svelte-h":!0}),M(le)!=="svelte-zz071o"&&(le.innerHTML=Gl),Pe=i(e),o(ne.$$.fragment,e),qe=i(e),w=r(e,"OL",{start:!0,"data-svelte-h":!0}),M(w)!=="svelte-8qqg6p"&&(w.innerHTML=zl),Oe=i(e),o(te.$$.fragment,e),el=i(e),j=r(e,"OL",{start:!0,"data-svelte-h":!0}),M(j)!=="svelte-1tllved"&&(j.innerHTML=El),ll=i(e),o(se.$$.fragment,e),nl=i(e),ie=r(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-13k5c2u"&&(ie.textContent=Hl),tl=i(e),o(ae.$$.fragment,e),sl=i(e),re=r(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-1mc7cfl"&&(re.textContent=Vl),il=i(e),Me=r(e,"TABLE",{"data-svelte-h":!0}),M(Me)!=="svelte-1or8grg"&&(Me.innerHTML=$l),al=i(e),o(de.$$.fragment,e),rl=i(e),me=r(e,"P",{}),Sl(me).forEach(n),this.h()},h(){dl(y,"name","hf:doc:metadata"),dl(y,"content",Pl),dl(w,"start","2"),dl(j,"start","3")},m(e,l){Yl(document.head,y),t(e,he,l),t(e,pe,l),t(e,ce,l),p(b,e,l),t(e,ue,l),p(J,e,l),t(e,ye,l),t(e,T,l),t(e,we,l),t(e,U,l),t(e,je,l),t(e,f,l),t(e,be,l),t(e,I,l),t(e,Je,l),t(e,g,l),t(e,Te,l),p(C,e,l),t(e,Ue,l),t(e,k,l),t(e,fe,l),t(e,_,l),t(e,Ie,l),p(v,e,l),t(e,ge,l),t(e,B,l),t(e,Ce,l),p(A,e,l),t(e,ke,l),p(Z,e,l),t(e,_e,l),t(e,W,l),t(e,ve,l),p(G,e,l),t(e,Be,l),t(e,z,l),t(e,Ae,l),p(E,e,l),t(e,Ze,l),t(e,H,l),t(e,We,l),t(e,V,l),t(e,Ge,l),t(e,$,l),t(e,ze,l),t(e,S,l),t(e,Ee,l),t(e,x,l),t(e,He,l),p(X,e,l),t(e,Ve,l),t(e,R,l),t(e,$e,l),t(e,L,l),t(e,Se,l),t(e,N,l),t(e,xe,l),t(e,Q,l),t(e,Xe,l),t(e,Y,l),t(e,Re,l),p(F,e,l),t(e,Le,l),t(e,D,l),t(e,Ne,l),p(K,e,l),t(e,Qe,l),t(e,P,l),t(e,Ye,l),p(q,e,l),t(e,Fe,l),p(O,e,l),t(e,De,l),t(e,ee,l),t(e,Ke,l),t(e,le,l),t(e,Pe,l),p(ne,e,l),t(e,qe,l),t(e,w,l),t(e,Oe,l),p(te,e,l),t(e,el,l),t(e,j,l),t(e,ll,l),p(se,e,l),t(e,nl,l),t(e,ie,l),t(e,tl,l),p(ae,e,l),t(e,sl,l),t(e,re,l),t(e,il,l),t(e,Me,l),t(e,al,l),p(de,e,l),t(e,rl,l),t(e,me,l),Ml=!0},p:Xl,i(e){Ml||(m(b.$$.fragment,e),m(J.$$.fragment,e),m(C.$$.fragment,e),m(v.$$.fragment,e),m(A.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(E.$$.fragment,e),m(X.$$.fragment,e),m(F.$$.fragment,e),m(K.$$.fragment,e),m(q.$$.fragment,e),m(O.$$.fragment,e),m(ne.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(de.$$.fragment,e),Ml=!0)},o(e){h(b.$$.fragment,e),h(J.$$.fragment,e),h(C.$$.fragment,e),h(v.$$.fragment,e),h(A.$$.fragment,e),h(Z.$$.fragment,e),h(G.$$.fragment,e),h(E.$$.fragment,e),h(X.$$.fragment,e),h(F.$$.fragment,e),h(K.$$.fragment,e),h(q.$$.fragment,e),h(O.$$.fragment,e),h(ne.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(de.$$.fragment,e),Ml=!1},d(e){e&&(n(he),n(pe),n(ce),n(ue),n(ye),n(T),n(we),n(U),n(je),n(f),n(be),n(I),n(Je),n(g),n(Te),n(Ue),n(k),n(fe),n(_),n(Ie),n(ge),n(B),n(Ce),n(ke),n(_e),n(W),n(ve),n(Be),n(z),n(Ae),n(Ze),n(H),n(We),n(V),n(Ge),n($),n(ze),n(S),n(Ee),n(x),n(He),n(Ve),n(R),n($e),n(L),n(Se),n(N),n(xe),n(Q),n(Xe),n(Y),n(Re),n(Le),n(D),n(Ne),n(Qe),n(P),n(Ye),n(Fe),n(De),n(ee),n(Ke),n(le),n(Pe),n(qe),n(w),n(Oe),n(el),n(j),n(ll),n(nl),n(ie),n(tl),n(sl),n(re),n(il),n(Me),n(al),n(rl),n(me)),n(y),c(b,e),c(J,e),c(C,e),c(v,e),c(A,e),c(Z,e),c(G,e),c(E,e),c(X,e),c(F,e),c(K,e),c(q,e),c(O,e),c(ne,e),c(te,e),c(se,e),c(ae,e),c(de,e)}}}const Pl='{"title":"Integrieren Sie jedes ML-Framework mit dem Hub","local":"integrieren-sie-jedes-ml-framework-mit-dem-hub","sections":[{"title":"Ein flexibler Ansatz: Helfer","local":"ein-flexibler-ansatz-helfer","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Einschränkungen","local":"einschränkungen","sections":[],"depth":3}],"depth":2},{"title":"Ein komplexerer Ansatz: Klassenvererbung","local":"ein-komplexerer-ansatz-klassenvererbung","sections":[{"title":"Ein konkretes Beispiel: PyTorch","local":"ein-konkretes-beispiel-pytorch","sections":[{"title":"Wie verwendet man es?","local":"wie-verwendet-man-es","sections":[],"depth":4},{"title":"Implementierung","local":"implementierung","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Kurzer Vergleich","local":"kurzer-vergleich","sections":[],"depth":2}],"depth":1}';function ql(ol){return Rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tn extends Ll{constructor(y){super(),Nl(this,y,ql,Kl,xl,{})}}export{tn as component};
