import{s as $n,n as Rn,o as vn}from"../chunks/scheduler.de5597d1.js";import{S as zn,i as Nn,e as a,s,c as r,h as Dn,a as M,d as t,b as i,f as kn,g as J,j as T,k as Pe,l as Zn,m as n,n as d,t as c,o as w,p as h}from"../chunks/index.bf1177c2.js";import{C as Sn,H as U,E as Bn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d16525ff.js";import{C as m}from"../chunks/CodeBlock.0114a234.js";function Gn(zt){let p,qe,He,Ke,y,el,u,ll,f,tl,C,Nt=`Das Hugging Face Hub Cache-System wurde entwickelt, um der zentrale Cache zu sein,
der zwischen Bibliotheken geteilt wird, welche vom Hub abhängen. Es wurde in v0.8.0 aktualisiert,
um das erneute Herunterladen von Dateien zwischen Revisionen zu verhindern.`,nl,b,Dt="Das Cache-System ist wie folgt aufgebaut:",sl,A,il,g,Zt=`Der <code>&lt;CACHE_DIR&gt;</code> ist normalerweise das Home-Verzeichnis Ihres Benutzers. Es kann jedoch mit dem
<code>cache_dir</code>-Argument in allen Methoden oder durch Angabe der Umgebungsvariablen
<code>HF_HOME</code> oder <code>HF_HUB_CACHE</code> angepasst werden.`,al,k,St=`Modelle, Datensätze und Räume teilen eine gemeinsame Wurzel.
Jedes dieser Repositories enthält den Repository-Typ, den Namensraum (Organisation oder Benutzername),
falls vorhanden, und den Repository-Namen:`,Ml,$,Tl,R,Bt=`Innerhalb dieser Ordner werden nun alle Dateien vom Hub heruntergeladen. Das Caching stellt sicher,
dass eine Datei nicht zweimal heruntergeladen wird, wenn sie bereits existiert und nicht aktualisiert wurde;
wurde sie jedoch aktualisiert und Sie fordern die neueste Datei an, wird die neueste Datei heruntergeladen
(während die vorherige Datei intakt bleibt, falls Sie sie erneut benötigen).`,rl,v,Gt="Um dies zu erreichen, enthalten alle Ordner dasselbe Grundgerüst:",Jl,z,dl,N,Lt="Jeder Ordner ist so gestaltet, dass er das Folgende enthält:",cl,D,wl,Z,Ot=`Der Ordner <code>refs</code> enthält Dateien, die die neueste Revision des gegebenen Verweises anzeigen.
Zum Beispiel, wenn wir zuvor eine Datei aus dem <code>main</code>-Branch eines Repositories abgerufen haben,
wird der Ordner <code>refs</code> eine Datei namens <code>main</code> enthalten, die selbst den Commit-Identifikator der aktuellen HEAD-Branch enthält.`,hl,S,Qt="Wenn der neueste Commit von <code>main</code> den Identifikator <code>aaaaaa</code> hat, dann enthält er <code>aaaaaa</code>.",Ul,B,Ft=`Wenn derselbe Zweig mit einem neuen Commit aktualisiert wird, der den Identifikator <code>bbbbbb</code> hat,
wird das erneute Herunterladen einer Datei von diesem Verweis die Datei <code>refs/main</code> aktualisieren, um <code>bbbbbb</code> zu enthalten.`,ml,G,pl,L,Wt="Der Ordner <code>blobs</code> enthält die tatsächlichen Dateien, die wir heruntergeladen haben. Der Name jeder Datei ist ihr Hash.",Il,O,jl,Q,Yt=`Der Ordner <code>snapshots</code> enthält Symlinks zu den oben erwähnten Blobs.
Er besteht selbst aus mehreren Ordnern: einem pro bekannter Revision!`,ol,F,Et=`In der obigen Erklärung hatten wir zunächst eine Datei von der Revision <code>aaaaaa</code> abgerufen, bevor wir eine Datei
von der Revision <code>bbbbbb</code> abgerufen haben. In dieser Situation hätten wir jetzt zwei Ordner im Ordner <code>snapshots</code>: <code>aaaaaa</code> und <code>bbbbbb</code>.`,yl,W,xt=`In jedem dieser Ordner leben Symlinks, die die Namen der Dateien haben, die wir heruntergeladen haben.
Wenn wir zum Beispiel die Datei <code>README.md</code> in der Revision <code>aaaaaa</code> heruntergeladen hätten, hätten wir den folgenden Pfad:`,ul,Y,fl,E,_t="Diese <code>README.md</code>-Datei ist tatsächlich ein Symlink, der auf den Blob verweist, der den Hash der Datei hat.",Cl,x,Vt=`Durch das Erstellen des Grundgerüsts auf diese Weise ermöglichen wir den Mechanismus der Dateifreigabe:
Wenn dieselbe Datei in der Revision <code>bbbbbb</code> abgerufen wurde, hätte sie denselben Hash und die Datei müsste nicht erneut heruntergeladen werden.`,bl,_,Al,V,Ht=`Zusätzlich zu den Ordnern <code>blobs</code>, <code>refs</code> und <code>snapshots</code> könnten Sie in Ihrem Cache auch einen <code>.no_exist</code> Ordner finden.
Dieser Ordner hält fest, welche Dateien Sie einmal versucht haben herunterzuladen, die jedoch nicht auf dem Hub vorhanden sind.
Seine Struktur ist dieselbe wie der <code>snapshots</code> Ordner mit einem Unterordner pro bekannter Revision:`,gl,H,kl,X,Xt=`Im Gegensatz zum <code>snapshots</code> Ordner handelt es sich bei den Dateien um einfache leere Dateien (keine Symlinks).
In diesem Beispiel existiert die Datei <code>&quot;config_that_does_not_exist.json&quot;</code> nicht auf dem Hub für die Revision <code>&quot;aaaaaa&quot;</code>.
Da dieser Ordner nur leere Dateien speichert, ist sein Speicherplatzverbrauch vernachlässigbar.`,$l,P,Pt=`Sie fragen sich jetzt vielleicht, warum diese Information überhaupt relevant ist?
In einigen Fällen versucht ein Framework, optionale Dateien für ein Modell zu laden.
Das Speichern der Nicht-Existenz optionaler Dateien beschleunigt das Laden eines Modells, da 1 HTTP-Anfrage pro möglicher optionaler Datei gespart wird.
Dies ist zum Beispiel bei <code>transformers</code> der Fall, wo jeder Tokenizer zusätzliche Dateien unterstützen kann. Beim ersten Laden des Tokenizers
auf Ihrem Gerät wird im Cache gespeichert, welche optionalen Dateien vorhanden sind (und welche nicht), um die Ladezeit bei den nächsten Initialisierungen zu beschleunigen.`,Rl,q,qt=`Um zu testen, ob eine Datei lokal im Cache gespeichert ist (ohne eine HTTP-Anfrage zu senden), können Sie die <code>try_to_load_from_cache()</code> Hilfsfunktion verwenden.
Sie gibt entweder den Dateipfad zurück (falls vorhanden und im Cache gespeichert), das Objekt <code>_CACHED_NO_EXIST</code> (wenn die Nicht-Existenz im Cache gespeichert ist)
oder <code>None</code> (wenn wir es nicht wissen).`,vl,K,zl,ee,Nl,le,Kt="In der Praxis sollte Ihr Cache folgendermaßen aussehen:",Dl,te,Zl,ne,Sl,se,en=`Um ein effizientes Cache-System zu haben, verwendet <code>huggingface-hub</code> Symlinks. Allerdings
werden Symlinks nicht auf allen Maschinen unterstützt. Dies ist eine bekannte Einschränkung,
insbesondere bei Windows. Wenn dies der Fall ist, verwendet <code>huggingface_hub</code> nicht das <code>blobs/</code> Verzeichnis,
sondern speichert die Dateien direkt im <code>snapshots/</code> Verzeichnis. Dieser Workaround ermöglicht es den Nutzern,
Dateien vom Hub auf genau die gleiche Weise herunterzuladen und zu cachen.
Auch Werkzeuge zur Überprüfung und Löschung des Caches (siehe unten) werden unterstützt.
Allerdings ist das Cache-System weniger effizient, da eine einzelne Datei möglicherweise mehrmals heruntergeladen wird,
wenn mehrere Revisionen des gleichen Repos heruntergeladen werden.`,Bl,ie,ln=`Wenn Sie von dem Symlink-basierten Cache-System auf einem Windows-Gerät profitieren möchten,
müssen Sie entweder den <a href="https://docs.microsoft.com/en-us/windows/apps/get-started/enable-your-device-for-development" rel="nofollow">Entwicklermodus aktivieren</a>
oder Python als Administrator ausführen.`,Gl,ae,tn=`Wenn Symlinks nicht unterstützt werden, wird dem Nutzer eine Warnmeldung angezeigt, um ihn darauf hinzuweisen,
dass er eine eingeschränkte Version des Cache-Systems verwendet. Diese Warnung kann durch Setzen der
Umgebungsvariable <code>HF_HUB_DISABLE_SYMLINKS_WARNING</code> auf true deaktiviert werden.`,Ll,Me,Ol,Te,nn=`Zusätzlich zum Zwischenspeichern von Dateien aus dem Hub benötigen nachgelagerte Bibliotheken
oft das Zwischenspeichern von anderen Dateien, die in Verbindung mit HF stehen, aber nicht
direkt von <code>huggingface_hub</code> behandelt werden (zum Beispiel: Dateien, die von GitHub heruntergeladen werden,
vorverarbeitete Daten, Protokolle,…). Um diese Dateien, die als <code>assets</code> bezeichnet werden, zwischenzuspeichern,
kann man <code>cached_assets_path()</code> verwenden. Dieser kleine Helfer generiert Pfade im HF-Cache auf eine einheitliche Weise,
basierend auf dem Namen der anfragenden Bibliothek und optional auf einem Namensraum und einem Unterordnernamen.
Das Ziel ist, dass jede nachgelagerte Bibliothek ihre Assets auf ihre eigene Weise verwaltet
(z.B. keine Regelung über die Struktur), solange sie im richtigen Assets-Ordner bleibt.
Diese Bibliotheken können dann die Werkzeuge von <code>huggingface_hub</code> nutzen, um den Cache zu verwalten,
insbesondere um Teile der Assets über einen CLI-Befehl zu scannen und zu löschen.`,Ql,re,Fl,I,sn=`<p><code>cached_assets_path()</code> ist der empfohlene Weg, um Assets zu speichern, ist jedoch nicht verpflichtend.
Wenn Ihre Bibliothek bereits ihren eigenen Cache verwendet, können Sie diesen gerne nutzen!</p>`,Wl,Je,Yl,de,an="In der Praxis sollte Ihr Assets-Cache wie der folgende Verzeichnisbaum aussehen:",El,ce,xl,we,_l,he,Mn=`Derzeit werden zwischengespeicherte Dateien nie aus Ihrem lokalen Verzeichnis gelöscht:
Wenn Sie eine neue Revision eines Zweiges herunterladen, werden vorherige Dateien aufbewahrt,
falls Sie sie wieder benötigen. Daher kann es nützlich sein, Ihr Cache-Verzeichnis zu scannen,
um zu erfahren, welche Repos und Revisionen den meisten Speicherplatz beanspruchen.
<code>huggingface_hub</code> bietet einen Helfer dafür, der über <code>hf</code> oder in einem Python-Skript verwendet werden kann.`,Vl,Ue,Hl,me,Tn=`Die bequemste Möglichkeit, Ihren HF-Cache zu untersuchen, ist der Befehl <code>hf cache ls</code>.
Er listet standardmäßig alle gecachten Repositories zusammen mit Größe, letzter Nutzung und Referenzen auf.`,Xl,pe,Pl,Ie,rn=`Mit <code>--revisions</code> wechseln Sie zur Ansicht auf Snapshot-Ebene. Filter akzeptieren
menschenlesbare Werte, sodass Ausdrücke wie <code>size&gt;1GB</code> oder <code>accessed&gt;30d</code> sofort funktionieren:`,ql,je,Kl,oe,Jn=`Brauchen Sie maschinenlesbare Ausgaben? <code>--format json</code> liefert strukturierte Objekte,
<code>--format csv</code> erzeugt durch Komma getrennte Zeilen und <code>--quiet</code> gibt nur Kennungen aus.
Alle Varianten lassen sich mit <code>--cache-dir</code> kombinieren, wenn Ihr Cache nicht unter <code>HF_HOME</code>
liegt.`,et,ye,lt,ue,dn=`Die Tabellen-Ausgabe lässt sich weiterhin mit bekannten Tools verarbeiten. Das folgende
Beispiel zeigt alle Revisionen für <code>t5-small</code>:`,tt,fe,nt,Ce,st,be,cn=`Für eine erweiterte Nutzung verwenden Sie <code>scan_cache_dir()</code>, welches das von dem CLI-Tool
aufgerufene Python-Dienstprogramm ist.`,it,Ae,wn="Sie können es verwenden, um einen detaillierten Bericht zu erhalten, der um 4 Datenklassen herum strukturiert ist:",at,ge,hn="<li><code>HFCacheInfo</code>: vollständiger Bericht, der von <code>scan_cache_dir()</code> zurückgegeben wird</li> <li><code>CachedRepoInfo</code>: Informationen über ein gecachtes Repo</li> <li><code>CachedRevisionInfo</code>: Informationen über eine gecachtes Revision (z.B. “snapshot) in einem Repo</li> <li><code>CachedFileInfo</code>: Informationen über eine gecachte Datei in einem Snapshot</li>",Mt,ke,Un="Hier ist ein einfaches Anwendungs-Beispiel in Python. Siehe Referenz für Details.",Tt,$e,rt,Re,Jt,ve,mn=`Das Durchsuchen Ihres Caches ist interessant, aber was Sie normalerweise als Nächstes tun möchten, ist
einige Teile zu löschen, um Speicherplatz freizugeben. Dies gelingt mit den CLI-Befehlen
<code>hf cache rm</code> und <code>hf cache prune</code>. Alternativ können Sie programmatisch den
<code>delete_revisions()</code>-Helfer des zurückgegebenen <code>HFCacheInfo</code>-Objekts nutzen.`,dt,ze,ct,Ne,pn=`Um einige Cache zu löschen, müssen Sie eine Liste von Revisionen übergeben, die gelöscht werden sollen. Das Tool wird
eine Strategie definieren, um den Speicherplatz auf der Grundlage dieser Liste freizugeben. Es gibt ein
<code>DeleteCacheStrategy</code> Objekt zurück, das beschreibt, welche Dateien und Ordner gelöscht werden. Die
<code>DeleteCacheStrategy</code> zeigt Ihnen, wie viel Speicherplatz voraussichtlich frei wird.
Sobald Sie mit der Löschung einverstanden sind, müssen Sie sie ausführen, um die Löschung wirksam zu machen.
Um Abweichungen zu vermeiden, können Sie ein Strategieobjekt nicht manuell bearbeiten.`,wt,De,In="Die Strategie zur Löschung von Revisionen ist folgende:",ht,Ze,jn="<li>Der Ordner <code>snapshot</code>, der die Revisions-Symlinks enthält, wird gelöscht.</li> <li>Blob-Dateien, die nur von zu löschenden Revisionen verlinkt werden, werden ebenfalls gelöscht.</li> <li>Wenn eine Revision mit 1 oder mehreren <code>refs</code> verknüpft ist, werden die Referenzen gelöscht.</li> <li>Werden alle Revisionen aus einem Repo gelöscht, wird das gesamte zwischengespeicherte Repository gelöscht.</li>",Ut,j,on=`<p>Revisions-Hashes sind eindeutig über alle Repositories hinweg. <code>hf cache rm</code> akzeptiert daher sowohl
Repository-Kennungen (z. B. <code>model/bert-base-uncased</code>) als auch einzelne Revisions-Hashes – bei einem Hash
müssen Sie das Repository nicht zusätzlich angeben.</p>`,mt,o,yn=`<p>Wenn eine Revision im Cache nicht gefunden wird, wird sie stillschweigend ignoriert. Außerdem wird, wenn eine Datei
oder ein Ordner beim Versuch, ihn zu löschen, nicht gefunden wird, eine Warnung protokolliert, aber es wird kein
Fehler ausgelöst. Die Löschung wird für andere Pfade im
<code>DeleteCacheStrategy</code> Objekt fortgesetzt.</p>`,pt,Se,It,Be,un=`Verwenden Sie <code>hf cache rm</code>, um gecachte Repositories oder einzelne Revisionen zu löschen.
Übergeben Sie dazu eine oder mehrere Repository-Kennungen (z. B. <code>model/bert-base-uncased</code>) oder Revisions-Hashes:`,jt,Ge,ot,Le,fn=`Sie können Repositories und spezifische Revisionen mischen. Nutzen Sie <code>--dry-run</code>, um den Effekt vorab zu prüfen,
oder <code>--yes</code>, wenn keine Rückfrage erscheinen soll:`,yt,Oe,ut,Qe,Cn="Wenn Ihr Cache nicht im Standardverzeichnis liegt, kombinieren Sie den Befehl mit <code>--cache-dir PFAD</code>.",ft,Fe,bn=`Zum Aufräumen verwaister Snapshots steht <code>hf cache prune</code> bereit. Der Befehl entfernt automatisch alle
Revisionen ohne Referenz:`,Ct,We,bt,Ye,An=`Beide Befehle unterstützen <code>--dry-run</code>, <code>--yes</code> und <code>--cache-dir</code>, sodass Sie Vorschauen erzeugen,
Automatisierungen bauen und alternative Cache-Verzeichnisse angeben können.`,At,Ee,gt,xe,gn=`Für mehr Flexibilität können Sie auch die Methode <code>delete_revisions()</code> programmatisch verwenden.
Hier ist ein einfaches Beispiel. Siehe Referenz für Details.`,kt,_e,$t,Ve,Rt,Xe,vt;return y=new Sn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new U({props:{title:"Verwalten des huggingface_hub Cache-Systems",local:"verwalten-des-huggingfacehub-cache-systems",headingTag:"h1"}}),f=new U({props:{title:"Caching verstehen",local:"caching-verstehen",headingTag:"h2"}}),A=new m({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDTU9ERUxTJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDREFUQVNFVFMlM0UlMEElRTIlOTQlOUMlRTIlOTQlODAlMjAlM0NTUEFDRVMlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">CACHE_DIR</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">MODELS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">DATASETS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">SPACES</span>&gt;</span>`,wrap:!1}}),$=new m({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tbHlzYW5kcmVqaWstLWFyeGl2LW5scCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tYmVydC1iYXNlLWNhc2VkJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlOUMlRTIlOTQlODAlMjBkYXRhc2V0cy0taHVnZ2luZ2ZhY2UtLURhdGFNZWFzdXJlbWVudHNGaWxlcyUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMHNwYWNlcy0tZGFsbGUtbWluaS0tZGFsbGUtbWluaQ==",highlighted:`&lt;<span class="hljs-comment">CACHE_DIR</span>&gt;
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">julien</span><span class="hljs-literal">-</span><span class="hljs-comment">c</span><span class="hljs-literal">--</span><span class="hljs-comment">EsperBERTo</span><span class="hljs-literal">-</span><span class="hljs-comment">small</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">lysandrejik</span><span class="hljs-literal">--</span><span class="hljs-comment">arxiv</span><span class="hljs-literal">-</span><span class="hljs-comment">nlp</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">bert</span><span class="hljs-literal">-</span><span class="hljs-comment">base</span><span class="hljs-literal">-</span><span class="hljs-comment">cased</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">glue</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">huggingface</span><span class="hljs-literal">--</span><span class="hljs-comment">DataMeasurementsFiles</span>
<span class="hljs-comment">├─ spaces</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span>`,wrap:!1}}),z=new m({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjByZWZzJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwYmxvYnMlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzbmFwc2hvdHMlMEEuLi4=",highlighted:`&lt;CACHE_DIR&gt;
├─ datasets<span class="hljs-params">--glue</span>
│  ├─ refs
│  ├─ blobs
│  ├─ snapshots
<span class="hljs-string">...</span>`,wrap:!1}}),D=new U({props:{title:"Refs",local:"refs",headingTag:"h3"}}),G=new U({props:{title:"Blobs",local:"blobs",headingTag:"h3"}}),O=new U({props:{title:"Snapshots",local:"snapshots",headingTag:"h3"}}),Y=new m({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGc25hcHNob3RzJTJGYWFhYWFhJTJGUkVBRE1FLm1k",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>snapshots<span class="hljs-regexp">/aaaaaa/</span>README.md',wrap:!1}}),_=new U({props:{title:".no_exist (fortgeschritten)",local:"noexist-fortgeschritten",headingTag:"h3"}}),H=new m({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGLm5vX2V4aXN0JTJGYWFhYWFhJTJGY29uZmlnX3RoYXRfZG9lc19ub3RfZXhpc3QuanNvbg==",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>.no_exist<span class="hljs-regexp">/aaaaaa/</span>config_that_does_not_exist.json',wrap:!1}}),K=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHRyeV90b19sb2FkX2Zyb21fY2FjaGUlMkMlMjBfQ0FDSEVEX05PX0VYSVNUJTBBJTBBZmlsZXBhdGglMjAlM0QlMjB0cnlfdG9fbG9hZF9mcm9tX2NhY2hlKCklMEFpZiUyMGlzaW5zdGFuY2UoZmlsZXBhdGglMkMlMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZmlsZSUyMGV4aXN0cyUyMGFuZCUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxpZiUyMGZpbGVwYXRoJTIwaXMlMjBfQ0FDSEVEX05PX0VYSVNUJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbm9uLWV4aXN0ZW5jZSUyMG9mJTIwZmlsZSUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGZpbGUlMjBpcyUyMG5vdCUyMGNhY2hlZCUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> try_to_load_from_cache, _CACHED_NO_EXIST

filepath = try_to_load_from_cache()
<span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(filepath, <span class="hljs-built_in">str</span>):
    <span class="hljs-comment"># file exists and is cached</span>
    ...
<span class="hljs-keyword">elif</span> filepath <span class="hljs-keyword">is</span> _CACHED_NO_EXIST:
    <span class="hljs-comment"># non-existence of file is cached</span>
    ...
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># file is not cached</span>
    ...`,wrap:!1}}),ee=new U({props:{title:"In der Praxis",local:"in-der-praxis",headingTag:"h3"}}),te=new m({props:{code:"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",highlighted:`    [  96]  .
    └── [ 160]  models--julien-c--EsperBERTo-small
        ├── [ 160]  blobs
        │   ├── [321M]  403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        │   ├── [ 398]  7cb18dc9bafbfcf74629a4b760af1b160957a83e
        │   └── [1.4K]  d7edf6bd2a681fb0175f7735299831ee1b22b812
        ├── [  96]  refs
        │   └── [  40]  main
        └── [ 128]  snapshots
            ├── [ 128]  2439f60ef33a0d46d85da5001d52aeda5b00ce9f
            │   ├── [  52]  README.md -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
            │   └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
            └── [ 128]  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
                ├── [  52]  README.md -&gt; ../../blobs/7cb18dc9bafbfcf74629a4b760af1b160957a83e
                └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),ne=new U({props:{title:"Einschränkungen",local:"einschränkungen",headingTag:"h3"}}),Me=new U({props:{title:"Assets zwischenspeichern",local:"assets-zwischenspeichern",headingTag:"h2"}}),re=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNhY2hlZF9hc3NldHNfcGF0aCUwQSUwQWFzc2V0c19wYXRoJTIwJTNEJTIwY2FjaGVkX2Fzc2V0c19wYXRoKGxpYnJhcnlfbmFtZSUzRCUyMmRhdGFzZXRzJTIyJTJDJTIwbmFtZXNwYWNlJTNEJTIyU1F1QUQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJkb3dubG9hZCUyMiklMEFzb21ldGhpbmdfcGF0aCUyMCUzRCUyMGFzc2V0c19wYXRoJTIwJTJGJTIwJTIyc29tZXRoaW5nLmpzb24lMjIlMjAlMjMlMjBNYWNoZW4lMjBTaWUlMkMlMjB3YXMlMjBTaWUlMjBtJUMzJUI2Y2h0ZW4lMkMlMjBpbiUyMElocmVtJTIwQXNzZXRzLU9yZG5lciE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cached_assets_path

assets_path = cached_assets_path(library_name=<span class="hljs-string">&quot;datasets&quot;</span>, namespace=<span class="hljs-string">&quot;SQuAD&quot;</span>, subfolder=<span class="hljs-string">&quot;download&quot;</span>)
something_path = assets_path / <span class="hljs-string">&quot;something.json&quot;</span> <span class="hljs-comment"># Machen Sie, was Sie möchten, in Ihrem Assets-Ordner!</span>`,wrap:!1}}),Je=new U({props:{title:"Assets in der Praxis",local:"assets-in-der-praxis",headingTag:"h3"}}),ce=new m({props:{code:"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",highlighted:`    assets/
    └── datasets/
    │   ├── SQuAD/
    │   │   ├── downloaded/
    │   │   ├── extracted/
    │   │   └── processed/
    │   ├── Helsinki-NLP--tatoeba_mt/
    │       ├── downloaded/
    │       ├── extracted/
    │       └── processed/
    └── transformers/
        ├── default/
        │   ├── something/
        ├── bert-base-cased/
        │   ├── default/
        │   └── training/
    hub/
    └── models--julien-c--EsperBERTo-small/
        ├── blobs/
        │   ├── (...)
        │   ├── (...)
        ├── refs/
        │   └── (...)
        └── [ 128]  snapshots/
            ├── 2439f60ef33a0d46d85da5001d52aeda5b00ce9f/
            │   ├── (...)
            └── bbc77c8132af1cc5cf678da3f1ddf2de43606d48/
                └── (...)`,wrap:!1}}),we=new U({props:{title:"Cache scannen",local:"cache-scannen",headingTag:"h2"}}),Ue=new U({props:{title:"Cache im Terminal prüfen",local:"cache-im-terminal-prüfen",headingTag:"h3"}}),pe=new m({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMGxzJTBBSUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTSVpFJTIwJTIwJTIwTEFTVF9BQ0NFU1NFRCUyMExBU1RfTU9ESUZJRUQlMjBSRUZTJTBBLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTIwLS0tLS0tLSUyMC0tLS0tLS0tLS0tLS0lMjAtLS0tLS0tLS0tLS0tJTIwLS0tLS0tLS0tLS0tLS0tLS0tLSUwQWRhdGFzZXQlMkZnbHVlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTE2LjNLJTIwNCUyMGRheXMlMjBhZ28lMjAlMjAlMjAlMjAlMjA0JTIwZGF5cyUyMGFnbyUyMCUyMCUyMCUyMCUyMDIuNC4wJTIwbWFpbiUyMDEuMTcuMCUwQWRhdGFzZXQlMkZnb29nbGUlMkZmbGV1cnMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA2NC45TSUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwJTIwMSUyMHdlZWslMjBhZ28lMjAlMjAlMjAlMjAlMjBtYWluJTIwcmVmcyUyRnByJTJGMSUwQW1vZGVsJTJGSmVhbi1CYXB0aXN0ZSUyRmNhbWVtYmVydC1uZXIlMjAlMjAlMjAlMjA0NDEuME0lMjAyJTIwd2Vla3MlMjBhZ28lMjAlMjAlMjAlMjAxNiUyMGhvdXJzJTIwYWdvJTIwJTIwJTIwbWFpbiUwQW1vZGVsJTJGYmVydC1iYXNlLWNhc2VkJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45RyUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwJTIwMiUyMHllYXJzJTIwYWdvJTBBbW9kZWwlMkZ0NS1iYXNlJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMTAuMUslMjAzJTIwbW9udGhzJTIwYWdvJTIwJTIwJTIwMyUyMG1vbnRocyUyMGFnbyUyMCUyMCUyMG1haW4lMEFtb2RlbCUyRnQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwOTcwLjdNJTIwMyUyMGRheXMlMjBhZ28lMjAlMjAlMjAlMjAlMjAzJTIwZGF5cyUyMGFnbyUyMCUyMCUyMCUyMCUyMG1haW4lMjByZWZzJTJGcHIlMkYxJTBBJTBBRm91bmQlMjA2JTIwcmVwbyhzKSUyMGZvciUyMGElMjB0b3RhbCUyMG9mJTIwMTIlMjByZXZpc2lvbihzKSUyMGFuZCUyMDMuNEclMjBvbiUyMGRpc2su",highlighted:`➜ hf cache ls
ID                                   SIZE   LAST_ACCESSED LAST_MODIFIED REFS
------------------------------------ ------- ------------- ------------- -------------------
dataset/glue                         116.3K 4 days ago     4 days ago     2.4.0 main 1.17.0
dataset/google/fleurs                 64.9M 1 week ago     1 week ago     main refs/pr/1
model/Jean-Baptiste/camembert-ner    441.0M 2 weeks ago    16 hours ago   main
model/bert-base-cased                  1.9G 1 week ago     2 years ago
model/t5-base                          10.1K 3 months ago   3 months ago   main
model/t5-small                        970.7M 3 days ago     3 days ago     main refs/pr/1

Found 6 repo(s) for a total of 12 revision(s) and 3.4G on disk.`,wrap:!1}}),je=new m({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMGxzJTIwLS1yZXZpc2lvbnMlMjAtLWZpbHRlciUyMCUyMnNpemUlM0UxR0IlMjIlMjAtLWZpbHRlciUyMCUyMmFjY2Vzc2VkJTNFMzBkJTIyJTBBSUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSRVZJU0lPTiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNJWkUlMjAlMjAlMjBMQVNUX01PRElGSUVEJTIwUkVGUyUwQS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyMC0tLS0tLS0tLS0tLS0tLS0tLSUyMC0tLS0tLS0lMjAtLS0tLS0tLS0tLS0tJTIwLS0tLS0tLS0tLS0tLS0tLS0tLSUwQW1vZGVsJTJGYmVydC1iYXNlLWNhc2VkJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNmQxZDdhMWEyYTZjZjRjMiUyMCUyMCUyMCUyMDEuOUclMjAlMjAyJTIweWVhcnMlMjBhZ28lMEFtb2RlbCUyRnQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMWM2MTBmNmIzZjVlN2Q4YSUyMCUyMCUyMCUyMDEuMUclMjAlMjAzJTIwbW9udGhzJTIwYWdvJTIwJTIwbWFpbiUwQSUwQUZvdW5kJTIwMiUyMHJlcG8ocyklMjBmb3IlMjBhJTIwdG90YWwlMjBvZiUyMDIlMjByZXZpc2lvbihzKSUyMGFuZCUyMDMuMEclMjBvbiUyMGRpc2su",highlighted:`➜ hf cache ls --revisions --filter &quot;size&gt;1GB&quot; --filter &quot;accessed&gt;30d&quot;
ID                                   REVISION            SIZE   LAST_MODIFIED REFS
------------------------------------ ------------------ ------- ------------- -------------------
model/bert-base-cased                6d1d7a1a2a6cf4c2    1.9G  2 years ago
model/t5-small                       1c610f6b3f5e7d8a    1.1G  3 months ago  main

Found 2 repo(s) for a total of 2 revision(s) and 3.0G on disk.`,wrap:!1}}),ye=new U({props:{title:"Mit Shell-Tools filtern",local:"mit-shell-tools-filtern",headingTag:"h4"}}),fe=new m({props:{code:"JUUyJTlFJTlDJTIwZXZhbCUyMCUyMmhmJTIwY2FjaGUlMjBscyUyMC0tcmV2aXNpb25zJTIyJTIwJTdDJTIwZ3JlcCUyMCUyMnQ1LXNtYWxsJTIyJTBBbW9kZWwlMkZ0NS1zbWFsbCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDFjNjEwZjZiM2Y1ZTdkOGElMjAlMjAlMjAlMjAxLjFHJTIwJTIwMyUyMG1vbnRocyUyMGFnbyUyMCUyMG1haW4lMEFtb2RlbCUyRnQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwOGYzYWQxYzkwZmVkN2E2MiUyMCUyMCUyMCUyMDgyMC4xTSUyMDIlMjB3ZWVrcyUyMGFnbyUyMCUyMCUyMHJlZnMlMkZwciUyRjE=",highlighted:`➜ eval &quot;hf cache ls --revisions&quot; | grep &quot;t5-small&quot;
model/t5-small                       1c610f6b3f5e7d8a    1.1G  3 months ago  main
model/t5-small                       8f3ad1c90fed7a62    820.1M 2 weeks ago   refs/pr/1`,wrap:!1}}),Ce=new U({props:{title:"Den Cache von Python aus scannen",local:"den-cache-von-python-aus-scannen",headingTag:"h3"}}),$e=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBaGZfY2FjaGVfaW5mbyUyMCUzRCUyMHNjYW5fY2FjaGVfZGlyKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_cache_info = scan_cache_dir()
HFCacheInfo(
    size_on_disk=<span class="hljs-number">3398085269</span>,
    repos=<span class="hljs-built_in">frozenset</span>({
        CachedRepoInfo(
            repo_id=<span class="hljs-string">&#x27;t5-small&#x27;</span>,
            repo_type=<span class="hljs-string">&#x27;model&#x27;</span>,
            repo_path=PosixPath(...),
            size_on_disk=<span class="hljs-number">970726914</span>,
            nb_files=<span class="hljs-number">11</span>,
            last_accessed=<span class="hljs-number">1662971707.3567169</span>,
            last_modified=<span class="hljs-number">1662971107.3567169</span>,
            revisions=<span class="hljs-built_in">frozenset</span>({
                CachedRevisionInfo(
                    commit_hash=<span class="hljs-string">&#x27;d78aea13fa7ecd06c29e3e46195d6341255065d5&#x27;</span>,
                    size_on_disk=<span class="hljs-number">970726339</span>,
                    snapshot_path=PosixPath(...),
                    <span class="hljs-comment"># No \`last_accessed\` as blobs are shared among revisions</span>
                    last_modified=<span class="hljs-number">1662971107.3567169</span>,
                    files=<span class="hljs-built_in">frozenset</span>({
                        CachedFileInfo(
                            file_name=<span class="hljs-string">&#x27;config.json&#x27;</span>,
                            size_on_disk=<span class="hljs-number">1197</span>
                            file_path=PosixPath(...),
                            blob_path=PosixPath(...),
                            blob_last_accessed=<span class="hljs-number">1662971707.3567169</span>,
                            blob_last_modified=<span class="hljs-number">1662971107.3567169</span>,
                        ),
                        CachedFileInfo(...),
                        ...
                    }),
                ),
                CachedRevisionInfo(...),
                ...
            }),
        ),
        CachedRepoInfo(...),
        ...
    }),
    warnings=[
        CorruptedCacheException(<span class="hljs-string">&quot;Snapshots dir doesn&#x27;t exist in cached repo: ...&quot;</span>),
        CorruptedCacheException(...),
        ...
    ],
)`,wrap:!1}}),Re=new U({props:{title:"Cache leeren",local:"cache-leeren",headingTag:"h2"}}),ze=new U({props:{title:"Löschstrategie",local:"löschstrategie",headingTag:"h3"}}),Se=new U({props:{title:"Cache vom Terminal aus leeren",local:"cache-vom-terminal-aus-leeren",headingTag:"h3"}}),Ge=new m({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMHJtJTIwbW9kZWwlMkZiZXJ0LWJhc2UtY2FzZWQlMEFBYm91dCUyMHRvJTIwZGVsZXRlJTIwMSUyMHJlcG8ocyklMjB0b3RhbGxpbmclMjAxLjlHLiUwQSUyMCUyMC0lMjBtb2RlbCUyRmJlcnQtYmFzZS1jYXNlZCUyMChlbnRpcmUlMjByZXBvKSUwQVByb2NlZWQlMjB3aXRoJTIwZGVsZXRpb24lM0YlMjAlNUJ5JTJGTiU1RCUzQSUyMHklMEFEZWxldGVkJTIwMSUyMHJlcG8ocyklMjBhbmQlMjAxJTIwcmV2aXNpb24ocyklM0IlMjBmcmVlZCUyMDEuOUcu",highlighted:`➜ hf cache rm model/bert-base-cased
About to delete 1 repo(s) totalling 1.9G.
  - model/bert-base-cased (entire repo)
Proceed with deletion? [y/N]: y
Deleted 1 repo(s) and 1 revision(s); freed 1.9G.`,wrap:!1}}),Oe=new m({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMHJtJTIwbW9kZWwlMkZ0NS1zbWFsbCUyMDhmM2FkMWMlMjAtLWRyeS1ydW4lMEFBYm91dCUyMHRvJTIwZGVsZXRlJTIwMSUyMHJlcG8ocyklMjBhbmQlMjAxJTIwcmV2aXNpb24ocyklMjB0b3RhbGxpbmclMjAxLjFHLiUwQSUyMCUyMC0lMjBtb2RlbCUyRnQ1LXNtYWxsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwOGYzYWQxYyUyMCU1Qm1haW4lNUQlMjAxLjFHJTBBRHJ5JTIwcnVuJTNBJTIwbm8lMjBmaWxlcyUyMHdlcmUlMjBkZWxldGVkLg==",highlighted:`➜ hf cache rm model/t5-small 8f3ad1c --dry-run
About to delete 1 repo(s) and 1 revision(s) totalling 1.1G.
  - model/t5-small:
      8f3ad1c [main] 1.1G
Dry run: no files were deleted.`,wrap:!1}}),We=new m({props:{code:"JUUyJTlFJTlDJTIwaGYlMjBjYWNoZSUyMHBydW5lJTBBQWJvdXQlMjB0byUyMGRlbGV0ZSUyMDMlMjB1bnJlZmVyZW5jZWQlMjByZXZpc2lvbihzKSUyMCgyLjRHJTIwdG90YWwpLiUwQSUyMCUyMC0lMjBtb2RlbCUyRnQ1LXNtYWxsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwMWM2MTBmNmIlMjAlNUJyZWZzJTJGcHIlMkYxJTVEJTIwODIwLjFNJTBBJTIwJTIwJTIwJTIwJTIwJTIwZDRlYzliNzIlMjAlNUIoZGV0YWNoZWQpJTVEJTIwNjQwLjVNJTBBJTIwJTIwLSUyMGRhdGFzZXQlMkZnb29nbGUlMkZmbGV1cnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAyYjkxYzhkZCUyMCU1QihkZXRhY2hlZCklNUQlMjA5MzcuNk0lMEFQcm9jZWVkJTNGJTIwJTVCeSUyRk4lNUQlM0ElMjB5JTBBRGVsZXRlZCUyMDMlMjB1bnJlZmVyZW5jZWQlMjByZXZpc2lvbihzKSUzQiUyMGZyZWVkJTIwMi40Ry4=",highlighted:`➜ hf cache prune
About to delete 3 unreferenced revision(s) (2.4G total).
  - model/t5-small:
      1c610f6b [refs/pr/1] 820.1M
      d4ec9b72 [(detached)] 640.5M
  - dataset/google/fleurs:
      2b91c8dd [(detached)] 937.6M
Proceed? [y/N]: y
Deleted 3 unreferenced revision(s); freed 2.4G.`,wrap:!1}}),Ee=new U({props:{title:"Cache aus Python leeren",local:"cache-aus-python-leeren",headingTag:"h3"}}),_e=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBZGVsZXRlX3N0cmF0ZWd5JTIwJTNEJTIwc2Nhbl9jYWNoZV9kaXIoKS5kZWxldGVfcmV2aXNpb25zKCUwQSUyMCUyMCUyMCUyMCUyMjgxZmQxZDZlNzg0N2M5OWY1ODYyYzlmYjgxMzg3OTU2ZDk5ZWM3YWElMjIlMEElMjAlMjAlMjAlMjAlMjJlMjk4M2IyMzdkY2NmM2FiNDkzN2M5N2ZhNzE3MzE5YTljYTFhOTZkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyNmMwZTYwODA5NTNkYjU2Mzc1NzYwYzA0NzFhOGM1ZjI5MjliYWYxMSUyMiUyQyUwQSklMEFwcmludCglMjJXaWxsJTIwZnJlZSUyMCUyMiUyMCUyQiUyMGRlbGV0ZV9zdHJhdGVneS5leHBlY3RlZF9mcmVlZF9zaXplX3N0ciklMEElMEFkZWxldGVfc3RyYXRlZ3kuZXhlY3V0ZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy = scan_cache_dir().delete_revisions(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;81fd1d6e7847c99f5862c9fb81387956d99ec7aa&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;e2983b237dccf3ab4937c97fa717319a9ca1a96d&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Will free &quot;</span> + delete_strategy.expected_freed_size_str)
Will free <span class="hljs-number">8.6</span>G

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy.execute()
Cache deletion done. Saved <span class="hljs-number">8.6</span>G.`,wrap:!1}}),Ve=new Bn({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/de/guides/manage-cache.md"}}),{c(){p=a("meta"),qe=s(),He=a("p"),Ke=s(),r(y.$$.fragment),el=s(),r(u.$$.fragment),ll=s(),r(f.$$.fragment),tl=s(),C=a("p"),C.textContent=Nt,nl=s(),b=a("p"),b.textContent=Dt,sl=s(),r(A.$$.fragment),il=s(),g=a("p"),g.innerHTML=Zt,al=s(),k=a("p"),k.textContent=St,Ml=s(),r($.$$.fragment),Tl=s(),R=a("p"),R.textContent=Bt,rl=s(),v=a("p"),v.textContent=Gt,Jl=s(),r(z.$$.fragment),dl=s(),N=a("p"),N.textContent=Lt,cl=s(),r(D.$$.fragment),wl=s(),Z=a("p"),Z.innerHTML=Ot,hl=s(),S=a("p"),S.innerHTML=Qt,Ul=s(),B=a("p"),B.innerHTML=Ft,ml=s(),r(G.$$.fragment),pl=s(),L=a("p"),L.innerHTML=Wt,Il=s(),r(O.$$.fragment),jl=s(),Q=a("p"),Q.innerHTML=Yt,ol=s(),F=a("p"),F.innerHTML=Et,yl=s(),W=a("p"),W.innerHTML=xt,ul=s(),r(Y.$$.fragment),fl=s(),E=a("p"),E.innerHTML=_t,Cl=s(),x=a("p"),x.innerHTML=Vt,bl=s(),r(_.$$.fragment),Al=s(),V=a("p"),V.innerHTML=Ht,gl=s(),r(H.$$.fragment),kl=s(),X=a("p"),X.innerHTML=Xt,$l=s(),P=a("p"),P.innerHTML=Pt,Rl=s(),q=a("p"),q.innerHTML=qt,vl=s(),r(K.$$.fragment),zl=s(),r(ee.$$.fragment),Nl=s(),le=a("p"),le.textContent=Kt,Dl=s(),r(te.$$.fragment),Zl=s(),r(ne.$$.fragment),Sl=s(),se=a("p"),se.innerHTML=en,Bl=s(),ie=a("p"),ie.innerHTML=ln,Gl=s(),ae=a("p"),ae.innerHTML=tn,Ll=s(),r(Me.$$.fragment),Ol=s(),Te=a("p"),Te.innerHTML=nn,Ql=s(),r(re.$$.fragment),Fl=s(),I=a("blockquote"),I.innerHTML=sn,Wl=s(),r(Je.$$.fragment),Yl=s(),de=a("p"),de.textContent=an,El=s(),r(ce.$$.fragment),xl=s(),r(we.$$.fragment),_l=s(),he=a("p"),he.innerHTML=Mn,Vl=s(),r(Ue.$$.fragment),Hl=s(),me=a("p"),me.innerHTML=Tn,Xl=s(),r(pe.$$.fragment),Pl=s(),Ie=a("p"),Ie.innerHTML=rn,ql=s(),r(je.$$.fragment),Kl=s(),oe=a("p"),oe.innerHTML=Jn,et=s(),r(ye.$$.fragment),lt=s(),ue=a("p"),ue.innerHTML=dn,tt=s(),r(fe.$$.fragment),nt=s(),r(Ce.$$.fragment),st=s(),be=a("p"),be.innerHTML=cn,it=s(),Ae=a("p"),Ae.textContent=wn,at=s(),ge=a("ul"),ge.innerHTML=hn,Mt=s(),ke=a("p"),ke.textContent=Un,Tt=s(),r($e.$$.fragment),rt=s(),r(Re.$$.fragment),Jt=s(),ve=a("p"),ve.innerHTML=mn,dt=s(),r(ze.$$.fragment),ct=s(),Ne=a("p"),Ne.innerHTML=pn,wt=s(),De=a("p"),De.textContent=In,ht=s(),Ze=a("ul"),Ze.innerHTML=jn,Ut=s(),j=a("blockquote"),j.innerHTML=on,mt=s(),o=a("blockquote"),o.innerHTML=yn,pt=s(),r(Se.$$.fragment),It=s(),Be=a("p"),Be.innerHTML=un,jt=s(),r(Ge.$$.fragment),ot=s(),Le=a("p"),Le.innerHTML=fn,yt=s(),r(Oe.$$.fragment),ut=s(),Qe=a("p"),Qe.innerHTML=Cn,ft=s(),Fe=a("p"),Fe.innerHTML=bn,Ct=s(),r(We.$$.fragment),bt=s(),Ye=a("p"),Ye.innerHTML=An,At=s(),r(Ee.$$.fragment),gt=s(),xe=a("p"),xe.innerHTML=gn,kt=s(),r(_e.$$.fragment),$t=s(),r(Ve.$$.fragment),Rt=s(),Xe=a("p"),this.h()},l(e){const l=Dn("svelte-u9bgzb",document.head);p=M(l,"META",{name:!0,content:!0}),l.forEach(t),qe=i(e),He=M(e,"P",{}),kn(He).forEach(t),Ke=i(e),J(y.$$.fragment,e),el=i(e),J(u.$$.fragment,e),ll=i(e),J(f.$$.fragment,e),tl=i(e),C=M(e,"P",{"data-svelte-h":!0}),T(C)!=="svelte-61rybt"&&(C.textContent=Nt),nl=i(e),b=M(e,"P",{"data-svelte-h":!0}),T(b)!=="svelte-pr21fp"&&(b.textContent=Dt),sl=i(e),J(A.$$.fragment,e),il=i(e),g=M(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-kafc54"&&(g.innerHTML=Zt),al=i(e),k=M(e,"P",{"data-svelte-h":!0}),T(k)!=="svelte-2zg9up"&&(k.textContent=St),Ml=i(e),J($.$$.fragment,e),Tl=i(e),R=M(e,"P",{"data-svelte-h":!0}),T(R)!=="svelte-br50js"&&(R.textContent=Bt),rl=i(e),v=M(e,"P",{"data-svelte-h":!0}),T(v)!=="svelte-9n877q"&&(v.textContent=Gt),Jl=i(e),J(z.$$.fragment,e),dl=i(e),N=M(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-1dmpcjk"&&(N.textContent=Lt),cl=i(e),J(D.$$.fragment,e),wl=i(e),Z=M(e,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-14k8h2t"&&(Z.innerHTML=Ot),hl=i(e),S=M(e,"P",{"data-svelte-h":!0}),T(S)!=="svelte-1n0msig"&&(S.innerHTML=Qt),Ul=i(e),B=M(e,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1f9smln"&&(B.innerHTML=Ft),ml=i(e),J(G.$$.fragment,e),pl=i(e),L=M(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-1eldkes"&&(L.innerHTML=Wt),Il=i(e),J(O.$$.fragment,e),jl=i(e),Q=M(e,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-o3uzfk"&&(Q.innerHTML=Yt),ol=i(e),F=M(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-1mgfwmw"&&(F.innerHTML=Et),yl=i(e),W=M(e,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1vu57r6"&&(W.innerHTML=xt),ul=i(e),J(Y.$$.fragment,e),fl=i(e),E=M(e,"P",{"data-svelte-h":!0}),T(E)!=="svelte-gqcyer"&&(E.innerHTML=_t),Cl=i(e),x=M(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-1yxwzcf"&&(x.innerHTML=Vt),bl=i(e),J(_.$$.fragment,e),Al=i(e),V=M(e,"P",{"data-svelte-h":!0}),T(V)!=="svelte-2u9061"&&(V.innerHTML=Ht),gl=i(e),J(H.$$.fragment,e),kl=i(e),X=M(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-1j1bmx5"&&(X.innerHTML=Xt),$l=i(e),P=M(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-1a83sun"&&(P.innerHTML=Pt),Rl=i(e),q=M(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-e89t87"&&(q.innerHTML=qt),vl=i(e),J(K.$$.fragment,e),zl=i(e),J(ee.$$.fragment,e),Nl=i(e),le=M(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-1no2ew1"&&(le.textContent=Kt),Dl=i(e),J(te.$$.fragment,e),Zl=i(e),J(ne.$$.fragment,e),Sl=i(e),se=M(e,"P",{"data-svelte-h":!0}),T(se)!=="svelte-ua6zs5"&&(se.innerHTML=en),Bl=i(e),ie=M(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-ld2pcs"&&(ie.innerHTML=ln),Gl=i(e),ae=M(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-pd3h3o"&&(ae.innerHTML=tn),Ll=i(e),J(Me.$$.fragment,e),Ol=i(e),Te=M(e,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-1jhuhng"&&(Te.innerHTML=nn),Ql=i(e),J(re.$$.fragment,e),Fl=i(e),I=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(I)!=="svelte-jvz4yn"&&(I.innerHTML=sn),Wl=i(e),J(Je.$$.fragment,e),Yl=i(e),de=M(e,"P",{"data-svelte-h":!0}),T(de)!=="svelte-1h2jt3o"&&(de.textContent=an),El=i(e),J(ce.$$.fragment,e),xl=i(e),J(we.$$.fragment,e),_l=i(e),he=M(e,"P",{"data-svelte-h":!0}),T(he)!=="svelte-pixup6"&&(he.innerHTML=Mn),Vl=i(e),J(Ue.$$.fragment,e),Hl=i(e),me=M(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-53xd1z"&&(me.innerHTML=Tn),Xl=i(e),J(pe.$$.fragment,e),Pl=i(e),Ie=M(e,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-jrfzsj"&&(Ie.innerHTML=rn),ql=i(e),J(je.$$.fragment,e),Kl=i(e),oe=M(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-1xpwj2d"&&(oe.innerHTML=Jn),et=i(e),J(ye.$$.fragment,e),lt=i(e),ue=M(e,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-1m36dwq"&&(ue.innerHTML=dn),tt=i(e),J(fe.$$.fragment,e),nt=i(e),J(Ce.$$.fragment,e),st=i(e),be=M(e,"P",{"data-svelte-h":!0}),T(be)!=="svelte-olmzw"&&(be.innerHTML=cn),it=i(e),Ae=M(e,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-norace"&&(Ae.textContent=wn),at=i(e),ge=M(e,"UL",{"data-svelte-h":!0}),T(ge)!=="svelte-1b698eq"&&(ge.innerHTML=hn),Mt=i(e),ke=M(e,"P",{"data-svelte-h":!0}),T(ke)!=="svelte-m9a3yy"&&(ke.textContent=Un),Tt=i(e),J($e.$$.fragment,e),rt=i(e),J(Re.$$.fragment,e),Jt=i(e),ve=M(e,"P",{"data-svelte-h":!0}),T(ve)!=="svelte-mxt064"&&(ve.innerHTML=mn),dt=i(e),J(ze.$$.fragment,e),ct=i(e),Ne=M(e,"P",{"data-svelte-h":!0}),T(Ne)!=="svelte-1miwjrk"&&(Ne.innerHTML=pn),wt=i(e),De=M(e,"P",{"data-svelte-h":!0}),T(De)!=="svelte-15wrf8w"&&(De.textContent=In),ht=i(e),Ze=M(e,"UL",{"data-svelte-h":!0}),T(Ze)!=="svelte-104cibx"&&(Ze.innerHTML=jn),Ut=i(e),j=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(j)!=="svelte-1m3k9li"&&(j.innerHTML=on),mt=i(e),o=M(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),T(o)!=="svelte-hyufwr"&&(o.innerHTML=yn),pt=i(e),J(Se.$$.fragment,e),It=i(e),Be=M(e,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-1chcdyg"&&(Be.innerHTML=un),jt=i(e),J(Ge.$$.fragment,e),ot=i(e),Le=M(e,"P",{"data-svelte-h":!0}),T(Le)!=="svelte-1lhe2ci"&&(Le.innerHTML=fn),yt=i(e),J(Oe.$$.fragment,e),ut=i(e),Qe=M(e,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-g0dwrw"&&(Qe.innerHTML=Cn),ft=i(e),Fe=M(e,"P",{"data-svelte-h":!0}),T(Fe)!=="svelte-1ch4bz2"&&(Fe.innerHTML=bn),Ct=i(e),J(We.$$.fragment,e),bt=i(e),Ye=M(e,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-1l1rpwx"&&(Ye.innerHTML=An),At=i(e),J(Ee.$$.fragment,e),gt=i(e),xe=M(e,"P",{"data-svelte-h":!0}),T(xe)!=="svelte-1bifrgv"&&(xe.innerHTML=gn),kt=i(e),J(_e.$$.fragment,e),$t=i(e),J(Ve.$$.fragment,e),Rt=i(e),Xe=M(e,"P",{}),kn(Xe).forEach(t),this.h()},h(){Pe(p,"name","hf:doc:metadata"),Pe(p,"content",Ln),Pe(I,"class","tip"),Pe(j,"class","tip"),Pe(o,"class","warning")},m(e,l){Zn(document.head,p),n(e,qe,l),n(e,He,l),n(e,Ke,l),d(y,e,l),n(e,el,l),d(u,e,l),n(e,ll,l),d(f,e,l),n(e,tl,l),n(e,C,l),n(e,nl,l),n(e,b,l),n(e,sl,l),d(A,e,l),n(e,il,l),n(e,g,l),n(e,al,l),n(e,k,l),n(e,Ml,l),d($,e,l),n(e,Tl,l),n(e,R,l),n(e,rl,l),n(e,v,l),n(e,Jl,l),d(z,e,l),n(e,dl,l),n(e,N,l),n(e,cl,l),d(D,e,l),n(e,wl,l),n(e,Z,l),n(e,hl,l),n(e,S,l),n(e,Ul,l),n(e,B,l),n(e,ml,l),d(G,e,l),n(e,pl,l),n(e,L,l),n(e,Il,l),d(O,e,l),n(e,jl,l),n(e,Q,l),n(e,ol,l),n(e,F,l),n(e,yl,l),n(e,W,l),n(e,ul,l),d(Y,e,l),n(e,fl,l),n(e,E,l),n(e,Cl,l),n(e,x,l),n(e,bl,l),d(_,e,l),n(e,Al,l),n(e,V,l),n(e,gl,l),d(H,e,l),n(e,kl,l),n(e,X,l),n(e,$l,l),n(e,P,l),n(e,Rl,l),n(e,q,l),n(e,vl,l),d(K,e,l),n(e,zl,l),d(ee,e,l),n(e,Nl,l),n(e,le,l),n(e,Dl,l),d(te,e,l),n(e,Zl,l),d(ne,e,l),n(e,Sl,l),n(e,se,l),n(e,Bl,l),n(e,ie,l),n(e,Gl,l),n(e,ae,l),n(e,Ll,l),d(Me,e,l),n(e,Ol,l),n(e,Te,l),n(e,Ql,l),d(re,e,l),n(e,Fl,l),n(e,I,l),n(e,Wl,l),d(Je,e,l),n(e,Yl,l),n(e,de,l),n(e,El,l),d(ce,e,l),n(e,xl,l),d(we,e,l),n(e,_l,l),n(e,he,l),n(e,Vl,l),d(Ue,e,l),n(e,Hl,l),n(e,me,l),n(e,Xl,l),d(pe,e,l),n(e,Pl,l),n(e,Ie,l),n(e,ql,l),d(je,e,l),n(e,Kl,l),n(e,oe,l),n(e,et,l),d(ye,e,l),n(e,lt,l),n(e,ue,l),n(e,tt,l),d(fe,e,l),n(e,nt,l),d(Ce,e,l),n(e,st,l),n(e,be,l),n(e,it,l),n(e,Ae,l),n(e,at,l),n(e,ge,l),n(e,Mt,l),n(e,ke,l),n(e,Tt,l),d($e,e,l),n(e,rt,l),d(Re,e,l),n(e,Jt,l),n(e,ve,l),n(e,dt,l),d(ze,e,l),n(e,ct,l),n(e,Ne,l),n(e,wt,l),n(e,De,l),n(e,ht,l),n(e,Ze,l),n(e,Ut,l),n(e,j,l),n(e,mt,l),n(e,o,l),n(e,pt,l),d(Se,e,l),n(e,It,l),n(e,Be,l),n(e,jt,l),d(Ge,e,l),n(e,ot,l),n(e,Le,l),n(e,yt,l),d(Oe,e,l),n(e,ut,l),n(e,Qe,l),n(e,ft,l),n(e,Fe,l),n(e,Ct,l),d(We,e,l),n(e,bt,l),n(e,Ye,l),n(e,At,l),d(Ee,e,l),n(e,gt,l),n(e,xe,l),n(e,kt,l),d(_e,e,l),n(e,$t,l),d(Ve,e,l),n(e,Rt,l),n(e,Xe,l),vt=!0},p:Rn,i(e){vt||(c(y.$$.fragment,e),c(u.$$.fragment,e),c(f.$$.fragment,e),c(A.$$.fragment,e),c($.$$.fragment,e),c(z.$$.fragment,e),c(D.$$.fragment,e),c(G.$$.fragment,e),c(O.$$.fragment,e),c(Y.$$.fragment,e),c(_.$$.fragment,e),c(H.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(Me.$$.fragment,e),c(re.$$.fragment,e),c(Je.$$.fragment,e),c(ce.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(pe.$$.fragment,e),c(je.$$.fragment,e),c(ye.$$.fragment,e),c(fe.$$.fragment,e),c(Ce.$$.fragment,e),c($e.$$.fragment,e),c(Re.$$.fragment,e),c(ze.$$.fragment,e),c(Se.$$.fragment,e),c(Ge.$$.fragment,e),c(Oe.$$.fragment,e),c(We.$$.fragment,e),c(Ee.$$.fragment,e),c(_e.$$.fragment,e),c(Ve.$$.fragment,e),vt=!0)},o(e){w(y.$$.fragment,e),w(u.$$.fragment,e),w(f.$$.fragment,e),w(A.$$.fragment,e),w($.$$.fragment,e),w(z.$$.fragment,e),w(D.$$.fragment,e),w(G.$$.fragment,e),w(O.$$.fragment,e),w(Y.$$.fragment,e),w(_.$$.fragment,e),w(H.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ne.$$.fragment,e),w(Me.$$.fragment,e),w(re.$$.fragment,e),w(Je.$$.fragment,e),w(ce.$$.fragment,e),w(we.$$.fragment,e),w(Ue.$$.fragment,e),w(pe.$$.fragment,e),w(je.$$.fragment,e),w(ye.$$.fragment,e),w(fe.$$.fragment,e),w(Ce.$$.fragment,e),w($e.$$.fragment,e),w(Re.$$.fragment,e),w(ze.$$.fragment,e),w(Se.$$.fragment,e),w(Ge.$$.fragment,e),w(Oe.$$.fragment,e),w(We.$$.fragment,e),w(Ee.$$.fragment,e),w(_e.$$.fragment,e),w(Ve.$$.fragment,e),vt=!1},d(e){e&&(t(qe),t(He),t(Ke),t(el),t(ll),t(tl),t(C),t(nl),t(b),t(sl),t(il),t(g),t(al),t(k),t(Ml),t(Tl),t(R),t(rl),t(v),t(Jl),t(dl),t(N),t(cl),t(wl),t(Z),t(hl),t(S),t(Ul),t(B),t(ml),t(pl),t(L),t(Il),t(jl),t(Q),t(ol),t(F),t(yl),t(W),t(ul),t(fl),t(E),t(Cl),t(x),t(bl),t(Al),t(V),t(gl),t(kl),t(X),t($l),t(P),t(Rl),t(q),t(vl),t(zl),t(Nl),t(le),t(Dl),t(Zl),t(Sl),t(se),t(Bl),t(ie),t(Gl),t(ae),t(Ll),t(Ol),t(Te),t(Ql),t(Fl),t(I),t(Wl),t(Yl),t(de),t(El),t(xl),t(_l),t(he),t(Vl),t(Hl),t(me),t(Xl),t(Pl),t(Ie),t(ql),t(Kl),t(oe),t(et),t(lt),t(ue),t(tt),t(nt),t(st),t(be),t(it),t(Ae),t(at),t(ge),t(Mt),t(ke),t(Tt),t(rt),t(Jt),t(ve),t(dt),t(ct),t(Ne),t(wt),t(De),t(ht),t(Ze),t(Ut),t(j),t(mt),t(o),t(pt),t(It),t(Be),t(jt),t(ot),t(Le),t(yt),t(ut),t(Qe),t(ft),t(Fe),t(Ct),t(bt),t(Ye),t(At),t(gt),t(xe),t(kt),t($t),t(Rt),t(Xe)),t(p),h(y,e),h(u,e),h(f,e),h(A,e),h($,e),h(z,e),h(D,e),h(G,e),h(O,e),h(Y,e),h(_,e),h(H,e),h(K,e),h(ee,e),h(te,e),h(ne,e),h(Me,e),h(re,e),h(Je,e),h(ce,e),h(we,e),h(Ue,e),h(pe,e),h(je,e),h(ye,e),h(fe,e),h(Ce,e),h($e,e),h(Re,e),h(ze,e),h(Se,e),h(Ge,e),h(Oe,e),h(We,e),h(Ee,e),h(_e,e),h(Ve,e)}}}const Ln='{"title":"Verwalten des huggingface_hub Cache-Systems","local":"verwalten-des-huggingfacehub-cache-systems","sections":[{"title":"Caching verstehen","local":"caching-verstehen","sections":[{"title":"Refs","local":"refs","sections":[],"depth":3},{"title":"Blobs","local":"blobs","sections":[],"depth":3},{"title":"Snapshots","local":"snapshots","sections":[],"depth":3},{"title":".no_exist (fortgeschritten)","local":"noexist-fortgeschritten","sections":[],"depth":3},{"title":"In der Praxis","local":"in-der-praxis","sections":[],"depth":3},{"title":"Einschränkungen","local":"einschränkungen","sections":[],"depth":3}],"depth":2},{"title":"Assets zwischenspeichern","local":"assets-zwischenspeichern","sections":[{"title":"Assets in der Praxis","local":"assets-in-der-praxis","sections":[],"depth":3}],"depth":2},{"title":"Cache scannen","local":"cache-scannen","sections":[{"title":"Cache im Terminal prüfen","local":"cache-im-terminal-prüfen","sections":[{"title":"Mit Shell-Tools filtern","local":"mit-shell-tools-filtern","sections":[],"depth":4}],"depth":3},{"title":"Den Cache von Python aus scannen","local":"den-cache-von-python-aus-scannen","sections":[],"depth":3}],"depth":2},{"title":"Cache leeren","local":"cache-leeren","sections":[{"title":"Löschstrategie","local":"löschstrategie","sections":[],"depth":3},{"title":"Cache vom Terminal aus leeren","local":"cache-vom-terminal-aus-leeren","sections":[],"depth":3},{"title":"Cache aus Python leeren","local":"cache-aus-python-leeren","sections":[],"depth":3}],"depth":2}],"depth":1}';function On(zt){return vn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class En extends zn{constructor(p){super(),Nn(this,p,On,Gn,$n,{})}}export{En as component};
