import{s as Et,n as Bt,o as Ht}from"../chunks/scheduler.0cf4ef2e.js";import{S as Lt,i as qt,e as i,s as a,c as o,h as Gt,a as p,d as t,b as l,f as Zt,g as r,j as c,k as Je,l as At,m as s,n as g,t as u,o as h,p as f}from"../chunks/index.abc433bf.js";import{C as Yt}from"../chunks/CopyLLMTxtMenu.efc6b005.js";import{C as d}from"../chunks/CodeBlock.00dcd05e.js";import{H as m,E as Qt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.86d448e2.js";function Xt(Kn){let j,Ee,ve,Be,w,He,U,Le,$,On=`Inference Endpoints provides a secure production solution to easily deploy any <code>transformers</code>, <code>sentence-transformers</code>, and <code>diffusers</code> models on a dedicated and autoscaling infrastructure managed by Hugging Face. An Inference Endpoint is built from a model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a>.
In this guide, we will learn how to programmatically manage Inference Endpoints with <code>huggingface_hub</code>. For more information about the Inference Endpoints product itself, check out its <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">official documentation</a>.`,qe,x,Dn='This guide assumes <code>huggingface_hub</code> is correctly installed and that your machine is logged in. Check out the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#quickstart" rel="nofollow">Quick Start guide</a> if that’s not the case yet. The minimal version supporting Inference Endpoints API is <code>v0.19.0</code>.',Ge,M,et='<p><strong>New:</strong> it is now possible to deploy an Inference Endpoint from the <a href="https://endpoints.huggingface.co/catalog" rel="nofollow">HF model catalog</a> with a simple API call. The catalog is a carefully curated list of models that can be deployed with optimized settings. You don’t need to configure anything, we take all the heavy stuff on us! All models and settings are guaranteed to have been tested to provide best cost/performance balance.  <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint_from_catalog">create_inference_endpoint_from_catalog()</a> works the same as <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>, with much less parameters to pass. You can use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_catalog">list_inference_catalog()</a> to programmatically retrieve the catalog.</p> <p>Note that this is still an experimental feature. Let us know what you think if you use it!</p>',Ae,I,Ye,T,nt='The first step is to create an Inference Endpoint using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>:',Qe,C,Xe,k,tt="Or via CLI:",Ve,W,Re,J,st='In this example, we created a <code>protected</code> Inference Endpoint named <code>&quot;my-endpoint-name&quot;</code>, to serve <a href="https://huggingface.co/gpt2" rel="nofollow">gpt2</a> for <code>text-generation</code>. A <code>protected</code> Inference Endpoint means your token is required to access the API. We also need to provide additional information to configure the hardware requirements, such as vendor, region, accelerator, instance type, and size. You can check out the list of available resources <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aprovider/list_vendors" rel="nofollow">here</a>. Alternatively, you can create an Inference Endpoint manually using the <a href="https://ui.endpoints.huggingface.co/new" rel="nofollow">Web interface</a> for convenience. Refer to this <a href="https://huggingface.co/docs/inference-endpoints/guides/advanced" rel="nofollow">guide</a> for details on advanced settings and their usage.',ze,v,at='The value returned by <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a> is an <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object:',Ne,Z,Se,E,lt="Or via CLI:",Fe,B,Pe,H,it="It’s a dataclass that holds information about the endpoint. You can access important attributes such as <code>name</code>, <code>repository</code>, <code>status</code>, <code>task</code>, <code>created_at</code>, <code>updated_at</code>, etc. If you need it, you can also access the raw response from the server with <code>endpoint.raw</code>.",Ke,L,pt='Once your Inference Endpoint is created, you can find it on your <a href="https://ui.endpoints.huggingface.co/" rel="nofollow">personal dashboard</a>.',Oe,q,ct='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/inference_endpoints_created.png"/>',De,G,en,A,ot='By default the Inference Endpoint is built from a docker image provided by Hugging Face. However, it is possible to specify any docker image using the <code>custom_image</code> parameter. A common use case is to run LLMs using the <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text-generation-inference</a> framework. This can be done like this:',nn,Y,tn,Q,rt='The value to pass as <code>custom_image</code> is a dictionary containing a url to the docker container and configuration to run it. For more details about it, checkout the <a href="https://api.endpoints.huggingface.cloud/#/v2%3A%3Aendpoint/create_endpoint" rel="nofollow">Swagger documentation</a>.',sn,X,an,V,gt='In some cases, you might need to manage Inference Endpoints you created previously. If you know the name, you can fetch it using <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a>, which returns an <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object. Alternatively, you can use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a> to retrieve a list of all Inference Endpoints. Both methods accept an optional <code>namespace</code> parameter. You can set the <code>namespace</code> to any organization you are a part of. Otherwise, it defaults to your username.',ln,R,pn,z,ut="Or via CLI:",cn,N,on,S,rn,F,ht='In the rest of this guide, we will assume that we have a <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> object called <code>endpoint</code>. You might have noticed that the endpoint has a <code>status</code> attribute of type <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a>. When the Inference Endpoint is deployed and accessible, the status should be <code>&quot;running&quot;</code> and the <code>url</code> attribute is set:',gn,P,un,K,ft='Before reaching a <code>&quot;running&quot;</code> state, the Inference Endpoint typically goes through an <code>&quot;initializing&quot;</code> or <code>&quot;pending&quot;</code> phase. You can fetch the new state of the endpoint by running <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.fetch">fetch()</a>. Like every other method from <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> that makes a request to the server, the internal attributes of <code>endpoint</code> are mutated in place:',hn,O,fn,D,dt="Or via CLI:",dn,ee,mn,ne,mt='Instead of fetching the Inference Endpoint status while waiting for it to run, you can directly call <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.wait">wait()</a>. This helper takes as input a <code>timeout</code> and a <code>fetch_every</code> parameter (in seconds) and will block the thread until the Inference Endpoint is deployed. Default values are respectively <code>None</code> (no timeout) and <code>5</code> seconds.',jn,te,Mn,se,jt="If <code>timeout</code> is set and the Inference Endpoint takes too much time to load, a <code>InferenceEndpointTimeoutError</code> timeout error is raised.",yn,ae,bn,le,Mt="Once your Inference Endpoint is up and running, you can finally run inference on it!",_n,ie,yt='<a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> has two properties <code>client</code> and <code>async_client</code> returning respectively an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> and an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> objects.',wn,pe,Un,ce,bt='If the Inference Endpoint is not running, an <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError">InferenceEndpointError</a> exception is raised:',$n,oe,xn,re,_t='For more details about how to use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>, check out the <a href="../guides/inference">Inference guide</a>.',In,ge,Tn,ue,wt="Now that we saw how to create an Inference Endpoint and run inference on it, let’s see how to manage its lifecycle.",Cn,y,Ut='<p>In this section, we will see methods like <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a> and <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.delete">delete()</a>. All of those methods are aliases added to <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> for convenience. If you prefer, you can also use the generic methods defined in <code>HfApi</code>: <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a>, <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a>, and <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a>.</p>',kn,he,Wn,fe,$t='To reduce costs when your Inference Endpoint is not in use, you can choose to either pause it using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">pause()</a> or scale it to zero using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">scale_to_zero()</a>.',Jn,b,xt='<p>An Inference Endpoint that is <em>paused</em> or <em>scaled to zero</em> doesn’t cost anything. The difference between those two is that a <em>paused</em> endpoint needs to be explicitly <em>resumed</em> using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">resume()</a>. On the contrary, a <em>scaled to zero</em> endpoint will automatically start if an inference call is made to it, with an additional cold start delay. An Inference Endpoint can also be configured to scale to zero automatically after a certain period of inactivity.</p>',vn,de,Zn,me,It="Or via CLI:",En,je,Bn,Me,Hn,ye,Tt='In some cases, you might also want to update your Inference Endpoint without creating a new one. You can either update the hosted model or the hardware requirements to run the model. You can do this using <a href="/docs/huggingface_hub/main/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.update">update()</a>:',Ln,be,qn,_e,Ct="Or via CLI:",Gn,we,An,Ue,Yn,$e,kt="Finally if you won’t use the Inference Endpoint anymore, you can simply call <code>~InferenceEndpoint.delete()</code>.",Qn,_,Wt="<p>This is a non-revertible action that will completely remove the endpoint, including its configuration, logs and usage metrics. You cannot restore a deleted Inference Endpoint.</p>",Xn,xe,Vn,Ie,Jt="A typical use case of Inference Endpoints is to process a batch of jobs at once to limit the infrastructure costs. You can automate this process using what we saw in this guide:",Rn,Te,zn,Ce,vt="Or if your Inference Endpoint already exists and is paused:",Nn,ke,Sn,We,Fn,Ze,Pn;return w=new Yt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new m({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),I=new m({props:{title:"Create an Inference Endpoint",local:"create-an-inference-endpoint",headingTag:"h2"}}),C=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEElMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIybXktZW5kcG9pbnQtbmFtZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9zaXRvcnklM0QlMjJncHQyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDIlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIyaW50ZWwtaWNsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;my-endpoint-name&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;gpt2&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;cpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x2&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),W=new d({props:{code:"aGYlMjBlbmRwb2ludHMlMjBkZXBsb3klMjBteS1lbmRwb2ludC1uYW1lJTIwLS1yZXBvJTIwZ3B0MiUyMC0tZnJhbWV3b3JrJTIwcHl0b3JjaCUyMC0tYWNjZWxlcmF0b3IlMjBjcHUlMjAtLXZlbmRvciUyMGF3cyUyMC0tcmVnaW9uJTIwdXMtZWFzdC0xJTIwLS1pbnN0YW5jZS1zaXplJTIweDIlMjAtLWluc3RhbmNlLXR5cGUlMjBpbnRlbC1pY2wlMjAtLXRhc2slMjB0ZXh0LWdlbmVyYXRpb24lMEElMEElMjMlMjBEZXBsb3klMjBmcm9tJTIwdGhlJTIwY2F0YWxvZyUyMHdpdGglMjBhJTIwc2luZ2xlJTIwY29tbWFuZCUwQWhmJTIwZW5kcG9pbnRzJTIwY2F0YWxvZyUyMGRlcGxveSUyMG15LWVuZHBvaW50LW5hbWUlMjAtLXJlcG8lMjBvcGVuYWklMkZncHQtb3NzLTEyMGI=",highlighted:`hf endpoints deploy my-endpoint-name --repo gpt2 --framework pytorch --accelerator cpu --vendor aws --region us-east-1 --instance-size x2 --instance-type intel-icl --task text-generation

<span class="hljs-comment"># Deploy from the catalog with a single command</span>
hf endpoints catalog deploy my-endpoint-name --repo openai/gpt-oss-120b`,wrap:!1}}),Z=new d({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),B=new d({props:{code:"aGYlMjBlbmRwb2ludHMlMjBkZXNjcmliZSUyMG15LWVuZHBvaW50LW5hbWU=",highlighted:"hf endpoints describe my-endpoint-name",wrap:!1}}),G=new m({props:{title:"Using a custom image",local:"using-a-custom-image",headingTag:"h4"}}),Y=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQoJTBBJTIwJTIwJTIwJTIwJTIyYXdzLXplcGh5ci03Yi1iZXRhLTA0ODYlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvc2l0b3J5JTNEJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnJhbWV3b3JrJTNEJTIycHl0b3JjaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUzRCUyMmdwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZlbmRvciUzRCUyMmF3cyUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZ2lvbiUzRCUyMnVzLWVhc3QtMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJwcm90ZWN0ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV9zaXplJTNEJTIyeDElMjIlMkMlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybnZpZGlhLWExMGclMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21faW1hZ2UlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoZWFsdGhfcm91dGUlMjIlM0ElMjAlMjIlMkZoZWFsdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnYlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfQkFUQ0hfUFJFRklMTF9UT0tFTlMlMjIlM0ElMjAlMjIyMDQ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTUFYX0lOUFVUX0xFTkdUSCUyMiUzQSUyMCUyMjEwMjQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNQVhfVE9UQUxfVE9LRU5TJTIyJTNBJTIwJTIyMTUxMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMk1PREVMX0lEJTIyJTNBJTIwJTIyJTJGcmVwb3NpdG9yeSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVybCUyMiUzQSUyMCUyMmdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ExLjEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Start an Inference Endpoint running Zephyr-7b-beta on TGI</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;aws-zephyr-7b-beta-0486&quot;</span>,
<span class="hljs-meta">... </span>    repository=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>,
<span class="hljs-meta">... </span>    framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
<span class="hljs-meta">... </span>    vendor=<span class="hljs-string">&quot;aws&quot;</span>,
<span class="hljs-meta">... </span>    region=<span class="hljs-string">&quot;us-east-1&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
<span class="hljs-meta">... </span>    instance_size=<span class="hljs-string">&quot;x1&quot;</span>,
<span class="hljs-meta">... </span>    instance_type=<span class="hljs-string">&quot;nvidia-a10g&quot;</span>,
<span class="hljs-meta">... </span>    custom_image={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;env&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_BATCH_PREFILL_TOKENS&quot;</span>: <span class="hljs-string">&quot;2048&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_INPUT_LENGTH&quot;</span>: <span class="hljs-string">&quot;1024&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;1512&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-generation-inference:1.1.0&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)`,wrap:!1}}),X=new m({props:{title:"Get or list existing Inference Endpoints",local:"get-or-list-existing-inference-endpoints",headingTag:"h3"}}),R=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMEElMEFnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMm15LWVuZHBvaW50LW5hbWUlMjIpJTBBJTBBbGlzdF9pbmZlcmVuY2VfZW5kcG9pbnRzKG5hbWVzcGFjZSUzRCUyMmh1Z2dpbmdmYWNlJTIyKSUwQSUwQWxpc3RfaW5mZXJlbmNlX2VuZHBvaW50cyhuYW1lc3BhY2UlM0QlMjIqJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint, list_inference_endpoints

<span class="hljs-comment"># Get one</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>get_inference_endpoint(<span class="hljs-string">&quot;my-endpoint-name&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># List all endpoints from an organization</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;huggingface&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]

<span class="hljs-comment"># List all endpoints from all organizations the user belongs to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>list_inference_endpoints(namespace=<span class="hljs-string">&quot;*&quot;</span>)
[InferenceEndpoint(name=<span class="hljs-string">&#x27;aws-starchat-beta&#x27;</span>, namespace=<span class="hljs-string">&#x27;huggingface&#x27;</span>, repository=<span class="hljs-string">&#x27;HuggingFaceH4/starchat-beta&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>), ...]`,wrap:!1}}),N=new d({props:{code:"aGYlMjBlbmRwb2ludHMlMjBkZXNjcmliZSUyMG15LWVuZHBvaW50LW5hbWUlMEFoZiUyMGVuZHBvaW50cyUyMGxzJTIwLS1uYW1lc3BhY2UlMjBodWdnaW5nZmFjZSUwQWhmJTIwZW5kcG9pbnRzJTIwbHMlMjAtLW5hbWVzcGFjZSUyMCcqJw==",highlighted:`hf endpoints describe my-endpoint-name
hf endpoints <span class="hljs-built_in">ls</span> --namespace huggingface
hf endpoints <span class="hljs-built_in">ls</span> --namespace <span class="hljs-string">&#x27;*&#x27;</span>`,wrap:!1}}),S=new m({props:{title:"Check deployment status",local:"check-deployment-status",headingTag:"h2"}}),P=new d({props:{code:"ZW5kcG9pbnQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),O=new d({props:{code:"ZW5kcG9pbnQuZmV0Y2goKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.fetch()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),ee=new d({props:{code:"aGYlMjBlbmRwb2ludHMlMjBkZXNjcmliZSUyMG15LWVuZHBvaW50LW5hbWU=",highlighted:"hf endpoints describe my-endpoint-name",wrap:!1}}),te=new d({props:{code:"ZW5kcG9pbnQlMEElMEFlbmRwb2ludC53YWl0KHRpbWVvdXQlM0QxMCklMEElMEFlbmRwb2ludC53YWl0KCk=",highlighted:`<span class="hljs-comment"># Pending endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Wait 10s =&gt; raises a InferenceEndpointTimeoutError</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait(timeout=<span class="hljs-number">10</span>)
    <span class="hljs-keyword">raise</span> InferenceEndpointTimeoutError(<span class="hljs-string">&quot;Timeout while waiting for Inference Endpoint to be deployed.&quot;</span>)
huggingface_hub._inference_endpoints.InferenceEndpointTimeoutError: Timeout <span class="hljs-keyword">while</span> waiting <span class="hljs-keyword">for</span> Inference Endpoint to be deployed.

<span class="hljs-comment"># Wait more</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;running&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)`,wrap:!1}}),ae=new m({props:{title:"Run inference",local:"run-inference",headingTag:"h2"}}),pe=new d({props:{code:"ZW5kcG9pbnQuY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJJJTIwYW0lMjIpJTBBJTBBYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQudGV4dF9nZW5lcmF0aW9uKCUyMkklMjBhbSUyMik=",highlighted:`<span class="hljs-comment"># Run text_generation task:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)
<span class="hljs-string">&#x27; not a fan of the idea of a &quot;big-budget&quot; movie. I think it\\&#x27;s a&#x27;</span>

<span class="hljs-comment"># Or in an asyncio context:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> endpoint.async_client.text_generation(<span class="hljs-string">&quot;I am&quot;</span>)`,wrap:!1}}),oe=new d({props:{code:"ZW5kcG9pbnQuY2xpZW50",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client\nhuggingface_hub._inference_endpoints.InferenceEndpointError: Cannot create a client <span class="hljs-keyword">for</span> this Inference Endpoint <span class="hljs-keyword">as</span> it <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> yet deployed. Please wait <span class="hljs-keyword">for</span> the Inference Endpoint to be deployed using `endpoint.wait()` <span class="hljs-keyword">and</span> <span class="hljs-keyword">try</span> again.',wrap:!1}}),ge=new m({props:{title:"Manage lifecycle",local:"manage-lifecycle",headingTag:"h2"}}),he=new m({props:{title:"Pause or scale to zero",local:"pause-or-scale-to-zero",headingTag:"h3"}}),de=new d({props:{code:"ZW5kcG9pbnQucGF1c2UoKSUwQWVuZHBvaW50LnJlc3VtZSgpJTBBZW5kcG9pbnQud2FpdCgpLmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUwQSUwQWVuZHBvaW50LnNjYWxlX3RvX3plcm8oKQ==",highlighted:`<span class="hljs-comment"># Pause and resume endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;paused&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait().client.text_generation(...)
...

<span class="hljs-comment"># Scale to zero</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.scale_to_zero()
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2&#x27;</span>, status=<span class="hljs-string">&#x27;scaledToZero&#x27;</span>, url=<span class="hljs-string">&#x27;https://jpj7k2q4j805b727.us-east-1.aws.endpoints.huggingface.cloud&#x27;</span>)
<span class="hljs-comment"># Endpoint is not &#x27;running&#x27; but still has a URL and will restart on first call.</span>`,wrap:!1}}),je=new d({props:{code:"aGYlMjBlbmRwb2ludHMlMjBwYXVzZSUyMG15LWVuZHBvaW50LW5hbWUlMEFoZiUyMGVuZHBvaW50cyUyMHJlc3VtZSUyMG15LWVuZHBvaW50LW5hbWUlMEFoZiUyMGVuZHBvaW50cyUyMHNjYWxlLXRvLXplcm8lMjBteS1lbmRwb2ludC1uYW1l",highlighted:`hf endpoints pause my-endpoint-name
hf endpoints resume my-endpoint-name
hf endpoints scale-to-zero my-endpoint-name`,wrap:!1}}),Me=new m({props:{title:"Update model or hardware requirements",local:"update-model-or-hardware-requirements",headingTag:"h3"}}),be=new d({props:{code:"ZW5kcG9pbnQudXBkYXRlKHJlcG9zaXRvcnklM0QlMjJncHQyLWxhcmdlJTIyKSUwQSUwQWVuZHBvaW50LnVwZGF0ZShtaW5fcmVwbGljYSUzRDIlMkMlMjBtYXhfcmVwbGljYSUzRDYpJTBBJTBBZW5kcG9pbnQudXBkYXRlKGFjY2VsZXJhdG9yJTNEJTIyY3B1JTIyJTJDJTIwaW5zdGFuY2Vfc2l6ZSUzRCUyMng0JTIyJTJDJTIwaW5zdGFuY2VfdHlwZSUzRCUyMmludGVsLWljbCUyMik=",highlighted:`<span class="hljs-comment"># Change target model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(repository=<span class="hljs-string">&quot;gpt2-large&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update number of replicas</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(min_replica=<span class="hljs-number">2</span>, max_replica=<span class="hljs-number">6</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)

<span class="hljs-comment"># Update to larger instance</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.update(accelerator=<span class="hljs-string">&quot;cpu&quot;</span>, instance_size=<span class="hljs-string">&quot;x4&quot;</span>, instance_type=<span class="hljs-string">&quot;intel-icl&quot;</span>)
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-endpoint-name&#x27;</span>, namespace=<span class="hljs-string">&#x27;Wauplin&#x27;</span>, repository=<span class="hljs-string">&#x27;gpt2-large&#x27;</span>, status=<span class="hljs-string">&#x27;pending&#x27;</span>, url=<span class="hljs-literal">None</span>)`,wrap:!1}}),we=new d({props:{code:"aGYlMjBlbmRwb2ludHMlMjB1cGRhdGUlMjBteS1lbmRwb2ludC1uYW1lJTIwLS1yZXBvJTIwZ3B0Mi1sYXJnZSUwQWhmJTIwZW5kcG9pbnRzJTIwdXBkYXRlJTIwbXktZW5kcG9pbnQtbmFtZSUyMC0tbWluLXJlcGxpY2ElMjAyJTIwLS1tYXgtcmVwbGljYSUyMDYlMEFoZiUyMGVuZHBvaW50cyUyMHVwZGF0ZSUyMG15LWVuZHBvaW50LW5hbWUlMjAtLWFjY2VsZXJhdG9yJTIwY3B1JTIwLS1pbnN0YW5jZS1zaXplJTIweDQlMjAtLWluc3RhbmNlLXR5cGUlMjBpbnRlbC1pY2w=",highlighted:`hf endpoints update my-endpoint-name --repo gpt2-large
hf endpoints update my-endpoint-name --min-replica 2 --max-replica 6
hf endpoints update my-endpoint-name --accelerator cpu --instance-size x4 --instance-type intel-icl`,wrap:!1}}),Ue=new m({props:{title:"Delete the endpoint",local:"delete-the-endpoint",headingTag:"h3"}}),xe=new m({props:{title:"An end-to-end example",local:"an-end-to-end-example",headingTag:"h2"}}),Te=new d({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBjcmVhdGVfaW5mZXJlbmNlX2VuZHBvaW50KG5hbWUlM0QlMjJiYXRjaC1lbmRwb2ludCUyMiUyQy4uLikud2FpdCgpJTBBJTBBY2xpZW50JTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50JTBBcmVzdWx0cyUyMCUzRCUyMCU1QmNsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCUwQSUwQWFzeW5jX2NsaWVudCUyMCUzRCUyMGVuZHBvaW50LmFzeW5jX2NsaWVudCUwQXJlc3VsdHMlMjAlM0QlMjBhc3luY2lvLmdhdGhlcigqJTVCYXN5bmNfY2xpZW50LnRleHRfZ2VuZXJhdGlvbiguLi4pJTIwZm9yJTIwam9iJTIwaW4lMjBqb2JzJTVEKSUwQSUwQWVuZHBvaW50LnBhdXNlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_inference_endpoint

<span class="hljs-comment"># Start endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = create_inference_endpoint(name=<span class="hljs-string">&quot;batch-endpoint&quot;</span>,...).wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = endpoint.client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = [client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs]

<span class="hljs-comment"># Or with asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),ke=new d({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50JTBBJTBBZW5kcG9pbnQlMjAlM0QlMjBnZXRfaW5mZXJlbmNlX2VuZHBvaW50KCUyMmJhdGNoLWVuZHBvaW50JTIyKS5yZXN1bWUoKS53YWl0KCklMEElMEFhc3luY19jbGllbnQlMjAlM0QlMjBlbmRwb2ludC5hc3luY19jbGllbnQlMEFyZXN1bHRzJTIwJTNEJTIwYXN5bmNpby5nYXRoZXIoKiU1QmFzeW5jX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oLi4uKSUyMGZvciUyMGpvYiUyMGluJTIwam9icyU1RCklMEElMEFlbmRwb2ludC5wYXVzZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> asyncio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint

<span class="hljs-comment"># Get endpoint + wait until initialized</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;batch-endpoint&quot;</span>).resume().wait()

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>async_client = endpoint.async_client
<span class="hljs-meta">&gt;&gt;&gt; </span>results = asyncio.gather(*[async_client.text_generation(...) <span class="hljs-keyword">for</span> job <span class="hljs-keyword">in</span> jobs])

<span class="hljs-comment"># Pause endpoint</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()`,wrap:!1}}),We=new Qt({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference_endpoints.md"}}),{c(){j=i("meta"),Ee=a(),ve=i("p"),Be=a(),o(w.$$.fragment),He=a(),o(U.$$.fragment),Le=a(),$=i("p"),$.innerHTML=On,qe=a(),x=i("p"),x.innerHTML=Dn,Ge=a(),M=i("blockquote"),M.innerHTML=et,Ae=a(),o(I.$$.fragment),Ye=a(),T=i("p"),T.innerHTML=nt,Qe=a(),o(C.$$.fragment),Xe=a(),k=i("p"),k.textContent=tt,Ve=a(),o(W.$$.fragment),Re=a(),J=i("p"),J.innerHTML=st,ze=a(),v=i("p"),v.innerHTML=at,Ne=a(),o(Z.$$.fragment),Se=a(),E=i("p"),E.textContent=lt,Fe=a(),o(B.$$.fragment),Pe=a(),H=i("p"),H.innerHTML=it,Ke=a(),L=i("p"),L.innerHTML=pt,Oe=a(),q=i("p"),q.innerHTML=ct,De=a(),o(G.$$.fragment),en=a(),A=i("p"),A.innerHTML=ot,nn=a(),o(Y.$$.fragment),tn=a(),Q=i("p"),Q.innerHTML=rt,sn=a(),o(X.$$.fragment),an=a(),V=i("p"),V.innerHTML=gt,ln=a(),o(R.$$.fragment),pn=a(),z=i("p"),z.textContent=ut,cn=a(),o(N.$$.fragment),on=a(),o(S.$$.fragment),rn=a(),F=i("p"),F.innerHTML=ht,gn=a(),o(P.$$.fragment),un=a(),K=i("p"),K.innerHTML=ft,hn=a(),o(O.$$.fragment),fn=a(),D=i("p"),D.textContent=dt,dn=a(),o(ee.$$.fragment),mn=a(),ne=i("p"),ne.innerHTML=mt,jn=a(),o(te.$$.fragment),Mn=a(),se=i("p"),se.innerHTML=jt,yn=a(),o(ae.$$.fragment),bn=a(),le=i("p"),le.textContent=Mt,_n=a(),ie=i("p"),ie.innerHTML=yt,wn=a(),o(pe.$$.fragment),Un=a(),ce=i("p"),ce.innerHTML=bt,$n=a(),o(oe.$$.fragment),xn=a(),re=i("p"),re.innerHTML=_t,In=a(),o(ge.$$.fragment),Tn=a(),ue=i("p"),ue.textContent=wt,Cn=a(),y=i("blockquote"),y.innerHTML=Ut,kn=a(),o(he.$$.fragment),Wn=a(),fe=i("p"),fe.innerHTML=$t,Jn=a(),b=i("blockquote"),b.innerHTML=xt,vn=a(),o(de.$$.fragment),Zn=a(),me=i("p"),me.textContent=It,En=a(),o(je.$$.fragment),Bn=a(),o(Me.$$.fragment),Hn=a(),ye=i("p"),ye.innerHTML=Tt,Ln=a(),o(be.$$.fragment),qn=a(),_e=i("p"),_e.textContent=Ct,Gn=a(),o(we.$$.fragment),An=a(),o(Ue.$$.fragment),Yn=a(),$e=i("p"),$e.innerHTML=kt,Qn=a(),_=i("blockquote"),_.innerHTML=Wt,Xn=a(),o(xe.$$.fragment),Vn=a(),Ie=i("p"),Ie.textContent=Jt,Rn=a(),o(Te.$$.fragment),zn=a(),Ce=i("p"),Ce.textContent=vt,Nn=a(),o(ke.$$.fragment),Sn=a(),o(We.$$.fragment),Fn=a(),Ze=i("p"),this.h()},l(e){const n=Gt("svelte-u9bgzb",document.head);j=p(n,"META",{name:!0,content:!0}),n.forEach(t),Ee=l(e),ve=p(e,"P",{}),Zt(ve).forEach(t),Be=l(e),r(w.$$.fragment,e),He=l(e),r(U.$$.fragment,e),Le=l(e),$=p(e,"P",{"data-svelte-h":!0}),c($)!=="svelte-188e6gz"&&($.innerHTML=On),qe=l(e),x=p(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1ds3okp"&&(x.innerHTML=Dn),Ge=l(e),M=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(M)!=="svelte-15rzt9v"&&(M.innerHTML=et),Ae=l(e),r(I.$$.fragment,e),Ye=l(e),T=p(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-cqit0a"&&(T.innerHTML=nt),Qe=l(e),r(C.$$.fragment,e),Xe=l(e),k=p(e,"P",{"data-svelte-h":!0}),c(k)!=="svelte-zihpvf"&&(k.textContent=tt),Ve=l(e),r(W.$$.fragment,e),Re=l(e),J=p(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-1stw0yf"&&(J.innerHTML=st),ze=l(e),v=p(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1v18sfy"&&(v.innerHTML=at),Ne=l(e),r(Z.$$.fragment,e),Se=l(e),E=p(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-zihpvf"&&(E.textContent=lt),Fe=l(e),r(B.$$.fragment,e),Pe=l(e),H=p(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-dxdc75"&&(H.innerHTML=it),Ke=l(e),L=p(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1tjw294"&&(L.innerHTML=pt),Oe=l(e),q=p(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1tajtyl"&&(q.innerHTML=ct),De=l(e),r(G.$$.fragment,e),en=l(e),A=p(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-j6tvxe"&&(A.innerHTML=ot),nn=l(e),r(Y.$$.fragment,e),tn=l(e),Q=p(e,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-33b9op"&&(Q.innerHTML=rt),sn=l(e),r(X.$$.fragment,e),an=l(e),V=p(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-1w1xfgf"&&(V.innerHTML=gt),ln=l(e),r(R.$$.fragment,e),pn=l(e),z=p(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-i27wnj"&&(z.textContent=ut),cn=l(e),r(N.$$.fragment,e),on=l(e),r(S.$$.fragment,e),rn=l(e),F=p(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-y5xy0k"&&(F.innerHTML=ht),gn=l(e),r(P.$$.fragment,e),un=l(e),K=p(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-13dlhqv"&&(K.innerHTML=ft),hn=l(e),r(O.$$.fragment,e),fn=l(e),D=p(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-zihpvf"&&(D.textContent=dt),dn=l(e),r(ee.$$.fragment,e),mn=l(e),ne=p(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-qtkg7n"&&(ne.innerHTML=mt),jn=l(e),r(te.$$.fragment,e),Mn=l(e),se=p(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1g2lxsg"&&(se.innerHTML=jt),yn=l(e),r(ae.$$.fragment,e),bn=l(e),le=p(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-un9pgy"&&(le.textContent=Mt),_n=l(e),ie=p(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-kz23iw"&&(ie.innerHTML=yt),wn=l(e),r(pe.$$.fragment,e),Un=l(e),ce=p(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-1p192s5"&&(ce.innerHTML=bt),$n=l(e),r(oe.$$.fragment,e),xn=l(e),re=p(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-ruirtr"&&(re.innerHTML=_t),In=l(e),r(ge.$$.fragment,e),Tn=l(e),ue=p(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-16mqpnz"&&(ue.textContent=wt),Cn=l(e),y=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(y)!=="svelte-xds5cz"&&(y.innerHTML=Ut),kn=l(e),r(he.$$.fragment,e),Wn=l(e),fe=p(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-iiep7b"&&(fe.innerHTML=$t),Jn=l(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(b)!=="svelte-qqf1d4"&&(b.innerHTML=xt),vn=l(e),r(de.$$.fragment,e),Zn=l(e),me=p(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-zihpvf"&&(me.textContent=It),En=l(e),r(je.$$.fragment,e),Bn=l(e),r(Me.$$.fragment,e),Hn=l(e),ye=p(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1s19g4k"&&(ye.innerHTML=Tt),Ln=l(e),r(be.$$.fragment,e),qn=l(e),_e=p(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-zihpvf"&&(_e.textContent=Ct),Gn=l(e),r(we.$$.fragment,e),An=l(e),r(Ue.$$.fragment,e),Yn=l(e),$e=p(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1j2n6pp"&&($e.innerHTML=kt),Qn=l(e),_=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(_)!=="svelte-1xzlwcl"&&(_.innerHTML=Wt),Xn=l(e),r(xe.$$.fragment,e),Vn=l(e),Ie=p(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-r11tzs"&&(Ie.textContent=Jt),Rn=l(e),r(Te.$$.fragment,e),zn=l(e),Ce=p(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-u5cd5i"&&(Ce.textContent=vt),Nn=l(e),r(ke.$$.fragment,e),Sn=l(e),r(We.$$.fragment,e),Fn=l(e),Ze=p(e,"P",{}),Zt(Ze).forEach(t),this.h()},h(){Je(j,"name","hf:doc:metadata"),Je(j,"content",Vt),Je(M,"class","tip"),Je(y,"class","tip"),Je(b,"class","tip"),Je(_,"class","warning")},m(e,n){At(document.head,j),s(e,Ee,n),s(e,ve,n),s(e,Be,n),g(w,e,n),s(e,He,n),g(U,e,n),s(e,Le,n),s(e,$,n),s(e,qe,n),s(e,x,n),s(e,Ge,n),s(e,M,n),s(e,Ae,n),g(I,e,n),s(e,Ye,n),s(e,T,n),s(e,Qe,n),g(C,e,n),s(e,Xe,n),s(e,k,n),s(e,Ve,n),g(W,e,n),s(e,Re,n),s(e,J,n),s(e,ze,n),s(e,v,n),s(e,Ne,n),g(Z,e,n),s(e,Se,n),s(e,E,n),s(e,Fe,n),g(B,e,n),s(e,Pe,n),s(e,H,n),s(e,Ke,n),s(e,L,n),s(e,Oe,n),s(e,q,n),s(e,De,n),g(G,e,n),s(e,en,n),s(e,A,n),s(e,nn,n),g(Y,e,n),s(e,tn,n),s(e,Q,n),s(e,sn,n),g(X,e,n),s(e,an,n),s(e,V,n),s(e,ln,n),g(R,e,n),s(e,pn,n),s(e,z,n),s(e,cn,n),g(N,e,n),s(e,on,n),g(S,e,n),s(e,rn,n),s(e,F,n),s(e,gn,n),g(P,e,n),s(e,un,n),s(e,K,n),s(e,hn,n),g(O,e,n),s(e,fn,n),s(e,D,n),s(e,dn,n),g(ee,e,n),s(e,mn,n),s(e,ne,n),s(e,jn,n),g(te,e,n),s(e,Mn,n),s(e,se,n),s(e,yn,n),g(ae,e,n),s(e,bn,n),s(e,le,n),s(e,_n,n),s(e,ie,n),s(e,wn,n),g(pe,e,n),s(e,Un,n),s(e,ce,n),s(e,$n,n),g(oe,e,n),s(e,xn,n),s(e,re,n),s(e,In,n),g(ge,e,n),s(e,Tn,n),s(e,ue,n),s(e,Cn,n),s(e,y,n),s(e,kn,n),g(he,e,n),s(e,Wn,n),s(e,fe,n),s(e,Jn,n),s(e,b,n),s(e,vn,n),g(de,e,n),s(e,Zn,n),s(e,me,n),s(e,En,n),g(je,e,n),s(e,Bn,n),g(Me,e,n),s(e,Hn,n),s(e,ye,n),s(e,Ln,n),g(be,e,n),s(e,qn,n),s(e,_e,n),s(e,Gn,n),g(we,e,n),s(e,An,n),g(Ue,e,n),s(e,Yn,n),s(e,$e,n),s(e,Qn,n),s(e,_,n),s(e,Xn,n),g(xe,e,n),s(e,Vn,n),s(e,Ie,n),s(e,Rn,n),g(Te,e,n),s(e,zn,n),s(e,Ce,n),s(e,Nn,n),g(ke,e,n),s(e,Sn,n),g(We,e,n),s(e,Fn,n),s(e,Ze,n),Pn=!0},p:Bt,i(e){Pn||(u(w.$$.fragment,e),u(U.$$.fragment,e),u(I.$$.fragment,e),u(C.$$.fragment,e),u(W.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(G.$$.fragment,e),u(Y.$$.fragment,e),u(X.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(oe.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(de.$$.fragment,e),u(je.$$.fragment,e),u(Me.$$.fragment,e),u(be.$$.fragment,e),u(we.$$.fragment,e),u(Ue.$$.fragment,e),u(xe.$$.fragment,e),u(Te.$$.fragment,e),u(ke.$$.fragment,e),u(We.$$.fragment,e),Pn=!0)},o(e){h(w.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(C.$$.fragment,e),h(W.$$.fragment,e),h(Z.$$.fragment,e),h(B.$$.fragment,e),h(G.$$.fragment,e),h(Y.$$.fragment,e),h(X.$$.fragment,e),h(R.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(pe.$$.fragment,e),h(oe.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(je.$$.fragment,e),h(Me.$$.fragment,e),h(be.$$.fragment,e),h(we.$$.fragment,e),h(Ue.$$.fragment,e),h(xe.$$.fragment,e),h(Te.$$.fragment,e),h(ke.$$.fragment,e),h(We.$$.fragment,e),Pn=!1},d(e){e&&(t(Ee),t(ve),t(Be),t(He),t(Le),t($),t(qe),t(x),t(Ge),t(M),t(Ae),t(Ye),t(T),t(Qe),t(Xe),t(k),t(Ve),t(Re),t(J),t(ze),t(v),t(Ne),t(Se),t(E),t(Fe),t(Pe),t(H),t(Ke),t(L),t(Oe),t(q),t(De),t(en),t(A),t(nn),t(tn),t(Q),t(sn),t(an),t(V),t(ln),t(pn),t(z),t(cn),t(on),t(rn),t(F),t(gn),t(un),t(K),t(hn),t(fn),t(D),t(dn),t(mn),t(ne),t(jn),t(Mn),t(se),t(yn),t(bn),t(le),t(_n),t(ie),t(wn),t(Un),t(ce),t($n),t(xn),t(re),t(In),t(Tn),t(ue),t(Cn),t(y),t(kn),t(Wn),t(fe),t(Jn),t(b),t(vn),t(Zn),t(me),t(En),t(Bn),t(Hn),t(ye),t(Ln),t(qn),t(_e),t(Gn),t(An),t(Yn),t($e),t(Qn),t(_),t(Xn),t(Vn),t(Ie),t(Rn),t(zn),t(Ce),t(Nn),t(Sn),t(Fn),t(Ze)),t(j),f(w,e),f(U,e),f(I,e),f(C,e),f(W,e),f(Z,e),f(B,e),f(G,e),f(Y,e),f(X,e),f(R,e),f(N,e),f(S,e),f(P,e),f(O,e),f(ee,e),f(te,e),f(ae,e),f(pe,e),f(oe,e),f(ge,e),f(he,e),f(de,e),f(je,e),f(Me,e),f(be,e),f(we,e),f(Ue,e),f(xe,e),f(Te,e),f(ke,e),f(We,e)}}}const Vt='{"title":"Inference Endpoints","local":"inference-endpoints","sections":[{"title":"Create an Inference Endpoint","local":"create-an-inference-endpoint","sections":[{"title":"Using a custom image","local":"using-a-custom-image","sections":[],"depth":4},{"title":"Get or list existing Inference Endpoints","local":"get-or-list-existing-inference-endpoints","sections":[],"depth":3}],"depth":2},{"title":"Check deployment status","local":"check-deployment-status","sections":[],"depth":2},{"title":"Run inference","local":"run-inference","sections":[],"depth":2},{"title":"Manage lifecycle","local":"manage-lifecycle","sections":[{"title":"Pause or scale to zero","local":"pause-or-scale-to-zero","sections":[],"depth":3},{"title":"Update model or hardware requirements","local":"update-model-or-hardware-requirements","sections":[],"depth":3},{"title":"Delete the endpoint","local":"delete-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"An end-to-end example","local":"an-end-to-end-example","sections":[],"depth":2}],"depth":1}';function Rt(Kn){return Ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Lt{constructor(j){super(),qt(this,j,Rt,Xt,Et,{})}}export{Kt as component};
