import{s as na,n as ia,o as oa}from"../chunks/scheduler.0cf4ef2e.js";import{S as ra,i as Ma,e as i,s,c as M,h as pa,a as o,d as t,b as n,f as sa,g as p,j as r,k as Mt,l as ca,m as a,n as c,t as d,o as h,p as m}from"../chunks/index.abc433bf.js";import{C as da}from"../chunks/CopyLLMTxtMenu.efc6b005.js";import{C as y}from"../chunks/CodeBlock.00dcd05e.js";import{H as u,E as ha}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.86d448e2.js";function ma(pt){let T,Ye,Ve,Ne,f,Re,b,Qe,j,ct=`The Hugging Face Hub makes hosting and sharing models with the community easy. It supports
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">dozens of libraries</a> in the Open Source ecosystem. We are always
working on expanding this support to push collaborative Machine Learning forward. The <code>huggingface_hub</code> library plays a
key role in this process, allowing any Python script to easily push and load files.`,Se,U,dt="There are four main ways to integrate a library with the Hub:",Xe,g,ht=`<li><strong>Push to Hub:</strong> implement a method to upload a model to the Hub. This includes the model weights, as well as
<a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">the model card</a> and any other relevant information
or data necessary to run the model (for example, training logs). This method is often called <code>push_to_hub()</code>.</li> <li><strong>Download from Hub:</strong> implement a method to load a model from the Hub. The method should download the model
configuration/weights and load the model. This method is often called <code>from_pretrained</code> or <code>load_from_hub()</code>.</li> <li><strong>Widgets:</strong> display a widget on the landing page of your models on the Hub. It allows users to quickly try a model
from the browser.</li>`,Fe,I,mt=`In this guide, we will focus on the first two topics. We will present the two main approaches you can use to integrate
a library, with their advantages and drawbacks. Everything is summarized at the end of the guide to help you choose
between the two. Please keep in mind that these are only guidelines that you are free to adapt to you requirements.`,Le,_,ut=`If you are interested in Inference and Widgets, you can follow <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">this guide</a>.
In both cases, you can reach out to us if you are integrating a library with the Hub and want to be listed
<a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">in our docs</a>.`,ze,C,qe,Z,yt=`The first approach to integrate a library to the Hub is to actually implement the <code>push_to_hub</code> and <code>from_pretrained</code>
methods by yourself. This gives you full flexibility on which files you need to upload/download and how to handle inputs
specific to your framework. You can refer to the two <a href="./upload">upload files</a> and <a href="./download">download files</a> guides
to learn more about how to do that. This is, for example how the FastAI integration is implemented (see <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.push_to_hub_fastai">push_to_hub_fastai()</a>
and <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.from_pretrained_fastai">from_pretrained_fastai()</a>).`,Pe,B,Tt="Implementation can differ between libraries, but the workflow is often similar.",De,v,Ke,k,wt="This is how a <code>from_pretrained</code> method usually looks like:",Oe,G,el,x,ll,W,Jt=`The <code>push_to_hub</code> method often requires a bit more complexity to handle repo creation, generate the model card and save weights.
A common approach is to save all of these files in a temporary folder, upload it and then delete it.`,tl,H,al,A,ft=`This is of course only an example. If you are interested in more complex manipulations (delete remote files, upload
weights on the fly, persist weights locally, etc.) please refer to the <a href="./upload">upload files</a> guide.`,sl,E,nl,V,bt=`While being flexible, this approach has some drawbacks, especially in terms of maintenance. Hugging Face users are often
used to additional features when working with <code>huggingface_hub</code>. For example, when loading files from the Hub, it is
common to offer parameters like:`,il,$,jt="<li><code>token</code>: to download from a private repo</li> <li><code>revision</code>: to download from a specific branch</li> <li><code>cache_dir</code>: to cache files in a specific directory</li> <li><code>force_download</code>/<code>local_files_only</code>: to reuse the cache or not</li> <li><code>proxies</code>: configure HTTP session</li>",ol,Y,Ut="When pushing models, similar parameters are supported:",rl,N,gt="<li><code>commit_message</code>: custom commit message</li> <li><code>private</code>: create a private repo if missing</li> <li><code>create_pr</code>: create a PR instead of pushing to <code>main</code></li> <li><code>branch</code>: push to a branch instead of the <code>main</code> branch</li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filter which files to upload</li> <li><code>token</code></li> <li>…</li>",Ml,R,It=`All of these parameters can be added to the implementations we saw above and passed to the <code>huggingface_hub</code> methods.
However, if a parameter changes or a new feature is added, you will need to update your package. Supporting those
parameters also means more documentation to maintain on your side. To see how to mitigate these limitations, let’s jump
to our next section <strong>class inheritance</strong>.`,pl,Q,cl,S,_t=`As we saw above, there are two main methods to include in your library to integrate it with the Hub: upload files
(<code>push_to_hub</code>) and download files (<code>from_pretrained</code>). You can implement those methods by yourself but it comes with
caveats. To tackle this, <code>huggingface_hub</code> provides a tool that uses class inheritance. Let’s see how it works!`,dl,X,Ct=`In a lot of cases, a library already implements its model using a Python class. The class contains the properties of
the model and methods to load, run, train, and evaluate it. Our approach is to extend this class to include upload and
download features using mixins. A <a href="https://stackoverflow.com/a/547714" rel="nofollow">Mixin</a> is a class that is meant to extend an
existing class with a set of specific features using multiple inheritance. <code>huggingface_hub</code> provides its own mixin,
the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>. The key here is to understand its behavior and how to customize it.`,hl,F,Zt=`The <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> class implements 3 <em>public</em> methods (<code>push_to_hub</code>, <code>save_pretrained</code> and <code>from_pretrained</code>). Those
are the methods that your users will call to load/save models with your library. <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> also defines 2
<em>private</em> methods (<code>_save_pretrained</code> and <code>_from_pretrained</code>). Those are the ones you must implement. So to integrate
your library, you should:`,ml,L,Bt=`<li>Make your Model class inherit from <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>.</li> <li>Implement the private methods:
<ul><li><a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._save_pretrained">_save_pretrained()</a>: method taking as input a path to a directory and saving the model to it.
You must write all the logic to dump your model in this method: model card, model weights, configuration files,
training logs, and figures. Any relevant information for this model must be handled by this method.
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards</a> are particularly important to describe your model. Check
out <a href="./model-cards">our implementation guide</a> for more details.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin._from_pretrained">_from_pretrained()</a>: <strong>class method</strong> taking as input a <code>model_id</code> and returning an instantiated
model. The method must download the relevant files and load them.</li></ul></li> <li>You are done!</li>`,ul,z,vt='The advantage of using <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> is that once you take care of the serialization/loading of the files, you are ready to go. You don’t need to worry about stuff like repo creation, commits, PRs, or revisions. The <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> also ensures public methods are documented and type annotated, and you’ll be able to view your model’s download count on the Hub. All of this is handled by the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> and available to your users.',yl,q,Tl,P,kt='A good example of what we saw above is <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin">PyTorchModelHubMixin</a>, our integration for the PyTorch framework. This is a ready-to-use integration.',wl,D,Jl,K,Gt="Here is how any user can load/save a PyTorch model from/to the Hub:",fl,O,bl,ee,jl,le,xt='The implementation is actually very straightforward, and the full implementation can be found <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">here</a>.',Ul,te,Wt="<li>First, inherit your class from <code>ModelHubMixin</code>:</li>",gl,ae,Il,w,Ht="<li>Implement the <code>_save_pretrained</code> method:</li>",_l,se,Cl,J,At="<li>Implement the <code>_from_pretrained</code> method:</li>",Zl,ne,Bl,ie,Et="And that’s it! Your library now enables users to upload and download files to and from the Hub.",vl,oe,kl,re,Vt='In the section above, we quickly discussed how the <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> works. In this section, we will see some of its more advanced features to improve your library integration with the Hugging Face Hub.',Gl,Me,xl,pe,$t='<a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> generates the model card for you. Model cards are files that accompany the models and provide important information about them. Under the hood, model cards are simple Markdown files with additional metadata. Model cards are essential for discoverability, reproducibility, and sharing! Check out the <a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards guide</a> for more details.',Wl,ce,Yt='Generating model cards semi-automatically is a good way to ensure that all models pushed with your library will share common metadata: <code>library_name</code>, <code>tags</code>, <code>license</code>, <code>pipeline_tag</code>, etc. This makes all models backed by your library easily searchable on the Hub and provides some resource links for users landing on the Hub. You can define the metadata directly when inheriting from <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>:',Hl,de,Al,he,Nt='By default, a generic model card will be generated with the info you’ve provided (example: <a href="https://huggingface.co/pyp1/VoiceCraft_giga830M" rel="nofollow">pyp1/VoiceCraft_giga830M</a>). But you can define your own model card template as well!',El,me,Rt='In this example, all models pushed with the <code>VoiceCraft</code> class will automatically include a citation section and license details. For more details on how to define a model card template, please check the <a href="./model-cards">Model Cards guide</a>.',Vl,ue,$l,ye,Qt="Finally, if you want to extend the model card generation process with dynamic values, you can override the <code>generate_model_card()</code> method:",Yl,Te,Nl,we,Rl,Je,St='<a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a> handles the model configuration for you. It automatically checks the input values when you instantiate the model and serializes them in a <code>config.json</code> file. This provides 2 benefits:',Ql,fe,Xt="<li>Users will be able to reload the model with the exact same parameters as you.</li> <li>Having a <code>config.json</code> file automatically enables analytics on the Hub (i.e. the “downloads” count).</li>",Sl,be,Ft="But how does it work in practice? Several rules make the process as smooth as possible from a user perspective:",Xl,je,Lt="<li>if your <code>__init__</code> method expects a <code>config</code> input, it will be automatically saved in the repo as <code>config.json</code>.</li> <li>if the <code>config</code> input parameter is annotated with a dataclass type (e.g. <code>config: Optional[MyConfigClass] = None</code>), then the <code>config</code> value will be correctly deserialized for you.</li> <li>all values passed at initialization will also be stored in the config file. This means you don’t necessarily have to expect a <code>config</code> input to benefit from it.</li>",Fl,Ue,zt="Example:",Ll,ge,zl,Ie,qt='But what if a value cannot be serialized as JSON? By default, the value will be ignored when saving the config file. However, in some cases your library already expects a custom object as input that cannot be serialized, and you don’t want to update your internal logic to update its type. No worries! You can pass custom encoders/decoders for any type when inheriting from <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a>. This is a bit more work but ensures your internal logic is untouched when integrating your library with the Hub.',ql,_e,Pt="Here is a concrete example where a class expects a <code>argparse.Namespace</code> config as input:",Pl,Ce,Dl,Ze,Dt="One solution can be to update the <code>__init__</code> signature to <code>def __init__(self, pattern: str, hidden_size: int)</code> and update all snippets that instantiate your class. This is a perfectly valid way to fix it but it might break downstream applications using your library.",Kl,Be,Kt="Another solution is to provide a simple encoder/decoder to convert <code>argparse.Namespace</code> to a dictionary.",Ol,ve,et,ke,Ot="In the snippet above, both the internal logic and the <code>__init__</code> signature of the class did not change. This means all existing code snippets for your library will continue to work. To achieve this, we had to:",lt,Ge,ea=`<li>Inherit from the mixin (<code>PytorchModelHubMixin</code> in this case).</li> <li>Pass a <code>coders</code> parameter in the inheritance. This is a dictionary where keys are custom types you want to process. Values are a tuple <code>(encoder, decoder)</code>.
<ul><li>The encoder expects an object of the specified type as input and returns a jsonable value. This will be used when saving a model with <code>save_pretrained</code>.</li> <li>The decoder expects raw data (typically a dictionary) as input and reconstructs the initial object. This will be used when loading the model with <code>from_pretrained</code>.</li></ul></li> <li>Add a type annotation to the <code>__init__</code> signature. This is important to let the mixin know which type is expected by the class and, therefore, which decoder to use.</li>`,tt,xe,la="For the sake of simplicity, the encoder/decoder functions in the example above are not robust. For a concrete implementation, you would most likely have to handle corner cases properly.",at,We,st,He,ta=`Let’s quickly sum up the two approaches we saw with their advantages and drawbacks. The table below is only indicative.
Your framework might have some specificities that you need to address. This guide is only here to give guidelines and
ideas on how to handle integration. In any case, feel free to contact us if you have any questions!`,nt,Ae,aa='<thead><tr><th align="center">Integration</th> <th align="center">Using helpers</th> <th align="center">Using <a href="/docs/huggingface_hub/main/en/package_reference/mixins#huggingface_hub.ModelHubMixin">ModelHubMixin</a></th></tr></thead> <tbody><tr><td align="center">User experience</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexibility</td> <td align="center">Very flexible.<br/>You fully control the implementation.</td> <td align="center">Less flexible.<br/>Your framework must have a model class.</td></tr> <tr><td align="center">Maintenance</td> <td align="center">More maintenance to add support for configuration, and new features. Might also require fixing issues reported by users.</td> <td align="center">Less maintenance as most of the interactions with the Hub are implemented in <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Documentation / Type annotation</td> <td align="center">To be written manually.</td> <td align="center">Partially handled by <code>huggingface_hub</code>.</td></tr> <tr><td align="center">Download counter</td> <td align="center">To be handled manually.</td> <td align="center">Enabled by default if class has a <code>config</code> attribute.</td></tr> <tr><td align="center">Model card</td> <td align="center">To be handled manually</td> <td align="center">Generated by default with library_name, tags, etc.</td></tr></tbody>',it,Ee,ot,$e,rt;return f=new da({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new u({props:{title:"Integrate any ML framework with the Hub",local:"integrate-any-ml-framework-with-the-hub",headingTag:"h1"}}),C=new u({props:{title:"A flexible approach: helpers",local:"a-flexible-approach-helpers",headingTag:"h2"}}),v=new u({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),G=new y({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBEb3dubG9hZCUyMG1vZGVsJTIwZnJvbSUyMEh1YiUwQSUyMCUyMCUyMGNhY2hlZF9tb2RlbCUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGZpbGVuYW1lJTNEJTIybW9kZWwucGtsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIyZmFzdGFpJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwbGlicmFyeV92ZXJzaW9uJTNEZ2V0X2Zhc3RhaV92ZXJzaW9uKCklMkMlMEElMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIzJTIwTG9hZCUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9hZF9tb2RlbChjYWNoZWRfbW9kZWwp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Download model from Hub</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Load model</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),x=new u({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),H=new y({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwcmVwbyUyMGlmJTIwbm90JTIwZXhpc3RpbmclMjB5ZXQlMjBhbmQlMjBnZXQlMjB0aGUlMjBhc3NvY2lhdGVkJTIwcmVwb19pZCUwQSUyMCUyMCUyMHJlcG9faWQlMjAlM0QlMjBhcGkuY3JlYXRlX3JlcG8ocmVwb19uYW1lJTJDJTIwZXhpc3Rfb2slM0RUcnVlKSUwQSUwQSUyMCUyMCUyMCUyMyUyMFNhdmUlMjBhbGwlMjBmaWxlcyUyMGluJTIwYSUyMHRlbXBvcmFyeSUyMGRpcmVjdG9yeSUyMGFuZCUyMHB1c2glMjB0aGVtJTIwaW4lMjBhJTIwc2luZ2xlJTIwY29tbWl0JTBBJTIwJTIwJTIwd2l0aCUyMFRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjB0bXBkaXIlMjAlM0QlMjBQYXRoKHRtcGRpciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwd2VpZ2h0cyUwQSUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWwobW9kZWwlMkMlMjB0bXBkaXIlMjAlMkYlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZW5lcmF0ZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQlMjAlM0QlMjBnZW5lcmF0ZV9tb2RlbF9jYXJkKG1vZGVsKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCh0bXBkaXIlMjAlMkYlMjAlMjJSRUFETUUubWQlMjIpLndyaXRlX3RleHQoY2FyZCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBTYXZlJTIwbG9ncyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFNhdmUlMjBmaWd1cmVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2F2ZSUyMGV2YWx1YXRpb24lMjBtZXRyaWNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUHVzaCUyMHRvJTIwaHViJTBBJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwYXBpLnVwbG9hZF9mb2xkZXIocmVwb19pZCUzRHJlcG9faWQlMkMlMjBmb2xkZXJfcGF0aCUzRHRtcGRpcik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Create repo if not existing yet and get the associated repo_id</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># Save all files in a temporary directory and push them in a single commit</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Save weights</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Generate model card</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Save logs</span>
      <span class="hljs-comment"># Save figures</span>
      <span class="hljs-comment"># Save evaluation metrics</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Push to hub</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),E=new u({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),Q=new u({props:{title:"A more complex approach: class inheritance",local:"a-more-complex-approach-class-inheritance",headingTag:"h2"}}),q=new u({props:{title:"A concrete example: PyTorch",local:"a-concrete-example-pytorch",headingTag:"h3"}}),D=new u({props:{title:"How to use it?",local:"how-to-use-it",headingTag:"h4"}}),O=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin


<span class="hljs-comment"># Define your Pytorch model exactly the same way you are used to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(
<span class="hljs-meta">... </span>        nn.Module,
<span class="hljs-meta">... </span>        PyTorchModelHubMixin, <span class="hljs-comment"># multiple inheritance</span>
<span class="hljs-meta">... </span>        library_name=<span class="hljs-string">&quot;keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        tags=[<span class="hljs-string">&quot;keras&quot;</span>],
<span class="hljs-meta">... </span>        repo_url=<span class="hljs-string">&quot;https://github.com/keras-team/keras-nlp&quot;</span>,
<span class="hljs-meta">... </span>        docs_url=<span class="hljs-string">&quot;https://keras.io/keras_nlp/&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># ^ optional metadata to generate model card</span>
<span class="hljs-meta">... </span>    ):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, hidden_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">512</span>, vocab_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">30000</span>, output_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">4</span></span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__()
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(hidden_size, vocab_size))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(output_size, vocab_size)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)

<span class="hljs-comment"># 1. Create model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel(hidden_size=<span class="hljs-number">128</span>)

<span class="hljs-comment"># Config is automatically created based on input + default values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.param.shape[<span class="hljs-number">0</span>]
<span class="hljs-number">128</span>

<span class="hljs-comment"># 2. (optional) Save model to local directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Push model weights to the Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Initialize model from the Hub =&gt; config has been preserved</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.param.shape[<span class="hljs-number">0</span>]
<span class="hljs-number">128</span>

<span class="hljs-comment"># Model card has been correctly populated</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard
<span class="hljs-meta">&gt;&gt;&gt; </span>card = ModelCard.load(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.tags
[<span class="hljs-string">&quot;keras&quot;</span>, <span class="hljs-string">&quot;pytorch_model_hub_mixin&quot;</span>, <span class="hljs-string">&quot;model_hub_mixin&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>card.data.library_name
<span class="hljs-string">&quot;keras-nlp&quot;</span>`,wrap:!1}}),ee=new u({props:{title:"Implementation",local:"implementation",headingTag:"h4"}}),ae=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),se=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJTYXZlJTIwd2VpZ2h0cyUyMGZyb20lMjBhJTIwUHl0b3JjaCUyMG1vZGVsJTIwdG8lMjBhJTIwbG9jYWwlMjBkaXJlY3RvcnkuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2F2ZV9tb2RlbF9hc19zYWZldGVuc29yKHNlbGYubW9kdWxlJTJDJTIwc3RyKHNhdmVfZGlyZWN0b3J5JTIwJTJGJTIwU0FGRVRFTlNPUlNfU0lOR0xFX0ZJTEUpKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-string">&quot;&quot;&quot;Save weights from a Pytorch model to a local directory.&quot;&quot;&quot;</span>
        save_model_as_safetensor(self.module, <span class="hljs-built_in">str</span>(save_directory / SAFETENSORS_SINGLE_FILE))
`,wrap:!1}}),ne=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Must be a classmethod!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># additional argument</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># additional argument</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Load Pytorch pretrained weights and return the loaded model.&quot;&quot;&quot;</span>
        model = cls(**model_kwargs)
        <span class="hljs-keyword">if</span> os.path.isdir(model_id):
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
            model_file = os.path.join(model_id, SAFETENSORS_SINGLE_FILE)
            <span class="hljs-keyword">return</span> cls._load_as_safetensor(model, model_file, map_location, strict)

         model_file = hf_hub_download(
            repo_id=model_id,
            filename=SAFETENSORS_SINGLE_FILE,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            token=token,
            local_files_only=local_files_only,
            )
         <span class="hljs-keyword">return</span> cls._load_as_safetensor(model, model_file, map_location, strict)`,wrap:!1}}),oe=new u({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h3"}}),Me=new u({props:{title:"Model card",local:"model-card",headingTag:"h4"}}),de=new y({props:{code:"Y2xhc3MlMjBVbmlEZXB0aFYxKCUwQSUyMCUyMCUyMG5uLk1vZHVsZSUyQyUwQSUyMCUyMCUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTJDJTBBJTIwJTIwJTIwbGlicmFyeV9uYW1lJTNEJTIydW5pZGVwdGglMjIlMkMlMEElMjAlMjAlMjByZXBvX3VybCUzRCUyMmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmxwaWNjaW5lbGxpLWV0aCUyRlVuaURlcHRoJTIyJTJDJTBBJTIwJTIwJTIwZG9jc191cmwlM0QuLi4lMkMlMEElMjAlMjAlMjBwaXBlbGluZV90YWclM0QlMjJkZXB0aC1lc3RpbWF0aW9uJTIyJTJDJTBBJTIwJTIwJTIwbGljZW5zZSUzRCUyMmNjLWJ5LW5jLTQuMCUyMiUyQyUwQSUyMCUyMCUyMHRhZ3MlM0QlNUIlMjJtb25vY3VsYXItbWV0cmljLWRlcHRoLWVzdGltYXRpb24lMjIlMkMlMjAlMjJhcnhpdiUzQTEyMzQuNTY3ODklMjIlNUQlMEEpJTNBJTBBJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">UniDepthV1</span>(
   nn.Module,
   PyTorchModelHubMixin,
   library_name=<span class="hljs-string">&quot;unidepth&quot;</span>,
   repo_url=<span class="hljs-string">&quot;https://github.com/lpiccinelli-eth/UniDepth&quot;</span>,
   docs_url=...,
   pipeline_tag=<span class="hljs-string">&quot;depth-estimation&quot;</span>,
   license=<span class="hljs-string">&quot;cc-by-nc-4.0&quot;</span>,
   tags=[<span class="hljs-string">&quot;monocular-metric-depth-estimation&quot;</span>, <span class="hljs-string">&quot;arxiv:1234.56789&quot;</span>]
):
   ...`,wrap:!1}}),ue=new y({props:{code:"TU9ERUxfQ0FSRF9URU1QTEFURSUyMCUzRCUyMCUyMiUyMiUyMiUwQS0tLSUwQSUyMyUyMEZvciUyMHJlZmVyZW5jZSUyMG9uJTIwbW9kZWwlMjBjYXJkJTIwbWV0YWRhdGElMkMlMjBzZWUlMjB0aGUlMjBzcGVjJTNBJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZodWItZG9jcyUyRmJsb2IlMkZtYWluJTJGbW9kZWxjYXJkLm1kJTNGcGxhaW4lM0QxJTBBJTIzJTIwRG9jJTIwJTJGJTIwZ3VpZGUlM0ElMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZG9jcyUyRmh1YiUyRm1vZGVsLWNhcmRzJTBBJTdCJTdCJTIwY2FyZF9kYXRhJTIwJTdEJTdEJTBBLS0tJTBBJTBBVGhpcyUyMGlzJTIwYSUyMFZvaWNlQ3JhZnQlMjBtb2RlbC4lMjBGb3IlMjBtb3JlJTIwZGV0YWlscyUyQyUyMHBsZWFzZSUyMGNoZWNrJTIwb3V0JTIwdGhlJTIwb2ZmaWNpYWwlMjBHaXRodWIlMjByZXBvJTNBJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGamFzb25wcHklMkZWb2ljZUNyYWZ0LiUyMFRoaXMlMjBtb2RlbCUyMGlzJTIwc2hhcmVkJTIwdW5kZXIlMjBhJTIwQXR0cmlidXRpb24tTm9uQ29tbWVyY2lhbC1TaGFyZUFsaWtlJTIwNC4wJTIwSW50ZXJuYXRpb25hbCUyMGxpY2Vuc2UuJTBBJTBBJTIzJTIzJTIwQ2l0YXRpb24lMEElMEElNDBhcnRpY2xlJTdCcGVuZzIwMjR2b2ljZWNyYWZ0JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCUGVuZyUyQyUyMFB1eXVhbiUyMGFuZCUyMEh1YW5nJTJDJTIwUG8tWWFvJTIwYW5kJTIwTGklMkMlMjBEYW5pZWwlMjBhbmQlMjBNb2hhbWVkJTJDJTIwQWJkZWxyYWhtYW4lMjBhbmQlMjBIYXJ3YXRoJTJDJTIwRGF2aWQlN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QlZvaWNlQ3JhZnQlM0ElMjBaZXJvLVNob3QlMjBTcGVlY2glMjBFZGl0aW5nJTIwYW5kJTIwVGV4dC10by1TcGVlY2glMjBpbiUyMHRoZSUyMFdpbGQlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCYXJYaXYlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAyNCU3RCUyQyUwQSU3RCUwQSUyMiUyMiUyMiUwQSUwQWNsYXNzJTIwVm9pY2VDcmFmdCglMEElMjAlMjAlMjBubi5Nb2R1bGUlMkMlMEElMjAlMjAlMjBQeVRvcmNoTW9kZWxIdWJNaXhpbiUyQyUwQSUyMCUyMCUyMGxpYnJhcnlfbmFtZSUzRCUyMnZvaWNlY3JhZnQlMjIlMkMlMEElMjAlMjAlMjBtb2RlbF9jYXJkX3RlbXBsYXRlJTNETU9ERUxfQ0FSRF9URU1QTEFURSUyQyUwQSUyMCUyMCUyMC4uLiUwQSklM0ElMEElMjAlMjAlMjAuLi4=",highlighted:`MODEL_CARD_TEMPLATE = <span class="hljs-string">&quot;&quot;&quot;
---
# For reference on model card metadata, see the spec: https://github.com/huggingface/hub-docs/blob/main/modelcard.md?plain=1
# Doc / guide: https://huggingface.co/docs/hub/model-cards
{{ card_data }}
---

This is a VoiceCraft model. For more details, please check out the official Github repo: https://github.com/jasonppy/VoiceCraft. This model is shared under a Attribution-NonCommercial-ShareAlike 4.0 International license.

## Citation

@article{peng2024voicecraft,
  author    = {Peng, Puyuan and Huang, Po-Yao and Li, Daniel and Mohamed, Abdelrahman and Harwath, David},
  title     = {VoiceCraft: Zero-Shot Speech Editing and Text-to-Speech in the Wild},
  journal   = {arXiv},
  year      = {2024},
}
&quot;&quot;&quot;</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">VoiceCraft</span>(
   nn.Module,
   PyTorchModelHubMixin,
   library_name=<span class="hljs-string">&quot;voicecraft&quot;</span>,
   model_card_template=MODEL_CARD_TEMPLATE,
   ...
):
   ...`,wrap:!1}}),Te=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTBBJTBBY2xhc3MlMjBVbmlEZXB0aFYxKG5uLk1vZHVsZSUyQyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTJDJTIwLi4uKSUzQSUwQSUyMCUyMCUyMCguLi4pJTBBJTBBJTIwJTIwJTIwZGVmJTIwZ2VuZXJhdGVfbW9kZWxfY2FyZChzZWxmJTJDJTIwKmFyZ3MlMkMlMjAqKmt3YXJncyklMjAtJTNFJTIwTW9kZWxDYXJkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwY2FyZCUyMCUzRCUyMHN1cGVyKCkuZ2VuZXJhdGVfbW9kZWxfY2FyZCgqYXJncyUyQyUyMCoqa3dhcmdzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMGNhcmQuZGF0YS5tZXRyaWNzJTIwJTNEJTIwLi4uJTIwJTIwJTIzJTIwYWRkJTIwbWV0cmljcyUyMHRvJTIwdGhlJTIwbWV0YWRhdGElMEElMjAlMjAlMjAlMjAlMjAlMjBjYXJkLnRleHQlMjAlMkIlM0QlMjAuLi4lMjAlMjMlMjBhcHBlbmQlMjBzZWN0aW9uJTIwdG8lMjB0aGUlMjBtb2RlbGNhcmQlMEElMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBjYXJk",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, PyTorchModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">UniDepthV1</span>(nn.Module, PyTorchModelHubMixin, ...):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_model_card</span>(<span class="hljs-params">self, *args, **kwargs</span>) -&gt; ModelCard:
      card = <span class="hljs-built_in">super</span>().generate_model_card(*args, **kwargs)
      card.data.metrics = ...  <span class="hljs-comment"># add metrics to the metadata</span>
      card.text += ... <span class="hljs-comment"># append section to the modelcard</span>
      <span class="hljs-keyword">return</span> card`,wrap:!1}}),we=new u({props:{title:"Config",local:"config",headingTag:"h4"}}),ge=new y({props:{code:"Y2xhc3MlMjBNeU1vZGVsKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwZGVmJTIwX19pbml0X18odmFsdWUlM0ElMjBzdHIlMkMlMjBzaXplJTNBJTIwaW50JTIwJTNEJTIwMyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnZhbHVlJTIwJTNEJTIwdmFsdWUlMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnNpemUlMjAlM0QlMjBzaXplJTBBJTBBJTIwJTIwJTIwKC4uLiklMjAlMjMlMjBpbXBsZW1lbnQlMjBfc2F2ZV9wcmV0cmFpbmVkJTIwJTJGJTIwX2Zyb21fcHJldHJhaW5lZCUwQSUwQW1vZGVsJTIwJTNEJTIwTXlNb2RlbCh2YWx1ZSUzRCUyMm15X3ZhbHVlJTIyKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCguLi4pJTBBJTBBJTIzJTIwY29uZmlnLmpzb24lMjBjb250YWlucyUyMHBhc3NlZCUyMGFuZCUyMGRlZmF1bHQlMjB2YWx1ZXMlMEElN0IlMjJ2YWx1ZSUyMiUzQSUyMCUyMm15X3ZhbHVlJTIyJTJDJTIwJTIyc2l6ZSUyMiUzQSUyMDMlN0Q=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">value: <span class="hljs-built_in">str</span>, size: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span></span>):
      self.value = value
      self.size = size

   (...) <span class="hljs-comment"># implement _save_pretrained / _from_pretrained</span>

model = MyModel(value=<span class="hljs-string">&quot;my_value&quot;</span>)
model.save_pretrained(...)

<span class="hljs-comment"># config.json contains passed and default values</span>
{<span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;my_value&quot;</span>, <span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">3</span>}`,wrap:!1}}),Ce=new y({props:{code:"Y2xhc3MlMjBWb2ljZUNyYWZ0KG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwYXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBhdHRlcm4lMjAlM0QlMjBzZWxmLmFyZ3MucGF0dGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBzZWxmLmFyZ3MuaGlkZGVuX3NpemUlMEElMjAlMjAlMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">VoiceCraft</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, args</span>):
      self.pattern = self.args.pattern
      self.hidden_size = self.args.hidden_size
      ...`,wrap:!1}}),ve=new y({props:{code:"ZnJvbSUyMGFyZ3BhcnNlJTIwaW1wb3J0JTIwTmFtZXNwYWNlJTBBJTBBY2xhc3MlMjBWb2ljZUNyYWZ0KCUwQSUyMCUyMCUyMG5uLk1vZHVsZSUyQyUwQSUyMCUyMCUyMFB5VG9yY2hNb2RlbEh1Yk1peGluJTJDJTIwJTIwJTIzJTIwaW5oZXJpdCUyMGZyb20lMjBtaXhpbiUwQSUyMCUyMCUyMGNvZGVycyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyME5hbWVzcGFjZSUyMCUzQSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwdmFycyh4KSUyQyUyMCUyMCUyMyUyMEVuY29kZXIlM0ElMjBob3clMjB0byUyMGNvbnZlcnQlMjBhJTIwJTYwTmFtZXNwYWNlJTYwJTIwdG8lMjBhJTIwdmFsaWQlMjBqc29uYWJsZSUyMHZhbHVlJTNGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFtYmRhJTIwZGF0YSUzQSUyME5hbWVzcGFjZSgqKmRhdGEpJTJDJTIwJTIwJTIzJTIwRGVjb2RlciUzQSUyMGhvdyUyMHRvJTIwcmVjb25zdHJ1Y3QlMjBhJTIwJTYwTmFtZXNwYWNlJTYwJTIwZnJvbSUyMGElMjBkaWN0aW9uYXJ5JTNGJTBBJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCU3RCUwQSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwYXJncyUzQSUyME5hbWVzcGFjZSklM0ElMjAlMjMlMjBhbm5vdGF0ZSUyMCU2MGFyZ3MlNjAlMEElMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnBhdHRlcm4lMjAlM0QlMjBzZWxmLmFyZ3MucGF0dGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaGlkZGVuX3NpemUlMjAlM0QlMjBzZWxmLmFyZ3MuaGlkZGVuX3NpemUlMEElMjAlMjAlMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">from</span> argparse <span class="hljs-keyword">import</span> Namespace

<span class="hljs-keyword">class</span> <span class="hljs-title class_">VoiceCraft</span>(
   nn.Module,
   PyTorchModelHubMixin,  <span class="hljs-comment"># inherit from mixin</span>
   coders={
      Namespace : (
         <span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">vars</span>(x),  <span class="hljs-comment"># Encoder: how to convert a \`Namespace\` to a valid jsonable value?</span>
         <span class="hljs-keyword">lambda</span> data: Namespace(**data),  <span class="hljs-comment"># Decoder: how to reconstruct a \`Namespace\` from a dictionary?</span>
      )
   }
):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, args: Namespace</span>): <span class="hljs-comment"># annotate \`args\`</span>
      self.pattern = self.args.pattern
      self.hidden_size = self.args.hidden_size
      ...`,wrap:!1}}),We=new u({props:{title:"Quick comparison",local:"quick-comparison",headingTag:"h2"}}),Ee=new ha({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/integrations.md"}}),{c(){T=i("meta"),Ye=s(),Ve=i("p"),Ne=s(),M(f.$$.fragment),Re=s(),M(b.$$.fragment),Qe=s(),j=i("p"),j.innerHTML=ct,Se=s(),U=i("p"),U.textContent=dt,Xe=s(),g=i("ol"),g.innerHTML=ht,Fe=s(),I=i("p"),I.textContent=mt,Le=s(),_=i("p"),_.innerHTML=ut,ze=s(),M(C.$$.fragment),qe=s(),Z=i("p"),Z.innerHTML=yt,Pe=s(),B=i("p"),B.textContent=Tt,De=s(),M(v.$$.fragment),Ke=s(),k=i("p"),k.innerHTML=wt,Oe=s(),M(G.$$.fragment),el=s(),M(x.$$.fragment),ll=s(),W=i("p"),W.innerHTML=Jt,tl=s(),M(H.$$.fragment),al=s(),A=i("p"),A.innerHTML=ft,sl=s(),M(E.$$.fragment),nl=s(),V=i("p"),V.innerHTML=bt,il=s(),$=i("ul"),$.innerHTML=jt,ol=s(),Y=i("p"),Y.textContent=Ut,rl=s(),N=i("ul"),N.innerHTML=gt,Ml=s(),R=i("p"),R.innerHTML=It,pl=s(),M(Q.$$.fragment),cl=s(),S=i("p"),S.innerHTML=_t,dl=s(),X=i("p"),X.innerHTML=Ct,hl=s(),F=i("p"),F.innerHTML=Zt,ml=s(),L=i("ol"),L.innerHTML=Bt,ul=s(),z=i("p"),z.innerHTML=vt,yl=s(),M(q.$$.fragment),Tl=s(),P=i("p"),P.innerHTML=kt,wl=s(),M(D.$$.fragment),Jl=s(),K=i("p"),K.textContent=Gt,fl=s(),M(O.$$.fragment),bl=s(),M(ee.$$.fragment),jl=s(),le=i("p"),le.innerHTML=xt,Ul=s(),te=i("ol"),te.innerHTML=Wt,gl=s(),M(ae.$$.fragment),Il=s(),w=i("ol"),w.innerHTML=Ht,_l=s(),M(se.$$.fragment),Cl=s(),J=i("ol"),J.innerHTML=At,Zl=s(),M(ne.$$.fragment),Bl=s(),ie=i("p"),ie.textContent=Et,vl=s(),M(oe.$$.fragment),kl=s(),re=i("p"),re.innerHTML=Vt,Gl=s(),M(Me.$$.fragment),xl=s(),pe=i("p"),pe.innerHTML=$t,Wl=s(),ce=i("p"),ce.innerHTML=Yt,Hl=s(),M(de.$$.fragment),Al=s(),he=i("p"),he.innerHTML=Nt,El=s(),me=i("p"),me.innerHTML=Rt,Vl=s(),M(ue.$$.fragment),$l=s(),ye=i("p"),ye.innerHTML=Qt,Yl=s(),M(Te.$$.fragment),Nl=s(),M(we.$$.fragment),Rl=s(),Je=i("p"),Je.innerHTML=St,Ql=s(),fe=i("ol"),fe.innerHTML=Xt,Sl=s(),be=i("p"),be.textContent=Ft,Xl=s(),je=i("ul"),je.innerHTML=Lt,Fl=s(),Ue=i("p"),Ue.textContent=zt,Ll=s(),M(ge.$$.fragment),zl=s(),Ie=i("p"),Ie.innerHTML=qt,ql=s(),_e=i("p"),_e.innerHTML=Pt,Pl=s(),M(Ce.$$.fragment),Dl=s(),Ze=i("p"),Ze.innerHTML=Dt,Kl=s(),Be=i("p"),Be.innerHTML=Kt,Ol=s(),M(ve.$$.fragment),et=s(),ke=i("p"),ke.innerHTML=Ot,lt=s(),Ge=i("ol"),Ge.innerHTML=ea,tt=s(),xe=i("p"),xe.textContent=la,at=s(),M(We.$$.fragment),st=s(),He=i("p"),He.textContent=ta,nt=s(),Ae=i("table"),Ae.innerHTML=aa,it=s(),M(Ee.$$.fragment),ot=s(),$e=i("p"),this.h()},l(e){const l=pa("svelte-u9bgzb",document.head);T=o(l,"META",{name:!0,content:!0}),l.forEach(t),Ye=n(e),Ve=o(e,"P",{}),sa(Ve).forEach(t),Ne=n(e),p(f.$$.fragment,e),Re=n(e),p(b.$$.fragment,e),Qe=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-uvt37o"&&(j.innerHTML=ct),Se=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-14vdlq5"&&(U.textContent=dt),Xe=n(e),g=o(e,"OL",{"data-svelte-h":!0}),r(g)!=="svelte-1joh1ob"&&(g.innerHTML=ht),Fe=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1tx4sul"&&(I.textContent=mt),Le=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-10f3yyh"&&(_.innerHTML=ut),ze=n(e),p(C.$$.fragment,e),qe=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-r9ojoj"&&(Z.innerHTML=yt),Pe=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1g2giur"&&(B.textContent=Tt),De=n(e),p(v.$$.fragment,e),Ke=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1ssb65u"&&(k.innerHTML=wt),Oe=n(e),p(G.$$.fragment,e),el=n(e),p(x.$$.fragment,e),ll=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-7bmo7d"&&(W.innerHTML=Jt),tl=n(e),p(H.$$.fragment,e),al=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-15vgu12"&&(A.innerHTML=ft),sl=n(e),p(E.$$.fragment,e),nl=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-tzwehq"&&(V.innerHTML=bt),il=n(e),$=o(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-1e4on1q"&&($.innerHTML=jt),ol=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-3m9y73"&&(Y.textContent=Ut),rl=n(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-30swpt"&&(N.innerHTML=gt),Ml=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-p8rs76"&&(R.innerHTML=It),pl=n(e),p(Q.$$.fragment,e),cl=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1uvlinw"&&(S.innerHTML=_t),dl=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-qqd3b3"&&(X.innerHTML=Ct),hl=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1e60xo5"&&(F.innerHTML=Zt),ml=n(e),L=o(e,"OL",{"data-svelte-h":!0}),r(L)!=="svelte-72ewvw"&&(L.innerHTML=Bt),ul=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1xuhak5"&&(z.innerHTML=vt),yl=n(e),p(q.$$.fragment,e),Tl=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-ua16f3"&&(P.innerHTML=kt),wl=n(e),p(D.$$.fragment,e),Jl=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-l2ktl8"&&(K.textContent=Gt),fl=n(e),p(O.$$.fragment,e),bl=n(e),p(ee.$$.fragment,e),jl=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-l2iz9k"&&(le.innerHTML=xt),Ul=n(e),te=o(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-1a9vqht"&&(te.innerHTML=Wt),gl=n(e),p(ae.$$.fragment,e),Il=n(e),w=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(w)!=="svelte-mclxy5"&&(w.innerHTML=Ht),_l=n(e),p(se.$$.fragment,e),Cl=n(e),J=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(J)!=="svelte-1vfuaub"&&(J.innerHTML=At),Zl=n(e),p(ne.$$.fragment,e),Bl=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-zuw9zy"&&(ie.textContent=Et),vl=n(e),p(oe.$$.fragment,e),kl=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-lpjruw"&&(re.innerHTML=Vt),Gl=n(e),p(Me.$$.fragment,e),xl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-r0v63u"&&(pe.innerHTML=$t),Wl=n(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-38ruh8"&&(ce.innerHTML=Yt),Hl=n(e),p(de.$$.fragment,e),Al=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-70iys4"&&(he.innerHTML=Nt),El=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-zhkaso"&&(me.innerHTML=Rt),Vl=n(e),p(ue.$$.fragment,e),$l=n(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1xgyqxt"&&(ye.innerHTML=Qt),Yl=n(e),p(Te.$$.fragment,e),Nl=n(e),p(we.$$.fragment,e),Rl=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-13gwv8k"&&(Je.innerHTML=St),Ql=n(e),fe=o(e,"OL",{"data-svelte-h":!0}),r(fe)!=="svelte-uqe2yy"&&(fe.innerHTML=Xt),Sl=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-gl8lj"&&(be.textContent=Ft),Xl=n(e),je=o(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-10x9zjy"&&(je.innerHTML=Lt),Fl=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-11lpom8"&&(Ue.textContent=zt),Ll=n(e),p(ge.$$.fragment,e),zl=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1jpezi8"&&(Ie.innerHTML=qt),ql=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-15vpqms"&&(_e.innerHTML=Pt),Pl=n(e),p(Ce.$$.fragment,e),Dl=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-n23cfp"&&(Ze.innerHTML=Dt),Kl=n(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1fs7jtp"&&(Be.innerHTML=Kt),Ol=n(e),p(ve.$$.fragment,e),et=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-unlgl7"&&(ke.innerHTML=Ot),lt=n(e),Ge=o(e,"OL",{"data-svelte-h":!0}),r(Ge)!=="svelte-20f48e"&&(Ge.innerHTML=ea),tt=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-103pztm"&&(xe.textContent=la),at=n(e),p(We.$$.fragment,e),st=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1qi11kl"&&(He.textContent=ta),nt=n(e),Ae=o(e,"TABLE",{"data-svelte-h":!0}),r(Ae)!=="svelte-17o2ar3"&&(Ae.innerHTML=aa),it=n(e),p(Ee.$$.fragment,e),ot=n(e),$e=o(e,"P",{}),sa($e).forEach(t),this.h()},h(){Mt(T,"name","hf:doc:metadata"),Mt(T,"content",ua),Mt(w,"start","2"),Mt(J,"start","3")},m(e,l){ca(document.head,T),a(e,Ye,l),a(e,Ve,l),a(e,Ne,l),c(f,e,l),a(e,Re,l),c(b,e,l),a(e,Qe,l),a(e,j,l),a(e,Se,l),a(e,U,l),a(e,Xe,l),a(e,g,l),a(e,Fe,l),a(e,I,l),a(e,Le,l),a(e,_,l),a(e,ze,l),c(C,e,l),a(e,qe,l),a(e,Z,l),a(e,Pe,l),a(e,B,l),a(e,De,l),c(v,e,l),a(e,Ke,l),a(e,k,l),a(e,Oe,l),c(G,e,l),a(e,el,l),c(x,e,l),a(e,ll,l),a(e,W,l),a(e,tl,l),c(H,e,l),a(e,al,l),a(e,A,l),a(e,sl,l),c(E,e,l),a(e,nl,l),a(e,V,l),a(e,il,l),a(e,$,l),a(e,ol,l),a(e,Y,l),a(e,rl,l),a(e,N,l),a(e,Ml,l),a(e,R,l),a(e,pl,l),c(Q,e,l),a(e,cl,l),a(e,S,l),a(e,dl,l),a(e,X,l),a(e,hl,l),a(e,F,l),a(e,ml,l),a(e,L,l),a(e,ul,l),a(e,z,l),a(e,yl,l),c(q,e,l),a(e,Tl,l),a(e,P,l),a(e,wl,l),c(D,e,l),a(e,Jl,l),a(e,K,l),a(e,fl,l),c(O,e,l),a(e,bl,l),c(ee,e,l),a(e,jl,l),a(e,le,l),a(e,Ul,l),a(e,te,l),a(e,gl,l),c(ae,e,l),a(e,Il,l),a(e,w,l),a(e,_l,l),c(se,e,l),a(e,Cl,l),a(e,J,l),a(e,Zl,l),c(ne,e,l),a(e,Bl,l),a(e,ie,l),a(e,vl,l),c(oe,e,l),a(e,kl,l),a(e,re,l),a(e,Gl,l),c(Me,e,l),a(e,xl,l),a(e,pe,l),a(e,Wl,l),a(e,ce,l),a(e,Hl,l),c(de,e,l),a(e,Al,l),a(e,he,l),a(e,El,l),a(e,me,l),a(e,Vl,l),c(ue,e,l),a(e,$l,l),a(e,ye,l),a(e,Yl,l),c(Te,e,l),a(e,Nl,l),c(we,e,l),a(e,Rl,l),a(e,Je,l),a(e,Ql,l),a(e,fe,l),a(e,Sl,l),a(e,be,l),a(e,Xl,l),a(e,je,l),a(e,Fl,l),a(e,Ue,l),a(e,Ll,l),c(ge,e,l),a(e,zl,l),a(e,Ie,l),a(e,ql,l),a(e,_e,l),a(e,Pl,l),c(Ce,e,l),a(e,Dl,l),a(e,Ze,l),a(e,Kl,l),a(e,Be,l),a(e,Ol,l),c(ve,e,l),a(e,et,l),a(e,ke,l),a(e,lt,l),a(e,Ge,l),a(e,tt,l),a(e,xe,l),a(e,at,l),c(We,e,l),a(e,st,l),a(e,He,l),a(e,nt,l),a(e,Ae,l),a(e,it,l),c(Ee,e,l),a(e,ot,l),a(e,$e,l),rt=!0},p:ia,i(e){rt||(d(f.$$.fragment,e),d(b.$$.fragment,e),d(C.$$.fragment,e),d(v.$$.fragment,e),d(G.$$.fragment,e),d(x.$$.fragment,e),d(H.$$.fragment,e),d(E.$$.fragment,e),d(Q.$$.fragment,e),d(q.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(Me.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(Te.$$.fragment,e),d(we.$$.fragment,e),d(ge.$$.fragment,e),d(Ce.$$.fragment,e),d(ve.$$.fragment,e),d(We.$$.fragment,e),d(Ee.$$.fragment,e),rt=!0)},o(e){h(f.$$.fragment,e),h(b.$$.fragment,e),h(C.$$.fragment,e),h(v.$$.fragment,e),h(G.$$.fragment,e),h(x.$$.fragment,e),h(H.$$.fragment,e),h(E.$$.fragment,e),h(Q.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(Me.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(ge.$$.fragment,e),h(Ce.$$.fragment,e),h(ve.$$.fragment,e),h(We.$$.fragment,e),h(Ee.$$.fragment,e),rt=!1},d(e){e&&(t(Ye),t(Ve),t(Ne),t(Re),t(Qe),t(j),t(Se),t(U),t(Xe),t(g),t(Fe),t(I),t(Le),t(_),t(ze),t(qe),t(Z),t(Pe),t(B),t(De),t(Ke),t(k),t(Oe),t(el),t(ll),t(W),t(tl),t(al),t(A),t(sl),t(nl),t(V),t(il),t($),t(ol),t(Y),t(rl),t(N),t(Ml),t(R),t(pl),t(cl),t(S),t(dl),t(X),t(hl),t(F),t(ml),t(L),t(ul),t(z),t(yl),t(Tl),t(P),t(wl),t(Jl),t(K),t(fl),t(bl),t(jl),t(le),t(Ul),t(te),t(gl),t(Il),t(w),t(_l),t(Cl),t(J),t(Zl),t(Bl),t(ie),t(vl),t(kl),t(re),t(Gl),t(xl),t(pe),t(Wl),t(ce),t(Hl),t(Al),t(he),t(El),t(me),t(Vl),t($l),t(ye),t(Yl),t(Nl),t(Rl),t(Je),t(Ql),t(fe),t(Sl),t(be),t(Xl),t(je),t(Fl),t(Ue),t(Ll),t(zl),t(Ie),t(ql),t(_e),t(Pl),t(Dl),t(Ze),t(Kl),t(Be),t(Ol),t(et),t(ke),t(lt),t(Ge),t(tt),t(xe),t(at),t(st),t(He),t(nt),t(Ae),t(it),t(ot),t($e)),t(T),m(f,e),m(b,e),m(C,e),m(v,e),m(G,e),m(x,e),m(H,e),m(E,e),m(Q,e),m(q,e),m(D,e),m(O,e),m(ee,e),m(ae,e),m(se,e),m(ne,e),m(oe,e),m(Me,e),m(de,e),m(ue,e),m(Te,e),m(we,e),m(ge,e),m(Ce,e),m(ve,e),m(We,e),m(Ee,e)}}}const ua='{"title":"Integrate any ML framework with the Hub","local":"integrate-any-ml-framework-with-the-hub","sections":[{"title":"A flexible approach: helpers","local":"a-flexible-approach-helpers","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"A more complex approach: class inheritance","local":"a-more-complex-approach-class-inheritance","sections":[{"title":"A concrete example: PyTorch","local":"a-concrete-example-pytorch","sections":[{"title":"How to use it?","local":"how-to-use-it","sections":[],"depth":4},{"title":"Implementation","local":"implementation","sections":[],"depth":4}],"depth":3},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Model card","local":"model-card","sections":[],"depth":4},{"title":"Config","local":"config","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Quick comparison","local":"quick-comparison","sections":[],"depth":2}],"depth":1}';function ya(pt){return oa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ja extends ra{constructor(T){super(),Ma(this,T,ya,ma,na,{})}}export{ja as component};
